%{
typedef struct {
	PyObject_HEAD
	GdkImlibImage *obj;
} PyGdkImlibImage_Object;

staticforward PyTypeObject PyGdkImlibImage_Type;
#define PyGdkImlibImage_Check(ob) ((ob)->ob_type == &PyGdkImlibImage_Type)
#define PyGdkImlibImage_Get(ob) (((PyGdkImlibImage_Object *)(ob))->obj)

static PyObject *
PyGdkImlibImage_New(GdkImlibImage *obj) {
  PyGdkImlibImage_Object *self;

  self = (PyGdkImlibImage_Object *)PyObject_NEW(PyGdkImlibImage_Object,
						&PyGdkImlibImage_Type);
  if (self == NULL)
    return NULL;
  self->obj = obj;
  return (PyObject *)self;
}

static void
PyGdkImlibImage_Dealloc(PyGdkImlibImage_Object *self) {
  gdk_imlib_destroy_image(self->obj); 
  PyMem_DEL(self);
}

static int
PyGdkImlibImage_Compare(PyGdkImlibImage_Object *self,
			PyGdkImlibImage_Object *v) {
  if (self->obj == v->obj) return 0;
  if (self->obj > v->obj) return -1;
  return 1;
}

static PyTypeObject PyGdkImlibImage_Type = {
  PyObject_HEAD_INIT(&PyType_Type)
  0,
  "GdkImlibImage",
  sizeof(PyGdkImlibImage_Object),
  0,
  (destructor)PyGdkImlibImage_Dealloc,
  (printfunc)0,
  (getattrfunc)0,
  (setattrfunc)0,
  (cmpfunc)PyGdkImlibImage_Compare,
  (reprfunc)0,
  0,
  0,
  0,
  (hashfunc)0,
  (ternaryfunc)0,
  (reprfunc)0,
  0L,0L,0L,0L,
  NULL
};

%}

%typemap(python,in) GdkImlibImage * {
  if (PyGdkImlibImage_Check($source))
    $target = PyGdkImlibImage_Get($source);
  else {
    PyErr_SetString(PyExc_TypeError, "object not an Imlib image");
    return NULL;
  }
}
%typemap(python,out) GdkImlibImage * {
  if ($source == NULL) {
    PyErr_SetString(PyExc_RuntimeError, "return value is NULL");
    return NULL;
  }
  $target = PyGdkImlibImage_New($source);
}

%typemap(python,in) GdkImlibColor * {
  if (!PyTuple_Check($source)) {
    PyErr_SetString(PyExc_TypeError, "not a tuple");
    return NULL;
  }
  $target = malloc(sizeof(GdkImlibColor));
  if (!PyArg_ParseTuple($source, "iii", &($target->r), &($target->g), &($target->b))) {
    free($target);
    return NULL;
  }
}
%typemap(python,freearg) GdkImlibColor * {
  free($source);
}

%typemap(python,ignore) GdkImlibColor *ocolor {
  $target = malloc(sizeof(GdkImlibColor));
}
%typemap(python,argout) GdkImlibColor *ocolor {
  $target = Py_BuildValue("(iii)", $source->r, $source->g, $source->b);
}
%typemap(python,freearg) GdkImlibColor *ocolor {
  free($source);
}

%typemap(python,in) GdkImlibBorder * {
  if (!PyTuple_Check($source)) {
    PyErr_SetString(PyExc_TypeError, "not a tuple");
    return NULL;
  }
  $target = malloc(sizeof(GdkImlibBorder));
  if (!PyArg_ParseTuple($source, "iiii", &($target->left), &($target->right),
			&($target->top), &($target->bottom))) {
    free($target);
    return NULL;
  }
}
%typemap(python,freearg) GdkImlibBorder * {
  free($source);
}

%typemap(python,ignore) GdkImlibBorder *oborder {
  $target = malloc(sizeof(GdkImlibColor));
}
%typemap(python,argout) GdkImlibBorder *oborder {
  $target = Py_BuildValue("(iii)", $source->left, $source->right,
			  $source->top, $source->bottom);
}
%typemap(python,freearg) GdkImlibBorder *oborder {
  free($source);
}

%typemap(python,in) GdkImlibColorModifier * {
  if (!PyTuple_Check($source)) {
    PyErr_SetString(PyExc_TypeError, "not a tuple");
    return NULL;
  }
  $target = malloc(sizeof(GdkImlibColorModifier));
  if (!PyArg_ParseTuple($source, "iii", &($target->gamma),
			&($target->brightness), &($target->contrast))) {
    free($target);
    return NULL;
  }
}
%typemap(python,freearg) GdkImlibColorModifier * {
  free($source);
}

%typemap(python,ignore) GdkImlibColorModifier *omod {
  $target = malloc(sizeof(GdkImlibColorModifier));
}
%typemap(python,argout) GdkImlibColorModifier *omod {
  $target = Py_BuildValue("(iii)", $source->gamma, $source->brightness,
			  $source->contrast);
}
%typemap(python,freearg) GdkImlibColorModifier *omod {
  free($source);
}

%typemap(python,in) char *mod {
  int i;
  PyObject *item;
  if (!PySequence_Check($source) || PySequence_Length($source) < 256) {
    PyErr_SetString(PyExc_TypeError, "not a sequence");
    return NULL;
  }
  $target = malloc(256 * sizeof(char));
  for (i = 0; i < 256; i++) {
    item = PySequence_GetItem($source, i);
    if (!PyInt_Check(item)) {
      PyErr_SetString(PyExc_TypeError, "item of sequence not an integer");
      free($target);
      return NULL;
    }
    $target[i] = PyInt_AsLong(item);
  }
}
%typemap(python,freearg) char *mod {
  free($source);
}

%typemap(python,ignore) char *omod {
  $target = malloc(256 * sizeof(char));
}
%typemap(python,argout) char *omod {
  int i;
  $target = PyList_New(256);
  for (i = 0; i < 256; i++)
    PyList_SetItem($target, i, omod[i]);
}
%typemap(python,freearg) char *omod {
  free($source);
}


