# signal handling for Python GTK

%{

static
void PyGtk_SignalMarshal(GtkObject *object, /*gpointer*/ PyObject *func,
                       int nparams, GtkArg *args, GtkType *arg_types,
                                                 GtkType return_type) {
    PyObject *arg_list, *params, *ret;
    int i;

    ret = PyTuple_New(1);
    PyTuple_SetItem(ret, 0, PyGtk_New(object));
    arg_list = GtkArgs_AsTuple(nparams, args);
    params = PySequence_Concat(ret, arg_list);
    Py_DECREF(ret);
    Py_DECREF(arg_list);
    ret = PyObject_CallObject(func, params);
    Py_DECREF(params);

    if (ret == NULL) {
        PyErr_Print();
	PyErr_Clear();
	return;
    }
    GtkArg_FromPyObject(&args[nparams], ret);
    Py_DECREF(ret);
}

static
void PyGtk_SignalDestroy(/*gpointer*/ PyObject *func) {
    Py_DECREF(func);
}

static PyObject *gtk__signal_connect(PyObject *self, PyObject *args) {
    PyGtk_Object *obj;
    char *name;
    PyObject *func;
    int signum;

    if (!PyArg_ParseTuple(args, "O!sO:gtk_signal_connect", &PyGtk_Type, &obj,
                    &name, &func))
        return NULL;
    if (!PyCallable_Check(func)) {
        PyErr_SetString(PyExc_TypeError, "third argument must be callable");
        return NULL;
    }
    Py_INCREF(func);
    signum = gtk_signal_connect(PyGtk_Get(obj), name, NULL, func);
    return PyInt_FromLong(signum);
}

static PyObject *gtk__signal_connect_after(PyObject *self, PyObject *args) {
    PyGtk_Object *obj;
    char *name;
    PyObject *func;
    int signum;

    if (!PyArg_ParseTuple(args, "O!sO:gtk_signal_connect_after",
                    &PyGtk_Type, &obj, &name, &func))
        return NULL;
    if (!PyCallable_Check(func)) {
        PyErr_SetString(PyExc_TypeError, "third argument must be callable");
        return NULL;
    }
    Py_INCREF(func);
    signum = gtk_signal_connect_after(PyGtk_Get(obj), name, NULL, func);
    return PyInt_FromLong(signum);
}

%}

// I haven't included gtk_signal_connect_object, since it is difficult
// to implement in C.  Here is a sample implementation in Python:
//
//  def gtk_signal_connect_object(obj, name, func, cobj):
//    class sigfunc:
//      def __init__(self, obj, func): self.obj=obj ; self.func = func
//      def __call__(self, obj, *args): apply(self.func, (self.obj,)+args)
//    return gtk_signal_connect(obj, name, sigfunc(cobj, func))
//
%native(gtk_signal_connect) PyObject *gtk__signal_connect(
        PyObject *self, PyObject *args);
%native(gtk_signal_connect_after) PyObject *gtk__signal_connect_after(
        PyObject *self, PyObject *args);

void gtk_signal_disconnect(GtkObject *o, int signum);
void gtk_signal_disconnect_by_data(GtkObject *o, PyObject *func);
void gtk_signal_handler_block(GtkObject *o, int signum);
void gtk_signal_handler_block_by_data(GtkObject *o, PyObject *func);
void gtk_signal_handler_unblock(GtkObject *o, int signum);
void gtk_signal_handler_unblock_by_data(GtkObject *o, PyObject *func);
void gtk_signal_handlers_destroy(GtkObject *o);

void gtk_signal_emit_stop_by_name(GtkObject *o, char *name);

%{
static PyObject *gtk__signal_emitv_by_name(PyObject *self, PyObject *args) {
  guint signal_id, i, nparams;
  GtkSignalQuery *query;
  GtkArg *params;
  PyObject *obj, *py_params, *item;
  gchar *name, buf[sizeof(GtkArg)]; /* large enough to hold any return value */

  if (!PyArg_ParseTuple(args, "O!sO:gtk_signal_emitv_by_name", &PyGtk_Type,
			&obj, &name, &py_params))
    return NULL;
  if (!PySequence_Check(py_params)) {
    PyErr_SetString(PyExc_TypeError, "third argument not a sequence");
    return NULL;
  }

  signal_id = gtk_signal_lookup(name, GTK_OBJECT_TYPE(PyGtk_Get(obj)));
  if (signal_id <= 0) {
    PyErr_SetString(PyExc_KeyError, "can't find signal in classes ancestry");
    return NULL;
  }
  query = gtk_signal_query(signal_id);
  params = g_new(GtkArg, query->nparams + 1);
  nparams = query->nparams;
  for (i = 0; i < nparams; i++) {
    params[i].type = query->params[i];
    params[i].name = NULL;
  }
  params[i].type = query->return_val;
  params[i].name = NULL;
  GTK_RETLOC_POINTER(params[i]) = buf; /* buffer to hold return value */
  g_free(query);
  if (GtkArgs_FromSequence(params, query->nparams, py_params)) {
    g_free(params);
    return NULL;
  }
  gtk_signal_emitv(PyGtk_Get(obj), signal_id, params);
  obj = GtkRet_AsPyObject(&params[nparams]);
  g_free(params);
  if (obj == NULL) { Py_INCREF(Py_None); obj = Py_None; }
  return obj;
}
%}
%native(gtk_signal_emitv_by_name) PyObject *gtk__signal_emitv_by_name(
					PyObject *self, PyObject *args);
