# typemaps for various Gtk object types <-> Python equivalents

%include obj_typemap.i

%typemap(python,in) GtkRequisition * {
        if (!PyTuple_Check($source)) {
            PyErr_SetString(PyExc_TypeError, "argument not a tuple");
            return NULL;
        }
        $target = malloc(sizeof(GtkRequisition));
        if (!PyArg_ParseTuple($source, "ii", &($target->width), &($target->height))) {
            free($target);
            return NULL;
        }
    }

%typemap(python,freearg) GtkRequisition * {
        free($source);
    }

%typemap(python,in) GtkAllocation * {
        if (!PyTuple_Check($source)) {
            PyErr_SetString(PyExc_TypeError, "not a tuple");
            return NULL;
        }
        $target = malloc(sizeof(GtkAllocation));
        if (!PyArg_ParseTuple($source, "iiii", &($target->x), &($target->y), &($target->width), &($target->height))) {
            free($target);
            return NULL;
        }
    }

%typemap(python,freearg) GtkAllocation * {
        free($source);
    }

%typemap(python,in) gdouble *color {
        if (!PyTuple_Check($source)) {
            PyErr_SetString(PyExc_TypeError, "not a tuple");
            return NULL;
        }
        $target = malloc(3 * sizeof(gdouble));
	if (!PyArg_ParseTuple($source, "ddd", &($target[0]), &($target[1]), &($target[2]))) {
            free($target);
            return NULL;
        }
    }

%typemap(python,freearg) gdouble *color {
        free($source);
    }

%typemap(python,ignore) gdouble *ocolor {
        $target = malloc(3 * sizeof(gdouble));
    }

%typemap(python,argout) gdouble *ocolor {
        $target = Py_BuildValue("(ddd)", $source[0], $source[1], $source[2]);
    }

%typemap(python,freearg) gdouble *ocolor {
        free($source);
    }

%typemap(python,ignore) char ** outstr {
        *$target = NULL;
    }
%typemap(python,argout) char **outstr {
        $target = PyString_FromString(*$source);
    }

// This is strictly a glib type, but it is usually of GtkObjects...
%typemap(python,out) GList * {
	GList *t;
        $target = PyList_New(0);
        for (t = $source; t != NULL; t = t->next)
            PyList_Append($target, PyGtk_New(GTK_OBJECT(t->data)));
    }

%typemap(python,in) GList * {
        int len, i;
        PyObject *item;
        if (!PyList_Check($source)) {
            PyErr_SetString(PyExc_TypeError, "argument not a list");
            return NULL;
        }
        $target = NULL;
        len = PyList_Size($source);
        for (i = 0; i < len; i++) {
            item = PyList_GetItem($source, i);
            if (!PyGtk_Check(item)) {
                PyErr_SetString(PyExc_TypeError, "item not a GtkObject");
                g_list_free($target);
                return NULL;
            }
            $target = g_list_append($target, (gpointer)PyGtk_Get(item));
        }
    }

%typemap(python,in) PyObject * {
  $target = $source;
}
%typemap(python,out) PyObject * {
  Py_INCREF($source);
  $target = $source;
}
