# Here is code that implements gtk_object_new, gtk_object_set

%{

static void PyGtk_object_set(GtkObject *o, PyObject *dict) {
    int i = 0;
    PyObject *key, *item;
    char *name, *err;
    GtkType obtype;
    GtkArg arg;
    GtkArgInfo *info;
 
    obtype = GTK_OBJECT_TYPE(o);

    //    for (i=0; i < len; i++) {
    while (PyDict_Next(dict, &i, &key, &item)) {
        if (!PyString_Check(key)) {
            fprintf(stderr, "Key not a string\n");
            continue;
        }
        name = PyString_AsString(key);
	err = gtk_object_arg_get_info(obtype, name, &info);
        if (info == NULL) {
            Py_DECREF(item);
            fprintf(stderr, err);
	    g_free(err);
            continue;
        }

        arg.type = info->type;
        arg.name = info->name;
	if (GtkArg_FromPyObject(&arg, item)) {
	  fprintf(stderr, "%s: expected %s, %s found\n", name,
		  gtk_type_name(arg.type), item->ob_type->tp_name);
	  continue;
	}
        gtk_object_setv(o, 1, &arg);
    }
}

static PyObject *gtk__object_set(PyObject *self, PyObject *args) {
    PyGtk_Object *obj;
    PyObject *dict;

    if (!PyArg_ParseTuple(args, "O!O!:gtk_object_set", &PyGtk_Type, &obj,
                  &PyDict_Type, &dict))
        return NULL;
    PyGtk_object_set(PyGtk_Get(obj), dict);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *gtk__object_new(PyObject *self, PyObject *args) {
    char *name;
    int type;
    PyObject *dict;
    GtkObject *obj;

    PyGtk_init_types();
    if (PyArg_ParseTuple(args, "sO!:gtk_object_new", &name, &PyDict_Type,
                  &dict))
        type = gtk_type_from_name(name);
    else {
        PyErr_Clear();
        if (!PyArg_ParseTuple(args, "iO!:gtk_object_new", &type, &PyDict_Type,
                      &dict))
            return NULL;
        name = gtk_type_name(type);
    }
    obj = gtk_object_newv(type, 0, NULL);
    PyGtk_object_set(obj, dict);
    return PyGtk_New(obj);
}

static PyObject *gtk__object_get(PyObject *self, PyObject *args) {
    PyGtk_Object *o;
    char *name;
    GtkArg garg;
    PyObject *ret;

    if (!PyArg_ParseTuple(args, "O!s:gtk_object_get", &PyGtk_Type, &o, &name))
        return NULL;
    garg.name = name;
    gtk_object_getv(PyGtk_Get(o), 1, &garg);

    if (garg.type == GTK_TYPE_INVALID) {
        PyErr_SetString(PyExc_AttributeError, "invalid property");
        return NULL;
    }
    ret = GtkArg_AsPyObject(&garg);
    if (ret == NULL) {
      PyErr_SetString(PyExc_TypeError, "couldn't translate type");
      return NULL;
    }
    return ret;
}
%}

%native(gtk_object_set) PyObject *gtk__object_set(PyObject *self,
                                                  PyObject *args);
%native(gtk_object_new) PyObject *gtk__object_new(PyObject *self,
                                                  PyObject *args);
%native(gtk_object_get) PyObject *gtk__object_get(PyObject *self,
                                                  PyObject *args);







