#!/bin/bash

# Copyright (C) 2016, 2017  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C parser:number5
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L number5.old <(echo \
'$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }
$ json() { json0 --literal-value --multi-obj -b 1 "$@"; }
$ echo -00|json
-0
0
$ echo -01|json
-0
1
$ echo -02|json
-0
2
$ echo -03|json
-0
3
$ echo -04|json
-0
4
$ echo -05|json
-0
5
$ echo -06|json
-0
6
$ echo -07|json
-0
7
$ echo -08|json
-0
8
$ echo -09|json
-0
9'
) -L number5.new <(
echo '$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'
json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; } 2>&1 ||
echo 'command failed: json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'

echo '$ json() { json0 --literal-value --multi-obj -b 1 "$@"; }'
json() { json0 --literal-value --multi-obj -b 1 "$@"; } 2>&1 ||
echo 'command failed: json() { json0 --literal-value --multi-obj -b 1 "$@"; }'

echo '$ echo -00|json'
echo -00|json 2>&1 ||
echo 'command failed: echo -00|json'

echo '$ echo -01|json'
echo -01|json 2>&1 ||
echo 'command failed: echo -01|json'

echo '$ echo -02|json'
echo -02|json 2>&1 ||
echo 'command failed: echo -02|json'

echo '$ echo -03|json'
echo -03|json 2>&1 ||
echo 'command failed: echo -03|json'

echo '$ echo -04|json'
echo -04|json 2>&1 ||
echo 'command failed: echo -04|json'

echo '$ echo -05|json'
echo -05|json 2>&1 ||
echo 'command failed: echo -05|json'

echo '$ echo -06|json'
echo -06|json 2>&1 ||
echo 'command failed: echo -06|json'

echo '$ echo -07|json'
echo -07|json 2>&1 ||
echo 'command failed: echo -07|json'

echo '$ echo -08|json'
echo -08|json 2>&1 ||
echo 'command failed: echo -08|json'

echo '$ echo -09|json'
echo -09|json 2>&1 ||
echo 'command failed: echo -09|json'
)

