#!/bin/bash

# Copyright (C) 2016, 2017  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker-list:list-closed-array-basic-closed-array-plain-val-array-basic-basic
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L list-closed-array-basic-closed-array-plain-val-array-basic-basic.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[{}],null]'\''
json: error: <text>:1:81: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[{}],null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[{}],false]'\''
json: error: <text>:1:81: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[{}],false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[{}],true]'\''
json: error: <text>:1:81: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[{}],true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[{}],123]'\''
json: error: <text>:1:81: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[{}],123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[{}],456]'\''
json: error: <text>:1:81: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[{}],456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[{}],"foo"]'\''
json: error: <text>:1:81: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[{}],"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[{}],"bar"]'\''
json: error: <text>:1:81: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[{}],"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[{}],{}]'\''
json: error: <text>:1:81: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[{}],{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[{}],[]]'\''
json: error: <text>:1:81: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[{}],[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[{}],null]'\''
json: error: <text>:1:81: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[{}],null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[{}],false]'\''
json: error: <text>:1:81: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[{}],false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[{}],true]'\''
json: error: <text>:1:81: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[{}],true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[{}],123]'\''
json: error: <text>:1:81: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[{}],123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[{}],456]'\''
json: error: <text>:1:81: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[{}],456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[{}],"foo"]'\''
json: error: <text>:1:81: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[{}],"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[{}],"bar"]'\''
json: error: <text>:1:81: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[{}],"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[{}],{}]'\''
json: error: <text>:1:81: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[{}],{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[{}],[]]'\''
json: error: <text>:1:81: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[{}],[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[{}],null]'\''
json: error: <text>:1:81: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[{}],null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[{}],false]'\''
json: error: <text>:1:81: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[{}],false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[{}],true]'\''
json: error: <text>:1:81: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[{}],true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[{}],123]'\''
json: error: <text>:1:81: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[{}],123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[{}],456]'\''
json: error: <text>:1:81: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[{}],456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[{}],"foo"]'\''
json: error: <text>:1:81: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[{}],"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[{}],"bar"]'\''
json: error: <text>:1:81: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[{}],"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[{}],{}]'\''
json: error: <text>:1:81: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[{}],{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[{}],[]]'\''
json: error: <text>:1:81: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[{}],[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[{}],null]'\''
json: error: <text>:1:81: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[{}],null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[{}],false]'\''
json: error: <text>:1:81: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[{}],false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[{}],true]'\''
json: error: <text>:1:81: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[{}],true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[{}],123]'\''
json: error: <text>:1:81: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[{}],123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[{}],456]'\''
json: error: <text>:1:81: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[{}],456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[{}],"foo"]'\''
json: error: <text>:1:81: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[{}],"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[{}],"bar"]'\''
json: error: <text>:1:81: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[{}],"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[{}],{}]'\''
json: error: <text>:1:81: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[{}],{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[{}],[]]'\''
json: error: <text>:1:81: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[{}],[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[{}],null]'\''
json: error: <text>:1:81: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[{}],null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[{}],false]'\''
json: error: <text>:1:81: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[{}],false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[{}],true]'\''
json: error: <text>:1:81: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[{}],true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[{}],123]'\''
json: error: <text>:1:81: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[{}],123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[{}],456]'\''
json: error: <text>:1:81: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[{}],456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[{}],"foo"]'\''
json: error: <text>:1:81: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[{}],"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[{}],"bar"]'\''
json: error: <text>:1:81: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[{}],"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[{}],{}]'\''
json: error: <text>:1:81: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[{}],{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[{}],[]]'\''
json: error: <text>:1:81: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[{}],[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[null,null]'\''
json: error: <text>:1:81: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[null,false]'\''
json: error: <text>:1:81: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[null,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[null,true]'\''
json: error: <text>:1:81: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[null,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[null,123]'\''
json: error: <text>:1:81: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[null,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[null,456]'\''
json: error: <text>:1:81: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[null,456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[null,"foo"]'\''
json: error: <text>:1:81: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[null,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[null,"bar"]'\''
json: error: <text>:1:81: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[null,"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[null,{}]'\''
json: error: <text>:1:81: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[null,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[null,[]]'\''
json: error: <text>:1:81: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[null,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,null]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[null,false]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,false]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[null,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[null,true]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,true]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[null,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[null,123]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,123]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[null,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[null,456]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,456]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[null,456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[null,"foo"]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,"foo"]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[null,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[null,"bar"]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,"bar"]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[null,"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[null,{}]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,{}]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[null,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[null,[]]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,[]]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[null,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,null]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[null,false]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,false]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[null,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[null,true]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,true]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[null,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[null,123]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,123]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[null,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[null,456]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,456]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[null,456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[null,"foo"]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,"foo"]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[null,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[null,"bar"]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,"bar"]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[null,"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[null,{}]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,{}]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[null,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[null,[]]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,[]]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[null,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,null]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[null,false]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,false]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[null,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[null,true]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,true]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[null,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[null,123]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,123]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[null,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[null,456]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,456]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[null,456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[null,"foo"]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,"foo"]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[null,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[null,"bar"]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,"bar"]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[null,"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[null,{}]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,{}]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[null,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[null,[]]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,[]]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[null,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,null]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[null,false]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,false]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[null,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[null,true]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,true]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[null,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[null,123]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,123]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[null,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[null,456]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,456]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[null,456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[null,"foo"]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,"foo"]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[null,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[null,"bar"]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,"bar"]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[null,"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[null,{}]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,{}]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[null,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[null,[]]'\''
json: error: <stdin>:1:6: type check error: too many arguments
json: error: <stdin>:1:6: [null,[]]
json: error: <stdin>:1:6:      ^
[null
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[null,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[false,null]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: [false,null]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[false,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[false,false]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: [false,false]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[false,true]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: [false,true]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[false,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[false,123]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: [false,123]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[false,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[false,456]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: [false,456]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[false,456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[false,"foo"]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: [false,"foo"]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[false,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[false,"bar"]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: [false,"bar"]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[false,"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[false,{}]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: [false,{}]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[false,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[false,[]]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: [false,[]]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[false,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[false,null]'\''
json: error: <text>:1:84: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[false,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[false,false]'\''
json: error: <text>:1:84: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[false,true]'\''
json: error: <text>:1:84: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[false,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[false,123]'\''
json: error: <text>:1:84: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[false,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[false,456]'\''
json: error: <text>:1:84: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[false,456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[false,"foo"]'\''
json: error: <text>:1:84: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[false,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[false,"bar"]'\''
json: error: <text>:1:84: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[false,"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[false,{}]'\''
json: error: <text>:1:84: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[false,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[false,[]]'\''
json: error: <text>:1:84: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[false,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[false,null]'\''
json: error: <text>:1:84: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[false,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[false,false]'\''
json: error: <text>:1:84: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[false,true]'\''
json: error: <text>:1:84: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[false,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[false,123]'\''
json: error: <text>:1:84: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[false,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[false,456]'\''
json: error: <text>:1:84: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[false,456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[false,"foo"]'\''
json: error: <text>:1:84: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[false,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[false,"bar"]'\''
json: error: <text>:1:84: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[false,"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[false,{}]'\''
json: error: <text>:1:84: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[false,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[false,[]]'\''
json: error: <text>:1:84: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[false,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[false,null]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: [false,null]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[false,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[false,false]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: [false,false]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[false,true]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: [false,true]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[false,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[false,123]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: [false,123]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[false,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[false,456]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: [false,456]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[false,456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[false,"foo"]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: [false,"foo"]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[false,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[false,"bar"]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: [false,"bar"]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[false,"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[false,{}]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: [false,{}]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[false,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[false,[]]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: [false,[]]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[false,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[false,null]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: [false,null]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[false,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[false,false]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: [false,false]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[false,true]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: [false,true]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[false,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[false,123]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: [false,123]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[false,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[false,456]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: [false,456]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[false,456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[false,"foo"]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: [false,"foo"]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[false,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[false,"bar"]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: [false,"bar"]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[false,"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[false,{}]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: [false,{}]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[false,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[false,[]]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: [false,[]]
json: error: <stdin>:1:7:       ^
[false
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[false,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[456,null]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,null]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[456,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[456,false]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,false]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[456,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[456,true]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,true]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[456,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[456,123]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,123]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[456,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[456,456]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,456]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[456,456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[456,"foo"]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,"foo"]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[456,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[456,"bar"]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,"bar"]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[456,"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[456,{}]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,{}]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[456,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[456,[]]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,[]]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[456,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[456,null]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,null]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[456,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[456,false]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,false]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[456,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[456,true]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,true]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[456,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[456,123]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,123]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[456,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[456,456]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,456]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[456,456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[456,"foo"]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,"foo"]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[456,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[456,"bar"]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,"bar"]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[456,"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[456,{}]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,{}]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[456,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[456,[]]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,[]]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[456,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[456,null]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,null]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[456,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[456,false]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,false]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[456,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[456,true]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,true]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[456,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[456,123]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,123]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[456,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[456,456]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,456]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[456,456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[456,"foo"]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,"foo"]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[456,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[456,"bar"]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,"bar"]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[456,"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[456,{}]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,{}]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[456,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[456,[]]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,[]]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[456,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[456,null]'\''
json: error: <text>:1:83: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[456,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[456,false]'\''
json: error: <text>:1:83: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[456,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[456,true]'\''
json: error: <text>:1:83: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[456,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[456,123]'\''
json: error: <text>:1:83: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[456,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[456,456]'\''
json: error: <text>:1:83: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[456,456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[456,"foo"]'\''
json: error: <text>:1:83: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[456,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[456,"bar"]'\''
json: error: <text>:1:83: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[456,"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[456,{}]'\''
json: error: <text>:1:83: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[456,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[456,[]]'\''
json: error: <text>:1:83: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[456,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[456,null]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,null]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[456,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[456,false]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,false]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[456,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[456,true]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,true]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[456,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[456,123]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,123]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[456,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[456,456]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,456]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[456,456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[456,"foo"]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,"foo"]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[456,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[456,"bar"]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,"bar"]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[456,"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[456,{}]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,{}]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[456,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[456,[]]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [456,[]]
json: error: <stdin>:1:5:     ^
[456
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[456,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''["bar",null]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar",null]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''["bar",null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''["bar",false]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar",false]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''["bar",false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''["bar",true]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar",true]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''["bar",true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''["bar",123]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar",123]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''["bar",123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''["bar",456]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar",456]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''["bar",456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''["bar","foo"]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar","foo"]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''["bar","foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''["bar","bar"]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar","bar"]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''["bar","bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''["bar",{}]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar",{}]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''["bar",{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''["bar",[]]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar",[]]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''["bar",[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''["bar",null]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar",null]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''["bar",null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''["bar",false]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar",false]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''["bar",false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''["bar",true]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar",true]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''["bar",true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''["bar",123]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar",123]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''["bar",123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''["bar",456]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar",456]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''["bar",456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''["bar","foo"]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar","foo"]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''["bar","foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''["bar","bar"]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar","bar"]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''["bar","bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''["bar",{}]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar",{}]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''["bar",{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''["bar",[]]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar",[]]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''["bar",[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''["bar",null]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar",null]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''["bar",null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''["bar",false]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar",false]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''["bar",false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''["bar",true]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar",true]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''["bar",true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''["bar",123]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar",123]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''["bar",123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''["bar",456]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar",456]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''["bar",456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''["bar","foo"]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar","foo"]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''["bar","foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''["bar","bar"]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar","bar"]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''["bar","bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''["bar",{}]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar",{}]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''["bar",{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''["bar",[]]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar",[]]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''["bar",[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''["bar",null]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar",null]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''["bar",null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''["bar",false]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar",false]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''["bar",false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''["bar",true]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar",true]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''["bar",true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''["bar",123]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar",123]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''["bar",123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''["bar",456]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar",456]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''["bar",456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''["bar","foo"]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar","foo"]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''["bar","foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''["bar","bar"]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar","bar"]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''["bar","bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''["bar",{}]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar",{}]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''["bar",{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''["bar",[]]'\''
json: error: <stdin>:1:7: type check error: too many arguments
json: error: <stdin>:1:7: ["bar",[]]
json: error: <stdin>:1:7:       ^
["bar"
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''["bar",[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''["bar",null]'\''
json: error: <text>:1:83: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''["bar",null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''["bar",false]'\''
json: error: <text>:1:83: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''["bar",false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''["bar",true]'\''
json: error: <text>:1:83: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''["bar",true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''["bar",123]'\''
json: error: <text>:1:83: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''["bar",123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''["bar",456]'\''
json: error: <text>:1:83: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''["bar",456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''["bar","foo"]'\''
json: error: <text>:1:83: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''["bar","foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''["bar","bar"]'\''
json: error: <text>:1:83: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''["bar","bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''["bar",{}]'\''
json: error: <text>:1:83: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''["bar",{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''["bar",[]]'\''
json: error: <text>:1:83: type lib error: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''["bar",[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[{},null]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},null]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[{},null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[{},false]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},false]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[{},false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[{},true]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},true]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[{},true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[{},123]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},123]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[{},123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[{},456]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},456]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[{},456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[{},"foo"]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},"foo"]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[{},"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[{},"bar"]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},"bar"]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[{},"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},{}]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[{},[]]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},[]]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[{},[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[{},null]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},null]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[{},null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[{},false]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},false]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[{},false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[{},true]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},true]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[{},true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[{},123]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},123]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[{},123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[{},456]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},456]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[{},456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[{},"foo"]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},"foo"]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[{},"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[{},"bar"]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},"bar"]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[{},"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},{}]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[{},[]]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},[]]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[{},[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[{},null]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},null]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[{},null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[{},false]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},false]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[{},false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[{},true]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},true]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[{},true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[{},123]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},123]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[{},123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[{},456]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},456]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[{},456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[{},"foo"]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},"foo"]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[{},"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[{},"bar"]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},"bar"]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[{},"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},{}]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[{},[]]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},[]]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[{},[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[{},null]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},null]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[{},null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[{},false]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},false]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[{},false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[{},true]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},true]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[{},true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[{},123]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},123]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[{},123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[{},456]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},456]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[{},456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[{},"foo"]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},"foo"]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[{},"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[{},"bar"]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},"bar"]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[{},"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},{}]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[{},[]]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},[]]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[{},[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[{},null]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},null]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[{},null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[{},false]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},false]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[{},false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[{},true]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},true]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[{},true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[{},123]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},123]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[{},123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[{},456]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},456]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[{},456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[{},"foo"]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},"foo"]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[{},"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[{},"bar"]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},"bar"]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[{},"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},{}]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[{},[]]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [{},[]]
json: error: <stdin>:1:4:    ^
[{}
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[{},[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[],null]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],null]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[],null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[],false]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],false]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[],false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[],true]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],true]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[],true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[],123]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],123]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[],123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[],456]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],456]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[],456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[],"foo"]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],"foo"]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[],"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[],"bar"]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],"bar"]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[],"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[],{}]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],{}]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[],{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],[]]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[],[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[],null]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],null]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[],null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[],false]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],false]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[],false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[],true]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],true]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[],true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[],123]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],123]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[],123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[],456]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],456]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[],456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[],"foo"]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],"foo"]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[],"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[],"bar"]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],"bar"]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[],"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[],{}]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],{}]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[],{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],[]]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[],[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[],null]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],null]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[],null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[],false]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],false]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[],false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[],true]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],true]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[],true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[],123]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],123]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[],123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[],456]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],456]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[],456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[],"foo"]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],"foo"]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[],"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[],"bar"]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],"bar"]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[],"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[],{}]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],{}]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[],{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],[]]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[],[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[],null]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],null]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[],null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[],false]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],false]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[],false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[],true]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],true]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[],true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[],123]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],123]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[],123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[],456]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],456]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[],456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[],"foo"]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],"foo"]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[],"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[],"bar"]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],"bar"]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[],"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[],{}]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],{}]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[],{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],[]]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[],[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[],null]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],null]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[],null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[],false]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],false]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[],false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[],true]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],true]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[],true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[],123]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],123]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[],123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[],456]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],456]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[],456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[],"foo"]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],"foo"]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[],"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[],"bar"]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],"bar"]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[],"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[],{}]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],{}]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[],{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:4: type check error: too many arguments
json: error: <stdin>:1:4: [[],[]]
json: error: <stdin>:1:4:    ^
[[]
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[],[]]'\'''
) -L list-closed-array-basic-closed-array-plain-val-array-basic-basic.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[{}],null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":null}]}]}' <<< '[[{}],null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[{}],null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[{}],false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":null}]}]}' <<< '[[{}],false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[{}],false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[{}],true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":null}]}]}' <<< '[[{}],true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[{}],true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[{}],123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":null}]}]}' <<< '[[{}],123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[{}],123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[{}],456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":null}]}]}' <<< '[[{}],456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[{}],456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[{}],"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":null}]}]}' <<< '[[{}],"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[{}],"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[{}],"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":null}]}]}' <<< '[[{}],"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[{}],"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[{}],{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":null}]}]}' <<< '[[{}],{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[{}],{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[{}],[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":null}]}]}' <<< '[[{}],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[{}],[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[{}],null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":false}]}]}' <<< '[[{}],null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[{}],null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[{}],false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":false}]}]}' <<< '[[{}],false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[{}],false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[{}],true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":false}]}]}' <<< '[[{}],true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[{}],true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[{}],123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":false}]}]}' <<< '[[{}],123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[{}],123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[{}],456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":false}]}]}' <<< '[[{}],456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[{}],456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[{}],"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":false}]}]}' <<< '[[{}],"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[{}],"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[{}],"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":false}]}]}' <<< '[[{}],"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[{}],"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[{}],{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":false}]}]}' <<< '[[{}],{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[{}],{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[{}],[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":false}]}]}' <<< '[[{}],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[{}],[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[{}],null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":true}]}]}' <<< '[[{}],null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[{}],null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[{}],false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":true}]}]}' <<< '[[{}],false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[{}],false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[{}],true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":true}]}]}' <<< '[[{}],true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[{}],true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[{}],123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":true}]}]}' <<< '[[{}],123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[{}],123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[{}],456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":true}]}]}' <<< '[[{}],456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[{}],456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[{}],"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":true}]}]}' <<< '[[{}],"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[{}],"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[{}],"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":true}]}]}' <<< '[[{}],"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[{}],"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[{}],{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":true}]}]}' <<< '[[{}],{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[{}],{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[{}],[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":true}]}]}' <<< '[[{}],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[{}],[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[{}],null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":123}]}]}' <<< '[[{}],null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[{}],null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[{}],false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":123}]}]}' <<< '[[{}],false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[{}],false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[{}],true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":123}]}]}' <<< '[[{}],true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[{}],true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[{}],123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":123}]}]}' <<< '[[{}],123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[{}],123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[{}],456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":123}]}]}' <<< '[[{}],456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[{}],456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[{}],"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":123}]}]}' <<< '[[{}],"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[{}],"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[{}],"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":123}]}]}' <<< '[[{}],"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[{}],"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[{}],{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":123}]}]}' <<< '[[{}],{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[{}],{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[{}],[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":123}]}]}' <<< '[[{}],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[{}],[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[{}],null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":"foo"}]}]}' <<< '[[{}],null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[{}],null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[{}],false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":"foo"}]}]}' <<< '[[{}],false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[{}],false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[{}],true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":"foo"}]}]}' <<< '[[{}],true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[{}],true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[{}],123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":"foo"}]}]}' <<< '[[{}],123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[{}],123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[{}],456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":"foo"}]}]}' <<< '[[{}],456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[{}],456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[{}],"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":"foo"}]}]}' <<< '[[{}],"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[{}],"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[{}],"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":"foo"}]}]}' <<< '[[{}],"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[{}],"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[{}],{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":"foo"}]}]}' <<< '[[{}],{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[{}],{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[{}],[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":"foo"}]}]}' <<< '[[{}],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[{}],[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":null}]}]}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[null,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":null}]}]}' <<< '[null,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[null,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[null,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":null}]}]}' <<< '[null,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[null,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[null,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":null}]}]}' <<< '[null,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[null,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[null,456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":null}]}]}' <<< '[null,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[null,456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[null,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":null}]}]}' <<< '[null,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[null,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[null,"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":null}]}]}' <<< '[null,"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[null,"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[null,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":null}]}]}' <<< '[null,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[null,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[null,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":null}]}]}' <<< '[null,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[null,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":false}]}]}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[null,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":false}]}]}' <<< '[null,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[null,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[null,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":false}]}]}' <<< '[null,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[null,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[null,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":false}]}]}' <<< '[null,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[null,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[null,456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":false}]}]}' <<< '[null,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[null,456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[null,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":false}]}]}' <<< '[null,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[null,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[null,"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":false}]}]}' <<< '[null,"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[null,"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[null,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":false}]}]}' <<< '[null,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[null,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[null,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":false}]}]}' <<< '[null,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[null,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":true}]}]}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[null,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":true}]}]}' <<< '[null,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[null,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[null,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":true}]}]}' <<< '[null,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[null,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[null,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":true}]}]}' <<< '[null,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[null,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[null,456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":true}]}]}' <<< '[null,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[null,456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[null,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":true}]}]}' <<< '[null,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[null,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[null,"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":true}]}]}' <<< '[null,"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[null,"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[null,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":true}]}]}' <<< '[null,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[null,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[null,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":true}]}]}' <<< '[null,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[null,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":123}]}]}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[null,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":123}]}]}' <<< '[null,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[null,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[null,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":123}]}]}' <<< '[null,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[null,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[null,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":123}]}]}' <<< '[null,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[null,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[null,456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":123}]}]}' <<< '[null,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[null,456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[null,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":123}]}]}' <<< '[null,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[null,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[null,"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":123}]}]}' <<< '[null,"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[null,"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[null,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":123}]}]}' <<< '[null,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[null,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[null,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":123}]}]}' <<< '[null,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[null,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":"foo"}]}]}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[null,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":"foo"}]}]}' <<< '[null,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[null,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[null,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":"foo"}]}]}' <<< '[null,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[null,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[null,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":"foo"}]}]}' <<< '[null,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[null,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[null,456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":"foo"}]}]}' <<< '[null,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[null,456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[null,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":"foo"}]}]}' <<< '[null,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[null,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[null,"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":"foo"}]}]}' <<< '[null,"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[null,"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[null,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":"foo"}]}]}' <<< '[null,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[null,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[null,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":"foo"}]}]}' <<< '[null,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[null,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[false,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":null}]}]}' <<< '[false,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[false,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":null}]}]}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[false,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":null}]}]}' <<< '[false,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[false,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[false,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":null}]}]}' <<< '[false,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[false,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[false,456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":null}]}]}' <<< '[false,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[false,456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[false,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":null}]}]}' <<< '[false,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[false,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[false,"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":null}]}]}' <<< '[false,"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[false,"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[false,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":null}]}]}' <<< '[false,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[false,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[false,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":null}]}]}' <<< '[false,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[false,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[false,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":false}]}]}' <<< '[false,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[false,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":false}]}]}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[false,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":false}]}]}' <<< '[false,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[false,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[false,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":false}]}]}' <<< '[false,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[false,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[false,456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":false}]}]}' <<< '[false,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[false,456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[false,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":false}]}]}' <<< '[false,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[false,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[false,"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":false}]}]}' <<< '[false,"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[false,"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[false,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":false}]}]}' <<< '[false,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[false,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[false,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":false}]}]}' <<< '[false,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[false,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[false,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":true}]}]}' <<< '[false,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[false,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":true}]}]}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[false,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":true}]}]}' <<< '[false,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[false,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[false,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":true}]}]}' <<< '[false,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[false,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[false,456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":true}]}]}' <<< '[false,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[false,456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[false,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":true}]}]}' <<< '[false,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[false,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[false,"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":true}]}]}' <<< '[false,"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[false,"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[false,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":true}]}]}' <<< '[false,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[false,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[false,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":true}]}]}' <<< '[false,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[false,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[false,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":123}]}]}' <<< '[false,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[false,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":123}]}]}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[false,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":123}]}]}' <<< '[false,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[false,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[false,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":123}]}]}' <<< '[false,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[false,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[false,456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":123}]}]}' <<< '[false,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[false,456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[false,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":123}]}]}' <<< '[false,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[false,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[false,"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":123}]}]}' <<< '[false,"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[false,"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[false,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":123}]}]}' <<< '[false,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[false,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[false,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":123}]}]}' <<< '[false,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[false,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[false,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":"foo"}]}]}' <<< '[false,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[false,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":"foo"}]}]}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[false,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":"foo"}]}]}' <<< '[false,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[false,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[false,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":"foo"}]}]}' <<< '[false,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[false,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[false,456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":"foo"}]}]}' <<< '[false,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[false,456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[false,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":"foo"}]}]}' <<< '[false,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[false,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[false,"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":"foo"}]}]}' <<< '[false,"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[false,"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[false,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":"foo"}]}]}' <<< '[false,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[false,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[false,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":"foo"}]}]}' <<< '[false,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[false,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[456,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":null}]}]}' <<< '[456,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[456,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[456,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":null}]}]}' <<< '[456,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[456,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[456,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":null}]}]}' <<< '[456,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[456,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[456,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":null}]}]}' <<< '[456,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[456,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[456,456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":null}]}]}' <<< '[456,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[456,456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[456,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":null}]}]}' <<< '[456,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[456,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[456,"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":null}]}]}' <<< '[456,"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[456,"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[456,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":null}]}]}' <<< '[456,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[456,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[456,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":null}]}]}' <<< '[456,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[456,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[456,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":false}]}]}' <<< '[456,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[456,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[456,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":false}]}]}' <<< '[456,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[456,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[456,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":false}]}]}' <<< '[456,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[456,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[456,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":false}]}]}' <<< '[456,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[456,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[456,456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":false}]}]}' <<< '[456,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[456,456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[456,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":false}]}]}' <<< '[456,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[456,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[456,"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":false}]}]}' <<< '[456,"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[456,"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[456,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":false}]}]}' <<< '[456,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[456,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[456,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":false}]}]}' <<< '[456,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[456,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[456,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":true}]}]}' <<< '[456,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[456,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[456,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":true}]}]}' <<< '[456,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[456,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[456,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":true}]}]}' <<< '[456,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[456,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[456,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":true}]}]}' <<< '[456,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[456,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[456,456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":true}]}]}' <<< '[456,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[456,456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[456,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":true}]}]}' <<< '[456,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[456,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[456,"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":true}]}]}' <<< '[456,"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[456,"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[456,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":true}]}]}' <<< '[456,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[456,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[456,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":true}]}]}' <<< '[456,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[456,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[456,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":123}]}]}' <<< '[456,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[456,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[456,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":123}]}]}' <<< '[456,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[456,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[456,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":123}]}]}' <<< '[456,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[456,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[456,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":123}]}]}' <<< '[456,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[456,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[456,456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":123}]}]}' <<< '[456,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[456,456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[456,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":123}]}]}' <<< '[456,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[456,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[456,"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":123}]}]}' <<< '[456,"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[456,"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[456,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":123}]}]}' <<< '[456,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[456,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[456,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":123}]}]}' <<< '[456,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[456,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[456,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":"foo"}]}]}' <<< '[456,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[456,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[456,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":"foo"}]}]}' <<< '[456,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[456,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[456,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":"foo"}]}]}' <<< '[456,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[456,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[456,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":"foo"}]}]}' <<< '[456,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[456,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[456,456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":"foo"}]}]}' <<< '[456,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[456,456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[456,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":"foo"}]}]}' <<< '[456,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[456,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[456,"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":"foo"}]}]}' <<< '[456,"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[456,"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[456,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":"foo"}]}]}' <<< '[456,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[456,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[456,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":"foo"}]}]}' <<< '[456,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[456,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''["bar",null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":null}]}]}' <<< '["bar",null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''["bar",null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''["bar",false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":null}]}]}' <<< '["bar",false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''["bar",false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''["bar",true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":null}]}]}' <<< '["bar",true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''["bar",true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''["bar",123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":null}]}]}' <<< '["bar",123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''["bar",123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''["bar",456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":null}]}]}' <<< '["bar",456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''["bar",456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''["bar","foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":null}]}]}' <<< '["bar","foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''["bar","foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":null}]}]}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''["bar",{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":null}]}]}' <<< '["bar",{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''["bar",{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''["bar",[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":null}]}]}' <<< '["bar",[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''["bar",[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''["bar",null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":false}]}]}' <<< '["bar",null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''["bar",null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''["bar",false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":false}]}]}' <<< '["bar",false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''["bar",false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''["bar",true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":false}]}]}' <<< '["bar",true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''["bar",true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''["bar",123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":false}]}]}' <<< '["bar",123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''["bar",123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''["bar",456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":false}]}]}' <<< '["bar",456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''["bar",456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''["bar","foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":false}]}]}' <<< '["bar","foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''["bar","foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":false}]}]}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''["bar",{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":false}]}]}' <<< '["bar",{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''["bar",{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''["bar",[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":false}]}]}' <<< '["bar",[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''["bar",[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''["bar",null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":true}]}]}' <<< '["bar",null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''["bar",null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''["bar",false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":true}]}]}' <<< '["bar",false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''["bar",false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''["bar",true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":true}]}]}' <<< '["bar",true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''["bar",true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''["bar",123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":true}]}]}' <<< '["bar",123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''["bar",123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''["bar",456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":true}]}]}' <<< '["bar",456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''["bar",456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''["bar","foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":true}]}]}' <<< '["bar","foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''["bar","foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":true}]}]}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''["bar",{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":true}]}]}' <<< '["bar",{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''["bar",{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''["bar",[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":true}]}]}' <<< '["bar",[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''["bar",[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''["bar",null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":123}]}]}' <<< '["bar",null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''["bar",null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''["bar",false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":123}]}]}' <<< '["bar",false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''["bar",false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''["bar",true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":123}]}]}' <<< '["bar",true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''["bar",true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''["bar",123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":123}]}]}' <<< '["bar",123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''["bar",123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''["bar",456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":123}]}]}' <<< '["bar",456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''["bar",456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''["bar","foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":123}]}]}' <<< '["bar","foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''["bar","foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":123}]}]}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''["bar",{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":123}]}]}' <<< '["bar",{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''["bar",{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''["bar",[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":123}]}]}' <<< '["bar",[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''["bar",[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''["bar",null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":"foo"}]}]}' <<< '["bar",null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''["bar",null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''["bar",false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":"foo"}]}]}' <<< '["bar",false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''["bar",false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''["bar",true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":"foo"}]}]}' <<< '["bar",true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''["bar",true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''["bar",123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":"foo"}]}]}' <<< '["bar",123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''["bar",123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''["bar",456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":"foo"}]}]}' <<< '["bar",456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''["bar",456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''["bar","foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":"foo"}]}]}' <<< '["bar","foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''["bar","foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''["bar","bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":"foo"}]}]}' <<< '["bar","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''["bar","bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''["bar",{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":"foo"}]}]}' <<< '["bar",{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''["bar",{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''["bar",[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":"foo"}]}]}' <<< '["bar",[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''["bar",[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[{},null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":null}]}]}' <<< '[{},null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[{},null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[{},false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":null}]}]}' <<< '[{},false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[{},false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[{},true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":null}]}]}' <<< '[{},true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[{},true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[{},123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":null}]}]}' <<< '[{},123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[{},123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[{},456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":null}]}]}' <<< '[{},456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[{},456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[{},"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":null}]}]}' <<< '[{},"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[{},"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[{},"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":null}]}]}' <<< '[{},"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[{},"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":null}]}]}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[{},[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":null}]}]}' <<< '[{},[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[{},[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[{},null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":false}]}]}' <<< '[{},null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[{},null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[{},false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":false}]}]}' <<< '[{},false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[{},false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[{},true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":false}]}]}' <<< '[{},true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[{},true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[{},123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":false}]}]}' <<< '[{},123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[{},123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[{},456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":false}]}]}' <<< '[{},456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[{},456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[{},"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":false}]}]}' <<< '[{},"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[{},"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[{},"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":false}]}]}' <<< '[{},"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[{},"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":false}]}]}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[{},[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":false}]}]}' <<< '[{},[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[{},[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[{},null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":true}]}]}' <<< '[{},null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[{},null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[{},false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":true}]}]}' <<< '[{},false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[{},false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[{},true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":true}]}]}' <<< '[{},true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[{},true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[{},123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":true}]}]}' <<< '[{},123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[{},123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[{},456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":true}]}]}' <<< '[{},456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[{},456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[{},"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":true}]}]}' <<< '[{},"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[{},"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[{},"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":true}]}]}' <<< '[{},"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[{},"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":true}]}]}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[{},[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":true}]}]}' <<< '[{},[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[{},[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[{},null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":123}]}]}' <<< '[{},null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[{},null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[{},false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":123}]}]}' <<< '[{},false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[{},false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[{},true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":123}]}]}' <<< '[{},true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[{},true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[{},123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":123}]}]}' <<< '[{},123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[{},123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[{},456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":123}]}]}' <<< '[{},456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[{},456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[{},"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":123}]}]}' <<< '[{},"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[{},"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[{},"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":123}]}]}' <<< '[{},"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[{},"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":123}]}]}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[{},[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":123}]}]}' <<< '[{},[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[{},[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[{},null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":"foo"}]}]}' <<< '[{},null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[{},null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[{},false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":"foo"}]}]}' <<< '[{},false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[{},false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[{},true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":"foo"}]}]}' <<< '[{},true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[{},true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[{},123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":"foo"}]}]}' <<< '[{},123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[{},123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[{},456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":"foo"}]}]}' <<< '[{},456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[{},456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[{},"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":"foo"}]}]}' <<< '[{},"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[{},"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[{},"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":"foo"}]}]}' <<< '[{},"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[{},"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":"foo"}]}]}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[{},[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":"foo"}]}]}' <<< '[{},[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[{},[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[],null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":null}]}]}' <<< '[[],null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[],null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[],false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":null}]}]}' <<< '[[],false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[],false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[],true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":null}]}]}' <<< '[[],true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[],true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[],123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":null}]}]}' <<< '[[],123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[],123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[],456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":null}]}]}' <<< '[[],456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[],456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[],"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":null}]}]}' <<< '[[],"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[],"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[],"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":null}]}]}' <<< '[[],"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[],"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[],{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":null}]}]}' <<< '[[],{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[],{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":null}]}]}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":null}]}]}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[],null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":false}]}]}' <<< '[[],null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[],null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[],false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":false}]}]}' <<< '[[],false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[],false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[],true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":false}]}]}' <<< '[[],true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[],true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[],123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":false}]}]}' <<< '[[],123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[],123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[],456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":false}]}]}' <<< '[[],456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[],456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[],"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":false}]}]}' <<< '[[],"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[],"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[],"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":false}]}]}' <<< '[[],"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[],"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[],{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":false}]}]}' <<< '[[],{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[],{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":false}]}]}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":false}]}]}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[],null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":true}]}]}' <<< '[[],null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[],null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[],false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":true}]}]}' <<< '[[],false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[],false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[],true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":true}]}]}' <<< '[[],true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[],true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[],123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":true}]}]}' <<< '[[],123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[],123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[],456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":true}]}]}' <<< '[[],456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[],456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[],"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":true}]}]}' <<< '[[],"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[],"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[],"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":true}]}]}' <<< '[[],"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[],"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[],{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":true}]}]}' <<< '[[],{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[],{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":true}]}]}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":true}]}]}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[],null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":123}]}]}' <<< '[[],null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[],null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[],false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":123}]}]}' <<< '[[],false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[],false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[],true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":123}]}]}' <<< '[[],true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[],true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[],123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":123}]}]}' <<< '[[],123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[],123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[],456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":123}]}]}' <<< '[[],456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[],456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[],"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":123}]}]}' <<< '[[],"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[],"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[],"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":123}]}]}' <<< '[[],"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[],"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[],{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":123}]}]}' <<< '[[],{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[],{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":123}]}]}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":123}]}]}'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[],null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":"foo"}]}]}' <<< '[[],null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[],null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[],false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":"foo"}]}]}' <<< '[[],false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[],false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[],true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":"foo"}]}]}' <<< '[[],true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[],true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[],123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":"foo"}]}]}' <<< '[[],123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[],123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[],456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":"foo"}]}]}' <<< '[[],456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[],456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[],"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":"foo"}]}]}' <<< '[[],"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[],"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[],"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":"foo"}]}]}' <<< '[[],"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[],"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[],{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":"foo"}]}]}' <<< '[[],{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[],{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":"foo"}]}]}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":[{"plain":"foo"}]}]}'\'' <<< '\''[[],[]]'\'''
)

