#!/bin/bash

# Copyright (C) 2016, 2017  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker-list:list-closed-array-basic-plain-val-basic
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L list-closed-array-basic-plain-val-basic.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''456'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\''
json: error: <stdin>:1:1: 456
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''456'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''"foo"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''[]'\'''
) -L list-closed-array-basic-plain-val-basic.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":null}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":false}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":true}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":123}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["type",{"plain":"foo"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":null}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":false}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":true}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":123}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["null",{"plain":"foo"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":null}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":false}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":true}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":123}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"plain":"foo"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":null}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":false}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":true}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":123}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["number",{"plain":"foo"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":null}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":false}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":true}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":123}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["string",{"plain":"foo"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":null}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":false}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":true}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":123}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["object",{"plain":"foo"}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":null}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":false}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":true}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":123}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''456'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}' <<< '456' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''456'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''"foo"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["array",{"plain":"foo"}]}]}'\'' <<< '\''[]'\'''
)

