#!/bin/bash

# Copyright (C) 2016, 2017  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker:open-array7
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L open-array7.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[456,null]'\''
[456,null]
$ json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[456,false]'\''
[456,false]
$ json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[456,true]'\''
[456,true]
$ json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[456,123]'\''
[456,123]
$ json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[456,"foo"]'\''
[456,"foo"]
$ json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[456,{}]'\''
[456,{}]
$ json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[456,[]]'\''
[456,[]]
$ json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[456,null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:2: [456,null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[456,null]'\''
$ json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[456,false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:2: [456,false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[456,false]'\''
$ json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[456,true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:2: [456,true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[456,true]'\''
$ json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[456,123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:2: [456,123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[456,123]'\''
$ json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[456,"foo"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:2: [456,"foo"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[456,"foo"]'\''
$ json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[456,{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:2: [456,{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[456,{}]'\''
$ json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[456,[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:2: [456,[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[456,[]]'\''
$ json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[456,null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:2: [456,null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[456,null]'\''
$ json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[456,false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:2: [456,false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[456,false]'\''
$ json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[456,true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:2: [456,true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[456,true]'\''
$ json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[456,123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:2: [456,123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[456,123]'\''
$ json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[456,"foo"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:2: [456,"foo"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[456,"foo"]'\''
$ json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[456,{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:2: [456,{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[456,{}]'\''
$ json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[456,[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:2: [456,[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[456,[]]'\''
$ json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[456,null]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:6: [456,null]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[456,null]'\''
$ json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[456,false]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:6: [456,false]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[456,false]'\''
$ json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[456,true]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:6: [456,true]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[456,true]'\''
$ json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[456,123]'\''
[456,123]
$ json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[456,"foo"]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:6: [456,"foo"]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[456,"foo"]'\''
$ json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[456,{}]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:6: [456,{}]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[456,{}]'\''
$ json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[456,[]]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:6: [456,[]]
json: error: <stdin>:1:6:      ^
[456,
command failed: json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[456,[]]'\''
$ json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[456,null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:2: [456,null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[456,null]'\''
$ json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[456,false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:2: [456,false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[456,false]'\''
$ json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[456,true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:2: [456,true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[456,true]'\''
$ json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[456,123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:2: [456,123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[456,123]'\''
$ json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[456,"foo"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:2: [456,"foo"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[456,"foo"]'\''
$ json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[456,{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:2: [456,{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[456,{}]'\''
$ json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[456,[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:2: [456,[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[456,[]]'\''
$ json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[456,null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:2: [456,null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[456,null]'\''
$ json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[456,false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:2: [456,false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[456,false]'\''
$ json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[456,true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:2: [456,true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[456,true]'\''
$ json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[456,123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:2: [456,123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[456,123]'\''
$ json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[456,"foo"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:2: [456,"foo"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[456,"foo"]'\''
$ json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[456,{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:2: [456,{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[456,{}]'\''
$ json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[456,[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:2: [456,[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[456,[]]'\''
$ json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[456,null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:2: [456,null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[456,null]'\''
$ json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[456,false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:2: [456,false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[456,false]'\''
$ json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[456,true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:2: [456,true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[456,true]'\''
$ json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[456,123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:2: [456,123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[456,123]'\''
$ json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[456,"foo"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:2: [456,"foo"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[456,"foo"]'\''
$ json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[456,{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:2: [456,{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[456,{}]'\''
$ json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[456,[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:2: [456,[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[456,[]]'\'''
) -L open-array7.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[456,null]'\'''
json -d '{"type":"array","args":"type"}' <<< '[456,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[456,null]'\'''

echo '$ json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[456,false]'\'''
json -d '{"type":"array","args":"type"}' <<< '[456,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[456,false]'\'''

echo '$ json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[456,true]'\'''
json -d '{"type":"array","args":"type"}' <<< '[456,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[456,true]'\'''

echo '$ json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[456,123]'\'''
json -d '{"type":"array","args":"type"}' <<< '[456,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[456,123]'\'''

echo '$ json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[456,"foo"]'\'''
json -d '{"type":"array","args":"type"}' <<< '[456,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[456,"foo"]'\'''

echo '$ json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[456,{}]'\'''
json -d '{"type":"array","args":"type"}' <<< '[456,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[456,{}]'\'''

echo '$ json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[456,[]]'\'''
json -d '{"type":"array","args":"type"}' <<< '[456,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[456,[]]'\'''

echo '$ json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[456,null]'\'''
json -d '{"type":"array","args":"null"}' <<< '[456,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[456,null]'\'''

echo '$ json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[456,false]'\'''
json -d '{"type":"array","args":"null"}' <<< '[456,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[456,false]'\'''

echo '$ json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[456,true]'\'''
json -d '{"type":"array","args":"null"}' <<< '[456,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[456,true]'\'''

echo '$ json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[456,123]'\'''
json -d '{"type":"array","args":"null"}' <<< '[456,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[456,123]'\'''

echo '$ json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[456,"foo"]'\'''
json -d '{"type":"array","args":"null"}' <<< '[456,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[456,"foo"]'\'''

echo '$ json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[456,{}]'\'''
json -d '{"type":"array","args":"null"}' <<< '[456,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[456,{}]'\'''

echo '$ json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[456,[]]'\'''
json -d '{"type":"array","args":"null"}' <<< '[456,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[456,[]]'\'''

echo '$ json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[456,null]'\'''
json -d '{"type":"array","args":"boolean"}' <<< '[456,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[456,null]'\'''

echo '$ json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[456,false]'\'''
json -d '{"type":"array","args":"boolean"}' <<< '[456,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[456,false]'\'''

echo '$ json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[456,true]'\'''
json -d '{"type":"array","args":"boolean"}' <<< '[456,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[456,true]'\'''

echo '$ json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[456,123]'\'''
json -d '{"type":"array","args":"boolean"}' <<< '[456,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[456,123]'\'''

echo '$ json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[456,"foo"]'\'''
json -d '{"type":"array","args":"boolean"}' <<< '[456,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[456,"foo"]'\'''

echo '$ json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[456,{}]'\'''
json -d '{"type":"array","args":"boolean"}' <<< '[456,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[456,{}]'\'''

echo '$ json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[456,[]]'\'''
json -d '{"type":"array","args":"boolean"}' <<< '[456,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[456,[]]'\'''

echo '$ json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[456,null]'\'''
json -d '{"type":"array","args":"number"}' <<< '[456,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[456,null]'\'''

echo '$ json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[456,false]'\'''
json -d '{"type":"array","args":"number"}' <<< '[456,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[456,false]'\'''

echo '$ json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[456,true]'\'''
json -d '{"type":"array","args":"number"}' <<< '[456,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[456,true]'\'''

echo '$ json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[456,123]'\'''
json -d '{"type":"array","args":"number"}' <<< '[456,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[456,123]'\'''

echo '$ json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[456,"foo"]'\'''
json -d '{"type":"array","args":"number"}' <<< '[456,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[456,"foo"]'\'''

echo '$ json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[456,{}]'\'''
json -d '{"type":"array","args":"number"}' <<< '[456,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[456,{}]'\'''

echo '$ json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[456,[]]'\'''
json -d '{"type":"array","args":"number"}' <<< '[456,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[456,[]]'\'''

echo '$ json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[456,null]'\'''
json -d '{"type":"array","args":"string"}' <<< '[456,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[456,null]'\'''

echo '$ json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[456,false]'\'''
json -d '{"type":"array","args":"string"}' <<< '[456,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[456,false]'\'''

echo '$ json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[456,true]'\'''
json -d '{"type":"array","args":"string"}' <<< '[456,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[456,true]'\'''

echo '$ json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[456,123]'\'''
json -d '{"type":"array","args":"string"}' <<< '[456,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[456,123]'\'''

echo '$ json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[456,"foo"]'\'''
json -d '{"type":"array","args":"string"}' <<< '[456,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[456,"foo"]'\'''

echo '$ json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[456,{}]'\'''
json -d '{"type":"array","args":"string"}' <<< '[456,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[456,{}]'\'''

echo '$ json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[456,[]]'\'''
json -d '{"type":"array","args":"string"}' <<< '[456,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[456,[]]'\'''

echo '$ json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[456,null]'\'''
json -d '{"type":"array","args":"object"}' <<< '[456,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[456,null]'\'''

echo '$ json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[456,false]'\'''
json -d '{"type":"array","args":"object"}' <<< '[456,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[456,false]'\'''

echo '$ json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[456,true]'\'''
json -d '{"type":"array","args":"object"}' <<< '[456,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[456,true]'\'''

echo '$ json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[456,123]'\'''
json -d '{"type":"array","args":"object"}' <<< '[456,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[456,123]'\'''

echo '$ json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[456,"foo"]'\'''
json -d '{"type":"array","args":"object"}' <<< '[456,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[456,"foo"]'\'''

echo '$ json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[456,{}]'\'''
json -d '{"type":"array","args":"object"}' <<< '[456,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[456,{}]'\'''

echo '$ json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[456,[]]'\'''
json -d '{"type":"array","args":"object"}' <<< '[456,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[456,[]]'\'''

echo '$ json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[456,null]'\'''
json -d '{"type":"array","args":"array"}' <<< '[456,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[456,null]'\'''

echo '$ json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[456,false]'\'''
json -d '{"type":"array","args":"array"}' <<< '[456,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[456,false]'\'''

echo '$ json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[456,true]'\'''
json -d '{"type":"array","args":"array"}' <<< '[456,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[456,true]'\'''

echo '$ json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[456,123]'\'''
json -d '{"type":"array","args":"array"}' <<< '[456,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[456,123]'\'''

echo '$ json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[456,"foo"]'\'''
json -d '{"type":"array","args":"array"}' <<< '[456,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[456,"foo"]'\'''

echo '$ json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[456,{}]'\'''
json -d '{"type":"array","args":"array"}' <<< '[456,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[456,{}]'\'''

echo '$ json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[456,[]]'\'''
json -d '{"type":"array","args":"array"}' <<< '[456,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[456,[]]'\'''
)

