#!/bin/bash

# Copyright (C) 2016, 2017  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C parser:string-unicode
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L string-unicode.old <(echo \
'$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }
$ json() { json0 --literal-value --parse-only "$@"; }
$ echo '\''"\uD7FF"'\''|json
$ echo '\''"\uD800"'\''|json
json: error: <stdin>:1:7: lex error: invalid string literal
json: error: <stdin>:1:7: "\\uD800"
json: error: <stdin>:1:7:        ^
command failed: echo '\''"\uD800"'\''|json
$ echo '\''"\uD801"'\''|json
json: error: <stdin>:1:7: lex error: invalid string literal
json: error: <stdin>:1:7: "\\uD801"
json: error: <stdin>:1:7:        ^
command failed: echo '\''"\uD801"'\''|json
$ echo '\''"\uDEAD"'\''|json
json: error: <stdin>:1:7: lex error: invalid string literal
json: error: <stdin>:1:7: "\\uDEAD"
json: error: <stdin>:1:7:        ^
command failed: echo '\''"\uDEAD"'\''|json
$ echo '\''"\uDFFE"'\''|json
json: error: <stdin>:1:7: lex error: invalid string literal
json: error: <stdin>:1:7: "\\uDFFE"
json: error: <stdin>:1:7:        ^
command failed: echo '\''"\uDFFE"'\''|json
$ echo '\''"\uDFFF"'\''|json
json: error: <stdin>:1:7: lex error: invalid string literal
json: error: <stdin>:1:7: "\\uDFFF"
json: error: <stdin>:1:7:        ^
command failed: echo '\''"\uDFFF"'\''|json
$ echo '\''"\uE000"'\''|json
$ json() { json0 --literal-value "$@"; }
$ echo '\''"\u0000"'\''|json -b 1
"\u0000"
$ echo '\''"\u0000"'\''|json -b 2
"\u0000"
$ echo '\''"\u0000"'\''|json -b 3
"\u0000"
$ echo '\''"\u0000"'\''|json -b 4
"\u0000"
$ echo '\''"\u0000"'\''|json -b 5
"\u0000"
$ echo '\''"\u0000"'\''|json -b 6
"\u0000"
$ echo '\''"\u0000"'\''|json -b 7
"\u0000"
$ echo '\''"\u0000"'\''|json -b 8
"\u0000"
$ echo '\''"\u0001"'\''|json -b 1
"\u0001"
$ echo '\''"\u0001"'\''|json -b 2
"\u0001"
$ echo '\''"\u0001"'\''|json -b 3
"\u0001"
$ echo '\''"\u0001"'\''|json -b 4
"\u0001"
$ echo '\''"\u0001"'\''|json -b 5
"\u0001"
$ echo '\''"\u0001"'\''|json -b 6
"\u0001"
$ echo '\''"\u0001"'\''|json -b 7
"\u0001"
$ echo '\''"\u0001"'\''|json -b 8
"\u0001"
$ echo '\''"\u0002"'\''|json -b 1
"\u0002"
$ echo '\''"\u0002"'\''|json -b 2
"\u0002"
$ echo '\''"\u0002"'\''|json -b 3
"\u0002"
$ echo '\''"\u0002"'\''|json -b 4
"\u0002"
$ echo '\''"\u0002"'\''|json -b 5
"\u0002"
$ echo '\''"\u0002"'\''|json -b 6
"\u0002"
$ echo '\''"\u0002"'\''|json -b 7
"\u0002"
$ echo '\''"\u0002"'\''|json -b 8
"\u0002"
$ echo '\''"\u0003"'\''|json -b 1
"\u0003"
$ echo '\''"\u0003"'\''|json -b 2
"\u0003"
$ echo '\''"\u0003"'\''|json -b 3
"\u0003"
$ echo '\''"\u0003"'\''|json -b 4
"\u0003"
$ echo '\''"\u0003"'\''|json -b 5
"\u0003"
$ echo '\''"\u0003"'\''|json -b 6
"\u0003"
$ echo '\''"\u0003"'\''|json -b 7
"\u0003"
$ echo '\''"\u0003"'\''|json -b 8
"\u0003"
$ echo '\''"\u0004"'\''|json -b 1
"\u0004"
$ echo '\''"\u0004"'\''|json -b 2
"\u0004"
$ echo '\''"\u0004"'\''|json -b 3
"\u0004"
$ echo '\''"\u0004"'\''|json -b 4
"\u0004"
$ echo '\''"\u0004"'\''|json -b 5
"\u0004"
$ echo '\''"\u0004"'\''|json -b 6
"\u0004"
$ echo '\''"\u0004"'\''|json -b 7
"\u0004"
$ echo '\''"\u0004"'\''|json -b 8
"\u0004"
$ echo '\''"\u0005"'\''|json -b 1
"\u0005"
$ echo '\''"\u0005"'\''|json -b 2
"\u0005"
$ echo '\''"\u0005"'\''|json -b 3
"\u0005"
$ echo '\''"\u0005"'\''|json -b 4
"\u0005"
$ echo '\''"\u0005"'\''|json -b 5
"\u0005"
$ echo '\''"\u0005"'\''|json -b 6
"\u0005"
$ echo '\''"\u0005"'\''|json -b 7
"\u0005"
$ echo '\''"\u0005"'\''|json -b 8
"\u0005"
$ echo '\''"\u0006"'\''|json -b 1
"\u0006"
$ echo '\''"\u0006"'\''|json -b 2
"\u0006"
$ echo '\''"\u0006"'\''|json -b 3
"\u0006"
$ echo '\''"\u0006"'\''|json -b 4
"\u0006"
$ echo '\''"\u0006"'\''|json -b 5
"\u0006"
$ echo '\''"\u0006"'\''|json -b 6
"\u0006"
$ echo '\''"\u0006"'\''|json -b 7
"\u0006"
$ echo '\''"\u0006"'\''|json -b 8
"\u0006"
$ echo '\''"\u0007"'\''|json -b 1
"\u0007"
$ echo '\''"\u0007"'\''|json -b 2
"\u0007"
$ echo '\''"\u0007"'\''|json -b 3
"\u0007"
$ echo '\''"\u0007"'\''|json -b 4
"\u0007"
$ echo '\''"\u0007"'\''|json -b 5
"\u0007"
$ echo '\''"\u0007"'\''|json -b 6
"\u0007"
$ echo '\''"\u0007"'\''|json -b 7
"\u0007"
$ echo '\''"\u0007"'\''|json -b 8
"\u0007"
$ echo '\''"\u0008"'\''|json -b 1
"\b"
$ echo '\''"\u0008"'\''|json -b 2
"\b"
$ echo '\''"\u0008"'\''|json -b 3
"\b"
$ echo '\''"\u0008"'\''|json -b 4
"\b"
$ echo '\''"\u0008"'\''|json -b 5
"\b"
$ echo '\''"\u0008"'\''|json -b 6
"\b"
$ echo '\''"\u0008"'\''|json -b 7
"\b"
$ echo '\''"\u0008"'\''|json -b 8
"\b"
$ echo '\''"\u0009"'\''|json -b 1
"\t"
$ echo '\''"\u0009"'\''|json -b 2
"\t"
$ echo '\''"\u0009"'\''|json -b 3
"\t"
$ echo '\''"\u0009"'\''|json -b 4
"\t"
$ echo '\''"\u0009"'\''|json -b 5
"\t"
$ echo '\''"\u0009"'\''|json -b 6
"\t"
$ echo '\''"\u0009"'\''|json -b 7
"\t"
$ echo '\''"\u0009"'\''|json -b 8
"\t"
$ echo '\''"\u000a"'\''|json -b 1
"\n"
$ echo '\''"\u000a"'\''|json -b 2
"\n"
$ echo '\''"\u000a"'\''|json -b 3
"\n"
$ echo '\''"\u000a"'\''|json -b 4
"\n"
$ echo '\''"\u000a"'\''|json -b 5
"\n"
$ echo '\''"\u000a"'\''|json -b 6
"\n"
$ echo '\''"\u000a"'\''|json -b 7
"\n"
$ echo '\''"\u000a"'\''|json -b 8
"\n"
$ echo '\''"\u000b"'\''|json -b 1
"\u000b"
$ echo '\''"\u000b"'\''|json -b 2
"\u000b"
$ echo '\''"\u000b"'\''|json -b 3
"\u000b"
$ echo '\''"\u000b"'\''|json -b 4
"\u000b"
$ echo '\''"\u000b"'\''|json -b 5
"\u000b"
$ echo '\''"\u000b"'\''|json -b 6
"\u000b"
$ echo '\''"\u000b"'\''|json -b 7
"\u000b"
$ echo '\''"\u000b"'\''|json -b 8
"\u000b"
$ echo '\''"\u000c"'\''|json -b 1
"\f"
$ echo '\''"\u000c"'\''|json -b 2
"\f"
$ echo '\''"\u000c"'\''|json -b 3
"\f"
$ echo '\''"\u000c"'\''|json -b 4
"\f"
$ echo '\''"\u000c"'\''|json -b 5
"\f"
$ echo '\''"\u000c"'\''|json -b 6
"\f"
$ echo '\''"\u000c"'\''|json -b 7
"\f"
$ echo '\''"\u000c"'\''|json -b 8
"\f"
$ echo '\''"\u000d"'\''|json -b 1
"\r"
$ echo '\''"\u000d"'\''|json -b 2
"\r"
$ echo '\''"\u000d"'\''|json -b 3
"\r"
$ echo '\''"\u000d"'\''|json -b 4
"\r"
$ echo '\''"\u000d"'\''|json -b 5
"\r"
$ echo '\''"\u000d"'\''|json -b 6
"\r"
$ echo '\''"\u000d"'\''|json -b 7
"\r"
$ echo '\''"\u000d"'\''|json -b 8
"\r"
$ echo '\''"\u000e"'\''|json -b 1
"\u000e"
$ echo '\''"\u000e"'\''|json -b 2
"\u000e"
$ echo '\''"\u000e"'\''|json -b 3
"\u000e"
$ echo '\''"\u000e"'\''|json -b 4
"\u000e"
$ echo '\''"\u000e"'\''|json -b 5
"\u000e"
$ echo '\''"\u000e"'\''|json -b 6
"\u000e"
$ echo '\''"\u000e"'\''|json -b 7
"\u000e"
$ echo '\''"\u000e"'\''|json -b 8
"\u000e"
$ echo '\''"\u000f"'\''|json -b 1
"\u000f"
$ echo '\''"\u000f"'\''|json -b 2
"\u000f"
$ echo '\''"\u000f"'\''|json -b 3
"\u000f"
$ echo '\''"\u000f"'\''|json -b 4
"\u000f"
$ echo '\''"\u000f"'\''|json -b 5
"\u000f"
$ echo '\''"\u000f"'\''|json -b 6
"\u000f"
$ echo '\''"\u000f"'\''|json -b 7
"\u000f"
$ echo '\''"\u000f"'\''|json -b 8
"\u000f"
$ echo '\''"\u0010"'\''|json -b 1
"\u0010"
$ echo '\''"\u0010"'\''|json -b 2
"\u0010"
$ echo '\''"\u0010"'\''|json -b 3
"\u0010"
$ echo '\''"\u0010"'\''|json -b 4
"\u0010"
$ echo '\''"\u0010"'\''|json -b 5
"\u0010"
$ echo '\''"\u0010"'\''|json -b 6
"\u0010"
$ echo '\''"\u0010"'\''|json -b 7
"\u0010"
$ echo '\''"\u0010"'\''|json -b 8
"\u0010"
$ echo '\''"\u0011"'\''|json -b 1
"\u0011"
$ echo '\''"\u0011"'\''|json -b 2
"\u0011"
$ echo '\''"\u0011"'\''|json -b 3
"\u0011"
$ echo '\''"\u0011"'\''|json -b 4
"\u0011"
$ echo '\''"\u0011"'\''|json -b 5
"\u0011"
$ echo '\''"\u0011"'\''|json -b 6
"\u0011"
$ echo '\''"\u0011"'\''|json -b 7
"\u0011"
$ echo '\''"\u0011"'\''|json -b 8
"\u0011"
$ echo '\''"\u0012"'\''|json -b 1
"\u0012"
$ echo '\''"\u0012"'\''|json -b 2
"\u0012"
$ echo '\''"\u0012"'\''|json -b 3
"\u0012"
$ echo '\''"\u0012"'\''|json -b 4
"\u0012"
$ echo '\''"\u0012"'\''|json -b 5
"\u0012"
$ echo '\''"\u0012"'\''|json -b 6
"\u0012"
$ echo '\''"\u0012"'\''|json -b 7
"\u0012"
$ echo '\''"\u0012"'\''|json -b 8
"\u0012"
$ echo '\''"\u0013"'\''|json -b 1
"\u0013"
$ echo '\''"\u0013"'\''|json -b 2
"\u0013"
$ echo '\''"\u0013"'\''|json -b 3
"\u0013"
$ echo '\''"\u0013"'\''|json -b 4
"\u0013"
$ echo '\''"\u0013"'\''|json -b 5
"\u0013"
$ echo '\''"\u0013"'\''|json -b 6
"\u0013"
$ echo '\''"\u0013"'\''|json -b 7
"\u0013"
$ echo '\''"\u0013"'\''|json -b 8
"\u0013"
$ echo '\''"\u0014"'\''|json -b 1
"\u0014"
$ echo '\''"\u0014"'\''|json -b 2
"\u0014"
$ echo '\''"\u0014"'\''|json -b 3
"\u0014"
$ echo '\''"\u0014"'\''|json -b 4
"\u0014"
$ echo '\''"\u0014"'\''|json -b 5
"\u0014"
$ echo '\''"\u0014"'\''|json -b 6
"\u0014"
$ echo '\''"\u0014"'\''|json -b 7
"\u0014"
$ echo '\''"\u0014"'\''|json -b 8
"\u0014"
$ echo '\''"\u0015"'\''|json -b 1
"\u0015"
$ echo '\''"\u0015"'\''|json -b 2
"\u0015"
$ echo '\''"\u0015"'\''|json -b 3
"\u0015"
$ echo '\''"\u0015"'\''|json -b 4
"\u0015"
$ echo '\''"\u0015"'\''|json -b 5
"\u0015"
$ echo '\''"\u0015"'\''|json -b 6
"\u0015"
$ echo '\''"\u0015"'\''|json -b 7
"\u0015"
$ echo '\''"\u0015"'\''|json -b 8
"\u0015"
$ echo '\''"\u0016"'\''|json -b 1
"\u0016"
$ echo '\''"\u0016"'\''|json -b 2
"\u0016"
$ echo '\''"\u0016"'\''|json -b 3
"\u0016"
$ echo '\''"\u0016"'\''|json -b 4
"\u0016"
$ echo '\''"\u0016"'\''|json -b 5
"\u0016"
$ echo '\''"\u0016"'\''|json -b 6
"\u0016"
$ echo '\''"\u0016"'\''|json -b 7
"\u0016"
$ echo '\''"\u0016"'\''|json -b 8
"\u0016"
$ echo '\''"\u0017"'\''|json -b 1
"\u0017"
$ echo '\''"\u0017"'\''|json -b 2
"\u0017"
$ echo '\''"\u0017"'\''|json -b 3
"\u0017"
$ echo '\''"\u0017"'\''|json -b 4
"\u0017"
$ echo '\''"\u0017"'\''|json -b 5
"\u0017"
$ echo '\''"\u0017"'\''|json -b 6
"\u0017"
$ echo '\''"\u0017"'\''|json -b 7
"\u0017"
$ echo '\''"\u0017"'\''|json -b 8
"\u0017"
$ echo '\''"\u0018"'\''|json -b 1
"\u0018"
$ echo '\''"\u0018"'\''|json -b 2
"\u0018"
$ echo '\''"\u0018"'\''|json -b 3
"\u0018"
$ echo '\''"\u0018"'\''|json -b 4
"\u0018"
$ echo '\''"\u0018"'\''|json -b 5
"\u0018"
$ echo '\''"\u0018"'\''|json -b 6
"\u0018"
$ echo '\''"\u0018"'\''|json -b 7
"\u0018"
$ echo '\''"\u0018"'\''|json -b 8
"\u0018"
$ echo '\''"\u0019"'\''|json -b 1
"\u0019"
$ echo '\''"\u0019"'\''|json -b 2
"\u0019"
$ echo '\''"\u0019"'\''|json -b 3
"\u0019"
$ echo '\''"\u0019"'\''|json -b 4
"\u0019"
$ echo '\''"\u0019"'\''|json -b 5
"\u0019"
$ echo '\''"\u0019"'\''|json -b 6
"\u0019"
$ echo '\''"\u0019"'\''|json -b 7
"\u0019"
$ echo '\''"\u0019"'\''|json -b 8
"\u0019"
$ echo '\''"\u001a"'\''|json -b 1
"\u001a"
$ echo '\''"\u001a"'\''|json -b 2
"\u001a"
$ echo '\''"\u001a"'\''|json -b 3
"\u001a"
$ echo '\''"\u001a"'\''|json -b 4
"\u001a"
$ echo '\''"\u001a"'\''|json -b 5
"\u001a"
$ echo '\''"\u001a"'\''|json -b 6
"\u001a"
$ echo '\''"\u001a"'\''|json -b 7
"\u001a"
$ echo '\''"\u001a"'\''|json -b 8
"\u001a"
$ echo '\''"\u001b"'\''|json -b 1
"\u001b"
$ echo '\''"\u001b"'\''|json -b 2
"\u001b"
$ echo '\''"\u001b"'\''|json -b 3
"\u001b"
$ echo '\''"\u001b"'\''|json -b 4
"\u001b"
$ echo '\''"\u001b"'\''|json -b 5
"\u001b"
$ echo '\''"\u001b"'\''|json -b 6
"\u001b"
$ echo '\''"\u001b"'\''|json -b 7
"\u001b"
$ echo '\''"\u001b"'\''|json -b 8
"\u001b"
$ echo '\''"\u001c"'\''|json -b 1
"\u001c"
$ echo '\''"\u001c"'\''|json -b 2
"\u001c"
$ echo '\''"\u001c"'\''|json -b 3
"\u001c"
$ echo '\''"\u001c"'\''|json -b 4
"\u001c"
$ echo '\''"\u001c"'\''|json -b 5
"\u001c"
$ echo '\''"\u001c"'\''|json -b 6
"\u001c"
$ echo '\''"\u001c"'\''|json -b 7
"\u001c"
$ echo '\''"\u001c"'\''|json -b 8
"\u001c"
$ echo '\''"\u001d"'\''|json -b 1
"\u001d"
$ echo '\''"\u001d"'\''|json -b 2
"\u001d"
$ echo '\''"\u001d"'\''|json -b 3
"\u001d"
$ echo '\''"\u001d"'\''|json -b 4
"\u001d"
$ echo '\''"\u001d"'\''|json -b 5
"\u001d"
$ echo '\''"\u001d"'\''|json -b 6
"\u001d"
$ echo '\''"\u001d"'\''|json -b 7
"\u001d"
$ echo '\''"\u001d"'\''|json -b 8
"\u001d"
$ echo '\''"\u001e"'\''|json -b 1
"\u001e"
$ echo '\''"\u001e"'\''|json -b 2
"\u001e"
$ echo '\''"\u001e"'\''|json -b 3
"\u001e"
$ echo '\''"\u001e"'\''|json -b 4
"\u001e"
$ echo '\''"\u001e"'\''|json -b 5
"\u001e"
$ echo '\''"\u001e"'\''|json -b 6
"\u001e"
$ echo '\''"\u001e"'\''|json -b 7
"\u001e"
$ echo '\''"\u001e"'\''|json -b 8
"\u001e"
$ echo '\''"\u001f"'\''|json -b 1
"\u001f"
$ echo '\''"\u001f"'\''|json -b 2
"\u001f"
$ echo '\''"\u001f"'\''|json -b 3
"\u001f"
$ echo '\''"\u001f"'\''|json -b 4
"\u001f"
$ echo '\''"\u001f"'\''|json -b 5
"\u001f"
$ echo '\''"\u001f"'\''|json -b 6
"\u001f"
$ echo '\''"\u001f"'\''|json -b 7
"\u001f"
$ echo '\''"\u001f"'\''|json -b 8
"\u001f"'
) -L string-unicode.new <(
echo '$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'
json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; } 2>&1 ||
echo 'command failed: json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'

echo '$ json() { json0 --literal-value --parse-only "$@"; }'
json() { json0 --literal-value --parse-only "$@"; } 2>&1 ||
echo 'command failed: json() { json0 --literal-value --parse-only "$@"; }'

echo '$ echo '\''"\uD7FF"'\''|json'
echo '"\uD7FF"'|json 2>&1 ||
echo 'command failed: echo '\''"\uD7FF"'\''|json'

echo '$ echo '\''"\uD800"'\''|json'
echo '"\uD800"'|json 2>&1 ||
echo 'command failed: echo '\''"\uD800"'\''|json'

echo '$ echo '\''"\uD801"'\''|json'
echo '"\uD801"'|json 2>&1 ||
echo 'command failed: echo '\''"\uD801"'\''|json'

echo '$ echo '\''"\uDEAD"'\''|json'
echo '"\uDEAD"'|json 2>&1 ||
echo 'command failed: echo '\''"\uDEAD"'\''|json'

echo '$ echo '\''"\uDFFE"'\''|json'
echo '"\uDFFE"'|json 2>&1 ||
echo 'command failed: echo '\''"\uDFFE"'\''|json'

echo '$ echo '\''"\uDFFF"'\''|json'
echo '"\uDFFF"'|json 2>&1 ||
echo 'command failed: echo '\''"\uDFFF"'\''|json'

echo '$ echo '\''"\uE000"'\''|json'
echo '"\uE000"'|json 2>&1 ||
echo 'command failed: echo '\''"\uE000"'\''|json'

echo '$ json() { json0 --literal-value "$@"; }'
json() { json0 --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { json0 --literal-value "$@"; }'

echo '$ echo '\''"\u0000"'\''|json -b 1'
echo '"\u0000"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u0000"'\''|json -b 1'

echo '$ echo '\''"\u0000"'\''|json -b 2'
echo '"\u0000"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u0000"'\''|json -b 2'

echo '$ echo '\''"\u0000"'\''|json -b 3'
echo '"\u0000"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u0000"'\''|json -b 3'

echo '$ echo '\''"\u0000"'\''|json -b 4'
echo '"\u0000"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u0000"'\''|json -b 4'

echo '$ echo '\''"\u0000"'\''|json -b 5'
echo '"\u0000"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u0000"'\''|json -b 5'

echo '$ echo '\''"\u0000"'\''|json -b 6'
echo '"\u0000"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u0000"'\''|json -b 6'

echo '$ echo '\''"\u0000"'\''|json -b 7'
echo '"\u0000"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u0000"'\''|json -b 7'

echo '$ echo '\''"\u0000"'\''|json -b 8'
echo '"\u0000"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u0000"'\''|json -b 8'

echo '$ echo '\''"\u0001"'\''|json -b 1'
echo '"\u0001"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u0001"'\''|json -b 1'

echo '$ echo '\''"\u0001"'\''|json -b 2'
echo '"\u0001"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u0001"'\''|json -b 2'

echo '$ echo '\''"\u0001"'\''|json -b 3'
echo '"\u0001"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u0001"'\''|json -b 3'

echo '$ echo '\''"\u0001"'\''|json -b 4'
echo '"\u0001"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u0001"'\''|json -b 4'

echo '$ echo '\''"\u0001"'\''|json -b 5'
echo '"\u0001"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u0001"'\''|json -b 5'

echo '$ echo '\''"\u0001"'\''|json -b 6'
echo '"\u0001"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u0001"'\''|json -b 6'

echo '$ echo '\''"\u0001"'\''|json -b 7'
echo '"\u0001"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u0001"'\''|json -b 7'

echo '$ echo '\''"\u0001"'\''|json -b 8'
echo '"\u0001"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u0001"'\''|json -b 8'

echo '$ echo '\''"\u0002"'\''|json -b 1'
echo '"\u0002"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u0002"'\''|json -b 1'

echo '$ echo '\''"\u0002"'\''|json -b 2'
echo '"\u0002"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u0002"'\''|json -b 2'

echo '$ echo '\''"\u0002"'\''|json -b 3'
echo '"\u0002"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u0002"'\''|json -b 3'

echo '$ echo '\''"\u0002"'\''|json -b 4'
echo '"\u0002"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u0002"'\''|json -b 4'

echo '$ echo '\''"\u0002"'\''|json -b 5'
echo '"\u0002"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u0002"'\''|json -b 5'

echo '$ echo '\''"\u0002"'\''|json -b 6'
echo '"\u0002"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u0002"'\''|json -b 6'

echo '$ echo '\''"\u0002"'\''|json -b 7'
echo '"\u0002"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u0002"'\''|json -b 7'

echo '$ echo '\''"\u0002"'\''|json -b 8'
echo '"\u0002"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u0002"'\''|json -b 8'

echo '$ echo '\''"\u0003"'\''|json -b 1'
echo '"\u0003"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u0003"'\''|json -b 1'

echo '$ echo '\''"\u0003"'\''|json -b 2'
echo '"\u0003"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u0003"'\''|json -b 2'

echo '$ echo '\''"\u0003"'\''|json -b 3'
echo '"\u0003"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u0003"'\''|json -b 3'

echo '$ echo '\''"\u0003"'\''|json -b 4'
echo '"\u0003"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u0003"'\''|json -b 4'

echo '$ echo '\''"\u0003"'\''|json -b 5'
echo '"\u0003"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u0003"'\''|json -b 5'

echo '$ echo '\''"\u0003"'\''|json -b 6'
echo '"\u0003"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u0003"'\''|json -b 6'

echo '$ echo '\''"\u0003"'\''|json -b 7'
echo '"\u0003"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u0003"'\''|json -b 7'

echo '$ echo '\''"\u0003"'\''|json -b 8'
echo '"\u0003"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u0003"'\''|json -b 8'

echo '$ echo '\''"\u0004"'\''|json -b 1'
echo '"\u0004"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u0004"'\''|json -b 1'

echo '$ echo '\''"\u0004"'\''|json -b 2'
echo '"\u0004"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u0004"'\''|json -b 2'

echo '$ echo '\''"\u0004"'\''|json -b 3'
echo '"\u0004"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u0004"'\''|json -b 3'

echo '$ echo '\''"\u0004"'\''|json -b 4'
echo '"\u0004"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u0004"'\''|json -b 4'

echo '$ echo '\''"\u0004"'\''|json -b 5'
echo '"\u0004"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u0004"'\''|json -b 5'

echo '$ echo '\''"\u0004"'\''|json -b 6'
echo '"\u0004"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u0004"'\''|json -b 6'

echo '$ echo '\''"\u0004"'\''|json -b 7'
echo '"\u0004"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u0004"'\''|json -b 7'

echo '$ echo '\''"\u0004"'\''|json -b 8'
echo '"\u0004"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u0004"'\''|json -b 8'

echo '$ echo '\''"\u0005"'\''|json -b 1'
echo '"\u0005"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u0005"'\''|json -b 1'

echo '$ echo '\''"\u0005"'\''|json -b 2'
echo '"\u0005"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u0005"'\''|json -b 2'

echo '$ echo '\''"\u0005"'\''|json -b 3'
echo '"\u0005"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u0005"'\''|json -b 3'

echo '$ echo '\''"\u0005"'\''|json -b 4'
echo '"\u0005"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u0005"'\''|json -b 4'

echo '$ echo '\''"\u0005"'\''|json -b 5'
echo '"\u0005"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u0005"'\''|json -b 5'

echo '$ echo '\''"\u0005"'\''|json -b 6'
echo '"\u0005"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u0005"'\''|json -b 6'

echo '$ echo '\''"\u0005"'\''|json -b 7'
echo '"\u0005"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u0005"'\''|json -b 7'

echo '$ echo '\''"\u0005"'\''|json -b 8'
echo '"\u0005"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u0005"'\''|json -b 8'

echo '$ echo '\''"\u0006"'\''|json -b 1'
echo '"\u0006"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u0006"'\''|json -b 1'

echo '$ echo '\''"\u0006"'\''|json -b 2'
echo '"\u0006"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u0006"'\''|json -b 2'

echo '$ echo '\''"\u0006"'\''|json -b 3'
echo '"\u0006"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u0006"'\''|json -b 3'

echo '$ echo '\''"\u0006"'\''|json -b 4'
echo '"\u0006"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u0006"'\''|json -b 4'

echo '$ echo '\''"\u0006"'\''|json -b 5'
echo '"\u0006"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u0006"'\''|json -b 5'

echo '$ echo '\''"\u0006"'\''|json -b 6'
echo '"\u0006"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u0006"'\''|json -b 6'

echo '$ echo '\''"\u0006"'\''|json -b 7'
echo '"\u0006"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u0006"'\''|json -b 7'

echo '$ echo '\''"\u0006"'\''|json -b 8'
echo '"\u0006"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u0006"'\''|json -b 8'

echo '$ echo '\''"\u0007"'\''|json -b 1'
echo '"\u0007"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u0007"'\''|json -b 1'

echo '$ echo '\''"\u0007"'\''|json -b 2'
echo '"\u0007"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u0007"'\''|json -b 2'

echo '$ echo '\''"\u0007"'\''|json -b 3'
echo '"\u0007"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u0007"'\''|json -b 3'

echo '$ echo '\''"\u0007"'\''|json -b 4'
echo '"\u0007"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u0007"'\''|json -b 4'

echo '$ echo '\''"\u0007"'\''|json -b 5'
echo '"\u0007"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u0007"'\''|json -b 5'

echo '$ echo '\''"\u0007"'\''|json -b 6'
echo '"\u0007"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u0007"'\''|json -b 6'

echo '$ echo '\''"\u0007"'\''|json -b 7'
echo '"\u0007"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u0007"'\''|json -b 7'

echo '$ echo '\''"\u0007"'\''|json -b 8'
echo '"\u0007"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u0007"'\''|json -b 8'

echo '$ echo '\''"\u0008"'\''|json -b 1'
echo '"\u0008"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u0008"'\''|json -b 1'

echo '$ echo '\''"\u0008"'\''|json -b 2'
echo '"\u0008"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u0008"'\''|json -b 2'

echo '$ echo '\''"\u0008"'\''|json -b 3'
echo '"\u0008"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u0008"'\''|json -b 3'

echo '$ echo '\''"\u0008"'\''|json -b 4'
echo '"\u0008"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u0008"'\''|json -b 4'

echo '$ echo '\''"\u0008"'\''|json -b 5'
echo '"\u0008"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u0008"'\''|json -b 5'

echo '$ echo '\''"\u0008"'\''|json -b 6'
echo '"\u0008"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u0008"'\''|json -b 6'

echo '$ echo '\''"\u0008"'\''|json -b 7'
echo '"\u0008"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u0008"'\''|json -b 7'

echo '$ echo '\''"\u0008"'\''|json -b 8'
echo '"\u0008"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u0008"'\''|json -b 8'

echo '$ echo '\''"\u0009"'\''|json -b 1'
echo '"\u0009"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u0009"'\''|json -b 1'

echo '$ echo '\''"\u0009"'\''|json -b 2'
echo '"\u0009"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u0009"'\''|json -b 2'

echo '$ echo '\''"\u0009"'\''|json -b 3'
echo '"\u0009"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u0009"'\''|json -b 3'

echo '$ echo '\''"\u0009"'\''|json -b 4'
echo '"\u0009"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u0009"'\''|json -b 4'

echo '$ echo '\''"\u0009"'\''|json -b 5'
echo '"\u0009"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u0009"'\''|json -b 5'

echo '$ echo '\''"\u0009"'\''|json -b 6'
echo '"\u0009"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u0009"'\''|json -b 6'

echo '$ echo '\''"\u0009"'\''|json -b 7'
echo '"\u0009"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u0009"'\''|json -b 7'

echo '$ echo '\''"\u0009"'\''|json -b 8'
echo '"\u0009"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u0009"'\''|json -b 8'

echo '$ echo '\''"\u000a"'\''|json -b 1'
echo '"\u000a"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u000a"'\''|json -b 1'

echo '$ echo '\''"\u000a"'\''|json -b 2'
echo '"\u000a"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u000a"'\''|json -b 2'

echo '$ echo '\''"\u000a"'\''|json -b 3'
echo '"\u000a"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u000a"'\''|json -b 3'

echo '$ echo '\''"\u000a"'\''|json -b 4'
echo '"\u000a"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u000a"'\''|json -b 4'

echo '$ echo '\''"\u000a"'\''|json -b 5'
echo '"\u000a"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u000a"'\''|json -b 5'

echo '$ echo '\''"\u000a"'\''|json -b 6'
echo '"\u000a"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u000a"'\''|json -b 6'

echo '$ echo '\''"\u000a"'\''|json -b 7'
echo '"\u000a"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u000a"'\''|json -b 7'

echo '$ echo '\''"\u000a"'\''|json -b 8'
echo '"\u000a"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u000a"'\''|json -b 8'

echo '$ echo '\''"\u000b"'\''|json -b 1'
echo '"\u000b"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u000b"'\''|json -b 1'

echo '$ echo '\''"\u000b"'\''|json -b 2'
echo '"\u000b"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u000b"'\''|json -b 2'

echo '$ echo '\''"\u000b"'\''|json -b 3'
echo '"\u000b"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u000b"'\''|json -b 3'

echo '$ echo '\''"\u000b"'\''|json -b 4'
echo '"\u000b"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u000b"'\''|json -b 4'

echo '$ echo '\''"\u000b"'\''|json -b 5'
echo '"\u000b"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u000b"'\''|json -b 5'

echo '$ echo '\''"\u000b"'\''|json -b 6'
echo '"\u000b"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u000b"'\''|json -b 6'

echo '$ echo '\''"\u000b"'\''|json -b 7'
echo '"\u000b"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u000b"'\''|json -b 7'

echo '$ echo '\''"\u000b"'\''|json -b 8'
echo '"\u000b"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u000b"'\''|json -b 8'

echo '$ echo '\''"\u000c"'\''|json -b 1'
echo '"\u000c"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u000c"'\''|json -b 1'

echo '$ echo '\''"\u000c"'\''|json -b 2'
echo '"\u000c"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u000c"'\''|json -b 2'

echo '$ echo '\''"\u000c"'\''|json -b 3'
echo '"\u000c"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u000c"'\''|json -b 3'

echo '$ echo '\''"\u000c"'\''|json -b 4'
echo '"\u000c"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u000c"'\''|json -b 4'

echo '$ echo '\''"\u000c"'\''|json -b 5'
echo '"\u000c"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u000c"'\''|json -b 5'

echo '$ echo '\''"\u000c"'\''|json -b 6'
echo '"\u000c"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u000c"'\''|json -b 6'

echo '$ echo '\''"\u000c"'\''|json -b 7'
echo '"\u000c"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u000c"'\''|json -b 7'

echo '$ echo '\''"\u000c"'\''|json -b 8'
echo '"\u000c"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u000c"'\''|json -b 8'

echo '$ echo '\''"\u000d"'\''|json -b 1'
echo '"\u000d"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u000d"'\''|json -b 1'

echo '$ echo '\''"\u000d"'\''|json -b 2'
echo '"\u000d"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u000d"'\''|json -b 2'

echo '$ echo '\''"\u000d"'\''|json -b 3'
echo '"\u000d"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u000d"'\''|json -b 3'

echo '$ echo '\''"\u000d"'\''|json -b 4'
echo '"\u000d"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u000d"'\''|json -b 4'

echo '$ echo '\''"\u000d"'\''|json -b 5'
echo '"\u000d"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u000d"'\''|json -b 5'

echo '$ echo '\''"\u000d"'\''|json -b 6'
echo '"\u000d"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u000d"'\''|json -b 6'

echo '$ echo '\''"\u000d"'\''|json -b 7'
echo '"\u000d"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u000d"'\''|json -b 7'

echo '$ echo '\''"\u000d"'\''|json -b 8'
echo '"\u000d"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u000d"'\''|json -b 8'

echo '$ echo '\''"\u000e"'\''|json -b 1'
echo '"\u000e"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u000e"'\''|json -b 1'

echo '$ echo '\''"\u000e"'\''|json -b 2'
echo '"\u000e"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u000e"'\''|json -b 2'

echo '$ echo '\''"\u000e"'\''|json -b 3'
echo '"\u000e"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u000e"'\''|json -b 3'

echo '$ echo '\''"\u000e"'\''|json -b 4'
echo '"\u000e"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u000e"'\''|json -b 4'

echo '$ echo '\''"\u000e"'\''|json -b 5'
echo '"\u000e"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u000e"'\''|json -b 5'

echo '$ echo '\''"\u000e"'\''|json -b 6'
echo '"\u000e"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u000e"'\''|json -b 6'

echo '$ echo '\''"\u000e"'\''|json -b 7'
echo '"\u000e"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u000e"'\''|json -b 7'

echo '$ echo '\''"\u000e"'\''|json -b 8'
echo '"\u000e"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u000e"'\''|json -b 8'

echo '$ echo '\''"\u000f"'\''|json -b 1'
echo '"\u000f"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u000f"'\''|json -b 1'

echo '$ echo '\''"\u000f"'\''|json -b 2'
echo '"\u000f"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u000f"'\''|json -b 2'

echo '$ echo '\''"\u000f"'\''|json -b 3'
echo '"\u000f"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u000f"'\''|json -b 3'

echo '$ echo '\''"\u000f"'\''|json -b 4'
echo '"\u000f"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u000f"'\''|json -b 4'

echo '$ echo '\''"\u000f"'\''|json -b 5'
echo '"\u000f"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u000f"'\''|json -b 5'

echo '$ echo '\''"\u000f"'\''|json -b 6'
echo '"\u000f"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u000f"'\''|json -b 6'

echo '$ echo '\''"\u000f"'\''|json -b 7'
echo '"\u000f"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u000f"'\''|json -b 7'

echo '$ echo '\''"\u000f"'\''|json -b 8'
echo '"\u000f"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u000f"'\''|json -b 8'

echo '$ echo '\''"\u0010"'\''|json -b 1'
echo '"\u0010"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u0010"'\''|json -b 1'

echo '$ echo '\''"\u0010"'\''|json -b 2'
echo '"\u0010"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u0010"'\''|json -b 2'

echo '$ echo '\''"\u0010"'\''|json -b 3'
echo '"\u0010"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u0010"'\''|json -b 3'

echo '$ echo '\''"\u0010"'\''|json -b 4'
echo '"\u0010"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u0010"'\''|json -b 4'

echo '$ echo '\''"\u0010"'\''|json -b 5'
echo '"\u0010"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u0010"'\''|json -b 5'

echo '$ echo '\''"\u0010"'\''|json -b 6'
echo '"\u0010"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u0010"'\''|json -b 6'

echo '$ echo '\''"\u0010"'\''|json -b 7'
echo '"\u0010"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u0010"'\''|json -b 7'

echo '$ echo '\''"\u0010"'\''|json -b 8'
echo '"\u0010"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u0010"'\''|json -b 8'

echo '$ echo '\''"\u0011"'\''|json -b 1'
echo '"\u0011"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u0011"'\''|json -b 1'

echo '$ echo '\''"\u0011"'\''|json -b 2'
echo '"\u0011"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u0011"'\''|json -b 2'

echo '$ echo '\''"\u0011"'\''|json -b 3'
echo '"\u0011"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u0011"'\''|json -b 3'

echo '$ echo '\''"\u0011"'\''|json -b 4'
echo '"\u0011"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u0011"'\''|json -b 4'

echo '$ echo '\''"\u0011"'\''|json -b 5'
echo '"\u0011"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u0011"'\''|json -b 5'

echo '$ echo '\''"\u0011"'\''|json -b 6'
echo '"\u0011"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u0011"'\''|json -b 6'

echo '$ echo '\''"\u0011"'\''|json -b 7'
echo '"\u0011"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u0011"'\''|json -b 7'

echo '$ echo '\''"\u0011"'\''|json -b 8'
echo '"\u0011"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u0011"'\''|json -b 8'

echo '$ echo '\''"\u0012"'\''|json -b 1'
echo '"\u0012"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u0012"'\''|json -b 1'

echo '$ echo '\''"\u0012"'\''|json -b 2'
echo '"\u0012"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u0012"'\''|json -b 2'

echo '$ echo '\''"\u0012"'\''|json -b 3'
echo '"\u0012"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u0012"'\''|json -b 3'

echo '$ echo '\''"\u0012"'\''|json -b 4'
echo '"\u0012"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u0012"'\''|json -b 4'

echo '$ echo '\''"\u0012"'\''|json -b 5'
echo '"\u0012"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u0012"'\''|json -b 5'

echo '$ echo '\''"\u0012"'\''|json -b 6'
echo '"\u0012"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u0012"'\''|json -b 6'

echo '$ echo '\''"\u0012"'\''|json -b 7'
echo '"\u0012"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u0012"'\''|json -b 7'

echo '$ echo '\''"\u0012"'\''|json -b 8'
echo '"\u0012"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u0012"'\''|json -b 8'

echo '$ echo '\''"\u0013"'\''|json -b 1'
echo '"\u0013"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u0013"'\''|json -b 1'

echo '$ echo '\''"\u0013"'\''|json -b 2'
echo '"\u0013"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u0013"'\''|json -b 2'

echo '$ echo '\''"\u0013"'\''|json -b 3'
echo '"\u0013"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u0013"'\''|json -b 3'

echo '$ echo '\''"\u0013"'\''|json -b 4'
echo '"\u0013"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u0013"'\''|json -b 4'

echo '$ echo '\''"\u0013"'\''|json -b 5'
echo '"\u0013"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u0013"'\''|json -b 5'

echo '$ echo '\''"\u0013"'\''|json -b 6'
echo '"\u0013"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u0013"'\''|json -b 6'

echo '$ echo '\''"\u0013"'\''|json -b 7'
echo '"\u0013"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u0013"'\''|json -b 7'

echo '$ echo '\''"\u0013"'\''|json -b 8'
echo '"\u0013"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u0013"'\''|json -b 8'

echo '$ echo '\''"\u0014"'\''|json -b 1'
echo '"\u0014"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u0014"'\''|json -b 1'

echo '$ echo '\''"\u0014"'\''|json -b 2'
echo '"\u0014"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u0014"'\''|json -b 2'

echo '$ echo '\''"\u0014"'\''|json -b 3'
echo '"\u0014"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u0014"'\''|json -b 3'

echo '$ echo '\''"\u0014"'\''|json -b 4'
echo '"\u0014"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u0014"'\''|json -b 4'

echo '$ echo '\''"\u0014"'\''|json -b 5'
echo '"\u0014"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u0014"'\''|json -b 5'

echo '$ echo '\''"\u0014"'\''|json -b 6'
echo '"\u0014"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u0014"'\''|json -b 6'

echo '$ echo '\''"\u0014"'\''|json -b 7'
echo '"\u0014"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u0014"'\''|json -b 7'

echo '$ echo '\''"\u0014"'\''|json -b 8'
echo '"\u0014"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u0014"'\''|json -b 8'

echo '$ echo '\''"\u0015"'\''|json -b 1'
echo '"\u0015"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u0015"'\''|json -b 1'

echo '$ echo '\''"\u0015"'\''|json -b 2'
echo '"\u0015"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u0015"'\''|json -b 2'

echo '$ echo '\''"\u0015"'\''|json -b 3'
echo '"\u0015"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u0015"'\''|json -b 3'

echo '$ echo '\''"\u0015"'\''|json -b 4'
echo '"\u0015"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u0015"'\''|json -b 4'

echo '$ echo '\''"\u0015"'\''|json -b 5'
echo '"\u0015"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u0015"'\''|json -b 5'

echo '$ echo '\''"\u0015"'\''|json -b 6'
echo '"\u0015"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u0015"'\''|json -b 6'

echo '$ echo '\''"\u0015"'\''|json -b 7'
echo '"\u0015"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u0015"'\''|json -b 7'

echo '$ echo '\''"\u0015"'\''|json -b 8'
echo '"\u0015"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u0015"'\''|json -b 8'

echo '$ echo '\''"\u0016"'\''|json -b 1'
echo '"\u0016"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u0016"'\''|json -b 1'

echo '$ echo '\''"\u0016"'\''|json -b 2'
echo '"\u0016"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u0016"'\''|json -b 2'

echo '$ echo '\''"\u0016"'\''|json -b 3'
echo '"\u0016"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u0016"'\''|json -b 3'

echo '$ echo '\''"\u0016"'\''|json -b 4'
echo '"\u0016"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u0016"'\''|json -b 4'

echo '$ echo '\''"\u0016"'\''|json -b 5'
echo '"\u0016"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u0016"'\''|json -b 5'

echo '$ echo '\''"\u0016"'\''|json -b 6'
echo '"\u0016"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u0016"'\''|json -b 6'

echo '$ echo '\''"\u0016"'\''|json -b 7'
echo '"\u0016"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u0016"'\''|json -b 7'

echo '$ echo '\''"\u0016"'\''|json -b 8'
echo '"\u0016"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u0016"'\''|json -b 8'

echo '$ echo '\''"\u0017"'\''|json -b 1'
echo '"\u0017"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u0017"'\''|json -b 1'

echo '$ echo '\''"\u0017"'\''|json -b 2'
echo '"\u0017"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u0017"'\''|json -b 2'

echo '$ echo '\''"\u0017"'\''|json -b 3'
echo '"\u0017"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u0017"'\''|json -b 3'

echo '$ echo '\''"\u0017"'\''|json -b 4'
echo '"\u0017"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u0017"'\''|json -b 4'

echo '$ echo '\''"\u0017"'\''|json -b 5'
echo '"\u0017"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u0017"'\''|json -b 5'

echo '$ echo '\''"\u0017"'\''|json -b 6'
echo '"\u0017"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u0017"'\''|json -b 6'

echo '$ echo '\''"\u0017"'\''|json -b 7'
echo '"\u0017"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u0017"'\''|json -b 7'

echo '$ echo '\''"\u0017"'\''|json -b 8'
echo '"\u0017"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u0017"'\''|json -b 8'

echo '$ echo '\''"\u0018"'\''|json -b 1'
echo '"\u0018"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u0018"'\''|json -b 1'

echo '$ echo '\''"\u0018"'\''|json -b 2'
echo '"\u0018"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u0018"'\''|json -b 2'

echo '$ echo '\''"\u0018"'\''|json -b 3'
echo '"\u0018"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u0018"'\''|json -b 3'

echo '$ echo '\''"\u0018"'\''|json -b 4'
echo '"\u0018"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u0018"'\''|json -b 4'

echo '$ echo '\''"\u0018"'\''|json -b 5'
echo '"\u0018"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u0018"'\''|json -b 5'

echo '$ echo '\''"\u0018"'\''|json -b 6'
echo '"\u0018"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u0018"'\''|json -b 6'

echo '$ echo '\''"\u0018"'\''|json -b 7'
echo '"\u0018"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u0018"'\''|json -b 7'

echo '$ echo '\''"\u0018"'\''|json -b 8'
echo '"\u0018"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u0018"'\''|json -b 8'

echo '$ echo '\''"\u0019"'\''|json -b 1'
echo '"\u0019"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u0019"'\''|json -b 1'

echo '$ echo '\''"\u0019"'\''|json -b 2'
echo '"\u0019"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u0019"'\''|json -b 2'

echo '$ echo '\''"\u0019"'\''|json -b 3'
echo '"\u0019"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u0019"'\''|json -b 3'

echo '$ echo '\''"\u0019"'\''|json -b 4'
echo '"\u0019"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u0019"'\''|json -b 4'

echo '$ echo '\''"\u0019"'\''|json -b 5'
echo '"\u0019"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u0019"'\''|json -b 5'

echo '$ echo '\''"\u0019"'\''|json -b 6'
echo '"\u0019"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u0019"'\''|json -b 6'

echo '$ echo '\''"\u0019"'\''|json -b 7'
echo '"\u0019"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u0019"'\''|json -b 7'

echo '$ echo '\''"\u0019"'\''|json -b 8'
echo '"\u0019"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u0019"'\''|json -b 8'

echo '$ echo '\''"\u001a"'\''|json -b 1'
echo '"\u001a"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u001a"'\''|json -b 1'

echo '$ echo '\''"\u001a"'\''|json -b 2'
echo '"\u001a"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u001a"'\''|json -b 2'

echo '$ echo '\''"\u001a"'\''|json -b 3'
echo '"\u001a"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u001a"'\''|json -b 3'

echo '$ echo '\''"\u001a"'\''|json -b 4'
echo '"\u001a"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u001a"'\''|json -b 4'

echo '$ echo '\''"\u001a"'\''|json -b 5'
echo '"\u001a"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u001a"'\''|json -b 5'

echo '$ echo '\''"\u001a"'\''|json -b 6'
echo '"\u001a"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u001a"'\''|json -b 6'

echo '$ echo '\''"\u001a"'\''|json -b 7'
echo '"\u001a"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u001a"'\''|json -b 7'

echo '$ echo '\''"\u001a"'\''|json -b 8'
echo '"\u001a"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u001a"'\''|json -b 8'

echo '$ echo '\''"\u001b"'\''|json -b 1'
echo '"\u001b"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u001b"'\''|json -b 1'

echo '$ echo '\''"\u001b"'\''|json -b 2'
echo '"\u001b"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u001b"'\''|json -b 2'

echo '$ echo '\''"\u001b"'\''|json -b 3'
echo '"\u001b"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u001b"'\''|json -b 3'

echo '$ echo '\''"\u001b"'\''|json -b 4'
echo '"\u001b"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u001b"'\''|json -b 4'

echo '$ echo '\''"\u001b"'\''|json -b 5'
echo '"\u001b"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u001b"'\''|json -b 5'

echo '$ echo '\''"\u001b"'\''|json -b 6'
echo '"\u001b"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u001b"'\''|json -b 6'

echo '$ echo '\''"\u001b"'\''|json -b 7'
echo '"\u001b"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u001b"'\''|json -b 7'

echo '$ echo '\''"\u001b"'\''|json -b 8'
echo '"\u001b"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u001b"'\''|json -b 8'

echo '$ echo '\''"\u001c"'\''|json -b 1'
echo '"\u001c"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u001c"'\''|json -b 1'

echo '$ echo '\''"\u001c"'\''|json -b 2'
echo '"\u001c"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u001c"'\''|json -b 2'

echo '$ echo '\''"\u001c"'\''|json -b 3'
echo '"\u001c"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u001c"'\''|json -b 3'

echo '$ echo '\''"\u001c"'\''|json -b 4'
echo '"\u001c"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u001c"'\''|json -b 4'

echo '$ echo '\''"\u001c"'\''|json -b 5'
echo '"\u001c"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u001c"'\''|json -b 5'

echo '$ echo '\''"\u001c"'\''|json -b 6'
echo '"\u001c"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u001c"'\''|json -b 6'

echo '$ echo '\''"\u001c"'\''|json -b 7'
echo '"\u001c"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u001c"'\''|json -b 7'

echo '$ echo '\''"\u001c"'\''|json -b 8'
echo '"\u001c"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u001c"'\''|json -b 8'

echo '$ echo '\''"\u001d"'\''|json -b 1'
echo '"\u001d"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u001d"'\''|json -b 1'

echo '$ echo '\''"\u001d"'\''|json -b 2'
echo '"\u001d"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u001d"'\''|json -b 2'

echo '$ echo '\''"\u001d"'\''|json -b 3'
echo '"\u001d"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u001d"'\''|json -b 3'

echo '$ echo '\''"\u001d"'\''|json -b 4'
echo '"\u001d"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u001d"'\''|json -b 4'

echo '$ echo '\''"\u001d"'\''|json -b 5'
echo '"\u001d"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u001d"'\''|json -b 5'

echo '$ echo '\''"\u001d"'\''|json -b 6'
echo '"\u001d"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u001d"'\''|json -b 6'

echo '$ echo '\''"\u001d"'\''|json -b 7'
echo '"\u001d"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u001d"'\''|json -b 7'

echo '$ echo '\''"\u001d"'\''|json -b 8'
echo '"\u001d"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u001d"'\''|json -b 8'

echo '$ echo '\''"\u001e"'\''|json -b 1'
echo '"\u001e"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u001e"'\''|json -b 1'

echo '$ echo '\''"\u001e"'\''|json -b 2'
echo '"\u001e"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u001e"'\''|json -b 2'

echo '$ echo '\''"\u001e"'\''|json -b 3'
echo '"\u001e"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u001e"'\''|json -b 3'

echo '$ echo '\''"\u001e"'\''|json -b 4'
echo '"\u001e"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u001e"'\''|json -b 4'

echo '$ echo '\''"\u001e"'\''|json -b 5'
echo '"\u001e"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u001e"'\''|json -b 5'

echo '$ echo '\''"\u001e"'\''|json -b 6'
echo '"\u001e"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u001e"'\''|json -b 6'

echo '$ echo '\''"\u001e"'\''|json -b 7'
echo '"\u001e"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u001e"'\''|json -b 7'

echo '$ echo '\''"\u001e"'\''|json -b 8'
echo '"\u001e"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u001e"'\''|json -b 8'

echo '$ echo '\''"\u001f"'\''|json -b 1'
echo '"\u001f"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\u001f"'\''|json -b 1'

echo '$ echo '\''"\u001f"'\''|json -b 2'
echo '"\u001f"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\u001f"'\''|json -b 2'

echo '$ echo '\''"\u001f"'\''|json -b 3'
echo '"\u001f"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\u001f"'\''|json -b 3'

echo '$ echo '\''"\u001f"'\''|json -b 4'
echo '"\u001f"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\u001f"'\''|json -b 4'

echo '$ echo '\''"\u001f"'\''|json -b 5'
echo '"\u001f"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\u001f"'\''|json -b 5'

echo '$ echo '\''"\u001f"'\''|json -b 6'
echo '"\u001f"'|json -b 6 2>&1 ||
echo 'command failed: echo '\''"\u001f"'\''|json -b 6'

echo '$ echo '\''"\u001f"'\''|json -b 7'
echo '"\u001f"'|json -b 7 2>&1 ||
echo 'command failed: echo '\''"\u001f"'\''|json -b 7'

echo '$ echo '\''"\u001f"'\''|json -b 8'
echo '"\u001f"'|json -b 8 2>&1 ||
echo 'command failed: echo '\''"\u001f"'\''|json -b 8'
)

