#!/bin/bash

# Copyright (C) 2016, 2017  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker:closed-array-list7
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L closed-array-list7.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"type"]}]}'\'' <<< '\''[null]'\''
[null]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"type"]}]}'\'' <<< '\''[false]'\''
[false]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"type"]}]}'\'' <<< '\''[true]'\''
[true]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"type"]}]}'\'' <<< '\''[123]'\''
[123]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"type"]}]}'\'' <<< '\''[456]'\''
[456]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"type"]}]}'\'' <<< '\''["bar"]'\''
["bar"]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"type"]}]}'\'' <<< '\''["baz"]'\''
["baz"]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"type"]}]}'\'' <<< '\''[{}]'\''
[{}]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"type"]}]}'\'' <<< '\''[[]]'\''
[[]]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"type"]}]}'\'' <<< '\''[null]'\''
[null]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"type"]}]}'\'' <<< '\''[false]'\''
[false]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"type"]}]}'\'' <<< '\''[true]'\''
[true]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"type"]}]}'\'' <<< '\''[123]'\''
[123]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"type"]}]}'\'' <<< '\''[456]'\''
[456]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"type"]}]}'\'' <<< '\''["bar"]'\''
["bar"]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"type"]}]}'\'' <<< '\''["baz"]'\''
["baz"]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"type"]}]}'\'' <<< '\''[{}]'\''
[{}]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"type"]}]}'\'' <<< '\''[[]]'\''
[[]]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"type"]}]}'\'' <<< '\''[null]'\''
[null]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"type"]}]}'\'' <<< '\''[false]'\''
[false]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"type"]}]}'\'' <<< '\''[true]'\''
[true]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"type"]}]}'\'' <<< '\''[123]'\''
[123]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"type"]}]}'\'' <<< '\''[456]'\''
[456]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"type"]}]}'\'' <<< '\''["bar"]'\''
["bar"]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"type"]}]}'\'' <<< '\''["baz"]'\''
["baz"]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"type"]}]}'\'' <<< '\''[{}]'\''
[{}]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"type"]}]}'\'' <<< '\''[[]]'\''
[[]]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"type"]}]}'\'' <<< '\''[null]'\''
[null]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"type"]}]}'\'' <<< '\''[false]'\''
[false]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"type"]}]}'\'' <<< '\''[true]'\''
[true]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"type"]}]}'\'' <<< '\''[123]'\''
[123]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"type"]}]}'\'' <<< '\''[456]'\''
[456]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"type"]}]}'\'' <<< '\''["bar"]'\''
["bar"]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"type"]}]}'\'' <<< '\''["baz"]'\''
["baz"]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"type"]}]}'\'' <<< '\''[{}]'\''
[{}]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"type"]}]}'\'' <<< '\''[[]]'\''
[[]]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"type"]}]}'\'' <<< '\''[null]'\''
[null]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"type"]}]}'\'' <<< '\''[false]'\''
[false]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"type"]}]}'\'' <<< '\''[true]'\''
[true]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"type"]}]}'\'' <<< '\''[123]'\''
[123]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"type"]}]}'\'' <<< '\''[456]'\''
[456]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"type"]}]}'\'' <<< '\''["bar"]'\''
["bar"]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"type"]}]}'\'' <<< '\''["baz"]'\''
["baz"]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"type"]}]}'\'' <<< '\''[{}]'\''
[{}]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"type"]}]}'\'' <<< '\''[[]]'\''
[[]]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"null"]}]}'\'' <<< '\''[null]'\''
[null]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"null"]}]}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"null"]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"null"]}]}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"null"]}]}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"null"]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"null"]}]}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"null"]}]}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"null"]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"null"]}]}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"null"]}]}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"null"]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"null"]}]}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"null"]}]}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"null"]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"null"]}]}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"null"]}]}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"null"]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"null"]}]}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"null"]}]}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"null"]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"null"]}]}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"null"]}]}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"null"]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"null"]}]}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"null"]}]}'\'' <<< '\''[null]'\''
[null]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"null"]}]}'\'' <<< '\''[false]'\''
[false]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"null"]}]}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"null"]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"null"]}]}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"null"]}]}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"null"]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"null"]}]}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"null"]}]}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"null"]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"null"]}]}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"null"]}]}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"null"]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"null"]}]}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"null"]}]}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"null"]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"null"]}]}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"null"]}]}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"null"]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"null"]}]}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"null"]}]}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"null"]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"null"]}]}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"null"]}]}'\'' <<< '\''[null]'\''
[null]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"null"]}]}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"null"]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"null"]}]}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"null"]}]}'\'' <<< '\''[true]'\''
[true]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"null"]}]}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"null"]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"null"]}]}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"null"]}]}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"null"]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"null"]}]}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"null"]}]}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"null"]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"null"]}]}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"null"]}]}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"null"]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"null"]}]}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"null"]}]}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"null"]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"null"]}]}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"null"]}]}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"null"]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"null"]}]}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"null"]}]}'\'' <<< '\''[null]'\''
[null]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"null"]}]}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"null"]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"null"]}]}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"null"]}]}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"null"]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"null"]}]}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"null"]}]}'\'' <<< '\''[123]'\''
[123]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"null"]}]}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"null"]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"null"]}]}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"null"]}]}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"null"]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"null"]}]}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"null"]}]}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"null"]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"null"]}]}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"null"]}]}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"null"]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"null"]}]}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"null"]}]}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"null"]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"null"]}]}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"null"]}]}'\'' <<< '\''[null]'\''
[null]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"null"]}]}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"null"]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"null"]}]}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"null"]}]}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"null"]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"null"]}]}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"null"]}]}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"null"]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"null"]}]}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"null"]}]}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"null"]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"null"]}]}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"null"]}]}'\'' <<< '\''["bar"]'\''
["bar"]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"null"]}]}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"null"]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"null"]}]}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"null"]}]}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"null"]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"null"]}]}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"null"]}]}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"null"]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"null"]}]}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"boolean"]}]}'\'' <<< '\''[null]'\''
[null]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"boolean"]}]}'\'' <<< '\''[false]'\''
[false]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"boolean"]}]}'\'' <<< '\''[true]'\''
[true]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"boolean"]}]}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"boolean"]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"boolean"]}]}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"boolean"]}]}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"boolean"]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"boolean"]}]}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"boolean"]}]}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"boolean"]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"boolean"]}]}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"boolean"]}]}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"boolean"]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"boolean"]}]}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"boolean"]}]}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"boolean"]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"boolean"]}]}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"boolean"]}]}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"boolean"]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"boolean"]}]}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"boolean"]}]}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"boolean"]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"boolean"]}]}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"boolean"]}]}'\'' <<< '\''[false]'\''
[false]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"boolean"]}]}'\'' <<< '\''[true]'\''
[true]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"boolean"]}]}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"boolean"]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"boolean"]}]}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"boolean"]}]}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"boolean"]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"boolean"]}]}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"boolean"]}]}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"boolean"]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"boolean"]}]}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"boolean"]}]}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"boolean"]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"boolean"]}]}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"boolean"]}]}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"boolean"]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"boolean"]}]}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"boolean"]}]}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"boolean"]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"boolean"]}]}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"boolean"]}]}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"boolean"]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"boolean"]}]}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"boolean"]}]}'\'' <<< '\''[false]'\''
[false]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"boolean"]}]}'\'' <<< '\''[true]'\''
[true]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"boolean"]}]}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"boolean"]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"boolean"]}]}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"boolean"]}]}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"boolean"]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"boolean"]}]}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"boolean"]}]}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"boolean"]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"boolean"]}]}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"boolean"]}]}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"boolean"]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"boolean"]}]}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"boolean"]}]}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"boolean"]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"boolean"]}]}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"boolean"]}]}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"boolean"]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"boolean"]}]}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"boolean"]}]}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"boolean"]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"boolean"]}]}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"boolean"]}]}'\'' <<< '\''[false]'\''
[false]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"boolean"]}]}'\'' <<< '\''[true]'\''
[true]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"boolean"]}]}'\'' <<< '\''[123]'\''
[123]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"boolean"]}]}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"boolean"]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"boolean"]}]}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"boolean"]}]}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"boolean"]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"boolean"]}]}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"boolean"]}]}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"boolean"]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"boolean"]}]}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"boolean"]}]}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"boolean"]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"boolean"]}]}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"boolean"]}]}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"boolean"]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"boolean"]}]}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"boolean"]}]}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"boolean"]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"boolean"]}]}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"boolean"]}]}'\'' <<< '\''[false]'\''
[false]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"boolean"]}]}'\'' <<< '\''[true]'\''
[true]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"boolean"]}]}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"boolean"]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"boolean"]}]}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"boolean"]}]}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"boolean"]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"boolean"]}]}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"boolean"]}]}'\'' <<< '\''["bar"]'\''
["bar"]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"boolean"]}]}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"boolean"]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"boolean"]}]}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"boolean"]}]}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"boolean"]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"boolean"]}]}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"boolean"]}]}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"boolean"]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"boolean"]}]}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"number"]}]}'\'' <<< '\''[null]'\''
[null]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"number"]}]}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"number"]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"number"]}]}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"number"]}]}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"number"]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"number"]}]}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"number"]}]}'\'' <<< '\''[123]'\''
[123]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"number"]}]}'\'' <<< '\''[456]'\''
[456]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"number"]}]}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"number"]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"number"]}]}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"number"]}]}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"number"]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"number"]}]}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"number"]}]}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"number"]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"number"]}]}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"number"]}]}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"number"]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"number"]}]}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"number"]}]}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"number"]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"number"]}]}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"number"]}]}'\'' <<< '\''[false]'\''
[false]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"number"]}]}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"number"]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"number"]}]}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"number"]}]}'\'' <<< '\''[123]'\''
[123]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"number"]}]}'\'' <<< '\''[456]'\''
[456]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"number"]}]}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"number"]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"number"]}]}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"number"]}]}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"number"]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"number"]}]}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"number"]}]}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"number"]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"number"]}]}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"number"]}]}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"number"]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"number"]}]}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"number"]}]}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"number"]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"number"]}]}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"number"]}]}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"number"]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"number"]}]}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"number"]}]}'\'' <<< '\''[true]'\''
[true]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"number"]}]}'\'' <<< '\''[123]'\''
[123]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"number"]}]}'\'' <<< '\''[456]'\''
[456]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"number"]}]}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"number"]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"number"]}]}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"number"]}]}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"number"]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"number"]}]}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"number"]}]}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"number"]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"number"]}]}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"number"]}]}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"number"]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"number"]}]}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"number"]}]}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"number"]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"number"]}]}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"number"]}]}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"number"]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"number"]}]}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"number"]}]}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"number"]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"number"]}]}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"number"]}]}'\'' <<< '\''[123]'\''
[123]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"number"]}]}'\'' <<< '\''[456]'\''
[456]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"number"]}]}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"number"]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"number"]}]}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"number"]}]}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"number"]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"number"]}]}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"number"]}]}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"number"]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"number"]}]}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"number"]}]}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"number"]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"number"]}]}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"number"]}]}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"number"]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"number"]}]}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"number"]}]}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"number"]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"number"]}]}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"number"]}]}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"number"]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"number"]}]}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"number"]}]}'\'' <<< '\''[123]'\''
[123]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"number"]}]}'\'' <<< '\''[456]'\''
[456]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"number"]}]}'\'' <<< '\''["bar"]'\''
["bar"]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"number"]}]}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"number"]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"number"]}]}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"number"]}]}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"number"]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"number"]}]}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"number"]}]}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"number"]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"number"]}]}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"string"]}]}'\'' <<< '\''[null]'\''
[null]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"string"]}]}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"string"]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"string"]}]}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"string"]}]}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"string"]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"string"]}]}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"string"]}]}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"string"]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"string"]}]}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"string"]}]}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"string"]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"string"]}]}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"string"]}]}'\'' <<< '\''["bar"]'\''
["bar"]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"string"]}]}'\'' <<< '\''["baz"]'\''
["baz"]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"string"]}]}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"string"]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"string"]}]}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"string"]}]}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"string"]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"string"]}]}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"string"]}]}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"string"]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"string"]}]}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"string"]}]}'\'' <<< '\''[false]'\''
[false]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"string"]}]}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"string"]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"string"]}]}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"string"]}]}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"string"]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"string"]}]}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"string"]}]}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"string"]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"string"]}]}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"string"]}]}'\'' <<< '\''["bar"]'\''
["bar"]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"string"]}]}'\'' <<< '\''["baz"]'\''
["baz"]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"string"]}]}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"string"]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"string"]}]}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"string"]}]}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"string"]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"string"]}]}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"string"]}]}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"string"]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"string"]}]}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"string"]}]}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"string"]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"string"]}]}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"string"]}]}'\'' <<< '\''[true]'\''
[true]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"string"]}]}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"string"]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"string"]}]}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"string"]}]}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"string"]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"string"]}]}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"string"]}]}'\'' <<< '\''["bar"]'\''
["bar"]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"string"]}]}'\'' <<< '\''["baz"]'\''
["baz"]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"string"]}]}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"string"]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"string"]}]}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"string"]}]}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"string"]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"string"]}]}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"string"]}]}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"string"]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"string"]}]}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"string"]}]}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"string"]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"string"]}]}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"string"]}]}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"string"]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"string"]}]}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"string"]}]}'\'' <<< '\''[123]'\''
[123]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"string"]}]}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"string"]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"string"]}]}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"string"]}]}'\'' <<< '\''["bar"]'\''
["bar"]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"string"]}]}'\'' <<< '\''["baz"]'\''
["baz"]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"string"]}]}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"string"]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"string"]}]}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"string"]}]}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"string"]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"string"]}]}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"string"]}]}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"string"]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"string"]}]}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"string"]}]}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"string"]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"string"]}]}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"string"]}]}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"string"]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"string"]}]}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"string"]}]}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"string"]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"string"]}]}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"string"]}]}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"string"]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"string"]}]}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"string"]}]}'\'' <<< '\''["bar"]'\''
["bar"]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"string"]}]}'\'' <<< '\''["baz"]'\''
["baz"]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"string"]}]}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"string"]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"string"]}]}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"string"]}]}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"string"]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"string"]}]}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"object"]}]}'\'' <<< '\''[null]'\''
[null]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"object"]}]}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"object"]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"object"]}]}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"object"]}]}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"object"]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"object"]}]}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"object"]}]}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"object"]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"object"]}]}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"object"]}]}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"object"]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"object"]}]}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"object"]}]}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"object"]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"object"]}]}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"object"]}]}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"object"]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"object"]}]}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"object"]}]}'\'' <<< '\''[{}]'\''
[{}]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"object"]}]}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"object"]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"object"]}]}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"object"]}]}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"object"]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"object"]}]}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"object"]}]}'\'' <<< '\''[false]'\''
[false]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"object"]}]}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"object"]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"object"]}]}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"object"]}]}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"object"]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"object"]}]}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"object"]}]}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"object"]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"object"]}]}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"object"]}]}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"object"]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"object"]}]}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"object"]}]}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"object"]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"object"]}]}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"object"]}]}'\'' <<< '\''[{}]'\''
[{}]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"object"]}]}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"object"]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"object"]}]}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"object"]}]}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"object"]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"object"]}]}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"object"]}]}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"object"]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"object"]}]}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"object"]}]}'\'' <<< '\''[true]'\''
[true]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"object"]}]}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"object"]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"object"]}]}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"object"]}]}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"object"]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"object"]}]}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"object"]}]}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"object"]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"object"]}]}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"object"]}]}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"object"]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"object"]}]}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"object"]}]}'\'' <<< '\''[{}]'\''
[{}]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"object"]}]}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"object"]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"object"]}]}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"object"]}]}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"object"]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"object"]}]}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"object"]}]}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"object"]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"object"]}]}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"object"]}]}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"object"]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"object"]}]}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"object"]}]}'\'' <<< '\''[123]'\''
[123]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"object"]}]}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"object"]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"object"]}]}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"object"]}]}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"object"]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"object"]}]}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"object"]}]}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"object"]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"object"]}]}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"object"]}]}'\'' <<< '\''[{}]'\''
[{}]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"object"]}]}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"object"]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"object"]}]}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"object"]}]}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"object"]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"object"]}]}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"object"]}]}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"object"]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"object"]}]}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"object"]}]}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"object"]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"object"]}]}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"object"]}]}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"object"]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"object"]}]}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"object"]}]}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"object"]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"object"]}]}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"object"]}]}'\'' <<< '\''["bar"]'\''
["bar"]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"object"]}]}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"object"]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"object"]}]}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"object"]}]}'\'' <<< '\''[{}]'\''
[{}]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"object"]}]}'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"object"]}'\''
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"object"]}]}'\'' <<< '\''[[]]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"array"]}]}'\'' <<< '\''[null]'\''
[null]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"array"]}]}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"array"]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"array"]}]}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"array"]}]}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"array"]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"array"]}]}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"array"]}]}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"array"]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"array"]}]}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"array"]}]}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"array"]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"array"]}]}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"array"]}]}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"array"]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"array"]}]}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"array"]}]}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"array"]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"array"]}]}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"array"]}]}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":null},"array"]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"array"]}]}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"array"]}]}'\'' <<< '\''[[]]'\''
[[]]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"array"]}]}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"array"]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"array"]}]}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"array"]}]}'\'' <<< '\''[false]'\''
[false]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"array"]}]}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"array"]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"array"]}]}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"array"]}]}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"array"]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"array"]}]}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"array"]}]}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"array"]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"array"]}]}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"array"]}]}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"array"]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"array"]}]}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"array"]}]}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"array"]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"array"]}]}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"array"]}]}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":false},"array"]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"array"]}]}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"array"]}]}'\'' <<< '\''[[]]'\''
[[]]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"array"]}]}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"array"]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"array"]}]}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"array"]}]}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"array"]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"array"]}]}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"array"]}]}'\'' <<< '\''[true]'\''
[true]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"array"]}]}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"array"]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"array"]}]}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"array"]}]}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"array"]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"array"]}]}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"array"]}]}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"array"]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"array"]}]}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"array"]}]}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"array"]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"array"]}]}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"array"]}]}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":true},"array"]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"array"]}]}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"array"]}]}'\'' <<< '\''[[]]'\''
[[]]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"array"]}]}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"array"]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"array"]}]}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"array"]}]}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"array"]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"array"]}]}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"array"]}]}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"array"]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"array"]}]}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"array"]}]}'\'' <<< '\''[123]'\''
[123]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"array"]}]}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"array"]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"array"]}]}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"array"]}]}'\'' <<< '\''["bar"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"array"]}'\''
json: error: <stdin>:1:2: ["bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"array"]}]}'\'' <<< '\''["bar"]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"array"]}]}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"array"]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"array"]}]}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"array"]}]}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":123},"array"]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"array"]}]}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"array"]}]}'\'' <<< '\''[[]]'\''
[[]]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"array"]}]}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"array"]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"array"]}]}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"array"]}]}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"array"]}'\''
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"array"]}]}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"array"]}]}'\'' <<< '\''[true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"array"]}'\''
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"array"]}]}'\'' <<< '\''[true]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"array"]}]}'\'' <<< '\''[123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"array"]}'\''
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"array"]}]}'\'' <<< '\''[123]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"array"]}]}'\'' <<< '\''[456]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"array"]}'\''
json: error: <stdin>:1:2: [456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"array"]}]}'\'' <<< '\''[456]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"array"]}]}'\'' <<< '\''["bar"]'\''
["bar"]
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"array"]}]}'\'' <<< '\''["baz"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"array"]}'\''
json: error: <stdin>:1:2: ["baz"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"array"]}]}'\'' <<< '\''["baz"]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"array"]}]}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"plain":"bar"},"array"]}'\''
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"array"]}]}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"array"]}]}'\'' <<< '\''[[]]'\''
[[]]'
) -L closed-array-list7.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"type"]}]}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":null},"type"]}]}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"type"]}]}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"type"]}]}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":null},"type"]}]}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"type"]}]}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"type"]}]}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":null},"type"]}]}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"type"]}]}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"type"]}]}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":null},"type"]}]}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"type"]}]}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"type"]}]}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":null},"type"]}]}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"type"]}]}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"type"]}]}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":null},"type"]}]}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"type"]}]}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"type"]}]}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":null},"type"]}]}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"type"]}]}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"type"]}]}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":null},"type"]}]}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"type"]}]}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"type"]}]}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":null},"type"]}]}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"type"]}]}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"type"]}]}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":false},"type"]}]}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"type"]}]}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"type"]}]}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":false},"type"]}]}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"type"]}]}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"type"]}]}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":false},"type"]}]}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"type"]}]}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"type"]}]}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":false},"type"]}]}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"type"]}]}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"type"]}]}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":false},"type"]}]}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"type"]}]}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"type"]}]}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":false},"type"]}]}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"type"]}]}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"type"]}]}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":false},"type"]}]}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"type"]}]}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"type"]}]}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":false},"type"]}]}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"type"]}]}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"type"]}]}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":false},"type"]}]}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"type"]}]}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"type"]}]}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":true},"type"]}]}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"type"]}]}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"type"]}]}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":true},"type"]}]}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"type"]}]}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"type"]}]}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":true},"type"]}]}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"type"]}]}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"type"]}]}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":true},"type"]}]}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"type"]}]}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"type"]}]}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":true},"type"]}]}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"type"]}]}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"type"]}]}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":true},"type"]}]}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"type"]}]}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"type"]}]}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":true},"type"]}]}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"type"]}]}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"type"]}]}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":true},"type"]}]}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"type"]}]}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"type"]}]}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":true},"type"]}]}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"type"]}]}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"type"]}]}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":123},"type"]}]}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"type"]}]}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"type"]}]}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":123},"type"]}]}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"type"]}]}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"type"]}]}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":123},"type"]}]}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"type"]}]}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"type"]}]}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":123},"type"]}]}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"type"]}]}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"type"]}]}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":123},"type"]}]}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"type"]}]}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"type"]}]}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":123},"type"]}]}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"type"]}]}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"type"]}]}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":123},"type"]}]}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"type"]}]}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"type"]}]}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":123},"type"]}]}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"type"]}]}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"type"]}]}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":123},"type"]}]}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"type"]}]}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"type"]}]}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"type"]}]}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"type"]}]}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"type"]}]}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"type"]}]}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"type"]}]}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"type"]}]}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"type"]}]}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"type"]}]}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"type"]}]}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"type"]}]}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"type"]}]}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"type"]}]}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"type"]}]}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"type"]}]}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"type"]}]}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"type"]}]}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"type"]}]}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"type"]}]}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"type"]}]}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"type"]}]}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"type"]}]}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"type"]}]}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"type"]}]}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"type"]}]}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"type"]}]}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"type"]}]}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"null"]}]}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":null},"null"]}]}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"null"]}]}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"null"]}]}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":null},"null"]}]}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"null"]}]}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"null"]}]}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":null},"null"]}]}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"null"]}]}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"null"]}]}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":null},"null"]}]}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"null"]}]}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"null"]}]}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":null},"null"]}]}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"null"]}]}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"null"]}]}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":null},"null"]}]}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"null"]}]}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"null"]}]}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":null},"null"]}]}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"null"]}]}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"null"]}]}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":null},"null"]}]}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"null"]}]}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"null"]}]}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":null},"null"]}]}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"null"]}]}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"null"]}]}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":false},"null"]}]}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"null"]}]}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"null"]}]}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":false},"null"]}]}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"null"]}]}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"null"]}]}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":false},"null"]}]}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"null"]}]}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"null"]}]}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":false},"null"]}]}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"null"]}]}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"null"]}]}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":false},"null"]}]}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"null"]}]}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"null"]}]}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":false},"null"]}]}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"null"]}]}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"null"]}]}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":false},"null"]}]}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"null"]}]}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"null"]}]}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":false},"null"]}]}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"null"]}]}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"null"]}]}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":false},"null"]}]}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"null"]}]}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"null"]}]}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":true},"null"]}]}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"null"]}]}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"null"]}]}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":true},"null"]}]}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"null"]}]}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"null"]}]}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":true},"null"]}]}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"null"]}]}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"null"]}]}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":true},"null"]}]}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"null"]}]}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"null"]}]}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":true},"null"]}]}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"null"]}]}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"null"]}]}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":true},"null"]}]}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"null"]}]}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"null"]}]}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":true},"null"]}]}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"null"]}]}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"null"]}]}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":true},"null"]}]}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"null"]}]}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"null"]}]}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":true},"null"]}]}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"null"]}]}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"null"]}]}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":123},"null"]}]}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"null"]}]}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"null"]}]}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":123},"null"]}]}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"null"]}]}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"null"]}]}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":123},"null"]}]}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"null"]}]}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"null"]}]}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":123},"null"]}]}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"null"]}]}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"null"]}]}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":123},"null"]}]}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"null"]}]}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"null"]}]}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":123},"null"]}]}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"null"]}]}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"null"]}]}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":123},"null"]}]}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"null"]}]}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"null"]}]}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":123},"null"]}]}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"null"]}]}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"null"]}]}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":123},"null"]}]}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"null"]}]}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"null"]}]}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"null"]}]}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"null"]}]}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"null"]}]}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"null"]}]}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"null"]}]}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"null"]}]}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"null"]}]}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"null"]}]}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"null"]}]}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"null"]}]}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"null"]}]}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"null"]}]}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"null"]}]}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"null"]}]}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"null"]}]}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"null"]}]}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"null"]}]}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"null"]}]}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"null"]}]}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"null"]}]}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"null"]}]}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"null"]}]}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"null"]}]}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"null"]}]}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"null"]}]}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"null"]}]}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"boolean"]}]}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":null},"boolean"]}]}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"boolean"]}]}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"boolean"]}]}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":null},"boolean"]}]}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"boolean"]}]}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"boolean"]}]}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":null},"boolean"]}]}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"boolean"]}]}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"boolean"]}]}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":null},"boolean"]}]}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"boolean"]}]}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"boolean"]}]}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":null},"boolean"]}]}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"boolean"]}]}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"boolean"]}]}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":null},"boolean"]}]}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"boolean"]}]}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"boolean"]}]}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":null},"boolean"]}]}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"boolean"]}]}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"boolean"]}]}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":null},"boolean"]}]}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"boolean"]}]}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"boolean"]}]}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":null},"boolean"]}]}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"boolean"]}]}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"boolean"]}]}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":false},"boolean"]}]}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"boolean"]}]}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"boolean"]}]}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":false},"boolean"]}]}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"boolean"]}]}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"boolean"]}]}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":false},"boolean"]}]}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"boolean"]}]}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"boolean"]}]}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":false},"boolean"]}]}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"boolean"]}]}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"boolean"]}]}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":false},"boolean"]}]}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"boolean"]}]}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"boolean"]}]}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":false},"boolean"]}]}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"boolean"]}]}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"boolean"]}]}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":false},"boolean"]}]}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"boolean"]}]}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"boolean"]}]}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":false},"boolean"]}]}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"boolean"]}]}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"boolean"]}]}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":false},"boolean"]}]}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"boolean"]}]}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"boolean"]}]}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":true},"boolean"]}]}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"boolean"]}]}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"boolean"]}]}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":true},"boolean"]}]}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"boolean"]}]}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"boolean"]}]}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":true},"boolean"]}]}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"boolean"]}]}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"boolean"]}]}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":true},"boolean"]}]}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"boolean"]}]}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"boolean"]}]}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":true},"boolean"]}]}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"boolean"]}]}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"boolean"]}]}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":true},"boolean"]}]}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"boolean"]}]}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"boolean"]}]}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":true},"boolean"]}]}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"boolean"]}]}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"boolean"]}]}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":true},"boolean"]}]}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"boolean"]}]}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"boolean"]}]}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":true},"boolean"]}]}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"boolean"]}]}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"boolean"]}]}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":123},"boolean"]}]}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"boolean"]}]}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"boolean"]}]}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":123},"boolean"]}]}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"boolean"]}]}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"boolean"]}]}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":123},"boolean"]}]}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"boolean"]}]}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"boolean"]}]}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":123},"boolean"]}]}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"boolean"]}]}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"boolean"]}]}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":123},"boolean"]}]}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"boolean"]}]}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"boolean"]}]}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":123},"boolean"]}]}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"boolean"]}]}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"boolean"]}]}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":123},"boolean"]}]}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"boolean"]}]}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"boolean"]}]}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":123},"boolean"]}]}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"boolean"]}]}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"boolean"]}]}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":123},"boolean"]}]}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"boolean"]}]}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"boolean"]}]}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"boolean"]}]}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"boolean"]}]}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"boolean"]}]}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"boolean"]}]}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"boolean"]}]}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"boolean"]}]}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"boolean"]}]}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"boolean"]}]}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"boolean"]}]}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"boolean"]}]}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"boolean"]}]}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"boolean"]}]}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"boolean"]}]}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"boolean"]}]}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"boolean"]}]}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"boolean"]}]}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"boolean"]}]}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"boolean"]}]}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"boolean"]}]}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"boolean"]}]}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"boolean"]}]}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"boolean"]}]}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"boolean"]}]}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"boolean"]}]}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"boolean"]}]}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"boolean"]}]}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"number"]}]}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":null},"number"]}]}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"number"]}]}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"number"]}]}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":null},"number"]}]}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"number"]}]}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"number"]}]}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":null},"number"]}]}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"number"]}]}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"number"]}]}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":null},"number"]}]}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"number"]}]}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"number"]}]}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":null},"number"]}]}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"number"]}]}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"number"]}]}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":null},"number"]}]}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"number"]}]}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"number"]}]}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":null},"number"]}]}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"number"]}]}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"number"]}]}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":null},"number"]}]}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"number"]}]}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"number"]}]}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":null},"number"]}]}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"number"]}]}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"number"]}]}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":false},"number"]}]}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"number"]}]}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"number"]}]}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":false},"number"]}]}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"number"]}]}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"number"]}]}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":false},"number"]}]}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"number"]}]}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"number"]}]}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":false},"number"]}]}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"number"]}]}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"number"]}]}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":false},"number"]}]}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"number"]}]}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"number"]}]}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":false},"number"]}]}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"number"]}]}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"number"]}]}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":false},"number"]}]}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"number"]}]}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"number"]}]}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":false},"number"]}]}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"number"]}]}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"number"]}]}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":false},"number"]}]}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"number"]}]}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"number"]}]}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":true},"number"]}]}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"number"]}]}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"number"]}]}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":true},"number"]}]}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"number"]}]}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"number"]}]}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":true},"number"]}]}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"number"]}]}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"number"]}]}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":true},"number"]}]}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"number"]}]}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"number"]}]}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":true},"number"]}]}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"number"]}]}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"number"]}]}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":true},"number"]}]}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"number"]}]}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"number"]}]}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":true},"number"]}]}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"number"]}]}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"number"]}]}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":true},"number"]}]}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"number"]}]}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"number"]}]}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":true},"number"]}]}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"number"]}]}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"number"]}]}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":123},"number"]}]}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"number"]}]}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"number"]}]}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":123},"number"]}]}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"number"]}]}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"number"]}]}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":123},"number"]}]}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"number"]}]}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"number"]}]}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":123},"number"]}]}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"number"]}]}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"number"]}]}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":123},"number"]}]}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"number"]}]}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"number"]}]}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":123},"number"]}]}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"number"]}]}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"number"]}]}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":123},"number"]}]}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"number"]}]}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"number"]}]}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":123},"number"]}]}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"number"]}]}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"number"]}]}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":123},"number"]}]}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"number"]}]}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"number"]}]}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"number"]}]}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"number"]}]}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"number"]}]}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"number"]}]}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"number"]}]}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"number"]}]}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"number"]}]}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"number"]}]}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"number"]}]}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"number"]}]}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"number"]}]}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"number"]}]}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"number"]}]}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"number"]}]}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"number"]}]}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"number"]}]}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"number"]}]}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"number"]}]}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"number"]}]}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"number"]}]}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"number"]}]}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"number"]}]}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"number"]}]}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"number"]}]}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"number"]}]}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"number"]}]}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"string"]}]}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":null},"string"]}]}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"string"]}]}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"string"]}]}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":null},"string"]}]}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"string"]}]}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"string"]}]}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":null},"string"]}]}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"string"]}]}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"string"]}]}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":null},"string"]}]}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"string"]}]}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"string"]}]}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":null},"string"]}]}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"string"]}]}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"string"]}]}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":null},"string"]}]}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"string"]}]}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"string"]}]}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":null},"string"]}]}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"string"]}]}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"string"]}]}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":null},"string"]}]}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"string"]}]}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"string"]}]}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":null},"string"]}]}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"string"]}]}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"string"]}]}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":false},"string"]}]}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"string"]}]}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"string"]}]}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":false},"string"]}]}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"string"]}]}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"string"]}]}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":false},"string"]}]}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"string"]}]}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"string"]}]}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":false},"string"]}]}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"string"]}]}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"string"]}]}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":false},"string"]}]}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"string"]}]}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"string"]}]}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":false},"string"]}]}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"string"]}]}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"string"]}]}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":false},"string"]}]}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"string"]}]}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"string"]}]}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":false},"string"]}]}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"string"]}]}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"string"]}]}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":false},"string"]}]}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"string"]}]}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"string"]}]}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":true},"string"]}]}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"string"]}]}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"string"]}]}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":true},"string"]}]}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"string"]}]}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"string"]}]}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":true},"string"]}]}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"string"]}]}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"string"]}]}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":true},"string"]}]}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"string"]}]}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"string"]}]}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":true},"string"]}]}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"string"]}]}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"string"]}]}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":true},"string"]}]}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"string"]}]}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"string"]}]}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":true},"string"]}]}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"string"]}]}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"string"]}]}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":true},"string"]}]}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"string"]}]}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"string"]}]}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":true},"string"]}]}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"string"]}]}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"string"]}]}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":123},"string"]}]}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"string"]}]}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"string"]}]}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":123},"string"]}]}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"string"]}]}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"string"]}]}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":123},"string"]}]}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"string"]}]}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"string"]}]}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":123},"string"]}]}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"string"]}]}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"string"]}]}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":123},"string"]}]}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"string"]}]}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"string"]}]}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":123},"string"]}]}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"string"]}]}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"string"]}]}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":123},"string"]}]}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"string"]}]}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"string"]}]}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":123},"string"]}]}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"string"]}]}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"string"]}]}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":123},"string"]}]}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"string"]}]}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"string"]}]}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"string"]}]}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"string"]}]}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"string"]}]}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"string"]}]}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"string"]}]}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"string"]}]}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"string"]}]}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"string"]}]}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"string"]}]}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"string"]}]}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"string"]}]}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"string"]}]}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"string"]}]}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"string"]}]}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"string"]}]}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"string"]}]}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"string"]}]}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"string"]}]}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"string"]}]}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"string"]}]}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"string"]}]}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"string"]}]}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"string"]}]}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"string"]}]}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"string"]}]}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"string"]}]}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"object"]}]}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":null},"object"]}]}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"object"]}]}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"object"]}]}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":null},"object"]}]}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"object"]}]}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"object"]}]}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":null},"object"]}]}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"object"]}]}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"object"]}]}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":null},"object"]}]}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"object"]}]}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"object"]}]}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":null},"object"]}]}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"object"]}]}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"object"]}]}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":null},"object"]}]}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"object"]}]}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"object"]}]}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":null},"object"]}]}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"object"]}]}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"object"]}]}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":null},"object"]}]}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"object"]}]}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"object"]}]}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":null},"object"]}]}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"object"]}]}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"object"]}]}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":false},"object"]}]}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"object"]}]}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"object"]}]}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":false},"object"]}]}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"object"]}]}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"object"]}]}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":false},"object"]}]}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"object"]}]}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"object"]}]}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":false},"object"]}]}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"object"]}]}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"object"]}]}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":false},"object"]}]}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"object"]}]}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"object"]}]}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":false},"object"]}]}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"object"]}]}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"object"]}]}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":false},"object"]}]}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"object"]}]}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"object"]}]}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":false},"object"]}]}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"object"]}]}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"object"]}]}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":false},"object"]}]}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"object"]}]}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"object"]}]}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":true},"object"]}]}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"object"]}]}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"object"]}]}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":true},"object"]}]}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"object"]}]}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"object"]}]}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":true},"object"]}]}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"object"]}]}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"object"]}]}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":true},"object"]}]}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"object"]}]}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"object"]}]}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":true},"object"]}]}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"object"]}]}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"object"]}]}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":true},"object"]}]}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"object"]}]}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"object"]}]}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":true},"object"]}]}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"object"]}]}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"object"]}]}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":true},"object"]}]}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"object"]}]}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"object"]}]}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":true},"object"]}]}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"object"]}]}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"object"]}]}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":123},"object"]}]}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"object"]}]}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"object"]}]}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":123},"object"]}]}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"object"]}]}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"object"]}]}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":123},"object"]}]}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"object"]}]}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"object"]}]}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":123},"object"]}]}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"object"]}]}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"object"]}]}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":123},"object"]}]}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"object"]}]}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"object"]}]}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":123},"object"]}]}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"object"]}]}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"object"]}]}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":123},"object"]}]}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"object"]}]}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"object"]}]}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":123},"object"]}]}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"object"]}]}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"object"]}]}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":123},"object"]}]}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"object"]}]}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"object"]}]}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"object"]}]}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"object"]}]}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"object"]}]}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"object"]}]}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"object"]}]}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"object"]}]}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"object"]}]}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"object"]}]}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"object"]}]}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"object"]}]}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"object"]}]}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"object"]}]}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"object"]}]}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"object"]}]}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"object"]}]}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"object"]}]}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"object"]}]}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"object"]}]}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"object"]}]}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"object"]}]}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"object"]}]}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"object"]}]}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"object"]}]}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"object"]}]}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"object"]}]}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"object"]}]}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"array"]}]}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":null},"array"]}]}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"array"]}]}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"array"]}]}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":null},"array"]}]}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"array"]}]}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"array"]}]}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":null},"array"]}]}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"array"]}]}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"array"]}]}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":null},"array"]}]}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"array"]}]}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"array"]}]}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":null},"array"]}]}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"array"]}]}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"array"]}]}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":null},"array"]}]}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"array"]}]}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"array"]}]}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":null},"array"]}]}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"array"]}]}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"array"]}]}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":null},"array"]}]}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"array"]}]}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"array"]}]}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":null},"array"]}]}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":null},"array"]}]}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"array"]}]}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":false},"array"]}]}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"array"]}]}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"array"]}]}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":false},"array"]}]}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"array"]}]}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"array"]}]}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":false},"array"]}]}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"array"]}]}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"array"]}]}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":false},"array"]}]}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"array"]}]}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"array"]}]}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":false},"array"]}]}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"array"]}]}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"array"]}]}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":false},"array"]}]}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"array"]}]}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"array"]}]}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":false},"array"]}]}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"array"]}]}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"array"]}]}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":false},"array"]}]}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"array"]}]}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"array"]}]}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":false},"array"]}]}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":false},"array"]}]}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"array"]}]}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":true},"array"]}]}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"array"]}]}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"array"]}]}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":true},"array"]}]}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"array"]}]}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"array"]}]}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":true},"array"]}]}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"array"]}]}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"array"]}]}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":true},"array"]}]}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"array"]}]}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"array"]}]}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":true},"array"]}]}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"array"]}]}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"array"]}]}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":true},"array"]}]}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"array"]}]}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"array"]}]}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":true},"array"]}]}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"array"]}]}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"array"]}]}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":true},"array"]}]}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"array"]}]}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"array"]}]}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":true},"array"]}]}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":true},"array"]}]}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"array"]}]}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":123},"array"]}]}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"array"]}]}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"array"]}]}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":123},"array"]}]}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"array"]}]}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"array"]}]}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":123},"array"]}]}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"array"]}]}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"array"]}]}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":123},"array"]}]}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"array"]}]}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"array"]}]}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":123},"array"]}]}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"array"]}]}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"array"]}]}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":123},"array"]}]}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"array"]}]}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"array"]}]}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":123},"array"]}]}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"array"]}]}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"array"]}]}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":123},"array"]}]}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"array"]}]}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"array"]}]}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":123},"array"]}]}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":123},"array"]}]}'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"array"]}]}'\'' <<< '\''[null]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"array"]}]}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"array"]}]}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"array"]}]}'\'' <<< '\''[false]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"array"]}]}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"array"]}]}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"array"]}]}'\'' <<< '\''[true]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"array"]}]}' <<< '[true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"array"]}]}'\'' <<< '\''[true]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"array"]}]}'\'' <<< '\''[123]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"array"]}]}' <<< '[123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"array"]}]}'\'' <<< '\''[123]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"array"]}]}'\'' <<< '\''[456]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"array"]}]}' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"array"]}]}'\'' <<< '\''[456]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"array"]}]}'\'' <<< '\''["bar"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"array"]}]}' <<< '["bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"array"]}]}'\'' <<< '\''["bar"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"array"]}]}'\'' <<< '\''["baz"]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"array"]}]}' <<< '["baz"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"array"]}]}'\'' <<< '\''["baz"]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"array"]}]}'\'' <<< '\''[{}]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"array"]}]}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"array"]}]}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"array"]}]}'\'' <<< '\''[[]]'\'''
json -d '{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"array"]}]}' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":[{"type":"list","args":[{"plain":"bar"},"array"]}]}'\'' <<< '\''[[]]'\'''
)

