#!/bin/bash

# Copyright (C) 2016, 2017, 2018  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker:open-array4
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L open-array4.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[null,null]'\''
[null,null]
$ json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[null,false]'\''
[null,false]
$ json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[null,true]'\''
[null,true]
$ json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[null,123]'\''
[null,123]
$ json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[null,"foo"]'\''
[null,"foo"]
$ json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[null,{}]'\''
[null,{}]
$ json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[null,[]]'\''
[null,[]]
$ json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[null,null]'\''
[null,null]
$ json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[null,false]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:7: [null,false]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[null,false]'\''
$ json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[null,true]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:7: [null,true]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[null,true]'\''
$ json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[null,123]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:7: [null,123]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[null,123]'\''
$ json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[null,"foo"]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:7: [null,"foo"]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[null,"foo"]'\''
$ json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[null,{}]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:7: [null,{}]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[null,{}]'\''
$ json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[null,[]]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:7: [null,[]]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[null,[]]'\''
$ json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:2: [null,null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[null,false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:2: [null,false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[null,false]'\''
$ json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[null,true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:2: [null,true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[null,true]'\''
$ json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[null,123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:2: [null,123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[null,123]'\''
$ json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[null,"foo"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:2: [null,"foo"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[null,"foo"]'\''
$ json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[null,{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:2: [null,{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[null,{}]'\''
$ json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[null,[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:2: [null,[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[null,[]]'\''
$ json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:2: [null,null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[null,false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:2: [null,false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[null,false]'\''
$ json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[null,true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:2: [null,true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[null,true]'\''
$ json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[null,123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:2: [null,123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[null,123]'\''
$ json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[null,"foo"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:2: [null,"foo"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[null,"foo"]'\''
$ json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[null,{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:2: [null,{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[null,{}]'\''
$ json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[null,[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:2: [null,[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[null,[]]'\''
$ json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:2: [null,null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[null,false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:2: [null,false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[null,false]'\''
$ json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[null,true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:2: [null,true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[null,true]'\''
$ json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[null,123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:2: [null,123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[null,123]'\''
$ json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[null,"foo"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:2: [null,"foo"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[null,"foo"]'\''
$ json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[null,{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:2: [null,{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[null,{}]'\''
$ json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[null,[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:2: [null,[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[null,[]]'\''
$ json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:2: [null,null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[null,false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:2: [null,false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[null,false]'\''
$ json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[null,true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:2: [null,true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[null,true]'\''
$ json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[null,123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:2: [null,123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[null,123]'\''
$ json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[null,"foo"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:2: [null,"foo"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[null,"foo"]'\''
$ json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[null,{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:2: [null,{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[null,{}]'\''
$ json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[null,[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:2: [null,[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[null,[]]'\''
$ json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:2: [null,null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[null,false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:2: [null,false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[null,false]'\''
$ json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[null,true]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:2: [null,true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[null,true]'\''
$ json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[null,123]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:2: [null,123]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[null,123]'\''
$ json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[null,"foo"]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:2: [null,"foo"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[null,"foo"]'\''
$ json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[null,{}]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:2: [null,{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[null,{}]'\''
$ json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[null,[]]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:2: [null,[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[null,[]]'\'''
) -L open-array4.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":"type"}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[null,false]'\'''
json -d '{"type":"array","args":"type"}' <<< '[null,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[null,false]'\'''

echo '$ json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[null,true]'\'''
json -d '{"type":"array","args":"type"}' <<< '[null,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[null,true]'\'''

echo '$ json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[null,123]'\'''
json -d '{"type":"array","args":"type"}' <<< '[null,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[null,123]'\'''

echo '$ json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[null,"foo"]'\'''
json -d '{"type":"array","args":"type"}' <<< '[null,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[null,"foo"]'\'''

echo '$ json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[null,{}]'\'''
json -d '{"type":"array","args":"type"}' <<< '[null,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[null,{}]'\'''

echo '$ json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[null,[]]'\'''
json -d '{"type":"array","args":"type"}' <<< '[null,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"type"}'\'' <<< '\''[null,[]]'\'''

echo '$ json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":"null"}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[null,false]'\'''
json -d '{"type":"array","args":"null"}' <<< '[null,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[null,false]'\'''

echo '$ json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[null,true]'\'''
json -d '{"type":"array","args":"null"}' <<< '[null,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[null,true]'\'''

echo '$ json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[null,123]'\'''
json -d '{"type":"array","args":"null"}' <<< '[null,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[null,123]'\'''

echo '$ json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[null,"foo"]'\'''
json -d '{"type":"array","args":"null"}' <<< '[null,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[null,"foo"]'\'''

echo '$ json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[null,{}]'\'''
json -d '{"type":"array","args":"null"}' <<< '[null,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[null,{}]'\'''

echo '$ json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[null,[]]'\'''
json -d '{"type":"array","args":"null"}' <<< '[null,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"null"}'\'' <<< '\''[null,[]]'\'''

echo '$ json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":"boolean"}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[null,false]'\'''
json -d '{"type":"array","args":"boolean"}' <<< '[null,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[null,false]'\'''

echo '$ json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[null,true]'\'''
json -d '{"type":"array","args":"boolean"}' <<< '[null,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[null,true]'\'''

echo '$ json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[null,123]'\'''
json -d '{"type":"array","args":"boolean"}' <<< '[null,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[null,123]'\'''

echo '$ json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[null,"foo"]'\'''
json -d '{"type":"array","args":"boolean"}' <<< '[null,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[null,"foo"]'\'''

echo '$ json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[null,{}]'\'''
json -d '{"type":"array","args":"boolean"}' <<< '[null,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[null,{}]'\'''

echo '$ json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[null,[]]'\'''
json -d '{"type":"array","args":"boolean"}' <<< '[null,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"boolean"}'\'' <<< '\''[null,[]]'\'''

echo '$ json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":"number"}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[null,false]'\'''
json -d '{"type":"array","args":"number"}' <<< '[null,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[null,false]'\'''

echo '$ json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[null,true]'\'''
json -d '{"type":"array","args":"number"}' <<< '[null,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[null,true]'\'''

echo '$ json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[null,123]'\'''
json -d '{"type":"array","args":"number"}' <<< '[null,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[null,123]'\'''

echo '$ json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[null,"foo"]'\'''
json -d '{"type":"array","args":"number"}' <<< '[null,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[null,"foo"]'\'''

echo '$ json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[null,{}]'\'''
json -d '{"type":"array","args":"number"}' <<< '[null,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[null,{}]'\'''

echo '$ json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[null,[]]'\'''
json -d '{"type":"array","args":"number"}' <<< '[null,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"number"}'\'' <<< '\''[null,[]]'\'''

echo '$ json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":"string"}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[null,false]'\'''
json -d '{"type":"array","args":"string"}' <<< '[null,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[null,false]'\'''

echo '$ json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[null,true]'\'''
json -d '{"type":"array","args":"string"}' <<< '[null,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[null,true]'\'''

echo '$ json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[null,123]'\'''
json -d '{"type":"array","args":"string"}' <<< '[null,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[null,123]'\'''

echo '$ json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[null,"foo"]'\'''
json -d '{"type":"array","args":"string"}' <<< '[null,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[null,"foo"]'\'''

echo '$ json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[null,{}]'\'''
json -d '{"type":"array","args":"string"}' <<< '[null,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[null,{}]'\'''

echo '$ json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[null,[]]'\'''
json -d '{"type":"array","args":"string"}' <<< '[null,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"string"}'\'' <<< '\''[null,[]]'\'''

echo '$ json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":"object"}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[null,false]'\'''
json -d '{"type":"array","args":"object"}' <<< '[null,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[null,false]'\'''

echo '$ json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[null,true]'\'''
json -d '{"type":"array","args":"object"}' <<< '[null,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[null,true]'\'''

echo '$ json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[null,123]'\'''
json -d '{"type":"array","args":"object"}' <<< '[null,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[null,123]'\'''

echo '$ json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[null,"foo"]'\'''
json -d '{"type":"array","args":"object"}' <<< '[null,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[null,"foo"]'\'''

echo '$ json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[null,{}]'\'''
json -d '{"type":"array","args":"object"}' <<< '[null,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[null,{}]'\'''

echo '$ json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[null,[]]'\'''
json -d '{"type":"array","args":"object"}' <<< '[null,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"object"}'\'' <<< '\''[null,[]]'\'''

echo '$ json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"array","args":"array"}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[null,false]'\'''
json -d '{"type":"array","args":"array"}' <<< '[null,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[null,false]'\'''

echo '$ json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[null,true]'\'''
json -d '{"type":"array","args":"array"}' <<< '[null,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[null,true]'\'''

echo '$ json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[null,123]'\'''
json -d '{"type":"array","args":"array"}' <<< '[null,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[null,123]'\'''

echo '$ json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[null,"foo"]'\'''
json -d '{"type":"array","args":"array"}' <<< '[null,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[null,"foo"]'\'''

echo '$ json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[null,{}]'\'''
json -d '{"type":"array","args":"array"}' <<< '[null,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[null,{}]'\'''

echo '$ json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[null,[]]'\'''
json -d '{"type":"array","args":"array"}' <<< '[null,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"array","args":"array"}'\'' <<< '\''[null,[]]'\'''
)

