#!/bin/bash

# Copyright (C) 2016, 2017, 2018  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C bugs:24
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L 24.old <(echo \
'$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '\''/error:/s|(/dev/fd/)[0-9]+|\1??|'\''; }
$ json -d '\''{"type":"list","args":[{"type":"array","args":"null"},{"type":"array","args":["number","number"]}]}'\'' <<< '\''[]'\''
[]
$ json -d '\''{"type":"list","args":[{"type":"array","args":"null"},{"type":"array","args":["number","number"]}]}'\'' <<< '\''[null]'\''
[null]
$ json -d '\''{"type":"list","args":[{"type":"array","args":"null"},{"type":"array","args":["number","number"]}]}'\'' <<< '\''[null,null]'\''
[null,null]
$ json -d '\''{"type":"list","args":[{"type":"array","args":"null"},{"type":"array","args":["number","number"]}]}'\'' <<< '\''[null,null,null]'\''
[null,null,null]
$ json -d '\''{"type":"list","args":[{"type":"array","args":"null"},{"type":"array","args":["number","number"]}]}'\'' <<< '\''[1]'\''
json: error: <stdin>:1:3: type check error: too few arguments
json: error: <stdin>:1:3: [1]
json: error: <stdin>:1:3:   ^
[1
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"null"},{"type":"array","args":["number","number"]}]}'\'' <<< '\''[1]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":"null"},{"type":"array","args":["number","number"]}]}'\'' <<< '\''[1,false]'\''
json: error: <stdin>:1:4: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:4: [1,false]
json: error: <stdin>:1:4:    ^
[1,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"null"},{"type":"array","args":["number","number"]}]}'\'' <<< '\''[1,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":"null"},{"type":"array","args":["number","number"]}]}'\'' <<< '\''[1,1]'\''
[1,1]
$ json -d '\''{"type":"list","args":[{"type":"array","args":"null"},{"type":"array","args":["number","number"]}]}'\'' <<< '\''[1,1,false]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [1,1,false]
json: error: <stdin>:1:5:     ^
[1,1
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"null"},{"type":"array","args":["number","number"]}]}'\'' <<< '\''[1,1,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":"null"},{"type":"array","args":["number","number"]}]}'\'' <<< '\''[1,1,1]'\''
json: error: <stdin>:1:5: type check error: too many arguments
json: error: <stdin>:1:5: [1,1,1]
json: error: <stdin>:1:5:     ^
[1,1
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"null"},{"type":"array","args":["number","number"]}]}'\'' <<< '\''[1,1,1]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":"null"},{"type":"array","args":["number","number"]}]}'\'' <<< '\''[false]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `"null"'\'' or `"number"'\'' or, otherwise, no value at all
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"null"},{"type":"array","args":["number","number"]}]}'\'' <<< '\''[false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":"null"},{"type":"array","args":["number","number"]}]}'\'' <<< '\''[null,false]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:7: [null,false]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"null"},{"type":"array","args":["number","number"]}]}'\'' <<< '\''[null,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":"null"},{"type":"array","args":["number","number"]}]}'\'' <<< '\''[null,null,false]'\''
json: error: <stdin>:1:12: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:12: [null,null,false]
json: error: <stdin>:1:12:            ^
[null,null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"null"},{"type":"array","args":["number","number"]}]}'\'' <<< '\''[null,null,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":"null"},{"type":"array","args":["number","number"]}]}'\'' <<< '\''[null,1]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:7: [null,1]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"null"},{"type":"array","args":["number","number"]}]}'\'' <<< '\''[null,1]'\'''
) -L 24.new <(
echo '$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '\''/error:/s|(/dev/fd/)[0-9]+|\1??|'\''; }'
json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '/error:/s|(/dev/fd/)[0-9]+|\1??|'; } 2>&1 ||
echo 'command failed: json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '\''/error:/s|(/dev/fd/)[0-9]+|\1??|'\''; }'

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"null"},{"type":"array","args":["number","number"]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"null"},{"type":"array","args":["number","number"]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"null"},{"type":"array","args":["number","number"]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"null"},{"type":"array","args":["number","number"]}]}'\'' <<< '\''[null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"null"},{"type":"array","args":["number","number"]}]}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"null"},{"type":"array","args":["number","number"]}]}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"null"},{"type":"array","args":["number","number"]}]}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"null"},{"type":"array","args":["number","number"]}]}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"null"},{"type":"array","args":["number","number"]}]}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"null"},{"type":"array","args":["number","number"]}]}'\'' <<< '\''[null,null,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"null"},{"type":"array","args":["number","number"]}]}' <<< '[null,null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"null"},{"type":"array","args":["number","number"]}]}'\'' <<< '\''[null,null,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"null"},{"type":"array","args":["number","number"]}]}'\'' <<< '\''[1]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"null"},{"type":"array","args":["number","number"]}]}' <<< '[1]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"null"},{"type":"array","args":["number","number"]}]}'\'' <<< '\''[1]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"null"},{"type":"array","args":["number","number"]}]}'\'' <<< '\''[1,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"null"},{"type":"array","args":["number","number"]}]}' <<< '[1,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"null"},{"type":"array","args":["number","number"]}]}'\'' <<< '\''[1,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"null"},{"type":"array","args":["number","number"]}]}'\'' <<< '\''[1,1]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"null"},{"type":"array","args":["number","number"]}]}' <<< '[1,1]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"null"},{"type":"array","args":["number","number"]}]}'\'' <<< '\''[1,1]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"null"},{"type":"array","args":["number","number"]}]}'\'' <<< '\''[1,1,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"null"},{"type":"array","args":["number","number"]}]}' <<< '[1,1,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"null"},{"type":"array","args":["number","number"]}]}'\'' <<< '\''[1,1,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"null"},{"type":"array","args":["number","number"]}]}'\'' <<< '\''[1,1,1]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"null"},{"type":"array","args":["number","number"]}]}' <<< '[1,1,1]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"null"},{"type":"array","args":["number","number"]}]}'\'' <<< '\''[1,1,1]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"null"},{"type":"array","args":["number","number"]}]}'\'' <<< '\''[false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"null"},{"type":"array","args":["number","number"]}]}' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"null"},{"type":"array","args":["number","number"]}]}'\'' <<< '\''[false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"null"},{"type":"array","args":["number","number"]}]}'\'' <<< '\''[null,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"null"},{"type":"array","args":["number","number"]}]}' <<< '[null,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"null"},{"type":"array","args":["number","number"]}]}'\'' <<< '\''[null,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"null"},{"type":"array","args":["number","number"]}]}'\'' <<< '\''[null,null,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"null"},{"type":"array","args":["number","number"]}]}' <<< '[null,null,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"null"},{"type":"array","args":["number","number"]}]}'\'' <<< '\''[null,null,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":"null"},{"type":"array","args":["number","number"]}]}'\'' <<< '\''[null,1]'\'''
json -d '{"type":"list","args":[{"type":"array","args":"null"},{"type":"array","args":["number","number"]}]}' <<< '[null,1]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":"null"},{"type":"array","args":["number","number"]}]}'\'' <<< '\''[null,1]'\'''
)

