#!/bin/bash

# Copyright (C) 2016, 2017, 2018  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C escape:trim4
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L trim4.old <(echo \
'$ json() { LD_LIBRARY_PATH=../lib ../src/json --validate-utf8 --escape-json --trim-spaces --verbose "$@"; }
$ echo -ne '\''\t\t\tA\fB\v\v\v'\''|json -b 1
A\fB
$ echo -ne '\''\t\t\tA\fB\v\v\v'\''|json -b 2
A\fB
$ echo -ne '\''\t\t\tA\fB\v\v\v'\''|json -b 3
A\fB
$ echo -ne '\''\t\t\tA\fB\v\v\v'\''|json -b 4
A\fB
$ echo -ne '\''\t\t\tA\fB\v\v\v'\''|json -b 5
A\fB
$ echo -ne '\''\t\t\tA\fB\v\v\v'\''|json -b 6
A\fB
$ echo -ne '\''\t\t\tA\fB\v\v\v'\''|json -b 7
A\fB
$ echo -ne '\''\t\t\tA\fB\v\v\v'\''|json -b 8
A\fB
$ echo -ne '\''\t\t\tA\fB\v\v\v'\''|json -b 9
A\fB
$ echo -ne '\''\t\t\tA\fB\v\v\v'\''|json -b 10
A\fB
$ echo -ne '\''\t\t\tA\f\xc2\x81\v\v\v'\''|json -b 1
A\f\u0081
$ echo -ne '\''\t\t\tA\f\xc2\x81\v\v\v'\''|json -b 2
A\f\u0081
$ echo -ne '\''\t\t\tA\f\xc2\x81\v\v\v'\''|json -b 3
A\f\u0081
$ echo -ne '\''\t\t\tA\f\xc2\x81\v\v\v'\''|json -b 4
A\f\u0081
$ echo -ne '\''\t\t\tA\f\xc2\x81\v\v\v'\''|json -b 5
A\f\u0081
$ echo -ne '\''\t\t\tA\f\xc2\x81\v\v\v'\''|json -b 6
A\f\u0081
$ echo -ne '\''\t\t\tA\f\xc2\x81\v\v\v'\''|json -b 7
A\f\u0081
$ echo -ne '\''\t\t\tA\f\xc2\x81\v\v\v'\''|json -b 8
A\f\u0081
$ echo -ne '\''\t\t\tA\f\xc2\x81\v\v\v'\''|json -b 9
A\f\u0081
$ echo -ne '\''\t\t\tA\f\xc2\x81\v\v\v'\''|json -b 10
A\f\u0081
$ echo -ne '\''\t\t\tA\f\xc2\x81\v\v\v'\''|json -b 11
A\f\u0081
$ echo -ne '\''\t\t\tA\f\xe0\xa0\x81\v\v\v'\''|json -b 1
A\f\u0801
$ echo -ne '\''\t\t\tA\f\xe0\xa0\x81\v\v\v'\''|json -b 2
A\f\u0801
$ echo -ne '\''\t\t\tA\f\xe0\xa0\x81\v\v\v'\''|json -b 3
A\f\u0801
$ echo -ne '\''\t\t\tA\f\xe0\xa0\x81\v\v\v'\''|json -b 4
A\f\u0801
$ echo -ne '\''\t\t\tA\f\xe0\xa0\x81\v\v\v'\''|json -b 5
A\f\u0801
$ echo -ne '\''\t\t\tA\f\xe0\xa0\x81\v\v\v'\''|json -b 6
A\f\u0801
$ echo -ne '\''\t\t\tA\f\xe0\xa0\x81\v\v\v'\''|json -b 7
A\f\u0801
$ echo -ne '\''\t\t\tA\f\xe0\xa0\x81\v\v\v'\''|json -b 8
A\f\u0801
$ echo -ne '\''\t\t\tA\f\xe0\xa0\x81\v\v\v'\''|json -b 9
A\f\u0801
$ echo -ne '\''\t\t\tA\f\xe0\xa0\x81\v\v\v'\''|json -b 10
A\f\u0801
$ echo -ne '\''\t\t\tA\f\xe0\xa0\x81\v\v\v'\''|json -b 11
A\f\u0801
$ echo -ne '\''\t\t\tA\f\xe0\xa0\x81\v\v\v'\''|json -b 12
A\f\u0801
$ echo -ne '\''\t\t\t\xc2\x80\fB\v\v\v'\''|json -b 1
\u0080\fB
$ echo -ne '\''\t\t\t\xc2\x80\fB\v\v\v'\''|json -b 2
\u0080\fB
$ echo -ne '\''\t\t\t\xc2\x80\fB\v\v\v'\''|json -b 3
\u0080\fB
$ echo -ne '\''\t\t\t\xc2\x80\fB\v\v\v'\''|json -b 4
\u0080\fB
$ echo -ne '\''\t\t\t\xc2\x80\fB\v\v\v'\''|json -b 5
\u0080\fB
$ echo -ne '\''\t\t\t\xc2\x80\fB\v\v\v'\''|json -b 6
\u0080\fB
$ echo -ne '\''\t\t\t\xc2\x80\fB\v\v\v'\''|json -b 7
\u0080\fB
$ echo -ne '\''\t\t\t\xc2\x80\fB\v\v\v'\''|json -b 8
\u0080\fB
$ echo -ne '\''\t\t\t\xc2\x80\fB\v\v\v'\''|json -b 9
\u0080\fB
$ echo -ne '\''\t\t\t\xc2\x80\fB\v\v\v'\''|json -b 10
\u0080\fB
$ echo -ne '\''\t\t\t\xc2\x80\fB\v\v\v'\''|json -b 11
\u0080\fB
$ echo -ne '\''\t\t\t\xc2\x80\f\xc2\x81\v\v\v'\''|json -b 1
\u0080\f\u0081
$ echo -ne '\''\t\t\t\xc2\x80\f\xc2\x81\v\v\v'\''|json -b 2
\u0080\f\u0081
$ echo -ne '\''\t\t\t\xc2\x80\f\xc2\x81\v\v\v'\''|json -b 3
\u0080\f\u0081
$ echo -ne '\''\t\t\t\xc2\x80\f\xc2\x81\v\v\v'\''|json -b 4
\u0080\f\u0081
$ echo -ne '\''\t\t\t\xc2\x80\f\xc2\x81\v\v\v'\''|json -b 5
\u0080\f\u0081
$ echo -ne '\''\t\t\t\xc2\x80\f\xc2\x81\v\v\v'\''|json -b 6
\u0080\f\u0081
$ echo -ne '\''\t\t\t\xc2\x80\f\xc2\x81\v\v\v'\''|json -b 7
\u0080\f\u0081
$ echo -ne '\''\t\t\t\xc2\x80\f\xc2\x81\v\v\v'\''|json -b 8
\u0080\f\u0081
$ echo -ne '\''\t\t\t\xc2\x80\f\xc2\x81\v\v\v'\''|json -b 9
\u0080\f\u0081
$ echo -ne '\''\t\t\t\xc2\x80\f\xc2\x81\v\v\v'\''|json -b 10
\u0080\f\u0081
$ echo -ne '\''\t\t\t\xc2\x80\f\xc2\x81\v\v\v'\''|json -b 11
\u0080\f\u0081
$ echo -ne '\''\t\t\t\xc2\x80\f\xc2\x81\v\v\v'\''|json -b 12
\u0080\f\u0081
$ echo -ne '\''\t\t\t\xc2\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 1
\u0080\f\u0801
$ echo -ne '\''\t\t\t\xc2\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 2
\u0080\f\u0801
$ echo -ne '\''\t\t\t\xc2\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 3
\u0080\f\u0801
$ echo -ne '\''\t\t\t\xc2\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 4
\u0080\f\u0801
$ echo -ne '\''\t\t\t\xc2\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 5
\u0080\f\u0801
$ echo -ne '\''\t\t\t\xc2\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 6
\u0080\f\u0801
$ echo -ne '\''\t\t\t\xc2\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 7
\u0080\f\u0801
$ echo -ne '\''\t\t\t\xc2\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 8
\u0080\f\u0801
$ echo -ne '\''\t\t\t\xc2\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 9
\u0080\f\u0801
$ echo -ne '\''\t\t\t\xc2\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 10
\u0080\f\u0801
$ echo -ne '\''\t\t\t\xc2\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 11
\u0080\f\u0801
$ echo -ne '\''\t\t\t\xc2\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 12
\u0080\f\u0801
$ echo -ne '\''\t\t\t\xc2\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 13
\u0080\f\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\fB\v\v\v'\''|json -b 1
\u0800\fB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\fB\v\v\v'\''|json -b 2
\u0800\fB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\fB\v\v\v'\''|json -b 3
\u0800\fB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\fB\v\v\v'\''|json -b 4
\u0800\fB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\fB\v\v\v'\''|json -b 5
\u0800\fB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\fB\v\v\v'\''|json -b 6
\u0800\fB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\fB\v\v\v'\''|json -b 7
\u0800\fB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\fB\v\v\v'\''|json -b 8
\u0800\fB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\fB\v\v\v'\''|json -b 9
\u0800\fB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\fB\v\v\v'\''|json -b 10
\u0800\fB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\fB\v\v\v'\''|json -b 11
\u0800\fB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\fB\v\v\v'\''|json -b 12
\u0800\fB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\xc2\x81\v\v\v'\''|json -b 1
\u0800\f\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\xc2\x81\v\v\v'\''|json -b 2
\u0800\f\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\xc2\x81\v\v\v'\''|json -b 3
\u0800\f\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\xc2\x81\v\v\v'\''|json -b 4
\u0800\f\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\xc2\x81\v\v\v'\''|json -b 5
\u0800\f\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\xc2\x81\v\v\v'\''|json -b 6
\u0800\f\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\xc2\x81\v\v\v'\''|json -b 7
\u0800\f\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\xc2\x81\v\v\v'\''|json -b 8
\u0800\f\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\xc2\x81\v\v\v'\''|json -b 9
\u0800\f\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\xc2\x81\v\v\v'\''|json -b 10
\u0800\f\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\xc2\x81\v\v\v'\''|json -b 11
\u0800\f\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\xc2\x81\v\v\v'\''|json -b 12
\u0800\f\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\xc2\x81\v\v\v'\''|json -b 13
\u0800\f\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 1
\u0800\f\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 2
\u0800\f\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 3
\u0800\f\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 4
\u0800\f\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 5
\u0800\f\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 6
\u0800\f\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 7
\u0800\f\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 8
\u0800\f\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 9
\u0800\f\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 10
\u0800\f\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 11
\u0800\f\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 12
\u0800\f\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 13
\u0800\f\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 14
\u0800\f\u0801
$ echo -ne '\''\t\t\tA\nB\v\v\v'\''|json -b 1
A\nB
$ echo -ne '\''\t\t\tA\nB\v\v\v'\''|json -b 2
A\nB
$ echo -ne '\''\t\t\tA\nB\v\v\v'\''|json -b 3
A\nB
$ echo -ne '\''\t\t\tA\nB\v\v\v'\''|json -b 4
A\nB
$ echo -ne '\''\t\t\tA\nB\v\v\v'\''|json -b 5
A\nB
$ echo -ne '\''\t\t\tA\nB\v\v\v'\''|json -b 6
A\nB
$ echo -ne '\''\t\t\tA\nB\v\v\v'\''|json -b 7
A\nB
$ echo -ne '\''\t\t\tA\nB\v\v\v'\''|json -b 8
A\nB
$ echo -ne '\''\t\t\tA\nB\v\v\v'\''|json -b 9
A\nB
$ echo -ne '\''\t\t\tA\nB\v\v\v'\''|json -b 10
A\nB
$ echo -ne '\''\t\t\tA\n\xc2\x81\v\v\v'\''|json -b 1
A\n\u0081
$ echo -ne '\''\t\t\tA\n\xc2\x81\v\v\v'\''|json -b 2
A\n\u0081
$ echo -ne '\''\t\t\tA\n\xc2\x81\v\v\v'\''|json -b 3
A\n\u0081
$ echo -ne '\''\t\t\tA\n\xc2\x81\v\v\v'\''|json -b 4
A\n\u0081
$ echo -ne '\''\t\t\tA\n\xc2\x81\v\v\v'\''|json -b 5
A\n\u0081
$ echo -ne '\''\t\t\tA\n\xc2\x81\v\v\v'\''|json -b 6
A\n\u0081
$ echo -ne '\''\t\t\tA\n\xc2\x81\v\v\v'\''|json -b 7
A\n\u0081
$ echo -ne '\''\t\t\tA\n\xc2\x81\v\v\v'\''|json -b 8
A\n\u0081
$ echo -ne '\''\t\t\tA\n\xc2\x81\v\v\v'\''|json -b 9
A\n\u0081
$ echo -ne '\''\t\t\tA\n\xc2\x81\v\v\v'\''|json -b 10
A\n\u0081
$ echo -ne '\''\t\t\tA\n\xc2\x81\v\v\v'\''|json -b 11
A\n\u0081
$ echo -ne '\''\t\t\tA\n\xe0\xa0\x81\v\v\v'\''|json -b 1
A\n\u0801
$ echo -ne '\''\t\t\tA\n\xe0\xa0\x81\v\v\v'\''|json -b 2
A\n\u0801
$ echo -ne '\''\t\t\tA\n\xe0\xa0\x81\v\v\v'\''|json -b 3
A\n\u0801
$ echo -ne '\''\t\t\tA\n\xe0\xa0\x81\v\v\v'\''|json -b 4
A\n\u0801
$ echo -ne '\''\t\t\tA\n\xe0\xa0\x81\v\v\v'\''|json -b 5
A\n\u0801
$ echo -ne '\''\t\t\tA\n\xe0\xa0\x81\v\v\v'\''|json -b 6
A\n\u0801
$ echo -ne '\''\t\t\tA\n\xe0\xa0\x81\v\v\v'\''|json -b 7
A\n\u0801
$ echo -ne '\''\t\t\tA\n\xe0\xa0\x81\v\v\v'\''|json -b 8
A\n\u0801
$ echo -ne '\''\t\t\tA\n\xe0\xa0\x81\v\v\v'\''|json -b 9
A\n\u0801
$ echo -ne '\''\t\t\tA\n\xe0\xa0\x81\v\v\v'\''|json -b 10
A\n\u0801
$ echo -ne '\''\t\t\tA\n\xe0\xa0\x81\v\v\v'\''|json -b 11
A\n\u0801
$ echo -ne '\''\t\t\tA\n\xe0\xa0\x81\v\v\v'\''|json -b 12
A\n\u0801
$ echo -ne '\''\t\t\t\xc2\x80\nB\v\v\v'\''|json -b 1
\u0080\nB
$ echo -ne '\''\t\t\t\xc2\x80\nB\v\v\v'\''|json -b 2
\u0080\nB
$ echo -ne '\''\t\t\t\xc2\x80\nB\v\v\v'\''|json -b 3
\u0080\nB
$ echo -ne '\''\t\t\t\xc2\x80\nB\v\v\v'\''|json -b 4
\u0080\nB
$ echo -ne '\''\t\t\t\xc2\x80\nB\v\v\v'\''|json -b 5
\u0080\nB
$ echo -ne '\''\t\t\t\xc2\x80\nB\v\v\v'\''|json -b 6
\u0080\nB
$ echo -ne '\''\t\t\t\xc2\x80\nB\v\v\v'\''|json -b 7
\u0080\nB
$ echo -ne '\''\t\t\t\xc2\x80\nB\v\v\v'\''|json -b 8
\u0080\nB
$ echo -ne '\''\t\t\t\xc2\x80\nB\v\v\v'\''|json -b 9
\u0080\nB
$ echo -ne '\''\t\t\t\xc2\x80\nB\v\v\v'\''|json -b 10
\u0080\nB
$ echo -ne '\''\t\t\t\xc2\x80\nB\v\v\v'\''|json -b 11
\u0080\nB
$ echo -ne '\''\t\t\t\xc2\x80\n\xc2\x81\v\v\v'\''|json -b 1
\u0080\n\u0081
$ echo -ne '\''\t\t\t\xc2\x80\n\xc2\x81\v\v\v'\''|json -b 2
\u0080\n\u0081
$ echo -ne '\''\t\t\t\xc2\x80\n\xc2\x81\v\v\v'\''|json -b 3
\u0080\n\u0081
$ echo -ne '\''\t\t\t\xc2\x80\n\xc2\x81\v\v\v'\''|json -b 4
\u0080\n\u0081
$ echo -ne '\''\t\t\t\xc2\x80\n\xc2\x81\v\v\v'\''|json -b 5
\u0080\n\u0081
$ echo -ne '\''\t\t\t\xc2\x80\n\xc2\x81\v\v\v'\''|json -b 6
\u0080\n\u0081
$ echo -ne '\''\t\t\t\xc2\x80\n\xc2\x81\v\v\v'\''|json -b 7
\u0080\n\u0081
$ echo -ne '\''\t\t\t\xc2\x80\n\xc2\x81\v\v\v'\''|json -b 8
\u0080\n\u0081
$ echo -ne '\''\t\t\t\xc2\x80\n\xc2\x81\v\v\v'\''|json -b 9
\u0080\n\u0081
$ echo -ne '\''\t\t\t\xc2\x80\n\xc2\x81\v\v\v'\''|json -b 10
\u0080\n\u0081
$ echo -ne '\''\t\t\t\xc2\x80\n\xc2\x81\v\v\v'\''|json -b 11
\u0080\n\u0081
$ echo -ne '\''\t\t\t\xc2\x80\n\xc2\x81\v\v\v'\''|json -b 12
\u0080\n\u0081
$ echo -ne '\''\t\t\t\xc2\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 1
\u0080\n\u0801
$ echo -ne '\''\t\t\t\xc2\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 2
\u0080\n\u0801
$ echo -ne '\''\t\t\t\xc2\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 3
\u0080\n\u0801
$ echo -ne '\''\t\t\t\xc2\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 4
\u0080\n\u0801
$ echo -ne '\''\t\t\t\xc2\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 5
\u0080\n\u0801
$ echo -ne '\''\t\t\t\xc2\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 6
\u0080\n\u0801
$ echo -ne '\''\t\t\t\xc2\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 7
\u0080\n\u0801
$ echo -ne '\''\t\t\t\xc2\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 8
\u0080\n\u0801
$ echo -ne '\''\t\t\t\xc2\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 9
\u0080\n\u0801
$ echo -ne '\''\t\t\t\xc2\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 10
\u0080\n\u0801
$ echo -ne '\''\t\t\t\xc2\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 11
\u0080\n\u0801
$ echo -ne '\''\t\t\t\xc2\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 12
\u0080\n\u0801
$ echo -ne '\''\t\t\t\xc2\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 13
\u0080\n\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\nB\v\v\v'\''|json -b 1
\u0800\nB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\nB\v\v\v'\''|json -b 2
\u0800\nB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\nB\v\v\v'\''|json -b 3
\u0800\nB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\nB\v\v\v'\''|json -b 4
\u0800\nB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\nB\v\v\v'\''|json -b 5
\u0800\nB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\nB\v\v\v'\''|json -b 6
\u0800\nB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\nB\v\v\v'\''|json -b 7
\u0800\nB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\nB\v\v\v'\''|json -b 8
\u0800\nB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\nB\v\v\v'\''|json -b 9
\u0800\nB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\nB\v\v\v'\''|json -b 10
\u0800\nB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\nB\v\v\v'\''|json -b 11
\u0800\nB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\nB\v\v\v'\''|json -b 12
\u0800\nB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\xc2\x81\v\v\v'\''|json -b 1
\u0800\n\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\xc2\x81\v\v\v'\''|json -b 2
\u0800\n\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\xc2\x81\v\v\v'\''|json -b 3
\u0800\n\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\xc2\x81\v\v\v'\''|json -b 4
\u0800\n\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\xc2\x81\v\v\v'\''|json -b 5
\u0800\n\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\xc2\x81\v\v\v'\''|json -b 6
\u0800\n\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\xc2\x81\v\v\v'\''|json -b 7
\u0800\n\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\xc2\x81\v\v\v'\''|json -b 8
\u0800\n\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\xc2\x81\v\v\v'\''|json -b 9
\u0800\n\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\xc2\x81\v\v\v'\''|json -b 10
\u0800\n\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\xc2\x81\v\v\v'\''|json -b 11
\u0800\n\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\xc2\x81\v\v\v'\''|json -b 12
\u0800\n\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\xc2\x81\v\v\v'\''|json -b 13
\u0800\n\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 1
\u0800\n\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 2
\u0800\n\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 3
\u0800\n\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 4
\u0800\n\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 5
\u0800\n\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 6
\u0800\n\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 7
\u0800\n\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 8
\u0800\n\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 9
\u0800\n\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 10
\u0800\n\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 11
\u0800\n\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 12
\u0800\n\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 13
\u0800\n\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 14
\u0800\n\u0801
$ echo -ne '\''\t\t\tA\rB\v\v\v'\''|json -b 1
A\rB
$ echo -ne '\''\t\t\tA\rB\v\v\v'\''|json -b 2
A\rB
$ echo -ne '\''\t\t\tA\rB\v\v\v'\''|json -b 3
A\rB
$ echo -ne '\''\t\t\tA\rB\v\v\v'\''|json -b 4
A\rB
$ echo -ne '\''\t\t\tA\rB\v\v\v'\''|json -b 5
A\rB
$ echo -ne '\''\t\t\tA\rB\v\v\v'\''|json -b 6
A\rB
$ echo -ne '\''\t\t\tA\rB\v\v\v'\''|json -b 7
A\rB
$ echo -ne '\''\t\t\tA\rB\v\v\v'\''|json -b 8
A\rB
$ echo -ne '\''\t\t\tA\rB\v\v\v'\''|json -b 9
A\rB
$ echo -ne '\''\t\t\tA\rB\v\v\v'\''|json -b 10
A\rB
$ echo -ne '\''\t\t\tA\r\xc2\x81\v\v\v'\''|json -b 1
A\r\u0081
$ echo -ne '\''\t\t\tA\r\xc2\x81\v\v\v'\''|json -b 2
A\r\u0081
$ echo -ne '\''\t\t\tA\r\xc2\x81\v\v\v'\''|json -b 3
A\r\u0081
$ echo -ne '\''\t\t\tA\r\xc2\x81\v\v\v'\''|json -b 4
A\r\u0081
$ echo -ne '\''\t\t\tA\r\xc2\x81\v\v\v'\''|json -b 5
A\r\u0081
$ echo -ne '\''\t\t\tA\r\xc2\x81\v\v\v'\''|json -b 6
A\r\u0081
$ echo -ne '\''\t\t\tA\r\xc2\x81\v\v\v'\''|json -b 7
A\r\u0081
$ echo -ne '\''\t\t\tA\r\xc2\x81\v\v\v'\''|json -b 8
A\r\u0081
$ echo -ne '\''\t\t\tA\r\xc2\x81\v\v\v'\''|json -b 9
A\r\u0081
$ echo -ne '\''\t\t\tA\r\xc2\x81\v\v\v'\''|json -b 10
A\r\u0081
$ echo -ne '\''\t\t\tA\r\xc2\x81\v\v\v'\''|json -b 11
A\r\u0081
$ echo -ne '\''\t\t\tA\r\xe0\xa0\x81\v\v\v'\''|json -b 1
A\r\u0801
$ echo -ne '\''\t\t\tA\r\xe0\xa0\x81\v\v\v'\''|json -b 2
A\r\u0801
$ echo -ne '\''\t\t\tA\r\xe0\xa0\x81\v\v\v'\''|json -b 3
A\r\u0801
$ echo -ne '\''\t\t\tA\r\xe0\xa0\x81\v\v\v'\''|json -b 4
A\r\u0801
$ echo -ne '\''\t\t\tA\r\xe0\xa0\x81\v\v\v'\''|json -b 5
A\r\u0801
$ echo -ne '\''\t\t\tA\r\xe0\xa0\x81\v\v\v'\''|json -b 6
A\r\u0801
$ echo -ne '\''\t\t\tA\r\xe0\xa0\x81\v\v\v'\''|json -b 7
A\r\u0801
$ echo -ne '\''\t\t\tA\r\xe0\xa0\x81\v\v\v'\''|json -b 8
A\r\u0801
$ echo -ne '\''\t\t\tA\r\xe0\xa0\x81\v\v\v'\''|json -b 9
A\r\u0801
$ echo -ne '\''\t\t\tA\r\xe0\xa0\x81\v\v\v'\''|json -b 10
A\r\u0801
$ echo -ne '\''\t\t\tA\r\xe0\xa0\x81\v\v\v'\''|json -b 11
A\r\u0801
$ echo -ne '\''\t\t\tA\r\xe0\xa0\x81\v\v\v'\''|json -b 12
A\r\u0801
$ echo -ne '\''\t\t\t\xc2\x80\rB\v\v\v'\''|json -b 1
\u0080\rB
$ echo -ne '\''\t\t\t\xc2\x80\rB\v\v\v'\''|json -b 2
\u0080\rB
$ echo -ne '\''\t\t\t\xc2\x80\rB\v\v\v'\''|json -b 3
\u0080\rB
$ echo -ne '\''\t\t\t\xc2\x80\rB\v\v\v'\''|json -b 4
\u0080\rB
$ echo -ne '\''\t\t\t\xc2\x80\rB\v\v\v'\''|json -b 5
\u0080\rB
$ echo -ne '\''\t\t\t\xc2\x80\rB\v\v\v'\''|json -b 6
\u0080\rB
$ echo -ne '\''\t\t\t\xc2\x80\rB\v\v\v'\''|json -b 7
\u0080\rB
$ echo -ne '\''\t\t\t\xc2\x80\rB\v\v\v'\''|json -b 8
\u0080\rB
$ echo -ne '\''\t\t\t\xc2\x80\rB\v\v\v'\''|json -b 9
\u0080\rB
$ echo -ne '\''\t\t\t\xc2\x80\rB\v\v\v'\''|json -b 10
\u0080\rB
$ echo -ne '\''\t\t\t\xc2\x80\rB\v\v\v'\''|json -b 11
\u0080\rB
$ echo -ne '\''\t\t\t\xc2\x80\r\xc2\x81\v\v\v'\''|json -b 1
\u0080\r\u0081
$ echo -ne '\''\t\t\t\xc2\x80\r\xc2\x81\v\v\v'\''|json -b 2
\u0080\r\u0081
$ echo -ne '\''\t\t\t\xc2\x80\r\xc2\x81\v\v\v'\''|json -b 3
\u0080\r\u0081
$ echo -ne '\''\t\t\t\xc2\x80\r\xc2\x81\v\v\v'\''|json -b 4
\u0080\r\u0081
$ echo -ne '\''\t\t\t\xc2\x80\r\xc2\x81\v\v\v'\''|json -b 5
\u0080\r\u0081
$ echo -ne '\''\t\t\t\xc2\x80\r\xc2\x81\v\v\v'\''|json -b 6
\u0080\r\u0081
$ echo -ne '\''\t\t\t\xc2\x80\r\xc2\x81\v\v\v'\''|json -b 7
\u0080\r\u0081
$ echo -ne '\''\t\t\t\xc2\x80\r\xc2\x81\v\v\v'\''|json -b 8
\u0080\r\u0081
$ echo -ne '\''\t\t\t\xc2\x80\r\xc2\x81\v\v\v'\''|json -b 9
\u0080\r\u0081
$ echo -ne '\''\t\t\t\xc2\x80\r\xc2\x81\v\v\v'\''|json -b 10
\u0080\r\u0081
$ echo -ne '\''\t\t\t\xc2\x80\r\xc2\x81\v\v\v'\''|json -b 11
\u0080\r\u0081
$ echo -ne '\''\t\t\t\xc2\x80\r\xc2\x81\v\v\v'\''|json -b 12
\u0080\r\u0081
$ echo -ne '\''\t\t\t\xc2\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 1
\u0080\r\u0801
$ echo -ne '\''\t\t\t\xc2\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 2
\u0080\r\u0801
$ echo -ne '\''\t\t\t\xc2\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 3
\u0080\r\u0801
$ echo -ne '\''\t\t\t\xc2\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 4
\u0080\r\u0801
$ echo -ne '\''\t\t\t\xc2\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 5
\u0080\r\u0801
$ echo -ne '\''\t\t\t\xc2\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 6
\u0080\r\u0801
$ echo -ne '\''\t\t\t\xc2\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 7
\u0080\r\u0801
$ echo -ne '\''\t\t\t\xc2\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 8
\u0080\r\u0801
$ echo -ne '\''\t\t\t\xc2\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 9
\u0080\r\u0801
$ echo -ne '\''\t\t\t\xc2\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 10
\u0080\r\u0801
$ echo -ne '\''\t\t\t\xc2\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 11
\u0080\r\u0801
$ echo -ne '\''\t\t\t\xc2\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 12
\u0080\r\u0801
$ echo -ne '\''\t\t\t\xc2\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 13
\u0080\r\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\rB\v\v\v'\''|json -b 1
\u0800\rB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\rB\v\v\v'\''|json -b 2
\u0800\rB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\rB\v\v\v'\''|json -b 3
\u0800\rB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\rB\v\v\v'\''|json -b 4
\u0800\rB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\rB\v\v\v'\''|json -b 5
\u0800\rB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\rB\v\v\v'\''|json -b 6
\u0800\rB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\rB\v\v\v'\''|json -b 7
\u0800\rB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\rB\v\v\v'\''|json -b 8
\u0800\rB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\rB\v\v\v'\''|json -b 9
\u0800\rB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\rB\v\v\v'\''|json -b 10
\u0800\rB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\rB\v\v\v'\''|json -b 11
\u0800\rB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\rB\v\v\v'\''|json -b 12
\u0800\rB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\xc2\x81\v\v\v'\''|json -b 1
\u0800\r\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\xc2\x81\v\v\v'\''|json -b 2
\u0800\r\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\xc2\x81\v\v\v'\''|json -b 3
\u0800\r\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\xc2\x81\v\v\v'\''|json -b 4
\u0800\r\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\xc2\x81\v\v\v'\''|json -b 5
\u0800\r\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\xc2\x81\v\v\v'\''|json -b 6
\u0800\r\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\xc2\x81\v\v\v'\''|json -b 7
\u0800\r\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\xc2\x81\v\v\v'\''|json -b 8
\u0800\r\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\xc2\x81\v\v\v'\''|json -b 9
\u0800\r\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\xc2\x81\v\v\v'\''|json -b 10
\u0800\r\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\xc2\x81\v\v\v'\''|json -b 11
\u0800\r\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\xc2\x81\v\v\v'\''|json -b 12
\u0800\r\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\xc2\x81\v\v\v'\''|json -b 13
\u0800\r\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 1
\u0800\r\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 2
\u0800\r\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 3
\u0800\r\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 4
\u0800\r\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 5
\u0800\r\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 6
\u0800\r\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 7
\u0800\r\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 8
\u0800\r\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 9
\u0800\r\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 10
\u0800\r\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 11
\u0800\r\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 12
\u0800\r\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 13
\u0800\r\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 14
\u0800\r\u0801
$ echo -ne '\''\t\t\tA\tB\v\v\v'\''|json -b 1
A\tB
$ echo -ne '\''\t\t\tA\tB\v\v\v'\''|json -b 2
A\tB
$ echo -ne '\''\t\t\tA\tB\v\v\v'\''|json -b 3
A\tB
$ echo -ne '\''\t\t\tA\tB\v\v\v'\''|json -b 4
A\tB
$ echo -ne '\''\t\t\tA\tB\v\v\v'\''|json -b 5
A\tB
$ echo -ne '\''\t\t\tA\tB\v\v\v'\''|json -b 6
A\tB
$ echo -ne '\''\t\t\tA\tB\v\v\v'\''|json -b 7
A\tB
$ echo -ne '\''\t\t\tA\tB\v\v\v'\''|json -b 8
A\tB
$ echo -ne '\''\t\t\tA\tB\v\v\v'\''|json -b 9
A\tB
$ echo -ne '\''\t\t\tA\tB\v\v\v'\''|json -b 10
A\tB
$ echo -ne '\''\t\t\tA\t\xc2\x81\v\v\v'\''|json -b 1
A\t\u0081
$ echo -ne '\''\t\t\tA\t\xc2\x81\v\v\v'\''|json -b 2
A\t\u0081
$ echo -ne '\''\t\t\tA\t\xc2\x81\v\v\v'\''|json -b 3
A\t\u0081
$ echo -ne '\''\t\t\tA\t\xc2\x81\v\v\v'\''|json -b 4
A\t\u0081
$ echo -ne '\''\t\t\tA\t\xc2\x81\v\v\v'\''|json -b 5
A\t\u0081
$ echo -ne '\''\t\t\tA\t\xc2\x81\v\v\v'\''|json -b 6
A\t\u0081
$ echo -ne '\''\t\t\tA\t\xc2\x81\v\v\v'\''|json -b 7
A\t\u0081
$ echo -ne '\''\t\t\tA\t\xc2\x81\v\v\v'\''|json -b 8
A\t\u0081
$ echo -ne '\''\t\t\tA\t\xc2\x81\v\v\v'\''|json -b 9
A\t\u0081
$ echo -ne '\''\t\t\tA\t\xc2\x81\v\v\v'\''|json -b 10
A\t\u0081
$ echo -ne '\''\t\t\tA\t\xc2\x81\v\v\v'\''|json -b 11
A\t\u0081
$ echo -ne '\''\t\t\tA\t\xe0\xa0\x81\v\v\v'\''|json -b 1
A\t\u0801
$ echo -ne '\''\t\t\tA\t\xe0\xa0\x81\v\v\v'\''|json -b 2
A\t\u0801
$ echo -ne '\''\t\t\tA\t\xe0\xa0\x81\v\v\v'\''|json -b 3
A\t\u0801
$ echo -ne '\''\t\t\tA\t\xe0\xa0\x81\v\v\v'\''|json -b 4
A\t\u0801
$ echo -ne '\''\t\t\tA\t\xe0\xa0\x81\v\v\v'\''|json -b 5
A\t\u0801
$ echo -ne '\''\t\t\tA\t\xe0\xa0\x81\v\v\v'\''|json -b 6
A\t\u0801
$ echo -ne '\''\t\t\tA\t\xe0\xa0\x81\v\v\v'\''|json -b 7
A\t\u0801
$ echo -ne '\''\t\t\tA\t\xe0\xa0\x81\v\v\v'\''|json -b 8
A\t\u0801
$ echo -ne '\''\t\t\tA\t\xe0\xa0\x81\v\v\v'\''|json -b 9
A\t\u0801
$ echo -ne '\''\t\t\tA\t\xe0\xa0\x81\v\v\v'\''|json -b 10
A\t\u0801
$ echo -ne '\''\t\t\tA\t\xe0\xa0\x81\v\v\v'\''|json -b 11
A\t\u0801
$ echo -ne '\''\t\t\tA\t\xe0\xa0\x81\v\v\v'\''|json -b 12
A\t\u0801
$ echo -ne '\''\t\t\t\xc2\x80\tB\v\v\v'\''|json -b 1
\u0080\tB
$ echo -ne '\''\t\t\t\xc2\x80\tB\v\v\v'\''|json -b 2
\u0080\tB
$ echo -ne '\''\t\t\t\xc2\x80\tB\v\v\v'\''|json -b 3
\u0080\tB
$ echo -ne '\''\t\t\t\xc2\x80\tB\v\v\v'\''|json -b 4
\u0080\tB
$ echo -ne '\''\t\t\t\xc2\x80\tB\v\v\v'\''|json -b 5
\u0080\tB
$ echo -ne '\''\t\t\t\xc2\x80\tB\v\v\v'\''|json -b 6
\u0080\tB
$ echo -ne '\''\t\t\t\xc2\x80\tB\v\v\v'\''|json -b 7
\u0080\tB
$ echo -ne '\''\t\t\t\xc2\x80\tB\v\v\v'\''|json -b 8
\u0080\tB
$ echo -ne '\''\t\t\t\xc2\x80\tB\v\v\v'\''|json -b 9
\u0080\tB
$ echo -ne '\''\t\t\t\xc2\x80\tB\v\v\v'\''|json -b 10
\u0080\tB
$ echo -ne '\''\t\t\t\xc2\x80\tB\v\v\v'\''|json -b 11
\u0080\tB
$ echo -ne '\''\t\t\t\xc2\x80\t\xc2\x81\v\v\v'\''|json -b 1
\u0080\t\u0081
$ echo -ne '\''\t\t\t\xc2\x80\t\xc2\x81\v\v\v'\''|json -b 2
\u0080\t\u0081
$ echo -ne '\''\t\t\t\xc2\x80\t\xc2\x81\v\v\v'\''|json -b 3
\u0080\t\u0081
$ echo -ne '\''\t\t\t\xc2\x80\t\xc2\x81\v\v\v'\''|json -b 4
\u0080\t\u0081
$ echo -ne '\''\t\t\t\xc2\x80\t\xc2\x81\v\v\v'\''|json -b 5
\u0080\t\u0081
$ echo -ne '\''\t\t\t\xc2\x80\t\xc2\x81\v\v\v'\''|json -b 6
\u0080\t\u0081
$ echo -ne '\''\t\t\t\xc2\x80\t\xc2\x81\v\v\v'\''|json -b 7
\u0080\t\u0081
$ echo -ne '\''\t\t\t\xc2\x80\t\xc2\x81\v\v\v'\''|json -b 8
\u0080\t\u0081
$ echo -ne '\''\t\t\t\xc2\x80\t\xc2\x81\v\v\v'\''|json -b 9
\u0080\t\u0081
$ echo -ne '\''\t\t\t\xc2\x80\t\xc2\x81\v\v\v'\''|json -b 10
\u0080\t\u0081
$ echo -ne '\''\t\t\t\xc2\x80\t\xc2\x81\v\v\v'\''|json -b 11
\u0080\t\u0081
$ echo -ne '\''\t\t\t\xc2\x80\t\xc2\x81\v\v\v'\''|json -b 12
\u0080\t\u0081
$ echo -ne '\''\t\t\t\xc2\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 1
\u0080\t\u0801
$ echo -ne '\''\t\t\t\xc2\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 2
\u0080\t\u0801
$ echo -ne '\''\t\t\t\xc2\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 3
\u0080\t\u0801
$ echo -ne '\''\t\t\t\xc2\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 4
\u0080\t\u0801
$ echo -ne '\''\t\t\t\xc2\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 5
\u0080\t\u0801
$ echo -ne '\''\t\t\t\xc2\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 6
\u0080\t\u0801
$ echo -ne '\''\t\t\t\xc2\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 7
\u0080\t\u0801
$ echo -ne '\''\t\t\t\xc2\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 8
\u0080\t\u0801
$ echo -ne '\''\t\t\t\xc2\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 9
\u0080\t\u0801
$ echo -ne '\''\t\t\t\xc2\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 10
\u0080\t\u0801
$ echo -ne '\''\t\t\t\xc2\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 11
\u0080\t\u0801
$ echo -ne '\''\t\t\t\xc2\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 12
\u0080\t\u0801
$ echo -ne '\''\t\t\t\xc2\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 13
\u0080\t\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\tB\v\v\v'\''|json -b 1
\u0800\tB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\tB\v\v\v'\''|json -b 2
\u0800\tB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\tB\v\v\v'\''|json -b 3
\u0800\tB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\tB\v\v\v'\''|json -b 4
\u0800\tB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\tB\v\v\v'\''|json -b 5
\u0800\tB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\tB\v\v\v'\''|json -b 6
\u0800\tB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\tB\v\v\v'\''|json -b 7
\u0800\tB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\tB\v\v\v'\''|json -b 8
\u0800\tB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\tB\v\v\v'\''|json -b 9
\u0800\tB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\tB\v\v\v'\''|json -b 10
\u0800\tB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\tB\v\v\v'\''|json -b 11
\u0800\tB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\tB\v\v\v'\''|json -b 12
\u0800\tB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\xc2\x81\v\v\v'\''|json -b 1
\u0800\t\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\xc2\x81\v\v\v'\''|json -b 2
\u0800\t\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\xc2\x81\v\v\v'\''|json -b 3
\u0800\t\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\xc2\x81\v\v\v'\''|json -b 4
\u0800\t\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\xc2\x81\v\v\v'\''|json -b 5
\u0800\t\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\xc2\x81\v\v\v'\''|json -b 6
\u0800\t\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\xc2\x81\v\v\v'\''|json -b 7
\u0800\t\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\xc2\x81\v\v\v'\''|json -b 8
\u0800\t\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\xc2\x81\v\v\v'\''|json -b 9
\u0800\t\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\xc2\x81\v\v\v'\''|json -b 10
\u0800\t\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\xc2\x81\v\v\v'\''|json -b 11
\u0800\t\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\xc2\x81\v\v\v'\''|json -b 12
\u0800\t\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\xc2\x81\v\v\v'\''|json -b 13
\u0800\t\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 1
\u0800\t\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 2
\u0800\t\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 3
\u0800\t\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 4
\u0800\t\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 5
\u0800\t\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 6
\u0800\t\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 7
\u0800\t\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 8
\u0800\t\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 9
\u0800\t\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 10
\u0800\t\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 11
\u0800\t\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 12
\u0800\t\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 13
\u0800\t\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 14
\u0800\t\u0801
$ echo -ne '\''\t\t\tA\vB\v\v\v'\''|json -b 1
A\u000bB
$ echo -ne '\''\t\t\tA\vB\v\v\v'\''|json -b 2
A\u000bB
$ echo -ne '\''\t\t\tA\vB\v\v\v'\''|json -b 3
A\u000bB
$ echo -ne '\''\t\t\tA\vB\v\v\v'\''|json -b 4
A\u000bB
$ echo -ne '\''\t\t\tA\vB\v\v\v'\''|json -b 5
A\u000bB
$ echo -ne '\''\t\t\tA\vB\v\v\v'\''|json -b 6
A\u000bB
$ echo -ne '\''\t\t\tA\vB\v\v\v'\''|json -b 7
A\u000bB
$ echo -ne '\''\t\t\tA\vB\v\v\v'\''|json -b 8
A\u000bB
$ echo -ne '\''\t\t\tA\vB\v\v\v'\''|json -b 9
A\u000bB
$ echo -ne '\''\t\t\tA\vB\v\v\v'\''|json -b 10
A\u000bB
$ echo -ne '\''\t\t\tA\v\xc2\x81\v\v\v'\''|json -b 1
A\u000b\u0081
$ echo -ne '\''\t\t\tA\v\xc2\x81\v\v\v'\''|json -b 2
A\u000b\u0081
$ echo -ne '\''\t\t\tA\v\xc2\x81\v\v\v'\''|json -b 3
A\u000b\u0081
$ echo -ne '\''\t\t\tA\v\xc2\x81\v\v\v'\''|json -b 4
A\u000b\u0081
$ echo -ne '\''\t\t\tA\v\xc2\x81\v\v\v'\''|json -b 5
A\u000b\u0081
$ echo -ne '\''\t\t\tA\v\xc2\x81\v\v\v'\''|json -b 6
A\u000b\u0081
$ echo -ne '\''\t\t\tA\v\xc2\x81\v\v\v'\''|json -b 7
A\u000b\u0081
$ echo -ne '\''\t\t\tA\v\xc2\x81\v\v\v'\''|json -b 8
A\u000b\u0081
$ echo -ne '\''\t\t\tA\v\xc2\x81\v\v\v'\''|json -b 9
A\u000b\u0081
$ echo -ne '\''\t\t\tA\v\xc2\x81\v\v\v'\''|json -b 10
A\u000b\u0081
$ echo -ne '\''\t\t\tA\v\xc2\x81\v\v\v'\''|json -b 11
A\u000b\u0081
$ echo -ne '\''\t\t\tA\v\xe0\xa0\x81\v\v\v'\''|json -b 1
A\u000b\u0801
$ echo -ne '\''\t\t\tA\v\xe0\xa0\x81\v\v\v'\''|json -b 2
A\u000b\u0801
$ echo -ne '\''\t\t\tA\v\xe0\xa0\x81\v\v\v'\''|json -b 3
A\u000b\u0801
$ echo -ne '\''\t\t\tA\v\xe0\xa0\x81\v\v\v'\''|json -b 4
A\u000b\u0801
$ echo -ne '\''\t\t\tA\v\xe0\xa0\x81\v\v\v'\''|json -b 5
A\u000b\u0801
$ echo -ne '\''\t\t\tA\v\xe0\xa0\x81\v\v\v'\''|json -b 6
A\u000b\u0801
$ echo -ne '\''\t\t\tA\v\xe0\xa0\x81\v\v\v'\''|json -b 7
A\u000b\u0801
$ echo -ne '\''\t\t\tA\v\xe0\xa0\x81\v\v\v'\''|json -b 8
A\u000b\u0801
$ echo -ne '\''\t\t\tA\v\xe0\xa0\x81\v\v\v'\''|json -b 9
A\u000b\u0801
$ echo -ne '\''\t\t\tA\v\xe0\xa0\x81\v\v\v'\''|json -b 10
A\u000b\u0801
$ echo -ne '\''\t\t\tA\v\xe0\xa0\x81\v\v\v'\''|json -b 11
A\u000b\u0801
$ echo -ne '\''\t\t\tA\v\xe0\xa0\x81\v\v\v'\''|json -b 12
A\u000b\u0801
$ echo -ne '\''\t\t\t\xc2\x80\vB\v\v\v'\''|json -b 1
\u0080\u000bB
$ echo -ne '\''\t\t\t\xc2\x80\vB\v\v\v'\''|json -b 2
\u0080\u000bB
$ echo -ne '\''\t\t\t\xc2\x80\vB\v\v\v'\''|json -b 3
\u0080\u000bB
$ echo -ne '\''\t\t\t\xc2\x80\vB\v\v\v'\''|json -b 4
\u0080\u000bB
$ echo -ne '\''\t\t\t\xc2\x80\vB\v\v\v'\''|json -b 5
\u0080\u000bB
$ echo -ne '\''\t\t\t\xc2\x80\vB\v\v\v'\''|json -b 6
\u0080\u000bB
$ echo -ne '\''\t\t\t\xc2\x80\vB\v\v\v'\''|json -b 7
\u0080\u000bB
$ echo -ne '\''\t\t\t\xc2\x80\vB\v\v\v'\''|json -b 8
\u0080\u000bB
$ echo -ne '\''\t\t\t\xc2\x80\vB\v\v\v'\''|json -b 9
\u0080\u000bB
$ echo -ne '\''\t\t\t\xc2\x80\vB\v\v\v'\''|json -b 10
\u0080\u000bB
$ echo -ne '\''\t\t\t\xc2\x80\vB\v\v\v'\''|json -b 11
\u0080\u000bB
$ echo -ne '\''\t\t\t\xc2\x80\v\xc2\x81\v\v\v'\''|json -b 1
\u0080\u000b\u0081
$ echo -ne '\''\t\t\t\xc2\x80\v\xc2\x81\v\v\v'\''|json -b 2
\u0080\u000b\u0081
$ echo -ne '\''\t\t\t\xc2\x80\v\xc2\x81\v\v\v'\''|json -b 3
\u0080\u000b\u0081
$ echo -ne '\''\t\t\t\xc2\x80\v\xc2\x81\v\v\v'\''|json -b 4
\u0080\u000b\u0081
$ echo -ne '\''\t\t\t\xc2\x80\v\xc2\x81\v\v\v'\''|json -b 5
\u0080\u000b\u0081
$ echo -ne '\''\t\t\t\xc2\x80\v\xc2\x81\v\v\v'\''|json -b 6
\u0080\u000b\u0081
$ echo -ne '\''\t\t\t\xc2\x80\v\xc2\x81\v\v\v'\''|json -b 7
\u0080\u000b\u0081
$ echo -ne '\''\t\t\t\xc2\x80\v\xc2\x81\v\v\v'\''|json -b 8
\u0080\u000b\u0081
$ echo -ne '\''\t\t\t\xc2\x80\v\xc2\x81\v\v\v'\''|json -b 9
\u0080\u000b\u0081
$ echo -ne '\''\t\t\t\xc2\x80\v\xc2\x81\v\v\v'\''|json -b 10
\u0080\u000b\u0081
$ echo -ne '\''\t\t\t\xc2\x80\v\xc2\x81\v\v\v'\''|json -b 11
\u0080\u000b\u0081
$ echo -ne '\''\t\t\t\xc2\x80\v\xc2\x81\v\v\v'\''|json -b 12
\u0080\u000b\u0081
$ echo -ne '\''\t\t\t\xc2\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 1
\u0080\u000b\u0801
$ echo -ne '\''\t\t\t\xc2\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 2
\u0080\u000b\u0801
$ echo -ne '\''\t\t\t\xc2\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 3
\u0080\u000b\u0801
$ echo -ne '\''\t\t\t\xc2\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 4
\u0080\u000b\u0801
$ echo -ne '\''\t\t\t\xc2\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 5
\u0080\u000b\u0801
$ echo -ne '\''\t\t\t\xc2\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 6
\u0080\u000b\u0801
$ echo -ne '\''\t\t\t\xc2\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 7
\u0080\u000b\u0801
$ echo -ne '\''\t\t\t\xc2\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 8
\u0080\u000b\u0801
$ echo -ne '\''\t\t\t\xc2\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 9
\u0080\u000b\u0801
$ echo -ne '\''\t\t\t\xc2\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 10
\u0080\u000b\u0801
$ echo -ne '\''\t\t\t\xc2\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 11
\u0080\u000b\u0801
$ echo -ne '\''\t\t\t\xc2\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 12
\u0080\u000b\u0801
$ echo -ne '\''\t\t\t\xc2\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 13
\u0080\u000b\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\vB\v\v\v'\''|json -b 1
\u0800\u000bB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\vB\v\v\v'\''|json -b 2
\u0800\u000bB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\vB\v\v\v'\''|json -b 3
\u0800\u000bB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\vB\v\v\v'\''|json -b 4
\u0800\u000bB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\vB\v\v\v'\''|json -b 5
\u0800\u000bB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\vB\v\v\v'\''|json -b 6
\u0800\u000bB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\vB\v\v\v'\''|json -b 7
\u0800\u000bB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\vB\v\v\v'\''|json -b 8
\u0800\u000bB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\vB\v\v\v'\''|json -b 9
\u0800\u000bB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\vB\v\v\v'\''|json -b 10
\u0800\u000bB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\vB\v\v\v'\''|json -b 11
\u0800\u000bB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\vB\v\v\v'\''|json -b 12
\u0800\u000bB
$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\xc2\x81\v\v\v'\''|json -b 1
\u0800\u000b\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\xc2\x81\v\v\v'\''|json -b 2
\u0800\u000b\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\xc2\x81\v\v\v'\''|json -b 3
\u0800\u000b\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\xc2\x81\v\v\v'\''|json -b 4
\u0800\u000b\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\xc2\x81\v\v\v'\''|json -b 5
\u0800\u000b\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\xc2\x81\v\v\v'\''|json -b 6
\u0800\u000b\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\xc2\x81\v\v\v'\''|json -b 7
\u0800\u000b\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\xc2\x81\v\v\v'\''|json -b 8
\u0800\u000b\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\xc2\x81\v\v\v'\''|json -b 9
\u0800\u000b\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\xc2\x81\v\v\v'\''|json -b 10
\u0800\u000b\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\xc2\x81\v\v\v'\''|json -b 11
\u0800\u000b\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\xc2\x81\v\v\v'\''|json -b 12
\u0800\u000b\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\xc2\x81\v\v\v'\''|json -b 13
\u0800\u000b\u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 1
\u0800\u000b\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 2
\u0800\u000b\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 3
\u0800\u000b\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 4
\u0800\u000b\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 5
\u0800\u000b\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 6
\u0800\u000b\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 7
\u0800\u000b\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 8
\u0800\u000b\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 9
\u0800\u000b\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 10
\u0800\u000b\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 11
\u0800\u000b\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 12
\u0800\u000b\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 13
\u0800\u000b\u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 14
\u0800\u000b\u0801
$ echo -ne '\''\t\t\tA B\v\v\v'\''|json -b 1
A B
$ echo -ne '\''\t\t\tA B\v\v\v'\''|json -b 2
A B
$ echo -ne '\''\t\t\tA B\v\v\v'\''|json -b 3
A B
$ echo -ne '\''\t\t\tA B\v\v\v'\''|json -b 4
A B
$ echo -ne '\''\t\t\tA B\v\v\v'\''|json -b 5
A B
$ echo -ne '\''\t\t\tA B\v\v\v'\''|json -b 6
A B
$ echo -ne '\''\t\t\tA B\v\v\v'\''|json -b 7
A B
$ echo -ne '\''\t\t\tA B\v\v\v'\''|json -b 8
A B
$ echo -ne '\''\t\t\tA B\v\v\v'\''|json -b 9
A B
$ echo -ne '\''\t\t\tA B\v\v\v'\''|json -b 10
A B
$ echo -ne '\''\t\t\tA \xc2\x81\v\v\v'\''|json -b 1
A \u0081
$ echo -ne '\''\t\t\tA \xc2\x81\v\v\v'\''|json -b 2
A \u0081
$ echo -ne '\''\t\t\tA \xc2\x81\v\v\v'\''|json -b 3
A \u0081
$ echo -ne '\''\t\t\tA \xc2\x81\v\v\v'\''|json -b 4
A \u0081
$ echo -ne '\''\t\t\tA \xc2\x81\v\v\v'\''|json -b 5
A \u0081
$ echo -ne '\''\t\t\tA \xc2\x81\v\v\v'\''|json -b 6
A \u0081
$ echo -ne '\''\t\t\tA \xc2\x81\v\v\v'\''|json -b 7
A \u0081
$ echo -ne '\''\t\t\tA \xc2\x81\v\v\v'\''|json -b 8
A \u0081
$ echo -ne '\''\t\t\tA \xc2\x81\v\v\v'\''|json -b 9
A \u0081
$ echo -ne '\''\t\t\tA \xc2\x81\v\v\v'\''|json -b 10
A \u0081
$ echo -ne '\''\t\t\tA \xc2\x81\v\v\v'\''|json -b 11
A \u0081
$ echo -ne '\''\t\t\tA \xe0\xa0\x81\v\v\v'\''|json -b 1
A \u0801
$ echo -ne '\''\t\t\tA \xe0\xa0\x81\v\v\v'\''|json -b 2
A \u0801
$ echo -ne '\''\t\t\tA \xe0\xa0\x81\v\v\v'\''|json -b 3
A \u0801
$ echo -ne '\''\t\t\tA \xe0\xa0\x81\v\v\v'\''|json -b 4
A \u0801
$ echo -ne '\''\t\t\tA \xe0\xa0\x81\v\v\v'\''|json -b 5
A \u0801
$ echo -ne '\''\t\t\tA \xe0\xa0\x81\v\v\v'\''|json -b 6
A \u0801
$ echo -ne '\''\t\t\tA \xe0\xa0\x81\v\v\v'\''|json -b 7
A \u0801
$ echo -ne '\''\t\t\tA \xe0\xa0\x81\v\v\v'\''|json -b 8
A \u0801
$ echo -ne '\''\t\t\tA \xe0\xa0\x81\v\v\v'\''|json -b 9
A \u0801
$ echo -ne '\''\t\t\tA \xe0\xa0\x81\v\v\v'\''|json -b 10
A \u0801
$ echo -ne '\''\t\t\tA \xe0\xa0\x81\v\v\v'\''|json -b 11
A \u0801
$ echo -ne '\''\t\t\tA \xe0\xa0\x81\v\v\v'\''|json -b 12
A \u0801
$ echo -ne '\''\t\t\t\xc2\x80 B\v\v\v'\''|json -b 1
\u0080 B
$ echo -ne '\''\t\t\t\xc2\x80 B\v\v\v'\''|json -b 2
\u0080 B
$ echo -ne '\''\t\t\t\xc2\x80 B\v\v\v'\''|json -b 3
\u0080 B
$ echo -ne '\''\t\t\t\xc2\x80 B\v\v\v'\''|json -b 4
\u0080 B
$ echo -ne '\''\t\t\t\xc2\x80 B\v\v\v'\''|json -b 5
\u0080 B
$ echo -ne '\''\t\t\t\xc2\x80 B\v\v\v'\''|json -b 6
\u0080 B
$ echo -ne '\''\t\t\t\xc2\x80 B\v\v\v'\''|json -b 7
\u0080 B
$ echo -ne '\''\t\t\t\xc2\x80 B\v\v\v'\''|json -b 8
\u0080 B
$ echo -ne '\''\t\t\t\xc2\x80 B\v\v\v'\''|json -b 9
\u0080 B
$ echo -ne '\''\t\t\t\xc2\x80 B\v\v\v'\''|json -b 10
\u0080 B
$ echo -ne '\''\t\t\t\xc2\x80 B\v\v\v'\''|json -b 11
\u0080 B
$ echo -ne '\''\t\t\t\xc2\x80 \xc2\x81\v\v\v'\''|json -b 1
\u0080 \u0081
$ echo -ne '\''\t\t\t\xc2\x80 \xc2\x81\v\v\v'\''|json -b 2
\u0080 \u0081
$ echo -ne '\''\t\t\t\xc2\x80 \xc2\x81\v\v\v'\''|json -b 3
\u0080 \u0081
$ echo -ne '\''\t\t\t\xc2\x80 \xc2\x81\v\v\v'\''|json -b 4
\u0080 \u0081
$ echo -ne '\''\t\t\t\xc2\x80 \xc2\x81\v\v\v'\''|json -b 5
\u0080 \u0081
$ echo -ne '\''\t\t\t\xc2\x80 \xc2\x81\v\v\v'\''|json -b 6
\u0080 \u0081
$ echo -ne '\''\t\t\t\xc2\x80 \xc2\x81\v\v\v'\''|json -b 7
\u0080 \u0081
$ echo -ne '\''\t\t\t\xc2\x80 \xc2\x81\v\v\v'\''|json -b 8
\u0080 \u0081
$ echo -ne '\''\t\t\t\xc2\x80 \xc2\x81\v\v\v'\''|json -b 9
\u0080 \u0081
$ echo -ne '\''\t\t\t\xc2\x80 \xc2\x81\v\v\v'\''|json -b 10
\u0080 \u0081
$ echo -ne '\''\t\t\t\xc2\x80 \xc2\x81\v\v\v'\''|json -b 11
\u0080 \u0081
$ echo -ne '\''\t\t\t\xc2\x80 \xc2\x81\v\v\v'\''|json -b 12
\u0080 \u0081
$ echo -ne '\''\t\t\t\xc2\x80 \xe0\xa0\x81\v\v\v'\''|json -b 1
\u0080 \u0801
$ echo -ne '\''\t\t\t\xc2\x80 \xe0\xa0\x81\v\v\v'\''|json -b 2
\u0080 \u0801
$ echo -ne '\''\t\t\t\xc2\x80 \xe0\xa0\x81\v\v\v'\''|json -b 3
\u0080 \u0801
$ echo -ne '\''\t\t\t\xc2\x80 \xe0\xa0\x81\v\v\v'\''|json -b 4
\u0080 \u0801
$ echo -ne '\''\t\t\t\xc2\x80 \xe0\xa0\x81\v\v\v'\''|json -b 5
\u0080 \u0801
$ echo -ne '\''\t\t\t\xc2\x80 \xe0\xa0\x81\v\v\v'\''|json -b 6
\u0080 \u0801
$ echo -ne '\''\t\t\t\xc2\x80 \xe0\xa0\x81\v\v\v'\''|json -b 7
\u0080 \u0801
$ echo -ne '\''\t\t\t\xc2\x80 \xe0\xa0\x81\v\v\v'\''|json -b 8
\u0080 \u0801
$ echo -ne '\''\t\t\t\xc2\x80 \xe0\xa0\x81\v\v\v'\''|json -b 9
\u0080 \u0801
$ echo -ne '\''\t\t\t\xc2\x80 \xe0\xa0\x81\v\v\v'\''|json -b 10
\u0080 \u0801
$ echo -ne '\''\t\t\t\xc2\x80 \xe0\xa0\x81\v\v\v'\''|json -b 11
\u0080 \u0801
$ echo -ne '\''\t\t\t\xc2\x80 \xe0\xa0\x81\v\v\v'\''|json -b 12
\u0080 \u0801
$ echo -ne '\''\t\t\t\xc2\x80 \xe0\xa0\x81\v\v\v'\''|json -b 13
\u0080 \u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80 B\v\v\v'\''|json -b 1
\u0800 B
$ echo -ne '\''\t\t\t\xe0\xa0\x80 B\v\v\v'\''|json -b 2
\u0800 B
$ echo -ne '\''\t\t\t\xe0\xa0\x80 B\v\v\v'\''|json -b 3
\u0800 B
$ echo -ne '\''\t\t\t\xe0\xa0\x80 B\v\v\v'\''|json -b 4
\u0800 B
$ echo -ne '\''\t\t\t\xe0\xa0\x80 B\v\v\v'\''|json -b 5
\u0800 B
$ echo -ne '\''\t\t\t\xe0\xa0\x80 B\v\v\v'\''|json -b 6
\u0800 B
$ echo -ne '\''\t\t\t\xe0\xa0\x80 B\v\v\v'\''|json -b 7
\u0800 B
$ echo -ne '\''\t\t\t\xe0\xa0\x80 B\v\v\v'\''|json -b 8
\u0800 B
$ echo -ne '\''\t\t\t\xe0\xa0\x80 B\v\v\v'\''|json -b 9
\u0800 B
$ echo -ne '\''\t\t\t\xe0\xa0\x80 B\v\v\v'\''|json -b 10
\u0800 B
$ echo -ne '\''\t\t\t\xe0\xa0\x80 B\v\v\v'\''|json -b 11
\u0800 B
$ echo -ne '\''\t\t\t\xe0\xa0\x80 B\v\v\v'\''|json -b 12
\u0800 B
$ echo -ne '\''\t\t\t\xe0\xa0\x80 \xc2\x81\v\v\v'\''|json -b 1
\u0800 \u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80 \xc2\x81\v\v\v'\''|json -b 2
\u0800 \u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80 \xc2\x81\v\v\v'\''|json -b 3
\u0800 \u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80 \xc2\x81\v\v\v'\''|json -b 4
\u0800 \u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80 \xc2\x81\v\v\v'\''|json -b 5
\u0800 \u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80 \xc2\x81\v\v\v'\''|json -b 6
\u0800 \u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80 \xc2\x81\v\v\v'\''|json -b 7
\u0800 \u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80 \xc2\x81\v\v\v'\''|json -b 8
\u0800 \u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80 \xc2\x81\v\v\v'\''|json -b 9
\u0800 \u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80 \xc2\x81\v\v\v'\''|json -b 10
\u0800 \u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80 \xc2\x81\v\v\v'\''|json -b 11
\u0800 \u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80 \xc2\x81\v\v\v'\''|json -b 12
\u0800 \u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80 \xc2\x81\v\v\v'\''|json -b 13
\u0800 \u0081
$ echo -ne '\''\t\t\t\xe0\xa0\x80 \xe0\xa0\x81\v\v\v'\''|json -b 1
\u0800 \u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80 \xe0\xa0\x81\v\v\v'\''|json -b 2
\u0800 \u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80 \xe0\xa0\x81\v\v\v'\''|json -b 3
\u0800 \u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80 \xe0\xa0\x81\v\v\v'\''|json -b 4
\u0800 \u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80 \xe0\xa0\x81\v\v\v'\''|json -b 5
\u0800 \u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80 \xe0\xa0\x81\v\v\v'\''|json -b 6
\u0800 \u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80 \xe0\xa0\x81\v\v\v'\''|json -b 7
\u0800 \u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80 \xe0\xa0\x81\v\v\v'\''|json -b 8
\u0800 \u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80 \xe0\xa0\x81\v\v\v'\''|json -b 9
\u0800 \u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80 \xe0\xa0\x81\v\v\v'\''|json -b 10
\u0800 \u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80 \xe0\xa0\x81\v\v\v'\''|json -b 11
\u0800 \u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80 \xe0\xa0\x81\v\v\v'\''|json -b 12
\u0800 \u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80 \xe0\xa0\x81\v\v\v'\''|json -b 13
\u0800 \u0801
$ echo -ne '\''\t\t\t\xe0\xa0\x80 \xe0\xa0\x81\v\v\v'\''|json -b 14
\u0800 \u0801'
) -L trim4.new <(
echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --validate-utf8 --escape-json --trim-spaces --verbose "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --validate-utf8 --escape-json --trim-spaces --verbose "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --validate-utf8 --escape-json --trim-spaces --verbose "$@"; }'

echo '$ echo -ne '\''\t\t\tA\fB\v\v\v'\''|json -b 1'
echo -ne '\t\t\tA\fB\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\fB\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\tA\fB\v\v\v'\''|json -b 2'
echo -ne '\t\t\tA\fB\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\fB\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\tA\fB\v\v\v'\''|json -b 3'
echo -ne '\t\t\tA\fB\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\fB\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\tA\fB\v\v\v'\''|json -b 4'
echo -ne '\t\t\tA\fB\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\fB\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\tA\fB\v\v\v'\''|json -b 5'
echo -ne '\t\t\tA\fB\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\fB\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\tA\fB\v\v\v'\''|json -b 6'
echo -ne '\t\t\tA\fB\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\fB\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\tA\fB\v\v\v'\''|json -b 7'
echo -ne '\t\t\tA\fB\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\fB\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\tA\fB\v\v\v'\''|json -b 8'
echo -ne '\t\t\tA\fB\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\fB\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\tA\fB\v\v\v'\''|json -b 9'
echo -ne '\t\t\tA\fB\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\fB\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\tA\fB\v\v\v'\''|json -b 10'
echo -ne '\t\t\tA\fB\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\fB\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\tA\f\xc2\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\tA\f\xc2\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\f\xc2\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\tA\f\xc2\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\tA\f\xc2\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\f\xc2\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\tA\f\xc2\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\tA\f\xc2\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\f\xc2\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\tA\f\xc2\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\tA\f\xc2\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\f\xc2\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\tA\f\xc2\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\tA\f\xc2\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\f\xc2\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\tA\f\xc2\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\tA\f\xc2\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\f\xc2\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\tA\f\xc2\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\tA\f\xc2\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\f\xc2\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\tA\f\xc2\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\tA\f\xc2\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\f\xc2\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\tA\f\xc2\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\tA\f\xc2\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\f\xc2\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\tA\f\xc2\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\tA\f\xc2\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\f\xc2\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\tA\f\xc2\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\tA\f\xc2\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\f\xc2\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\tA\f\xe0\xa0\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\tA\f\xe0\xa0\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\f\xe0\xa0\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\tA\f\xe0\xa0\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\tA\f\xe0\xa0\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\f\xe0\xa0\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\tA\f\xe0\xa0\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\tA\f\xe0\xa0\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\f\xe0\xa0\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\tA\f\xe0\xa0\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\tA\f\xe0\xa0\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\f\xe0\xa0\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\tA\f\xe0\xa0\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\tA\f\xe0\xa0\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\f\xe0\xa0\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\tA\f\xe0\xa0\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\tA\f\xe0\xa0\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\f\xe0\xa0\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\tA\f\xe0\xa0\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\tA\f\xe0\xa0\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\f\xe0\xa0\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\tA\f\xe0\xa0\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\tA\f\xe0\xa0\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\f\xe0\xa0\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\tA\f\xe0\xa0\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\tA\f\xe0\xa0\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\f\xe0\xa0\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\tA\f\xe0\xa0\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\tA\f\xe0\xa0\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\f\xe0\xa0\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\tA\f\xe0\xa0\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\tA\f\xe0\xa0\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\f\xe0\xa0\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\tA\f\xe0\xa0\x81\v\v\v'\''|json -b 12'
echo -ne '\t\t\tA\f\xe0\xa0\x81\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\f\xe0\xa0\x81\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xc2\x80\fB\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xc2\x80\fB\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\fB\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xc2\x80\fB\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xc2\x80\fB\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\fB\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xc2\x80\fB\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xc2\x80\fB\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\fB\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xc2\x80\fB\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xc2\x80\fB\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\fB\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xc2\x80\fB\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xc2\x80\fB\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\fB\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xc2\x80\fB\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xc2\x80\fB\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\fB\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xc2\x80\fB\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xc2\x80\fB\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\fB\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xc2\x80\fB\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xc2\x80\fB\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\fB\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xc2\x80\fB\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xc2\x80\fB\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\fB\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xc2\x80\fB\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xc2\x80\fB\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\fB\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xc2\x80\fB\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xc2\x80\fB\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\fB\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xc2\x80\f\xc2\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xc2\x80\f\xc2\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\f\xc2\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xc2\x80\f\xc2\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xc2\x80\f\xc2\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\f\xc2\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xc2\x80\f\xc2\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xc2\x80\f\xc2\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\f\xc2\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xc2\x80\f\xc2\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xc2\x80\f\xc2\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\f\xc2\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xc2\x80\f\xc2\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xc2\x80\f\xc2\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\f\xc2\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xc2\x80\f\xc2\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xc2\x80\f\xc2\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\f\xc2\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xc2\x80\f\xc2\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xc2\x80\f\xc2\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\f\xc2\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xc2\x80\f\xc2\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xc2\x80\f\xc2\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\f\xc2\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xc2\x80\f\xc2\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xc2\x80\f\xc2\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\f\xc2\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xc2\x80\f\xc2\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xc2\x80\f\xc2\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\f\xc2\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xc2\x80\f\xc2\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xc2\x80\f\xc2\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\f\xc2\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xc2\x80\f\xc2\x81\v\v\v'\''|json -b 12'
echo -ne '\t\t\t\xc2\x80\f\xc2\x81\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\f\xc2\x81\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xc2\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xc2\x80\f\xe0\xa0\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xc2\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xc2\x80\f\xe0\xa0\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xc2\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xc2\x80\f\xe0\xa0\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xc2\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xc2\x80\f\xe0\xa0\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xc2\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xc2\x80\f\xe0\xa0\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xc2\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xc2\x80\f\xe0\xa0\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xc2\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xc2\x80\f\xe0\xa0\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xc2\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xc2\x80\f\xe0\xa0\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xc2\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xc2\x80\f\xe0\xa0\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xc2\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xc2\x80\f\xe0\xa0\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xc2\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xc2\x80\f\xe0\xa0\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xc2\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 12'
echo -ne '\t\t\t\xc2\x80\f\xe0\xa0\x81\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xc2\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 13'
echo -ne '\t\t\t\xc2\x80\f\xe0\xa0\x81\v\v\v'|json -b 13 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 13'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\fB\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xe0\xa0\x80\fB\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\fB\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\fB\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xe0\xa0\x80\fB\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\fB\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\fB\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xe0\xa0\x80\fB\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\fB\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\fB\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xe0\xa0\x80\fB\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\fB\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\fB\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xe0\xa0\x80\fB\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\fB\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\fB\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xe0\xa0\x80\fB\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\fB\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\fB\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xe0\xa0\x80\fB\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\fB\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\fB\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xe0\xa0\x80\fB\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\fB\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\fB\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xe0\xa0\x80\fB\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\fB\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\fB\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xe0\xa0\x80\fB\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\fB\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\fB\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xe0\xa0\x80\fB\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\fB\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\fB\v\v\v'\''|json -b 12'
echo -ne '\t\t\t\xe0\xa0\x80\fB\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\fB\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\xc2\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xe0\xa0\x80\f\xc2\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\f\xc2\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\xc2\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xe0\xa0\x80\f\xc2\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\f\xc2\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\xc2\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xe0\xa0\x80\f\xc2\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\f\xc2\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\xc2\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xe0\xa0\x80\f\xc2\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\f\xc2\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\xc2\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xe0\xa0\x80\f\xc2\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\f\xc2\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\xc2\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xe0\xa0\x80\f\xc2\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\f\xc2\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\xc2\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xe0\xa0\x80\f\xc2\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\f\xc2\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\xc2\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xe0\xa0\x80\f\xc2\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\f\xc2\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\xc2\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xe0\xa0\x80\f\xc2\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\f\xc2\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\xc2\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xe0\xa0\x80\f\xc2\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\f\xc2\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\xc2\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xe0\xa0\x80\f\xc2\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\f\xc2\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\xc2\x81\v\v\v'\''|json -b 12'
echo -ne '\t\t\t\xe0\xa0\x80\f\xc2\x81\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\f\xc2\x81\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\xc2\x81\v\v\v'\''|json -b 13'
echo -ne '\t\t\t\xe0\xa0\x80\f\xc2\x81\v\v\v'|json -b 13 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\f\xc2\x81\v\v\v'\''|json -b 13'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xe0\xa0\x80\f\xe0\xa0\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xe0\xa0\x80\f\xe0\xa0\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xe0\xa0\x80\f\xe0\xa0\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xe0\xa0\x80\f\xe0\xa0\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xe0\xa0\x80\f\xe0\xa0\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xe0\xa0\x80\f\xe0\xa0\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xe0\xa0\x80\f\xe0\xa0\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xe0\xa0\x80\f\xe0\xa0\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xe0\xa0\x80\f\xe0\xa0\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xe0\xa0\x80\f\xe0\xa0\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xe0\xa0\x80\f\xe0\xa0\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 12'
echo -ne '\t\t\t\xe0\xa0\x80\f\xe0\xa0\x81\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 13'
echo -ne '\t\t\t\xe0\xa0\x80\f\xe0\xa0\x81\v\v\v'|json -b 13 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 13'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 14'
echo -ne '\t\t\t\xe0\xa0\x80\f\xe0\xa0\x81\v\v\v'|json -b 14 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\f\xe0\xa0\x81\v\v\v'\''|json -b 14'

echo '$ echo -ne '\''\t\t\tA\nB\v\v\v'\''|json -b 1'
echo -ne '\t\t\tA\nB\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\nB\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\tA\nB\v\v\v'\''|json -b 2'
echo -ne '\t\t\tA\nB\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\nB\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\tA\nB\v\v\v'\''|json -b 3'
echo -ne '\t\t\tA\nB\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\nB\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\tA\nB\v\v\v'\''|json -b 4'
echo -ne '\t\t\tA\nB\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\nB\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\tA\nB\v\v\v'\''|json -b 5'
echo -ne '\t\t\tA\nB\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\nB\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\tA\nB\v\v\v'\''|json -b 6'
echo -ne '\t\t\tA\nB\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\nB\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\tA\nB\v\v\v'\''|json -b 7'
echo -ne '\t\t\tA\nB\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\nB\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\tA\nB\v\v\v'\''|json -b 8'
echo -ne '\t\t\tA\nB\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\nB\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\tA\nB\v\v\v'\''|json -b 9'
echo -ne '\t\t\tA\nB\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\nB\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\tA\nB\v\v\v'\''|json -b 10'
echo -ne '\t\t\tA\nB\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\nB\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\tA\n\xc2\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\tA\n\xc2\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\n\xc2\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\tA\n\xc2\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\tA\n\xc2\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\n\xc2\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\tA\n\xc2\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\tA\n\xc2\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\n\xc2\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\tA\n\xc2\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\tA\n\xc2\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\n\xc2\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\tA\n\xc2\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\tA\n\xc2\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\n\xc2\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\tA\n\xc2\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\tA\n\xc2\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\n\xc2\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\tA\n\xc2\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\tA\n\xc2\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\n\xc2\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\tA\n\xc2\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\tA\n\xc2\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\n\xc2\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\tA\n\xc2\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\tA\n\xc2\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\n\xc2\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\tA\n\xc2\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\tA\n\xc2\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\n\xc2\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\tA\n\xc2\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\tA\n\xc2\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\n\xc2\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\tA\n\xe0\xa0\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\tA\n\xe0\xa0\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\n\xe0\xa0\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\tA\n\xe0\xa0\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\tA\n\xe0\xa0\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\n\xe0\xa0\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\tA\n\xe0\xa0\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\tA\n\xe0\xa0\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\n\xe0\xa0\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\tA\n\xe0\xa0\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\tA\n\xe0\xa0\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\n\xe0\xa0\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\tA\n\xe0\xa0\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\tA\n\xe0\xa0\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\n\xe0\xa0\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\tA\n\xe0\xa0\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\tA\n\xe0\xa0\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\n\xe0\xa0\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\tA\n\xe0\xa0\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\tA\n\xe0\xa0\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\n\xe0\xa0\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\tA\n\xe0\xa0\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\tA\n\xe0\xa0\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\n\xe0\xa0\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\tA\n\xe0\xa0\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\tA\n\xe0\xa0\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\n\xe0\xa0\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\tA\n\xe0\xa0\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\tA\n\xe0\xa0\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\n\xe0\xa0\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\tA\n\xe0\xa0\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\tA\n\xe0\xa0\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\n\xe0\xa0\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\tA\n\xe0\xa0\x81\v\v\v'\''|json -b 12'
echo -ne '\t\t\tA\n\xe0\xa0\x81\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\n\xe0\xa0\x81\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xc2\x80\nB\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xc2\x80\nB\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\nB\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xc2\x80\nB\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xc2\x80\nB\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\nB\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xc2\x80\nB\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xc2\x80\nB\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\nB\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xc2\x80\nB\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xc2\x80\nB\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\nB\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xc2\x80\nB\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xc2\x80\nB\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\nB\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xc2\x80\nB\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xc2\x80\nB\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\nB\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xc2\x80\nB\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xc2\x80\nB\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\nB\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xc2\x80\nB\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xc2\x80\nB\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\nB\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xc2\x80\nB\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xc2\x80\nB\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\nB\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xc2\x80\nB\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xc2\x80\nB\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\nB\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xc2\x80\nB\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xc2\x80\nB\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\nB\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xc2\x80\n\xc2\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xc2\x80\n\xc2\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\n\xc2\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xc2\x80\n\xc2\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xc2\x80\n\xc2\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\n\xc2\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xc2\x80\n\xc2\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xc2\x80\n\xc2\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\n\xc2\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xc2\x80\n\xc2\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xc2\x80\n\xc2\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\n\xc2\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xc2\x80\n\xc2\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xc2\x80\n\xc2\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\n\xc2\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xc2\x80\n\xc2\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xc2\x80\n\xc2\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\n\xc2\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xc2\x80\n\xc2\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xc2\x80\n\xc2\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\n\xc2\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xc2\x80\n\xc2\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xc2\x80\n\xc2\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\n\xc2\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xc2\x80\n\xc2\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xc2\x80\n\xc2\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\n\xc2\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xc2\x80\n\xc2\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xc2\x80\n\xc2\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\n\xc2\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xc2\x80\n\xc2\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xc2\x80\n\xc2\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\n\xc2\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xc2\x80\n\xc2\x81\v\v\v'\''|json -b 12'
echo -ne '\t\t\t\xc2\x80\n\xc2\x81\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\n\xc2\x81\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xc2\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xc2\x80\n\xe0\xa0\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xc2\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xc2\x80\n\xe0\xa0\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xc2\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xc2\x80\n\xe0\xa0\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xc2\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xc2\x80\n\xe0\xa0\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xc2\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xc2\x80\n\xe0\xa0\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xc2\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xc2\x80\n\xe0\xa0\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xc2\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xc2\x80\n\xe0\xa0\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xc2\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xc2\x80\n\xe0\xa0\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xc2\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xc2\x80\n\xe0\xa0\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xc2\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xc2\x80\n\xe0\xa0\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xc2\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xc2\x80\n\xe0\xa0\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xc2\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 12'
echo -ne '\t\t\t\xc2\x80\n\xe0\xa0\x81\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xc2\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 13'
echo -ne '\t\t\t\xc2\x80\n\xe0\xa0\x81\v\v\v'|json -b 13 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 13'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\nB\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xe0\xa0\x80\nB\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\nB\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\nB\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xe0\xa0\x80\nB\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\nB\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\nB\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xe0\xa0\x80\nB\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\nB\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\nB\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xe0\xa0\x80\nB\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\nB\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\nB\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xe0\xa0\x80\nB\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\nB\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\nB\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xe0\xa0\x80\nB\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\nB\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\nB\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xe0\xa0\x80\nB\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\nB\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\nB\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xe0\xa0\x80\nB\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\nB\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\nB\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xe0\xa0\x80\nB\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\nB\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\nB\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xe0\xa0\x80\nB\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\nB\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\nB\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xe0\xa0\x80\nB\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\nB\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\nB\v\v\v'\''|json -b 12'
echo -ne '\t\t\t\xe0\xa0\x80\nB\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\nB\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\xc2\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xe0\xa0\x80\n\xc2\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\n\xc2\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\xc2\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xe0\xa0\x80\n\xc2\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\n\xc2\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\xc2\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xe0\xa0\x80\n\xc2\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\n\xc2\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\xc2\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xe0\xa0\x80\n\xc2\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\n\xc2\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\xc2\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xe0\xa0\x80\n\xc2\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\n\xc2\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\xc2\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xe0\xa0\x80\n\xc2\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\n\xc2\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\xc2\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xe0\xa0\x80\n\xc2\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\n\xc2\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\xc2\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xe0\xa0\x80\n\xc2\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\n\xc2\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\xc2\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xe0\xa0\x80\n\xc2\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\n\xc2\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\xc2\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xe0\xa0\x80\n\xc2\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\n\xc2\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\xc2\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xe0\xa0\x80\n\xc2\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\n\xc2\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\xc2\x81\v\v\v'\''|json -b 12'
echo -ne '\t\t\t\xe0\xa0\x80\n\xc2\x81\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\n\xc2\x81\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\xc2\x81\v\v\v'\''|json -b 13'
echo -ne '\t\t\t\xe0\xa0\x80\n\xc2\x81\v\v\v'|json -b 13 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\n\xc2\x81\v\v\v'\''|json -b 13'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xe0\xa0\x80\n\xe0\xa0\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xe0\xa0\x80\n\xe0\xa0\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xe0\xa0\x80\n\xe0\xa0\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xe0\xa0\x80\n\xe0\xa0\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xe0\xa0\x80\n\xe0\xa0\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xe0\xa0\x80\n\xe0\xa0\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xe0\xa0\x80\n\xe0\xa0\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xe0\xa0\x80\n\xe0\xa0\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xe0\xa0\x80\n\xe0\xa0\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xe0\xa0\x80\n\xe0\xa0\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xe0\xa0\x80\n\xe0\xa0\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 12'
echo -ne '\t\t\t\xe0\xa0\x80\n\xe0\xa0\x81\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 13'
echo -ne '\t\t\t\xe0\xa0\x80\n\xe0\xa0\x81\v\v\v'|json -b 13 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 13'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 14'
echo -ne '\t\t\t\xe0\xa0\x80\n\xe0\xa0\x81\v\v\v'|json -b 14 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\n\xe0\xa0\x81\v\v\v'\''|json -b 14'

echo '$ echo -ne '\''\t\t\tA\rB\v\v\v'\''|json -b 1'
echo -ne '\t\t\tA\rB\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\rB\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\tA\rB\v\v\v'\''|json -b 2'
echo -ne '\t\t\tA\rB\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\rB\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\tA\rB\v\v\v'\''|json -b 3'
echo -ne '\t\t\tA\rB\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\rB\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\tA\rB\v\v\v'\''|json -b 4'
echo -ne '\t\t\tA\rB\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\rB\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\tA\rB\v\v\v'\''|json -b 5'
echo -ne '\t\t\tA\rB\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\rB\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\tA\rB\v\v\v'\''|json -b 6'
echo -ne '\t\t\tA\rB\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\rB\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\tA\rB\v\v\v'\''|json -b 7'
echo -ne '\t\t\tA\rB\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\rB\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\tA\rB\v\v\v'\''|json -b 8'
echo -ne '\t\t\tA\rB\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\rB\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\tA\rB\v\v\v'\''|json -b 9'
echo -ne '\t\t\tA\rB\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\rB\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\tA\rB\v\v\v'\''|json -b 10'
echo -ne '\t\t\tA\rB\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\rB\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\tA\r\xc2\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\tA\r\xc2\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\r\xc2\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\tA\r\xc2\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\tA\r\xc2\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\r\xc2\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\tA\r\xc2\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\tA\r\xc2\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\r\xc2\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\tA\r\xc2\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\tA\r\xc2\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\r\xc2\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\tA\r\xc2\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\tA\r\xc2\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\r\xc2\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\tA\r\xc2\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\tA\r\xc2\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\r\xc2\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\tA\r\xc2\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\tA\r\xc2\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\r\xc2\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\tA\r\xc2\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\tA\r\xc2\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\r\xc2\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\tA\r\xc2\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\tA\r\xc2\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\r\xc2\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\tA\r\xc2\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\tA\r\xc2\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\r\xc2\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\tA\r\xc2\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\tA\r\xc2\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\r\xc2\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\tA\r\xe0\xa0\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\tA\r\xe0\xa0\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\r\xe0\xa0\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\tA\r\xe0\xa0\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\tA\r\xe0\xa0\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\r\xe0\xa0\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\tA\r\xe0\xa0\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\tA\r\xe0\xa0\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\r\xe0\xa0\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\tA\r\xe0\xa0\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\tA\r\xe0\xa0\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\r\xe0\xa0\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\tA\r\xe0\xa0\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\tA\r\xe0\xa0\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\r\xe0\xa0\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\tA\r\xe0\xa0\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\tA\r\xe0\xa0\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\r\xe0\xa0\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\tA\r\xe0\xa0\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\tA\r\xe0\xa0\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\r\xe0\xa0\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\tA\r\xe0\xa0\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\tA\r\xe0\xa0\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\r\xe0\xa0\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\tA\r\xe0\xa0\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\tA\r\xe0\xa0\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\r\xe0\xa0\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\tA\r\xe0\xa0\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\tA\r\xe0\xa0\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\r\xe0\xa0\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\tA\r\xe0\xa0\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\tA\r\xe0\xa0\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\r\xe0\xa0\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\tA\r\xe0\xa0\x81\v\v\v'\''|json -b 12'
echo -ne '\t\t\tA\r\xe0\xa0\x81\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\r\xe0\xa0\x81\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xc2\x80\rB\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xc2\x80\rB\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\rB\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xc2\x80\rB\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xc2\x80\rB\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\rB\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xc2\x80\rB\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xc2\x80\rB\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\rB\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xc2\x80\rB\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xc2\x80\rB\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\rB\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xc2\x80\rB\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xc2\x80\rB\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\rB\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xc2\x80\rB\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xc2\x80\rB\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\rB\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xc2\x80\rB\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xc2\x80\rB\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\rB\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xc2\x80\rB\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xc2\x80\rB\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\rB\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xc2\x80\rB\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xc2\x80\rB\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\rB\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xc2\x80\rB\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xc2\x80\rB\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\rB\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xc2\x80\rB\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xc2\x80\rB\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\rB\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xc2\x80\r\xc2\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xc2\x80\r\xc2\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\r\xc2\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xc2\x80\r\xc2\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xc2\x80\r\xc2\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\r\xc2\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xc2\x80\r\xc2\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xc2\x80\r\xc2\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\r\xc2\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xc2\x80\r\xc2\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xc2\x80\r\xc2\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\r\xc2\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xc2\x80\r\xc2\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xc2\x80\r\xc2\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\r\xc2\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xc2\x80\r\xc2\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xc2\x80\r\xc2\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\r\xc2\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xc2\x80\r\xc2\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xc2\x80\r\xc2\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\r\xc2\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xc2\x80\r\xc2\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xc2\x80\r\xc2\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\r\xc2\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xc2\x80\r\xc2\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xc2\x80\r\xc2\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\r\xc2\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xc2\x80\r\xc2\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xc2\x80\r\xc2\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\r\xc2\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xc2\x80\r\xc2\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xc2\x80\r\xc2\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\r\xc2\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xc2\x80\r\xc2\x81\v\v\v'\''|json -b 12'
echo -ne '\t\t\t\xc2\x80\r\xc2\x81\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\r\xc2\x81\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xc2\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xc2\x80\r\xe0\xa0\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xc2\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xc2\x80\r\xe0\xa0\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xc2\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xc2\x80\r\xe0\xa0\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xc2\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xc2\x80\r\xe0\xa0\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xc2\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xc2\x80\r\xe0\xa0\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xc2\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xc2\x80\r\xe0\xa0\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xc2\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xc2\x80\r\xe0\xa0\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xc2\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xc2\x80\r\xe0\xa0\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xc2\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xc2\x80\r\xe0\xa0\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xc2\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xc2\x80\r\xe0\xa0\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xc2\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xc2\x80\r\xe0\xa0\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xc2\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 12'
echo -ne '\t\t\t\xc2\x80\r\xe0\xa0\x81\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xc2\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 13'
echo -ne '\t\t\t\xc2\x80\r\xe0\xa0\x81\v\v\v'|json -b 13 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 13'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\rB\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xe0\xa0\x80\rB\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\rB\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\rB\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xe0\xa0\x80\rB\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\rB\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\rB\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xe0\xa0\x80\rB\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\rB\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\rB\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xe0\xa0\x80\rB\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\rB\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\rB\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xe0\xa0\x80\rB\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\rB\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\rB\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xe0\xa0\x80\rB\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\rB\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\rB\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xe0\xa0\x80\rB\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\rB\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\rB\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xe0\xa0\x80\rB\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\rB\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\rB\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xe0\xa0\x80\rB\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\rB\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\rB\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xe0\xa0\x80\rB\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\rB\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\rB\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xe0\xa0\x80\rB\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\rB\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\rB\v\v\v'\''|json -b 12'
echo -ne '\t\t\t\xe0\xa0\x80\rB\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\rB\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\xc2\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xe0\xa0\x80\r\xc2\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\r\xc2\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\xc2\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xe0\xa0\x80\r\xc2\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\r\xc2\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\xc2\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xe0\xa0\x80\r\xc2\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\r\xc2\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\xc2\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xe0\xa0\x80\r\xc2\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\r\xc2\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\xc2\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xe0\xa0\x80\r\xc2\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\r\xc2\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\xc2\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xe0\xa0\x80\r\xc2\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\r\xc2\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\xc2\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xe0\xa0\x80\r\xc2\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\r\xc2\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\xc2\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xe0\xa0\x80\r\xc2\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\r\xc2\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\xc2\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xe0\xa0\x80\r\xc2\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\r\xc2\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\xc2\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xe0\xa0\x80\r\xc2\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\r\xc2\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\xc2\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xe0\xa0\x80\r\xc2\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\r\xc2\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\xc2\x81\v\v\v'\''|json -b 12'
echo -ne '\t\t\t\xe0\xa0\x80\r\xc2\x81\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\r\xc2\x81\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\xc2\x81\v\v\v'\''|json -b 13'
echo -ne '\t\t\t\xe0\xa0\x80\r\xc2\x81\v\v\v'|json -b 13 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\r\xc2\x81\v\v\v'\''|json -b 13'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xe0\xa0\x80\r\xe0\xa0\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xe0\xa0\x80\r\xe0\xa0\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xe0\xa0\x80\r\xe0\xa0\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xe0\xa0\x80\r\xe0\xa0\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xe0\xa0\x80\r\xe0\xa0\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xe0\xa0\x80\r\xe0\xa0\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xe0\xa0\x80\r\xe0\xa0\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xe0\xa0\x80\r\xe0\xa0\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xe0\xa0\x80\r\xe0\xa0\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xe0\xa0\x80\r\xe0\xa0\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xe0\xa0\x80\r\xe0\xa0\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 12'
echo -ne '\t\t\t\xe0\xa0\x80\r\xe0\xa0\x81\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 13'
echo -ne '\t\t\t\xe0\xa0\x80\r\xe0\xa0\x81\v\v\v'|json -b 13 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 13'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 14'
echo -ne '\t\t\t\xe0\xa0\x80\r\xe0\xa0\x81\v\v\v'|json -b 14 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\r\xe0\xa0\x81\v\v\v'\''|json -b 14'

echo '$ echo -ne '\''\t\t\tA\tB\v\v\v'\''|json -b 1'
echo -ne '\t\t\tA\tB\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\tB\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\tA\tB\v\v\v'\''|json -b 2'
echo -ne '\t\t\tA\tB\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\tB\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\tA\tB\v\v\v'\''|json -b 3'
echo -ne '\t\t\tA\tB\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\tB\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\tA\tB\v\v\v'\''|json -b 4'
echo -ne '\t\t\tA\tB\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\tB\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\tA\tB\v\v\v'\''|json -b 5'
echo -ne '\t\t\tA\tB\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\tB\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\tA\tB\v\v\v'\''|json -b 6'
echo -ne '\t\t\tA\tB\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\tB\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\tA\tB\v\v\v'\''|json -b 7'
echo -ne '\t\t\tA\tB\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\tB\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\tA\tB\v\v\v'\''|json -b 8'
echo -ne '\t\t\tA\tB\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\tB\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\tA\tB\v\v\v'\''|json -b 9'
echo -ne '\t\t\tA\tB\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\tB\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\tA\tB\v\v\v'\''|json -b 10'
echo -ne '\t\t\tA\tB\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\tB\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\tA\t\xc2\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\tA\t\xc2\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\t\xc2\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\tA\t\xc2\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\tA\t\xc2\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\t\xc2\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\tA\t\xc2\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\tA\t\xc2\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\t\xc2\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\tA\t\xc2\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\tA\t\xc2\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\t\xc2\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\tA\t\xc2\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\tA\t\xc2\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\t\xc2\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\tA\t\xc2\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\tA\t\xc2\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\t\xc2\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\tA\t\xc2\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\tA\t\xc2\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\t\xc2\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\tA\t\xc2\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\tA\t\xc2\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\t\xc2\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\tA\t\xc2\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\tA\t\xc2\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\t\xc2\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\tA\t\xc2\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\tA\t\xc2\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\t\xc2\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\tA\t\xc2\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\tA\t\xc2\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\t\xc2\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\tA\t\xe0\xa0\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\tA\t\xe0\xa0\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\t\xe0\xa0\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\tA\t\xe0\xa0\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\tA\t\xe0\xa0\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\t\xe0\xa0\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\tA\t\xe0\xa0\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\tA\t\xe0\xa0\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\t\xe0\xa0\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\tA\t\xe0\xa0\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\tA\t\xe0\xa0\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\t\xe0\xa0\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\tA\t\xe0\xa0\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\tA\t\xe0\xa0\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\t\xe0\xa0\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\tA\t\xe0\xa0\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\tA\t\xe0\xa0\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\t\xe0\xa0\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\tA\t\xe0\xa0\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\tA\t\xe0\xa0\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\t\xe0\xa0\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\tA\t\xe0\xa0\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\tA\t\xe0\xa0\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\t\xe0\xa0\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\tA\t\xe0\xa0\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\tA\t\xe0\xa0\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\t\xe0\xa0\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\tA\t\xe0\xa0\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\tA\t\xe0\xa0\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\t\xe0\xa0\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\tA\t\xe0\xa0\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\tA\t\xe0\xa0\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\t\xe0\xa0\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\tA\t\xe0\xa0\x81\v\v\v'\''|json -b 12'
echo -ne '\t\t\tA\t\xe0\xa0\x81\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\t\xe0\xa0\x81\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xc2\x80\tB\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xc2\x80\tB\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\tB\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xc2\x80\tB\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xc2\x80\tB\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\tB\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xc2\x80\tB\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xc2\x80\tB\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\tB\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xc2\x80\tB\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xc2\x80\tB\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\tB\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xc2\x80\tB\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xc2\x80\tB\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\tB\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xc2\x80\tB\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xc2\x80\tB\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\tB\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xc2\x80\tB\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xc2\x80\tB\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\tB\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xc2\x80\tB\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xc2\x80\tB\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\tB\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xc2\x80\tB\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xc2\x80\tB\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\tB\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xc2\x80\tB\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xc2\x80\tB\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\tB\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xc2\x80\tB\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xc2\x80\tB\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\tB\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xc2\x80\t\xc2\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xc2\x80\t\xc2\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\t\xc2\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xc2\x80\t\xc2\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xc2\x80\t\xc2\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\t\xc2\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xc2\x80\t\xc2\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xc2\x80\t\xc2\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\t\xc2\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xc2\x80\t\xc2\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xc2\x80\t\xc2\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\t\xc2\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xc2\x80\t\xc2\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xc2\x80\t\xc2\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\t\xc2\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xc2\x80\t\xc2\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xc2\x80\t\xc2\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\t\xc2\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xc2\x80\t\xc2\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xc2\x80\t\xc2\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\t\xc2\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xc2\x80\t\xc2\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xc2\x80\t\xc2\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\t\xc2\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xc2\x80\t\xc2\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xc2\x80\t\xc2\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\t\xc2\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xc2\x80\t\xc2\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xc2\x80\t\xc2\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\t\xc2\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xc2\x80\t\xc2\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xc2\x80\t\xc2\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\t\xc2\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xc2\x80\t\xc2\x81\v\v\v'\''|json -b 12'
echo -ne '\t\t\t\xc2\x80\t\xc2\x81\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\t\xc2\x81\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xc2\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xc2\x80\t\xe0\xa0\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xc2\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xc2\x80\t\xe0\xa0\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xc2\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xc2\x80\t\xe0\xa0\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xc2\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xc2\x80\t\xe0\xa0\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xc2\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xc2\x80\t\xe0\xa0\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xc2\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xc2\x80\t\xe0\xa0\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xc2\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xc2\x80\t\xe0\xa0\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xc2\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xc2\x80\t\xe0\xa0\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xc2\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xc2\x80\t\xe0\xa0\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xc2\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xc2\x80\t\xe0\xa0\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xc2\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xc2\x80\t\xe0\xa0\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xc2\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 12'
echo -ne '\t\t\t\xc2\x80\t\xe0\xa0\x81\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xc2\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 13'
echo -ne '\t\t\t\xc2\x80\t\xe0\xa0\x81\v\v\v'|json -b 13 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 13'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\tB\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xe0\xa0\x80\tB\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\tB\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\tB\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xe0\xa0\x80\tB\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\tB\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\tB\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xe0\xa0\x80\tB\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\tB\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\tB\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xe0\xa0\x80\tB\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\tB\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\tB\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xe0\xa0\x80\tB\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\tB\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\tB\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xe0\xa0\x80\tB\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\tB\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\tB\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xe0\xa0\x80\tB\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\tB\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\tB\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xe0\xa0\x80\tB\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\tB\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\tB\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xe0\xa0\x80\tB\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\tB\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\tB\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xe0\xa0\x80\tB\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\tB\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\tB\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xe0\xa0\x80\tB\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\tB\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\tB\v\v\v'\''|json -b 12'
echo -ne '\t\t\t\xe0\xa0\x80\tB\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\tB\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\xc2\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xe0\xa0\x80\t\xc2\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\t\xc2\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\xc2\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xe0\xa0\x80\t\xc2\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\t\xc2\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\xc2\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xe0\xa0\x80\t\xc2\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\t\xc2\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\xc2\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xe0\xa0\x80\t\xc2\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\t\xc2\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\xc2\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xe0\xa0\x80\t\xc2\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\t\xc2\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\xc2\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xe0\xa0\x80\t\xc2\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\t\xc2\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\xc2\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xe0\xa0\x80\t\xc2\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\t\xc2\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\xc2\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xe0\xa0\x80\t\xc2\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\t\xc2\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\xc2\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xe0\xa0\x80\t\xc2\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\t\xc2\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\xc2\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xe0\xa0\x80\t\xc2\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\t\xc2\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\xc2\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xe0\xa0\x80\t\xc2\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\t\xc2\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\xc2\x81\v\v\v'\''|json -b 12'
echo -ne '\t\t\t\xe0\xa0\x80\t\xc2\x81\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\t\xc2\x81\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\xc2\x81\v\v\v'\''|json -b 13'
echo -ne '\t\t\t\xe0\xa0\x80\t\xc2\x81\v\v\v'|json -b 13 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\t\xc2\x81\v\v\v'\''|json -b 13'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xe0\xa0\x80\t\xe0\xa0\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xe0\xa0\x80\t\xe0\xa0\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xe0\xa0\x80\t\xe0\xa0\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xe0\xa0\x80\t\xe0\xa0\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xe0\xa0\x80\t\xe0\xa0\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xe0\xa0\x80\t\xe0\xa0\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xe0\xa0\x80\t\xe0\xa0\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xe0\xa0\x80\t\xe0\xa0\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xe0\xa0\x80\t\xe0\xa0\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xe0\xa0\x80\t\xe0\xa0\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xe0\xa0\x80\t\xe0\xa0\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 12'
echo -ne '\t\t\t\xe0\xa0\x80\t\xe0\xa0\x81\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 13'
echo -ne '\t\t\t\xe0\xa0\x80\t\xe0\xa0\x81\v\v\v'|json -b 13 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 13'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 14'
echo -ne '\t\t\t\xe0\xa0\x80\t\xe0\xa0\x81\v\v\v'|json -b 14 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\t\xe0\xa0\x81\v\v\v'\''|json -b 14'

echo '$ echo -ne '\''\t\t\tA\vB\v\v\v'\''|json -b 1'
echo -ne '\t\t\tA\vB\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\vB\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\tA\vB\v\v\v'\''|json -b 2'
echo -ne '\t\t\tA\vB\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\vB\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\tA\vB\v\v\v'\''|json -b 3'
echo -ne '\t\t\tA\vB\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\vB\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\tA\vB\v\v\v'\''|json -b 4'
echo -ne '\t\t\tA\vB\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\vB\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\tA\vB\v\v\v'\''|json -b 5'
echo -ne '\t\t\tA\vB\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\vB\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\tA\vB\v\v\v'\''|json -b 6'
echo -ne '\t\t\tA\vB\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\vB\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\tA\vB\v\v\v'\''|json -b 7'
echo -ne '\t\t\tA\vB\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\vB\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\tA\vB\v\v\v'\''|json -b 8'
echo -ne '\t\t\tA\vB\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\vB\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\tA\vB\v\v\v'\''|json -b 9'
echo -ne '\t\t\tA\vB\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\vB\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\tA\vB\v\v\v'\''|json -b 10'
echo -ne '\t\t\tA\vB\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\vB\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\tA\v\xc2\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\tA\v\xc2\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\v\xc2\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\tA\v\xc2\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\tA\v\xc2\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\v\xc2\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\tA\v\xc2\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\tA\v\xc2\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\v\xc2\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\tA\v\xc2\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\tA\v\xc2\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\v\xc2\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\tA\v\xc2\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\tA\v\xc2\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\v\xc2\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\tA\v\xc2\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\tA\v\xc2\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\v\xc2\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\tA\v\xc2\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\tA\v\xc2\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\v\xc2\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\tA\v\xc2\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\tA\v\xc2\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\v\xc2\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\tA\v\xc2\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\tA\v\xc2\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\v\xc2\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\tA\v\xc2\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\tA\v\xc2\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\v\xc2\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\tA\v\xc2\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\tA\v\xc2\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\v\xc2\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\tA\v\xe0\xa0\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\tA\v\xe0\xa0\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\v\xe0\xa0\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\tA\v\xe0\xa0\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\tA\v\xe0\xa0\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\v\xe0\xa0\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\tA\v\xe0\xa0\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\tA\v\xe0\xa0\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\v\xe0\xa0\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\tA\v\xe0\xa0\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\tA\v\xe0\xa0\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\v\xe0\xa0\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\tA\v\xe0\xa0\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\tA\v\xe0\xa0\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\v\xe0\xa0\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\tA\v\xe0\xa0\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\tA\v\xe0\xa0\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\v\xe0\xa0\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\tA\v\xe0\xa0\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\tA\v\xe0\xa0\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\v\xe0\xa0\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\tA\v\xe0\xa0\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\tA\v\xe0\xa0\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\v\xe0\xa0\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\tA\v\xe0\xa0\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\tA\v\xe0\xa0\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\v\xe0\xa0\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\tA\v\xe0\xa0\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\tA\v\xe0\xa0\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\v\xe0\xa0\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\tA\v\xe0\xa0\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\tA\v\xe0\xa0\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\v\xe0\xa0\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\tA\v\xe0\xa0\x81\v\v\v'\''|json -b 12'
echo -ne '\t\t\tA\v\xe0\xa0\x81\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA\v\xe0\xa0\x81\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xc2\x80\vB\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xc2\x80\vB\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\vB\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xc2\x80\vB\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xc2\x80\vB\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\vB\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xc2\x80\vB\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xc2\x80\vB\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\vB\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xc2\x80\vB\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xc2\x80\vB\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\vB\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xc2\x80\vB\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xc2\x80\vB\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\vB\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xc2\x80\vB\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xc2\x80\vB\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\vB\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xc2\x80\vB\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xc2\x80\vB\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\vB\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xc2\x80\vB\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xc2\x80\vB\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\vB\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xc2\x80\vB\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xc2\x80\vB\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\vB\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xc2\x80\vB\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xc2\x80\vB\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\vB\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xc2\x80\vB\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xc2\x80\vB\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\vB\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xc2\x80\v\xc2\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xc2\x80\v\xc2\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\v\xc2\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xc2\x80\v\xc2\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xc2\x80\v\xc2\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\v\xc2\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xc2\x80\v\xc2\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xc2\x80\v\xc2\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\v\xc2\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xc2\x80\v\xc2\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xc2\x80\v\xc2\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\v\xc2\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xc2\x80\v\xc2\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xc2\x80\v\xc2\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\v\xc2\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xc2\x80\v\xc2\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xc2\x80\v\xc2\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\v\xc2\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xc2\x80\v\xc2\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xc2\x80\v\xc2\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\v\xc2\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xc2\x80\v\xc2\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xc2\x80\v\xc2\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\v\xc2\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xc2\x80\v\xc2\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xc2\x80\v\xc2\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\v\xc2\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xc2\x80\v\xc2\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xc2\x80\v\xc2\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\v\xc2\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xc2\x80\v\xc2\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xc2\x80\v\xc2\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\v\xc2\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xc2\x80\v\xc2\x81\v\v\v'\''|json -b 12'
echo -ne '\t\t\t\xc2\x80\v\xc2\x81\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\v\xc2\x81\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xc2\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xc2\x80\v\xe0\xa0\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xc2\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xc2\x80\v\xe0\xa0\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xc2\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xc2\x80\v\xe0\xa0\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xc2\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xc2\x80\v\xe0\xa0\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xc2\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xc2\x80\v\xe0\xa0\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xc2\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xc2\x80\v\xe0\xa0\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xc2\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xc2\x80\v\xe0\xa0\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xc2\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xc2\x80\v\xe0\xa0\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xc2\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xc2\x80\v\xe0\xa0\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xc2\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xc2\x80\v\xe0\xa0\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xc2\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xc2\x80\v\xe0\xa0\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xc2\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 12'
echo -ne '\t\t\t\xc2\x80\v\xe0\xa0\x81\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xc2\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 13'
echo -ne '\t\t\t\xc2\x80\v\xe0\xa0\x81\v\v\v'|json -b 13 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 13'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\vB\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xe0\xa0\x80\vB\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\vB\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\vB\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xe0\xa0\x80\vB\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\vB\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\vB\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xe0\xa0\x80\vB\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\vB\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\vB\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xe0\xa0\x80\vB\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\vB\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\vB\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xe0\xa0\x80\vB\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\vB\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\vB\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xe0\xa0\x80\vB\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\vB\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\vB\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xe0\xa0\x80\vB\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\vB\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\vB\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xe0\xa0\x80\vB\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\vB\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\vB\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xe0\xa0\x80\vB\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\vB\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\vB\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xe0\xa0\x80\vB\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\vB\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\vB\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xe0\xa0\x80\vB\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\vB\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\vB\v\v\v'\''|json -b 12'
echo -ne '\t\t\t\xe0\xa0\x80\vB\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\vB\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\xc2\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xe0\xa0\x80\v\xc2\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\v\xc2\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\xc2\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xe0\xa0\x80\v\xc2\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\v\xc2\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\xc2\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xe0\xa0\x80\v\xc2\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\v\xc2\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\xc2\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xe0\xa0\x80\v\xc2\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\v\xc2\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\xc2\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xe0\xa0\x80\v\xc2\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\v\xc2\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\xc2\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xe0\xa0\x80\v\xc2\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\v\xc2\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\xc2\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xe0\xa0\x80\v\xc2\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\v\xc2\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\xc2\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xe0\xa0\x80\v\xc2\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\v\xc2\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\xc2\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xe0\xa0\x80\v\xc2\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\v\xc2\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\xc2\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xe0\xa0\x80\v\xc2\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\v\xc2\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\xc2\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xe0\xa0\x80\v\xc2\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\v\xc2\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\xc2\x81\v\v\v'\''|json -b 12'
echo -ne '\t\t\t\xe0\xa0\x80\v\xc2\x81\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\v\xc2\x81\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\xc2\x81\v\v\v'\''|json -b 13'
echo -ne '\t\t\t\xe0\xa0\x80\v\xc2\x81\v\v\v'|json -b 13 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\v\xc2\x81\v\v\v'\''|json -b 13'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xe0\xa0\x80\v\xe0\xa0\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xe0\xa0\x80\v\xe0\xa0\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xe0\xa0\x80\v\xe0\xa0\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xe0\xa0\x80\v\xe0\xa0\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xe0\xa0\x80\v\xe0\xa0\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xe0\xa0\x80\v\xe0\xa0\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xe0\xa0\x80\v\xe0\xa0\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xe0\xa0\x80\v\xe0\xa0\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xe0\xa0\x80\v\xe0\xa0\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xe0\xa0\x80\v\xe0\xa0\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xe0\xa0\x80\v\xe0\xa0\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 12'
echo -ne '\t\t\t\xe0\xa0\x80\v\xe0\xa0\x81\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 13'
echo -ne '\t\t\t\xe0\xa0\x80\v\xe0\xa0\x81\v\v\v'|json -b 13 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 13'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 14'
echo -ne '\t\t\t\xe0\xa0\x80\v\xe0\xa0\x81\v\v\v'|json -b 14 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80\v\xe0\xa0\x81\v\v\v'\''|json -b 14'

echo '$ echo -ne '\''\t\t\tA B\v\v\v'\''|json -b 1'
echo -ne '\t\t\tA B\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA B\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\tA B\v\v\v'\''|json -b 2'
echo -ne '\t\t\tA B\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA B\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\tA B\v\v\v'\''|json -b 3'
echo -ne '\t\t\tA B\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA B\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\tA B\v\v\v'\''|json -b 4'
echo -ne '\t\t\tA B\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA B\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\tA B\v\v\v'\''|json -b 5'
echo -ne '\t\t\tA B\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA B\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\tA B\v\v\v'\''|json -b 6'
echo -ne '\t\t\tA B\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA B\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\tA B\v\v\v'\''|json -b 7'
echo -ne '\t\t\tA B\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA B\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\tA B\v\v\v'\''|json -b 8'
echo -ne '\t\t\tA B\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA B\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\tA B\v\v\v'\''|json -b 9'
echo -ne '\t\t\tA B\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA B\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\tA B\v\v\v'\''|json -b 10'
echo -ne '\t\t\tA B\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA B\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\tA \xc2\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\tA \xc2\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA \xc2\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\tA \xc2\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\tA \xc2\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA \xc2\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\tA \xc2\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\tA \xc2\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA \xc2\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\tA \xc2\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\tA \xc2\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA \xc2\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\tA \xc2\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\tA \xc2\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA \xc2\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\tA \xc2\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\tA \xc2\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA \xc2\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\tA \xc2\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\tA \xc2\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA \xc2\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\tA \xc2\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\tA \xc2\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA \xc2\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\tA \xc2\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\tA \xc2\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA \xc2\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\tA \xc2\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\tA \xc2\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA \xc2\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\tA \xc2\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\tA \xc2\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA \xc2\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\tA \xe0\xa0\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\tA \xe0\xa0\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA \xe0\xa0\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\tA \xe0\xa0\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\tA \xe0\xa0\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA \xe0\xa0\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\tA \xe0\xa0\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\tA \xe0\xa0\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA \xe0\xa0\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\tA \xe0\xa0\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\tA \xe0\xa0\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA \xe0\xa0\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\tA \xe0\xa0\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\tA \xe0\xa0\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA \xe0\xa0\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\tA \xe0\xa0\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\tA \xe0\xa0\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA \xe0\xa0\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\tA \xe0\xa0\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\tA \xe0\xa0\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA \xe0\xa0\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\tA \xe0\xa0\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\tA \xe0\xa0\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA \xe0\xa0\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\tA \xe0\xa0\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\tA \xe0\xa0\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA \xe0\xa0\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\tA \xe0\xa0\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\tA \xe0\xa0\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA \xe0\xa0\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\tA \xe0\xa0\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\tA \xe0\xa0\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA \xe0\xa0\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\tA \xe0\xa0\x81\v\v\v'\''|json -b 12'
echo -ne '\t\t\tA \xe0\xa0\x81\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\tA \xe0\xa0\x81\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xc2\x80 B\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xc2\x80 B\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80 B\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xc2\x80 B\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xc2\x80 B\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80 B\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xc2\x80 B\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xc2\x80 B\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80 B\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xc2\x80 B\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xc2\x80 B\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80 B\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xc2\x80 B\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xc2\x80 B\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80 B\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xc2\x80 B\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xc2\x80 B\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80 B\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xc2\x80 B\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xc2\x80 B\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80 B\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xc2\x80 B\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xc2\x80 B\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80 B\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xc2\x80 B\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xc2\x80 B\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80 B\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xc2\x80 B\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xc2\x80 B\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80 B\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xc2\x80 B\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xc2\x80 B\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80 B\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xc2\x80 \xc2\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xc2\x80 \xc2\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80 \xc2\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xc2\x80 \xc2\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xc2\x80 \xc2\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80 \xc2\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xc2\x80 \xc2\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xc2\x80 \xc2\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80 \xc2\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xc2\x80 \xc2\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xc2\x80 \xc2\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80 \xc2\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xc2\x80 \xc2\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xc2\x80 \xc2\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80 \xc2\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xc2\x80 \xc2\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xc2\x80 \xc2\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80 \xc2\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xc2\x80 \xc2\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xc2\x80 \xc2\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80 \xc2\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xc2\x80 \xc2\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xc2\x80 \xc2\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80 \xc2\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xc2\x80 \xc2\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xc2\x80 \xc2\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80 \xc2\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xc2\x80 \xc2\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xc2\x80 \xc2\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80 \xc2\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xc2\x80 \xc2\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xc2\x80 \xc2\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80 \xc2\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xc2\x80 \xc2\x81\v\v\v'\''|json -b 12'
echo -ne '\t\t\t\xc2\x80 \xc2\x81\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80 \xc2\x81\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xc2\x80 \xe0\xa0\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xc2\x80 \xe0\xa0\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80 \xe0\xa0\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xc2\x80 \xe0\xa0\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xc2\x80 \xe0\xa0\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80 \xe0\xa0\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xc2\x80 \xe0\xa0\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xc2\x80 \xe0\xa0\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80 \xe0\xa0\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xc2\x80 \xe0\xa0\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xc2\x80 \xe0\xa0\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80 \xe0\xa0\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xc2\x80 \xe0\xa0\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xc2\x80 \xe0\xa0\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80 \xe0\xa0\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xc2\x80 \xe0\xa0\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xc2\x80 \xe0\xa0\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80 \xe0\xa0\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xc2\x80 \xe0\xa0\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xc2\x80 \xe0\xa0\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80 \xe0\xa0\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xc2\x80 \xe0\xa0\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xc2\x80 \xe0\xa0\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80 \xe0\xa0\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xc2\x80 \xe0\xa0\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xc2\x80 \xe0\xa0\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80 \xe0\xa0\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xc2\x80 \xe0\xa0\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xc2\x80 \xe0\xa0\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80 \xe0\xa0\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xc2\x80 \xe0\xa0\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xc2\x80 \xe0\xa0\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80 \xe0\xa0\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xc2\x80 \xe0\xa0\x81\v\v\v'\''|json -b 12'
echo -ne '\t\t\t\xc2\x80 \xe0\xa0\x81\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80 \xe0\xa0\x81\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xc2\x80 \xe0\xa0\x81\v\v\v'\''|json -b 13'
echo -ne '\t\t\t\xc2\x80 \xe0\xa0\x81\v\v\v'|json -b 13 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xc2\x80 \xe0\xa0\x81\v\v\v'\''|json -b 13'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80 B\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xe0\xa0\x80 B\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80 B\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80 B\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xe0\xa0\x80 B\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80 B\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80 B\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xe0\xa0\x80 B\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80 B\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80 B\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xe0\xa0\x80 B\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80 B\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80 B\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xe0\xa0\x80 B\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80 B\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80 B\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xe0\xa0\x80 B\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80 B\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80 B\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xe0\xa0\x80 B\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80 B\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80 B\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xe0\xa0\x80 B\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80 B\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80 B\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xe0\xa0\x80 B\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80 B\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80 B\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xe0\xa0\x80 B\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80 B\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80 B\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xe0\xa0\x80 B\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80 B\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80 B\v\v\v'\''|json -b 12'
echo -ne '\t\t\t\xe0\xa0\x80 B\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80 B\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80 \xc2\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xe0\xa0\x80 \xc2\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80 \xc2\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80 \xc2\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xe0\xa0\x80 \xc2\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80 \xc2\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80 \xc2\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xe0\xa0\x80 \xc2\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80 \xc2\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80 \xc2\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xe0\xa0\x80 \xc2\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80 \xc2\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80 \xc2\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xe0\xa0\x80 \xc2\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80 \xc2\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80 \xc2\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xe0\xa0\x80 \xc2\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80 \xc2\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80 \xc2\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xe0\xa0\x80 \xc2\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80 \xc2\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80 \xc2\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xe0\xa0\x80 \xc2\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80 \xc2\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80 \xc2\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xe0\xa0\x80 \xc2\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80 \xc2\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80 \xc2\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xe0\xa0\x80 \xc2\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80 \xc2\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80 \xc2\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xe0\xa0\x80 \xc2\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80 \xc2\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80 \xc2\x81\v\v\v'\''|json -b 12'
echo -ne '\t\t\t\xe0\xa0\x80 \xc2\x81\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80 \xc2\x81\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80 \xc2\x81\v\v\v'\''|json -b 13'
echo -ne '\t\t\t\xe0\xa0\x80 \xc2\x81\v\v\v'|json -b 13 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80 \xc2\x81\v\v\v'\''|json -b 13'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80 \xe0\xa0\x81\v\v\v'\''|json -b 1'
echo -ne '\t\t\t\xe0\xa0\x80 \xe0\xa0\x81\v\v\v'|json -b 1 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80 \xe0\xa0\x81\v\v\v'\''|json -b 1'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80 \xe0\xa0\x81\v\v\v'\''|json -b 2'
echo -ne '\t\t\t\xe0\xa0\x80 \xe0\xa0\x81\v\v\v'|json -b 2 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80 \xe0\xa0\x81\v\v\v'\''|json -b 2'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80 \xe0\xa0\x81\v\v\v'\''|json -b 3'
echo -ne '\t\t\t\xe0\xa0\x80 \xe0\xa0\x81\v\v\v'|json -b 3 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80 \xe0\xa0\x81\v\v\v'\''|json -b 3'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80 \xe0\xa0\x81\v\v\v'\''|json -b 4'
echo -ne '\t\t\t\xe0\xa0\x80 \xe0\xa0\x81\v\v\v'|json -b 4 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80 \xe0\xa0\x81\v\v\v'\''|json -b 4'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80 \xe0\xa0\x81\v\v\v'\''|json -b 5'
echo -ne '\t\t\t\xe0\xa0\x80 \xe0\xa0\x81\v\v\v'|json -b 5 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80 \xe0\xa0\x81\v\v\v'\''|json -b 5'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80 \xe0\xa0\x81\v\v\v'\''|json -b 6'
echo -ne '\t\t\t\xe0\xa0\x80 \xe0\xa0\x81\v\v\v'|json -b 6 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80 \xe0\xa0\x81\v\v\v'\''|json -b 6'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80 \xe0\xa0\x81\v\v\v'\''|json -b 7'
echo -ne '\t\t\t\xe0\xa0\x80 \xe0\xa0\x81\v\v\v'|json -b 7 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80 \xe0\xa0\x81\v\v\v'\''|json -b 7'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80 \xe0\xa0\x81\v\v\v'\''|json -b 8'
echo -ne '\t\t\t\xe0\xa0\x80 \xe0\xa0\x81\v\v\v'|json -b 8 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80 \xe0\xa0\x81\v\v\v'\''|json -b 8'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80 \xe0\xa0\x81\v\v\v'\''|json -b 9'
echo -ne '\t\t\t\xe0\xa0\x80 \xe0\xa0\x81\v\v\v'|json -b 9 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80 \xe0\xa0\x81\v\v\v'\''|json -b 9'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80 \xe0\xa0\x81\v\v\v'\''|json -b 10'
echo -ne '\t\t\t\xe0\xa0\x80 \xe0\xa0\x81\v\v\v'|json -b 10 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80 \xe0\xa0\x81\v\v\v'\''|json -b 10'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80 \xe0\xa0\x81\v\v\v'\''|json -b 11'
echo -ne '\t\t\t\xe0\xa0\x80 \xe0\xa0\x81\v\v\v'|json -b 11 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80 \xe0\xa0\x81\v\v\v'\''|json -b 11'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80 \xe0\xa0\x81\v\v\v'\''|json -b 12'
echo -ne '\t\t\t\xe0\xa0\x80 \xe0\xa0\x81\v\v\v'|json -b 12 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80 \xe0\xa0\x81\v\v\v'\''|json -b 12'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80 \xe0\xa0\x81\v\v\v'\''|json -b 13'
echo -ne '\t\t\t\xe0\xa0\x80 \xe0\xa0\x81\v\v\v'|json -b 13 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80 \xe0\xa0\x81\v\v\v'\''|json -b 13'

echo '$ echo -ne '\''\t\t\t\xe0\xa0\x80 \xe0\xa0\x81\v\v\v'\''|json -b 14'
echo -ne '\t\t\t\xe0\xa0\x80 \xe0\xa0\x81\v\v\v'|json -b 14 2>&1 ||
echo 'command failed: echo -ne '\''\t\t\t\xe0\xa0\x80 \xe0\xa0\x81\v\v\v'\''|json -b 14'
)

