#!/bin/bash

# Copyright (C) 2016, 2017, 2018  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker-list:list-closed-array-empty-val-array-basic-basic
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L list-closed-array-empty-val-array-basic-basic.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:2: type check error: too many arguments
json: error: <stdin>:1:2: [null,null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[null,false]'\''
json: error: <stdin>:1:2: type check error: too many arguments
json: error: <stdin>:1:2: [null,false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[null,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[null,true]'\''
json: error: <stdin>:1:2: type check error: too many arguments
json: error: <stdin>:1:2: [null,true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[null,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[null,456]'\''
json: error: <stdin>:1:2: type check error: too many arguments
json: error: <stdin>:1:2: [null,456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[null,456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[null,"bar"]'\''
json: error: <stdin>:1:2: type check error: too many arguments
json: error: <stdin>:1:2: [null,"bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[null,"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[null,{}]'\''
json: error: <stdin>:1:2: type check error: too many arguments
json: error: <stdin>:1:2: [null,{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[null,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[null,[]]'\''
json: error: <stdin>:1:2: type check error: too many arguments
json: error: <stdin>:1:2: [null,[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[null,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[false,null]'\''
json: error: <stdin>:1:2: type check error: too many arguments
json: error: <stdin>:1:2: [false,null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[false,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[false,false]'\''
json: error: <stdin>:1:2: type check error: too many arguments
json: error: <stdin>:1:2: [false,false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[false,true]'\''
json: error: <stdin>:1:2: type check error: too many arguments
json: error: <stdin>:1:2: [false,true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[false,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[false,456]'\''
json: error: <stdin>:1:2: type check error: too many arguments
json: error: <stdin>:1:2: [false,456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[false,456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[false,"bar"]'\''
json: error: <stdin>:1:2: type check error: too many arguments
json: error: <stdin>:1:2: [false,"bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[false,"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[false,{}]'\''
json: error: <stdin>:1:2: type check error: too many arguments
json: error: <stdin>:1:2: [false,{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[false,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[false,[]]'\''
json: error: <stdin>:1:2: type check error: too many arguments
json: error: <stdin>:1:2: [false,[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[false,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[true,null]'\''
json: error: <stdin>:1:2: type check error: too many arguments
json: error: <stdin>:1:2: [true,null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[true,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[true,false]'\''
json: error: <stdin>:1:2: type check error: too many arguments
json: error: <stdin>:1:2: [true,false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[true,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[true,true]'\''
json: error: <stdin>:1:2: type check error: too many arguments
json: error: <stdin>:1:2: [true,true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[true,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[true,456]'\''
json: error: <stdin>:1:2: type check error: too many arguments
json: error: <stdin>:1:2: [true,456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[true,456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[true,"bar"]'\''
json: error: <stdin>:1:2: type check error: too many arguments
json: error: <stdin>:1:2: [true,"bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[true,"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[true,{}]'\''
json: error: <stdin>:1:2: type check error: too many arguments
json: error: <stdin>:1:2: [true,{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[true,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[true,[]]'\''
json: error: <stdin>:1:2: type check error: too many arguments
json: error: <stdin>:1:2: [true,[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[true,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[123,null]'\''
json: error: <stdin>:1:2: type check error: too many arguments
json: error: <stdin>:1:2: [123,null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[123,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[123,false]'\''
json: error: <stdin>:1:2: type check error: too many arguments
json: error: <stdin>:1:2: [123,false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[123,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[123,true]'\''
json: error: <stdin>:1:2: type check error: too many arguments
json: error: <stdin>:1:2: [123,true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[123,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[123,456]'\''
json: error: <stdin>:1:2: type check error: too many arguments
json: error: <stdin>:1:2: [123,456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[123,456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[123,"bar"]'\''
json: error: <stdin>:1:2: type check error: too many arguments
json: error: <stdin>:1:2: [123,"bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[123,"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[123,{}]'\''
json: error: <stdin>:1:2: type check error: too many arguments
json: error: <stdin>:1:2: [123,{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[123,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[123,[]]'\''
json: error: <stdin>:1:2: type check error: too many arguments
json: error: <stdin>:1:2: [123,[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[123,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''["foo",null]'\''
json: error: <stdin>:1:2: type check error: too many arguments
json: error: <stdin>:1:2: ["foo",null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''["foo",null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''["foo",false]'\''
json: error: <stdin>:1:2: type check error: too many arguments
json: error: <stdin>:1:2: ["foo",false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''["foo",false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''["foo",true]'\''
json: error: <stdin>:1:2: type check error: too many arguments
json: error: <stdin>:1:2: ["foo",true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''["foo",true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''["foo",456]'\''
json: error: <stdin>:1:2: type check error: too many arguments
json: error: <stdin>:1:2: ["foo",456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''["foo",456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''["foo","bar"]'\''
json: error: <stdin>:1:2: type check error: too many arguments
json: error: <stdin>:1:2: ["foo","bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''["foo","bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''["foo",{}]'\''
json: error: <stdin>:1:2: type check error: too many arguments
json: error: <stdin>:1:2: ["foo",{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''["foo",{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''["foo",[]]'\''
json: error: <stdin>:1:2: type check error: too many arguments
json: error: <stdin>:1:2: ["foo",[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''["foo",[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[{},null]'\''
json: error: <stdin>:1:2: type check error: too many arguments
json: error: <stdin>:1:2: [{},null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[{},null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[{},false]'\''
json: error: <stdin>:1:2: type check error: too many arguments
json: error: <stdin>:1:2: [{},false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[{},false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[{},true]'\''
json: error: <stdin>:1:2: type check error: too many arguments
json: error: <stdin>:1:2: [{},true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[{},true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[{},456]'\''
json: error: <stdin>:1:2: type check error: too many arguments
json: error: <stdin>:1:2: [{},456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[{},456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[{},"bar"]'\''
json: error: <stdin>:1:2: type check error: too many arguments
json: error: <stdin>:1:2: [{},"bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[{},"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[{},{}]'\''
json: error: <stdin>:1:2: type check error: too many arguments
json: error: <stdin>:1:2: [{},{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[{},{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[{},[]]'\''
json: error: <stdin>:1:2: type check error: too many arguments
json: error: <stdin>:1:2: [{},[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[{},[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[[],null]'\''
json: error: <stdin>:1:2: type check error: too many arguments
json: error: <stdin>:1:2: [[],null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[[],null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[[],false]'\''
json: error: <stdin>:1:2: type check error: too many arguments
json: error: <stdin>:1:2: [[],false]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[[],false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[[],true]'\''
json: error: <stdin>:1:2: type check error: too many arguments
json: error: <stdin>:1:2: [[],true]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[[],true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[[],456]'\''
json: error: <stdin>:1:2: type check error: too many arguments
json: error: <stdin>:1:2: [[],456]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[[],456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[[],"bar"]'\''
json: error: <stdin>:1:2: type check error: too many arguments
json: error: <stdin>:1:2: [[],"bar"]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[[],"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[[],{}]'\''
json: error: <stdin>:1:2: type check error: too many arguments
json: error: <stdin>:1:2: [[],{}]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[[],{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:2: type check error: too many arguments
json: error: <stdin>:1:2: [[],[]]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[[],[]]'\'''
) -L list-closed-array-empty-val-array-basic-basic.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]}]}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[null,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]}]}' <<< '[null,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[null,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[null,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]}]}' <<< '[null,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[null,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[null,456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]}]}' <<< '[null,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[null,456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[null,"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]}]}' <<< '[null,"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[null,"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[null,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]}]}' <<< '[null,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[null,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[null,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]}]}' <<< '[null,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[null,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[false,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]}]}' <<< '[false,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[false,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]}]}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[false,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]}]}' <<< '[false,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[false,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[false,456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]}]}' <<< '[false,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[false,456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[false,"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]}]}' <<< '[false,"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[false,"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[false,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]}]}' <<< '[false,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[false,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[false,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]}]}' <<< '[false,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[false,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[true,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]}]}' <<< '[true,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[true,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[true,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]}]}' <<< '[true,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[true,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]}]}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[true,456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]}]}' <<< '[true,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[true,456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[true,"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]}]}' <<< '[true,"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[true,"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[true,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]}]}' <<< '[true,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[true,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[true,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]}]}' <<< '[true,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[true,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[123,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]}]}' <<< '[123,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[123,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[123,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]}]}' <<< '[123,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[123,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[123,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]}]}' <<< '[123,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[123,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[123,456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]}]}' <<< '[123,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[123,456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[123,"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]}]}' <<< '[123,"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[123,"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[123,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]}]}' <<< '[123,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[123,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[123,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]}]}' <<< '[123,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[123,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''["foo",null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]}]}' <<< '["foo",null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''["foo",null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''["foo",false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]}]}' <<< '["foo",false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''["foo",false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''["foo",true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]}]}' <<< '["foo",true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''["foo",true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''["foo",456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]}]}' <<< '["foo",456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''["foo",456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''["foo","bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]}]}' <<< '["foo","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''["foo","bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''["foo",{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]}]}' <<< '["foo",{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''["foo",{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''["foo",[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]}]}' <<< '["foo",[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''["foo",[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[{},null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]}]}' <<< '[{},null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[{},null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[{},false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]}]}' <<< '[{},false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[{},false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[{},true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]}]}' <<< '[{},true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[{},true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[{},456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]}]}' <<< '[{},456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[{},456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[{},"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]}]}' <<< '[{},"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[{},"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[{},{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]}]}' <<< '[{},{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[{},{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[{},[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]}]}' <<< '[{},[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[{},[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[[],null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]}]}' <<< '[[],null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[[],null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[[],false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]}]}' <<< '[[],false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[[],false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[[],true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]}]}' <<< '[[],true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[[],true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[[],456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]}]}' <<< '[[],456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[[],456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[[],"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]}]}' <<< '[[],"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[[],"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[[],{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]}]}' <<< '[[],{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[[],{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[[],[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[]}]}' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[]}]}'\'' <<< '\''[[],[]]'\'''
)

