#!/bin/bash

# Copyright (C) 2016, 2017, 2018  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker-list:list-object-foo-basic-object-bar-basic-val-object-foo-basic-fuu-basic
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L list-object-foo-basic-object-bar-basic-val-object-foo-basic-fuu-basic.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":null}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":null}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":false}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":false}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":true}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":true}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":123}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":123}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"bar"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":"bar"}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":{}}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":{}}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":[]}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":[]}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":null}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":null}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":false}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":false}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":true}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":true}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":123}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":123}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"bar"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":"bar"}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":{}}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":{}}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":[]}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":[]}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":null}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":null}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":false}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":false}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":true}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":true}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":123}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":123}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"bar"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":"bar"}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":{}}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":{}}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":[]}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":[]}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":null}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":null}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":false}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":false}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":true}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":true}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":123}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":123}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"bar"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":"bar"}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":{}}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":{}}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":[]}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":[]}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":null}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":null}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":false}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":false}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":true}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":true}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":123}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":123}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"bar"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":"bar"}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":{}}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":{}}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":[]}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":[]}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":null}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":null}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":false}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":false}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":true}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":true}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":123}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":123}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"bar"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":"bar"}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":{}}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":{}}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":[]}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":[{}],"fuu":[]}
json: error: <stdin>:1:12:            ^
{"foo":[{}]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":null,"fuu":null}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":null}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":null,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":null,"fuu":false}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":false}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":null,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":null,"fuu":true}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":true}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":null,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":null,"fuu":123}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":123}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":null,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":null,"fuu":"bar"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":"bar"}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":null,"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":null,"fuu":{}}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":{}}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":null,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":null,"fuu":[]}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":[]}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":null,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":null,"fuu":null}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":null}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":null,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":null,"fuu":false}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":false}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":null,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":null,"fuu":true}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":true}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":null,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":null,"fuu":123}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":123}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":null,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":null,"fuu":"bar"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":"bar"}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":null,"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":null,"fuu":{}}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":{}}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":null,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":null,"fuu":[]}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":[]}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":null,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":null,"fuu":null}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":null}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":null,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":null,"fuu":false}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":false}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":null,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":null,"fuu":true}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":true}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":null,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":null,"fuu":123}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":123}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":null,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":null,"fuu":"bar"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":"bar"}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":null,"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":null,"fuu":{}}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":{}}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":null,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":null,"fuu":[]}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":[]}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":null,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":null,"fuu":null}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":null}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":null,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":null,"fuu":false}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":false}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":null,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":null,"fuu":true}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":true}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":null,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":null,"fuu":123}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":123}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":null,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":null,"fuu":"bar"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":"bar"}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":null,"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":null,"fuu":{}}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":{}}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":null,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":null,"fuu":[]}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":[]}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":null,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":null,"fuu":null}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":null}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":null,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":null,"fuu":false}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":false}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":null,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":null,"fuu":true}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":true}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":null,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":null,"fuu":123}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":123}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":null,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":null,"fuu":"bar"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":"bar"}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":null,"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":null,"fuu":{}}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":{}}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":null,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":null,"fuu":[]}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":[]}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":null,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":null,"fuu":null}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":null}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":null,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":null,"fuu":false}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":false}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":null,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":null,"fuu":true}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":true}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":null,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":null,"fuu":123}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":123}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":null,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":null,"fuu":"bar"}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":"bar"}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":null,"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":null,"fuu":{}}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":{}}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":null,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":null,"fuu":[]}'\''
json: error: <stdin>:1:12: type check error: too many arguments
json: error: <stdin>:1:12: {"foo":null,"fuu":[]}
json: error: <stdin>:1:12:            ^
{"foo":null
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":null,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":false,"fuu":null}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":null}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":false,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":false,"fuu":false}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":false}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":false,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":false,"fuu":true}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":true}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":false,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":false,"fuu":123}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":123}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":false,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":false,"fuu":"bar"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":"bar"}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":false,"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":false,"fuu":{}}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":{}}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":false,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":false,"fuu":[]}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":[]}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":false,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":false,"fuu":null}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":null}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":false,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":false,"fuu":false}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":false}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":false,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":false,"fuu":true}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":true}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":false,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":false,"fuu":123}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":123}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":false,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":false,"fuu":"bar"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":"bar"}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":false,"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":false,"fuu":{}}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":{}}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":false,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":false,"fuu":[]}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":[]}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":false,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":false,"fuu":null}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":null}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":false,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":false,"fuu":false}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":false}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":false,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":false,"fuu":true}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":true}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":false,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":false,"fuu":123}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":123}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":false,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":false,"fuu":"bar"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":"bar"}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":false,"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":false,"fuu":{}}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":{}}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":false,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":false,"fuu":[]}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":[]}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":false,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":false,"fuu":null}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":null}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":false,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":false,"fuu":false}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":false}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":false,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":false,"fuu":true}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":true}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":false,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":false,"fuu":123}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":123}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":false,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":false,"fuu":"bar"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":"bar"}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":false,"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":false,"fuu":{}}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":{}}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":false,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":false,"fuu":[]}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":[]}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":false,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":false,"fuu":null}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":null}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":false,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":false,"fuu":false}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":false}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":false,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":false,"fuu":true}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":true}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":false,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":false,"fuu":123}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":123}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":false,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":false,"fuu":"bar"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":"bar"}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":false,"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":false,"fuu":{}}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":{}}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":false,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":false,"fuu":[]}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":[]}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":false,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":false,"fuu":null}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":null}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":false,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":false,"fuu":false}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":false}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":false,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":false,"fuu":true}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":true}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":false,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":false,"fuu":123}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":123}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":false,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":false,"fuu":"bar"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":"bar"}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":false,"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":false,"fuu":{}}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":{}}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":false,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":false,"fuu":[]}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":false,"fuu":[]}
json: error: <stdin>:1:13:             ^
{"foo":false
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":false,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":456,"fuu":null}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":null}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":456,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":456,"fuu":false}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":false}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":456,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":456,"fuu":true}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":true}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":456,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":456,"fuu":123}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":123}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":456,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":456,"fuu":"bar"}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":"bar"}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":456,"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":456,"fuu":{}}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":{}}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":456,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":456,"fuu":[]}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":[]}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":456,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":456,"fuu":null}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":null}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":456,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":456,"fuu":false}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":false}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":456,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":456,"fuu":true}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":true}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":456,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":456,"fuu":123}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":123}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":456,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":456,"fuu":"bar"}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":"bar"}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":456,"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":456,"fuu":{}}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":{}}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":456,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":456,"fuu":[]}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":[]}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":456,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":456,"fuu":null}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":null}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":456,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":456,"fuu":false}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":false}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":456,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":456,"fuu":true}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":true}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":456,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":456,"fuu":123}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":123}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":456,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":456,"fuu":"bar"}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":"bar"}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":456,"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":456,"fuu":{}}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":{}}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":456,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":456,"fuu":[]}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":[]}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":456,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":456,"fuu":null}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":null}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":456,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":456,"fuu":false}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":false}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":456,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":456,"fuu":true}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":true}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":456,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":456,"fuu":123}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":123}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":456,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":456,"fuu":"bar"}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":"bar"}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":456,"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":456,"fuu":{}}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":{}}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":456,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":456,"fuu":[]}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":[]}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":456,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":456,"fuu":null}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":null}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":456,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":456,"fuu":false}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":false}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":456,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":456,"fuu":true}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":true}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":456,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":456,"fuu":123}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":123}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":456,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":456,"fuu":"bar"}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":"bar"}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":456,"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":456,"fuu":{}}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":{}}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":456,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":456,"fuu":[]}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":[]}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":456,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":456,"fuu":null}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":null}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":456,"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":456,"fuu":false}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":false}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":456,"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":456,"fuu":true}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":true}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":456,"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":456,"fuu":123}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":123}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":456,"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":456,"fuu":"bar"}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":"bar"}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":456,"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":456,"fuu":{}}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":{}}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":456,"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":456,"fuu":[]}'\''
json: error: <stdin>:1:11: type check error: too many arguments
json: error: <stdin>:1:11: {"foo":456,"fuu":[]}
json: error: <stdin>:1:11:           ^
{"foo":456
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":456,"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":"baz","fuu":null}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":null}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":"baz","fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":"baz","fuu":false}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":false}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":"baz","fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":"baz","fuu":true}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":true}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":"baz","fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":"baz","fuu":123}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":123}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":"baz","fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":"baz","fuu":"bar"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":"bar"}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":"baz","fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":"baz","fuu":{}}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":{}}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":"baz","fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":"baz","fuu":[]}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":[]}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":"baz","fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":"baz","fuu":null}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":null}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":"baz","fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":"baz","fuu":false}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":false}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":"baz","fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":"baz","fuu":true}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":true}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":"baz","fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":"baz","fuu":123}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":123}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":"baz","fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":"baz","fuu":"bar"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":"bar"}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":"baz","fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":"baz","fuu":{}}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":{}}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":"baz","fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":"baz","fuu":[]}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":[]}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":"baz","fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":"baz","fuu":null}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":null}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":"baz","fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":"baz","fuu":false}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":false}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":"baz","fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":"baz","fuu":true}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":true}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":"baz","fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":"baz","fuu":123}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":123}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":"baz","fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":"baz","fuu":"bar"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":"bar"}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":"baz","fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":"baz","fuu":{}}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":{}}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":"baz","fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":"baz","fuu":[]}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":[]}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":"baz","fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":"baz","fuu":null}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":null}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":"baz","fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":"baz","fuu":false}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":false}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":"baz","fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":"baz","fuu":true}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":true}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":"baz","fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":"baz","fuu":123}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":123}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":"baz","fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":"baz","fuu":"bar"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":"bar"}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":"baz","fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":"baz","fuu":{}}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":{}}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":"baz","fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":"baz","fuu":[]}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":[]}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":"baz","fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":"baz","fuu":null}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":null}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":"baz","fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":"baz","fuu":false}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":false}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":"baz","fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":"baz","fuu":true}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":true}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":"baz","fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":"baz","fuu":123}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":123}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":"baz","fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":"baz","fuu":"bar"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":"bar"}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":"baz","fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":"baz","fuu":{}}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":{}}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":"baz","fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":"baz","fuu":[]}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":[]}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":"baz","fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":"baz","fuu":null}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":null}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":"baz","fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":"baz","fuu":false}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":false}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":"baz","fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":"baz","fuu":true}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":true}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":"baz","fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":"baz","fuu":123}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":123}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":"baz","fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":"baz","fuu":"bar"}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":"bar"}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":"baz","fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":"baz","fuu":{}}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":{}}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":"baz","fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":"baz","fuu":[]}'\''
json: error: <stdin>:1:13: type check error: too many arguments
json: error: <stdin>:1:13: {"foo":"baz","fuu":[]}
json: error: <stdin>:1:13:             ^
{"foo":"baz"
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":"baz","fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":{},"fuu":null}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":null}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":{},"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":{},"fuu":false}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":false}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":{},"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":{},"fuu":true}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":true}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":{},"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":{},"fuu":123}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":123}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":{},"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":{},"fuu":"bar"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":"bar"}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":{},"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":{},"fuu":{}}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":{}}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":{},"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":{},"fuu":[]}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":[]}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":{},"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":{},"fuu":null}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":null}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":{},"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":{},"fuu":false}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":false}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":{},"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":{},"fuu":true}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":true}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":{},"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":{},"fuu":123}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":123}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":{},"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":{},"fuu":"bar"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":"bar"}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":{},"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":{},"fuu":{}}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":{}}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":{},"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":{},"fuu":[]}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":[]}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":{},"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":{},"fuu":null}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":null}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":{},"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":{},"fuu":false}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":false}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":{},"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":{},"fuu":true}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":true}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":{},"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":{},"fuu":123}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":123}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":{},"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":{},"fuu":"bar"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":"bar"}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":{},"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":{},"fuu":{}}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":{}}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":{},"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":{},"fuu":[]}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":[]}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":{},"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":{},"fuu":null}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":null}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":{},"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":{},"fuu":false}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":false}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":{},"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":{},"fuu":true}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":true}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":{},"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":{},"fuu":123}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":123}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":{},"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":{},"fuu":"bar"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":"bar"}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":{},"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":{},"fuu":{}}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":{}}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":{},"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":{},"fuu":[]}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":[]}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":{},"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":{},"fuu":null}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":null}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":{},"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":{},"fuu":false}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":false}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":{},"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":{},"fuu":true}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":true}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":{},"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":{},"fuu":123}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":123}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":{},"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":{},"fuu":"bar"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":"bar"}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":{},"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":{},"fuu":{}}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":{}}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":{},"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":{},"fuu":[]}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":[]}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":{},"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":{},"fuu":null}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":null}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":{},"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":{},"fuu":false}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":false}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":{},"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":{},"fuu":true}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":true}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":{},"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":{},"fuu":123}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":123}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":{},"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":{},"fuu":"bar"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":"bar"}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":{},"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":{},"fuu":{}}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":{}}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":{},"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":{},"fuu":[]}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":{},"fuu":[]}
json: error: <stdin>:1:10:          ^
{"foo":{}
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":{},"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":[],"fuu":null}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":null}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":[],"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":[],"fuu":false}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":false}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":[],"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":[],"fuu":true}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":true}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":[],"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":[],"fuu":123}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":123}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":[],"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":[],"fuu":"bar"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":"bar"}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":[],"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":[],"fuu":{}}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":{}}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":[],"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":[],"fuu":[]}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":[]}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":[],"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":[],"fuu":null}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":null}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":[],"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":[],"fuu":false}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":false}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":[],"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":[],"fuu":true}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":true}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":[],"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":[],"fuu":123}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":123}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":[],"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":[],"fuu":"bar"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":"bar"}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":[],"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":[],"fuu":{}}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":{}}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":[],"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":[],"fuu":[]}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":[]}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":[],"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":[],"fuu":null}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":null}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":[],"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":[],"fuu":false}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":false}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":[],"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":[],"fuu":true}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":true}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":[],"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":[],"fuu":123}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":123}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":[],"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":[],"fuu":"bar"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":"bar"}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":[],"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":[],"fuu":{}}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":{}}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":[],"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":[],"fuu":[]}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":[]}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":[],"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":[],"fuu":null}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":null}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":[],"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":[],"fuu":false}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":false}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":[],"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":[],"fuu":true}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":true}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":[],"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":[],"fuu":123}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":123}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":[],"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":[],"fuu":"bar"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":"bar"}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":[],"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":[],"fuu":{}}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":{}}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":[],"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":[],"fuu":[]}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":[]}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":[],"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":[],"fuu":null}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":null}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":[],"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":[],"fuu":false}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":false}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":[],"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":[],"fuu":true}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":true}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":[],"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":[],"fuu":123}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":123}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":[],"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":[],"fuu":"bar"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":"bar"}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":[],"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":[],"fuu":{}}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":{}}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":[],"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":[],"fuu":[]}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":[]}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":[],"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":[],"fuu":null}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":null}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":[],"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":[],"fuu":false}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":false}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":[],"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":[],"fuu":true}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":true}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":[],"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":[],"fuu":123}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":123}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":[],"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":[],"fuu":"bar"}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":"bar"}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":[],"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":[],"fuu":{}}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":{}}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":[],"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":[],"fuu":[]}'\''
json: error: <stdin>:1:10: type check error: too many arguments
json: error: <stdin>:1:10: {"foo":[],"fuu":[]}
json: error: <stdin>:1:10:          ^
{"foo":[]
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":[],"fuu":[]}'\'''
) -L list-object-foo-basic-object-bar-basic-val-object-foo-basic-fuu-basic.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"foo":[{}],"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"foo":[{}],"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"foo":[{}],"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"foo":[{}],"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"foo":[{}],"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"foo":[{}],"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"foo":[{}],"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"foo":[{}],"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"foo":[{}],"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"foo":[{}],"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"foo":[{}],"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"foo":[{}],"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"foo":[{}],"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"foo":[{}],"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"foo":[{}],"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"foo":[{}],"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"foo":[{}],"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"foo":[{}],"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"foo":[{}],"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"foo":[{}],"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"foo":[{}],"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"foo":[{}],"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"foo":[{}],"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"foo":[{}],"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"foo":[{}],"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"foo":[{}],"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"foo":[{}],"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"foo":[{}],"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"foo":[{}],"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"foo":[{}],"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"foo":[{}],"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"foo":[{}],"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"foo":[{}],"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"foo":[{}],"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"foo":[{}],"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"foo":[{}],"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"foo":[{}],"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"foo":[{}],"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"foo":[{}],"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"foo":[{}],"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"foo":[{}],"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"foo":[{}],"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":[{}],"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":null,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"foo":null,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":null,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":null,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"foo":null,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":null,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":null,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"foo":null,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":null,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":null,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"foo":null,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":null,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":null,"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"foo":null,"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":null,"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":null,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"foo":null,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":null,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":null,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"foo":null,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":null,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":null,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"foo":null,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":null,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":null,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"foo":null,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":null,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":null,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"foo":null,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":null,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":null,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"foo":null,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":null,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":null,"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"foo":null,"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":null,"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":null,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"foo":null,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":null,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":null,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"foo":null,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":null,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":null,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"foo":null,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":null,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":null,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"foo":null,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":null,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":null,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"foo":null,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":null,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":null,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"foo":null,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":null,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":null,"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"foo":null,"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":null,"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":null,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"foo":null,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":null,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":null,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"foo":null,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":null,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":null,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"foo":null,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":null,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":null,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"foo":null,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":null,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":null,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"foo":null,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":null,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":null,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"foo":null,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":null,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":null,"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"foo":null,"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":null,"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":null,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"foo":null,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":null,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":null,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"foo":null,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":null,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":null,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"foo":null,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":null,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":null,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"foo":null,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":null,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":null,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"foo":null,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":null,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":null,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"foo":null,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":null,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":null,"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"foo":null,"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":null,"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":null,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"foo":null,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":null,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":null,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"foo":null,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":null,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":null,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"foo":null,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":null,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":null,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"foo":null,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":null,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":null,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"foo":null,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":null,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":null,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"foo":null,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":null,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":null,"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"foo":null,"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":null,"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":null,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"foo":null,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":null,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":null,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"foo":null,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":null,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":false,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"foo":false,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":false,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":false,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"foo":false,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":false,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":false,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"foo":false,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":false,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":false,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"foo":false,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":false,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":false,"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"foo":false,"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":false,"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":false,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"foo":false,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":false,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":false,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"foo":false,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":false,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":false,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"foo":false,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":false,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":false,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"foo":false,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":false,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":false,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"foo":false,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":false,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":false,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"foo":false,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":false,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":false,"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"foo":false,"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":false,"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":false,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"foo":false,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":false,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":false,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"foo":false,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":false,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":false,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"foo":false,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":false,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":false,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"foo":false,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":false,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":false,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"foo":false,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":false,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":false,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"foo":false,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":false,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":false,"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"foo":false,"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":false,"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":false,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"foo":false,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":false,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":false,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"foo":false,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":false,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":false,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"foo":false,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":false,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":false,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"foo":false,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":false,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":false,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"foo":false,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":false,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":false,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"foo":false,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":false,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":false,"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"foo":false,"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":false,"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":false,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"foo":false,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":false,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":false,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"foo":false,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":false,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":false,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"foo":false,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":false,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":false,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"foo":false,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":false,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":false,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"foo":false,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":false,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":false,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"foo":false,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":false,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":false,"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"foo":false,"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":false,"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":false,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"foo":false,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":false,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":false,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"foo":false,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":false,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":false,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"foo":false,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":false,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":false,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"foo":false,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":false,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":false,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"foo":false,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":false,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":false,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"foo":false,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":false,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":false,"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"foo":false,"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":false,"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":false,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"foo":false,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":false,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":false,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"foo":false,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":false,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":456,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"foo":456,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":456,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":456,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"foo":456,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":456,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":456,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"foo":456,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":456,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":456,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"foo":456,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":456,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":456,"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"foo":456,"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":456,"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":456,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"foo":456,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":456,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":456,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"foo":456,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":456,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":456,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"foo":456,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":456,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":456,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"foo":456,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":456,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":456,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"foo":456,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":456,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":456,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"foo":456,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":456,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":456,"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"foo":456,"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":456,"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":456,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"foo":456,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":456,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":456,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"foo":456,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":456,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":456,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"foo":456,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":456,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":456,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"foo":456,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":456,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":456,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"foo":456,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":456,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":456,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"foo":456,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":456,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":456,"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"foo":456,"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":456,"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":456,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"foo":456,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":456,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":456,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"foo":456,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":456,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":456,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"foo":456,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":456,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":456,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"foo":456,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":456,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":456,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"foo":456,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":456,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":456,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"foo":456,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":456,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":456,"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"foo":456,"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":456,"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":456,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"foo":456,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":456,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":456,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"foo":456,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":456,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":456,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"foo":456,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":456,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":456,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"foo":456,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":456,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":456,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"foo":456,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":456,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":456,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"foo":456,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":456,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":456,"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"foo":456,"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":456,"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":456,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"foo":456,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":456,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":456,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"foo":456,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":456,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":456,"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"foo":456,"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":456,"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":456,"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"foo":456,"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":456,"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":456,"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"foo":456,"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":456,"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":456,"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"foo":456,"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":456,"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":456,"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"foo":456,"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":456,"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":456,"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"foo":456,"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":456,"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":456,"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"foo":456,"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":456,"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":"baz","fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"foo":"baz","fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":"baz","fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":"baz","fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"foo":"baz","fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":"baz","fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":"baz","fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"foo":"baz","fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":"baz","fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":"baz","fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"foo":"baz","fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":"baz","fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":"baz","fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"foo":"baz","fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":"baz","fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":"baz","fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"foo":"baz","fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":"baz","fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":"baz","fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"foo":"baz","fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":"baz","fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":"baz","fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"foo":"baz","fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":"baz","fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":"baz","fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"foo":"baz","fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":"baz","fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":"baz","fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"foo":"baz","fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":"baz","fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":"baz","fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"foo":"baz","fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":"baz","fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":"baz","fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"foo":"baz","fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":"baz","fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":"baz","fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"foo":"baz","fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":"baz","fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":"baz","fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"foo":"baz","fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":"baz","fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":"baz","fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"foo":"baz","fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":"baz","fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":"baz","fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"foo":"baz","fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":"baz","fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":"baz","fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"foo":"baz","fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":"baz","fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":"baz","fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"foo":"baz","fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":"baz","fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":"baz","fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"foo":"baz","fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":"baz","fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":"baz","fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"foo":"baz","fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":"baz","fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":"baz","fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"foo":"baz","fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":"baz","fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":"baz","fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"foo":"baz","fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":"baz","fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":"baz","fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"foo":"baz","fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":"baz","fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":"baz","fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"foo":"baz","fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":"baz","fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":"baz","fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"foo":"baz","fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":"baz","fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":"baz","fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"foo":"baz","fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":"baz","fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":"baz","fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"foo":"baz","fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":"baz","fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":"baz","fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"foo":"baz","fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":"baz","fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":"baz","fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"foo":"baz","fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":"baz","fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":"baz","fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"foo":"baz","fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":"baz","fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":"baz","fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"foo":"baz","fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":"baz","fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":"baz","fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"foo":"baz","fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":"baz","fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":"baz","fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"foo":"baz","fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":"baz","fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":"baz","fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"foo":"baz","fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":"baz","fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":"baz","fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"foo":"baz","fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":"baz","fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":"baz","fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"foo":"baz","fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":"baz","fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":"baz","fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"foo":"baz","fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":"baz","fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":"baz","fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"foo":"baz","fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":"baz","fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":"baz","fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"foo":"baz","fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":"baz","fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":"baz","fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"foo":"baz","fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":"baz","fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":"baz","fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"foo":"baz","fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":"baz","fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":"baz","fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"foo":"baz","fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":"baz","fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":{},"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"foo":{},"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":{},"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":{},"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"foo":{},"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":{},"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":{},"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"foo":{},"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":{},"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":{},"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"foo":{},"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":{},"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":{},"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"foo":{},"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":{},"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":{},"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"foo":{},"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":{},"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":{},"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"foo":{},"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":{},"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":{},"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"foo":{},"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":{},"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":{},"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"foo":{},"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":{},"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":{},"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"foo":{},"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":{},"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":{},"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"foo":{},"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":{},"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":{},"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"foo":{},"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":{},"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":{},"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"foo":{},"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":{},"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":{},"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"foo":{},"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":{},"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":{},"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"foo":{},"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":{},"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":{},"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"foo":{},"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":{},"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":{},"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"foo":{},"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":{},"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":{},"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"foo":{},"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":{},"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":{},"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"foo":{},"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":{},"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":{},"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"foo":{},"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":{},"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":{},"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"foo":{},"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":{},"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":{},"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"foo":{},"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":{},"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":{},"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"foo":{},"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":{},"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":{},"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"foo":{},"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":{},"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":{},"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"foo":{},"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":{},"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":{},"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"foo":{},"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":{},"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":{},"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"foo":{},"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":{},"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":{},"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"foo":{},"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":{},"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":{},"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"foo":{},"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":{},"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":{},"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"foo":{},"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":{},"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":{},"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"foo":{},"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":{},"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":{},"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"foo":{},"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":{},"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":{},"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"foo":{},"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":{},"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":{},"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"foo":{},"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":{},"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":{},"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"foo":{},"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":{},"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":{},"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"foo":{},"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":{},"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":{},"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"foo":{},"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":{},"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":{},"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"foo":{},"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":{},"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":{},"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"foo":{},"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":{},"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":{},"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"foo":{},"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":{},"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":{},"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"foo":{},"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":{},"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":{},"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}' <<< '{"foo":{},"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"bar","type":"array"}]}]}'\'' <<< '\''{"foo":{},"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":[],"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"foo":[],"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":[],"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":[],"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"foo":[],"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":[],"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":[],"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"foo":[],"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":[],"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":[],"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"foo":[],"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":[],"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":[],"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"foo":[],"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":[],"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":[],"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"foo":[],"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":[],"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":[],"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}' <<< '{"foo":[],"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"type"}]}]}'\'' <<< '\''{"foo":[],"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":[],"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"foo":[],"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":[],"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":[],"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"foo":[],"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":[],"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":[],"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"foo":[],"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":[],"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":[],"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"foo":[],"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":[],"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":[],"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"foo":[],"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":[],"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":[],"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"foo":[],"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":[],"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":[],"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}' <<< '{"foo":[],"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"null"}]}]}'\'' <<< '\''{"foo":[],"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":[],"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"foo":[],"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":[],"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":[],"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"foo":[],"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":[],"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":[],"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"foo":[],"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":[],"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":[],"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"foo":[],"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":[],"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":[],"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"foo":[],"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":[],"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":[],"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"foo":[],"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":[],"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":[],"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}' <<< '{"foo":[],"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"boolean"}]}]}'\'' <<< '\''{"foo":[],"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":[],"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"foo":[],"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":[],"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":[],"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"foo":[],"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":[],"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":[],"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"foo":[],"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":[],"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":[],"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"foo":[],"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":[],"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":[],"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"foo":[],"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":[],"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":[],"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"foo":[],"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":[],"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":[],"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}' <<< '{"foo":[],"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"number"}]}]}'\'' <<< '\''{"foo":[],"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":[],"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"foo":[],"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":[],"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":[],"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"foo":[],"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":[],"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":[],"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"foo":[],"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":[],"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":[],"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"foo":[],"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":[],"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":[],"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"foo":[],"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":[],"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":[],"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"foo":[],"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":[],"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":[],"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}' <<< '{"foo":[],"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"string"}]}]}'\'' <<< '\''{"foo":[],"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":[],"fuu":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"foo":[],"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":[],"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":[],"fuu":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"foo":[],"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":[],"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":[],"fuu":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"foo":[],"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":[],"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":[],"fuu":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"foo":[],"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":[],"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":[],"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"foo":[],"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":[],"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":[],"fuu":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"foo":[],"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":[],"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":[],"fuu":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}' <<< '{"foo":[],"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"bar","type":"object"}]}]}'\'' <<< '\''{"foo":[],"fuu":[]}'\'''
)

