#!/bin/bash

# Copyright (C) 2016, 2017, 2018  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker-list:list-plain-object-plain-val-object-basic
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L list-plain-object-plain-val-object-basic.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[]}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":null}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":false}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":true}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":123}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":456}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":{}}'\''
$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[]}'\'''
) -L list-plain-object-plain-val-object-basic.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":456}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":null},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":456}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":false},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":456}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":true},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":456}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":123},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":null}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":false}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":true}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":123}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":456}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"bar"}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":{}}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[]}'\'''
json -d '{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"plain":"foo"},{"type":"object","args":[{"name":"faa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[]}'\'''
)

