#!/bin/bash

# Copyright (C) 2016, 2017, 2018  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-lib:list-closed-array-any-closed-array-any
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L list-closed-array-any-closed-array-any.old <(echo \
'$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }
$ json <<< '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":["type"]}]}'\''
json: error: <stdin>:1:57: attribute error: invalid "list" type object: duplicated '\''closed array'\'' entry (previous defined at 1:24)
json: error: <stdin>:1:57: "type":"array","args":["type"]},{"type":"array","args":["type"]}]
json: error: <stdin>:1:57:                                 ^
command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":["type"]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":["null"]}]}'\''
json: error: <stdin>:1:48: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:81)
json: error: <stdin>:1:48: "args":[{"type":"array","args":["type"]},{"type":"array","args":[
json: error: <stdin>:1:48:                                 ^
{
    "type": "list",
    "args": [
        {
            "type": "array",
            "args": [
                "type"
            ]
        },
        {
            "type": "array",
            "args": [
                "null"
            ]
        }
    ],
    "attr": {
        "any": null,
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": {
                "sym": "type",
                "lo": {
                    "sym": "null",
                    "lo": null,
                    "eq": {
                        "val": {
                            "type": "array",
                            "args": [
                                "null"
                            ]
                        },
                        "lo": null,
                        "hi": null
                    },
                    "hi": null
                },
                "eq": {
                    "val": {
                        "type": "array",
                        "args": [
                            "type"
                        ]
                    },
                    "lo": null,
                    "hi": null
                },
                "hi": null
            }
        }
    }
}
command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":["null"]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":["boolean"]}]}'\''
json: error: <stdin>:1:48: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:81)
json: error: <stdin>:1:48: "args":[{"type":"array","args":["type"]},{"type":"array","args":[
json: error: <stdin>:1:48:                                 ^
{
    "type": "list",
    "args": [
        {
            "type": "array",
            "args": [
                "type"
            ]
        },
        {
            "type": "array",
            "args": [
                "boolean"
            ]
        }
    ],
    "attr": {
        "any": null,
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": {
                "sym": "type",
                "lo": {
                    "sym": "boolean",
                    "lo": null,
                    "eq": {
                        "val": {
                            "type": "array",
                            "args": [
                                "boolean"
                            ]
                        },
                        "lo": null,
                        "hi": null
                    },
                    "hi": null
                },
                "eq": {
                    "val": {
                        "type": "array",
                        "args": [
                            "type"
                        ]
                    },
                    "lo": null,
                    "hi": null
                },
                "hi": null
            }
        }
    }
}
command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":["boolean"]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":["number"]}]}'\''
json: error: <stdin>:1:48: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:81)
json: error: <stdin>:1:48: "args":[{"type":"array","args":["type"]},{"type":"array","args":[
json: error: <stdin>:1:48:                                 ^
{
    "type": "list",
    "args": [
        {
            "type": "array",
            "args": [
                "type"
            ]
        },
        {
            "type": "array",
            "args": [
                "number"
            ]
        }
    ],
    "attr": {
        "any": null,
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": {
                "sym": "type",
                "lo": {
                    "sym": "number",
                    "lo": null,
                    "eq": {
                        "val": {
                            "type": "array",
                            "args": [
                                "number"
                            ]
                        },
                        "lo": null,
                        "hi": null
                    },
                    "hi": null
                },
                "eq": {
                    "val": {
                        "type": "array",
                        "args": [
                            "type"
                        ]
                    },
                    "lo": null,
                    "hi": null
                },
                "hi": null
            }
        }
    }
}
command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":["number"]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":["string"]}]}'\''
json: error: <stdin>:1:48: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:81)
json: error: <stdin>:1:48: "args":[{"type":"array","args":["type"]},{"type":"array","args":[
json: error: <stdin>:1:48:                                 ^
{
    "type": "list",
    "args": [
        {
            "type": "array",
            "args": [
                "type"
            ]
        },
        {
            "type": "array",
            "args": [
                "string"
            ]
        }
    ],
    "attr": {
        "any": null,
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": {
                "sym": "type",
                "lo": {
                    "sym": "string",
                    "lo": null,
                    "eq": {
                        "val": {
                            "type": "array",
                            "args": [
                                "string"
                            ]
                        },
                        "lo": null,
                        "hi": null
                    },
                    "hi": null
                },
                "eq": {
                    "val": {
                        "type": "array",
                        "args": [
                            "type"
                        ]
                    },
                    "lo": null,
                    "hi": null
                },
                "hi": null
            }
        }
    }
}
command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":["string"]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":["object"]}]}'\''
json: error: <stdin>:1:48: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:81)
json: error: <stdin>:1:48: "args":[{"type":"array","args":["type"]},{"type":"array","args":[
json: error: <stdin>:1:48:                                 ^
{
    "type": "list",
    "args": [
        {
            "type": "array",
            "args": [
                "type"
            ]
        },
        {
            "type": "array",
            "args": [
                "object"
            ]
        }
    ],
    "attr": {
        "any": null,
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": {
                "sym": "type",
                "lo": {
                    "sym": "object",
                    "lo": null,
                    "eq": {
                        "val": {
                            "type": "array",
                            "args": [
                                "object"
                            ]
                        },
                        "lo": null,
                        "hi": null
                    },
                    "hi": null
                },
                "eq": {
                    "val": {
                        "type": "array",
                        "args": [
                            "type"
                        ]
                    },
                    "lo": null,
                    "hi": null
                },
                "hi": null
            }
        }
    }
}
command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":["object"]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":["array"]}]}'\''
json: error: <stdin>:1:48: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:81)
json: error: <stdin>:1:48: "args":[{"type":"array","args":["type"]},{"type":"array","args":[
json: error: <stdin>:1:48:                                 ^
{
    "type": "list",
    "args": [
        {
            "type": "array",
            "args": [
                "type"
            ]
        },
        {
            "type": "array",
            "args": [
                "array"
            ]
        }
    ],
    "attr": {
        "any": null,
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": {
                "sym": "type",
                "lo": {
                    "sym": "array",
                    "lo": null,
                    "eq": {
                        "val": {
                            "type": "array",
                            "args": [
                                "array"
                            ]
                        },
                        "lo": null,
                        "hi": null
                    },
                    "hi": null
                },
                "eq": {
                    "val": {
                        "type": "array",
                        "args": [
                            "type"
                        ]
                    },
                    "lo": null,
                    "hi": null
                },
                "hi": null
            }
        }
    }
}
command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":["array"]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":["type"]}]}'\''
json: error: <stdin>:1:81: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
json: error: <stdin>:1:81: null"]},{"type":"array","args":["type"]}]}
json: error: <stdin>:1:81:                                 ^
{
    "type": "list",
    "args": [
        {
            "type": "array",
            "args": [
                "null"
            ]
        },
        {
            "type": "array",
            "args": [
                "type"
            ]
        }
    ],
    "attr": {
        "any": null,
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": {
                "sym": "null",
                "lo": null,
                "eq": {
                    "val": {
                        "type": "array",
                        "args": [
                            "null"
                        ]
                    },
                    "lo": null,
                    "hi": null
                },
                "hi": {
                    "sym": "type",
                    "lo": null,
                    "eq": {
                        "val": {
                            "type": "array",
                            "args": [
                                "type"
                            ]
                        },
                        "lo": null,
                        "hi": null
                    },
                    "hi": null
                }
            }
        }
    }
}
command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":["type"]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":["null"]}]}'\''
json: error: <stdin>:1:57: attribute error: invalid "list" type object: duplicated '\''closed array'\'' entry (previous defined at 1:24)
json: error: <stdin>:1:57: "type":"array","args":["null"]},{"type":"array","args":["null"]}]
json: error: <stdin>:1:57:                                 ^
command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":["null"]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":["boolean"]}]}'\''
{
    "type": "list",
    "args": [
        {
            "type": "array",
            "args": [
                "null"
            ]
        },
        {
            "type": "array",
            "args": [
                "boolean"
            ]
        }
    ],
    "attr": {
        "any": null,
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": {
                "sym": "null",
                "lo": null,
                "eq": {
                    "val": {
                        "type": "array",
                        "args": [
                            "null"
                        ]
                    },
                    "lo": null,
                    "hi": null
                },
                "hi": {
                    "sym": "boolean",
                    "lo": null,
                    "eq": {
                        "val": {
                            "type": "array",
                            "args": [
                                "boolean"
                            ]
                        },
                        "lo": null,
                        "hi": null
                    },
                    "hi": null
                }
            }
        }
    }
}
$ json <<< '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":["number"]}]}'\''
{
    "type": "list",
    "args": [
        {
            "type": "array",
            "args": [
                "null"
            ]
        },
        {
            "type": "array",
            "args": [
                "number"
            ]
        }
    ],
    "attr": {
        "any": null,
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": {
                "sym": "null",
                "lo": null,
                "eq": {
                    "val": {
                        "type": "array",
                        "args": [
                            "null"
                        ]
                    },
                    "lo": null,
                    "hi": null
                },
                "hi": {
                    "sym": "number",
                    "lo": null,
                    "eq": {
                        "val": {
                            "type": "array",
                            "args": [
                                "number"
                            ]
                        },
                        "lo": null,
                        "hi": null
                    },
                    "hi": null
                }
            }
        }
    }
}
$ json <<< '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":["string"]}]}'\''
{
    "type": "list",
    "args": [
        {
            "type": "array",
            "args": [
                "null"
            ]
        },
        {
            "type": "array",
            "args": [
                "string"
            ]
        }
    ],
    "attr": {
        "any": null,
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": {
                "sym": "null",
                "lo": null,
                "eq": {
                    "val": {
                        "type": "array",
                        "args": [
                            "null"
                        ]
                    },
                    "lo": null,
                    "hi": null
                },
                "hi": {
                    "sym": "string",
                    "lo": null,
                    "eq": {
                        "val": {
                            "type": "array",
                            "args": [
                                "string"
                            ]
                        },
                        "lo": null,
                        "hi": null
                    },
                    "hi": null
                }
            }
        }
    }
}
$ json <<< '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":["object"]}]}'\''
{
    "type": "list",
    "args": [
        {
            "type": "array",
            "args": [
                "null"
            ]
        },
        {
            "type": "array",
            "args": [
                "object"
            ]
        }
    ],
    "attr": {
        "any": null,
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": {
                "sym": "null",
                "lo": null,
                "eq": {
                    "val": {
                        "type": "array",
                        "args": [
                            "null"
                        ]
                    },
                    "lo": null,
                    "hi": null
                },
                "hi": {
                    "sym": "object",
                    "lo": null,
                    "eq": {
                        "val": {
                            "type": "array",
                            "args": [
                                "object"
                            ]
                        },
                        "lo": null,
                        "hi": null
                    },
                    "hi": null
                }
            }
        }
    }
}
$ json <<< '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":["array"]}]}'\''
{
    "type": "list",
    "args": [
        {
            "type": "array",
            "args": [
                "null"
            ]
        },
        {
            "type": "array",
            "args": [
                "array"
            ]
        }
    ],
    "attr": {
        "any": null,
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": {
                "sym": "null",
                "lo": null,
                "eq": {
                    "val": {
                        "type": "array",
                        "args": [
                            "null"
                        ]
                    },
                    "lo": null,
                    "hi": null
                },
                "hi": {
                    "sym": "array",
                    "lo": null,
                    "eq": {
                        "val": {
                            "type": "array",
                            "args": [
                                "array"
                            ]
                        },
                        "lo": null,
                        "hi": null
                    },
                    "hi": null
                }
            }
        }
    }
}
$ json <<< '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":["type"]}]}'\''
json: error: <stdin>:1:84: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
json: error: <stdin>:1:84: lean"]},{"type":"array","args":["type"]}]}
json: error: <stdin>:1:84:                                 ^
{
    "type": "list",
    "args": [
        {
            "type": "array",
            "args": [
                "boolean"
            ]
        },
        {
            "type": "array",
            "args": [
                "type"
            ]
        }
    ],
    "attr": {
        "any": null,
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": {
                "sym": "boolean",
                "lo": null,
                "eq": {
                    "val": {
                        "type": "array",
                        "args": [
                            "boolean"
                        ]
                    },
                    "lo": null,
                    "hi": null
                },
                "hi": {
                    "sym": "type",
                    "lo": null,
                    "eq": {
                        "val": {
                            "type": "array",
                            "args": [
                                "type"
                            ]
                        },
                        "lo": null,
                        "hi": null
                    },
                    "hi": null
                }
            }
        }
    }
}
command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":["type"]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":["null"]}]}'\''
{
    "type": "list",
    "args": [
        {
            "type": "array",
            "args": [
                "boolean"
            ]
        },
        {
            "type": "array",
            "args": [
                "null"
            ]
        }
    ],
    "attr": {
        "any": null,
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": {
                "sym": "boolean",
                "lo": {
                    "sym": "null",
                    "lo": null,
                    "eq": {
                        "val": {
                            "type": "array",
                            "args": [
                                "null"
                            ]
                        },
                        "lo": null,
                        "hi": null
                    },
                    "hi": null
                },
                "eq": {
                    "val": {
                        "type": "array",
                        "args": [
                            "boolean"
                        ]
                    },
                    "lo": null,
                    "hi": null
                },
                "hi": null
            }
        }
    }
}
$ json <<< '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":["boolean"]}]}'\''
json: error: <stdin>:1:60: attribute error: invalid "list" type object: duplicated '\''closed array'\'' entry (previous defined at 1:24)
json: error: <stdin>:1:60: pe":"array","args":["boolean"]},{"type":"array","args":["boolean"
json: error: <stdin>:1:60:                                 ^
command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":["boolean"]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":["number"]}]}'\''
{
    "type": "list",
    "args": [
        {
            "type": "array",
            "args": [
                "boolean"
            ]
        },
        {
            "type": "array",
            "args": [
                "number"
            ]
        }
    ],
    "attr": {
        "any": null,
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": {
                "sym": "boolean",
                "lo": null,
                "eq": {
                    "val": {
                        "type": "array",
                        "args": [
                            "boolean"
                        ]
                    },
                    "lo": null,
                    "hi": null
                },
                "hi": {
                    "sym": "number",
                    "lo": null,
                    "eq": {
                        "val": {
                            "type": "array",
                            "args": [
                                "number"
                            ]
                        },
                        "lo": null,
                        "hi": null
                    },
                    "hi": null
                }
            }
        }
    }
}
$ json <<< '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":["string"]}]}'\''
{
    "type": "list",
    "args": [
        {
            "type": "array",
            "args": [
                "boolean"
            ]
        },
        {
            "type": "array",
            "args": [
                "string"
            ]
        }
    ],
    "attr": {
        "any": null,
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": {
                "sym": "boolean",
                "lo": null,
                "eq": {
                    "val": {
                        "type": "array",
                        "args": [
                            "boolean"
                        ]
                    },
                    "lo": null,
                    "hi": null
                },
                "hi": {
                    "sym": "string",
                    "lo": null,
                    "eq": {
                        "val": {
                            "type": "array",
                            "args": [
                                "string"
                            ]
                        },
                        "lo": null,
                        "hi": null
                    },
                    "hi": null
                }
            }
        }
    }
}
$ json <<< '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":["object"]}]}'\''
{
    "type": "list",
    "args": [
        {
            "type": "array",
            "args": [
                "boolean"
            ]
        },
        {
            "type": "array",
            "args": [
                "object"
            ]
        }
    ],
    "attr": {
        "any": null,
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": {
                "sym": "boolean",
                "lo": null,
                "eq": {
                    "val": {
                        "type": "array",
                        "args": [
                            "boolean"
                        ]
                    },
                    "lo": null,
                    "hi": null
                },
                "hi": {
                    "sym": "object",
                    "lo": null,
                    "eq": {
                        "val": {
                            "type": "array",
                            "args": [
                                "object"
                            ]
                        },
                        "lo": null,
                        "hi": null
                    },
                    "hi": null
                }
            }
        }
    }
}
$ json <<< '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":["array"]}]}'\''
{
    "type": "list",
    "args": [
        {
            "type": "array",
            "args": [
                "boolean"
            ]
        },
        {
            "type": "array",
            "args": [
                "array"
            ]
        }
    ],
    "attr": {
        "any": null,
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": {
                "sym": "boolean",
                "lo": null,
                "eq": {
                    "val": {
                        "type": "array",
                        "args": [
                            "boolean"
                        ]
                    },
                    "lo": null,
                    "hi": null
                },
                "hi": {
                    "sym": "array",
                    "lo": null,
                    "eq": {
                        "val": {
                            "type": "array",
                            "args": [
                                "array"
                            ]
                        },
                        "lo": null,
                        "hi": null
                    },
                    "hi": null
                }
            }
        }
    }
}
$ json <<< '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":["type"]}]}'\''
json: error: <stdin>:1:83: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
json: error: <stdin>:1:83: mber"]},{"type":"array","args":["type"]}]}
json: error: <stdin>:1:83:                                 ^
{
    "type": "list",
    "args": [
        {
            "type": "array",
            "args": [
                "number"
            ]
        },
        {
            "type": "array",
            "args": [
                "type"
            ]
        }
    ],
    "attr": {
        "any": null,
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": {
                "sym": "number",
                "lo": null,
                "eq": {
                    "val": {
                        "type": "array",
                        "args": [
                            "number"
                        ]
                    },
                    "lo": null,
                    "hi": null
                },
                "hi": {
                    "sym": "type",
                    "lo": null,
                    "eq": {
                        "val": {
                            "type": "array",
                            "args": [
                                "type"
                            ]
                        },
                        "lo": null,
                        "hi": null
                    },
                    "hi": null
                }
            }
        }
    }
}
command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":["type"]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":["null"]}]}'\''
{
    "type": "list",
    "args": [
        {
            "type": "array",
            "args": [
                "number"
            ]
        },
        {
            "type": "array",
            "args": [
                "null"
            ]
        }
    ],
    "attr": {
        "any": null,
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": {
                "sym": "number",
                "lo": {
                    "sym": "null",
                    "lo": null,
                    "eq": {
                        "val": {
                            "type": "array",
                            "args": [
                                "null"
                            ]
                        },
                        "lo": null,
                        "hi": null
                    },
                    "hi": null
                },
                "eq": {
                    "val": {
                        "type": "array",
                        "args": [
                            "number"
                        ]
                    },
                    "lo": null,
                    "hi": null
                },
                "hi": null
            }
        }
    }
}
$ json <<< '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":["boolean"]}]}'\''
{
    "type": "list",
    "args": [
        {
            "type": "array",
            "args": [
                "number"
            ]
        },
        {
            "type": "array",
            "args": [
                "boolean"
            ]
        }
    ],
    "attr": {
        "any": null,
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": {
                "sym": "number",
                "lo": {
                    "sym": "boolean",
                    "lo": null,
                    "eq": {
                        "val": {
                            "type": "array",
                            "args": [
                                "boolean"
                            ]
                        },
                        "lo": null,
                        "hi": null
                    },
                    "hi": null
                },
                "eq": {
                    "val": {
                        "type": "array",
                        "args": [
                            "number"
                        ]
                    },
                    "lo": null,
                    "hi": null
                },
                "hi": null
            }
        }
    }
}
$ json <<< '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":["number"]}]}'\''
json: error: <stdin>:1:59: attribute error: invalid "list" type object: duplicated '\''closed array'\'' entry (previous defined at 1:24)
json: error: <stdin>:1:59: ype":"array","args":["number"]},{"type":"array","args":["number"]
json: error: <stdin>:1:59:                                 ^
command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":["number"]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":["string"]}]}'\''
{
    "type": "list",
    "args": [
        {
            "type": "array",
            "args": [
                "number"
            ]
        },
        {
            "type": "array",
            "args": [
                "string"
            ]
        }
    ],
    "attr": {
        "any": null,
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": {
                "sym": "number",
                "lo": null,
                "eq": {
                    "val": {
                        "type": "array",
                        "args": [
                            "number"
                        ]
                    },
                    "lo": null,
                    "hi": null
                },
                "hi": {
                    "sym": "string",
                    "lo": null,
                    "eq": {
                        "val": {
                            "type": "array",
                            "args": [
                                "string"
                            ]
                        },
                        "lo": null,
                        "hi": null
                    },
                    "hi": null
                }
            }
        }
    }
}
$ json <<< '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":["object"]}]}'\''
{
    "type": "list",
    "args": [
        {
            "type": "array",
            "args": [
                "number"
            ]
        },
        {
            "type": "array",
            "args": [
                "object"
            ]
        }
    ],
    "attr": {
        "any": null,
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": {
                "sym": "number",
                "lo": null,
                "eq": {
                    "val": {
                        "type": "array",
                        "args": [
                            "number"
                        ]
                    },
                    "lo": null,
                    "hi": null
                },
                "hi": {
                    "sym": "object",
                    "lo": null,
                    "eq": {
                        "val": {
                            "type": "array",
                            "args": [
                                "object"
                            ]
                        },
                        "lo": null,
                        "hi": null
                    },
                    "hi": null
                }
            }
        }
    }
}
$ json <<< '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":["array"]}]}'\''
{
    "type": "list",
    "args": [
        {
            "type": "array",
            "args": [
                "number"
            ]
        },
        {
            "type": "array",
            "args": [
                "array"
            ]
        }
    ],
    "attr": {
        "any": null,
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": {
                "sym": "number",
                "lo": null,
                "eq": {
                    "val": {
                        "type": "array",
                        "args": [
                            "number"
                        ]
                    },
                    "lo": null,
                    "hi": null
                },
                "hi": {
                    "sym": "array",
                    "lo": null,
                    "eq": {
                        "val": {
                            "type": "array",
                            "args": [
                                "array"
                            ]
                        },
                        "lo": null,
                        "hi": null
                    },
                    "hi": null
                }
            }
        }
    }
}
$ json <<< '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":["type"]}]}'\''
json: error: <stdin>:1:83: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
json: error: <stdin>:1:83: ring"]},{"type":"array","args":["type"]}]}
json: error: <stdin>:1:83:                                 ^
{
    "type": "list",
    "args": [
        {
            "type": "array",
            "args": [
                "string"
            ]
        },
        {
            "type": "array",
            "args": [
                "type"
            ]
        }
    ],
    "attr": {
        "any": null,
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": {
                "sym": "string",
                "lo": null,
                "eq": {
                    "val": {
                        "type": "array",
                        "args": [
                            "string"
                        ]
                    },
                    "lo": null,
                    "hi": null
                },
                "hi": {
                    "sym": "type",
                    "lo": null,
                    "eq": {
                        "val": {
                            "type": "array",
                            "args": [
                                "type"
                            ]
                        },
                        "lo": null,
                        "hi": null
                    },
                    "hi": null
                }
            }
        }
    }
}
command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":["type"]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":["null"]}]}'\''
{
    "type": "list",
    "args": [
        {
            "type": "array",
            "args": [
                "string"
            ]
        },
        {
            "type": "array",
            "args": [
                "null"
            ]
        }
    ],
    "attr": {
        "any": null,
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": {
                "sym": "string",
                "lo": {
                    "sym": "null",
                    "lo": null,
                    "eq": {
                        "val": {
                            "type": "array",
                            "args": [
                                "null"
                            ]
                        },
                        "lo": null,
                        "hi": null
                    },
                    "hi": null
                },
                "eq": {
                    "val": {
                        "type": "array",
                        "args": [
                            "string"
                        ]
                    },
                    "lo": null,
                    "hi": null
                },
                "hi": null
            }
        }
    }
}
$ json <<< '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":["boolean"]}]}'\''
{
    "type": "list",
    "args": [
        {
            "type": "array",
            "args": [
                "string"
            ]
        },
        {
            "type": "array",
            "args": [
                "boolean"
            ]
        }
    ],
    "attr": {
        "any": null,
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": {
                "sym": "string",
                "lo": {
                    "sym": "boolean",
                    "lo": null,
                    "eq": {
                        "val": {
                            "type": "array",
                            "args": [
                                "boolean"
                            ]
                        },
                        "lo": null,
                        "hi": null
                    },
                    "hi": null
                },
                "eq": {
                    "val": {
                        "type": "array",
                        "args": [
                            "string"
                        ]
                    },
                    "lo": null,
                    "hi": null
                },
                "hi": null
            }
        }
    }
}
$ json <<< '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":["number"]}]}'\''
{
    "type": "list",
    "args": [
        {
            "type": "array",
            "args": [
                "string"
            ]
        },
        {
            "type": "array",
            "args": [
                "number"
            ]
        }
    ],
    "attr": {
        "any": null,
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": {
                "sym": "string",
                "lo": {
                    "sym": "number",
                    "lo": null,
                    "eq": {
                        "val": {
                            "type": "array",
                            "args": [
                                "number"
                            ]
                        },
                        "lo": null,
                        "hi": null
                    },
                    "hi": null
                },
                "eq": {
                    "val": {
                        "type": "array",
                        "args": [
                            "string"
                        ]
                    },
                    "lo": null,
                    "hi": null
                },
                "hi": null
            }
        }
    }
}
$ json <<< '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":["string"]}]}'\''
json: error: <stdin>:1:59: attribute error: invalid "list" type object: duplicated '\''closed array'\'' entry (previous defined at 1:24)
json: error: <stdin>:1:59: ype":"array","args":["string"]},{"type":"array","args":["string"]
json: error: <stdin>:1:59:                                 ^
command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":["string"]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":["object"]}]}'\''
{
    "type": "list",
    "args": [
        {
            "type": "array",
            "args": [
                "string"
            ]
        },
        {
            "type": "array",
            "args": [
                "object"
            ]
        }
    ],
    "attr": {
        "any": null,
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": {
                "sym": "string",
                "lo": null,
                "eq": {
                    "val": {
                        "type": "array",
                        "args": [
                            "string"
                        ]
                    },
                    "lo": null,
                    "hi": null
                },
                "hi": {
                    "sym": "object",
                    "lo": null,
                    "eq": {
                        "val": {
                            "type": "array",
                            "args": [
                                "object"
                            ]
                        },
                        "lo": null,
                        "hi": null
                    },
                    "hi": null
                }
            }
        }
    }
}
$ json <<< '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":["array"]}]}'\''
{
    "type": "list",
    "args": [
        {
            "type": "array",
            "args": [
                "string"
            ]
        },
        {
            "type": "array",
            "args": [
                "array"
            ]
        }
    ],
    "attr": {
        "any": null,
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": {
                "sym": "string",
                "lo": null,
                "eq": {
                    "val": {
                        "type": "array",
                        "args": [
                            "string"
                        ]
                    },
                    "lo": null,
                    "hi": null
                },
                "hi": {
                    "sym": "array",
                    "lo": null,
                    "eq": {
                        "val": {
                            "type": "array",
                            "args": [
                                "array"
                            ]
                        },
                        "lo": null,
                        "hi": null
                    },
                    "hi": null
                }
            }
        }
    }
}
$ json <<< '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":["type"]}]}'\''
json: error: <stdin>:1:83: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
json: error: <stdin>:1:83: ject"]},{"type":"array","args":["type"]}]}
json: error: <stdin>:1:83:                                 ^
{
    "type": "list",
    "args": [
        {
            "type": "array",
            "args": [
                "object"
            ]
        },
        {
            "type": "array",
            "args": [
                "type"
            ]
        }
    ],
    "attr": {
        "any": null,
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": {
                "sym": "object",
                "lo": null,
                "eq": {
                    "val": {
                        "type": "array",
                        "args": [
                            "object"
                        ]
                    },
                    "lo": null,
                    "hi": null
                },
                "hi": {
                    "sym": "type",
                    "lo": null,
                    "eq": {
                        "val": {
                            "type": "array",
                            "args": [
                                "type"
                            ]
                        },
                        "lo": null,
                        "hi": null
                    },
                    "hi": null
                }
            }
        }
    }
}
command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":["type"]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":["null"]}]}'\''
{
    "type": "list",
    "args": [
        {
            "type": "array",
            "args": [
                "object"
            ]
        },
        {
            "type": "array",
            "args": [
                "null"
            ]
        }
    ],
    "attr": {
        "any": null,
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": {
                "sym": "object",
                "lo": {
                    "sym": "null",
                    "lo": null,
                    "eq": {
                        "val": {
                            "type": "array",
                            "args": [
                                "null"
                            ]
                        },
                        "lo": null,
                        "hi": null
                    },
                    "hi": null
                },
                "eq": {
                    "val": {
                        "type": "array",
                        "args": [
                            "object"
                        ]
                    },
                    "lo": null,
                    "hi": null
                },
                "hi": null
            }
        }
    }
}
$ json <<< '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":["boolean"]}]}'\''
{
    "type": "list",
    "args": [
        {
            "type": "array",
            "args": [
                "object"
            ]
        },
        {
            "type": "array",
            "args": [
                "boolean"
            ]
        }
    ],
    "attr": {
        "any": null,
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": {
                "sym": "object",
                "lo": {
                    "sym": "boolean",
                    "lo": null,
                    "eq": {
                        "val": {
                            "type": "array",
                            "args": [
                                "boolean"
                            ]
                        },
                        "lo": null,
                        "hi": null
                    },
                    "hi": null
                },
                "eq": {
                    "val": {
                        "type": "array",
                        "args": [
                            "object"
                        ]
                    },
                    "lo": null,
                    "hi": null
                },
                "hi": null
            }
        }
    }
}
$ json <<< '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":["number"]}]}'\''
{
    "type": "list",
    "args": [
        {
            "type": "array",
            "args": [
                "object"
            ]
        },
        {
            "type": "array",
            "args": [
                "number"
            ]
        }
    ],
    "attr": {
        "any": null,
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": {
                "sym": "object",
                "lo": {
                    "sym": "number",
                    "lo": null,
                    "eq": {
                        "val": {
                            "type": "array",
                            "args": [
                                "number"
                            ]
                        },
                        "lo": null,
                        "hi": null
                    },
                    "hi": null
                },
                "eq": {
                    "val": {
                        "type": "array",
                        "args": [
                            "object"
                        ]
                    },
                    "lo": null,
                    "hi": null
                },
                "hi": null
            }
        }
    }
}
$ json <<< '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":["string"]}]}'\''
{
    "type": "list",
    "args": [
        {
            "type": "array",
            "args": [
                "object"
            ]
        },
        {
            "type": "array",
            "args": [
                "string"
            ]
        }
    ],
    "attr": {
        "any": null,
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": {
                "sym": "object",
                "lo": {
                    "sym": "string",
                    "lo": null,
                    "eq": {
                        "val": {
                            "type": "array",
                            "args": [
                                "string"
                            ]
                        },
                        "lo": null,
                        "hi": null
                    },
                    "hi": null
                },
                "eq": {
                    "val": {
                        "type": "array",
                        "args": [
                            "object"
                        ]
                    },
                    "lo": null,
                    "hi": null
                },
                "hi": null
            }
        }
    }
}
$ json <<< '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":["object"]}]}'\''
json: error: <stdin>:1:59: attribute error: invalid "list" type object: duplicated '\''closed array'\'' entry (previous defined at 1:24)
json: error: <stdin>:1:59: ype":"array","args":["object"]},{"type":"array","args":["object"]
json: error: <stdin>:1:59:                                 ^
command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":["object"]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":["array"]}]}'\''
{
    "type": "list",
    "args": [
        {
            "type": "array",
            "args": [
                "object"
            ]
        },
        {
            "type": "array",
            "args": [
                "array"
            ]
        }
    ],
    "attr": {
        "any": null,
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": {
                "sym": "object",
                "lo": null,
                "eq": {
                    "val": {
                        "type": "array",
                        "args": [
                            "object"
                        ]
                    },
                    "lo": null,
                    "hi": null
                },
                "hi": {
                    "sym": "array",
                    "lo": null,
                    "eq": {
                        "val": {
                            "type": "array",
                            "args": [
                                "array"
                            ]
                        },
                        "lo": null,
                        "hi": null
                    },
                    "hi": null
                }
            }
        }
    }
}
$ json <<< '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":["type"]}]}'\''
json: error: <stdin>:1:82: attribute error: invalid "list" type object: array argument ambiguity (the other is at 1:48)
json: error: <stdin>:1:82: rray"]},{"type":"array","args":["type"]}]}
json: error: <stdin>:1:82:                                 ^
{
    "type": "list",
    "args": [
        {
            "type": "array",
            "args": [
                "array"
            ]
        },
        {
            "type": "array",
            "args": [
                "type"
            ]
        }
    ],
    "attr": {
        "any": null,
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": {
                "sym": "array",
                "lo": null,
                "eq": {
                    "val": {
                        "type": "array",
                        "args": [
                            "array"
                        ]
                    },
                    "lo": null,
                    "hi": null
                },
                "hi": {
                    "sym": "type",
                    "lo": null,
                    "eq": {
                        "val": {
                            "type": "array",
                            "args": [
                                "type"
                            ]
                        },
                        "lo": null,
                        "hi": null
                    },
                    "hi": null
                }
            }
        }
    }
}
command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":["type"]}]}'\''
$ json <<< '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":["null"]}]}'\''
{
    "type": "list",
    "args": [
        {
            "type": "array",
            "args": [
                "array"
            ]
        },
        {
            "type": "array",
            "args": [
                "null"
            ]
        }
    ],
    "attr": {
        "any": null,
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": {
                "sym": "array",
                "lo": {
                    "sym": "null",
                    "lo": null,
                    "eq": {
                        "val": {
                            "type": "array",
                            "args": [
                                "null"
                            ]
                        },
                        "lo": null,
                        "hi": null
                    },
                    "hi": null
                },
                "eq": {
                    "val": {
                        "type": "array",
                        "args": [
                            "array"
                        ]
                    },
                    "lo": null,
                    "hi": null
                },
                "hi": null
            }
        }
    }
}
$ json <<< '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":["boolean"]}]}'\''
{
    "type": "list",
    "args": [
        {
            "type": "array",
            "args": [
                "array"
            ]
        },
        {
            "type": "array",
            "args": [
                "boolean"
            ]
        }
    ],
    "attr": {
        "any": null,
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": {
                "sym": "array",
                "lo": {
                    "sym": "boolean",
                    "lo": null,
                    "eq": {
                        "val": {
                            "type": "array",
                            "args": [
                                "boolean"
                            ]
                        },
                        "lo": null,
                        "hi": null
                    },
                    "hi": null
                },
                "eq": {
                    "val": {
                        "type": "array",
                        "args": [
                            "array"
                        ]
                    },
                    "lo": null,
                    "hi": null
                },
                "hi": null
            }
        }
    }
}
$ json <<< '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":["number"]}]}'\''
{
    "type": "list",
    "args": [
        {
            "type": "array",
            "args": [
                "array"
            ]
        },
        {
            "type": "array",
            "args": [
                "number"
            ]
        }
    ],
    "attr": {
        "any": null,
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": {
                "sym": "array",
                "lo": {
                    "sym": "number",
                    "lo": null,
                    "eq": {
                        "val": {
                            "type": "array",
                            "args": [
                                "number"
                            ]
                        },
                        "lo": null,
                        "hi": null
                    },
                    "hi": null
                },
                "eq": {
                    "val": {
                        "type": "array",
                        "args": [
                            "array"
                        ]
                    },
                    "lo": null,
                    "hi": null
                },
                "hi": null
            }
        }
    }
}
$ json <<< '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":["string"]}]}'\''
{
    "type": "list",
    "args": [
        {
            "type": "array",
            "args": [
                "array"
            ]
        },
        {
            "type": "array",
            "args": [
                "string"
            ]
        }
    ],
    "attr": {
        "any": null,
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": {
                "sym": "array",
                "lo": {
                    "sym": "string",
                    "lo": null,
                    "eq": {
                        "val": {
                            "type": "array",
                            "args": [
                                "string"
                            ]
                        },
                        "lo": null,
                        "hi": null
                    },
                    "hi": null
                },
                "eq": {
                    "val": {
                        "type": "array",
                        "args": [
                            "array"
                        ]
                    },
                    "lo": null,
                    "hi": null
                },
                "hi": null
            }
        }
    }
}
$ json <<< '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":["object"]}]}'\''
{
    "type": "list",
    "args": [
        {
            "type": "array",
            "args": [
                "array"
            ]
        },
        {
            "type": "array",
            "args": [
                "object"
            ]
        }
    ],
    "attr": {
        "any": null,
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": {
                "sym": "array",
                "lo": {
                    "sym": "object",
                    "lo": null,
                    "eq": {
                        "val": {
                            "type": "array",
                            "args": [
                                "object"
                            ]
                        },
                        "lo": null,
                        "hi": null
                    },
                    "hi": null
                },
                "eq": {
                    "val": {
                        "type": "array",
                        "args": [
                            "array"
                        ]
                    },
                    "lo": null,
                    "hi": null
                },
                "hi": null
            }
        }
    }
}
$ json <<< '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":["array"]}]}'\''
json: error: <stdin>:1:58: attribute error: invalid "list" type object: duplicated '\''closed array'\'' entry (previous defined at 1:24)
json: error: <stdin>:1:58: type":"array","args":["array"]},{"type":"array","args":["array"]}
json: error: <stdin>:1:58:                                 ^
command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":["array"]}]}'\'''
) -L list-closed-array-any-closed-array-any.new <(
echo '$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }'
json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; } 2>&1 ||
echo 'command failed: json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }'

echo '$ json <<< '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":["type"]}]}'\'''
json <<< '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":["type"]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":["type"]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":["null"]}]}'\'''
json <<< '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":["null"]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":["null"]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":["boolean"]}]}'\'''
json <<< '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":["boolean"]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":["boolean"]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":["number"]}]}'\'''
json <<< '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":["number"]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":["number"]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":["string"]}]}'\'''
json <<< '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":["string"]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":["string"]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":["object"]}]}'\'''
json <<< '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":["object"]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":["object"]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":["array"]}]}'\'''
json <<< '{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":["array"]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["type"]},{"type":"array","args":["array"]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":["type"]}]}'\'''
json <<< '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":["type"]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":["type"]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":["null"]}]}'\'''
json <<< '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":["null"]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":["null"]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":["boolean"]}]}'\'''
json <<< '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":["boolean"]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":["boolean"]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":["number"]}]}'\'''
json <<< '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":["number"]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":["number"]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":["string"]}]}'\'''
json <<< '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":["string"]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":["string"]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":["object"]}]}'\'''
json <<< '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":["object"]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":["object"]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":["array"]}]}'\'''
json <<< '{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":["array"]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["null"]},{"type":"array","args":["array"]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":["type"]}]}'\'''
json <<< '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":["type"]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":["type"]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":["null"]}]}'\'''
json <<< '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":["null"]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":["null"]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":["boolean"]}]}'\'''
json <<< '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":["boolean"]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":["boolean"]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":["number"]}]}'\'''
json <<< '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":["number"]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":["number"]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":["string"]}]}'\'''
json <<< '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":["string"]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":["string"]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":["object"]}]}'\'''
json <<< '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":["object"]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":["object"]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":["array"]}]}'\'''
json <<< '{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":["array"]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["boolean"]},{"type":"array","args":["array"]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":["type"]}]}'\'''
json <<< '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":["type"]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":["type"]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":["null"]}]}'\'''
json <<< '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":["null"]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":["null"]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":["boolean"]}]}'\'''
json <<< '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":["boolean"]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":["boolean"]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":["number"]}]}'\'''
json <<< '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":["number"]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":["number"]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":["string"]}]}'\'''
json <<< '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":["string"]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":["string"]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":["object"]}]}'\'''
json <<< '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":["object"]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":["object"]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":["array"]}]}'\'''
json <<< '{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":["array"]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["number"]},{"type":"array","args":["array"]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":["type"]}]}'\'''
json <<< '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":["type"]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":["type"]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":["null"]}]}'\'''
json <<< '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":["null"]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":["null"]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":["boolean"]}]}'\'''
json <<< '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":["boolean"]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":["boolean"]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":["number"]}]}'\'''
json <<< '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":["number"]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":["number"]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":["string"]}]}'\'''
json <<< '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":["string"]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":["string"]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":["object"]}]}'\'''
json <<< '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":["object"]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":["object"]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":["array"]}]}'\'''
json <<< '{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":["array"]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["string"]},{"type":"array","args":["array"]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":["type"]}]}'\'''
json <<< '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":["type"]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":["type"]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":["null"]}]}'\'''
json <<< '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":["null"]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":["null"]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":["boolean"]}]}'\'''
json <<< '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":["boolean"]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":["boolean"]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":["number"]}]}'\'''
json <<< '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":["number"]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":["number"]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":["string"]}]}'\'''
json <<< '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":["string"]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":["string"]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":["object"]}]}'\'''
json <<< '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":["object"]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":["object"]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":["array"]}]}'\'''
json <<< '{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":["array"]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["object"]},{"type":"array","args":["array"]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":["type"]}]}'\'''
json <<< '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":["type"]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":["type"]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":["null"]}]}'\'''
json <<< '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":["null"]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":["null"]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":["boolean"]}]}'\'''
json <<< '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":["boolean"]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":["boolean"]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":["number"]}]}'\'''
json <<< '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":["number"]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":["number"]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":["string"]}]}'\'''
json <<< '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":["string"]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":["string"]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":["object"]}]}'\'''
json <<< '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":["object"]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":["object"]}]}'\'''

echo '$ json <<< '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":["array"]}]}'\'''
json <<< '{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":["array"]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":[{"type":"array","args":["array"]},{"type":"array","args":["array"]}]}'\'''
)

