#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C filter:invalid-args2
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L invalid-args2.old <(echo \
'$ json0() { LD_LIBRARY_PATH=../lib ../src/json "$@"; }
$ shopt -s expand_aliases
$ alias json='\''json0 -f'\''
$ json -- ../lib/test-filter.so -X
json: error: ../lib/test-filter.so: filter library: invalid command line option '\''-X'\''
command failed: json -- ../lib/test-filter.so -X
$ json -- ../lib/test-filter.so --foo
json: error: ../lib/test-filter.so: filter library: invalid command line option '\''--foo'\''
command failed: json -- ../lib/test-filter.so --foo
$ json -- ../lib/test-filter.so -f
json: error: ../lib/test-filter.so: filter library: argument for option '\''-f'\'' not found
command failed: json -- ../lib/test-filter.so -f
$ json -- ../lib/test-filter.so --fail
json: error: ../lib/test-filter.so: filter library: argument for option '\''--fail'\'' not found
command failed: json -- ../lib/test-filter.so --fail
$ json -- ../lib/test-filter.so -f '\'''\''
json: error: ../lib/test-filter.so: filter library: invalid argument for '\''fail'\'' option: '\'''\''
command failed: json -- ../lib/test-filter.so -f '\'''\''
$ json -- ../lib/test-filter.so --fail=
json: error: ../lib/test-filter.so: filter library: invalid argument for '\''fail'\'' option: '\'''\''
command failed: json -- ../lib/test-filter.so --fail=
$ json -- ../lib/test-filter.so -f foo
json: error: ../lib/test-filter.so: filter library: invalid argument for '\''fail'\'' option: '\''foo'\''
command failed: json -- ../lib/test-filter.so -f foo
$ json -- ../lib/test-filter.so --fail=foo
json: error: ../lib/test-filter.so: filter library: invalid argument for '\''fail'\'' option: '\''foo'\''
command failed: json -- ../lib/test-filter.so --fail=foo
$ json -- ../lib/test-filter.so --no-fail=
json: error: ../lib/test-filter.so: filter library: option '\''--no-fail'\'' does not allow an argument
command failed: json -- ../lib/test-filter.so --no-fail=
$ json -- ../lib/test-filter.so --no-fail=foo
json: error: ../lib/test-filter.so: filter library: option '\''--no-fail'\'' does not allow an argument
command failed: json -- ../lib/test-filter.so --no-fail=foo'
) -L invalid-args2.new <(
echo '$ json0() { LD_LIBRARY_PATH=../lib ../src/json "$@"; }'
json0() { LD_LIBRARY_PATH=../lib ../src/json "$@"; } 2>&1 ||
echo 'command failed: json0() { LD_LIBRARY_PATH=../lib ../src/json "$@"; }'

echo '$ shopt -s expand_aliases'
shopt -s expand_aliases 2>&1 ||
echo 'command failed: shopt -s expand_aliases'

echo '$ alias json='\''json0 -f'\'''
alias json='json0 -f' 2>&1 ||
echo 'command failed: alias json='\''json0 -f'\'''

echo '$ json -- ../lib/test-filter.so -X'
json -- ../lib/test-filter.so -X 2>&1 ||
echo 'command failed: json -- ../lib/test-filter.so -X'

echo '$ json -- ../lib/test-filter.so --foo'
json -- ../lib/test-filter.so --foo 2>&1 ||
echo 'command failed: json -- ../lib/test-filter.so --foo'

echo '$ json -- ../lib/test-filter.so -f'
json -- ../lib/test-filter.so -f 2>&1 ||
echo 'command failed: json -- ../lib/test-filter.so -f'

echo '$ json -- ../lib/test-filter.so --fail'
json -- ../lib/test-filter.so --fail 2>&1 ||
echo 'command failed: json -- ../lib/test-filter.so --fail'

echo '$ json -- ../lib/test-filter.so -f '\'''\'''
json -- ../lib/test-filter.so -f '' 2>&1 ||
echo 'command failed: json -- ../lib/test-filter.so -f '\'''\'''

echo '$ json -- ../lib/test-filter.so --fail='
json -- ../lib/test-filter.so --fail= 2>&1 ||
echo 'command failed: json -- ../lib/test-filter.so --fail='

echo '$ json -- ../lib/test-filter.so -f foo'
json -- ../lib/test-filter.so -f foo 2>&1 ||
echo 'command failed: json -- ../lib/test-filter.so -f foo'

echo '$ json -- ../lib/test-filter.so --fail=foo'
json -- ../lib/test-filter.so --fail=foo 2>&1 ||
echo 'command failed: json -- ../lib/test-filter.so --fail=foo'

echo '$ json -- ../lib/test-filter.so --no-fail='
json -- ../lib/test-filter.so --no-fail= 2>&1 ||
echo 'command failed: json -- ../lib/test-filter.so --no-fail='

echo '$ json -- ../lib/test-filter.so --no-fail=foo'
json -- ../lib/test-filter.so --no-fail=foo 2>&1 ||
echo 'command failed: json -- ../lib/test-filter.so --no-fail=foo'
)

