#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C parser:number11
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L number11.old <(echo \
'$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }
$ json() { json0 --literal-value "$@"; }
$ echo -n 0|json -b 1
0
$ echo -n 0|json -b 2
0
$ echo -n -|json -b 1
json: error: <stdin>:1:2: lex error: invalid number literal
json: error: <stdin>:1:2: -
json: error: <stdin>:1:2:  ^
command failed: echo -n -|json -b 1
$ echo -n -|json -b 2
json: error: <stdin>:1:2: lex error: invalid number literal
json: error: <stdin>:1:2: -
json: error: <stdin>:1:2:  ^
command failed: echo -n -|json -b 2
$ echo -n -1|json -b 1
-1
$ echo -n -1|json -b 2
-1
$ echo -n -1|json -b 3
-1
$ echo -n -12|json -b 1
-12
$ echo -n -12|json -b 2
-12
$ echo -n -12|json -b 3
-12
$ echo -n -12|json -b 4
-12
$ echo -n -123|json -b 1
-123
$ echo -n -123|json -b 2
-123
$ echo -n -123|json -b 3
-123
$ echo -n -123|json -b 4
-123
$ echo -n -123|json -b 5
-123
$ echo -n -123.|json -b 1
json: error: <stdin>:1:6: lex error: invalid number literal
json: error: <stdin>:1:6: -123.
json: error: <stdin>:1:6:      ^
command failed: echo -n -123.|json -b 1
$ echo -n -123.|json -b 2
json: error: <stdin>:1:6: lex error: invalid number literal
json: error: <stdin>:1:6: -123.
json: error: <stdin>:1:6:      ^
command failed: echo -n -123.|json -b 2
$ echo -n -123.|json -b 3
json: error: <stdin>:1:6: lex error: invalid number literal
json: error: <stdin>:1:6: -123.
json: error: <stdin>:1:6:      ^
command failed: echo -n -123.|json -b 3
$ echo -n -123.|json -b 4
json: error: <stdin>:1:6: lex error: invalid number literal
json: error: <stdin>:1:6: -123.
json: error: <stdin>:1:6:      ^
command failed: echo -n -123.|json -b 4
$ echo -n -123.|json -b 5
json: error: <stdin>:1:6: lex error: invalid number literal
json: error: <stdin>:1:6: -123.
json: error: <stdin>:1:6:      ^
command failed: echo -n -123.|json -b 5
$ echo -n -123.|json -b 6
json: error: <stdin>:1:6: lex error: invalid number literal
json: error: <stdin>:1:6: -123.
json: error: <stdin>:1:6:      ^
command failed: echo -n -123.|json -b 6
$ echo -n -123.4|json -b 1
-123.4
$ echo -n -123.4|json -b 2
-123.4
$ echo -n -123.4|json -b 3
-123.4
$ echo -n -123.4|json -b 4
-123.4
$ echo -n -123.4|json -b 5
-123.4
$ echo -n -123.4|json -b 6
-123.4
$ echo -n -123.4|json -b 7
-123.4
$ echo -n -123.45|json -b 1
-123.45
$ echo -n -123.45|json -b 2
-123.45
$ echo -n -123.45|json -b 3
-123.45
$ echo -n -123.45|json -b 4
-123.45
$ echo -n -123.45|json -b 5
-123.45
$ echo -n -123.45|json -b 6
-123.45
$ echo -n -123.45|json -b 7
-123.45
$ echo -n -123.45|json -b 8
-123.45
$ echo -n -123.456|json -b 1
-123.456
$ echo -n -123.456|json -b 2
-123.456
$ echo -n -123.456|json -b 3
-123.456
$ echo -n -123.456|json -b 4
-123.456
$ echo -n -123.456|json -b 5
-123.456
$ echo -n -123.456|json -b 6
-123.456
$ echo -n -123.456|json -b 7
-123.456
$ echo -n -123.456|json -b 8
-123.456
$ echo -n -123.456|json -b 9
-123.456
$ echo -n -123.456e|json -b 1
json: error: <stdin>:1:10: lex error: invalid number literal
json: error: <stdin>:1:10: -123.456e
json: error: <stdin>:1:10:          ^
command failed: echo -n -123.456e|json -b 1
$ echo -n -123.456e|json -b 2
json: error: <stdin>:1:10: lex error: invalid number literal
json: error: <stdin>:1:10: -123.456e
json: error: <stdin>:1:10:          ^
command failed: echo -n -123.456e|json -b 2
$ echo -n -123.456e|json -b 3
json: error: <stdin>:1:10: lex error: invalid number literal
json: error: <stdin>:1:10: -123.456e
json: error: <stdin>:1:10:          ^
command failed: echo -n -123.456e|json -b 3
$ echo -n -123.456e|json -b 4
json: error: <stdin>:1:10: lex error: invalid number literal
json: error: <stdin>:1:10: -123.456e
json: error: <stdin>:1:10:          ^
command failed: echo -n -123.456e|json -b 4
$ echo -n -123.456e|json -b 5
json: error: <stdin>:1:10: lex error: invalid number literal
json: error: <stdin>:1:10: -123.456e
json: error: <stdin>:1:10:          ^
command failed: echo -n -123.456e|json -b 5
$ echo -n -123.456e|json -b 6
json: error: <stdin>:1:10: lex error: invalid number literal
json: error: <stdin>:1:10: -123.456e
json: error: <stdin>:1:10:          ^
command failed: echo -n -123.456e|json -b 6
$ echo -n -123.456e|json -b 7
json: error: <stdin>:1:10: lex error: invalid number literal
json: error: <stdin>:1:10: -123.456e
json: error: <stdin>:1:10:          ^
command failed: echo -n -123.456e|json -b 7
$ echo -n -123.456e|json -b 8
json: error: <stdin>:1:10: lex error: invalid number literal
json: error: <stdin>:1:10: -123.456e
json: error: <stdin>:1:10:          ^
command failed: echo -n -123.456e|json -b 8
$ echo -n -123.456e|json -b 9
json: error: <stdin>:1:10: lex error: invalid number literal
json: error: <stdin>:1:10: -123.456e
json: error: <stdin>:1:10:          ^
command failed: echo -n -123.456e|json -b 9
$ echo -n -123.456e|json -b 10
json: error: <stdin>:1:10: lex error: invalid number literal
json: error: <stdin>:1:10: -123.456e
json: error: <stdin>:1:10:          ^
command failed: echo -n -123.456e|json -b 10
$ echo -n -123.456e+|json -b 1
json: error: <stdin>:1:11: lex error: invalid number literal
json: error: <stdin>:1:11: -123.456e+
json: error: <stdin>:1:11:           ^
command failed: echo -n -123.456e+|json -b 1
$ echo -n -123.456e+|json -b 2
json: error: <stdin>:1:11: lex error: invalid number literal
json: error: <stdin>:1:11: -123.456e+
json: error: <stdin>:1:11:           ^
command failed: echo -n -123.456e+|json -b 2
$ echo -n -123.456e+|json -b 3
json: error: <stdin>:1:11: lex error: invalid number literal
json: error: <stdin>:1:11: -123.456e+
json: error: <stdin>:1:11:           ^
command failed: echo -n -123.456e+|json -b 3
$ echo -n -123.456e+|json -b 4
json: error: <stdin>:1:11: lex error: invalid number literal
json: error: <stdin>:1:11: -123.456e+
json: error: <stdin>:1:11:           ^
command failed: echo -n -123.456e+|json -b 4
$ echo -n -123.456e+|json -b 5
json: error: <stdin>:1:11: lex error: invalid number literal
json: error: <stdin>:1:11: -123.456e+
json: error: <stdin>:1:11:           ^
command failed: echo -n -123.456e+|json -b 5
$ echo -n -123.456e+|json -b 6
json: error: <stdin>:1:11: lex error: invalid number literal
json: error: <stdin>:1:11: -123.456e+
json: error: <stdin>:1:11:           ^
command failed: echo -n -123.456e+|json -b 6
$ echo -n -123.456e+|json -b 7
json: error: <stdin>:1:11: lex error: invalid number literal
json: error: <stdin>:1:11: -123.456e+
json: error: <stdin>:1:11:           ^
command failed: echo -n -123.456e+|json -b 7
$ echo -n -123.456e+|json -b 8
json: error: <stdin>:1:11: lex error: invalid number literal
json: error: <stdin>:1:11: -123.456e+
json: error: <stdin>:1:11:           ^
command failed: echo -n -123.456e+|json -b 8
$ echo -n -123.456e+|json -b 9
json: error: <stdin>:1:11: lex error: invalid number literal
json: error: <stdin>:1:11: -123.456e+
json: error: <stdin>:1:11:           ^
command failed: echo -n -123.456e+|json -b 9
$ echo -n -123.456e+|json -b 10
json: error: <stdin>:1:11: lex error: invalid number literal
json: error: <stdin>:1:11: -123.456e+
json: error: <stdin>:1:11:           ^
command failed: echo -n -123.456e+|json -b 10
$ echo -n -123.456e+|json -b 11
json: error: <stdin>:1:11: lex error: invalid number literal
json: error: <stdin>:1:11: -123.456e+
json: error: <stdin>:1:11:           ^
command failed: echo -n -123.456e+|json -b 11
$ echo -n -123.456e+7|json -b 1
-123.456e+7
$ echo -n -123.456e+7|json -b 2
-123.456e+7
$ echo -n -123.456e+7|json -b 3
-123.456e+7
$ echo -n -123.456e+7|json -b 4
-123.456e+7
$ echo -n -123.456e+7|json -b 5
-123.456e+7
$ echo -n -123.456e+7|json -b 6
-123.456e+7
$ echo -n -123.456e+7|json -b 7
-123.456e+7
$ echo -n -123.456e+7|json -b 8
-123.456e+7
$ echo -n -123.456e+7|json -b 9
-123.456e+7
$ echo -n -123.456e+7|json -b 10
-123.456e+7
$ echo -n -123.456e+7|json -b 11
-123.456e+7
$ echo -n -123.456e+7|json -b 12
-123.456e+7
$ echo -n -123.456e+78|json -b 1
-123.456e+78
$ echo -n -123.456e+78|json -b 2
-123.456e+78
$ echo -n -123.456e+78|json -b 3
-123.456e+78
$ echo -n -123.456e+78|json -b 4
-123.456e+78
$ echo -n -123.456e+78|json -b 5
-123.456e+78
$ echo -n -123.456e+78|json -b 6
-123.456e+78
$ echo -n -123.456e+78|json -b 7
-123.456e+78
$ echo -n -123.456e+78|json -b 8
-123.456e+78
$ echo -n -123.456e+78|json -b 9
-123.456e+78
$ echo -n -123.456e+78|json -b 10
-123.456e+78
$ echo -n -123.456e+78|json -b 11
-123.456e+78
$ echo -n -123.456e+78|json -b 12
-123.456e+78
$ echo -n -123.456e+78|json -b 13
-123.456e+78
$ echo -n -123.456e+789|json -b 1
-123.456e+789
$ echo -n -123.456e+789|json -b 2
-123.456e+789
$ echo -n -123.456e+789|json -b 3
-123.456e+789
$ echo -n -123.456e+789|json -b 4
-123.456e+789
$ echo -n -123.456e+789|json -b 5
-123.456e+789
$ echo -n -123.456e+789|json -b 6
-123.456e+789
$ echo -n -123.456e+789|json -b 7
-123.456e+789
$ echo -n -123.456e+789|json -b 8
-123.456e+789
$ echo -n -123.456e+789|json -b 9
-123.456e+789
$ echo -n -123.456e+789|json -b 10
-123.456e+789
$ echo -n -123.456e+789|json -b 11
-123.456e+789
$ echo -n -123.456e+789|json -b 12
-123.456e+789
$ echo -n -123.456e+789|json -b 13
-123.456e+789
$ echo -n -123.456e+789|json -b 14
-123.456e+789
$ echo -n -123.456e-|json -b 1
json: error: <stdin>:1:11: lex error: invalid number literal
json: error: <stdin>:1:11: -123.456e-
json: error: <stdin>:1:11:           ^
command failed: echo -n -123.456e-|json -b 1
$ echo -n -123.456e-|json -b 2
json: error: <stdin>:1:11: lex error: invalid number literal
json: error: <stdin>:1:11: -123.456e-
json: error: <stdin>:1:11:           ^
command failed: echo -n -123.456e-|json -b 2
$ echo -n -123.456e-|json -b 3
json: error: <stdin>:1:11: lex error: invalid number literal
json: error: <stdin>:1:11: -123.456e-
json: error: <stdin>:1:11:           ^
command failed: echo -n -123.456e-|json -b 3
$ echo -n -123.456e-|json -b 4
json: error: <stdin>:1:11: lex error: invalid number literal
json: error: <stdin>:1:11: -123.456e-
json: error: <stdin>:1:11:           ^
command failed: echo -n -123.456e-|json -b 4
$ echo -n -123.456e-|json -b 5
json: error: <stdin>:1:11: lex error: invalid number literal
json: error: <stdin>:1:11: -123.456e-
json: error: <stdin>:1:11:           ^
command failed: echo -n -123.456e-|json -b 5
$ echo -n -123.456e-|json -b 6
json: error: <stdin>:1:11: lex error: invalid number literal
json: error: <stdin>:1:11: -123.456e-
json: error: <stdin>:1:11:           ^
command failed: echo -n -123.456e-|json -b 6
$ echo -n -123.456e-|json -b 7
json: error: <stdin>:1:11: lex error: invalid number literal
json: error: <stdin>:1:11: -123.456e-
json: error: <stdin>:1:11:           ^
command failed: echo -n -123.456e-|json -b 7
$ echo -n -123.456e-|json -b 8
json: error: <stdin>:1:11: lex error: invalid number literal
json: error: <stdin>:1:11: -123.456e-
json: error: <stdin>:1:11:           ^
command failed: echo -n -123.456e-|json -b 8
$ echo -n -123.456e-|json -b 9
json: error: <stdin>:1:11: lex error: invalid number literal
json: error: <stdin>:1:11: -123.456e-
json: error: <stdin>:1:11:           ^
command failed: echo -n -123.456e-|json -b 9
$ echo -n -123.456e-|json -b 10
json: error: <stdin>:1:11: lex error: invalid number literal
json: error: <stdin>:1:11: -123.456e-
json: error: <stdin>:1:11:           ^
command failed: echo -n -123.456e-|json -b 10
$ echo -n -123.456e-|json -b 11
json: error: <stdin>:1:11: lex error: invalid number literal
json: error: <stdin>:1:11: -123.456e-
json: error: <stdin>:1:11:           ^
command failed: echo -n -123.456e-|json -b 11
$ echo -n -123.456e-7|json -b 1
-123.456e-7
$ echo -n -123.456e-7|json -b 2
-123.456e-7
$ echo -n -123.456e-7|json -b 3
-123.456e-7
$ echo -n -123.456e-7|json -b 4
-123.456e-7
$ echo -n -123.456e-7|json -b 5
-123.456e-7
$ echo -n -123.456e-7|json -b 6
-123.456e-7
$ echo -n -123.456e-7|json -b 7
-123.456e-7
$ echo -n -123.456e-7|json -b 8
-123.456e-7
$ echo -n -123.456e-7|json -b 9
-123.456e-7
$ echo -n -123.456e-7|json -b 10
-123.456e-7
$ echo -n -123.456e-7|json -b 11
-123.456e-7
$ echo -n -123.456e-7|json -b 12
-123.456e-7
$ echo -n -123.456e-78|json -b 1
-123.456e-78
$ echo -n -123.456e-78|json -b 2
-123.456e-78
$ echo -n -123.456e-78|json -b 3
-123.456e-78
$ echo -n -123.456e-78|json -b 4
-123.456e-78
$ echo -n -123.456e-78|json -b 5
-123.456e-78
$ echo -n -123.456e-78|json -b 6
-123.456e-78
$ echo -n -123.456e-78|json -b 7
-123.456e-78
$ echo -n -123.456e-78|json -b 8
-123.456e-78
$ echo -n -123.456e-78|json -b 9
-123.456e-78
$ echo -n -123.456e-78|json -b 10
-123.456e-78
$ echo -n -123.456e-78|json -b 11
-123.456e-78
$ echo -n -123.456e-78|json -b 12
-123.456e-78
$ echo -n -123.456e-78|json -b 13
-123.456e-78
$ echo -n -123.456e-789|json -b 1
-123.456e-789
$ echo -n -123.456e-789|json -b 2
-123.456e-789
$ echo -n -123.456e-789|json -b 3
-123.456e-789
$ echo -n -123.456e-789|json -b 4
-123.456e-789
$ echo -n -123.456e-789|json -b 5
-123.456e-789
$ echo -n -123.456e-789|json -b 6
-123.456e-789
$ echo -n -123.456e-789|json -b 7
-123.456e-789
$ echo -n -123.456e-789|json -b 8
-123.456e-789
$ echo -n -123.456e-789|json -b 9
-123.456e-789
$ echo -n -123.456e-789|json -b 10
-123.456e-789
$ echo -n -123.456e-789|json -b 11
-123.456e-789
$ echo -n -123.456e-789|json -b 12
-123.456e-789
$ echo -n -123.456e-789|json -b 13
-123.456e-789
$ echo -n -123.456e-789|json -b 14
-123.456e-789
$ echo -n -123.456e7|json -b 1
-123.456e7
$ echo -n -123.456e7|json -b 2
-123.456e7
$ echo -n -123.456e7|json -b 3
-123.456e7
$ echo -n -123.456e7|json -b 4
-123.456e7
$ echo -n -123.456e7|json -b 5
-123.456e7
$ echo -n -123.456e7|json -b 6
-123.456e7
$ echo -n -123.456e7|json -b 7
-123.456e7
$ echo -n -123.456e7|json -b 8
-123.456e7
$ echo -n -123.456e7|json -b 9
-123.456e7
$ echo -n -123.456e7|json -b 10
-123.456e7
$ echo -n -123.456e7|json -b 11
-123.456e7
$ echo -n -123.456e78|json -b 1
-123.456e78
$ echo -n -123.456e78|json -b 2
-123.456e78
$ echo -n -123.456e78|json -b 3
-123.456e78
$ echo -n -123.456e78|json -b 4
-123.456e78
$ echo -n -123.456e78|json -b 5
-123.456e78
$ echo -n -123.456e78|json -b 6
-123.456e78
$ echo -n -123.456e78|json -b 7
-123.456e78
$ echo -n -123.456e78|json -b 8
-123.456e78
$ echo -n -123.456e78|json -b 9
-123.456e78
$ echo -n -123.456e78|json -b 10
-123.456e78
$ echo -n -123.456e78|json -b 11
-123.456e78
$ echo -n -123.456e78|json -b 12
-123.456e78
$ echo -n -123.456e789|json -b 1
-123.456e789
$ echo -n -123.456e789|json -b 2
-123.456e789
$ echo -n -123.456e789|json -b 3
-123.456e789
$ echo -n -123.456e789|json -b 4
-123.456e789
$ echo -n -123.456e789|json -b 5
-123.456e789
$ echo -n -123.456e789|json -b 6
-123.456e789
$ echo -n -123.456e789|json -b 7
-123.456e789
$ echo -n -123.456e789|json -b 8
-123.456e789
$ echo -n -123.456e789|json -b 9
-123.456e789
$ echo -n -123.456e789|json -b 10
-123.456e789
$ echo -n -123.456e789|json -b 11
-123.456e789
$ echo -n -123.456e789|json -b 12
-123.456e789
$ echo -n -123.456e789|json -b 13
-123.456e789
$ echo -n -123e|json -b 1
json: error: <stdin>:1:6: lex error: invalid number literal
json: error: <stdin>:1:6: -123e
json: error: <stdin>:1:6:      ^
command failed: echo -n -123e|json -b 1
$ echo -n -123e|json -b 2
json: error: <stdin>:1:6: lex error: invalid number literal
json: error: <stdin>:1:6: -123e
json: error: <stdin>:1:6:      ^
command failed: echo -n -123e|json -b 2
$ echo -n -123e|json -b 3
json: error: <stdin>:1:6: lex error: invalid number literal
json: error: <stdin>:1:6: -123e
json: error: <stdin>:1:6:      ^
command failed: echo -n -123e|json -b 3
$ echo -n -123e|json -b 4
json: error: <stdin>:1:6: lex error: invalid number literal
json: error: <stdin>:1:6: -123e
json: error: <stdin>:1:6:      ^
command failed: echo -n -123e|json -b 4
$ echo -n -123e|json -b 5
json: error: <stdin>:1:6: lex error: invalid number literal
json: error: <stdin>:1:6: -123e
json: error: <stdin>:1:6:      ^
command failed: echo -n -123e|json -b 5
$ echo -n -123e|json -b 6
json: error: <stdin>:1:6: lex error: invalid number literal
json: error: <stdin>:1:6: -123e
json: error: <stdin>:1:6:      ^
command failed: echo -n -123e|json -b 6
$ echo -n -123e+|json -b 1
json: error: <stdin>:1:7: lex error: invalid number literal
json: error: <stdin>:1:7: -123e+
json: error: <stdin>:1:7:       ^
command failed: echo -n -123e+|json -b 1
$ echo -n -123e+|json -b 2
json: error: <stdin>:1:7: lex error: invalid number literal
json: error: <stdin>:1:7: -123e+
json: error: <stdin>:1:7:       ^
command failed: echo -n -123e+|json -b 2
$ echo -n -123e+|json -b 3
json: error: <stdin>:1:7: lex error: invalid number literal
json: error: <stdin>:1:7: -123e+
json: error: <stdin>:1:7:       ^
command failed: echo -n -123e+|json -b 3
$ echo -n -123e+|json -b 4
json: error: <stdin>:1:7: lex error: invalid number literal
json: error: <stdin>:1:7: -123e+
json: error: <stdin>:1:7:       ^
command failed: echo -n -123e+|json -b 4
$ echo -n -123e+|json -b 5
json: error: <stdin>:1:7: lex error: invalid number literal
json: error: <stdin>:1:7: -123e+
json: error: <stdin>:1:7:       ^
command failed: echo -n -123e+|json -b 5
$ echo -n -123e+|json -b 6
json: error: <stdin>:1:7: lex error: invalid number literal
json: error: <stdin>:1:7: -123e+
json: error: <stdin>:1:7:       ^
command failed: echo -n -123e+|json -b 6
$ echo -n -123e+|json -b 7
json: error: <stdin>:1:7: lex error: invalid number literal
json: error: <stdin>:1:7: -123e+
json: error: <stdin>:1:7:       ^
command failed: echo -n -123e+|json -b 7
$ echo -n -123e+4|json -b 1
-123e+4
$ echo -n -123e+4|json -b 2
-123e+4
$ echo -n -123e+4|json -b 3
-123e+4
$ echo -n -123e+4|json -b 4
-123e+4
$ echo -n -123e+4|json -b 5
-123e+4
$ echo -n -123e+4|json -b 6
-123e+4
$ echo -n -123e+4|json -b 7
-123e+4
$ echo -n -123e+4|json -b 8
-123e+4
$ echo -n -123e+45|json -b 1
-123e+45
$ echo -n -123e+45|json -b 2
-123e+45
$ echo -n -123e+45|json -b 3
-123e+45
$ echo -n -123e+45|json -b 4
-123e+45
$ echo -n -123e+45|json -b 5
-123e+45
$ echo -n -123e+45|json -b 6
-123e+45
$ echo -n -123e+45|json -b 7
-123e+45
$ echo -n -123e+45|json -b 8
-123e+45
$ echo -n -123e+45|json -b 9
-123e+45
$ echo -n -123e+456|json -b 1
-123e+456
$ echo -n -123e+456|json -b 2
-123e+456
$ echo -n -123e+456|json -b 3
-123e+456
$ echo -n -123e+456|json -b 4
-123e+456
$ echo -n -123e+456|json -b 5
-123e+456
$ echo -n -123e+456|json -b 6
-123e+456
$ echo -n -123e+456|json -b 7
-123e+456
$ echo -n -123e+456|json -b 8
-123e+456
$ echo -n -123e+456|json -b 9
-123e+456
$ echo -n -123e+456|json -b 10
-123e+456
$ echo -n -123e-|json -b 1
json: error: <stdin>:1:7: lex error: invalid number literal
json: error: <stdin>:1:7: -123e-
json: error: <stdin>:1:7:       ^
command failed: echo -n -123e-|json -b 1
$ echo -n -123e-|json -b 2
json: error: <stdin>:1:7: lex error: invalid number literal
json: error: <stdin>:1:7: -123e-
json: error: <stdin>:1:7:       ^
command failed: echo -n -123e-|json -b 2
$ echo -n -123e-|json -b 3
json: error: <stdin>:1:7: lex error: invalid number literal
json: error: <stdin>:1:7: -123e-
json: error: <stdin>:1:7:       ^
command failed: echo -n -123e-|json -b 3
$ echo -n -123e-|json -b 4
json: error: <stdin>:1:7: lex error: invalid number literal
json: error: <stdin>:1:7: -123e-
json: error: <stdin>:1:7:       ^
command failed: echo -n -123e-|json -b 4
$ echo -n -123e-|json -b 5
json: error: <stdin>:1:7: lex error: invalid number literal
json: error: <stdin>:1:7: -123e-
json: error: <stdin>:1:7:       ^
command failed: echo -n -123e-|json -b 5
$ echo -n -123e-|json -b 6
json: error: <stdin>:1:7: lex error: invalid number literal
json: error: <stdin>:1:7: -123e-
json: error: <stdin>:1:7:       ^
command failed: echo -n -123e-|json -b 6
$ echo -n -123e-|json -b 7
json: error: <stdin>:1:7: lex error: invalid number literal
json: error: <stdin>:1:7: -123e-
json: error: <stdin>:1:7:       ^
command failed: echo -n -123e-|json -b 7
$ echo -n -123e-4|json -b 1
-123e-4
$ echo -n -123e-4|json -b 2
-123e-4
$ echo -n -123e-4|json -b 3
-123e-4
$ echo -n -123e-4|json -b 4
-123e-4
$ echo -n -123e-4|json -b 5
-123e-4
$ echo -n -123e-4|json -b 6
-123e-4
$ echo -n -123e-4|json -b 7
-123e-4
$ echo -n -123e-4|json -b 8
-123e-4
$ echo -n -123e-45|json -b 1
-123e-45
$ echo -n -123e-45|json -b 2
-123e-45
$ echo -n -123e-45|json -b 3
-123e-45
$ echo -n -123e-45|json -b 4
-123e-45
$ echo -n -123e-45|json -b 5
-123e-45
$ echo -n -123e-45|json -b 6
-123e-45
$ echo -n -123e-45|json -b 7
-123e-45
$ echo -n -123e-45|json -b 8
-123e-45
$ echo -n -123e-45|json -b 9
-123e-45
$ echo -n -123e-456|json -b 1
-123e-456
$ echo -n -123e-456|json -b 2
-123e-456
$ echo -n -123e-456|json -b 3
-123e-456
$ echo -n -123e-456|json -b 4
-123e-456
$ echo -n -123e-456|json -b 5
-123e-456
$ echo -n -123e-456|json -b 6
-123e-456
$ echo -n -123e-456|json -b 7
-123e-456
$ echo -n -123e-456|json -b 8
-123e-456
$ echo -n -123e-456|json -b 9
-123e-456
$ echo -n -123e-456|json -b 10
-123e-456
$ echo -n -123e4|json -b 1
-123e4
$ echo -n -123e4|json -b 2
-123e4
$ echo -n -123e4|json -b 3
-123e4
$ echo -n -123e4|json -b 4
-123e4
$ echo -n -123e4|json -b 5
-123e4
$ echo -n -123e4|json -b 6
-123e4
$ echo -n -123e4|json -b 7
-123e4
$ echo -n -123e45|json -b 1
-123e45
$ echo -n -123e45|json -b 2
-123e45
$ echo -n -123e45|json -b 3
-123e45
$ echo -n -123e45|json -b 4
-123e45
$ echo -n -123e45|json -b 5
-123e45
$ echo -n -123e45|json -b 6
-123e45
$ echo -n -123e45|json -b 7
-123e45
$ echo -n -123e45|json -b 8
-123e45
$ echo -n -123e456|json -b 1
-123e456
$ echo -n -123e456|json -b 2
-123e456
$ echo -n -123e456|json -b 3
-123e456
$ echo -n -123e456|json -b 4
-123e456
$ echo -n -123e456|json -b 5
-123e456
$ echo -n -123e456|json -b 6
-123e456
$ echo -n -123e456|json -b 7
-123e456
$ echo -n -123e456|json -b 8
-123e456
$ echo -n -123e456|json -b 9
-123e456
$ echo -n 1|json -b 1
1
$ echo -n 1|json -b 2
1
$ echo -n 12|json -b 1
12
$ echo -n 12|json -b 2
12
$ echo -n 12|json -b 3
12
$ echo -n 123|json -b 1
123
$ echo -n 123|json -b 2
123
$ echo -n 123|json -b 3
123
$ echo -n 123|json -b 4
123
$ echo -n 123.|json -b 1
json: error: <stdin>:1:5: lex error: invalid number literal
json: error: <stdin>:1:5: 123.
json: error: <stdin>:1:5:     ^
command failed: echo -n 123.|json -b 1
$ echo -n 123.|json -b 2
json: error: <stdin>:1:5: lex error: invalid number literal
json: error: <stdin>:1:5: 123.
json: error: <stdin>:1:5:     ^
command failed: echo -n 123.|json -b 2
$ echo -n 123.|json -b 3
json: error: <stdin>:1:5: lex error: invalid number literal
json: error: <stdin>:1:5: 123.
json: error: <stdin>:1:5:     ^
command failed: echo -n 123.|json -b 3
$ echo -n 123.|json -b 4
json: error: <stdin>:1:5: lex error: invalid number literal
json: error: <stdin>:1:5: 123.
json: error: <stdin>:1:5:     ^
command failed: echo -n 123.|json -b 4
$ echo -n 123.|json -b 5
json: error: <stdin>:1:5: lex error: invalid number literal
json: error: <stdin>:1:5: 123.
json: error: <stdin>:1:5:     ^
command failed: echo -n 123.|json -b 5
$ echo -n 123.4|json -b 1
123.4
$ echo -n 123.4|json -b 2
123.4
$ echo -n 123.4|json -b 3
123.4
$ echo -n 123.4|json -b 4
123.4
$ echo -n 123.4|json -b 5
123.4
$ echo -n 123.4|json -b 6
123.4
$ echo -n 123.45|json -b 1
123.45
$ echo -n 123.45|json -b 2
123.45
$ echo -n 123.45|json -b 3
123.45
$ echo -n 123.45|json -b 4
123.45
$ echo -n 123.45|json -b 5
123.45
$ echo -n 123.45|json -b 6
123.45
$ echo -n 123.45|json -b 7
123.45
$ echo -n 123.456|json -b 1
123.456
$ echo -n 123.456|json -b 2
123.456
$ echo -n 123.456|json -b 3
123.456
$ echo -n 123.456|json -b 4
123.456
$ echo -n 123.456|json -b 5
123.456
$ echo -n 123.456|json -b 6
123.456
$ echo -n 123.456|json -b 7
123.456
$ echo -n 123.456|json -b 8
123.456
$ echo -n 123.456e|json -b 1
json: error: <stdin>:1:9: lex error: invalid number literal
json: error: <stdin>:1:9: 123.456e
json: error: <stdin>:1:9:         ^
command failed: echo -n 123.456e|json -b 1
$ echo -n 123.456e|json -b 2
json: error: <stdin>:1:9: lex error: invalid number literal
json: error: <stdin>:1:9: 123.456e
json: error: <stdin>:1:9:         ^
command failed: echo -n 123.456e|json -b 2
$ echo -n 123.456e|json -b 3
json: error: <stdin>:1:9: lex error: invalid number literal
json: error: <stdin>:1:9: 123.456e
json: error: <stdin>:1:9:         ^
command failed: echo -n 123.456e|json -b 3
$ echo -n 123.456e|json -b 4
json: error: <stdin>:1:9: lex error: invalid number literal
json: error: <stdin>:1:9: 123.456e
json: error: <stdin>:1:9:         ^
command failed: echo -n 123.456e|json -b 4
$ echo -n 123.456e|json -b 5
json: error: <stdin>:1:9: lex error: invalid number literal
json: error: <stdin>:1:9: 123.456e
json: error: <stdin>:1:9:         ^
command failed: echo -n 123.456e|json -b 5
$ echo -n 123.456e|json -b 6
json: error: <stdin>:1:9: lex error: invalid number literal
json: error: <stdin>:1:9: 123.456e
json: error: <stdin>:1:9:         ^
command failed: echo -n 123.456e|json -b 6
$ echo -n 123.456e|json -b 7
json: error: <stdin>:1:9: lex error: invalid number literal
json: error: <stdin>:1:9: 123.456e
json: error: <stdin>:1:9:         ^
command failed: echo -n 123.456e|json -b 7
$ echo -n 123.456e|json -b 8
json: error: <stdin>:1:9: lex error: invalid number literal
json: error: <stdin>:1:9: 123.456e
json: error: <stdin>:1:9:         ^
command failed: echo -n 123.456e|json -b 8
$ echo -n 123.456e|json -b 9
json: error: <stdin>:1:9: lex error: invalid number literal
json: error: <stdin>:1:9: 123.456e
json: error: <stdin>:1:9:         ^
command failed: echo -n 123.456e|json -b 9
$ echo -n 123.456e+|json -b 1
json: error: <stdin>:1:10: lex error: invalid number literal
json: error: <stdin>:1:10: 123.456e+
json: error: <stdin>:1:10:          ^
command failed: echo -n 123.456e+|json -b 1
$ echo -n 123.456e+|json -b 2
json: error: <stdin>:1:10: lex error: invalid number literal
json: error: <stdin>:1:10: 123.456e+
json: error: <stdin>:1:10:          ^
command failed: echo -n 123.456e+|json -b 2
$ echo -n 123.456e+|json -b 3
json: error: <stdin>:1:10: lex error: invalid number literal
json: error: <stdin>:1:10: 123.456e+
json: error: <stdin>:1:10:          ^
command failed: echo -n 123.456e+|json -b 3
$ echo -n 123.456e+|json -b 4
json: error: <stdin>:1:10: lex error: invalid number literal
json: error: <stdin>:1:10: 123.456e+
json: error: <stdin>:1:10:          ^
command failed: echo -n 123.456e+|json -b 4
$ echo -n 123.456e+|json -b 5
json: error: <stdin>:1:10: lex error: invalid number literal
json: error: <stdin>:1:10: 123.456e+
json: error: <stdin>:1:10:          ^
command failed: echo -n 123.456e+|json -b 5
$ echo -n 123.456e+|json -b 6
json: error: <stdin>:1:10: lex error: invalid number literal
json: error: <stdin>:1:10: 123.456e+
json: error: <stdin>:1:10:          ^
command failed: echo -n 123.456e+|json -b 6
$ echo -n 123.456e+|json -b 7
json: error: <stdin>:1:10: lex error: invalid number literal
json: error: <stdin>:1:10: 123.456e+
json: error: <stdin>:1:10:          ^
command failed: echo -n 123.456e+|json -b 7
$ echo -n 123.456e+|json -b 8
json: error: <stdin>:1:10: lex error: invalid number literal
json: error: <stdin>:1:10: 123.456e+
json: error: <stdin>:1:10:          ^
command failed: echo -n 123.456e+|json -b 8
$ echo -n 123.456e+|json -b 9
json: error: <stdin>:1:10: lex error: invalid number literal
json: error: <stdin>:1:10: 123.456e+
json: error: <stdin>:1:10:          ^
command failed: echo -n 123.456e+|json -b 9
$ echo -n 123.456e+|json -b 10
json: error: <stdin>:1:10: lex error: invalid number literal
json: error: <stdin>:1:10: 123.456e+
json: error: <stdin>:1:10:          ^
command failed: echo -n 123.456e+|json -b 10
$ echo -n 123.456e+7|json -b 1
123.456e+7
$ echo -n 123.456e+7|json -b 2
123.456e+7
$ echo -n 123.456e+7|json -b 3
123.456e+7
$ echo -n 123.456e+7|json -b 4
123.456e+7
$ echo -n 123.456e+7|json -b 5
123.456e+7
$ echo -n 123.456e+7|json -b 6
123.456e+7
$ echo -n 123.456e+7|json -b 7
123.456e+7
$ echo -n 123.456e+7|json -b 8
123.456e+7
$ echo -n 123.456e+7|json -b 9
123.456e+7
$ echo -n 123.456e+7|json -b 10
123.456e+7
$ echo -n 123.456e+7|json -b 11
123.456e+7
$ echo -n 123.456e+78|json -b 1
123.456e+78
$ echo -n 123.456e+78|json -b 2
123.456e+78
$ echo -n 123.456e+78|json -b 3
123.456e+78
$ echo -n 123.456e+78|json -b 4
123.456e+78
$ echo -n 123.456e+78|json -b 5
123.456e+78
$ echo -n 123.456e+78|json -b 6
123.456e+78
$ echo -n 123.456e+78|json -b 7
123.456e+78
$ echo -n 123.456e+78|json -b 8
123.456e+78
$ echo -n 123.456e+78|json -b 9
123.456e+78
$ echo -n 123.456e+78|json -b 10
123.456e+78
$ echo -n 123.456e+78|json -b 11
123.456e+78
$ echo -n 123.456e+78|json -b 12
123.456e+78
$ echo -n 123.456e+789|json -b 1
123.456e+789
$ echo -n 123.456e+789|json -b 2
123.456e+789
$ echo -n 123.456e+789|json -b 3
123.456e+789
$ echo -n 123.456e+789|json -b 4
123.456e+789
$ echo -n 123.456e+789|json -b 5
123.456e+789
$ echo -n 123.456e+789|json -b 6
123.456e+789
$ echo -n 123.456e+789|json -b 7
123.456e+789
$ echo -n 123.456e+789|json -b 8
123.456e+789
$ echo -n 123.456e+789|json -b 9
123.456e+789
$ echo -n 123.456e+789|json -b 10
123.456e+789
$ echo -n 123.456e+789|json -b 11
123.456e+789
$ echo -n 123.456e+789|json -b 12
123.456e+789
$ echo -n 123.456e+789|json -b 13
123.456e+789
$ echo -n 123.456e-|json -b 1
json: error: <stdin>:1:10: lex error: invalid number literal
json: error: <stdin>:1:10: 123.456e-
json: error: <stdin>:1:10:          ^
command failed: echo -n 123.456e-|json -b 1
$ echo -n 123.456e-|json -b 2
json: error: <stdin>:1:10: lex error: invalid number literal
json: error: <stdin>:1:10: 123.456e-
json: error: <stdin>:1:10:          ^
command failed: echo -n 123.456e-|json -b 2
$ echo -n 123.456e-|json -b 3
json: error: <stdin>:1:10: lex error: invalid number literal
json: error: <stdin>:1:10: 123.456e-
json: error: <stdin>:1:10:          ^
command failed: echo -n 123.456e-|json -b 3
$ echo -n 123.456e-|json -b 4
json: error: <stdin>:1:10: lex error: invalid number literal
json: error: <stdin>:1:10: 123.456e-
json: error: <stdin>:1:10:          ^
command failed: echo -n 123.456e-|json -b 4
$ echo -n 123.456e-|json -b 5
json: error: <stdin>:1:10: lex error: invalid number literal
json: error: <stdin>:1:10: 123.456e-
json: error: <stdin>:1:10:          ^
command failed: echo -n 123.456e-|json -b 5
$ echo -n 123.456e-|json -b 6
json: error: <stdin>:1:10: lex error: invalid number literal
json: error: <stdin>:1:10: 123.456e-
json: error: <stdin>:1:10:          ^
command failed: echo -n 123.456e-|json -b 6
$ echo -n 123.456e-|json -b 7
json: error: <stdin>:1:10: lex error: invalid number literal
json: error: <stdin>:1:10: 123.456e-
json: error: <stdin>:1:10:          ^
command failed: echo -n 123.456e-|json -b 7
$ echo -n 123.456e-|json -b 8
json: error: <stdin>:1:10: lex error: invalid number literal
json: error: <stdin>:1:10: 123.456e-
json: error: <stdin>:1:10:          ^
command failed: echo -n 123.456e-|json -b 8
$ echo -n 123.456e-|json -b 9
json: error: <stdin>:1:10: lex error: invalid number literal
json: error: <stdin>:1:10: 123.456e-
json: error: <stdin>:1:10:          ^
command failed: echo -n 123.456e-|json -b 9
$ echo -n 123.456e-|json -b 10
json: error: <stdin>:1:10: lex error: invalid number literal
json: error: <stdin>:1:10: 123.456e-
json: error: <stdin>:1:10:          ^
command failed: echo -n 123.456e-|json -b 10
$ echo -n 123.456e-7|json -b 1
123.456e-7
$ echo -n 123.456e-7|json -b 2
123.456e-7
$ echo -n 123.456e-7|json -b 3
123.456e-7
$ echo -n 123.456e-7|json -b 4
123.456e-7
$ echo -n 123.456e-7|json -b 5
123.456e-7
$ echo -n 123.456e-7|json -b 6
123.456e-7
$ echo -n 123.456e-7|json -b 7
123.456e-7
$ echo -n 123.456e-7|json -b 8
123.456e-7
$ echo -n 123.456e-7|json -b 9
123.456e-7
$ echo -n 123.456e-7|json -b 10
123.456e-7
$ echo -n 123.456e-7|json -b 11
123.456e-7
$ echo -n 123.456e-78|json -b 1
123.456e-78
$ echo -n 123.456e-78|json -b 2
123.456e-78
$ echo -n 123.456e-78|json -b 3
123.456e-78
$ echo -n 123.456e-78|json -b 4
123.456e-78
$ echo -n 123.456e-78|json -b 5
123.456e-78
$ echo -n 123.456e-78|json -b 6
123.456e-78
$ echo -n 123.456e-78|json -b 7
123.456e-78
$ echo -n 123.456e-78|json -b 8
123.456e-78
$ echo -n 123.456e-78|json -b 9
123.456e-78
$ echo -n 123.456e-78|json -b 10
123.456e-78
$ echo -n 123.456e-78|json -b 11
123.456e-78
$ echo -n 123.456e-78|json -b 12
123.456e-78
$ echo -n 123.456e-789|json -b 1
123.456e-789
$ echo -n 123.456e-789|json -b 2
123.456e-789
$ echo -n 123.456e-789|json -b 3
123.456e-789
$ echo -n 123.456e-789|json -b 4
123.456e-789
$ echo -n 123.456e-789|json -b 5
123.456e-789
$ echo -n 123.456e-789|json -b 6
123.456e-789
$ echo -n 123.456e-789|json -b 7
123.456e-789
$ echo -n 123.456e-789|json -b 8
123.456e-789
$ echo -n 123.456e-789|json -b 9
123.456e-789
$ echo -n 123.456e-789|json -b 10
123.456e-789
$ echo -n 123.456e-789|json -b 11
123.456e-789
$ echo -n 123.456e-789|json -b 12
123.456e-789
$ echo -n 123.456e-789|json -b 13
123.456e-789
$ echo -n 123.456e7|json -b 1
123.456e7
$ echo -n 123.456e7|json -b 2
123.456e7
$ echo -n 123.456e7|json -b 3
123.456e7
$ echo -n 123.456e7|json -b 4
123.456e7
$ echo -n 123.456e7|json -b 5
123.456e7
$ echo -n 123.456e7|json -b 6
123.456e7
$ echo -n 123.456e7|json -b 7
123.456e7
$ echo -n 123.456e7|json -b 8
123.456e7
$ echo -n 123.456e7|json -b 9
123.456e7
$ echo -n 123.456e7|json -b 10
123.456e7
$ echo -n 123.456e78|json -b 1
123.456e78
$ echo -n 123.456e78|json -b 2
123.456e78
$ echo -n 123.456e78|json -b 3
123.456e78
$ echo -n 123.456e78|json -b 4
123.456e78
$ echo -n 123.456e78|json -b 5
123.456e78
$ echo -n 123.456e78|json -b 6
123.456e78
$ echo -n 123.456e78|json -b 7
123.456e78
$ echo -n 123.456e78|json -b 8
123.456e78
$ echo -n 123.456e78|json -b 9
123.456e78
$ echo -n 123.456e78|json -b 10
123.456e78
$ echo -n 123.456e78|json -b 11
123.456e78
$ echo -n 123.456e789|json -b 1
123.456e789
$ echo -n 123.456e789|json -b 2
123.456e789
$ echo -n 123.456e789|json -b 3
123.456e789
$ echo -n 123.456e789|json -b 4
123.456e789
$ echo -n 123.456e789|json -b 5
123.456e789
$ echo -n 123.456e789|json -b 6
123.456e789
$ echo -n 123.456e789|json -b 7
123.456e789
$ echo -n 123.456e789|json -b 8
123.456e789
$ echo -n 123.456e789|json -b 9
123.456e789
$ echo -n 123.456e789|json -b 10
123.456e789
$ echo -n 123.456e789|json -b 11
123.456e789
$ echo -n 123.456e789|json -b 12
123.456e789
$ echo -n 123e|json -b 1
json: error: <stdin>:1:5: lex error: invalid number literal
json: error: <stdin>:1:5: 123e
json: error: <stdin>:1:5:     ^
command failed: echo -n 123e|json -b 1
$ echo -n 123e|json -b 2
json: error: <stdin>:1:5: lex error: invalid number literal
json: error: <stdin>:1:5: 123e
json: error: <stdin>:1:5:     ^
command failed: echo -n 123e|json -b 2
$ echo -n 123e|json -b 3
json: error: <stdin>:1:5: lex error: invalid number literal
json: error: <stdin>:1:5: 123e
json: error: <stdin>:1:5:     ^
command failed: echo -n 123e|json -b 3
$ echo -n 123e|json -b 4
json: error: <stdin>:1:5: lex error: invalid number literal
json: error: <stdin>:1:5: 123e
json: error: <stdin>:1:5:     ^
command failed: echo -n 123e|json -b 4
$ echo -n 123e|json -b 5
json: error: <stdin>:1:5: lex error: invalid number literal
json: error: <stdin>:1:5: 123e
json: error: <stdin>:1:5:     ^
command failed: echo -n 123e|json -b 5
$ echo -n 123e+|json -b 1
json: error: <stdin>:1:6: lex error: invalid number literal
json: error: <stdin>:1:6: 123e+
json: error: <stdin>:1:6:      ^
command failed: echo -n 123e+|json -b 1
$ echo -n 123e+|json -b 2
json: error: <stdin>:1:6: lex error: invalid number literal
json: error: <stdin>:1:6: 123e+
json: error: <stdin>:1:6:      ^
command failed: echo -n 123e+|json -b 2
$ echo -n 123e+|json -b 3
json: error: <stdin>:1:6: lex error: invalid number literal
json: error: <stdin>:1:6: 123e+
json: error: <stdin>:1:6:      ^
command failed: echo -n 123e+|json -b 3
$ echo -n 123e+|json -b 4
json: error: <stdin>:1:6: lex error: invalid number literal
json: error: <stdin>:1:6: 123e+
json: error: <stdin>:1:6:      ^
command failed: echo -n 123e+|json -b 4
$ echo -n 123e+|json -b 5
json: error: <stdin>:1:6: lex error: invalid number literal
json: error: <stdin>:1:6: 123e+
json: error: <stdin>:1:6:      ^
command failed: echo -n 123e+|json -b 5
$ echo -n 123e+|json -b 6
json: error: <stdin>:1:6: lex error: invalid number literal
json: error: <stdin>:1:6: 123e+
json: error: <stdin>:1:6:      ^
command failed: echo -n 123e+|json -b 6
$ echo -n 123e+4|json -b 1
123e+4
$ echo -n 123e+4|json -b 2
123e+4
$ echo -n 123e+4|json -b 3
123e+4
$ echo -n 123e+4|json -b 4
123e+4
$ echo -n 123e+4|json -b 5
123e+4
$ echo -n 123e+4|json -b 6
123e+4
$ echo -n 123e+4|json -b 7
123e+4
$ echo -n 123e+45|json -b 1
123e+45
$ echo -n 123e+45|json -b 2
123e+45
$ echo -n 123e+45|json -b 3
123e+45
$ echo -n 123e+45|json -b 4
123e+45
$ echo -n 123e+45|json -b 5
123e+45
$ echo -n 123e+45|json -b 6
123e+45
$ echo -n 123e+45|json -b 7
123e+45
$ echo -n 123e+45|json -b 8
123e+45
$ echo -n 123e+456|json -b 1
123e+456
$ echo -n 123e+456|json -b 2
123e+456
$ echo -n 123e+456|json -b 3
123e+456
$ echo -n 123e+456|json -b 4
123e+456
$ echo -n 123e+456|json -b 5
123e+456
$ echo -n 123e+456|json -b 6
123e+456
$ echo -n 123e+456|json -b 7
123e+456
$ echo -n 123e+456|json -b 8
123e+456
$ echo -n 123e+456|json -b 9
123e+456
$ echo -n 123e-|json -b 1
json: error: <stdin>:1:6: lex error: invalid number literal
json: error: <stdin>:1:6: 123e-
json: error: <stdin>:1:6:      ^
command failed: echo -n 123e-|json -b 1
$ echo -n 123e-|json -b 2
json: error: <stdin>:1:6: lex error: invalid number literal
json: error: <stdin>:1:6: 123e-
json: error: <stdin>:1:6:      ^
command failed: echo -n 123e-|json -b 2
$ echo -n 123e-|json -b 3
json: error: <stdin>:1:6: lex error: invalid number literal
json: error: <stdin>:1:6: 123e-
json: error: <stdin>:1:6:      ^
command failed: echo -n 123e-|json -b 3
$ echo -n 123e-|json -b 4
json: error: <stdin>:1:6: lex error: invalid number literal
json: error: <stdin>:1:6: 123e-
json: error: <stdin>:1:6:      ^
command failed: echo -n 123e-|json -b 4
$ echo -n 123e-|json -b 5
json: error: <stdin>:1:6: lex error: invalid number literal
json: error: <stdin>:1:6: 123e-
json: error: <stdin>:1:6:      ^
command failed: echo -n 123e-|json -b 5
$ echo -n 123e-|json -b 6
json: error: <stdin>:1:6: lex error: invalid number literal
json: error: <stdin>:1:6: 123e-
json: error: <stdin>:1:6:      ^
command failed: echo -n 123e-|json -b 6
$ echo -n 123e-4|json -b 1
123e-4
$ echo -n 123e-4|json -b 2
123e-4
$ echo -n 123e-4|json -b 3
123e-4
$ echo -n 123e-4|json -b 4
123e-4
$ echo -n 123e-4|json -b 5
123e-4
$ echo -n 123e-4|json -b 6
123e-4
$ echo -n 123e-4|json -b 7
123e-4
$ echo -n 123e-45|json -b 1
123e-45
$ echo -n 123e-45|json -b 2
123e-45
$ echo -n 123e-45|json -b 3
123e-45
$ echo -n 123e-45|json -b 4
123e-45
$ echo -n 123e-45|json -b 5
123e-45
$ echo -n 123e-45|json -b 6
123e-45
$ echo -n 123e-45|json -b 7
123e-45
$ echo -n 123e-45|json -b 8
123e-45
$ echo -n 123e-456|json -b 1
123e-456
$ echo -n 123e-456|json -b 2
123e-456
$ echo -n 123e-456|json -b 3
123e-456
$ echo -n 123e-456|json -b 4
123e-456
$ echo -n 123e-456|json -b 5
123e-456
$ echo -n 123e-456|json -b 6
123e-456
$ echo -n 123e-456|json -b 7
123e-456
$ echo -n 123e-456|json -b 8
123e-456
$ echo -n 123e-456|json -b 9
123e-456
$ echo -n 123e4|json -b 1
123e4
$ echo -n 123e4|json -b 2
123e4
$ echo -n 123e4|json -b 3
123e4
$ echo -n 123e4|json -b 4
123e4
$ echo -n 123e4|json -b 5
123e4
$ echo -n 123e4|json -b 6
123e4
$ echo -n 123e45|json -b 1
123e45
$ echo -n 123e45|json -b 2
123e45
$ echo -n 123e45|json -b 3
123e45
$ echo -n 123e45|json -b 4
123e45
$ echo -n 123e45|json -b 5
123e45
$ echo -n 123e45|json -b 6
123e45
$ echo -n 123e45|json -b 7
123e45
$ echo -n 123e456|json -b 1
123e456
$ echo -n 123e456|json -b 2
123e456
$ echo -n 123e456|json -b 3
123e456
$ echo -n 123e456|json -b 4
123e456
$ echo -n 123e456|json -b 5
123e456
$ echo -n 123e456|json -b 6
123e456
$ echo -n 123e456|json -b 7
123e456
$ echo -n 123e456|json -b 8
123e456'
) -L number11.new <(
echo '$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'
json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; } 2>&1 ||
echo 'command failed: json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'

echo '$ json() { json0 --literal-value "$@"; }'
json() { json0 --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { json0 --literal-value "$@"; }'

echo '$ echo -n 0|json -b 1'
echo -n 0|json -b 1 2>&1 ||
echo 'command failed: echo -n 0|json -b 1'

echo '$ echo -n 0|json -b 2'
echo -n 0|json -b 2 2>&1 ||
echo 'command failed: echo -n 0|json -b 2'

echo '$ echo -n -|json -b 1'
echo -n -|json -b 1 2>&1 ||
echo 'command failed: echo -n -|json -b 1'

echo '$ echo -n -|json -b 2'
echo -n -|json -b 2 2>&1 ||
echo 'command failed: echo -n -|json -b 2'

echo '$ echo -n -1|json -b 1'
echo -n -1|json -b 1 2>&1 ||
echo 'command failed: echo -n -1|json -b 1'

echo '$ echo -n -1|json -b 2'
echo -n -1|json -b 2 2>&1 ||
echo 'command failed: echo -n -1|json -b 2'

echo '$ echo -n -1|json -b 3'
echo -n -1|json -b 3 2>&1 ||
echo 'command failed: echo -n -1|json -b 3'

echo '$ echo -n -12|json -b 1'
echo -n -12|json -b 1 2>&1 ||
echo 'command failed: echo -n -12|json -b 1'

echo '$ echo -n -12|json -b 2'
echo -n -12|json -b 2 2>&1 ||
echo 'command failed: echo -n -12|json -b 2'

echo '$ echo -n -12|json -b 3'
echo -n -12|json -b 3 2>&1 ||
echo 'command failed: echo -n -12|json -b 3'

echo '$ echo -n -12|json -b 4'
echo -n -12|json -b 4 2>&1 ||
echo 'command failed: echo -n -12|json -b 4'

echo '$ echo -n -123|json -b 1'
echo -n -123|json -b 1 2>&1 ||
echo 'command failed: echo -n -123|json -b 1'

echo '$ echo -n -123|json -b 2'
echo -n -123|json -b 2 2>&1 ||
echo 'command failed: echo -n -123|json -b 2'

echo '$ echo -n -123|json -b 3'
echo -n -123|json -b 3 2>&1 ||
echo 'command failed: echo -n -123|json -b 3'

echo '$ echo -n -123|json -b 4'
echo -n -123|json -b 4 2>&1 ||
echo 'command failed: echo -n -123|json -b 4'

echo '$ echo -n -123|json -b 5'
echo -n -123|json -b 5 2>&1 ||
echo 'command failed: echo -n -123|json -b 5'

echo '$ echo -n -123.|json -b 1'
echo -n -123.|json -b 1 2>&1 ||
echo 'command failed: echo -n -123.|json -b 1'

echo '$ echo -n -123.|json -b 2'
echo -n -123.|json -b 2 2>&1 ||
echo 'command failed: echo -n -123.|json -b 2'

echo '$ echo -n -123.|json -b 3'
echo -n -123.|json -b 3 2>&1 ||
echo 'command failed: echo -n -123.|json -b 3'

echo '$ echo -n -123.|json -b 4'
echo -n -123.|json -b 4 2>&1 ||
echo 'command failed: echo -n -123.|json -b 4'

echo '$ echo -n -123.|json -b 5'
echo -n -123.|json -b 5 2>&1 ||
echo 'command failed: echo -n -123.|json -b 5'

echo '$ echo -n -123.|json -b 6'
echo -n -123.|json -b 6 2>&1 ||
echo 'command failed: echo -n -123.|json -b 6'

echo '$ echo -n -123.4|json -b 1'
echo -n -123.4|json -b 1 2>&1 ||
echo 'command failed: echo -n -123.4|json -b 1'

echo '$ echo -n -123.4|json -b 2'
echo -n -123.4|json -b 2 2>&1 ||
echo 'command failed: echo -n -123.4|json -b 2'

echo '$ echo -n -123.4|json -b 3'
echo -n -123.4|json -b 3 2>&1 ||
echo 'command failed: echo -n -123.4|json -b 3'

echo '$ echo -n -123.4|json -b 4'
echo -n -123.4|json -b 4 2>&1 ||
echo 'command failed: echo -n -123.4|json -b 4'

echo '$ echo -n -123.4|json -b 5'
echo -n -123.4|json -b 5 2>&1 ||
echo 'command failed: echo -n -123.4|json -b 5'

echo '$ echo -n -123.4|json -b 6'
echo -n -123.4|json -b 6 2>&1 ||
echo 'command failed: echo -n -123.4|json -b 6'

echo '$ echo -n -123.4|json -b 7'
echo -n -123.4|json -b 7 2>&1 ||
echo 'command failed: echo -n -123.4|json -b 7'

echo '$ echo -n -123.45|json -b 1'
echo -n -123.45|json -b 1 2>&1 ||
echo 'command failed: echo -n -123.45|json -b 1'

echo '$ echo -n -123.45|json -b 2'
echo -n -123.45|json -b 2 2>&1 ||
echo 'command failed: echo -n -123.45|json -b 2'

echo '$ echo -n -123.45|json -b 3'
echo -n -123.45|json -b 3 2>&1 ||
echo 'command failed: echo -n -123.45|json -b 3'

echo '$ echo -n -123.45|json -b 4'
echo -n -123.45|json -b 4 2>&1 ||
echo 'command failed: echo -n -123.45|json -b 4'

echo '$ echo -n -123.45|json -b 5'
echo -n -123.45|json -b 5 2>&1 ||
echo 'command failed: echo -n -123.45|json -b 5'

echo '$ echo -n -123.45|json -b 6'
echo -n -123.45|json -b 6 2>&1 ||
echo 'command failed: echo -n -123.45|json -b 6'

echo '$ echo -n -123.45|json -b 7'
echo -n -123.45|json -b 7 2>&1 ||
echo 'command failed: echo -n -123.45|json -b 7'

echo '$ echo -n -123.45|json -b 8'
echo -n -123.45|json -b 8 2>&1 ||
echo 'command failed: echo -n -123.45|json -b 8'

echo '$ echo -n -123.456|json -b 1'
echo -n -123.456|json -b 1 2>&1 ||
echo 'command failed: echo -n -123.456|json -b 1'

echo '$ echo -n -123.456|json -b 2'
echo -n -123.456|json -b 2 2>&1 ||
echo 'command failed: echo -n -123.456|json -b 2'

echo '$ echo -n -123.456|json -b 3'
echo -n -123.456|json -b 3 2>&1 ||
echo 'command failed: echo -n -123.456|json -b 3'

echo '$ echo -n -123.456|json -b 4'
echo -n -123.456|json -b 4 2>&1 ||
echo 'command failed: echo -n -123.456|json -b 4'

echo '$ echo -n -123.456|json -b 5'
echo -n -123.456|json -b 5 2>&1 ||
echo 'command failed: echo -n -123.456|json -b 5'

echo '$ echo -n -123.456|json -b 6'
echo -n -123.456|json -b 6 2>&1 ||
echo 'command failed: echo -n -123.456|json -b 6'

echo '$ echo -n -123.456|json -b 7'
echo -n -123.456|json -b 7 2>&1 ||
echo 'command failed: echo -n -123.456|json -b 7'

echo '$ echo -n -123.456|json -b 8'
echo -n -123.456|json -b 8 2>&1 ||
echo 'command failed: echo -n -123.456|json -b 8'

echo '$ echo -n -123.456|json -b 9'
echo -n -123.456|json -b 9 2>&1 ||
echo 'command failed: echo -n -123.456|json -b 9'

echo '$ echo -n -123.456e|json -b 1'
echo -n -123.456e|json -b 1 2>&1 ||
echo 'command failed: echo -n -123.456e|json -b 1'

echo '$ echo -n -123.456e|json -b 2'
echo -n -123.456e|json -b 2 2>&1 ||
echo 'command failed: echo -n -123.456e|json -b 2'

echo '$ echo -n -123.456e|json -b 3'
echo -n -123.456e|json -b 3 2>&1 ||
echo 'command failed: echo -n -123.456e|json -b 3'

echo '$ echo -n -123.456e|json -b 4'
echo -n -123.456e|json -b 4 2>&1 ||
echo 'command failed: echo -n -123.456e|json -b 4'

echo '$ echo -n -123.456e|json -b 5'
echo -n -123.456e|json -b 5 2>&1 ||
echo 'command failed: echo -n -123.456e|json -b 5'

echo '$ echo -n -123.456e|json -b 6'
echo -n -123.456e|json -b 6 2>&1 ||
echo 'command failed: echo -n -123.456e|json -b 6'

echo '$ echo -n -123.456e|json -b 7'
echo -n -123.456e|json -b 7 2>&1 ||
echo 'command failed: echo -n -123.456e|json -b 7'

echo '$ echo -n -123.456e|json -b 8'
echo -n -123.456e|json -b 8 2>&1 ||
echo 'command failed: echo -n -123.456e|json -b 8'

echo '$ echo -n -123.456e|json -b 9'
echo -n -123.456e|json -b 9 2>&1 ||
echo 'command failed: echo -n -123.456e|json -b 9'

echo '$ echo -n -123.456e|json -b 10'
echo -n -123.456e|json -b 10 2>&1 ||
echo 'command failed: echo -n -123.456e|json -b 10'

echo '$ echo -n -123.456e+|json -b 1'
echo -n -123.456e+|json -b 1 2>&1 ||
echo 'command failed: echo -n -123.456e+|json -b 1'

echo '$ echo -n -123.456e+|json -b 2'
echo -n -123.456e+|json -b 2 2>&1 ||
echo 'command failed: echo -n -123.456e+|json -b 2'

echo '$ echo -n -123.456e+|json -b 3'
echo -n -123.456e+|json -b 3 2>&1 ||
echo 'command failed: echo -n -123.456e+|json -b 3'

echo '$ echo -n -123.456e+|json -b 4'
echo -n -123.456e+|json -b 4 2>&1 ||
echo 'command failed: echo -n -123.456e+|json -b 4'

echo '$ echo -n -123.456e+|json -b 5'
echo -n -123.456e+|json -b 5 2>&1 ||
echo 'command failed: echo -n -123.456e+|json -b 5'

echo '$ echo -n -123.456e+|json -b 6'
echo -n -123.456e+|json -b 6 2>&1 ||
echo 'command failed: echo -n -123.456e+|json -b 6'

echo '$ echo -n -123.456e+|json -b 7'
echo -n -123.456e+|json -b 7 2>&1 ||
echo 'command failed: echo -n -123.456e+|json -b 7'

echo '$ echo -n -123.456e+|json -b 8'
echo -n -123.456e+|json -b 8 2>&1 ||
echo 'command failed: echo -n -123.456e+|json -b 8'

echo '$ echo -n -123.456e+|json -b 9'
echo -n -123.456e+|json -b 9 2>&1 ||
echo 'command failed: echo -n -123.456e+|json -b 9'

echo '$ echo -n -123.456e+|json -b 10'
echo -n -123.456e+|json -b 10 2>&1 ||
echo 'command failed: echo -n -123.456e+|json -b 10'

echo '$ echo -n -123.456e+|json -b 11'
echo -n -123.456e+|json -b 11 2>&1 ||
echo 'command failed: echo -n -123.456e+|json -b 11'

echo '$ echo -n -123.456e+7|json -b 1'
echo -n -123.456e+7|json -b 1 2>&1 ||
echo 'command failed: echo -n -123.456e+7|json -b 1'

echo '$ echo -n -123.456e+7|json -b 2'
echo -n -123.456e+7|json -b 2 2>&1 ||
echo 'command failed: echo -n -123.456e+7|json -b 2'

echo '$ echo -n -123.456e+7|json -b 3'
echo -n -123.456e+7|json -b 3 2>&1 ||
echo 'command failed: echo -n -123.456e+7|json -b 3'

echo '$ echo -n -123.456e+7|json -b 4'
echo -n -123.456e+7|json -b 4 2>&1 ||
echo 'command failed: echo -n -123.456e+7|json -b 4'

echo '$ echo -n -123.456e+7|json -b 5'
echo -n -123.456e+7|json -b 5 2>&1 ||
echo 'command failed: echo -n -123.456e+7|json -b 5'

echo '$ echo -n -123.456e+7|json -b 6'
echo -n -123.456e+7|json -b 6 2>&1 ||
echo 'command failed: echo -n -123.456e+7|json -b 6'

echo '$ echo -n -123.456e+7|json -b 7'
echo -n -123.456e+7|json -b 7 2>&1 ||
echo 'command failed: echo -n -123.456e+7|json -b 7'

echo '$ echo -n -123.456e+7|json -b 8'
echo -n -123.456e+7|json -b 8 2>&1 ||
echo 'command failed: echo -n -123.456e+7|json -b 8'

echo '$ echo -n -123.456e+7|json -b 9'
echo -n -123.456e+7|json -b 9 2>&1 ||
echo 'command failed: echo -n -123.456e+7|json -b 9'

echo '$ echo -n -123.456e+7|json -b 10'
echo -n -123.456e+7|json -b 10 2>&1 ||
echo 'command failed: echo -n -123.456e+7|json -b 10'

echo '$ echo -n -123.456e+7|json -b 11'
echo -n -123.456e+7|json -b 11 2>&1 ||
echo 'command failed: echo -n -123.456e+7|json -b 11'

echo '$ echo -n -123.456e+7|json -b 12'
echo -n -123.456e+7|json -b 12 2>&1 ||
echo 'command failed: echo -n -123.456e+7|json -b 12'

echo '$ echo -n -123.456e+78|json -b 1'
echo -n -123.456e+78|json -b 1 2>&1 ||
echo 'command failed: echo -n -123.456e+78|json -b 1'

echo '$ echo -n -123.456e+78|json -b 2'
echo -n -123.456e+78|json -b 2 2>&1 ||
echo 'command failed: echo -n -123.456e+78|json -b 2'

echo '$ echo -n -123.456e+78|json -b 3'
echo -n -123.456e+78|json -b 3 2>&1 ||
echo 'command failed: echo -n -123.456e+78|json -b 3'

echo '$ echo -n -123.456e+78|json -b 4'
echo -n -123.456e+78|json -b 4 2>&1 ||
echo 'command failed: echo -n -123.456e+78|json -b 4'

echo '$ echo -n -123.456e+78|json -b 5'
echo -n -123.456e+78|json -b 5 2>&1 ||
echo 'command failed: echo -n -123.456e+78|json -b 5'

echo '$ echo -n -123.456e+78|json -b 6'
echo -n -123.456e+78|json -b 6 2>&1 ||
echo 'command failed: echo -n -123.456e+78|json -b 6'

echo '$ echo -n -123.456e+78|json -b 7'
echo -n -123.456e+78|json -b 7 2>&1 ||
echo 'command failed: echo -n -123.456e+78|json -b 7'

echo '$ echo -n -123.456e+78|json -b 8'
echo -n -123.456e+78|json -b 8 2>&1 ||
echo 'command failed: echo -n -123.456e+78|json -b 8'

echo '$ echo -n -123.456e+78|json -b 9'
echo -n -123.456e+78|json -b 9 2>&1 ||
echo 'command failed: echo -n -123.456e+78|json -b 9'

echo '$ echo -n -123.456e+78|json -b 10'
echo -n -123.456e+78|json -b 10 2>&1 ||
echo 'command failed: echo -n -123.456e+78|json -b 10'

echo '$ echo -n -123.456e+78|json -b 11'
echo -n -123.456e+78|json -b 11 2>&1 ||
echo 'command failed: echo -n -123.456e+78|json -b 11'

echo '$ echo -n -123.456e+78|json -b 12'
echo -n -123.456e+78|json -b 12 2>&1 ||
echo 'command failed: echo -n -123.456e+78|json -b 12'

echo '$ echo -n -123.456e+78|json -b 13'
echo -n -123.456e+78|json -b 13 2>&1 ||
echo 'command failed: echo -n -123.456e+78|json -b 13'

echo '$ echo -n -123.456e+789|json -b 1'
echo -n -123.456e+789|json -b 1 2>&1 ||
echo 'command failed: echo -n -123.456e+789|json -b 1'

echo '$ echo -n -123.456e+789|json -b 2'
echo -n -123.456e+789|json -b 2 2>&1 ||
echo 'command failed: echo -n -123.456e+789|json -b 2'

echo '$ echo -n -123.456e+789|json -b 3'
echo -n -123.456e+789|json -b 3 2>&1 ||
echo 'command failed: echo -n -123.456e+789|json -b 3'

echo '$ echo -n -123.456e+789|json -b 4'
echo -n -123.456e+789|json -b 4 2>&1 ||
echo 'command failed: echo -n -123.456e+789|json -b 4'

echo '$ echo -n -123.456e+789|json -b 5'
echo -n -123.456e+789|json -b 5 2>&1 ||
echo 'command failed: echo -n -123.456e+789|json -b 5'

echo '$ echo -n -123.456e+789|json -b 6'
echo -n -123.456e+789|json -b 6 2>&1 ||
echo 'command failed: echo -n -123.456e+789|json -b 6'

echo '$ echo -n -123.456e+789|json -b 7'
echo -n -123.456e+789|json -b 7 2>&1 ||
echo 'command failed: echo -n -123.456e+789|json -b 7'

echo '$ echo -n -123.456e+789|json -b 8'
echo -n -123.456e+789|json -b 8 2>&1 ||
echo 'command failed: echo -n -123.456e+789|json -b 8'

echo '$ echo -n -123.456e+789|json -b 9'
echo -n -123.456e+789|json -b 9 2>&1 ||
echo 'command failed: echo -n -123.456e+789|json -b 9'

echo '$ echo -n -123.456e+789|json -b 10'
echo -n -123.456e+789|json -b 10 2>&1 ||
echo 'command failed: echo -n -123.456e+789|json -b 10'

echo '$ echo -n -123.456e+789|json -b 11'
echo -n -123.456e+789|json -b 11 2>&1 ||
echo 'command failed: echo -n -123.456e+789|json -b 11'

echo '$ echo -n -123.456e+789|json -b 12'
echo -n -123.456e+789|json -b 12 2>&1 ||
echo 'command failed: echo -n -123.456e+789|json -b 12'

echo '$ echo -n -123.456e+789|json -b 13'
echo -n -123.456e+789|json -b 13 2>&1 ||
echo 'command failed: echo -n -123.456e+789|json -b 13'

echo '$ echo -n -123.456e+789|json -b 14'
echo -n -123.456e+789|json -b 14 2>&1 ||
echo 'command failed: echo -n -123.456e+789|json -b 14'

echo '$ echo -n -123.456e-|json -b 1'
echo -n -123.456e-|json -b 1 2>&1 ||
echo 'command failed: echo -n -123.456e-|json -b 1'

echo '$ echo -n -123.456e-|json -b 2'
echo -n -123.456e-|json -b 2 2>&1 ||
echo 'command failed: echo -n -123.456e-|json -b 2'

echo '$ echo -n -123.456e-|json -b 3'
echo -n -123.456e-|json -b 3 2>&1 ||
echo 'command failed: echo -n -123.456e-|json -b 3'

echo '$ echo -n -123.456e-|json -b 4'
echo -n -123.456e-|json -b 4 2>&1 ||
echo 'command failed: echo -n -123.456e-|json -b 4'

echo '$ echo -n -123.456e-|json -b 5'
echo -n -123.456e-|json -b 5 2>&1 ||
echo 'command failed: echo -n -123.456e-|json -b 5'

echo '$ echo -n -123.456e-|json -b 6'
echo -n -123.456e-|json -b 6 2>&1 ||
echo 'command failed: echo -n -123.456e-|json -b 6'

echo '$ echo -n -123.456e-|json -b 7'
echo -n -123.456e-|json -b 7 2>&1 ||
echo 'command failed: echo -n -123.456e-|json -b 7'

echo '$ echo -n -123.456e-|json -b 8'
echo -n -123.456e-|json -b 8 2>&1 ||
echo 'command failed: echo -n -123.456e-|json -b 8'

echo '$ echo -n -123.456e-|json -b 9'
echo -n -123.456e-|json -b 9 2>&1 ||
echo 'command failed: echo -n -123.456e-|json -b 9'

echo '$ echo -n -123.456e-|json -b 10'
echo -n -123.456e-|json -b 10 2>&1 ||
echo 'command failed: echo -n -123.456e-|json -b 10'

echo '$ echo -n -123.456e-|json -b 11'
echo -n -123.456e-|json -b 11 2>&1 ||
echo 'command failed: echo -n -123.456e-|json -b 11'

echo '$ echo -n -123.456e-7|json -b 1'
echo -n -123.456e-7|json -b 1 2>&1 ||
echo 'command failed: echo -n -123.456e-7|json -b 1'

echo '$ echo -n -123.456e-7|json -b 2'
echo -n -123.456e-7|json -b 2 2>&1 ||
echo 'command failed: echo -n -123.456e-7|json -b 2'

echo '$ echo -n -123.456e-7|json -b 3'
echo -n -123.456e-7|json -b 3 2>&1 ||
echo 'command failed: echo -n -123.456e-7|json -b 3'

echo '$ echo -n -123.456e-7|json -b 4'
echo -n -123.456e-7|json -b 4 2>&1 ||
echo 'command failed: echo -n -123.456e-7|json -b 4'

echo '$ echo -n -123.456e-7|json -b 5'
echo -n -123.456e-7|json -b 5 2>&1 ||
echo 'command failed: echo -n -123.456e-7|json -b 5'

echo '$ echo -n -123.456e-7|json -b 6'
echo -n -123.456e-7|json -b 6 2>&1 ||
echo 'command failed: echo -n -123.456e-7|json -b 6'

echo '$ echo -n -123.456e-7|json -b 7'
echo -n -123.456e-7|json -b 7 2>&1 ||
echo 'command failed: echo -n -123.456e-7|json -b 7'

echo '$ echo -n -123.456e-7|json -b 8'
echo -n -123.456e-7|json -b 8 2>&1 ||
echo 'command failed: echo -n -123.456e-7|json -b 8'

echo '$ echo -n -123.456e-7|json -b 9'
echo -n -123.456e-7|json -b 9 2>&1 ||
echo 'command failed: echo -n -123.456e-7|json -b 9'

echo '$ echo -n -123.456e-7|json -b 10'
echo -n -123.456e-7|json -b 10 2>&1 ||
echo 'command failed: echo -n -123.456e-7|json -b 10'

echo '$ echo -n -123.456e-7|json -b 11'
echo -n -123.456e-7|json -b 11 2>&1 ||
echo 'command failed: echo -n -123.456e-7|json -b 11'

echo '$ echo -n -123.456e-7|json -b 12'
echo -n -123.456e-7|json -b 12 2>&1 ||
echo 'command failed: echo -n -123.456e-7|json -b 12'

echo '$ echo -n -123.456e-78|json -b 1'
echo -n -123.456e-78|json -b 1 2>&1 ||
echo 'command failed: echo -n -123.456e-78|json -b 1'

echo '$ echo -n -123.456e-78|json -b 2'
echo -n -123.456e-78|json -b 2 2>&1 ||
echo 'command failed: echo -n -123.456e-78|json -b 2'

echo '$ echo -n -123.456e-78|json -b 3'
echo -n -123.456e-78|json -b 3 2>&1 ||
echo 'command failed: echo -n -123.456e-78|json -b 3'

echo '$ echo -n -123.456e-78|json -b 4'
echo -n -123.456e-78|json -b 4 2>&1 ||
echo 'command failed: echo -n -123.456e-78|json -b 4'

echo '$ echo -n -123.456e-78|json -b 5'
echo -n -123.456e-78|json -b 5 2>&1 ||
echo 'command failed: echo -n -123.456e-78|json -b 5'

echo '$ echo -n -123.456e-78|json -b 6'
echo -n -123.456e-78|json -b 6 2>&1 ||
echo 'command failed: echo -n -123.456e-78|json -b 6'

echo '$ echo -n -123.456e-78|json -b 7'
echo -n -123.456e-78|json -b 7 2>&1 ||
echo 'command failed: echo -n -123.456e-78|json -b 7'

echo '$ echo -n -123.456e-78|json -b 8'
echo -n -123.456e-78|json -b 8 2>&1 ||
echo 'command failed: echo -n -123.456e-78|json -b 8'

echo '$ echo -n -123.456e-78|json -b 9'
echo -n -123.456e-78|json -b 9 2>&1 ||
echo 'command failed: echo -n -123.456e-78|json -b 9'

echo '$ echo -n -123.456e-78|json -b 10'
echo -n -123.456e-78|json -b 10 2>&1 ||
echo 'command failed: echo -n -123.456e-78|json -b 10'

echo '$ echo -n -123.456e-78|json -b 11'
echo -n -123.456e-78|json -b 11 2>&1 ||
echo 'command failed: echo -n -123.456e-78|json -b 11'

echo '$ echo -n -123.456e-78|json -b 12'
echo -n -123.456e-78|json -b 12 2>&1 ||
echo 'command failed: echo -n -123.456e-78|json -b 12'

echo '$ echo -n -123.456e-78|json -b 13'
echo -n -123.456e-78|json -b 13 2>&1 ||
echo 'command failed: echo -n -123.456e-78|json -b 13'

echo '$ echo -n -123.456e-789|json -b 1'
echo -n -123.456e-789|json -b 1 2>&1 ||
echo 'command failed: echo -n -123.456e-789|json -b 1'

echo '$ echo -n -123.456e-789|json -b 2'
echo -n -123.456e-789|json -b 2 2>&1 ||
echo 'command failed: echo -n -123.456e-789|json -b 2'

echo '$ echo -n -123.456e-789|json -b 3'
echo -n -123.456e-789|json -b 3 2>&1 ||
echo 'command failed: echo -n -123.456e-789|json -b 3'

echo '$ echo -n -123.456e-789|json -b 4'
echo -n -123.456e-789|json -b 4 2>&1 ||
echo 'command failed: echo -n -123.456e-789|json -b 4'

echo '$ echo -n -123.456e-789|json -b 5'
echo -n -123.456e-789|json -b 5 2>&1 ||
echo 'command failed: echo -n -123.456e-789|json -b 5'

echo '$ echo -n -123.456e-789|json -b 6'
echo -n -123.456e-789|json -b 6 2>&1 ||
echo 'command failed: echo -n -123.456e-789|json -b 6'

echo '$ echo -n -123.456e-789|json -b 7'
echo -n -123.456e-789|json -b 7 2>&1 ||
echo 'command failed: echo -n -123.456e-789|json -b 7'

echo '$ echo -n -123.456e-789|json -b 8'
echo -n -123.456e-789|json -b 8 2>&1 ||
echo 'command failed: echo -n -123.456e-789|json -b 8'

echo '$ echo -n -123.456e-789|json -b 9'
echo -n -123.456e-789|json -b 9 2>&1 ||
echo 'command failed: echo -n -123.456e-789|json -b 9'

echo '$ echo -n -123.456e-789|json -b 10'
echo -n -123.456e-789|json -b 10 2>&1 ||
echo 'command failed: echo -n -123.456e-789|json -b 10'

echo '$ echo -n -123.456e-789|json -b 11'
echo -n -123.456e-789|json -b 11 2>&1 ||
echo 'command failed: echo -n -123.456e-789|json -b 11'

echo '$ echo -n -123.456e-789|json -b 12'
echo -n -123.456e-789|json -b 12 2>&1 ||
echo 'command failed: echo -n -123.456e-789|json -b 12'

echo '$ echo -n -123.456e-789|json -b 13'
echo -n -123.456e-789|json -b 13 2>&1 ||
echo 'command failed: echo -n -123.456e-789|json -b 13'

echo '$ echo -n -123.456e-789|json -b 14'
echo -n -123.456e-789|json -b 14 2>&1 ||
echo 'command failed: echo -n -123.456e-789|json -b 14'

echo '$ echo -n -123.456e7|json -b 1'
echo -n -123.456e7|json -b 1 2>&1 ||
echo 'command failed: echo -n -123.456e7|json -b 1'

echo '$ echo -n -123.456e7|json -b 2'
echo -n -123.456e7|json -b 2 2>&1 ||
echo 'command failed: echo -n -123.456e7|json -b 2'

echo '$ echo -n -123.456e7|json -b 3'
echo -n -123.456e7|json -b 3 2>&1 ||
echo 'command failed: echo -n -123.456e7|json -b 3'

echo '$ echo -n -123.456e7|json -b 4'
echo -n -123.456e7|json -b 4 2>&1 ||
echo 'command failed: echo -n -123.456e7|json -b 4'

echo '$ echo -n -123.456e7|json -b 5'
echo -n -123.456e7|json -b 5 2>&1 ||
echo 'command failed: echo -n -123.456e7|json -b 5'

echo '$ echo -n -123.456e7|json -b 6'
echo -n -123.456e7|json -b 6 2>&1 ||
echo 'command failed: echo -n -123.456e7|json -b 6'

echo '$ echo -n -123.456e7|json -b 7'
echo -n -123.456e7|json -b 7 2>&1 ||
echo 'command failed: echo -n -123.456e7|json -b 7'

echo '$ echo -n -123.456e7|json -b 8'
echo -n -123.456e7|json -b 8 2>&1 ||
echo 'command failed: echo -n -123.456e7|json -b 8'

echo '$ echo -n -123.456e7|json -b 9'
echo -n -123.456e7|json -b 9 2>&1 ||
echo 'command failed: echo -n -123.456e7|json -b 9'

echo '$ echo -n -123.456e7|json -b 10'
echo -n -123.456e7|json -b 10 2>&1 ||
echo 'command failed: echo -n -123.456e7|json -b 10'

echo '$ echo -n -123.456e7|json -b 11'
echo -n -123.456e7|json -b 11 2>&1 ||
echo 'command failed: echo -n -123.456e7|json -b 11'

echo '$ echo -n -123.456e78|json -b 1'
echo -n -123.456e78|json -b 1 2>&1 ||
echo 'command failed: echo -n -123.456e78|json -b 1'

echo '$ echo -n -123.456e78|json -b 2'
echo -n -123.456e78|json -b 2 2>&1 ||
echo 'command failed: echo -n -123.456e78|json -b 2'

echo '$ echo -n -123.456e78|json -b 3'
echo -n -123.456e78|json -b 3 2>&1 ||
echo 'command failed: echo -n -123.456e78|json -b 3'

echo '$ echo -n -123.456e78|json -b 4'
echo -n -123.456e78|json -b 4 2>&1 ||
echo 'command failed: echo -n -123.456e78|json -b 4'

echo '$ echo -n -123.456e78|json -b 5'
echo -n -123.456e78|json -b 5 2>&1 ||
echo 'command failed: echo -n -123.456e78|json -b 5'

echo '$ echo -n -123.456e78|json -b 6'
echo -n -123.456e78|json -b 6 2>&1 ||
echo 'command failed: echo -n -123.456e78|json -b 6'

echo '$ echo -n -123.456e78|json -b 7'
echo -n -123.456e78|json -b 7 2>&1 ||
echo 'command failed: echo -n -123.456e78|json -b 7'

echo '$ echo -n -123.456e78|json -b 8'
echo -n -123.456e78|json -b 8 2>&1 ||
echo 'command failed: echo -n -123.456e78|json -b 8'

echo '$ echo -n -123.456e78|json -b 9'
echo -n -123.456e78|json -b 9 2>&1 ||
echo 'command failed: echo -n -123.456e78|json -b 9'

echo '$ echo -n -123.456e78|json -b 10'
echo -n -123.456e78|json -b 10 2>&1 ||
echo 'command failed: echo -n -123.456e78|json -b 10'

echo '$ echo -n -123.456e78|json -b 11'
echo -n -123.456e78|json -b 11 2>&1 ||
echo 'command failed: echo -n -123.456e78|json -b 11'

echo '$ echo -n -123.456e78|json -b 12'
echo -n -123.456e78|json -b 12 2>&1 ||
echo 'command failed: echo -n -123.456e78|json -b 12'

echo '$ echo -n -123.456e789|json -b 1'
echo -n -123.456e789|json -b 1 2>&1 ||
echo 'command failed: echo -n -123.456e789|json -b 1'

echo '$ echo -n -123.456e789|json -b 2'
echo -n -123.456e789|json -b 2 2>&1 ||
echo 'command failed: echo -n -123.456e789|json -b 2'

echo '$ echo -n -123.456e789|json -b 3'
echo -n -123.456e789|json -b 3 2>&1 ||
echo 'command failed: echo -n -123.456e789|json -b 3'

echo '$ echo -n -123.456e789|json -b 4'
echo -n -123.456e789|json -b 4 2>&1 ||
echo 'command failed: echo -n -123.456e789|json -b 4'

echo '$ echo -n -123.456e789|json -b 5'
echo -n -123.456e789|json -b 5 2>&1 ||
echo 'command failed: echo -n -123.456e789|json -b 5'

echo '$ echo -n -123.456e789|json -b 6'
echo -n -123.456e789|json -b 6 2>&1 ||
echo 'command failed: echo -n -123.456e789|json -b 6'

echo '$ echo -n -123.456e789|json -b 7'
echo -n -123.456e789|json -b 7 2>&1 ||
echo 'command failed: echo -n -123.456e789|json -b 7'

echo '$ echo -n -123.456e789|json -b 8'
echo -n -123.456e789|json -b 8 2>&1 ||
echo 'command failed: echo -n -123.456e789|json -b 8'

echo '$ echo -n -123.456e789|json -b 9'
echo -n -123.456e789|json -b 9 2>&1 ||
echo 'command failed: echo -n -123.456e789|json -b 9'

echo '$ echo -n -123.456e789|json -b 10'
echo -n -123.456e789|json -b 10 2>&1 ||
echo 'command failed: echo -n -123.456e789|json -b 10'

echo '$ echo -n -123.456e789|json -b 11'
echo -n -123.456e789|json -b 11 2>&1 ||
echo 'command failed: echo -n -123.456e789|json -b 11'

echo '$ echo -n -123.456e789|json -b 12'
echo -n -123.456e789|json -b 12 2>&1 ||
echo 'command failed: echo -n -123.456e789|json -b 12'

echo '$ echo -n -123.456e789|json -b 13'
echo -n -123.456e789|json -b 13 2>&1 ||
echo 'command failed: echo -n -123.456e789|json -b 13'

echo '$ echo -n -123e|json -b 1'
echo -n -123e|json -b 1 2>&1 ||
echo 'command failed: echo -n -123e|json -b 1'

echo '$ echo -n -123e|json -b 2'
echo -n -123e|json -b 2 2>&1 ||
echo 'command failed: echo -n -123e|json -b 2'

echo '$ echo -n -123e|json -b 3'
echo -n -123e|json -b 3 2>&1 ||
echo 'command failed: echo -n -123e|json -b 3'

echo '$ echo -n -123e|json -b 4'
echo -n -123e|json -b 4 2>&1 ||
echo 'command failed: echo -n -123e|json -b 4'

echo '$ echo -n -123e|json -b 5'
echo -n -123e|json -b 5 2>&1 ||
echo 'command failed: echo -n -123e|json -b 5'

echo '$ echo -n -123e|json -b 6'
echo -n -123e|json -b 6 2>&1 ||
echo 'command failed: echo -n -123e|json -b 6'

echo '$ echo -n -123e+|json -b 1'
echo -n -123e+|json -b 1 2>&1 ||
echo 'command failed: echo -n -123e+|json -b 1'

echo '$ echo -n -123e+|json -b 2'
echo -n -123e+|json -b 2 2>&1 ||
echo 'command failed: echo -n -123e+|json -b 2'

echo '$ echo -n -123e+|json -b 3'
echo -n -123e+|json -b 3 2>&1 ||
echo 'command failed: echo -n -123e+|json -b 3'

echo '$ echo -n -123e+|json -b 4'
echo -n -123e+|json -b 4 2>&1 ||
echo 'command failed: echo -n -123e+|json -b 4'

echo '$ echo -n -123e+|json -b 5'
echo -n -123e+|json -b 5 2>&1 ||
echo 'command failed: echo -n -123e+|json -b 5'

echo '$ echo -n -123e+|json -b 6'
echo -n -123e+|json -b 6 2>&1 ||
echo 'command failed: echo -n -123e+|json -b 6'

echo '$ echo -n -123e+|json -b 7'
echo -n -123e+|json -b 7 2>&1 ||
echo 'command failed: echo -n -123e+|json -b 7'

echo '$ echo -n -123e+4|json -b 1'
echo -n -123e+4|json -b 1 2>&1 ||
echo 'command failed: echo -n -123e+4|json -b 1'

echo '$ echo -n -123e+4|json -b 2'
echo -n -123e+4|json -b 2 2>&1 ||
echo 'command failed: echo -n -123e+4|json -b 2'

echo '$ echo -n -123e+4|json -b 3'
echo -n -123e+4|json -b 3 2>&1 ||
echo 'command failed: echo -n -123e+4|json -b 3'

echo '$ echo -n -123e+4|json -b 4'
echo -n -123e+4|json -b 4 2>&1 ||
echo 'command failed: echo -n -123e+4|json -b 4'

echo '$ echo -n -123e+4|json -b 5'
echo -n -123e+4|json -b 5 2>&1 ||
echo 'command failed: echo -n -123e+4|json -b 5'

echo '$ echo -n -123e+4|json -b 6'
echo -n -123e+4|json -b 6 2>&1 ||
echo 'command failed: echo -n -123e+4|json -b 6'

echo '$ echo -n -123e+4|json -b 7'
echo -n -123e+4|json -b 7 2>&1 ||
echo 'command failed: echo -n -123e+4|json -b 7'

echo '$ echo -n -123e+4|json -b 8'
echo -n -123e+4|json -b 8 2>&1 ||
echo 'command failed: echo -n -123e+4|json -b 8'

echo '$ echo -n -123e+45|json -b 1'
echo -n -123e+45|json -b 1 2>&1 ||
echo 'command failed: echo -n -123e+45|json -b 1'

echo '$ echo -n -123e+45|json -b 2'
echo -n -123e+45|json -b 2 2>&1 ||
echo 'command failed: echo -n -123e+45|json -b 2'

echo '$ echo -n -123e+45|json -b 3'
echo -n -123e+45|json -b 3 2>&1 ||
echo 'command failed: echo -n -123e+45|json -b 3'

echo '$ echo -n -123e+45|json -b 4'
echo -n -123e+45|json -b 4 2>&1 ||
echo 'command failed: echo -n -123e+45|json -b 4'

echo '$ echo -n -123e+45|json -b 5'
echo -n -123e+45|json -b 5 2>&1 ||
echo 'command failed: echo -n -123e+45|json -b 5'

echo '$ echo -n -123e+45|json -b 6'
echo -n -123e+45|json -b 6 2>&1 ||
echo 'command failed: echo -n -123e+45|json -b 6'

echo '$ echo -n -123e+45|json -b 7'
echo -n -123e+45|json -b 7 2>&1 ||
echo 'command failed: echo -n -123e+45|json -b 7'

echo '$ echo -n -123e+45|json -b 8'
echo -n -123e+45|json -b 8 2>&1 ||
echo 'command failed: echo -n -123e+45|json -b 8'

echo '$ echo -n -123e+45|json -b 9'
echo -n -123e+45|json -b 9 2>&1 ||
echo 'command failed: echo -n -123e+45|json -b 9'

echo '$ echo -n -123e+456|json -b 1'
echo -n -123e+456|json -b 1 2>&1 ||
echo 'command failed: echo -n -123e+456|json -b 1'

echo '$ echo -n -123e+456|json -b 2'
echo -n -123e+456|json -b 2 2>&1 ||
echo 'command failed: echo -n -123e+456|json -b 2'

echo '$ echo -n -123e+456|json -b 3'
echo -n -123e+456|json -b 3 2>&1 ||
echo 'command failed: echo -n -123e+456|json -b 3'

echo '$ echo -n -123e+456|json -b 4'
echo -n -123e+456|json -b 4 2>&1 ||
echo 'command failed: echo -n -123e+456|json -b 4'

echo '$ echo -n -123e+456|json -b 5'
echo -n -123e+456|json -b 5 2>&1 ||
echo 'command failed: echo -n -123e+456|json -b 5'

echo '$ echo -n -123e+456|json -b 6'
echo -n -123e+456|json -b 6 2>&1 ||
echo 'command failed: echo -n -123e+456|json -b 6'

echo '$ echo -n -123e+456|json -b 7'
echo -n -123e+456|json -b 7 2>&1 ||
echo 'command failed: echo -n -123e+456|json -b 7'

echo '$ echo -n -123e+456|json -b 8'
echo -n -123e+456|json -b 8 2>&1 ||
echo 'command failed: echo -n -123e+456|json -b 8'

echo '$ echo -n -123e+456|json -b 9'
echo -n -123e+456|json -b 9 2>&1 ||
echo 'command failed: echo -n -123e+456|json -b 9'

echo '$ echo -n -123e+456|json -b 10'
echo -n -123e+456|json -b 10 2>&1 ||
echo 'command failed: echo -n -123e+456|json -b 10'

echo '$ echo -n -123e-|json -b 1'
echo -n -123e-|json -b 1 2>&1 ||
echo 'command failed: echo -n -123e-|json -b 1'

echo '$ echo -n -123e-|json -b 2'
echo -n -123e-|json -b 2 2>&1 ||
echo 'command failed: echo -n -123e-|json -b 2'

echo '$ echo -n -123e-|json -b 3'
echo -n -123e-|json -b 3 2>&1 ||
echo 'command failed: echo -n -123e-|json -b 3'

echo '$ echo -n -123e-|json -b 4'
echo -n -123e-|json -b 4 2>&1 ||
echo 'command failed: echo -n -123e-|json -b 4'

echo '$ echo -n -123e-|json -b 5'
echo -n -123e-|json -b 5 2>&1 ||
echo 'command failed: echo -n -123e-|json -b 5'

echo '$ echo -n -123e-|json -b 6'
echo -n -123e-|json -b 6 2>&1 ||
echo 'command failed: echo -n -123e-|json -b 6'

echo '$ echo -n -123e-|json -b 7'
echo -n -123e-|json -b 7 2>&1 ||
echo 'command failed: echo -n -123e-|json -b 7'

echo '$ echo -n -123e-4|json -b 1'
echo -n -123e-4|json -b 1 2>&1 ||
echo 'command failed: echo -n -123e-4|json -b 1'

echo '$ echo -n -123e-4|json -b 2'
echo -n -123e-4|json -b 2 2>&1 ||
echo 'command failed: echo -n -123e-4|json -b 2'

echo '$ echo -n -123e-4|json -b 3'
echo -n -123e-4|json -b 3 2>&1 ||
echo 'command failed: echo -n -123e-4|json -b 3'

echo '$ echo -n -123e-4|json -b 4'
echo -n -123e-4|json -b 4 2>&1 ||
echo 'command failed: echo -n -123e-4|json -b 4'

echo '$ echo -n -123e-4|json -b 5'
echo -n -123e-4|json -b 5 2>&1 ||
echo 'command failed: echo -n -123e-4|json -b 5'

echo '$ echo -n -123e-4|json -b 6'
echo -n -123e-4|json -b 6 2>&1 ||
echo 'command failed: echo -n -123e-4|json -b 6'

echo '$ echo -n -123e-4|json -b 7'
echo -n -123e-4|json -b 7 2>&1 ||
echo 'command failed: echo -n -123e-4|json -b 7'

echo '$ echo -n -123e-4|json -b 8'
echo -n -123e-4|json -b 8 2>&1 ||
echo 'command failed: echo -n -123e-4|json -b 8'

echo '$ echo -n -123e-45|json -b 1'
echo -n -123e-45|json -b 1 2>&1 ||
echo 'command failed: echo -n -123e-45|json -b 1'

echo '$ echo -n -123e-45|json -b 2'
echo -n -123e-45|json -b 2 2>&1 ||
echo 'command failed: echo -n -123e-45|json -b 2'

echo '$ echo -n -123e-45|json -b 3'
echo -n -123e-45|json -b 3 2>&1 ||
echo 'command failed: echo -n -123e-45|json -b 3'

echo '$ echo -n -123e-45|json -b 4'
echo -n -123e-45|json -b 4 2>&1 ||
echo 'command failed: echo -n -123e-45|json -b 4'

echo '$ echo -n -123e-45|json -b 5'
echo -n -123e-45|json -b 5 2>&1 ||
echo 'command failed: echo -n -123e-45|json -b 5'

echo '$ echo -n -123e-45|json -b 6'
echo -n -123e-45|json -b 6 2>&1 ||
echo 'command failed: echo -n -123e-45|json -b 6'

echo '$ echo -n -123e-45|json -b 7'
echo -n -123e-45|json -b 7 2>&1 ||
echo 'command failed: echo -n -123e-45|json -b 7'

echo '$ echo -n -123e-45|json -b 8'
echo -n -123e-45|json -b 8 2>&1 ||
echo 'command failed: echo -n -123e-45|json -b 8'

echo '$ echo -n -123e-45|json -b 9'
echo -n -123e-45|json -b 9 2>&1 ||
echo 'command failed: echo -n -123e-45|json -b 9'

echo '$ echo -n -123e-456|json -b 1'
echo -n -123e-456|json -b 1 2>&1 ||
echo 'command failed: echo -n -123e-456|json -b 1'

echo '$ echo -n -123e-456|json -b 2'
echo -n -123e-456|json -b 2 2>&1 ||
echo 'command failed: echo -n -123e-456|json -b 2'

echo '$ echo -n -123e-456|json -b 3'
echo -n -123e-456|json -b 3 2>&1 ||
echo 'command failed: echo -n -123e-456|json -b 3'

echo '$ echo -n -123e-456|json -b 4'
echo -n -123e-456|json -b 4 2>&1 ||
echo 'command failed: echo -n -123e-456|json -b 4'

echo '$ echo -n -123e-456|json -b 5'
echo -n -123e-456|json -b 5 2>&1 ||
echo 'command failed: echo -n -123e-456|json -b 5'

echo '$ echo -n -123e-456|json -b 6'
echo -n -123e-456|json -b 6 2>&1 ||
echo 'command failed: echo -n -123e-456|json -b 6'

echo '$ echo -n -123e-456|json -b 7'
echo -n -123e-456|json -b 7 2>&1 ||
echo 'command failed: echo -n -123e-456|json -b 7'

echo '$ echo -n -123e-456|json -b 8'
echo -n -123e-456|json -b 8 2>&1 ||
echo 'command failed: echo -n -123e-456|json -b 8'

echo '$ echo -n -123e-456|json -b 9'
echo -n -123e-456|json -b 9 2>&1 ||
echo 'command failed: echo -n -123e-456|json -b 9'

echo '$ echo -n -123e-456|json -b 10'
echo -n -123e-456|json -b 10 2>&1 ||
echo 'command failed: echo -n -123e-456|json -b 10'

echo '$ echo -n -123e4|json -b 1'
echo -n -123e4|json -b 1 2>&1 ||
echo 'command failed: echo -n -123e4|json -b 1'

echo '$ echo -n -123e4|json -b 2'
echo -n -123e4|json -b 2 2>&1 ||
echo 'command failed: echo -n -123e4|json -b 2'

echo '$ echo -n -123e4|json -b 3'
echo -n -123e4|json -b 3 2>&1 ||
echo 'command failed: echo -n -123e4|json -b 3'

echo '$ echo -n -123e4|json -b 4'
echo -n -123e4|json -b 4 2>&1 ||
echo 'command failed: echo -n -123e4|json -b 4'

echo '$ echo -n -123e4|json -b 5'
echo -n -123e4|json -b 5 2>&1 ||
echo 'command failed: echo -n -123e4|json -b 5'

echo '$ echo -n -123e4|json -b 6'
echo -n -123e4|json -b 6 2>&1 ||
echo 'command failed: echo -n -123e4|json -b 6'

echo '$ echo -n -123e4|json -b 7'
echo -n -123e4|json -b 7 2>&1 ||
echo 'command failed: echo -n -123e4|json -b 7'

echo '$ echo -n -123e45|json -b 1'
echo -n -123e45|json -b 1 2>&1 ||
echo 'command failed: echo -n -123e45|json -b 1'

echo '$ echo -n -123e45|json -b 2'
echo -n -123e45|json -b 2 2>&1 ||
echo 'command failed: echo -n -123e45|json -b 2'

echo '$ echo -n -123e45|json -b 3'
echo -n -123e45|json -b 3 2>&1 ||
echo 'command failed: echo -n -123e45|json -b 3'

echo '$ echo -n -123e45|json -b 4'
echo -n -123e45|json -b 4 2>&1 ||
echo 'command failed: echo -n -123e45|json -b 4'

echo '$ echo -n -123e45|json -b 5'
echo -n -123e45|json -b 5 2>&1 ||
echo 'command failed: echo -n -123e45|json -b 5'

echo '$ echo -n -123e45|json -b 6'
echo -n -123e45|json -b 6 2>&1 ||
echo 'command failed: echo -n -123e45|json -b 6'

echo '$ echo -n -123e45|json -b 7'
echo -n -123e45|json -b 7 2>&1 ||
echo 'command failed: echo -n -123e45|json -b 7'

echo '$ echo -n -123e45|json -b 8'
echo -n -123e45|json -b 8 2>&1 ||
echo 'command failed: echo -n -123e45|json -b 8'

echo '$ echo -n -123e456|json -b 1'
echo -n -123e456|json -b 1 2>&1 ||
echo 'command failed: echo -n -123e456|json -b 1'

echo '$ echo -n -123e456|json -b 2'
echo -n -123e456|json -b 2 2>&1 ||
echo 'command failed: echo -n -123e456|json -b 2'

echo '$ echo -n -123e456|json -b 3'
echo -n -123e456|json -b 3 2>&1 ||
echo 'command failed: echo -n -123e456|json -b 3'

echo '$ echo -n -123e456|json -b 4'
echo -n -123e456|json -b 4 2>&1 ||
echo 'command failed: echo -n -123e456|json -b 4'

echo '$ echo -n -123e456|json -b 5'
echo -n -123e456|json -b 5 2>&1 ||
echo 'command failed: echo -n -123e456|json -b 5'

echo '$ echo -n -123e456|json -b 6'
echo -n -123e456|json -b 6 2>&1 ||
echo 'command failed: echo -n -123e456|json -b 6'

echo '$ echo -n -123e456|json -b 7'
echo -n -123e456|json -b 7 2>&1 ||
echo 'command failed: echo -n -123e456|json -b 7'

echo '$ echo -n -123e456|json -b 8'
echo -n -123e456|json -b 8 2>&1 ||
echo 'command failed: echo -n -123e456|json -b 8'

echo '$ echo -n -123e456|json -b 9'
echo -n -123e456|json -b 9 2>&1 ||
echo 'command failed: echo -n -123e456|json -b 9'

echo '$ echo -n 1|json -b 1'
echo -n 1|json -b 1 2>&1 ||
echo 'command failed: echo -n 1|json -b 1'

echo '$ echo -n 1|json -b 2'
echo -n 1|json -b 2 2>&1 ||
echo 'command failed: echo -n 1|json -b 2'

echo '$ echo -n 12|json -b 1'
echo -n 12|json -b 1 2>&1 ||
echo 'command failed: echo -n 12|json -b 1'

echo '$ echo -n 12|json -b 2'
echo -n 12|json -b 2 2>&1 ||
echo 'command failed: echo -n 12|json -b 2'

echo '$ echo -n 12|json -b 3'
echo -n 12|json -b 3 2>&1 ||
echo 'command failed: echo -n 12|json -b 3'

echo '$ echo -n 123|json -b 1'
echo -n 123|json -b 1 2>&1 ||
echo 'command failed: echo -n 123|json -b 1'

echo '$ echo -n 123|json -b 2'
echo -n 123|json -b 2 2>&1 ||
echo 'command failed: echo -n 123|json -b 2'

echo '$ echo -n 123|json -b 3'
echo -n 123|json -b 3 2>&1 ||
echo 'command failed: echo -n 123|json -b 3'

echo '$ echo -n 123|json -b 4'
echo -n 123|json -b 4 2>&1 ||
echo 'command failed: echo -n 123|json -b 4'

echo '$ echo -n 123.|json -b 1'
echo -n 123.|json -b 1 2>&1 ||
echo 'command failed: echo -n 123.|json -b 1'

echo '$ echo -n 123.|json -b 2'
echo -n 123.|json -b 2 2>&1 ||
echo 'command failed: echo -n 123.|json -b 2'

echo '$ echo -n 123.|json -b 3'
echo -n 123.|json -b 3 2>&1 ||
echo 'command failed: echo -n 123.|json -b 3'

echo '$ echo -n 123.|json -b 4'
echo -n 123.|json -b 4 2>&1 ||
echo 'command failed: echo -n 123.|json -b 4'

echo '$ echo -n 123.|json -b 5'
echo -n 123.|json -b 5 2>&1 ||
echo 'command failed: echo -n 123.|json -b 5'

echo '$ echo -n 123.4|json -b 1'
echo -n 123.4|json -b 1 2>&1 ||
echo 'command failed: echo -n 123.4|json -b 1'

echo '$ echo -n 123.4|json -b 2'
echo -n 123.4|json -b 2 2>&1 ||
echo 'command failed: echo -n 123.4|json -b 2'

echo '$ echo -n 123.4|json -b 3'
echo -n 123.4|json -b 3 2>&1 ||
echo 'command failed: echo -n 123.4|json -b 3'

echo '$ echo -n 123.4|json -b 4'
echo -n 123.4|json -b 4 2>&1 ||
echo 'command failed: echo -n 123.4|json -b 4'

echo '$ echo -n 123.4|json -b 5'
echo -n 123.4|json -b 5 2>&1 ||
echo 'command failed: echo -n 123.4|json -b 5'

echo '$ echo -n 123.4|json -b 6'
echo -n 123.4|json -b 6 2>&1 ||
echo 'command failed: echo -n 123.4|json -b 6'

echo '$ echo -n 123.45|json -b 1'
echo -n 123.45|json -b 1 2>&1 ||
echo 'command failed: echo -n 123.45|json -b 1'

echo '$ echo -n 123.45|json -b 2'
echo -n 123.45|json -b 2 2>&1 ||
echo 'command failed: echo -n 123.45|json -b 2'

echo '$ echo -n 123.45|json -b 3'
echo -n 123.45|json -b 3 2>&1 ||
echo 'command failed: echo -n 123.45|json -b 3'

echo '$ echo -n 123.45|json -b 4'
echo -n 123.45|json -b 4 2>&1 ||
echo 'command failed: echo -n 123.45|json -b 4'

echo '$ echo -n 123.45|json -b 5'
echo -n 123.45|json -b 5 2>&1 ||
echo 'command failed: echo -n 123.45|json -b 5'

echo '$ echo -n 123.45|json -b 6'
echo -n 123.45|json -b 6 2>&1 ||
echo 'command failed: echo -n 123.45|json -b 6'

echo '$ echo -n 123.45|json -b 7'
echo -n 123.45|json -b 7 2>&1 ||
echo 'command failed: echo -n 123.45|json -b 7'

echo '$ echo -n 123.456|json -b 1'
echo -n 123.456|json -b 1 2>&1 ||
echo 'command failed: echo -n 123.456|json -b 1'

echo '$ echo -n 123.456|json -b 2'
echo -n 123.456|json -b 2 2>&1 ||
echo 'command failed: echo -n 123.456|json -b 2'

echo '$ echo -n 123.456|json -b 3'
echo -n 123.456|json -b 3 2>&1 ||
echo 'command failed: echo -n 123.456|json -b 3'

echo '$ echo -n 123.456|json -b 4'
echo -n 123.456|json -b 4 2>&1 ||
echo 'command failed: echo -n 123.456|json -b 4'

echo '$ echo -n 123.456|json -b 5'
echo -n 123.456|json -b 5 2>&1 ||
echo 'command failed: echo -n 123.456|json -b 5'

echo '$ echo -n 123.456|json -b 6'
echo -n 123.456|json -b 6 2>&1 ||
echo 'command failed: echo -n 123.456|json -b 6'

echo '$ echo -n 123.456|json -b 7'
echo -n 123.456|json -b 7 2>&1 ||
echo 'command failed: echo -n 123.456|json -b 7'

echo '$ echo -n 123.456|json -b 8'
echo -n 123.456|json -b 8 2>&1 ||
echo 'command failed: echo -n 123.456|json -b 8'

echo '$ echo -n 123.456e|json -b 1'
echo -n 123.456e|json -b 1 2>&1 ||
echo 'command failed: echo -n 123.456e|json -b 1'

echo '$ echo -n 123.456e|json -b 2'
echo -n 123.456e|json -b 2 2>&1 ||
echo 'command failed: echo -n 123.456e|json -b 2'

echo '$ echo -n 123.456e|json -b 3'
echo -n 123.456e|json -b 3 2>&1 ||
echo 'command failed: echo -n 123.456e|json -b 3'

echo '$ echo -n 123.456e|json -b 4'
echo -n 123.456e|json -b 4 2>&1 ||
echo 'command failed: echo -n 123.456e|json -b 4'

echo '$ echo -n 123.456e|json -b 5'
echo -n 123.456e|json -b 5 2>&1 ||
echo 'command failed: echo -n 123.456e|json -b 5'

echo '$ echo -n 123.456e|json -b 6'
echo -n 123.456e|json -b 6 2>&1 ||
echo 'command failed: echo -n 123.456e|json -b 6'

echo '$ echo -n 123.456e|json -b 7'
echo -n 123.456e|json -b 7 2>&1 ||
echo 'command failed: echo -n 123.456e|json -b 7'

echo '$ echo -n 123.456e|json -b 8'
echo -n 123.456e|json -b 8 2>&1 ||
echo 'command failed: echo -n 123.456e|json -b 8'

echo '$ echo -n 123.456e|json -b 9'
echo -n 123.456e|json -b 9 2>&1 ||
echo 'command failed: echo -n 123.456e|json -b 9'

echo '$ echo -n 123.456e+|json -b 1'
echo -n 123.456e+|json -b 1 2>&1 ||
echo 'command failed: echo -n 123.456e+|json -b 1'

echo '$ echo -n 123.456e+|json -b 2'
echo -n 123.456e+|json -b 2 2>&1 ||
echo 'command failed: echo -n 123.456e+|json -b 2'

echo '$ echo -n 123.456e+|json -b 3'
echo -n 123.456e+|json -b 3 2>&1 ||
echo 'command failed: echo -n 123.456e+|json -b 3'

echo '$ echo -n 123.456e+|json -b 4'
echo -n 123.456e+|json -b 4 2>&1 ||
echo 'command failed: echo -n 123.456e+|json -b 4'

echo '$ echo -n 123.456e+|json -b 5'
echo -n 123.456e+|json -b 5 2>&1 ||
echo 'command failed: echo -n 123.456e+|json -b 5'

echo '$ echo -n 123.456e+|json -b 6'
echo -n 123.456e+|json -b 6 2>&1 ||
echo 'command failed: echo -n 123.456e+|json -b 6'

echo '$ echo -n 123.456e+|json -b 7'
echo -n 123.456e+|json -b 7 2>&1 ||
echo 'command failed: echo -n 123.456e+|json -b 7'

echo '$ echo -n 123.456e+|json -b 8'
echo -n 123.456e+|json -b 8 2>&1 ||
echo 'command failed: echo -n 123.456e+|json -b 8'

echo '$ echo -n 123.456e+|json -b 9'
echo -n 123.456e+|json -b 9 2>&1 ||
echo 'command failed: echo -n 123.456e+|json -b 9'

echo '$ echo -n 123.456e+|json -b 10'
echo -n 123.456e+|json -b 10 2>&1 ||
echo 'command failed: echo -n 123.456e+|json -b 10'

echo '$ echo -n 123.456e+7|json -b 1'
echo -n 123.456e+7|json -b 1 2>&1 ||
echo 'command failed: echo -n 123.456e+7|json -b 1'

echo '$ echo -n 123.456e+7|json -b 2'
echo -n 123.456e+7|json -b 2 2>&1 ||
echo 'command failed: echo -n 123.456e+7|json -b 2'

echo '$ echo -n 123.456e+7|json -b 3'
echo -n 123.456e+7|json -b 3 2>&1 ||
echo 'command failed: echo -n 123.456e+7|json -b 3'

echo '$ echo -n 123.456e+7|json -b 4'
echo -n 123.456e+7|json -b 4 2>&1 ||
echo 'command failed: echo -n 123.456e+7|json -b 4'

echo '$ echo -n 123.456e+7|json -b 5'
echo -n 123.456e+7|json -b 5 2>&1 ||
echo 'command failed: echo -n 123.456e+7|json -b 5'

echo '$ echo -n 123.456e+7|json -b 6'
echo -n 123.456e+7|json -b 6 2>&1 ||
echo 'command failed: echo -n 123.456e+7|json -b 6'

echo '$ echo -n 123.456e+7|json -b 7'
echo -n 123.456e+7|json -b 7 2>&1 ||
echo 'command failed: echo -n 123.456e+7|json -b 7'

echo '$ echo -n 123.456e+7|json -b 8'
echo -n 123.456e+7|json -b 8 2>&1 ||
echo 'command failed: echo -n 123.456e+7|json -b 8'

echo '$ echo -n 123.456e+7|json -b 9'
echo -n 123.456e+7|json -b 9 2>&1 ||
echo 'command failed: echo -n 123.456e+7|json -b 9'

echo '$ echo -n 123.456e+7|json -b 10'
echo -n 123.456e+7|json -b 10 2>&1 ||
echo 'command failed: echo -n 123.456e+7|json -b 10'

echo '$ echo -n 123.456e+7|json -b 11'
echo -n 123.456e+7|json -b 11 2>&1 ||
echo 'command failed: echo -n 123.456e+7|json -b 11'

echo '$ echo -n 123.456e+78|json -b 1'
echo -n 123.456e+78|json -b 1 2>&1 ||
echo 'command failed: echo -n 123.456e+78|json -b 1'

echo '$ echo -n 123.456e+78|json -b 2'
echo -n 123.456e+78|json -b 2 2>&1 ||
echo 'command failed: echo -n 123.456e+78|json -b 2'

echo '$ echo -n 123.456e+78|json -b 3'
echo -n 123.456e+78|json -b 3 2>&1 ||
echo 'command failed: echo -n 123.456e+78|json -b 3'

echo '$ echo -n 123.456e+78|json -b 4'
echo -n 123.456e+78|json -b 4 2>&1 ||
echo 'command failed: echo -n 123.456e+78|json -b 4'

echo '$ echo -n 123.456e+78|json -b 5'
echo -n 123.456e+78|json -b 5 2>&1 ||
echo 'command failed: echo -n 123.456e+78|json -b 5'

echo '$ echo -n 123.456e+78|json -b 6'
echo -n 123.456e+78|json -b 6 2>&1 ||
echo 'command failed: echo -n 123.456e+78|json -b 6'

echo '$ echo -n 123.456e+78|json -b 7'
echo -n 123.456e+78|json -b 7 2>&1 ||
echo 'command failed: echo -n 123.456e+78|json -b 7'

echo '$ echo -n 123.456e+78|json -b 8'
echo -n 123.456e+78|json -b 8 2>&1 ||
echo 'command failed: echo -n 123.456e+78|json -b 8'

echo '$ echo -n 123.456e+78|json -b 9'
echo -n 123.456e+78|json -b 9 2>&1 ||
echo 'command failed: echo -n 123.456e+78|json -b 9'

echo '$ echo -n 123.456e+78|json -b 10'
echo -n 123.456e+78|json -b 10 2>&1 ||
echo 'command failed: echo -n 123.456e+78|json -b 10'

echo '$ echo -n 123.456e+78|json -b 11'
echo -n 123.456e+78|json -b 11 2>&1 ||
echo 'command failed: echo -n 123.456e+78|json -b 11'

echo '$ echo -n 123.456e+78|json -b 12'
echo -n 123.456e+78|json -b 12 2>&1 ||
echo 'command failed: echo -n 123.456e+78|json -b 12'

echo '$ echo -n 123.456e+789|json -b 1'
echo -n 123.456e+789|json -b 1 2>&1 ||
echo 'command failed: echo -n 123.456e+789|json -b 1'

echo '$ echo -n 123.456e+789|json -b 2'
echo -n 123.456e+789|json -b 2 2>&1 ||
echo 'command failed: echo -n 123.456e+789|json -b 2'

echo '$ echo -n 123.456e+789|json -b 3'
echo -n 123.456e+789|json -b 3 2>&1 ||
echo 'command failed: echo -n 123.456e+789|json -b 3'

echo '$ echo -n 123.456e+789|json -b 4'
echo -n 123.456e+789|json -b 4 2>&1 ||
echo 'command failed: echo -n 123.456e+789|json -b 4'

echo '$ echo -n 123.456e+789|json -b 5'
echo -n 123.456e+789|json -b 5 2>&1 ||
echo 'command failed: echo -n 123.456e+789|json -b 5'

echo '$ echo -n 123.456e+789|json -b 6'
echo -n 123.456e+789|json -b 6 2>&1 ||
echo 'command failed: echo -n 123.456e+789|json -b 6'

echo '$ echo -n 123.456e+789|json -b 7'
echo -n 123.456e+789|json -b 7 2>&1 ||
echo 'command failed: echo -n 123.456e+789|json -b 7'

echo '$ echo -n 123.456e+789|json -b 8'
echo -n 123.456e+789|json -b 8 2>&1 ||
echo 'command failed: echo -n 123.456e+789|json -b 8'

echo '$ echo -n 123.456e+789|json -b 9'
echo -n 123.456e+789|json -b 9 2>&1 ||
echo 'command failed: echo -n 123.456e+789|json -b 9'

echo '$ echo -n 123.456e+789|json -b 10'
echo -n 123.456e+789|json -b 10 2>&1 ||
echo 'command failed: echo -n 123.456e+789|json -b 10'

echo '$ echo -n 123.456e+789|json -b 11'
echo -n 123.456e+789|json -b 11 2>&1 ||
echo 'command failed: echo -n 123.456e+789|json -b 11'

echo '$ echo -n 123.456e+789|json -b 12'
echo -n 123.456e+789|json -b 12 2>&1 ||
echo 'command failed: echo -n 123.456e+789|json -b 12'

echo '$ echo -n 123.456e+789|json -b 13'
echo -n 123.456e+789|json -b 13 2>&1 ||
echo 'command failed: echo -n 123.456e+789|json -b 13'

echo '$ echo -n 123.456e-|json -b 1'
echo -n 123.456e-|json -b 1 2>&1 ||
echo 'command failed: echo -n 123.456e-|json -b 1'

echo '$ echo -n 123.456e-|json -b 2'
echo -n 123.456e-|json -b 2 2>&1 ||
echo 'command failed: echo -n 123.456e-|json -b 2'

echo '$ echo -n 123.456e-|json -b 3'
echo -n 123.456e-|json -b 3 2>&1 ||
echo 'command failed: echo -n 123.456e-|json -b 3'

echo '$ echo -n 123.456e-|json -b 4'
echo -n 123.456e-|json -b 4 2>&1 ||
echo 'command failed: echo -n 123.456e-|json -b 4'

echo '$ echo -n 123.456e-|json -b 5'
echo -n 123.456e-|json -b 5 2>&1 ||
echo 'command failed: echo -n 123.456e-|json -b 5'

echo '$ echo -n 123.456e-|json -b 6'
echo -n 123.456e-|json -b 6 2>&1 ||
echo 'command failed: echo -n 123.456e-|json -b 6'

echo '$ echo -n 123.456e-|json -b 7'
echo -n 123.456e-|json -b 7 2>&1 ||
echo 'command failed: echo -n 123.456e-|json -b 7'

echo '$ echo -n 123.456e-|json -b 8'
echo -n 123.456e-|json -b 8 2>&1 ||
echo 'command failed: echo -n 123.456e-|json -b 8'

echo '$ echo -n 123.456e-|json -b 9'
echo -n 123.456e-|json -b 9 2>&1 ||
echo 'command failed: echo -n 123.456e-|json -b 9'

echo '$ echo -n 123.456e-|json -b 10'
echo -n 123.456e-|json -b 10 2>&1 ||
echo 'command failed: echo -n 123.456e-|json -b 10'

echo '$ echo -n 123.456e-7|json -b 1'
echo -n 123.456e-7|json -b 1 2>&1 ||
echo 'command failed: echo -n 123.456e-7|json -b 1'

echo '$ echo -n 123.456e-7|json -b 2'
echo -n 123.456e-7|json -b 2 2>&1 ||
echo 'command failed: echo -n 123.456e-7|json -b 2'

echo '$ echo -n 123.456e-7|json -b 3'
echo -n 123.456e-7|json -b 3 2>&1 ||
echo 'command failed: echo -n 123.456e-7|json -b 3'

echo '$ echo -n 123.456e-7|json -b 4'
echo -n 123.456e-7|json -b 4 2>&1 ||
echo 'command failed: echo -n 123.456e-7|json -b 4'

echo '$ echo -n 123.456e-7|json -b 5'
echo -n 123.456e-7|json -b 5 2>&1 ||
echo 'command failed: echo -n 123.456e-7|json -b 5'

echo '$ echo -n 123.456e-7|json -b 6'
echo -n 123.456e-7|json -b 6 2>&1 ||
echo 'command failed: echo -n 123.456e-7|json -b 6'

echo '$ echo -n 123.456e-7|json -b 7'
echo -n 123.456e-7|json -b 7 2>&1 ||
echo 'command failed: echo -n 123.456e-7|json -b 7'

echo '$ echo -n 123.456e-7|json -b 8'
echo -n 123.456e-7|json -b 8 2>&1 ||
echo 'command failed: echo -n 123.456e-7|json -b 8'

echo '$ echo -n 123.456e-7|json -b 9'
echo -n 123.456e-7|json -b 9 2>&1 ||
echo 'command failed: echo -n 123.456e-7|json -b 9'

echo '$ echo -n 123.456e-7|json -b 10'
echo -n 123.456e-7|json -b 10 2>&1 ||
echo 'command failed: echo -n 123.456e-7|json -b 10'

echo '$ echo -n 123.456e-7|json -b 11'
echo -n 123.456e-7|json -b 11 2>&1 ||
echo 'command failed: echo -n 123.456e-7|json -b 11'

echo '$ echo -n 123.456e-78|json -b 1'
echo -n 123.456e-78|json -b 1 2>&1 ||
echo 'command failed: echo -n 123.456e-78|json -b 1'

echo '$ echo -n 123.456e-78|json -b 2'
echo -n 123.456e-78|json -b 2 2>&1 ||
echo 'command failed: echo -n 123.456e-78|json -b 2'

echo '$ echo -n 123.456e-78|json -b 3'
echo -n 123.456e-78|json -b 3 2>&1 ||
echo 'command failed: echo -n 123.456e-78|json -b 3'

echo '$ echo -n 123.456e-78|json -b 4'
echo -n 123.456e-78|json -b 4 2>&1 ||
echo 'command failed: echo -n 123.456e-78|json -b 4'

echo '$ echo -n 123.456e-78|json -b 5'
echo -n 123.456e-78|json -b 5 2>&1 ||
echo 'command failed: echo -n 123.456e-78|json -b 5'

echo '$ echo -n 123.456e-78|json -b 6'
echo -n 123.456e-78|json -b 6 2>&1 ||
echo 'command failed: echo -n 123.456e-78|json -b 6'

echo '$ echo -n 123.456e-78|json -b 7'
echo -n 123.456e-78|json -b 7 2>&1 ||
echo 'command failed: echo -n 123.456e-78|json -b 7'

echo '$ echo -n 123.456e-78|json -b 8'
echo -n 123.456e-78|json -b 8 2>&1 ||
echo 'command failed: echo -n 123.456e-78|json -b 8'

echo '$ echo -n 123.456e-78|json -b 9'
echo -n 123.456e-78|json -b 9 2>&1 ||
echo 'command failed: echo -n 123.456e-78|json -b 9'

echo '$ echo -n 123.456e-78|json -b 10'
echo -n 123.456e-78|json -b 10 2>&1 ||
echo 'command failed: echo -n 123.456e-78|json -b 10'

echo '$ echo -n 123.456e-78|json -b 11'
echo -n 123.456e-78|json -b 11 2>&1 ||
echo 'command failed: echo -n 123.456e-78|json -b 11'

echo '$ echo -n 123.456e-78|json -b 12'
echo -n 123.456e-78|json -b 12 2>&1 ||
echo 'command failed: echo -n 123.456e-78|json -b 12'

echo '$ echo -n 123.456e-789|json -b 1'
echo -n 123.456e-789|json -b 1 2>&1 ||
echo 'command failed: echo -n 123.456e-789|json -b 1'

echo '$ echo -n 123.456e-789|json -b 2'
echo -n 123.456e-789|json -b 2 2>&1 ||
echo 'command failed: echo -n 123.456e-789|json -b 2'

echo '$ echo -n 123.456e-789|json -b 3'
echo -n 123.456e-789|json -b 3 2>&1 ||
echo 'command failed: echo -n 123.456e-789|json -b 3'

echo '$ echo -n 123.456e-789|json -b 4'
echo -n 123.456e-789|json -b 4 2>&1 ||
echo 'command failed: echo -n 123.456e-789|json -b 4'

echo '$ echo -n 123.456e-789|json -b 5'
echo -n 123.456e-789|json -b 5 2>&1 ||
echo 'command failed: echo -n 123.456e-789|json -b 5'

echo '$ echo -n 123.456e-789|json -b 6'
echo -n 123.456e-789|json -b 6 2>&1 ||
echo 'command failed: echo -n 123.456e-789|json -b 6'

echo '$ echo -n 123.456e-789|json -b 7'
echo -n 123.456e-789|json -b 7 2>&1 ||
echo 'command failed: echo -n 123.456e-789|json -b 7'

echo '$ echo -n 123.456e-789|json -b 8'
echo -n 123.456e-789|json -b 8 2>&1 ||
echo 'command failed: echo -n 123.456e-789|json -b 8'

echo '$ echo -n 123.456e-789|json -b 9'
echo -n 123.456e-789|json -b 9 2>&1 ||
echo 'command failed: echo -n 123.456e-789|json -b 9'

echo '$ echo -n 123.456e-789|json -b 10'
echo -n 123.456e-789|json -b 10 2>&1 ||
echo 'command failed: echo -n 123.456e-789|json -b 10'

echo '$ echo -n 123.456e-789|json -b 11'
echo -n 123.456e-789|json -b 11 2>&1 ||
echo 'command failed: echo -n 123.456e-789|json -b 11'

echo '$ echo -n 123.456e-789|json -b 12'
echo -n 123.456e-789|json -b 12 2>&1 ||
echo 'command failed: echo -n 123.456e-789|json -b 12'

echo '$ echo -n 123.456e-789|json -b 13'
echo -n 123.456e-789|json -b 13 2>&1 ||
echo 'command failed: echo -n 123.456e-789|json -b 13'

echo '$ echo -n 123.456e7|json -b 1'
echo -n 123.456e7|json -b 1 2>&1 ||
echo 'command failed: echo -n 123.456e7|json -b 1'

echo '$ echo -n 123.456e7|json -b 2'
echo -n 123.456e7|json -b 2 2>&1 ||
echo 'command failed: echo -n 123.456e7|json -b 2'

echo '$ echo -n 123.456e7|json -b 3'
echo -n 123.456e7|json -b 3 2>&1 ||
echo 'command failed: echo -n 123.456e7|json -b 3'

echo '$ echo -n 123.456e7|json -b 4'
echo -n 123.456e7|json -b 4 2>&1 ||
echo 'command failed: echo -n 123.456e7|json -b 4'

echo '$ echo -n 123.456e7|json -b 5'
echo -n 123.456e7|json -b 5 2>&1 ||
echo 'command failed: echo -n 123.456e7|json -b 5'

echo '$ echo -n 123.456e7|json -b 6'
echo -n 123.456e7|json -b 6 2>&1 ||
echo 'command failed: echo -n 123.456e7|json -b 6'

echo '$ echo -n 123.456e7|json -b 7'
echo -n 123.456e7|json -b 7 2>&1 ||
echo 'command failed: echo -n 123.456e7|json -b 7'

echo '$ echo -n 123.456e7|json -b 8'
echo -n 123.456e7|json -b 8 2>&1 ||
echo 'command failed: echo -n 123.456e7|json -b 8'

echo '$ echo -n 123.456e7|json -b 9'
echo -n 123.456e7|json -b 9 2>&1 ||
echo 'command failed: echo -n 123.456e7|json -b 9'

echo '$ echo -n 123.456e7|json -b 10'
echo -n 123.456e7|json -b 10 2>&1 ||
echo 'command failed: echo -n 123.456e7|json -b 10'

echo '$ echo -n 123.456e78|json -b 1'
echo -n 123.456e78|json -b 1 2>&1 ||
echo 'command failed: echo -n 123.456e78|json -b 1'

echo '$ echo -n 123.456e78|json -b 2'
echo -n 123.456e78|json -b 2 2>&1 ||
echo 'command failed: echo -n 123.456e78|json -b 2'

echo '$ echo -n 123.456e78|json -b 3'
echo -n 123.456e78|json -b 3 2>&1 ||
echo 'command failed: echo -n 123.456e78|json -b 3'

echo '$ echo -n 123.456e78|json -b 4'
echo -n 123.456e78|json -b 4 2>&1 ||
echo 'command failed: echo -n 123.456e78|json -b 4'

echo '$ echo -n 123.456e78|json -b 5'
echo -n 123.456e78|json -b 5 2>&1 ||
echo 'command failed: echo -n 123.456e78|json -b 5'

echo '$ echo -n 123.456e78|json -b 6'
echo -n 123.456e78|json -b 6 2>&1 ||
echo 'command failed: echo -n 123.456e78|json -b 6'

echo '$ echo -n 123.456e78|json -b 7'
echo -n 123.456e78|json -b 7 2>&1 ||
echo 'command failed: echo -n 123.456e78|json -b 7'

echo '$ echo -n 123.456e78|json -b 8'
echo -n 123.456e78|json -b 8 2>&1 ||
echo 'command failed: echo -n 123.456e78|json -b 8'

echo '$ echo -n 123.456e78|json -b 9'
echo -n 123.456e78|json -b 9 2>&1 ||
echo 'command failed: echo -n 123.456e78|json -b 9'

echo '$ echo -n 123.456e78|json -b 10'
echo -n 123.456e78|json -b 10 2>&1 ||
echo 'command failed: echo -n 123.456e78|json -b 10'

echo '$ echo -n 123.456e78|json -b 11'
echo -n 123.456e78|json -b 11 2>&1 ||
echo 'command failed: echo -n 123.456e78|json -b 11'

echo '$ echo -n 123.456e789|json -b 1'
echo -n 123.456e789|json -b 1 2>&1 ||
echo 'command failed: echo -n 123.456e789|json -b 1'

echo '$ echo -n 123.456e789|json -b 2'
echo -n 123.456e789|json -b 2 2>&1 ||
echo 'command failed: echo -n 123.456e789|json -b 2'

echo '$ echo -n 123.456e789|json -b 3'
echo -n 123.456e789|json -b 3 2>&1 ||
echo 'command failed: echo -n 123.456e789|json -b 3'

echo '$ echo -n 123.456e789|json -b 4'
echo -n 123.456e789|json -b 4 2>&1 ||
echo 'command failed: echo -n 123.456e789|json -b 4'

echo '$ echo -n 123.456e789|json -b 5'
echo -n 123.456e789|json -b 5 2>&1 ||
echo 'command failed: echo -n 123.456e789|json -b 5'

echo '$ echo -n 123.456e789|json -b 6'
echo -n 123.456e789|json -b 6 2>&1 ||
echo 'command failed: echo -n 123.456e789|json -b 6'

echo '$ echo -n 123.456e789|json -b 7'
echo -n 123.456e789|json -b 7 2>&1 ||
echo 'command failed: echo -n 123.456e789|json -b 7'

echo '$ echo -n 123.456e789|json -b 8'
echo -n 123.456e789|json -b 8 2>&1 ||
echo 'command failed: echo -n 123.456e789|json -b 8'

echo '$ echo -n 123.456e789|json -b 9'
echo -n 123.456e789|json -b 9 2>&1 ||
echo 'command failed: echo -n 123.456e789|json -b 9'

echo '$ echo -n 123.456e789|json -b 10'
echo -n 123.456e789|json -b 10 2>&1 ||
echo 'command failed: echo -n 123.456e789|json -b 10'

echo '$ echo -n 123.456e789|json -b 11'
echo -n 123.456e789|json -b 11 2>&1 ||
echo 'command failed: echo -n 123.456e789|json -b 11'

echo '$ echo -n 123.456e789|json -b 12'
echo -n 123.456e789|json -b 12 2>&1 ||
echo 'command failed: echo -n 123.456e789|json -b 12'

echo '$ echo -n 123e|json -b 1'
echo -n 123e|json -b 1 2>&1 ||
echo 'command failed: echo -n 123e|json -b 1'

echo '$ echo -n 123e|json -b 2'
echo -n 123e|json -b 2 2>&1 ||
echo 'command failed: echo -n 123e|json -b 2'

echo '$ echo -n 123e|json -b 3'
echo -n 123e|json -b 3 2>&1 ||
echo 'command failed: echo -n 123e|json -b 3'

echo '$ echo -n 123e|json -b 4'
echo -n 123e|json -b 4 2>&1 ||
echo 'command failed: echo -n 123e|json -b 4'

echo '$ echo -n 123e|json -b 5'
echo -n 123e|json -b 5 2>&1 ||
echo 'command failed: echo -n 123e|json -b 5'

echo '$ echo -n 123e+|json -b 1'
echo -n 123e+|json -b 1 2>&1 ||
echo 'command failed: echo -n 123e+|json -b 1'

echo '$ echo -n 123e+|json -b 2'
echo -n 123e+|json -b 2 2>&1 ||
echo 'command failed: echo -n 123e+|json -b 2'

echo '$ echo -n 123e+|json -b 3'
echo -n 123e+|json -b 3 2>&1 ||
echo 'command failed: echo -n 123e+|json -b 3'

echo '$ echo -n 123e+|json -b 4'
echo -n 123e+|json -b 4 2>&1 ||
echo 'command failed: echo -n 123e+|json -b 4'

echo '$ echo -n 123e+|json -b 5'
echo -n 123e+|json -b 5 2>&1 ||
echo 'command failed: echo -n 123e+|json -b 5'

echo '$ echo -n 123e+|json -b 6'
echo -n 123e+|json -b 6 2>&1 ||
echo 'command failed: echo -n 123e+|json -b 6'

echo '$ echo -n 123e+4|json -b 1'
echo -n 123e+4|json -b 1 2>&1 ||
echo 'command failed: echo -n 123e+4|json -b 1'

echo '$ echo -n 123e+4|json -b 2'
echo -n 123e+4|json -b 2 2>&1 ||
echo 'command failed: echo -n 123e+4|json -b 2'

echo '$ echo -n 123e+4|json -b 3'
echo -n 123e+4|json -b 3 2>&1 ||
echo 'command failed: echo -n 123e+4|json -b 3'

echo '$ echo -n 123e+4|json -b 4'
echo -n 123e+4|json -b 4 2>&1 ||
echo 'command failed: echo -n 123e+4|json -b 4'

echo '$ echo -n 123e+4|json -b 5'
echo -n 123e+4|json -b 5 2>&1 ||
echo 'command failed: echo -n 123e+4|json -b 5'

echo '$ echo -n 123e+4|json -b 6'
echo -n 123e+4|json -b 6 2>&1 ||
echo 'command failed: echo -n 123e+4|json -b 6'

echo '$ echo -n 123e+4|json -b 7'
echo -n 123e+4|json -b 7 2>&1 ||
echo 'command failed: echo -n 123e+4|json -b 7'

echo '$ echo -n 123e+45|json -b 1'
echo -n 123e+45|json -b 1 2>&1 ||
echo 'command failed: echo -n 123e+45|json -b 1'

echo '$ echo -n 123e+45|json -b 2'
echo -n 123e+45|json -b 2 2>&1 ||
echo 'command failed: echo -n 123e+45|json -b 2'

echo '$ echo -n 123e+45|json -b 3'
echo -n 123e+45|json -b 3 2>&1 ||
echo 'command failed: echo -n 123e+45|json -b 3'

echo '$ echo -n 123e+45|json -b 4'
echo -n 123e+45|json -b 4 2>&1 ||
echo 'command failed: echo -n 123e+45|json -b 4'

echo '$ echo -n 123e+45|json -b 5'
echo -n 123e+45|json -b 5 2>&1 ||
echo 'command failed: echo -n 123e+45|json -b 5'

echo '$ echo -n 123e+45|json -b 6'
echo -n 123e+45|json -b 6 2>&1 ||
echo 'command failed: echo -n 123e+45|json -b 6'

echo '$ echo -n 123e+45|json -b 7'
echo -n 123e+45|json -b 7 2>&1 ||
echo 'command failed: echo -n 123e+45|json -b 7'

echo '$ echo -n 123e+45|json -b 8'
echo -n 123e+45|json -b 8 2>&1 ||
echo 'command failed: echo -n 123e+45|json -b 8'

echo '$ echo -n 123e+456|json -b 1'
echo -n 123e+456|json -b 1 2>&1 ||
echo 'command failed: echo -n 123e+456|json -b 1'

echo '$ echo -n 123e+456|json -b 2'
echo -n 123e+456|json -b 2 2>&1 ||
echo 'command failed: echo -n 123e+456|json -b 2'

echo '$ echo -n 123e+456|json -b 3'
echo -n 123e+456|json -b 3 2>&1 ||
echo 'command failed: echo -n 123e+456|json -b 3'

echo '$ echo -n 123e+456|json -b 4'
echo -n 123e+456|json -b 4 2>&1 ||
echo 'command failed: echo -n 123e+456|json -b 4'

echo '$ echo -n 123e+456|json -b 5'
echo -n 123e+456|json -b 5 2>&1 ||
echo 'command failed: echo -n 123e+456|json -b 5'

echo '$ echo -n 123e+456|json -b 6'
echo -n 123e+456|json -b 6 2>&1 ||
echo 'command failed: echo -n 123e+456|json -b 6'

echo '$ echo -n 123e+456|json -b 7'
echo -n 123e+456|json -b 7 2>&1 ||
echo 'command failed: echo -n 123e+456|json -b 7'

echo '$ echo -n 123e+456|json -b 8'
echo -n 123e+456|json -b 8 2>&1 ||
echo 'command failed: echo -n 123e+456|json -b 8'

echo '$ echo -n 123e+456|json -b 9'
echo -n 123e+456|json -b 9 2>&1 ||
echo 'command failed: echo -n 123e+456|json -b 9'

echo '$ echo -n 123e-|json -b 1'
echo -n 123e-|json -b 1 2>&1 ||
echo 'command failed: echo -n 123e-|json -b 1'

echo '$ echo -n 123e-|json -b 2'
echo -n 123e-|json -b 2 2>&1 ||
echo 'command failed: echo -n 123e-|json -b 2'

echo '$ echo -n 123e-|json -b 3'
echo -n 123e-|json -b 3 2>&1 ||
echo 'command failed: echo -n 123e-|json -b 3'

echo '$ echo -n 123e-|json -b 4'
echo -n 123e-|json -b 4 2>&1 ||
echo 'command failed: echo -n 123e-|json -b 4'

echo '$ echo -n 123e-|json -b 5'
echo -n 123e-|json -b 5 2>&1 ||
echo 'command failed: echo -n 123e-|json -b 5'

echo '$ echo -n 123e-|json -b 6'
echo -n 123e-|json -b 6 2>&1 ||
echo 'command failed: echo -n 123e-|json -b 6'

echo '$ echo -n 123e-4|json -b 1'
echo -n 123e-4|json -b 1 2>&1 ||
echo 'command failed: echo -n 123e-4|json -b 1'

echo '$ echo -n 123e-4|json -b 2'
echo -n 123e-4|json -b 2 2>&1 ||
echo 'command failed: echo -n 123e-4|json -b 2'

echo '$ echo -n 123e-4|json -b 3'
echo -n 123e-4|json -b 3 2>&1 ||
echo 'command failed: echo -n 123e-4|json -b 3'

echo '$ echo -n 123e-4|json -b 4'
echo -n 123e-4|json -b 4 2>&1 ||
echo 'command failed: echo -n 123e-4|json -b 4'

echo '$ echo -n 123e-4|json -b 5'
echo -n 123e-4|json -b 5 2>&1 ||
echo 'command failed: echo -n 123e-4|json -b 5'

echo '$ echo -n 123e-4|json -b 6'
echo -n 123e-4|json -b 6 2>&1 ||
echo 'command failed: echo -n 123e-4|json -b 6'

echo '$ echo -n 123e-4|json -b 7'
echo -n 123e-4|json -b 7 2>&1 ||
echo 'command failed: echo -n 123e-4|json -b 7'

echo '$ echo -n 123e-45|json -b 1'
echo -n 123e-45|json -b 1 2>&1 ||
echo 'command failed: echo -n 123e-45|json -b 1'

echo '$ echo -n 123e-45|json -b 2'
echo -n 123e-45|json -b 2 2>&1 ||
echo 'command failed: echo -n 123e-45|json -b 2'

echo '$ echo -n 123e-45|json -b 3'
echo -n 123e-45|json -b 3 2>&1 ||
echo 'command failed: echo -n 123e-45|json -b 3'

echo '$ echo -n 123e-45|json -b 4'
echo -n 123e-45|json -b 4 2>&1 ||
echo 'command failed: echo -n 123e-45|json -b 4'

echo '$ echo -n 123e-45|json -b 5'
echo -n 123e-45|json -b 5 2>&1 ||
echo 'command failed: echo -n 123e-45|json -b 5'

echo '$ echo -n 123e-45|json -b 6'
echo -n 123e-45|json -b 6 2>&1 ||
echo 'command failed: echo -n 123e-45|json -b 6'

echo '$ echo -n 123e-45|json -b 7'
echo -n 123e-45|json -b 7 2>&1 ||
echo 'command failed: echo -n 123e-45|json -b 7'

echo '$ echo -n 123e-45|json -b 8'
echo -n 123e-45|json -b 8 2>&1 ||
echo 'command failed: echo -n 123e-45|json -b 8'

echo '$ echo -n 123e-456|json -b 1'
echo -n 123e-456|json -b 1 2>&1 ||
echo 'command failed: echo -n 123e-456|json -b 1'

echo '$ echo -n 123e-456|json -b 2'
echo -n 123e-456|json -b 2 2>&1 ||
echo 'command failed: echo -n 123e-456|json -b 2'

echo '$ echo -n 123e-456|json -b 3'
echo -n 123e-456|json -b 3 2>&1 ||
echo 'command failed: echo -n 123e-456|json -b 3'

echo '$ echo -n 123e-456|json -b 4'
echo -n 123e-456|json -b 4 2>&1 ||
echo 'command failed: echo -n 123e-456|json -b 4'

echo '$ echo -n 123e-456|json -b 5'
echo -n 123e-456|json -b 5 2>&1 ||
echo 'command failed: echo -n 123e-456|json -b 5'

echo '$ echo -n 123e-456|json -b 6'
echo -n 123e-456|json -b 6 2>&1 ||
echo 'command failed: echo -n 123e-456|json -b 6'

echo '$ echo -n 123e-456|json -b 7'
echo -n 123e-456|json -b 7 2>&1 ||
echo 'command failed: echo -n 123e-456|json -b 7'

echo '$ echo -n 123e-456|json -b 8'
echo -n 123e-456|json -b 8 2>&1 ||
echo 'command failed: echo -n 123e-456|json -b 8'

echo '$ echo -n 123e-456|json -b 9'
echo -n 123e-456|json -b 9 2>&1 ||
echo 'command failed: echo -n 123e-456|json -b 9'

echo '$ echo -n 123e4|json -b 1'
echo -n 123e4|json -b 1 2>&1 ||
echo 'command failed: echo -n 123e4|json -b 1'

echo '$ echo -n 123e4|json -b 2'
echo -n 123e4|json -b 2 2>&1 ||
echo 'command failed: echo -n 123e4|json -b 2'

echo '$ echo -n 123e4|json -b 3'
echo -n 123e4|json -b 3 2>&1 ||
echo 'command failed: echo -n 123e4|json -b 3'

echo '$ echo -n 123e4|json -b 4'
echo -n 123e4|json -b 4 2>&1 ||
echo 'command failed: echo -n 123e4|json -b 4'

echo '$ echo -n 123e4|json -b 5'
echo -n 123e4|json -b 5 2>&1 ||
echo 'command failed: echo -n 123e4|json -b 5'

echo '$ echo -n 123e4|json -b 6'
echo -n 123e4|json -b 6 2>&1 ||
echo 'command failed: echo -n 123e4|json -b 6'

echo '$ echo -n 123e45|json -b 1'
echo -n 123e45|json -b 1 2>&1 ||
echo 'command failed: echo -n 123e45|json -b 1'

echo '$ echo -n 123e45|json -b 2'
echo -n 123e45|json -b 2 2>&1 ||
echo 'command failed: echo -n 123e45|json -b 2'

echo '$ echo -n 123e45|json -b 3'
echo -n 123e45|json -b 3 2>&1 ||
echo 'command failed: echo -n 123e45|json -b 3'

echo '$ echo -n 123e45|json -b 4'
echo -n 123e45|json -b 4 2>&1 ||
echo 'command failed: echo -n 123e45|json -b 4'

echo '$ echo -n 123e45|json -b 5'
echo -n 123e45|json -b 5 2>&1 ||
echo 'command failed: echo -n 123e45|json -b 5'

echo '$ echo -n 123e45|json -b 6'
echo -n 123e45|json -b 6 2>&1 ||
echo 'command failed: echo -n 123e45|json -b 6'

echo '$ echo -n 123e45|json -b 7'
echo -n 123e45|json -b 7 2>&1 ||
echo 'command failed: echo -n 123e45|json -b 7'

echo '$ echo -n 123e456|json -b 1'
echo -n 123e456|json -b 1 2>&1 ||
echo 'command failed: echo -n 123e456|json -b 1'

echo '$ echo -n 123e456|json -b 2'
echo -n 123e456|json -b 2 2>&1 ||
echo 'command failed: echo -n 123e456|json -b 2'

echo '$ echo -n 123e456|json -b 3'
echo -n 123e456|json -b 3 2>&1 ||
echo 'command failed: echo -n 123e456|json -b 3'

echo '$ echo -n 123e456|json -b 4'
echo -n 123e456|json -b 4 2>&1 ||
echo 'command failed: echo -n 123e456|json -b 4'

echo '$ echo -n 123e456|json -b 5'
echo -n 123e456|json -b 5 2>&1 ||
echo 'command failed: echo -n 123e456|json -b 5'

echo '$ echo -n 123e456|json -b 6'
echo -n 123e456|json -b 6 2>&1 ||
echo 'command failed: echo -n 123e456|json -b 6'

echo '$ echo -n 123e456|json -b 7'
echo -n 123e456|json -b 7 2>&1 ||
echo 'command failed: echo -n 123e456|json -b 7'

echo '$ echo -n 123e456|json -b 8'
echo -n 123e456|json -b 8 2>&1 ||
echo 'command failed: echo -n 123e456|json -b 8'
)

