#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C parser:raw-string5
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L raw-string5.old <(echo \
'$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }
$ json() { json0 --literal-value --raw-strings "$@"; }
$ echo -n '\''r"()")"'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid char
json: error: <stdin>:1:6: r"()")"
json: error: <stdin>:1:6:      ^
r"()"
command failed: echo -n '\''r"()")"'\''|json -b1
$ echo -n '\''r"()")"'\''|json -b2
json: error: <stdin>:1:6: lex error: invalid char
json: error: <stdin>:1:6: r"()")"
json: error: <stdin>:1:6:      ^
r"()"
command failed: echo -n '\''r"()")"'\''|json -b2
$ echo -n '\''r"()")"'\''|json -b3
json: error: <stdin>:1:6: lex error: invalid char
json: error: <stdin>:1:6: r"()")"
json: error: <stdin>:1:6:      ^
r"()"
command failed: echo -n '\''r"()")"'\''|json -b3
$ echo -n '\''r"()")"'\''|json -b4
json: error: <stdin>:1:6: lex error: invalid char
json: error: <stdin>:1:6: r"()")"
json: error: <stdin>:1:6:      ^
r"()"
command failed: echo -n '\''r"()")"'\''|json -b4
$ echo -n '\''r"()")"'\''|json -b5
json: error: <stdin>:1:6: lex error: invalid char
json: error: <stdin>:1:6: r"()")"
json: error: <stdin>:1:6:      ^
r"()"
command failed: echo -n '\''r"()")"'\''|json -b5
$ echo -n '\''r"()")"'\''|json -b6
json: error: <stdin>:1:6: lex error: invalid char
json: error: <stdin>:1:6: r"()")"
json: error: <stdin>:1:6:      ^
r"()"
command failed: echo -n '\''r"()")"'\''|json -b6
$ echo -n '\''r"()")"'\''|json -b7
json: error: <stdin>:1:6: lex error: invalid char
json: error: <stdin>:1:6: r"()")"
json: error: <stdin>:1:6:      ^
r"()"
command failed: echo -n '\''r"()")"'\''|json -b7
$ echo -n '\''r"bar()")bar"'\''|json -b1
r"bar()")bar"
$ echo -n '\''r"bar()")bar"'\''|json -b2
r"bar()")bar"
$ echo -n '\''r"bar()")bar"'\''|json -b3
r"bar()")bar"
$ echo -n '\''r"bar()")bar"'\''|json -b4
r"bar()")bar"
$ echo -n '\''r"bar()")bar"'\''|json -b5
r"bar()")bar"
$ echo -n '\''r"bar()")bar"'\''|json -b6
r"bar()")bar"
$ echo -n '\''r"bar()")bar"'\''|json -b7
r"bar()")bar"
$ echo -n '\''r"bar()")bar"'\''|json -b8
r"bar()")bar"
$ echo -n '\''r"bar()")bar"'\''|json -b9
r"bar()")bar"
$ echo -n '\''r"bar()")bar"'\''|json -b10
r"bar()")bar"
$ echo -n '\''r"bar()")bar"'\''|json -b11
r"bar()")bar"
$ echo -n '\''r"bar()")bar"'\''|json -b12
r"bar()")bar"
$ echo -n '\''r"bar()")bar"'\''|json -b13
r"bar()")bar"
$ echo -n '\''r"bar()b")bar"'\''|json -b1
r"bar()b")bar"
$ echo -n '\''r"bar()b")bar"'\''|json -b2
r"bar()b")bar"
$ echo -n '\''r"bar()b")bar"'\''|json -b3
r"bar()b")bar"
$ echo -n '\''r"bar()b")bar"'\''|json -b4
r"bar()b")bar"
$ echo -n '\''r"bar()b")bar"'\''|json -b5
r"bar()b")bar"
$ echo -n '\''r"bar()b")bar"'\''|json -b6
r"bar()b")bar"
$ echo -n '\''r"bar()b")bar"'\''|json -b7
r"bar()b")bar"
$ echo -n '\''r"bar()b")bar"'\''|json -b8
r"bar()b")bar"
$ echo -n '\''r"bar()b")bar"'\''|json -b9
r"bar()b")bar"
$ echo -n '\''r"bar()b")bar"'\''|json -b10
r"bar()b")bar"
$ echo -n '\''r"bar()b")bar"'\''|json -b11
r"bar()b")bar"
$ echo -n '\''r"bar()b")bar"'\''|json -b12
r"bar()b")bar"
$ echo -n '\''r"bar()b")bar"'\''|json -b13
r"bar()b")bar"
$ echo -n '\''r"bar()b")bar"'\''|json -b14
r"bar()b")bar"
$ echo -n '\''r"bar()ba")bar"'\''|json -b1
r"bar()ba")bar"
$ echo -n '\''r"bar()ba")bar"'\''|json -b2
r"bar()ba")bar"
$ echo -n '\''r"bar()ba")bar"'\''|json -b3
r"bar()ba")bar"
$ echo -n '\''r"bar()ba")bar"'\''|json -b4
r"bar()ba")bar"
$ echo -n '\''r"bar()ba")bar"'\''|json -b5
r"bar()ba")bar"
$ echo -n '\''r"bar()ba")bar"'\''|json -b6
r"bar()ba")bar"
$ echo -n '\''r"bar()ba")bar"'\''|json -b7
r"bar()ba")bar"
$ echo -n '\''r"bar()ba")bar"'\''|json -b8
r"bar()ba")bar"
$ echo -n '\''r"bar()ba")bar"'\''|json -b9
r"bar()ba")bar"
$ echo -n '\''r"bar()ba")bar"'\''|json -b10
r"bar()ba")bar"
$ echo -n '\''r"bar()ba")bar"'\''|json -b11
r"bar()ba")bar"
$ echo -n '\''r"bar()ba")bar"'\''|json -b12
r"bar()ba")bar"
$ echo -n '\''r"bar()ba")bar"'\''|json -b13
r"bar()ba")bar"
$ echo -n '\''r"bar()ba")bar"'\''|json -b14
r"bar()ba")bar"
$ echo -n '\''r"bar()ba")bar"'\''|json -b15
r"bar()ba")bar"
$ echo -n '\''r"bar()bar")bar"'\''|json -b1
json: error: <stdin>:1:12: lex error: invalid char
json: error: <stdin>:1:12: r"bar()bar")bar"
json: error: <stdin>:1:12:            ^
r"bar()bar"
command failed: echo -n '\''r"bar()bar")bar"'\''|json -b1
$ echo -n '\''r"bar()bar")bar"'\''|json -b2
json: error: <stdin>:1:12: lex error: invalid char
json: error: <stdin>:1:12: r"bar()bar")bar"
json: error: <stdin>:1:12:            ^
r"bar()bar"
command failed: echo -n '\''r"bar()bar")bar"'\''|json -b2
$ echo -n '\''r"bar()bar")bar"'\''|json -b3
json: error: <stdin>:1:12: lex error: invalid char
json: error: <stdin>:1:12: r"bar()bar")bar"
json: error: <stdin>:1:12:            ^
r"bar()bar"
command failed: echo -n '\''r"bar()bar")bar"'\''|json -b3
$ echo -n '\''r"bar()bar")bar"'\''|json -b4
json: error: <stdin>:1:12: lex error: invalid char
json: error: <stdin>:1:12: r"bar()bar")bar"
json: error: <stdin>:1:12:            ^
r"bar()bar"
command failed: echo -n '\''r"bar()bar")bar"'\''|json -b4
$ echo -n '\''r"bar()bar")bar"'\''|json -b5
json: error: <stdin>:1:12: lex error: invalid char
json: error: <stdin>:1:12: r"bar()bar")bar"
json: error: <stdin>:1:12:            ^
r"bar()bar"
command failed: echo -n '\''r"bar()bar")bar"'\''|json -b5
$ echo -n '\''r"bar()bar")bar"'\''|json -b6
json: error: <stdin>:1:12: lex error: invalid char
json: error: <stdin>:1:12: r"bar()bar")bar"
json: error: <stdin>:1:12:            ^
r"bar()bar"
command failed: echo -n '\''r"bar()bar")bar"'\''|json -b6
$ echo -n '\''r"bar()bar")bar"'\''|json -b7
json: error: <stdin>:1:12: lex error: invalid char
json: error: <stdin>:1:12: r"bar()bar")bar"
json: error: <stdin>:1:12:            ^
r"bar()bar"
command failed: echo -n '\''r"bar()bar")bar"'\''|json -b7
$ echo -n '\''r"bar()bar")bar"'\''|json -b8
json: error: <stdin>:1:12: lex error: invalid char
json: error: <stdin>:1:12: r"bar()bar")bar"
json: error: <stdin>:1:12:            ^
r"bar()bar"
command failed: echo -n '\''r"bar()bar")bar"'\''|json -b8
$ echo -n '\''r"bar()bar")bar"'\''|json -b9
json: error: <stdin>:1:12: lex error: invalid char
json: error: <stdin>:1:12: r"bar()bar")bar"
json: error: <stdin>:1:12:            ^
r"bar()bar"
command failed: echo -n '\''r"bar()bar")bar"'\''|json -b9
$ echo -n '\''r"bar()bar")bar"'\''|json -b10
json: error: <stdin>:1:12: lex error: invalid char
json: error: <stdin>:1:12: r"bar()bar")bar"
json: error: <stdin>:1:12:            ^
r"bar()bar"
command failed: echo -n '\''r"bar()bar")bar"'\''|json -b10
$ echo -n '\''r"bar()bar")bar"'\''|json -b11
json: error: <stdin>:1:12: lex error: invalid char
json: error: <stdin>:1:12: r"bar()bar")bar"
json: error: <stdin>:1:12:            ^
r"bar()bar"
command failed: echo -n '\''r"bar()bar")bar"'\''|json -b11
$ echo -n '\''r"bar()bar")bar"'\''|json -b12
json: error: <stdin>:1:12: lex error: invalid char
json: error: <stdin>:1:12: r"bar()bar")bar"
json: error: <stdin>:1:12:            ^
r"bar()bar"
command failed: echo -n '\''r"bar()bar")bar"'\''|json -b12
$ echo -n '\''r"bar()bar")bar"'\''|json -b13
json: error: <stdin>:1:12: lex error: invalid char
json: error: <stdin>:1:12: r"bar()bar")bar"
json: error: <stdin>:1:12:            ^
r"bar()bar"
command failed: echo -n '\''r"bar()bar")bar"'\''|json -b13
$ echo -n '\''r"bar()bar")bar"'\''|json -b14
json: error: <stdin>:1:12: lex error: invalid char
json: error: <stdin>:1:12: r"bar()bar")bar"
json: error: <stdin>:1:12:            ^
r"bar()bar"
command failed: echo -n '\''r"bar()bar")bar"'\''|json -b14
$ echo -n '\''r"bar()bar")bar"'\''|json -b15
json: error: <stdin>:1:12: lex error: invalid char
json: error: <stdin>:1:12: r"bar()bar")bar"
json: error: <stdin>:1:12:            ^
r"bar()bar"
command failed: echo -n '\''r"bar()bar")bar"'\''|json -b15
$ echo -n '\''r"bar()bar")bar"'\''|json -b16
json: error: <stdin>:1:12: lex error: invalid char
json: error: <stdin>:1:12: r"bar()bar")bar"
json: error: <stdin>:1:12:            ^
r"bar()bar"
command failed: echo -n '\''r"bar()bar")bar"'\''|json -b16
$ echo -n '\''r"0123456789abcdef()")0123456789abcdef"'\''|json -b1
r"0123456789abcdef()")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()")0123456789abcdef"'\''|json -b2
r"0123456789abcdef()")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()")0123456789abcdef"'\''|json -b4
r"0123456789abcdef()")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()")0123456789abcdef"'\''|json -b8
r"0123456789abcdef()")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()")0123456789abcdef"'\''|json -b16
r"0123456789abcdef()")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()")0123456789abcdef"'\''|json -b32
r"0123456789abcdef()")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()0")0123456789abcdef"'\''|json -b1
r"0123456789abcdef()0")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()0")0123456789abcdef"'\''|json -b2
r"0123456789abcdef()0")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()0")0123456789abcdef"'\''|json -b4
r"0123456789abcdef()0")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()0")0123456789abcdef"'\''|json -b8
r"0123456789abcdef()0")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()0")0123456789abcdef"'\''|json -b16
r"0123456789abcdef()0")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()0")0123456789abcdef"'\''|json -b32
r"0123456789abcdef()0")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()01")0123456789abcdef"'\''|json -b1
r"0123456789abcdef()01")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()01")0123456789abcdef"'\''|json -b2
r"0123456789abcdef()01")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()01")0123456789abcdef"'\''|json -b4
r"0123456789abcdef()01")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()01")0123456789abcdef"'\''|json -b8
r"0123456789abcdef()01")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()01")0123456789abcdef"'\''|json -b16
r"0123456789abcdef()01")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()01")0123456789abcdef"'\''|json -b32
r"0123456789abcdef()01")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()012")0123456789abcdef"'\''|json -b1
r"0123456789abcdef()012")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()012")0123456789abcdef"'\''|json -b2
r"0123456789abcdef()012")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()012")0123456789abcdef"'\''|json -b4
r"0123456789abcdef()012")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()012")0123456789abcdef"'\''|json -b8
r"0123456789abcdef()012")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()012")0123456789abcdef"'\''|json -b16
r"0123456789abcdef()012")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()012")0123456789abcdef"'\''|json -b32
r"0123456789abcdef()012")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()0123")0123456789abcdef"'\''|json -b1
r"0123456789abcdef()0123")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()0123")0123456789abcdef"'\''|json -b2
r"0123456789abcdef()0123")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()0123")0123456789abcdef"'\''|json -b4
r"0123456789abcdef()0123")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()0123")0123456789abcdef"'\''|json -b8
r"0123456789abcdef()0123")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()0123")0123456789abcdef"'\''|json -b16
r"0123456789abcdef()0123")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()0123")0123456789abcdef"'\''|json -b32
r"0123456789abcdef()0123")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()01234")0123456789abcdef"'\''|json -b1
r"0123456789abcdef()01234")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()01234")0123456789abcdef"'\''|json -b2
r"0123456789abcdef()01234")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()01234")0123456789abcdef"'\''|json -b4
r"0123456789abcdef()01234")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()01234")0123456789abcdef"'\''|json -b8
r"0123456789abcdef()01234")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()01234")0123456789abcdef"'\''|json -b16
r"0123456789abcdef()01234")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()01234")0123456789abcdef"'\''|json -b32
r"0123456789abcdef()01234")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()012345")0123456789abcdef"'\''|json -b1
r"0123456789abcdef()012345")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()012345")0123456789abcdef"'\''|json -b2
r"0123456789abcdef()012345")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()012345")0123456789abcdef"'\''|json -b4
r"0123456789abcdef()012345")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()012345")0123456789abcdef"'\''|json -b8
r"0123456789abcdef()012345")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()012345")0123456789abcdef"'\''|json -b16
r"0123456789abcdef()012345")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()012345")0123456789abcdef"'\''|json -b32
r"0123456789abcdef()012345")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()0123456")0123456789abcdef"'\''|json -b1
r"0123456789abcdef()0123456")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()0123456")0123456789abcdef"'\''|json -b2
r"0123456789abcdef()0123456")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()0123456")0123456789abcdef"'\''|json -b4
r"0123456789abcdef()0123456")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()0123456")0123456789abcdef"'\''|json -b8
r"0123456789abcdef()0123456")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()0123456")0123456789abcdef"'\''|json -b16
r"0123456789abcdef()0123456")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()0123456")0123456789abcdef"'\''|json -b32
r"0123456789abcdef()0123456")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()01234567")0123456789abcdef"'\''|json -b1
r"0123456789abcdef()01234567")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()01234567")0123456789abcdef"'\''|json -b2
r"0123456789abcdef()01234567")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()01234567")0123456789abcdef"'\''|json -b4
r"0123456789abcdef()01234567")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()01234567")0123456789abcdef"'\''|json -b8
r"0123456789abcdef()01234567")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()01234567")0123456789abcdef"'\''|json -b16
r"0123456789abcdef()01234567")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()01234567")0123456789abcdef"'\''|json -b32
r"0123456789abcdef()01234567")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()012345678")0123456789abcdef"'\''|json -b1
r"0123456789abcdef()012345678")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()012345678")0123456789abcdef"'\''|json -b2
r"0123456789abcdef()012345678")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()012345678")0123456789abcdef"'\''|json -b4
r"0123456789abcdef()012345678")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()012345678")0123456789abcdef"'\''|json -b8
r"0123456789abcdef()012345678")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()012345678")0123456789abcdef"'\''|json -b16
r"0123456789abcdef()012345678")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()012345678")0123456789abcdef"'\''|json -b32
r"0123456789abcdef()012345678")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()0123456789")0123456789abcdef"'\''|json -b1
r"0123456789abcdef()0123456789")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()0123456789")0123456789abcdef"'\''|json -b2
r"0123456789abcdef()0123456789")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()0123456789")0123456789abcdef"'\''|json -b4
r"0123456789abcdef()0123456789")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()0123456789")0123456789abcdef"'\''|json -b8
r"0123456789abcdef()0123456789")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()0123456789")0123456789abcdef"'\''|json -b16
r"0123456789abcdef()0123456789")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()0123456789")0123456789abcdef"'\''|json -b32
r"0123456789abcdef()0123456789")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()0123456789a")0123456789abcdef"'\''|json -b1
r"0123456789abcdef()0123456789a")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()0123456789a")0123456789abcdef"'\''|json -b2
r"0123456789abcdef()0123456789a")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()0123456789a")0123456789abcdef"'\''|json -b4
r"0123456789abcdef()0123456789a")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()0123456789a")0123456789abcdef"'\''|json -b8
r"0123456789abcdef()0123456789a")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()0123456789a")0123456789abcdef"'\''|json -b16
r"0123456789abcdef()0123456789a")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()0123456789a")0123456789abcdef"'\''|json -b32
r"0123456789abcdef()0123456789a")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()0123456789ab")0123456789abcdef"'\''|json -b1
r"0123456789abcdef()0123456789ab")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()0123456789ab")0123456789abcdef"'\''|json -b2
r"0123456789abcdef()0123456789ab")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()0123456789ab")0123456789abcdef"'\''|json -b4
r"0123456789abcdef()0123456789ab")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()0123456789ab")0123456789abcdef"'\''|json -b8
r"0123456789abcdef()0123456789ab")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()0123456789ab")0123456789abcdef"'\''|json -b16
r"0123456789abcdef()0123456789ab")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()0123456789ab")0123456789abcdef"'\''|json -b32
r"0123456789abcdef()0123456789ab")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()0123456789abc")0123456789abcdef"'\''|json -b1
r"0123456789abcdef()0123456789abc")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()0123456789abc")0123456789abcdef"'\''|json -b2
r"0123456789abcdef()0123456789abc")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()0123456789abc")0123456789abcdef"'\''|json -b4
r"0123456789abcdef()0123456789abc")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()0123456789abc")0123456789abcdef"'\''|json -b8
r"0123456789abcdef()0123456789abc")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()0123456789abc")0123456789abcdef"'\''|json -b16
r"0123456789abcdef()0123456789abc")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()0123456789abc")0123456789abcdef"'\''|json -b32
r"0123456789abcdef()0123456789abc")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()0123456789abcd")0123456789abcdef"'\''|json -b1
r"0123456789abcdef()0123456789abcd")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()0123456789abcd")0123456789abcdef"'\''|json -b2
r"0123456789abcdef()0123456789abcd")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()0123456789abcd")0123456789abcdef"'\''|json -b4
r"0123456789abcdef()0123456789abcd")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()0123456789abcd")0123456789abcdef"'\''|json -b8
r"0123456789abcdef()0123456789abcd")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()0123456789abcd")0123456789abcdef"'\''|json -b16
r"0123456789abcdef()0123456789abcd")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()0123456789abcd")0123456789abcdef"'\''|json -b32
r"0123456789abcdef()0123456789abcd")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()0123456789abcde")0123456789abcdef"'\''|json -b1
r"0123456789abcdef()0123456789abcde")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()0123456789abcde")0123456789abcdef"'\''|json -b2
r"0123456789abcdef()0123456789abcde")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()0123456789abcde")0123456789abcdef"'\''|json -b4
r"0123456789abcdef()0123456789abcde")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()0123456789abcde")0123456789abcdef"'\''|json -b8
r"0123456789abcdef()0123456789abcde")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()0123456789abcde")0123456789abcdef"'\''|json -b16
r"0123456789abcdef()0123456789abcde")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()0123456789abcde")0123456789abcdef"'\''|json -b32
r"0123456789abcdef()0123456789abcde")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()0123456789abcdef")0123456789abcdef"'\''|json -b1
json: error: <stdin>:1:38: lex error: invalid char
json: error: <stdin>:1:38: 3456789abcdef()0123456789abcdef")0123456789abcdef"
json: error: <stdin>:1:38:                                 ^
r"0123456789abcdef()0123456789abcdef"
command failed: echo -n '\''r"0123456789abcdef()0123456789abcdef")0123456789abcdef"'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abcdef")0123456789abcdef"'\''|json -b2
json: error: <stdin>:1:38: lex error: invalid char
json: error: <stdin>:1:38: 3456789abcdef()0123456789abcdef")0123456789abcdef"
json: error: <stdin>:1:38:                                 ^
r"0123456789abcdef()0123456789abcdef"
command failed: echo -n '\''r"0123456789abcdef()0123456789abcdef")0123456789abcdef"'\''|json -b2
$ echo -n '\''r"0123456789abcdef()0123456789abcdef")0123456789abcdef"'\''|json -b4
json: error: <stdin>:1:38: lex error: invalid char
json: error: <stdin>:1:38: 3456789abcdef()0123456789abcdef")0123456789abcdef"
json: error: <stdin>:1:38:                                 ^
r"0123456789abcdef()0123456789abcdef"
command failed: echo -n '\''r"0123456789abcdef()0123456789abcdef")0123456789abcdef"'\''|json -b4
$ echo -n '\''r"0123456789abcdef()0123456789abcdef")0123456789abcdef"'\''|json -b8
json: error: <stdin>:1:38: lex error: invalid char
json: error: <stdin>:1:38: 3456789abcdef()0123456789abcdef")0123456789abcdef"
json: error: <stdin>:1:38:                                 ^
r"0123456789abcdef()0123456789abcdef"
command failed: echo -n '\''r"0123456789abcdef()0123456789abcdef")0123456789abcdef"'\''|json -b8
$ echo -n '\''r"0123456789abcdef()0123456789abcdef")0123456789abcdef"'\''|json -b16
json: error: <stdin>:1:38: lex error: invalid char
json: error: <stdin>:1:38: 3456789abcdef()0123456789abcdef")0123456789abcdef"
json: error: <stdin>:1:38:                                 ^
r"0123456789abcdef()0123456789abcdef"
command failed: echo -n '\''r"0123456789abcdef()0123456789abcdef")0123456789abcdef"'\''|json -b16
$ echo -n '\''r"0123456789abcdef()0123456789abcdef")0123456789abcdef"'\''|json -b32
json: error: <stdin>:1:38: lex error: invalid char
json: error: <stdin>:1:38: 3456789abcdef()0123456789abcdef")0123456789abcdef"
json: error: <stdin>:1:38:                                 ^
r"0123456789abcdef()0123456789abcdef"
command failed: echo -n '\''r"0123456789abcdef()0123456789abcdef")0123456789abcdef"'\''|json -b32
$ echo -n '\''r"(foo)")"'\''|json -b1
json: error: <stdin>:1:9: lex error: invalid char
json: error: <stdin>:1:9: r"(foo)")"
json: error: <stdin>:1:9:         ^
r"(foo)"
command failed: echo -n '\''r"(foo)")"'\''|json -b1
$ echo -n '\''r"(foo)")"'\''|json -b2
json: error: <stdin>:1:9: lex error: invalid char
json: error: <stdin>:1:9: r"(foo)")"
json: error: <stdin>:1:9:         ^
r"(foo)"
command failed: echo -n '\''r"(foo)")"'\''|json -b2
$ echo -n '\''r"(foo)")"'\''|json -b3
json: error: <stdin>:1:9: lex error: invalid char
json: error: <stdin>:1:9: r"(foo)")"
json: error: <stdin>:1:9:         ^
r"(foo)"
command failed: echo -n '\''r"(foo)")"'\''|json -b3
$ echo -n '\''r"(foo)")"'\''|json -b4
json: error: <stdin>:1:9: lex error: invalid char
json: error: <stdin>:1:9: r"(foo)")"
json: error: <stdin>:1:9:         ^
r"(foo)"
command failed: echo -n '\''r"(foo)")"'\''|json -b4
$ echo -n '\''r"(foo)")"'\''|json -b5
json: error: <stdin>:1:9: lex error: invalid char
json: error: <stdin>:1:9: r"(foo)")"
json: error: <stdin>:1:9:         ^
r"(foo)"
command failed: echo -n '\''r"(foo)")"'\''|json -b5
$ echo -n '\''r"(foo)")"'\''|json -b6
json: error: <stdin>:1:9: lex error: invalid char
json: error: <stdin>:1:9: r"(foo)")"
json: error: <stdin>:1:9:         ^
r"(foo)"
command failed: echo -n '\''r"(foo)")"'\''|json -b6
$ echo -n '\''r"(foo)")"'\''|json -b7
json: error: <stdin>:1:9: lex error: invalid char
json: error: <stdin>:1:9: r"(foo)")"
json: error: <stdin>:1:9:         ^
r"(foo)"
command failed: echo -n '\''r"(foo)")"'\''|json -b7
$ echo -n '\''r"(foo)")"'\''|json -b8
json: error: <stdin>:1:9: lex error: invalid char
json: error: <stdin>:1:9: r"(foo)")"
json: error: <stdin>:1:9:         ^
r"(foo)"
command failed: echo -n '\''r"(foo)")"'\''|json -b8
$ echo -n '\''r"(foo)")"'\''|json -b9
json: error: <stdin>:1:9: lex error: invalid char
json: error: <stdin>:1:9: r"(foo)")"
json: error: <stdin>:1:9:         ^
r"(foo)"
command failed: echo -n '\''r"(foo)")"'\''|json -b9
$ echo -n '\''r"(foo)")"'\''|json -b10
json: error: <stdin>:1:9: lex error: invalid char
json: error: <stdin>:1:9: r"(foo)")"
json: error: <stdin>:1:9:         ^
r"(foo)"
command failed: echo -n '\''r"(foo)")"'\''|json -b10
$ echo -n '\''r"bar(foo)")bar"'\''|json -b1
r"bar(foo)")bar"
$ echo -n '\''r"bar(foo)")bar"'\''|json -b2
r"bar(foo)")bar"
$ echo -n '\''r"bar(foo)")bar"'\''|json -b3
r"bar(foo)")bar"
$ echo -n '\''r"bar(foo)")bar"'\''|json -b4
r"bar(foo)")bar"
$ echo -n '\''r"bar(foo)")bar"'\''|json -b5
r"bar(foo)")bar"
$ echo -n '\''r"bar(foo)")bar"'\''|json -b6
r"bar(foo)")bar"
$ echo -n '\''r"bar(foo)")bar"'\''|json -b7
r"bar(foo)")bar"
$ echo -n '\''r"bar(foo)")bar"'\''|json -b8
r"bar(foo)")bar"
$ echo -n '\''r"bar(foo)")bar"'\''|json -b9
r"bar(foo)")bar"
$ echo -n '\''r"bar(foo)")bar"'\''|json -b10
r"bar(foo)")bar"
$ echo -n '\''r"bar(foo)")bar"'\''|json -b11
r"bar(foo)")bar"
$ echo -n '\''r"bar(foo)")bar"'\''|json -b12
r"bar(foo)")bar"
$ echo -n '\''r"bar(foo)")bar"'\''|json -b13
r"bar(foo)")bar"
$ echo -n '\''r"bar(foo)")bar"'\''|json -b14
r"bar(foo)")bar"
$ echo -n '\''r"bar(foo)")bar"'\''|json -b15
r"bar(foo)")bar"
$ echo -n '\''r"bar(foo)")bar"'\''|json -b16
r"bar(foo)")bar"
$ echo -n '\''r"bar(foo)b")bar"'\''|json -b1
r"bar(foo)b")bar"
$ echo -n '\''r"bar(foo)b")bar"'\''|json -b2
r"bar(foo)b")bar"
$ echo -n '\''r"bar(foo)b")bar"'\''|json -b3
r"bar(foo)b")bar"
$ echo -n '\''r"bar(foo)b")bar"'\''|json -b4
r"bar(foo)b")bar"
$ echo -n '\''r"bar(foo)b")bar"'\''|json -b5
r"bar(foo)b")bar"
$ echo -n '\''r"bar(foo)b")bar"'\''|json -b6
r"bar(foo)b")bar"
$ echo -n '\''r"bar(foo)b")bar"'\''|json -b7
r"bar(foo)b")bar"
$ echo -n '\''r"bar(foo)b")bar"'\''|json -b8
r"bar(foo)b")bar"
$ echo -n '\''r"bar(foo)b")bar"'\''|json -b9
r"bar(foo)b")bar"
$ echo -n '\''r"bar(foo)b")bar"'\''|json -b10
r"bar(foo)b")bar"
$ echo -n '\''r"bar(foo)b")bar"'\''|json -b11
r"bar(foo)b")bar"
$ echo -n '\''r"bar(foo)b")bar"'\''|json -b12
r"bar(foo)b")bar"
$ echo -n '\''r"bar(foo)b")bar"'\''|json -b13
r"bar(foo)b")bar"
$ echo -n '\''r"bar(foo)b")bar"'\''|json -b14
r"bar(foo)b")bar"
$ echo -n '\''r"bar(foo)b")bar"'\''|json -b15
r"bar(foo)b")bar"
$ echo -n '\''r"bar(foo)b")bar"'\''|json -b16
r"bar(foo)b")bar"
$ echo -n '\''r"bar(foo)b")bar"'\''|json -b17
r"bar(foo)b")bar"
$ echo -n '\''r"bar(foo)ba")bar"'\''|json -b1
r"bar(foo)ba")bar"
$ echo -n '\''r"bar(foo)ba")bar"'\''|json -b2
r"bar(foo)ba")bar"
$ echo -n '\''r"bar(foo)ba")bar"'\''|json -b3
r"bar(foo)ba")bar"
$ echo -n '\''r"bar(foo)ba")bar"'\''|json -b4
r"bar(foo)ba")bar"
$ echo -n '\''r"bar(foo)ba")bar"'\''|json -b5
r"bar(foo)ba")bar"
$ echo -n '\''r"bar(foo)ba")bar"'\''|json -b6
r"bar(foo)ba")bar"
$ echo -n '\''r"bar(foo)ba")bar"'\''|json -b7
r"bar(foo)ba")bar"
$ echo -n '\''r"bar(foo)ba")bar"'\''|json -b8
r"bar(foo)ba")bar"
$ echo -n '\''r"bar(foo)ba")bar"'\''|json -b9
r"bar(foo)ba")bar"
$ echo -n '\''r"bar(foo)ba")bar"'\''|json -b10
r"bar(foo)ba")bar"
$ echo -n '\''r"bar(foo)ba")bar"'\''|json -b11
r"bar(foo)ba")bar"
$ echo -n '\''r"bar(foo)ba")bar"'\''|json -b12
r"bar(foo)ba")bar"
$ echo -n '\''r"bar(foo)ba")bar"'\''|json -b13
r"bar(foo)ba")bar"
$ echo -n '\''r"bar(foo)ba")bar"'\''|json -b14
r"bar(foo)ba")bar"
$ echo -n '\''r"bar(foo)ba")bar"'\''|json -b15
r"bar(foo)ba")bar"
$ echo -n '\''r"bar(foo)ba")bar"'\''|json -b16
r"bar(foo)ba")bar"
$ echo -n '\''r"bar(foo)ba")bar"'\''|json -b17
r"bar(foo)ba")bar"
$ echo -n '\''r"bar(foo)ba")bar"'\''|json -b18
r"bar(foo)ba")bar"
$ echo -n '\''r"bar(foo)bar")bar"'\''|json -b1
json: error: <stdin>:1:15: lex error: invalid char
json: error: <stdin>:1:15: r"bar(foo)bar")bar"
json: error: <stdin>:1:15:               ^
r"bar(foo)bar"
command failed: echo -n '\''r"bar(foo)bar")bar"'\''|json -b1
$ echo -n '\''r"bar(foo)bar")bar"'\''|json -b2
json: error: <stdin>:1:15: lex error: invalid char
json: error: <stdin>:1:15: r"bar(foo)bar")bar"
json: error: <stdin>:1:15:               ^
r"bar(foo)bar"
command failed: echo -n '\''r"bar(foo)bar")bar"'\''|json -b2
$ echo -n '\''r"bar(foo)bar")bar"'\''|json -b3
json: error: <stdin>:1:15: lex error: invalid char
json: error: <stdin>:1:15: r"bar(foo)bar")bar"
json: error: <stdin>:1:15:               ^
r"bar(foo)bar"
command failed: echo -n '\''r"bar(foo)bar")bar"'\''|json -b3
$ echo -n '\''r"bar(foo)bar")bar"'\''|json -b4
json: error: <stdin>:1:15: lex error: invalid char
json: error: <stdin>:1:15: r"bar(foo)bar")bar"
json: error: <stdin>:1:15:               ^
r"bar(foo)bar"
command failed: echo -n '\''r"bar(foo)bar")bar"'\''|json -b4
$ echo -n '\''r"bar(foo)bar")bar"'\''|json -b5
json: error: <stdin>:1:15: lex error: invalid char
json: error: <stdin>:1:15: r"bar(foo)bar")bar"
json: error: <stdin>:1:15:               ^
r"bar(foo)bar"
command failed: echo -n '\''r"bar(foo)bar")bar"'\''|json -b5
$ echo -n '\''r"bar(foo)bar")bar"'\''|json -b6
json: error: <stdin>:1:15: lex error: invalid char
json: error: <stdin>:1:15: r"bar(foo)bar")bar"
json: error: <stdin>:1:15:               ^
r"bar(foo)bar"
command failed: echo -n '\''r"bar(foo)bar")bar"'\''|json -b6
$ echo -n '\''r"bar(foo)bar")bar"'\''|json -b7
json: error: <stdin>:1:15: lex error: invalid char
json: error: <stdin>:1:15: r"bar(foo)bar")bar"
json: error: <stdin>:1:15:               ^
r"bar(foo)bar"
command failed: echo -n '\''r"bar(foo)bar")bar"'\''|json -b7
$ echo -n '\''r"bar(foo)bar")bar"'\''|json -b8
json: error: <stdin>:1:15: lex error: invalid char
json: error: <stdin>:1:15: r"bar(foo)bar")bar"
json: error: <stdin>:1:15:               ^
r"bar(foo)bar"
command failed: echo -n '\''r"bar(foo)bar")bar"'\''|json -b8
$ echo -n '\''r"bar(foo)bar")bar"'\''|json -b9
json: error: <stdin>:1:15: lex error: invalid char
json: error: <stdin>:1:15: r"bar(foo)bar")bar"
json: error: <stdin>:1:15:               ^
r"bar(foo)bar"
command failed: echo -n '\''r"bar(foo)bar")bar"'\''|json -b9
$ echo -n '\''r"bar(foo)bar")bar"'\''|json -b10
json: error: <stdin>:1:15: lex error: invalid char
json: error: <stdin>:1:15: r"bar(foo)bar")bar"
json: error: <stdin>:1:15:               ^
r"bar(foo)bar"
command failed: echo -n '\''r"bar(foo)bar")bar"'\''|json -b10
$ echo -n '\''r"bar(foo)bar")bar"'\''|json -b11
json: error: <stdin>:1:15: lex error: invalid char
json: error: <stdin>:1:15: r"bar(foo)bar")bar"
json: error: <stdin>:1:15:               ^
r"bar(foo)bar"
command failed: echo -n '\''r"bar(foo)bar")bar"'\''|json -b11
$ echo -n '\''r"bar(foo)bar")bar"'\''|json -b12
json: error: <stdin>:1:15: lex error: invalid char
json: error: <stdin>:1:15: r"bar(foo)bar")bar"
json: error: <stdin>:1:15:               ^
r"bar(foo)bar"
command failed: echo -n '\''r"bar(foo)bar")bar"'\''|json -b12
$ echo -n '\''r"bar(foo)bar")bar"'\''|json -b13
json: error: <stdin>:1:15: lex error: invalid char
json: error: <stdin>:1:15: r"bar(foo)bar")bar"
json: error: <stdin>:1:15:               ^
r"bar(foo)bar"
command failed: echo -n '\''r"bar(foo)bar")bar"'\''|json -b13
$ echo -n '\''r"bar(foo)bar")bar"'\''|json -b14
json: error: <stdin>:1:15: lex error: invalid char
json: error: <stdin>:1:15: r"bar(foo)bar")bar"
json: error: <stdin>:1:15:               ^
r"bar(foo)bar"
command failed: echo -n '\''r"bar(foo)bar")bar"'\''|json -b14
$ echo -n '\''r"bar(foo)bar")bar"'\''|json -b15
json: error: <stdin>:1:15: lex error: invalid char
json: error: <stdin>:1:15: r"bar(foo)bar")bar"
json: error: <stdin>:1:15:               ^
r"bar(foo)bar"
command failed: echo -n '\''r"bar(foo)bar")bar"'\''|json -b15
$ echo -n '\''r"bar(foo)bar")bar"'\''|json -b16
json: error: <stdin>:1:15: lex error: invalid char
json: error: <stdin>:1:15: r"bar(foo)bar")bar"
json: error: <stdin>:1:15:               ^
r"bar(foo)bar"
command failed: echo -n '\''r"bar(foo)bar")bar"'\''|json -b16
$ echo -n '\''r"bar(foo)bar")bar"'\''|json -b17
json: error: <stdin>:1:15: lex error: invalid char
json: error: <stdin>:1:15: r"bar(foo)bar")bar"
json: error: <stdin>:1:15:               ^
r"bar(foo)bar"
command failed: echo -n '\''r"bar(foo)bar")bar"'\''|json -b17
$ echo -n '\''r"bar(foo)bar")bar"'\''|json -b18
json: error: <stdin>:1:15: lex error: invalid char
json: error: <stdin>:1:15: r"bar(foo)bar")bar"
json: error: <stdin>:1:15:               ^
r"bar(foo)bar"
command failed: echo -n '\''r"bar(foo)bar")bar"'\''|json -b18
$ echo -n '\''r"bar(foo)bar")bar"'\''|json -b19
json: error: <stdin>:1:15: lex error: invalid char
json: error: <stdin>:1:15: r"bar(foo)bar")bar"
json: error: <stdin>:1:15:               ^
r"bar(foo)bar"
command failed: echo -n '\''r"bar(foo)bar")bar"'\''|json -b19
$ echo -n '\''r"0123456789abcdef(foo)")0123456789abcdef"'\''|json -b1
r"0123456789abcdef(foo)")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)")0123456789abcdef"'\''|json -b2
r"0123456789abcdef(foo)")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)")0123456789abcdef"'\''|json -b4
r"0123456789abcdef(foo)")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)")0123456789abcdef"'\''|json -b8
r"0123456789abcdef(foo)")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)")0123456789abcdef"'\''|json -b16
r"0123456789abcdef(foo)")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)")0123456789abcdef"'\''|json -b32
r"0123456789abcdef(foo)")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)0")0123456789abcdef"'\''|json -b1
r"0123456789abcdef(foo)0")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)0")0123456789abcdef"'\''|json -b2
r"0123456789abcdef(foo)0")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)0")0123456789abcdef"'\''|json -b4
r"0123456789abcdef(foo)0")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)0")0123456789abcdef"'\''|json -b8
r"0123456789abcdef(foo)0")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)0")0123456789abcdef"'\''|json -b16
r"0123456789abcdef(foo)0")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)0")0123456789abcdef"'\''|json -b32
r"0123456789abcdef(foo)0")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)01")0123456789abcdef"'\''|json -b1
r"0123456789abcdef(foo)01")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)01")0123456789abcdef"'\''|json -b2
r"0123456789abcdef(foo)01")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)01")0123456789abcdef"'\''|json -b4
r"0123456789abcdef(foo)01")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)01")0123456789abcdef"'\''|json -b8
r"0123456789abcdef(foo)01")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)01")0123456789abcdef"'\''|json -b16
r"0123456789abcdef(foo)01")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)01")0123456789abcdef"'\''|json -b32
r"0123456789abcdef(foo)01")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)012")0123456789abcdef"'\''|json -b1
r"0123456789abcdef(foo)012")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)012")0123456789abcdef"'\''|json -b2
r"0123456789abcdef(foo)012")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)012")0123456789abcdef"'\''|json -b4
r"0123456789abcdef(foo)012")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)012")0123456789abcdef"'\''|json -b8
r"0123456789abcdef(foo)012")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)012")0123456789abcdef"'\''|json -b16
r"0123456789abcdef(foo)012")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)012")0123456789abcdef"'\''|json -b32
r"0123456789abcdef(foo)012")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)0123")0123456789abcdef"'\''|json -b1
r"0123456789abcdef(foo)0123")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)0123")0123456789abcdef"'\''|json -b2
r"0123456789abcdef(foo)0123")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)0123")0123456789abcdef"'\''|json -b4
r"0123456789abcdef(foo)0123")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)0123")0123456789abcdef"'\''|json -b8
r"0123456789abcdef(foo)0123")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)0123")0123456789abcdef"'\''|json -b16
r"0123456789abcdef(foo)0123")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)0123")0123456789abcdef"'\''|json -b32
r"0123456789abcdef(foo)0123")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)01234")0123456789abcdef"'\''|json -b1
r"0123456789abcdef(foo)01234")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)01234")0123456789abcdef"'\''|json -b2
r"0123456789abcdef(foo)01234")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)01234")0123456789abcdef"'\''|json -b4
r"0123456789abcdef(foo)01234")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)01234")0123456789abcdef"'\''|json -b8
r"0123456789abcdef(foo)01234")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)01234")0123456789abcdef"'\''|json -b16
r"0123456789abcdef(foo)01234")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)01234")0123456789abcdef"'\''|json -b32
r"0123456789abcdef(foo)01234")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)012345")0123456789abcdef"'\''|json -b1
r"0123456789abcdef(foo)012345")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)012345")0123456789abcdef"'\''|json -b2
r"0123456789abcdef(foo)012345")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)012345")0123456789abcdef"'\''|json -b4
r"0123456789abcdef(foo)012345")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)012345")0123456789abcdef"'\''|json -b8
r"0123456789abcdef(foo)012345")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)012345")0123456789abcdef"'\''|json -b16
r"0123456789abcdef(foo)012345")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)012345")0123456789abcdef"'\''|json -b32
r"0123456789abcdef(foo)012345")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)0123456")0123456789abcdef"'\''|json -b1
r"0123456789abcdef(foo)0123456")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)0123456")0123456789abcdef"'\''|json -b2
r"0123456789abcdef(foo)0123456")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)0123456")0123456789abcdef"'\''|json -b4
r"0123456789abcdef(foo)0123456")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)0123456")0123456789abcdef"'\''|json -b8
r"0123456789abcdef(foo)0123456")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)0123456")0123456789abcdef"'\''|json -b16
r"0123456789abcdef(foo)0123456")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)0123456")0123456789abcdef"'\''|json -b32
r"0123456789abcdef(foo)0123456")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)01234567")0123456789abcdef"'\''|json -b1
r"0123456789abcdef(foo)01234567")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)01234567")0123456789abcdef"'\''|json -b2
r"0123456789abcdef(foo)01234567")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)01234567")0123456789abcdef"'\''|json -b4
r"0123456789abcdef(foo)01234567")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)01234567")0123456789abcdef"'\''|json -b8
r"0123456789abcdef(foo)01234567")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)01234567")0123456789abcdef"'\''|json -b16
r"0123456789abcdef(foo)01234567")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)01234567")0123456789abcdef"'\''|json -b32
r"0123456789abcdef(foo)01234567")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)012345678")0123456789abcdef"'\''|json -b1
r"0123456789abcdef(foo)012345678")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)012345678")0123456789abcdef"'\''|json -b2
r"0123456789abcdef(foo)012345678")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)012345678")0123456789abcdef"'\''|json -b4
r"0123456789abcdef(foo)012345678")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)012345678")0123456789abcdef"'\''|json -b8
r"0123456789abcdef(foo)012345678")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)012345678")0123456789abcdef"'\''|json -b16
r"0123456789abcdef(foo)012345678")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)012345678")0123456789abcdef"'\''|json -b32
r"0123456789abcdef(foo)012345678")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)0123456789")0123456789abcdef"'\''|json -b1
r"0123456789abcdef(foo)0123456789")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)0123456789")0123456789abcdef"'\''|json -b2
r"0123456789abcdef(foo)0123456789")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)0123456789")0123456789abcdef"'\''|json -b4
r"0123456789abcdef(foo)0123456789")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)0123456789")0123456789abcdef"'\''|json -b8
r"0123456789abcdef(foo)0123456789")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)0123456789")0123456789abcdef"'\''|json -b16
r"0123456789abcdef(foo)0123456789")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)0123456789")0123456789abcdef"'\''|json -b32
r"0123456789abcdef(foo)0123456789")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)0123456789a")0123456789abcdef"'\''|json -b1
r"0123456789abcdef(foo)0123456789a")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)0123456789a")0123456789abcdef"'\''|json -b2
r"0123456789abcdef(foo)0123456789a")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)0123456789a")0123456789abcdef"'\''|json -b4
r"0123456789abcdef(foo)0123456789a")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)0123456789a")0123456789abcdef"'\''|json -b8
r"0123456789abcdef(foo)0123456789a")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)0123456789a")0123456789abcdef"'\''|json -b16
r"0123456789abcdef(foo)0123456789a")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)0123456789a")0123456789abcdef"'\''|json -b32
r"0123456789abcdef(foo)0123456789a")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)0123456789ab")0123456789abcdef"'\''|json -b1
r"0123456789abcdef(foo)0123456789ab")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)0123456789ab")0123456789abcdef"'\''|json -b2
r"0123456789abcdef(foo)0123456789ab")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)0123456789ab")0123456789abcdef"'\''|json -b4
r"0123456789abcdef(foo)0123456789ab")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)0123456789ab")0123456789abcdef"'\''|json -b8
r"0123456789abcdef(foo)0123456789ab")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)0123456789ab")0123456789abcdef"'\''|json -b16
r"0123456789abcdef(foo)0123456789ab")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)0123456789ab")0123456789abcdef"'\''|json -b32
r"0123456789abcdef(foo)0123456789ab")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)0123456789abc")0123456789abcdef"'\''|json -b1
r"0123456789abcdef(foo)0123456789abc")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)0123456789abc")0123456789abcdef"'\''|json -b2
r"0123456789abcdef(foo)0123456789abc")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)0123456789abc")0123456789abcdef"'\''|json -b4
r"0123456789abcdef(foo)0123456789abc")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)0123456789abc")0123456789abcdef"'\''|json -b8
r"0123456789abcdef(foo)0123456789abc")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)0123456789abc")0123456789abcdef"'\''|json -b16
r"0123456789abcdef(foo)0123456789abc")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)0123456789abc")0123456789abcdef"'\''|json -b32
r"0123456789abcdef(foo)0123456789abc")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcd")0123456789abcdef"'\''|json -b1
r"0123456789abcdef(foo)0123456789abcd")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcd")0123456789abcdef"'\''|json -b2
r"0123456789abcdef(foo)0123456789abcd")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcd")0123456789abcdef"'\''|json -b4
r"0123456789abcdef(foo)0123456789abcd")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcd")0123456789abcdef"'\''|json -b8
r"0123456789abcdef(foo)0123456789abcd")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcd")0123456789abcdef"'\''|json -b16
r"0123456789abcdef(foo)0123456789abcd")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcd")0123456789abcdef"'\''|json -b32
r"0123456789abcdef(foo)0123456789abcd")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcde")0123456789abcdef"'\''|json -b1
r"0123456789abcdef(foo)0123456789abcde")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcde")0123456789abcdef"'\''|json -b2
r"0123456789abcdef(foo)0123456789abcde")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcde")0123456789abcdef"'\''|json -b4
r"0123456789abcdef(foo)0123456789abcde")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcde")0123456789abcdef"'\''|json -b8
r"0123456789abcdef(foo)0123456789abcde")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcde")0123456789abcdef"'\''|json -b16
r"0123456789abcdef(foo)0123456789abcde")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcde")0123456789abcdef"'\''|json -b32
r"0123456789abcdef(foo)0123456789abcde")0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcdef")0123456789abcdef"'\''|json -b1
json: error: <stdin>:1:41: lex error: invalid char
json: error: <stdin>:1:41: 6789abcdef(foo)0123456789abcdef")0123456789abcdef"
json: error: <stdin>:1:41:                                 ^
r"0123456789abcdef(foo)0123456789abcdef"
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcdef")0123456789abcdef"'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcdef")0123456789abcdef"'\''|json -b2
json: error: <stdin>:1:41: lex error: invalid char
json: error: <stdin>:1:41: 6789abcdef(foo)0123456789abcdef")0123456789abcdef"
json: error: <stdin>:1:41:                                 ^
r"0123456789abcdef(foo)0123456789abcdef"
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcdef")0123456789abcdef"'\''|json -b2
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcdef")0123456789abcdef"'\''|json -b4
json: error: <stdin>:1:41: lex error: invalid char
json: error: <stdin>:1:41: 6789abcdef(foo)0123456789abcdef")0123456789abcdef"
json: error: <stdin>:1:41:                                 ^
r"0123456789abcdef(foo)0123456789abcdef"
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcdef")0123456789abcdef"'\''|json -b4
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcdef")0123456789abcdef"'\''|json -b8
json: error: <stdin>:1:41: lex error: invalid char
json: error: <stdin>:1:41: 6789abcdef(foo)0123456789abcdef")0123456789abcdef"
json: error: <stdin>:1:41:                                 ^
r"0123456789abcdef(foo)0123456789abcdef"
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcdef")0123456789abcdef"'\''|json -b8
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcdef")0123456789abcdef"'\''|json -b16
json: error: <stdin>:1:41: lex error: invalid char
json: error: <stdin>:1:41: 6789abcdef(foo)0123456789abcdef")0123456789abcdef"
json: error: <stdin>:1:41:                                 ^
r"0123456789abcdef(foo)0123456789abcdef"
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcdef")0123456789abcdef"'\''|json -b16
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcdef")0123456789abcdef"'\''|json -b32
json: error: <stdin>:1:41: lex error: invalid char
json: error: <stdin>:1:41: 6789abcdef(foo)0123456789abcdef")0123456789abcdef"
json: error: <stdin>:1:41:                                 ^
r"0123456789abcdef(foo)0123456789abcdef"
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcdef")0123456789abcdef"'\''|json -b32'
) -L raw-string5.new <(
echo '$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'
json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; } 2>&1 ||
echo 'command failed: json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'

echo '$ json() { json0 --literal-value --raw-strings "$@"; }'
json() { json0 --literal-value --raw-strings "$@"; } 2>&1 ||
echo 'command failed: json() { json0 --literal-value --raw-strings "$@"; }'

echo '$ echo -n '\''r"()")"'\''|json -b1'
echo -n 'r"()")"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"()")"'\''|json -b1'

echo '$ echo -n '\''r"()")"'\''|json -b2'
echo -n 'r"()")"'|json -b2 2>&1 ||
echo 'command failed: echo -n '\''r"()")"'\''|json -b2'

echo '$ echo -n '\''r"()")"'\''|json -b3'
echo -n 'r"()")"'|json -b3 2>&1 ||
echo 'command failed: echo -n '\''r"()")"'\''|json -b3'

echo '$ echo -n '\''r"()")"'\''|json -b4'
echo -n 'r"()")"'|json -b4 2>&1 ||
echo 'command failed: echo -n '\''r"()")"'\''|json -b4'

echo '$ echo -n '\''r"()")"'\''|json -b5'
echo -n 'r"()")"'|json -b5 2>&1 ||
echo 'command failed: echo -n '\''r"()")"'\''|json -b5'

echo '$ echo -n '\''r"()")"'\''|json -b6'
echo -n 'r"()")"'|json -b6 2>&1 ||
echo 'command failed: echo -n '\''r"()")"'\''|json -b6'

echo '$ echo -n '\''r"()")"'\''|json -b7'
echo -n 'r"()")"'|json -b7 2>&1 ||
echo 'command failed: echo -n '\''r"()")"'\''|json -b7'

echo '$ echo -n '\''r"bar()")bar"'\''|json -b1'
echo -n 'r"bar()")bar"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"bar()")bar"'\''|json -b1'

echo '$ echo -n '\''r"bar()")bar"'\''|json -b2'
echo -n 'r"bar()")bar"'|json -b2 2>&1 ||
echo 'command failed: echo -n '\''r"bar()")bar"'\''|json -b2'

echo '$ echo -n '\''r"bar()")bar"'\''|json -b3'
echo -n 'r"bar()")bar"'|json -b3 2>&1 ||
echo 'command failed: echo -n '\''r"bar()")bar"'\''|json -b3'

echo '$ echo -n '\''r"bar()")bar"'\''|json -b4'
echo -n 'r"bar()")bar"'|json -b4 2>&1 ||
echo 'command failed: echo -n '\''r"bar()")bar"'\''|json -b4'

echo '$ echo -n '\''r"bar()")bar"'\''|json -b5'
echo -n 'r"bar()")bar"'|json -b5 2>&1 ||
echo 'command failed: echo -n '\''r"bar()")bar"'\''|json -b5'

echo '$ echo -n '\''r"bar()")bar"'\''|json -b6'
echo -n 'r"bar()")bar"'|json -b6 2>&1 ||
echo 'command failed: echo -n '\''r"bar()")bar"'\''|json -b6'

echo '$ echo -n '\''r"bar()")bar"'\''|json -b7'
echo -n 'r"bar()")bar"'|json -b7 2>&1 ||
echo 'command failed: echo -n '\''r"bar()")bar"'\''|json -b7'

echo '$ echo -n '\''r"bar()")bar"'\''|json -b8'
echo -n 'r"bar()")bar"'|json -b8 2>&1 ||
echo 'command failed: echo -n '\''r"bar()")bar"'\''|json -b8'

echo '$ echo -n '\''r"bar()")bar"'\''|json -b9'
echo -n 'r"bar()")bar"'|json -b9 2>&1 ||
echo 'command failed: echo -n '\''r"bar()")bar"'\''|json -b9'

echo '$ echo -n '\''r"bar()")bar"'\''|json -b10'
echo -n 'r"bar()")bar"'|json -b10 2>&1 ||
echo 'command failed: echo -n '\''r"bar()")bar"'\''|json -b10'

echo '$ echo -n '\''r"bar()")bar"'\''|json -b11'
echo -n 'r"bar()")bar"'|json -b11 2>&1 ||
echo 'command failed: echo -n '\''r"bar()")bar"'\''|json -b11'

echo '$ echo -n '\''r"bar()")bar"'\''|json -b12'
echo -n 'r"bar()")bar"'|json -b12 2>&1 ||
echo 'command failed: echo -n '\''r"bar()")bar"'\''|json -b12'

echo '$ echo -n '\''r"bar()")bar"'\''|json -b13'
echo -n 'r"bar()")bar"'|json -b13 2>&1 ||
echo 'command failed: echo -n '\''r"bar()")bar"'\''|json -b13'

echo '$ echo -n '\''r"bar()b")bar"'\''|json -b1'
echo -n 'r"bar()b")bar"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"bar()b")bar"'\''|json -b1'

echo '$ echo -n '\''r"bar()b")bar"'\''|json -b2'
echo -n 'r"bar()b")bar"'|json -b2 2>&1 ||
echo 'command failed: echo -n '\''r"bar()b")bar"'\''|json -b2'

echo '$ echo -n '\''r"bar()b")bar"'\''|json -b3'
echo -n 'r"bar()b")bar"'|json -b3 2>&1 ||
echo 'command failed: echo -n '\''r"bar()b")bar"'\''|json -b3'

echo '$ echo -n '\''r"bar()b")bar"'\''|json -b4'
echo -n 'r"bar()b")bar"'|json -b4 2>&1 ||
echo 'command failed: echo -n '\''r"bar()b")bar"'\''|json -b4'

echo '$ echo -n '\''r"bar()b")bar"'\''|json -b5'
echo -n 'r"bar()b")bar"'|json -b5 2>&1 ||
echo 'command failed: echo -n '\''r"bar()b")bar"'\''|json -b5'

echo '$ echo -n '\''r"bar()b")bar"'\''|json -b6'
echo -n 'r"bar()b")bar"'|json -b6 2>&1 ||
echo 'command failed: echo -n '\''r"bar()b")bar"'\''|json -b6'

echo '$ echo -n '\''r"bar()b")bar"'\''|json -b7'
echo -n 'r"bar()b")bar"'|json -b7 2>&1 ||
echo 'command failed: echo -n '\''r"bar()b")bar"'\''|json -b7'

echo '$ echo -n '\''r"bar()b")bar"'\''|json -b8'
echo -n 'r"bar()b")bar"'|json -b8 2>&1 ||
echo 'command failed: echo -n '\''r"bar()b")bar"'\''|json -b8'

echo '$ echo -n '\''r"bar()b")bar"'\''|json -b9'
echo -n 'r"bar()b")bar"'|json -b9 2>&1 ||
echo 'command failed: echo -n '\''r"bar()b")bar"'\''|json -b9'

echo '$ echo -n '\''r"bar()b")bar"'\''|json -b10'
echo -n 'r"bar()b")bar"'|json -b10 2>&1 ||
echo 'command failed: echo -n '\''r"bar()b")bar"'\''|json -b10'

echo '$ echo -n '\''r"bar()b")bar"'\''|json -b11'
echo -n 'r"bar()b")bar"'|json -b11 2>&1 ||
echo 'command failed: echo -n '\''r"bar()b")bar"'\''|json -b11'

echo '$ echo -n '\''r"bar()b")bar"'\''|json -b12'
echo -n 'r"bar()b")bar"'|json -b12 2>&1 ||
echo 'command failed: echo -n '\''r"bar()b")bar"'\''|json -b12'

echo '$ echo -n '\''r"bar()b")bar"'\''|json -b13'
echo -n 'r"bar()b")bar"'|json -b13 2>&1 ||
echo 'command failed: echo -n '\''r"bar()b")bar"'\''|json -b13'

echo '$ echo -n '\''r"bar()b")bar"'\''|json -b14'
echo -n 'r"bar()b")bar"'|json -b14 2>&1 ||
echo 'command failed: echo -n '\''r"bar()b")bar"'\''|json -b14'

echo '$ echo -n '\''r"bar()ba")bar"'\''|json -b1'
echo -n 'r"bar()ba")bar"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"bar()ba")bar"'\''|json -b1'

echo '$ echo -n '\''r"bar()ba")bar"'\''|json -b2'
echo -n 'r"bar()ba")bar"'|json -b2 2>&1 ||
echo 'command failed: echo -n '\''r"bar()ba")bar"'\''|json -b2'

echo '$ echo -n '\''r"bar()ba")bar"'\''|json -b3'
echo -n 'r"bar()ba")bar"'|json -b3 2>&1 ||
echo 'command failed: echo -n '\''r"bar()ba")bar"'\''|json -b3'

echo '$ echo -n '\''r"bar()ba")bar"'\''|json -b4'
echo -n 'r"bar()ba")bar"'|json -b4 2>&1 ||
echo 'command failed: echo -n '\''r"bar()ba")bar"'\''|json -b4'

echo '$ echo -n '\''r"bar()ba")bar"'\''|json -b5'
echo -n 'r"bar()ba")bar"'|json -b5 2>&1 ||
echo 'command failed: echo -n '\''r"bar()ba")bar"'\''|json -b5'

echo '$ echo -n '\''r"bar()ba")bar"'\''|json -b6'
echo -n 'r"bar()ba")bar"'|json -b6 2>&1 ||
echo 'command failed: echo -n '\''r"bar()ba")bar"'\''|json -b6'

echo '$ echo -n '\''r"bar()ba")bar"'\''|json -b7'
echo -n 'r"bar()ba")bar"'|json -b7 2>&1 ||
echo 'command failed: echo -n '\''r"bar()ba")bar"'\''|json -b7'

echo '$ echo -n '\''r"bar()ba")bar"'\''|json -b8'
echo -n 'r"bar()ba")bar"'|json -b8 2>&1 ||
echo 'command failed: echo -n '\''r"bar()ba")bar"'\''|json -b8'

echo '$ echo -n '\''r"bar()ba")bar"'\''|json -b9'
echo -n 'r"bar()ba")bar"'|json -b9 2>&1 ||
echo 'command failed: echo -n '\''r"bar()ba")bar"'\''|json -b9'

echo '$ echo -n '\''r"bar()ba")bar"'\''|json -b10'
echo -n 'r"bar()ba")bar"'|json -b10 2>&1 ||
echo 'command failed: echo -n '\''r"bar()ba")bar"'\''|json -b10'

echo '$ echo -n '\''r"bar()ba")bar"'\''|json -b11'
echo -n 'r"bar()ba")bar"'|json -b11 2>&1 ||
echo 'command failed: echo -n '\''r"bar()ba")bar"'\''|json -b11'

echo '$ echo -n '\''r"bar()ba")bar"'\''|json -b12'
echo -n 'r"bar()ba")bar"'|json -b12 2>&1 ||
echo 'command failed: echo -n '\''r"bar()ba")bar"'\''|json -b12'

echo '$ echo -n '\''r"bar()ba")bar"'\''|json -b13'
echo -n 'r"bar()ba")bar"'|json -b13 2>&1 ||
echo 'command failed: echo -n '\''r"bar()ba")bar"'\''|json -b13'

echo '$ echo -n '\''r"bar()ba")bar"'\''|json -b14'
echo -n 'r"bar()ba")bar"'|json -b14 2>&1 ||
echo 'command failed: echo -n '\''r"bar()ba")bar"'\''|json -b14'

echo '$ echo -n '\''r"bar()ba")bar"'\''|json -b15'
echo -n 'r"bar()ba")bar"'|json -b15 2>&1 ||
echo 'command failed: echo -n '\''r"bar()ba")bar"'\''|json -b15'

echo '$ echo -n '\''r"bar()bar")bar"'\''|json -b1'
echo -n 'r"bar()bar")bar"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"bar()bar")bar"'\''|json -b1'

echo '$ echo -n '\''r"bar()bar")bar"'\''|json -b2'
echo -n 'r"bar()bar")bar"'|json -b2 2>&1 ||
echo 'command failed: echo -n '\''r"bar()bar")bar"'\''|json -b2'

echo '$ echo -n '\''r"bar()bar")bar"'\''|json -b3'
echo -n 'r"bar()bar")bar"'|json -b3 2>&1 ||
echo 'command failed: echo -n '\''r"bar()bar")bar"'\''|json -b3'

echo '$ echo -n '\''r"bar()bar")bar"'\''|json -b4'
echo -n 'r"bar()bar")bar"'|json -b4 2>&1 ||
echo 'command failed: echo -n '\''r"bar()bar")bar"'\''|json -b4'

echo '$ echo -n '\''r"bar()bar")bar"'\''|json -b5'
echo -n 'r"bar()bar")bar"'|json -b5 2>&1 ||
echo 'command failed: echo -n '\''r"bar()bar")bar"'\''|json -b5'

echo '$ echo -n '\''r"bar()bar")bar"'\''|json -b6'
echo -n 'r"bar()bar")bar"'|json -b6 2>&1 ||
echo 'command failed: echo -n '\''r"bar()bar")bar"'\''|json -b6'

echo '$ echo -n '\''r"bar()bar")bar"'\''|json -b7'
echo -n 'r"bar()bar")bar"'|json -b7 2>&1 ||
echo 'command failed: echo -n '\''r"bar()bar")bar"'\''|json -b7'

echo '$ echo -n '\''r"bar()bar")bar"'\''|json -b8'
echo -n 'r"bar()bar")bar"'|json -b8 2>&1 ||
echo 'command failed: echo -n '\''r"bar()bar")bar"'\''|json -b8'

echo '$ echo -n '\''r"bar()bar")bar"'\''|json -b9'
echo -n 'r"bar()bar")bar"'|json -b9 2>&1 ||
echo 'command failed: echo -n '\''r"bar()bar")bar"'\''|json -b9'

echo '$ echo -n '\''r"bar()bar")bar"'\''|json -b10'
echo -n 'r"bar()bar")bar"'|json -b10 2>&1 ||
echo 'command failed: echo -n '\''r"bar()bar")bar"'\''|json -b10'

echo '$ echo -n '\''r"bar()bar")bar"'\''|json -b11'
echo -n 'r"bar()bar")bar"'|json -b11 2>&1 ||
echo 'command failed: echo -n '\''r"bar()bar")bar"'\''|json -b11'

echo '$ echo -n '\''r"bar()bar")bar"'\''|json -b12'
echo -n 'r"bar()bar")bar"'|json -b12 2>&1 ||
echo 'command failed: echo -n '\''r"bar()bar")bar"'\''|json -b12'

echo '$ echo -n '\''r"bar()bar")bar"'\''|json -b13'
echo -n 'r"bar()bar")bar"'|json -b13 2>&1 ||
echo 'command failed: echo -n '\''r"bar()bar")bar"'\''|json -b13'

echo '$ echo -n '\''r"bar()bar")bar"'\''|json -b14'
echo -n 'r"bar()bar")bar"'|json -b14 2>&1 ||
echo 'command failed: echo -n '\''r"bar()bar")bar"'\''|json -b14'

echo '$ echo -n '\''r"bar()bar")bar"'\''|json -b15'
echo -n 'r"bar()bar")bar"'|json -b15 2>&1 ||
echo 'command failed: echo -n '\''r"bar()bar")bar"'\''|json -b15'

echo '$ echo -n '\''r"bar()bar")bar"'\''|json -b16'
echo -n 'r"bar()bar")bar"'|json -b16 2>&1 ||
echo 'command failed: echo -n '\''r"bar()bar")bar"'\''|json -b16'

echo '$ echo -n '\''r"0123456789abcdef()")0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef()")0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()")0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()")0123456789abcdef"'\''|json -b2'
echo -n 'r"0123456789abcdef()")0123456789abcdef"'|json -b2 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()")0123456789abcdef"'\''|json -b2'

echo '$ echo -n '\''r"0123456789abcdef()")0123456789abcdef"'\''|json -b4'
echo -n 'r"0123456789abcdef()")0123456789abcdef"'|json -b4 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()")0123456789abcdef"'\''|json -b4'

echo '$ echo -n '\''r"0123456789abcdef()")0123456789abcdef"'\''|json -b8'
echo -n 'r"0123456789abcdef()")0123456789abcdef"'|json -b8 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()")0123456789abcdef"'\''|json -b8'

echo '$ echo -n '\''r"0123456789abcdef()")0123456789abcdef"'\''|json -b16'
echo -n 'r"0123456789abcdef()")0123456789abcdef"'|json -b16 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()")0123456789abcdef"'\''|json -b16'

echo '$ echo -n '\''r"0123456789abcdef()")0123456789abcdef"'\''|json -b32'
echo -n 'r"0123456789abcdef()")0123456789abcdef"'|json -b32 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()")0123456789abcdef"'\''|json -b32'

echo '$ echo -n '\''r"0123456789abcdef()0")0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef()0")0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0")0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0")0123456789abcdef"'\''|json -b2'
echo -n 'r"0123456789abcdef()0")0123456789abcdef"'|json -b2 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0")0123456789abcdef"'\''|json -b2'

echo '$ echo -n '\''r"0123456789abcdef()0")0123456789abcdef"'\''|json -b4'
echo -n 'r"0123456789abcdef()0")0123456789abcdef"'|json -b4 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0")0123456789abcdef"'\''|json -b4'

echo '$ echo -n '\''r"0123456789abcdef()0")0123456789abcdef"'\''|json -b8'
echo -n 'r"0123456789abcdef()0")0123456789abcdef"'|json -b8 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0")0123456789abcdef"'\''|json -b8'

echo '$ echo -n '\''r"0123456789abcdef()0")0123456789abcdef"'\''|json -b16'
echo -n 'r"0123456789abcdef()0")0123456789abcdef"'|json -b16 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0")0123456789abcdef"'\''|json -b16'

echo '$ echo -n '\''r"0123456789abcdef()0")0123456789abcdef"'\''|json -b32'
echo -n 'r"0123456789abcdef()0")0123456789abcdef"'|json -b32 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0")0123456789abcdef"'\''|json -b32'

echo '$ echo -n '\''r"0123456789abcdef()01")0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef()01")0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01")0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()01")0123456789abcdef"'\''|json -b2'
echo -n 'r"0123456789abcdef()01")0123456789abcdef"'|json -b2 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01")0123456789abcdef"'\''|json -b2'

echo '$ echo -n '\''r"0123456789abcdef()01")0123456789abcdef"'\''|json -b4'
echo -n 'r"0123456789abcdef()01")0123456789abcdef"'|json -b4 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01")0123456789abcdef"'\''|json -b4'

echo '$ echo -n '\''r"0123456789abcdef()01")0123456789abcdef"'\''|json -b8'
echo -n 'r"0123456789abcdef()01")0123456789abcdef"'|json -b8 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01")0123456789abcdef"'\''|json -b8'

echo '$ echo -n '\''r"0123456789abcdef()01")0123456789abcdef"'\''|json -b16'
echo -n 'r"0123456789abcdef()01")0123456789abcdef"'|json -b16 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01")0123456789abcdef"'\''|json -b16'

echo '$ echo -n '\''r"0123456789abcdef()01")0123456789abcdef"'\''|json -b32'
echo -n 'r"0123456789abcdef()01")0123456789abcdef"'|json -b32 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01")0123456789abcdef"'\''|json -b32'

echo '$ echo -n '\''r"0123456789abcdef()012")0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef()012")0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012")0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()012")0123456789abcdef"'\''|json -b2'
echo -n 'r"0123456789abcdef()012")0123456789abcdef"'|json -b2 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012")0123456789abcdef"'\''|json -b2'

echo '$ echo -n '\''r"0123456789abcdef()012")0123456789abcdef"'\''|json -b4'
echo -n 'r"0123456789abcdef()012")0123456789abcdef"'|json -b4 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012")0123456789abcdef"'\''|json -b4'

echo '$ echo -n '\''r"0123456789abcdef()012")0123456789abcdef"'\''|json -b8'
echo -n 'r"0123456789abcdef()012")0123456789abcdef"'|json -b8 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012")0123456789abcdef"'\''|json -b8'

echo '$ echo -n '\''r"0123456789abcdef()012")0123456789abcdef"'\''|json -b16'
echo -n 'r"0123456789abcdef()012")0123456789abcdef"'|json -b16 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012")0123456789abcdef"'\''|json -b16'

echo '$ echo -n '\''r"0123456789abcdef()012")0123456789abcdef"'\''|json -b32'
echo -n 'r"0123456789abcdef()012")0123456789abcdef"'|json -b32 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012")0123456789abcdef"'\''|json -b32'

echo '$ echo -n '\''r"0123456789abcdef()0123")0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef()0123")0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123")0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123")0123456789abcdef"'\''|json -b2'
echo -n 'r"0123456789abcdef()0123")0123456789abcdef"'|json -b2 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123")0123456789abcdef"'\''|json -b2'

echo '$ echo -n '\''r"0123456789abcdef()0123")0123456789abcdef"'\''|json -b4'
echo -n 'r"0123456789abcdef()0123")0123456789abcdef"'|json -b4 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123")0123456789abcdef"'\''|json -b4'

echo '$ echo -n '\''r"0123456789abcdef()0123")0123456789abcdef"'\''|json -b8'
echo -n 'r"0123456789abcdef()0123")0123456789abcdef"'|json -b8 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123")0123456789abcdef"'\''|json -b8'

echo '$ echo -n '\''r"0123456789abcdef()0123")0123456789abcdef"'\''|json -b16'
echo -n 'r"0123456789abcdef()0123")0123456789abcdef"'|json -b16 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123")0123456789abcdef"'\''|json -b16'

echo '$ echo -n '\''r"0123456789abcdef()0123")0123456789abcdef"'\''|json -b32'
echo -n 'r"0123456789abcdef()0123")0123456789abcdef"'|json -b32 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123")0123456789abcdef"'\''|json -b32'

echo '$ echo -n '\''r"0123456789abcdef()01234")0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef()01234")0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01234")0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()01234")0123456789abcdef"'\''|json -b2'
echo -n 'r"0123456789abcdef()01234")0123456789abcdef"'|json -b2 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01234")0123456789abcdef"'\''|json -b2'

echo '$ echo -n '\''r"0123456789abcdef()01234")0123456789abcdef"'\''|json -b4'
echo -n 'r"0123456789abcdef()01234")0123456789abcdef"'|json -b4 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01234")0123456789abcdef"'\''|json -b4'

echo '$ echo -n '\''r"0123456789abcdef()01234")0123456789abcdef"'\''|json -b8'
echo -n 'r"0123456789abcdef()01234")0123456789abcdef"'|json -b8 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01234")0123456789abcdef"'\''|json -b8'

echo '$ echo -n '\''r"0123456789abcdef()01234")0123456789abcdef"'\''|json -b16'
echo -n 'r"0123456789abcdef()01234")0123456789abcdef"'|json -b16 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01234")0123456789abcdef"'\''|json -b16'

echo '$ echo -n '\''r"0123456789abcdef()01234")0123456789abcdef"'\''|json -b32'
echo -n 'r"0123456789abcdef()01234")0123456789abcdef"'|json -b32 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01234")0123456789abcdef"'\''|json -b32'

echo '$ echo -n '\''r"0123456789abcdef()012345")0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef()012345")0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012345")0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()012345")0123456789abcdef"'\''|json -b2'
echo -n 'r"0123456789abcdef()012345")0123456789abcdef"'|json -b2 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012345")0123456789abcdef"'\''|json -b2'

echo '$ echo -n '\''r"0123456789abcdef()012345")0123456789abcdef"'\''|json -b4'
echo -n 'r"0123456789abcdef()012345")0123456789abcdef"'|json -b4 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012345")0123456789abcdef"'\''|json -b4'

echo '$ echo -n '\''r"0123456789abcdef()012345")0123456789abcdef"'\''|json -b8'
echo -n 'r"0123456789abcdef()012345")0123456789abcdef"'|json -b8 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012345")0123456789abcdef"'\''|json -b8'

echo '$ echo -n '\''r"0123456789abcdef()012345")0123456789abcdef"'\''|json -b16'
echo -n 'r"0123456789abcdef()012345")0123456789abcdef"'|json -b16 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012345")0123456789abcdef"'\''|json -b16'

echo '$ echo -n '\''r"0123456789abcdef()012345")0123456789abcdef"'\''|json -b32'
echo -n 'r"0123456789abcdef()012345")0123456789abcdef"'|json -b32 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012345")0123456789abcdef"'\''|json -b32'

echo '$ echo -n '\''r"0123456789abcdef()0123456")0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456")0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456")0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456")0123456789abcdef"'\''|json -b2'
echo -n 'r"0123456789abcdef()0123456")0123456789abcdef"'|json -b2 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456")0123456789abcdef"'\''|json -b2'

echo '$ echo -n '\''r"0123456789abcdef()0123456")0123456789abcdef"'\''|json -b4'
echo -n 'r"0123456789abcdef()0123456")0123456789abcdef"'|json -b4 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456")0123456789abcdef"'\''|json -b4'

echo '$ echo -n '\''r"0123456789abcdef()0123456")0123456789abcdef"'\''|json -b8'
echo -n 'r"0123456789abcdef()0123456")0123456789abcdef"'|json -b8 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456")0123456789abcdef"'\''|json -b8'

echo '$ echo -n '\''r"0123456789abcdef()0123456")0123456789abcdef"'\''|json -b16'
echo -n 'r"0123456789abcdef()0123456")0123456789abcdef"'|json -b16 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456")0123456789abcdef"'\''|json -b16'

echo '$ echo -n '\''r"0123456789abcdef()0123456")0123456789abcdef"'\''|json -b32'
echo -n 'r"0123456789abcdef()0123456")0123456789abcdef"'|json -b32 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456")0123456789abcdef"'\''|json -b32'

echo '$ echo -n '\''r"0123456789abcdef()01234567")0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef()01234567")0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01234567")0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()01234567")0123456789abcdef"'\''|json -b2'
echo -n 'r"0123456789abcdef()01234567")0123456789abcdef"'|json -b2 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01234567")0123456789abcdef"'\''|json -b2'

echo '$ echo -n '\''r"0123456789abcdef()01234567")0123456789abcdef"'\''|json -b4'
echo -n 'r"0123456789abcdef()01234567")0123456789abcdef"'|json -b4 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01234567")0123456789abcdef"'\''|json -b4'

echo '$ echo -n '\''r"0123456789abcdef()01234567")0123456789abcdef"'\''|json -b8'
echo -n 'r"0123456789abcdef()01234567")0123456789abcdef"'|json -b8 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01234567")0123456789abcdef"'\''|json -b8'

echo '$ echo -n '\''r"0123456789abcdef()01234567")0123456789abcdef"'\''|json -b16'
echo -n 'r"0123456789abcdef()01234567")0123456789abcdef"'|json -b16 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01234567")0123456789abcdef"'\''|json -b16'

echo '$ echo -n '\''r"0123456789abcdef()01234567")0123456789abcdef"'\''|json -b32'
echo -n 'r"0123456789abcdef()01234567")0123456789abcdef"'|json -b32 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01234567")0123456789abcdef"'\''|json -b32'

echo '$ echo -n '\''r"0123456789abcdef()012345678")0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef()012345678")0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012345678")0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()012345678")0123456789abcdef"'\''|json -b2'
echo -n 'r"0123456789abcdef()012345678")0123456789abcdef"'|json -b2 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012345678")0123456789abcdef"'\''|json -b2'

echo '$ echo -n '\''r"0123456789abcdef()012345678")0123456789abcdef"'\''|json -b4'
echo -n 'r"0123456789abcdef()012345678")0123456789abcdef"'|json -b4 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012345678")0123456789abcdef"'\''|json -b4'

echo '$ echo -n '\''r"0123456789abcdef()012345678")0123456789abcdef"'\''|json -b8'
echo -n 'r"0123456789abcdef()012345678")0123456789abcdef"'|json -b8 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012345678")0123456789abcdef"'\''|json -b8'

echo '$ echo -n '\''r"0123456789abcdef()012345678")0123456789abcdef"'\''|json -b16'
echo -n 'r"0123456789abcdef()012345678")0123456789abcdef"'|json -b16 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012345678")0123456789abcdef"'\''|json -b16'

echo '$ echo -n '\''r"0123456789abcdef()012345678")0123456789abcdef"'\''|json -b32'
echo -n 'r"0123456789abcdef()012345678")0123456789abcdef"'|json -b32 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012345678")0123456789abcdef"'\''|json -b32'

echo '$ echo -n '\''r"0123456789abcdef()0123456789")0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789")0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789")0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789")0123456789abcdef"'\''|json -b2'
echo -n 'r"0123456789abcdef()0123456789")0123456789abcdef"'|json -b2 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789")0123456789abcdef"'\''|json -b2'

echo '$ echo -n '\''r"0123456789abcdef()0123456789")0123456789abcdef"'\''|json -b4'
echo -n 'r"0123456789abcdef()0123456789")0123456789abcdef"'|json -b4 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789")0123456789abcdef"'\''|json -b4'

echo '$ echo -n '\''r"0123456789abcdef()0123456789")0123456789abcdef"'\''|json -b8'
echo -n 'r"0123456789abcdef()0123456789")0123456789abcdef"'|json -b8 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789")0123456789abcdef"'\''|json -b8'

echo '$ echo -n '\''r"0123456789abcdef()0123456789")0123456789abcdef"'\''|json -b16'
echo -n 'r"0123456789abcdef()0123456789")0123456789abcdef"'|json -b16 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789")0123456789abcdef"'\''|json -b16'

echo '$ echo -n '\''r"0123456789abcdef()0123456789")0123456789abcdef"'\''|json -b32'
echo -n 'r"0123456789abcdef()0123456789")0123456789abcdef"'|json -b32 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789")0123456789abcdef"'\''|json -b32'

echo '$ echo -n '\''r"0123456789abcdef()0123456789a")0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789a")0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789a")0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789a")0123456789abcdef"'\''|json -b2'
echo -n 'r"0123456789abcdef()0123456789a")0123456789abcdef"'|json -b2 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789a")0123456789abcdef"'\''|json -b2'

echo '$ echo -n '\''r"0123456789abcdef()0123456789a")0123456789abcdef"'\''|json -b4'
echo -n 'r"0123456789abcdef()0123456789a")0123456789abcdef"'|json -b4 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789a")0123456789abcdef"'\''|json -b4'

echo '$ echo -n '\''r"0123456789abcdef()0123456789a")0123456789abcdef"'\''|json -b8'
echo -n 'r"0123456789abcdef()0123456789a")0123456789abcdef"'|json -b8 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789a")0123456789abcdef"'\''|json -b8'

echo '$ echo -n '\''r"0123456789abcdef()0123456789a")0123456789abcdef"'\''|json -b16'
echo -n 'r"0123456789abcdef()0123456789a")0123456789abcdef"'|json -b16 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789a")0123456789abcdef"'\''|json -b16'

echo '$ echo -n '\''r"0123456789abcdef()0123456789a")0123456789abcdef"'\''|json -b32'
echo -n 'r"0123456789abcdef()0123456789a")0123456789abcdef"'|json -b32 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789a")0123456789abcdef"'\''|json -b32'

echo '$ echo -n '\''r"0123456789abcdef()0123456789ab")0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789ab")0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789ab")0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789ab")0123456789abcdef"'\''|json -b2'
echo -n 'r"0123456789abcdef()0123456789ab")0123456789abcdef"'|json -b2 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789ab")0123456789abcdef"'\''|json -b2'

echo '$ echo -n '\''r"0123456789abcdef()0123456789ab")0123456789abcdef"'\''|json -b4'
echo -n 'r"0123456789abcdef()0123456789ab")0123456789abcdef"'|json -b4 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789ab")0123456789abcdef"'\''|json -b4'

echo '$ echo -n '\''r"0123456789abcdef()0123456789ab")0123456789abcdef"'\''|json -b8'
echo -n 'r"0123456789abcdef()0123456789ab")0123456789abcdef"'|json -b8 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789ab")0123456789abcdef"'\''|json -b8'

echo '$ echo -n '\''r"0123456789abcdef()0123456789ab")0123456789abcdef"'\''|json -b16'
echo -n 'r"0123456789abcdef()0123456789ab")0123456789abcdef"'|json -b16 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789ab")0123456789abcdef"'\''|json -b16'

echo '$ echo -n '\''r"0123456789abcdef()0123456789ab")0123456789abcdef"'\''|json -b32'
echo -n 'r"0123456789abcdef()0123456789ab")0123456789abcdef"'|json -b32 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789ab")0123456789abcdef"'\''|json -b32'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abc")0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abc")0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abc")0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abc")0123456789abcdef"'\''|json -b2'
echo -n 'r"0123456789abcdef()0123456789abc")0123456789abcdef"'|json -b2 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abc")0123456789abcdef"'\''|json -b2'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abc")0123456789abcdef"'\''|json -b4'
echo -n 'r"0123456789abcdef()0123456789abc")0123456789abcdef"'|json -b4 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abc")0123456789abcdef"'\''|json -b4'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abc")0123456789abcdef"'\''|json -b8'
echo -n 'r"0123456789abcdef()0123456789abc")0123456789abcdef"'|json -b8 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abc")0123456789abcdef"'\''|json -b8'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abc")0123456789abcdef"'\''|json -b16'
echo -n 'r"0123456789abcdef()0123456789abc")0123456789abcdef"'|json -b16 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abc")0123456789abcdef"'\''|json -b16'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abc")0123456789abcdef"'\''|json -b32'
echo -n 'r"0123456789abcdef()0123456789abc")0123456789abcdef"'|json -b32 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abc")0123456789abcdef"'\''|json -b32'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcd")0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abcd")0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcd")0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcd")0123456789abcdef"'\''|json -b2'
echo -n 'r"0123456789abcdef()0123456789abcd")0123456789abcdef"'|json -b2 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcd")0123456789abcdef"'\''|json -b2'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcd")0123456789abcdef"'\''|json -b4'
echo -n 'r"0123456789abcdef()0123456789abcd")0123456789abcdef"'|json -b4 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcd")0123456789abcdef"'\''|json -b4'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcd")0123456789abcdef"'\''|json -b8'
echo -n 'r"0123456789abcdef()0123456789abcd")0123456789abcdef"'|json -b8 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcd")0123456789abcdef"'\''|json -b8'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcd")0123456789abcdef"'\''|json -b16'
echo -n 'r"0123456789abcdef()0123456789abcd")0123456789abcdef"'|json -b16 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcd")0123456789abcdef"'\''|json -b16'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcd")0123456789abcdef"'\''|json -b32'
echo -n 'r"0123456789abcdef()0123456789abcd")0123456789abcdef"'|json -b32 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcd")0123456789abcdef"'\''|json -b32'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcde")0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abcde")0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcde")0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcde")0123456789abcdef"'\''|json -b2'
echo -n 'r"0123456789abcdef()0123456789abcde")0123456789abcdef"'|json -b2 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcde")0123456789abcdef"'\''|json -b2'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcde")0123456789abcdef"'\''|json -b4'
echo -n 'r"0123456789abcdef()0123456789abcde")0123456789abcdef"'|json -b4 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcde")0123456789abcdef"'\''|json -b4'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcde")0123456789abcdef"'\''|json -b8'
echo -n 'r"0123456789abcdef()0123456789abcde")0123456789abcdef"'|json -b8 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcde")0123456789abcdef"'\''|json -b8'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcde")0123456789abcdef"'\''|json -b16'
echo -n 'r"0123456789abcdef()0123456789abcde")0123456789abcdef"'|json -b16 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcde")0123456789abcdef"'\''|json -b16'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcde")0123456789abcdef"'\''|json -b32'
echo -n 'r"0123456789abcdef()0123456789abcde")0123456789abcdef"'|json -b32 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcde")0123456789abcdef"'\''|json -b32'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcdef")0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abcdef")0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcdef")0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcdef")0123456789abcdef"'\''|json -b2'
echo -n 'r"0123456789abcdef()0123456789abcdef")0123456789abcdef"'|json -b2 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcdef")0123456789abcdef"'\''|json -b2'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcdef")0123456789abcdef"'\''|json -b4'
echo -n 'r"0123456789abcdef()0123456789abcdef")0123456789abcdef"'|json -b4 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcdef")0123456789abcdef"'\''|json -b4'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcdef")0123456789abcdef"'\''|json -b8'
echo -n 'r"0123456789abcdef()0123456789abcdef")0123456789abcdef"'|json -b8 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcdef")0123456789abcdef"'\''|json -b8'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcdef")0123456789abcdef"'\''|json -b16'
echo -n 'r"0123456789abcdef()0123456789abcdef")0123456789abcdef"'|json -b16 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcdef")0123456789abcdef"'\''|json -b16'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcdef")0123456789abcdef"'\''|json -b32'
echo -n 'r"0123456789abcdef()0123456789abcdef")0123456789abcdef"'|json -b32 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcdef")0123456789abcdef"'\''|json -b32'

echo '$ echo -n '\''r"(foo)")"'\''|json -b1'
echo -n 'r"(foo)")"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"(foo)")"'\''|json -b1'

echo '$ echo -n '\''r"(foo)")"'\''|json -b2'
echo -n 'r"(foo)")"'|json -b2 2>&1 ||
echo 'command failed: echo -n '\''r"(foo)")"'\''|json -b2'

echo '$ echo -n '\''r"(foo)")"'\''|json -b3'
echo -n 'r"(foo)")"'|json -b3 2>&1 ||
echo 'command failed: echo -n '\''r"(foo)")"'\''|json -b3'

echo '$ echo -n '\''r"(foo)")"'\''|json -b4'
echo -n 'r"(foo)")"'|json -b4 2>&1 ||
echo 'command failed: echo -n '\''r"(foo)")"'\''|json -b4'

echo '$ echo -n '\''r"(foo)")"'\''|json -b5'
echo -n 'r"(foo)")"'|json -b5 2>&1 ||
echo 'command failed: echo -n '\''r"(foo)")"'\''|json -b5'

echo '$ echo -n '\''r"(foo)")"'\''|json -b6'
echo -n 'r"(foo)")"'|json -b6 2>&1 ||
echo 'command failed: echo -n '\''r"(foo)")"'\''|json -b6'

echo '$ echo -n '\''r"(foo)")"'\''|json -b7'
echo -n 'r"(foo)")"'|json -b7 2>&1 ||
echo 'command failed: echo -n '\''r"(foo)")"'\''|json -b7'

echo '$ echo -n '\''r"(foo)")"'\''|json -b8'
echo -n 'r"(foo)")"'|json -b8 2>&1 ||
echo 'command failed: echo -n '\''r"(foo)")"'\''|json -b8'

echo '$ echo -n '\''r"(foo)")"'\''|json -b9'
echo -n 'r"(foo)")"'|json -b9 2>&1 ||
echo 'command failed: echo -n '\''r"(foo)")"'\''|json -b9'

echo '$ echo -n '\''r"(foo)")"'\''|json -b10'
echo -n 'r"(foo)")"'|json -b10 2>&1 ||
echo 'command failed: echo -n '\''r"(foo)")"'\''|json -b10'

echo '$ echo -n '\''r"bar(foo)")bar"'\''|json -b1'
echo -n 'r"bar(foo)")bar"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)")bar"'\''|json -b1'

echo '$ echo -n '\''r"bar(foo)")bar"'\''|json -b2'
echo -n 'r"bar(foo)")bar"'|json -b2 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)")bar"'\''|json -b2'

echo '$ echo -n '\''r"bar(foo)")bar"'\''|json -b3'
echo -n 'r"bar(foo)")bar"'|json -b3 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)")bar"'\''|json -b3'

echo '$ echo -n '\''r"bar(foo)")bar"'\''|json -b4'
echo -n 'r"bar(foo)")bar"'|json -b4 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)")bar"'\''|json -b4'

echo '$ echo -n '\''r"bar(foo)")bar"'\''|json -b5'
echo -n 'r"bar(foo)")bar"'|json -b5 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)")bar"'\''|json -b5'

echo '$ echo -n '\''r"bar(foo)")bar"'\''|json -b6'
echo -n 'r"bar(foo)")bar"'|json -b6 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)")bar"'\''|json -b6'

echo '$ echo -n '\''r"bar(foo)")bar"'\''|json -b7'
echo -n 'r"bar(foo)")bar"'|json -b7 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)")bar"'\''|json -b7'

echo '$ echo -n '\''r"bar(foo)")bar"'\''|json -b8'
echo -n 'r"bar(foo)")bar"'|json -b8 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)")bar"'\''|json -b8'

echo '$ echo -n '\''r"bar(foo)")bar"'\''|json -b9'
echo -n 'r"bar(foo)")bar"'|json -b9 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)")bar"'\''|json -b9'

echo '$ echo -n '\''r"bar(foo)")bar"'\''|json -b10'
echo -n 'r"bar(foo)")bar"'|json -b10 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)")bar"'\''|json -b10'

echo '$ echo -n '\''r"bar(foo)")bar"'\''|json -b11'
echo -n 'r"bar(foo)")bar"'|json -b11 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)")bar"'\''|json -b11'

echo '$ echo -n '\''r"bar(foo)")bar"'\''|json -b12'
echo -n 'r"bar(foo)")bar"'|json -b12 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)")bar"'\''|json -b12'

echo '$ echo -n '\''r"bar(foo)")bar"'\''|json -b13'
echo -n 'r"bar(foo)")bar"'|json -b13 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)")bar"'\''|json -b13'

echo '$ echo -n '\''r"bar(foo)")bar"'\''|json -b14'
echo -n 'r"bar(foo)")bar"'|json -b14 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)")bar"'\''|json -b14'

echo '$ echo -n '\''r"bar(foo)")bar"'\''|json -b15'
echo -n 'r"bar(foo)")bar"'|json -b15 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)")bar"'\''|json -b15'

echo '$ echo -n '\''r"bar(foo)")bar"'\''|json -b16'
echo -n 'r"bar(foo)")bar"'|json -b16 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)")bar"'\''|json -b16'

echo '$ echo -n '\''r"bar(foo)b")bar"'\''|json -b1'
echo -n 'r"bar(foo)b")bar"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)b")bar"'\''|json -b1'

echo '$ echo -n '\''r"bar(foo)b")bar"'\''|json -b2'
echo -n 'r"bar(foo)b")bar"'|json -b2 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)b")bar"'\''|json -b2'

echo '$ echo -n '\''r"bar(foo)b")bar"'\''|json -b3'
echo -n 'r"bar(foo)b")bar"'|json -b3 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)b")bar"'\''|json -b3'

echo '$ echo -n '\''r"bar(foo)b")bar"'\''|json -b4'
echo -n 'r"bar(foo)b")bar"'|json -b4 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)b")bar"'\''|json -b4'

echo '$ echo -n '\''r"bar(foo)b")bar"'\''|json -b5'
echo -n 'r"bar(foo)b")bar"'|json -b5 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)b")bar"'\''|json -b5'

echo '$ echo -n '\''r"bar(foo)b")bar"'\''|json -b6'
echo -n 'r"bar(foo)b")bar"'|json -b6 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)b")bar"'\''|json -b6'

echo '$ echo -n '\''r"bar(foo)b")bar"'\''|json -b7'
echo -n 'r"bar(foo)b")bar"'|json -b7 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)b")bar"'\''|json -b7'

echo '$ echo -n '\''r"bar(foo)b")bar"'\''|json -b8'
echo -n 'r"bar(foo)b")bar"'|json -b8 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)b")bar"'\''|json -b8'

echo '$ echo -n '\''r"bar(foo)b")bar"'\''|json -b9'
echo -n 'r"bar(foo)b")bar"'|json -b9 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)b")bar"'\''|json -b9'

echo '$ echo -n '\''r"bar(foo)b")bar"'\''|json -b10'
echo -n 'r"bar(foo)b")bar"'|json -b10 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)b")bar"'\''|json -b10'

echo '$ echo -n '\''r"bar(foo)b")bar"'\''|json -b11'
echo -n 'r"bar(foo)b")bar"'|json -b11 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)b")bar"'\''|json -b11'

echo '$ echo -n '\''r"bar(foo)b")bar"'\''|json -b12'
echo -n 'r"bar(foo)b")bar"'|json -b12 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)b")bar"'\''|json -b12'

echo '$ echo -n '\''r"bar(foo)b")bar"'\''|json -b13'
echo -n 'r"bar(foo)b")bar"'|json -b13 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)b")bar"'\''|json -b13'

echo '$ echo -n '\''r"bar(foo)b")bar"'\''|json -b14'
echo -n 'r"bar(foo)b")bar"'|json -b14 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)b")bar"'\''|json -b14'

echo '$ echo -n '\''r"bar(foo)b")bar"'\''|json -b15'
echo -n 'r"bar(foo)b")bar"'|json -b15 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)b")bar"'\''|json -b15'

echo '$ echo -n '\''r"bar(foo)b")bar"'\''|json -b16'
echo -n 'r"bar(foo)b")bar"'|json -b16 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)b")bar"'\''|json -b16'

echo '$ echo -n '\''r"bar(foo)b")bar"'\''|json -b17'
echo -n 'r"bar(foo)b")bar"'|json -b17 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)b")bar"'\''|json -b17'

echo '$ echo -n '\''r"bar(foo)ba")bar"'\''|json -b1'
echo -n 'r"bar(foo)ba")bar"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)ba")bar"'\''|json -b1'

echo '$ echo -n '\''r"bar(foo)ba")bar"'\''|json -b2'
echo -n 'r"bar(foo)ba")bar"'|json -b2 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)ba")bar"'\''|json -b2'

echo '$ echo -n '\''r"bar(foo)ba")bar"'\''|json -b3'
echo -n 'r"bar(foo)ba")bar"'|json -b3 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)ba")bar"'\''|json -b3'

echo '$ echo -n '\''r"bar(foo)ba")bar"'\''|json -b4'
echo -n 'r"bar(foo)ba")bar"'|json -b4 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)ba")bar"'\''|json -b4'

echo '$ echo -n '\''r"bar(foo)ba")bar"'\''|json -b5'
echo -n 'r"bar(foo)ba")bar"'|json -b5 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)ba")bar"'\''|json -b5'

echo '$ echo -n '\''r"bar(foo)ba")bar"'\''|json -b6'
echo -n 'r"bar(foo)ba")bar"'|json -b6 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)ba")bar"'\''|json -b6'

echo '$ echo -n '\''r"bar(foo)ba")bar"'\''|json -b7'
echo -n 'r"bar(foo)ba")bar"'|json -b7 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)ba")bar"'\''|json -b7'

echo '$ echo -n '\''r"bar(foo)ba")bar"'\''|json -b8'
echo -n 'r"bar(foo)ba")bar"'|json -b8 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)ba")bar"'\''|json -b8'

echo '$ echo -n '\''r"bar(foo)ba")bar"'\''|json -b9'
echo -n 'r"bar(foo)ba")bar"'|json -b9 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)ba")bar"'\''|json -b9'

echo '$ echo -n '\''r"bar(foo)ba")bar"'\''|json -b10'
echo -n 'r"bar(foo)ba")bar"'|json -b10 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)ba")bar"'\''|json -b10'

echo '$ echo -n '\''r"bar(foo)ba")bar"'\''|json -b11'
echo -n 'r"bar(foo)ba")bar"'|json -b11 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)ba")bar"'\''|json -b11'

echo '$ echo -n '\''r"bar(foo)ba")bar"'\''|json -b12'
echo -n 'r"bar(foo)ba")bar"'|json -b12 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)ba")bar"'\''|json -b12'

echo '$ echo -n '\''r"bar(foo)ba")bar"'\''|json -b13'
echo -n 'r"bar(foo)ba")bar"'|json -b13 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)ba")bar"'\''|json -b13'

echo '$ echo -n '\''r"bar(foo)ba")bar"'\''|json -b14'
echo -n 'r"bar(foo)ba")bar"'|json -b14 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)ba")bar"'\''|json -b14'

echo '$ echo -n '\''r"bar(foo)ba")bar"'\''|json -b15'
echo -n 'r"bar(foo)ba")bar"'|json -b15 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)ba")bar"'\''|json -b15'

echo '$ echo -n '\''r"bar(foo)ba")bar"'\''|json -b16'
echo -n 'r"bar(foo)ba")bar"'|json -b16 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)ba")bar"'\''|json -b16'

echo '$ echo -n '\''r"bar(foo)ba")bar"'\''|json -b17'
echo -n 'r"bar(foo)ba")bar"'|json -b17 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)ba")bar"'\''|json -b17'

echo '$ echo -n '\''r"bar(foo)ba")bar"'\''|json -b18'
echo -n 'r"bar(foo)ba")bar"'|json -b18 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)ba")bar"'\''|json -b18'

echo '$ echo -n '\''r"bar(foo)bar")bar"'\''|json -b1'
echo -n 'r"bar(foo)bar")bar"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)bar")bar"'\''|json -b1'

echo '$ echo -n '\''r"bar(foo)bar")bar"'\''|json -b2'
echo -n 'r"bar(foo)bar")bar"'|json -b2 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)bar")bar"'\''|json -b2'

echo '$ echo -n '\''r"bar(foo)bar")bar"'\''|json -b3'
echo -n 'r"bar(foo)bar")bar"'|json -b3 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)bar")bar"'\''|json -b3'

echo '$ echo -n '\''r"bar(foo)bar")bar"'\''|json -b4'
echo -n 'r"bar(foo)bar")bar"'|json -b4 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)bar")bar"'\''|json -b4'

echo '$ echo -n '\''r"bar(foo)bar")bar"'\''|json -b5'
echo -n 'r"bar(foo)bar")bar"'|json -b5 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)bar")bar"'\''|json -b5'

echo '$ echo -n '\''r"bar(foo)bar")bar"'\''|json -b6'
echo -n 'r"bar(foo)bar")bar"'|json -b6 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)bar")bar"'\''|json -b6'

echo '$ echo -n '\''r"bar(foo)bar")bar"'\''|json -b7'
echo -n 'r"bar(foo)bar")bar"'|json -b7 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)bar")bar"'\''|json -b7'

echo '$ echo -n '\''r"bar(foo)bar")bar"'\''|json -b8'
echo -n 'r"bar(foo)bar")bar"'|json -b8 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)bar")bar"'\''|json -b8'

echo '$ echo -n '\''r"bar(foo)bar")bar"'\''|json -b9'
echo -n 'r"bar(foo)bar")bar"'|json -b9 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)bar")bar"'\''|json -b9'

echo '$ echo -n '\''r"bar(foo)bar")bar"'\''|json -b10'
echo -n 'r"bar(foo)bar")bar"'|json -b10 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)bar")bar"'\''|json -b10'

echo '$ echo -n '\''r"bar(foo)bar")bar"'\''|json -b11'
echo -n 'r"bar(foo)bar")bar"'|json -b11 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)bar")bar"'\''|json -b11'

echo '$ echo -n '\''r"bar(foo)bar")bar"'\''|json -b12'
echo -n 'r"bar(foo)bar")bar"'|json -b12 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)bar")bar"'\''|json -b12'

echo '$ echo -n '\''r"bar(foo)bar")bar"'\''|json -b13'
echo -n 'r"bar(foo)bar")bar"'|json -b13 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)bar")bar"'\''|json -b13'

echo '$ echo -n '\''r"bar(foo)bar")bar"'\''|json -b14'
echo -n 'r"bar(foo)bar")bar"'|json -b14 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)bar")bar"'\''|json -b14'

echo '$ echo -n '\''r"bar(foo)bar")bar"'\''|json -b15'
echo -n 'r"bar(foo)bar")bar"'|json -b15 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)bar")bar"'\''|json -b15'

echo '$ echo -n '\''r"bar(foo)bar")bar"'\''|json -b16'
echo -n 'r"bar(foo)bar")bar"'|json -b16 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)bar")bar"'\''|json -b16'

echo '$ echo -n '\''r"bar(foo)bar")bar"'\''|json -b17'
echo -n 'r"bar(foo)bar")bar"'|json -b17 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)bar")bar"'\''|json -b17'

echo '$ echo -n '\''r"bar(foo)bar")bar"'\''|json -b18'
echo -n 'r"bar(foo)bar")bar"'|json -b18 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)bar")bar"'\''|json -b18'

echo '$ echo -n '\''r"bar(foo)bar")bar"'\''|json -b19'
echo -n 'r"bar(foo)bar")bar"'|json -b19 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)bar")bar"'\''|json -b19'

echo '$ echo -n '\''r"0123456789abcdef(foo)")0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)")0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)")0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)")0123456789abcdef"'\''|json -b2'
echo -n 'r"0123456789abcdef(foo)")0123456789abcdef"'|json -b2 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)")0123456789abcdef"'\''|json -b2'

echo '$ echo -n '\''r"0123456789abcdef(foo)")0123456789abcdef"'\''|json -b4'
echo -n 'r"0123456789abcdef(foo)")0123456789abcdef"'|json -b4 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)")0123456789abcdef"'\''|json -b4'

echo '$ echo -n '\''r"0123456789abcdef(foo)")0123456789abcdef"'\''|json -b8'
echo -n 'r"0123456789abcdef(foo)")0123456789abcdef"'|json -b8 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)")0123456789abcdef"'\''|json -b8'

echo '$ echo -n '\''r"0123456789abcdef(foo)")0123456789abcdef"'\''|json -b16'
echo -n 'r"0123456789abcdef(foo)")0123456789abcdef"'|json -b16 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)")0123456789abcdef"'\''|json -b16'

echo '$ echo -n '\''r"0123456789abcdef(foo)")0123456789abcdef"'\''|json -b32'
echo -n 'r"0123456789abcdef(foo)")0123456789abcdef"'|json -b32 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)")0123456789abcdef"'\''|json -b32'

echo '$ echo -n '\''r"0123456789abcdef(foo)0")0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0")0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0")0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0")0123456789abcdef"'\''|json -b2'
echo -n 'r"0123456789abcdef(foo)0")0123456789abcdef"'|json -b2 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0")0123456789abcdef"'\''|json -b2'

echo '$ echo -n '\''r"0123456789abcdef(foo)0")0123456789abcdef"'\''|json -b4'
echo -n 'r"0123456789abcdef(foo)0")0123456789abcdef"'|json -b4 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0")0123456789abcdef"'\''|json -b4'

echo '$ echo -n '\''r"0123456789abcdef(foo)0")0123456789abcdef"'\''|json -b8'
echo -n 'r"0123456789abcdef(foo)0")0123456789abcdef"'|json -b8 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0")0123456789abcdef"'\''|json -b8'

echo '$ echo -n '\''r"0123456789abcdef(foo)0")0123456789abcdef"'\''|json -b16'
echo -n 'r"0123456789abcdef(foo)0")0123456789abcdef"'|json -b16 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0")0123456789abcdef"'\''|json -b16'

echo '$ echo -n '\''r"0123456789abcdef(foo)0")0123456789abcdef"'\''|json -b32'
echo -n 'r"0123456789abcdef(foo)0")0123456789abcdef"'|json -b32 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0")0123456789abcdef"'\''|json -b32'

echo '$ echo -n '\''r"0123456789abcdef(foo)01")0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)01")0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01")0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)01")0123456789abcdef"'\''|json -b2'
echo -n 'r"0123456789abcdef(foo)01")0123456789abcdef"'|json -b2 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01")0123456789abcdef"'\''|json -b2'

echo '$ echo -n '\''r"0123456789abcdef(foo)01")0123456789abcdef"'\''|json -b4'
echo -n 'r"0123456789abcdef(foo)01")0123456789abcdef"'|json -b4 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01")0123456789abcdef"'\''|json -b4'

echo '$ echo -n '\''r"0123456789abcdef(foo)01")0123456789abcdef"'\''|json -b8'
echo -n 'r"0123456789abcdef(foo)01")0123456789abcdef"'|json -b8 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01")0123456789abcdef"'\''|json -b8'

echo '$ echo -n '\''r"0123456789abcdef(foo)01")0123456789abcdef"'\''|json -b16'
echo -n 'r"0123456789abcdef(foo)01")0123456789abcdef"'|json -b16 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01")0123456789abcdef"'\''|json -b16'

echo '$ echo -n '\''r"0123456789abcdef(foo)01")0123456789abcdef"'\''|json -b32'
echo -n 'r"0123456789abcdef(foo)01")0123456789abcdef"'|json -b32 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01")0123456789abcdef"'\''|json -b32'

echo '$ echo -n '\''r"0123456789abcdef(foo)012")0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)012")0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012")0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)012")0123456789abcdef"'\''|json -b2'
echo -n 'r"0123456789abcdef(foo)012")0123456789abcdef"'|json -b2 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012")0123456789abcdef"'\''|json -b2'

echo '$ echo -n '\''r"0123456789abcdef(foo)012")0123456789abcdef"'\''|json -b4'
echo -n 'r"0123456789abcdef(foo)012")0123456789abcdef"'|json -b4 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012")0123456789abcdef"'\''|json -b4'

echo '$ echo -n '\''r"0123456789abcdef(foo)012")0123456789abcdef"'\''|json -b8'
echo -n 'r"0123456789abcdef(foo)012")0123456789abcdef"'|json -b8 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012")0123456789abcdef"'\''|json -b8'

echo '$ echo -n '\''r"0123456789abcdef(foo)012")0123456789abcdef"'\''|json -b16'
echo -n 'r"0123456789abcdef(foo)012")0123456789abcdef"'|json -b16 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012")0123456789abcdef"'\''|json -b16'

echo '$ echo -n '\''r"0123456789abcdef(foo)012")0123456789abcdef"'\''|json -b32'
echo -n 'r"0123456789abcdef(foo)012")0123456789abcdef"'|json -b32 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012")0123456789abcdef"'\''|json -b32'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123")0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123")0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123")0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123")0123456789abcdef"'\''|json -b2'
echo -n 'r"0123456789abcdef(foo)0123")0123456789abcdef"'|json -b2 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123")0123456789abcdef"'\''|json -b2'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123")0123456789abcdef"'\''|json -b4'
echo -n 'r"0123456789abcdef(foo)0123")0123456789abcdef"'|json -b4 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123")0123456789abcdef"'\''|json -b4'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123")0123456789abcdef"'\''|json -b8'
echo -n 'r"0123456789abcdef(foo)0123")0123456789abcdef"'|json -b8 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123")0123456789abcdef"'\''|json -b8'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123")0123456789abcdef"'\''|json -b16'
echo -n 'r"0123456789abcdef(foo)0123")0123456789abcdef"'|json -b16 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123")0123456789abcdef"'\''|json -b16'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123")0123456789abcdef"'\''|json -b32'
echo -n 'r"0123456789abcdef(foo)0123")0123456789abcdef"'|json -b32 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123")0123456789abcdef"'\''|json -b32'

echo '$ echo -n '\''r"0123456789abcdef(foo)01234")0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)01234")0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01234")0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)01234")0123456789abcdef"'\''|json -b2'
echo -n 'r"0123456789abcdef(foo)01234")0123456789abcdef"'|json -b2 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01234")0123456789abcdef"'\''|json -b2'

echo '$ echo -n '\''r"0123456789abcdef(foo)01234")0123456789abcdef"'\''|json -b4'
echo -n 'r"0123456789abcdef(foo)01234")0123456789abcdef"'|json -b4 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01234")0123456789abcdef"'\''|json -b4'

echo '$ echo -n '\''r"0123456789abcdef(foo)01234")0123456789abcdef"'\''|json -b8'
echo -n 'r"0123456789abcdef(foo)01234")0123456789abcdef"'|json -b8 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01234")0123456789abcdef"'\''|json -b8'

echo '$ echo -n '\''r"0123456789abcdef(foo)01234")0123456789abcdef"'\''|json -b16'
echo -n 'r"0123456789abcdef(foo)01234")0123456789abcdef"'|json -b16 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01234")0123456789abcdef"'\''|json -b16'

echo '$ echo -n '\''r"0123456789abcdef(foo)01234")0123456789abcdef"'\''|json -b32'
echo -n 'r"0123456789abcdef(foo)01234")0123456789abcdef"'|json -b32 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01234")0123456789abcdef"'\''|json -b32'

echo '$ echo -n '\''r"0123456789abcdef(foo)012345")0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)012345")0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012345")0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)012345")0123456789abcdef"'\''|json -b2'
echo -n 'r"0123456789abcdef(foo)012345")0123456789abcdef"'|json -b2 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012345")0123456789abcdef"'\''|json -b2'

echo '$ echo -n '\''r"0123456789abcdef(foo)012345")0123456789abcdef"'\''|json -b4'
echo -n 'r"0123456789abcdef(foo)012345")0123456789abcdef"'|json -b4 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012345")0123456789abcdef"'\''|json -b4'

echo '$ echo -n '\''r"0123456789abcdef(foo)012345")0123456789abcdef"'\''|json -b8'
echo -n 'r"0123456789abcdef(foo)012345")0123456789abcdef"'|json -b8 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012345")0123456789abcdef"'\''|json -b8'

echo '$ echo -n '\''r"0123456789abcdef(foo)012345")0123456789abcdef"'\''|json -b16'
echo -n 'r"0123456789abcdef(foo)012345")0123456789abcdef"'|json -b16 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012345")0123456789abcdef"'\''|json -b16'

echo '$ echo -n '\''r"0123456789abcdef(foo)012345")0123456789abcdef"'\''|json -b32'
echo -n 'r"0123456789abcdef(foo)012345")0123456789abcdef"'|json -b32 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012345")0123456789abcdef"'\''|json -b32'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456")0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456")0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456")0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456")0123456789abcdef"'\''|json -b2'
echo -n 'r"0123456789abcdef(foo)0123456")0123456789abcdef"'|json -b2 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456")0123456789abcdef"'\''|json -b2'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456")0123456789abcdef"'\''|json -b4'
echo -n 'r"0123456789abcdef(foo)0123456")0123456789abcdef"'|json -b4 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456")0123456789abcdef"'\''|json -b4'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456")0123456789abcdef"'\''|json -b8'
echo -n 'r"0123456789abcdef(foo)0123456")0123456789abcdef"'|json -b8 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456")0123456789abcdef"'\''|json -b8'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456")0123456789abcdef"'\''|json -b16'
echo -n 'r"0123456789abcdef(foo)0123456")0123456789abcdef"'|json -b16 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456")0123456789abcdef"'\''|json -b16'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456")0123456789abcdef"'\''|json -b32'
echo -n 'r"0123456789abcdef(foo)0123456")0123456789abcdef"'|json -b32 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456")0123456789abcdef"'\''|json -b32'

echo '$ echo -n '\''r"0123456789abcdef(foo)01234567")0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)01234567")0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01234567")0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)01234567")0123456789abcdef"'\''|json -b2'
echo -n 'r"0123456789abcdef(foo)01234567")0123456789abcdef"'|json -b2 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01234567")0123456789abcdef"'\''|json -b2'

echo '$ echo -n '\''r"0123456789abcdef(foo)01234567")0123456789abcdef"'\''|json -b4'
echo -n 'r"0123456789abcdef(foo)01234567")0123456789abcdef"'|json -b4 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01234567")0123456789abcdef"'\''|json -b4'

echo '$ echo -n '\''r"0123456789abcdef(foo)01234567")0123456789abcdef"'\''|json -b8'
echo -n 'r"0123456789abcdef(foo)01234567")0123456789abcdef"'|json -b8 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01234567")0123456789abcdef"'\''|json -b8'

echo '$ echo -n '\''r"0123456789abcdef(foo)01234567")0123456789abcdef"'\''|json -b16'
echo -n 'r"0123456789abcdef(foo)01234567")0123456789abcdef"'|json -b16 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01234567")0123456789abcdef"'\''|json -b16'

echo '$ echo -n '\''r"0123456789abcdef(foo)01234567")0123456789abcdef"'\''|json -b32'
echo -n 'r"0123456789abcdef(foo)01234567")0123456789abcdef"'|json -b32 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01234567")0123456789abcdef"'\''|json -b32'

echo '$ echo -n '\''r"0123456789abcdef(foo)012345678")0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)012345678")0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012345678")0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)012345678")0123456789abcdef"'\''|json -b2'
echo -n 'r"0123456789abcdef(foo)012345678")0123456789abcdef"'|json -b2 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012345678")0123456789abcdef"'\''|json -b2'

echo '$ echo -n '\''r"0123456789abcdef(foo)012345678")0123456789abcdef"'\''|json -b4'
echo -n 'r"0123456789abcdef(foo)012345678")0123456789abcdef"'|json -b4 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012345678")0123456789abcdef"'\''|json -b4'

echo '$ echo -n '\''r"0123456789abcdef(foo)012345678")0123456789abcdef"'\''|json -b8'
echo -n 'r"0123456789abcdef(foo)012345678")0123456789abcdef"'|json -b8 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012345678")0123456789abcdef"'\''|json -b8'

echo '$ echo -n '\''r"0123456789abcdef(foo)012345678")0123456789abcdef"'\''|json -b16'
echo -n 'r"0123456789abcdef(foo)012345678")0123456789abcdef"'|json -b16 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012345678")0123456789abcdef"'\''|json -b16'

echo '$ echo -n '\''r"0123456789abcdef(foo)012345678")0123456789abcdef"'\''|json -b32'
echo -n 'r"0123456789abcdef(foo)012345678")0123456789abcdef"'|json -b32 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012345678")0123456789abcdef"'\''|json -b32'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789")0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789")0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789")0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789")0123456789abcdef"'\''|json -b2'
echo -n 'r"0123456789abcdef(foo)0123456789")0123456789abcdef"'|json -b2 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789")0123456789abcdef"'\''|json -b2'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789")0123456789abcdef"'\''|json -b4'
echo -n 'r"0123456789abcdef(foo)0123456789")0123456789abcdef"'|json -b4 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789")0123456789abcdef"'\''|json -b4'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789")0123456789abcdef"'\''|json -b8'
echo -n 'r"0123456789abcdef(foo)0123456789")0123456789abcdef"'|json -b8 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789")0123456789abcdef"'\''|json -b8'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789")0123456789abcdef"'\''|json -b16'
echo -n 'r"0123456789abcdef(foo)0123456789")0123456789abcdef"'|json -b16 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789")0123456789abcdef"'\''|json -b16'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789")0123456789abcdef"'\''|json -b32'
echo -n 'r"0123456789abcdef(foo)0123456789")0123456789abcdef"'|json -b32 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789")0123456789abcdef"'\''|json -b32'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789a")0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789a")0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789a")0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789a")0123456789abcdef"'\''|json -b2'
echo -n 'r"0123456789abcdef(foo)0123456789a")0123456789abcdef"'|json -b2 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789a")0123456789abcdef"'\''|json -b2'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789a")0123456789abcdef"'\''|json -b4'
echo -n 'r"0123456789abcdef(foo)0123456789a")0123456789abcdef"'|json -b4 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789a")0123456789abcdef"'\''|json -b4'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789a")0123456789abcdef"'\''|json -b8'
echo -n 'r"0123456789abcdef(foo)0123456789a")0123456789abcdef"'|json -b8 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789a")0123456789abcdef"'\''|json -b8'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789a")0123456789abcdef"'\''|json -b16'
echo -n 'r"0123456789abcdef(foo)0123456789a")0123456789abcdef"'|json -b16 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789a")0123456789abcdef"'\''|json -b16'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789a")0123456789abcdef"'\''|json -b32'
echo -n 'r"0123456789abcdef(foo)0123456789a")0123456789abcdef"'|json -b32 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789a")0123456789abcdef"'\''|json -b32'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789ab")0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789ab")0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789ab")0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789ab")0123456789abcdef"'\''|json -b2'
echo -n 'r"0123456789abcdef(foo)0123456789ab")0123456789abcdef"'|json -b2 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789ab")0123456789abcdef"'\''|json -b2'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789ab")0123456789abcdef"'\''|json -b4'
echo -n 'r"0123456789abcdef(foo)0123456789ab")0123456789abcdef"'|json -b4 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789ab")0123456789abcdef"'\''|json -b4'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789ab")0123456789abcdef"'\''|json -b8'
echo -n 'r"0123456789abcdef(foo)0123456789ab")0123456789abcdef"'|json -b8 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789ab")0123456789abcdef"'\''|json -b8'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789ab")0123456789abcdef"'\''|json -b16'
echo -n 'r"0123456789abcdef(foo)0123456789ab")0123456789abcdef"'|json -b16 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789ab")0123456789abcdef"'\''|json -b16'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789ab")0123456789abcdef"'\''|json -b32'
echo -n 'r"0123456789abcdef(foo)0123456789ab")0123456789abcdef"'|json -b32 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789ab")0123456789abcdef"'\''|json -b32'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abc")0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abc")0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abc")0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abc")0123456789abcdef"'\''|json -b2'
echo -n 'r"0123456789abcdef(foo)0123456789abc")0123456789abcdef"'|json -b2 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abc")0123456789abcdef"'\''|json -b2'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abc")0123456789abcdef"'\''|json -b4'
echo -n 'r"0123456789abcdef(foo)0123456789abc")0123456789abcdef"'|json -b4 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abc")0123456789abcdef"'\''|json -b4'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abc")0123456789abcdef"'\''|json -b8'
echo -n 'r"0123456789abcdef(foo)0123456789abc")0123456789abcdef"'|json -b8 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abc")0123456789abcdef"'\''|json -b8'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abc")0123456789abcdef"'\''|json -b16'
echo -n 'r"0123456789abcdef(foo)0123456789abc")0123456789abcdef"'|json -b16 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abc")0123456789abcdef"'\''|json -b16'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abc")0123456789abcdef"'\''|json -b32'
echo -n 'r"0123456789abcdef(foo)0123456789abc")0123456789abcdef"'|json -b32 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abc")0123456789abcdef"'\''|json -b32'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcd")0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abcd")0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcd")0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcd")0123456789abcdef"'\''|json -b2'
echo -n 'r"0123456789abcdef(foo)0123456789abcd")0123456789abcdef"'|json -b2 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcd")0123456789abcdef"'\''|json -b2'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcd")0123456789abcdef"'\''|json -b4'
echo -n 'r"0123456789abcdef(foo)0123456789abcd")0123456789abcdef"'|json -b4 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcd")0123456789abcdef"'\''|json -b4'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcd")0123456789abcdef"'\''|json -b8'
echo -n 'r"0123456789abcdef(foo)0123456789abcd")0123456789abcdef"'|json -b8 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcd")0123456789abcdef"'\''|json -b8'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcd")0123456789abcdef"'\''|json -b16'
echo -n 'r"0123456789abcdef(foo)0123456789abcd")0123456789abcdef"'|json -b16 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcd")0123456789abcdef"'\''|json -b16'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcd")0123456789abcdef"'\''|json -b32'
echo -n 'r"0123456789abcdef(foo)0123456789abcd")0123456789abcdef"'|json -b32 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcd")0123456789abcdef"'\''|json -b32'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcde")0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abcde")0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcde")0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcde")0123456789abcdef"'\''|json -b2'
echo -n 'r"0123456789abcdef(foo)0123456789abcde")0123456789abcdef"'|json -b2 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcde")0123456789abcdef"'\''|json -b2'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcde")0123456789abcdef"'\''|json -b4'
echo -n 'r"0123456789abcdef(foo)0123456789abcde")0123456789abcdef"'|json -b4 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcde")0123456789abcdef"'\''|json -b4'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcde")0123456789abcdef"'\''|json -b8'
echo -n 'r"0123456789abcdef(foo)0123456789abcde")0123456789abcdef"'|json -b8 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcde")0123456789abcdef"'\''|json -b8'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcde")0123456789abcdef"'\''|json -b16'
echo -n 'r"0123456789abcdef(foo)0123456789abcde")0123456789abcdef"'|json -b16 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcde")0123456789abcdef"'\''|json -b16'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcde")0123456789abcdef"'\''|json -b32'
echo -n 'r"0123456789abcdef(foo)0123456789abcde")0123456789abcdef"'|json -b32 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcde")0123456789abcdef"'\''|json -b32'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcdef")0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abcdef")0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcdef")0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcdef")0123456789abcdef"'\''|json -b2'
echo -n 'r"0123456789abcdef(foo)0123456789abcdef")0123456789abcdef"'|json -b2 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcdef")0123456789abcdef"'\''|json -b2'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcdef")0123456789abcdef"'\''|json -b4'
echo -n 'r"0123456789abcdef(foo)0123456789abcdef")0123456789abcdef"'|json -b4 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcdef")0123456789abcdef"'\''|json -b4'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcdef")0123456789abcdef"'\''|json -b8'
echo -n 'r"0123456789abcdef(foo)0123456789abcdef")0123456789abcdef"'|json -b8 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcdef")0123456789abcdef"'\''|json -b8'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcdef")0123456789abcdef"'\''|json -b16'
echo -n 'r"0123456789abcdef(foo)0123456789abcdef")0123456789abcdef"'|json -b16 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcdef")0123456789abcdef"'\''|json -b16'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcdef")0123456789abcdef"'\''|json -b32'
echo -n 'r"0123456789abcdef(foo)0123456789abcdef")0123456789abcdef"'|json -b32 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcdef")0123456789abcdef"'\''|json -b32'
)

