#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C parser:string-surrogate-pairs-escape
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L string-surrogate-pairs-escape.old <(echo \
'$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }
$ json() { json0 --literal-value --escape-utf8 --no-surrogate-pairs "$@"; }
$ echo -e '\''"\xf0\x90\x80\x80"'\''|json
"\ufffd"
$ echo -e '\''"\xf0\x90\x80\xbf"'\''|json
"\ufffd"
$ echo -e '\''"\xf0\x90\xbf\x80"'\''|json
"\ufffd"
$ echo -e '\''"\xf0\x90\xbf\xbf"'\''|json
"\ufffd"
$ echo -e '\''"\xf0\xbf\x80\x80"'\''|json
"\ufffd"
$ echo -e '\''"\xf0\xbf\x80\xbf"'\''|json
"\ufffd"
$ echo -e '\''"\xf0\xbf\xbf\x80"'\''|json
"\ufffd"
$ echo -e '\''"\xf0\xbf\xbf\xbf"'\''|json
"\ufffd"
$ echo -e '\''"\xf1\x80\x80\x80"'\''|json
"\ufffd"
$ echo -e '\''"\xf1\x80\x80\xbf"'\''|json
"\ufffd"
$ echo -e '\''"\xf1\x80\xbf\x80"'\''|json
"\ufffd"
$ echo -e '\''"\xf1\x80\xbf\xbf"'\''|json
"\ufffd"
$ echo -e '\''"\xf1\xbf\x80\x80"'\''|json
"\ufffd"
$ echo -e '\''"\xf1\xbf\x80\xbf"'\''|json
"\ufffd"
$ echo -e '\''"\xf1\xbf\xbf\x80"'\''|json
"\ufffd"
$ echo -e '\''"\xf1\xbf\xbf\xbf"'\''|json
"\ufffd"
$ echo -e '\''"\xf3\x80\x80\x80"'\''|json
"\ufffd"
$ echo -e '\''"\xf3\x80\x80\xbf"'\''|json
"\ufffd"
$ echo -e '\''"\xf3\x80\xbf\x80"'\''|json
"\ufffd"
$ echo -e '\''"\xf3\x80\xbf\xbf"'\''|json
"\ufffd"
$ echo -e '\''"\xf3\xbf\x80\x80"'\''|json
"\ufffd"
$ echo -e '\''"\xf3\xbf\x80\xbf"'\''|json
"\ufffd"
$ echo -e '\''"\xf3\xbf\xbf\x80"'\''|json
"\ufffd"
$ echo -e '\''"\xf3\xbf\xbf\xbf"'\''|json
"\ufffd"
$ echo -e '\''"\xf4\x80\x80\x80"'\''|json
"\ufffd"
$ echo -e '\''"\xf4\x80\x80\xbf"'\''|json
"\ufffd"
$ echo -e '\''"\xf4\x80\xbf\x80"'\''|json
"\ufffd"
$ echo -e '\''"\xf4\x80\xbf\xbf"'\''|json
"\ufffd"
$ echo -e '\''"\xf4\x8f\x80\x80"'\''|json
"\ufffd"
$ echo -e '\''"\xf4\x8f\x80\xbf"'\''|json
"\ufffd"
$ echo -e '\''"\xf4\x8f\xbf\x80"'\''|json
"\ufffd"
$ echo -e '\''"\xf4\x8f\xbf\xbf"'\''|json
"\ufffd"'
) -L string-surrogate-pairs-escape.new <(
echo '$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'
json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; } 2>&1 ||
echo 'command failed: json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'

echo '$ json() { json0 --literal-value --escape-utf8 --no-surrogate-pairs "$@"; }'
json() { json0 --literal-value --escape-utf8 --no-surrogate-pairs "$@"; } 2>&1 ||
echo 'command failed: json() { json0 --literal-value --escape-utf8 --no-surrogate-pairs "$@"; }'

echo '$ echo -e '\''"\xf0\x90\x80\x80"'\''|json'
echo -e '"\xf0\x90\x80\x80"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xf0\x90\x80\x80"'\''|json'

echo '$ echo -e '\''"\xf0\x90\x80\xbf"'\''|json'
echo -e '"\xf0\x90\x80\xbf"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xf0\x90\x80\xbf"'\''|json'

echo '$ echo -e '\''"\xf0\x90\xbf\x80"'\''|json'
echo -e '"\xf0\x90\xbf\x80"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xf0\x90\xbf\x80"'\''|json'

echo '$ echo -e '\''"\xf0\x90\xbf\xbf"'\''|json'
echo -e '"\xf0\x90\xbf\xbf"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xf0\x90\xbf\xbf"'\''|json'

echo '$ echo -e '\''"\xf0\xbf\x80\x80"'\''|json'
echo -e '"\xf0\xbf\x80\x80"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xf0\xbf\x80\x80"'\''|json'

echo '$ echo -e '\''"\xf0\xbf\x80\xbf"'\''|json'
echo -e '"\xf0\xbf\x80\xbf"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xf0\xbf\x80\xbf"'\''|json'

echo '$ echo -e '\''"\xf0\xbf\xbf\x80"'\''|json'
echo -e '"\xf0\xbf\xbf\x80"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xf0\xbf\xbf\x80"'\''|json'

echo '$ echo -e '\''"\xf0\xbf\xbf\xbf"'\''|json'
echo -e '"\xf0\xbf\xbf\xbf"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xf0\xbf\xbf\xbf"'\''|json'

echo '$ echo -e '\''"\xf1\x80\x80\x80"'\''|json'
echo -e '"\xf1\x80\x80\x80"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xf1\x80\x80\x80"'\''|json'

echo '$ echo -e '\''"\xf1\x80\x80\xbf"'\''|json'
echo -e '"\xf1\x80\x80\xbf"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xf1\x80\x80\xbf"'\''|json'

echo '$ echo -e '\''"\xf1\x80\xbf\x80"'\''|json'
echo -e '"\xf1\x80\xbf\x80"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xf1\x80\xbf\x80"'\''|json'

echo '$ echo -e '\''"\xf1\x80\xbf\xbf"'\''|json'
echo -e '"\xf1\x80\xbf\xbf"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xf1\x80\xbf\xbf"'\''|json'

echo '$ echo -e '\''"\xf1\xbf\x80\x80"'\''|json'
echo -e '"\xf1\xbf\x80\x80"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xf1\xbf\x80\x80"'\''|json'

echo '$ echo -e '\''"\xf1\xbf\x80\xbf"'\''|json'
echo -e '"\xf1\xbf\x80\xbf"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xf1\xbf\x80\xbf"'\''|json'

echo '$ echo -e '\''"\xf1\xbf\xbf\x80"'\''|json'
echo -e '"\xf1\xbf\xbf\x80"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xf1\xbf\xbf\x80"'\''|json'

echo '$ echo -e '\''"\xf1\xbf\xbf\xbf"'\''|json'
echo -e '"\xf1\xbf\xbf\xbf"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xf1\xbf\xbf\xbf"'\''|json'

echo '$ echo -e '\''"\xf3\x80\x80\x80"'\''|json'
echo -e '"\xf3\x80\x80\x80"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xf3\x80\x80\x80"'\''|json'

echo '$ echo -e '\''"\xf3\x80\x80\xbf"'\''|json'
echo -e '"\xf3\x80\x80\xbf"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xf3\x80\x80\xbf"'\''|json'

echo '$ echo -e '\''"\xf3\x80\xbf\x80"'\''|json'
echo -e '"\xf3\x80\xbf\x80"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xf3\x80\xbf\x80"'\''|json'

echo '$ echo -e '\''"\xf3\x80\xbf\xbf"'\''|json'
echo -e '"\xf3\x80\xbf\xbf"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xf3\x80\xbf\xbf"'\''|json'

echo '$ echo -e '\''"\xf3\xbf\x80\x80"'\''|json'
echo -e '"\xf3\xbf\x80\x80"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xf3\xbf\x80\x80"'\''|json'

echo '$ echo -e '\''"\xf3\xbf\x80\xbf"'\''|json'
echo -e '"\xf3\xbf\x80\xbf"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xf3\xbf\x80\xbf"'\''|json'

echo '$ echo -e '\''"\xf3\xbf\xbf\x80"'\''|json'
echo -e '"\xf3\xbf\xbf\x80"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xf3\xbf\xbf\x80"'\''|json'

echo '$ echo -e '\''"\xf3\xbf\xbf\xbf"'\''|json'
echo -e '"\xf3\xbf\xbf\xbf"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xf3\xbf\xbf\xbf"'\''|json'

echo '$ echo -e '\''"\xf4\x80\x80\x80"'\''|json'
echo -e '"\xf4\x80\x80\x80"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xf4\x80\x80\x80"'\''|json'

echo '$ echo -e '\''"\xf4\x80\x80\xbf"'\''|json'
echo -e '"\xf4\x80\x80\xbf"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xf4\x80\x80\xbf"'\''|json'

echo '$ echo -e '\''"\xf4\x80\xbf\x80"'\''|json'
echo -e '"\xf4\x80\xbf\x80"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xf4\x80\xbf\x80"'\''|json'

echo '$ echo -e '\''"\xf4\x80\xbf\xbf"'\''|json'
echo -e '"\xf4\x80\xbf\xbf"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xf4\x80\xbf\xbf"'\''|json'

echo '$ echo -e '\''"\xf4\x8f\x80\x80"'\''|json'
echo -e '"\xf4\x8f\x80\x80"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xf4\x8f\x80\x80"'\''|json'

echo '$ echo -e '\''"\xf4\x8f\x80\xbf"'\''|json'
echo -e '"\xf4\x8f\x80\xbf"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xf4\x8f\x80\xbf"'\''|json'

echo '$ echo -e '\''"\xf4\x8f\xbf\x80"'\''|json'
echo -e '"\xf4\x8f\xbf\x80"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xf4\x8f\xbf\x80"'\''|json'

echo '$ echo -e '\''"\xf4\x8f\xbf\xbf"'\''|json'
echo -e '"\xf4\x8f\xbf\xbf"'|json 2>&1 ||
echo 'command failed: echo -e '\''"\xf4\x8f\xbf\xbf"'\''|json'
)

