#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C parser:string3
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L string3.old <(echo \
'$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }
$ json() { json0 --literal-value "$@"; }
$ echo -n '\''"'\''|json -b 1
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "
json: error: <stdin>:1:2:  ^
command failed: echo -n '\''"'\''|json -b 1
$ echo -n '\''"'\''|json -b 2
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "
json: error: <stdin>:1:2:  ^
command failed: echo -n '\''"'\''|json -b 2
$ echo -n '\''"f'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "f
json: error: <stdin>:1:3:   ^
command failed: echo -n '\''"f'\''|json -b 1
$ echo -n '\''"f'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "f
json: error: <stdin>:1:3:   ^
command failed: echo -n '\''"f'\''|json -b 2
$ echo -n '\''"f'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "f
json: error: <stdin>:1:3:   ^
command failed: echo -n '\''"f'\''|json -b 3
$ echo -n '\''"fo'\''|json -b 1
json: error: <stdin>:1:4: lex error: invalid string literal
json: error: <stdin>:1:4: "fo
json: error: <stdin>:1:4:    ^
command failed: echo -n '\''"fo'\''|json -b 1
$ echo -n '\''"fo'\''|json -b 2
json: error: <stdin>:1:4: lex error: invalid string literal
json: error: <stdin>:1:4: "fo
json: error: <stdin>:1:4:    ^
command failed: echo -n '\''"fo'\''|json -b 2
$ echo -n '\''"fo'\''|json -b 3
json: error: <stdin>:1:4: lex error: invalid string literal
json: error: <stdin>:1:4: "fo
json: error: <stdin>:1:4:    ^
command failed: echo -n '\''"fo'\''|json -b 3
$ echo -n '\''"fo'\''|json -b 4
json: error: <stdin>:1:4: lex error: invalid string literal
json: error: <stdin>:1:4: "fo
json: error: <stdin>:1:4:    ^
command failed: echo -n '\''"fo'\''|json -b 4
$ echo -n '\''"foo'\''|json -b 1
json: error: <stdin>:1:5: lex error: invalid string literal
json: error: <stdin>:1:5: "foo
json: error: <stdin>:1:5:     ^
command failed: echo -n '\''"foo'\''|json -b 1
$ echo -n '\''"foo'\''|json -b 2
json: error: <stdin>:1:5: lex error: invalid string literal
json: error: <stdin>:1:5: "foo
json: error: <stdin>:1:5:     ^
command failed: echo -n '\''"foo'\''|json -b 2
$ echo -n '\''"foo'\''|json -b 3
json: error: <stdin>:1:5: lex error: invalid string literal
json: error: <stdin>:1:5: "foo
json: error: <stdin>:1:5:     ^
command failed: echo -n '\''"foo'\''|json -b 3
$ echo -n '\''"foo'\''|json -b 4
json: error: <stdin>:1:5: lex error: invalid string literal
json: error: <stdin>:1:5: "foo
json: error: <stdin>:1:5:     ^
command failed: echo -n '\''"foo'\''|json -b 4
$ echo -n '\''"foo'\''|json -b 5
json: error: <stdin>:1:5: lex error: invalid string literal
json: error: <stdin>:1:5: "foo
json: error: <stdin>:1:5:     ^
command failed: echo -n '\''"foo'\''|json -b 5
$ echo -n '\''"foo"'\''|json -b 1
"foo"
$ echo -n '\''"foo"'\''|json -b 2
"foo"
$ echo -n '\''"foo"'\''|json -b 3
"foo"
$ echo -n '\''"foo"'\''|json -b 4
"foo"
$ echo -n '\''"foo"'\''|json -b 5
"foo"
$ echo -n '\''"foo"'\''|json -b 6
"foo"
$ echo -n '\''"'\''|json -b 1
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "
json: error: <stdin>:1:2:  ^
command failed: echo -n '\''"'\''|json -b 1
$ echo -n '\''"'\''|json -b 2
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "
json: error: <stdin>:1:2:  ^
command failed: echo -n '\''"'\''|json -b 2
$ echo -n '\''"\'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\
json: error: <stdin>:1:3:    ^
command failed: echo -n '\''"\'\''|json -b 1
$ echo -n '\''"\'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\
json: error: <stdin>:1:3:    ^
command failed: echo -n '\''"\'\''|json -b 2
$ echo -n '\''"\'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\
json: error: <stdin>:1:3:    ^
command failed: echo -n '\''"\'\''|json -b 3
$ echo -n '\''"\n'\''|json -b 1
json: error: <stdin>:1:4: lex error: invalid string literal
json: error: <stdin>:1:4: "\\n
json: error: <stdin>:1:4:     ^
command failed: echo -n '\''"\n'\''|json -b 1
$ echo -n '\''"\n'\''|json -b 2
json: error: <stdin>:1:4: lex error: invalid string literal
json: error: <stdin>:1:4: "\\n
json: error: <stdin>:1:4:     ^
command failed: echo -n '\''"\n'\''|json -b 2
$ echo -n '\''"\n'\''|json -b 3
json: error: <stdin>:1:4: lex error: invalid string literal
json: error: <stdin>:1:4: "\\n
json: error: <stdin>:1:4:     ^
command failed: echo -n '\''"\n'\''|json -b 3
$ echo -n '\''"\n'\''|json -b 4
json: error: <stdin>:1:4: lex error: invalid string literal
json: error: <stdin>:1:4: "\\n
json: error: <stdin>:1:4:     ^
command failed: echo -n '\''"\n'\''|json -b 4
$ echo -n '\''"\n"'\''|json -b 1
"\n"
$ echo -n '\''"\n"'\''|json -b 2
"\n"
$ echo -n '\''"\n"'\''|json -b 3
"\n"
$ echo -n '\''"\n"'\''|json -b 4
"\n"
$ echo -n '\''"\n"'\''|json -b 5
"\n"
$ echo -n '\''"'\''|json -b 1
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "
json: error: <stdin>:1:2:  ^
command failed: echo -n '\''"'\''|json -b 1
$ echo -n '\''"'\''|json -b 2
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "
json: error: <stdin>:1:2:  ^
command failed: echo -n '\''"'\''|json -b 2
$ echo -n '\''"\'\''|json -b 1
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\
json: error: <stdin>:1:3:    ^
command failed: echo -n '\''"\'\''|json -b 1
$ echo -n '\''"\'\''|json -b 2
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\
json: error: <stdin>:1:3:    ^
command failed: echo -n '\''"\'\''|json -b 2
$ echo -n '\''"\'\''|json -b 3
json: error: <stdin>:1:3: lex error: invalid string literal
json: error: <stdin>:1:3: "\\
json: error: <stdin>:1:3:    ^
command failed: echo -n '\''"\'\''|json -b 3
$ echo -n '\''"\u'\''|json -b 1
json: error: <stdin>:1:4: lex error: invalid string literal
json: error: <stdin>:1:4: "\\u
json: error: <stdin>:1:4:     ^
command failed: echo -n '\''"\u'\''|json -b 1
$ echo -n '\''"\u'\''|json -b 2
json: error: <stdin>:1:4: lex error: invalid string literal
json: error: <stdin>:1:4: "\\u
json: error: <stdin>:1:4:     ^
command failed: echo -n '\''"\u'\''|json -b 2
$ echo -n '\''"\u'\''|json -b 3
json: error: <stdin>:1:4: lex error: invalid string literal
json: error: <stdin>:1:4: "\\u
json: error: <stdin>:1:4:     ^
command failed: echo -n '\''"\u'\''|json -b 3
$ echo -n '\''"\u'\''|json -b 4
json: error: <stdin>:1:4: lex error: invalid string literal
json: error: <stdin>:1:4: "\\u
json: error: <stdin>:1:4:     ^
command failed: echo -n '\''"\u'\''|json -b 4
$ echo -n '\''"\u0'\''|json -b 1
json: error: <stdin>:1:5: lex error: invalid string literal
json: error: <stdin>:1:5: "\\u0
json: error: <stdin>:1:5:      ^
command failed: echo -n '\''"\u0'\''|json -b 1
$ echo -n '\''"\u0'\''|json -b 2
json: error: <stdin>:1:5: lex error: invalid string literal
json: error: <stdin>:1:5: "\\u0
json: error: <stdin>:1:5:      ^
command failed: echo -n '\''"\u0'\''|json -b 2
$ echo -n '\''"\u0'\''|json -b 3
json: error: <stdin>:1:5: lex error: invalid string literal
json: error: <stdin>:1:5: "\\u0
json: error: <stdin>:1:5:      ^
command failed: echo -n '\''"\u0'\''|json -b 3
$ echo -n '\''"\u0'\''|json -b 4
json: error: <stdin>:1:5: lex error: invalid string literal
json: error: <stdin>:1:5: "\\u0
json: error: <stdin>:1:5:      ^
command failed: echo -n '\''"\u0'\''|json -b 4
$ echo -n '\''"\u0'\''|json -b 5
json: error: <stdin>:1:5: lex error: invalid string literal
json: error: <stdin>:1:5: "\\u0
json: error: <stdin>:1:5:      ^
command failed: echo -n '\''"\u0'\''|json -b 5
$ echo -n '\''"\u00'\''|json -b 1
json: error: <stdin>:1:6: lex error: invalid string literal
json: error: <stdin>:1:6: "\\u00
json: error: <stdin>:1:6:       ^
command failed: echo -n '\''"\u00'\''|json -b 1
$ echo -n '\''"\u00'\''|json -b 2
json: error: <stdin>:1:6: lex error: invalid string literal
json: error: <stdin>:1:6: "\\u00
json: error: <stdin>:1:6:       ^
command failed: echo -n '\''"\u00'\''|json -b 2
$ echo -n '\''"\u00'\''|json -b 3
json: error: <stdin>:1:6: lex error: invalid string literal
json: error: <stdin>:1:6: "\\u00
json: error: <stdin>:1:6:       ^
command failed: echo -n '\''"\u00'\''|json -b 3
$ echo -n '\''"\u00'\''|json -b 4
json: error: <stdin>:1:6: lex error: invalid string literal
json: error: <stdin>:1:6: "\\u00
json: error: <stdin>:1:6:       ^
command failed: echo -n '\''"\u00'\''|json -b 4
$ echo -n '\''"\u00'\''|json -b 5
json: error: <stdin>:1:6: lex error: invalid string literal
json: error: <stdin>:1:6: "\\u00
json: error: <stdin>:1:6:       ^
command failed: echo -n '\''"\u00'\''|json -b 5
$ echo -n '\''"\u00'\''|json -b 6
json: error: <stdin>:1:6: lex error: invalid string literal
json: error: <stdin>:1:6: "\\u00
json: error: <stdin>:1:6:       ^
command failed: echo -n '\''"\u00'\''|json -b 6
$ echo -n '\''"\u002'\''|json -b 1
json: error: <stdin>:1:7: lex error: invalid string literal
json: error: <stdin>:1:7: "\\u002
json: error: <stdin>:1:7:        ^
command failed: echo -n '\''"\u002'\''|json -b 1
$ echo -n '\''"\u002'\''|json -b 2
json: error: <stdin>:1:7: lex error: invalid string literal
json: error: <stdin>:1:7: "\\u002
json: error: <stdin>:1:7:        ^
command failed: echo -n '\''"\u002'\''|json -b 2
$ echo -n '\''"\u002'\''|json -b 3
json: error: <stdin>:1:7: lex error: invalid string literal
json: error: <stdin>:1:7: "\\u002
json: error: <stdin>:1:7:        ^
command failed: echo -n '\''"\u002'\''|json -b 3
$ echo -n '\''"\u002'\''|json -b 4
json: error: <stdin>:1:7: lex error: invalid string literal
json: error: <stdin>:1:7: "\\u002
json: error: <stdin>:1:7:        ^
command failed: echo -n '\''"\u002'\''|json -b 4
$ echo -n '\''"\u002'\''|json -b 5
json: error: <stdin>:1:7: lex error: invalid string literal
json: error: <stdin>:1:7: "\\u002
json: error: <stdin>:1:7:        ^
command failed: echo -n '\''"\u002'\''|json -b 5
$ echo -n '\''"\u002'\''|json -b 6
json: error: <stdin>:1:7: lex error: invalid string literal
json: error: <stdin>:1:7: "\\u002
json: error: <stdin>:1:7:        ^
command failed: echo -n '\''"\u002'\''|json -b 6
$ echo -n '\''"\u002'\''|json -b 7
json: error: <stdin>:1:7: lex error: invalid string literal
json: error: <stdin>:1:7: "\\u002
json: error: <stdin>:1:7:        ^
command failed: echo -n '\''"\u002'\''|json -b 7
$ echo -n '\''"\u0020'\''|json -b 1
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\u0020
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\u0020'\''|json -b 1
$ echo -n '\''"\u0020'\''|json -b 2
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\u0020
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\u0020'\''|json -b 2
$ echo -n '\''"\u0020'\''|json -b 3
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\u0020
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\u0020'\''|json -b 3
$ echo -n '\''"\u0020'\''|json -b 4
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\u0020
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\u0020'\''|json -b 4
$ echo -n '\''"\u0020'\''|json -b 5
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\u0020
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\u0020'\''|json -b 5
$ echo -n '\''"\u0020'\''|json -b 6
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\u0020
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\u0020'\''|json -b 6
$ echo -n '\''"\u0020'\''|json -b 7
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\u0020
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\u0020'\''|json -b 7
$ echo -n '\''"\u0020'\''|json -b 8
json: error: <stdin>:1:8: lex error: invalid string literal
json: error: <stdin>:1:8: "\\u0020
json: error: <stdin>:1:8:         ^
command failed: echo -n '\''"\u0020'\''|json -b 8
$ echo -n '\''"\u0020"'\''|json -b 1
" "
$ echo -n '\''"\u0020"'\''|json -b 2
" "
$ echo -n '\''"\u0020"'\''|json -b 3
" "
$ echo -n '\''"\u0020"'\''|json -b 4
" "
$ echo -n '\''"\u0020"'\''|json -b 5
" "
$ echo -n '\''"\u0020"'\''|json -b 6
" "
$ echo -n '\''"\u0020"'\''|json -b 7
" "
$ echo -n '\''"\u0020"'\''|json -b 8
" "
$ echo -n '\''"\u0020"'\''|json -b 9
" "'
) -L string3.new <(
echo '$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'
json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; } 2>&1 ||
echo 'command failed: json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'

echo '$ json() { json0 --literal-value "$@"; }'
json() { json0 --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { json0 --literal-value "$@"; }'

echo '$ echo -n '\''"'\''|json -b 1'
echo -n '"'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''"'\''|json -b 1'

echo '$ echo -n '\''"'\''|json -b 2'
echo -n '"'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''"'\''|json -b 2'

echo '$ echo -n '\''"f'\''|json -b 1'
echo -n '"f'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''"f'\''|json -b 1'

echo '$ echo -n '\''"f'\''|json -b 2'
echo -n '"f'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''"f'\''|json -b 2'

echo '$ echo -n '\''"f'\''|json -b 3'
echo -n '"f'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''"f'\''|json -b 3'

echo '$ echo -n '\''"fo'\''|json -b 1'
echo -n '"fo'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''"fo'\''|json -b 1'

echo '$ echo -n '\''"fo'\''|json -b 2'
echo -n '"fo'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''"fo'\''|json -b 2'

echo '$ echo -n '\''"fo'\''|json -b 3'
echo -n '"fo'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''"fo'\''|json -b 3'

echo '$ echo -n '\''"fo'\''|json -b 4'
echo -n '"fo'|json -b 4 2>&1 ||
echo 'command failed: echo -n '\''"fo'\''|json -b 4'

echo '$ echo -n '\''"foo'\''|json -b 1'
echo -n '"foo'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''"foo'\''|json -b 1'

echo '$ echo -n '\''"foo'\''|json -b 2'
echo -n '"foo'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''"foo'\''|json -b 2'

echo '$ echo -n '\''"foo'\''|json -b 3'
echo -n '"foo'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''"foo'\''|json -b 3'

echo '$ echo -n '\''"foo'\''|json -b 4'
echo -n '"foo'|json -b 4 2>&1 ||
echo 'command failed: echo -n '\''"foo'\''|json -b 4'

echo '$ echo -n '\''"foo'\''|json -b 5'
echo -n '"foo'|json -b 5 2>&1 ||
echo 'command failed: echo -n '\''"foo'\''|json -b 5'

echo '$ echo -n '\''"foo"'\''|json -b 1'
echo -n '"foo"'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''"foo"'\''|json -b 1'

echo '$ echo -n '\''"foo"'\''|json -b 2'
echo -n '"foo"'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''"foo"'\''|json -b 2'

echo '$ echo -n '\''"foo"'\''|json -b 3'
echo -n '"foo"'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''"foo"'\''|json -b 3'

echo '$ echo -n '\''"foo"'\''|json -b 4'
echo -n '"foo"'|json -b 4 2>&1 ||
echo 'command failed: echo -n '\''"foo"'\''|json -b 4'

echo '$ echo -n '\''"foo"'\''|json -b 5'
echo -n '"foo"'|json -b 5 2>&1 ||
echo 'command failed: echo -n '\''"foo"'\''|json -b 5'

echo '$ echo -n '\''"foo"'\''|json -b 6'
echo -n '"foo"'|json -b 6 2>&1 ||
echo 'command failed: echo -n '\''"foo"'\''|json -b 6'

echo '$ echo -n '\''"'\''|json -b 1'
echo -n '"'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''"'\''|json -b 1'

echo '$ echo -n '\''"'\''|json -b 2'
echo -n '"'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''"'\''|json -b 2'

echo '$ echo -n '\''"\'\''|json -b 1'
echo -n '"\'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''"\'\''|json -b 1'

echo '$ echo -n '\''"\'\''|json -b 2'
echo -n '"\'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''"\'\''|json -b 2'

echo '$ echo -n '\''"\'\''|json -b 3'
echo -n '"\'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''"\'\''|json -b 3'

echo '$ echo -n '\''"\n'\''|json -b 1'
echo -n '"\n'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''"\n'\''|json -b 1'

echo '$ echo -n '\''"\n'\''|json -b 2'
echo -n '"\n'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''"\n'\''|json -b 2'

echo '$ echo -n '\''"\n'\''|json -b 3'
echo -n '"\n'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''"\n'\''|json -b 3'

echo '$ echo -n '\''"\n'\''|json -b 4'
echo -n '"\n'|json -b 4 2>&1 ||
echo 'command failed: echo -n '\''"\n'\''|json -b 4'

echo '$ echo -n '\''"\n"'\''|json -b 1'
echo -n '"\n"'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''"\n"'\''|json -b 1'

echo '$ echo -n '\''"\n"'\''|json -b 2'
echo -n '"\n"'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''"\n"'\''|json -b 2'

echo '$ echo -n '\''"\n"'\''|json -b 3'
echo -n '"\n"'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''"\n"'\''|json -b 3'

echo '$ echo -n '\''"\n"'\''|json -b 4'
echo -n '"\n"'|json -b 4 2>&1 ||
echo 'command failed: echo -n '\''"\n"'\''|json -b 4'

echo '$ echo -n '\''"\n"'\''|json -b 5'
echo -n '"\n"'|json -b 5 2>&1 ||
echo 'command failed: echo -n '\''"\n"'\''|json -b 5'

echo '$ echo -n '\''"'\''|json -b 1'
echo -n '"'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''"'\''|json -b 1'

echo '$ echo -n '\''"'\''|json -b 2'
echo -n '"'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''"'\''|json -b 2'

echo '$ echo -n '\''"\'\''|json -b 1'
echo -n '"\'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''"\'\''|json -b 1'

echo '$ echo -n '\''"\'\''|json -b 2'
echo -n '"\'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''"\'\''|json -b 2'

echo '$ echo -n '\''"\'\''|json -b 3'
echo -n '"\'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''"\'\''|json -b 3'

echo '$ echo -n '\''"\u'\''|json -b 1'
echo -n '"\u'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''"\u'\''|json -b 1'

echo '$ echo -n '\''"\u'\''|json -b 2'
echo -n '"\u'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''"\u'\''|json -b 2'

echo '$ echo -n '\''"\u'\''|json -b 3'
echo -n '"\u'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''"\u'\''|json -b 3'

echo '$ echo -n '\''"\u'\''|json -b 4'
echo -n '"\u'|json -b 4 2>&1 ||
echo 'command failed: echo -n '\''"\u'\''|json -b 4'

echo '$ echo -n '\''"\u0'\''|json -b 1'
echo -n '"\u0'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''"\u0'\''|json -b 1'

echo '$ echo -n '\''"\u0'\''|json -b 2'
echo -n '"\u0'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''"\u0'\''|json -b 2'

echo '$ echo -n '\''"\u0'\''|json -b 3'
echo -n '"\u0'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''"\u0'\''|json -b 3'

echo '$ echo -n '\''"\u0'\''|json -b 4'
echo -n '"\u0'|json -b 4 2>&1 ||
echo 'command failed: echo -n '\''"\u0'\''|json -b 4'

echo '$ echo -n '\''"\u0'\''|json -b 5'
echo -n '"\u0'|json -b 5 2>&1 ||
echo 'command failed: echo -n '\''"\u0'\''|json -b 5'

echo '$ echo -n '\''"\u00'\''|json -b 1'
echo -n '"\u00'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''"\u00'\''|json -b 1'

echo '$ echo -n '\''"\u00'\''|json -b 2'
echo -n '"\u00'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''"\u00'\''|json -b 2'

echo '$ echo -n '\''"\u00'\''|json -b 3'
echo -n '"\u00'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''"\u00'\''|json -b 3'

echo '$ echo -n '\''"\u00'\''|json -b 4'
echo -n '"\u00'|json -b 4 2>&1 ||
echo 'command failed: echo -n '\''"\u00'\''|json -b 4'

echo '$ echo -n '\''"\u00'\''|json -b 5'
echo -n '"\u00'|json -b 5 2>&1 ||
echo 'command failed: echo -n '\''"\u00'\''|json -b 5'

echo '$ echo -n '\''"\u00'\''|json -b 6'
echo -n '"\u00'|json -b 6 2>&1 ||
echo 'command failed: echo -n '\''"\u00'\''|json -b 6'

echo '$ echo -n '\''"\u002'\''|json -b 1'
echo -n '"\u002'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''"\u002'\''|json -b 1'

echo '$ echo -n '\''"\u002'\''|json -b 2'
echo -n '"\u002'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''"\u002'\''|json -b 2'

echo '$ echo -n '\''"\u002'\''|json -b 3'
echo -n '"\u002'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''"\u002'\''|json -b 3'

echo '$ echo -n '\''"\u002'\''|json -b 4'
echo -n '"\u002'|json -b 4 2>&1 ||
echo 'command failed: echo -n '\''"\u002'\''|json -b 4'

echo '$ echo -n '\''"\u002'\''|json -b 5'
echo -n '"\u002'|json -b 5 2>&1 ||
echo 'command failed: echo -n '\''"\u002'\''|json -b 5'

echo '$ echo -n '\''"\u002'\''|json -b 6'
echo -n '"\u002'|json -b 6 2>&1 ||
echo 'command failed: echo -n '\''"\u002'\''|json -b 6'

echo '$ echo -n '\''"\u002'\''|json -b 7'
echo -n '"\u002'|json -b 7 2>&1 ||
echo 'command failed: echo -n '\''"\u002'\''|json -b 7'

echo '$ echo -n '\''"\u0020'\''|json -b 1'
echo -n '"\u0020'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''"\u0020'\''|json -b 1'

echo '$ echo -n '\''"\u0020'\''|json -b 2'
echo -n '"\u0020'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''"\u0020'\''|json -b 2'

echo '$ echo -n '\''"\u0020'\''|json -b 3'
echo -n '"\u0020'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''"\u0020'\''|json -b 3'

echo '$ echo -n '\''"\u0020'\''|json -b 4'
echo -n '"\u0020'|json -b 4 2>&1 ||
echo 'command failed: echo -n '\''"\u0020'\''|json -b 4'

echo '$ echo -n '\''"\u0020'\''|json -b 5'
echo -n '"\u0020'|json -b 5 2>&1 ||
echo 'command failed: echo -n '\''"\u0020'\''|json -b 5'

echo '$ echo -n '\''"\u0020'\''|json -b 6'
echo -n '"\u0020'|json -b 6 2>&1 ||
echo 'command failed: echo -n '\''"\u0020'\''|json -b 6'

echo '$ echo -n '\''"\u0020'\''|json -b 7'
echo -n '"\u0020'|json -b 7 2>&1 ||
echo 'command failed: echo -n '\''"\u0020'\''|json -b 7'

echo '$ echo -n '\''"\u0020'\''|json -b 8'
echo -n '"\u0020'|json -b 8 2>&1 ||
echo 'command failed: echo -n '\''"\u0020'\''|json -b 8'

echo '$ echo -n '\''"\u0020"'\''|json -b 1'
echo -n '"\u0020"'|json -b 1 2>&1 ||
echo 'command failed: echo -n '\''"\u0020"'\''|json -b 1'

echo '$ echo -n '\''"\u0020"'\''|json -b 2'
echo -n '"\u0020"'|json -b 2 2>&1 ||
echo 'command failed: echo -n '\''"\u0020"'\''|json -b 2'

echo '$ echo -n '\''"\u0020"'\''|json -b 3'
echo -n '"\u0020"'|json -b 3 2>&1 ||
echo 'command failed: echo -n '\''"\u0020"'\''|json -b 3'

echo '$ echo -n '\''"\u0020"'\''|json -b 4'
echo -n '"\u0020"'|json -b 4 2>&1 ||
echo 'command failed: echo -n '\''"\u0020"'\''|json -b 4'

echo '$ echo -n '\''"\u0020"'\''|json -b 5'
echo -n '"\u0020"'|json -b 5 2>&1 ||
echo 'command failed: echo -n '\''"\u0020"'\''|json -b 5'

echo '$ echo -n '\''"\u0020"'\''|json -b 6'
echo -n '"\u0020"'|json -b 6 2>&1 ||
echo 'command failed: echo -n '\''"\u0020"'\''|json -b 6'

echo '$ echo -n '\''"\u0020"'\''|json -b 7'
echo -n '"\u0020"'|json -b 7 2>&1 ||
echo 'command failed: echo -n '\''"\u0020"'\''|json -b 7'

echo '$ echo -n '\''"\u0020"'\''|json -b 8'
echo -n '"\u0020"'|json -b 8 2>&1 ||
echo 'command failed: echo -n '\''"\u0020"'\''|json -b 8'

echo '$ echo -n '\''"\u0020"'\''|json -b 9'
echo -n '"\u0020"'|json -b 9 2>&1 ||
echo 'command failed: echo -n '\''"\u0020"'\''|json -b 9'
)

