#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-lib:dict
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L dict.old <(echo \
'$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }
$ json <<< '\''{"type":"dict","args":[{"name":"baz","type":null}]}'\''
json: error: <stdin>:1:45: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:45: t","args":[{"name":"baz","type":null}]}
json: error: <stdin>:1:45:                                 ^
command failed: json <<< '\''{"type":"dict","args":[{"name":"baz","type":null}]}'\''
$ json <<< '\''{"type":"dict","args":[{"name":"baz","type":false}]}'\''
json: error: <stdin>:1:45: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:45: t","args":[{"name":"baz","type":false}]}
json: error: <stdin>:1:45:                                 ^
command failed: json <<< '\''{"type":"dict","args":[{"name":"baz","type":false}]}'\''
$ json <<< '\''{"type":"dict","args":[{"name":"baz","type":true}]}'\''
json: error: <stdin>:1:45: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:45: t","args":[{"name":"baz","type":true}]}
json: error: <stdin>:1:45:                                 ^
command failed: json <<< '\''{"type":"dict","args":[{"name":"baz","type":true}]}'\''
$ json <<< '\''{"type":"dict","args":[{"name":"baz","type":123}]}'\''
json: error: <stdin>:1:45: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:45: t","args":[{"name":"baz","type":123}]}
json: error: <stdin>:1:45:                                 ^
command failed: json <<< '\''{"type":"dict","args":[{"name":"baz","type":123}]}'\''
$ json <<< '\''{"type":"dict","args":[{"name":"baz","type":"foo"}]}'\''
json: error: <stdin>:1:45: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:45: t","args":[{"name":"baz","type":"foo"}]}
json: error: <stdin>:1:45:                                 ^
command failed: json <<< '\''{"type":"dict","args":[{"name":"baz","type":"foo"}]}'\''
$ json <<< '\''{"type":"dict","args":[{"name":"baz","type":"type"}]}'\''
{
    "type": "dict",
    "args": [
        {
            "name": "baz",
            "type": "type"
        }
    ],
    "expr": null,
    "attr": {
        "args": {
            "sym": "b",
            "lo": null,
            "eq": {
                "sym": "a",
                "lo": null,
                "eq": {
                    "sym": "z",
                    "lo": null,
                    "eq": {
                        "val": 0,
                        "lo": null,
                        "hi": null
                    },
                    "hi": null
                },
                "hi": null
            },
            "hi": null
        },
        "expr": [],
        "size": 0
    }
}
$ json <<< '\''{"type":"dict","args":[{"name":"baz","type":"null"}]}'\''
{
    "type": "dict",
    "args": [
        {
            "name": "baz",
            "type": "null"
        }
    ],
    "expr": null,
    "attr": {
        "args": {
            "sym": "b",
            "lo": null,
            "eq": {
                "sym": "a",
                "lo": null,
                "eq": {
                    "sym": "z",
                    "lo": null,
                    "eq": {
                        "val": 0,
                        "lo": null,
                        "hi": null
                    },
                    "hi": null
                },
                "hi": null
            },
            "hi": null
        },
        "expr": [],
        "size": 0
    }
}
$ json <<< '\''{"type":"dict","args":[{"name":"baz","type":"boolean"}]}'\''
{
    "type": "dict",
    "args": [
        {
            "name": "baz",
            "type": "boolean"
        }
    ],
    "expr": null,
    "attr": {
        "args": {
            "sym": "b",
            "lo": null,
            "eq": {
                "sym": "a",
                "lo": null,
                "eq": {
                    "sym": "z",
                    "lo": null,
                    "eq": {
                        "val": 0,
                        "lo": null,
                        "hi": null
                    },
                    "hi": null
                },
                "hi": null
            },
            "hi": null
        },
        "expr": [],
        "size": 0
    }
}
$ json <<< '\''{"type":"dict","args":[{"name":"baz","type":"number"}]}'\''
{
    "type": "dict",
    "args": [
        {
            "name": "baz",
            "type": "number"
        }
    ],
    "expr": null,
    "attr": {
        "args": {
            "sym": "b",
            "lo": null,
            "eq": {
                "sym": "a",
                "lo": null,
                "eq": {
                    "sym": "z",
                    "lo": null,
                    "eq": {
                        "val": 0,
                        "lo": null,
                        "hi": null
                    },
                    "hi": null
                },
                "hi": null
            },
            "hi": null
        },
        "expr": [],
        "size": 0
    }
}
$ json <<< '\''{"type":"dict","args":[{"name":"baz","type":"string"}]}'\''
{
    "type": "dict",
    "args": [
        {
            "name": "baz",
            "type": "string"
        }
    ],
    "expr": null,
    "attr": {
        "args": {
            "sym": "b",
            "lo": null,
            "eq": {
                "sym": "a",
                "lo": null,
                "eq": {
                    "sym": "z",
                    "lo": null,
                    "eq": {
                        "val": 0,
                        "lo": null,
                        "hi": null
                    },
                    "hi": null
                },
                "hi": null
            },
            "hi": null
        },
        "expr": [],
        "size": 0
    }
}
$ json <<< '\''{"type":"dict","args":[{"name":"baz","type":"object"}]}'\''
{
    "type": "dict",
    "args": [
        {
            "name": "baz",
            "type": "object"
        }
    ],
    "expr": null,
    "attr": {
        "args": {
            "sym": "b",
            "lo": null,
            "eq": {
                "sym": "a",
                "lo": null,
                "eq": {
                    "sym": "z",
                    "lo": null,
                    "eq": {
                        "val": 0,
                        "lo": null,
                        "hi": null
                    },
                    "hi": null
                },
                "hi": null
            },
            "hi": null
        },
        "expr": [],
        "size": 0
    }
}
$ json <<< '\''{"type":"dict","args":[{"name":"baz","type":"array"}]}'\''
{
    "type": "dict",
    "args": [
        {
            "name": "baz",
            "type": "array"
        }
    ],
    "expr": null,
    "attr": {
        "args": {
            "sym": "b",
            "lo": null,
            "eq": {
                "sym": "a",
                "lo": null,
                "eq": {
                    "sym": "z",
                    "lo": null,
                    "eq": {
                        "val": 0,
                        "lo": null,
                        "hi": null
                    },
                    "hi": null
                },
                "hi": null
            },
            "hi": null
        },
        "expr": [],
        "size": 0
    }
}
$ json <<< '\''{"type":"dict","args":[{"name":"baz","type":"list"}]}'\''
json: error: <stdin>:1:45: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:45: t","args":[{"name":"baz","type":"list"}]}
json: error: <stdin>:1:45:                                 ^
command failed: json <<< '\''{"type":"dict","args":[{"name":"baz","type":"list"}]}'\''
$ json <<< '\''{"type":"dict","args":[{"name":"baz","type":"dict"}]}'\''
json: error: <stdin>:1:45: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:45: t","args":[{"name":"baz","type":"dict"}]}
json: error: <stdin>:1:45:                                 ^
command failed: json <<< '\''{"type":"dict","args":[{"name":"baz","type":"dict"}]}'\''
$ json <<< '\''{"type":"dict","args":[{"name":"baz","type":{}}]}'\''
json: error: <stdin>:1:45: meta error: empty objects are not allowed
json: error: <stdin>:1:45: t","args":[{"name":"baz","type":{}}]}
json: error: <stdin>:1:45:                                 ^
command failed: json <<< '\''{"type":"dict","args":[{"name":"baz","type":{}}]}'\''
$ json <<< '\''{"type":"dict","args":[{"name":"baz","type":{"foo":"bar"}}]}'\''
json: error: <stdin>:1:46: meta error: invalid first key of object: it must be "type", "name" or "plain"
json: error: <stdin>:1:46: ","args":[{"name":"baz","type":{"foo":"bar"}}]}
json: error: <stdin>:1:46:                                 ^
command failed: json <<< '\''{"type":"dict","args":[{"name":"baz","type":{"foo":"bar"}}]}'\''
$ json <<< '\''{"type":"dict","args":[{"name":"baz","type":[]}]}'\''
json: error: <stdin>:1:45: meta error: invalid "name" object: its "type" argument must be a type
json: error: <stdin>:1:45: t","args":[{"name":"baz","type":[]}]}
json: error: <stdin>:1:45:                                 ^
command failed: json <<< '\''{"type":"dict","args":[{"name":"baz","type":[]}]}'\''
$ json <<< '\''{"type":"dict","args":[{"name":"baz","type":["foo","bar"]}]}'\''
json: error: <stdin>:1:46: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:46: ","args":[{"name":"baz","type":["foo","bar"]}]}
json: error: <stdin>:1:46:                                 ^
command failed: json <<< '\''{"type":"dict","args":[{"name":"baz","type":["foo","bar"]}]}'\'''
) -L dict.new <(
echo '$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }'
json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; } 2>&1 ||
echo 'command failed: json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }'

echo '$ json <<< '\''{"type":"dict","args":[{"name":"baz","type":null}]}'\'''
json <<< '{"type":"dict","args":[{"name":"baz","type":null}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","args":[{"name":"baz","type":null}]}'\'''

echo '$ json <<< '\''{"type":"dict","args":[{"name":"baz","type":false}]}'\'''
json <<< '{"type":"dict","args":[{"name":"baz","type":false}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","args":[{"name":"baz","type":false}]}'\'''

echo '$ json <<< '\''{"type":"dict","args":[{"name":"baz","type":true}]}'\'''
json <<< '{"type":"dict","args":[{"name":"baz","type":true}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","args":[{"name":"baz","type":true}]}'\'''

echo '$ json <<< '\''{"type":"dict","args":[{"name":"baz","type":123}]}'\'''
json <<< '{"type":"dict","args":[{"name":"baz","type":123}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","args":[{"name":"baz","type":123}]}'\'''

echo '$ json <<< '\''{"type":"dict","args":[{"name":"baz","type":"foo"}]}'\'''
json <<< '{"type":"dict","args":[{"name":"baz","type":"foo"}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","args":[{"name":"baz","type":"foo"}]}'\'''

echo '$ json <<< '\''{"type":"dict","args":[{"name":"baz","type":"type"}]}'\'''
json <<< '{"type":"dict","args":[{"name":"baz","type":"type"}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","args":[{"name":"baz","type":"type"}]}'\'''

echo '$ json <<< '\''{"type":"dict","args":[{"name":"baz","type":"null"}]}'\'''
json <<< '{"type":"dict","args":[{"name":"baz","type":"null"}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","args":[{"name":"baz","type":"null"}]}'\'''

echo '$ json <<< '\''{"type":"dict","args":[{"name":"baz","type":"boolean"}]}'\'''
json <<< '{"type":"dict","args":[{"name":"baz","type":"boolean"}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","args":[{"name":"baz","type":"boolean"}]}'\'''

echo '$ json <<< '\''{"type":"dict","args":[{"name":"baz","type":"number"}]}'\'''
json <<< '{"type":"dict","args":[{"name":"baz","type":"number"}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","args":[{"name":"baz","type":"number"}]}'\'''

echo '$ json <<< '\''{"type":"dict","args":[{"name":"baz","type":"string"}]}'\'''
json <<< '{"type":"dict","args":[{"name":"baz","type":"string"}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","args":[{"name":"baz","type":"string"}]}'\'''

echo '$ json <<< '\''{"type":"dict","args":[{"name":"baz","type":"object"}]}'\'''
json <<< '{"type":"dict","args":[{"name":"baz","type":"object"}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","args":[{"name":"baz","type":"object"}]}'\'''

echo '$ json <<< '\''{"type":"dict","args":[{"name":"baz","type":"array"}]}'\'''
json <<< '{"type":"dict","args":[{"name":"baz","type":"array"}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","args":[{"name":"baz","type":"array"}]}'\'''

echo '$ json <<< '\''{"type":"dict","args":[{"name":"baz","type":"list"}]}'\'''
json <<< '{"type":"dict","args":[{"name":"baz","type":"list"}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","args":[{"name":"baz","type":"list"}]}'\'''

echo '$ json <<< '\''{"type":"dict","args":[{"name":"baz","type":"dict"}]}'\'''
json <<< '{"type":"dict","args":[{"name":"baz","type":"dict"}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","args":[{"name":"baz","type":"dict"}]}'\'''

echo '$ json <<< '\''{"type":"dict","args":[{"name":"baz","type":{}}]}'\'''
json <<< '{"type":"dict","args":[{"name":"baz","type":{}}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","args":[{"name":"baz","type":{}}]}'\'''

echo '$ json <<< '\''{"type":"dict","args":[{"name":"baz","type":{"foo":"bar"}}]}'\'''
json <<< '{"type":"dict","args":[{"name":"baz","type":{"foo":"bar"}}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","args":[{"name":"baz","type":{"foo":"bar"}}]}'\'''

echo '$ json <<< '\''{"type":"dict","args":[{"name":"baz","type":[]}]}'\'''
json <<< '{"type":"dict","args":[{"name":"baz","type":[]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","args":[{"name":"baz","type":[]}]}'\'''

echo '$ json <<< '\''{"type":"dict","args":[{"name":"baz","type":["foo","bar"]}]}'\'''
json <<< '{"type":"dict","args":[{"name":"baz","type":["foo","bar"]}]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"dict","args":[{"name":"baz","type":["foo","bar"]}]}'\'''
)

