# Copyright (C) 2016, 2017, 2018, 2019  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

.PHONY: default clean allclean all depend

default: all

MODULE := $(basename $(firstword ${MAKEFILE_LIST}))
MODULE_LITEX := $(subst -,_,$(patsubst %-litex,%,${MODULE}))

PCRE2_HOME := /usr/local
PCRE2_LIB := ${PCRE2_HOME}/lib

PCRE2_VERSION := 1031

ifneq (${MAKECMDGOALS},clean)
ifneq (${MAKECMDGOALS},allclean)
PCRE2_VERSION_CHECK := $(shell \
	bash -c '. ../libpcre2-version.sh && \
		libpcre2-version-check "${PCRE2_LIB}" ${PCRE2_VERSION}' 2>&1)

ifneq (${PCRE2_VERSION_CHECK},)
$(error ${PCRE2_VERSION_CHECK})
endif
endif
endif

GCC := gcc
GCC_STD := gnu99
CFLAGS := -Wall -Wextra \
          -std=${GCC_STD} -I. -I.. \
          -fPIC -fvisibility=hidden -g -shared \
          -fdata-sections -ffunction-sections -Wl,--gc-sections \
          -Wl,--entry=${subst -,_,${MODULE}}_main \
          -DMODULE=${subst -,_,${MODULE}} \
          -DMODULE_LITEX=${MODULE_LITEX} \
          -DMODULE_DEF=\"${MODULE}.def\" \
          -DPROGRAM=${MODULE}.so \
          -DJSON_NO_LIB_MAIN

DEF  := ${MODULE}.def
SRCS := ${MODULE}.c common.c
BIN  := ${MODULE}.so
DEP  := .depend-${MODULE}

# dependency rules

ifeq (${DEP}, $(wildcard ${DEP}))
include ${DEP}
endif

${MODULE}.c: ${MODULE}.def
${BIN}: ${SRCS}

# building rules

${MODULE}.def: ${MODULE}.json
	LD_LIBRARY_PATH=.:${PCRE2_LIB} ../src/json -VF -- \
		./json-litex.so -D ${MODULE}.json > ${MODULE}.def

${BIN}:
	${GCC} ${CFLAGS} ${SRCS} -o $@

# main targets

depend:
	${GCC} ${CFLAGS} -c ${SRCS} -MM| \
	sed -r 's/^[^ \t]+\.o:/${BIN}:/' > ${DEP}

all: ${BIN}

clean:

allclean: clean
	rm -f *~ ${DEF} ${BIN}


