#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -p litex -C expr-flat:jumps4
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L jumps4.old <(echo \
'$ shopt -s expand_aliases
$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"
$ test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vc flat; }
$ alias test-expr='\''test-expr -C'\''
$ test-expr '\''`0`||`1`'\''
0 match_str("0")
1 jump_true(eos)
2 match_str("1")
$ test-expr '\''`0`&&`1`||`2`'\''
0 match_str("0")
1 jump_false*(4)
2 match_str("1")
3 jump_true(eos)
4 match_str("2")
$ test-expr '\''`0`&&`1`||`2`&&`3`'\''
0 match_str("0")
1 jump_false*(4)
2 match_str("1")
3 jump_true(eos)
4 match_str("2")
5 jump_false(eos)
6 match_str("3")
$ test-expr '\''`0`&&`1`&&`2`||`3`&&`4`'\''
0 match_str("0")
1 jump_false*(6)
2 match_str("1")
3 jump_false*(6)
4 match_str("2")
5 jump_true(eos)
6 match_str("3")
7 jump_false(eos)
8 match_str("4")
$ test-expr '\''`0`&&`1`&&`2`||`3`&&`4`&&`5`'\''
 0 match_str("0")
 1 jump_false*(6)
 2 match_str("1")
 3 jump_false*(6)
 4 match_str("2")
 5 jump_true(eos)
 6 match_str("3")
 7 jump_false(eos)
 8 match_str("4")
 9 jump_false(eos)
10 match_str("5")
$ test-expr '\''`0`&&`1`&&`2`&&`3`||`4`&&`5`&&`6`'\''
 0 match_str("0")
 1 jump_false*(8)
 2 match_str("1")
 3 jump_false*(8)
 4 match_str("2")
 5 jump_false*(8)
 6 match_str("3")
 7 jump_true(eos)
 8 match_str("4")
 9 jump_false(eos)
10 match_str("5")
11 jump_false(eos)
12 match_str("6")
$ test-expr '\''`0`&&`1`&&`2`&&`3`||`4`&&`5`&&`6`&&`7`'\''
 0 match_str("0")
 1 jump_false*(8)
 2 match_str("1")
 3 jump_false*(8)
 4 match_str("2")
 5 jump_false*(8)
 6 match_str("3")
 7 jump_true(eos)
 8 match_str("4")
 9 jump_false(eos)
10 match_str("5")
11 jump_false(eos)
12 match_str("6")
13 jump_false(eos)
14 match_str("7")
$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`||`5`&&`6`&&`7`&&`8`'\''
 0 match_str("0")
 1 jump_false*(10)
 2 match_str("1")
 3 jump_false*(10)
 4 match_str("2")
 5 jump_false*(10)
 6 match_str("3")
 7 jump_false*(10)
 8 match_str("4")
 9 jump_true(eos)
10 match_str("5")
11 jump_false(eos)
12 match_str("6")
13 jump_false(eos)
14 match_str("7")
15 jump_false(eos)
16 match_str("8")
$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`||`5`&&`6`&&`7`&&`8`&&`9`'\''
 0 match_str("0")
 1 jump_false*(10)
 2 match_str("1")
 3 jump_false*(10)
 4 match_str("2")
 5 jump_false*(10)
 6 match_str("3")
 7 jump_false*(10)
 8 match_str("4")
 9 jump_true(eos)
10 match_str("5")
11 jump_false(eos)
12 match_str("6")
13 jump_false(eos)
14 match_str("7")
15 jump_false(eos)
16 match_str("8")
17 jump_false(eos)
18 match_str("9")
$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`||`6`&&`7`&&`8`&&`9`&&`10`'\''
 0 match_str("0")
 1 jump_false*(12)
 2 match_str("1")
 3 jump_false*(12)
 4 match_str("2")
 5 jump_false*(12)
 6 match_str("3")
 7 jump_false*(12)
 8 match_str("4")
 9 jump_false*(12)
10 match_str("5")
11 jump_true(eos)
12 match_str("6")
13 jump_false(eos)
14 match_str("7")
15 jump_false(eos)
16 match_str("8")
17 jump_false(eos)
18 match_str("9")
19 jump_false(eos)
20 match_str("10")
$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`||`6`&&`7`&&`8`&&`9`&&`10`&&`11`'\''
 0 match_str("0")
 1 jump_false*(12)
 2 match_str("1")
 3 jump_false*(12)
 4 match_str("2")
 5 jump_false*(12)
 6 match_str("3")
 7 jump_false*(12)
 8 match_str("4")
 9 jump_false*(12)
10 match_str("5")
11 jump_true(eos)
12 match_str("6")
13 jump_false(eos)
14 match_str("7")
15 jump_false(eos)
16 match_str("8")
17 jump_false(eos)
18 match_str("9")
19 jump_false(eos)
20 match_str("10")
21 jump_false(eos)
22 match_str("11")
$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`||`7`&&`8`&&`9`&&`10`&&`11`&&`12`'\''
 0 match_str("0")
 1 jump_false*(14)
 2 match_str("1")
 3 jump_false*(14)
 4 match_str("2")
 5 jump_false*(14)
 6 match_str("3")
 7 jump_false*(14)
 8 match_str("4")
 9 jump_false*(14)
10 match_str("5")
11 jump_false*(14)
12 match_str("6")
13 jump_true(eos)
14 match_str("7")
15 jump_false(eos)
16 match_str("8")
17 jump_false(eos)
18 match_str("9")
19 jump_false(eos)
20 match_str("10")
21 jump_false(eos)
22 match_str("11")
23 jump_false(eos)
24 match_str("12")
$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`||`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`'\''
 0 match_str("0")
 1 jump_false*(14)
 2 match_str("1")
 3 jump_false*(14)
 4 match_str("2")
 5 jump_false*(14)
 6 match_str("3")
 7 jump_false*(14)
 8 match_str("4")
 9 jump_false*(14)
10 match_str("5")
11 jump_false*(14)
12 match_str("6")
13 jump_true(eos)
14 match_str("7")
15 jump_false(eos)
16 match_str("8")
17 jump_false(eos)
18 match_str("9")
19 jump_false(eos)
20 match_str("10")
21 jump_false(eos)
22 match_str("11")
23 jump_false(eos)
24 match_str("12")
25 jump_false(eos)
26 match_str("13")
$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`||`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`'\''
 0 match_str("0")
 1 jump_false*(16)
 2 match_str("1")
 3 jump_false*(16)
 4 match_str("2")
 5 jump_false*(16)
 6 match_str("3")
 7 jump_false*(16)
 8 match_str("4")
 9 jump_false*(16)
10 match_str("5")
11 jump_false*(16)
12 match_str("6")
13 jump_false*(16)
14 match_str("7")
15 jump_true(eos)
16 match_str("8")
17 jump_false(eos)
18 match_str("9")
19 jump_false(eos)
20 match_str("10")
21 jump_false(eos)
22 match_str("11")
23 jump_false(eos)
24 match_str("12")
25 jump_false(eos)
26 match_str("13")
27 jump_false(eos)
28 match_str("14")
$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`||`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`'\''
 0 match_str("0")
 1 jump_false*(16)
 2 match_str("1")
 3 jump_false*(16)
 4 match_str("2")
 5 jump_false*(16)
 6 match_str("3")
 7 jump_false*(16)
 8 match_str("4")
 9 jump_false*(16)
10 match_str("5")
11 jump_false*(16)
12 match_str("6")
13 jump_false*(16)
14 match_str("7")
15 jump_true(eos)
16 match_str("8")
17 jump_false(eos)
18 match_str("9")
19 jump_false(eos)
20 match_str("10")
21 jump_false(eos)
22 match_str("11")
23 jump_false(eos)
24 match_str("12")
25 jump_false(eos)
26 match_str("13")
27 jump_false(eos)
28 match_str("14")
29 jump_false(eos)
30 match_str("15")
$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`||`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`'\''
 0 match_str("0")
 1 jump_false*(18)
 2 match_str("1")
 3 jump_false*(18)
 4 match_str("2")
 5 jump_false*(18)
 6 match_str("3")
 7 jump_false*(18)
 8 match_str("4")
 9 jump_false*(18)
10 match_str("5")
11 jump_false*(18)
12 match_str("6")
13 jump_false*(18)
14 match_str("7")
15 jump_false*(18)
16 match_str("8")
17 jump_true(eos)
18 match_str("9")
19 jump_false(eos)
20 match_str("10")
21 jump_false(eos)
22 match_str("11")
23 jump_false(eos)
24 match_str("12")
25 jump_false(eos)
26 match_str("13")
27 jump_false(eos)
28 match_str("14")
29 jump_false(eos)
30 match_str("15")
31 jump_false(eos)
32 match_str("16")
$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`||`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`'\''
 0 match_str("0")
 1 jump_false*(18)
 2 match_str("1")
 3 jump_false*(18)
 4 match_str("2")
 5 jump_false*(18)
 6 match_str("3")
 7 jump_false*(18)
 8 match_str("4")
 9 jump_false*(18)
10 match_str("5")
11 jump_false*(18)
12 match_str("6")
13 jump_false*(18)
14 match_str("7")
15 jump_false*(18)
16 match_str("8")
17 jump_true(eos)
18 match_str("9")
19 jump_false(eos)
20 match_str("10")
21 jump_false(eos)
22 match_str("11")
23 jump_false(eos)
24 match_str("12")
25 jump_false(eos)
26 match_str("13")
27 jump_false(eos)
28 match_str("14")
29 jump_false(eos)
30 match_str("15")
31 jump_false(eos)
32 match_str("16")
33 jump_false(eos)
34 match_str("17")
$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`||`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`'\''
 0 match_str("0")
 1 jump_false*(20)
 2 match_str("1")
 3 jump_false*(20)
 4 match_str("2")
 5 jump_false*(20)
 6 match_str("3")
 7 jump_false*(20)
 8 match_str("4")
 9 jump_false*(20)
10 match_str("5")
11 jump_false*(20)
12 match_str("6")
13 jump_false*(20)
14 match_str("7")
15 jump_false*(20)
16 match_str("8")
17 jump_false*(20)
18 match_str("9")
19 jump_true(eos)
20 match_str("10")
21 jump_false(eos)
22 match_str("11")
23 jump_false(eos)
24 match_str("12")
25 jump_false(eos)
26 match_str("13")
27 jump_false(eos)
28 match_str("14")
29 jump_false(eos)
30 match_str("15")
31 jump_false(eos)
32 match_str("16")
33 jump_false(eos)
34 match_str("17")
35 jump_false(eos)
36 match_str("18")
$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`||`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`'\''
 0 match_str("0")
 1 jump_false*(20)
 2 match_str("1")
 3 jump_false*(20)
 4 match_str("2")
 5 jump_false*(20)
 6 match_str("3")
 7 jump_false*(20)
 8 match_str("4")
 9 jump_false*(20)
10 match_str("5")
11 jump_false*(20)
12 match_str("6")
13 jump_false*(20)
14 match_str("7")
15 jump_false*(20)
16 match_str("8")
17 jump_false*(20)
18 match_str("9")
19 jump_true(eos)
20 match_str("10")
21 jump_false(eos)
22 match_str("11")
23 jump_false(eos)
24 match_str("12")
25 jump_false(eos)
26 match_str("13")
27 jump_false(eos)
28 match_str("14")
29 jump_false(eos)
30 match_str("15")
31 jump_false(eos)
32 match_str("16")
33 jump_false(eos)
34 match_str("17")
35 jump_false(eos)
36 match_str("18")
37 jump_false(eos)
38 match_str("19")
$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`||`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`'\''
 0 match_str("0")
 1 jump_false*(22)
 2 match_str("1")
 3 jump_false*(22)
 4 match_str("2")
 5 jump_false*(22)
 6 match_str("3")
 7 jump_false*(22)
 8 match_str("4")
 9 jump_false*(22)
10 match_str("5")
11 jump_false*(22)
12 match_str("6")
13 jump_false*(22)
14 match_str("7")
15 jump_false*(22)
16 match_str("8")
17 jump_false*(22)
18 match_str("9")
19 jump_false*(22)
20 match_str("10")
21 jump_true(eos)
22 match_str("11")
23 jump_false(eos)
24 match_str("12")
25 jump_false(eos)
26 match_str("13")
27 jump_false(eos)
28 match_str("14")
29 jump_false(eos)
30 match_str("15")
31 jump_false(eos)
32 match_str("16")
33 jump_false(eos)
34 match_str("17")
35 jump_false(eos)
36 match_str("18")
37 jump_false(eos)
38 match_str("19")
39 jump_false(eos)
40 match_str("20")
$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`||`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`'\''
 0 match_str("0")
 1 jump_false*(22)
 2 match_str("1")
 3 jump_false*(22)
 4 match_str("2")
 5 jump_false*(22)
 6 match_str("3")
 7 jump_false*(22)
 8 match_str("4")
 9 jump_false*(22)
10 match_str("5")
11 jump_false*(22)
12 match_str("6")
13 jump_false*(22)
14 match_str("7")
15 jump_false*(22)
16 match_str("8")
17 jump_false*(22)
18 match_str("9")
19 jump_false*(22)
20 match_str("10")
21 jump_true(eos)
22 match_str("11")
23 jump_false(eos)
24 match_str("12")
25 jump_false(eos)
26 match_str("13")
27 jump_false(eos)
28 match_str("14")
29 jump_false(eos)
30 match_str("15")
31 jump_false(eos)
32 match_str("16")
33 jump_false(eos)
34 match_str("17")
35 jump_false(eos)
36 match_str("18")
37 jump_false(eos)
38 match_str("19")
39 jump_false(eos)
40 match_str("20")
41 jump_false(eos)
42 match_str("21")
$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`||`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`'\''
 0 match_str("0")
 1 jump_false*(24)
 2 match_str("1")
 3 jump_false*(24)
 4 match_str("2")
 5 jump_false*(24)
 6 match_str("3")
 7 jump_false*(24)
 8 match_str("4")
 9 jump_false*(24)
10 match_str("5")
11 jump_false*(24)
12 match_str("6")
13 jump_false*(24)
14 match_str("7")
15 jump_false*(24)
16 match_str("8")
17 jump_false*(24)
18 match_str("9")
19 jump_false*(24)
20 match_str("10")
21 jump_false*(24)
22 match_str("11")
23 jump_true(eos)
24 match_str("12")
25 jump_false(eos)
26 match_str("13")
27 jump_false(eos)
28 match_str("14")
29 jump_false(eos)
30 match_str("15")
31 jump_false(eos)
32 match_str("16")
33 jump_false(eos)
34 match_str("17")
35 jump_false(eos)
36 match_str("18")
37 jump_false(eos)
38 match_str("19")
39 jump_false(eos)
40 match_str("20")
41 jump_false(eos)
42 match_str("21")
43 jump_false(eos)
44 match_str("22")
$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`||`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`'\''
 0 match_str("0")
 1 jump_false*(24)
 2 match_str("1")
 3 jump_false*(24)
 4 match_str("2")
 5 jump_false*(24)
 6 match_str("3")
 7 jump_false*(24)
 8 match_str("4")
 9 jump_false*(24)
10 match_str("5")
11 jump_false*(24)
12 match_str("6")
13 jump_false*(24)
14 match_str("7")
15 jump_false*(24)
16 match_str("8")
17 jump_false*(24)
18 match_str("9")
19 jump_false*(24)
20 match_str("10")
21 jump_false*(24)
22 match_str("11")
23 jump_true(eos)
24 match_str("12")
25 jump_false(eos)
26 match_str("13")
27 jump_false(eos)
28 match_str("14")
29 jump_false(eos)
30 match_str("15")
31 jump_false(eos)
32 match_str("16")
33 jump_false(eos)
34 match_str("17")
35 jump_false(eos)
36 match_str("18")
37 jump_false(eos)
38 match_str("19")
39 jump_false(eos)
40 match_str("20")
41 jump_false(eos)
42 match_str("21")
43 jump_false(eos)
44 match_str("22")
45 jump_false(eos)
46 match_str("23")
$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`||`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`'\''
 0 match_str("0")
 1 jump_false*(26)
 2 match_str("1")
 3 jump_false*(26)
 4 match_str("2")
 5 jump_false*(26)
 6 match_str("3")
 7 jump_false*(26)
 8 match_str("4")
 9 jump_false*(26)
10 match_str("5")
11 jump_false*(26)
12 match_str("6")
13 jump_false*(26)
14 match_str("7")
15 jump_false*(26)
16 match_str("8")
17 jump_false*(26)
18 match_str("9")
19 jump_false*(26)
20 match_str("10")
21 jump_false*(26)
22 match_str("11")
23 jump_false*(26)
24 match_str("12")
25 jump_true(eos)
26 match_str("13")
27 jump_false(eos)
28 match_str("14")
29 jump_false(eos)
30 match_str("15")
31 jump_false(eos)
32 match_str("16")
33 jump_false(eos)
34 match_str("17")
35 jump_false(eos)
36 match_str("18")
37 jump_false(eos)
38 match_str("19")
39 jump_false(eos)
40 match_str("20")
41 jump_false(eos)
42 match_str("21")
43 jump_false(eos)
44 match_str("22")
45 jump_false(eos)
46 match_str("23")
47 jump_false(eos)
48 match_str("24")
$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`||`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`'\''
 0 match_str("0")
 1 jump_false*(26)
 2 match_str("1")
 3 jump_false*(26)
 4 match_str("2")
 5 jump_false*(26)
 6 match_str("3")
 7 jump_false*(26)
 8 match_str("4")
 9 jump_false*(26)
10 match_str("5")
11 jump_false*(26)
12 match_str("6")
13 jump_false*(26)
14 match_str("7")
15 jump_false*(26)
16 match_str("8")
17 jump_false*(26)
18 match_str("9")
19 jump_false*(26)
20 match_str("10")
21 jump_false*(26)
22 match_str("11")
23 jump_false*(26)
24 match_str("12")
25 jump_true(eos)
26 match_str("13")
27 jump_false(eos)
28 match_str("14")
29 jump_false(eos)
30 match_str("15")
31 jump_false(eos)
32 match_str("16")
33 jump_false(eos)
34 match_str("17")
35 jump_false(eos)
36 match_str("18")
37 jump_false(eos)
38 match_str("19")
39 jump_false(eos)
40 match_str("20")
41 jump_false(eos)
42 match_str("21")
43 jump_false(eos)
44 match_str("22")
45 jump_false(eos)
46 match_str("23")
47 jump_false(eos)
48 match_str("24")
49 jump_false(eos)
50 match_str("25")
$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`||`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`'\''
 0 match_str("0")
 1 jump_false*(28)
 2 match_str("1")
 3 jump_false*(28)
 4 match_str("2")
 5 jump_false*(28)
 6 match_str("3")
 7 jump_false*(28)
 8 match_str("4")
 9 jump_false*(28)
10 match_str("5")
11 jump_false*(28)
12 match_str("6")
13 jump_false*(28)
14 match_str("7")
15 jump_false*(28)
16 match_str("8")
17 jump_false*(28)
18 match_str("9")
19 jump_false*(28)
20 match_str("10")
21 jump_false*(28)
22 match_str("11")
23 jump_false*(28)
24 match_str("12")
25 jump_false*(28)
26 match_str("13")
27 jump_true(eos)
28 match_str("14")
29 jump_false(eos)
30 match_str("15")
31 jump_false(eos)
32 match_str("16")
33 jump_false(eos)
34 match_str("17")
35 jump_false(eos)
36 match_str("18")
37 jump_false(eos)
38 match_str("19")
39 jump_false(eos)
40 match_str("20")
41 jump_false(eos)
42 match_str("21")
43 jump_false(eos)
44 match_str("22")
45 jump_false(eos)
46 match_str("23")
47 jump_false(eos)
48 match_str("24")
49 jump_false(eos)
50 match_str("25")
51 jump_false(eos)
52 match_str("26")
$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`||`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`'\''
 0 match_str("0")
 1 jump_false*(28)
 2 match_str("1")
 3 jump_false*(28)
 4 match_str("2")
 5 jump_false*(28)
 6 match_str("3")
 7 jump_false*(28)
 8 match_str("4")
 9 jump_false*(28)
10 match_str("5")
11 jump_false*(28)
12 match_str("6")
13 jump_false*(28)
14 match_str("7")
15 jump_false*(28)
16 match_str("8")
17 jump_false*(28)
18 match_str("9")
19 jump_false*(28)
20 match_str("10")
21 jump_false*(28)
22 match_str("11")
23 jump_false*(28)
24 match_str("12")
25 jump_false*(28)
26 match_str("13")
27 jump_true(eos)
28 match_str("14")
29 jump_false(eos)
30 match_str("15")
31 jump_false(eos)
32 match_str("16")
33 jump_false(eos)
34 match_str("17")
35 jump_false(eos)
36 match_str("18")
37 jump_false(eos)
38 match_str("19")
39 jump_false(eos)
40 match_str("20")
41 jump_false(eos)
42 match_str("21")
43 jump_false(eos)
44 match_str("22")
45 jump_false(eos)
46 match_str("23")
47 jump_false(eos)
48 match_str("24")
49 jump_false(eos)
50 match_str("25")
51 jump_false(eos)
52 match_str("26")
53 jump_false(eos)
54 match_str("27")
$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`||`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`'\''
 0 match_str("0")
 1 jump_false*(30)
 2 match_str("1")
 3 jump_false*(30)
 4 match_str("2")
 5 jump_false*(30)
 6 match_str("3")
 7 jump_false*(30)
 8 match_str("4")
 9 jump_false*(30)
10 match_str("5")
11 jump_false*(30)
12 match_str("6")
13 jump_false*(30)
14 match_str("7")
15 jump_false*(30)
16 match_str("8")
17 jump_false*(30)
18 match_str("9")
19 jump_false*(30)
20 match_str("10")
21 jump_false*(30)
22 match_str("11")
23 jump_false*(30)
24 match_str("12")
25 jump_false*(30)
26 match_str("13")
27 jump_false*(30)
28 match_str("14")
29 jump_true(eos)
30 match_str("15")
31 jump_false(eos)
32 match_str("16")
33 jump_false(eos)
34 match_str("17")
35 jump_false(eos)
36 match_str("18")
37 jump_false(eos)
38 match_str("19")
39 jump_false(eos)
40 match_str("20")
41 jump_false(eos)
42 match_str("21")
43 jump_false(eos)
44 match_str("22")
45 jump_false(eos)
46 match_str("23")
47 jump_false(eos)
48 match_str("24")
49 jump_false(eos)
50 match_str("25")
51 jump_false(eos)
52 match_str("26")
53 jump_false(eos)
54 match_str("27")
55 jump_false(eos)
56 match_str("28")
$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`||`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`'\''
 0 match_str("0")
 1 jump_false*(30)
 2 match_str("1")
 3 jump_false*(30)
 4 match_str("2")
 5 jump_false*(30)
 6 match_str("3")
 7 jump_false*(30)
 8 match_str("4")
 9 jump_false*(30)
10 match_str("5")
11 jump_false*(30)
12 match_str("6")
13 jump_false*(30)
14 match_str("7")
15 jump_false*(30)
16 match_str("8")
17 jump_false*(30)
18 match_str("9")
19 jump_false*(30)
20 match_str("10")
21 jump_false*(30)
22 match_str("11")
23 jump_false*(30)
24 match_str("12")
25 jump_false*(30)
26 match_str("13")
27 jump_false*(30)
28 match_str("14")
29 jump_true(eos)
30 match_str("15")
31 jump_false(eos)
32 match_str("16")
33 jump_false(eos)
34 match_str("17")
35 jump_false(eos)
36 match_str("18")
37 jump_false(eos)
38 match_str("19")
39 jump_false(eos)
40 match_str("20")
41 jump_false(eos)
42 match_str("21")
43 jump_false(eos)
44 match_str("22")
45 jump_false(eos)
46 match_str("23")
47 jump_false(eos)
48 match_str("24")
49 jump_false(eos)
50 match_str("25")
51 jump_false(eos)
52 match_str("26")
53 jump_false(eos)
54 match_str("27")
55 jump_false(eos)
56 match_str("28")
57 jump_false(eos)
58 match_str("29")
$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`||`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`'\''
 0 match_str("0")
 1 jump_false*(32)
 2 match_str("1")
 3 jump_false*(32)
 4 match_str("2")
 5 jump_false*(32)
 6 match_str("3")
 7 jump_false*(32)
 8 match_str("4")
 9 jump_false*(32)
10 match_str("5")
11 jump_false*(32)
12 match_str("6")
13 jump_false*(32)
14 match_str("7")
15 jump_false*(32)
16 match_str("8")
17 jump_false*(32)
18 match_str("9")
19 jump_false*(32)
20 match_str("10")
21 jump_false*(32)
22 match_str("11")
23 jump_false*(32)
24 match_str("12")
25 jump_false*(32)
26 match_str("13")
27 jump_false*(32)
28 match_str("14")
29 jump_false*(32)
30 match_str("15")
31 jump_true(eos)
32 match_str("16")
33 jump_false(eos)
34 match_str("17")
35 jump_false(eos)
36 match_str("18")
37 jump_false(eos)
38 match_str("19")
39 jump_false(eos)
40 match_str("20")
41 jump_false(eos)
42 match_str("21")
43 jump_false(eos)
44 match_str("22")
45 jump_false(eos)
46 match_str("23")
47 jump_false(eos)
48 match_str("24")
49 jump_false(eos)
50 match_str("25")
51 jump_false(eos)
52 match_str("26")
53 jump_false(eos)
54 match_str("27")
55 jump_false(eos)
56 match_str("28")
57 jump_false(eos)
58 match_str("29")
59 jump_false(eos)
60 match_str("30")
$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`||`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`'\''
 0 match_str("0")
 1 jump_false*(32)
 2 match_str("1")
 3 jump_false*(32)
 4 match_str("2")
 5 jump_false*(32)
 6 match_str("3")
 7 jump_false*(32)
 8 match_str("4")
 9 jump_false*(32)
10 match_str("5")
11 jump_false*(32)
12 match_str("6")
13 jump_false*(32)
14 match_str("7")
15 jump_false*(32)
16 match_str("8")
17 jump_false*(32)
18 match_str("9")
19 jump_false*(32)
20 match_str("10")
21 jump_false*(32)
22 match_str("11")
23 jump_false*(32)
24 match_str("12")
25 jump_false*(32)
26 match_str("13")
27 jump_false*(32)
28 match_str("14")
29 jump_false*(32)
30 match_str("15")
31 jump_true(eos)
32 match_str("16")
33 jump_false(eos)
34 match_str("17")
35 jump_false(eos)
36 match_str("18")
37 jump_false(eos)
38 match_str("19")
39 jump_false(eos)
40 match_str("20")
41 jump_false(eos)
42 match_str("21")
43 jump_false(eos)
44 match_str("22")
45 jump_false(eos)
46 match_str("23")
47 jump_false(eos)
48 match_str("24")
49 jump_false(eos)
50 match_str("25")
51 jump_false(eos)
52 match_str("26")
53 jump_false(eos)
54 match_str("27")
55 jump_false(eos)
56 match_str("28")
57 jump_false(eos)
58 match_str("29")
59 jump_false(eos)
60 match_str("30")
61 jump_false(eos)
62 match_str("31")
$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`||`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`'\''
 0 match_str("0")
 1 jump_false*(34)
 2 match_str("1")
 3 jump_false*(34)
 4 match_str("2")
 5 jump_false*(34)
 6 match_str("3")
 7 jump_false*(34)
 8 match_str("4")
 9 jump_false*(34)
10 match_str("5")
11 jump_false*(34)
12 match_str("6")
13 jump_false*(34)
14 match_str("7")
15 jump_false*(34)
16 match_str("8")
17 jump_false*(34)
18 match_str("9")
19 jump_false*(34)
20 match_str("10")
21 jump_false*(34)
22 match_str("11")
23 jump_false*(34)
24 match_str("12")
25 jump_false*(34)
26 match_str("13")
27 jump_false*(34)
28 match_str("14")
29 jump_false*(34)
30 match_str("15")
31 jump_false*(34)
32 match_str("16")
33 jump_true(eos)
34 match_str("17")
35 jump_false(eos)
36 match_str("18")
37 jump_false(eos)
38 match_str("19")
39 jump_false(eos)
40 match_str("20")
41 jump_false(eos)
42 match_str("21")
43 jump_false(eos)
44 match_str("22")
45 jump_false(eos)
46 match_str("23")
47 jump_false(eos)
48 match_str("24")
49 jump_false(eos)
50 match_str("25")
51 jump_false(eos)
52 match_str("26")
53 jump_false(eos)
54 match_str("27")
55 jump_false(eos)
56 match_str("28")
57 jump_false(eos)
58 match_str("29")
59 jump_false(eos)
60 match_str("30")
61 jump_false(eos)
62 match_str("31")
63 jump_false(eos)
64 match_str("32")
$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`||`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`'\''
 0 match_str("0")
 1 jump_false*(34)
 2 match_str("1")
 3 jump_false*(34)
 4 match_str("2")
 5 jump_false*(34)
 6 match_str("3")
 7 jump_false*(34)
 8 match_str("4")
 9 jump_false*(34)
10 match_str("5")
11 jump_false*(34)
12 match_str("6")
13 jump_false*(34)
14 match_str("7")
15 jump_false*(34)
16 match_str("8")
17 jump_false*(34)
18 match_str("9")
19 jump_false*(34)
20 match_str("10")
21 jump_false*(34)
22 match_str("11")
23 jump_false*(34)
24 match_str("12")
25 jump_false*(34)
26 match_str("13")
27 jump_false*(34)
28 match_str("14")
29 jump_false*(34)
30 match_str("15")
31 jump_false*(34)
32 match_str("16")
33 jump_true(eos)
34 match_str("17")
35 jump_false(eos)
36 match_str("18")
37 jump_false(eos)
38 match_str("19")
39 jump_false(eos)
40 match_str("20")
41 jump_false(eos)
42 match_str("21")
43 jump_false(eos)
44 match_str("22")
45 jump_false(eos)
46 match_str("23")
47 jump_false(eos)
48 match_str("24")
49 jump_false(eos)
50 match_str("25")
51 jump_false(eos)
52 match_str("26")
53 jump_false(eos)
54 match_str("27")
55 jump_false(eos)
56 match_str("28")
57 jump_false(eos)
58 match_str("29")
59 jump_false(eos)
60 match_str("30")
61 jump_false(eos)
62 match_str("31")
63 jump_false(eos)
64 match_str("32")
65 jump_false(eos)
66 match_str("33")
$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`||`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`'\''
 0 match_str("0")
 1 jump_false*(36)
 2 match_str("1")
 3 jump_false*(36)
 4 match_str("2")
 5 jump_false*(36)
 6 match_str("3")
 7 jump_false*(36)
 8 match_str("4")
 9 jump_false*(36)
10 match_str("5")
11 jump_false*(36)
12 match_str("6")
13 jump_false*(36)
14 match_str("7")
15 jump_false*(36)
16 match_str("8")
17 jump_false*(36)
18 match_str("9")
19 jump_false*(36)
20 match_str("10")
21 jump_false*(36)
22 match_str("11")
23 jump_false*(36)
24 match_str("12")
25 jump_false*(36)
26 match_str("13")
27 jump_false*(36)
28 match_str("14")
29 jump_false*(36)
30 match_str("15")
31 jump_false*(36)
32 match_str("16")
33 jump_false*(36)
34 match_str("17")
35 jump_true(eos)
36 match_str("18")
37 jump_false(eos)
38 match_str("19")
39 jump_false(eos)
40 match_str("20")
41 jump_false(eos)
42 match_str("21")
43 jump_false(eos)
44 match_str("22")
45 jump_false(eos)
46 match_str("23")
47 jump_false(eos)
48 match_str("24")
49 jump_false(eos)
50 match_str("25")
51 jump_false(eos)
52 match_str("26")
53 jump_false(eos)
54 match_str("27")
55 jump_false(eos)
56 match_str("28")
57 jump_false(eos)
58 match_str("29")
59 jump_false(eos)
60 match_str("30")
61 jump_false(eos)
62 match_str("31")
63 jump_false(eos)
64 match_str("32")
65 jump_false(eos)
66 match_str("33")
67 jump_false(eos)
68 match_str("34")
$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`||`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`'\''
 0 match_str("0")
 1 jump_false*(36)
 2 match_str("1")
 3 jump_false*(36)
 4 match_str("2")
 5 jump_false*(36)
 6 match_str("3")
 7 jump_false*(36)
 8 match_str("4")
 9 jump_false*(36)
10 match_str("5")
11 jump_false*(36)
12 match_str("6")
13 jump_false*(36)
14 match_str("7")
15 jump_false*(36)
16 match_str("8")
17 jump_false*(36)
18 match_str("9")
19 jump_false*(36)
20 match_str("10")
21 jump_false*(36)
22 match_str("11")
23 jump_false*(36)
24 match_str("12")
25 jump_false*(36)
26 match_str("13")
27 jump_false*(36)
28 match_str("14")
29 jump_false*(36)
30 match_str("15")
31 jump_false*(36)
32 match_str("16")
33 jump_false*(36)
34 match_str("17")
35 jump_true(eos)
36 match_str("18")
37 jump_false(eos)
38 match_str("19")
39 jump_false(eos)
40 match_str("20")
41 jump_false(eos)
42 match_str("21")
43 jump_false(eos)
44 match_str("22")
45 jump_false(eos)
46 match_str("23")
47 jump_false(eos)
48 match_str("24")
49 jump_false(eos)
50 match_str("25")
51 jump_false(eos)
52 match_str("26")
53 jump_false(eos)
54 match_str("27")
55 jump_false(eos)
56 match_str("28")
57 jump_false(eos)
58 match_str("29")
59 jump_false(eos)
60 match_str("30")
61 jump_false(eos)
62 match_str("31")
63 jump_false(eos)
64 match_str("32")
65 jump_false(eos)
66 match_str("33")
67 jump_false(eos)
68 match_str("34")
69 jump_false(eos)
70 match_str("35")
$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`||`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`'\''
 0 match_str("0")
 1 jump_false*(38)
 2 match_str("1")
 3 jump_false*(38)
 4 match_str("2")
 5 jump_false*(38)
 6 match_str("3")
 7 jump_false*(38)
 8 match_str("4")
 9 jump_false*(38)
10 match_str("5")
11 jump_false*(38)
12 match_str("6")
13 jump_false*(38)
14 match_str("7")
15 jump_false*(38)
16 match_str("8")
17 jump_false*(38)
18 match_str("9")
19 jump_false*(38)
20 match_str("10")
21 jump_false*(38)
22 match_str("11")
23 jump_false*(38)
24 match_str("12")
25 jump_false*(38)
26 match_str("13")
27 jump_false*(38)
28 match_str("14")
29 jump_false*(38)
30 match_str("15")
31 jump_false*(38)
32 match_str("16")
33 jump_false*(38)
34 match_str("17")
35 jump_false*(38)
36 match_str("18")
37 jump_true(eos)
38 match_str("19")
39 jump_false(eos)
40 match_str("20")
41 jump_false(eos)
42 match_str("21")
43 jump_false(eos)
44 match_str("22")
45 jump_false(eos)
46 match_str("23")
47 jump_false(eos)
48 match_str("24")
49 jump_false(eos)
50 match_str("25")
51 jump_false(eos)
52 match_str("26")
53 jump_false(eos)
54 match_str("27")
55 jump_false(eos)
56 match_str("28")
57 jump_false(eos)
58 match_str("29")
59 jump_false(eos)
60 match_str("30")
61 jump_false(eos)
62 match_str("31")
63 jump_false(eos)
64 match_str("32")
65 jump_false(eos)
66 match_str("33")
67 jump_false(eos)
68 match_str("34")
69 jump_false(eos)
70 match_str("35")
71 jump_false(eos)
72 match_str("36")
$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`||`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`'\''
 0 match_str("0")
 1 jump_false*(38)
 2 match_str("1")
 3 jump_false*(38)
 4 match_str("2")
 5 jump_false*(38)
 6 match_str("3")
 7 jump_false*(38)
 8 match_str("4")
 9 jump_false*(38)
10 match_str("5")
11 jump_false*(38)
12 match_str("6")
13 jump_false*(38)
14 match_str("7")
15 jump_false*(38)
16 match_str("8")
17 jump_false*(38)
18 match_str("9")
19 jump_false*(38)
20 match_str("10")
21 jump_false*(38)
22 match_str("11")
23 jump_false*(38)
24 match_str("12")
25 jump_false*(38)
26 match_str("13")
27 jump_false*(38)
28 match_str("14")
29 jump_false*(38)
30 match_str("15")
31 jump_false*(38)
32 match_str("16")
33 jump_false*(38)
34 match_str("17")
35 jump_false*(38)
36 match_str("18")
37 jump_true(eos)
38 match_str("19")
39 jump_false(eos)
40 match_str("20")
41 jump_false(eos)
42 match_str("21")
43 jump_false(eos)
44 match_str("22")
45 jump_false(eos)
46 match_str("23")
47 jump_false(eos)
48 match_str("24")
49 jump_false(eos)
50 match_str("25")
51 jump_false(eos)
52 match_str("26")
53 jump_false(eos)
54 match_str("27")
55 jump_false(eos)
56 match_str("28")
57 jump_false(eos)
58 match_str("29")
59 jump_false(eos)
60 match_str("30")
61 jump_false(eos)
62 match_str("31")
63 jump_false(eos)
64 match_str("32")
65 jump_false(eos)
66 match_str("33")
67 jump_false(eos)
68 match_str("34")
69 jump_false(eos)
70 match_str("35")
71 jump_false(eos)
72 match_str("36")
73 jump_false(eos)
74 match_str("37")
$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`||`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`'\''
 0 match_str("0")
 1 jump_false*(40)
 2 match_str("1")
 3 jump_false*(40)
 4 match_str("2")
 5 jump_false*(40)
 6 match_str("3")
 7 jump_false*(40)
 8 match_str("4")
 9 jump_false*(40)
10 match_str("5")
11 jump_false*(40)
12 match_str("6")
13 jump_false*(40)
14 match_str("7")
15 jump_false*(40)
16 match_str("8")
17 jump_false*(40)
18 match_str("9")
19 jump_false*(40)
20 match_str("10")
21 jump_false*(40)
22 match_str("11")
23 jump_false*(40)
24 match_str("12")
25 jump_false*(40)
26 match_str("13")
27 jump_false*(40)
28 match_str("14")
29 jump_false*(40)
30 match_str("15")
31 jump_false*(40)
32 match_str("16")
33 jump_false*(40)
34 match_str("17")
35 jump_false*(40)
36 match_str("18")
37 jump_false*(40)
38 match_str("19")
39 jump_true(eos)
40 match_str("20")
41 jump_false(eos)
42 match_str("21")
43 jump_false(eos)
44 match_str("22")
45 jump_false(eos)
46 match_str("23")
47 jump_false(eos)
48 match_str("24")
49 jump_false(eos)
50 match_str("25")
51 jump_false(eos)
52 match_str("26")
53 jump_false(eos)
54 match_str("27")
55 jump_false(eos)
56 match_str("28")
57 jump_false(eos)
58 match_str("29")
59 jump_false(eos)
60 match_str("30")
61 jump_false(eos)
62 match_str("31")
63 jump_false(eos)
64 match_str("32")
65 jump_false(eos)
66 match_str("33")
67 jump_false(eos)
68 match_str("34")
69 jump_false(eos)
70 match_str("35")
71 jump_false(eos)
72 match_str("36")
73 jump_false(eos)
74 match_str("37")
75 jump_false(eos)
76 match_str("38")
$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`||`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`'\''
 0 match_str("0")
 1 jump_false*(40)
 2 match_str("1")
 3 jump_false*(40)
 4 match_str("2")
 5 jump_false*(40)
 6 match_str("3")
 7 jump_false*(40)
 8 match_str("4")
 9 jump_false*(40)
10 match_str("5")
11 jump_false*(40)
12 match_str("6")
13 jump_false*(40)
14 match_str("7")
15 jump_false*(40)
16 match_str("8")
17 jump_false*(40)
18 match_str("9")
19 jump_false*(40)
20 match_str("10")
21 jump_false*(40)
22 match_str("11")
23 jump_false*(40)
24 match_str("12")
25 jump_false*(40)
26 match_str("13")
27 jump_false*(40)
28 match_str("14")
29 jump_false*(40)
30 match_str("15")
31 jump_false*(40)
32 match_str("16")
33 jump_false*(40)
34 match_str("17")
35 jump_false*(40)
36 match_str("18")
37 jump_false*(40)
38 match_str("19")
39 jump_true(eos)
40 match_str("20")
41 jump_false(eos)
42 match_str("21")
43 jump_false(eos)
44 match_str("22")
45 jump_false(eos)
46 match_str("23")
47 jump_false(eos)
48 match_str("24")
49 jump_false(eos)
50 match_str("25")
51 jump_false(eos)
52 match_str("26")
53 jump_false(eos)
54 match_str("27")
55 jump_false(eos)
56 match_str("28")
57 jump_false(eos)
58 match_str("29")
59 jump_false(eos)
60 match_str("30")
61 jump_false(eos)
62 match_str("31")
63 jump_false(eos)
64 match_str("32")
65 jump_false(eos)
66 match_str("33")
67 jump_false(eos)
68 match_str("34")
69 jump_false(eos)
70 match_str("35")
71 jump_false(eos)
72 match_str("36")
73 jump_false(eos)
74 match_str("37")
75 jump_false(eos)
76 match_str("38")
77 jump_false(eos)
78 match_str("39")
$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`||`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`'\''
 0 match_str("0")
 1 jump_false*(42)
 2 match_str("1")
 3 jump_false*(42)
 4 match_str("2")
 5 jump_false*(42)
 6 match_str("3")
 7 jump_false*(42)
 8 match_str("4")
 9 jump_false*(42)
10 match_str("5")
11 jump_false*(42)
12 match_str("6")
13 jump_false*(42)
14 match_str("7")
15 jump_false*(42)
16 match_str("8")
17 jump_false*(42)
18 match_str("9")
19 jump_false*(42)
20 match_str("10")
21 jump_false*(42)
22 match_str("11")
23 jump_false*(42)
24 match_str("12")
25 jump_false*(42)
26 match_str("13")
27 jump_false*(42)
28 match_str("14")
29 jump_false*(42)
30 match_str("15")
31 jump_false*(42)
32 match_str("16")
33 jump_false*(42)
34 match_str("17")
35 jump_false*(42)
36 match_str("18")
37 jump_false*(42)
38 match_str("19")
39 jump_false*(42)
40 match_str("20")
41 jump_true(eos)
42 match_str("21")
43 jump_false(eos)
44 match_str("22")
45 jump_false(eos)
46 match_str("23")
47 jump_false(eos)
48 match_str("24")
49 jump_false(eos)
50 match_str("25")
51 jump_false(eos)
52 match_str("26")
53 jump_false(eos)
54 match_str("27")
55 jump_false(eos)
56 match_str("28")
57 jump_false(eos)
58 match_str("29")
59 jump_false(eos)
60 match_str("30")
61 jump_false(eos)
62 match_str("31")
63 jump_false(eos)
64 match_str("32")
65 jump_false(eos)
66 match_str("33")
67 jump_false(eos)
68 match_str("34")
69 jump_false(eos)
70 match_str("35")
71 jump_false(eos)
72 match_str("36")
73 jump_false(eos)
74 match_str("37")
75 jump_false(eos)
76 match_str("38")
77 jump_false(eos)
78 match_str("39")
79 jump_false(eos)
80 match_str("40")
$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`||`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`'\''
 0 match_str("0")
 1 jump_false*(42)
 2 match_str("1")
 3 jump_false*(42)
 4 match_str("2")
 5 jump_false*(42)
 6 match_str("3")
 7 jump_false*(42)
 8 match_str("4")
 9 jump_false*(42)
10 match_str("5")
11 jump_false*(42)
12 match_str("6")
13 jump_false*(42)
14 match_str("7")
15 jump_false*(42)
16 match_str("8")
17 jump_false*(42)
18 match_str("9")
19 jump_false*(42)
20 match_str("10")
21 jump_false*(42)
22 match_str("11")
23 jump_false*(42)
24 match_str("12")
25 jump_false*(42)
26 match_str("13")
27 jump_false*(42)
28 match_str("14")
29 jump_false*(42)
30 match_str("15")
31 jump_false*(42)
32 match_str("16")
33 jump_false*(42)
34 match_str("17")
35 jump_false*(42)
36 match_str("18")
37 jump_false*(42)
38 match_str("19")
39 jump_false*(42)
40 match_str("20")
41 jump_true(eos)
42 match_str("21")
43 jump_false(eos)
44 match_str("22")
45 jump_false(eos)
46 match_str("23")
47 jump_false(eos)
48 match_str("24")
49 jump_false(eos)
50 match_str("25")
51 jump_false(eos)
52 match_str("26")
53 jump_false(eos)
54 match_str("27")
55 jump_false(eos)
56 match_str("28")
57 jump_false(eos)
58 match_str("29")
59 jump_false(eos)
60 match_str("30")
61 jump_false(eos)
62 match_str("31")
63 jump_false(eos)
64 match_str("32")
65 jump_false(eos)
66 match_str("33")
67 jump_false(eos)
68 match_str("34")
69 jump_false(eos)
70 match_str("35")
71 jump_false(eos)
72 match_str("36")
73 jump_false(eos)
74 match_str("37")
75 jump_false(eos)
76 match_str("38")
77 jump_false(eos)
78 match_str("39")
79 jump_false(eos)
80 match_str("40")
81 jump_false(eos)
82 match_str("41")
$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`||`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`'\''
 0 match_str("0")
 1 jump_false*(44)
 2 match_str("1")
 3 jump_false*(44)
 4 match_str("2")
 5 jump_false*(44)
 6 match_str("3")
 7 jump_false*(44)
 8 match_str("4")
 9 jump_false*(44)
10 match_str("5")
11 jump_false*(44)
12 match_str("6")
13 jump_false*(44)
14 match_str("7")
15 jump_false*(44)
16 match_str("8")
17 jump_false*(44)
18 match_str("9")
19 jump_false*(44)
20 match_str("10")
21 jump_false*(44)
22 match_str("11")
23 jump_false*(44)
24 match_str("12")
25 jump_false*(44)
26 match_str("13")
27 jump_false*(44)
28 match_str("14")
29 jump_false*(44)
30 match_str("15")
31 jump_false*(44)
32 match_str("16")
33 jump_false*(44)
34 match_str("17")
35 jump_false*(44)
36 match_str("18")
37 jump_false*(44)
38 match_str("19")
39 jump_false*(44)
40 match_str("20")
41 jump_false*(44)
42 match_str("21")
43 jump_true(eos)
44 match_str("22")
45 jump_false(eos)
46 match_str("23")
47 jump_false(eos)
48 match_str("24")
49 jump_false(eos)
50 match_str("25")
51 jump_false(eos)
52 match_str("26")
53 jump_false(eos)
54 match_str("27")
55 jump_false(eos)
56 match_str("28")
57 jump_false(eos)
58 match_str("29")
59 jump_false(eos)
60 match_str("30")
61 jump_false(eos)
62 match_str("31")
63 jump_false(eos)
64 match_str("32")
65 jump_false(eos)
66 match_str("33")
67 jump_false(eos)
68 match_str("34")
69 jump_false(eos)
70 match_str("35")
71 jump_false(eos)
72 match_str("36")
73 jump_false(eos)
74 match_str("37")
75 jump_false(eos)
76 match_str("38")
77 jump_false(eos)
78 match_str("39")
79 jump_false(eos)
80 match_str("40")
81 jump_false(eos)
82 match_str("41")
83 jump_false(eos)
84 match_str("42")
$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`||`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`'\''
 0 match_str("0")
 1 jump_false*(44)
 2 match_str("1")
 3 jump_false*(44)
 4 match_str("2")
 5 jump_false*(44)
 6 match_str("3")
 7 jump_false*(44)
 8 match_str("4")
 9 jump_false*(44)
10 match_str("5")
11 jump_false*(44)
12 match_str("6")
13 jump_false*(44)
14 match_str("7")
15 jump_false*(44)
16 match_str("8")
17 jump_false*(44)
18 match_str("9")
19 jump_false*(44)
20 match_str("10")
21 jump_false*(44)
22 match_str("11")
23 jump_false*(44)
24 match_str("12")
25 jump_false*(44)
26 match_str("13")
27 jump_false*(44)
28 match_str("14")
29 jump_false*(44)
30 match_str("15")
31 jump_false*(44)
32 match_str("16")
33 jump_false*(44)
34 match_str("17")
35 jump_false*(44)
36 match_str("18")
37 jump_false*(44)
38 match_str("19")
39 jump_false*(44)
40 match_str("20")
41 jump_false*(44)
42 match_str("21")
43 jump_true(eos)
44 match_str("22")
45 jump_false(eos)
46 match_str("23")
47 jump_false(eos)
48 match_str("24")
49 jump_false(eos)
50 match_str("25")
51 jump_false(eos)
52 match_str("26")
53 jump_false(eos)
54 match_str("27")
55 jump_false(eos)
56 match_str("28")
57 jump_false(eos)
58 match_str("29")
59 jump_false(eos)
60 match_str("30")
61 jump_false(eos)
62 match_str("31")
63 jump_false(eos)
64 match_str("32")
65 jump_false(eos)
66 match_str("33")
67 jump_false(eos)
68 match_str("34")
69 jump_false(eos)
70 match_str("35")
71 jump_false(eos)
72 match_str("36")
73 jump_false(eos)
74 match_str("37")
75 jump_false(eos)
76 match_str("38")
77 jump_false(eos)
78 match_str("39")
79 jump_false(eos)
80 match_str("40")
81 jump_false(eos)
82 match_str("41")
83 jump_false(eos)
84 match_str("42")
85 jump_false(eos)
86 match_str("43")
$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`||`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`'\''
 0 match_str("0")
 1 jump_false*(46)
 2 match_str("1")
 3 jump_false*(46)
 4 match_str("2")
 5 jump_false*(46)
 6 match_str("3")
 7 jump_false*(46)
 8 match_str("4")
 9 jump_false*(46)
10 match_str("5")
11 jump_false*(46)
12 match_str("6")
13 jump_false*(46)
14 match_str("7")
15 jump_false*(46)
16 match_str("8")
17 jump_false*(46)
18 match_str("9")
19 jump_false*(46)
20 match_str("10")
21 jump_false*(46)
22 match_str("11")
23 jump_false*(46)
24 match_str("12")
25 jump_false*(46)
26 match_str("13")
27 jump_false*(46)
28 match_str("14")
29 jump_false*(46)
30 match_str("15")
31 jump_false*(46)
32 match_str("16")
33 jump_false*(46)
34 match_str("17")
35 jump_false*(46)
36 match_str("18")
37 jump_false*(46)
38 match_str("19")
39 jump_false*(46)
40 match_str("20")
41 jump_false*(46)
42 match_str("21")
43 jump_false*(46)
44 match_str("22")
45 jump_true(eos)
46 match_str("23")
47 jump_false(eos)
48 match_str("24")
49 jump_false(eos)
50 match_str("25")
51 jump_false(eos)
52 match_str("26")
53 jump_false(eos)
54 match_str("27")
55 jump_false(eos)
56 match_str("28")
57 jump_false(eos)
58 match_str("29")
59 jump_false(eos)
60 match_str("30")
61 jump_false(eos)
62 match_str("31")
63 jump_false(eos)
64 match_str("32")
65 jump_false(eos)
66 match_str("33")
67 jump_false(eos)
68 match_str("34")
69 jump_false(eos)
70 match_str("35")
71 jump_false(eos)
72 match_str("36")
73 jump_false(eos)
74 match_str("37")
75 jump_false(eos)
76 match_str("38")
77 jump_false(eos)
78 match_str("39")
79 jump_false(eos)
80 match_str("40")
81 jump_false(eos)
82 match_str("41")
83 jump_false(eos)
84 match_str("42")
85 jump_false(eos)
86 match_str("43")
87 jump_false(eos)
88 match_str("44")
$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`||`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`'\''
 0 match_str("0")
 1 jump_false*(46)
 2 match_str("1")
 3 jump_false*(46)
 4 match_str("2")
 5 jump_false*(46)
 6 match_str("3")
 7 jump_false*(46)
 8 match_str("4")
 9 jump_false*(46)
10 match_str("5")
11 jump_false*(46)
12 match_str("6")
13 jump_false*(46)
14 match_str("7")
15 jump_false*(46)
16 match_str("8")
17 jump_false*(46)
18 match_str("9")
19 jump_false*(46)
20 match_str("10")
21 jump_false*(46)
22 match_str("11")
23 jump_false*(46)
24 match_str("12")
25 jump_false*(46)
26 match_str("13")
27 jump_false*(46)
28 match_str("14")
29 jump_false*(46)
30 match_str("15")
31 jump_false*(46)
32 match_str("16")
33 jump_false*(46)
34 match_str("17")
35 jump_false*(46)
36 match_str("18")
37 jump_false*(46)
38 match_str("19")
39 jump_false*(46)
40 match_str("20")
41 jump_false*(46)
42 match_str("21")
43 jump_false*(46)
44 match_str("22")
45 jump_true(eos)
46 match_str("23")
47 jump_false(eos)
48 match_str("24")
49 jump_false(eos)
50 match_str("25")
51 jump_false(eos)
52 match_str("26")
53 jump_false(eos)
54 match_str("27")
55 jump_false(eos)
56 match_str("28")
57 jump_false(eos)
58 match_str("29")
59 jump_false(eos)
60 match_str("30")
61 jump_false(eos)
62 match_str("31")
63 jump_false(eos)
64 match_str("32")
65 jump_false(eos)
66 match_str("33")
67 jump_false(eos)
68 match_str("34")
69 jump_false(eos)
70 match_str("35")
71 jump_false(eos)
72 match_str("36")
73 jump_false(eos)
74 match_str("37")
75 jump_false(eos)
76 match_str("38")
77 jump_false(eos)
78 match_str("39")
79 jump_false(eos)
80 match_str("40")
81 jump_false(eos)
82 match_str("41")
83 jump_false(eos)
84 match_str("42")
85 jump_false(eos)
86 match_str("43")
87 jump_false(eos)
88 match_str("44")
89 jump_false(eos)
90 match_str("45")
$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`||`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`'\''
 0 match_str("0")
 1 jump_false*(48)
 2 match_str("1")
 3 jump_false*(48)
 4 match_str("2")
 5 jump_false*(48)
 6 match_str("3")
 7 jump_false*(48)
 8 match_str("4")
 9 jump_false*(48)
10 match_str("5")
11 jump_false*(48)
12 match_str("6")
13 jump_false*(48)
14 match_str("7")
15 jump_false*(48)
16 match_str("8")
17 jump_false*(48)
18 match_str("9")
19 jump_false*(48)
20 match_str("10")
21 jump_false*(48)
22 match_str("11")
23 jump_false*(48)
24 match_str("12")
25 jump_false*(48)
26 match_str("13")
27 jump_false*(48)
28 match_str("14")
29 jump_false*(48)
30 match_str("15")
31 jump_false*(48)
32 match_str("16")
33 jump_false*(48)
34 match_str("17")
35 jump_false*(48)
36 match_str("18")
37 jump_false*(48)
38 match_str("19")
39 jump_false*(48)
40 match_str("20")
41 jump_false*(48)
42 match_str("21")
43 jump_false*(48)
44 match_str("22")
45 jump_false*(48)
46 match_str("23")
47 jump_true(eos)
48 match_str("24")
49 jump_false(eos)
50 match_str("25")
51 jump_false(eos)
52 match_str("26")
53 jump_false(eos)
54 match_str("27")
55 jump_false(eos)
56 match_str("28")
57 jump_false(eos)
58 match_str("29")
59 jump_false(eos)
60 match_str("30")
61 jump_false(eos)
62 match_str("31")
63 jump_false(eos)
64 match_str("32")
65 jump_false(eos)
66 match_str("33")
67 jump_false(eos)
68 match_str("34")
69 jump_false(eos)
70 match_str("35")
71 jump_false(eos)
72 match_str("36")
73 jump_false(eos)
74 match_str("37")
75 jump_false(eos)
76 match_str("38")
77 jump_false(eos)
78 match_str("39")
79 jump_false(eos)
80 match_str("40")
81 jump_false(eos)
82 match_str("41")
83 jump_false(eos)
84 match_str("42")
85 jump_false(eos)
86 match_str("43")
87 jump_false(eos)
88 match_str("44")
89 jump_false(eos)
90 match_str("45")
91 jump_false(eos)
92 match_str("46")
$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`||`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`&&`47`'\''
 0 match_str("0")
 1 jump_false*(48)
 2 match_str("1")
 3 jump_false*(48)
 4 match_str("2")
 5 jump_false*(48)
 6 match_str("3")
 7 jump_false*(48)
 8 match_str("4")
 9 jump_false*(48)
10 match_str("5")
11 jump_false*(48)
12 match_str("6")
13 jump_false*(48)
14 match_str("7")
15 jump_false*(48)
16 match_str("8")
17 jump_false*(48)
18 match_str("9")
19 jump_false*(48)
20 match_str("10")
21 jump_false*(48)
22 match_str("11")
23 jump_false*(48)
24 match_str("12")
25 jump_false*(48)
26 match_str("13")
27 jump_false*(48)
28 match_str("14")
29 jump_false*(48)
30 match_str("15")
31 jump_false*(48)
32 match_str("16")
33 jump_false*(48)
34 match_str("17")
35 jump_false*(48)
36 match_str("18")
37 jump_false*(48)
38 match_str("19")
39 jump_false*(48)
40 match_str("20")
41 jump_false*(48)
42 match_str("21")
43 jump_false*(48)
44 match_str("22")
45 jump_false*(48)
46 match_str("23")
47 jump_true(eos)
48 match_str("24")
49 jump_false(eos)
50 match_str("25")
51 jump_false(eos)
52 match_str("26")
53 jump_false(eos)
54 match_str("27")
55 jump_false(eos)
56 match_str("28")
57 jump_false(eos)
58 match_str("29")
59 jump_false(eos)
60 match_str("30")
61 jump_false(eos)
62 match_str("31")
63 jump_false(eos)
64 match_str("32")
65 jump_false(eos)
66 match_str("33")
67 jump_false(eos)
68 match_str("34")
69 jump_false(eos)
70 match_str("35")
71 jump_false(eos)
72 match_str("36")
73 jump_false(eos)
74 match_str("37")
75 jump_false(eos)
76 match_str("38")
77 jump_false(eos)
78 match_str("39")
79 jump_false(eos)
80 match_str("40")
81 jump_false(eos)
82 match_str("41")
83 jump_false(eos)
84 match_str("42")
85 jump_false(eos)
86 match_str("43")
87 jump_false(eos)
88 match_str("44")
89 jump_false(eos)
90 match_str("45")
91 jump_false(eos)
92 match_str("46")
93 jump_false(eos)
94 match_str("47")
$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`||`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`&&`47`&&`48`'\''
 0 match_str("0")
 1 jump_false*(50)
 2 match_str("1")
 3 jump_false*(50)
 4 match_str("2")
 5 jump_false*(50)
 6 match_str("3")
 7 jump_false*(50)
 8 match_str("4")
 9 jump_false*(50)
10 match_str("5")
11 jump_false*(50)
12 match_str("6")
13 jump_false*(50)
14 match_str("7")
15 jump_false*(50)
16 match_str("8")
17 jump_false*(50)
18 match_str("9")
19 jump_false*(50)
20 match_str("10")
21 jump_false*(50)
22 match_str("11")
23 jump_false*(50)
24 match_str("12")
25 jump_false*(50)
26 match_str("13")
27 jump_false*(50)
28 match_str("14")
29 jump_false*(50)
30 match_str("15")
31 jump_false*(50)
32 match_str("16")
33 jump_false*(50)
34 match_str("17")
35 jump_false*(50)
36 match_str("18")
37 jump_false*(50)
38 match_str("19")
39 jump_false*(50)
40 match_str("20")
41 jump_false*(50)
42 match_str("21")
43 jump_false*(50)
44 match_str("22")
45 jump_false*(50)
46 match_str("23")
47 jump_false*(50)
48 match_str("24")
49 jump_true(eos)
50 match_str("25")
51 jump_false(eos)
52 match_str("26")
53 jump_false(eos)
54 match_str("27")
55 jump_false(eos)
56 match_str("28")
57 jump_false(eos)
58 match_str("29")
59 jump_false(eos)
60 match_str("30")
61 jump_false(eos)
62 match_str("31")
63 jump_false(eos)
64 match_str("32")
65 jump_false(eos)
66 match_str("33")
67 jump_false(eos)
68 match_str("34")
69 jump_false(eos)
70 match_str("35")
71 jump_false(eos)
72 match_str("36")
73 jump_false(eos)
74 match_str("37")
75 jump_false(eos)
76 match_str("38")
77 jump_false(eos)
78 match_str("39")
79 jump_false(eos)
80 match_str("40")
81 jump_false(eos)
82 match_str("41")
83 jump_false(eos)
84 match_str("42")
85 jump_false(eos)
86 match_str("43")
87 jump_false(eos)
88 match_str("44")
89 jump_false(eos)
90 match_str("45")
91 jump_false(eos)
92 match_str("46")
93 jump_false(eos)
94 match_str("47")
95 jump_false(eos)
96 match_str("48")
$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`||`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`&&`47`&&`48`&&`49`'\''
 0 match_str("0")
 1 jump_false*(50)
 2 match_str("1")
 3 jump_false*(50)
 4 match_str("2")
 5 jump_false*(50)
 6 match_str("3")
 7 jump_false*(50)
 8 match_str("4")
 9 jump_false*(50)
10 match_str("5")
11 jump_false*(50)
12 match_str("6")
13 jump_false*(50)
14 match_str("7")
15 jump_false*(50)
16 match_str("8")
17 jump_false*(50)
18 match_str("9")
19 jump_false*(50)
20 match_str("10")
21 jump_false*(50)
22 match_str("11")
23 jump_false*(50)
24 match_str("12")
25 jump_false*(50)
26 match_str("13")
27 jump_false*(50)
28 match_str("14")
29 jump_false*(50)
30 match_str("15")
31 jump_false*(50)
32 match_str("16")
33 jump_false*(50)
34 match_str("17")
35 jump_false*(50)
36 match_str("18")
37 jump_false*(50)
38 match_str("19")
39 jump_false*(50)
40 match_str("20")
41 jump_false*(50)
42 match_str("21")
43 jump_false*(50)
44 match_str("22")
45 jump_false*(50)
46 match_str("23")
47 jump_false*(50)
48 match_str("24")
49 jump_true(eos)
50 match_str("25")
51 jump_false(eos)
52 match_str("26")
53 jump_false(eos)
54 match_str("27")
55 jump_false(eos)
56 match_str("28")
57 jump_false(eos)
58 match_str("29")
59 jump_false(eos)
60 match_str("30")
61 jump_false(eos)
62 match_str("31")
63 jump_false(eos)
64 match_str("32")
65 jump_false(eos)
66 match_str("33")
67 jump_false(eos)
68 match_str("34")
69 jump_false(eos)
70 match_str("35")
71 jump_false(eos)
72 match_str("36")
73 jump_false(eos)
74 match_str("37")
75 jump_false(eos)
76 match_str("38")
77 jump_false(eos)
78 match_str("39")
79 jump_false(eos)
80 match_str("40")
81 jump_false(eos)
82 match_str("41")
83 jump_false(eos)
84 match_str("42")
85 jump_false(eos)
86 match_str("43")
87 jump_false(eos)
88 match_str("44")
89 jump_false(eos)
90 match_str("45")
91 jump_false(eos)
92 match_str("46")
93 jump_false(eos)
94 match_str("47")
95 jump_false(eos)
96 match_str("48")
97 jump_false(eos)
98 match_str("49")
$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`||`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`&&`47`&&`48`&&`49`&&`50`'\''
  0 match_str("0")
  1 jump_false*(52)
  2 match_str("1")
  3 jump_false*(52)
  4 match_str("2")
  5 jump_false*(52)
  6 match_str("3")
  7 jump_false*(52)
  8 match_str("4")
  9 jump_false*(52)
 10 match_str("5")
 11 jump_false*(52)
 12 match_str("6")
 13 jump_false*(52)
 14 match_str("7")
 15 jump_false*(52)
 16 match_str("8")
 17 jump_false*(52)
 18 match_str("9")
 19 jump_false*(52)
 20 match_str("10")
 21 jump_false*(52)
 22 match_str("11")
 23 jump_false*(52)
 24 match_str("12")
 25 jump_false*(52)
 26 match_str("13")
 27 jump_false*(52)
 28 match_str("14")
 29 jump_false*(52)
 30 match_str("15")
 31 jump_false*(52)
 32 match_str("16")
 33 jump_false*(52)
 34 match_str("17")
 35 jump_false*(52)
 36 match_str("18")
 37 jump_false*(52)
 38 match_str("19")
 39 jump_false*(52)
 40 match_str("20")
 41 jump_false*(52)
 42 match_str("21")
 43 jump_false*(52)
 44 match_str("22")
 45 jump_false*(52)
 46 match_str("23")
 47 jump_false*(52)
 48 match_str("24")
 49 jump_false*(52)
 50 match_str("25")
 51 jump_true(eos)
 52 match_str("26")
 53 jump_false(eos)
 54 match_str("27")
 55 jump_false(eos)
 56 match_str("28")
 57 jump_false(eos)
 58 match_str("29")
 59 jump_false(eos)
 60 match_str("30")
 61 jump_false(eos)
 62 match_str("31")
 63 jump_false(eos)
 64 match_str("32")
 65 jump_false(eos)
 66 match_str("33")
 67 jump_false(eos)
 68 match_str("34")
 69 jump_false(eos)
 70 match_str("35")
 71 jump_false(eos)
 72 match_str("36")
 73 jump_false(eos)
 74 match_str("37")
 75 jump_false(eos)
 76 match_str("38")
 77 jump_false(eos)
 78 match_str("39")
 79 jump_false(eos)
 80 match_str("40")
 81 jump_false(eos)
 82 match_str("41")
 83 jump_false(eos)
 84 match_str("42")
 85 jump_false(eos)
 86 match_str("43")
 87 jump_false(eos)
 88 match_str("44")
 89 jump_false(eos)
 90 match_str("45")
 91 jump_false(eos)
 92 match_str("46")
 93 jump_false(eos)
 94 match_str("47")
 95 jump_false(eos)
 96 match_str("48")
 97 jump_false(eos)
 98 match_str("49")
 99 jump_false(eos)
100 match_str("50")
$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`||`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`&&`47`&&`48`&&`49`&&`50`&&`51`'\''
  0 match_str("0")
  1 jump_false*(52)
  2 match_str("1")
  3 jump_false*(52)
  4 match_str("2")
  5 jump_false*(52)
  6 match_str("3")
  7 jump_false*(52)
  8 match_str("4")
  9 jump_false*(52)
 10 match_str("5")
 11 jump_false*(52)
 12 match_str("6")
 13 jump_false*(52)
 14 match_str("7")
 15 jump_false*(52)
 16 match_str("8")
 17 jump_false*(52)
 18 match_str("9")
 19 jump_false*(52)
 20 match_str("10")
 21 jump_false*(52)
 22 match_str("11")
 23 jump_false*(52)
 24 match_str("12")
 25 jump_false*(52)
 26 match_str("13")
 27 jump_false*(52)
 28 match_str("14")
 29 jump_false*(52)
 30 match_str("15")
 31 jump_false*(52)
 32 match_str("16")
 33 jump_false*(52)
 34 match_str("17")
 35 jump_false*(52)
 36 match_str("18")
 37 jump_false*(52)
 38 match_str("19")
 39 jump_false*(52)
 40 match_str("20")
 41 jump_false*(52)
 42 match_str("21")
 43 jump_false*(52)
 44 match_str("22")
 45 jump_false*(52)
 46 match_str("23")
 47 jump_false*(52)
 48 match_str("24")
 49 jump_false*(52)
 50 match_str("25")
 51 jump_true(eos)
 52 match_str("26")
 53 jump_false(eos)
 54 match_str("27")
 55 jump_false(eos)
 56 match_str("28")
 57 jump_false(eos)
 58 match_str("29")
 59 jump_false(eos)
 60 match_str("30")
 61 jump_false(eos)
 62 match_str("31")
 63 jump_false(eos)
 64 match_str("32")
 65 jump_false(eos)
 66 match_str("33")
 67 jump_false(eos)
 68 match_str("34")
 69 jump_false(eos)
 70 match_str("35")
 71 jump_false(eos)
 72 match_str("36")
 73 jump_false(eos)
 74 match_str("37")
 75 jump_false(eos)
 76 match_str("38")
 77 jump_false(eos)
 78 match_str("39")
 79 jump_false(eos)
 80 match_str("40")
 81 jump_false(eos)
 82 match_str("41")
 83 jump_false(eos)
 84 match_str("42")
 85 jump_false(eos)
 86 match_str("43")
 87 jump_false(eos)
 88 match_str("44")
 89 jump_false(eos)
 90 match_str("45")
 91 jump_false(eos)
 92 match_str("46")
 93 jump_false(eos)
 94 match_str("47")
 95 jump_false(eos)
 96 match_str("48")
 97 jump_false(eos)
 98 match_str("49")
 99 jump_false(eos)
100 match_str("50")
101 jump_false(eos)
102 match_str("51")
$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`||`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`&&`47`&&`48`&&`49`&&`50`&&`51`&&`52`'\''
  0 match_str("0")
  1 jump_false*(54)
  2 match_str("1")
  3 jump_false*(54)
  4 match_str("2")
  5 jump_false*(54)
  6 match_str("3")
  7 jump_false*(54)
  8 match_str("4")
  9 jump_false*(54)
 10 match_str("5")
 11 jump_false*(54)
 12 match_str("6")
 13 jump_false*(54)
 14 match_str("7")
 15 jump_false*(54)
 16 match_str("8")
 17 jump_false*(54)
 18 match_str("9")
 19 jump_false*(54)
 20 match_str("10")
 21 jump_false*(54)
 22 match_str("11")
 23 jump_false*(54)
 24 match_str("12")
 25 jump_false*(54)
 26 match_str("13")
 27 jump_false*(54)
 28 match_str("14")
 29 jump_false*(54)
 30 match_str("15")
 31 jump_false*(54)
 32 match_str("16")
 33 jump_false*(54)
 34 match_str("17")
 35 jump_false*(54)
 36 match_str("18")
 37 jump_false*(54)
 38 match_str("19")
 39 jump_false*(54)
 40 match_str("20")
 41 jump_false*(54)
 42 match_str("21")
 43 jump_false*(54)
 44 match_str("22")
 45 jump_false*(54)
 46 match_str("23")
 47 jump_false*(54)
 48 match_str("24")
 49 jump_false*(54)
 50 match_str("25")
 51 jump_false*(54)
 52 match_str("26")
 53 jump_true(eos)
 54 match_str("27")
 55 jump_false(eos)
 56 match_str("28")
 57 jump_false(eos)
 58 match_str("29")
 59 jump_false(eos)
 60 match_str("30")
 61 jump_false(eos)
 62 match_str("31")
 63 jump_false(eos)
 64 match_str("32")
 65 jump_false(eos)
 66 match_str("33")
 67 jump_false(eos)
 68 match_str("34")
 69 jump_false(eos)
 70 match_str("35")
 71 jump_false(eos)
 72 match_str("36")
 73 jump_false(eos)
 74 match_str("37")
 75 jump_false(eos)
 76 match_str("38")
 77 jump_false(eos)
 78 match_str("39")
 79 jump_false(eos)
 80 match_str("40")
 81 jump_false(eos)
 82 match_str("41")
 83 jump_false(eos)
 84 match_str("42")
 85 jump_false(eos)
 86 match_str("43")
 87 jump_false(eos)
 88 match_str("44")
 89 jump_false(eos)
 90 match_str("45")
 91 jump_false(eos)
 92 match_str("46")
 93 jump_false(eos)
 94 match_str("47")
 95 jump_false(eos)
 96 match_str("48")
 97 jump_false(eos)
 98 match_str("49")
 99 jump_false(eos)
100 match_str("50")
101 jump_false(eos)
102 match_str("51")
103 jump_false(eos)
104 match_str("52")
$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`||`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`&&`47`&&`48`&&`49`&&`50`&&`51`&&`52`&&`53`'\''
  0 match_str("0")
  1 jump_false*(54)
  2 match_str("1")
  3 jump_false*(54)
  4 match_str("2")
  5 jump_false*(54)
  6 match_str("3")
  7 jump_false*(54)
  8 match_str("4")
  9 jump_false*(54)
 10 match_str("5")
 11 jump_false*(54)
 12 match_str("6")
 13 jump_false*(54)
 14 match_str("7")
 15 jump_false*(54)
 16 match_str("8")
 17 jump_false*(54)
 18 match_str("9")
 19 jump_false*(54)
 20 match_str("10")
 21 jump_false*(54)
 22 match_str("11")
 23 jump_false*(54)
 24 match_str("12")
 25 jump_false*(54)
 26 match_str("13")
 27 jump_false*(54)
 28 match_str("14")
 29 jump_false*(54)
 30 match_str("15")
 31 jump_false*(54)
 32 match_str("16")
 33 jump_false*(54)
 34 match_str("17")
 35 jump_false*(54)
 36 match_str("18")
 37 jump_false*(54)
 38 match_str("19")
 39 jump_false*(54)
 40 match_str("20")
 41 jump_false*(54)
 42 match_str("21")
 43 jump_false*(54)
 44 match_str("22")
 45 jump_false*(54)
 46 match_str("23")
 47 jump_false*(54)
 48 match_str("24")
 49 jump_false*(54)
 50 match_str("25")
 51 jump_false*(54)
 52 match_str("26")
 53 jump_true(eos)
 54 match_str("27")
 55 jump_false(eos)
 56 match_str("28")
 57 jump_false(eos)
 58 match_str("29")
 59 jump_false(eos)
 60 match_str("30")
 61 jump_false(eos)
 62 match_str("31")
 63 jump_false(eos)
 64 match_str("32")
 65 jump_false(eos)
 66 match_str("33")
 67 jump_false(eos)
 68 match_str("34")
 69 jump_false(eos)
 70 match_str("35")
 71 jump_false(eos)
 72 match_str("36")
 73 jump_false(eos)
 74 match_str("37")
 75 jump_false(eos)
 76 match_str("38")
 77 jump_false(eos)
 78 match_str("39")
 79 jump_false(eos)
 80 match_str("40")
 81 jump_false(eos)
 82 match_str("41")
 83 jump_false(eos)
 84 match_str("42")
 85 jump_false(eos)
 86 match_str("43")
 87 jump_false(eos)
 88 match_str("44")
 89 jump_false(eos)
 90 match_str("45")
 91 jump_false(eos)
 92 match_str("46")
 93 jump_false(eos)
 94 match_str("47")
 95 jump_false(eos)
 96 match_str("48")
 97 jump_false(eos)
 98 match_str("49")
 99 jump_false(eos)
100 match_str("50")
101 jump_false(eos)
102 match_str("51")
103 jump_false(eos)
104 match_str("52")
105 jump_false(eos)
106 match_str("53")
$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`||`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`&&`47`&&`48`&&`49`&&`50`&&`51`&&`52`&&`53`&&`54`'\''
  0 match_str("0")
  1 jump_false*(56)
  2 match_str("1")
  3 jump_false*(56)
  4 match_str("2")
  5 jump_false*(56)
  6 match_str("3")
  7 jump_false*(56)
  8 match_str("4")
  9 jump_false*(56)
 10 match_str("5")
 11 jump_false*(56)
 12 match_str("6")
 13 jump_false*(56)
 14 match_str("7")
 15 jump_false*(56)
 16 match_str("8")
 17 jump_false*(56)
 18 match_str("9")
 19 jump_false*(56)
 20 match_str("10")
 21 jump_false*(56)
 22 match_str("11")
 23 jump_false*(56)
 24 match_str("12")
 25 jump_false*(56)
 26 match_str("13")
 27 jump_false*(56)
 28 match_str("14")
 29 jump_false*(56)
 30 match_str("15")
 31 jump_false*(56)
 32 match_str("16")
 33 jump_false*(56)
 34 match_str("17")
 35 jump_false*(56)
 36 match_str("18")
 37 jump_false*(56)
 38 match_str("19")
 39 jump_false*(56)
 40 match_str("20")
 41 jump_false*(56)
 42 match_str("21")
 43 jump_false*(56)
 44 match_str("22")
 45 jump_false*(56)
 46 match_str("23")
 47 jump_false*(56)
 48 match_str("24")
 49 jump_false*(56)
 50 match_str("25")
 51 jump_false*(56)
 52 match_str("26")
 53 jump_false*(56)
 54 match_str("27")
 55 jump_true(eos)
 56 match_str("28")
 57 jump_false(eos)
 58 match_str("29")
 59 jump_false(eos)
 60 match_str("30")
 61 jump_false(eos)
 62 match_str("31")
 63 jump_false(eos)
 64 match_str("32")
 65 jump_false(eos)
 66 match_str("33")
 67 jump_false(eos)
 68 match_str("34")
 69 jump_false(eos)
 70 match_str("35")
 71 jump_false(eos)
 72 match_str("36")
 73 jump_false(eos)
 74 match_str("37")
 75 jump_false(eos)
 76 match_str("38")
 77 jump_false(eos)
 78 match_str("39")
 79 jump_false(eos)
 80 match_str("40")
 81 jump_false(eos)
 82 match_str("41")
 83 jump_false(eos)
 84 match_str("42")
 85 jump_false(eos)
 86 match_str("43")
 87 jump_false(eos)
 88 match_str("44")
 89 jump_false(eos)
 90 match_str("45")
 91 jump_false(eos)
 92 match_str("46")
 93 jump_false(eos)
 94 match_str("47")
 95 jump_false(eos)
 96 match_str("48")
 97 jump_false(eos)
 98 match_str("49")
 99 jump_false(eos)
100 match_str("50")
101 jump_false(eos)
102 match_str("51")
103 jump_false(eos)
104 match_str("52")
105 jump_false(eos)
106 match_str("53")
107 jump_false(eos)
108 match_str("54")
$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`||`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`&&`47`&&`48`&&`49`&&`50`&&`51`&&`52`&&`53`&&`54`&&`55`'\''
  0 match_str("0")
  1 jump_false*(56)
  2 match_str("1")
  3 jump_false*(56)
  4 match_str("2")
  5 jump_false*(56)
  6 match_str("3")
  7 jump_false*(56)
  8 match_str("4")
  9 jump_false*(56)
 10 match_str("5")
 11 jump_false*(56)
 12 match_str("6")
 13 jump_false*(56)
 14 match_str("7")
 15 jump_false*(56)
 16 match_str("8")
 17 jump_false*(56)
 18 match_str("9")
 19 jump_false*(56)
 20 match_str("10")
 21 jump_false*(56)
 22 match_str("11")
 23 jump_false*(56)
 24 match_str("12")
 25 jump_false*(56)
 26 match_str("13")
 27 jump_false*(56)
 28 match_str("14")
 29 jump_false*(56)
 30 match_str("15")
 31 jump_false*(56)
 32 match_str("16")
 33 jump_false*(56)
 34 match_str("17")
 35 jump_false*(56)
 36 match_str("18")
 37 jump_false*(56)
 38 match_str("19")
 39 jump_false*(56)
 40 match_str("20")
 41 jump_false*(56)
 42 match_str("21")
 43 jump_false*(56)
 44 match_str("22")
 45 jump_false*(56)
 46 match_str("23")
 47 jump_false*(56)
 48 match_str("24")
 49 jump_false*(56)
 50 match_str("25")
 51 jump_false*(56)
 52 match_str("26")
 53 jump_false*(56)
 54 match_str("27")
 55 jump_true(eos)
 56 match_str("28")
 57 jump_false(eos)
 58 match_str("29")
 59 jump_false(eos)
 60 match_str("30")
 61 jump_false(eos)
 62 match_str("31")
 63 jump_false(eos)
 64 match_str("32")
 65 jump_false(eos)
 66 match_str("33")
 67 jump_false(eos)
 68 match_str("34")
 69 jump_false(eos)
 70 match_str("35")
 71 jump_false(eos)
 72 match_str("36")
 73 jump_false(eos)
 74 match_str("37")
 75 jump_false(eos)
 76 match_str("38")
 77 jump_false(eos)
 78 match_str("39")
 79 jump_false(eos)
 80 match_str("40")
 81 jump_false(eos)
 82 match_str("41")
 83 jump_false(eos)
 84 match_str("42")
 85 jump_false(eos)
 86 match_str("43")
 87 jump_false(eos)
 88 match_str("44")
 89 jump_false(eos)
 90 match_str("45")
 91 jump_false(eos)
 92 match_str("46")
 93 jump_false(eos)
 94 match_str("47")
 95 jump_false(eos)
 96 match_str("48")
 97 jump_false(eos)
 98 match_str("49")
 99 jump_false(eos)
100 match_str("50")
101 jump_false(eos)
102 match_str("51")
103 jump_false(eos)
104 match_str("52")
105 jump_false(eos)
106 match_str("53")
107 jump_false(eos)
108 match_str("54")
109 jump_false(eos)
110 match_str("55")
$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`||`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`&&`47`&&`48`&&`49`&&`50`&&`51`&&`52`&&`53`&&`54`&&`55`&&`56`'\''
  0 match_str("0")
  1 jump_false*(58)
  2 match_str("1")
  3 jump_false*(58)
  4 match_str("2")
  5 jump_false*(58)
  6 match_str("3")
  7 jump_false*(58)
  8 match_str("4")
  9 jump_false*(58)
 10 match_str("5")
 11 jump_false*(58)
 12 match_str("6")
 13 jump_false*(58)
 14 match_str("7")
 15 jump_false*(58)
 16 match_str("8")
 17 jump_false*(58)
 18 match_str("9")
 19 jump_false*(58)
 20 match_str("10")
 21 jump_false*(58)
 22 match_str("11")
 23 jump_false*(58)
 24 match_str("12")
 25 jump_false*(58)
 26 match_str("13")
 27 jump_false*(58)
 28 match_str("14")
 29 jump_false*(58)
 30 match_str("15")
 31 jump_false*(58)
 32 match_str("16")
 33 jump_false*(58)
 34 match_str("17")
 35 jump_false*(58)
 36 match_str("18")
 37 jump_false*(58)
 38 match_str("19")
 39 jump_false*(58)
 40 match_str("20")
 41 jump_false*(58)
 42 match_str("21")
 43 jump_false*(58)
 44 match_str("22")
 45 jump_false*(58)
 46 match_str("23")
 47 jump_false*(58)
 48 match_str("24")
 49 jump_false*(58)
 50 match_str("25")
 51 jump_false*(58)
 52 match_str("26")
 53 jump_false*(58)
 54 match_str("27")
 55 jump_false*(58)
 56 match_str("28")
 57 jump_true(eos)
 58 match_str("29")
 59 jump_false(eos)
 60 match_str("30")
 61 jump_false(eos)
 62 match_str("31")
 63 jump_false(eos)
 64 match_str("32")
 65 jump_false(eos)
 66 match_str("33")
 67 jump_false(eos)
 68 match_str("34")
 69 jump_false(eos)
 70 match_str("35")
 71 jump_false(eos)
 72 match_str("36")
 73 jump_false(eos)
 74 match_str("37")
 75 jump_false(eos)
 76 match_str("38")
 77 jump_false(eos)
 78 match_str("39")
 79 jump_false(eos)
 80 match_str("40")
 81 jump_false(eos)
 82 match_str("41")
 83 jump_false(eos)
 84 match_str("42")
 85 jump_false(eos)
 86 match_str("43")
 87 jump_false(eos)
 88 match_str("44")
 89 jump_false(eos)
 90 match_str("45")
 91 jump_false(eos)
 92 match_str("46")
 93 jump_false(eos)
 94 match_str("47")
 95 jump_false(eos)
 96 match_str("48")
 97 jump_false(eos)
 98 match_str("49")
 99 jump_false(eos)
100 match_str("50")
101 jump_false(eos)
102 match_str("51")
103 jump_false(eos)
104 match_str("52")
105 jump_false(eos)
106 match_str("53")
107 jump_false(eos)
108 match_str("54")
109 jump_false(eos)
110 match_str("55")
111 jump_false(eos)
112 match_str("56")
$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`||`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`&&`47`&&`48`&&`49`&&`50`&&`51`&&`52`&&`53`&&`54`&&`55`&&`56`&&`57`'\''
  0 match_str("0")
  1 jump_false*(58)
  2 match_str("1")
  3 jump_false*(58)
  4 match_str("2")
  5 jump_false*(58)
  6 match_str("3")
  7 jump_false*(58)
  8 match_str("4")
  9 jump_false*(58)
 10 match_str("5")
 11 jump_false*(58)
 12 match_str("6")
 13 jump_false*(58)
 14 match_str("7")
 15 jump_false*(58)
 16 match_str("8")
 17 jump_false*(58)
 18 match_str("9")
 19 jump_false*(58)
 20 match_str("10")
 21 jump_false*(58)
 22 match_str("11")
 23 jump_false*(58)
 24 match_str("12")
 25 jump_false*(58)
 26 match_str("13")
 27 jump_false*(58)
 28 match_str("14")
 29 jump_false*(58)
 30 match_str("15")
 31 jump_false*(58)
 32 match_str("16")
 33 jump_false*(58)
 34 match_str("17")
 35 jump_false*(58)
 36 match_str("18")
 37 jump_false*(58)
 38 match_str("19")
 39 jump_false*(58)
 40 match_str("20")
 41 jump_false*(58)
 42 match_str("21")
 43 jump_false*(58)
 44 match_str("22")
 45 jump_false*(58)
 46 match_str("23")
 47 jump_false*(58)
 48 match_str("24")
 49 jump_false*(58)
 50 match_str("25")
 51 jump_false*(58)
 52 match_str("26")
 53 jump_false*(58)
 54 match_str("27")
 55 jump_false*(58)
 56 match_str("28")
 57 jump_true(eos)
 58 match_str("29")
 59 jump_false(eos)
 60 match_str("30")
 61 jump_false(eos)
 62 match_str("31")
 63 jump_false(eos)
 64 match_str("32")
 65 jump_false(eos)
 66 match_str("33")
 67 jump_false(eos)
 68 match_str("34")
 69 jump_false(eos)
 70 match_str("35")
 71 jump_false(eos)
 72 match_str("36")
 73 jump_false(eos)
 74 match_str("37")
 75 jump_false(eos)
 76 match_str("38")
 77 jump_false(eos)
 78 match_str("39")
 79 jump_false(eos)
 80 match_str("40")
 81 jump_false(eos)
 82 match_str("41")
 83 jump_false(eos)
 84 match_str("42")
 85 jump_false(eos)
 86 match_str("43")
 87 jump_false(eos)
 88 match_str("44")
 89 jump_false(eos)
 90 match_str("45")
 91 jump_false(eos)
 92 match_str("46")
 93 jump_false(eos)
 94 match_str("47")
 95 jump_false(eos)
 96 match_str("48")
 97 jump_false(eos)
 98 match_str("49")
 99 jump_false(eos)
100 match_str("50")
101 jump_false(eos)
102 match_str("51")
103 jump_false(eos)
104 match_str("52")
105 jump_false(eos)
106 match_str("53")
107 jump_false(eos)
108 match_str("54")
109 jump_false(eos)
110 match_str("55")
111 jump_false(eos)
112 match_str("56")
113 jump_false(eos)
114 match_str("57")
$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`||`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`&&`47`&&`48`&&`49`&&`50`&&`51`&&`52`&&`53`&&`54`&&`55`&&`56`&&`57`&&`58`'\''
  0 match_str("0")
  1 jump_false*(60)
  2 match_str("1")
  3 jump_false*(60)
  4 match_str("2")
  5 jump_false*(60)
  6 match_str("3")
  7 jump_false*(60)
  8 match_str("4")
  9 jump_false*(60)
 10 match_str("5")
 11 jump_false*(60)
 12 match_str("6")
 13 jump_false*(60)
 14 match_str("7")
 15 jump_false*(60)
 16 match_str("8")
 17 jump_false*(60)
 18 match_str("9")
 19 jump_false*(60)
 20 match_str("10")
 21 jump_false*(60)
 22 match_str("11")
 23 jump_false*(60)
 24 match_str("12")
 25 jump_false*(60)
 26 match_str("13")
 27 jump_false*(60)
 28 match_str("14")
 29 jump_false*(60)
 30 match_str("15")
 31 jump_false*(60)
 32 match_str("16")
 33 jump_false*(60)
 34 match_str("17")
 35 jump_false*(60)
 36 match_str("18")
 37 jump_false*(60)
 38 match_str("19")
 39 jump_false*(60)
 40 match_str("20")
 41 jump_false*(60)
 42 match_str("21")
 43 jump_false*(60)
 44 match_str("22")
 45 jump_false*(60)
 46 match_str("23")
 47 jump_false*(60)
 48 match_str("24")
 49 jump_false*(60)
 50 match_str("25")
 51 jump_false*(60)
 52 match_str("26")
 53 jump_false*(60)
 54 match_str("27")
 55 jump_false*(60)
 56 match_str("28")
 57 jump_false*(60)
 58 match_str("29")
 59 jump_true(eos)
 60 match_str("30")
 61 jump_false(eos)
 62 match_str("31")
 63 jump_false(eos)
 64 match_str("32")
 65 jump_false(eos)
 66 match_str("33")
 67 jump_false(eos)
 68 match_str("34")
 69 jump_false(eos)
 70 match_str("35")
 71 jump_false(eos)
 72 match_str("36")
 73 jump_false(eos)
 74 match_str("37")
 75 jump_false(eos)
 76 match_str("38")
 77 jump_false(eos)
 78 match_str("39")
 79 jump_false(eos)
 80 match_str("40")
 81 jump_false(eos)
 82 match_str("41")
 83 jump_false(eos)
 84 match_str("42")
 85 jump_false(eos)
 86 match_str("43")
 87 jump_false(eos)
 88 match_str("44")
 89 jump_false(eos)
 90 match_str("45")
 91 jump_false(eos)
 92 match_str("46")
 93 jump_false(eos)
 94 match_str("47")
 95 jump_false(eos)
 96 match_str("48")
 97 jump_false(eos)
 98 match_str("49")
 99 jump_false(eos)
100 match_str("50")
101 jump_false(eos)
102 match_str("51")
103 jump_false(eos)
104 match_str("52")
105 jump_false(eos)
106 match_str("53")
107 jump_false(eos)
108 match_str("54")
109 jump_false(eos)
110 match_str("55")
111 jump_false(eos)
112 match_str("56")
113 jump_false(eos)
114 match_str("57")
115 jump_false(eos)
116 match_str("58")
$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`||`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`&&`47`&&`48`&&`49`&&`50`&&`51`&&`52`&&`53`&&`54`&&`55`&&`56`&&`57`&&`58`&&`59`'\''
  0 match_str("0")
  1 jump_false*(60)
  2 match_str("1")
  3 jump_false*(60)
  4 match_str("2")
  5 jump_false*(60)
  6 match_str("3")
  7 jump_false*(60)
  8 match_str("4")
  9 jump_false*(60)
 10 match_str("5")
 11 jump_false*(60)
 12 match_str("6")
 13 jump_false*(60)
 14 match_str("7")
 15 jump_false*(60)
 16 match_str("8")
 17 jump_false*(60)
 18 match_str("9")
 19 jump_false*(60)
 20 match_str("10")
 21 jump_false*(60)
 22 match_str("11")
 23 jump_false*(60)
 24 match_str("12")
 25 jump_false*(60)
 26 match_str("13")
 27 jump_false*(60)
 28 match_str("14")
 29 jump_false*(60)
 30 match_str("15")
 31 jump_false*(60)
 32 match_str("16")
 33 jump_false*(60)
 34 match_str("17")
 35 jump_false*(60)
 36 match_str("18")
 37 jump_false*(60)
 38 match_str("19")
 39 jump_false*(60)
 40 match_str("20")
 41 jump_false*(60)
 42 match_str("21")
 43 jump_false*(60)
 44 match_str("22")
 45 jump_false*(60)
 46 match_str("23")
 47 jump_false*(60)
 48 match_str("24")
 49 jump_false*(60)
 50 match_str("25")
 51 jump_false*(60)
 52 match_str("26")
 53 jump_false*(60)
 54 match_str("27")
 55 jump_false*(60)
 56 match_str("28")
 57 jump_false*(60)
 58 match_str("29")
 59 jump_true(eos)
 60 match_str("30")
 61 jump_false(eos)
 62 match_str("31")
 63 jump_false(eos)
 64 match_str("32")
 65 jump_false(eos)
 66 match_str("33")
 67 jump_false(eos)
 68 match_str("34")
 69 jump_false(eos)
 70 match_str("35")
 71 jump_false(eos)
 72 match_str("36")
 73 jump_false(eos)
 74 match_str("37")
 75 jump_false(eos)
 76 match_str("38")
 77 jump_false(eos)
 78 match_str("39")
 79 jump_false(eos)
 80 match_str("40")
 81 jump_false(eos)
 82 match_str("41")
 83 jump_false(eos)
 84 match_str("42")
 85 jump_false(eos)
 86 match_str("43")
 87 jump_false(eos)
 88 match_str("44")
 89 jump_false(eos)
 90 match_str("45")
 91 jump_false(eos)
 92 match_str("46")
 93 jump_false(eos)
 94 match_str("47")
 95 jump_false(eos)
 96 match_str("48")
 97 jump_false(eos)
 98 match_str("49")
 99 jump_false(eos)
100 match_str("50")
101 jump_false(eos)
102 match_str("51")
103 jump_false(eos)
104 match_str("52")
105 jump_false(eos)
106 match_str("53")
107 jump_false(eos)
108 match_str("54")
109 jump_false(eos)
110 match_str("55")
111 jump_false(eos)
112 match_str("56")
113 jump_false(eos)
114 match_str("57")
115 jump_false(eos)
116 match_str("58")
117 jump_false(eos)
118 match_str("59")
$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`||`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`&&`47`&&`48`&&`49`&&`50`&&`51`&&`52`&&`53`&&`54`&&`55`&&`56`&&`57`&&`58`&&`59`&&`60`'\''
  0 match_str("0")
  1 jump_false*(62)
  2 match_str("1")
  3 jump_false*(62)
  4 match_str("2")
  5 jump_false*(62)
  6 match_str("3")
  7 jump_false*(62)
  8 match_str("4")
  9 jump_false*(62)
 10 match_str("5")
 11 jump_false*(62)
 12 match_str("6")
 13 jump_false*(62)
 14 match_str("7")
 15 jump_false*(62)
 16 match_str("8")
 17 jump_false*(62)
 18 match_str("9")
 19 jump_false*(62)
 20 match_str("10")
 21 jump_false*(62)
 22 match_str("11")
 23 jump_false*(62)
 24 match_str("12")
 25 jump_false*(62)
 26 match_str("13")
 27 jump_false*(62)
 28 match_str("14")
 29 jump_false*(62)
 30 match_str("15")
 31 jump_false*(62)
 32 match_str("16")
 33 jump_false*(62)
 34 match_str("17")
 35 jump_false*(62)
 36 match_str("18")
 37 jump_false*(62)
 38 match_str("19")
 39 jump_false*(62)
 40 match_str("20")
 41 jump_false*(62)
 42 match_str("21")
 43 jump_false*(62)
 44 match_str("22")
 45 jump_false*(62)
 46 match_str("23")
 47 jump_false*(62)
 48 match_str("24")
 49 jump_false*(62)
 50 match_str("25")
 51 jump_false*(62)
 52 match_str("26")
 53 jump_false*(62)
 54 match_str("27")
 55 jump_false*(62)
 56 match_str("28")
 57 jump_false*(62)
 58 match_str("29")
 59 jump_false*(62)
 60 match_str("30")
 61 jump_true(eos)
 62 match_str("31")
 63 jump_false(eos)
 64 match_str("32")
 65 jump_false(eos)
 66 match_str("33")
 67 jump_false(eos)
 68 match_str("34")
 69 jump_false(eos)
 70 match_str("35")
 71 jump_false(eos)
 72 match_str("36")
 73 jump_false(eos)
 74 match_str("37")
 75 jump_false(eos)
 76 match_str("38")
 77 jump_false(eos)
 78 match_str("39")
 79 jump_false(eos)
 80 match_str("40")
 81 jump_false(eos)
 82 match_str("41")
 83 jump_false(eos)
 84 match_str("42")
 85 jump_false(eos)
 86 match_str("43")
 87 jump_false(eos)
 88 match_str("44")
 89 jump_false(eos)
 90 match_str("45")
 91 jump_false(eos)
 92 match_str("46")
 93 jump_false(eos)
 94 match_str("47")
 95 jump_false(eos)
 96 match_str("48")
 97 jump_false(eos)
 98 match_str("49")
 99 jump_false(eos)
100 match_str("50")
101 jump_false(eos)
102 match_str("51")
103 jump_false(eos)
104 match_str("52")
105 jump_false(eos)
106 match_str("53")
107 jump_false(eos)
108 match_str("54")
109 jump_false(eos)
110 match_str("55")
111 jump_false(eos)
112 match_str("56")
113 jump_false(eos)
114 match_str("57")
115 jump_false(eos)
116 match_str("58")
117 jump_false(eos)
118 match_str("59")
119 jump_false(eos)
120 match_str("60")
$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`||`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`&&`47`&&`48`&&`49`&&`50`&&`51`&&`52`&&`53`&&`54`&&`55`&&`56`&&`57`&&`58`&&`59`&&`60`&&`61`'\''
  0 match_str("0")
  1 jump_false*(62)
  2 match_str("1")
  3 jump_false*(62)
  4 match_str("2")
  5 jump_false*(62)
  6 match_str("3")
  7 jump_false*(62)
  8 match_str("4")
  9 jump_false*(62)
 10 match_str("5")
 11 jump_false*(62)
 12 match_str("6")
 13 jump_false*(62)
 14 match_str("7")
 15 jump_false*(62)
 16 match_str("8")
 17 jump_false*(62)
 18 match_str("9")
 19 jump_false*(62)
 20 match_str("10")
 21 jump_false*(62)
 22 match_str("11")
 23 jump_false*(62)
 24 match_str("12")
 25 jump_false*(62)
 26 match_str("13")
 27 jump_false*(62)
 28 match_str("14")
 29 jump_false*(62)
 30 match_str("15")
 31 jump_false*(62)
 32 match_str("16")
 33 jump_false*(62)
 34 match_str("17")
 35 jump_false*(62)
 36 match_str("18")
 37 jump_false*(62)
 38 match_str("19")
 39 jump_false*(62)
 40 match_str("20")
 41 jump_false*(62)
 42 match_str("21")
 43 jump_false*(62)
 44 match_str("22")
 45 jump_false*(62)
 46 match_str("23")
 47 jump_false*(62)
 48 match_str("24")
 49 jump_false*(62)
 50 match_str("25")
 51 jump_false*(62)
 52 match_str("26")
 53 jump_false*(62)
 54 match_str("27")
 55 jump_false*(62)
 56 match_str("28")
 57 jump_false*(62)
 58 match_str("29")
 59 jump_false*(62)
 60 match_str("30")
 61 jump_true(eos)
 62 match_str("31")
 63 jump_false(eos)
 64 match_str("32")
 65 jump_false(eos)
 66 match_str("33")
 67 jump_false(eos)
 68 match_str("34")
 69 jump_false(eos)
 70 match_str("35")
 71 jump_false(eos)
 72 match_str("36")
 73 jump_false(eos)
 74 match_str("37")
 75 jump_false(eos)
 76 match_str("38")
 77 jump_false(eos)
 78 match_str("39")
 79 jump_false(eos)
 80 match_str("40")
 81 jump_false(eos)
 82 match_str("41")
 83 jump_false(eos)
 84 match_str("42")
 85 jump_false(eos)
 86 match_str("43")
 87 jump_false(eos)
 88 match_str("44")
 89 jump_false(eos)
 90 match_str("45")
 91 jump_false(eos)
 92 match_str("46")
 93 jump_false(eos)
 94 match_str("47")
 95 jump_false(eos)
 96 match_str("48")
 97 jump_false(eos)
 98 match_str("49")
 99 jump_false(eos)
100 match_str("50")
101 jump_false(eos)
102 match_str("51")
103 jump_false(eos)
104 match_str("52")
105 jump_false(eos)
106 match_str("53")
107 jump_false(eos)
108 match_str("54")
109 jump_false(eos)
110 match_str("55")
111 jump_false(eos)
112 match_str("56")
113 jump_false(eos)
114 match_str("57")
115 jump_false(eos)
116 match_str("58")
117 jump_false(eos)
118 match_str("59")
119 jump_false(eos)
120 match_str("60")
121 jump_false(eos)
122 match_str("61")
$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`||`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`&&`47`&&`48`&&`49`&&`50`&&`51`&&`52`&&`53`&&`54`&&`55`&&`56`&&`57`&&`58`&&`59`&&`60`&&`61`&&`62`'\''
  0 match_str("0")
  1 jump_false*(64)
  2 match_str("1")
  3 jump_false*(64)
  4 match_str("2")
  5 jump_false*(64)
  6 match_str("3")
  7 jump_false*(64)
  8 match_str("4")
  9 jump_false*(64)
 10 match_str("5")
 11 jump_false*(64)
 12 match_str("6")
 13 jump_false*(64)
 14 match_str("7")
 15 jump_false*(64)
 16 match_str("8")
 17 jump_false*(64)
 18 match_str("9")
 19 jump_false*(64)
 20 match_str("10")
 21 jump_false*(64)
 22 match_str("11")
 23 jump_false*(64)
 24 match_str("12")
 25 jump_false*(64)
 26 match_str("13")
 27 jump_false*(64)
 28 match_str("14")
 29 jump_false*(64)
 30 match_str("15")
 31 jump_false*(64)
 32 match_str("16")
 33 jump_false*(64)
 34 match_str("17")
 35 jump_false*(64)
 36 match_str("18")
 37 jump_false*(64)
 38 match_str("19")
 39 jump_false*(64)
 40 match_str("20")
 41 jump_false*(64)
 42 match_str("21")
 43 jump_false*(64)
 44 match_str("22")
 45 jump_false*(64)
 46 match_str("23")
 47 jump_false*(64)
 48 match_str("24")
 49 jump_false*(64)
 50 match_str("25")
 51 jump_false*(64)
 52 match_str("26")
 53 jump_false*(64)
 54 match_str("27")
 55 jump_false*(64)
 56 match_str("28")
 57 jump_false*(64)
 58 match_str("29")
 59 jump_false*(64)
 60 match_str("30")
 61 jump_false*(64)
 62 match_str("31")
 63 jump_true(eos)
 64 match_str("32")
 65 jump_false(eos)
 66 match_str("33")
 67 jump_false(eos)
 68 match_str("34")
 69 jump_false(eos)
 70 match_str("35")
 71 jump_false(eos)
 72 match_str("36")
 73 jump_false(eos)
 74 match_str("37")
 75 jump_false(eos)
 76 match_str("38")
 77 jump_false(eos)
 78 match_str("39")
 79 jump_false(eos)
 80 match_str("40")
 81 jump_false(eos)
 82 match_str("41")
 83 jump_false(eos)
 84 match_str("42")
 85 jump_false(eos)
 86 match_str("43")
 87 jump_false(eos)
 88 match_str("44")
 89 jump_false(eos)
 90 match_str("45")
 91 jump_false(eos)
 92 match_str("46")
 93 jump_false(eos)
 94 match_str("47")
 95 jump_false(eos)
 96 match_str("48")
 97 jump_false(eos)
 98 match_str("49")
 99 jump_false(eos)
100 match_str("50")
101 jump_false(eos)
102 match_str("51")
103 jump_false(eos)
104 match_str("52")
105 jump_false(eos)
106 match_str("53")
107 jump_false(eos)
108 match_str("54")
109 jump_false(eos)
110 match_str("55")
111 jump_false(eos)
112 match_str("56")
113 jump_false(eos)
114 match_str("57")
115 jump_false(eos)
116 match_str("58")
117 jump_false(eos)
118 match_str("59")
119 jump_false(eos)
120 match_str("60")
121 jump_false(eos)
122 match_str("61")
123 jump_false(eos)
124 match_str("62")
$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`||`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`&&`47`&&`48`&&`49`&&`50`&&`51`&&`52`&&`53`&&`54`&&`55`&&`56`&&`57`&&`58`&&`59`&&`60`&&`61`&&`62`&&`63`'\''
  0 match_str("0")
  1 jump_false*(64)
  2 match_str("1")
  3 jump_false*(64)
  4 match_str("2")
  5 jump_false*(64)
  6 match_str("3")
  7 jump_false*(64)
  8 match_str("4")
  9 jump_false*(64)
 10 match_str("5")
 11 jump_false*(64)
 12 match_str("6")
 13 jump_false*(64)
 14 match_str("7")
 15 jump_false*(64)
 16 match_str("8")
 17 jump_false*(64)
 18 match_str("9")
 19 jump_false*(64)
 20 match_str("10")
 21 jump_false*(64)
 22 match_str("11")
 23 jump_false*(64)
 24 match_str("12")
 25 jump_false*(64)
 26 match_str("13")
 27 jump_false*(64)
 28 match_str("14")
 29 jump_false*(64)
 30 match_str("15")
 31 jump_false*(64)
 32 match_str("16")
 33 jump_false*(64)
 34 match_str("17")
 35 jump_false*(64)
 36 match_str("18")
 37 jump_false*(64)
 38 match_str("19")
 39 jump_false*(64)
 40 match_str("20")
 41 jump_false*(64)
 42 match_str("21")
 43 jump_false*(64)
 44 match_str("22")
 45 jump_false*(64)
 46 match_str("23")
 47 jump_false*(64)
 48 match_str("24")
 49 jump_false*(64)
 50 match_str("25")
 51 jump_false*(64)
 52 match_str("26")
 53 jump_false*(64)
 54 match_str("27")
 55 jump_false*(64)
 56 match_str("28")
 57 jump_false*(64)
 58 match_str("29")
 59 jump_false*(64)
 60 match_str("30")
 61 jump_false*(64)
 62 match_str("31")
 63 jump_true(eos)
 64 match_str("32")
 65 jump_false(eos)
 66 match_str("33")
 67 jump_false(eos)
 68 match_str("34")
 69 jump_false(eos)
 70 match_str("35")
 71 jump_false(eos)
 72 match_str("36")
 73 jump_false(eos)
 74 match_str("37")
 75 jump_false(eos)
 76 match_str("38")
 77 jump_false(eos)
 78 match_str("39")
 79 jump_false(eos)
 80 match_str("40")
 81 jump_false(eos)
 82 match_str("41")
 83 jump_false(eos)
 84 match_str("42")
 85 jump_false(eos)
 86 match_str("43")
 87 jump_false(eos)
 88 match_str("44")
 89 jump_false(eos)
 90 match_str("45")
 91 jump_false(eos)
 92 match_str("46")
 93 jump_false(eos)
 94 match_str("47")
 95 jump_false(eos)
 96 match_str("48")
 97 jump_false(eos)
 98 match_str("49")
 99 jump_false(eos)
100 match_str("50")
101 jump_false(eos)
102 match_str("51")
103 jump_false(eos)
104 match_str("52")
105 jump_false(eos)
106 match_str("53")
107 jump_false(eos)
108 match_str("54")
109 jump_false(eos)
110 match_str("55")
111 jump_false(eos)
112 match_str("56")
113 jump_false(eos)
114 match_str("57")
115 jump_false(eos)
116 match_str("58")
117 jump_false(eos)
118 match_str("59")
119 jump_false(eos)
120 match_str("60")
121 jump_false(eos)
122 match_str("61")
123 jump_false(eos)
124 match_str("62")
125 jump_false(eos)
126 match_str("63")'
) -L jumps4.new <(
echo '$ shopt -s expand_aliases'
shopt -s expand_aliases 2>&1 ||
echo 'command failed: shopt -s expand_aliases'

echo '$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'
[ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib" 2>&1 ||
echo 'command failed: [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'

echo '$ test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vc flat; }'
test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vc flat; } 2>&1 ||
echo 'command failed: test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vc flat; }'

echo '$ alias test-expr='\''test-expr -C'\'''
alias test-expr='test-expr -C' 2>&1 ||
echo 'command failed: alias test-expr='\''test-expr -C'\'''

echo '$ test-expr '\''`0`||`1`'\'''
test-expr '`0`||`1`' 2>&1 ||
echo 'command failed: test-expr '\''`0`||`1`'\'''

echo '$ test-expr '\''`0`&&`1`||`2`'\'''
test-expr '`0`&&`1`||`2`' 2>&1 ||
echo 'command failed: test-expr '\''`0`&&`1`||`2`'\'''

echo '$ test-expr '\''`0`&&`1`||`2`&&`3`'\'''
test-expr '`0`&&`1`||`2`&&`3`' 2>&1 ||
echo 'command failed: test-expr '\''`0`&&`1`||`2`&&`3`'\'''

echo '$ test-expr '\''`0`&&`1`&&`2`||`3`&&`4`'\'''
test-expr '`0`&&`1`&&`2`||`3`&&`4`' 2>&1 ||
echo 'command failed: test-expr '\''`0`&&`1`&&`2`||`3`&&`4`'\'''

echo '$ test-expr '\''`0`&&`1`&&`2`||`3`&&`4`&&`5`'\'''
test-expr '`0`&&`1`&&`2`||`3`&&`4`&&`5`' 2>&1 ||
echo 'command failed: test-expr '\''`0`&&`1`&&`2`||`3`&&`4`&&`5`'\'''

echo '$ test-expr '\''`0`&&`1`&&`2`&&`3`||`4`&&`5`&&`6`'\'''
test-expr '`0`&&`1`&&`2`&&`3`||`4`&&`5`&&`6`' 2>&1 ||
echo 'command failed: test-expr '\''`0`&&`1`&&`2`&&`3`||`4`&&`5`&&`6`'\'''

echo '$ test-expr '\''`0`&&`1`&&`2`&&`3`||`4`&&`5`&&`6`&&`7`'\'''
test-expr '`0`&&`1`&&`2`&&`3`||`4`&&`5`&&`6`&&`7`' 2>&1 ||
echo 'command failed: test-expr '\''`0`&&`1`&&`2`&&`3`||`4`&&`5`&&`6`&&`7`'\'''

echo '$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`||`5`&&`6`&&`7`&&`8`'\'''
test-expr '`0`&&`1`&&`2`&&`3`&&`4`||`5`&&`6`&&`7`&&`8`' 2>&1 ||
echo 'command failed: test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`||`5`&&`6`&&`7`&&`8`'\'''

echo '$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`||`5`&&`6`&&`7`&&`8`&&`9`'\'''
test-expr '`0`&&`1`&&`2`&&`3`&&`4`||`5`&&`6`&&`7`&&`8`&&`9`' 2>&1 ||
echo 'command failed: test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`||`5`&&`6`&&`7`&&`8`&&`9`'\'''

echo '$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`||`6`&&`7`&&`8`&&`9`&&`10`'\'''
test-expr '`0`&&`1`&&`2`&&`3`&&`4`&&`5`||`6`&&`7`&&`8`&&`9`&&`10`' 2>&1 ||
echo 'command failed: test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`||`6`&&`7`&&`8`&&`9`&&`10`'\'''

echo '$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`||`6`&&`7`&&`8`&&`9`&&`10`&&`11`'\'''
test-expr '`0`&&`1`&&`2`&&`3`&&`4`&&`5`||`6`&&`7`&&`8`&&`9`&&`10`&&`11`' 2>&1 ||
echo 'command failed: test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`||`6`&&`7`&&`8`&&`9`&&`10`&&`11`'\'''

echo '$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`||`7`&&`8`&&`9`&&`10`&&`11`&&`12`'\'''
test-expr '`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`||`7`&&`8`&&`9`&&`10`&&`11`&&`12`' 2>&1 ||
echo 'command failed: test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`||`7`&&`8`&&`9`&&`10`&&`11`&&`12`'\'''

echo '$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`||`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`'\'''
test-expr '`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`||`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`' 2>&1 ||
echo 'command failed: test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`||`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`'\'''

echo '$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`||`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`'\'''
test-expr '`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`||`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`' 2>&1 ||
echo 'command failed: test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`||`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`'\'''

echo '$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`||`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`'\'''
test-expr '`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`||`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`' 2>&1 ||
echo 'command failed: test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`||`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`'\'''

echo '$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`||`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`'\'''
test-expr '`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`||`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`' 2>&1 ||
echo 'command failed: test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`||`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`'\'''

echo '$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`||`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`'\'''
test-expr '`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`||`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`' 2>&1 ||
echo 'command failed: test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`||`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`'\'''

echo '$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`||`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`'\'''
test-expr '`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`||`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`' 2>&1 ||
echo 'command failed: test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`||`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`'\'''

echo '$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`||`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`'\'''
test-expr '`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`||`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`' 2>&1 ||
echo 'command failed: test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`||`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`'\'''

echo '$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`||`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`'\'''
test-expr '`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`||`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`' 2>&1 ||
echo 'command failed: test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`||`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`'\'''

echo '$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`||`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`'\'''
test-expr '`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`||`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`' 2>&1 ||
echo 'command failed: test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`||`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`'\'''

echo '$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`||`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`'\'''
test-expr '`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`||`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`' 2>&1 ||
echo 'command failed: test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`||`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`'\'''

echo '$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`||`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`'\'''
test-expr '`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`||`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`' 2>&1 ||
echo 'command failed: test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`||`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`'\'''

echo '$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`||`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`'\'''
test-expr '`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`||`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`' 2>&1 ||
echo 'command failed: test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`||`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`'\'''

echo '$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`||`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`'\'''
test-expr '`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`||`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`' 2>&1 ||
echo 'command failed: test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`||`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`'\'''

echo '$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`||`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`'\'''
test-expr '`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`||`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`' 2>&1 ||
echo 'command failed: test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`||`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`'\'''

echo '$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`||`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`'\'''
test-expr '`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`||`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`' 2>&1 ||
echo 'command failed: test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`||`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`'\'''

echo '$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`||`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`'\'''
test-expr '`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`||`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`' 2>&1 ||
echo 'command failed: test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`||`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`'\'''

echo '$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`||`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`'\'''
test-expr '`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`||`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`' 2>&1 ||
echo 'command failed: test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`||`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`'\'''

echo '$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`||`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`'\'''
test-expr '`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`||`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`' 2>&1 ||
echo 'command failed: test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`||`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`'\'''

echo '$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`||`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`'\'''
test-expr '`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`||`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`' 2>&1 ||
echo 'command failed: test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`||`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`'\'''

echo '$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`||`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`'\'''
test-expr '`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`||`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`' 2>&1 ||
echo 'command failed: test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`||`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`'\'''

echo '$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`||`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`'\'''
test-expr '`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`||`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`' 2>&1 ||
echo 'command failed: test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`||`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`'\'''

echo '$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`||`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`'\'''
test-expr '`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`||`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`' 2>&1 ||
echo 'command failed: test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`||`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`'\'''

echo '$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`||`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`'\'''
test-expr '`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`||`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`' 2>&1 ||
echo 'command failed: test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`||`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`'\'''

echo '$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`||`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`'\'''
test-expr '`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`||`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`' 2>&1 ||
echo 'command failed: test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`||`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`'\'''

echo '$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`||`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`'\'''
test-expr '`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`||`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`' 2>&1 ||
echo 'command failed: test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`||`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`'\'''

echo '$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`||`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`'\'''
test-expr '`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`||`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`' 2>&1 ||
echo 'command failed: test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`||`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`'\'''

echo '$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`||`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`'\'''
test-expr '`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`||`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`' 2>&1 ||
echo 'command failed: test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`||`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`'\'''

echo '$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`||`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`'\'''
test-expr '`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`||`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`' 2>&1 ||
echo 'command failed: test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`||`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`'\'''

echo '$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`||`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`'\'''
test-expr '`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`||`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`' 2>&1 ||
echo 'command failed: test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`||`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`'\'''

echo '$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`||`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`'\'''
test-expr '`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`||`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`' 2>&1 ||
echo 'command failed: test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`||`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`'\'''

echo '$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`||`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`'\'''
test-expr '`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`||`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`' 2>&1 ||
echo 'command failed: test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`||`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`'\'''

echo '$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`||`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`'\'''
test-expr '`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`||`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`' 2>&1 ||
echo 'command failed: test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`||`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`'\'''

echo '$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`||`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`'\'''
test-expr '`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`||`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`' 2>&1 ||
echo 'command failed: test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`||`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`'\'''

echo '$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`||`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`'\'''
test-expr '`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`||`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`' 2>&1 ||
echo 'command failed: test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`||`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`'\'''

echo '$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`||`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`&&`47`'\'''
test-expr '`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`||`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`&&`47`' 2>&1 ||
echo 'command failed: test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`||`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`&&`47`'\'''

echo '$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`||`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`&&`47`&&`48`'\'''
test-expr '`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`||`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`&&`47`&&`48`' 2>&1 ||
echo 'command failed: test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`||`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`&&`47`&&`48`'\'''

echo '$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`||`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`&&`47`&&`48`&&`49`'\'''
test-expr '`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`||`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`&&`47`&&`48`&&`49`' 2>&1 ||
echo 'command failed: test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`||`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`&&`47`&&`48`&&`49`'\'''

echo '$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`||`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`&&`47`&&`48`&&`49`&&`50`'\'''
test-expr '`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`||`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`&&`47`&&`48`&&`49`&&`50`' 2>&1 ||
echo 'command failed: test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`||`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`&&`47`&&`48`&&`49`&&`50`'\'''

echo '$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`||`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`&&`47`&&`48`&&`49`&&`50`&&`51`'\'''
test-expr '`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`||`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`&&`47`&&`48`&&`49`&&`50`&&`51`' 2>&1 ||
echo 'command failed: test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`||`26`&&`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`&&`47`&&`48`&&`49`&&`50`&&`51`'\'''

echo '$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`||`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`&&`47`&&`48`&&`49`&&`50`&&`51`&&`52`'\'''
test-expr '`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`||`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`&&`47`&&`48`&&`49`&&`50`&&`51`&&`52`' 2>&1 ||
echo 'command failed: test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`||`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`&&`47`&&`48`&&`49`&&`50`&&`51`&&`52`'\'''

echo '$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`||`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`&&`47`&&`48`&&`49`&&`50`&&`51`&&`52`&&`53`'\'''
test-expr '`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`||`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`&&`47`&&`48`&&`49`&&`50`&&`51`&&`52`&&`53`' 2>&1 ||
echo 'command failed: test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`||`27`&&`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`&&`47`&&`48`&&`49`&&`50`&&`51`&&`52`&&`53`'\'''

echo '$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`||`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`&&`47`&&`48`&&`49`&&`50`&&`51`&&`52`&&`53`&&`54`'\'''
test-expr '`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`||`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`&&`47`&&`48`&&`49`&&`50`&&`51`&&`52`&&`53`&&`54`' 2>&1 ||
echo 'command failed: test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`||`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`&&`47`&&`48`&&`49`&&`50`&&`51`&&`52`&&`53`&&`54`'\'''

echo '$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`||`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`&&`47`&&`48`&&`49`&&`50`&&`51`&&`52`&&`53`&&`54`&&`55`'\'''
test-expr '`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`||`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`&&`47`&&`48`&&`49`&&`50`&&`51`&&`52`&&`53`&&`54`&&`55`' 2>&1 ||
echo 'command failed: test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`||`28`&&`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`&&`47`&&`48`&&`49`&&`50`&&`51`&&`52`&&`53`&&`54`&&`55`'\'''

echo '$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`||`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`&&`47`&&`48`&&`49`&&`50`&&`51`&&`52`&&`53`&&`54`&&`55`&&`56`'\'''
test-expr '`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`||`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`&&`47`&&`48`&&`49`&&`50`&&`51`&&`52`&&`53`&&`54`&&`55`&&`56`' 2>&1 ||
echo 'command failed: test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`||`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`&&`47`&&`48`&&`49`&&`50`&&`51`&&`52`&&`53`&&`54`&&`55`&&`56`'\'''

echo '$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`||`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`&&`47`&&`48`&&`49`&&`50`&&`51`&&`52`&&`53`&&`54`&&`55`&&`56`&&`57`'\'''
test-expr '`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`||`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`&&`47`&&`48`&&`49`&&`50`&&`51`&&`52`&&`53`&&`54`&&`55`&&`56`&&`57`' 2>&1 ||
echo 'command failed: test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`||`29`&&`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`&&`47`&&`48`&&`49`&&`50`&&`51`&&`52`&&`53`&&`54`&&`55`&&`56`&&`57`'\'''

echo '$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`||`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`&&`47`&&`48`&&`49`&&`50`&&`51`&&`52`&&`53`&&`54`&&`55`&&`56`&&`57`&&`58`'\'''
test-expr '`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`||`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`&&`47`&&`48`&&`49`&&`50`&&`51`&&`52`&&`53`&&`54`&&`55`&&`56`&&`57`&&`58`' 2>&1 ||
echo 'command failed: test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`||`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`&&`47`&&`48`&&`49`&&`50`&&`51`&&`52`&&`53`&&`54`&&`55`&&`56`&&`57`&&`58`'\'''

echo '$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`||`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`&&`47`&&`48`&&`49`&&`50`&&`51`&&`52`&&`53`&&`54`&&`55`&&`56`&&`57`&&`58`&&`59`'\'''
test-expr '`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`||`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`&&`47`&&`48`&&`49`&&`50`&&`51`&&`52`&&`53`&&`54`&&`55`&&`56`&&`57`&&`58`&&`59`' 2>&1 ||
echo 'command failed: test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`||`30`&&`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`&&`47`&&`48`&&`49`&&`50`&&`51`&&`52`&&`53`&&`54`&&`55`&&`56`&&`57`&&`58`&&`59`'\'''

echo '$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`||`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`&&`47`&&`48`&&`49`&&`50`&&`51`&&`52`&&`53`&&`54`&&`55`&&`56`&&`57`&&`58`&&`59`&&`60`'\'''
test-expr '`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`||`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`&&`47`&&`48`&&`49`&&`50`&&`51`&&`52`&&`53`&&`54`&&`55`&&`56`&&`57`&&`58`&&`59`&&`60`' 2>&1 ||
echo 'command failed: test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`||`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`&&`47`&&`48`&&`49`&&`50`&&`51`&&`52`&&`53`&&`54`&&`55`&&`56`&&`57`&&`58`&&`59`&&`60`'\'''

echo '$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`||`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`&&`47`&&`48`&&`49`&&`50`&&`51`&&`52`&&`53`&&`54`&&`55`&&`56`&&`57`&&`58`&&`59`&&`60`&&`61`'\'''
test-expr '`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`||`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`&&`47`&&`48`&&`49`&&`50`&&`51`&&`52`&&`53`&&`54`&&`55`&&`56`&&`57`&&`58`&&`59`&&`60`&&`61`' 2>&1 ||
echo 'command failed: test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`||`31`&&`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`&&`47`&&`48`&&`49`&&`50`&&`51`&&`52`&&`53`&&`54`&&`55`&&`56`&&`57`&&`58`&&`59`&&`60`&&`61`'\'''

echo '$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`||`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`&&`47`&&`48`&&`49`&&`50`&&`51`&&`52`&&`53`&&`54`&&`55`&&`56`&&`57`&&`58`&&`59`&&`60`&&`61`&&`62`'\'''
test-expr '`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`||`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`&&`47`&&`48`&&`49`&&`50`&&`51`&&`52`&&`53`&&`54`&&`55`&&`56`&&`57`&&`58`&&`59`&&`60`&&`61`&&`62`' 2>&1 ||
echo 'command failed: test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`||`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`&&`47`&&`48`&&`49`&&`50`&&`51`&&`52`&&`53`&&`54`&&`55`&&`56`&&`57`&&`58`&&`59`&&`60`&&`61`&&`62`'\'''

echo '$ test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`||`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`&&`47`&&`48`&&`49`&&`50`&&`51`&&`52`&&`53`&&`54`&&`55`&&`56`&&`57`&&`58`&&`59`&&`60`&&`61`&&`62`&&`63`'\'''
test-expr '`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`||`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`&&`47`&&`48`&&`49`&&`50`&&`51`&&`52`&&`53`&&`54`&&`55`&&`56`&&`57`&&`58`&&`59`&&`60`&&`61`&&`62`&&`63`' 2>&1 ||
echo 'command failed: test-expr '\''`0`&&`1`&&`2`&&`3`&&`4`&&`5`&&`6`&&`7`&&`8`&&`9`&&`10`&&`11`&&`12`&&`13`&&`14`&&`15`&&`16`&&`17`&&`18`&&`19`&&`20`&&`21`&&`22`&&`23`&&`24`&&`25`&&`26`&&`27`&&`28`&&`29`&&`30`&&`31`||`32`&&`33`&&`34`&&`35`&&`36`&&`37`&&`38`&&`39`&&`40`&&`41`&&`42`&&`43`&&`44`&&`45`&&`46`&&`47`&&`48`&&`49`&&`50`&&`51`&&`52`&&`53`&&`54`&&`55`&&`56`&&`57`&&`58`&&`59`&&`60`&&`61`&&`62`&&`63`'\'''
)

