#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -p litex -C expr-flat:rex-opt3
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L rex-opt3.old <(echo \
'$ shopt -s expand_aliases
$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"
$ test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vc flat; }
$ alias test-expr='\''test-expr -b alpha -C'\''
$ test-expr $'\''/a/\x02'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\x02
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x02'\''
$ test-expr $'\''/a/\x03'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\x03
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x03'\''
$ test-expr $'\''/a/\x04'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\x04
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x04'\''
$ test-expr $'\''/a/\x05'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\x05
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x05'\''
$ test-expr $'\''/a/\x06'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\x06
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x06'\''
$ test-expr $'\''/a/\x07'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\a
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x07'\''
$ test-expr $'\''/a/\x08'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\b
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x08'\''
$ test-expr $'\''/a/\x09'\''
0 match_rex("a")
$ test-expr $'\''/a/\x0a'\''
0 match_rex("a")
$ test-expr $'\''/a/\x0b'\''
0 match_rex("a")
$ test-expr $'\''/a/\x0c'\''
0 match_rex("a")
$ test-expr $'\''/a/\x0d'\''
0 match_rex("a")
$ test-expr $'\''/a/\x0e'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\x0e
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x0e'\''
$ test-expr $'\''/a/\x0f'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\x0f
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x0f'\''
$ test-expr $'\''/a/\x10'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\x10
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x10'\''
$ test-expr $'\''/a/\x11'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\x11
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x11'\''
$ test-expr $'\''/a/\x12'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\x12
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x12'\''
$ test-expr $'\''/a/\x13'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\x13
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x13'\''
$ test-expr $'\''/a/\x14'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\x14
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x14'\''
$ test-expr $'\''/a/\x15'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\x15
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x15'\''
$ test-expr $'\''/a/\x16'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\x16
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x16'\''
$ test-expr $'\''/a/\x17'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\x17
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x17'\''
$ test-expr $'\''/a/\x18'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\x18
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x18'\''
$ test-expr $'\''/a/\x19'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\x19
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x19'\''
$ test-expr $'\''/a/\x1a'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\x1a
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x1a'\''
$ test-expr $'\''/a/\x1b'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\x1b
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x1b'\''
$ test-expr $'\''/a/\x1c'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\x1c
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x1c'\''
$ test-expr $'\''/a/\x1d'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\x1d
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x1d'\''
$ test-expr $'\''/a/\x1e'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\x1e
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x1e'\''
$ test-expr $'\''/a/\x1f'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\x1f
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x1f'\''
$ test-expr $'\''/a/\x20'\''
0 match_rex("a")
$ test-expr $'\''/a/\x21'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: /a/!
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x21'\''
$ test-expr $'\''/a/\x22'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/"
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x22'\''
$ test-expr $'\''/a/\x23'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: /a/#
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x23'\''
$ test-expr $'\''/a/\x24'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/$
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x24'\''
$ test-expr $'\''/a/\x25'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/%
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x25'\''
$ test-expr $'\''/a/\x26'\''
test-expr: error:1:4: compiler error: invalid operator
test-expr: error:1:4: compiler error: /a/&
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x26'\''
$ test-expr $'\''/a/\x27'\''
test-expr: error:1:5: compiler error: unexpected end of expression
test-expr: error:1:5: compiler error: /a/'\''
test-expr: error:1:5: compiler error:     ^
command failed: test-expr $'\''/a/\x27'\''
$ test-expr $'\''/a/\x28'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: /a/(
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x28'\''
$ test-expr $'\''/a/\x29'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: /a/)
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x29'\''
$ test-expr $'\''/a/\x2a'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/*
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x2a'\''
$ test-expr $'\''/a/\x2b'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/+
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x2b'\''
$ test-expr $'\''/a/\x2c'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: /a/,
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x2c'\''
$ test-expr $'\''/a/\x2d'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/-
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x2d'\''
$ test-expr $'\''/a/\x2e'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/.
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x2e'\''
$ test-expr $'\''/a/\x2f'\''
test-expr: error:1:5: compiler error: unexpected end of expression
test-expr: error:1:5: compiler error: /a//
test-expr: error:1:5: compiler error:     ^
command failed: test-expr $'\''/a/\x2f'\''
$ test-expr $'\''/a/\x30'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: /a/0
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x30'\''
$ test-expr $'\''/a/\x31'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: /a/1
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x31'\''
$ test-expr $'\''/a/\x32'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: /a/2
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x32'\''
$ test-expr $'\''/a/\x33'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: /a/3
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x33'\''
$ test-expr $'\''/a/\x34'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: /a/4
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x34'\''
$ test-expr $'\''/a/\x35'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: /a/5
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x35'\''
$ test-expr $'\''/a/\x36'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: /a/6
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x36'\''
$ test-expr $'\''/a/\x37'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: /a/7
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x37'\''
$ test-expr $'\''/a/\x38'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: /a/8
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x38'\''
$ test-expr $'\''/a/\x39'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: /a/9
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x39'\''
$ test-expr $'\''/a/\x3a'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/:
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x3a'\''
$ test-expr $'\''/a/\x3b'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/;
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x3b'\''
$ test-expr $'\''/a/\x3c'\''
test-expr: error:1:5: compiler error: unexpected end of expression
test-expr: error:1:5: compiler error: /a/<
test-expr: error:1:5: compiler error:     ^
command failed: test-expr $'\''/a/\x3c'\''
$ test-expr $'\''/a/\x3d'\''
test-expr: error:1:4: compiler error: invalid operator
test-expr: error:1:4: compiler error: /a/=
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x3d'\''
$ test-expr $'\''/a/\x3e'\''
test-expr: error:1:5: compiler error: unexpected end of expression
test-expr: error:1:5: compiler error: /a/>
test-expr: error:1:5: compiler error:     ^
command failed: test-expr $'\''/a/\x3e'\''
$ test-expr $'\''/a/\x3f'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/?
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x3f'\''
$ test-expr $'\''/a/\x40'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/@
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x40'\''
$ test-expr $'\''/a/\x41'\''
test-expr: error:1:4: compiler error: unknown regex option char
test-expr: error:1:4: compiler error: /a/A
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x41'\''
$ test-expr $'\''/a/\x42'\''
test-expr: error:1:4: compiler error: unknown regex option char
test-expr: error:1:4: compiler error: /a/B
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x42'\''
$ test-expr $'\''/a/\x43'\''
test-expr: error:1:4: compiler error: unknown regex option char
test-expr: error:1:4: compiler error: /a/C
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x43'\''
$ test-expr $'\''/a/\x44'\''
test-expr: error:1:4: compiler error: unknown regex option char
test-expr: error:1:4: compiler error: /a/D
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x44'\''
$ test-expr $'\''/a/\x45'\''
test-expr: error:1:4: compiler error: unknown regex option char
test-expr: error:1:4: compiler error: /a/E
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x45'\''
$ test-expr $'\''/a/\x46'\''
test-expr: error:1:4: compiler error: unknown regex option char
test-expr: error:1:4: compiler error: /a/F
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x46'\''
$ test-expr $'\''/a/\x47'\''
test-expr: error:1:4: compiler error: unknown regex option char
test-expr: error:1:4: compiler error: /a/G
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x47'\''
$ test-expr $'\''/a/\x48'\''
test-expr: error:1:4: compiler error: unknown regex option char
test-expr: error:1:4: compiler error: /a/H
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x48'\''
$ test-expr $'\''/a/\x49'\''
0 match_rex("a","I")
$ test-expr $'\''/a/\x4a'\''
test-expr: error:1:4: compiler error: unknown regex option char
test-expr: error:1:4: compiler error: /a/J
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x4a'\''
$ test-expr $'\''/a/\x4b'\''
test-expr: error:1:4: compiler error: unknown regex option char
test-expr: error:1:4: compiler error: /a/K
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x4b'\''
$ test-expr $'\''/a/\x4c'\''
test-expr: error:1:4: compiler error: unknown regex option char
test-expr: error:1:4: compiler error: /a/L
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x4c'\''
$ test-expr $'\''/a/\x4d'\''
test-expr: error:1:4: compiler error: unknown regex option char
test-expr: error:1:4: compiler error: /a/M
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x4d'\''
$ test-expr $'\''/a/\x4e'\''
test-expr: error:1:4: compiler error: unknown regex option char
test-expr: error:1:4: compiler error: /a/N
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x4e'\''
$ test-expr $'\''/a/\x4f'\''
test-expr: error:1:4: compiler error: unknown regex option char
test-expr: error:1:4: compiler error: /a/O
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x4f'\''
$ test-expr $'\''/a/\x50'\''
test-expr: error:1:4: compiler error: unknown regex option char
test-expr: error:1:4: compiler error: /a/P
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x50'\''
$ test-expr $'\''/a/\x51'\''
test-expr: error:1:4: compiler error: unknown regex option char
test-expr: error:1:4: compiler error: /a/Q
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x51'\''
$ test-expr $'\''/a/\x52'\''
test-expr: error:1:4: compiler error: unknown regex option char
test-expr: error:1:4: compiler error: /a/R
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x52'\''
$ test-expr $'\''/a/\x53'\''
0 match_rex("a","S")
$ test-expr $'\''/a/\x54'\''
test-expr: error:1:4: compiler error: unknown regex option char
test-expr: error:1:4: compiler error: /a/T
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x54'\''
$ test-expr $'\''/a/\x55'\''
0 match_rex("a","U")
$ test-expr $'\''/a/\x56'\''
test-expr: error:1:4: compiler error: unknown regex option char
test-expr: error:1:4: compiler error: /a/V
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x56'\''
$ test-expr $'\''/a/\x57'\''
test-expr: error:1:4: compiler error: unknown regex option char
test-expr: error:1:4: compiler error: /a/W
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x57'\''
$ test-expr $'\''/a/\x58'\''
0 match_rex("a","X")
$ test-expr $'\''/a/\x59'\''
test-expr: error:1:4: compiler error: unknown regex option char
test-expr: error:1:4: compiler error: /a/Y
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x59'\''
$ test-expr $'\''/a/\x5a'\''
test-expr: error:1:4: compiler error: unknown regex option char
test-expr: error:1:4: compiler error: /a/Z
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x5a'\''
$ test-expr $'\''/a/\x5b'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/[
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x5b'\''
$ test-expr $'\''/a/\x5c'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\\
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x5c'\''
$ test-expr $'\''/a/\x5d'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/]
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x5d'\''
$ test-expr $'\''/a/\x5e'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/^
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x5e'\''
$ test-expr $'\''/a/\x5f'\''
test-expr: error:1:4: compiler error: unexpected token
test-expr: error:1:4: compiler error: /a/_
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x5f'\''
$ test-expr $'\''/a/\x60'\''
test-expr: error:1:5: compiler error: unexpected end of expression
test-expr: error:1:5: compiler error: /a/`
test-expr: error:1:5: compiler error:     ^
command failed: test-expr $'\''/a/\x60'\''
$ test-expr $'\''/a/\x61'\''
test-expr: error:1:4: compiler error: unknown regex option char
test-expr: error:1:4: compiler error: /a/a
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x61'\''
$ test-expr $'\''/a/\x62'\''
test-expr: error:1:4: compiler error: unknown regex option char
test-expr: error:1:4: compiler error: /a/b
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x62'\''
$ test-expr $'\''/a/\x63'\''
test-expr: error:1:4: compiler error: unknown regex option char
test-expr: error:1:4: compiler error: /a/c
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x63'\''
$ test-expr $'\''/a/\x64'\''
test-expr: error:1:4: compiler error: unknown regex option char
test-expr: error:1:4: compiler error: /a/d
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x64'\''
$ test-expr $'\''/a/\x65'\''
test-expr: error:1:4: compiler error: unknown regex option char
test-expr: error:1:4: compiler error: /a/e
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x65'\''
$ test-expr $'\''/a/\x66'\''
test-expr: error:1:4: compiler error: unknown regex option char
test-expr: error:1:4: compiler error: /a/f
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x66'\''
$ test-expr $'\''/a/\x67'\''
test-expr: error:1:4: compiler error: unknown regex option char
test-expr: error:1:4: compiler error: /a/g
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x67'\''
$ test-expr $'\''/a/\x68'\''
test-expr: error:1:4: compiler error: unknown regex option char
test-expr: error:1:4: compiler error: /a/h
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x68'\''
$ test-expr $'\''/a/\x69'\''
test-expr: error:1:4: compiler error: unknown regex option char
test-expr: error:1:4: compiler error: /a/i
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x69'\''
$ test-expr $'\''/a/\x6a'\''
test-expr: error:1:4: compiler error: unknown regex option char
test-expr: error:1:4: compiler error: /a/j
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x6a'\''
$ test-expr $'\''/a/\x6b'\''
test-expr: error:1:4: compiler error: unknown regex option char
test-expr: error:1:4: compiler error: /a/k
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x6b'\''
$ test-expr $'\''/a/\x6c'\''
test-expr: error:1:4: compiler error: unknown regex option char
test-expr: error:1:4: compiler error: /a/l
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x6c'\''
$ test-expr $'\''/a/\x6d'\''
test-expr: error:1:4: compiler error: unknown regex option char
test-expr: error:1:4: compiler error: /a/m
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x6d'\''
$ test-expr $'\''/a/\x6e'\''
test-expr: error:1:4: compiler error: unknown regex option char
test-expr: error:1:4: compiler error: /a/n
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x6e'\''
$ test-expr $'\''/a/\x6f'\''
test-expr: error:1:4: compiler error: unknown regex option char
test-expr: error:1:4: compiler error: /a/o
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x6f'\''
$ test-expr $'\''/a/\x70'\''
test-expr: error:1:4: compiler error: unknown regex option char
test-expr: error:1:4: compiler error: /a/p
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x70'\''
$ test-expr $'\''/a/\x71'\''
test-expr: error:1:4: compiler error: unknown regex option char
test-expr: error:1:4: compiler error: /a/q
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x71'\''
$ test-expr $'\''/a/\x72'\''
test-expr: error:1:4: compiler error: unknown regex option char
test-expr: error:1:4: compiler error: /a/r
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x72'\''
$ test-expr $'\''/a/\x73'\''
test-expr: error:1:4: compiler error: unknown regex option char
test-expr: error:1:4: compiler error: /a/s
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x73'\''
$ test-expr $'\''/a/\x74'\''
test-expr: error:1:4: compiler error: unknown regex option char
test-expr: error:1:4: compiler error: /a/t
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x74'\''
$ test-expr $'\''/a/\x75'\''
test-expr: error:1:4: compiler error: unknown regex option char
test-expr: error:1:4: compiler error: /a/u
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x75'\''
$ test-expr $'\''/a/\x76'\''
test-expr: error:1:4: compiler error: unknown regex option char
test-expr: error:1:4: compiler error: /a/v
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x76'\''
$ test-expr $'\''/a/\x77'\''
test-expr: error:1:4: compiler error: unknown regex option char
test-expr: error:1:4: compiler error: /a/w
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x77'\''
$ test-expr $'\''/a/\x78'\''
test-expr: error:1:4: compiler error: unknown regex option char
test-expr: error:1:4: compiler error: /a/x
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x78'\''
$ test-expr $'\''/a/\x79'\''
test-expr: error:1:4: compiler error: unknown regex option char
test-expr: error:1:4: compiler error: /a/y
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x79'\''
$ test-expr $'\''/a/\x7a'\''
test-expr: error:1:4: compiler error: unknown regex option char
test-expr: error:1:4: compiler error: /a/z
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x7a'\''
$ test-expr $'\''/a/\x7b'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/{
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x7b'\''
$ test-expr $'\''/a/\x7c'\''
test-expr: error:1:4: compiler error: invalid operator
test-expr: error:1:4: compiler error: /a/|
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x7c'\''
$ test-expr $'\''/a/\x7d'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/}
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x7d'\''
$ test-expr $'\''/a/\x7e'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/~
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x7e'\''
$ test-expr $'\''/a/\x80'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\x80
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x80'\''
$ test-expr $'\''/a/\x81'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\x81
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x81'\''
$ test-expr $'\''/a/\x82'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\x82
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x82'\''
$ test-expr $'\''/a/\x83'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\x83
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x83'\''
$ test-expr $'\''/a/\x84'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\x84
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x84'\''
$ test-expr $'\''/a/\x85'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\x85
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x85'\''
$ test-expr $'\''/a/\x86'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\x86
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x86'\''
$ test-expr $'\''/a/\x87'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\x87
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x87'\''
$ test-expr $'\''/a/\x88'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\x88
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x88'\''
$ test-expr $'\''/a/\x89'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\x89
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x89'\''
$ test-expr $'\''/a/\x8a'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\x8a
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x8a'\''
$ test-expr $'\''/a/\x8b'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\x8b
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x8b'\''
$ test-expr $'\''/a/\x8c'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\x8c
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x8c'\''
$ test-expr $'\''/a/\x8d'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\x8d
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x8d'\''
$ test-expr $'\''/a/\x8e'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\x8e
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x8e'\''
$ test-expr $'\''/a/\x8f'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\x8f
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x8f'\''
$ test-expr $'\''/a/\x90'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\x90
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x90'\''
$ test-expr $'\''/a/\x91'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\x91
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x91'\''
$ test-expr $'\''/a/\x92'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\x92
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x92'\''
$ test-expr $'\''/a/\x93'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\x93
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x93'\''
$ test-expr $'\''/a/\x94'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\x94
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x94'\''
$ test-expr $'\''/a/\x95'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\x95
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x95'\''
$ test-expr $'\''/a/\x96'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\x96
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x96'\''
$ test-expr $'\''/a/\x97'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\x97
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x97'\''
$ test-expr $'\''/a/\x98'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\x98
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x98'\''
$ test-expr $'\''/a/\x99'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\x99
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x99'\''
$ test-expr $'\''/a/\x9a'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\x9a
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x9a'\''
$ test-expr $'\''/a/\x9b'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\x9b
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x9b'\''
$ test-expr $'\''/a/\x9c'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\x9c
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x9c'\''
$ test-expr $'\''/a/\x9d'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\x9d
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x9d'\''
$ test-expr $'\''/a/\x9e'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\x9e
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x9e'\''
$ test-expr $'\''/a/\x9f'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\x9f
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\x9f'\''
$ test-expr $'\''/a/\xa0'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xa0
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xa0'\''
$ test-expr $'\''/a/\xa1'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xa1
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xa1'\''
$ test-expr $'\''/a/\xa2'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xa2
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xa2'\''
$ test-expr $'\''/a/\xa3'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xa3
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xa3'\''
$ test-expr $'\''/a/\xa4'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xa4
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xa4'\''
$ test-expr $'\''/a/\xa5'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xa5
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xa5'\''
$ test-expr $'\''/a/\xa6'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xa6
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xa6'\''
$ test-expr $'\''/a/\xa7'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xa7
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xa7'\''
$ test-expr $'\''/a/\xa8'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xa8
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xa8'\''
$ test-expr $'\''/a/\xa9'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xa9
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xa9'\''
$ test-expr $'\''/a/\xaa'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xaa
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xaa'\''
$ test-expr $'\''/a/\xab'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xab
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xab'\''
$ test-expr $'\''/a/\xac'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xac
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xac'\''
$ test-expr $'\''/a/\xad'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xad
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xad'\''
$ test-expr $'\''/a/\xae'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xae
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xae'\''
$ test-expr $'\''/a/\xaf'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xaf
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xaf'\''
$ test-expr $'\''/a/\xb0'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xb0
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xb0'\''
$ test-expr $'\''/a/\xb1'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xb1
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xb1'\''
$ test-expr $'\''/a/\xb2'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xb2
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xb2'\''
$ test-expr $'\''/a/\xb3'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xb3
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xb3'\''
$ test-expr $'\''/a/\xb4'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xb4
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xb4'\''
$ test-expr $'\''/a/\xb5'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xb5
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xb5'\''
$ test-expr $'\''/a/\xb6'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xb6
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xb6'\''
$ test-expr $'\''/a/\xb7'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xb7
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xb7'\''
$ test-expr $'\''/a/\xb8'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xb8
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xb8'\''
$ test-expr $'\''/a/\xb9'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xb9
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xb9'\''
$ test-expr $'\''/a/\xba'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xba
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xba'\''
$ test-expr $'\''/a/\xbb'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xbb
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xbb'\''
$ test-expr $'\''/a/\xbc'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xbc
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xbc'\''
$ test-expr $'\''/a/\xbd'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xbd
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xbd'\''
$ test-expr $'\''/a/\xbe'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xbe
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xbe'\''
$ test-expr $'\''/a/\xbf'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xbf
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xbf'\''
$ test-expr $'\''/a/\xc0'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xc0
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xc0'\''
$ test-expr $'\''/a/\xc1'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xc1
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xc1'\''
$ test-expr $'\''/a/\xc2'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xc2
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xc2'\''
$ test-expr $'\''/a/\xc3'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xc3
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xc3'\''
$ test-expr $'\''/a/\xc4'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xc4
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xc4'\''
$ test-expr $'\''/a/\xc5'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xc5
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xc5'\''
$ test-expr $'\''/a/\xc6'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xc6
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xc6'\''
$ test-expr $'\''/a/\xc7'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xc7
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xc7'\''
$ test-expr $'\''/a/\xc8'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xc8
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xc8'\''
$ test-expr $'\''/a/\xc9'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xc9
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xc9'\''
$ test-expr $'\''/a/\xca'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xca
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xca'\''
$ test-expr $'\''/a/\xcb'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xcb
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xcb'\''
$ test-expr $'\''/a/\xcc'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xcc
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xcc'\''
$ test-expr $'\''/a/\xcd'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xcd
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xcd'\''
$ test-expr $'\''/a/\xce'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xce
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xce'\''
$ test-expr $'\''/a/\xcf'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xcf
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xcf'\''
$ test-expr $'\''/a/\xd0'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xd0
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xd0'\''
$ test-expr $'\''/a/\xd1'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xd1
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xd1'\''
$ test-expr $'\''/a/\xd2'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xd2
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xd2'\''
$ test-expr $'\''/a/\xd3'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xd3
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xd3'\''
$ test-expr $'\''/a/\xd4'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xd4
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xd4'\''
$ test-expr $'\''/a/\xd5'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xd5
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xd5'\''
$ test-expr $'\''/a/\xd6'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xd6
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xd6'\''
$ test-expr $'\''/a/\xd7'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xd7
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xd7'\''
$ test-expr $'\''/a/\xd8'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xd8
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xd8'\''
$ test-expr $'\''/a/\xd9'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xd9
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xd9'\''
$ test-expr $'\''/a/\xda'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xda
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xda'\''
$ test-expr $'\''/a/\xdb'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xdb
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xdb'\''
$ test-expr $'\''/a/\xdc'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xdc
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xdc'\''
$ test-expr $'\''/a/\xdd'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xdd
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xdd'\''
$ test-expr $'\''/a/\xde'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xde
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xde'\''
$ test-expr $'\''/a/\xdf'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xdf
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xdf'\''
$ test-expr $'\''/a/\xe0'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xe0
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xe0'\''
$ test-expr $'\''/a/\xe1'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xe1
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xe1'\''
$ test-expr $'\''/a/\xe2'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xe2
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xe2'\''
$ test-expr $'\''/a/\xe3'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xe3
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xe3'\''
$ test-expr $'\''/a/\xe4'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xe4
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xe4'\''
$ test-expr $'\''/a/\xe5'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xe5
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xe5'\''
$ test-expr $'\''/a/\xe6'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xe6
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xe6'\''
$ test-expr $'\''/a/\xe7'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xe7
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xe7'\''
$ test-expr $'\''/a/\xe8'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xe8
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xe8'\''
$ test-expr $'\''/a/\xe9'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xe9
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xe9'\''
$ test-expr $'\''/a/\xea'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xea
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xea'\''
$ test-expr $'\''/a/\xeb'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xeb
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xeb'\''
$ test-expr $'\''/a/\xec'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xec
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xec'\''
$ test-expr $'\''/a/\xed'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xed
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xed'\''
$ test-expr $'\''/a/\xee'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xee
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xee'\''
$ test-expr $'\''/a/\xef'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xef
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xef'\''
$ test-expr $'\''/a/\xf0'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xf0
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xf0'\''
$ test-expr $'\''/a/\xf1'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xf1
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xf1'\''
$ test-expr $'\''/a/\xf2'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xf2
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xf2'\''
$ test-expr $'\''/a/\xf3'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xf3
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xf3'\''
$ test-expr $'\''/a/\xf4'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xf4
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xf4'\''
$ test-expr $'\''/a/\xf5'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xf5
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xf5'\''
$ test-expr $'\''/a/\xf6'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xf6
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xf6'\''
$ test-expr $'\''/a/\xf7'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xf7
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xf7'\''
$ test-expr $'\''/a/\xf8'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xf8
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xf8'\''
$ test-expr $'\''/a/\xf9'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xf9
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xf9'\''
$ test-expr $'\''/a/\xfa'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xfa
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xfa'\''
$ test-expr $'\''/a/\xfb'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xfb
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xfb'\''
$ test-expr $'\''/a/\xfc'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xfc
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xfc'\''
$ test-expr $'\''/a/\xfd'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xfd
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xfd'\''
$ test-expr $'\''/a/\xfe'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xfe
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xfe'\''
$ test-expr $'\''/a/\xff'\''
test-expr: error:1:4: compiler error: unexpected char
test-expr: error:1:4: compiler error: /a/\xff
test-expr: error:1:4: compiler error:    ^
command failed: test-expr $'\''/a/\xff'\'''
) -L rex-opt3.new <(
echo '$ shopt -s expand_aliases'
shopt -s expand_aliases 2>&1 ||
echo 'command failed: shopt -s expand_aliases'

echo '$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'
[ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib" 2>&1 ||
echo 'command failed: [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'

echo '$ test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vc flat; }'
test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vc flat; } 2>&1 ||
echo 'command failed: test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vc flat; }'

echo '$ alias test-expr='\''test-expr -b alpha -C'\'''
alias test-expr='test-expr -b alpha -C' 2>&1 ||
echo 'command failed: alias test-expr='\''test-expr -b alpha -C'\'''

echo '$ test-expr $'\''/a/\x02'\'''
test-expr $'/a/\x02' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x02'\'''

echo '$ test-expr $'\''/a/\x03'\'''
test-expr $'/a/\x03' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x03'\'''

echo '$ test-expr $'\''/a/\x04'\'''
test-expr $'/a/\x04' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x04'\'''

echo '$ test-expr $'\''/a/\x05'\'''
test-expr $'/a/\x05' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x05'\'''

echo '$ test-expr $'\''/a/\x06'\'''
test-expr $'/a/\x06' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x06'\'''

echo '$ test-expr $'\''/a/\x07'\'''
test-expr $'/a/\x07' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x07'\'''

echo '$ test-expr $'\''/a/\x08'\'''
test-expr $'/a/\x08' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x08'\'''

echo '$ test-expr $'\''/a/\x09'\'''
test-expr $'/a/\x09' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x09'\'''

echo '$ test-expr $'\''/a/\x0a'\'''
test-expr $'/a/\x0a' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x0a'\'''

echo '$ test-expr $'\''/a/\x0b'\'''
test-expr $'/a/\x0b' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x0b'\'''

echo '$ test-expr $'\''/a/\x0c'\'''
test-expr $'/a/\x0c' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x0c'\'''

echo '$ test-expr $'\''/a/\x0d'\'''
test-expr $'/a/\x0d' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x0d'\'''

echo '$ test-expr $'\''/a/\x0e'\'''
test-expr $'/a/\x0e' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x0e'\'''

echo '$ test-expr $'\''/a/\x0f'\'''
test-expr $'/a/\x0f' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x0f'\'''

echo '$ test-expr $'\''/a/\x10'\'''
test-expr $'/a/\x10' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x10'\'''

echo '$ test-expr $'\''/a/\x11'\'''
test-expr $'/a/\x11' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x11'\'''

echo '$ test-expr $'\''/a/\x12'\'''
test-expr $'/a/\x12' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x12'\'''

echo '$ test-expr $'\''/a/\x13'\'''
test-expr $'/a/\x13' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x13'\'''

echo '$ test-expr $'\''/a/\x14'\'''
test-expr $'/a/\x14' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x14'\'''

echo '$ test-expr $'\''/a/\x15'\'''
test-expr $'/a/\x15' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x15'\'''

echo '$ test-expr $'\''/a/\x16'\'''
test-expr $'/a/\x16' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x16'\'''

echo '$ test-expr $'\''/a/\x17'\'''
test-expr $'/a/\x17' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x17'\'''

echo '$ test-expr $'\''/a/\x18'\'''
test-expr $'/a/\x18' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x18'\'''

echo '$ test-expr $'\''/a/\x19'\'''
test-expr $'/a/\x19' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x19'\'''

echo '$ test-expr $'\''/a/\x1a'\'''
test-expr $'/a/\x1a' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x1a'\'''

echo '$ test-expr $'\''/a/\x1b'\'''
test-expr $'/a/\x1b' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x1b'\'''

echo '$ test-expr $'\''/a/\x1c'\'''
test-expr $'/a/\x1c' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x1c'\'''

echo '$ test-expr $'\''/a/\x1d'\'''
test-expr $'/a/\x1d' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x1d'\'''

echo '$ test-expr $'\''/a/\x1e'\'''
test-expr $'/a/\x1e' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x1e'\'''

echo '$ test-expr $'\''/a/\x1f'\'''
test-expr $'/a/\x1f' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x1f'\'''

echo '$ test-expr $'\''/a/\x20'\'''
test-expr $'/a/\x20' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x20'\'''

echo '$ test-expr $'\''/a/\x21'\'''
test-expr $'/a/\x21' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x21'\'''

echo '$ test-expr $'\''/a/\x22'\'''
test-expr $'/a/\x22' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x22'\'''

echo '$ test-expr $'\''/a/\x23'\'''
test-expr $'/a/\x23' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x23'\'''

echo '$ test-expr $'\''/a/\x24'\'''
test-expr $'/a/\x24' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x24'\'''

echo '$ test-expr $'\''/a/\x25'\'''
test-expr $'/a/\x25' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x25'\'''

echo '$ test-expr $'\''/a/\x26'\'''
test-expr $'/a/\x26' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x26'\'''

echo '$ test-expr $'\''/a/\x27'\'''
test-expr $'/a/\x27' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x27'\'''

echo '$ test-expr $'\''/a/\x28'\'''
test-expr $'/a/\x28' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x28'\'''

echo '$ test-expr $'\''/a/\x29'\'''
test-expr $'/a/\x29' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x29'\'''

echo '$ test-expr $'\''/a/\x2a'\'''
test-expr $'/a/\x2a' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x2a'\'''

echo '$ test-expr $'\''/a/\x2b'\'''
test-expr $'/a/\x2b' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x2b'\'''

echo '$ test-expr $'\''/a/\x2c'\'''
test-expr $'/a/\x2c' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x2c'\'''

echo '$ test-expr $'\''/a/\x2d'\'''
test-expr $'/a/\x2d' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x2d'\'''

echo '$ test-expr $'\''/a/\x2e'\'''
test-expr $'/a/\x2e' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x2e'\'''

echo '$ test-expr $'\''/a/\x2f'\'''
test-expr $'/a/\x2f' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x2f'\'''

echo '$ test-expr $'\''/a/\x30'\'''
test-expr $'/a/\x30' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x30'\'''

echo '$ test-expr $'\''/a/\x31'\'''
test-expr $'/a/\x31' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x31'\'''

echo '$ test-expr $'\''/a/\x32'\'''
test-expr $'/a/\x32' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x32'\'''

echo '$ test-expr $'\''/a/\x33'\'''
test-expr $'/a/\x33' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x33'\'''

echo '$ test-expr $'\''/a/\x34'\'''
test-expr $'/a/\x34' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x34'\'''

echo '$ test-expr $'\''/a/\x35'\'''
test-expr $'/a/\x35' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x35'\'''

echo '$ test-expr $'\''/a/\x36'\'''
test-expr $'/a/\x36' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x36'\'''

echo '$ test-expr $'\''/a/\x37'\'''
test-expr $'/a/\x37' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x37'\'''

echo '$ test-expr $'\''/a/\x38'\'''
test-expr $'/a/\x38' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x38'\'''

echo '$ test-expr $'\''/a/\x39'\'''
test-expr $'/a/\x39' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x39'\'''

echo '$ test-expr $'\''/a/\x3a'\'''
test-expr $'/a/\x3a' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x3a'\'''

echo '$ test-expr $'\''/a/\x3b'\'''
test-expr $'/a/\x3b' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x3b'\'''

echo '$ test-expr $'\''/a/\x3c'\'''
test-expr $'/a/\x3c' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x3c'\'''

echo '$ test-expr $'\''/a/\x3d'\'''
test-expr $'/a/\x3d' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x3d'\'''

echo '$ test-expr $'\''/a/\x3e'\'''
test-expr $'/a/\x3e' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x3e'\'''

echo '$ test-expr $'\''/a/\x3f'\'''
test-expr $'/a/\x3f' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x3f'\'''

echo '$ test-expr $'\''/a/\x40'\'''
test-expr $'/a/\x40' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x40'\'''

echo '$ test-expr $'\''/a/\x41'\'''
test-expr $'/a/\x41' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x41'\'''

echo '$ test-expr $'\''/a/\x42'\'''
test-expr $'/a/\x42' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x42'\'''

echo '$ test-expr $'\''/a/\x43'\'''
test-expr $'/a/\x43' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x43'\'''

echo '$ test-expr $'\''/a/\x44'\'''
test-expr $'/a/\x44' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x44'\'''

echo '$ test-expr $'\''/a/\x45'\'''
test-expr $'/a/\x45' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x45'\'''

echo '$ test-expr $'\''/a/\x46'\'''
test-expr $'/a/\x46' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x46'\'''

echo '$ test-expr $'\''/a/\x47'\'''
test-expr $'/a/\x47' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x47'\'''

echo '$ test-expr $'\''/a/\x48'\'''
test-expr $'/a/\x48' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x48'\'''

echo '$ test-expr $'\''/a/\x49'\'''
test-expr $'/a/\x49' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x49'\'''

echo '$ test-expr $'\''/a/\x4a'\'''
test-expr $'/a/\x4a' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x4a'\'''

echo '$ test-expr $'\''/a/\x4b'\'''
test-expr $'/a/\x4b' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x4b'\'''

echo '$ test-expr $'\''/a/\x4c'\'''
test-expr $'/a/\x4c' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x4c'\'''

echo '$ test-expr $'\''/a/\x4d'\'''
test-expr $'/a/\x4d' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x4d'\'''

echo '$ test-expr $'\''/a/\x4e'\'''
test-expr $'/a/\x4e' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x4e'\'''

echo '$ test-expr $'\''/a/\x4f'\'''
test-expr $'/a/\x4f' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x4f'\'''

echo '$ test-expr $'\''/a/\x50'\'''
test-expr $'/a/\x50' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x50'\'''

echo '$ test-expr $'\''/a/\x51'\'''
test-expr $'/a/\x51' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x51'\'''

echo '$ test-expr $'\''/a/\x52'\'''
test-expr $'/a/\x52' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x52'\'''

echo '$ test-expr $'\''/a/\x53'\'''
test-expr $'/a/\x53' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x53'\'''

echo '$ test-expr $'\''/a/\x54'\'''
test-expr $'/a/\x54' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x54'\'''

echo '$ test-expr $'\''/a/\x55'\'''
test-expr $'/a/\x55' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x55'\'''

echo '$ test-expr $'\''/a/\x56'\'''
test-expr $'/a/\x56' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x56'\'''

echo '$ test-expr $'\''/a/\x57'\'''
test-expr $'/a/\x57' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x57'\'''

echo '$ test-expr $'\''/a/\x58'\'''
test-expr $'/a/\x58' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x58'\'''

echo '$ test-expr $'\''/a/\x59'\'''
test-expr $'/a/\x59' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x59'\'''

echo '$ test-expr $'\''/a/\x5a'\'''
test-expr $'/a/\x5a' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x5a'\'''

echo '$ test-expr $'\''/a/\x5b'\'''
test-expr $'/a/\x5b' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x5b'\'''

echo '$ test-expr $'\''/a/\x5c'\'''
test-expr $'/a/\x5c' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x5c'\'''

echo '$ test-expr $'\''/a/\x5d'\'''
test-expr $'/a/\x5d' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x5d'\'''

echo '$ test-expr $'\''/a/\x5e'\'''
test-expr $'/a/\x5e' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x5e'\'''

echo '$ test-expr $'\''/a/\x5f'\'''
test-expr $'/a/\x5f' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x5f'\'''

echo '$ test-expr $'\''/a/\x60'\'''
test-expr $'/a/\x60' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x60'\'''

echo '$ test-expr $'\''/a/\x61'\'''
test-expr $'/a/\x61' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x61'\'''

echo '$ test-expr $'\''/a/\x62'\'''
test-expr $'/a/\x62' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x62'\'''

echo '$ test-expr $'\''/a/\x63'\'''
test-expr $'/a/\x63' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x63'\'''

echo '$ test-expr $'\''/a/\x64'\'''
test-expr $'/a/\x64' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x64'\'''

echo '$ test-expr $'\''/a/\x65'\'''
test-expr $'/a/\x65' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x65'\'''

echo '$ test-expr $'\''/a/\x66'\'''
test-expr $'/a/\x66' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x66'\'''

echo '$ test-expr $'\''/a/\x67'\'''
test-expr $'/a/\x67' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x67'\'''

echo '$ test-expr $'\''/a/\x68'\'''
test-expr $'/a/\x68' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x68'\'''

echo '$ test-expr $'\''/a/\x69'\'''
test-expr $'/a/\x69' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x69'\'''

echo '$ test-expr $'\''/a/\x6a'\'''
test-expr $'/a/\x6a' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x6a'\'''

echo '$ test-expr $'\''/a/\x6b'\'''
test-expr $'/a/\x6b' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x6b'\'''

echo '$ test-expr $'\''/a/\x6c'\'''
test-expr $'/a/\x6c' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x6c'\'''

echo '$ test-expr $'\''/a/\x6d'\'''
test-expr $'/a/\x6d' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x6d'\'''

echo '$ test-expr $'\''/a/\x6e'\'''
test-expr $'/a/\x6e' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x6e'\'''

echo '$ test-expr $'\''/a/\x6f'\'''
test-expr $'/a/\x6f' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x6f'\'''

echo '$ test-expr $'\''/a/\x70'\'''
test-expr $'/a/\x70' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x70'\'''

echo '$ test-expr $'\''/a/\x71'\'''
test-expr $'/a/\x71' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x71'\'''

echo '$ test-expr $'\''/a/\x72'\'''
test-expr $'/a/\x72' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x72'\'''

echo '$ test-expr $'\''/a/\x73'\'''
test-expr $'/a/\x73' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x73'\'''

echo '$ test-expr $'\''/a/\x74'\'''
test-expr $'/a/\x74' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x74'\'''

echo '$ test-expr $'\''/a/\x75'\'''
test-expr $'/a/\x75' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x75'\'''

echo '$ test-expr $'\''/a/\x76'\'''
test-expr $'/a/\x76' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x76'\'''

echo '$ test-expr $'\''/a/\x77'\'''
test-expr $'/a/\x77' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x77'\'''

echo '$ test-expr $'\''/a/\x78'\'''
test-expr $'/a/\x78' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x78'\'''

echo '$ test-expr $'\''/a/\x79'\'''
test-expr $'/a/\x79' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x79'\'''

echo '$ test-expr $'\''/a/\x7a'\'''
test-expr $'/a/\x7a' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x7a'\'''

echo '$ test-expr $'\''/a/\x7b'\'''
test-expr $'/a/\x7b' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x7b'\'''

echo '$ test-expr $'\''/a/\x7c'\'''
test-expr $'/a/\x7c' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x7c'\'''

echo '$ test-expr $'\''/a/\x7d'\'''
test-expr $'/a/\x7d' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x7d'\'''

echo '$ test-expr $'\''/a/\x7e'\'''
test-expr $'/a/\x7e' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x7e'\'''

echo '$ test-expr $'\''/a/\x80'\'''
test-expr $'/a/\x80' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x80'\'''

echo '$ test-expr $'\''/a/\x81'\'''
test-expr $'/a/\x81' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x81'\'''

echo '$ test-expr $'\''/a/\x82'\'''
test-expr $'/a/\x82' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x82'\'''

echo '$ test-expr $'\''/a/\x83'\'''
test-expr $'/a/\x83' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x83'\'''

echo '$ test-expr $'\''/a/\x84'\'''
test-expr $'/a/\x84' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x84'\'''

echo '$ test-expr $'\''/a/\x85'\'''
test-expr $'/a/\x85' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x85'\'''

echo '$ test-expr $'\''/a/\x86'\'''
test-expr $'/a/\x86' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x86'\'''

echo '$ test-expr $'\''/a/\x87'\'''
test-expr $'/a/\x87' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x87'\'''

echo '$ test-expr $'\''/a/\x88'\'''
test-expr $'/a/\x88' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x88'\'''

echo '$ test-expr $'\''/a/\x89'\'''
test-expr $'/a/\x89' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x89'\'''

echo '$ test-expr $'\''/a/\x8a'\'''
test-expr $'/a/\x8a' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x8a'\'''

echo '$ test-expr $'\''/a/\x8b'\'''
test-expr $'/a/\x8b' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x8b'\'''

echo '$ test-expr $'\''/a/\x8c'\'''
test-expr $'/a/\x8c' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x8c'\'''

echo '$ test-expr $'\''/a/\x8d'\'''
test-expr $'/a/\x8d' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x8d'\'''

echo '$ test-expr $'\''/a/\x8e'\'''
test-expr $'/a/\x8e' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x8e'\'''

echo '$ test-expr $'\''/a/\x8f'\'''
test-expr $'/a/\x8f' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x8f'\'''

echo '$ test-expr $'\''/a/\x90'\'''
test-expr $'/a/\x90' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x90'\'''

echo '$ test-expr $'\''/a/\x91'\'''
test-expr $'/a/\x91' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x91'\'''

echo '$ test-expr $'\''/a/\x92'\'''
test-expr $'/a/\x92' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x92'\'''

echo '$ test-expr $'\''/a/\x93'\'''
test-expr $'/a/\x93' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x93'\'''

echo '$ test-expr $'\''/a/\x94'\'''
test-expr $'/a/\x94' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x94'\'''

echo '$ test-expr $'\''/a/\x95'\'''
test-expr $'/a/\x95' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x95'\'''

echo '$ test-expr $'\''/a/\x96'\'''
test-expr $'/a/\x96' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x96'\'''

echo '$ test-expr $'\''/a/\x97'\'''
test-expr $'/a/\x97' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x97'\'''

echo '$ test-expr $'\''/a/\x98'\'''
test-expr $'/a/\x98' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x98'\'''

echo '$ test-expr $'\''/a/\x99'\'''
test-expr $'/a/\x99' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x99'\'''

echo '$ test-expr $'\''/a/\x9a'\'''
test-expr $'/a/\x9a' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x9a'\'''

echo '$ test-expr $'\''/a/\x9b'\'''
test-expr $'/a/\x9b' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x9b'\'''

echo '$ test-expr $'\''/a/\x9c'\'''
test-expr $'/a/\x9c' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x9c'\'''

echo '$ test-expr $'\''/a/\x9d'\'''
test-expr $'/a/\x9d' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x9d'\'''

echo '$ test-expr $'\''/a/\x9e'\'''
test-expr $'/a/\x9e' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x9e'\'''

echo '$ test-expr $'\''/a/\x9f'\'''
test-expr $'/a/\x9f' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\x9f'\'''

echo '$ test-expr $'\''/a/\xa0'\'''
test-expr $'/a/\xa0' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xa0'\'''

echo '$ test-expr $'\''/a/\xa1'\'''
test-expr $'/a/\xa1' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xa1'\'''

echo '$ test-expr $'\''/a/\xa2'\'''
test-expr $'/a/\xa2' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xa2'\'''

echo '$ test-expr $'\''/a/\xa3'\'''
test-expr $'/a/\xa3' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xa3'\'''

echo '$ test-expr $'\''/a/\xa4'\'''
test-expr $'/a/\xa4' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xa4'\'''

echo '$ test-expr $'\''/a/\xa5'\'''
test-expr $'/a/\xa5' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xa5'\'''

echo '$ test-expr $'\''/a/\xa6'\'''
test-expr $'/a/\xa6' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xa6'\'''

echo '$ test-expr $'\''/a/\xa7'\'''
test-expr $'/a/\xa7' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xa7'\'''

echo '$ test-expr $'\''/a/\xa8'\'''
test-expr $'/a/\xa8' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xa8'\'''

echo '$ test-expr $'\''/a/\xa9'\'''
test-expr $'/a/\xa9' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xa9'\'''

echo '$ test-expr $'\''/a/\xaa'\'''
test-expr $'/a/\xaa' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xaa'\'''

echo '$ test-expr $'\''/a/\xab'\'''
test-expr $'/a/\xab' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xab'\'''

echo '$ test-expr $'\''/a/\xac'\'''
test-expr $'/a/\xac' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xac'\'''

echo '$ test-expr $'\''/a/\xad'\'''
test-expr $'/a/\xad' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xad'\'''

echo '$ test-expr $'\''/a/\xae'\'''
test-expr $'/a/\xae' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xae'\'''

echo '$ test-expr $'\''/a/\xaf'\'''
test-expr $'/a/\xaf' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xaf'\'''

echo '$ test-expr $'\''/a/\xb0'\'''
test-expr $'/a/\xb0' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xb0'\'''

echo '$ test-expr $'\''/a/\xb1'\'''
test-expr $'/a/\xb1' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xb1'\'''

echo '$ test-expr $'\''/a/\xb2'\'''
test-expr $'/a/\xb2' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xb2'\'''

echo '$ test-expr $'\''/a/\xb3'\'''
test-expr $'/a/\xb3' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xb3'\'''

echo '$ test-expr $'\''/a/\xb4'\'''
test-expr $'/a/\xb4' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xb4'\'''

echo '$ test-expr $'\''/a/\xb5'\'''
test-expr $'/a/\xb5' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xb5'\'''

echo '$ test-expr $'\''/a/\xb6'\'''
test-expr $'/a/\xb6' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xb6'\'''

echo '$ test-expr $'\''/a/\xb7'\'''
test-expr $'/a/\xb7' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xb7'\'''

echo '$ test-expr $'\''/a/\xb8'\'''
test-expr $'/a/\xb8' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xb8'\'''

echo '$ test-expr $'\''/a/\xb9'\'''
test-expr $'/a/\xb9' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xb9'\'''

echo '$ test-expr $'\''/a/\xba'\'''
test-expr $'/a/\xba' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xba'\'''

echo '$ test-expr $'\''/a/\xbb'\'''
test-expr $'/a/\xbb' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xbb'\'''

echo '$ test-expr $'\''/a/\xbc'\'''
test-expr $'/a/\xbc' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xbc'\'''

echo '$ test-expr $'\''/a/\xbd'\'''
test-expr $'/a/\xbd' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xbd'\'''

echo '$ test-expr $'\''/a/\xbe'\'''
test-expr $'/a/\xbe' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xbe'\'''

echo '$ test-expr $'\''/a/\xbf'\'''
test-expr $'/a/\xbf' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xbf'\'''

echo '$ test-expr $'\''/a/\xc0'\'''
test-expr $'/a/\xc0' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xc0'\'''

echo '$ test-expr $'\''/a/\xc1'\'''
test-expr $'/a/\xc1' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xc1'\'''

echo '$ test-expr $'\''/a/\xc2'\'''
test-expr $'/a/\xc2' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xc2'\'''

echo '$ test-expr $'\''/a/\xc3'\'''
test-expr $'/a/\xc3' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xc3'\'''

echo '$ test-expr $'\''/a/\xc4'\'''
test-expr $'/a/\xc4' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xc4'\'''

echo '$ test-expr $'\''/a/\xc5'\'''
test-expr $'/a/\xc5' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xc5'\'''

echo '$ test-expr $'\''/a/\xc6'\'''
test-expr $'/a/\xc6' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xc6'\'''

echo '$ test-expr $'\''/a/\xc7'\'''
test-expr $'/a/\xc7' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xc7'\'''

echo '$ test-expr $'\''/a/\xc8'\'''
test-expr $'/a/\xc8' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xc8'\'''

echo '$ test-expr $'\''/a/\xc9'\'''
test-expr $'/a/\xc9' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xc9'\'''

echo '$ test-expr $'\''/a/\xca'\'''
test-expr $'/a/\xca' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xca'\'''

echo '$ test-expr $'\''/a/\xcb'\'''
test-expr $'/a/\xcb' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xcb'\'''

echo '$ test-expr $'\''/a/\xcc'\'''
test-expr $'/a/\xcc' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xcc'\'''

echo '$ test-expr $'\''/a/\xcd'\'''
test-expr $'/a/\xcd' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xcd'\'''

echo '$ test-expr $'\''/a/\xce'\'''
test-expr $'/a/\xce' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xce'\'''

echo '$ test-expr $'\''/a/\xcf'\'''
test-expr $'/a/\xcf' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xcf'\'''

echo '$ test-expr $'\''/a/\xd0'\'''
test-expr $'/a/\xd0' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xd0'\'''

echo '$ test-expr $'\''/a/\xd1'\'''
test-expr $'/a/\xd1' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xd1'\'''

echo '$ test-expr $'\''/a/\xd2'\'''
test-expr $'/a/\xd2' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xd2'\'''

echo '$ test-expr $'\''/a/\xd3'\'''
test-expr $'/a/\xd3' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xd3'\'''

echo '$ test-expr $'\''/a/\xd4'\'''
test-expr $'/a/\xd4' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xd4'\'''

echo '$ test-expr $'\''/a/\xd5'\'''
test-expr $'/a/\xd5' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xd5'\'''

echo '$ test-expr $'\''/a/\xd6'\'''
test-expr $'/a/\xd6' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xd6'\'''

echo '$ test-expr $'\''/a/\xd7'\'''
test-expr $'/a/\xd7' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xd7'\'''

echo '$ test-expr $'\''/a/\xd8'\'''
test-expr $'/a/\xd8' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xd8'\'''

echo '$ test-expr $'\''/a/\xd9'\'''
test-expr $'/a/\xd9' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xd9'\'''

echo '$ test-expr $'\''/a/\xda'\'''
test-expr $'/a/\xda' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xda'\'''

echo '$ test-expr $'\''/a/\xdb'\'''
test-expr $'/a/\xdb' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xdb'\'''

echo '$ test-expr $'\''/a/\xdc'\'''
test-expr $'/a/\xdc' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xdc'\'''

echo '$ test-expr $'\''/a/\xdd'\'''
test-expr $'/a/\xdd' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xdd'\'''

echo '$ test-expr $'\''/a/\xde'\'''
test-expr $'/a/\xde' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xde'\'''

echo '$ test-expr $'\''/a/\xdf'\'''
test-expr $'/a/\xdf' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xdf'\'''

echo '$ test-expr $'\''/a/\xe0'\'''
test-expr $'/a/\xe0' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xe0'\'''

echo '$ test-expr $'\''/a/\xe1'\'''
test-expr $'/a/\xe1' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xe1'\'''

echo '$ test-expr $'\''/a/\xe2'\'''
test-expr $'/a/\xe2' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xe2'\'''

echo '$ test-expr $'\''/a/\xe3'\'''
test-expr $'/a/\xe3' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xe3'\'''

echo '$ test-expr $'\''/a/\xe4'\'''
test-expr $'/a/\xe4' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xe4'\'''

echo '$ test-expr $'\''/a/\xe5'\'''
test-expr $'/a/\xe5' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xe5'\'''

echo '$ test-expr $'\''/a/\xe6'\'''
test-expr $'/a/\xe6' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xe6'\'''

echo '$ test-expr $'\''/a/\xe7'\'''
test-expr $'/a/\xe7' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xe7'\'''

echo '$ test-expr $'\''/a/\xe8'\'''
test-expr $'/a/\xe8' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xe8'\'''

echo '$ test-expr $'\''/a/\xe9'\'''
test-expr $'/a/\xe9' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xe9'\'''

echo '$ test-expr $'\''/a/\xea'\'''
test-expr $'/a/\xea' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xea'\'''

echo '$ test-expr $'\''/a/\xeb'\'''
test-expr $'/a/\xeb' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xeb'\'''

echo '$ test-expr $'\''/a/\xec'\'''
test-expr $'/a/\xec' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xec'\'''

echo '$ test-expr $'\''/a/\xed'\'''
test-expr $'/a/\xed' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xed'\'''

echo '$ test-expr $'\''/a/\xee'\'''
test-expr $'/a/\xee' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xee'\'''

echo '$ test-expr $'\''/a/\xef'\'''
test-expr $'/a/\xef' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xef'\'''

echo '$ test-expr $'\''/a/\xf0'\'''
test-expr $'/a/\xf0' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xf0'\'''

echo '$ test-expr $'\''/a/\xf1'\'''
test-expr $'/a/\xf1' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xf1'\'''

echo '$ test-expr $'\''/a/\xf2'\'''
test-expr $'/a/\xf2' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xf2'\'''

echo '$ test-expr $'\''/a/\xf3'\'''
test-expr $'/a/\xf3' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xf3'\'''

echo '$ test-expr $'\''/a/\xf4'\'''
test-expr $'/a/\xf4' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xf4'\'''

echo '$ test-expr $'\''/a/\xf5'\'''
test-expr $'/a/\xf5' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xf5'\'''

echo '$ test-expr $'\''/a/\xf6'\'''
test-expr $'/a/\xf6' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xf6'\'''

echo '$ test-expr $'\''/a/\xf7'\'''
test-expr $'/a/\xf7' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xf7'\'''

echo '$ test-expr $'\''/a/\xf8'\'''
test-expr $'/a/\xf8' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xf8'\'''

echo '$ test-expr $'\''/a/\xf9'\'''
test-expr $'/a/\xf9' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xf9'\'''

echo '$ test-expr $'\''/a/\xfa'\'''
test-expr $'/a/\xfa' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xfa'\'''

echo '$ test-expr $'\''/a/\xfb'\'''
test-expr $'/a/\xfb' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xfb'\'''

echo '$ test-expr $'\''/a/\xfc'\'''
test-expr $'/a/\xfc' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xfc'\'''

echo '$ test-expr $'\''/a/\xfd'\'''
test-expr $'/a/\xfd' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xfd'\'''

echo '$ test-expr $'\''/a/\xfe'\'''
test-expr $'/a/\xfe' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xfe'\'''

echo '$ test-expr $'\''/a/\xff'\'''
test-expr $'/a/\xff' 2>&1 ||
echo 'command failed: test-expr $'\''/a/\xff'\'''
)

