#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C parser:raw-string3
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L raw-string3.old <(echo \
'$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }
$ json() { json0 --literal-value --raw-strings "$@"; }
$ echo -n '\''r'\''|json -b1
json: error: <stdin>:1:2: lex error: invalid raw string literal
json: error: <stdin>:1:2: r
json: error: <stdin>:1:2:  ^
command failed: echo -n '\''r'\''|json -b1
$ echo -n '\''r"'\''|json -b1
json: error: <stdin>:1:3: lex error: invalid raw string literal
json: error: <stdin>:1:3: r"
json: error: <stdin>:1:3:   ^
command failed: echo -n '\''r"'\''|json -b1
$ echo -n '\''r"('\''|json -b1
json: error: <stdin>:1:4: lex error: invalid raw string literal
json: error: <stdin>:1:4: r"(
json: error: <stdin>:1:4:    ^
command failed: echo -n '\''r"('\''|json -b1
$ echo -n '\''r"()'\''|json -b1
json: error: <stdin>:1:5: lex error: invalid raw string literal
json: error: <stdin>:1:5: r"()
json: error: <stdin>:1:5:     ^
command failed: echo -n '\''r"()'\''|json -b1
$ echo -n '\''r"()"'\''|json -b1
r"()"
$ echo -n '\''r"())'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"())
json: error: <stdin>:1:6:      ^
command failed: echo -n '\''r"())'\''|json -b1
$ echo -n '\''r"())"'\''|json -b1
r"())"
$ echo -n '\''r"(f'\''|json -b1
json: error: <stdin>:1:5: lex error: invalid raw string literal
json: error: <stdin>:1:5: r"(f
json: error: <stdin>:1:5:     ^
command failed: echo -n '\''r"(f'\''|json -b1
$ echo -n '\''r"(fo'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"(fo
json: error: <stdin>:1:6:      ^
command failed: echo -n '\''r"(fo'\''|json -b1
$ echo -n '\''r"(foo'\''|json -b1
json: error: <stdin>:1:7: lex error: invalid raw string literal
json: error: <stdin>:1:7: r"(foo
json: error: <stdin>:1:7:       ^
command failed: echo -n '\''r"(foo'\''|json -b1
$ echo -n '\''r"(foo)'\''|json -b1
json: error: <stdin>:1:8: lex error: invalid raw string literal
json: error: <stdin>:1:8: r"(foo)
json: error: <stdin>:1:8:        ^
command failed: echo -n '\''r"(foo)'\''|json -b1
$ echo -n '\''r"(foo)"'\''|json -b1
r"(foo)"
$ echo -n '\''r"(foo))'\''|json -b1
json: error: <stdin>:1:9: lex error: invalid raw string literal
json: error: <stdin>:1:9: r"(foo))
json: error: <stdin>:1:9:         ^
command failed: echo -n '\''r"(foo))'\''|json -b1
$ echo -n '\''r"(foo))"'\''|json -b1
r"(foo))"
$ echo -n '\''r"0'\''|json -b1
json: error: <stdin>:1:4: lex error: invalid raw string literal
json: error: <stdin>:1:4: r"0
json: error: <stdin>:1:4:    ^
command failed: echo -n '\''r"0'\''|json -b1
$ echo -n '\''r"01'\''|json -b1
json: error: <stdin>:1:5: lex error: invalid raw string literal
json: error: <stdin>:1:5: r"01
json: error: <stdin>:1:5:     ^
command failed: echo -n '\''r"01'\''|json -b1
$ echo -n '\''r"012'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"012
json: error: <stdin>:1:6:      ^
command failed: echo -n '\''r"012'\''|json -b1
$ echo -n '\''r"0123'\''|json -b1
json: error: <stdin>:1:7: lex error: invalid raw string literal
json: error: <stdin>:1:7: r"0123
json: error: <stdin>:1:7:       ^
command failed: echo -n '\''r"0123'\''|json -b1
$ echo -n '\''r"01234'\''|json -b1
json: error: <stdin>:1:8: lex error: invalid raw string literal
json: error: <stdin>:1:8: r"01234
json: error: <stdin>:1:8:        ^
command failed: echo -n '\''r"01234'\''|json -b1
$ echo -n '\''r"012345'\''|json -b1
json: error: <stdin>:1:9: lex error: invalid raw string literal
json: error: <stdin>:1:9: r"012345
json: error: <stdin>:1:9:         ^
command failed: echo -n '\''r"012345'\''|json -b1
$ echo -n '\''r"0123456'\''|json -b1
json: error: <stdin>:1:10: lex error: invalid raw string literal
json: error: <stdin>:1:10: r"0123456
json: error: <stdin>:1:10:          ^
command failed: echo -n '\''r"0123456'\''|json -b1
$ echo -n '\''r"01234567'\''|json -b1
json: error: <stdin>:1:11: lex error: invalid raw string literal
json: error: <stdin>:1:11: r"01234567
json: error: <stdin>:1:11:           ^
command failed: echo -n '\''r"01234567'\''|json -b1
$ echo -n '\''r"012345678'\''|json -b1
json: error: <stdin>:1:12: lex error: invalid raw string literal
json: error: <stdin>:1:12: r"012345678
json: error: <stdin>:1:12:            ^
command failed: echo -n '\''r"012345678'\''|json -b1
$ echo -n '\''r"0123456789'\''|json -b1
json: error: <stdin>:1:13: lex error: invalid raw string literal
json: error: <stdin>:1:13: r"0123456789
json: error: <stdin>:1:13:             ^
command failed: echo -n '\''r"0123456789'\''|json -b1
$ echo -n '\''r"0123456789a'\''|json -b1
json: error: <stdin>:1:14: lex error: invalid raw string literal
json: error: <stdin>:1:14: r"0123456789a
json: error: <stdin>:1:14:              ^
command failed: echo -n '\''r"0123456789a'\''|json -b1
$ echo -n '\''r"0123456789ab'\''|json -b1
json: error: <stdin>:1:15: lex error: invalid raw string literal
json: error: <stdin>:1:15: r"0123456789ab
json: error: <stdin>:1:15:               ^
command failed: echo -n '\''r"0123456789ab'\''|json -b1
$ echo -n '\''r"0123456789abc'\''|json -b1
json: error: <stdin>:1:16: lex error: invalid raw string literal
json: error: <stdin>:1:16: r"0123456789abc
json: error: <stdin>:1:16:                ^
command failed: echo -n '\''r"0123456789abc'\''|json -b1
$ echo -n '\''r"0123456789abcd'\''|json -b1
json: error: <stdin>:1:17: lex error: invalid raw string literal
json: error: <stdin>:1:17: r"0123456789abcd
json: error: <stdin>:1:17:                 ^
command failed: echo -n '\''r"0123456789abcd'\''|json -b1
$ echo -n '\''r"0123456789abcde'\''|json -b1
json: error: <stdin>:1:18: lex error: invalid raw string literal
json: error: <stdin>:1:18: r"0123456789abcde
json: error: <stdin>:1:18:                  ^
command failed: echo -n '\''r"0123456789abcde'\''|json -b1
$ echo -n '\''r"0123456789abcdef'\''|json -b1
json: error: <stdin>:1:19: lex error: invalid raw string literal
json: error: <stdin>:1:19: r"0123456789abcdef
json: error: <stdin>:1:19:                   ^
command failed: echo -n '\''r"0123456789abcdef'\''|json -b1
$ echo -n '\''r"0123456789abcdef('\''|json -b1
json: error: <stdin>:1:20: lex error: invalid raw string literal
json: error: <stdin>:1:20: r"0123456789abcdef(
json: error: <stdin>:1:20:                    ^
command failed: echo -n '\''r"0123456789abcdef('\''|json -b1
$ echo -n '\''r"0123456789abcdef()'\''|json -b1
json: error: <stdin>:1:21: lex error: invalid raw string literal
json: error: <stdin>:1:21: r"0123456789abcdef()
json: error: <stdin>:1:21:                     ^
command failed: echo -n '\''r"0123456789abcdef()'\''|json -b1
$ echo -n '\''r"0123456789abcdef())'\''|json -b1
json: error: <stdin>:1:22: lex error: invalid raw string literal
json: error: <stdin>:1:22: r"0123456789abcdef())
json: error: <stdin>:1:22:                      ^
command failed: echo -n '\''r"0123456789abcdef())'\''|json -b1
$ echo -n '\''r"0123456789abcdef())0'\''|json -b1
json: error: <stdin>:1:23: lex error: invalid raw string literal
json: error: <stdin>:1:23: r"0123456789abcdef())0
json: error: <stdin>:1:23:                       ^
command failed: echo -n '\''r"0123456789abcdef())0'\''|json -b1
$ echo -n '\''r"0123456789abcdef())01'\''|json -b1
json: error: <stdin>:1:24: lex error: invalid raw string literal
json: error: <stdin>:1:24: r"0123456789abcdef())01
json: error: <stdin>:1:24:                        ^
command failed: echo -n '\''r"0123456789abcdef())01'\''|json -b1
$ echo -n '\''r"0123456789abcdef())012'\''|json -b1
json: error: <stdin>:1:25: lex error: invalid raw string literal
json: error: <stdin>:1:25: r"0123456789abcdef())012
json: error: <stdin>:1:25:                         ^
command failed: echo -n '\''r"0123456789abcdef())012'\''|json -b1
$ echo -n '\''r"0123456789abcdef())0123'\''|json -b1
json: error: <stdin>:1:26: lex error: invalid raw string literal
json: error: <stdin>:1:26: r"0123456789abcdef())0123
json: error: <stdin>:1:26:                          ^
command failed: echo -n '\''r"0123456789abcdef())0123'\''|json -b1
$ echo -n '\''r"0123456789abcdef())01234'\''|json -b1
json: error: <stdin>:1:27: lex error: invalid raw string literal
json: error: <stdin>:1:27: r"0123456789abcdef())01234
json: error: <stdin>:1:27:                           ^
command failed: echo -n '\''r"0123456789abcdef())01234'\''|json -b1
$ echo -n '\''r"0123456789abcdef())012345'\''|json -b1
json: error: <stdin>:1:28: lex error: invalid raw string literal
json: error: <stdin>:1:28: r"0123456789abcdef())012345
json: error: <stdin>:1:28:                            ^
command failed: echo -n '\''r"0123456789abcdef())012345'\''|json -b1
$ echo -n '\''r"0123456789abcdef())0123456'\''|json -b1
json: error: <stdin>:1:29: lex error: invalid raw string literal
json: error: <stdin>:1:29: r"0123456789abcdef())0123456
json: error: <stdin>:1:29:                             ^
command failed: echo -n '\''r"0123456789abcdef())0123456'\''|json -b1
$ echo -n '\''r"0123456789abcdef())01234567'\''|json -b1
json: error: <stdin>:1:30: lex error: invalid raw string literal
json: error: <stdin>:1:30: r"0123456789abcdef())01234567
json: error: <stdin>:1:30:                              ^
command failed: echo -n '\''r"0123456789abcdef())01234567'\''|json -b1
$ echo -n '\''r"0123456789abcdef())012345678'\''|json -b1
json: error: <stdin>:1:31: lex error: invalid raw string literal
json: error: <stdin>:1:31: r"0123456789abcdef())012345678
json: error: <stdin>:1:31:                               ^
command failed: echo -n '\''r"0123456789abcdef())012345678'\''|json -b1
$ echo -n '\''r"0123456789abcdef())0123456789'\''|json -b1
json: error: <stdin>:1:32: lex error: invalid raw string literal
json: error: <stdin>:1:32: r"0123456789abcdef())0123456789
json: error: <stdin>:1:32:                                ^
command failed: echo -n '\''r"0123456789abcdef())0123456789'\''|json -b1
$ echo -n '\''r"0123456789abcdef())0123456789a'\''|json -b1
json: error: <stdin>:1:33: lex error: invalid raw string literal
json: error: <stdin>:1:33: r"0123456789abcdef())0123456789a
json: error: <stdin>:1:33:                                 ^
command failed: echo -n '\''r"0123456789abcdef())0123456789a'\''|json -b1
$ echo -n '\''r"0123456789abcdef())0123456789ab'\''|json -b1
json: error: <stdin>:1:34: lex error: invalid raw string literal
json: error: <stdin>:1:34: "0123456789abcdef())0123456789ab
json: error: <stdin>:1:34:                                 ^
command failed: echo -n '\''r"0123456789abcdef())0123456789ab'\''|json -b1
$ echo -n '\''r"0123456789abcdef())0123456789abc'\''|json -b1
json: error: <stdin>:1:35: lex error: invalid raw string literal
json: error: <stdin>:1:35: 0123456789abcdef())0123456789abc
json: error: <stdin>:1:35:                                 ^
command failed: echo -n '\''r"0123456789abcdef())0123456789abc'\''|json -b1
$ echo -n '\''r"0123456789abcdef())0123456789abcd'\''|json -b1
json: error: <stdin>:1:36: lex error: invalid raw string literal
json: error: <stdin>:1:36: 123456789abcdef())0123456789abcd
json: error: <stdin>:1:36:                                 ^
command failed: echo -n '\''r"0123456789abcdef())0123456789abcd'\''|json -b1
$ echo -n '\''r"0123456789abcdef())0123456789abcde'\''|json -b1
json: error: <stdin>:1:37: lex error: invalid raw string literal
json: error: <stdin>:1:37: 23456789abcdef())0123456789abcde
json: error: <stdin>:1:37:                                 ^
command failed: echo -n '\''r"0123456789abcdef())0123456789abcde'\''|json -b1
$ echo -n '\''r"0123456789abcdef())0123456789abcdef'\''|json -b1
json: error: <stdin>:1:38: lex error: invalid raw string literal
json: error: <stdin>:1:38: 3456789abcdef())0123456789abcdef
json: error: <stdin>:1:38:                                 ^
command failed: echo -n '\''r"0123456789abcdef())0123456789abcdef'\''|json -b1
$ echo -n '\''r"0123456789abcdef())0123456789abcdef"'\''|json -b1
r"0123456789abcdef())0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()0'\''|json -b1
json: error: <stdin>:1:22: lex error: invalid raw string literal
json: error: <stdin>:1:22: r"0123456789abcdef()0
json: error: <stdin>:1:22:                      ^
command failed: echo -n '\''r"0123456789abcdef()0'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0)'\''|json -b1
json: error: <stdin>:1:23: lex error: invalid raw string literal
json: error: <stdin>:1:23: r"0123456789abcdef()0)
json: error: <stdin>:1:23:                       ^
command failed: echo -n '\''r"0123456789abcdef()0)'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0)0'\''|json -b1
json: error: <stdin>:1:24: lex error: invalid raw string literal
json: error: <stdin>:1:24: r"0123456789abcdef()0)0
json: error: <stdin>:1:24:                        ^
command failed: echo -n '\''r"0123456789abcdef()0)0'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0)01'\''|json -b1
json: error: <stdin>:1:25: lex error: invalid raw string literal
json: error: <stdin>:1:25: r"0123456789abcdef()0)01
json: error: <stdin>:1:25:                         ^
command failed: echo -n '\''r"0123456789abcdef()0)01'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0)012'\''|json -b1
json: error: <stdin>:1:26: lex error: invalid raw string literal
json: error: <stdin>:1:26: r"0123456789abcdef()0)012
json: error: <stdin>:1:26:                          ^
command failed: echo -n '\''r"0123456789abcdef()0)012'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0)0123'\''|json -b1
json: error: <stdin>:1:27: lex error: invalid raw string literal
json: error: <stdin>:1:27: r"0123456789abcdef()0)0123
json: error: <stdin>:1:27:                           ^
command failed: echo -n '\''r"0123456789abcdef()0)0123'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0)01234'\''|json -b1
json: error: <stdin>:1:28: lex error: invalid raw string literal
json: error: <stdin>:1:28: r"0123456789abcdef()0)01234
json: error: <stdin>:1:28:                            ^
command failed: echo -n '\''r"0123456789abcdef()0)01234'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0)012345'\''|json -b1
json: error: <stdin>:1:29: lex error: invalid raw string literal
json: error: <stdin>:1:29: r"0123456789abcdef()0)012345
json: error: <stdin>:1:29:                             ^
command failed: echo -n '\''r"0123456789abcdef()0)012345'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0)0123456'\''|json -b1
json: error: <stdin>:1:30: lex error: invalid raw string literal
json: error: <stdin>:1:30: r"0123456789abcdef()0)0123456
json: error: <stdin>:1:30:                              ^
command failed: echo -n '\''r"0123456789abcdef()0)0123456'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0)01234567'\''|json -b1
json: error: <stdin>:1:31: lex error: invalid raw string literal
json: error: <stdin>:1:31: r"0123456789abcdef()0)01234567
json: error: <stdin>:1:31:                               ^
command failed: echo -n '\''r"0123456789abcdef()0)01234567'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0)012345678'\''|json -b1
json: error: <stdin>:1:32: lex error: invalid raw string literal
json: error: <stdin>:1:32: r"0123456789abcdef()0)012345678
json: error: <stdin>:1:32:                                ^
command failed: echo -n '\''r"0123456789abcdef()0)012345678'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0)0123456789'\''|json -b1
json: error: <stdin>:1:33: lex error: invalid raw string literal
json: error: <stdin>:1:33: r"0123456789abcdef()0)0123456789
json: error: <stdin>:1:33:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0)0123456789'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0)0123456789a'\''|json -b1
json: error: <stdin>:1:34: lex error: invalid raw string literal
json: error: <stdin>:1:34: "0123456789abcdef()0)0123456789a
json: error: <stdin>:1:34:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0)0123456789a'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0)0123456789ab'\''|json -b1
json: error: <stdin>:1:35: lex error: invalid raw string literal
json: error: <stdin>:1:35: 0123456789abcdef()0)0123456789ab
json: error: <stdin>:1:35:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0)0123456789ab'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0)0123456789abc'\''|json -b1
json: error: <stdin>:1:36: lex error: invalid raw string literal
json: error: <stdin>:1:36: 123456789abcdef()0)0123456789abc
json: error: <stdin>:1:36:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0)0123456789abc'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0)0123456789abcd'\''|json -b1
json: error: <stdin>:1:37: lex error: invalid raw string literal
json: error: <stdin>:1:37: 23456789abcdef()0)0123456789abcd
json: error: <stdin>:1:37:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0)0123456789abcd'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0)0123456789abcde'\''|json -b1
json: error: <stdin>:1:38: lex error: invalid raw string literal
json: error: <stdin>:1:38: 3456789abcdef()0)0123456789abcde
json: error: <stdin>:1:38:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0)0123456789abcde'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0)0123456789abcdef'\''|json -b1
json: error: <stdin>:1:39: lex error: invalid raw string literal
json: error: <stdin>:1:39: 456789abcdef()0)0123456789abcdef
json: error: <stdin>:1:39:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0)0123456789abcdef'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0)0123456789abcdef"'\''|json -b1
r"0123456789abcdef()0)0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()01'\''|json -b1
json: error: <stdin>:1:23: lex error: invalid raw string literal
json: error: <stdin>:1:23: r"0123456789abcdef()01
json: error: <stdin>:1:23:                       ^
command failed: echo -n '\''r"0123456789abcdef()01'\''|json -b1
$ echo -n '\''r"0123456789abcdef()01)'\''|json -b1
json: error: <stdin>:1:24: lex error: invalid raw string literal
json: error: <stdin>:1:24: r"0123456789abcdef()01)
json: error: <stdin>:1:24:                        ^
command failed: echo -n '\''r"0123456789abcdef()01)'\''|json -b1
$ echo -n '\''r"0123456789abcdef()01)0'\''|json -b1
json: error: <stdin>:1:25: lex error: invalid raw string literal
json: error: <stdin>:1:25: r"0123456789abcdef()01)0
json: error: <stdin>:1:25:                         ^
command failed: echo -n '\''r"0123456789abcdef()01)0'\''|json -b1
$ echo -n '\''r"0123456789abcdef()01)01'\''|json -b1
json: error: <stdin>:1:26: lex error: invalid raw string literal
json: error: <stdin>:1:26: r"0123456789abcdef()01)01
json: error: <stdin>:1:26:                          ^
command failed: echo -n '\''r"0123456789abcdef()01)01'\''|json -b1
$ echo -n '\''r"0123456789abcdef()01)012'\''|json -b1
json: error: <stdin>:1:27: lex error: invalid raw string literal
json: error: <stdin>:1:27: r"0123456789abcdef()01)012
json: error: <stdin>:1:27:                           ^
command failed: echo -n '\''r"0123456789abcdef()01)012'\''|json -b1
$ echo -n '\''r"0123456789abcdef()01)0123'\''|json -b1
json: error: <stdin>:1:28: lex error: invalid raw string literal
json: error: <stdin>:1:28: r"0123456789abcdef()01)0123
json: error: <stdin>:1:28:                            ^
command failed: echo -n '\''r"0123456789abcdef()01)0123'\''|json -b1
$ echo -n '\''r"0123456789abcdef()01)01234'\''|json -b1
json: error: <stdin>:1:29: lex error: invalid raw string literal
json: error: <stdin>:1:29: r"0123456789abcdef()01)01234
json: error: <stdin>:1:29:                             ^
command failed: echo -n '\''r"0123456789abcdef()01)01234'\''|json -b1
$ echo -n '\''r"0123456789abcdef()01)012345'\''|json -b1
json: error: <stdin>:1:30: lex error: invalid raw string literal
json: error: <stdin>:1:30: r"0123456789abcdef()01)012345
json: error: <stdin>:1:30:                              ^
command failed: echo -n '\''r"0123456789abcdef()01)012345'\''|json -b1
$ echo -n '\''r"0123456789abcdef()01)0123456'\''|json -b1
json: error: <stdin>:1:31: lex error: invalid raw string literal
json: error: <stdin>:1:31: r"0123456789abcdef()01)0123456
json: error: <stdin>:1:31:                               ^
command failed: echo -n '\''r"0123456789abcdef()01)0123456'\''|json -b1
$ echo -n '\''r"0123456789abcdef()01)01234567'\''|json -b1
json: error: <stdin>:1:32: lex error: invalid raw string literal
json: error: <stdin>:1:32: r"0123456789abcdef()01)01234567
json: error: <stdin>:1:32:                                ^
command failed: echo -n '\''r"0123456789abcdef()01)01234567'\''|json -b1
$ echo -n '\''r"0123456789abcdef()01)012345678'\''|json -b1
json: error: <stdin>:1:33: lex error: invalid raw string literal
json: error: <stdin>:1:33: r"0123456789abcdef()01)012345678
json: error: <stdin>:1:33:                                 ^
command failed: echo -n '\''r"0123456789abcdef()01)012345678'\''|json -b1
$ echo -n '\''r"0123456789abcdef()01)0123456789'\''|json -b1
json: error: <stdin>:1:34: lex error: invalid raw string literal
json: error: <stdin>:1:34: "0123456789abcdef()01)0123456789
json: error: <stdin>:1:34:                                 ^
command failed: echo -n '\''r"0123456789abcdef()01)0123456789'\''|json -b1
$ echo -n '\''r"0123456789abcdef()01)0123456789a'\''|json -b1
json: error: <stdin>:1:35: lex error: invalid raw string literal
json: error: <stdin>:1:35: 0123456789abcdef()01)0123456789a
json: error: <stdin>:1:35:                                 ^
command failed: echo -n '\''r"0123456789abcdef()01)0123456789a'\''|json -b1
$ echo -n '\''r"0123456789abcdef()01)0123456789ab'\''|json -b1
json: error: <stdin>:1:36: lex error: invalid raw string literal
json: error: <stdin>:1:36: 123456789abcdef()01)0123456789ab
json: error: <stdin>:1:36:                                 ^
command failed: echo -n '\''r"0123456789abcdef()01)0123456789ab'\''|json -b1
$ echo -n '\''r"0123456789abcdef()01)0123456789abc'\''|json -b1
json: error: <stdin>:1:37: lex error: invalid raw string literal
json: error: <stdin>:1:37: 23456789abcdef()01)0123456789abc
json: error: <stdin>:1:37:                                 ^
command failed: echo -n '\''r"0123456789abcdef()01)0123456789abc'\''|json -b1
$ echo -n '\''r"0123456789abcdef()01)0123456789abcd'\''|json -b1
json: error: <stdin>:1:38: lex error: invalid raw string literal
json: error: <stdin>:1:38: 3456789abcdef()01)0123456789abcd
json: error: <stdin>:1:38:                                 ^
command failed: echo -n '\''r"0123456789abcdef()01)0123456789abcd'\''|json -b1
$ echo -n '\''r"0123456789abcdef()01)0123456789abcde'\''|json -b1
json: error: <stdin>:1:39: lex error: invalid raw string literal
json: error: <stdin>:1:39: 456789abcdef()01)0123456789abcde
json: error: <stdin>:1:39:                                 ^
command failed: echo -n '\''r"0123456789abcdef()01)0123456789abcde'\''|json -b1
$ echo -n '\''r"0123456789abcdef()01)0123456789abcdef'\''|json -b1
json: error: <stdin>:1:40: lex error: invalid raw string literal
json: error: <stdin>:1:40: 56789abcdef()01)0123456789abcdef
json: error: <stdin>:1:40:                                 ^
command failed: echo -n '\''r"0123456789abcdef()01)0123456789abcdef'\''|json -b1
$ echo -n '\''r"0123456789abcdef()01)0123456789abcdef"'\''|json -b1
r"0123456789abcdef()01)0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()012'\''|json -b1
json: error: <stdin>:1:24: lex error: invalid raw string literal
json: error: <stdin>:1:24: r"0123456789abcdef()012
json: error: <stdin>:1:24:                        ^
command failed: echo -n '\''r"0123456789abcdef()012'\''|json -b1
$ echo -n '\''r"0123456789abcdef()012)'\''|json -b1
json: error: <stdin>:1:25: lex error: invalid raw string literal
json: error: <stdin>:1:25: r"0123456789abcdef()012)
json: error: <stdin>:1:25:                         ^
command failed: echo -n '\''r"0123456789abcdef()012)'\''|json -b1
$ echo -n '\''r"0123456789abcdef()012)0'\''|json -b1
json: error: <stdin>:1:26: lex error: invalid raw string literal
json: error: <stdin>:1:26: r"0123456789abcdef()012)0
json: error: <stdin>:1:26:                          ^
command failed: echo -n '\''r"0123456789abcdef()012)0'\''|json -b1
$ echo -n '\''r"0123456789abcdef()012)01'\''|json -b1
json: error: <stdin>:1:27: lex error: invalid raw string literal
json: error: <stdin>:1:27: r"0123456789abcdef()012)01
json: error: <stdin>:1:27:                           ^
command failed: echo -n '\''r"0123456789abcdef()012)01'\''|json -b1
$ echo -n '\''r"0123456789abcdef()012)012'\''|json -b1
json: error: <stdin>:1:28: lex error: invalid raw string literal
json: error: <stdin>:1:28: r"0123456789abcdef()012)012
json: error: <stdin>:1:28:                            ^
command failed: echo -n '\''r"0123456789abcdef()012)012'\''|json -b1
$ echo -n '\''r"0123456789abcdef()012)0123'\''|json -b1
json: error: <stdin>:1:29: lex error: invalid raw string literal
json: error: <stdin>:1:29: r"0123456789abcdef()012)0123
json: error: <stdin>:1:29:                             ^
command failed: echo -n '\''r"0123456789abcdef()012)0123'\''|json -b1
$ echo -n '\''r"0123456789abcdef()012)01234'\''|json -b1
json: error: <stdin>:1:30: lex error: invalid raw string literal
json: error: <stdin>:1:30: r"0123456789abcdef()012)01234
json: error: <stdin>:1:30:                              ^
command failed: echo -n '\''r"0123456789abcdef()012)01234'\''|json -b1
$ echo -n '\''r"0123456789abcdef()012)012345'\''|json -b1
json: error: <stdin>:1:31: lex error: invalid raw string literal
json: error: <stdin>:1:31: r"0123456789abcdef()012)012345
json: error: <stdin>:1:31:                               ^
command failed: echo -n '\''r"0123456789abcdef()012)012345'\''|json -b1
$ echo -n '\''r"0123456789abcdef()012)0123456'\''|json -b1
json: error: <stdin>:1:32: lex error: invalid raw string literal
json: error: <stdin>:1:32: r"0123456789abcdef()012)0123456
json: error: <stdin>:1:32:                                ^
command failed: echo -n '\''r"0123456789abcdef()012)0123456'\''|json -b1
$ echo -n '\''r"0123456789abcdef()012)01234567'\''|json -b1
json: error: <stdin>:1:33: lex error: invalid raw string literal
json: error: <stdin>:1:33: r"0123456789abcdef()012)01234567
json: error: <stdin>:1:33:                                 ^
command failed: echo -n '\''r"0123456789abcdef()012)01234567'\''|json -b1
$ echo -n '\''r"0123456789abcdef()012)012345678'\''|json -b1
json: error: <stdin>:1:34: lex error: invalid raw string literal
json: error: <stdin>:1:34: "0123456789abcdef()012)012345678
json: error: <stdin>:1:34:                                 ^
command failed: echo -n '\''r"0123456789abcdef()012)012345678'\''|json -b1
$ echo -n '\''r"0123456789abcdef()012)0123456789'\''|json -b1
json: error: <stdin>:1:35: lex error: invalid raw string literal
json: error: <stdin>:1:35: 0123456789abcdef()012)0123456789
json: error: <stdin>:1:35:                                 ^
command failed: echo -n '\''r"0123456789abcdef()012)0123456789'\''|json -b1
$ echo -n '\''r"0123456789abcdef()012)0123456789a'\''|json -b1
json: error: <stdin>:1:36: lex error: invalid raw string literal
json: error: <stdin>:1:36: 123456789abcdef()012)0123456789a
json: error: <stdin>:1:36:                                 ^
command failed: echo -n '\''r"0123456789abcdef()012)0123456789a'\''|json -b1
$ echo -n '\''r"0123456789abcdef()012)0123456789ab'\''|json -b1
json: error: <stdin>:1:37: lex error: invalid raw string literal
json: error: <stdin>:1:37: 23456789abcdef()012)0123456789ab
json: error: <stdin>:1:37:                                 ^
command failed: echo -n '\''r"0123456789abcdef()012)0123456789ab'\''|json -b1
$ echo -n '\''r"0123456789abcdef()012)0123456789abc'\''|json -b1
json: error: <stdin>:1:38: lex error: invalid raw string literal
json: error: <stdin>:1:38: 3456789abcdef()012)0123456789abc
json: error: <stdin>:1:38:                                 ^
command failed: echo -n '\''r"0123456789abcdef()012)0123456789abc'\''|json -b1
$ echo -n '\''r"0123456789abcdef()012)0123456789abcd'\''|json -b1
json: error: <stdin>:1:39: lex error: invalid raw string literal
json: error: <stdin>:1:39: 456789abcdef()012)0123456789abcd
json: error: <stdin>:1:39:                                 ^
command failed: echo -n '\''r"0123456789abcdef()012)0123456789abcd'\''|json -b1
$ echo -n '\''r"0123456789abcdef()012)0123456789abcde'\''|json -b1
json: error: <stdin>:1:40: lex error: invalid raw string literal
json: error: <stdin>:1:40: 56789abcdef()012)0123456789abcde
json: error: <stdin>:1:40:                                 ^
command failed: echo -n '\''r"0123456789abcdef()012)0123456789abcde'\''|json -b1
$ echo -n '\''r"0123456789abcdef()012)0123456789abcdef'\''|json -b1
json: error: <stdin>:1:41: lex error: invalid raw string literal
json: error: <stdin>:1:41: 6789abcdef()012)0123456789abcdef
json: error: <stdin>:1:41:                                 ^
command failed: echo -n '\''r"0123456789abcdef()012)0123456789abcdef'\''|json -b1
$ echo -n '\''r"0123456789abcdef()012)0123456789abcdef"'\''|json -b1
r"0123456789abcdef()012)0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()0123'\''|json -b1
json: error: <stdin>:1:25: lex error: invalid raw string literal
json: error: <stdin>:1:25: r"0123456789abcdef()0123
json: error: <stdin>:1:25:                         ^
command failed: echo -n '\''r"0123456789abcdef()0123'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123)'\''|json -b1
json: error: <stdin>:1:26: lex error: invalid raw string literal
json: error: <stdin>:1:26: r"0123456789abcdef()0123)
json: error: <stdin>:1:26:                          ^
command failed: echo -n '\''r"0123456789abcdef()0123)'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123)0'\''|json -b1
json: error: <stdin>:1:27: lex error: invalid raw string literal
json: error: <stdin>:1:27: r"0123456789abcdef()0123)0
json: error: <stdin>:1:27:                           ^
command failed: echo -n '\''r"0123456789abcdef()0123)0'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123)01'\''|json -b1
json: error: <stdin>:1:28: lex error: invalid raw string literal
json: error: <stdin>:1:28: r"0123456789abcdef()0123)01
json: error: <stdin>:1:28:                            ^
command failed: echo -n '\''r"0123456789abcdef()0123)01'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123)012'\''|json -b1
json: error: <stdin>:1:29: lex error: invalid raw string literal
json: error: <stdin>:1:29: r"0123456789abcdef()0123)012
json: error: <stdin>:1:29:                             ^
command failed: echo -n '\''r"0123456789abcdef()0123)012'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123)0123'\''|json -b1
json: error: <stdin>:1:30: lex error: invalid raw string literal
json: error: <stdin>:1:30: r"0123456789abcdef()0123)0123
json: error: <stdin>:1:30:                              ^
command failed: echo -n '\''r"0123456789abcdef()0123)0123'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123)01234'\''|json -b1
json: error: <stdin>:1:31: lex error: invalid raw string literal
json: error: <stdin>:1:31: r"0123456789abcdef()0123)01234
json: error: <stdin>:1:31:                               ^
command failed: echo -n '\''r"0123456789abcdef()0123)01234'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123)012345'\''|json -b1
json: error: <stdin>:1:32: lex error: invalid raw string literal
json: error: <stdin>:1:32: r"0123456789abcdef()0123)012345
json: error: <stdin>:1:32:                                ^
command failed: echo -n '\''r"0123456789abcdef()0123)012345'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123)0123456'\''|json -b1
json: error: <stdin>:1:33: lex error: invalid raw string literal
json: error: <stdin>:1:33: r"0123456789abcdef()0123)0123456
json: error: <stdin>:1:33:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123)0123456'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123)01234567'\''|json -b1
json: error: <stdin>:1:34: lex error: invalid raw string literal
json: error: <stdin>:1:34: "0123456789abcdef()0123)01234567
json: error: <stdin>:1:34:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123)01234567'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123)012345678'\''|json -b1
json: error: <stdin>:1:35: lex error: invalid raw string literal
json: error: <stdin>:1:35: 0123456789abcdef()0123)012345678
json: error: <stdin>:1:35:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123)012345678'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123)0123456789'\''|json -b1
json: error: <stdin>:1:36: lex error: invalid raw string literal
json: error: <stdin>:1:36: 123456789abcdef()0123)0123456789
json: error: <stdin>:1:36:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123)0123456789'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123)0123456789a'\''|json -b1
json: error: <stdin>:1:37: lex error: invalid raw string literal
json: error: <stdin>:1:37: 23456789abcdef()0123)0123456789a
json: error: <stdin>:1:37:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123)0123456789a'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123)0123456789ab'\''|json -b1
json: error: <stdin>:1:38: lex error: invalid raw string literal
json: error: <stdin>:1:38: 3456789abcdef()0123)0123456789ab
json: error: <stdin>:1:38:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123)0123456789ab'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123)0123456789abc'\''|json -b1
json: error: <stdin>:1:39: lex error: invalid raw string literal
json: error: <stdin>:1:39: 456789abcdef()0123)0123456789abc
json: error: <stdin>:1:39:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123)0123456789abc'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123)0123456789abcd'\''|json -b1
json: error: <stdin>:1:40: lex error: invalid raw string literal
json: error: <stdin>:1:40: 56789abcdef()0123)0123456789abcd
json: error: <stdin>:1:40:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123)0123456789abcd'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123)0123456789abcde'\''|json -b1
json: error: <stdin>:1:41: lex error: invalid raw string literal
json: error: <stdin>:1:41: 6789abcdef()0123)0123456789abcde
json: error: <stdin>:1:41:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123)0123456789abcde'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123)0123456789abcdef'\''|json -b1
json: error: <stdin>:1:42: lex error: invalid raw string literal
json: error: <stdin>:1:42: 789abcdef()0123)0123456789abcdef
json: error: <stdin>:1:42:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123)0123456789abcdef'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123)0123456789abcdef"'\''|json -b1
r"0123456789abcdef()0123)0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()01234'\''|json -b1
json: error: <stdin>:1:26: lex error: invalid raw string literal
json: error: <stdin>:1:26: r"0123456789abcdef()01234
json: error: <stdin>:1:26:                          ^
command failed: echo -n '\''r"0123456789abcdef()01234'\''|json -b1
$ echo -n '\''r"0123456789abcdef()01234)'\''|json -b1
json: error: <stdin>:1:27: lex error: invalid raw string literal
json: error: <stdin>:1:27: r"0123456789abcdef()01234)
json: error: <stdin>:1:27:                           ^
command failed: echo -n '\''r"0123456789abcdef()01234)'\''|json -b1
$ echo -n '\''r"0123456789abcdef()01234)0'\''|json -b1
json: error: <stdin>:1:28: lex error: invalid raw string literal
json: error: <stdin>:1:28: r"0123456789abcdef()01234)0
json: error: <stdin>:1:28:                            ^
command failed: echo -n '\''r"0123456789abcdef()01234)0'\''|json -b1
$ echo -n '\''r"0123456789abcdef()01234)01'\''|json -b1
json: error: <stdin>:1:29: lex error: invalid raw string literal
json: error: <stdin>:1:29: r"0123456789abcdef()01234)01
json: error: <stdin>:1:29:                             ^
command failed: echo -n '\''r"0123456789abcdef()01234)01'\''|json -b1
$ echo -n '\''r"0123456789abcdef()01234)012'\''|json -b1
json: error: <stdin>:1:30: lex error: invalid raw string literal
json: error: <stdin>:1:30: r"0123456789abcdef()01234)012
json: error: <stdin>:1:30:                              ^
command failed: echo -n '\''r"0123456789abcdef()01234)012'\''|json -b1
$ echo -n '\''r"0123456789abcdef()01234)0123'\''|json -b1
json: error: <stdin>:1:31: lex error: invalid raw string literal
json: error: <stdin>:1:31: r"0123456789abcdef()01234)0123
json: error: <stdin>:1:31:                               ^
command failed: echo -n '\''r"0123456789abcdef()01234)0123'\''|json -b1
$ echo -n '\''r"0123456789abcdef()01234)01234'\''|json -b1
json: error: <stdin>:1:32: lex error: invalid raw string literal
json: error: <stdin>:1:32: r"0123456789abcdef()01234)01234
json: error: <stdin>:1:32:                                ^
command failed: echo -n '\''r"0123456789abcdef()01234)01234'\''|json -b1
$ echo -n '\''r"0123456789abcdef()01234)012345'\''|json -b1
json: error: <stdin>:1:33: lex error: invalid raw string literal
json: error: <stdin>:1:33: r"0123456789abcdef()01234)012345
json: error: <stdin>:1:33:                                 ^
command failed: echo -n '\''r"0123456789abcdef()01234)012345'\''|json -b1
$ echo -n '\''r"0123456789abcdef()01234)0123456'\''|json -b1
json: error: <stdin>:1:34: lex error: invalid raw string literal
json: error: <stdin>:1:34: "0123456789abcdef()01234)0123456
json: error: <stdin>:1:34:                                 ^
command failed: echo -n '\''r"0123456789abcdef()01234)0123456'\''|json -b1
$ echo -n '\''r"0123456789abcdef()01234)01234567'\''|json -b1
json: error: <stdin>:1:35: lex error: invalid raw string literal
json: error: <stdin>:1:35: 0123456789abcdef()01234)01234567
json: error: <stdin>:1:35:                                 ^
command failed: echo -n '\''r"0123456789abcdef()01234)01234567'\''|json -b1
$ echo -n '\''r"0123456789abcdef()01234)012345678'\''|json -b1
json: error: <stdin>:1:36: lex error: invalid raw string literal
json: error: <stdin>:1:36: 123456789abcdef()01234)012345678
json: error: <stdin>:1:36:                                 ^
command failed: echo -n '\''r"0123456789abcdef()01234)012345678'\''|json -b1
$ echo -n '\''r"0123456789abcdef()01234)0123456789'\''|json -b1
json: error: <stdin>:1:37: lex error: invalid raw string literal
json: error: <stdin>:1:37: 23456789abcdef()01234)0123456789
json: error: <stdin>:1:37:                                 ^
command failed: echo -n '\''r"0123456789abcdef()01234)0123456789'\''|json -b1
$ echo -n '\''r"0123456789abcdef()01234)0123456789a'\''|json -b1
json: error: <stdin>:1:38: lex error: invalid raw string literal
json: error: <stdin>:1:38: 3456789abcdef()01234)0123456789a
json: error: <stdin>:1:38:                                 ^
command failed: echo -n '\''r"0123456789abcdef()01234)0123456789a'\''|json -b1
$ echo -n '\''r"0123456789abcdef()01234)0123456789ab'\''|json -b1
json: error: <stdin>:1:39: lex error: invalid raw string literal
json: error: <stdin>:1:39: 456789abcdef()01234)0123456789ab
json: error: <stdin>:1:39:                                 ^
command failed: echo -n '\''r"0123456789abcdef()01234)0123456789ab'\''|json -b1
$ echo -n '\''r"0123456789abcdef()01234)0123456789abc'\''|json -b1
json: error: <stdin>:1:40: lex error: invalid raw string literal
json: error: <stdin>:1:40: 56789abcdef()01234)0123456789abc
json: error: <stdin>:1:40:                                 ^
command failed: echo -n '\''r"0123456789abcdef()01234)0123456789abc'\''|json -b1
$ echo -n '\''r"0123456789abcdef()01234)0123456789abcd'\''|json -b1
json: error: <stdin>:1:41: lex error: invalid raw string literal
json: error: <stdin>:1:41: 6789abcdef()01234)0123456789abcd
json: error: <stdin>:1:41:                                 ^
command failed: echo -n '\''r"0123456789abcdef()01234)0123456789abcd'\''|json -b1
$ echo -n '\''r"0123456789abcdef()01234)0123456789abcde'\''|json -b1
json: error: <stdin>:1:42: lex error: invalid raw string literal
json: error: <stdin>:1:42: 789abcdef()01234)0123456789abcde
json: error: <stdin>:1:42:                                 ^
command failed: echo -n '\''r"0123456789abcdef()01234)0123456789abcde'\''|json -b1
$ echo -n '\''r"0123456789abcdef()01234)0123456789abcdef'\''|json -b1
json: error: <stdin>:1:43: lex error: invalid raw string literal
json: error: <stdin>:1:43: 89abcdef()01234)0123456789abcdef
json: error: <stdin>:1:43:                                 ^
command failed: echo -n '\''r"0123456789abcdef()01234)0123456789abcdef'\''|json -b1
$ echo -n '\''r"0123456789abcdef()01234)0123456789abcdef"'\''|json -b1
r"0123456789abcdef()01234)0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()012345'\''|json -b1
json: error: <stdin>:1:27: lex error: invalid raw string literal
json: error: <stdin>:1:27: r"0123456789abcdef()012345
json: error: <stdin>:1:27:                           ^
command failed: echo -n '\''r"0123456789abcdef()012345'\''|json -b1
$ echo -n '\''r"0123456789abcdef()012345)'\''|json -b1
json: error: <stdin>:1:28: lex error: invalid raw string literal
json: error: <stdin>:1:28: r"0123456789abcdef()012345)
json: error: <stdin>:1:28:                            ^
command failed: echo -n '\''r"0123456789abcdef()012345)'\''|json -b1
$ echo -n '\''r"0123456789abcdef()012345)0'\''|json -b1
json: error: <stdin>:1:29: lex error: invalid raw string literal
json: error: <stdin>:1:29: r"0123456789abcdef()012345)0
json: error: <stdin>:1:29:                             ^
command failed: echo -n '\''r"0123456789abcdef()012345)0'\''|json -b1
$ echo -n '\''r"0123456789abcdef()012345)01'\''|json -b1
json: error: <stdin>:1:30: lex error: invalid raw string literal
json: error: <stdin>:1:30: r"0123456789abcdef()012345)01
json: error: <stdin>:1:30:                              ^
command failed: echo -n '\''r"0123456789abcdef()012345)01'\''|json -b1
$ echo -n '\''r"0123456789abcdef()012345)012'\''|json -b1
json: error: <stdin>:1:31: lex error: invalid raw string literal
json: error: <stdin>:1:31: r"0123456789abcdef()012345)012
json: error: <stdin>:1:31:                               ^
command failed: echo -n '\''r"0123456789abcdef()012345)012'\''|json -b1
$ echo -n '\''r"0123456789abcdef()012345)0123'\''|json -b1
json: error: <stdin>:1:32: lex error: invalid raw string literal
json: error: <stdin>:1:32: r"0123456789abcdef()012345)0123
json: error: <stdin>:1:32:                                ^
command failed: echo -n '\''r"0123456789abcdef()012345)0123'\''|json -b1
$ echo -n '\''r"0123456789abcdef()012345)01234'\''|json -b1
json: error: <stdin>:1:33: lex error: invalid raw string literal
json: error: <stdin>:1:33: r"0123456789abcdef()012345)01234
json: error: <stdin>:1:33:                                 ^
command failed: echo -n '\''r"0123456789abcdef()012345)01234'\''|json -b1
$ echo -n '\''r"0123456789abcdef()012345)012345'\''|json -b1
json: error: <stdin>:1:34: lex error: invalid raw string literal
json: error: <stdin>:1:34: "0123456789abcdef()012345)012345
json: error: <stdin>:1:34:                                 ^
command failed: echo -n '\''r"0123456789abcdef()012345)012345'\''|json -b1
$ echo -n '\''r"0123456789abcdef()012345)0123456'\''|json -b1
json: error: <stdin>:1:35: lex error: invalid raw string literal
json: error: <stdin>:1:35: 0123456789abcdef()012345)0123456
json: error: <stdin>:1:35:                                 ^
command failed: echo -n '\''r"0123456789abcdef()012345)0123456'\''|json -b1
$ echo -n '\''r"0123456789abcdef()012345)01234567'\''|json -b1
json: error: <stdin>:1:36: lex error: invalid raw string literal
json: error: <stdin>:1:36: 123456789abcdef()012345)01234567
json: error: <stdin>:1:36:                                 ^
command failed: echo -n '\''r"0123456789abcdef()012345)01234567'\''|json -b1
$ echo -n '\''r"0123456789abcdef()012345)012345678'\''|json -b1
json: error: <stdin>:1:37: lex error: invalid raw string literal
json: error: <stdin>:1:37: 23456789abcdef()012345)012345678
json: error: <stdin>:1:37:                                 ^
command failed: echo -n '\''r"0123456789abcdef()012345)012345678'\''|json -b1
$ echo -n '\''r"0123456789abcdef()012345)0123456789'\''|json -b1
json: error: <stdin>:1:38: lex error: invalid raw string literal
json: error: <stdin>:1:38: 3456789abcdef()012345)0123456789
json: error: <stdin>:1:38:                                 ^
command failed: echo -n '\''r"0123456789abcdef()012345)0123456789'\''|json -b1
$ echo -n '\''r"0123456789abcdef()012345)0123456789a'\''|json -b1
json: error: <stdin>:1:39: lex error: invalid raw string literal
json: error: <stdin>:1:39: 456789abcdef()012345)0123456789a
json: error: <stdin>:1:39:                                 ^
command failed: echo -n '\''r"0123456789abcdef()012345)0123456789a'\''|json -b1
$ echo -n '\''r"0123456789abcdef()012345)0123456789ab'\''|json -b1
json: error: <stdin>:1:40: lex error: invalid raw string literal
json: error: <stdin>:1:40: 56789abcdef()012345)0123456789ab
json: error: <stdin>:1:40:                                 ^
command failed: echo -n '\''r"0123456789abcdef()012345)0123456789ab'\''|json -b1
$ echo -n '\''r"0123456789abcdef()012345)0123456789abc'\''|json -b1
json: error: <stdin>:1:41: lex error: invalid raw string literal
json: error: <stdin>:1:41: 6789abcdef()012345)0123456789abc
json: error: <stdin>:1:41:                                 ^
command failed: echo -n '\''r"0123456789abcdef()012345)0123456789abc'\''|json -b1
$ echo -n '\''r"0123456789abcdef()012345)0123456789abcd'\''|json -b1
json: error: <stdin>:1:42: lex error: invalid raw string literal
json: error: <stdin>:1:42: 789abcdef()012345)0123456789abcd
json: error: <stdin>:1:42:                                 ^
command failed: echo -n '\''r"0123456789abcdef()012345)0123456789abcd'\''|json -b1
$ echo -n '\''r"0123456789abcdef()012345)0123456789abcde'\''|json -b1
json: error: <stdin>:1:43: lex error: invalid raw string literal
json: error: <stdin>:1:43: 89abcdef()012345)0123456789abcde
json: error: <stdin>:1:43:                                 ^
command failed: echo -n '\''r"0123456789abcdef()012345)0123456789abcde'\''|json -b1
$ echo -n '\''r"0123456789abcdef()012345)0123456789abcdef'\''|json -b1
json: error: <stdin>:1:44: lex error: invalid raw string literal
json: error: <stdin>:1:44: 9abcdef()012345)0123456789abcdef
json: error: <stdin>:1:44:                                 ^
command failed: echo -n '\''r"0123456789abcdef()012345)0123456789abcdef'\''|json -b1
$ echo -n '\''r"0123456789abcdef()012345)0123456789abcdef"'\''|json -b1
r"0123456789abcdef()012345)0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()0123456'\''|json -b1
json: error: <stdin>:1:28: lex error: invalid raw string literal
json: error: <stdin>:1:28: r"0123456789abcdef()0123456
json: error: <stdin>:1:28:                            ^
command failed: echo -n '\''r"0123456789abcdef()0123456'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456)'\''|json -b1
json: error: <stdin>:1:29: lex error: invalid raw string literal
json: error: <stdin>:1:29: r"0123456789abcdef()0123456)
json: error: <stdin>:1:29:                             ^
command failed: echo -n '\''r"0123456789abcdef()0123456)'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456)0'\''|json -b1
json: error: <stdin>:1:30: lex error: invalid raw string literal
json: error: <stdin>:1:30: r"0123456789abcdef()0123456)0
json: error: <stdin>:1:30:                              ^
command failed: echo -n '\''r"0123456789abcdef()0123456)0'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456)01'\''|json -b1
json: error: <stdin>:1:31: lex error: invalid raw string literal
json: error: <stdin>:1:31: r"0123456789abcdef()0123456)01
json: error: <stdin>:1:31:                               ^
command failed: echo -n '\''r"0123456789abcdef()0123456)01'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456)012'\''|json -b1
json: error: <stdin>:1:32: lex error: invalid raw string literal
json: error: <stdin>:1:32: r"0123456789abcdef()0123456)012
json: error: <stdin>:1:32:                                ^
command failed: echo -n '\''r"0123456789abcdef()0123456)012'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456)0123'\''|json -b1
json: error: <stdin>:1:33: lex error: invalid raw string literal
json: error: <stdin>:1:33: r"0123456789abcdef()0123456)0123
json: error: <stdin>:1:33:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456)0123'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456)01234'\''|json -b1
json: error: <stdin>:1:34: lex error: invalid raw string literal
json: error: <stdin>:1:34: "0123456789abcdef()0123456)01234
json: error: <stdin>:1:34:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456)01234'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456)012345'\''|json -b1
json: error: <stdin>:1:35: lex error: invalid raw string literal
json: error: <stdin>:1:35: 0123456789abcdef()0123456)012345
json: error: <stdin>:1:35:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456)012345'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456)0123456'\''|json -b1
json: error: <stdin>:1:36: lex error: invalid raw string literal
json: error: <stdin>:1:36: 123456789abcdef()0123456)0123456
json: error: <stdin>:1:36:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456)0123456'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456)01234567'\''|json -b1
json: error: <stdin>:1:37: lex error: invalid raw string literal
json: error: <stdin>:1:37: 23456789abcdef()0123456)01234567
json: error: <stdin>:1:37:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456)01234567'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456)012345678'\''|json -b1
json: error: <stdin>:1:38: lex error: invalid raw string literal
json: error: <stdin>:1:38: 3456789abcdef()0123456)012345678
json: error: <stdin>:1:38:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456)012345678'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456)0123456789'\''|json -b1
json: error: <stdin>:1:39: lex error: invalid raw string literal
json: error: <stdin>:1:39: 456789abcdef()0123456)0123456789
json: error: <stdin>:1:39:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456)0123456789'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456)0123456789a'\''|json -b1
json: error: <stdin>:1:40: lex error: invalid raw string literal
json: error: <stdin>:1:40: 56789abcdef()0123456)0123456789a
json: error: <stdin>:1:40:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456)0123456789a'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456)0123456789ab'\''|json -b1
json: error: <stdin>:1:41: lex error: invalid raw string literal
json: error: <stdin>:1:41: 6789abcdef()0123456)0123456789ab
json: error: <stdin>:1:41:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456)0123456789ab'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456)0123456789abc'\''|json -b1
json: error: <stdin>:1:42: lex error: invalid raw string literal
json: error: <stdin>:1:42: 789abcdef()0123456)0123456789abc
json: error: <stdin>:1:42:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456)0123456789abc'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456)0123456789abcd'\''|json -b1
json: error: <stdin>:1:43: lex error: invalid raw string literal
json: error: <stdin>:1:43: 89abcdef()0123456)0123456789abcd
json: error: <stdin>:1:43:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456)0123456789abcd'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456)0123456789abcde'\''|json -b1
json: error: <stdin>:1:44: lex error: invalid raw string literal
json: error: <stdin>:1:44: 9abcdef()0123456)0123456789abcde
json: error: <stdin>:1:44:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456)0123456789abcde'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456)0123456789abcdef'\''|json -b1
json: error: <stdin>:1:45: lex error: invalid raw string literal
json: error: <stdin>:1:45: abcdef()0123456)0123456789abcdef
json: error: <stdin>:1:45:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456)0123456789abcdef'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456)0123456789abcdef"'\''|json -b1
r"0123456789abcdef()0123456)0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()01234567'\''|json -b1
json: error: <stdin>:1:29: lex error: invalid raw string literal
json: error: <stdin>:1:29: r"0123456789abcdef()01234567
json: error: <stdin>:1:29:                             ^
command failed: echo -n '\''r"0123456789abcdef()01234567'\''|json -b1
$ echo -n '\''r"0123456789abcdef()01234567)'\''|json -b1
json: error: <stdin>:1:30: lex error: invalid raw string literal
json: error: <stdin>:1:30: r"0123456789abcdef()01234567)
json: error: <stdin>:1:30:                              ^
command failed: echo -n '\''r"0123456789abcdef()01234567)'\''|json -b1
$ echo -n '\''r"0123456789abcdef()01234567)0'\''|json -b1
json: error: <stdin>:1:31: lex error: invalid raw string literal
json: error: <stdin>:1:31: r"0123456789abcdef()01234567)0
json: error: <stdin>:1:31:                               ^
command failed: echo -n '\''r"0123456789abcdef()01234567)0'\''|json -b1
$ echo -n '\''r"0123456789abcdef()01234567)01'\''|json -b1
json: error: <stdin>:1:32: lex error: invalid raw string literal
json: error: <stdin>:1:32: r"0123456789abcdef()01234567)01
json: error: <stdin>:1:32:                                ^
command failed: echo -n '\''r"0123456789abcdef()01234567)01'\''|json -b1
$ echo -n '\''r"0123456789abcdef()01234567)012'\''|json -b1
json: error: <stdin>:1:33: lex error: invalid raw string literal
json: error: <stdin>:1:33: r"0123456789abcdef()01234567)012
json: error: <stdin>:1:33:                                 ^
command failed: echo -n '\''r"0123456789abcdef()01234567)012'\''|json -b1
$ echo -n '\''r"0123456789abcdef()01234567)0123'\''|json -b1
json: error: <stdin>:1:34: lex error: invalid raw string literal
json: error: <stdin>:1:34: "0123456789abcdef()01234567)0123
json: error: <stdin>:1:34:                                 ^
command failed: echo -n '\''r"0123456789abcdef()01234567)0123'\''|json -b1
$ echo -n '\''r"0123456789abcdef()01234567)01234'\''|json -b1
json: error: <stdin>:1:35: lex error: invalid raw string literal
json: error: <stdin>:1:35: 0123456789abcdef()01234567)01234
json: error: <stdin>:1:35:                                 ^
command failed: echo -n '\''r"0123456789abcdef()01234567)01234'\''|json -b1
$ echo -n '\''r"0123456789abcdef()01234567)012345'\''|json -b1
json: error: <stdin>:1:36: lex error: invalid raw string literal
json: error: <stdin>:1:36: 123456789abcdef()01234567)012345
json: error: <stdin>:1:36:                                 ^
command failed: echo -n '\''r"0123456789abcdef()01234567)012345'\''|json -b1
$ echo -n '\''r"0123456789abcdef()01234567)0123456'\''|json -b1
json: error: <stdin>:1:37: lex error: invalid raw string literal
json: error: <stdin>:1:37: 23456789abcdef()01234567)0123456
json: error: <stdin>:1:37:                                 ^
command failed: echo -n '\''r"0123456789abcdef()01234567)0123456'\''|json -b1
$ echo -n '\''r"0123456789abcdef()01234567)01234567'\''|json -b1
json: error: <stdin>:1:38: lex error: invalid raw string literal
json: error: <stdin>:1:38: 3456789abcdef()01234567)01234567
json: error: <stdin>:1:38:                                 ^
command failed: echo -n '\''r"0123456789abcdef()01234567)01234567'\''|json -b1
$ echo -n '\''r"0123456789abcdef()01234567)012345678'\''|json -b1
json: error: <stdin>:1:39: lex error: invalid raw string literal
json: error: <stdin>:1:39: 456789abcdef()01234567)012345678
json: error: <stdin>:1:39:                                 ^
command failed: echo -n '\''r"0123456789abcdef()01234567)012345678'\''|json -b1
$ echo -n '\''r"0123456789abcdef()01234567)0123456789'\''|json -b1
json: error: <stdin>:1:40: lex error: invalid raw string literal
json: error: <stdin>:1:40: 56789abcdef()01234567)0123456789
json: error: <stdin>:1:40:                                 ^
command failed: echo -n '\''r"0123456789abcdef()01234567)0123456789'\''|json -b1
$ echo -n '\''r"0123456789abcdef()01234567)0123456789a'\''|json -b1
json: error: <stdin>:1:41: lex error: invalid raw string literal
json: error: <stdin>:1:41: 6789abcdef()01234567)0123456789a
json: error: <stdin>:1:41:                                 ^
command failed: echo -n '\''r"0123456789abcdef()01234567)0123456789a'\''|json -b1
$ echo -n '\''r"0123456789abcdef()01234567)0123456789ab'\''|json -b1
json: error: <stdin>:1:42: lex error: invalid raw string literal
json: error: <stdin>:1:42: 789abcdef()01234567)0123456789ab
json: error: <stdin>:1:42:                                 ^
command failed: echo -n '\''r"0123456789abcdef()01234567)0123456789ab'\''|json -b1
$ echo -n '\''r"0123456789abcdef()01234567)0123456789abc'\''|json -b1
json: error: <stdin>:1:43: lex error: invalid raw string literal
json: error: <stdin>:1:43: 89abcdef()01234567)0123456789abc
json: error: <stdin>:1:43:                                 ^
command failed: echo -n '\''r"0123456789abcdef()01234567)0123456789abc'\''|json -b1
$ echo -n '\''r"0123456789abcdef()01234567)0123456789abcd'\''|json -b1
json: error: <stdin>:1:44: lex error: invalid raw string literal
json: error: <stdin>:1:44: 9abcdef()01234567)0123456789abcd
json: error: <stdin>:1:44:                                 ^
command failed: echo -n '\''r"0123456789abcdef()01234567)0123456789abcd'\''|json -b1
$ echo -n '\''r"0123456789abcdef()01234567)0123456789abcde'\''|json -b1
json: error: <stdin>:1:45: lex error: invalid raw string literal
json: error: <stdin>:1:45: abcdef()01234567)0123456789abcde
json: error: <stdin>:1:45:                                 ^
command failed: echo -n '\''r"0123456789abcdef()01234567)0123456789abcde'\''|json -b1
$ echo -n '\''r"0123456789abcdef()01234567)0123456789abcdef'\''|json -b1
json: error: <stdin>:1:46: lex error: invalid raw string literal
json: error: <stdin>:1:46: bcdef()01234567)0123456789abcdef
json: error: <stdin>:1:46:                                 ^
command failed: echo -n '\''r"0123456789abcdef()01234567)0123456789abcdef'\''|json -b1
$ echo -n '\''r"0123456789abcdef()01234567)0123456789abcdef"'\''|json -b1
r"0123456789abcdef()01234567)0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()012345678'\''|json -b1
json: error: <stdin>:1:30: lex error: invalid raw string literal
json: error: <stdin>:1:30: r"0123456789abcdef()012345678
json: error: <stdin>:1:30:                              ^
command failed: echo -n '\''r"0123456789abcdef()012345678'\''|json -b1
$ echo -n '\''r"0123456789abcdef()012345678)'\''|json -b1
json: error: <stdin>:1:31: lex error: invalid raw string literal
json: error: <stdin>:1:31: r"0123456789abcdef()012345678)
json: error: <stdin>:1:31:                               ^
command failed: echo -n '\''r"0123456789abcdef()012345678)'\''|json -b1
$ echo -n '\''r"0123456789abcdef()012345678)0'\''|json -b1
json: error: <stdin>:1:32: lex error: invalid raw string literal
json: error: <stdin>:1:32: r"0123456789abcdef()012345678)0
json: error: <stdin>:1:32:                                ^
command failed: echo -n '\''r"0123456789abcdef()012345678)0'\''|json -b1
$ echo -n '\''r"0123456789abcdef()012345678)01'\''|json -b1
json: error: <stdin>:1:33: lex error: invalid raw string literal
json: error: <stdin>:1:33: r"0123456789abcdef()012345678)01
json: error: <stdin>:1:33:                                 ^
command failed: echo -n '\''r"0123456789abcdef()012345678)01'\''|json -b1
$ echo -n '\''r"0123456789abcdef()012345678)012'\''|json -b1
json: error: <stdin>:1:34: lex error: invalid raw string literal
json: error: <stdin>:1:34: "0123456789abcdef()012345678)012
json: error: <stdin>:1:34:                                 ^
command failed: echo -n '\''r"0123456789abcdef()012345678)012'\''|json -b1
$ echo -n '\''r"0123456789abcdef()012345678)0123'\''|json -b1
json: error: <stdin>:1:35: lex error: invalid raw string literal
json: error: <stdin>:1:35: 0123456789abcdef()012345678)0123
json: error: <stdin>:1:35:                                 ^
command failed: echo -n '\''r"0123456789abcdef()012345678)0123'\''|json -b1
$ echo -n '\''r"0123456789abcdef()012345678)01234'\''|json -b1
json: error: <stdin>:1:36: lex error: invalid raw string literal
json: error: <stdin>:1:36: 123456789abcdef()012345678)01234
json: error: <stdin>:1:36:                                 ^
command failed: echo -n '\''r"0123456789abcdef()012345678)01234'\''|json -b1
$ echo -n '\''r"0123456789abcdef()012345678)012345'\''|json -b1
json: error: <stdin>:1:37: lex error: invalid raw string literal
json: error: <stdin>:1:37: 23456789abcdef()012345678)012345
json: error: <stdin>:1:37:                                 ^
command failed: echo -n '\''r"0123456789abcdef()012345678)012345'\''|json -b1
$ echo -n '\''r"0123456789abcdef()012345678)0123456'\''|json -b1
json: error: <stdin>:1:38: lex error: invalid raw string literal
json: error: <stdin>:1:38: 3456789abcdef()012345678)0123456
json: error: <stdin>:1:38:                                 ^
command failed: echo -n '\''r"0123456789abcdef()012345678)0123456'\''|json -b1
$ echo -n '\''r"0123456789abcdef()012345678)01234567'\''|json -b1
json: error: <stdin>:1:39: lex error: invalid raw string literal
json: error: <stdin>:1:39: 456789abcdef()012345678)01234567
json: error: <stdin>:1:39:                                 ^
command failed: echo -n '\''r"0123456789abcdef()012345678)01234567'\''|json -b1
$ echo -n '\''r"0123456789abcdef()012345678)012345678'\''|json -b1
json: error: <stdin>:1:40: lex error: invalid raw string literal
json: error: <stdin>:1:40: 56789abcdef()012345678)012345678
json: error: <stdin>:1:40:                                 ^
command failed: echo -n '\''r"0123456789abcdef()012345678)012345678'\''|json -b1
$ echo -n '\''r"0123456789abcdef()012345678)0123456789'\''|json -b1
json: error: <stdin>:1:41: lex error: invalid raw string literal
json: error: <stdin>:1:41: 6789abcdef()012345678)0123456789
json: error: <stdin>:1:41:                                 ^
command failed: echo -n '\''r"0123456789abcdef()012345678)0123456789'\''|json -b1
$ echo -n '\''r"0123456789abcdef()012345678)0123456789a'\''|json -b1
json: error: <stdin>:1:42: lex error: invalid raw string literal
json: error: <stdin>:1:42: 789abcdef()012345678)0123456789a
json: error: <stdin>:1:42:                                 ^
command failed: echo -n '\''r"0123456789abcdef()012345678)0123456789a'\''|json -b1
$ echo -n '\''r"0123456789abcdef()012345678)0123456789ab'\''|json -b1
json: error: <stdin>:1:43: lex error: invalid raw string literal
json: error: <stdin>:1:43: 89abcdef()012345678)0123456789ab
json: error: <stdin>:1:43:                                 ^
command failed: echo -n '\''r"0123456789abcdef()012345678)0123456789ab'\''|json -b1
$ echo -n '\''r"0123456789abcdef()012345678)0123456789abc'\''|json -b1
json: error: <stdin>:1:44: lex error: invalid raw string literal
json: error: <stdin>:1:44: 9abcdef()012345678)0123456789abc
json: error: <stdin>:1:44:                                 ^
command failed: echo -n '\''r"0123456789abcdef()012345678)0123456789abc'\''|json -b1
$ echo -n '\''r"0123456789abcdef()012345678)0123456789abcd'\''|json -b1
json: error: <stdin>:1:45: lex error: invalid raw string literal
json: error: <stdin>:1:45: abcdef()012345678)0123456789abcd
json: error: <stdin>:1:45:                                 ^
command failed: echo -n '\''r"0123456789abcdef()012345678)0123456789abcd'\''|json -b1
$ echo -n '\''r"0123456789abcdef()012345678)0123456789abcde'\''|json -b1
json: error: <stdin>:1:46: lex error: invalid raw string literal
json: error: <stdin>:1:46: bcdef()012345678)0123456789abcde
json: error: <stdin>:1:46:                                 ^
command failed: echo -n '\''r"0123456789abcdef()012345678)0123456789abcde'\''|json -b1
$ echo -n '\''r"0123456789abcdef()012345678)0123456789abcdef'\''|json -b1
json: error: <stdin>:1:47: lex error: invalid raw string literal
json: error: <stdin>:1:47: cdef()012345678)0123456789abcdef
json: error: <stdin>:1:47:                                 ^
command failed: echo -n '\''r"0123456789abcdef()012345678)0123456789abcdef'\''|json -b1
$ echo -n '\''r"0123456789abcdef()012345678)0123456789abcdef"'\''|json -b1
r"0123456789abcdef()012345678)0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()0123456789'\''|json -b1
json: error: <stdin>:1:31: lex error: invalid raw string literal
json: error: <stdin>:1:31: r"0123456789abcdef()0123456789
json: error: <stdin>:1:31:                               ^
command failed: echo -n '\''r"0123456789abcdef()0123456789'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789)'\''|json -b1
json: error: <stdin>:1:32: lex error: invalid raw string literal
json: error: <stdin>:1:32: r"0123456789abcdef()0123456789)
json: error: <stdin>:1:32:                                ^
command failed: echo -n '\''r"0123456789abcdef()0123456789)'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789)0'\''|json -b1
json: error: <stdin>:1:33: lex error: invalid raw string literal
json: error: <stdin>:1:33: r"0123456789abcdef()0123456789)0
json: error: <stdin>:1:33:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789)0'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789)01'\''|json -b1
json: error: <stdin>:1:34: lex error: invalid raw string literal
json: error: <stdin>:1:34: "0123456789abcdef()0123456789)01
json: error: <stdin>:1:34:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789)01'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789)012'\''|json -b1
json: error: <stdin>:1:35: lex error: invalid raw string literal
json: error: <stdin>:1:35: 0123456789abcdef()0123456789)012
json: error: <stdin>:1:35:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789)012'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789)0123'\''|json -b1
json: error: <stdin>:1:36: lex error: invalid raw string literal
json: error: <stdin>:1:36: 123456789abcdef()0123456789)0123
json: error: <stdin>:1:36:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789)0123'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789)01234'\''|json -b1
json: error: <stdin>:1:37: lex error: invalid raw string literal
json: error: <stdin>:1:37: 23456789abcdef()0123456789)01234
json: error: <stdin>:1:37:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789)01234'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789)012345'\''|json -b1
json: error: <stdin>:1:38: lex error: invalid raw string literal
json: error: <stdin>:1:38: 3456789abcdef()0123456789)012345
json: error: <stdin>:1:38:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789)012345'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789)0123456'\''|json -b1
json: error: <stdin>:1:39: lex error: invalid raw string literal
json: error: <stdin>:1:39: 456789abcdef()0123456789)0123456
json: error: <stdin>:1:39:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789)0123456'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789)01234567'\''|json -b1
json: error: <stdin>:1:40: lex error: invalid raw string literal
json: error: <stdin>:1:40: 56789abcdef()0123456789)01234567
json: error: <stdin>:1:40:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789)01234567'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789)012345678'\''|json -b1
json: error: <stdin>:1:41: lex error: invalid raw string literal
json: error: <stdin>:1:41: 6789abcdef()0123456789)012345678
json: error: <stdin>:1:41:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789)012345678'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789)0123456789'\''|json -b1
json: error: <stdin>:1:42: lex error: invalid raw string literal
json: error: <stdin>:1:42: 789abcdef()0123456789)0123456789
json: error: <stdin>:1:42:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789)0123456789'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789)0123456789a'\''|json -b1
json: error: <stdin>:1:43: lex error: invalid raw string literal
json: error: <stdin>:1:43: 89abcdef()0123456789)0123456789a
json: error: <stdin>:1:43:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789)0123456789a'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789)0123456789ab'\''|json -b1
json: error: <stdin>:1:44: lex error: invalid raw string literal
json: error: <stdin>:1:44: 9abcdef()0123456789)0123456789ab
json: error: <stdin>:1:44:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789)0123456789ab'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789)0123456789abc'\''|json -b1
json: error: <stdin>:1:45: lex error: invalid raw string literal
json: error: <stdin>:1:45: abcdef()0123456789)0123456789abc
json: error: <stdin>:1:45:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789)0123456789abc'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789)0123456789abcd'\''|json -b1
json: error: <stdin>:1:46: lex error: invalid raw string literal
json: error: <stdin>:1:46: bcdef()0123456789)0123456789abcd
json: error: <stdin>:1:46:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789)0123456789abcd'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789)0123456789abcde'\''|json -b1
json: error: <stdin>:1:47: lex error: invalid raw string literal
json: error: <stdin>:1:47: cdef()0123456789)0123456789abcde
json: error: <stdin>:1:47:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789)0123456789abcde'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789)0123456789abcdef'\''|json -b1
json: error: <stdin>:1:48: lex error: invalid raw string literal
json: error: <stdin>:1:48: def()0123456789)0123456789abcdef
json: error: <stdin>:1:48:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789)0123456789abcdef'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789)0123456789abcdef"'\''|json -b1
r"0123456789abcdef()0123456789)0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()0123456789a'\''|json -b1
json: error: <stdin>:1:32: lex error: invalid raw string literal
json: error: <stdin>:1:32: r"0123456789abcdef()0123456789a
json: error: <stdin>:1:32:                                ^
command failed: echo -n '\''r"0123456789abcdef()0123456789a'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789a)'\''|json -b1
json: error: <stdin>:1:33: lex error: invalid raw string literal
json: error: <stdin>:1:33: r"0123456789abcdef()0123456789a)
json: error: <stdin>:1:33:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789a)'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789a)0'\''|json -b1
json: error: <stdin>:1:34: lex error: invalid raw string literal
json: error: <stdin>:1:34: "0123456789abcdef()0123456789a)0
json: error: <stdin>:1:34:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789a)0'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789a)01'\''|json -b1
json: error: <stdin>:1:35: lex error: invalid raw string literal
json: error: <stdin>:1:35: 0123456789abcdef()0123456789a)01
json: error: <stdin>:1:35:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789a)01'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789a)012'\''|json -b1
json: error: <stdin>:1:36: lex error: invalid raw string literal
json: error: <stdin>:1:36: 123456789abcdef()0123456789a)012
json: error: <stdin>:1:36:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789a)012'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789a)0123'\''|json -b1
json: error: <stdin>:1:37: lex error: invalid raw string literal
json: error: <stdin>:1:37: 23456789abcdef()0123456789a)0123
json: error: <stdin>:1:37:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789a)0123'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789a)01234'\''|json -b1
json: error: <stdin>:1:38: lex error: invalid raw string literal
json: error: <stdin>:1:38: 3456789abcdef()0123456789a)01234
json: error: <stdin>:1:38:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789a)01234'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789a)012345'\''|json -b1
json: error: <stdin>:1:39: lex error: invalid raw string literal
json: error: <stdin>:1:39: 456789abcdef()0123456789a)012345
json: error: <stdin>:1:39:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789a)012345'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789a)0123456'\''|json -b1
json: error: <stdin>:1:40: lex error: invalid raw string literal
json: error: <stdin>:1:40: 56789abcdef()0123456789a)0123456
json: error: <stdin>:1:40:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789a)0123456'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789a)01234567'\''|json -b1
json: error: <stdin>:1:41: lex error: invalid raw string literal
json: error: <stdin>:1:41: 6789abcdef()0123456789a)01234567
json: error: <stdin>:1:41:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789a)01234567'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789a)012345678'\''|json -b1
json: error: <stdin>:1:42: lex error: invalid raw string literal
json: error: <stdin>:1:42: 789abcdef()0123456789a)012345678
json: error: <stdin>:1:42:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789a)012345678'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789a)0123456789'\''|json -b1
json: error: <stdin>:1:43: lex error: invalid raw string literal
json: error: <stdin>:1:43: 89abcdef()0123456789a)0123456789
json: error: <stdin>:1:43:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789a)0123456789'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789a)0123456789a'\''|json -b1
json: error: <stdin>:1:44: lex error: invalid raw string literal
json: error: <stdin>:1:44: 9abcdef()0123456789a)0123456789a
json: error: <stdin>:1:44:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789a)0123456789a'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789a)0123456789ab'\''|json -b1
json: error: <stdin>:1:45: lex error: invalid raw string literal
json: error: <stdin>:1:45: abcdef()0123456789a)0123456789ab
json: error: <stdin>:1:45:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789a)0123456789ab'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789a)0123456789abc'\''|json -b1
json: error: <stdin>:1:46: lex error: invalid raw string literal
json: error: <stdin>:1:46: bcdef()0123456789a)0123456789abc
json: error: <stdin>:1:46:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789a)0123456789abc'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789a)0123456789abcd'\''|json -b1
json: error: <stdin>:1:47: lex error: invalid raw string literal
json: error: <stdin>:1:47: cdef()0123456789a)0123456789abcd
json: error: <stdin>:1:47:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789a)0123456789abcd'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789a)0123456789abcde'\''|json -b1
json: error: <stdin>:1:48: lex error: invalid raw string literal
json: error: <stdin>:1:48: def()0123456789a)0123456789abcde
json: error: <stdin>:1:48:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789a)0123456789abcde'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789a)0123456789abcdef'\''|json -b1
json: error: <stdin>:1:49: lex error: invalid raw string literal
json: error: <stdin>:1:49: ef()0123456789a)0123456789abcdef
json: error: <stdin>:1:49:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789a)0123456789abcdef'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789a)0123456789abcdef"'\''|json -b1
r"0123456789abcdef()0123456789a)0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()0123456789ab'\''|json -b1
json: error: <stdin>:1:33: lex error: invalid raw string literal
json: error: <stdin>:1:33: r"0123456789abcdef()0123456789ab
json: error: <stdin>:1:33:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789ab'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789ab)'\''|json -b1
json: error: <stdin>:1:34: lex error: invalid raw string literal
json: error: <stdin>:1:34: "0123456789abcdef()0123456789ab)
json: error: <stdin>:1:34:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789ab)'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789ab)0'\''|json -b1
json: error: <stdin>:1:35: lex error: invalid raw string literal
json: error: <stdin>:1:35: 0123456789abcdef()0123456789ab)0
json: error: <stdin>:1:35:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789ab)0'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789ab)01'\''|json -b1
json: error: <stdin>:1:36: lex error: invalid raw string literal
json: error: <stdin>:1:36: 123456789abcdef()0123456789ab)01
json: error: <stdin>:1:36:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789ab)01'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789ab)012'\''|json -b1
json: error: <stdin>:1:37: lex error: invalid raw string literal
json: error: <stdin>:1:37: 23456789abcdef()0123456789ab)012
json: error: <stdin>:1:37:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789ab)012'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789ab)0123'\''|json -b1
json: error: <stdin>:1:38: lex error: invalid raw string literal
json: error: <stdin>:1:38: 3456789abcdef()0123456789ab)0123
json: error: <stdin>:1:38:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789ab)0123'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789ab)01234'\''|json -b1
json: error: <stdin>:1:39: lex error: invalid raw string literal
json: error: <stdin>:1:39: 456789abcdef()0123456789ab)01234
json: error: <stdin>:1:39:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789ab)01234'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789ab)012345'\''|json -b1
json: error: <stdin>:1:40: lex error: invalid raw string literal
json: error: <stdin>:1:40: 56789abcdef()0123456789ab)012345
json: error: <stdin>:1:40:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789ab)012345'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789ab)0123456'\''|json -b1
json: error: <stdin>:1:41: lex error: invalid raw string literal
json: error: <stdin>:1:41: 6789abcdef()0123456789ab)0123456
json: error: <stdin>:1:41:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789ab)0123456'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789ab)01234567'\''|json -b1
json: error: <stdin>:1:42: lex error: invalid raw string literal
json: error: <stdin>:1:42: 789abcdef()0123456789ab)01234567
json: error: <stdin>:1:42:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789ab)01234567'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789ab)012345678'\''|json -b1
json: error: <stdin>:1:43: lex error: invalid raw string literal
json: error: <stdin>:1:43: 89abcdef()0123456789ab)012345678
json: error: <stdin>:1:43:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789ab)012345678'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789ab)0123456789'\''|json -b1
json: error: <stdin>:1:44: lex error: invalid raw string literal
json: error: <stdin>:1:44: 9abcdef()0123456789ab)0123456789
json: error: <stdin>:1:44:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789ab)0123456789'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789ab)0123456789a'\''|json -b1
json: error: <stdin>:1:45: lex error: invalid raw string literal
json: error: <stdin>:1:45: abcdef()0123456789ab)0123456789a
json: error: <stdin>:1:45:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789ab)0123456789a'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789ab)0123456789ab'\''|json -b1
json: error: <stdin>:1:46: lex error: invalid raw string literal
json: error: <stdin>:1:46: bcdef()0123456789ab)0123456789ab
json: error: <stdin>:1:46:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789ab)0123456789ab'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789ab)0123456789abc'\''|json -b1
json: error: <stdin>:1:47: lex error: invalid raw string literal
json: error: <stdin>:1:47: cdef()0123456789ab)0123456789abc
json: error: <stdin>:1:47:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789ab)0123456789abc'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789ab)0123456789abcd'\''|json -b1
json: error: <stdin>:1:48: lex error: invalid raw string literal
json: error: <stdin>:1:48: def()0123456789ab)0123456789abcd
json: error: <stdin>:1:48:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789ab)0123456789abcd'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789ab)0123456789abcde'\''|json -b1
json: error: <stdin>:1:49: lex error: invalid raw string literal
json: error: <stdin>:1:49: ef()0123456789ab)0123456789abcde
json: error: <stdin>:1:49:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789ab)0123456789abcde'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789ab)0123456789abcdef'\''|json -b1
json: error: <stdin>:1:50: lex error: invalid raw string literal
json: error: <stdin>:1:50: f()0123456789ab)0123456789abcdef
json: error: <stdin>:1:50:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789ab)0123456789abcdef'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789ab)0123456789abcdef"'\''|json -b1
r"0123456789abcdef()0123456789ab)0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()0123456789abc'\''|json -b1
json: error: <stdin>:1:34: lex error: invalid raw string literal
json: error: <stdin>:1:34: "0123456789abcdef()0123456789abc
json: error: <stdin>:1:34:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abc'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abc)'\''|json -b1
json: error: <stdin>:1:35: lex error: invalid raw string literal
json: error: <stdin>:1:35: 0123456789abcdef()0123456789abc)
json: error: <stdin>:1:35:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abc)'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abc)0'\''|json -b1
json: error: <stdin>:1:36: lex error: invalid raw string literal
json: error: <stdin>:1:36: 123456789abcdef()0123456789abc)0
json: error: <stdin>:1:36:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abc)0'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abc)01'\''|json -b1
json: error: <stdin>:1:37: lex error: invalid raw string literal
json: error: <stdin>:1:37: 23456789abcdef()0123456789abc)01
json: error: <stdin>:1:37:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abc)01'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abc)012'\''|json -b1
json: error: <stdin>:1:38: lex error: invalid raw string literal
json: error: <stdin>:1:38: 3456789abcdef()0123456789abc)012
json: error: <stdin>:1:38:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abc)012'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abc)0123'\''|json -b1
json: error: <stdin>:1:39: lex error: invalid raw string literal
json: error: <stdin>:1:39: 456789abcdef()0123456789abc)0123
json: error: <stdin>:1:39:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abc)0123'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abc)01234'\''|json -b1
json: error: <stdin>:1:40: lex error: invalid raw string literal
json: error: <stdin>:1:40: 56789abcdef()0123456789abc)01234
json: error: <stdin>:1:40:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abc)01234'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abc)012345'\''|json -b1
json: error: <stdin>:1:41: lex error: invalid raw string literal
json: error: <stdin>:1:41: 6789abcdef()0123456789abc)012345
json: error: <stdin>:1:41:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abc)012345'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abc)0123456'\''|json -b1
json: error: <stdin>:1:42: lex error: invalid raw string literal
json: error: <stdin>:1:42: 789abcdef()0123456789abc)0123456
json: error: <stdin>:1:42:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abc)0123456'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abc)01234567'\''|json -b1
json: error: <stdin>:1:43: lex error: invalid raw string literal
json: error: <stdin>:1:43: 89abcdef()0123456789abc)01234567
json: error: <stdin>:1:43:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abc)01234567'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abc)012345678'\''|json -b1
json: error: <stdin>:1:44: lex error: invalid raw string literal
json: error: <stdin>:1:44: 9abcdef()0123456789abc)012345678
json: error: <stdin>:1:44:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abc)012345678'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abc)0123456789'\''|json -b1
json: error: <stdin>:1:45: lex error: invalid raw string literal
json: error: <stdin>:1:45: abcdef()0123456789abc)0123456789
json: error: <stdin>:1:45:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abc)0123456789'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abc)0123456789a'\''|json -b1
json: error: <stdin>:1:46: lex error: invalid raw string literal
json: error: <stdin>:1:46: bcdef()0123456789abc)0123456789a
json: error: <stdin>:1:46:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abc)0123456789a'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abc)0123456789ab'\''|json -b1
json: error: <stdin>:1:47: lex error: invalid raw string literal
json: error: <stdin>:1:47: cdef()0123456789abc)0123456789ab
json: error: <stdin>:1:47:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abc)0123456789ab'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abc)0123456789abc'\''|json -b1
json: error: <stdin>:1:48: lex error: invalid raw string literal
json: error: <stdin>:1:48: def()0123456789abc)0123456789abc
json: error: <stdin>:1:48:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abc)0123456789abc'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abc)0123456789abcd'\''|json -b1
json: error: <stdin>:1:49: lex error: invalid raw string literal
json: error: <stdin>:1:49: ef()0123456789abc)0123456789abcd
json: error: <stdin>:1:49:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abc)0123456789abcd'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abc)0123456789abcde'\''|json -b1
json: error: <stdin>:1:50: lex error: invalid raw string literal
json: error: <stdin>:1:50: f()0123456789abc)0123456789abcde
json: error: <stdin>:1:50:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abc)0123456789abcde'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abc)0123456789abcdef'\''|json -b1
json: error: <stdin>:1:51: lex error: invalid raw string literal
json: error: <stdin>:1:51: ()0123456789abc)0123456789abcdef
json: error: <stdin>:1:51:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abc)0123456789abcdef'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abc)0123456789abcdef"'\''|json -b1
r"0123456789abcdef()0123456789abc)0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()0123456789abcd'\''|json -b1
json: error: <stdin>:1:35: lex error: invalid raw string literal
json: error: <stdin>:1:35: 0123456789abcdef()0123456789abcd
json: error: <stdin>:1:35:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abcd'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abcd)'\''|json -b1
json: error: <stdin>:1:36: lex error: invalid raw string literal
json: error: <stdin>:1:36: 123456789abcdef()0123456789abcd)
json: error: <stdin>:1:36:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abcd)'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abcd)0'\''|json -b1
json: error: <stdin>:1:37: lex error: invalid raw string literal
json: error: <stdin>:1:37: 23456789abcdef()0123456789abcd)0
json: error: <stdin>:1:37:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abcd)0'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abcd)01'\''|json -b1
json: error: <stdin>:1:38: lex error: invalid raw string literal
json: error: <stdin>:1:38: 3456789abcdef()0123456789abcd)01
json: error: <stdin>:1:38:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abcd)01'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abcd)012'\''|json -b1
json: error: <stdin>:1:39: lex error: invalid raw string literal
json: error: <stdin>:1:39: 456789abcdef()0123456789abcd)012
json: error: <stdin>:1:39:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abcd)012'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abcd)0123'\''|json -b1
json: error: <stdin>:1:40: lex error: invalid raw string literal
json: error: <stdin>:1:40: 56789abcdef()0123456789abcd)0123
json: error: <stdin>:1:40:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abcd)0123'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abcd)01234'\''|json -b1
json: error: <stdin>:1:41: lex error: invalid raw string literal
json: error: <stdin>:1:41: 6789abcdef()0123456789abcd)01234
json: error: <stdin>:1:41:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abcd)01234'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abcd)012345'\''|json -b1
json: error: <stdin>:1:42: lex error: invalid raw string literal
json: error: <stdin>:1:42: 789abcdef()0123456789abcd)012345
json: error: <stdin>:1:42:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abcd)012345'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abcd)0123456'\''|json -b1
json: error: <stdin>:1:43: lex error: invalid raw string literal
json: error: <stdin>:1:43: 89abcdef()0123456789abcd)0123456
json: error: <stdin>:1:43:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abcd)0123456'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abcd)01234567'\''|json -b1
json: error: <stdin>:1:44: lex error: invalid raw string literal
json: error: <stdin>:1:44: 9abcdef()0123456789abcd)01234567
json: error: <stdin>:1:44:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abcd)01234567'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abcd)012345678'\''|json -b1
json: error: <stdin>:1:45: lex error: invalid raw string literal
json: error: <stdin>:1:45: abcdef()0123456789abcd)012345678
json: error: <stdin>:1:45:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abcd)012345678'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abcd)0123456789'\''|json -b1
json: error: <stdin>:1:46: lex error: invalid raw string literal
json: error: <stdin>:1:46: bcdef()0123456789abcd)0123456789
json: error: <stdin>:1:46:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abcd)0123456789'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abcd)0123456789a'\''|json -b1
json: error: <stdin>:1:47: lex error: invalid raw string literal
json: error: <stdin>:1:47: cdef()0123456789abcd)0123456789a
json: error: <stdin>:1:47:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abcd)0123456789a'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abcd)0123456789ab'\''|json -b1
json: error: <stdin>:1:48: lex error: invalid raw string literal
json: error: <stdin>:1:48: def()0123456789abcd)0123456789ab
json: error: <stdin>:1:48:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abcd)0123456789ab'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abcd)0123456789abc'\''|json -b1
json: error: <stdin>:1:49: lex error: invalid raw string literal
json: error: <stdin>:1:49: ef()0123456789abcd)0123456789abc
json: error: <stdin>:1:49:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abcd)0123456789abc'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abcd)0123456789abcd'\''|json -b1
json: error: <stdin>:1:50: lex error: invalid raw string literal
json: error: <stdin>:1:50: f()0123456789abcd)0123456789abcd
json: error: <stdin>:1:50:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abcd)0123456789abcd'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abcd)0123456789abcde'\''|json -b1
json: error: <stdin>:1:51: lex error: invalid raw string literal
json: error: <stdin>:1:51: ()0123456789abcd)0123456789abcde
json: error: <stdin>:1:51:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abcd)0123456789abcde'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abcd)0123456789abcdef'\''|json -b1
json: error: <stdin>:1:52: lex error: invalid raw string literal
json: error: <stdin>:1:52: )0123456789abcd)0123456789abcdef
json: error: <stdin>:1:52:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abcd)0123456789abcdef'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abcd)0123456789abcdef"'\''|json -b1
r"0123456789abcdef()0123456789abcd)0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()0123456789abcde'\''|json -b1
json: error: <stdin>:1:36: lex error: invalid raw string literal
json: error: <stdin>:1:36: 123456789abcdef()0123456789abcde
json: error: <stdin>:1:36:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abcde'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abcde)'\''|json -b1
json: error: <stdin>:1:37: lex error: invalid raw string literal
json: error: <stdin>:1:37: 23456789abcdef()0123456789abcde)
json: error: <stdin>:1:37:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abcde)'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abcde)0'\''|json -b1
json: error: <stdin>:1:38: lex error: invalid raw string literal
json: error: <stdin>:1:38: 3456789abcdef()0123456789abcde)0
json: error: <stdin>:1:38:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abcde)0'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abcde)01'\''|json -b1
json: error: <stdin>:1:39: lex error: invalid raw string literal
json: error: <stdin>:1:39: 456789abcdef()0123456789abcde)01
json: error: <stdin>:1:39:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abcde)01'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abcde)012'\''|json -b1
json: error: <stdin>:1:40: lex error: invalid raw string literal
json: error: <stdin>:1:40: 56789abcdef()0123456789abcde)012
json: error: <stdin>:1:40:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abcde)012'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abcde)0123'\''|json -b1
json: error: <stdin>:1:41: lex error: invalid raw string literal
json: error: <stdin>:1:41: 6789abcdef()0123456789abcde)0123
json: error: <stdin>:1:41:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abcde)0123'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abcde)01234'\''|json -b1
json: error: <stdin>:1:42: lex error: invalid raw string literal
json: error: <stdin>:1:42: 789abcdef()0123456789abcde)01234
json: error: <stdin>:1:42:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abcde)01234'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abcde)012345'\''|json -b1
json: error: <stdin>:1:43: lex error: invalid raw string literal
json: error: <stdin>:1:43: 89abcdef()0123456789abcde)012345
json: error: <stdin>:1:43:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abcde)012345'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abcde)0123456'\''|json -b1
json: error: <stdin>:1:44: lex error: invalid raw string literal
json: error: <stdin>:1:44: 9abcdef()0123456789abcde)0123456
json: error: <stdin>:1:44:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abcde)0123456'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abcde)01234567'\''|json -b1
json: error: <stdin>:1:45: lex error: invalid raw string literal
json: error: <stdin>:1:45: abcdef()0123456789abcde)01234567
json: error: <stdin>:1:45:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abcde)01234567'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abcde)012345678'\''|json -b1
json: error: <stdin>:1:46: lex error: invalid raw string literal
json: error: <stdin>:1:46: bcdef()0123456789abcde)012345678
json: error: <stdin>:1:46:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abcde)012345678'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abcde)0123456789'\''|json -b1
json: error: <stdin>:1:47: lex error: invalid raw string literal
json: error: <stdin>:1:47: cdef()0123456789abcde)0123456789
json: error: <stdin>:1:47:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abcde)0123456789'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abcde)0123456789a'\''|json -b1
json: error: <stdin>:1:48: lex error: invalid raw string literal
json: error: <stdin>:1:48: def()0123456789abcde)0123456789a
json: error: <stdin>:1:48:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abcde)0123456789a'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abcde)0123456789ab'\''|json -b1
json: error: <stdin>:1:49: lex error: invalid raw string literal
json: error: <stdin>:1:49: ef()0123456789abcde)0123456789ab
json: error: <stdin>:1:49:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abcde)0123456789ab'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abcde)0123456789abc'\''|json -b1
json: error: <stdin>:1:50: lex error: invalid raw string literal
json: error: <stdin>:1:50: f()0123456789abcde)0123456789abc
json: error: <stdin>:1:50:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abcde)0123456789abc'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abcde)0123456789abcd'\''|json -b1
json: error: <stdin>:1:51: lex error: invalid raw string literal
json: error: <stdin>:1:51: ()0123456789abcde)0123456789abcd
json: error: <stdin>:1:51:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abcde)0123456789abcd'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abcde)0123456789abcde'\''|json -b1
json: error: <stdin>:1:52: lex error: invalid raw string literal
json: error: <stdin>:1:52: )0123456789abcde)0123456789abcde
json: error: <stdin>:1:52:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abcde)0123456789abcde'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abcde)0123456789abcdef'\''|json -b1
json: error: <stdin>:1:53: lex error: invalid raw string literal
json: error: <stdin>:1:53: 0123456789abcde)0123456789abcdef
json: error: <stdin>:1:53:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abcde)0123456789abcdef'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abcde)0123456789abcdef"'\''|json -b1
r"0123456789abcdef()0123456789abcde)0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()0123456789abcdef'\''|json -b1
json: error: <stdin>:1:37: lex error: invalid raw string literal
json: error: <stdin>:1:37: 23456789abcdef()0123456789abcdef
json: error: <stdin>:1:37:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abcdef'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abcdef"'\''|json -b1
r"0123456789abcdef()0123456789abcdef"
$ echo -n '\''r"0123456789abcdef()0123456789abcdef)'\''|json -b1
json: error: <stdin>:1:38: lex error: invalid raw string literal
json: error: <stdin>:1:38: 3456789abcdef()0123456789abcdef)
json: error: <stdin>:1:38:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abcdef)'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abcdef)0'\''|json -b1
json: error: <stdin>:1:39: lex error: invalid raw string literal
json: error: <stdin>:1:39: 456789abcdef()0123456789abcdef)0
json: error: <stdin>:1:39:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abcdef)0'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abcdef)01'\''|json -b1
json: error: <stdin>:1:40: lex error: invalid raw string literal
json: error: <stdin>:1:40: 56789abcdef()0123456789abcdef)01
json: error: <stdin>:1:40:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abcdef)01'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abcdef)012'\''|json -b1
json: error: <stdin>:1:41: lex error: invalid raw string literal
json: error: <stdin>:1:41: 6789abcdef()0123456789abcdef)012
json: error: <stdin>:1:41:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abcdef)012'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abcdef)0123'\''|json -b1
json: error: <stdin>:1:42: lex error: invalid raw string literal
json: error: <stdin>:1:42: 789abcdef()0123456789abcdef)0123
json: error: <stdin>:1:42:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abcdef)0123'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abcdef)01234'\''|json -b1
json: error: <stdin>:1:43: lex error: invalid raw string literal
json: error: <stdin>:1:43: 89abcdef()0123456789abcdef)01234
json: error: <stdin>:1:43:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abcdef)01234'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abcdef)012345'\''|json -b1
json: error: <stdin>:1:44: lex error: invalid raw string literal
json: error: <stdin>:1:44: 9abcdef()0123456789abcdef)012345
json: error: <stdin>:1:44:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abcdef)012345'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abcdef)0123456'\''|json -b1
json: error: <stdin>:1:45: lex error: invalid raw string literal
json: error: <stdin>:1:45: abcdef()0123456789abcdef)0123456
json: error: <stdin>:1:45:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abcdef)0123456'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abcdef)01234567'\''|json -b1
json: error: <stdin>:1:46: lex error: invalid raw string literal
json: error: <stdin>:1:46: bcdef()0123456789abcdef)01234567
json: error: <stdin>:1:46:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abcdef)01234567'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abcdef)012345678'\''|json -b1
json: error: <stdin>:1:47: lex error: invalid raw string literal
json: error: <stdin>:1:47: cdef()0123456789abcdef)012345678
json: error: <stdin>:1:47:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abcdef)012345678'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abcdef)0123456789'\''|json -b1
json: error: <stdin>:1:48: lex error: invalid raw string literal
json: error: <stdin>:1:48: def()0123456789abcdef)0123456789
json: error: <stdin>:1:48:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abcdef)0123456789'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abcdef)0123456789a'\''|json -b1
json: error: <stdin>:1:49: lex error: invalid raw string literal
json: error: <stdin>:1:49: ef()0123456789abcdef)0123456789a
json: error: <stdin>:1:49:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abcdef)0123456789a'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abcdef)0123456789ab'\''|json -b1
json: error: <stdin>:1:50: lex error: invalid raw string literal
json: error: <stdin>:1:50: f()0123456789abcdef)0123456789ab
json: error: <stdin>:1:50:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abcdef)0123456789ab'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abcdef)0123456789abc'\''|json -b1
json: error: <stdin>:1:51: lex error: invalid raw string literal
json: error: <stdin>:1:51: ()0123456789abcdef)0123456789abc
json: error: <stdin>:1:51:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abcdef)0123456789abc'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abcdef)0123456789abcd'\''|json -b1
json: error: <stdin>:1:52: lex error: invalid raw string literal
json: error: <stdin>:1:52: )0123456789abcdef)0123456789abcd
json: error: <stdin>:1:52:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abcdef)0123456789abcd'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abcdef)0123456789abcde'\''|json -b1
json: error: <stdin>:1:53: lex error: invalid raw string literal
json: error: <stdin>:1:53: 0123456789abcdef)0123456789abcde
json: error: <stdin>:1:53:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abcdef)0123456789abcde'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abcdef)0123456789abcdef'\''|json -b1
json: error: <stdin>:1:54: lex error: invalid raw string literal
json: error: <stdin>:1:54: 123456789abcdef)0123456789abcdef
json: error: <stdin>:1:54:                                 ^
command failed: echo -n '\''r"0123456789abcdef()0123456789abcdef)0123456789abcdef'\''|json -b1
$ echo -n '\''r"0123456789abcdef()0123456789abcdef)0123456789abcdef"'\''|json -b1
r"0123456789abcdef()0123456789abcdef)0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(f'\''|json -b1
json: error: <stdin>:1:21: lex error: invalid raw string literal
json: error: <stdin>:1:21: r"0123456789abcdef(f
json: error: <stdin>:1:21:                     ^
command failed: echo -n '\''r"0123456789abcdef(f'\''|json -b1
$ echo -n '\''r"0123456789abcdef(fo'\''|json -b1
json: error: <stdin>:1:22: lex error: invalid raw string literal
json: error: <stdin>:1:22: r"0123456789abcdef(fo
json: error: <stdin>:1:22:                      ^
command failed: echo -n '\''r"0123456789abcdef(fo'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo'\''|json -b1
json: error: <stdin>:1:23: lex error: invalid raw string literal
json: error: <stdin>:1:23: r"0123456789abcdef(foo
json: error: <stdin>:1:23:                       ^
command failed: echo -n '\''r"0123456789abcdef(foo'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)'\''|json -b1
json: error: <stdin>:1:24: lex error: invalid raw string literal
json: error: <stdin>:1:24: r"0123456789abcdef(foo)
json: error: <stdin>:1:24:                        ^
command failed: echo -n '\''r"0123456789abcdef(foo)'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo))'\''|json -b1
json: error: <stdin>:1:25: lex error: invalid raw string literal
json: error: <stdin>:1:25: r"0123456789abcdef(foo))
json: error: <stdin>:1:25:                         ^
command failed: echo -n '\''r"0123456789abcdef(foo))'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo))0'\''|json -b1
json: error: <stdin>:1:26: lex error: invalid raw string literal
json: error: <stdin>:1:26: r"0123456789abcdef(foo))0
json: error: <stdin>:1:26:                          ^
command failed: echo -n '\''r"0123456789abcdef(foo))0'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo))01'\''|json -b1
json: error: <stdin>:1:27: lex error: invalid raw string literal
json: error: <stdin>:1:27: r"0123456789abcdef(foo))01
json: error: <stdin>:1:27:                           ^
command failed: echo -n '\''r"0123456789abcdef(foo))01'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo))012'\''|json -b1
json: error: <stdin>:1:28: lex error: invalid raw string literal
json: error: <stdin>:1:28: r"0123456789abcdef(foo))012
json: error: <stdin>:1:28:                            ^
command failed: echo -n '\''r"0123456789abcdef(foo))012'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo))0123'\''|json -b1
json: error: <stdin>:1:29: lex error: invalid raw string literal
json: error: <stdin>:1:29: r"0123456789abcdef(foo))0123
json: error: <stdin>:1:29:                             ^
command failed: echo -n '\''r"0123456789abcdef(foo))0123'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo))01234'\''|json -b1
json: error: <stdin>:1:30: lex error: invalid raw string literal
json: error: <stdin>:1:30: r"0123456789abcdef(foo))01234
json: error: <stdin>:1:30:                              ^
command failed: echo -n '\''r"0123456789abcdef(foo))01234'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo))012345'\''|json -b1
json: error: <stdin>:1:31: lex error: invalid raw string literal
json: error: <stdin>:1:31: r"0123456789abcdef(foo))012345
json: error: <stdin>:1:31:                               ^
command failed: echo -n '\''r"0123456789abcdef(foo))012345'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo))0123456'\''|json -b1
json: error: <stdin>:1:32: lex error: invalid raw string literal
json: error: <stdin>:1:32: r"0123456789abcdef(foo))0123456
json: error: <stdin>:1:32:                                ^
command failed: echo -n '\''r"0123456789abcdef(foo))0123456'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo))01234567'\''|json -b1
json: error: <stdin>:1:33: lex error: invalid raw string literal
json: error: <stdin>:1:33: r"0123456789abcdef(foo))01234567
json: error: <stdin>:1:33:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo))01234567'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo))012345678'\''|json -b1
json: error: <stdin>:1:34: lex error: invalid raw string literal
json: error: <stdin>:1:34: "0123456789abcdef(foo))012345678
json: error: <stdin>:1:34:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo))012345678'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo))0123456789'\''|json -b1
json: error: <stdin>:1:35: lex error: invalid raw string literal
json: error: <stdin>:1:35: 0123456789abcdef(foo))0123456789
json: error: <stdin>:1:35:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo))0123456789'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo))0123456789a'\''|json -b1
json: error: <stdin>:1:36: lex error: invalid raw string literal
json: error: <stdin>:1:36: 123456789abcdef(foo))0123456789a
json: error: <stdin>:1:36:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo))0123456789a'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo))0123456789ab'\''|json -b1
json: error: <stdin>:1:37: lex error: invalid raw string literal
json: error: <stdin>:1:37: 23456789abcdef(foo))0123456789ab
json: error: <stdin>:1:37:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo))0123456789ab'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo))0123456789abc'\''|json -b1
json: error: <stdin>:1:38: lex error: invalid raw string literal
json: error: <stdin>:1:38: 3456789abcdef(foo))0123456789abc
json: error: <stdin>:1:38:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo))0123456789abc'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo))0123456789abcd'\''|json -b1
json: error: <stdin>:1:39: lex error: invalid raw string literal
json: error: <stdin>:1:39: 456789abcdef(foo))0123456789abcd
json: error: <stdin>:1:39:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo))0123456789abcd'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo))0123456789abcde'\''|json -b1
json: error: <stdin>:1:40: lex error: invalid raw string literal
json: error: <stdin>:1:40: 56789abcdef(foo))0123456789abcde
json: error: <stdin>:1:40:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo))0123456789abcde'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo))0123456789abcdef'\''|json -b1
json: error: <stdin>:1:41: lex error: invalid raw string literal
json: error: <stdin>:1:41: 6789abcdef(foo))0123456789abcdef
json: error: <stdin>:1:41:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo))0123456789abcdef'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo))0123456789abcdef"'\''|json -b1
r"0123456789abcdef(foo))0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)0'\''|json -b1
json: error: <stdin>:1:25: lex error: invalid raw string literal
json: error: <stdin>:1:25: r"0123456789abcdef(foo)0
json: error: <stdin>:1:25:                         ^
command failed: echo -n '\''r"0123456789abcdef(foo)0'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0)'\''|json -b1
json: error: <stdin>:1:26: lex error: invalid raw string literal
json: error: <stdin>:1:26: r"0123456789abcdef(foo)0)
json: error: <stdin>:1:26:                          ^
command failed: echo -n '\''r"0123456789abcdef(foo)0)'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0)0'\''|json -b1
json: error: <stdin>:1:27: lex error: invalid raw string literal
json: error: <stdin>:1:27: r"0123456789abcdef(foo)0)0
json: error: <stdin>:1:27:                           ^
command failed: echo -n '\''r"0123456789abcdef(foo)0)0'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0)01'\''|json -b1
json: error: <stdin>:1:28: lex error: invalid raw string literal
json: error: <stdin>:1:28: r"0123456789abcdef(foo)0)01
json: error: <stdin>:1:28:                            ^
command failed: echo -n '\''r"0123456789abcdef(foo)0)01'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0)012'\''|json -b1
json: error: <stdin>:1:29: lex error: invalid raw string literal
json: error: <stdin>:1:29: r"0123456789abcdef(foo)0)012
json: error: <stdin>:1:29:                             ^
command failed: echo -n '\''r"0123456789abcdef(foo)0)012'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0)0123'\''|json -b1
json: error: <stdin>:1:30: lex error: invalid raw string literal
json: error: <stdin>:1:30: r"0123456789abcdef(foo)0)0123
json: error: <stdin>:1:30:                              ^
command failed: echo -n '\''r"0123456789abcdef(foo)0)0123'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0)01234'\''|json -b1
json: error: <stdin>:1:31: lex error: invalid raw string literal
json: error: <stdin>:1:31: r"0123456789abcdef(foo)0)01234
json: error: <stdin>:1:31:                               ^
command failed: echo -n '\''r"0123456789abcdef(foo)0)01234'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0)012345'\''|json -b1
json: error: <stdin>:1:32: lex error: invalid raw string literal
json: error: <stdin>:1:32: r"0123456789abcdef(foo)0)012345
json: error: <stdin>:1:32:                                ^
command failed: echo -n '\''r"0123456789abcdef(foo)0)012345'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0)0123456'\''|json -b1
json: error: <stdin>:1:33: lex error: invalid raw string literal
json: error: <stdin>:1:33: r"0123456789abcdef(foo)0)0123456
json: error: <stdin>:1:33:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0)0123456'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0)01234567'\''|json -b1
json: error: <stdin>:1:34: lex error: invalid raw string literal
json: error: <stdin>:1:34: "0123456789abcdef(foo)0)01234567
json: error: <stdin>:1:34:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0)01234567'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0)012345678'\''|json -b1
json: error: <stdin>:1:35: lex error: invalid raw string literal
json: error: <stdin>:1:35: 0123456789abcdef(foo)0)012345678
json: error: <stdin>:1:35:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0)012345678'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0)0123456789'\''|json -b1
json: error: <stdin>:1:36: lex error: invalid raw string literal
json: error: <stdin>:1:36: 123456789abcdef(foo)0)0123456789
json: error: <stdin>:1:36:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0)0123456789'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0)0123456789a'\''|json -b1
json: error: <stdin>:1:37: lex error: invalid raw string literal
json: error: <stdin>:1:37: 23456789abcdef(foo)0)0123456789a
json: error: <stdin>:1:37:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0)0123456789a'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0)0123456789ab'\''|json -b1
json: error: <stdin>:1:38: lex error: invalid raw string literal
json: error: <stdin>:1:38: 3456789abcdef(foo)0)0123456789ab
json: error: <stdin>:1:38:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0)0123456789ab'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0)0123456789abc'\''|json -b1
json: error: <stdin>:1:39: lex error: invalid raw string literal
json: error: <stdin>:1:39: 456789abcdef(foo)0)0123456789abc
json: error: <stdin>:1:39:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0)0123456789abc'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0)0123456789abcd'\''|json -b1
json: error: <stdin>:1:40: lex error: invalid raw string literal
json: error: <stdin>:1:40: 56789abcdef(foo)0)0123456789abcd
json: error: <stdin>:1:40:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0)0123456789abcd'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0)0123456789abcde'\''|json -b1
json: error: <stdin>:1:41: lex error: invalid raw string literal
json: error: <stdin>:1:41: 6789abcdef(foo)0)0123456789abcde
json: error: <stdin>:1:41:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0)0123456789abcde'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0)0123456789abcdef'\''|json -b1
json: error: <stdin>:1:42: lex error: invalid raw string literal
json: error: <stdin>:1:42: 789abcdef(foo)0)0123456789abcdef
json: error: <stdin>:1:42:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0)0123456789abcdef'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0)0123456789abcdef"'\''|json -b1
r"0123456789abcdef(foo)0)0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)01'\''|json -b1
json: error: <stdin>:1:26: lex error: invalid raw string literal
json: error: <stdin>:1:26: r"0123456789abcdef(foo)01
json: error: <stdin>:1:26:                          ^
command failed: echo -n '\''r"0123456789abcdef(foo)01'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)01)'\''|json -b1
json: error: <stdin>:1:27: lex error: invalid raw string literal
json: error: <stdin>:1:27: r"0123456789abcdef(foo)01)
json: error: <stdin>:1:27:                           ^
command failed: echo -n '\''r"0123456789abcdef(foo)01)'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)01)0'\''|json -b1
json: error: <stdin>:1:28: lex error: invalid raw string literal
json: error: <stdin>:1:28: r"0123456789abcdef(foo)01)0
json: error: <stdin>:1:28:                            ^
command failed: echo -n '\''r"0123456789abcdef(foo)01)0'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)01)01'\''|json -b1
json: error: <stdin>:1:29: lex error: invalid raw string literal
json: error: <stdin>:1:29: r"0123456789abcdef(foo)01)01
json: error: <stdin>:1:29:                             ^
command failed: echo -n '\''r"0123456789abcdef(foo)01)01'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)01)012'\''|json -b1
json: error: <stdin>:1:30: lex error: invalid raw string literal
json: error: <stdin>:1:30: r"0123456789abcdef(foo)01)012
json: error: <stdin>:1:30:                              ^
command failed: echo -n '\''r"0123456789abcdef(foo)01)012'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)01)0123'\''|json -b1
json: error: <stdin>:1:31: lex error: invalid raw string literal
json: error: <stdin>:1:31: r"0123456789abcdef(foo)01)0123
json: error: <stdin>:1:31:                               ^
command failed: echo -n '\''r"0123456789abcdef(foo)01)0123'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)01)01234'\''|json -b1
json: error: <stdin>:1:32: lex error: invalid raw string literal
json: error: <stdin>:1:32: r"0123456789abcdef(foo)01)01234
json: error: <stdin>:1:32:                                ^
command failed: echo -n '\''r"0123456789abcdef(foo)01)01234'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)01)012345'\''|json -b1
json: error: <stdin>:1:33: lex error: invalid raw string literal
json: error: <stdin>:1:33: r"0123456789abcdef(foo)01)012345
json: error: <stdin>:1:33:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)01)012345'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)01)0123456'\''|json -b1
json: error: <stdin>:1:34: lex error: invalid raw string literal
json: error: <stdin>:1:34: "0123456789abcdef(foo)01)0123456
json: error: <stdin>:1:34:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)01)0123456'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)01)01234567'\''|json -b1
json: error: <stdin>:1:35: lex error: invalid raw string literal
json: error: <stdin>:1:35: 0123456789abcdef(foo)01)01234567
json: error: <stdin>:1:35:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)01)01234567'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)01)012345678'\''|json -b1
json: error: <stdin>:1:36: lex error: invalid raw string literal
json: error: <stdin>:1:36: 123456789abcdef(foo)01)012345678
json: error: <stdin>:1:36:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)01)012345678'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)01)0123456789'\''|json -b1
json: error: <stdin>:1:37: lex error: invalid raw string literal
json: error: <stdin>:1:37: 23456789abcdef(foo)01)0123456789
json: error: <stdin>:1:37:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)01)0123456789'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)01)0123456789a'\''|json -b1
json: error: <stdin>:1:38: lex error: invalid raw string literal
json: error: <stdin>:1:38: 3456789abcdef(foo)01)0123456789a
json: error: <stdin>:1:38:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)01)0123456789a'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)01)0123456789ab'\''|json -b1
json: error: <stdin>:1:39: lex error: invalid raw string literal
json: error: <stdin>:1:39: 456789abcdef(foo)01)0123456789ab
json: error: <stdin>:1:39:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)01)0123456789ab'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)01)0123456789abc'\''|json -b1
json: error: <stdin>:1:40: lex error: invalid raw string literal
json: error: <stdin>:1:40: 56789abcdef(foo)01)0123456789abc
json: error: <stdin>:1:40:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)01)0123456789abc'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)01)0123456789abcd'\''|json -b1
json: error: <stdin>:1:41: lex error: invalid raw string literal
json: error: <stdin>:1:41: 6789abcdef(foo)01)0123456789abcd
json: error: <stdin>:1:41:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)01)0123456789abcd'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)01)0123456789abcde'\''|json -b1
json: error: <stdin>:1:42: lex error: invalid raw string literal
json: error: <stdin>:1:42: 789abcdef(foo)01)0123456789abcde
json: error: <stdin>:1:42:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)01)0123456789abcde'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)01)0123456789abcdef'\''|json -b1
json: error: <stdin>:1:43: lex error: invalid raw string literal
json: error: <stdin>:1:43: 89abcdef(foo)01)0123456789abcdef
json: error: <stdin>:1:43:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)01)0123456789abcdef'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)01)0123456789abcdef"'\''|json -b1
r"0123456789abcdef(foo)01)0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)012'\''|json -b1
json: error: <stdin>:1:27: lex error: invalid raw string literal
json: error: <stdin>:1:27: r"0123456789abcdef(foo)012
json: error: <stdin>:1:27:                           ^
command failed: echo -n '\''r"0123456789abcdef(foo)012'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)012)'\''|json -b1
json: error: <stdin>:1:28: lex error: invalid raw string literal
json: error: <stdin>:1:28: r"0123456789abcdef(foo)012)
json: error: <stdin>:1:28:                            ^
command failed: echo -n '\''r"0123456789abcdef(foo)012)'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)012)0'\''|json -b1
json: error: <stdin>:1:29: lex error: invalid raw string literal
json: error: <stdin>:1:29: r"0123456789abcdef(foo)012)0
json: error: <stdin>:1:29:                             ^
command failed: echo -n '\''r"0123456789abcdef(foo)012)0'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)012)01'\''|json -b1
json: error: <stdin>:1:30: lex error: invalid raw string literal
json: error: <stdin>:1:30: r"0123456789abcdef(foo)012)01
json: error: <stdin>:1:30:                              ^
command failed: echo -n '\''r"0123456789abcdef(foo)012)01'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)012)012'\''|json -b1
json: error: <stdin>:1:31: lex error: invalid raw string literal
json: error: <stdin>:1:31: r"0123456789abcdef(foo)012)012
json: error: <stdin>:1:31:                               ^
command failed: echo -n '\''r"0123456789abcdef(foo)012)012'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)012)0123'\''|json -b1
json: error: <stdin>:1:32: lex error: invalid raw string literal
json: error: <stdin>:1:32: r"0123456789abcdef(foo)012)0123
json: error: <stdin>:1:32:                                ^
command failed: echo -n '\''r"0123456789abcdef(foo)012)0123'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)012)01234'\''|json -b1
json: error: <stdin>:1:33: lex error: invalid raw string literal
json: error: <stdin>:1:33: r"0123456789abcdef(foo)012)01234
json: error: <stdin>:1:33:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)012)01234'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)012)012345'\''|json -b1
json: error: <stdin>:1:34: lex error: invalid raw string literal
json: error: <stdin>:1:34: "0123456789abcdef(foo)012)012345
json: error: <stdin>:1:34:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)012)012345'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)012)0123456'\''|json -b1
json: error: <stdin>:1:35: lex error: invalid raw string literal
json: error: <stdin>:1:35: 0123456789abcdef(foo)012)0123456
json: error: <stdin>:1:35:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)012)0123456'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)012)01234567'\''|json -b1
json: error: <stdin>:1:36: lex error: invalid raw string literal
json: error: <stdin>:1:36: 123456789abcdef(foo)012)01234567
json: error: <stdin>:1:36:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)012)01234567'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)012)012345678'\''|json -b1
json: error: <stdin>:1:37: lex error: invalid raw string literal
json: error: <stdin>:1:37: 23456789abcdef(foo)012)012345678
json: error: <stdin>:1:37:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)012)012345678'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)012)0123456789'\''|json -b1
json: error: <stdin>:1:38: lex error: invalid raw string literal
json: error: <stdin>:1:38: 3456789abcdef(foo)012)0123456789
json: error: <stdin>:1:38:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)012)0123456789'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)012)0123456789a'\''|json -b1
json: error: <stdin>:1:39: lex error: invalid raw string literal
json: error: <stdin>:1:39: 456789abcdef(foo)012)0123456789a
json: error: <stdin>:1:39:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)012)0123456789a'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)012)0123456789ab'\''|json -b1
json: error: <stdin>:1:40: lex error: invalid raw string literal
json: error: <stdin>:1:40: 56789abcdef(foo)012)0123456789ab
json: error: <stdin>:1:40:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)012)0123456789ab'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)012)0123456789abc'\''|json -b1
json: error: <stdin>:1:41: lex error: invalid raw string literal
json: error: <stdin>:1:41: 6789abcdef(foo)012)0123456789abc
json: error: <stdin>:1:41:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)012)0123456789abc'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)012)0123456789abcd'\''|json -b1
json: error: <stdin>:1:42: lex error: invalid raw string literal
json: error: <stdin>:1:42: 789abcdef(foo)012)0123456789abcd
json: error: <stdin>:1:42:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)012)0123456789abcd'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)012)0123456789abcde'\''|json -b1
json: error: <stdin>:1:43: lex error: invalid raw string literal
json: error: <stdin>:1:43: 89abcdef(foo)012)0123456789abcde
json: error: <stdin>:1:43:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)012)0123456789abcde'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)012)0123456789abcdef'\''|json -b1
json: error: <stdin>:1:44: lex error: invalid raw string literal
json: error: <stdin>:1:44: 9abcdef(foo)012)0123456789abcdef
json: error: <stdin>:1:44:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)012)0123456789abcdef'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)012)0123456789abcdef"'\''|json -b1
r"0123456789abcdef(foo)012)0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)0123'\''|json -b1
json: error: <stdin>:1:28: lex error: invalid raw string literal
json: error: <stdin>:1:28: r"0123456789abcdef(foo)0123
json: error: <stdin>:1:28:                            ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123)'\''|json -b1
json: error: <stdin>:1:29: lex error: invalid raw string literal
json: error: <stdin>:1:29: r"0123456789abcdef(foo)0123)
json: error: <stdin>:1:29:                             ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123)'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123)0'\''|json -b1
json: error: <stdin>:1:30: lex error: invalid raw string literal
json: error: <stdin>:1:30: r"0123456789abcdef(foo)0123)0
json: error: <stdin>:1:30:                              ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123)0'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123)01'\''|json -b1
json: error: <stdin>:1:31: lex error: invalid raw string literal
json: error: <stdin>:1:31: r"0123456789abcdef(foo)0123)01
json: error: <stdin>:1:31:                               ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123)01'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123)012'\''|json -b1
json: error: <stdin>:1:32: lex error: invalid raw string literal
json: error: <stdin>:1:32: r"0123456789abcdef(foo)0123)012
json: error: <stdin>:1:32:                                ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123)012'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123)0123'\''|json -b1
json: error: <stdin>:1:33: lex error: invalid raw string literal
json: error: <stdin>:1:33: r"0123456789abcdef(foo)0123)0123
json: error: <stdin>:1:33:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123)0123'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123)01234'\''|json -b1
json: error: <stdin>:1:34: lex error: invalid raw string literal
json: error: <stdin>:1:34: "0123456789abcdef(foo)0123)01234
json: error: <stdin>:1:34:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123)01234'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123)012345'\''|json -b1
json: error: <stdin>:1:35: lex error: invalid raw string literal
json: error: <stdin>:1:35: 0123456789abcdef(foo)0123)012345
json: error: <stdin>:1:35:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123)012345'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123)0123456'\''|json -b1
json: error: <stdin>:1:36: lex error: invalid raw string literal
json: error: <stdin>:1:36: 123456789abcdef(foo)0123)0123456
json: error: <stdin>:1:36:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123)0123456'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123)01234567'\''|json -b1
json: error: <stdin>:1:37: lex error: invalid raw string literal
json: error: <stdin>:1:37: 23456789abcdef(foo)0123)01234567
json: error: <stdin>:1:37:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123)01234567'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123)012345678'\''|json -b1
json: error: <stdin>:1:38: lex error: invalid raw string literal
json: error: <stdin>:1:38: 3456789abcdef(foo)0123)012345678
json: error: <stdin>:1:38:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123)012345678'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123)0123456789'\''|json -b1
json: error: <stdin>:1:39: lex error: invalid raw string literal
json: error: <stdin>:1:39: 456789abcdef(foo)0123)0123456789
json: error: <stdin>:1:39:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123)0123456789'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123)0123456789a'\''|json -b1
json: error: <stdin>:1:40: lex error: invalid raw string literal
json: error: <stdin>:1:40: 56789abcdef(foo)0123)0123456789a
json: error: <stdin>:1:40:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123)0123456789a'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123)0123456789ab'\''|json -b1
json: error: <stdin>:1:41: lex error: invalid raw string literal
json: error: <stdin>:1:41: 6789abcdef(foo)0123)0123456789ab
json: error: <stdin>:1:41:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123)0123456789ab'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123)0123456789abc'\''|json -b1
json: error: <stdin>:1:42: lex error: invalid raw string literal
json: error: <stdin>:1:42: 789abcdef(foo)0123)0123456789abc
json: error: <stdin>:1:42:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123)0123456789abc'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123)0123456789abcd'\''|json -b1
json: error: <stdin>:1:43: lex error: invalid raw string literal
json: error: <stdin>:1:43: 89abcdef(foo)0123)0123456789abcd
json: error: <stdin>:1:43:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123)0123456789abcd'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123)0123456789abcde'\''|json -b1
json: error: <stdin>:1:44: lex error: invalid raw string literal
json: error: <stdin>:1:44: 9abcdef(foo)0123)0123456789abcde
json: error: <stdin>:1:44:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123)0123456789abcde'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123)0123456789abcdef'\''|json -b1
json: error: <stdin>:1:45: lex error: invalid raw string literal
json: error: <stdin>:1:45: abcdef(foo)0123)0123456789abcdef
json: error: <stdin>:1:45:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123)0123456789abcdef'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123)0123456789abcdef"'\''|json -b1
r"0123456789abcdef(foo)0123)0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)01234'\''|json -b1
json: error: <stdin>:1:29: lex error: invalid raw string literal
json: error: <stdin>:1:29: r"0123456789abcdef(foo)01234
json: error: <stdin>:1:29:                             ^
command failed: echo -n '\''r"0123456789abcdef(foo)01234'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)01234)'\''|json -b1
json: error: <stdin>:1:30: lex error: invalid raw string literal
json: error: <stdin>:1:30: r"0123456789abcdef(foo)01234)
json: error: <stdin>:1:30:                              ^
command failed: echo -n '\''r"0123456789abcdef(foo)01234)'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)01234)0'\''|json -b1
json: error: <stdin>:1:31: lex error: invalid raw string literal
json: error: <stdin>:1:31: r"0123456789abcdef(foo)01234)0
json: error: <stdin>:1:31:                               ^
command failed: echo -n '\''r"0123456789abcdef(foo)01234)0'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)01234)01'\''|json -b1
json: error: <stdin>:1:32: lex error: invalid raw string literal
json: error: <stdin>:1:32: r"0123456789abcdef(foo)01234)01
json: error: <stdin>:1:32:                                ^
command failed: echo -n '\''r"0123456789abcdef(foo)01234)01'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)01234)012'\''|json -b1
json: error: <stdin>:1:33: lex error: invalid raw string literal
json: error: <stdin>:1:33: r"0123456789abcdef(foo)01234)012
json: error: <stdin>:1:33:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)01234)012'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)01234)0123'\''|json -b1
json: error: <stdin>:1:34: lex error: invalid raw string literal
json: error: <stdin>:1:34: "0123456789abcdef(foo)01234)0123
json: error: <stdin>:1:34:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)01234)0123'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)01234)01234'\''|json -b1
json: error: <stdin>:1:35: lex error: invalid raw string literal
json: error: <stdin>:1:35: 0123456789abcdef(foo)01234)01234
json: error: <stdin>:1:35:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)01234)01234'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)01234)012345'\''|json -b1
json: error: <stdin>:1:36: lex error: invalid raw string literal
json: error: <stdin>:1:36: 123456789abcdef(foo)01234)012345
json: error: <stdin>:1:36:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)01234)012345'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)01234)0123456'\''|json -b1
json: error: <stdin>:1:37: lex error: invalid raw string literal
json: error: <stdin>:1:37: 23456789abcdef(foo)01234)0123456
json: error: <stdin>:1:37:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)01234)0123456'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)01234)01234567'\''|json -b1
json: error: <stdin>:1:38: lex error: invalid raw string literal
json: error: <stdin>:1:38: 3456789abcdef(foo)01234)01234567
json: error: <stdin>:1:38:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)01234)01234567'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)01234)012345678'\''|json -b1
json: error: <stdin>:1:39: lex error: invalid raw string literal
json: error: <stdin>:1:39: 456789abcdef(foo)01234)012345678
json: error: <stdin>:1:39:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)01234)012345678'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)01234)0123456789'\''|json -b1
json: error: <stdin>:1:40: lex error: invalid raw string literal
json: error: <stdin>:1:40: 56789abcdef(foo)01234)0123456789
json: error: <stdin>:1:40:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)01234)0123456789'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)01234)0123456789a'\''|json -b1
json: error: <stdin>:1:41: lex error: invalid raw string literal
json: error: <stdin>:1:41: 6789abcdef(foo)01234)0123456789a
json: error: <stdin>:1:41:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)01234)0123456789a'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)01234)0123456789ab'\''|json -b1
json: error: <stdin>:1:42: lex error: invalid raw string literal
json: error: <stdin>:1:42: 789abcdef(foo)01234)0123456789ab
json: error: <stdin>:1:42:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)01234)0123456789ab'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)01234)0123456789abc'\''|json -b1
json: error: <stdin>:1:43: lex error: invalid raw string literal
json: error: <stdin>:1:43: 89abcdef(foo)01234)0123456789abc
json: error: <stdin>:1:43:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)01234)0123456789abc'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)01234)0123456789abcd'\''|json -b1
json: error: <stdin>:1:44: lex error: invalid raw string literal
json: error: <stdin>:1:44: 9abcdef(foo)01234)0123456789abcd
json: error: <stdin>:1:44:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)01234)0123456789abcd'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)01234)0123456789abcde'\''|json -b1
json: error: <stdin>:1:45: lex error: invalid raw string literal
json: error: <stdin>:1:45: abcdef(foo)01234)0123456789abcde
json: error: <stdin>:1:45:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)01234)0123456789abcde'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)01234)0123456789abcdef'\''|json -b1
json: error: <stdin>:1:46: lex error: invalid raw string literal
json: error: <stdin>:1:46: bcdef(foo)01234)0123456789abcdef
json: error: <stdin>:1:46:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)01234)0123456789abcdef'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)01234)0123456789abcdef"'\''|json -b1
r"0123456789abcdef(foo)01234)0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)012345'\''|json -b1
json: error: <stdin>:1:30: lex error: invalid raw string literal
json: error: <stdin>:1:30: r"0123456789abcdef(foo)012345
json: error: <stdin>:1:30:                              ^
command failed: echo -n '\''r"0123456789abcdef(foo)012345'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)012345)'\''|json -b1
json: error: <stdin>:1:31: lex error: invalid raw string literal
json: error: <stdin>:1:31: r"0123456789abcdef(foo)012345)
json: error: <stdin>:1:31:                               ^
command failed: echo -n '\''r"0123456789abcdef(foo)012345)'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)012345)0'\''|json -b1
json: error: <stdin>:1:32: lex error: invalid raw string literal
json: error: <stdin>:1:32: r"0123456789abcdef(foo)012345)0
json: error: <stdin>:1:32:                                ^
command failed: echo -n '\''r"0123456789abcdef(foo)012345)0'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)012345)01'\''|json -b1
json: error: <stdin>:1:33: lex error: invalid raw string literal
json: error: <stdin>:1:33: r"0123456789abcdef(foo)012345)01
json: error: <stdin>:1:33:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)012345)01'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)012345)012'\''|json -b1
json: error: <stdin>:1:34: lex error: invalid raw string literal
json: error: <stdin>:1:34: "0123456789abcdef(foo)012345)012
json: error: <stdin>:1:34:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)012345)012'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)012345)0123'\''|json -b1
json: error: <stdin>:1:35: lex error: invalid raw string literal
json: error: <stdin>:1:35: 0123456789abcdef(foo)012345)0123
json: error: <stdin>:1:35:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)012345)0123'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)012345)01234'\''|json -b1
json: error: <stdin>:1:36: lex error: invalid raw string literal
json: error: <stdin>:1:36: 123456789abcdef(foo)012345)01234
json: error: <stdin>:1:36:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)012345)01234'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)012345)012345'\''|json -b1
json: error: <stdin>:1:37: lex error: invalid raw string literal
json: error: <stdin>:1:37: 23456789abcdef(foo)012345)012345
json: error: <stdin>:1:37:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)012345)012345'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)012345)0123456'\''|json -b1
json: error: <stdin>:1:38: lex error: invalid raw string literal
json: error: <stdin>:1:38: 3456789abcdef(foo)012345)0123456
json: error: <stdin>:1:38:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)012345)0123456'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)012345)01234567'\''|json -b1
json: error: <stdin>:1:39: lex error: invalid raw string literal
json: error: <stdin>:1:39: 456789abcdef(foo)012345)01234567
json: error: <stdin>:1:39:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)012345)01234567'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)012345)012345678'\''|json -b1
json: error: <stdin>:1:40: lex error: invalid raw string literal
json: error: <stdin>:1:40: 56789abcdef(foo)012345)012345678
json: error: <stdin>:1:40:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)012345)012345678'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)012345)0123456789'\''|json -b1
json: error: <stdin>:1:41: lex error: invalid raw string literal
json: error: <stdin>:1:41: 6789abcdef(foo)012345)0123456789
json: error: <stdin>:1:41:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)012345)0123456789'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)012345)0123456789a'\''|json -b1
json: error: <stdin>:1:42: lex error: invalid raw string literal
json: error: <stdin>:1:42: 789abcdef(foo)012345)0123456789a
json: error: <stdin>:1:42:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)012345)0123456789a'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)012345)0123456789ab'\''|json -b1
json: error: <stdin>:1:43: lex error: invalid raw string literal
json: error: <stdin>:1:43: 89abcdef(foo)012345)0123456789ab
json: error: <stdin>:1:43:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)012345)0123456789ab'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)012345)0123456789abc'\''|json -b1
json: error: <stdin>:1:44: lex error: invalid raw string literal
json: error: <stdin>:1:44: 9abcdef(foo)012345)0123456789abc
json: error: <stdin>:1:44:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)012345)0123456789abc'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)012345)0123456789abcd'\''|json -b1
json: error: <stdin>:1:45: lex error: invalid raw string literal
json: error: <stdin>:1:45: abcdef(foo)012345)0123456789abcd
json: error: <stdin>:1:45:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)012345)0123456789abcd'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)012345)0123456789abcde'\''|json -b1
json: error: <stdin>:1:46: lex error: invalid raw string literal
json: error: <stdin>:1:46: bcdef(foo)012345)0123456789abcde
json: error: <stdin>:1:46:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)012345)0123456789abcde'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)012345)0123456789abcdef'\''|json -b1
json: error: <stdin>:1:47: lex error: invalid raw string literal
json: error: <stdin>:1:47: cdef(foo)012345)0123456789abcdef
json: error: <stdin>:1:47:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)012345)0123456789abcdef'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)012345)0123456789abcdef"'\''|json -b1
r"0123456789abcdef(foo)012345)0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)0123456'\''|json -b1
json: error: <stdin>:1:31: lex error: invalid raw string literal
json: error: <stdin>:1:31: r"0123456789abcdef(foo)0123456
json: error: <stdin>:1:31:                               ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456)'\''|json -b1
json: error: <stdin>:1:32: lex error: invalid raw string literal
json: error: <stdin>:1:32: r"0123456789abcdef(foo)0123456)
json: error: <stdin>:1:32:                                ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456)'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456)0'\''|json -b1
json: error: <stdin>:1:33: lex error: invalid raw string literal
json: error: <stdin>:1:33: r"0123456789abcdef(foo)0123456)0
json: error: <stdin>:1:33:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456)0'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456)01'\''|json -b1
json: error: <stdin>:1:34: lex error: invalid raw string literal
json: error: <stdin>:1:34: "0123456789abcdef(foo)0123456)01
json: error: <stdin>:1:34:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456)01'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456)012'\''|json -b1
json: error: <stdin>:1:35: lex error: invalid raw string literal
json: error: <stdin>:1:35: 0123456789abcdef(foo)0123456)012
json: error: <stdin>:1:35:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456)012'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456)0123'\''|json -b1
json: error: <stdin>:1:36: lex error: invalid raw string literal
json: error: <stdin>:1:36: 123456789abcdef(foo)0123456)0123
json: error: <stdin>:1:36:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456)0123'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456)01234'\''|json -b1
json: error: <stdin>:1:37: lex error: invalid raw string literal
json: error: <stdin>:1:37: 23456789abcdef(foo)0123456)01234
json: error: <stdin>:1:37:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456)01234'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456)012345'\''|json -b1
json: error: <stdin>:1:38: lex error: invalid raw string literal
json: error: <stdin>:1:38: 3456789abcdef(foo)0123456)012345
json: error: <stdin>:1:38:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456)012345'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456)0123456'\''|json -b1
json: error: <stdin>:1:39: lex error: invalid raw string literal
json: error: <stdin>:1:39: 456789abcdef(foo)0123456)0123456
json: error: <stdin>:1:39:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456)0123456'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456)01234567'\''|json -b1
json: error: <stdin>:1:40: lex error: invalid raw string literal
json: error: <stdin>:1:40: 56789abcdef(foo)0123456)01234567
json: error: <stdin>:1:40:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456)01234567'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456)012345678'\''|json -b1
json: error: <stdin>:1:41: lex error: invalid raw string literal
json: error: <stdin>:1:41: 6789abcdef(foo)0123456)012345678
json: error: <stdin>:1:41:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456)012345678'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456)0123456789'\''|json -b1
json: error: <stdin>:1:42: lex error: invalid raw string literal
json: error: <stdin>:1:42: 789abcdef(foo)0123456)0123456789
json: error: <stdin>:1:42:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456)0123456789'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456)0123456789a'\''|json -b1
json: error: <stdin>:1:43: lex error: invalid raw string literal
json: error: <stdin>:1:43: 89abcdef(foo)0123456)0123456789a
json: error: <stdin>:1:43:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456)0123456789a'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456)0123456789ab'\''|json -b1
json: error: <stdin>:1:44: lex error: invalid raw string literal
json: error: <stdin>:1:44: 9abcdef(foo)0123456)0123456789ab
json: error: <stdin>:1:44:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456)0123456789ab'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456)0123456789abc'\''|json -b1
json: error: <stdin>:1:45: lex error: invalid raw string literal
json: error: <stdin>:1:45: abcdef(foo)0123456)0123456789abc
json: error: <stdin>:1:45:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456)0123456789abc'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456)0123456789abcd'\''|json -b1
json: error: <stdin>:1:46: lex error: invalid raw string literal
json: error: <stdin>:1:46: bcdef(foo)0123456)0123456789abcd
json: error: <stdin>:1:46:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456)0123456789abcd'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456)0123456789abcde'\''|json -b1
json: error: <stdin>:1:47: lex error: invalid raw string literal
json: error: <stdin>:1:47: cdef(foo)0123456)0123456789abcde
json: error: <stdin>:1:47:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456)0123456789abcde'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456)0123456789abcdef'\''|json -b1
json: error: <stdin>:1:48: lex error: invalid raw string literal
json: error: <stdin>:1:48: def(foo)0123456)0123456789abcdef
json: error: <stdin>:1:48:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456)0123456789abcdef'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456)0123456789abcdef"'\''|json -b1
r"0123456789abcdef(foo)0123456)0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)01234567'\''|json -b1
json: error: <stdin>:1:32: lex error: invalid raw string literal
json: error: <stdin>:1:32: r"0123456789abcdef(foo)01234567
json: error: <stdin>:1:32:                                ^
command failed: echo -n '\''r"0123456789abcdef(foo)01234567'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)01234567)'\''|json -b1
json: error: <stdin>:1:33: lex error: invalid raw string literal
json: error: <stdin>:1:33: r"0123456789abcdef(foo)01234567)
json: error: <stdin>:1:33:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)01234567)'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)01234567)0'\''|json -b1
json: error: <stdin>:1:34: lex error: invalid raw string literal
json: error: <stdin>:1:34: "0123456789abcdef(foo)01234567)0
json: error: <stdin>:1:34:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)01234567)0'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)01234567)01'\''|json -b1
json: error: <stdin>:1:35: lex error: invalid raw string literal
json: error: <stdin>:1:35: 0123456789abcdef(foo)01234567)01
json: error: <stdin>:1:35:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)01234567)01'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)01234567)012'\''|json -b1
json: error: <stdin>:1:36: lex error: invalid raw string literal
json: error: <stdin>:1:36: 123456789abcdef(foo)01234567)012
json: error: <stdin>:1:36:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)01234567)012'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)01234567)0123'\''|json -b1
json: error: <stdin>:1:37: lex error: invalid raw string literal
json: error: <stdin>:1:37: 23456789abcdef(foo)01234567)0123
json: error: <stdin>:1:37:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)01234567)0123'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)01234567)01234'\''|json -b1
json: error: <stdin>:1:38: lex error: invalid raw string literal
json: error: <stdin>:1:38: 3456789abcdef(foo)01234567)01234
json: error: <stdin>:1:38:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)01234567)01234'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)01234567)012345'\''|json -b1
json: error: <stdin>:1:39: lex error: invalid raw string literal
json: error: <stdin>:1:39: 456789abcdef(foo)01234567)012345
json: error: <stdin>:1:39:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)01234567)012345'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)01234567)0123456'\''|json -b1
json: error: <stdin>:1:40: lex error: invalid raw string literal
json: error: <stdin>:1:40: 56789abcdef(foo)01234567)0123456
json: error: <stdin>:1:40:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)01234567)0123456'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)01234567)01234567'\''|json -b1
json: error: <stdin>:1:41: lex error: invalid raw string literal
json: error: <stdin>:1:41: 6789abcdef(foo)01234567)01234567
json: error: <stdin>:1:41:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)01234567)01234567'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)01234567)012345678'\''|json -b1
json: error: <stdin>:1:42: lex error: invalid raw string literal
json: error: <stdin>:1:42: 789abcdef(foo)01234567)012345678
json: error: <stdin>:1:42:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)01234567)012345678'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)01234567)0123456789'\''|json -b1
json: error: <stdin>:1:43: lex error: invalid raw string literal
json: error: <stdin>:1:43: 89abcdef(foo)01234567)0123456789
json: error: <stdin>:1:43:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)01234567)0123456789'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)01234567)0123456789a'\''|json -b1
json: error: <stdin>:1:44: lex error: invalid raw string literal
json: error: <stdin>:1:44: 9abcdef(foo)01234567)0123456789a
json: error: <stdin>:1:44:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)01234567)0123456789a'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)01234567)0123456789ab'\''|json -b1
json: error: <stdin>:1:45: lex error: invalid raw string literal
json: error: <stdin>:1:45: abcdef(foo)01234567)0123456789ab
json: error: <stdin>:1:45:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)01234567)0123456789ab'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)01234567)0123456789abc'\''|json -b1
json: error: <stdin>:1:46: lex error: invalid raw string literal
json: error: <stdin>:1:46: bcdef(foo)01234567)0123456789abc
json: error: <stdin>:1:46:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)01234567)0123456789abc'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)01234567)0123456789abcd'\''|json -b1
json: error: <stdin>:1:47: lex error: invalid raw string literal
json: error: <stdin>:1:47: cdef(foo)01234567)0123456789abcd
json: error: <stdin>:1:47:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)01234567)0123456789abcd'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)01234567)0123456789abcde'\''|json -b1
json: error: <stdin>:1:48: lex error: invalid raw string literal
json: error: <stdin>:1:48: def(foo)01234567)0123456789abcde
json: error: <stdin>:1:48:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)01234567)0123456789abcde'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)01234567)0123456789abcdef'\''|json -b1
json: error: <stdin>:1:49: lex error: invalid raw string literal
json: error: <stdin>:1:49: ef(foo)01234567)0123456789abcdef
json: error: <stdin>:1:49:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)01234567)0123456789abcdef'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)01234567)0123456789abcdef"'\''|json -b1
r"0123456789abcdef(foo)01234567)0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)012345678'\''|json -b1
json: error: <stdin>:1:33: lex error: invalid raw string literal
json: error: <stdin>:1:33: r"0123456789abcdef(foo)012345678
json: error: <stdin>:1:33:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)012345678'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)012345678)'\''|json -b1
json: error: <stdin>:1:34: lex error: invalid raw string literal
json: error: <stdin>:1:34: "0123456789abcdef(foo)012345678)
json: error: <stdin>:1:34:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)012345678)'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)012345678)0'\''|json -b1
json: error: <stdin>:1:35: lex error: invalid raw string literal
json: error: <stdin>:1:35: 0123456789abcdef(foo)012345678)0
json: error: <stdin>:1:35:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)012345678)0'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)012345678)01'\''|json -b1
json: error: <stdin>:1:36: lex error: invalid raw string literal
json: error: <stdin>:1:36: 123456789abcdef(foo)012345678)01
json: error: <stdin>:1:36:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)012345678)01'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)012345678)012'\''|json -b1
json: error: <stdin>:1:37: lex error: invalid raw string literal
json: error: <stdin>:1:37: 23456789abcdef(foo)012345678)012
json: error: <stdin>:1:37:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)012345678)012'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)012345678)0123'\''|json -b1
json: error: <stdin>:1:38: lex error: invalid raw string literal
json: error: <stdin>:1:38: 3456789abcdef(foo)012345678)0123
json: error: <stdin>:1:38:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)012345678)0123'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)012345678)01234'\''|json -b1
json: error: <stdin>:1:39: lex error: invalid raw string literal
json: error: <stdin>:1:39: 456789abcdef(foo)012345678)01234
json: error: <stdin>:1:39:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)012345678)01234'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)012345678)012345'\''|json -b1
json: error: <stdin>:1:40: lex error: invalid raw string literal
json: error: <stdin>:1:40: 56789abcdef(foo)012345678)012345
json: error: <stdin>:1:40:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)012345678)012345'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)012345678)0123456'\''|json -b1
json: error: <stdin>:1:41: lex error: invalid raw string literal
json: error: <stdin>:1:41: 6789abcdef(foo)012345678)0123456
json: error: <stdin>:1:41:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)012345678)0123456'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)012345678)01234567'\''|json -b1
json: error: <stdin>:1:42: lex error: invalid raw string literal
json: error: <stdin>:1:42: 789abcdef(foo)012345678)01234567
json: error: <stdin>:1:42:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)012345678)01234567'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)012345678)012345678'\''|json -b1
json: error: <stdin>:1:43: lex error: invalid raw string literal
json: error: <stdin>:1:43: 89abcdef(foo)012345678)012345678
json: error: <stdin>:1:43:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)012345678)012345678'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)012345678)0123456789'\''|json -b1
json: error: <stdin>:1:44: lex error: invalid raw string literal
json: error: <stdin>:1:44: 9abcdef(foo)012345678)0123456789
json: error: <stdin>:1:44:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)012345678)0123456789'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)012345678)0123456789a'\''|json -b1
json: error: <stdin>:1:45: lex error: invalid raw string literal
json: error: <stdin>:1:45: abcdef(foo)012345678)0123456789a
json: error: <stdin>:1:45:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)012345678)0123456789a'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)012345678)0123456789ab'\''|json -b1
json: error: <stdin>:1:46: lex error: invalid raw string literal
json: error: <stdin>:1:46: bcdef(foo)012345678)0123456789ab
json: error: <stdin>:1:46:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)012345678)0123456789ab'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)012345678)0123456789abc'\''|json -b1
json: error: <stdin>:1:47: lex error: invalid raw string literal
json: error: <stdin>:1:47: cdef(foo)012345678)0123456789abc
json: error: <stdin>:1:47:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)012345678)0123456789abc'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)012345678)0123456789abcd'\''|json -b1
json: error: <stdin>:1:48: lex error: invalid raw string literal
json: error: <stdin>:1:48: def(foo)012345678)0123456789abcd
json: error: <stdin>:1:48:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)012345678)0123456789abcd'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)012345678)0123456789abcde'\''|json -b1
json: error: <stdin>:1:49: lex error: invalid raw string literal
json: error: <stdin>:1:49: ef(foo)012345678)0123456789abcde
json: error: <stdin>:1:49:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)012345678)0123456789abcde'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)012345678)0123456789abcdef'\''|json -b1
json: error: <stdin>:1:50: lex error: invalid raw string literal
json: error: <stdin>:1:50: f(foo)012345678)0123456789abcdef
json: error: <stdin>:1:50:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)012345678)0123456789abcdef'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)012345678)0123456789abcdef"'\''|json -b1
r"0123456789abcdef(foo)012345678)0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)0123456789'\''|json -b1
json: error: <stdin>:1:34: lex error: invalid raw string literal
json: error: <stdin>:1:34: "0123456789abcdef(foo)0123456789
json: error: <stdin>:1:34:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789)'\''|json -b1
json: error: <stdin>:1:35: lex error: invalid raw string literal
json: error: <stdin>:1:35: 0123456789abcdef(foo)0123456789)
json: error: <stdin>:1:35:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789)'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789)0'\''|json -b1
json: error: <stdin>:1:36: lex error: invalid raw string literal
json: error: <stdin>:1:36: 123456789abcdef(foo)0123456789)0
json: error: <stdin>:1:36:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789)0'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789)01'\''|json -b1
json: error: <stdin>:1:37: lex error: invalid raw string literal
json: error: <stdin>:1:37: 23456789abcdef(foo)0123456789)01
json: error: <stdin>:1:37:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789)01'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789)012'\''|json -b1
json: error: <stdin>:1:38: lex error: invalid raw string literal
json: error: <stdin>:1:38: 3456789abcdef(foo)0123456789)012
json: error: <stdin>:1:38:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789)012'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789)0123'\''|json -b1
json: error: <stdin>:1:39: lex error: invalid raw string literal
json: error: <stdin>:1:39: 456789abcdef(foo)0123456789)0123
json: error: <stdin>:1:39:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789)0123'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789)01234'\''|json -b1
json: error: <stdin>:1:40: lex error: invalid raw string literal
json: error: <stdin>:1:40: 56789abcdef(foo)0123456789)01234
json: error: <stdin>:1:40:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789)01234'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789)012345'\''|json -b1
json: error: <stdin>:1:41: lex error: invalid raw string literal
json: error: <stdin>:1:41: 6789abcdef(foo)0123456789)012345
json: error: <stdin>:1:41:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789)012345'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789)0123456'\''|json -b1
json: error: <stdin>:1:42: lex error: invalid raw string literal
json: error: <stdin>:1:42: 789abcdef(foo)0123456789)0123456
json: error: <stdin>:1:42:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789)0123456'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789)01234567'\''|json -b1
json: error: <stdin>:1:43: lex error: invalid raw string literal
json: error: <stdin>:1:43: 89abcdef(foo)0123456789)01234567
json: error: <stdin>:1:43:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789)01234567'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789)012345678'\''|json -b1
json: error: <stdin>:1:44: lex error: invalid raw string literal
json: error: <stdin>:1:44: 9abcdef(foo)0123456789)012345678
json: error: <stdin>:1:44:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789)012345678'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789)0123456789'\''|json -b1
json: error: <stdin>:1:45: lex error: invalid raw string literal
json: error: <stdin>:1:45: abcdef(foo)0123456789)0123456789
json: error: <stdin>:1:45:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789)0123456789'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789)0123456789a'\''|json -b1
json: error: <stdin>:1:46: lex error: invalid raw string literal
json: error: <stdin>:1:46: bcdef(foo)0123456789)0123456789a
json: error: <stdin>:1:46:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789)0123456789a'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789)0123456789ab'\''|json -b1
json: error: <stdin>:1:47: lex error: invalid raw string literal
json: error: <stdin>:1:47: cdef(foo)0123456789)0123456789ab
json: error: <stdin>:1:47:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789)0123456789ab'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789)0123456789abc'\''|json -b1
json: error: <stdin>:1:48: lex error: invalid raw string literal
json: error: <stdin>:1:48: def(foo)0123456789)0123456789abc
json: error: <stdin>:1:48:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789)0123456789abc'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789)0123456789abcd'\''|json -b1
json: error: <stdin>:1:49: lex error: invalid raw string literal
json: error: <stdin>:1:49: ef(foo)0123456789)0123456789abcd
json: error: <stdin>:1:49:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789)0123456789abcd'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789)0123456789abcde'\''|json -b1
json: error: <stdin>:1:50: lex error: invalid raw string literal
json: error: <stdin>:1:50: f(foo)0123456789)0123456789abcde
json: error: <stdin>:1:50:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789)0123456789abcde'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789)0123456789abcdef'\''|json -b1
json: error: <stdin>:1:51: lex error: invalid raw string literal
json: error: <stdin>:1:51: (foo)0123456789)0123456789abcdef
json: error: <stdin>:1:51:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789)0123456789abcdef'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789)0123456789abcdef"'\''|json -b1
r"0123456789abcdef(foo)0123456789)0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)0123456789a'\''|json -b1
json: error: <stdin>:1:35: lex error: invalid raw string literal
json: error: <stdin>:1:35: 0123456789abcdef(foo)0123456789a
json: error: <stdin>:1:35:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789a'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789a)'\''|json -b1
json: error: <stdin>:1:36: lex error: invalid raw string literal
json: error: <stdin>:1:36: 123456789abcdef(foo)0123456789a)
json: error: <stdin>:1:36:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789a)'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789a)0'\''|json -b1
json: error: <stdin>:1:37: lex error: invalid raw string literal
json: error: <stdin>:1:37: 23456789abcdef(foo)0123456789a)0
json: error: <stdin>:1:37:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789a)0'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789a)01'\''|json -b1
json: error: <stdin>:1:38: lex error: invalid raw string literal
json: error: <stdin>:1:38: 3456789abcdef(foo)0123456789a)01
json: error: <stdin>:1:38:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789a)01'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789a)012'\''|json -b1
json: error: <stdin>:1:39: lex error: invalid raw string literal
json: error: <stdin>:1:39: 456789abcdef(foo)0123456789a)012
json: error: <stdin>:1:39:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789a)012'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789a)0123'\''|json -b1
json: error: <stdin>:1:40: lex error: invalid raw string literal
json: error: <stdin>:1:40: 56789abcdef(foo)0123456789a)0123
json: error: <stdin>:1:40:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789a)0123'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789a)01234'\''|json -b1
json: error: <stdin>:1:41: lex error: invalid raw string literal
json: error: <stdin>:1:41: 6789abcdef(foo)0123456789a)01234
json: error: <stdin>:1:41:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789a)01234'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789a)012345'\''|json -b1
json: error: <stdin>:1:42: lex error: invalid raw string literal
json: error: <stdin>:1:42: 789abcdef(foo)0123456789a)012345
json: error: <stdin>:1:42:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789a)012345'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789a)0123456'\''|json -b1
json: error: <stdin>:1:43: lex error: invalid raw string literal
json: error: <stdin>:1:43: 89abcdef(foo)0123456789a)0123456
json: error: <stdin>:1:43:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789a)0123456'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789a)01234567'\''|json -b1
json: error: <stdin>:1:44: lex error: invalid raw string literal
json: error: <stdin>:1:44: 9abcdef(foo)0123456789a)01234567
json: error: <stdin>:1:44:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789a)01234567'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789a)012345678'\''|json -b1
json: error: <stdin>:1:45: lex error: invalid raw string literal
json: error: <stdin>:1:45: abcdef(foo)0123456789a)012345678
json: error: <stdin>:1:45:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789a)012345678'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789a)0123456789'\''|json -b1
json: error: <stdin>:1:46: lex error: invalid raw string literal
json: error: <stdin>:1:46: bcdef(foo)0123456789a)0123456789
json: error: <stdin>:1:46:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789a)0123456789'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789a)0123456789a'\''|json -b1
json: error: <stdin>:1:47: lex error: invalid raw string literal
json: error: <stdin>:1:47: cdef(foo)0123456789a)0123456789a
json: error: <stdin>:1:47:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789a)0123456789a'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789a)0123456789ab'\''|json -b1
json: error: <stdin>:1:48: lex error: invalid raw string literal
json: error: <stdin>:1:48: def(foo)0123456789a)0123456789ab
json: error: <stdin>:1:48:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789a)0123456789ab'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789a)0123456789abc'\''|json -b1
json: error: <stdin>:1:49: lex error: invalid raw string literal
json: error: <stdin>:1:49: ef(foo)0123456789a)0123456789abc
json: error: <stdin>:1:49:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789a)0123456789abc'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789a)0123456789abcd'\''|json -b1
json: error: <stdin>:1:50: lex error: invalid raw string literal
json: error: <stdin>:1:50: f(foo)0123456789a)0123456789abcd
json: error: <stdin>:1:50:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789a)0123456789abcd'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789a)0123456789abcde'\''|json -b1
json: error: <stdin>:1:51: lex error: invalid raw string literal
json: error: <stdin>:1:51: (foo)0123456789a)0123456789abcde
json: error: <stdin>:1:51:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789a)0123456789abcde'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789a)0123456789abcdef'\''|json -b1
json: error: <stdin>:1:52: lex error: invalid raw string literal
json: error: <stdin>:1:52: foo)0123456789a)0123456789abcdef
json: error: <stdin>:1:52:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789a)0123456789abcdef'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789a)0123456789abcdef"'\''|json -b1
r"0123456789abcdef(foo)0123456789a)0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)0123456789ab'\''|json -b1
json: error: <stdin>:1:36: lex error: invalid raw string literal
json: error: <stdin>:1:36: 123456789abcdef(foo)0123456789ab
json: error: <stdin>:1:36:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789ab'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789ab)'\''|json -b1
json: error: <stdin>:1:37: lex error: invalid raw string literal
json: error: <stdin>:1:37: 23456789abcdef(foo)0123456789ab)
json: error: <stdin>:1:37:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789ab)'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789ab)0'\''|json -b1
json: error: <stdin>:1:38: lex error: invalid raw string literal
json: error: <stdin>:1:38: 3456789abcdef(foo)0123456789ab)0
json: error: <stdin>:1:38:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789ab)0'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789ab)01'\''|json -b1
json: error: <stdin>:1:39: lex error: invalid raw string literal
json: error: <stdin>:1:39: 456789abcdef(foo)0123456789ab)01
json: error: <stdin>:1:39:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789ab)01'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789ab)012'\''|json -b1
json: error: <stdin>:1:40: lex error: invalid raw string literal
json: error: <stdin>:1:40: 56789abcdef(foo)0123456789ab)012
json: error: <stdin>:1:40:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789ab)012'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789ab)0123'\''|json -b1
json: error: <stdin>:1:41: lex error: invalid raw string literal
json: error: <stdin>:1:41: 6789abcdef(foo)0123456789ab)0123
json: error: <stdin>:1:41:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789ab)0123'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789ab)01234'\''|json -b1
json: error: <stdin>:1:42: lex error: invalid raw string literal
json: error: <stdin>:1:42: 789abcdef(foo)0123456789ab)01234
json: error: <stdin>:1:42:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789ab)01234'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789ab)012345'\''|json -b1
json: error: <stdin>:1:43: lex error: invalid raw string literal
json: error: <stdin>:1:43: 89abcdef(foo)0123456789ab)012345
json: error: <stdin>:1:43:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789ab)012345'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789ab)0123456'\''|json -b1
json: error: <stdin>:1:44: lex error: invalid raw string literal
json: error: <stdin>:1:44: 9abcdef(foo)0123456789ab)0123456
json: error: <stdin>:1:44:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789ab)0123456'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789ab)01234567'\''|json -b1
json: error: <stdin>:1:45: lex error: invalid raw string literal
json: error: <stdin>:1:45: abcdef(foo)0123456789ab)01234567
json: error: <stdin>:1:45:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789ab)01234567'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789ab)012345678'\''|json -b1
json: error: <stdin>:1:46: lex error: invalid raw string literal
json: error: <stdin>:1:46: bcdef(foo)0123456789ab)012345678
json: error: <stdin>:1:46:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789ab)012345678'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789ab)0123456789'\''|json -b1
json: error: <stdin>:1:47: lex error: invalid raw string literal
json: error: <stdin>:1:47: cdef(foo)0123456789ab)0123456789
json: error: <stdin>:1:47:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789ab)0123456789'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789ab)0123456789a'\''|json -b1
json: error: <stdin>:1:48: lex error: invalid raw string literal
json: error: <stdin>:1:48: def(foo)0123456789ab)0123456789a
json: error: <stdin>:1:48:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789ab)0123456789a'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789ab)0123456789ab'\''|json -b1
json: error: <stdin>:1:49: lex error: invalid raw string literal
json: error: <stdin>:1:49: ef(foo)0123456789ab)0123456789ab
json: error: <stdin>:1:49:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789ab)0123456789ab'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789ab)0123456789abc'\''|json -b1
json: error: <stdin>:1:50: lex error: invalid raw string literal
json: error: <stdin>:1:50: f(foo)0123456789ab)0123456789abc
json: error: <stdin>:1:50:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789ab)0123456789abc'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789ab)0123456789abcd'\''|json -b1
json: error: <stdin>:1:51: lex error: invalid raw string literal
json: error: <stdin>:1:51: (foo)0123456789ab)0123456789abcd
json: error: <stdin>:1:51:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789ab)0123456789abcd'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789ab)0123456789abcde'\''|json -b1
json: error: <stdin>:1:52: lex error: invalid raw string literal
json: error: <stdin>:1:52: foo)0123456789ab)0123456789abcde
json: error: <stdin>:1:52:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789ab)0123456789abcde'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789ab)0123456789abcdef'\''|json -b1
json: error: <stdin>:1:53: lex error: invalid raw string literal
json: error: <stdin>:1:53: oo)0123456789ab)0123456789abcdef
json: error: <stdin>:1:53:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789ab)0123456789abcdef'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789ab)0123456789abcdef"'\''|json -b1
r"0123456789abcdef(foo)0123456789ab)0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)0123456789abc'\''|json -b1
json: error: <stdin>:1:37: lex error: invalid raw string literal
json: error: <stdin>:1:37: 23456789abcdef(foo)0123456789abc
json: error: <stdin>:1:37:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abc'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abc)'\''|json -b1
json: error: <stdin>:1:38: lex error: invalid raw string literal
json: error: <stdin>:1:38: 3456789abcdef(foo)0123456789abc)
json: error: <stdin>:1:38:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abc)'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abc)0'\''|json -b1
json: error: <stdin>:1:39: lex error: invalid raw string literal
json: error: <stdin>:1:39: 456789abcdef(foo)0123456789abc)0
json: error: <stdin>:1:39:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abc)0'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abc)01'\''|json -b1
json: error: <stdin>:1:40: lex error: invalid raw string literal
json: error: <stdin>:1:40: 56789abcdef(foo)0123456789abc)01
json: error: <stdin>:1:40:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abc)01'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abc)012'\''|json -b1
json: error: <stdin>:1:41: lex error: invalid raw string literal
json: error: <stdin>:1:41: 6789abcdef(foo)0123456789abc)012
json: error: <stdin>:1:41:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abc)012'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abc)0123'\''|json -b1
json: error: <stdin>:1:42: lex error: invalid raw string literal
json: error: <stdin>:1:42: 789abcdef(foo)0123456789abc)0123
json: error: <stdin>:1:42:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abc)0123'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abc)01234'\''|json -b1
json: error: <stdin>:1:43: lex error: invalid raw string literal
json: error: <stdin>:1:43: 89abcdef(foo)0123456789abc)01234
json: error: <stdin>:1:43:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abc)01234'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abc)012345'\''|json -b1
json: error: <stdin>:1:44: lex error: invalid raw string literal
json: error: <stdin>:1:44: 9abcdef(foo)0123456789abc)012345
json: error: <stdin>:1:44:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abc)012345'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abc)0123456'\''|json -b1
json: error: <stdin>:1:45: lex error: invalid raw string literal
json: error: <stdin>:1:45: abcdef(foo)0123456789abc)0123456
json: error: <stdin>:1:45:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abc)0123456'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abc)01234567'\''|json -b1
json: error: <stdin>:1:46: lex error: invalid raw string literal
json: error: <stdin>:1:46: bcdef(foo)0123456789abc)01234567
json: error: <stdin>:1:46:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abc)01234567'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abc)012345678'\''|json -b1
json: error: <stdin>:1:47: lex error: invalid raw string literal
json: error: <stdin>:1:47: cdef(foo)0123456789abc)012345678
json: error: <stdin>:1:47:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abc)012345678'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abc)0123456789'\''|json -b1
json: error: <stdin>:1:48: lex error: invalid raw string literal
json: error: <stdin>:1:48: def(foo)0123456789abc)0123456789
json: error: <stdin>:1:48:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abc)0123456789'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abc)0123456789a'\''|json -b1
json: error: <stdin>:1:49: lex error: invalid raw string literal
json: error: <stdin>:1:49: ef(foo)0123456789abc)0123456789a
json: error: <stdin>:1:49:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abc)0123456789a'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abc)0123456789ab'\''|json -b1
json: error: <stdin>:1:50: lex error: invalid raw string literal
json: error: <stdin>:1:50: f(foo)0123456789abc)0123456789ab
json: error: <stdin>:1:50:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abc)0123456789ab'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abc)0123456789abc'\''|json -b1
json: error: <stdin>:1:51: lex error: invalid raw string literal
json: error: <stdin>:1:51: (foo)0123456789abc)0123456789abc
json: error: <stdin>:1:51:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abc)0123456789abc'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abc)0123456789abcd'\''|json -b1
json: error: <stdin>:1:52: lex error: invalid raw string literal
json: error: <stdin>:1:52: foo)0123456789abc)0123456789abcd
json: error: <stdin>:1:52:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abc)0123456789abcd'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abc)0123456789abcde'\''|json -b1
json: error: <stdin>:1:53: lex error: invalid raw string literal
json: error: <stdin>:1:53: oo)0123456789abc)0123456789abcde
json: error: <stdin>:1:53:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abc)0123456789abcde'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abc)0123456789abcdef'\''|json -b1
json: error: <stdin>:1:54: lex error: invalid raw string literal
json: error: <stdin>:1:54: o)0123456789abc)0123456789abcdef
json: error: <stdin>:1:54:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abc)0123456789abcdef'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abc)0123456789abcdef"'\''|json -b1
r"0123456789abcdef(foo)0123456789abc)0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcd'\''|json -b1
json: error: <stdin>:1:38: lex error: invalid raw string literal
json: error: <stdin>:1:38: 3456789abcdef(foo)0123456789abcd
json: error: <stdin>:1:38:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcd'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcd)'\''|json -b1
json: error: <stdin>:1:39: lex error: invalid raw string literal
json: error: <stdin>:1:39: 456789abcdef(foo)0123456789abcd)
json: error: <stdin>:1:39:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcd)'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcd)0'\''|json -b1
json: error: <stdin>:1:40: lex error: invalid raw string literal
json: error: <stdin>:1:40: 56789abcdef(foo)0123456789abcd)0
json: error: <stdin>:1:40:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcd)0'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcd)01'\''|json -b1
json: error: <stdin>:1:41: lex error: invalid raw string literal
json: error: <stdin>:1:41: 6789abcdef(foo)0123456789abcd)01
json: error: <stdin>:1:41:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcd)01'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcd)012'\''|json -b1
json: error: <stdin>:1:42: lex error: invalid raw string literal
json: error: <stdin>:1:42: 789abcdef(foo)0123456789abcd)012
json: error: <stdin>:1:42:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcd)012'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcd)0123'\''|json -b1
json: error: <stdin>:1:43: lex error: invalid raw string literal
json: error: <stdin>:1:43: 89abcdef(foo)0123456789abcd)0123
json: error: <stdin>:1:43:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcd)0123'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcd)01234'\''|json -b1
json: error: <stdin>:1:44: lex error: invalid raw string literal
json: error: <stdin>:1:44: 9abcdef(foo)0123456789abcd)01234
json: error: <stdin>:1:44:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcd)01234'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcd)012345'\''|json -b1
json: error: <stdin>:1:45: lex error: invalid raw string literal
json: error: <stdin>:1:45: abcdef(foo)0123456789abcd)012345
json: error: <stdin>:1:45:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcd)012345'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcd)0123456'\''|json -b1
json: error: <stdin>:1:46: lex error: invalid raw string literal
json: error: <stdin>:1:46: bcdef(foo)0123456789abcd)0123456
json: error: <stdin>:1:46:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcd)0123456'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcd)01234567'\''|json -b1
json: error: <stdin>:1:47: lex error: invalid raw string literal
json: error: <stdin>:1:47: cdef(foo)0123456789abcd)01234567
json: error: <stdin>:1:47:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcd)01234567'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcd)012345678'\''|json -b1
json: error: <stdin>:1:48: lex error: invalid raw string literal
json: error: <stdin>:1:48: def(foo)0123456789abcd)012345678
json: error: <stdin>:1:48:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcd)012345678'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcd)0123456789'\''|json -b1
json: error: <stdin>:1:49: lex error: invalid raw string literal
json: error: <stdin>:1:49: ef(foo)0123456789abcd)0123456789
json: error: <stdin>:1:49:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcd)0123456789'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcd)0123456789a'\''|json -b1
json: error: <stdin>:1:50: lex error: invalid raw string literal
json: error: <stdin>:1:50: f(foo)0123456789abcd)0123456789a
json: error: <stdin>:1:50:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcd)0123456789a'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcd)0123456789ab'\''|json -b1
json: error: <stdin>:1:51: lex error: invalid raw string literal
json: error: <stdin>:1:51: (foo)0123456789abcd)0123456789ab
json: error: <stdin>:1:51:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcd)0123456789ab'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcd)0123456789abc'\''|json -b1
json: error: <stdin>:1:52: lex error: invalid raw string literal
json: error: <stdin>:1:52: foo)0123456789abcd)0123456789abc
json: error: <stdin>:1:52:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcd)0123456789abc'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcd)0123456789abcd'\''|json -b1
json: error: <stdin>:1:53: lex error: invalid raw string literal
json: error: <stdin>:1:53: oo)0123456789abcd)0123456789abcd
json: error: <stdin>:1:53:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcd)0123456789abcd'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcd)0123456789abcde'\''|json -b1
json: error: <stdin>:1:54: lex error: invalid raw string literal
json: error: <stdin>:1:54: o)0123456789abcd)0123456789abcde
json: error: <stdin>:1:54:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcd)0123456789abcde'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcd)0123456789abcdef'\''|json -b1
json: error: <stdin>:1:55: lex error: invalid raw string literal
json: error: <stdin>:1:55: )0123456789abcd)0123456789abcdef
json: error: <stdin>:1:55:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcd)0123456789abcdef'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcd)0123456789abcdef"'\''|json -b1
r"0123456789abcdef(foo)0123456789abcd)0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcde'\''|json -b1
json: error: <stdin>:1:39: lex error: invalid raw string literal
json: error: <stdin>:1:39: 456789abcdef(foo)0123456789abcde
json: error: <stdin>:1:39:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcde'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcde)'\''|json -b1
json: error: <stdin>:1:40: lex error: invalid raw string literal
json: error: <stdin>:1:40: 56789abcdef(foo)0123456789abcde)
json: error: <stdin>:1:40:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcde)'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcde)0'\''|json -b1
json: error: <stdin>:1:41: lex error: invalid raw string literal
json: error: <stdin>:1:41: 6789abcdef(foo)0123456789abcde)0
json: error: <stdin>:1:41:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcde)0'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcde)01'\''|json -b1
json: error: <stdin>:1:42: lex error: invalid raw string literal
json: error: <stdin>:1:42: 789abcdef(foo)0123456789abcde)01
json: error: <stdin>:1:42:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcde)01'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcde)012'\''|json -b1
json: error: <stdin>:1:43: lex error: invalid raw string literal
json: error: <stdin>:1:43: 89abcdef(foo)0123456789abcde)012
json: error: <stdin>:1:43:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcde)012'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcde)0123'\''|json -b1
json: error: <stdin>:1:44: lex error: invalid raw string literal
json: error: <stdin>:1:44: 9abcdef(foo)0123456789abcde)0123
json: error: <stdin>:1:44:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcde)0123'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcde)01234'\''|json -b1
json: error: <stdin>:1:45: lex error: invalid raw string literal
json: error: <stdin>:1:45: abcdef(foo)0123456789abcde)01234
json: error: <stdin>:1:45:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcde)01234'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcde)012345'\''|json -b1
json: error: <stdin>:1:46: lex error: invalid raw string literal
json: error: <stdin>:1:46: bcdef(foo)0123456789abcde)012345
json: error: <stdin>:1:46:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcde)012345'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcde)0123456'\''|json -b1
json: error: <stdin>:1:47: lex error: invalid raw string literal
json: error: <stdin>:1:47: cdef(foo)0123456789abcde)0123456
json: error: <stdin>:1:47:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcde)0123456'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcde)01234567'\''|json -b1
json: error: <stdin>:1:48: lex error: invalid raw string literal
json: error: <stdin>:1:48: def(foo)0123456789abcde)01234567
json: error: <stdin>:1:48:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcde)01234567'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcde)012345678'\''|json -b1
json: error: <stdin>:1:49: lex error: invalid raw string literal
json: error: <stdin>:1:49: ef(foo)0123456789abcde)012345678
json: error: <stdin>:1:49:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcde)012345678'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcde)0123456789'\''|json -b1
json: error: <stdin>:1:50: lex error: invalid raw string literal
json: error: <stdin>:1:50: f(foo)0123456789abcde)0123456789
json: error: <stdin>:1:50:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcde)0123456789'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcde)0123456789a'\''|json -b1
json: error: <stdin>:1:51: lex error: invalid raw string literal
json: error: <stdin>:1:51: (foo)0123456789abcde)0123456789a
json: error: <stdin>:1:51:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcde)0123456789a'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcde)0123456789ab'\''|json -b1
json: error: <stdin>:1:52: lex error: invalid raw string literal
json: error: <stdin>:1:52: foo)0123456789abcde)0123456789ab
json: error: <stdin>:1:52:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcde)0123456789ab'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcde)0123456789abc'\''|json -b1
json: error: <stdin>:1:53: lex error: invalid raw string literal
json: error: <stdin>:1:53: oo)0123456789abcde)0123456789abc
json: error: <stdin>:1:53:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcde)0123456789abc'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcde)0123456789abcd'\''|json -b1
json: error: <stdin>:1:54: lex error: invalid raw string literal
json: error: <stdin>:1:54: o)0123456789abcde)0123456789abcd
json: error: <stdin>:1:54:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcde)0123456789abcd'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcde)0123456789abcde'\''|json -b1
json: error: <stdin>:1:55: lex error: invalid raw string literal
json: error: <stdin>:1:55: )0123456789abcde)0123456789abcde
json: error: <stdin>:1:55:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcde)0123456789abcde'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcde)0123456789abcdef'\''|json -b1
json: error: <stdin>:1:56: lex error: invalid raw string literal
json: error: <stdin>:1:56: 0123456789abcde)0123456789abcdef
json: error: <stdin>:1:56:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcde)0123456789abcdef'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcde)0123456789abcdef"'\''|json -b1
r"0123456789abcdef(foo)0123456789abcde)0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcdef'\''|json -b1
json: error: <stdin>:1:40: lex error: invalid raw string literal
json: error: <stdin>:1:40: 56789abcdef(foo)0123456789abcdef
json: error: <stdin>:1:40:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcdef'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcdef"'\''|json -b1
r"0123456789abcdef(foo)0123456789abcdef"
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)'\''|json -b1
json: error: <stdin>:1:41: lex error: invalid raw string literal
json: error: <stdin>:1:41: 6789abcdef(foo)0123456789abcdef)
json: error: <stdin>:1:41:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)0'\''|json -b1
json: error: <stdin>:1:42: lex error: invalid raw string literal
json: error: <stdin>:1:42: 789abcdef(foo)0123456789abcdef)0
json: error: <stdin>:1:42:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)0'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)01'\''|json -b1
json: error: <stdin>:1:43: lex error: invalid raw string literal
json: error: <stdin>:1:43: 89abcdef(foo)0123456789abcdef)01
json: error: <stdin>:1:43:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)01'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)012'\''|json -b1
json: error: <stdin>:1:44: lex error: invalid raw string literal
json: error: <stdin>:1:44: 9abcdef(foo)0123456789abcdef)012
json: error: <stdin>:1:44:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)012'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)0123'\''|json -b1
json: error: <stdin>:1:45: lex error: invalid raw string literal
json: error: <stdin>:1:45: abcdef(foo)0123456789abcdef)0123
json: error: <stdin>:1:45:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)0123'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)01234'\''|json -b1
json: error: <stdin>:1:46: lex error: invalid raw string literal
json: error: <stdin>:1:46: bcdef(foo)0123456789abcdef)01234
json: error: <stdin>:1:46:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)01234'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)012345'\''|json -b1
json: error: <stdin>:1:47: lex error: invalid raw string literal
json: error: <stdin>:1:47: cdef(foo)0123456789abcdef)012345
json: error: <stdin>:1:47:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)012345'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)0123456'\''|json -b1
json: error: <stdin>:1:48: lex error: invalid raw string literal
json: error: <stdin>:1:48: def(foo)0123456789abcdef)0123456
json: error: <stdin>:1:48:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)0123456'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)01234567'\''|json -b1
json: error: <stdin>:1:49: lex error: invalid raw string literal
json: error: <stdin>:1:49: ef(foo)0123456789abcdef)01234567
json: error: <stdin>:1:49:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)01234567'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)012345678'\''|json -b1
json: error: <stdin>:1:50: lex error: invalid raw string literal
json: error: <stdin>:1:50: f(foo)0123456789abcdef)012345678
json: error: <stdin>:1:50:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)012345678'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)0123456789'\''|json -b1
json: error: <stdin>:1:51: lex error: invalid raw string literal
json: error: <stdin>:1:51: (foo)0123456789abcdef)0123456789
json: error: <stdin>:1:51:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)0123456789'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)0123456789a'\''|json -b1
json: error: <stdin>:1:52: lex error: invalid raw string literal
json: error: <stdin>:1:52: foo)0123456789abcdef)0123456789a
json: error: <stdin>:1:52:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)0123456789a'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)0123456789ab'\''|json -b1
json: error: <stdin>:1:53: lex error: invalid raw string literal
json: error: <stdin>:1:53: oo)0123456789abcdef)0123456789ab
json: error: <stdin>:1:53:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)0123456789ab'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)0123456789abc'\''|json -b1
json: error: <stdin>:1:54: lex error: invalid raw string literal
json: error: <stdin>:1:54: o)0123456789abcdef)0123456789abc
json: error: <stdin>:1:54:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)0123456789abc'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)0123456789abcd'\''|json -b1
json: error: <stdin>:1:55: lex error: invalid raw string literal
json: error: <stdin>:1:55: )0123456789abcdef)0123456789abcd
json: error: <stdin>:1:55:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)0123456789abcd'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)0123456789abcde'\''|json -b1
json: error: <stdin>:1:56: lex error: invalid raw string literal
json: error: <stdin>:1:56: 0123456789abcdef)0123456789abcde
json: error: <stdin>:1:56:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)0123456789abcde'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)0123456789abcdef'\''|json -b1
json: error: <stdin>:1:57: lex error: invalid raw string literal
json: error: <stdin>:1:57: 123456789abcdef)0123456789abcdef
json: error: <stdin>:1:57:                                 ^
command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)0123456789abcdef'\''|json -b1
$ echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)0123456789abcdef"'\''|json -b1
r"0123456789abcdef(foo)0123456789abcdef)0123456789abcdef"
$ echo -n '\''r"b'\''|json -b1
json: error: <stdin>:1:4: lex error: invalid raw string literal
json: error: <stdin>:1:4: r"b
json: error: <stdin>:1:4:    ^
command failed: echo -n '\''r"b'\''|json -b1
$ echo -n '\''r"ba'\''|json -b1
json: error: <stdin>:1:5: lex error: invalid raw string literal
json: error: <stdin>:1:5: r"ba
json: error: <stdin>:1:5:     ^
command failed: echo -n '\''r"ba'\''|json -b1
$ echo -n '\''r"bar'\''|json -b1
json: error: <stdin>:1:6: lex error: invalid raw string literal
json: error: <stdin>:1:6: r"bar
json: error: <stdin>:1:6:      ^
command failed: echo -n '\''r"bar'\''|json -b1
$ echo -n '\''r"bar('\''|json -b1
json: error: <stdin>:1:7: lex error: invalid raw string literal
json: error: <stdin>:1:7: r"bar(
json: error: <stdin>:1:7:       ^
command failed: echo -n '\''r"bar('\''|json -b1
$ echo -n '\''r"bar()'\''|json -b1
json: error: <stdin>:1:8: lex error: invalid raw string literal
json: error: <stdin>:1:8: r"bar()
json: error: <stdin>:1:8:        ^
command failed: echo -n '\''r"bar()'\''|json -b1
$ echo -n '\''r"bar())'\''|json -b1
json: error: <stdin>:1:9: lex error: invalid raw string literal
json: error: <stdin>:1:9: r"bar())
json: error: <stdin>:1:9:         ^
command failed: echo -n '\''r"bar())'\''|json -b1
$ echo -n '\''r"bar())b'\''|json -b1
json: error: <stdin>:1:10: lex error: invalid raw string literal
json: error: <stdin>:1:10: r"bar())b
json: error: <stdin>:1:10:          ^
command failed: echo -n '\''r"bar())b'\''|json -b1
$ echo -n '\''r"bar())ba'\''|json -b1
json: error: <stdin>:1:11: lex error: invalid raw string literal
json: error: <stdin>:1:11: r"bar())ba
json: error: <stdin>:1:11:           ^
command failed: echo -n '\''r"bar())ba'\''|json -b1
$ echo -n '\''r"bar())bar'\''|json -b1
json: error: <stdin>:1:12: lex error: invalid raw string literal
json: error: <stdin>:1:12: r"bar())bar
json: error: <stdin>:1:12:            ^
command failed: echo -n '\''r"bar())bar'\''|json -b1
$ echo -n '\''r"bar())bar"'\''|json -b1
r"bar())bar"
$ echo -n '\''r"bar()b'\''|json -b1
json: error: <stdin>:1:9: lex error: invalid raw string literal
json: error: <stdin>:1:9: r"bar()b
json: error: <stdin>:1:9:         ^
command failed: echo -n '\''r"bar()b'\''|json -b1
$ echo -n '\''r"bar()b)'\''|json -b1
json: error: <stdin>:1:10: lex error: invalid raw string literal
json: error: <stdin>:1:10: r"bar()b)
json: error: <stdin>:1:10:          ^
command failed: echo -n '\''r"bar()b)'\''|json -b1
$ echo -n '\''r"bar()b)b'\''|json -b1
json: error: <stdin>:1:11: lex error: invalid raw string literal
json: error: <stdin>:1:11: r"bar()b)b
json: error: <stdin>:1:11:           ^
command failed: echo -n '\''r"bar()b)b'\''|json -b1
$ echo -n '\''r"bar()b)ba'\''|json -b1
json: error: <stdin>:1:12: lex error: invalid raw string literal
json: error: <stdin>:1:12: r"bar()b)ba
json: error: <stdin>:1:12:            ^
command failed: echo -n '\''r"bar()b)ba'\''|json -b1
$ echo -n '\''r"bar()b)bar'\''|json -b1
json: error: <stdin>:1:13: lex error: invalid raw string literal
json: error: <stdin>:1:13: r"bar()b)bar
json: error: <stdin>:1:13:             ^
command failed: echo -n '\''r"bar()b)bar'\''|json -b1
$ echo -n '\''r"bar()b)bar"'\''|json -b1
r"bar()b)bar"
$ echo -n '\''r"bar()ba'\''|json -b1
json: error: <stdin>:1:10: lex error: invalid raw string literal
json: error: <stdin>:1:10: r"bar()ba
json: error: <stdin>:1:10:          ^
command failed: echo -n '\''r"bar()ba'\''|json -b1
$ echo -n '\''r"bar()ba)'\''|json -b1
json: error: <stdin>:1:11: lex error: invalid raw string literal
json: error: <stdin>:1:11: r"bar()ba)
json: error: <stdin>:1:11:           ^
command failed: echo -n '\''r"bar()ba)'\''|json -b1
$ echo -n '\''r"bar()ba)b'\''|json -b1
json: error: <stdin>:1:12: lex error: invalid raw string literal
json: error: <stdin>:1:12: r"bar()ba)b
json: error: <stdin>:1:12:            ^
command failed: echo -n '\''r"bar()ba)b'\''|json -b1
$ echo -n '\''r"bar()ba)ba'\''|json -b1
json: error: <stdin>:1:13: lex error: invalid raw string literal
json: error: <stdin>:1:13: r"bar()ba)ba
json: error: <stdin>:1:13:             ^
command failed: echo -n '\''r"bar()ba)ba'\''|json -b1
$ echo -n '\''r"bar()ba)bar'\''|json -b1
json: error: <stdin>:1:14: lex error: invalid raw string literal
json: error: <stdin>:1:14: r"bar()ba)bar
json: error: <stdin>:1:14:              ^
command failed: echo -n '\''r"bar()ba)bar'\''|json -b1
$ echo -n '\''r"bar()ba)bar"'\''|json -b1
r"bar()ba)bar"
$ echo -n '\''r"bar()bar'\''|json -b1
json: error: <stdin>:1:11: lex error: invalid raw string literal
json: error: <stdin>:1:11: r"bar()bar
json: error: <stdin>:1:11:           ^
command failed: echo -n '\''r"bar()bar'\''|json -b1
$ echo -n '\''r"bar()bar"'\''|json -b1
r"bar()bar"
$ echo -n '\''r"bar()bar)'\''|json -b1
json: error: <stdin>:1:12: lex error: invalid raw string literal
json: error: <stdin>:1:12: r"bar()bar)
json: error: <stdin>:1:12:            ^
command failed: echo -n '\''r"bar()bar)'\''|json -b1
$ echo -n '\''r"bar()bar)b'\''|json -b1
json: error: <stdin>:1:13: lex error: invalid raw string literal
json: error: <stdin>:1:13: r"bar()bar)b
json: error: <stdin>:1:13:             ^
command failed: echo -n '\''r"bar()bar)b'\''|json -b1
$ echo -n '\''r"bar()bar)ba'\''|json -b1
json: error: <stdin>:1:14: lex error: invalid raw string literal
json: error: <stdin>:1:14: r"bar()bar)ba
json: error: <stdin>:1:14:              ^
command failed: echo -n '\''r"bar()bar)ba'\''|json -b1
$ echo -n '\''r"bar()bar)bar'\''|json -b1
json: error: <stdin>:1:15: lex error: invalid raw string literal
json: error: <stdin>:1:15: r"bar()bar)bar
json: error: <stdin>:1:15:               ^
command failed: echo -n '\''r"bar()bar)bar'\''|json -b1
$ echo -n '\''r"bar()bar)bar"'\''|json -b1
r"bar()bar)bar"
$ echo -n '\''r"bar(f'\''|json -b1
json: error: <stdin>:1:8: lex error: invalid raw string literal
json: error: <stdin>:1:8: r"bar(f
json: error: <stdin>:1:8:        ^
command failed: echo -n '\''r"bar(f'\''|json -b1
$ echo -n '\''r"bar(fo'\''|json -b1
json: error: <stdin>:1:9: lex error: invalid raw string literal
json: error: <stdin>:1:9: r"bar(fo
json: error: <stdin>:1:9:         ^
command failed: echo -n '\''r"bar(fo'\''|json -b1
$ echo -n '\''r"bar(foo'\''|json -b1
json: error: <stdin>:1:10: lex error: invalid raw string literal
json: error: <stdin>:1:10: r"bar(foo
json: error: <stdin>:1:10:          ^
command failed: echo -n '\''r"bar(foo'\''|json -b1
$ echo -n '\''r"bar(foo)'\''|json -b1
json: error: <stdin>:1:11: lex error: invalid raw string literal
json: error: <stdin>:1:11: r"bar(foo)
json: error: <stdin>:1:11:           ^
command failed: echo -n '\''r"bar(foo)'\''|json -b1
$ echo -n '\''r"bar(foo))'\''|json -b1
json: error: <stdin>:1:12: lex error: invalid raw string literal
json: error: <stdin>:1:12: r"bar(foo))
json: error: <stdin>:1:12:            ^
command failed: echo -n '\''r"bar(foo))'\''|json -b1
$ echo -n '\''r"bar(foo))b'\''|json -b1
json: error: <stdin>:1:13: lex error: invalid raw string literal
json: error: <stdin>:1:13: r"bar(foo))b
json: error: <stdin>:1:13:             ^
command failed: echo -n '\''r"bar(foo))b'\''|json -b1
$ echo -n '\''r"bar(foo))ba'\''|json -b1
json: error: <stdin>:1:14: lex error: invalid raw string literal
json: error: <stdin>:1:14: r"bar(foo))ba
json: error: <stdin>:1:14:              ^
command failed: echo -n '\''r"bar(foo))ba'\''|json -b1
$ echo -n '\''r"bar(foo))bar'\''|json -b1
json: error: <stdin>:1:15: lex error: invalid raw string literal
json: error: <stdin>:1:15: r"bar(foo))bar
json: error: <stdin>:1:15:               ^
command failed: echo -n '\''r"bar(foo))bar'\''|json -b1
$ echo -n '\''r"bar(foo))bar"'\''|json -b1
r"bar(foo))bar"
$ echo -n '\''r"bar(foo)b'\''|json -b1
json: error: <stdin>:1:12: lex error: invalid raw string literal
json: error: <stdin>:1:12: r"bar(foo)b
json: error: <stdin>:1:12:            ^
command failed: echo -n '\''r"bar(foo)b'\''|json -b1
$ echo -n '\''r"bar(foo)b)'\''|json -b1
json: error: <stdin>:1:13: lex error: invalid raw string literal
json: error: <stdin>:1:13: r"bar(foo)b)
json: error: <stdin>:1:13:             ^
command failed: echo -n '\''r"bar(foo)b)'\''|json -b1
$ echo -n '\''r"bar(foo)b)b'\''|json -b1
json: error: <stdin>:1:14: lex error: invalid raw string literal
json: error: <stdin>:1:14: r"bar(foo)b)b
json: error: <stdin>:1:14:              ^
command failed: echo -n '\''r"bar(foo)b)b'\''|json -b1
$ echo -n '\''r"bar(foo)b)ba'\''|json -b1
json: error: <stdin>:1:15: lex error: invalid raw string literal
json: error: <stdin>:1:15: r"bar(foo)b)ba
json: error: <stdin>:1:15:               ^
command failed: echo -n '\''r"bar(foo)b)ba'\''|json -b1
$ echo -n '\''r"bar(foo)b)bar'\''|json -b1
json: error: <stdin>:1:16: lex error: invalid raw string literal
json: error: <stdin>:1:16: r"bar(foo)b)bar
json: error: <stdin>:1:16:                ^
command failed: echo -n '\''r"bar(foo)b)bar'\''|json -b1
$ echo -n '\''r"bar(foo)b)bar"'\''|json -b1
r"bar(foo)b)bar"
$ echo -n '\''r"bar(foo)ba'\''|json -b1
json: error: <stdin>:1:13: lex error: invalid raw string literal
json: error: <stdin>:1:13: r"bar(foo)ba
json: error: <stdin>:1:13:             ^
command failed: echo -n '\''r"bar(foo)ba'\''|json -b1
$ echo -n '\''r"bar(foo)ba)'\''|json -b1
json: error: <stdin>:1:14: lex error: invalid raw string literal
json: error: <stdin>:1:14: r"bar(foo)ba)
json: error: <stdin>:1:14:              ^
command failed: echo -n '\''r"bar(foo)ba)'\''|json -b1
$ echo -n '\''r"bar(foo)ba)b'\''|json -b1
json: error: <stdin>:1:15: lex error: invalid raw string literal
json: error: <stdin>:1:15: r"bar(foo)ba)b
json: error: <stdin>:1:15:               ^
command failed: echo -n '\''r"bar(foo)ba)b'\''|json -b1
$ echo -n '\''r"bar(foo)ba)ba'\''|json -b1
json: error: <stdin>:1:16: lex error: invalid raw string literal
json: error: <stdin>:1:16: r"bar(foo)ba)ba
json: error: <stdin>:1:16:                ^
command failed: echo -n '\''r"bar(foo)ba)ba'\''|json -b1
$ echo -n '\''r"bar(foo)ba)bar'\''|json -b1
json: error: <stdin>:1:17: lex error: invalid raw string literal
json: error: <stdin>:1:17: r"bar(foo)ba)bar
json: error: <stdin>:1:17:                 ^
command failed: echo -n '\''r"bar(foo)ba)bar'\''|json -b1
$ echo -n '\''r"bar(foo)ba)bar"'\''|json -b1
r"bar(foo)ba)bar"
$ echo -n '\''r"bar(foo)bar'\''|json -b1
json: error: <stdin>:1:14: lex error: invalid raw string literal
json: error: <stdin>:1:14: r"bar(foo)bar
json: error: <stdin>:1:14:              ^
command failed: echo -n '\''r"bar(foo)bar'\''|json -b1
$ echo -n '\''r"bar(foo)bar"'\''|json -b1
r"bar(foo)bar"
$ echo -n '\''r"bar(foo)bar)'\''|json -b1
json: error: <stdin>:1:15: lex error: invalid raw string literal
json: error: <stdin>:1:15: r"bar(foo)bar)
json: error: <stdin>:1:15:               ^
command failed: echo -n '\''r"bar(foo)bar)'\''|json -b1
$ echo -n '\''r"bar(foo)bar)b'\''|json -b1
json: error: <stdin>:1:16: lex error: invalid raw string literal
json: error: <stdin>:1:16: r"bar(foo)bar)b
json: error: <stdin>:1:16:                ^
command failed: echo -n '\''r"bar(foo)bar)b'\''|json -b1
$ echo -n '\''r"bar(foo)bar)ba'\''|json -b1
json: error: <stdin>:1:17: lex error: invalid raw string literal
json: error: <stdin>:1:17: r"bar(foo)bar)ba
json: error: <stdin>:1:17:                 ^
command failed: echo -n '\''r"bar(foo)bar)ba'\''|json -b1
$ echo -n '\''r"bar(foo)bar)bar'\''|json -b1
json: error: <stdin>:1:18: lex error: invalid raw string literal
json: error: <stdin>:1:18: r"bar(foo)bar)bar
json: error: <stdin>:1:18:                  ^
command failed: echo -n '\''r"bar(foo)bar)bar'\''|json -b1
$ echo -n '\''r"bar(foo)bar)bar"'\''|json -b1
r"bar(foo)bar)bar"'
) -L raw-string3.new <(
echo '$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'
json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; } 2>&1 ||
echo 'command failed: json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'

echo '$ json() { json0 --literal-value --raw-strings "$@"; }'
json() { json0 --literal-value --raw-strings "$@"; } 2>&1 ||
echo 'command failed: json() { json0 --literal-value --raw-strings "$@"; }'

echo '$ echo -n '\''r'\''|json -b1'
echo -n 'r'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r'\''|json -b1'

echo '$ echo -n '\''r"'\''|json -b1'
echo -n 'r"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"'\''|json -b1'

echo '$ echo -n '\''r"('\''|json -b1'
echo -n 'r"('|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"('\''|json -b1'

echo '$ echo -n '\''r"()'\''|json -b1'
echo -n 'r"()'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"()'\''|json -b1'

echo '$ echo -n '\''r"()"'\''|json -b1'
echo -n 'r"()"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"()"'\''|json -b1'

echo '$ echo -n '\''r"())'\''|json -b1'
echo -n 'r"())'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"())'\''|json -b1'

echo '$ echo -n '\''r"())"'\''|json -b1'
echo -n 'r"())"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"())"'\''|json -b1'

echo '$ echo -n '\''r"(f'\''|json -b1'
echo -n 'r"(f'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"(f'\''|json -b1'

echo '$ echo -n '\''r"(fo'\''|json -b1'
echo -n 'r"(fo'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"(fo'\''|json -b1'

echo '$ echo -n '\''r"(foo'\''|json -b1'
echo -n 'r"(foo'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"(foo'\''|json -b1'

echo '$ echo -n '\''r"(foo)'\''|json -b1'
echo -n 'r"(foo)'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"(foo)'\''|json -b1'

echo '$ echo -n '\''r"(foo)"'\''|json -b1'
echo -n 'r"(foo)"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"(foo)"'\''|json -b1'

echo '$ echo -n '\''r"(foo))'\''|json -b1'
echo -n 'r"(foo))'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"(foo))'\''|json -b1'

echo '$ echo -n '\''r"(foo))"'\''|json -b1'
echo -n 'r"(foo))"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"(foo))"'\''|json -b1'

echo '$ echo -n '\''r"0'\''|json -b1'
echo -n 'r"0'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0'\''|json -b1'

echo '$ echo -n '\''r"01'\''|json -b1'
echo -n 'r"01'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"01'\''|json -b1'

echo '$ echo -n '\''r"012'\''|json -b1'
echo -n 'r"012'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"012'\''|json -b1'

echo '$ echo -n '\''r"0123'\''|json -b1'
echo -n 'r"0123'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123'\''|json -b1'

echo '$ echo -n '\''r"01234'\''|json -b1'
echo -n 'r"01234'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"01234'\''|json -b1'

echo '$ echo -n '\''r"012345'\''|json -b1'
echo -n 'r"012345'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"012345'\''|json -b1'

echo '$ echo -n '\''r"0123456'\''|json -b1'
echo -n 'r"0123456'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456'\''|json -b1'

echo '$ echo -n '\''r"01234567'\''|json -b1'
echo -n 'r"01234567'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"01234567'\''|json -b1'

echo '$ echo -n '\''r"012345678'\''|json -b1'
echo -n 'r"012345678'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"012345678'\''|json -b1'

echo '$ echo -n '\''r"0123456789'\''|json -b1'
echo -n 'r"0123456789'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789'\''|json -b1'

echo '$ echo -n '\''r"0123456789a'\''|json -b1'
echo -n 'r"0123456789a'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789a'\''|json -b1'

echo '$ echo -n '\''r"0123456789ab'\''|json -b1'
echo -n 'r"0123456789ab'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789ab'\''|json -b1'

echo '$ echo -n '\''r"0123456789abc'\''|json -b1'
echo -n 'r"0123456789abc'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abc'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcd'\''|json -b1'
echo -n 'r"0123456789abcd'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcd'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcde'\''|json -b1'
echo -n 'r"0123456789abcde'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcde'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef'\''|json -b1'
echo -n 'r"0123456789abcdef'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef('\''|json -b1'
echo -n 'r"0123456789abcdef('|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef('\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()'\''|json -b1'
echo -n 'r"0123456789abcdef()'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef())'\''|json -b1'
echo -n 'r"0123456789abcdef())'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef())'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef())0'\''|json -b1'
echo -n 'r"0123456789abcdef())0'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef())0'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef())01'\''|json -b1'
echo -n 'r"0123456789abcdef())01'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef())01'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef())012'\''|json -b1'
echo -n 'r"0123456789abcdef())012'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef())012'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef())0123'\''|json -b1'
echo -n 'r"0123456789abcdef())0123'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef())0123'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef())01234'\''|json -b1'
echo -n 'r"0123456789abcdef())01234'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef())01234'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef())012345'\''|json -b1'
echo -n 'r"0123456789abcdef())012345'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef())012345'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef())0123456'\''|json -b1'
echo -n 'r"0123456789abcdef())0123456'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef())0123456'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef())01234567'\''|json -b1'
echo -n 'r"0123456789abcdef())01234567'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef())01234567'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef())012345678'\''|json -b1'
echo -n 'r"0123456789abcdef())012345678'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef())012345678'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef())0123456789'\''|json -b1'
echo -n 'r"0123456789abcdef())0123456789'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef())0123456789'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef())0123456789a'\''|json -b1'
echo -n 'r"0123456789abcdef())0123456789a'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef())0123456789a'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef())0123456789ab'\''|json -b1'
echo -n 'r"0123456789abcdef())0123456789ab'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef())0123456789ab'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef())0123456789abc'\''|json -b1'
echo -n 'r"0123456789abcdef())0123456789abc'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef())0123456789abc'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef())0123456789abcd'\''|json -b1'
echo -n 'r"0123456789abcdef())0123456789abcd'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef())0123456789abcd'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef())0123456789abcde'\''|json -b1'
echo -n 'r"0123456789abcdef())0123456789abcde'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef())0123456789abcde'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef())0123456789abcdef'\''|json -b1'
echo -n 'r"0123456789abcdef())0123456789abcdef'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef())0123456789abcdef'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef())0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef())0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef())0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0'\''|json -b1'
echo -n 'r"0123456789abcdef()0'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0)'\''|json -b1'
echo -n 'r"0123456789abcdef()0)'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0)'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0)0'\''|json -b1'
echo -n 'r"0123456789abcdef()0)0'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0)0'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0)01'\''|json -b1'
echo -n 'r"0123456789abcdef()0)01'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0)01'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0)012'\''|json -b1'
echo -n 'r"0123456789abcdef()0)012'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0)012'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0)0123'\''|json -b1'
echo -n 'r"0123456789abcdef()0)0123'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0)0123'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0)01234'\''|json -b1'
echo -n 'r"0123456789abcdef()0)01234'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0)01234'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0)012345'\''|json -b1'
echo -n 'r"0123456789abcdef()0)012345'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0)012345'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0)0123456'\''|json -b1'
echo -n 'r"0123456789abcdef()0)0123456'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0)0123456'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0)01234567'\''|json -b1'
echo -n 'r"0123456789abcdef()0)01234567'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0)01234567'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0)012345678'\''|json -b1'
echo -n 'r"0123456789abcdef()0)012345678'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0)012345678'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0)0123456789'\''|json -b1'
echo -n 'r"0123456789abcdef()0)0123456789'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0)0123456789'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0)0123456789a'\''|json -b1'
echo -n 'r"0123456789abcdef()0)0123456789a'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0)0123456789a'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0)0123456789ab'\''|json -b1'
echo -n 'r"0123456789abcdef()0)0123456789ab'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0)0123456789ab'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0)0123456789abc'\''|json -b1'
echo -n 'r"0123456789abcdef()0)0123456789abc'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0)0123456789abc'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0)0123456789abcd'\''|json -b1'
echo -n 'r"0123456789abcdef()0)0123456789abcd'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0)0123456789abcd'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0)0123456789abcde'\''|json -b1'
echo -n 'r"0123456789abcdef()0)0123456789abcde'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0)0123456789abcde'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0)0123456789abcdef'\''|json -b1'
echo -n 'r"0123456789abcdef()0)0123456789abcdef'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0)0123456789abcdef'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0)0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef()0)0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0)0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()01'\''|json -b1'
echo -n 'r"0123456789abcdef()01'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()01)'\''|json -b1'
echo -n 'r"0123456789abcdef()01)'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01)'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()01)0'\''|json -b1'
echo -n 'r"0123456789abcdef()01)0'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01)0'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()01)01'\''|json -b1'
echo -n 'r"0123456789abcdef()01)01'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01)01'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()01)012'\''|json -b1'
echo -n 'r"0123456789abcdef()01)012'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01)012'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()01)0123'\''|json -b1'
echo -n 'r"0123456789abcdef()01)0123'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01)0123'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()01)01234'\''|json -b1'
echo -n 'r"0123456789abcdef()01)01234'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01)01234'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()01)012345'\''|json -b1'
echo -n 'r"0123456789abcdef()01)012345'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01)012345'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()01)0123456'\''|json -b1'
echo -n 'r"0123456789abcdef()01)0123456'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01)0123456'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()01)01234567'\''|json -b1'
echo -n 'r"0123456789abcdef()01)01234567'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01)01234567'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()01)012345678'\''|json -b1'
echo -n 'r"0123456789abcdef()01)012345678'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01)012345678'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()01)0123456789'\''|json -b1'
echo -n 'r"0123456789abcdef()01)0123456789'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01)0123456789'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()01)0123456789a'\''|json -b1'
echo -n 'r"0123456789abcdef()01)0123456789a'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01)0123456789a'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()01)0123456789ab'\''|json -b1'
echo -n 'r"0123456789abcdef()01)0123456789ab'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01)0123456789ab'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()01)0123456789abc'\''|json -b1'
echo -n 'r"0123456789abcdef()01)0123456789abc'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01)0123456789abc'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()01)0123456789abcd'\''|json -b1'
echo -n 'r"0123456789abcdef()01)0123456789abcd'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01)0123456789abcd'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()01)0123456789abcde'\''|json -b1'
echo -n 'r"0123456789abcdef()01)0123456789abcde'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01)0123456789abcde'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()01)0123456789abcdef'\''|json -b1'
echo -n 'r"0123456789abcdef()01)0123456789abcdef'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01)0123456789abcdef'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()01)0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef()01)0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01)0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()012'\''|json -b1'
echo -n 'r"0123456789abcdef()012'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()012)'\''|json -b1'
echo -n 'r"0123456789abcdef()012)'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012)'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()012)0'\''|json -b1'
echo -n 'r"0123456789abcdef()012)0'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012)0'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()012)01'\''|json -b1'
echo -n 'r"0123456789abcdef()012)01'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012)01'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()012)012'\''|json -b1'
echo -n 'r"0123456789abcdef()012)012'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012)012'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()012)0123'\''|json -b1'
echo -n 'r"0123456789abcdef()012)0123'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012)0123'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()012)01234'\''|json -b1'
echo -n 'r"0123456789abcdef()012)01234'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012)01234'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()012)012345'\''|json -b1'
echo -n 'r"0123456789abcdef()012)012345'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012)012345'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()012)0123456'\''|json -b1'
echo -n 'r"0123456789abcdef()012)0123456'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012)0123456'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()012)01234567'\''|json -b1'
echo -n 'r"0123456789abcdef()012)01234567'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012)01234567'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()012)012345678'\''|json -b1'
echo -n 'r"0123456789abcdef()012)012345678'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012)012345678'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()012)0123456789'\''|json -b1'
echo -n 'r"0123456789abcdef()012)0123456789'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012)0123456789'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()012)0123456789a'\''|json -b1'
echo -n 'r"0123456789abcdef()012)0123456789a'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012)0123456789a'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()012)0123456789ab'\''|json -b1'
echo -n 'r"0123456789abcdef()012)0123456789ab'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012)0123456789ab'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()012)0123456789abc'\''|json -b1'
echo -n 'r"0123456789abcdef()012)0123456789abc'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012)0123456789abc'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()012)0123456789abcd'\''|json -b1'
echo -n 'r"0123456789abcdef()012)0123456789abcd'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012)0123456789abcd'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()012)0123456789abcde'\''|json -b1'
echo -n 'r"0123456789abcdef()012)0123456789abcde'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012)0123456789abcde'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()012)0123456789abcdef'\''|json -b1'
echo -n 'r"0123456789abcdef()012)0123456789abcdef'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012)0123456789abcdef'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()012)0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef()012)0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012)0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123'\''|json -b1'
echo -n 'r"0123456789abcdef()0123'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123)'\''|json -b1'
echo -n 'r"0123456789abcdef()0123)'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123)'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123)0'\''|json -b1'
echo -n 'r"0123456789abcdef()0123)0'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123)0'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123)01'\''|json -b1'
echo -n 'r"0123456789abcdef()0123)01'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123)01'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123)012'\''|json -b1'
echo -n 'r"0123456789abcdef()0123)012'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123)012'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123)0123'\''|json -b1'
echo -n 'r"0123456789abcdef()0123)0123'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123)0123'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123)01234'\''|json -b1'
echo -n 'r"0123456789abcdef()0123)01234'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123)01234'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123)012345'\''|json -b1'
echo -n 'r"0123456789abcdef()0123)012345'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123)012345'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123)0123456'\''|json -b1'
echo -n 'r"0123456789abcdef()0123)0123456'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123)0123456'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123)01234567'\''|json -b1'
echo -n 'r"0123456789abcdef()0123)01234567'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123)01234567'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123)012345678'\''|json -b1'
echo -n 'r"0123456789abcdef()0123)012345678'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123)012345678'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123)0123456789'\''|json -b1'
echo -n 'r"0123456789abcdef()0123)0123456789'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123)0123456789'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123)0123456789a'\''|json -b1'
echo -n 'r"0123456789abcdef()0123)0123456789a'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123)0123456789a'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123)0123456789ab'\''|json -b1'
echo -n 'r"0123456789abcdef()0123)0123456789ab'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123)0123456789ab'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123)0123456789abc'\''|json -b1'
echo -n 'r"0123456789abcdef()0123)0123456789abc'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123)0123456789abc'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123)0123456789abcd'\''|json -b1'
echo -n 'r"0123456789abcdef()0123)0123456789abcd'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123)0123456789abcd'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123)0123456789abcde'\''|json -b1'
echo -n 'r"0123456789abcdef()0123)0123456789abcde'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123)0123456789abcde'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123)0123456789abcdef'\''|json -b1'
echo -n 'r"0123456789abcdef()0123)0123456789abcdef'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123)0123456789abcdef'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123)0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef()0123)0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123)0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()01234'\''|json -b1'
echo -n 'r"0123456789abcdef()01234'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01234'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()01234)'\''|json -b1'
echo -n 'r"0123456789abcdef()01234)'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01234)'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()01234)0'\''|json -b1'
echo -n 'r"0123456789abcdef()01234)0'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01234)0'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()01234)01'\''|json -b1'
echo -n 'r"0123456789abcdef()01234)01'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01234)01'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()01234)012'\''|json -b1'
echo -n 'r"0123456789abcdef()01234)012'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01234)012'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()01234)0123'\''|json -b1'
echo -n 'r"0123456789abcdef()01234)0123'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01234)0123'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()01234)01234'\''|json -b1'
echo -n 'r"0123456789abcdef()01234)01234'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01234)01234'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()01234)012345'\''|json -b1'
echo -n 'r"0123456789abcdef()01234)012345'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01234)012345'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()01234)0123456'\''|json -b1'
echo -n 'r"0123456789abcdef()01234)0123456'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01234)0123456'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()01234)01234567'\''|json -b1'
echo -n 'r"0123456789abcdef()01234)01234567'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01234)01234567'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()01234)012345678'\''|json -b1'
echo -n 'r"0123456789abcdef()01234)012345678'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01234)012345678'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()01234)0123456789'\''|json -b1'
echo -n 'r"0123456789abcdef()01234)0123456789'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01234)0123456789'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()01234)0123456789a'\''|json -b1'
echo -n 'r"0123456789abcdef()01234)0123456789a'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01234)0123456789a'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()01234)0123456789ab'\''|json -b1'
echo -n 'r"0123456789abcdef()01234)0123456789ab'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01234)0123456789ab'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()01234)0123456789abc'\''|json -b1'
echo -n 'r"0123456789abcdef()01234)0123456789abc'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01234)0123456789abc'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()01234)0123456789abcd'\''|json -b1'
echo -n 'r"0123456789abcdef()01234)0123456789abcd'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01234)0123456789abcd'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()01234)0123456789abcde'\''|json -b1'
echo -n 'r"0123456789abcdef()01234)0123456789abcde'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01234)0123456789abcde'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()01234)0123456789abcdef'\''|json -b1'
echo -n 'r"0123456789abcdef()01234)0123456789abcdef'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01234)0123456789abcdef'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()01234)0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef()01234)0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01234)0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()012345'\''|json -b1'
echo -n 'r"0123456789abcdef()012345'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012345'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()012345)'\''|json -b1'
echo -n 'r"0123456789abcdef()012345)'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012345)'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()012345)0'\''|json -b1'
echo -n 'r"0123456789abcdef()012345)0'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012345)0'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()012345)01'\''|json -b1'
echo -n 'r"0123456789abcdef()012345)01'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012345)01'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()012345)012'\''|json -b1'
echo -n 'r"0123456789abcdef()012345)012'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012345)012'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()012345)0123'\''|json -b1'
echo -n 'r"0123456789abcdef()012345)0123'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012345)0123'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()012345)01234'\''|json -b1'
echo -n 'r"0123456789abcdef()012345)01234'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012345)01234'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()012345)012345'\''|json -b1'
echo -n 'r"0123456789abcdef()012345)012345'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012345)012345'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()012345)0123456'\''|json -b1'
echo -n 'r"0123456789abcdef()012345)0123456'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012345)0123456'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()012345)01234567'\''|json -b1'
echo -n 'r"0123456789abcdef()012345)01234567'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012345)01234567'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()012345)012345678'\''|json -b1'
echo -n 'r"0123456789abcdef()012345)012345678'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012345)012345678'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()012345)0123456789'\''|json -b1'
echo -n 'r"0123456789abcdef()012345)0123456789'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012345)0123456789'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()012345)0123456789a'\''|json -b1'
echo -n 'r"0123456789abcdef()012345)0123456789a'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012345)0123456789a'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()012345)0123456789ab'\''|json -b1'
echo -n 'r"0123456789abcdef()012345)0123456789ab'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012345)0123456789ab'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()012345)0123456789abc'\''|json -b1'
echo -n 'r"0123456789abcdef()012345)0123456789abc'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012345)0123456789abc'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()012345)0123456789abcd'\''|json -b1'
echo -n 'r"0123456789abcdef()012345)0123456789abcd'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012345)0123456789abcd'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()012345)0123456789abcde'\''|json -b1'
echo -n 'r"0123456789abcdef()012345)0123456789abcde'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012345)0123456789abcde'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()012345)0123456789abcdef'\''|json -b1'
echo -n 'r"0123456789abcdef()012345)0123456789abcdef'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012345)0123456789abcdef'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()012345)0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef()012345)0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012345)0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456)'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456)'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456)'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456)0'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456)0'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456)0'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456)01'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456)01'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456)01'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456)012'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456)012'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456)012'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456)0123'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456)0123'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456)0123'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456)01234'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456)01234'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456)01234'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456)012345'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456)012345'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456)012345'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456)0123456'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456)0123456'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456)0123456'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456)01234567'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456)01234567'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456)01234567'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456)012345678'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456)012345678'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456)012345678'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456)0123456789'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456)0123456789'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456)0123456789'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456)0123456789a'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456)0123456789a'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456)0123456789a'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456)0123456789ab'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456)0123456789ab'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456)0123456789ab'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456)0123456789abc'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456)0123456789abc'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456)0123456789abc'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456)0123456789abcd'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456)0123456789abcd'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456)0123456789abcd'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456)0123456789abcde'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456)0123456789abcde'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456)0123456789abcde'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456)0123456789abcdef'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456)0123456789abcdef'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456)0123456789abcdef'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456)0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456)0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456)0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()01234567'\''|json -b1'
echo -n 'r"0123456789abcdef()01234567'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01234567'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()01234567)'\''|json -b1'
echo -n 'r"0123456789abcdef()01234567)'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01234567)'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()01234567)0'\''|json -b1'
echo -n 'r"0123456789abcdef()01234567)0'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01234567)0'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()01234567)01'\''|json -b1'
echo -n 'r"0123456789abcdef()01234567)01'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01234567)01'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()01234567)012'\''|json -b1'
echo -n 'r"0123456789abcdef()01234567)012'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01234567)012'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()01234567)0123'\''|json -b1'
echo -n 'r"0123456789abcdef()01234567)0123'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01234567)0123'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()01234567)01234'\''|json -b1'
echo -n 'r"0123456789abcdef()01234567)01234'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01234567)01234'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()01234567)012345'\''|json -b1'
echo -n 'r"0123456789abcdef()01234567)012345'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01234567)012345'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()01234567)0123456'\''|json -b1'
echo -n 'r"0123456789abcdef()01234567)0123456'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01234567)0123456'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()01234567)01234567'\''|json -b1'
echo -n 'r"0123456789abcdef()01234567)01234567'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01234567)01234567'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()01234567)012345678'\''|json -b1'
echo -n 'r"0123456789abcdef()01234567)012345678'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01234567)012345678'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()01234567)0123456789'\''|json -b1'
echo -n 'r"0123456789abcdef()01234567)0123456789'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01234567)0123456789'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()01234567)0123456789a'\''|json -b1'
echo -n 'r"0123456789abcdef()01234567)0123456789a'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01234567)0123456789a'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()01234567)0123456789ab'\''|json -b1'
echo -n 'r"0123456789abcdef()01234567)0123456789ab'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01234567)0123456789ab'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()01234567)0123456789abc'\''|json -b1'
echo -n 'r"0123456789abcdef()01234567)0123456789abc'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01234567)0123456789abc'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()01234567)0123456789abcd'\''|json -b1'
echo -n 'r"0123456789abcdef()01234567)0123456789abcd'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01234567)0123456789abcd'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()01234567)0123456789abcde'\''|json -b1'
echo -n 'r"0123456789abcdef()01234567)0123456789abcde'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01234567)0123456789abcde'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()01234567)0123456789abcdef'\''|json -b1'
echo -n 'r"0123456789abcdef()01234567)0123456789abcdef'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01234567)0123456789abcdef'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()01234567)0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef()01234567)0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()01234567)0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()012345678'\''|json -b1'
echo -n 'r"0123456789abcdef()012345678'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012345678'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()012345678)'\''|json -b1'
echo -n 'r"0123456789abcdef()012345678)'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012345678)'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()012345678)0'\''|json -b1'
echo -n 'r"0123456789abcdef()012345678)0'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012345678)0'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()012345678)01'\''|json -b1'
echo -n 'r"0123456789abcdef()012345678)01'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012345678)01'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()012345678)012'\''|json -b1'
echo -n 'r"0123456789abcdef()012345678)012'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012345678)012'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()012345678)0123'\''|json -b1'
echo -n 'r"0123456789abcdef()012345678)0123'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012345678)0123'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()012345678)01234'\''|json -b1'
echo -n 'r"0123456789abcdef()012345678)01234'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012345678)01234'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()012345678)012345'\''|json -b1'
echo -n 'r"0123456789abcdef()012345678)012345'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012345678)012345'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()012345678)0123456'\''|json -b1'
echo -n 'r"0123456789abcdef()012345678)0123456'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012345678)0123456'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()012345678)01234567'\''|json -b1'
echo -n 'r"0123456789abcdef()012345678)01234567'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012345678)01234567'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()012345678)012345678'\''|json -b1'
echo -n 'r"0123456789abcdef()012345678)012345678'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012345678)012345678'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()012345678)0123456789'\''|json -b1'
echo -n 'r"0123456789abcdef()012345678)0123456789'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012345678)0123456789'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()012345678)0123456789a'\''|json -b1'
echo -n 'r"0123456789abcdef()012345678)0123456789a'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012345678)0123456789a'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()012345678)0123456789ab'\''|json -b1'
echo -n 'r"0123456789abcdef()012345678)0123456789ab'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012345678)0123456789ab'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()012345678)0123456789abc'\''|json -b1'
echo -n 'r"0123456789abcdef()012345678)0123456789abc'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012345678)0123456789abc'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()012345678)0123456789abcd'\''|json -b1'
echo -n 'r"0123456789abcdef()012345678)0123456789abcd'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012345678)0123456789abcd'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()012345678)0123456789abcde'\''|json -b1'
echo -n 'r"0123456789abcdef()012345678)0123456789abcde'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012345678)0123456789abcde'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()012345678)0123456789abcdef'\''|json -b1'
echo -n 'r"0123456789abcdef()012345678)0123456789abcdef'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012345678)0123456789abcdef'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()012345678)0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef()012345678)0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()012345678)0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789)'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789)'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789)'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789)0'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789)0'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789)0'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789)01'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789)01'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789)01'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789)012'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789)012'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789)012'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789)0123'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789)0123'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789)0123'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789)01234'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789)01234'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789)01234'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789)012345'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789)012345'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789)012345'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789)0123456'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789)0123456'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789)0123456'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789)01234567'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789)01234567'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789)01234567'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789)012345678'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789)012345678'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789)012345678'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789)0123456789'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789)0123456789'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789)0123456789'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789)0123456789a'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789)0123456789a'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789)0123456789a'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789)0123456789ab'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789)0123456789ab'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789)0123456789ab'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789)0123456789abc'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789)0123456789abc'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789)0123456789abc'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789)0123456789abcd'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789)0123456789abcd'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789)0123456789abcd'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789)0123456789abcde'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789)0123456789abcde'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789)0123456789abcde'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789)0123456789abcdef'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789)0123456789abcdef'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789)0123456789abcdef'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789)0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789)0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789)0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789a'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789a'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789a'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789a)'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789a)'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789a)'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789a)0'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789a)0'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789a)0'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789a)01'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789a)01'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789a)01'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789a)012'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789a)012'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789a)012'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789a)0123'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789a)0123'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789a)0123'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789a)01234'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789a)01234'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789a)01234'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789a)012345'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789a)012345'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789a)012345'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789a)0123456'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789a)0123456'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789a)0123456'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789a)01234567'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789a)01234567'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789a)01234567'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789a)012345678'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789a)012345678'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789a)012345678'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789a)0123456789'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789a)0123456789'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789a)0123456789'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789a)0123456789a'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789a)0123456789a'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789a)0123456789a'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789a)0123456789ab'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789a)0123456789ab'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789a)0123456789ab'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789a)0123456789abc'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789a)0123456789abc'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789a)0123456789abc'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789a)0123456789abcd'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789a)0123456789abcd'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789a)0123456789abcd'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789a)0123456789abcde'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789a)0123456789abcde'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789a)0123456789abcde'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789a)0123456789abcdef'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789a)0123456789abcdef'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789a)0123456789abcdef'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789a)0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789a)0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789a)0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789ab'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789ab'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789ab'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789ab)'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789ab)'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789ab)'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789ab)0'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789ab)0'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789ab)0'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789ab)01'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789ab)01'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789ab)01'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789ab)012'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789ab)012'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789ab)012'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789ab)0123'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789ab)0123'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789ab)0123'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789ab)01234'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789ab)01234'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789ab)01234'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789ab)012345'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789ab)012345'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789ab)012345'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789ab)0123456'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789ab)0123456'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789ab)0123456'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789ab)01234567'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789ab)01234567'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789ab)01234567'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789ab)012345678'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789ab)012345678'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789ab)012345678'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789ab)0123456789'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789ab)0123456789'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789ab)0123456789'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789ab)0123456789a'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789ab)0123456789a'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789ab)0123456789a'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789ab)0123456789ab'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789ab)0123456789ab'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789ab)0123456789ab'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789ab)0123456789abc'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789ab)0123456789abc'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789ab)0123456789abc'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789ab)0123456789abcd'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789ab)0123456789abcd'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789ab)0123456789abcd'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789ab)0123456789abcde'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789ab)0123456789abcde'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789ab)0123456789abcde'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789ab)0123456789abcdef'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789ab)0123456789abcdef'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789ab)0123456789abcdef'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789ab)0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789ab)0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789ab)0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abc'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abc'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abc'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abc)'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abc)'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abc)'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abc)0'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abc)0'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abc)0'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abc)01'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abc)01'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abc)01'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abc)012'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abc)012'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abc)012'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abc)0123'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abc)0123'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abc)0123'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abc)01234'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abc)01234'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abc)01234'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abc)012345'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abc)012345'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abc)012345'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abc)0123456'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abc)0123456'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abc)0123456'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abc)01234567'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abc)01234567'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abc)01234567'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abc)012345678'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abc)012345678'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abc)012345678'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abc)0123456789'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abc)0123456789'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abc)0123456789'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abc)0123456789a'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abc)0123456789a'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abc)0123456789a'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abc)0123456789ab'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abc)0123456789ab'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abc)0123456789ab'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abc)0123456789abc'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abc)0123456789abc'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abc)0123456789abc'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abc)0123456789abcd'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abc)0123456789abcd'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abc)0123456789abcd'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abc)0123456789abcde'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abc)0123456789abcde'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abc)0123456789abcde'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abc)0123456789abcdef'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abc)0123456789abcdef'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abc)0123456789abcdef'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abc)0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abc)0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abc)0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcd'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abcd'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcd'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcd)'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abcd)'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcd)'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcd)0'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abcd)0'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcd)0'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcd)01'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abcd)01'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcd)01'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcd)012'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abcd)012'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcd)012'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcd)0123'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abcd)0123'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcd)0123'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcd)01234'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abcd)01234'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcd)01234'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcd)012345'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abcd)012345'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcd)012345'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcd)0123456'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abcd)0123456'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcd)0123456'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcd)01234567'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abcd)01234567'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcd)01234567'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcd)012345678'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abcd)012345678'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcd)012345678'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcd)0123456789'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abcd)0123456789'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcd)0123456789'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcd)0123456789a'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abcd)0123456789a'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcd)0123456789a'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcd)0123456789ab'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abcd)0123456789ab'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcd)0123456789ab'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcd)0123456789abc'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abcd)0123456789abc'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcd)0123456789abc'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcd)0123456789abcd'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abcd)0123456789abcd'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcd)0123456789abcd'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcd)0123456789abcde'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abcd)0123456789abcde'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcd)0123456789abcde'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcd)0123456789abcdef'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abcd)0123456789abcdef'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcd)0123456789abcdef'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcd)0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abcd)0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcd)0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcde'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abcde'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcde'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcde)'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abcde)'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcde)'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcde)0'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abcde)0'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcde)0'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcde)01'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abcde)01'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcde)01'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcde)012'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abcde)012'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcde)012'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcde)0123'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abcde)0123'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcde)0123'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcde)01234'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abcde)01234'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcde)01234'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcde)012345'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abcde)012345'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcde)012345'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcde)0123456'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abcde)0123456'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcde)0123456'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcde)01234567'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abcde)01234567'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcde)01234567'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcde)012345678'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abcde)012345678'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcde)012345678'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcde)0123456789'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abcde)0123456789'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcde)0123456789'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcde)0123456789a'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abcde)0123456789a'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcde)0123456789a'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcde)0123456789ab'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abcde)0123456789ab'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcde)0123456789ab'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcde)0123456789abc'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abcde)0123456789abc'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcde)0123456789abc'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcde)0123456789abcd'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abcde)0123456789abcd'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcde)0123456789abcd'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcde)0123456789abcde'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abcde)0123456789abcde'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcde)0123456789abcde'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcde)0123456789abcdef'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abcde)0123456789abcdef'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcde)0123456789abcdef'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcde)0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abcde)0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcde)0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcdef'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abcdef'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcdef'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcdef)'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abcdef)'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcdef)'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcdef)0'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abcdef)0'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcdef)0'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcdef)01'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abcdef)01'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcdef)01'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcdef)012'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abcdef)012'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcdef)012'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcdef)0123'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abcdef)0123'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcdef)0123'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcdef)01234'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abcdef)01234'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcdef)01234'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcdef)012345'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abcdef)012345'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcdef)012345'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcdef)0123456'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abcdef)0123456'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcdef)0123456'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcdef)01234567'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abcdef)01234567'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcdef)01234567'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcdef)012345678'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abcdef)012345678'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcdef)012345678'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcdef)0123456789'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abcdef)0123456789'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcdef)0123456789'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcdef)0123456789a'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abcdef)0123456789a'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcdef)0123456789a'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcdef)0123456789ab'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abcdef)0123456789ab'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcdef)0123456789ab'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcdef)0123456789abc'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abcdef)0123456789abc'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcdef)0123456789abc'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcdef)0123456789abcd'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abcdef)0123456789abcd'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcdef)0123456789abcd'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcdef)0123456789abcde'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abcdef)0123456789abcde'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcdef)0123456789abcde'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcdef)0123456789abcdef'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abcdef)0123456789abcdef'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcdef)0123456789abcdef'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef()0123456789abcdef)0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef()0123456789abcdef)0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef()0123456789abcdef)0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(f'\''|json -b1'
echo -n 'r"0123456789abcdef(f'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(f'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(fo'\''|json -b1'
echo -n 'r"0123456789abcdef(fo'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(fo'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo'\''|json -b1'
echo -n 'r"0123456789abcdef(foo'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo))'\''|json -b1'
echo -n 'r"0123456789abcdef(foo))'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo))'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo))0'\''|json -b1'
echo -n 'r"0123456789abcdef(foo))0'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo))0'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo))01'\''|json -b1'
echo -n 'r"0123456789abcdef(foo))01'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo))01'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo))012'\''|json -b1'
echo -n 'r"0123456789abcdef(foo))012'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo))012'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo))0123'\''|json -b1'
echo -n 'r"0123456789abcdef(foo))0123'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo))0123'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo))01234'\''|json -b1'
echo -n 'r"0123456789abcdef(foo))01234'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo))01234'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo))012345'\''|json -b1'
echo -n 'r"0123456789abcdef(foo))012345'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo))012345'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo))0123456'\''|json -b1'
echo -n 'r"0123456789abcdef(foo))0123456'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo))0123456'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo))01234567'\''|json -b1'
echo -n 'r"0123456789abcdef(foo))01234567'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo))01234567'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo))012345678'\''|json -b1'
echo -n 'r"0123456789abcdef(foo))012345678'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo))012345678'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo))0123456789'\''|json -b1'
echo -n 'r"0123456789abcdef(foo))0123456789'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo))0123456789'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo))0123456789a'\''|json -b1'
echo -n 'r"0123456789abcdef(foo))0123456789a'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo))0123456789a'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo))0123456789ab'\''|json -b1'
echo -n 'r"0123456789abcdef(foo))0123456789ab'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo))0123456789ab'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo))0123456789abc'\''|json -b1'
echo -n 'r"0123456789abcdef(foo))0123456789abc'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo))0123456789abc'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo))0123456789abcd'\''|json -b1'
echo -n 'r"0123456789abcdef(foo))0123456789abcd'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo))0123456789abcd'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo))0123456789abcde'\''|json -b1'
echo -n 'r"0123456789abcdef(foo))0123456789abcde'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo))0123456789abcde'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo))0123456789abcdef'\''|json -b1'
echo -n 'r"0123456789abcdef(foo))0123456789abcdef'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo))0123456789abcdef'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo))0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef(foo))0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo))0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0)'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0)'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0)'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0)0'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0)0'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0)0'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0)01'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0)01'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0)01'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0)012'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0)012'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0)012'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0)0123'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0)0123'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0)0123'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0)01234'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0)01234'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0)01234'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0)012345'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0)012345'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0)012345'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0)0123456'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0)0123456'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0)0123456'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0)01234567'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0)01234567'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0)01234567'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0)012345678'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0)012345678'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0)012345678'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0)0123456789'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0)0123456789'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0)0123456789'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0)0123456789a'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0)0123456789a'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0)0123456789a'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0)0123456789ab'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0)0123456789ab'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0)0123456789ab'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0)0123456789abc'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0)0123456789abc'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0)0123456789abc'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0)0123456789abcd'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0)0123456789abcd'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0)0123456789abcd'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0)0123456789abcde'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0)0123456789abcde'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0)0123456789abcde'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0)0123456789abcdef'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0)0123456789abcdef'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0)0123456789abcdef'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0)0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0)0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0)0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)01'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)01'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)01)'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)01)'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01)'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)01)0'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)01)0'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01)0'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)01)01'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)01)01'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01)01'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)01)012'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)01)012'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01)012'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)01)0123'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)01)0123'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01)0123'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)01)01234'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)01)01234'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01)01234'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)01)012345'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)01)012345'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01)012345'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)01)0123456'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)01)0123456'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01)0123456'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)01)01234567'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)01)01234567'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01)01234567'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)01)012345678'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)01)012345678'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01)012345678'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)01)0123456789'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)01)0123456789'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01)0123456789'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)01)0123456789a'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)01)0123456789a'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01)0123456789a'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)01)0123456789ab'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)01)0123456789ab'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01)0123456789ab'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)01)0123456789abc'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)01)0123456789abc'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01)0123456789abc'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)01)0123456789abcd'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)01)0123456789abcd'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01)0123456789abcd'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)01)0123456789abcde'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)01)0123456789abcde'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01)0123456789abcde'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)01)0123456789abcdef'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)01)0123456789abcdef'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01)0123456789abcdef'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)01)0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)01)0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01)0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)012'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)012'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)012)'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)012)'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012)'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)012)0'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)012)0'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012)0'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)012)01'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)012)01'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012)01'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)012)012'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)012)012'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012)012'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)012)0123'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)012)0123'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012)0123'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)012)01234'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)012)01234'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012)01234'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)012)012345'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)012)012345'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012)012345'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)012)0123456'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)012)0123456'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012)0123456'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)012)01234567'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)012)01234567'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012)01234567'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)012)012345678'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)012)012345678'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012)012345678'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)012)0123456789'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)012)0123456789'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012)0123456789'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)012)0123456789a'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)012)0123456789a'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012)0123456789a'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)012)0123456789ab'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)012)0123456789ab'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012)0123456789ab'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)012)0123456789abc'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)012)0123456789abc'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012)0123456789abc'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)012)0123456789abcd'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)012)0123456789abcd'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012)0123456789abcd'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)012)0123456789abcde'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)012)0123456789abcde'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012)0123456789abcde'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)012)0123456789abcdef'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)012)0123456789abcdef'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012)0123456789abcdef'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)012)0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)012)0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012)0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123)'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123)'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123)'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123)0'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123)0'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123)0'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123)01'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123)01'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123)01'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123)012'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123)012'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123)012'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123)0123'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123)0123'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123)0123'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123)01234'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123)01234'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123)01234'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123)012345'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123)012345'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123)012345'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123)0123456'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123)0123456'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123)0123456'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123)01234567'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123)01234567'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123)01234567'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123)012345678'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123)012345678'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123)012345678'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123)0123456789'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123)0123456789'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123)0123456789'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123)0123456789a'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123)0123456789a'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123)0123456789a'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123)0123456789ab'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123)0123456789ab'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123)0123456789ab'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123)0123456789abc'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123)0123456789abc'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123)0123456789abc'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123)0123456789abcd'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123)0123456789abcd'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123)0123456789abcd'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123)0123456789abcde'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123)0123456789abcde'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123)0123456789abcde'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123)0123456789abcdef'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123)0123456789abcdef'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123)0123456789abcdef'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123)0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123)0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123)0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)01234'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)01234'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01234'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)01234)'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)01234)'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01234)'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)01234)0'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)01234)0'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01234)0'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)01234)01'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)01234)01'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01234)01'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)01234)012'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)01234)012'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01234)012'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)01234)0123'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)01234)0123'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01234)0123'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)01234)01234'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)01234)01234'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01234)01234'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)01234)012345'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)01234)012345'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01234)012345'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)01234)0123456'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)01234)0123456'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01234)0123456'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)01234)01234567'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)01234)01234567'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01234)01234567'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)01234)012345678'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)01234)012345678'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01234)012345678'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)01234)0123456789'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)01234)0123456789'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01234)0123456789'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)01234)0123456789a'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)01234)0123456789a'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01234)0123456789a'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)01234)0123456789ab'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)01234)0123456789ab'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01234)0123456789ab'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)01234)0123456789abc'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)01234)0123456789abc'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01234)0123456789abc'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)01234)0123456789abcd'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)01234)0123456789abcd'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01234)0123456789abcd'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)01234)0123456789abcde'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)01234)0123456789abcde'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01234)0123456789abcde'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)01234)0123456789abcdef'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)01234)0123456789abcdef'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01234)0123456789abcdef'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)01234)0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)01234)0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01234)0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)012345'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)012345'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012345'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)012345)'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)012345)'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012345)'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)012345)0'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)012345)0'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012345)0'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)012345)01'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)012345)01'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012345)01'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)012345)012'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)012345)012'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012345)012'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)012345)0123'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)012345)0123'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012345)0123'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)012345)01234'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)012345)01234'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012345)01234'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)012345)012345'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)012345)012345'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012345)012345'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)012345)0123456'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)012345)0123456'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012345)0123456'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)012345)01234567'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)012345)01234567'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012345)01234567'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)012345)012345678'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)012345)012345678'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012345)012345678'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)012345)0123456789'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)012345)0123456789'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012345)0123456789'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)012345)0123456789a'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)012345)0123456789a'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012345)0123456789a'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)012345)0123456789ab'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)012345)0123456789ab'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012345)0123456789ab'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)012345)0123456789abc'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)012345)0123456789abc'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012345)0123456789abc'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)012345)0123456789abcd'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)012345)0123456789abcd'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012345)0123456789abcd'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)012345)0123456789abcde'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)012345)0123456789abcde'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012345)0123456789abcde'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)012345)0123456789abcdef'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)012345)0123456789abcdef'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012345)0123456789abcdef'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)012345)0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)012345)0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012345)0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456)'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456)'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456)'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456)0'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456)0'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456)0'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456)01'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456)01'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456)01'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456)012'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456)012'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456)012'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456)0123'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456)0123'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456)0123'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456)01234'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456)01234'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456)01234'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456)012345'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456)012345'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456)012345'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456)0123456'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456)0123456'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456)0123456'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456)01234567'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456)01234567'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456)01234567'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456)012345678'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456)012345678'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456)012345678'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456)0123456789'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456)0123456789'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456)0123456789'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456)0123456789a'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456)0123456789a'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456)0123456789a'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456)0123456789ab'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456)0123456789ab'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456)0123456789ab'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456)0123456789abc'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456)0123456789abc'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456)0123456789abc'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456)0123456789abcd'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456)0123456789abcd'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456)0123456789abcd'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456)0123456789abcde'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456)0123456789abcde'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456)0123456789abcde'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456)0123456789abcdef'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456)0123456789abcdef'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456)0123456789abcdef'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456)0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456)0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456)0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)01234567'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)01234567'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01234567'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)01234567)'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)01234567)'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01234567)'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)01234567)0'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)01234567)0'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01234567)0'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)01234567)01'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)01234567)01'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01234567)01'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)01234567)012'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)01234567)012'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01234567)012'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)01234567)0123'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)01234567)0123'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01234567)0123'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)01234567)01234'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)01234567)01234'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01234567)01234'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)01234567)012345'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)01234567)012345'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01234567)012345'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)01234567)0123456'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)01234567)0123456'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01234567)0123456'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)01234567)01234567'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)01234567)01234567'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01234567)01234567'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)01234567)012345678'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)01234567)012345678'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01234567)012345678'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)01234567)0123456789'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)01234567)0123456789'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01234567)0123456789'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)01234567)0123456789a'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)01234567)0123456789a'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01234567)0123456789a'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)01234567)0123456789ab'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)01234567)0123456789ab'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01234567)0123456789ab'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)01234567)0123456789abc'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)01234567)0123456789abc'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01234567)0123456789abc'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)01234567)0123456789abcd'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)01234567)0123456789abcd'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01234567)0123456789abcd'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)01234567)0123456789abcde'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)01234567)0123456789abcde'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01234567)0123456789abcde'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)01234567)0123456789abcdef'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)01234567)0123456789abcdef'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01234567)0123456789abcdef'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)01234567)0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)01234567)0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)01234567)0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)012345678'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)012345678'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012345678'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)012345678)'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)012345678)'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012345678)'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)012345678)0'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)012345678)0'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012345678)0'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)012345678)01'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)012345678)01'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012345678)01'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)012345678)012'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)012345678)012'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012345678)012'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)012345678)0123'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)012345678)0123'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012345678)0123'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)012345678)01234'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)012345678)01234'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012345678)01234'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)012345678)012345'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)012345678)012345'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012345678)012345'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)012345678)0123456'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)012345678)0123456'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012345678)0123456'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)012345678)01234567'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)012345678)01234567'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012345678)01234567'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)012345678)012345678'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)012345678)012345678'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012345678)012345678'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)012345678)0123456789'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)012345678)0123456789'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012345678)0123456789'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)012345678)0123456789a'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)012345678)0123456789a'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012345678)0123456789a'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)012345678)0123456789ab'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)012345678)0123456789ab'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012345678)0123456789ab'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)012345678)0123456789abc'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)012345678)0123456789abc'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012345678)0123456789abc'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)012345678)0123456789abcd'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)012345678)0123456789abcd'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012345678)0123456789abcd'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)012345678)0123456789abcde'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)012345678)0123456789abcde'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012345678)0123456789abcde'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)012345678)0123456789abcdef'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)012345678)0123456789abcdef'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012345678)0123456789abcdef'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)012345678)0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)012345678)0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)012345678)0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789)'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789)'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789)'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789)0'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789)0'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789)0'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789)01'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789)01'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789)01'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789)012'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789)012'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789)012'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789)0123'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789)0123'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789)0123'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789)01234'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789)01234'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789)01234'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789)012345'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789)012345'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789)012345'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789)0123456'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789)0123456'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789)0123456'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789)01234567'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789)01234567'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789)01234567'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789)012345678'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789)012345678'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789)012345678'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789)0123456789'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789)0123456789'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789)0123456789'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789)0123456789a'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789)0123456789a'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789)0123456789a'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789)0123456789ab'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789)0123456789ab'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789)0123456789ab'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789)0123456789abc'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789)0123456789abc'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789)0123456789abc'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789)0123456789abcd'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789)0123456789abcd'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789)0123456789abcd'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789)0123456789abcde'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789)0123456789abcde'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789)0123456789abcde'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789)0123456789abcdef'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789)0123456789abcdef'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789)0123456789abcdef'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789)0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789)0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789)0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789a'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789a'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789a'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789a)'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789a)'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789a)'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789a)0'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789a)0'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789a)0'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789a)01'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789a)01'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789a)01'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789a)012'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789a)012'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789a)012'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789a)0123'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789a)0123'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789a)0123'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789a)01234'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789a)01234'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789a)01234'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789a)012345'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789a)012345'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789a)012345'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789a)0123456'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789a)0123456'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789a)0123456'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789a)01234567'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789a)01234567'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789a)01234567'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789a)012345678'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789a)012345678'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789a)012345678'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789a)0123456789'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789a)0123456789'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789a)0123456789'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789a)0123456789a'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789a)0123456789a'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789a)0123456789a'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789a)0123456789ab'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789a)0123456789ab'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789a)0123456789ab'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789a)0123456789abc'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789a)0123456789abc'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789a)0123456789abc'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789a)0123456789abcd'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789a)0123456789abcd'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789a)0123456789abcd'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789a)0123456789abcde'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789a)0123456789abcde'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789a)0123456789abcde'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789a)0123456789abcdef'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789a)0123456789abcdef'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789a)0123456789abcdef'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789a)0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789a)0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789a)0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789ab'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789ab'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789ab'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789ab)'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789ab)'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789ab)'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789ab)0'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789ab)0'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789ab)0'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789ab)01'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789ab)01'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789ab)01'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789ab)012'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789ab)012'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789ab)012'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789ab)0123'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789ab)0123'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789ab)0123'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789ab)01234'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789ab)01234'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789ab)01234'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789ab)012345'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789ab)012345'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789ab)012345'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789ab)0123456'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789ab)0123456'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789ab)0123456'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789ab)01234567'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789ab)01234567'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789ab)01234567'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789ab)012345678'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789ab)012345678'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789ab)012345678'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789ab)0123456789'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789ab)0123456789'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789ab)0123456789'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789ab)0123456789a'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789ab)0123456789a'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789ab)0123456789a'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789ab)0123456789ab'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789ab)0123456789ab'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789ab)0123456789ab'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789ab)0123456789abc'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789ab)0123456789abc'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789ab)0123456789abc'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789ab)0123456789abcd'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789ab)0123456789abcd'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789ab)0123456789abcd'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789ab)0123456789abcde'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789ab)0123456789abcde'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789ab)0123456789abcde'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789ab)0123456789abcdef'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789ab)0123456789abcdef'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789ab)0123456789abcdef'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789ab)0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789ab)0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789ab)0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abc'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abc'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abc'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abc)'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abc)'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abc)'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abc)0'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abc)0'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abc)0'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abc)01'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abc)01'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abc)01'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abc)012'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abc)012'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abc)012'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abc)0123'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abc)0123'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abc)0123'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abc)01234'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abc)01234'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abc)01234'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abc)012345'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abc)012345'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abc)012345'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abc)0123456'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abc)0123456'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abc)0123456'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abc)01234567'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abc)01234567'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abc)01234567'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abc)012345678'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abc)012345678'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abc)012345678'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abc)0123456789'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abc)0123456789'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abc)0123456789'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abc)0123456789a'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abc)0123456789a'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abc)0123456789a'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abc)0123456789ab'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abc)0123456789ab'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abc)0123456789ab'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abc)0123456789abc'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abc)0123456789abc'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abc)0123456789abc'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abc)0123456789abcd'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abc)0123456789abcd'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abc)0123456789abcd'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abc)0123456789abcde'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abc)0123456789abcde'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abc)0123456789abcde'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abc)0123456789abcdef'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abc)0123456789abcdef'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abc)0123456789abcdef'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abc)0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abc)0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abc)0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcd'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abcd'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcd'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcd)'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abcd)'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcd)'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcd)0'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abcd)0'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcd)0'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcd)01'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abcd)01'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcd)01'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcd)012'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abcd)012'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcd)012'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcd)0123'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abcd)0123'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcd)0123'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcd)01234'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abcd)01234'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcd)01234'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcd)012345'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abcd)012345'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcd)012345'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcd)0123456'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abcd)0123456'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcd)0123456'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcd)01234567'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abcd)01234567'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcd)01234567'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcd)012345678'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abcd)012345678'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcd)012345678'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcd)0123456789'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abcd)0123456789'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcd)0123456789'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcd)0123456789a'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abcd)0123456789a'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcd)0123456789a'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcd)0123456789ab'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abcd)0123456789ab'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcd)0123456789ab'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcd)0123456789abc'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abcd)0123456789abc'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcd)0123456789abc'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcd)0123456789abcd'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abcd)0123456789abcd'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcd)0123456789abcd'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcd)0123456789abcde'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abcd)0123456789abcde'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcd)0123456789abcde'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcd)0123456789abcdef'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abcd)0123456789abcdef'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcd)0123456789abcdef'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcd)0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abcd)0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcd)0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcde'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abcde'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcde'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcde)'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abcde)'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcde)'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcde)0'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abcde)0'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcde)0'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcde)01'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abcde)01'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcde)01'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcde)012'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abcde)012'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcde)012'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcde)0123'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abcde)0123'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcde)0123'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcde)01234'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abcde)01234'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcde)01234'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcde)012345'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abcde)012345'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcde)012345'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcde)0123456'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abcde)0123456'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcde)0123456'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcde)01234567'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abcde)01234567'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcde)01234567'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcde)012345678'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abcde)012345678'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcde)012345678'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcde)0123456789'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abcde)0123456789'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcde)0123456789'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcde)0123456789a'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abcde)0123456789a'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcde)0123456789a'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcde)0123456789ab'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abcde)0123456789ab'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcde)0123456789ab'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcde)0123456789abc'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abcde)0123456789abc'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcde)0123456789abc'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcde)0123456789abcd'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abcde)0123456789abcd'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcde)0123456789abcd'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcde)0123456789abcde'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abcde)0123456789abcde'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcde)0123456789abcde'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcde)0123456789abcdef'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abcde)0123456789abcdef'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcde)0123456789abcdef'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcde)0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abcde)0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcde)0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcdef'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abcdef'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcdef'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abcdef)'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)0'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abcdef)0'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)0'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)01'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abcdef)01'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)01'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)012'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abcdef)012'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)012'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)0123'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abcdef)0123'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)0123'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)01234'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abcdef)01234'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)01234'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)012345'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abcdef)012345'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)012345'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)0123456'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abcdef)0123456'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)0123456'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)01234567'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abcdef)01234567'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)01234567'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)012345678'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abcdef)012345678'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)012345678'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)0123456789'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abcdef)0123456789'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)0123456789'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)0123456789a'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abcdef)0123456789a'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)0123456789a'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)0123456789ab'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abcdef)0123456789ab'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)0123456789ab'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)0123456789abc'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abcdef)0123456789abc'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)0123456789abc'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)0123456789abcd'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abcdef)0123456789abcd'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)0123456789abcd'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)0123456789abcde'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abcdef)0123456789abcde'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)0123456789abcde'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)0123456789abcdef'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abcdef)0123456789abcdef'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)0123456789abcdef'\''|json -b1'

echo '$ echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)0123456789abcdef"'\''|json -b1'
echo -n 'r"0123456789abcdef(foo)0123456789abcdef)0123456789abcdef"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"0123456789abcdef(foo)0123456789abcdef)0123456789abcdef"'\''|json -b1'

echo '$ echo -n '\''r"b'\''|json -b1'
echo -n 'r"b'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"b'\''|json -b1'

echo '$ echo -n '\''r"ba'\''|json -b1'
echo -n 'r"ba'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"ba'\''|json -b1'

echo '$ echo -n '\''r"bar'\''|json -b1'
echo -n 'r"bar'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"bar'\''|json -b1'

echo '$ echo -n '\''r"bar('\''|json -b1'
echo -n 'r"bar('|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"bar('\''|json -b1'

echo '$ echo -n '\''r"bar()'\''|json -b1'
echo -n 'r"bar()'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"bar()'\''|json -b1'

echo '$ echo -n '\''r"bar())'\''|json -b1'
echo -n 'r"bar())'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"bar())'\''|json -b1'

echo '$ echo -n '\''r"bar())b'\''|json -b1'
echo -n 'r"bar())b'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"bar())b'\''|json -b1'

echo '$ echo -n '\''r"bar())ba'\''|json -b1'
echo -n 'r"bar())ba'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"bar())ba'\''|json -b1'

echo '$ echo -n '\''r"bar())bar'\''|json -b1'
echo -n 'r"bar())bar'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"bar())bar'\''|json -b1'

echo '$ echo -n '\''r"bar())bar"'\''|json -b1'
echo -n 'r"bar())bar"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"bar())bar"'\''|json -b1'

echo '$ echo -n '\''r"bar()b'\''|json -b1'
echo -n 'r"bar()b'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"bar()b'\''|json -b1'

echo '$ echo -n '\''r"bar()b)'\''|json -b1'
echo -n 'r"bar()b)'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"bar()b)'\''|json -b1'

echo '$ echo -n '\''r"bar()b)b'\''|json -b1'
echo -n 'r"bar()b)b'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"bar()b)b'\''|json -b1'

echo '$ echo -n '\''r"bar()b)ba'\''|json -b1'
echo -n 'r"bar()b)ba'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"bar()b)ba'\''|json -b1'

echo '$ echo -n '\''r"bar()b)bar'\''|json -b1'
echo -n 'r"bar()b)bar'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"bar()b)bar'\''|json -b1'

echo '$ echo -n '\''r"bar()b)bar"'\''|json -b1'
echo -n 'r"bar()b)bar"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"bar()b)bar"'\''|json -b1'

echo '$ echo -n '\''r"bar()ba'\''|json -b1'
echo -n 'r"bar()ba'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"bar()ba'\''|json -b1'

echo '$ echo -n '\''r"bar()ba)'\''|json -b1'
echo -n 'r"bar()ba)'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"bar()ba)'\''|json -b1'

echo '$ echo -n '\''r"bar()ba)b'\''|json -b1'
echo -n 'r"bar()ba)b'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"bar()ba)b'\''|json -b1'

echo '$ echo -n '\''r"bar()ba)ba'\''|json -b1'
echo -n 'r"bar()ba)ba'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"bar()ba)ba'\''|json -b1'

echo '$ echo -n '\''r"bar()ba)bar'\''|json -b1'
echo -n 'r"bar()ba)bar'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"bar()ba)bar'\''|json -b1'

echo '$ echo -n '\''r"bar()ba)bar"'\''|json -b1'
echo -n 'r"bar()ba)bar"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"bar()ba)bar"'\''|json -b1'

echo '$ echo -n '\''r"bar()bar'\''|json -b1'
echo -n 'r"bar()bar'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"bar()bar'\''|json -b1'

echo '$ echo -n '\''r"bar()bar"'\''|json -b1'
echo -n 'r"bar()bar"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"bar()bar"'\''|json -b1'

echo '$ echo -n '\''r"bar()bar)'\''|json -b1'
echo -n 'r"bar()bar)'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"bar()bar)'\''|json -b1'

echo '$ echo -n '\''r"bar()bar)b'\''|json -b1'
echo -n 'r"bar()bar)b'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"bar()bar)b'\''|json -b1'

echo '$ echo -n '\''r"bar()bar)ba'\''|json -b1'
echo -n 'r"bar()bar)ba'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"bar()bar)ba'\''|json -b1'

echo '$ echo -n '\''r"bar()bar)bar'\''|json -b1'
echo -n 'r"bar()bar)bar'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"bar()bar)bar'\''|json -b1'

echo '$ echo -n '\''r"bar()bar)bar"'\''|json -b1'
echo -n 'r"bar()bar)bar"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"bar()bar)bar"'\''|json -b1'

echo '$ echo -n '\''r"bar(f'\''|json -b1'
echo -n 'r"bar(f'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"bar(f'\''|json -b1'

echo '$ echo -n '\''r"bar(fo'\''|json -b1'
echo -n 'r"bar(fo'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"bar(fo'\''|json -b1'

echo '$ echo -n '\''r"bar(foo'\''|json -b1'
echo -n 'r"bar(foo'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo'\''|json -b1'

echo '$ echo -n '\''r"bar(foo)'\''|json -b1'
echo -n 'r"bar(foo)'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)'\''|json -b1'

echo '$ echo -n '\''r"bar(foo))'\''|json -b1'
echo -n 'r"bar(foo))'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo))'\''|json -b1'

echo '$ echo -n '\''r"bar(foo))b'\''|json -b1'
echo -n 'r"bar(foo))b'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo))b'\''|json -b1'

echo '$ echo -n '\''r"bar(foo))ba'\''|json -b1'
echo -n 'r"bar(foo))ba'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo))ba'\''|json -b1'

echo '$ echo -n '\''r"bar(foo))bar'\''|json -b1'
echo -n 'r"bar(foo))bar'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo))bar'\''|json -b1'

echo '$ echo -n '\''r"bar(foo))bar"'\''|json -b1'
echo -n 'r"bar(foo))bar"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo))bar"'\''|json -b1'

echo '$ echo -n '\''r"bar(foo)b'\''|json -b1'
echo -n 'r"bar(foo)b'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)b'\''|json -b1'

echo '$ echo -n '\''r"bar(foo)b)'\''|json -b1'
echo -n 'r"bar(foo)b)'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)b)'\''|json -b1'

echo '$ echo -n '\''r"bar(foo)b)b'\''|json -b1'
echo -n 'r"bar(foo)b)b'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)b)b'\''|json -b1'

echo '$ echo -n '\''r"bar(foo)b)ba'\''|json -b1'
echo -n 'r"bar(foo)b)ba'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)b)ba'\''|json -b1'

echo '$ echo -n '\''r"bar(foo)b)bar'\''|json -b1'
echo -n 'r"bar(foo)b)bar'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)b)bar'\''|json -b1'

echo '$ echo -n '\''r"bar(foo)b)bar"'\''|json -b1'
echo -n 'r"bar(foo)b)bar"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)b)bar"'\''|json -b1'

echo '$ echo -n '\''r"bar(foo)ba'\''|json -b1'
echo -n 'r"bar(foo)ba'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)ba'\''|json -b1'

echo '$ echo -n '\''r"bar(foo)ba)'\''|json -b1'
echo -n 'r"bar(foo)ba)'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)ba)'\''|json -b1'

echo '$ echo -n '\''r"bar(foo)ba)b'\''|json -b1'
echo -n 'r"bar(foo)ba)b'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)ba)b'\''|json -b1'

echo '$ echo -n '\''r"bar(foo)ba)ba'\''|json -b1'
echo -n 'r"bar(foo)ba)ba'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)ba)ba'\''|json -b1'

echo '$ echo -n '\''r"bar(foo)ba)bar'\''|json -b1'
echo -n 'r"bar(foo)ba)bar'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)ba)bar'\''|json -b1'

echo '$ echo -n '\''r"bar(foo)ba)bar"'\''|json -b1'
echo -n 'r"bar(foo)ba)bar"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)ba)bar"'\''|json -b1'

echo '$ echo -n '\''r"bar(foo)bar'\''|json -b1'
echo -n 'r"bar(foo)bar'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)bar'\''|json -b1'

echo '$ echo -n '\''r"bar(foo)bar"'\''|json -b1'
echo -n 'r"bar(foo)bar"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)bar"'\''|json -b1'

echo '$ echo -n '\''r"bar(foo)bar)'\''|json -b1'
echo -n 'r"bar(foo)bar)'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)bar)'\''|json -b1'

echo '$ echo -n '\''r"bar(foo)bar)b'\''|json -b1'
echo -n 'r"bar(foo)bar)b'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)bar)b'\''|json -b1'

echo '$ echo -n '\''r"bar(foo)bar)ba'\''|json -b1'
echo -n 'r"bar(foo)bar)ba'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)bar)ba'\''|json -b1'

echo '$ echo -n '\''r"bar(foo)bar)bar'\''|json -b1'
echo -n 'r"bar(foo)bar)bar'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)bar)bar'\''|json -b1'

echo '$ echo -n '\''r"bar(foo)bar)bar"'\''|json -b1'
echo -n 'r"bar(foo)bar)bar"'|json -b1 2>&1 ||
echo 'command failed: echo -n '\''r"bar(foo)bar)bar"'\''|json -b1'
)

