#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-lib:array-value
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L array-value.old <(echo \
'$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }
$ json <<< '\''[null]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''[null]'\''
$ json <<< '\''[false]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: [false]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''[false]'\''
$ json <<< '\''[true]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: [true]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''[true]'\''
$ json <<< '\''[123]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: [123]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''[123]'\''
$ json <<< '\''["foo"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["foo"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["foo"]'\''
$ json <<< '\''["type"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: ["type"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''["type"]'\''
$ json <<< '\''["null"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: ["null"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''["null"]'\''
$ json <<< '\''["boolean"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: ["boolean"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''["boolean"]'\''
$ json <<< '\''["number"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: ["number"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''["number"]'\''
$ json <<< '\''["string"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: ["string"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''["string"]'\''
$ json <<< '\''["object"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: ["object"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''["object"]'\''
$ json <<< '\''["array"]'\''
json: error: <stdin>:1:1: meta error: invalid top value: it must be a type or an array of "name" objects
json: error: <stdin>:1:1: ["array"]
json: error: <stdin>:1:1: ^
command failed: json <<< '\''["array"]'\''
$ json <<< '\''["list"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["list"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["list"]'\''
$ json <<< '\''["dict"]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: ["dict"]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''["dict"]'\''
$ json <<< '\''[{}]'\''
json: error: <stdin>:1:2: meta error: empty objects are not allowed
json: error: <stdin>:1:2: [{}]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''[{}]'\''
$ json <<< '\''[{"foo":"bar"}]'\''
json: error: <stdin>:1:3: meta error: invalid first key of object: it must be "type", "name" or "plain"
json: error: <stdin>:1:3: [{"foo":"bar"}]
json: error: <stdin>:1:3:   ^
command failed: json <<< '\''[{"foo":"bar"}]'\''
$ json <<< '\''[{"name":"baz","type":"object"}]'\''
[
    {
        "name": "baz",
        "type": "object"
    }
]
$ json <<< '\''[[]]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: [[]]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''[[]]'\''
$ json <<< '\''[["number","string"]]'\''
json: error: <stdin>:1:2: meta error: invalid array: element is neither a type nor a "name" object
json: error: <stdin>:1:2: [["number","string"]]
json: error: <stdin>:1:2:  ^
command failed: json <<< '\''[["number","string"]]'\'''
) -L array-value.new <(
echo '$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }'
json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; } 2>&1 ||
echo 'command failed: json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }'

echo '$ json <<< '\''[null]'\'''
json <<< '[null]' 2>&1 ||
echo 'command failed: json <<< '\''[null]'\'''

echo '$ json <<< '\''[false]'\'''
json <<< '[false]' 2>&1 ||
echo 'command failed: json <<< '\''[false]'\'''

echo '$ json <<< '\''[true]'\'''
json <<< '[true]' 2>&1 ||
echo 'command failed: json <<< '\''[true]'\'''

echo '$ json <<< '\''[123]'\'''
json <<< '[123]' 2>&1 ||
echo 'command failed: json <<< '\''[123]'\'''

echo '$ json <<< '\''["foo"]'\'''
json <<< '["foo"]' 2>&1 ||
echo 'command failed: json <<< '\''["foo"]'\'''

echo '$ json <<< '\''["type"]'\'''
json <<< '["type"]' 2>&1 ||
echo 'command failed: json <<< '\''["type"]'\'''

echo '$ json <<< '\''["null"]'\'''
json <<< '["null"]' 2>&1 ||
echo 'command failed: json <<< '\''["null"]'\'''

echo '$ json <<< '\''["boolean"]'\'''
json <<< '["boolean"]' 2>&1 ||
echo 'command failed: json <<< '\''["boolean"]'\'''

echo '$ json <<< '\''["number"]'\'''
json <<< '["number"]' 2>&1 ||
echo 'command failed: json <<< '\''["number"]'\'''

echo '$ json <<< '\''["string"]'\'''
json <<< '["string"]' 2>&1 ||
echo 'command failed: json <<< '\''["string"]'\'''

echo '$ json <<< '\''["object"]'\'''
json <<< '["object"]' 2>&1 ||
echo 'command failed: json <<< '\''["object"]'\'''

echo '$ json <<< '\''["array"]'\'''
json <<< '["array"]' 2>&1 ||
echo 'command failed: json <<< '\''["array"]'\'''

echo '$ json <<< '\''["list"]'\'''
json <<< '["list"]' 2>&1 ||
echo 'command failed: json <<< '\''["list"]'\'''

echo '$ json <<< '\''["dict"]'\'''
json <<< '["dict"]' 2>&1 ||
echo 'command failed: json <<< '\''["dict"]'\'''

echo '$ json <<< '\''[{}]'\'''
json <<< '[{}]' 2>&1 ||
echo 'command failed: json <<< '\''[{}]'\'''

echo '$ json <<< '\''[{"foo":"bar"}]'\'''
json <<< '[{"foo":"bar"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"foo":"bar"}]'\'''

echo '$ json <<< '\''[{"name":"baz","type":"object"}]'\'''
json <<< '[{"name":"baz","type":"object"}]' 2>&1 ||
echo 'command failed: json <<< '\''[{"name":"baz","type":"object"}]'\'''

echo '$ json <<< '\''[[]]'\'''
json <<< '[[]]' 2>&1 ||
echo 'command failed: json <<< '\''[[]]'\'''

echo '$ json <<< '\''[["number","string"]]'\'''
json <<< '[["number","string"]]' 2>&1 ||
echo 'command failed: json <<< '\''[["number","string"]]'\'''
)

