#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C bugs:39
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L 39.old <(echo \
'$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '\''/error:/s|(/dev/fd/)[0-9]+|\1??|'\''; }
$ json -VO -u <<< $'\''{"plain":"\xef\xbf\xc0"}'\''
json: error: <stdin>:1:13: lex error: invalid utf-8 encoding
json: error: <stdin>:1:13: {"plain":"\xef\xbf\xc0"}
json: error: <stdin>:1:13:                   ^
command failed: json -VO -u <<< $'\''{"plain":"\xef\xbf\xc0"}'\''
$ json -VT -u <<< $'\''{"plain":"\xef\xbf\xc0"}'\'' && echo OK
json: error: <stdin>:1:13: parse error: invalid utf-8 encoding
json: error: <stdin>:1:13: {"plain":"\xef\xbf\xc0"}
json: error: <stdin>:1:13:                   ^
command failed: json -VT -u <<< $'\''{"plain":"\xef\xbf\xc0"}'\'' && echo OK'
) -L 39.new <(
echo '$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '\''/error:/s|(/dev/fd/)[0-9]+|\1??|'\''; }'
json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '/error:/s|(/dev/fd/)[0-9]+|\1??|'; } 2>&1 ||
echo 'command failed: json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '\''/error:/s|(/dev/fd/)[0-9]+|\1??|'\''; }'

echo '$ json -VO -u <<< $'\''{"plain":"\xef\xbf\xc0"}'\'''
json -VO -u <<< $'{"plain":"\xef\xbf\xc0"}' 2>&1 ||
echo 'command failed: json -VO -u <<< $'\''{"plain":"\xef\xbf\xc0"}'\'''

echo '$ json -VT -u <<< $'\''{"plain":"\xef\xbf\xc0"}'\'' && echo OK'
json -VT -u <<< $'{"plain":"\xef\xbf\xc0"}' && echo OK 2>&1 ||
echo 'command failed: json -VT -u <<< $'\''{"plain":"\xef\xbf\xc0"}'\'' && echo OK'
)

