#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C filter:help
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L help.old <(echo \
'$ json0() { LD_LIBRARY_PATH=../lib ../src/json "$@"; }
$ shopt -s expand_aliases
$ alias json='\''json0 -F'\''
$ json ../lib/test-filter.so
usage: test-filter.so [ACTION|OPTION]...
where actions are specified as:
  -G|--generic         print out the text '\''generic action'\''
the options are:
  -f|--fail=WHERE      set where the filter to fail or make
     --no-fail           it to not fail at all; WHERE can be
                         any of: '\''init'\'', '\''handler'\'' or '\''exec'\''
  -d|--dump-options    print parsed options and exit
  -v|--version         print version numbers and exit
  -?|--help            display this help info and exit
$ json -- ../lib/test-filter.so --help
usage: test-filter.so [ACTION|OPTION]...
where actions are specified as:
  -G|--generic         print out the text '\''generic action'\''
the options are:
  -f|--fail=WHERE      set where the filter to fail or make
     --no-fail           it to not fail at all; WHERE can be
                         any of: '\''init'\'', '\''handler'\'' or '\''exec'\''
  -d|--dump-options    print parsed options and exit
  -v|--version         print version numbers and exit
  -?|--help            display this help info and exit'
) -L help.new <(
echo '$ json0() { LD_LIBRARY_PATH=../lib ../src/json "$@"; }'
json0() { LD_LIBRARY_PATH=../lib ../src/json "$@"; } 2>&1 ||
echo 'command failed: json0() { LD_LIBRARY_PATH=../lib ../src/json "$@"; }'

echo '$ shopt -s expand_aliases'
shopt -s expand_aliases 2>&1 ||
echo 'command failed: shopt -s expand_aliases'

echo '$ alias json='\''json0 -F'\'''
alias json='json0 -F' 2>&1 ||
echo 'command failed: alias json='\''json0 -F'\'''

echo '$ json ../lib/test-filter.so'
json ../lib/test-filter.so 2>&1 ||
echo 'command failed: json ../lib/test-filter.so'

echo '$ json -- ../lib/test-filter.so --help'
json -- ../lib/test-filter.so --help 2>&1 ||
echo 'command failed: json -- ../lib/test-filter.so --help'
)

