#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C parser:string-plain
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L string-plain.old <(echo \
'$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }
$ json() { json0 --literal-value --escape-utf8 "$@"; }
$ echo -e '\''"\x0"'\''|json -b 1
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\0"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x0"'\''|json -b 1
$ echo -e '\''"\x0"'\''|json -b 2
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\0"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x0"'\''|json -b 2
$ echo -e '\''"\x0"'\''|json -b 3
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\0"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x0"'\''|json -b 3
$ echo -e '\''"\x0"'\''|json -b 4
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\0"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x0"'\''|json -b 4
$ echo -e '\''"\x0"'\''|json -b 5
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\0"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x0"'\''|json -b 5
$ echo -e '\''"\x1"'\''|json -b 1
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x01"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x1"'\''|json -b 1
$ echo -e '\''"\x1"'\''|json -b 2
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x01"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x1"'\''|json -b 2
$ echo -e '\''"\x1"'\''|json -b 3
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x01"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x1"'\''|json -b 3
$ echo -e '\''"\x1"'\''|json -b 4
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x01"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x1"'\''|json -b 4
$ echo -e '\''"\x1"'\''|json -b 5
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x01"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x1"'\''|json -b 5
$ echo -e '\''"\x2"'\''|json -b 1
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x02"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x2"'\''|json -b 1
$ echo -e '\''"\x2"'\''|json -b 2
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x02"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x2"'\''|json -b 2
$ echo -e '\''"\x2"'\''|json -b 3
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x02"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x2"'\''|json -b 3
$ echo -e '\''"\x2"'\''|json -b 4
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x02"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x2"'\''|json -b 4
$ echo -e '\''"\x2"'\''|json -b 5
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x02"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x2"'\''|json -b 5
$ echo -e '\''"\x3"'\''|json -b 1
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x03"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x3"'\''|json -b 1
$ echo -e '\''"\x3"'\''|json -b 2
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x03"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x3"'\''|json -b 2
$ echo -e '\''"\x3"'\''|json -b 3
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x03"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x3"'\''|json -b 3
$ echo -e '\''"\x3"'\''|json -b 4
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x03"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x3"'\''|json -b 4
$ echo -e '\''"\x3"'\''|json -b 5
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x03"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x3"'\''|json -b 5
$ echo -e '\''"\x4"'\''|json -b 1
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x04"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x4"'\''|json -b 1
$ echo -e '\''"\x4"'\''|json -b 2
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x04"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x4"'\''|json -b 2
$ echo -e '\''"\x4"'\''|json -b 3
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x04"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x4"'\''|json -b 3
$ echo -e '\''"\x4"'\''|json -b 4
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x04"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x4"'\''|json -b 4
$ echo -e '\''"\x4"'\''|json -b 5
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x04"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x4"'\''|json -b 5
$ echo -e '\''"\x5"'\''|json -b 1
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x05"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x5"'\''|json -b 1
$ echo -e '\''"\x5"'\''|json -b 2
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x05"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x5"'\''|json -b 2
$ echo -e '\''"\x5"'\''|json -b 3
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x05"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x5"'\''|json -b 3
$ echo -e '\''"\x5"'\''|json -b 4
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x05"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x5"'\''|json -b 4
$ echo -e '\''"\x5"'\''|json -b 5
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x05"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x5"'\''|json -b 5
$ echo -e '\''"\x6"'\''|json -b 1
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x06"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x6"'\''|json -b 1
$ echo -e '\''"\x6"'\''|json -b 2
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x06"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x6"'\''|json -b 2
$ echo -e '\''"\x6"'\''|json -b 3
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x06"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x6"'\''|json -b 3
$ echo -e '\''"\x6"'\''|json -b 4
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x06"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x6"'\''|json -b 4
$ echo -e '\''"\x6"'\''|json -b 5
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x06"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x6"'\''|json -b 5
$ echo -e '\''"\x7"'\''|json -b 1
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\a"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x7"'\''|json -b 1
$ echo -e '\''"\x7"'\''|json -b 2
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\a"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x7"'\''|json -b 2
$ echo -e '\''"\x7"'\''|json -b 3
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\a"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x7"'\''|json -b 3
$ echo -e '\''"\x7"'\''|json -b 4
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\a"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x7"'\''|json -b 4
$ echo -e '\''"\x7"'\''|json -b 5
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\a"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x7"'\''|json -b 5
$ echo -e '\''"\x8"'\''|json -b 1
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\b"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x8"'\''|json -b 1
$ echo -e '\''"\x8"'\''|json -b 2
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\b"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x8"'\''|json -b 2
$ echo -e '\''"\x8"'\''|json -b 3
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\b"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x8"'\''|json -b 3
$ echo -e '\''"\x8"'\''|json -b 4
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\b"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x8"'\''|json -b 4
$ echo -e '\''"\x8"'\''|json -b 5
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\b"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x8"'\''|json -b 5
$ echo -e '\''"\x9"'\''|json -b 1
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\t"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x9"'\''|json -b 1
$ echo -e '\''"\x9"'\''|json -b 2
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\t"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x9"'\''|json -b 2
$ echo -e '\''"\x9"'\''|json -b 3
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\t"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x9"'\''|json -b 3
$ echo -e '\''"\x9"'\''|json -b 4
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\t"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x9"'\''|json -b 4
$ echo -e '\''"\x9"'\''|json -b 5
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\t"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x9"'\''|json -b 5
$ echo -e '\''"\xa"'\''|json -b 1
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\n"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xa"'\''|json -b 1
$ echo -e '\''"\xa"'\''|json -b 2
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\n"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xa"'\''|json -b 2
$ echo -e '\''"\xa"'\''|json -b 3
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\n"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xa"'\''|json -b 3
$ echo -e '\''"\xa"'\''|json -b 4
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\n"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xa"'\''|json -b 4
$ echo -e '\''"\xa"'\''|json -b 5
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\n"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xa"'\''|json -b 5
$ echo -e '\''"\xb"'\''|json -b 1
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\v"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xb"'\''|json -b 1
$ echo -e '\''"\xb"'\''|json -b 2
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\v"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xb"'\''|json -b 2
$ echo -e '\''"\xb"'\''|json -b 3
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\v"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xb"'\''|json -b 3
$ echo -e '\''"\xb"'\''|json -b 4
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\v"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xb"'\''|json -b 4
$ echo -e '\''"\xb"'\''|json -b 5
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\v"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xb"'\''|json -b 5
$ echo -e '\''"\xc"'\''|json -b 1
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\f"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xc"'\''|json -b 1
$ echo -e '\''"\xc"'\''|json -b 2
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\f"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xc"'\''|json -b 2
$ echo -e '\''"\xc"'\''|json -b 3
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\f"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xc"'\''|json -b 3
$ echo -e '\''"\xc"'\''|json -b 4
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\f"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xc"'\''|json -b 4
$ echo -e '\''"\xc"'\''|json -b 5
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\f"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xc"'\''|json -b 5
$ echo -e '\''"\xd"'\''|json -b 1
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\r"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xd"'\''|json -b 1
$ echo -e '\''"\xd"'\''|json -b 2
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\r"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xd"'\''|json -b 2
$ echo -e '\''"\xd"'\''|json -b 3
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\r"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xd"'\''|json -b 3
$ echo -e '\''"\xd"'\''|json -b 4
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\r"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xd"'\''|json -b 4
$ echo -e '\''"\xd"'\''|json -b 5
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\r"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xd"'\''|json -b 5
$ echo -e '\''"\xe"'\''|json -b 1
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x0e"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xe"'\''|json -b 1
$ echo -e '\''"\xe"'\''|json -b 2
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x0e"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xe"'\''|json -b 2
$ echo -e '\''"\xe"'\''|json -b 3
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x0e"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xe"'\''|json -b 3
$ echo -e '\''"\xe"'\''|json -b 4
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x0e"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xe"'\''|json -b 4
$ echo -e '\''"\xe"'\''|json -b 5
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x0e"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xe"'\''|json -b 5
$ echo -e '\''"\xf"'\''|json -b 1
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x0f"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xf"'\''|json -b 1
$ echo -e '\''"\xf"'\''|json -b 2
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x0f"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xf"'\''|json -b 2
$ echo -e '\''"\xf"'\''|json -b 3
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x0f"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xf"'\''|json -b 3
$ echo -e '\''"\xf"'\''|json -b 4
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x0f"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xf"'\''|json -b 4
$ echo -e '\''"\xf"'\''|json -b 5
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x0f"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\xf"'\''|json -b 5
$ echo -e '\''"\x10"'\''|json -b 1
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x10"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x10"'\''|json -b 1
$ echo -e '\''"\x10"'\''|json -b 2
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x10"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x10"'\''|json -b 2
$ echo -e '\''"\x10"'\''|json -b 3
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x10"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x10"'\''|json -b 3
$ echo -e '\''"\x10"'\''|json -b 4
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x10"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x10"'\''|json -b 4
$ echo -e '\''"\x10"'\''|json -b 5
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x10"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x10"'\''|json -b 5
$ echo -e '\''"\x11"'\''|json -b 1
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x11"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x11"'\''|json -b 1
$ echo -e '\''"\x11"'\''|json -b 2
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x11"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x11"'\''|json -b 2
$ echo -e '\''"\x11"'\''|json -b 3
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x11"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x11"'\''|json -b 3
$ echo -e '\''"\x11"'\''|json -b 4
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x11"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x11"'\''|json -b 4
$ echo -e '\''"\x11"'\''|json -b 5
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x11"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x11"'\''|json -b 5
$ echo -e '\''"\x12"'\''|json -b 1
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x12"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x12"'\''|json -b 1
$ echo -e '\''"\x12"'\''|json -b 2
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x12"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x12"'\''|json -b 2
$ echo -e '\''"\x12"'\''|json -b 3
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x12"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x12"'\''|json -b 3
$ echo -e '\''"\x12"'\''|json -b 4
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x12"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x12"'\''|json -b 4
$ echo -e '\''"\x12"'\''|json -b 5
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x12"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x12"'\''|json -b 5
$ echo -e '\''"\x13"'\''|json -b 1
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x13"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x13"'\''|json -b 1
$ echo -e '\''"\x13"'\''|json -b 2
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x13"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x13"'\''|json -b 2
$ echo -e '\''"\x13"'\''|json -b 3
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x13"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x13"'\''|json -b 3
$ echo -e '\''"\x13"'\''|json -b 4
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x13"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x13"'\''|json -b 4
$ echo -e '\''"\x13"'\''|json -b 5
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x13"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x13"'\''|json -b 5
$ echo -e '\''"\x14"'\''|json -b 1
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x14"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x14"'\''|json -b 1
$ echo -e '\''"\x14"'\''|json -b 2
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x14"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x14"'\''|json -b 2
$ echo -e '\''"\x14"'\''|json -b 3
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x14"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x14"'\''|json -b 3
$ echo -e '\''"\x14"'\''|json -b 4
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x14"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x14"'\''|json -b 4
$ echo -e '\''"\x14"'\''|json -b 5
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x14"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x14"'\''|json -b 5
$ echo -e '\''"\x15"'\''|json -b 1
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x15"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x15"'\''|json -b 1
$ echo -e '\''"\x15"'\''|json -b 2
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x15"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x15"'\''|json -b 2
$ echo -e '\''"\x15"'\''|json -b 3
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x15"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x15"'\''|json -b 3
$ echo -e '\''"\x15"'\''|json -b 4
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x15"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x15"'\''|json -b 4
$ echo -e '\''"\x15"'\''|json -b 5
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x15"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x15"'\''|json -b 5
$ echo -e '\''"\x16"'\''|json -b 1
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x16"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x16"'\''|json -b 1
$ echo -e '\''"\x16"'\''|json -b 2
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x16"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x16"'\''|json -b 2
$ echo -e '\''"\x16"'\''|json -b 3
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x16"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x16"'\''|json -b 3
$ echo -e '\''"\x16"'\''|json -b 4
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x16"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x16"'\''|json -b 4
$ echo -e '\''"\x16"'\''|json -b 5
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x16"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x16"'\''|json -b 5
$ echo -e '\''"\x17"'\''|json -b 1
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x17"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x17"'\''|json -b 1
$ echo -e '\''"\x17"'\''|json -b 2
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x17"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x17"'\''|json -b 2
$ echo -e '\''"\x17"'\''|json -b 3
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x17"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x17"'\''|json -b 3
$ echo -e '\''"\x17"'\''|json -b 4
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x17"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x17"'\''|json -b 4
$ echo -e '\''"\x17"'\''|json -b 5
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x17"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x17"'\''|json -b 5
$ echo -e '\''"\x18"'\''|json -b 1
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x18"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x18"'\''|json -b 1
$ echo -e '\''"\x18"'\''|json -b 2
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x18"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x18"'\''|json -b 2
$ echo -e '\''"\x18"'\''|json -b 3
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x18"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x18"'\''|json -b 3
$ echo -e '\''"\x18"'\''|json -b 4
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x18"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x18"'\''|json -b 4
$ echo -e '\''"\x18"'\''|json -b 5
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x18"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x18"'\''|json -b 5
$ echo -e '\''"\x19"'\''|json -b 1
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x19"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x19"'\''|json -b 1
$ echo -e '\''"\x19"'\''|json -b 2
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x19"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x19"'\''|json -b 2
$ echo -e '\''"\x19"'\''|json -b 3
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x19"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x19"'\''|json -b 3
$ echo -e '\''"\x19"'\''|json -b 4
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x19"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x19"'\''|json -b 4
$ echo -e '\''"\x19"'\''|json -b 5
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x19"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x19"'\''|json -b 5
$ echo -e '\''"\x1a"'\''|json -b 1
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x1a"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x1a"'\''|json -b 1
$ echo -e '\''"\x1a"'\''|json -b 2
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x1a"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x1a"'\''|json -b 2
$ echo -e '\''"\x1a"'\''|json -b 3
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x1a"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x1a"'\''|json -b 3
$ echo -e '\''"\x1a"'\''|json -b 4
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x1a"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x1a"'\''|json -b 4
$ echo -e '\''"\x1a"'\''|json -b 5
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x1a"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x1a"'\''|json -b 5
$ echo -e '\''"\x1b"'\''|json -b 1
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x1b"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x1b"'\''|json -b 1
$ echo -e '\''"\x1b"'\''|json -b 2
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x1b"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x1b"'\''|json -b 2
$ echo -e '\''"\x1b"'\''|json -b 3
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x1b"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x1b"'\''|json -b 3
$ echo -e '\''"\x1b"'\''|json -b 4
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x1b"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x1b"'\''|json -b 4
$ echo -e '\''"\x1b"'\''|json -b 5
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x1b"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x1b"'\''|json -b 5
$ echo -e '\''"\x1c"'\''|json -b 1
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x1c"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x1c"'\''|json -b 1
$ echo -e '\''"\x1c"'\''|json -b 2
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x1c"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x1c"'\''|json -b 2
$ echo -e '\''"\x1c"'\''|json -b 3
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x1c"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x1c"'\''|json -b 3
$ echo -e '\''"\x1c"'\''|json -b 4
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x1c"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x1c"'\''|json -b 4
$ echo -e '\''"\x1c"'\''|json -b 5
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x1c"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x1c"'\''|json -b 5
$ echo -e '\''"\x1d"'\''|json -b 1
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x1d"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x1d"'\''|json -b 1
$ echo -e '\''"\x1d"'\''|json -b 2
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x1d"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x1d"'\''|json -b 2
$ echo -e '\''"\x1d"'\''|json -b 3
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x1d"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x1d"'\''|json -b 3
$ echo -e '\''"\x1d"'\''|json -b 4
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x1d"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x1d"'\''|json -b 4
$ echo -e '\''"\x1d"'\''|json -b 5
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x1d"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x1d"'\''|json -b 5
$ echo -e '\''"\x1e"'\''|json -b 1
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x1e"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x1e"'\''|json -b 1
$ echo -e '\''"\x1e"'\''|json -b 2
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x1e"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x1e"'\''|json -b 2
$ echo -e '\''"\x1e"'\''|json -b 3
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x1e"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x1e"'\''|json -b 3
$ echo -e '\''"\x1e"'\''|json -b 4
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x1e"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x1e"'\''|json -b 4
$ echo -e '\''"\x1e"'\''|json -b 5
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x1e"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x1e"'\''|json -b 5
$ echo -e '\''"\x1f"'\''|json -b 1
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x1f"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x1f"'\''|json -b 1
$ echo -e '\''"\x1f"'\''|json -b 2
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x1f"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x1f"'\''|json -b 2
$ echo -e '\''"\x1f"'\''|json -b 3
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x1f"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x1f"'\''|json -b 3
$ echo -e '\''"\x1f"'\''|json -b 4
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x1f"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x1f"'\''|json -b 4
$ echo -e '\''"\x1f"'\''|json -b 5
json: error: <stdin>:1:2: lex error: invalid string literal
json: error: <stdin>:1:2: "\x1f"
json: error: <stdin>:1:2:  ^
command failed: echo -e '\''"\x1f"'\''|json -b 5
$ echo '\''" "'\''|json -b 1
" "
$ echo '\''" "'\''|json -b 2
" "
$ echo '\''" "'\''|json -b 3
" "
$ echo '\''" "'\''|json -b 4
" "
$ echo '\''" "'\''|json -b 5
" "
$ echo '\''"!"'\''|json -b 1
"!"
$ echo '\''"!"'\''|json -b 2
"!"
$ echo '\''"!"'\''|json -b 3
"!"
$ echo '\''"!"'\''|json -b 4
"!"
$ echo '\''"!"'\''|json -b 5
"!"
$ echo '\''"""'\''|json -b 1
json: error: <stdin>:1:4: lex error: invalid string literal
json: error: <stdin>:1:4: """
json: error: <stdin>:1:4:    ^
""
command failed: echo '\''"""'\''|json -b 1
$ echo '\''"""'\''|json -b 2
json: error: <stdin>:1:4: lex error: invalid string literal
json: error: <stdin>:1:4: """
json: error: <stdin>:1:4:    ^
""
command failed: echo '\''"""'\''|json -b 2
$ echo '\''"""'\''|json -b 3
json: error: <stdin>:1:4: lex error: invalid string literal
json: error: <stdin>:1:4: """
json: error: <stdin>:1:4:    ^
""
command failed: echo '\''"""'\''|json -b 3
$ echo '\''"""'\''|json -b 4
json: error: <stdin>:1:4: lex error: invalid string literal
json: error: <stdin>:1:4: """
json: error: <stdin>:1:4:    ^
""
command failed: echo '\''"""'\''|json -b 4
$ echo '\''"""'\''|json -b 5
json: error: <stdin>:1:4: lex error: invalid string literal
json: error: <stdin>:1:4: """
json: error: <stdin>:1:4:    ^
""
command failed: echo '\''"""'\''|json -b 5
$ echo '\''"#"'\''|json -b 1
"#"
$ echo '\''"#"'\''|json -b 2
"#"
$ echo '\''"#"'\''|json -b 3
"#"
$ echo '\''"#"'\''|json -b 4
"#"
$ echo '\''"#"'\''|json -b 5
"#"
$ echo '\''"$"'\''|json -b 1
"$"
$ echo '\''"$"'\''|json -b 2
"$"
$ echo '\''"$"'\''|json -b 3
"$"
$ echo '\''"$"'\''|json -b 4
"$"
$ echo '\''"$"'\''|json -b 5
"$"
$ echo '\''"%"'\''|json -b 1
"%"
$ echo '\''"%"'\''|json -b 2
"%"
$ echo '\''"%"'\''|json -b 3
"%"
$ echo '\''"%"'\''|json -b 4
"%"
$ echo '\''"%"'\''|json -b 5
"%"
$ echo '\''"&"'\''|json -b 1
"&"
$ echo '\''"&"'\''|json -b 2
"&"
$ echo '\''"&"'\''|json -b 3
"&"
$ echo '\''"&"'\''|json -b 4
"&"
$ echo '\''"&"'\''|json -b 5
"&"
$ echo -e '\''"\x27"'\''|json -b 1
"'\''"
$ echo -e '\''"\x27"'\''|json -b 2
"'\''"
$ echo -e '\''"\x27"'\''|json -b 3
"'\''"
$ echo -e '\''"\x27"'\''|json -b 4
"'\''"
$ echo -e '\''"\x27"'\''|json -b 5
"'\''"
$ echo '\''"("'\''|json -b 1
"("
$ echo '\''"("'\''|json -b 2
"("
$ echo '\''"("'\''|json -b 3
"("
$ echo '\''"("'\''|json -b 4
"("
$ echo '\''"("'\''|json -b 5
"("
$ echo '\''")"'\''|json -b 1
")"
$ echo '\''")"'\''|json -b 2
")"
$ echo '\''")"'\''|json -b 3
")"
$ echo '\''")"'\''|json -b 4
")"
$ echo '\''")"'\''|json -b 5
")"
$ echo '\''"*"'\''|json -b 1
"*"
$ echo '\''"*"'\''|json -b 2
"*"
$ echo '\''"*"'\''|json -b 3
"*"
$ echo '\''"*"'\''|json -b 4
"*"
$ echo '\''"*"'\''|json -b 5
"*"
$ echo '\''"+"'\''|json -b 1
"+"
$ echo '\''"+"'\''|json -b 2
"+"
$ echo '\''"+"'\''|json -b 3
"+"
$ echo '\''"+"'\''|json -b 4
"+"
$ echo '\''"+"'\''|json -b 5
"+"
$ echo '\''","'\''|json -b 1
","
$ echo '\''","'\''|json -b 2
","
$ echo '\''","'\''|json -b 3
","
$ echo '\''","'\''|json -b 4
","
$ echo '\''","'\''|json -b 5
","
$ echo '\''"-"'\''|json -b 1
"-"
$ echo '\''"-"'\''|json -b 2
"-"
$ echo '\''"-"'\''|json -b 3
"-"
$ echo '\''"-"'\''|json -b 4
"-"
$ echo '\''"-"'\''|json -b 5
"-"
$ echo '\''"."'\''|json -b 1
"."
$ echo '\''"."'\''|json -b 2
"."
$ echo '\''"."'\''|json -b 3
"."
$ echo '\''"."'\''|json -b 4
"."
$ echo '\''"."'\''|json -b 5
"."
$ echo '\''"/"'\''|json -b 1
"/"
$ echo '\''"/"'\''|json -b 2
"/"
$ echo '\''"/"'\''|json -b 3
"/"
$ echo '\''"/"'\''|json -b 4
"/"
$ echo '\''"/"'\''|json -b 5
"/"
$ echo '\''"0"'\''|json -b 1
"0"
$ echo '\''"0"'\''|json -b 2
"0"
$ echo '\''"0"'\''|json -b 3
"0"
$ echo '\''"0"'\''|json -b 4
"0"
$ echo '\''"0"'\''|json -b 5
"0"
$ echo '\''"1"'\''|json -b 1
"1"
$ echo '\''"1"'\''|json -b 2
"1"
$ echo '\''"1"'\''|json -b 3
"1"
$ echo '\''"1"'\''|json -b 4
"1"
$ echo '\''"1"'\''|json -b 5
"1"
$ echo '\''"2"'\''|json -b 1
"2"
$ echo '\''"2"'\''|json -b 2
"2"
$ echo '\''"2"'\''|json -b 3
"2"
$ echo '\''"2"'\''|json -b 4
"2"
$ echo '\''"2"'\''|json -b 5
"2"
$ echo '\''"3"'\''|json -b 1
"3"
$ echo '\''"3"'\''|json -b 2
"3"
$ echo '\''"3"'\''|json -b 3
"3"
$ echo '\''"3"'\''|json -b 4
"3"
$ echo '\''"3"'\''|json -b 5
"3"
$ echo '\''"4"'\''|json -b 1
"4"
$ echo '\''"4"'\''|json -b 2
"4"
$ echo '\''"4"'\''|json -b 3
"4"
$ echo '\''"4"'\''|json -b 4
"4"
$ echo '\''"4"'\''|json -b 5
"4"
$ echo '\''"5"'\''|json -b 1
"5"
$ echo '\''"5"'\''|json -b 2
"5"
$ echo '\''"5"'\''|json -b 3
"5"
$ echo '\''"5"'\''|json -b 4
"5"
$ echo '\''"5"'\''|json -b 5
"5"
$ echo '\''"6"'\''|json -b 1
"6"
$ echo '\''"6"'\''|json -b 2
"6"
$ echo '\''"6"'\''|json -b 3
"6"
$ echo '\''"6"'\''|json -b 4
"6"
$ echo '\''"6"'\''|json -b 5
"6"
$ echo '\''"7"'\''|json -b 1
"7"
$ echo '\''"7"'\''|json -b 2
"7"
$ echo '\''"7"'\''|json -b 3
"7"
$ echo '\''"7"'\''|json -b 4
"7"
$ echo '\''"7"'\''|json -b 5
"7"
$ echo '\''"8"'\''|json -b 1
"8"
$ echo '\''"8"'\''|json -b 2
"8"
$ echo '\''"8"'\''|json -b 3
"8"
$ echo '\''"8"'\''|json -b 4
"8"
$ echo '\''"8"'\''|json -b 5
"8"
$ echo '\''"9"'\''|json -b 1
"9"
$ echo '\''"9"'\''|json -b 2
"9"
$ echo '\''"9"'\''|json -b 3
"9"
$ echo '\''"9"'\''|json -b 4
"9"
$ echo '\''"9"'\''|json -b 5
"9"
$ echo '\''":"'\''|json -b 1
":"
$ echo '\''":"'\''|json -b 2
":"
$ echo '\''":"'\''|json -b 3
":"
$ echo '\''":"'\''|json -b 4
":"
$ echo '\''":"'\''|json -b 5
":"
$ echo '\''";"'\''|json -b 1
";"
$ echo '\''";"'\''|json -b 2
";"
$ echo '\''";"'\''|json -b 3
";"
$ echo '\''";"'\''|json -b 4
";"
$ echo '\''";"'\''|json -b 5
";"
$ echo '\''"<"'\''|json -b 1
"<"
$ echo '\''"<"'\''|json -b 2
"<"
$ echo '\''"<"'\''|json -b 3
"<"
$ echo '\''"<"'\''|json -b 4
"<"
$ echo '\''"<"'\''|json -b 5
"<"
$ echo '\''"="'\''|json -b 1
"="
$ echo '\''"="'\''|json -b 2
"="
$ echo '\''"="'\''|json -b 3
"="
$ echo '\''"="'\''|json -b 4
"="
$ echo '\''"="'\''|json -b 5
"="
$ echo '\''">"'\''|json -b 1
">"
$ echo '\''">"'\''|json -b 2
">"
$ echo '\''">"'\''|json -b 3
">"
$ echo '\''">"'\''|json -b 4
">"
$ echo '\''">"'\''|json -b 5
">"
$ echo '\''"?"'\''|json -b 1
"?"
$ echo '\''"?"'\''|json -b 2
"?"
$ echo '\''"?"'\''|json -b 3
"?"
$ echo '\''"?"'\''|json -b 4
"?"
$ echo '\''"?"'\''|json -b 5
"?"
$ echo '\''"@"'\''|json -b 1
"@"
$ echo '\''"@"'\''|json -b 2
"@"
$ echo '\''"@"'\''|json -b 3
"@"
$ echo '\''"@"'\''|json -b 4
"@"
$ echo '\''"@"'\''|json -b 5
"@"
$ echo '\''"A"'\''|json -b 1
"A"
$ echo '\''"A"'\''|json -b 2
"A"
$ echo '\''"A"'\''|json -b 3
"A"
$ echo '\''"A"'\''|json -b 4
"A"
$ echo '\''"A"'\''|json -b 5
"A"
$ echo '\''"B"'\''|json -b 1
"B"
$ echo '\''"B"'\''|json -b 2
"B"
$ echo '\''"B"'\''|json -b 3
"B"
$ echo '\''"B"'\''|json -b 4
"B"
$ echo '\''"B"'\''|json -b 5
"B"
$ echo '\''"C"'\''|json -b 1
"C"
$ echo '\''"C"'\''|json -b 2
"C"
$ echo '\''"C"'\''|json -b 3
"C"
$ echo '\''"C"'\''|json -b 4
"C"
$ echo '\''"C"'\''|json -b 5
"C"
$ echo '\''"D"'\''|json -b 1
"D"
$ echo '\''"D"'\''|json -b 2
"D"
$ echo '\''"D"'\''|json -b 3
"D"
$ echo '\''"D"'\''|json -b 4
"D"
$ echo '\''"D"'\''|json -b 5
"D"
$ echo '\''"E"'\''|json -b 1
"E"
$ echo '\''"E"'\''|json -b 2
"E"
$ echo '\''"E"'\''|json -b 3
"E"
$ echo '\''"E"'\''|json -b 4
"E"
$ echo '\''"E"'\''|json -b 5
"E"
$ echo '\''"F"'\''|json -b 1
"F"
$ echo '\''"F"'\''|json -b 2
"F"
$ echo '\''"F"'\''|json -b 3
"F"
$ echo '\''"F"'\''|json -b 4
"F"
$ echo '\''"F"'\''|json -b 5
"F"
$ echo '\''"G"'\''|json -b 1
"G"
$ echo '\''"G"'\''|json -b 2
"G"
$ echo '\''"G"'\''|json -b 3
"G"
$ echo '\''"G"'\''|json -b 4
"G"
$ echo '\''"G"'\''|json -b 5
"G"
$ echo '\''"H"'\''|json -b 1
"H"
$ echo '\''"H"'\''|json -b 2
"H"
$ echo '\''"H"'\''|json -b 3
"H"
$ echo '\''"H"'\''|json -b 4
"H"
$ echo '\''"H"'\''|json -b 5
"H"
$ echo '\''"I"'\''|json -b 1
"I"
$ echo '\''"I"'\''|json -b 2
"I"
$ echo '\''"I"'\''|json -b 3
"I"
$ echo '\''"I"'\''|json -b 4
"I"
$ echo '\''"I"'\''|json -b 5
"I"
$ echo '\''"J"'\''|json -b 1
"J"
$ echo '\''"J"'\''|json -b 2
"J"
$ echo '\''"J"'\''|json -b 3
"J"
$ echo '\''"J"'\''|json -b 4
"J"
$ echo '\''"J"'\''|json -b 5
"J"
$ echo '\''"K"'\''|json -b 1
"K"
$ echo '\''"K"'\''|json -b 2
"K"
$ echo '\''"K"'\''|json -b 3
"K"
$ echo '\''"K"'\''|json -b 4
"K"
$ echo '\''"K"'\''|json -b 5
"K"
$ echo '\''"L"'\''|json -b 1
"L"
$ echo '\''"L"'\''|json -b 2
"L"
$ echo '\''"L"'\''|json -b 3
"L"
$ echo '\''"L"'\''|json -b 4
"L"
$ echo '\''"L"'\''|json -b 5
"L"
$ echo '\''"M"'\''|json -b 1
"M"
$ echo '\''"M"'\''|json -b 2
"M"
$ echo '\''"M"'\''|json -b 3
"M"
$ echo '\''"M"'\''|json -b 4
"M"
$ echo '\''"M"'\''|json -b 5
"M"
$ echo '\''"N"'\''|json -b 1
"N"
$ echo '\''"N"'\''|json -b 2
"N"
$ echo '\''"N"'\''|json -b 3
"N"
$ echo '\''"N"'\''|json -b 4
"N"
$ echo '\''"N"'\''|json -b 5
"N"
$ echo '\''"O"'\''|json -b 1
"O"
$ echo '\''"O"'\''|json -b 2
"O"
$ echo '\''"O"'\''|json -b 3
"O"
$ echo '\''"O"'\''|json -b 4
"O"
$ echo '\''"O"'\''|json -b 5
"O"
$ echo '\''"P"'\''|json -b 1
"P"
$ echo '\''"P"'\''|json -b 2
"P"
$ echo '\''"P"'\''|json -b 3
"P"
$ echo '\''"P"'\''|json -b 4
"P"
$ echo '\''"P"'\''|json -b 5
"P"
$ echo '\''"Q"'\''|json -b 1
"Q"
$ echo '\''"Q"'\''|json -b 2
"Q"
$ echo '\''"Q"'\''|json -b 3
"Q"
$ echo '\''"Q"'\''|json -b 4
"Q"
$ echo '\''"Q"'\''|json -b 5
"Q"
$ echo '\''"R"'\''|json -b 1
"R"
$ echo '\''"R"'\''|json -b 2
"R"
$ echo '\''"R"'\''|json -b 3
"R"
$ echo '\''"R"'\''|json -b 4
"R"
$ echo '\''"R"'\''|json -b 5
"R"
$ echo '\''"S"'\''|json -b 1
"S"
$ echo '\''"S"'\''|json -b 2
"S"
$ echo '\''"S"'\''|json -b 3
"S"
$ echo '\''"S"'\''|json -b 4
"S"
$ echo '\''"S"'\''|json -b 5
"S"
$ echo '\''"T"'\''|json -b 1
"T"
$ echo '\''"T"'\''|json -b 2
"T"
$ echo '\''"T"'\''|json -b 3
"T"
$ echo '\''"T"'\''|json -b 4
"T"
$ echo '\''"T"'\''|json -b 5
"T"
$ echo '\''"U"'\''|json -b 1
"U"
$ echo '\''"U"'\''|json -b 2
"U"
$ echo '\''"U"'\''|json -b 3
"U"
$ echo '\''"U"'\''|json -b 4
"U"
$ echo '\''"U"'\''|json -b 5
"U"
$ echo '\''"V"'\''|json -b 1
"V"
$ echo '\''"V"'\''|json -b 2
"V"
$ echo '\''"V"'\''|json -b 3
"V"
$ echo '\''"V"'\''|json -b 4
"V"
$ echo '\''"V"'\''|json -b 5
"V"
$ echo '\''"W"'\''|json -b 1
"W"
$ echo '\''"W"'\''|json -b 2
"W"
$ echo '\''"W"'\''|json -b 3
"W"
$ echo '\''"W"'\''|json -b 4
"W"
$ echo '\''"W"'\''|json -b 5
"W"
$ echo '\''"X"'\''|json -b 1
"X"
$ echo '\''"X"'\''|json -b 2
"X"
$ echo '\''"X"'\''|json -b 3
"X"
$ echo '\''"X"'\''|json -b 4
"X"
$ echo '\''"X"'\''|json -b 5
"X"
$ echo '\''"Y"'\''|json -b 1
"Y"
$ echo '\''"Y"'\''|json -b 2
"Y"
$ echo '\''"Y"'\''|json -b 3
"Y"
$ echo '\''"Y"'\''|json -b 4
"Y"
$ echo '\''"Y"'\''|json -b 5
"Y"
$ echo '\''"Z"'\''|json -b 1
"Z"
$ echo '\''"Z"'\''|json -b 2
"Z"
$ echo '\''"Z"'\''|json -b 3
"Z"
$ echo '\''"Z"'\''|json -b 4
"Z"
$ echo '\''"Z"'\''|json -b 5
"Z"
$ echo '\''"["'\''|json -b 1
"["
$ echo '\''"["'\''|json -b 2
"["
$ echo '\''"["'\''|json -b 3
"["
$ echo '\''"["'\''|json -b 4
"["
$ echo '\''"["'\''|json -b 5
"["
$ echo '\''"\"'\''|json -b 1
json: error: <stdin>:1:4: lex error: invalid string literal
json: error: <stdin>:1:4: "\\"
json: error: <stdin>:1:4:     ^
command failed: echo '\''"\"'\''|json -b 1
$ echo '\''"\"'\''|json -b 2
json: error: <stdin>:1:4: lex error: invalid string literal
json: error: <stdin>:1:4: "\\"
json: error: <stdin>:1:4:     ^
command failed: echo '\''"\"'\''|json -b 2
$ echo '\''"\"'\''|json -b 3
json: error: <stdin>:1:4: lex error: invalid string literal
json: error: <stdin>:1:4: "\\"
json: error: <stdin>:1:4:     ^
command failed: echo '\''"\"'\''|json -b 3
$ echo '\''"\"'\''|json -b 4
json: error: <stdin>:1:4: lex error: invalid string literal
json: error: <stdin>:1:4: "\\"
json: error: <stdin>:1:4:     ^
command failed: echo '\''"\"'\''|json -b 4
$ echo '\''"\"'\''|json -b 5
json: error: <stdin>:1:4: lex error: invalid string literal
json: error: <stdin>:1:4: "\\"
json: error: <stdin>:1:4:     ^
command failed: echo '\''"\"'\''|json -b 5
$ echo '\''"]"'\''|json -b 1
"]"
$ echo '\''"]"'\''|json -b 2
"]"
$ echo '\''"]"'\''|json -b 3
"]"
$ echo '\''"]"'\''|json -b 4
"]"
$ echo '\''"]"'\''|json -b 5
"]"
$ echo '\''"^"'\''|json -b 1
"^"
$ echo '\''"^"'\''|json -b 2
"^"
$ echo '\''"^"'\''|json -b 3
"^"
$ echo '\''"^"'\''|json -b 4
"^"
$ echo '\''"^"'\''|json -b 5
"^"
$ echo '\''"_"'\''|json -b 1
"_"
$ echo '\''"_"'\''|json -b 2
"_"
$ echo '\''"_"'\''|json -b 3
"_"
$ echo '\''"_"'\''|json -b 4
"_"
$ echo '\''"_"'\''|json -b 5
"_"
$ echo '\''"`"'\''|json -b 1
"`"
$ echo '\''"`"'\''|json -b 2
"`"
$ echo '\''"`"'\''|json -b 3
"`"
$ echo '\''"`"'\''|json -b 4
"`"
$ echo '\''"`"'\''|json -b 5
"`"
$ echo '\''"a"'\''|json -b 1
"a"
$ echo '\''"a"'\''|json -b 2
"a"
$ echo '\''"a"'\''|json -b 3
"a"
$ echo '\''"a"'\''|json -b 4
"a"
$ echo '\''"a"'\''|json -b 5
"a"
$ echo '\''"b"'\''|json -b 1
"b"
$ echo '\''"b"'\''|json -b 2
"b"
$ echo '\''"b"'\''|json -b 3
"b"
$ echo '\''"b"'\''|json -b 4
"b"
$ echo '\''"b"'\''|json -b 5
"b"
$ echo '\''"c"'\''|json -b 1
"c"
$ echo '\''"c"'\''|json -b 2
"c"
$ echo '\''"c"'\''|json -b 3
"c"
$ echo '\''"c"'\''|json -b 4
"c"
$ echo '\''"c"'\''|json -b 5
"c"
$ echo '\''"d"'\''|json -b 1
"d"
$ echo '\''"d"'\''|json -b 2
"d"
$ echo '\''"d"'\''|json -b 3
"d"
$ echo '\''"d"'\''|json -b 4
"d"
$ echo '\''"d"'\''|json -b 5
"d"
$ echo '\''"e"'\''|json -b 1
"e"
$ echo '\''"e"'\''|json -b 2
"e"
$ echo '\''"e"'\''|json -b 3
"e"
$ echo '\''"e"'\''|json -b 4
"e"
$ echo '\''"e"'\''|json -b 5
"e"
$ echo '\''"f"'\''|json -b 1
"f"
$ echo '\''"f"'\''|json -b 2
"f"
$ echo '\''"f"'\''|json -b 3
"f"
$ echo '\''"f"'\''|json -b 4
"f"
$ echo '\''"f"'\''|json -b 5
"f"
$ echo '\''"g"'\''|json -b 1
"g"
$ echo '\''"g"'\''|json -b 2
"g"
$ echo '\''"g"'\''|json -b 3
"g"
$ echo '\''"g"'\''|json -b 4
"g"
$ echo '\''"g"'\''|json -b 5
"g"
$ echo '\''"h"'\''|json -b 1
"h"
$ echo '\''"h"'\''|json -b 2
"h"
$ echo '\''"h"'\''|json -b 3
"h"
$ echo '\''"h"'\''|json -b 4
"h"
$ echo '\''"h"'\''|json -b 5
"h"
$ echo '\''"i"'\''|json -b 1
"i"
$ echo '\''"i"'\''|json -b 2
"i"
$ echo '\''"i"'\''|json -b 3
"i"
$ echo '\''"i"'\''|json -b 4
"i"
$ echo '\''"i"'\''|json -b 5
"i"
$ echo '\''"j"'\''|json -b 1
"j"
$ echo '\''"j"'\''|json -b 2
"j"
$ echo '\''"j"'\''|json -b 3
"j"
$ echo '\''"j"'\''|json -b 4
"j"
$ echo '\''"j"'\''|json -b 5
"j"
$ echo '\''"k"'\''|json -b 1
"k"
$ echo '\''"k"'\''|json -b 2
"k"
$ echo '\''"k"'\''|json -b 3
"k"
$ echo '\''"k"'\''|json -b 4
"k"
$ echo '\''"k"'\''|json -b 5
"k"
$ echo '\''"l"'\''|json -b 1
"l"
$ echo '\''"l"'\''|json -b 2
"l"
$ echo '\''"l"'\''|json -b 3
"l"
$ echo '\''"l"'\''|json -b 4
"l"
$ echo '\''"l"'\''|json -b 5
"l"
$ echo '\''"m"'\''|json -b 1
"m"
$ echo '\''"m"'\''|json -b 2
"m"
$ echo '\''"m"'\''|json -b 3
"m"
$ echo '\''"m"'\''|json -b 4
"m"
$ echo '\''"m"'\''|json -b 5
"m"
$ echo '\''"n"'\''|json -b 1
"n"
$ echo '\''"n"'\''|json -b 2
"n"
$ echo '\''"n"'\''|json -b 3
"n"
$ echo '\''"n"'\''|json -b 4
"n"
$ echo '\''"n"'\''|json -b 5
"n"
$ echo '\''"o"'\''|json -b 1
"o"
$ echo '\''"o"'\''|json -b 2
"o"
$ echo '\''"o"'\''|json -b 3
"o"
$ echo '\''"o"'\''|json -b 4
"o"
$ echo '\''"o"'\''|json -b 5
"o"
$ echo '\''"p"'\''|json -b 1
"p"
$ echo '\''"p"'\''|json -b 2
"p"
$ echo '\''"p"'\''|json -b 3
"p"
$ echo '\''"p"'\''|json -b 4
"p"
$ echo '\''"p"'\''|json -b 5
"p"
$ echo '\''"q"'\''|json -b 1
"q"
$ echo '\''"q"'\''|json -b 2
"q"
$ echo '\''"q"'\''|json -b 3
"q"
$ echo '\''"q"'\''|json -b 4
"q"
$ echo '\''"q"'\''|json -b 5
"q"
$ echo '\''"r"'\''|json -b 1
"r"
$ echo '\''"r"'\''|json -b 2
"r"
$ echo '\''"r"'\''|json -b 3
"r"
$ echo '\''"r"'\''|json -b 4
"r"
$ echo '\''"r"'\''|json -b 5
"r"
$ echo '\''"s"'\''|json -b 1
"s"
$ echo '\''"s"'\''|json -b 2
"s"
$ echo '\''"s"'\''|json -b 3
"s"
$ echo '\''"s"'\''|json -b 4
"s"
$ echo '\''"s"'\''|json -b 5
"s"
$ echo '\''"t"'\''|json -b 1
"t"
$ echo '\''"t"'\''|json -b 2
"t"
$ echo '\''"t"'\''|json -b 3
"t"
$ echo '\''"t"'\''|json -b 4
"t"
$ echo '\''"t"'\''|json -b 5
"t"
$ echo '\''"u"'\''|json -b 1
"u"
$ echo '\''"u"'\''|json -b 2
"u"
$ echo '\''"u"'\''|json -b 3
"u"
$ echo '\''"u"'\''|json -b 4
"u"
$ echo '\''"u"'\''|json -b 5
"u"
$ echo '\''"v"'\''|json -b 1
"v"
$ echo '\''"v"'\''|json -b 2
"v"
$ echo '\''"v"'\''|json -b 3
"v"
$ echo '\''"v"'\''|json -b 4
"v"
$ echo '\''"v"'\''|json -b 5
"v"
$ echo '\''"w"'\''|json -b 1
"w"
$ echo '\''"w"'\''|json -b 2
"w"
$ echo '\''"w"'\''|json -b 3
"w"
$ echo '\''"w"'\''|json -b 4
"w"
$ echo '\''"w"'\''|json -b 5
"w"
$ echo '\''"x"'\''|json -b 1
"x"
$ echo '\''"x"'\''|json -b 2
"x"
$ echo '\''"x"'\''|json -b 3
"x"
$ echo '\''"x"'\''|json -b 4
"x"
$ echo '\''"x"'\''|json -b 5
"x"
$ echo '\''"y"'\''|json -b 1
"y"
$ echo '\''"y"'\''|json -b 2
"y"
$ echo '\''"y"'\''|json -b 3
"y"
$ echo '\''"y"'\''|json -b 4
"y"
$ echo '\''"y"'\''|json -b 5
"y"
$ echo '\''"z"'\''|json -b 1
"z"
$ echo '\''"z"'\''|json -b 2
"z"
$ echo '\''"z"'\''|json -b 3
"z"
$ echo '\''"z"'\''|json -b 4
"z"
$ echo '\''"z"'\''|json -b 5
"z"
$ echo '\''"{"'\''|json -b 1
"{"
$ echo '\''"{"'\''|json -b 2
"{"
$ echo '\''"{"'\''|json -b 3
"{"
$ echo '\''"{"'\''|json -b 4
"{"
$ echo '\''"{"'\''|json -b 5
"{"
$ echo '\''"|"'\''|json -b 1
"|"
$ echo '\''"|"'\''|json -b 2
"|"
$ echo '\''"|"'\''|json -b 3
"|"
$ echo '\''"|"'\''|json -b 4
"|"
$ echo '\''"|"'\''|json -b 5
"|"
$ echo '\''"}"'\''|json -b 1
"}"
$ echo '\''"}"'\''|json -b 2
"}"
$ echo '\''"}"'\''|json -b 3
"}"
$ echo '\''"}"'\''|json -b 4
"}"
$ echo '\''"}"'\''|json -b 5
"}"
$ echo '\''"~"'\''|json -b 1
"~"
$ echo '\''"~"'\''|json -b 2
"~"
$ echo '\''"~"'\''|json -b 3
"~"
$ echo '\''"~"'\''|json -b 4
"~"
$ echo '\''"~"'\''|json -b 5
"~"
$ echo -e '\''"\x7f"'\''|json -b 1
"\u007f"
$ echo -e '\''"\x7f"'\''|json -b 2
"\u007f"
$ echo -e '\''"\x7f"'\''|json -b 3
"\u007f"
$ echo -e '\''"\x7f"'\''|json -b 4
"\u007f"
$ echo -e '\''"\x7f"'\''|json -b 5
"\u007f"'
) -L string-plain.new <(
echo '$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'
json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; } 2>&1 ||
echo 'command failed: json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'

echo '$ json() { json0 --literal-value --escape-utf8 "$@"; }'
json() { json0 --literal-value --escape-utf8 "$@"; } 2>&1 ||
echo 'command failed: json() { json0 --literal-value --escape-utf8 "$@"; }'

echo '$ echo -e '\''"\x0"'\''|json -b 1'
echo -e '"\x0"'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''"\x0"'\''|json -b 1'

echo '$ echo -e '\''"\x0"'\''|json -b 2'
echo -e '"\x0"'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''"\x0"'\''|json -b 2'

echo '$ echo -e '\''"\x0"'\''|json -b 3'
echo -e '"\x0"'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''"\x0"'\''|json -b 3'

echo '$ echo -e '\''"\x0"'\''|json -b 4'
echo -e '"\x0"'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''"\x0"'\''|json -b 4'

echo '$ echo -e '\''"\x0"'\''|json -b 5'
echo -e '"\x0"'|json -b 5 2>&1 ||
echo 'command failed: echo -e '\''"\x0"'\''|json -b 5'

echo '$ echo -e '\''"\x1"'\''|json -b 1'
echo -e '"\x1"'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''"\x1"'\''|json -b 1'

echo '$ echo -e '\''"\x1"'\''|json -b 2'
echo -e '"\x1"'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''"\x1"'\''|json -b 2'

echo '$ echo -e '\''"\x1"'\''|json -b 3'
echo -e '"\x1"'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''"\x1"'\''|json -b 3'

echo '$ echo -e '\''"\x1"'\''|json -b 4'
echo -e '"\x1"'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''"\x1"'\''|json -b 4'

echo '$ echo -e '\''"\x1"'\''|json -b 5'
echo -e '"\x1"'|json -b 5 2>&1 ||
echo 'command failed: echo -e '\''"\x1"'\''|json -b 5'

echo '$ echo -e '\''"\x2"'\''|json -b 1'
echo -e '"\x2"'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''"\x2"'\''|json -b 1'

echo '$ echo -e '\''"\x2"'\''|json -b 2'
echo -e '"\x2"'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''"\x2"'\''|json -b 2'

echo '$ echo -e '\''"\x2"'\''|json -b 3'
echo -e '"\x2"'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''"\x2"'\''|json -b 3'

echo '$ echo -e '\''"\x2"'\''|json -b 4'
echo -e '"\x2"'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''"\x2"'\''|json -b 4'

echo '$ echo -e '\''"\x2"'\''|json -b 5'
echo -e '"\x2"'|json -b 5 2>&1 ||
echo 'command failed: echo -e '\''"\x2"'\''|json -b 5'

echo '$ echo -e '\''"\x3"'\''|json -b 1'
echo -e '"\x3"'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''"\x3"'\''|json -b 1'

echo '$ echo -e '\''"\x3"'\''|json -b 2'
echo -e '"\x3"'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''"\x3"'\''|json -b 2'

echo '$ echo -e '\''"\x3"'\''|json -b 3'
echo -e '"\x3"'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''"\x3"'\''|json -b 3'

echo '$ echo -e '\''"\x3"'\''|json -b 4'
echo -e '"\x3"'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''"\x3"'\''|json -b 4'

echo '$ echo -e '\''"\x3"'\''|json -b 5'
echo -e '"\x3"'|json -b 5 2>&1 ||
echo 'command failed: echo -e '\''"\x3"'\''|json -b 5'

echo '$ echo -e '\''"\x4"'\''|json -b 1'
echo -e '"\x4"'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''"\x4"'\''|json -b 1'

echo '$ echo -e '\''"\x4"'\''|json -b 2'
echo -e '"\x4"'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''"\x4"'\''|json -b 2'

echo '$ echo -e '\''"\x4"'\''|json -b 3'
echo -e '"\x4"'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''"\x4"'\''|json -b 3'

echo '$ echo -e '\''"\x4"'\''|json -b 4'
echo -e '"\x4"'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''"\x4"'\''|json -b 4'

echo '$ echo -e '\''"\x4"'\''|json -b 5'
echo -e '"\x4"'|json -b 5 2>&1 ||
echo 'command failed: echo -e '\''"\x4"'\''|json -b 5'

echo '$ echo -e '\''"\x5"'\''|json -b 1'
echo -e '"\x5"'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''"\x5"'\''|json -b 1'

echo '$ echo -e '\''"\x5"'\''|json -b 2'
echo -e '"\x5"'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''"\x5"'\''|json -b 2'

echo '$ echo -e '\''"\x5"'\''|json -b 3'
echo -e '"\x5"'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''"\x5"'\''|json -b 3'

echo '$ echo -e '\''"\x5"'\''|json -b 4'
echo -e '"\x5"'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''"\x5"'\''|json -b 4'

echo '$ echo -e '\''"\x5"'\''|json -b 5'
echo -e '"\x5"'|json -b 5 2>&1 ||
echo 'command failed: echo -e '\''"\x5"'\''|json -b 5'

echo '$ echo -e '\''"\x6"'\''|json -b 1'
echo -e '"\x6"'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''"\x6"'\''|json -b 1'

echo '$ echo -e '\''"\x6"'\''|json -b 2'
echo -e '"\x6"'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''"\x6"'\''|json -b 2'

echo '$ echo -e '\''"\x6"'\''|json -b 3'
echo -e '"\x6"'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''"\x6"'\''|json -b 3'

echo '$ echo -e '\''"\x6"'\''|json -b 4'
echo -e '"\x6"'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''"\x6"'\''|json -b 4'

echo '$ echo -e '\''"\x6"'\''|json -b 5'
echo -e '"\x6"'|json -b 5 2>&1 ||
echo 'command failed: echo -e '\''"\x6"'\''|json -b 5'

echo '$ echo -e '\''"\x7"'\''|json -b 1'
echo -e '"\x7"'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''"\x7"'\''|json -b 1'

echo '$ echo -e '\''"\x7"'\''|json -b 2'
echo -e '"\x7"'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''"\x7"'\''|json -b 2'

echo '$ echo -e '\''"\x7"'\''|json -b 3'
echo -e '"\x7"'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''"\x7"'\''|json -b 3'

echo '$ echo -e '\''"\x7"'\''|json -b 4'
echo -e '"\x7"'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''"\x7"'\''|json -b 4'

echo '$ echo -e '\''"\x7"'\''|json -b 5'
echo -e '"\x7"'|json -b 5 2>&1 ||
echo 'command failed: echo -e '\''"\x7"'\''|json -b 5'

echo '$ echo -e '\''"\x8"'\''|json -b 1'
echo -e '"\x8"'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''"\x8"'\''|json -b 1'

echo '$ echo -e '\''"\x8"'\''|json -b 2'
echo -e '"\x8"'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''"\x8"'\''|json -b 2'

echo '$ echo -e '\''"\x8"'\''|json -b 3'
echo -e '"\x8"'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''"\x8"'\''|json -b 3'

echo '$ echo -e '\''"\x8"'\''|json -b 4'
echo -e '"\x8"'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''"\x8"'\''|json -b 4'

echo '$ echo -e '\''"\x8"'\''|json -b 5'
echo -e '"\x8"'|json -b 5 2>&1 ||
echo 'command failed: echo -e '\''"\x8"'\''|json -b 5'

echo '$ echo -e '\''"\x9"'\''|json -b 1'
echo -e '"\x9"'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''"\x9"'\''|json -b 1'

echo '$ echo -e '\''"\x9"'\''|json -b 2'
echo -e '"\x9"'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''"\x9"'\''|json -b 2'

echo '$ echo -e '\''"\x9"'\''|json -b 3'
echo -e '"\x9"'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''"\x9"'\''|json -b 3'

echo '$ echo -e '\''"\x9"'\''|json -b 4'
echo -e '"\x9"'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''"\x9"'\''|json -b 4'

echo '$ echo -e '\''"\x9"'\''|json -b 5'
echo -e '"\x9"'|json -b 5 2>&1 ||
echo 'command failed: echo -e '\''"\x9"'\''|json -b 5'

echo '$ echo -e '\''"\xa"'\''|json -b 1'
echo -e '"\xa"'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''"\xa"'\''|json -b 1'

echo '$ echo -e '\''"\xa"'\''|json -b 2'
echo -e '"\xa"'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''"\xa"'\''|json -b 2'

echo '$ echo -e '\''"\xa"'\''|json -b 3'
echo -e '"\xa"'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''"\xa"'\''|json -b 3'

echo '$ echo -e '\''"\xa"'\''|json -b 4'
echo -e '"\xa"'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''"\xa"'\''|json -b 4'

echo '$ echo -e '\''"\xa"'\''|json -b 5'
echo -e '"\xa"'|json -b 5 2>&1 ||
echo 'command failed: echo -e '\''"\xa"'\''|json -b 5'

echo '$ echo -e '\''"\xb"'\''|json -b 1'
echo -e '"\xb"'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''"\xb"'\''|json -b 1'

echo '$ echo -e '\''"\xb"'\''|json -b 2'
echo -e '"\xb"'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''"\xb"'\''|json -b 2'

echo '$ echo -e '\''"\xb"'\''|json -b 3'
echo -e '"\xb"'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''"\xb"'\''|json -b 3'

echo '$ echo -e '\''"\xb"'\''|json -b 4'
echo -e '"\xb"'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''"\xb"'\''|json -b 4'

echo '$ echo -e '\''"\xb"'\''|json -b 5'
echo -e '"\xb"'|json -b 5 2>&1 ||
echo 'command failed: echo -e '\''"\xb"'\''|json -b 5'

echo '$ echo -e '\''"\xc"'\''|json -b 1'
echo -e '"\xc"'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''"\xc"'\''|json -b 1'

echo '$ echo -e '\''"\xc"'\''|json -b 2'
echo -e '"\xc"'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''"\xc"'\''|json -b 2'

echo '$ echo -e '\''"\xc"'\''|json -b 3'
echo -e '"\xc"'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''"\xc"'\''|json -b 3'

echo '$ echo -e '\''"\xc"'\''|json -b 4'
echo -e '"\xc"'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''"\xc"'\''|json -b 4'

echo '$ echo -e '\''"\xc"'\''|json -b 5'
echo -e '"\xc"'|json -b 5 2>&1 ||
echo 'command failed: echo -e '\''"\xc"'\''|json -b 5'

echo '$ echo -e '\''"\xd"'\''|json -b 1'
echo -e '"\xd"'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''"\xd"'\''|json -b 1'

echo '$ echo -e '\''"\xd"'\''|json -b 2'
echo -e '"\xd"'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''"\xd"'\''|json -b 2'

echo '$ echo -e '\''"\xd"'\''|json -b 3'
echo -e '"\xd"'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''"\xd"'\''|json -b 3'

echo '$ echo -e '\''"\xd"'\''|json -b 4'
echo -e '"\xd"'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''"\xd"'\''|json -b 4'

echo '$ echo -e '\''"\xd"'\''|json -b 5'
echo -e '"\xd"'|json -b 5 2>&1 ||
echo 'command failed: echo -e '\''"\xd"'\''|json -b 5'

echo '$ echo -e '\''"\xe"'\''|json -b 1'
echo -e '"\xe"'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''"\xe"'\''|json -b 1'

echo '$ echo -e '\''"\xe"'\''|json -b 2'
echo -e '"\xe"'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''"\xe"'\''|json -b 2'

echo '$ echo -e '\''"\xe"'\''|json -b 3'
echo -e '"\xe"'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''"\xe"'\''|json -b 3'

echo '$ echo -e '\''"\xe"'\''|json -b 4'
echo -e '"\xe"'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''"\xe"'\''|json -b 4'

echo '$ echo -e '\''"\xe"'\''|json -b 5'
echo -e '"\xe"'|json -b 5 2>&1 ||
echo 'command failed: echo -e '\''"\xe"'\''|json -b 5'

echo '$ echo -e '\''"\xf"'\''|json -b 1'
echo -e '"\xf"'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''"\xf"'\''|json -b 1'

echo '$ echo -e '\''"\xf"'\''|json -b 2'
echo -e '"\xf"'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''"\xf"'\''|json -b 2'

echo '$ echo -e '\''"\xf"'\''|json -b 3'
echo -e '"\xf"'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''"\xf"'\''|json -b 3'

echo '$ echo -e '\''"\xf"'\''|json -b 4'
echo -e '"\xf"'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''"\xf"'\''|json -b 4'

echo '$ echo -e '\''"\xf"'\''|json -b 5'
echo -e '"\xf"'|json -b 5 2>&1 ||
echo 'command failed: echo -e '\''"\xf"'\''|json -b 5'

echo '$ echo -e '\''"\x10"'\''|json -b 1'
echo -e '"\x10"'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''"\x10"'\''|json -b 1'

echo '$ echo -e '\''"\x10"'\''|json -b 2'
echo -e '"\x10"'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''"\x10"'\''|json -b 2'

echo '$ echo -e '\''"\x10"'\''|json -b 3'
echo -e '"\x10"'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''"\x10"'\''|json -b 3'

echo '$ echo -e '\''"\x10"'\''|json -b 4'
echo -e '"\x10"'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''"\x10"'\''|json -b 4'

echo '$ echo -e '\''"\x10"'\''|json -b 5'
echo -e '"\x10"'|json -b 5 2>&1 ||
echo 'command failed: echo -e '\''"\x10"'\''|json -b 5'

echo '$ echo -e '\''"\x11"'\''|json -b 1'
echo -e '"\x11"'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''"\x11"'\''|json -b 1'

echo '$ echo -e '\''"\x11"'\''|json -b 2'
echo -e '"\x11"'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''"\x11"'\''|json -b 2'

echo '$ echo -e '\''"\x11"'\''|json -b 3'
echo -e '"\x11"'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''"\x11"'\''|json -b 3'

echo '$ echo -e '\''"\x11"'\''|json -b 4'
echo -e '"\x11"'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''"\x11"'\''|json -b 4'

echo '$ echo -e '\''"\x11"'\''|json -b 5'
echo -e '"\x11"'|json -b 5 2>&1 ||
echo 'command failed: echo -e '\''"\x11"'\''|json -b 5'

echo '$ echo -e '\''"\x12"'\''|json -b 1'
echo -e '"\x12"'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''"\x12"'\''|json -b 1'

echo '$ echo -e '\''"\x12"'\''|json -b 2'
echo -e '"\x12"'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''"\x12"'\''|json -b 2'

echo '$ echo -e '\''"\x12"'\''|json -b 3'
echo -e '"\x12"'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''"\x12"'\''|json -b 3'

echo '$ echo -e '\''"\x12"'\''|json -b 4'
echo -e '"\x12"'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''"\x12"'\''|json -b 4'

echo '$ echo -e '\''"\x12"'\''|json -b 5'
echo -e '"\x12"'|json -b 5 2>&1 ||
echo 'command failed: echo -e '\''"\x12"'\''|json -b 5'

echo '$ echo -e '\''"\x13"'\''|json -b 1'
echo -e '"\x13"'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''"\x13"'\''|json -b 1'

echo '$ echo -e '\''"\x13"'\''|json -b 2'
echo -e '"\x13"'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''"\x13"'\''|json -b 2'

echo '$ echo -e '\''"\x13"'\''|json -b 3'
echo -e '"\x13"'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''"\x13"'\''|json -b 3'

echo '$ echo -e '\''"\x13"'\''|json -b 4'
echo -e '"\x13"'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''"\x13"'\''|json -b 4'

echo '$ echo -e '\''"\x13"'\''|json -b 5'
echo -e '"\x13"'|json -b 5 2>&1 ||
echo 'command failed: echo -e '\''"\x13"'\''|json -b 5'

echo '$ echo -e '\''"\x14"'\''|json -b 1'
echo -e '"\x14"'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''"\x14"'\''|json -b 1'

echo '$ echo -e '\''"\x14"'\''|json -b 2'
echo -e '"\x14"'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''"\x14"'\''|json -b 2'

echo '$ echo -e '\''"\x14"'\''|json -b 3'
echo -e '"\x14"'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''"\x14"'\''|json -b 3'

echo '$ echo -e '\''"\x14"'\''|json -b 4'
echo -e '"\x14"'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''"\x14"'\''|json -b 4'

echo '$ echo -e '\''"\x14"'\''|json -b 5'
echo -e '"\x14"'|json -b 5 2>&1 ||
echo 'command failed: echo -e '\''"\x14"'\''|json -b 5'

echo '$ echo -e '\''"\x15"'\''|json -b 1'
echo -e '"\x15"'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''"\x15"'\''|json -b 1'

echo '$ echo -e '\''"\x15"'\''|json -b 2'
echo -e '"\x15"'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''"\x15"'\''|json -b 2'

echo '$ echo -e '\''"\x15"'\''|json -b 3'
echo -e '"\x15"'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''"\x15"'\''|json -b 3'

echo '$ echo -e '\''"\x15"'\''|json -b 4'
echo -e '"\x15"'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''"\x15"'\''|json -b 4'

echo '$ echo -e '\''"\x15"'\''|json -b 5'
echo -e '"\x15"'|json -b 5 2>&1 ||
echo 'command failed: echo -e '\''"\x15"'\''|json -b 5'

echo '$ echo -e '\''"\x16"'\''|json -b 1'
echo -e '"\x16"'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''"\x16"'\''|json -b 1'

echo '$ echo -e '\''"\x16"'\''|json -b 2'
echo -e '"\x16"'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''"\x16"'\''|json -b 2'

echo '$ echo -e '\''"\x16"'\''|json -b 3'
echo -e '"\x16"'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''"\x16"'\''|json -b 3'

echo '$ echo -e '\''"\x16"'\''|json -b 4'
echo -e '"\x16"'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''"\x16"'\''|json -b 4'

echo '$ echo -e '\''"\x16"'\''|json -b 5'
echo -e '"\x16"'|json -b 5 2>&1 ||
echo 'command failed: echo -e '\''"\x16"'\''|json -b 5'

echo '$ echo -e '\''"\x17"'\''|json -b 1'
echo -e '"\x17"'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''"\x17"'\''|json -b 1'

echo '$ echo -e '\''"\x17"'\''|json -b 2'
echo -e '"\x17"'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''"\x17"'\''|json -b 2'

echo '$ echo -e '\''"\x17"'\''|json -b 3'
echo -e '"\x17"'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''"\x17"'\''|json -b 3'

echo '$ echo -e '\''"\x17"'\''|json -b 4'
echo -e '"\x17"'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''"\x17"'\''|json -b 4'

echo '$ echo -e '\''"\x17"'\''|json -b 5'
echo -e '"\x17"'|json -b 5 2>&1 ||
echo 'command failed: echo -e '\''"\x17"'\''|json -b 5'

echo '$ echo -e '\''"\x18"'\''|json -b 1'
echo -e '"\x18"'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''"\x18"'\''|json -b 1'

echo '$ echo -e '\''"\x18"'\''|json -b 2'
echo -e '"\x18"'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''"\x18"'\''|json -b 2'

echo '$ echo -e '\''"\x18"'\''|json -b 3'
echo -e '"\x18"'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''"\x18"'\''|json -b 3'

echo '$ echo -e '\''"\x18"'\''|json -b 4'
echo -e '"\x18"'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''"\x18"'\''|json -b 4'

echo '$ echo -e '\''"\x18"'\''|json -b 5'
echo -e '"\x18"'|json -b 5 2>&1 ||
echo 'command failed: echo -e '\''"\x18"'\''|json -b 5'

echo '$ echo -e '\''"\x19"'\''|json -b 1'
echo -e '"\x19"'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''"\x19"'\''|json -b 1'

echo '$ echo -e '\''"\x19"'\''|json -b 2'
echo -e '"\x19"'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''"\x19"'\''|json -b 2'

echo '$ echo -e '\''"\x19"'\''|json -b 3'
echo -e '"\x19"'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''"\x19"'\''|json -b 3'

echo '$ echo -e '\''"\x19"'\''|json -b 4'
echo -e '"\x19"'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''"\x19"'\''|json -b 4'

echo '$ echo -e '\''"\x19"'\''|json -b 5'
echo -e '"\x19"'|json -b 5 2>&1 ||
echo 'command failed: echo -e '\''"\x19"'\''|json -b 5'

echo '$ echo -e '\''"\x1a"'\''|json -b 1'
echo -e '"\x1a"'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''"\x1a"'\''|json -b 1'

echo '$ echo -e '\''"\x1a"'\''|json -b 2'
echo -e '"\x1a"'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''"\x1a"'\''|json -b 2'

echo '$ echo -e '\''"\x1a"'\''|json -b 3'
echo -e '"\x1a"'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''"\x1a"'\''|json -b 3'

echo '$ echo -e '\''"\x1a"'\''|json -b 4'
echo -e '"\x1a"'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''"\x1a"'\''|json -b 4'

echo '$ echo -e '\''"\x1a"'\''|json -b 5'
echo -e '"\x1a"'|json -b 5 2>&1 ||
echo 'command failed: echo -e '\''"\x1a"'\''|json -b 5'

echo '$ echo -e '\''"\x1b"'\''|json -b 1'
echo -e '"\x1b"'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''"\x1b"'\''|json -b 1'

echo '$ echo -e '\''"\x1b"'\''|json -b 2'
echo -e '"\x1b"'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''"\x1b"'\''|json -b 2'

echo '$ echo -e '\''"\x1b"'\''|json -b 3'
echo -e '"\x1b"'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''"\x1b"'\''|json -b 3'

echo '$ echo -e '\''"\x1b"'\''|json -b 4'
echo -e '"\x1b"'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''"\x1b"'\''|json -b 4'

echo '$ echo -e '\''"\x1b"'\''|json -b 5'
echo -e '"\x1b"'|json -b 5 2>&1 ||
echo 'command failed: echo -e '\''"\x1b"'\''|json -b 5'

echo '$ echo -e '\''"\x1c"'\''|json -b 1'
echo -e '"\x1c"'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''"\x1c"'\''|json -b 1'

echo '$ echo -e '\''"\x1c"'\''|json -b 2'
echo -e '"\x1c"'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''"\x1c"'\''|json -b 2'

echo '$ echo -e '\''"\x1c"'\''|json -b 3'
echo -e '"\x1c"'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''"\x1c"'\''|json -b 3'

echo '$ echo -e '\''"\x1c"'\''|json -b 4'
echo -e '"\x1c"'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''"\x1c"'\''|json -b 4'

echo '$ echo -e '\''"\x1c"'\''|json -b 5'
echo -e '"\x1c"'|json -b 5 2>&1 ||
echo 'command failed: echo -e '\''"\x1c"'\''|json -b 5'

echo '$ echo -e '\''"\x1d"'\''|json -b 1'
echo -e '"\x1d"'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''"\x1d"'\''|json -b 1'

echo '$ echo -e '\''"\x1d"'\''|json -b 2'
echo -e '"\x1d"'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''"\x1d"'\''|json -b 2'

echo '$ echo -e '\''"\x1d"'\''|json -b 3'
echo -e '"\x1d"'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''"\x1d"'\''|json -b 3'

echo '$ echo -e '\''"\x1d"'\''|json -b 4'
echo -e '"\x1d"'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''"\x1d"'\''|json -b 4'

echo '$ echo -e '\''"\x1d"'\''|json -b 5'
echo -e '"\x1d"'|json -b 5 2>&1 ||
echo 'command failed: echo -e '\''"\x1d"'\''|json -b 5'

echo '$ echo -e '\''"\x1e"'\''|json -b 1'
echo -e '"\x1e"'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''"\x1e"'\''|json -b 1'

echo '$ echo -e '\''"\x1e"'\''|json -b 2'
echo -e '"\x1e"'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''"\x1e"'\''|json -b 2'

echo '$ echo -e '\''"\x1e"'\''|json -b 3'
echo -e '"\x1e"'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''"\x1e"'\''|json -b 3'

echo '$ echo -e '\''"\x1e"'\''|json -b 4'
echo -e '"\x1e"'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''"\x1e"'\''|json -b 4'

echo '$ echo -e '\''"\x1e"'\''|json -b 5'
echo -e '"\x1e"'|json -b 5 2>&1 ||
echo 'command failed: echo -e '\''"\x1e"'\''|json -b 5'

echo '$ echo -e '\''"\x1f"'\''|json -b 1'
echo -e '"\x1f"'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''"\x1f"'\''|json -b 1'

echo '$ echo -e '\''"\x1f"'\''|json -b 2'
echo -e '"\x1f"'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''"\x1f"'\''|json -b 2'

echo '$ echo -e '\''"\x1f"'\''|json -b 3'
echo -e '"\x1f"'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''"\x1f"'\''|json -b 3'

echo '$ echo -e '\''"\x1f"'\''|json -b 4'
echo -e '"\x1f"'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''"\x1f"'\''|json -b 4'

echo '$ echo -e '\''"\x1f"'\''|json -b 5'
echo -e '"\x1f"'|json -b 5 2>&1 ||
echo 'command failed: echo -e '\''"\x1f"'\''|json -b 5'

echo '$ echo '\''" "'\''|json -b 1'
echo '" "'|json -b 1 2>&1 ||
echo 'command failed: echo '\''" "'\''|json -b 1'

echo '$ echo '\''" "'\''|json -b 2'
echo '" "'|json -b 2 2>&1 ||
echo 'command failed: echo '\''" "'\''|json -b 2'

echo '$ echo '\''" "'\''|json -b 3'
echo '" "'|json -b 3 2>&1 ||
echo 'command failed: echo '\''" "'\''|json -b 3'

echo '$ echo '\''" "'\''|json -b 4'
echo '" "'|json -b 4 2>&1 ||
echo 'command failed: echo '\''" "'\''|json -b 4'

echo '$ echo '\''" "'\''|json -b 5'
echo '" "'|json -b 5 2>&1 ||
echo 'command failed: echo '\''" "'\''|json -b 5'

echo '$ echo '\''"!"'\''|json -b 1'
echo '"!"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"!"'\''|json -b 1'

echo '$ echo '\''"!"'\''|json -b 2'
echo '"!"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"!"'\''|json -b 2'

echo '$ echo '\''"!"'\''|json -b 3'
echo '"!"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"!"'\''|json -b 3'

echo '$ echo '\''"!"'\''|json -b 4'
echo '"!"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"!"'\''|json -b 4'

echo '$ echo '\''"!"'\''|json -b 5'
echo '"!"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"!"'\''|json -b 5'

echo '$ echo '\''"""'\''|json -b 1'
echo '"""'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"""'\''|json -b 1'

echo '$ echo '\''"""'\''|json -b 2'
echo '"""'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"""'\''|json -b 2'

echo '$ echo '\''"""'\''|json -b 3'
echo '"""'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"""'\''|json -b 3'

echo '$ echo '\''"""'\''|json -b 4'
echo '"""'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"""'\''|json -b 4'

echo '$ echo '\''"""'\''|json -b 5'
echo '"""'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"""'\''|json -b 5'

echo '$ echo '\''"#"'\''|json -b 1'
echo '"#"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"#"'\''|json -b 1'

echo '$ echo '\''"#"'\''|json -b 2'
echo '"#"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"#"'\''|json -b 2'

echo '$ echo '\''"#"'\''|json -b 3'
echo '"#"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"#"'\''|json -b 3'

echo '$ echo '\''"#"'\''|json -b 4'
echo '"#"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"#"'\''|json -b 4'

echo '$ echo '\''"#"'\''|json -b 5'
echo '"#"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"#"'\''|json -b 5'

echo '$ echo '\''"$"'\''|json -b 1'
echo '"$"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"$"'\''|json -b 1'

echo '$ echo '\''"$"'\''|json -b 2'
echo '"$"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"$"'\''|json -b 2'

echo '$ echo '\''"$"'\''|json -b 3'
echo '"$"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"$"'\''|json -b 3'

echo '$ echo '\''"$"'\''|json -b 4'
echo '"$"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"$"'\''|json -b 4'

echo '$ echo '\''"$"'\''|json -b 5'
echo '"$"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"$"'\''|json -b 5'

echo '$ echo '\''"%"'\''|json -b 1'
echo '"%"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"%"'\''|json -b 1'

echo '$ echo '\''"%"'\''|json -b 2'
echo '"%"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"%"'\''|json -b 2'

echo '$ echo '\''"%"'\''|json -b 3'
echo '"%"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"%"'\''|json -b 3'

echo '$ echo '\''"%"'\''|json -b 4'
echo '"%"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"%"'\''|json -b 4'

echo '$ echo '\''"%"'\''|json -b 5'
echo '"%"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"%"'\''|json -b 5'

echo '$ echo '\''"&"'\''|json -b 1'
echo '"&"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"&"'\''|json -b 1'

echo '$ echo '\''"&"'\''|json -b 2'
echo '"&"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"&"'\''|json -b 2'

echo '$ echo '\''"&"'\''|json -b 3'
echo '"&"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"&"'\''|json -b 3'

echo '$ echo '\''"&"'\''|json -b 4'
echo '"&"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"&"'\''|json -b 4'

echo '$ echo '\''"&"'\''|json -b 5'
echo '"&"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"&"'\''|json -b 5'

echo '$ echo -e '\''"\x27"'\''|json -b 1'
echo -e '"\x27"'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''"\x27"'\''|json -b 1'

echo '$ echo -e '\''"\x27"'\''|json -b 2'
echo -e '"\x27"'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''"\x27"'\''|json -b 2'

echo '$ echo -e '\''"\x27"'\''|json -b 3'
echo -e '"\x27"'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''"\x27"'\''|json -b 3'

echo '$ echo -e '\''"\x27"'\''|json -b 4'
echo -e '"\x27"'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''"\x27"'\''|json -b 4'

echo '$ echo -e '\''"\x27"'\''|json -b 5'
echo -e '"\x27"'|json -b 5 2>&1 ||
echo 'command failed: echo -e '\''"\x27"'\''|json -b 5'

echo '$ echo '\''"("'\''|json -b 1'
echo '"("'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"("'\''|json -b 1'

echo '$ echo '\''"("'\''|json -b 2'
echo '"("'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"("'\''|json -b 2'

echo '$ echo '\''"("'\''|json -b 3'
echo '"("'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"("'\''|json -b 3'

echo '$ echo '\''"("'\''|json -b 4'
echo '"("'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"("'\''|json -b 4'

echo '$ echo '\''"("'\''|json -b 5'
echo '"("'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"("'\''|json -b 5'

echo '$ echo '\''")"'\''|json -b 1'
echo '")"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''")"'\''|json -b 1'

echo '$ echo '\''")"'\''|json -b 2'
echo '")"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''")"'\''|json -b 2'

echo '$ echo '\''")"'\''|json -b 3'
echo '")"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''")"'\''|json -b 3'

echo '$ echo '\''")"'\''|json -b 4'
echo '")"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''")"'\''|json -b 4'

echo '$ echo '\''")"'\''|json -b 5'
echo '")"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''")"'\''|json -b 5'

echo '$ echo '\''"*"'\''|json -b 1'
echo '"*"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"*"'\''|json -b 1'

echo '$ echo '\''"*"'\''|json -b 2'
echo '"*"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"*"'\''|json -b 2'

echo '$ echo '\''"*"'\''|json -b 3'
echo '"*"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"*"'\''|json -b 3'

echo '$ echo '\''"*"'\''|json -b 4'
echo '"*"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"*"'\''|json -b 4'

echo '$ echo '\''"*"'\''|json -b 5'
echo '"*"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"*"'\''|json -b 5'

echo '$ echo '\''"+"'\''|json -b 1'
echo '"+"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"+"'\''|json -b 1'

echo '$ echo '\''"+"'\''|json -b 2'
echo '"+"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"+"'\''|json -b 2'

echo '$ echo '\''"+"'\''|json -b 3'
echo '"+"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"+"'\''|json -b 3'

echo '$ echo '\''"+"'\''|json -b 4'
echo '"+"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"+"'\''|json -b 4'

echo '$ echo '\''"+"'\''|json -b 5'
echo '"+"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"+"'\''|json -b 5'

echo '$ echo '\''","'\''|json -b 1'
echo '","'|json -b 1 2>&1 ||
echo 'command failed: echo '\''","'\''|json -b 1'

echo '$ echo '\''","'\''|json -b 2'
echo '","'|json -b 2 2>&1 ||
echo 'command failed: echo '\''","'\''|json -b 2'

echo '$ echo '\''","'\''|json -b 3'
echo '","'|json -b 3 2>&1 ||
echo 'command failed: echo '\''","'\''|json -b 3'

echo '$ echo '\''","'\''|json -b 4'
echo '","'|json -b 4 2>&1 ||
echo 'command failed: echo '\''","'\''|json -b 4'

echo '$ echo '\''","'\''|json -b 5'
echo '","'|json -b 5 2>&1 ||
echo 'command failed: echo '\''","'\''|json -b 5'

echo '$ echo '\''"-"'\''|json -b 1'
echo '"-"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"-"'\''|json -b 1'

echo '$ echo '\''"-"'\''|json -b 2'
echo '"-"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"-"'\''|json -b 2'

echo '$ echo '\''"-"'\''|json -b 3'
echo '"-"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"-"'\''|json -b 3'

echo '$ echo '\''"-"'\''|json -b 4'
echo '"-"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"-"'\''|json -b 4'

echo '$ echo '\''"-"'\''|json -b 5'
echo '"-"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"-"'\''|json -b 5'

echo '$ echo '\''"."'\''|json -b 1'
echo '"."'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"."'\''|json -b 1'

echo '$ echo '\''"."'\''|json -b 2'
echo '"."'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"."'\''|json -b 2'

echo '$ echo '\''"."'\''|json -b 3'
echo '"."'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"."'\''|json -b 3'

echo '$ echo '\''"."'\''|json -b 4'
echo '"."'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"."'\''|json -b 4'

echo '$ echo '\''"."'\''|json -b 5'
echo '"."'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"."'\''|json -b 5'

echo '$ echo '\''"/"'\''|json -b 1'
echo '"/"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"/"'\''|json -b 1'

echo '$ echo '\''"/"'\''|json -b 2'
echo '"/"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"/"'\''|json -b 2'

echo '$ echo '\''"/"'\''|json -b 3'
echo '"/"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"/"'\''|json -b 3'

echo '$ echo '\''"/"'\''|json -b 4'
echo '"/"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"/"'\''|json -b 4'

echo '$ echo '\''"/"'\''|json -b 5'
echo '"/"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"/"'\''|json -b 5'

echo '$ echo '\''"0"'\''|json -b 1'
echo '"0"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"0"'\''|json -b 1'

echo '$ echo '\''"0"'\''|json -b 2'
echo '"0"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"0"'\''|json -b 2'

echo '$ echo '\''"0"'\''|json -b 3'
echo '"0"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"0"'\''|json -b 3'

echo '$ echo '\''"0"'\''|json -b 4'
echo '"0"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"0"'\''|json -b 4'

echo '$ echo '\''"0"'\''|json -b 5'
echo '"0"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"0"'\''|json -b 5'

echo '$ echo '\''"1"'\''|json -b 1'
echo '"1"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"1"'\''|json -b 1'

echo '$ echo '\''"1"'\''|json -b 2'
echo '"1"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"1"'\''|json -b 2'

echo '$ echo '\''"1"'\''|json -b 3'
echo '"1"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"1"'\''|json -b 3'

echo '$ echo '\''"1"'\''|json -b 4'
echo '"1"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"1"'\''|json -b 4'

echo '$ echo '\''"1"'\''|json -b 5'
echo '"1"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"1"'\''|json -b 5'

echo '$ echo '\''"2"'\''|json -b 1'
echo '"2"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"2"'\''|json -b 1'

echo '$ echo '\''"2"'\''|json -b 2'
echo '"2"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"2"'\''|json -b 2'

echo '$ echo '\''"2"'\''|json -b 3'
echo '"2"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"2"'\''|json -b 3'

echo '$ echo '\''"2"'\''|json -b 4'
echo '"2"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"2"'\''|json -b 4'

echo '$ echo '\''"2"'\''|json -b 5'
echo '"2"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"2"'\''|json -b 5'

echo '$ echo '\''"3"'\''|json -b 1'
echo '"3"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"3"'\''|json -b 1'

echo '$ echo '\''"3"'\''|json -b 2'
echo '"3"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"3"'\''|json -b 2'

echo '$ echo '\''"3"'\''|json -b 3'
echo '"3"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"3"'\''|json -b 3'

echo '$ echo '\''"3"'\''|json -b 4'
echo '"3"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"3"'\''|json -b 4'

echo '$ echo '\''"3"'\''|json -b 5'
echo '"3"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"3"'\''|json -b 5'

echo '$ echo '\''"4"'\''|json -b 1'
echo '"4"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"4"'\''|json -b 1'

echo '$ echo '\''"4"'\''|json -b 2'
echo '"4"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"4"'\''|json -b 2'

echo '$ echo '\''"4"'\''|json -b 3'
echo '"4"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"4"'\''|json -b 3'

echo '$ echo '\''"4"'\''|json -b 4'
echo '"4"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"4"'\''|json -b 4'

echo '$ echo '\''"4"'\''|json -b 5'
echo '"4"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"4"'\''|json -b 5'

echo '$ echo '\''"5"'\''|json -b 1'
echo '"5"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"5"'\''|json -b 1'

echo '$ echo '\''"5"'\''|json -b 2'
echo '"5"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"5"'\''|json -b 2'

echo '$ echo '\''"5"'\''|json -b 3'
echo '"5"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"5"'\''|json -b 3'

echo '$ echo '\''"5"'\''|json -b 4'
echo '"5"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"5"'\''|json -b 4'

echo '$ echo '\''"5"'\''|json -b 5'
echo '"5"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"5"'\''|json -b 5'

echo '$ echo '\''"6"'\''|json -b 1'
echo '"6"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"6"'\''|json -b 1'

echo '$ echo '\''"6"'\''|json -b 2'
echo '"6"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"6"'\''|json -b 2'

echo '$ echo '\''"6"'\''|json -b 3'
echo '"6"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"6"'\''|json -b 3'

echo '$ echo '\''"6"'\''|json -b 4'
echo '"6"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"6"'\''|json -b 4'

echo '$ echo '\''"6"'\''|json -b 5'
echo '"6"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"6"'\''|json -b 5'

echo '$ echo '\''"7"'\''|json -b 1'
echo '"7"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"7"'\''|json -b 1'

echo '$ echo '\''"7"'\''|json -b 2'
echo '"7"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"7"'\''|json -b 2'

echo '$ echo '\''"7"'\''|json -b 3'
echo '"7"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"7"'\''|json -b 3'

echo '$ echo '\''"7"'\''|json -b 4'
echo '"7"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"7"'\''|json -b 4'

echo '$ echo '\''"7"'\''|json -b 5'
echo '"7"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"7"'\''|json -b 5'

echo '$ echo '\''"8"'\''|json -b 1'
echo '"8"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"8"'\''|json -b 1'

echo '$ echo '\''"8"'\''|json -b 2'
echo '"8"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"8"'\''|json -b 2'

echo '$ echo '\''"8"'\''|json -b 3'
echo '"8"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"8"'\''|json -b 3'

echo '$ echo '\''"8"'\''|json -b 4'
echo '"8"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"8"'\''|json -b 4'

echo '$ echo '\''"8"'\''|json -b 5'
echo '"8"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"8"'\''|json -b 5'

echo '$ echo '\''"9"'\''|json -b 1'
echo '"9"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"9"'\''|json -b 1'

echo '$ echo '\''"9"'\''|json -b 2'
echo '"9"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"9"'\''|json -b 2'

echo '$ echo '\''"9"'\''|json -b 3'
echo '"9"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"9"'\''|json -b 3'

echo '$ echo '\''"9"'\''|json -b 4'
echo '"9"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"9"'\''|json -b 4'

echo '$ echo '\''"9"'\''|json -b 5'
echo '"9"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"9"'\''|json -b 5'

echo '$ echo '\''":"'\''|json -b 1'
echo '":"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''":"'\''|json -b 1'

echo '$ echo '\''":"'\''|json -b 2'
echo '":"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''":"'\''|json -b 2'

echo '$ echo '\''":"'\''|json -b 3'
echo '":"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''":"'\''|json -b 3'

echo '$ echo '\''":"'\''|json -b 4'
echo '":"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''":"'\''|json -b 4'

echo '$ echo '\''":"'\''|json -b 5'
echo '":"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''":"'\''|json -b 5'

echo '$ echo '\''";"'\''|json -b 1'
echo '";"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''";"'\''|json -b 1'

echo '$ echo '\''";"'\''|json -b 2'
echo '";"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''";"'\''|json -b 2'

echo '$ echo '\''";"'\''|json -b 3'
echo '";"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''";"'\''|json -b 3'

echo '$ echo '\''";"'\''|json -b 4'
echo '";"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''";"'\''|json -b 4'

echo '$ echo '\''";"'\''|json -b 5'
echo '";"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''";"'\''|json -b 5'

echo '$ echo '\''"<"'\''|json -b 1'
echo '"<"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"<"'\''|json -b 1'

echo '$ echo '\''"<"'\''|json -b 2'
echo '"<"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"<"'\''|json -b 2'

echo '$ echo '\''"<"'\''|json -b 3'
echo '"<"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"<"'\''|json -b 3'

echo '$ echo '\''"<"'\''|json -b 4'
echo '"<"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"<"'\''|json -b 4'

echo '$ echo '\''"<"'\''|json -b 5'
echo '"<"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"<"'\''|json -b 5'

echo '$ echo '\''"="'\''|json -b 1'
echo '"="'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"="'\''|json -b 1'

echo '$ echo '\''"="'\''|json -b 2'
echo '"="'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"="'\''|json -b 2'

echo '$ echo '\''"="'\''|json -b 3'
echo '"="'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"="'\''|json -b 3'

echo '$ echo '\''"="'\''|json -b 4'
echo '"="'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"="'\''|json -b 4'

echo '$ echo '\''"="'\''|json -b 5'
echo '"="'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"="'\''|json -b 5'

echo '$ echo '\''">"'\''|json -b 1'
echo '">"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''">"'\''|json -b 1'

echo '$ echo '\''">"'\''|json -b 2'
echo '">"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''">"'\''|json -b 2'

echo '$ echo '\''">"'\''|json -b 3'
echo '">"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''">"'\''|json -b 3'

echo '$ echo '\''">"'\''|json -b 4'
echo '">"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''">"'\''|json -b 4'

echo '$ echo '\''">"'\''|json -b 5'
echo '">"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''">"'\''|json -b 5'

echo '$ echo '\''"?"'\''|json -b 1'
echo '"?"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"?"'\''|json -b 1'

echo '$ echo '\''"?"'\''|json -b 2'
echo '"?"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"?"'\''|json -b 2'

echo '$ echo '\''"?"'\''|json -b 3'
echo '"?"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"?"'\''|json -b 3'

echo '$ echo '\''"?"'\''|json -b 4'
echo '"?"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"?"'\''|json -b 4'

echo '$ echo '\''"?"'\''|json -b 5'
echo '"?"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"?"'\''|json -b 5'

echo '$ echo '\''"@"'\''|json -b 1'
echo '"@"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"@"'\''|json -b 1'

echo '$ echo '\''"@"'\''|json -b 2'
echo '"@"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"@"'\''|json -b 2'

echo '$ echo '\''"@"'\''|json -b 3'
echo '"@"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"@"'\''|json -b 3'

echo '$ echo '\''"@"'\''|json -b 4'
echo '"@"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"@"'\''|json -b 4'

echo '$ echo '\''"@"'\''|json -b 5'
echo '"@"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"@"'\''|json -b 5'

echo '$ echo '\''"A"'\''|json -b 1'
echo '"A"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"A"'\''|json -b 1'

echo '$ echo '\''"A"'\''|json -b 2'
echo '"A"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"A"'\''|json -b 2'

echo '$ echo '\''"A"'\''|json -b 3'
echo '"A"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"A"'\''|json -b 3'

echo '$ echo '\''"A"'\''|json -b 4'
echo '"A"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"A"'\''|json -b 4'

echo '$ echo '\''"A"'\''|json -b 5'
echo '"A"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"A"'\''|json -b 5'

echo '$ echo '\''"B"'\''|json -b 1'
echo '"B"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"B"'\''|json -b 1'

echo '$ echo '\''"B"'\''|json -b 2'
echo '"B"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"B"'\''|json -b 2'

echo '$ echo '\''"B"'\''|json -b 3'
echo '"B"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"B"'\''|json -b 3'

echo '$ echo '\''"B"'\''|json -b 4'
echo '"B"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"B"'\''|json -b 4'

echo '$ echo '\''"B"'\''|json -b 5'
echo '"B"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"B"'\''|json -b 5'

echo '$ echo '\''"C"'\''|json -b 1'
echo '"C"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"C"'\''|json -b 1'

echo '$ echo '\''"C"'\''|json -b 2'
echo '"C"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"C"'\''|json -b 2'

echo '$ echo '\''"C"'\''|json -b 3'
echo '"C"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"C"'\''|json -b 3'

echo '$ echo '\''"C"'\''|json -b 4'
echo '"C"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"C"'\''|json -b 4'

echo '$ echo '\''"C"'\''|json -b 5'
echo '"C"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"C"'\''|json -b 5'

echo '$ echo '\''"D"'\''|json -b 1'
echo '"D"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"D"'\''|json -b 1'

echo '$ echo '\''"D"'\''|json -b 2'
echo '"D"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"D"'\''|json -b 2'

echo '$ echo '\''"D"'\''|json -b 3'
echo '"D"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"D"'\''|json -b 3'

echo '$ echo '\''"D"'\''|json -b 4'
echo '"D"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"D"'\''|json -b 4'

echo '$ echo '\''"D"'\''|json -b 5'
echo '"D"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"D"'\''|json -b 5'

echo '$ echo '\''"E"'\''|json -b 1'
echo '"E"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"E"'\''|json -b 1'

echo '$ echo '\''"E"'\''|json -b 2'
echo '"E"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"E"'\''|json -b 2'

echo '$ echo '\''"E"'\''|json -b 3'
echo '"E"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"E"'\''|json -b 3'

echo '$ echo '\''"E"'\''|json -b 4'
echo '"E"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"E"'\''|json -b 4'

echo '$ echo '\''"E"'\''|json -b 5'
echo '"E"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"E"'\''|json -b 5'

echo '$ echo '\''"F"'\''|json -b 1'
echo '"F"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"F"'\''|json -b 1'

echo '$ echo '\''"F"'\''|json -b 2'
echo '"F"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"F"'\''|json -b 2'

echo '$ echo '\''"F"'\''|json -b 3'
echo '"F"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"F"'\''|json -b 3'

echo '$ echo '\''"F"'\''|json -b 4'
echo '"F"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"F"'\''|json -b 4'

echo '$ echo '\''"F"'\''|json -b 5'
echo '"F"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"F"'\''|json -b 5'

echo '$ echo '\''"G"'\''|json -b 1'
echo '"G"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"G"'\''|json -b 1'

echo '$ echo '\''"G"'\''|json -b 2'
echo '"G"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"G"'\''|json -b 2'

echo '$ echo '\''"G"'\''|json -b 3'
echo '"G"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"G"'\''|json -b 3'

echo '$ echo '\''"G"'\''|json -b 4'
echo '"G"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"G"'\''|json -b 4'

echo '$ echo '\''"G"'\''|json -b 5'
echo '"G"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"G"'\''|json -b 5'

echo '$ echo '\''"H"'\''|json -b 1'
echo '"H"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"H"'\''|json -b 1'

echo '$ echo '\''"H"'\''|json -b 2'
echo '"H"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"H"'\''|json -b 2'

echo '$ echo '\''"H"'\''|json -b 3'
echo '"H"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"H"'\''|json -b 3'

echo '$ echo '\''"H"'\''|json -b 4'
echo '"H"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"H"'\''|json -b 4'

echo '$ echo '\''"H"'\''|json -b 5'
echo '"H"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"H"'\''|json -b 5'

echo '$ echo '\''"I"'\''|json -b 1'
echo '"I"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"I"'\''|json -b 1'

echo '$ echo '\''"I"'\''|json -b 2'
echo '"I"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"I"'\''|json -b 2'

echo '$ echo '\''"I"'\''|json -b 3'
echo '"I"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"I"'\''|json -b 3'

echo '$ echo '\''"I"'\''|json -b 4'
echo '"I"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"I"'\''|json -b 4'

echo '$ echo '\''"I"'\''|json -b 5'
echo '"I"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"I"'\''|json -b 5'

echo '$ echo '\''"J"'\''|json -b 1'
echo '"J"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"J"'\''|json -b 1'

echo '$ echo '\''"J"'\''|json -b 2'
echo '"J"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"J"'\''|json -b 2'

echo '$ echo '\''"J"'\''|json -b 3'
echo '"J"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"J"'\''|json -b 3'

echo '$ echo '\''"J"'\''|json -b 4'
echo '"J"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"J"'\''|json -b 4'

echo '$ echo '\''"J"'\''|json -b 5'
echo '"J"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"J"'\''|json -b 5'

echo '$ echo '\''"K"'\''|json -b 1'
echo '"K"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"K"'\''|json -b 1'

echo '$ echo '\''"K"'\''|json -b 2'
echo '"K"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"K"'\''|json -b 2'

echo '$ echo '\''"K"'\''|json -b 3'
echo '"K"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"K"'\''|json -b 3'

echo '$ echo '\''"K"'\''|json -b 4'
echo '"K"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"K"'\''|json -b 4'

echo '$ echo '\''"K"'\''|json -b 5'
echo '"K"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"K"'\''|json -b 5'

echo '$ echo '\''"L"'\''|json -b 1'
echo '"L"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"L"'\''|json -b 1'

echo '$ echo '\''"L"'\''|json -b 2'
echo '"L"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"L"'\''|json -b 2'

echo '$ echo '\''"L"'\''|json -b 3'
echo '"L"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"L"'\''|json -b 3'

echo '$ echo '\''"L"'\''|json -b 4'
echo '"L"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"L"'\''|json -b 4'

echo '$ echo '\''"L"'\''|json -b 5'
echo '"L"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"L"'\''|json -b 5'

echo '$ echo '\''"M"'\''|json -b 1'
echo '"M"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"M"'\''|json -b 1'

echo '$ echo '\''"M"'\''|json -b 2'
echo '"M"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"M"'\''|json -b 2'

echo '$ echo '\''"M"'\''|json -b 3'
echo '"M"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"M"'\''|json -b 3'

echo '$ echo '\''"M"'\''|json -b 4'
echo '"M"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"M"'\''|json -b 4'

echo '$ echo '\''"M"'\''|json -b 5'
echo '"M"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"M"'\''|json -b 5'

echo '$ echo '\''"N"'\''|json -b 1'
echo '"N"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"N"'\''|json -b 1'

echo '$ echo '\''"N"'\''|json -b 2'
echo '"N"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"N"'\''|json -b 2'

echo '$ echo '\''"N"'\''|json -b 3'
echo '"N"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"N"'\''|json -b 3'

echo '$ echo '\''"N"'\''|json -b 4'
echo '"N"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"N"'\''|json -b 4'

echo '$ echo '\''"N"'\''|json -b 5'
echo '"N"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"N"'\''|json -b 5'

echo '$ echo '\''"O"'\''|json -b 1'
echo '"O"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"O"'\''|json -b 1'

echo '$ echo '\''"O"'\''|json -b 2'
echo '"O"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"O"'\''|json -b 2'

echo '$ echo '\''"O"'\''|json -b 3'
echo '"O"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"O"'\''|json -b 3'

echo '$ echo '\''"O"'\''|json -b 4'
echo '"O"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"O"'\''|json -b 4'

echo '$ echo '\''"O"'\''|json -b 5'
echo '"O"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"O"'\''|json -b 5'

echo '$ echo '\''"P"'\''|json -b 1'
echo '"P"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"P"'\''|json -b 1'

echo '$ echo '\''"P"'\''|json -b 2'
echo '"P"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"P"'\''|json -b 2'

echo '$ echo '\''"P"'\''|json -b 3'
echo '"P"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"P"'\''|json -b 3'

echo '$ echo '\''"P"'\''|json -b 4'
echo '"P"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"P"'\''|json -b 4'

echo '$ echo '\''"P"'\''|json -b 5'
echo '"P"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"P"'\''|json -b 5'

echo '$ echo '\''"Q"'\''|json -b 1'
echo '"Q"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"Q"'\''|json -b 1'

echo '$ echo '\''"Q"'\''|json -b 2'
echo '"Q"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"Q"'\''|json -b 2'

echo '$ echo '\''"Q"'\''|json -b 3'
echo '"Q"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"Q"'\''|json -b 3'

echo '$ echo '\''"Q"'\''|json -b 4'
echo '"Q"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"Q"'\''|json -b 4'

echo '$ echo '\''"Q"'\''|json -b 5'
echo '"Q"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"Q"'\''|json -b 5'

echo '$ echo '\''"R"'\''|json -b 1'
echo '"R"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"R"'\''|json -b 1'

echo '$ echo '\''"R"'\''|json -b 2'
echo '"R"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"R"'\''|json -b 2'

echo '$ echo '\''"R"'\''|json -b 3'
echo '"R"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"R"'\''|json -b 3'

echo '$ echo '\''"R"'\''|json -b 4'
echo '"R"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"R"'\''|json -b 4'

echo '$ echo '\''"R"'\''|json -b 5'
echo '"R"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"R"'\''|json -b 5'

echo '$ echo '\''"S"'\''|json -b 1'
echo '"S"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"S"'\''|json -b 1'

echo '$ echo '\''"S"'\''|json -b 2'
echo '"S"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"S"'\''|json -b 2'

echo '$ echo '\''"S"'\''|json -b 3'
echo '"S"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"S"'\''|json -b 3'

echo '$ echo '\''"S"'\''|json -b 4'
echo '"S"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"S"'\''|json -b 4'

echo '$ echo '\''"S"'\''|json -b 5'
echo '"S"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"S"'\''|json -b 5'

echo '$ echo '\''"T"'\''|json -b 1'
echo '"T"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"T"'\''|json -b 1'

echo '$ echo '\''"T"'\''|json -b 2'
echo '"T"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"T"'\''|json -b 2'

echo '$ echo '\''"T"'\''|json -b 3'
echo '"T"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"T"'\''|json -b 3'

echo '$ echo '\''"T"'\''|json -b 4'
echo '"T"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"T"'\''|json -b 4'

echo '$ echo '\''"T"'\''|json -b 5'
echo '"T"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"T"'\''|json -b 5'

echo '$ echo '\''"U"'\''|json -b 1'
echo '"U"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"U"'\''|json -b 1'

echo '$ echo '\''"U"'\''|json -b 2'
echo '"U"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"U"'\''|json -b 2'

echo '$ echo '\''"U"'\''|json -b 3'
echo '"U"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"U"'\''|json -b 3'

echo '$ echo '\''"U"'\''|json -b 4'
echo '"U"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"U"'\''|json -b 4'

echo '$ echo '\''"U"'\''|json -b 5'
echo '"U"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"U"'\''|json -b 5'

echo '$ echo '\''"V"'\''|json -b 1'
echo '"V"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"V"'\''|json -b 1'

echo '$ echo '\''"V"'\''|json -b 2'
echo '"V"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"V"'\''|json -b 2'

echo '$ echo '\''"V"'\''|json -b 3'
echo '"V"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"V"'\''|json -b 3'

echo '$ echo '\''"V"'\''|json -b 4'
echo '"V"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"V"'\''|json -b 4'

echo '$ echo '\''"V"'\''|json -b 5'
echo '"V"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"V"'\''|json -b 5'

echo '$ echo '\''"W"'\''|json -b 1'
echo '"W"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"W"'\''|json -b 1'

echo '$ echo '\''"W"'\''|json -b 2'
echo '"W"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"W"'\''|json -b 2'

echo '$ echo '\''"W"'\''|json -b 3'
echo '"W"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"W"'\''|json -b 3'

echo '$ echo '\''"W"'\''|json -b 4'
echo '"W"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"W"'\''|json -b 4'

echo '$ echo '\''"W"'\''|json -b 5'
echo '"W"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"W"'\''|json -b 5'

echo '$ echo '\''"X"'\''|json -b 1'
echo '"X"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"X"'\''|json -b 1'

echo '$ echo '\''"X"'\''|json -b 2'
echo '"X"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"X"'\''|json -b 2'

echo '$ echo '\''"X"'\''|json -b 3'
echo '"X"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"X"'\''|json -b 3'

echo '$ echo '\''"X"'\''|json -b 4'
echo '"X"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"X"'\''|json -b 4'

echo '$ echo '\''"X"'\''|json -b 5'
echo '"X"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"X"'\''|json -b 5'

echo '$ echo '\''"Y"'\''|json -b 1'
echo '"Y"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"Y"'\''|json -b 1'

echo '$ echo '\''"Y"'\''|json -b 2'
echo '"Y"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"Y"'\''|json -b 2'

echo '$ echo '\''"Y"'\''|json -b 3'
echo '"Y"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"Y"'\''|json -b 3'

echo '$ echo '\''"Y"'\''|json -b 4'
echo '"Y"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"Y"'\''|json -b 4'

echo '$ echo '\''"Y"'\''|json -b 5'
echo '"Y"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"Y"'\''|json -b 5'

echo '$ echo '\''"Z"'\''|json -b 1'
echo '"Z"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"Z"'\''|json -b 1'

echo '$ echo '\''"Z"'\''|json -b 2'
echo '"Z"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"Z"'\''|json -b 2'

echo '$ echo '\''"Z"'\''|json -b 3'
echo '"Z"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"Z"'\''|json -b 3'

echo '$ echo '\''"Z"'\''|json -b 4'
echo '"Z"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"Z"'\''|json -b 4'

echo '$ echo '\''"Z"'\''|json -b 5'
echo '"Z"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"Z"'\''|json -b 5'

echo '$ echo '\''"["'\''|json -b 1'
echo '"["'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"["'\''|json -b 1'

echo '$ echo '\''"["'\''|json -b 2'
echo '"["'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"["'\''|json -b 2'

echo '$ echo '\''"["'\''|json -b 3'
echo '"["'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"["'\''|json -b 3'

echo '$ echo '\''"["'\''|json -b 4'
echo '"["'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"["'\''|json -b 4'

echo '$ echo '\''"["'\''|json -b 5'
echo '"["'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"["'\''|json -b 5'

echo '$ echo '\''"\"'\''|json -b 1'
echo '"\"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"\"'\''|json -b 1'

echo '$ echo '\''"\"'\''|json -b 2'
echo '"\"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"\"'\''|json -b 2'

echo '$ echo '\''"\"'\''|json -b 3'
echo '"\"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"\"'\''|json -b 3'

echo '$ echo '\''"\"'\''|json -b 4'
echo '"\"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"\"'\''|json -b 4'

echo '$ echo '\''"\"'\''|json -b 5'
echo '"\"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"\"'\''|json -b 5'

echo '$ echo '\''"]"'\''|json -b 1'
echo '"]"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"]"'\''|json -b 1'

echo '$ echo '\''"]"'\''|json -b 2'
echo '"]"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"]"'\''|json -b 2'

echo '$ echo '\''"]"'\''|json -b 3'
echo '"]"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"]"'\''|json -b 3'

echo '$ echo '\''"]"'\''|json -b 4'
echo '"]"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"]"'\''|json -b 4'

echo '$ echo '\''"]"'\''|json -b 5'
echo '"]"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"]"'\''|json -b 5'

echo '$ echo '\''"^"'\''|json -b 1'
echo '"^"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"^"'\''|json -b 1'

echo '$ echo '\''"^"'\''|json -b 2'
echo '"^"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"^"'\''|json -b 2'

echo '$ echo '\''"^"'\''|json -b 3'
echo '"^"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"^"'\''|json -b 3'

echo '$ echo '\''"^"'\''|json -b 4'
echo '"^"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"^"'\''|json -b 4'

echo '$ echo '\''"^"'\''|json -b 5'
echo '"^"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"^"'\''|json -b 5'

echo '$ echo '\''"_"'\''|json -b 1'
echo '"_"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"_"'\''|json -b 1'

echo '$ echo '\''"_"'\''|json -b 2'
echo '"_"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"_"'\''|json -b 2'

echo '$ echo '\''"_"'\''|json -b 3'
echo '"_"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"_"'\''|json -b 3'

echo '$ echo '\''"_"'\''|json -b 4'
echo '"_"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"_"'\''|json -b 4'

echo '$ echo '\''"_"'\''|json -b 5'
echo '"_"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"_"'\''|json -b 5'

echo '$ echo '\''"`"'\''|json -b 1'
echo '"`"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"`"'\''|json -b 1'

echo '$ echo '\''"`"'\''|json -b 2'
echo '"`"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"`"'\''|json -b 2'

echo '$ echo '\''"`"'\''|json -b 3'
echo '"`"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"`"'\''|json -b 3'

echo '$ echo '\''"`"'\''|json -b 4'
echo '"`"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"`"'\''|json -b 4'

echo '$ echo '\''"`"'\''|json -b 5'
echo '"`"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"`"'\''|json -b 5'

echo '$ echo '\''"a"'\''|json -b 1'
echo '"a"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"a"'\''|json -b 1'

echo '$ echo '\''"a"'\''|json -b 2'
echo '"a"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"a"'\''|json -b 2'

echo '$ echo '\''"a"'\''|json -b 3'
echo '"a"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"a"'\''|json -b 3'

echo '$ echo '\''"a"'\''|json -b 4'
echo '"a"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"a"'\''|json -b 4'

echo '$ echo '\''"a"'\''|json -b 5'
echo '"a"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"a"'\''|json -b 5'

echo '$ echo '\''"b"'\''|json -b 1'
echo '"b"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"b"'\''|json -b 1'

echo '$ echo '\''"b"'\''|json -b 2'
echo '"b"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"b"'\''|json -b 2'

echo '$ echo '\''"b"'\''|json -b 3'
echo '"b"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"b"'\''|json -b 3'

echo '$ echo '\''"b"'\''|json -b 4'
echo '"b"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"b"'\''|json -b 4'

echo '$ echo '\''"b"'\''|json -b 5'
echo '"b"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"b"'\''|json -b 5'

echo '$ echo '\''"c"'\''|json -b 1'
echo '"c"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"c"'\''|json -b 1'

echo '$ echo '\''"c"'\''|json -b 2'
echo '"c"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"c"'\''|json -b 2'

echo '$ echo '\''"c"'\''|json -b 3'
echo '"c"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"c"'\''|json -b 3'

echo '$ echo '\''"c"'\''|json -b 4'
echo '"c"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"c"'\''|json -b 4'

echo '$ echo '\''"c"'\''|json -b 5'
echo '"c"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"c"'\''|json -b 5'

echo '$ echo '\''"d"'\''|json -b 1'
echo '"d"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"d"'\''|json -b 1'

echo '$ echo '\''"d"'\''|json -b 2'
echo '"d"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"d"'\''|json -b 2'

echo '$ echo '\''"d"'\''|json -b 3'
echo '"d"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"d"'\''|json -b 3'

echo '$ echo '\''"d"'\''|json -b 4'
echo '"d"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"d"'\''|json -b 4'

echo '$ echo '\''"d"'\''|json -b 5'
echo '"d"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"d"'\''|json -b 5'

echo '$ echo '\''"e"'\''|json -b 1'
echo '"e"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"e"'\''|json -b 1'

echo '$ echo '\''"e"'\''|json -b 2'
echo '"e"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"e"'\''|json -b 2'

echo '$ echo '\''"e"'\''|json -b 3'
echo '"e"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"e"'\''|json -b 3'

echo '$ echo '\''"e"'\''|json -b 4'
echo '"e"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"e"'\''|json -b 4'

echo '$ echo '\''"e"'\''|json -b 5'
echo '"e"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"e"'\''|json -b 5'

echo '$ echo '\''"f"'\''|json -b 1'
echo '"f"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"f"'\''|json -b 1'

echo '$ echo '\''"f"'\''|json -b 2'
echo '"f"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"f"'\''|json -b 2'

echo '$ echo '\''"f"'\''|json -b 3'
echo '"f"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"f"'\''|json -b 3'

echo '$ echo '\''"f"'\''|json -b 4'
echo '"f"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"f"'\''|json -b 4'

echo '$ echo '\''"f"'\''|json -b 5'
echo '"f"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"f"'\''|json -b 5'

echo '$ echo '\''"g"'\''|json -b 1'
echo '"g"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"g"'\''|json -b 1'

echo '$ echo '\''"g"'\''|json -b 2'
echo '"g"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"g"'\''|json -b 2'

echo '$ echo '\''"g"'\''|json -b 3'
echo '"g"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"g"'\''|json -b 3'

echo '$ echo '\''"g"'\''|json -b 4'
echo '"g"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"g"'\''|json -b 4'

echo '$ echo '\''"g"'\''|json -b 5'
echo '"g"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"g"'\''|json -b 5'

echo '$ echo '\''"h"'\''|json -b 1'
echo '"h"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"h"'\''|json -b 1'

echo '$ echo '\''"h"'\''|json -b 2'
echo '"h"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"h"'\''|json -b 2'

echo '$ echo '\''"h"'\''|json -b 3'
echo '"h"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"h"'\''|json -b 3'

echo '$ echo '\''"h"'\''|json -b 4'
echo '"h"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"h"'\''|json -b 4'

echo '$ echo '\''"h"'\''|json -b 5'
echo '"h"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"h"'\''|json -b 5'

echo '$ echo '\''"i"'\''|json -b 1'
echo '"i"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"i"'\''|json -b 1'

echo '$ echo '\''"i"'\''|json -b 2'
echo '"i"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"i"'\''|json -b 2'

echo '$ echo '\''"i"'\''|json -b 3'
echo '"i"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"i"'\''|json -b 3'

echo '$ echo '\''"i"'\''|json -b 4'
echo '"i"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"i"'\''|json -b 4'

echo '$ echo '\''"i"'\''|json -b 5'
echo '"i"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"i"'\''|json -b 5'

echo '$ echo '\''"j"'\''|json -b 1'
echo '"j"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"j"'\''|json -b 1'

echo '$ echo '\''"j"'\''|json -b 2'
echo '"j"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"j"'\''|json -b 2'

echo '$ echo '\''"j"'\''|json -b 3'
echo '"j"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"j"'\''|json -b 3'

echo '$ echo '\''"j"'\''|json -b 4'
echo '"j"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"j"'\''|json -b 4'

echo '$ echo '\''"j"'\''|json -b 5'
echo '"j"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"j"'\''|json -b 5'

echo '$ echo '\''"k"'\''|json -b 1'
echo '"k"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"k"'\''|json -b 1'

echo '$ echo '\''"k"'\''|json -b 2'
echo '"k"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"k"'\''|json -b 2'

echo '$ echo '\''"k"'\''|json -b 3'
echo '"k"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"k"'\''|json -b 3'

echo '$ echo '\''"k"'\''|json -b 4'
echo '"k"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"k"'\''|json -b 4'

echo '$ echo '\''"k"'\''|json -b 5'
echo '"k"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"k"'\''|json -b 5'

echo '$ echo '\''"l"'\''|json -b 1'
echo '"l"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"l"'\''|json -b 1'

echo '$ echo '\''"l"'\''|json -b 2'
echo '"l"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"l"'\''|json -b 2'

echo '$ echo '\''"l"'\''|json -b 3'
echo '"l"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"l"'\''|json -b 3'

echo '$ echo '\''"l"'\''|json -b 4'
echo '"l"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"l"'\''|json -b 4'

echo '$ echo '\''"l"'\''|json -b 5'
echo '"l"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"l"'\''|json -b 5'

echo '$ echo '\''"m"'\''|json -b 1'
echo '"m"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"m"'\''|json -b 1'

echo '$ echo '\''"m"'\''|json -b 2'
echo '"m"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"m"'\''|json -b 2'

echo '$ echo '\''"m"'\''|json -b 3'
echo '"m"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"m"'\''|json -b 3'

echo '$ echo '\''"m"'\''|json -b 4'
echo '"m"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"m"'\''|json -b 4'

echo '$ echo '\''"m"'\''|json -b 5'
echo '"m"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"m"'\''|json -b 5'

echo '$ echo '\''"n"'\''|json -b 1'
echo '"n"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"n"'\''|json -b 1'

echo '$ echo '\''"n"'\''|json -b 2'
echo '"n"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"n"'\''|json -b 2'

echo '$ echo '\''"n"'\''|json -b 3'
echo '"n"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"n"'\''|json -b 3'

echo '$ echo '\''"n"'\''|json -b 4'
echo '"n"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"n"'\''|json -b 4'

echo '$ echo '\''"n"'\''|json -b 5'
echo '"n"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"n"'\''|json -b 5'

echo '$ echo '\''"o"'\''|json -b 1'
echo '"o"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"o"'\''|json -b 1'

echo '$ echo '\''"o"'\''|json -b 2'
echo '"o"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"o"'\''|json -b 2'

echo '$ echo '\''"o"'\''|json -b 3'
echo '"o"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"o"'\''|json -b 3'

echo '$ echo '\''"o"'\''|json -b 4'
echo '"o"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"o"'\''|json -b 4'

echo '$ echo '\''"o"'\''|json -b 5'
echo '"o"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"o"'\''|json -b 5'

echo '$ echo '\''"p"'\''|json -b 1'
echo '"p"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"p"'\''|json -b 1'

echo '$ echo '\''"p"'\''|json -b 2'
echo '"p"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"p"'\''|json -b 2'

echo '$ echo '\''"p"'\''|json -b 3'
echo '"p"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"p"'\''|json -b 3'

echo '$ echo '\''"p"'\''|json -b 4'
echo '"p"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"p"'\''|json -b 4'

echo '$ echo '\''"p"'\''|json -b 5'
echo '"p"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"p"'\''|json -b 5'

echo '$ echo '\''"q"'\''|json -b 1'
echo '"q"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"q"'\''|json -b 1'

echo '$ echo '\''"q"'\''|json -b 2'
echo '"q"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"q"'\''|json -b 2'

echo '$ echo '\''"q"'\''|json -b 3'
echo '"q"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"q"'\''|json -b 3'

echo '$ echo '\''"q"'\''|json -b 4'
echo '"q"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"q"'\''|json -b 4'

echo '$ echo '\''"q"'\''|json -b 5'
echo '"q"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"q"'\''|json -b 5'

echo '$ echo '\''"r"'\''|json -b 1'
echo '"r"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"r"'\''|json -b 1'

echo '$ echo '\''"r"'\''|json -b 2'
echo '"r"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"r"'\''|json -b 2'

echo '$ echo '\''"r"'\''|json -b 3'
echo '"r"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"r"'\''|json -b 3'

echo '$ echo '\''"r"'\''|json -b 4'
echo '"r"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"r"'\''|json -b 4'

echo '$ echo '\''"r"'\''|json -b 5'
echo '"r"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"r"'\''|json -b 5'

echo '$ echo '\''"s"'\''|json -b 1'
echo '"s"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"s"'\''|json -b 1'

echo '$ echo '\''"s"'\''|json -b 2'
echo '"s"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"s"'\''|json -b 2'

echo '$ echo '\''"s"'\''|json -b 3'
echo '"s"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"s"'\''|json -b 3'

echo '$ echo '\''"s"'\''|json -b 4'
echo '"s"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"s"'\''|json -b 4'

echo '$ echo '\''"s"'\''|json -b 5'
echo '"s"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"s"'\''|json -b 5'

echo '$ echo '\''"t"'\''|json -b 1'
echo '"t"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"t"'\''|json -b 1'

echo '$ echo '\''"t"'\''|json -b 2'
echo '"t"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"t"'\''|json -b 2'

echo '$ echo '\''"t"'\''|json -b 3'
echo '"t"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"t"'\''|json -b 3'

echo '$ echo '\''"t"'\''|json -b 4'
echo '"t"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"t"'\''|json -b 4'

echo '$ echo '\''"t"'\''|json -b 5'
echo '"t"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"t"'\''|json -b 5'

echo '$ echo '\''"u"'\''|json -b 1'
echo '"u"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"u"'\''|json -b 1'

echo '$ echo '\''"u"'\''|json -b 2'
echo '"u"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"u"'\''|json -b 2'

echo '$ echo '\''"u"'\''|json -b 3'
echo '"u"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"u"'\''|json -b 3'

echo '$ echo '\''"u"'\''|json -b 4'
echo '"u"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"u"'\''|json -b 4'

echo '$ echo '\''"u"'\''|json -b 5'
echo '"u"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"u"'\''|json -b 5'

echo '$ echo '\''"v"'\''|json -b 1'
echo '"v"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"v"'\''|json -b 1'

echo '$ echo '\''"v"'\''|json -b 2'
echo '"v"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"v"'\''|json -b 2'

echo '$ echo '\''"v"'\''|json -b 3'
echo '"v"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"v"'\''|json -b 3'

echo '$ echo '\''"v"'\''|json -b 4'
echo '"v"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"v"'\''|json -b 4'

echo '$ echo '\''"v"'\''|json -b 5'
echo '"v"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"v"'\''|json -b 5'

echo '$ echo '\''"w"'\''|json -b 1'
echo '"w"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"w"'\''|json -b 1'

echo '$ echo '\''"w"'\''|json -b 2'
echo '"w"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"w"'\''|json -b 2'

echo '$ echo '\''"w"'\''|json -b 3'
echo '"w"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"w"'\''|json -b 3'

echo '$ echo '\''"w"'\''|json -b 4'
echo '"w"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"w"'\''|json -b 4'

echo '$ echo '\''"w"'\''|json -b 5'
echo '"w"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"w"'\''|json -b 5'

echo '$ echo '\''"x"'\''|json -b 1'
echo '"x"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"x"'\''|json -b 1'

echo '$ echo '\''"x"'\''|json -b 2'
echo '"x"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"x"'\''|json -b 2'

echo '$ echo '\''"x"'\''|json -b 3'
echo '"x"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"x"'\''|json -b 3'

echo '$ echo '\''"x"'\''|json -b 4'
echo '"x"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"x"'\''|json -b 4'

echo '$ echo '\''"x"'\''|json -b 5'
echo '"x"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"x"'\''|json -b 5'

echo '$ echo '\''"y"'\''|json -b 1'
echo '"y"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"y"'\''|json -b 1'

echo '$ echo '\''"y"'\''|json -b 2'
echo '"y"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"y"'\''|json -b 2'

echo '$ echo '\''"y"'\''|json -b 3'
echo '"y"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"y"'\''|json -b 3'

echo '$ echo '\''"y"'\''|json -b 4'
echo '"y"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"y"'\''|json -b 4'

echo '$ echo '\''"y"'\''|json -b 5'
echo '"y"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"y"'\''|json -b 5'

echo '$ echo '\''"z"'\''|json -b 1'
echo '"z"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"z"'\''|json -b 1'

echo '$ echo '\''"z"'\''|json -b 2'
echo '"z"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"z"'\''|json -b 2'

echo '$ echo '\''"z"'\''|json -b 3'
echo '"z"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"z"'\''|json -b 3'

echo '$ echo '\''"z"'\''|json -b 4'
echo '"z"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"z"'\''|json -b 4'

echo '$ echo '\''"z"'\''|json -b 5'
echo '"z"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"z"'\''|json -b 5'

echo '$ echo '\''"{"'\''|json -b 1'
echo '"{"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"{"'\''|json -b 1'

echo '$ echo '\''"{"'\''|json -b 2'
echo '"{"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"{"'\''|json -b 2'

echo '$ echo '\''"{"'\''|json -b 3'
echo '"{"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"{"'\''|json -b 3'

echo '$ echo '\''"{"'\''|json -b 4'
echo '"{"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"{"'\''|json -b 4'

echo '$ echo '\''"{"'\''|json -b 5'
echo '"{"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"{"'\''|json -b 5'

echo '$ echo '\''"|"'\''|json -b 1'
echo '"|"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"|"'\''|json -b 1'

echo '$ echo '\''"|"'\''|json -b 2'
echo '"|"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"|"'\''|json -b 2'

echo '$ echo '\''"|"'\''|json -b 3'
echo '"|"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"|"'\''|json -b 3'

echo '$ echo '\''"|"'\''|json -b 4'
echo '"|"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"|"'\''|json -b 4'

echo '$ echo '\''"|"'\''|json -b 5'
echo '"|"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"|"'\''|json -b 5'

echo '$ echo '\''"}"'\''|json -b 1'
echo '"}"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"}"'\''|json -b 1'

echo '$ echo '\''"}"'\''|json -b 2'
echo '"}"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"}"'\''|json -b 2'

echo '$ echo '\''"}"'\''|json -b 3'
echo '"}"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"}"'\''|json -b 3'

echo '$ echo '\''"}"'\''|json -b 4'
echo '"}"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"}"'\''|json -b 4'

echo '$ echo '\''"}"'\''|json -b 5'
echo '"}"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"}"'\''|json -b 5'

echo '$ echo '\''"~"'\''|json -b 1'
echo '"~"'|json -b 1 2>&1 ||
echo 'command failed: echo '\''"~"'\''|json -b 1'

echo '$ echo '\''"~"'\''|json -b 2'
echo '"~"'|json -b 2 2>&1 ||
echo 'command failed: echo '\''"~"'\''|json -b 2'

echo '$ echo '\''"~"'\''|json -b 3'
echo '"~"'|json -b 3 2>&1 ||
echo 'command failed: echo '\''"~"'\''|json -b 3'

echo '$ echo '\''"~"'\''|json -b 4'
echo '"~"'|json -b 4 2>&1 ||
echo 'command failed: echo '\''"~"'\''|json -b 4'

echo '$ echo '\''"~"'\''|json -b 5'
echo '"~"'|json -b 5 2>&1 ||
echo 'command failed: echo '\''"~"'\''|json -b 5'

echo '$ echo -e '\''"\x7f"'\''|json -b 1'
echo -e '"\x7f"'|json -b 1 2>&1 ||
echo 'command failed: echo -e '\''"\x7f"'\''|json -b 1'

echo '$ echo -e '\''"\x7f"'\''|json -b 2'
echo -e '"\x7f"'|json -b 2 2>&1 ||
echo 'command failed: echo -e '\''"\x7f"'\''|json -b 2'

echo '$ echo -e '\''"\x7f"'\''|json -b 3'
echo -e '"\x7f"'|json -b 3 2>&1 ||
echo 'command failed: echo -e '\''"\x7f"'\''|json -b 3'

echo '$ echo -e '\''"\x7f"'\''|json -b 4'
echo -e '"\x7f"'|json -b 4 2>&1 ||
echo 'command failed: echo -e '\''"\x7f"'\''|json -b 4'

echo '$ echo -e '\''"\x7f"'\''|json -b 5'
echo -e '"\x7f"'|json -b 5 2>&1 ||
echo 'command failed: echo -e '\''"\x7f"'\''|json -b 5'
)

