#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker-list:list-object-basic-plain-val-object-basic-basic
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L list-object-basic-plain-val-object-basic-basic.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[{}],"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":null,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":false,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":456,"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456,"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":456,"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":456,"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456,"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":456,"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":456,"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456,"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":456,"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":456,"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456,"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":456,"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":456,"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456,"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":456,"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":456,"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456,"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":456,"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":456,"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456,"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":456,"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":456,"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456,"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":456,"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":456,"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":456,"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":456,"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"bar","baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar","baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"bar","baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"bar","baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar","baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"bar","baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"bar","baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar","baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"bar","baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"bar","baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar","baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"bar","baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"bar","baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar","baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"bar","baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"bar","baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar","baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"bar","baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"bar","baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar","baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"bar","baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"bar","baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar","baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"bar","baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"bar","baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar","baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"bar","baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"bar","baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar","baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"bar","baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"bar","baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar","baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"bar","baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"bar","baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar","baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"bar","baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"bar","baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar","baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"bar","baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"bar","baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar","baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"bar","baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"bar","baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar","baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"bar","baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"bar","baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar","baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"bar","baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"bar","baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar","baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"bar","baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"bar","baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar","baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"bar","baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"bar","baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar","baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"bar","baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"bar","baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar","baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"bar","baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"bar","baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar","baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"bar","baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"bar","baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar","baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"bar","baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"bar","baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar","baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"bar","baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"bar","baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar","baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"bar","baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"bar","baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar","baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"bar","baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"bar","baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar","baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"bar","baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"bar","baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar","baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"bar","baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"bar","baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar","baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"bar","baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"bar","baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar","baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"bar","baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"bar","baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar","baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"bar","baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"bar","baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar","baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"bar","baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"bar","baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar","baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"bar","baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"bar","baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar","baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"bar","baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"bar","baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar","baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"bar","baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"bar","baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar","baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"bar","baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"bar","baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar","baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"bar","baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"bar","baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar","baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"bar","baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"bar","baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar","baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"bar","baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"bar","baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar","baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"bar","baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"bar","baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar","baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"bar","baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"bar","baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar","baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"bar","baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"bar","baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar","baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"bar","baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"bar","baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar","baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"bar","baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"bar","baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar","baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"bar","baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"bar","baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":"bar","baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"bar","baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{},"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{},"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{},"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{},"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{},"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{},"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{},"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{},"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{},"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{},"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{},"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{},"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{},"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{},"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{},"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{},"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{},"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{},"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{},"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{},"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{},"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{},"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{},"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{},"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{},"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{},"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{},"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{},"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{},"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{},"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{},"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{},"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{},"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{},"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{},"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{},"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{},"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{},"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{},"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{},"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{},"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{},"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{},"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{},"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{},"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{},"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{},"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{},"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{},"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{},"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{},"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{},"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{},"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{},"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{},"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{},"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{},"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{},"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{},"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{},"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{},"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{},"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{},"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{},"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{},"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{},"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{},"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{},"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{},"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{},"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{},"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{},"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":{},"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":{},"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":{},"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":{},"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":{},"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":{},"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":{},"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":{},"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":{},"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":{},"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":{},"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":{},"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":{},"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":{},"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":{},"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":{},"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":{},"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":{},"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":{},"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[],"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[],"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[],"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[],"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[],"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[],"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[],"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[],"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[],"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[],"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[],"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[],"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[],"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[],"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[],"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[],"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[],"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[],"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[],"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[],"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[],"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[],"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[],"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[],"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[],"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[],"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[],"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[],"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[],"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[],"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[],"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[],"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[],"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[],"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[],"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[],"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[],"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[],"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[],"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[],"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[],"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[],"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[],"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[],"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[],"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[],"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[],"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[],"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[],"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[],"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[],"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[],"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[],"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[],"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[],"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[],"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[],"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[],"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[],"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[],"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[],"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[],"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[],"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[],"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[],"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[],"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[],"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[],"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[],"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[],"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[],"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[],"baa":[]}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[],"baa":null}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":null}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[],"baa":null}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[],"baa":false}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":false}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[],"baa":false}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[],"baa":true}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":true}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[],"baa":true}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[],"baa":123}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":123}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[],"baa":123}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[],"baa":456}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":456}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[],"baa":456}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[],"baa":"foo"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":"foo"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[],"baa":"foo"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[],"baa":"bar"}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":"bar"}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[],"baa":"bar"}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[],"baa":{}}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":{}}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[],"baa":{}}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[],"baa":[]}'\''
json: error: <stdin>:1:2: type check error: invalid argument name: expected "faa"
json: error: <stdin>:1:2: {"fuu":[],"baa":[]}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[],"baa":[]}'\'''
) -L list-object-basic-plain-val-object-basic-basic.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"fuu":[{}],"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"fuu":[{}],"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"fuu":[{}],"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"fuu":[{}],"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"fuu":[{}],"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"fuu":[{}],"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"fuu":[{}],"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"fuu":[{}],"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"fuu":[{}],"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"fuu":[{}],"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"fuu":[{}],"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"fuu":[{}],"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"fuu":[{}],"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"fuu":[{}],"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"fuu":[{}],"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"fuu":[{}],"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"fuu":[{}],"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"fuu":[{}],"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"fuu":[{}],"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"fuu":[{}],"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"fuu":[{}],"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"fuu":[{}],"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"fuu":[{}],"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"fuu":[{}],"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"fuu":[{}],"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"fuu":[{}],"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"fuu":[{}],"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"fuu":[{}],"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"fuu":[{}],"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"fuu":[{}],"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"fuu":[{}],"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"fuu":[{}],"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"fuu":[{}],"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"fuu":[{}],"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"fuu":[{}],"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"fuu":[{}],"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":[{}],"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":[{}],"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":[{}],"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":[{}],"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":[{}],"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":[{}],"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":[{}],"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":[{}],"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":[{}],"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"type"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[{}],"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"fuu":null,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"fuu":null,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"fuu":null,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"fuu":null,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"fuu":null,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"fuu":null,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"fuu":null,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"fuu":null,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"fuu":null,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"fuu":null,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"fuu":null,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"fuu":null,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"fuu":null,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"fuu":null,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"fuu":null,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"fuu":null,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"fuu":null,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"fuu":null,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"fuu":null,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"fuu":null,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"fuu":null,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"fuu":null,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"fuu":null,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"fuu":null,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"fuu":null,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"fuu":null,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"fuu":null,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"fuu":null,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":null,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":null,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":null,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":null,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":null,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":null,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":null,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":null,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":null,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":null,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":null,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":null,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":null,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":null,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":null,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":null,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":null,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"null"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":null,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"fuu":false,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"fuu":false,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"fuu":false,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"fuu":false,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"fuu":false,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"fuu":false,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"fuu":false,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"fuu":false,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"fuu":false,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"fuu":false,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"fuu":false,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"fuu":false,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"fuu":false,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"fuu":false,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"fuu":false,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"fuu":false,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"fuu":false,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"fuu":false,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"fuu":false,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"fuu":false,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"fuu":false,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"fuu":false,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"fuu":false,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"fuu":false,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"fuu":false,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"fuu":false,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"fuu":false,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"fuu":false,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":false,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":false,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":false,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":false,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":false,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":false,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":false,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":false,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":false,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":false,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":false,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":false,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":false,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":false,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":false,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":false,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":false,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"boolean"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":false,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"fuu":456,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"fuu":456,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"fuu":456,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"fuu":456,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"fuu":456,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"fuu":456,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"fuu":456,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"fuu":456,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"fuu":456,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":456,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"fuu":456,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"fuu":456,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"fuu":456,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"fuu":456,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"fuu":456,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"fuu":456,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"fuu":456,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"fuu":456,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"fuu":456,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":456,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"fuu":456,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"fuu":456,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"fuu":456,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"fuu":456,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"fuu":456,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"fuu":456,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"fuu":456,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"fuu":456,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"fuu":456,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":456,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"fuu":456,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"fuu":456,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"fuu":456,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"fuu":456,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"fuu":456,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"fuu":456,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"fuu":456,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"fuu":456,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"fuu":456,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":456,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":456,"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":456,"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":456,"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":456,"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":456,"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":456,"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":456,"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":456,"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":456,"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":456,"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":456,"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":456,"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":456,"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":456,"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":456,"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":456,"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":456,"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":456,"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":456,"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":456,"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":456,"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":456,"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":456,"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":456,"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":456,"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":456,"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"number"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":456,"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"bar","baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"fuu":"bar","baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"bar","baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"bar","baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"fuu":"bar","baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"bar","baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"bar","baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"fuu":"bar","baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"bar","baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"bar","baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"fuu":"bar","baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"bar","baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"bar","baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"fuu":"bar","baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"bar","baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"bar","baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"fuu":"bar","baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"bar","baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"bar","baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"fuu":"bar","baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"bar","baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"bar","baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"fuu":"bar","baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"bar","baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"bar","baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"fuu":"bar","baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":"bar","baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"bar","baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"fuu":"bar","baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"bar","baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"bar","baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"fuu":"bar","baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"bar","baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"bar","baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"fuu":"bar","baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"bar","baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"bar","baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"fuu":"bar","baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"bar","baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"bar","baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"fuu":"bar","baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"bar","baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"bar","baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"fuu":"bar","baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"bar","baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"bar","baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"fuu":"bar","baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"bar","baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"bar","baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"fuu":"bar","baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"bar","baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"bar","baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"fuu":"bar","baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":"bar","baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"bar","baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"fuu":"bar","baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"bar","baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"bar","baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"fuu":"bar","baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"bar","baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"bar","baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"fuu":"bar","baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"bar","baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"bar","baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"fuu":"bar","baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"bar","baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"bar","baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"fuu":"bar","baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"bar","baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"bar","baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"fuu":"bar","baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"bar","baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"bar","baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"fuu":"bar","baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"bar","baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"bar","baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"fuu":"bar","baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"bar","baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"bar","baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"fuu":"bar","baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":"bar","baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"bar","baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"fuu":"bar","baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"bar","baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"bar","baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"fuu":"bar","baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"bar","baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"bar","baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"fuu":"bar","baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"bar","baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"bar","baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"fuu":"bar","baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"bar","baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"bar","baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"fuu":"bar","baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"bar","baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"bar","baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"fuu":"bar","baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"bar","baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"bar","baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"fuu":"bar","baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"bar","baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"bar","baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"fuu":"bar","baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"bar","baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"bar","baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"fuu":"bar","baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":"bar","baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"bar","baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"bar","baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"bar","baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"bar","baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"bar","baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"bar","baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"bar","baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"bar","baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"bar","baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"bar","baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"bar","baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"bar","baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"bar","baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"bar","baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"bar","baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"bar","baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"bar","baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"bar","baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"bar","baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"bar","baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"bar","baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"bar","baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"bar","baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"bar","baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"bar","baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":"bar","baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"string"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":"bar","baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{},"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"fuu":{},"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{},"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{},"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"fuu":{},"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{},"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{},"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"fuu":{},"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{},"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{},"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"fuu":{},"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{},"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{},"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"fuu":{},"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{},"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{},"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"fuu":{},"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{},"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{},"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"fuu":{},"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{},"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{},"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"fuu":{},"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{},"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{},"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"fuu":{},"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":{},"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{},"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"fuu":{},"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{},"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{},"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"fuu":{},"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{},"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{},"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"fuu":{},"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{},"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{},"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"fuu":{},"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{},"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{},"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"fuu":{},"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{},"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{},"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"fuu":{},"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{},"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{},"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"fuu":{},"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{},"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{},"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"fuu":{},"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{},"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{},"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"fuu":{},"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":{},"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{},"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"fuu":{},"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{},"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{},"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"fuu":{},"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{},"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{},"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"fuu":{},"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{},"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{},"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"fuu":{},"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{},"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{},"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"fuu":{},"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{},"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{},"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"fuu":{},"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{},"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{},"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"fuu":{},"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{},"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{},"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"fuu":{},"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{},"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{},"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"fuu":{},"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":{},"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{},"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"fuu":{},"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{},"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{},"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"fuu":{},"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{},"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{},"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"fuu":{},"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{},"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{},"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"fuu":{},"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{},"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{},"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"fuu":{},"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{},"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{},"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"fuu":{},"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{},"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{},"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"fuu":{},"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{},"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{},"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"fuu":{},"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{},"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{},"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"fuu":{},"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":{},"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":{},"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":{},"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":{},"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":{},"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":{},"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":{},"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":{},"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":{},"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":{},"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":{},"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":{},"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":{},"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":{},"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":{},"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":{},"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":{},"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":{},"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":{},"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":{},"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":{},"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":{},"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":{},"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":{},"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":{},"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":{},"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":{},"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"object"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":{},"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[],"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"fuu":[],"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[],"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[],"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"fuu":[],"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[],"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[],"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"fuu":[],"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[],"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[],"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"fuu":[],"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[],"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[],"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"fuu":[],"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[],"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[],"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"fuu":[],"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[],"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[],"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"fuu":[],"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[],"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[],"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"fuu":[],"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[],"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[],"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}' <<< '{"fuu":[],"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":null}}]}]}'\'' <<< '\''{"fuu":[],"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[],"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"fuu":[],"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[],"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[],"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"fuu":[],"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[],"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[],"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"fuu":[],"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[],"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[],"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"fuu":[],"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[],"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[],"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"fuu":[],"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[],"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[],"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"fuu":[],"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[],"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[],"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"fuu":[],"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[],"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[],"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"fuu":[],"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[],"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[],"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}' <<< '{"fuu":[],"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":false}}]}]}'\'' <<< '\''{"fuu":[],"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[],"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"fuu":[],"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[],"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[],"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"fuu":[],"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[],"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[],"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"fuu":[],"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[],"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[],"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"fuu":[],"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[],"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[],"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"fuu":[],"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[],"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[],"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"fuu":[],"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[],"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[],"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"fuu":[],"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[],"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[],"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"fuu":[],"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[],"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[],"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}' <<< '{"fuu":[],"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":true}}]}]}'\'' <<< '\''{"fuu":[],"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[],"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"fuu":[],"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[],"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[],"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"fuu":[],"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[],"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[],"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"fuu":[],"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[],"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[],"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"fuu":[],"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[],"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[],"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"fuu":[],"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[],"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[],"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"fuu":[],"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[],"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[],"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"fuu":[],"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[],"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[],"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"fuu":[],"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[],"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[],"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}' <<< '{"fuu":[],"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":123}}]}]}'\'' <<< '\''{"fuu":[],"baa":[]}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[],"baa":null}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":[],"baa":null}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[],"baa":null}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[],"baa":false}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":[],"baa":false}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[],"baa":false}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[],"baa":true}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":[],"baa":true}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[],"baa":true}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[],"baa":123}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":[],"baa":123}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[],"baa":123}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[],"baa":456}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":[],"baa":456}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[],"baa":456}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[],"baa":"foo"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":[],"baa":"foo"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[],"baa":"foo"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[],"baa":"bar"}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":[],"baa":"bar"}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[],"baa":"bar"}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[],"baa":{}}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":[],"baa":{}}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[],"baa":{}}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[],"baa":[]}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}' <<< '{"fuu":[],"baa":[]}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"faa","type":"array"},{"name":"baa","type":{"plain":"foo"}}]}]}'\'' <<< '\''{"fuu":[],"baa":[]}'\'''
)

