#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C escape:surrogate-pairs
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L surrogate-pairs.old <(echo \
'$ json() { LD_LIBRARY_PATH=../lib ../src/json --verbose --escape-json --validate-utf8 --surrogate-pairs "$@"; }
$ echo -ne '\''\xf0\x90\x80\x80'\''|json
\ud800\udc00
$ echo -ne '\''\xf0\x90\x80\xbf'\''|json
\ud800\udc3f
$ echo -ne '\''\xf0\x90\xbf\x80'\''|json
\ud803\udfc0
$ echo -ne '\''\xf0\x90\xbf\xbf'\''|json
\ud803\udfff
$ echo -ne '\''\xf0\xbf\x80\x80'\''|json
\ud8bc\udc00
$ echo -ne '\''\xf0\xbf\x80\xbf'\''|json
\ud8bc\udc3f
$ echo -ne '\''\xf0\xbf\xbf\x80'\''|json
\ud8bf\udfc0
$ echo -ne '\''\xf0\xbf\xbf\xbf'\''|json
\ud8bf\udfff
$ echo -ne '\''\xf1\x80\x80\x80'\''|json
\ud8c0\udc00
$ echo -ne '\''\xf1\x80\x80\xbf'\''|json
\ud8c0\udc3f
$ echo -ne '\''\xf1\x80\xbf\x80'\''|json
\ud8c3\udfc0
$ echo -ne '\''\xf1\x80\xbf\xbf'\''|json
\ud8c3\udfff
$ echo -ne '\''\xf1\xbf\x80\x80'\''|json
\ud9bc\udc00
$ echo -ne '\''\xf1\xbf\x80\xbf'\''|json
\ud9bc\udc3f
$ echo -ne '\''\xf1\xbf\xbf\x80'\''|json
\ud9bf\udfc0
$ echo -ne '\''\xf1\xbf\xbf\xbf'\''|json
\ud9bf\udfff
$ echo -ne '\''\xf3\x80\x80\x80'\''|json
\udac0\udc00
$ echo -ne '\''\xf3\x80\x80\xbf'\''|json
\udac0\udc3f
$ echo -ne '\''\xf3\x80\xbf\x80'\''|json
\udac3\udfc0
$ echo -ne '\''\xf3\x80\xbf\xbf'\''|json
\udac3\udfff
$ echo -ne '\''\xf3\xbf\x80\x80'\''|json
\udbbc\udc00
$ echo -ne '\''\xf3\xbf\x80\xbf'\''|json
\udbbc\udc3f
$ echo -ne '\''\xf3\xbf\xbf\x80'\''|json
\udbbf\udfc0
$ echo -ne '\''\xf3\xbf\xbf\xbf'\''|json
\udbbf\udfff
$ echo -ne '\''\xf4\x80\x80\x80'\''|json
\udbc0\udc00
$ echo -ne '\''\xf4\x80\x80\xbf'\''|json
\udbc0\udc3f
$ echo -ne '\''\xf4\x80\xbf\x80'\''|json
\udbc3\udfc0
$ echo -ne '\''\xf4\x80\xbf\xbf'\''|json
\udbc3\udfff
$ echo -ne '\''\xf4\x8f\x80\x80'\''|json
\udbfc\udc00
$ echo -ne '\''\xf4\x8f\x80\xbf'\''|json
\udbfc\udc3f
$ echo -ne '\''\xf4\x8f\xbf\x80'\''|json
\udbff\udfc0
$ echo -ne '\''\xf4\x8f\xbf\xbf'\''|json
\udbff\udfff'
) -L surrogate-pairs.new <(
echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --verbose --escape-json --validate-utf8 --surrogate-pairs "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --verbose --escape-json --validate-utf8 --surrogate-pairs "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --verbose --escape-json --validate-utf8 --surrogate-pairs "$@"; }'

echo '$ echo -ne '\''\xf0\x90\x80\x80'\''|json'
echo -ne '\xf0\x90\x80\x80'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\x90\x80\x80'\''|json'

echo '$ echo -ne '\''\xf0\x90\x80\xbf'\''|json'
echo -ne '\xf0\x90\x80\xbf'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\x90\x80\xbf'\''|json'

echo '$ echo -ne '\''\xf0\x90\xbf\x80'\''|json'
echo -ne '\xf0\x90\xbf\x80'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\x90\xbf\x80'\''|json'

echo '$ echo -ne '\''\xf0\x90\xbf\xbf'\''|json'
echo -ne '\xf0\x90\xbf\xbf'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\x90\xbf\xbf'\''|json'

echo '$ echo -ne '\''\xf0\xbf\x80\x80'\''|json'
echo -ne '\xf0\xbf\x80\x80'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\xbf\x80\x80'\''|json'

echo '$ echo -ne '\''\xf0\xbf\x80\xbf'\''|json'
echo -ne '\xf0\xbf\x80\xbf'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\xbf\x80\xbf'\''|json'

echo '$ echo -ne '\''\xf0\xbf\xbf\x80'\''|json'
echo -ne '\xf0\xbf\xbf\x80'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\xbf\xbf\x80'\''|json'

echo '$ echo -ne '\''\xf0\xbf\xbf\xbf'\''|json'
echo -ne '\xf0\xbf\xbf\xbf'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf0\xbf\xbf\xbf'\''|json'

echo '$ echo -ne '\''\xf1\x80\x80\x80'\''|json'
echo -ne '\xf1\x80\x80\x80'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf1\x80\x80\x80'\''|json'

echo '$ echo -ne '\''\xf1\x80\x80\xbf'\''|json'
echo -ne '\xf1\x80\x80\xbf'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf1\x80\x80\xbf'\''|json'

echo '$ echo -ne '\''\xf1\x80\xbf\x80'\''|json'
echo -ne '\xf1\x80\xbf\x80'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf1\x80\xbf\x80'\''|json'

echo '$ echo -ne '\''\xf1\x80\xbf\xbf'\''|json'
echo -ne '\xf1\x80\xbf\xbf'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf1\x80\xbf\xbf'\''|json'

echo '$ echo -ne '\''\xf1\xbf\x80\x80'\''|json'
echo -ne '\xf1\xbf\x80\x80'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf1\xbf\x80\x80'\''|json'

echo '$ echo -ne '\''\xf1\xbf\x80\xbf'\''|json'
echo -ne '\xf1\xbf\x80\xbf'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf1\xbf\x80\xbf'\''|json'

echo '$ echo -ne '\''\xf1\xbf\xbf\x80'\''|json'
echo -ne '\xf1\xbf\xbf\x80'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf1\xbf\xbf\x80'\''|json'

echo '$ echo -ne '\''\xf1\xbf\xbf\xbf'\''|json'
echo -ne '\xf1\xbf\xbf\xbf'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf1\xbf\xbf\xbf'\''|json'

echo '$ echo -ne '\''\xf3\x80\x80\x80'\''|json'
echo -ne '\xf3\x80\x80\x80'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf3\x80\x80\x80'\''|json'

echo '$ echo -ne '\''\xf3\x80\x80\xbf'\''|json'
echo -ne '\xf3\x80\x80\xbf'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf3\x80\x80\xbf'\''|json'

echo '$ echo -ne '\''\xf3\x80\xbf\x80'\''|json'
echo -ne '\xf3\x80\xbf\x80'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf3\x80\xbf\x80'\''|json'

echo '$ echo -ne '\''\xf3\x80\xbf\xbf'\''|json'
echo -ne '\xf3\x80\xbf\xbf'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf3\x80\xbf\xbf'\''|json'

echo '$ echo -ne '\''\xf3\xbf\x80\x80'\''|json'
echo -ne '\xf3\xbf\x80\x80'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf3\xbf\x80\x80'\''|json'

echo '$ echo -ne '\''\xf3\xbf\x80\xbf'\''|json'
echo -ne '\xf3\xbf\x80\xbf'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf3\xbf\x80\xbf'\''|json'

echo '$ echo -ne '\''\xf3\xbf\xbf\x80'\''|json'
echo -ne '\xf3\xbf\xbf\x80'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf3\xbf\xbf\x80'\''|json'

echo '$ echo -ne '\''\xf3\xbf\xbf\xbf'\''|json'
echo -ne '\xf3\xbf\xbf\xbf'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf3\xbf\xbf\xbf'\''|json'

echo '$ echo -ne '\''\xf4\x80\x80\x80'\''|json'
echo -ne '\xf4\x80\x80\x80'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf4\x80\x80\x80'\''|json'

echo '$ echo -ne '\''\xf4\x80\x80\xbf'\''|json'
echo -ne '\xf4\x80\x80\xbf'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf4\x80\x80\xbf'\''|json'

echo '$ echo -ne '\''\xf4\x80\xbf\x80'\''|json'
echo -ne '\xf4\x80\xbf\x80'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf4\x80\xbf\x80'\''|json'

echo '$ echo -ne '\''\xf4\x80\xbf\xbf'\''|json'
echo -ne '\xf4\x80\xbf\xbf'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf4\x80\xbf\xbf'\''|json'

echo '$ echo -ne '\''\xf4\x8f\x80\x80'\''|json'
echo -ne '\xf4\x8f\x80\x80'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf4\x8f\x80\x80'\''|json'

echo '$ echo -ne '\''\xf4\x8f\x80\xbf'\''|json'
echo -ne '\xf4\x8f\x80\xbf'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf4\x8f\x80\xbf'\''|json'

echo '$ echo -ne '\''\xf4\x8f\xbf\x80'\''|json'
echo -ne '\xf4\x8f\xbf\x80'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf4\x8f\xbf\x80'\''|json'

echo '$ echo -ne '\''\xf4\x8f\xbf\xbf'\''|json'
echo -ne '\xf4\x8f\xbf\xbf'|json 2>&1 ||
echo 'command failed: echo -ne '\''\xf4\x8f\xbf\xbf'\''|json'
)

