#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -p litex -C expr-ast:null-char2
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L null-char2.old <(echo \
'$ shopt -s expand_aliases
$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"
$ test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vc ast; }
$ alias test-expr='\''test-expr -n. -E'\''
$ test-expr '\''/\0/'\'' '\''"."'\''
1
$ test-expr '\''/\0/'\'' '\''"."'\''
1
$ test-expr '\''/^\0/'\'' '\''"."'\''
1
$ test-expr '\''/^\0/'\'' '\''"."'\''
1
$ test-expr '\''#/\0/'\'' '\''"."'\''
1
$ test-expr '\''#/\0/'\'' '\''"."'\''
1
$ test-expr '\''#/^\0/'\'' '\''"."'\''
1
$ test-expr '\''#/^\0/'\'' '\''"."'\''
1
$ test-expr '\''/\0/'\'' '\''".y"'\''
1
$ test-expr '\''/\0/'\'' '\''".y"'\''
1
$ test-expr '\''/^\0/'\'' '\''".y"'\''
1
$ test-expr '\''/^\0/'\'' '\''".y"'\''
1
$ test-expr '\''#/\0/'\'' '\''".y"'\''
1
$ test-expr '\''#/\0/'\'' '\''".y"'\''
1
$ test-expr '\''#/^\0/'\'' '\''".y"'\''
1
$ test-expr '\''#/^\0/'\'' '\''".y"'\''
1
$ test-expr '\''/\0/'\'' '\''"x."'\''
1
$ test-expr '\''/\0/'\'' '\''"x."'\''
1
$ test-expr '\''/^\0/'\'' '\''"x."'\''
0
$ test-expr '\''/^\0/'\'' '\''"x."'\''
0
$ test-expr '\''#/\0/'\'' '\''"x."'\''
1
$ test-expr '\''#/\0/'\'' '\''"x."'\''
1
$ test-expr '\''#/^\0/'\'' '\''"x."'\''
0
$ test-expr '\''#/^\0/'\'' '\''"x."'\''
0
$ test-expr '\''/\0/'\'' '\''"x.y"'\''
1
$ test-expr '\''/\0/'\'' '\''"x.y"'\''
1
$ test-expr '\''/^\0/'\'' '\''"x.y"'\''
0
$ test-expr '\''/^\0/'\'' '\''"x.y"'\''
0
$ test-expr '\''#/\0/'\'' '\''"x.y"'\''
1
$ test-expr '\''#/\0/'\'' '\''"x.y"'\''
1
$ test-expr '\''#/^\0/'\'' '\''"x.y"'\''
0
$ test-expr '\''#/^\0/'\'' '\''"x.y"'\''
0
$ test-expr '\''/\0/'\'' '\''"..."'\''
1
$ test-expr '\''/\0/'\'' '\''"..."'\''
1
$ test-expr '\''/^\0/'\'' '\''"..."'\''
1
$ test-expr '\''/^\0/'\'' '\''"..."'\''
1
$ test-expr '\''#/\0/'\'' '\''"..."'\''
3
$ test-expr '\''#/\0/'\'' '\''"..."'\''
3
$ test-expr '\''#/^\0/'\'' '\''"..."'\''
3
$ test-expr '\''#/^\0/'\'' '\''"..."'\''
3
$ test-expr '\''/\0/'\'' '\''"...y"'\''
1
$ test-expr '\''/\0/'\'' '\''"...y"'\''
1
$ test-expr '\''/^\0/'\'' '\''"...y"'\''
1
$ test-expr '\''/^\0/'\'' '\''"...y"'\''
1
$ test-expr '\''#/\0/'\'' '\''"...y"'\''
3
$ test-expr '\''#/\0/'\'' '\''"...y"'\''
3
$ test-expr '\''#/^\0/'\'' '\''"...y"'\''
3
$ test-expr '\''#/^\0/'\'' '\''"...y"'\''
3
$ test-expr '\''/\0/'\'' '\''"x..."'\''
1
$ test-expr '\''/\0/'\'' '\''"x..."'\''
1
$ test-expr '\''/^\0/'\'' '\''"x..."'\''
0
$ test-expr '\''/^\0/'\'' '\''"x..."'\''
0
$ test-expr '\''#/\0/'\'' '\''"x..."'\''
3
$ test-expr '\''#/\0/'\'' '\''"x..."'\''
3
$ test-expr '\''#/^\0/'\'' '\''"x..."'\''
0
$ test-expr '\''#/^\0/'\'' '\''"x..."'\''
0
$ test-expr '\''/\0/'\'' '\''"x...y"'\''
1
$ test-expr '\''/\0/'\'' '\''"x...y"'\''
1
$ test-expr '\''/^\0/'\'' '\''"x...y"'\''
0
$ test-expr '\''/^\0/'\'' '\''"x...y"'\''
0
$ test-expr '\''#/\0/'\'' '\''"x...y"'\''
3
$ test-expr '\''#/\0/'\'' '\''"x...y"'\''
3
$ test-expr '\''#/^\0/'\'' '\''"x...y"'\''
0
$ test-expr '\''#/^\0/'\'' '\''"x...y"'\''
0
$ test-expr '\''/\0\0/'\'' '\''".."'\''
1
$ test-expr '\''/\0\0/'\'' '\''".."'\''
1
$ test-expr '\''/^\0\0/'\'' '\''".."'\''
1
$ test-expr '\''/^\0\0/'\'' '\''".."'\''
1
$ test-expr '\''#/\0\0/'\'' '\''".."'\''
1
$ test-expr '\''#/\0\0/'\'' '\''".."'\''
1
$ test-expr '\''#/^\0\0/'\'' '\''".."'\''
1
$ test-expr '\''#/^\0\0/'\'' '\''".."'\''
1
$ test-expr '\''/\0\0/'\'' '\''"..y"'\''
1
$ test-expr '\''/\0\0/'\'' '\''"..y"'\''
1
$ test-expr '\''/^\0\0/'\'' '\''"..y"'\''
1
$ test-expr '\''/^\0\0/'\'' '\''"..y"'\''
1
$ test-expr '\''#/\0\0/'\'' '\''"..y"'\''
1
$ test-expr '\''#/\0\0/'\'' '\''"..y"'\''
1
$ test-expr '\''#/^\0\0/'\'' '\''"..y"'\''
1
$ test-expr '\''#/^\0\0/'\'' '\''"..y"'\''
1
$ test-expr '\''/\0\0/'\'' '\''"x.."'\''
1
$ test-expr '\''/\0\0/'\'' '\''"x.."'\''
1
$ test-expr '\''/^\0\0/'\'' '\''"x.."'\''
0
$ test-expr '\''/^\0\0/'\'' '\''"x.."'\''
0
$ test-expr '\''#/\0\0/'\'' '\''"x.."'\''
1
$ test-expr '\''#/\0\0/'\'' '\''"x.."'\''
1
$ test-expr '\''#/^\0\0/'\'' '\''"x.."'\''
0
$ test-expr '\''#/^\0\0/'\'' '\''"x.."'\''
0
$ test-expr '\''/\0\0/'\'' '\''"x..y"'\''
1
$ test-expr '\''/\0\0/'\'' '\''"x..y"'\''
1
$ test-expr '\''/^\0\0/'\'' '\''"x..y"'\''
0
$ test-expr '\''/^\0\0/'\'' '\''"x..y"'\''
0
$ test-expr '\''#/\0\0/'\'' '\''"x..y"'\''
1
$ test-expr '\''#/\0\0/'\'' '\''"x..y"'\''
1
$ test-expr '\''#/^\0\0/'\'' '\''"x..y"'\''
0
$ test-expr '\''#/^\0\0/'\'' '\''"x..y"'\''
0
$ test-expr '\''/\0\0/'\'' '\''"....."'\''
1
$ test-expr '\''/\0\0/'\'' '\''"....."'\''
1
$ test-expr '\''/^\0\0/'\'' '\''"....."'\''
1
$ test-expr '\''/^\0\0/'\'' '\''"....."'\''
1
$ test-expr '\''#/\0\0/'\'' '\''"....."'\''
2
$ test-expr '\''#/\0\0/'\'' '\''"....."'\''
2
$ test-expr '\''#/^\0\0/'\'' '\''"....."'\''
2
$ test-expr '\''#/^\0\0/'\'' '\''"....."'\''
2
$ test-expr '\''/\0\0/'\'' '\''".....y"'\''
1
$ test-expr '\''/\0\0/'\'' '\''".....y"'\''
1
$ test-expr '\''/^\0\0/'\'' '\''".....y"'\''
1
$ test-expr '\''/^\0\0/'\'' '\''".....y"'\''
1
$ test-expr '\''#/\0\0/'\'' '\''".....y"'\''
2
$ test-expr '\''#/\0\0/'\'' '\''".....y"'\''
2
$ test-expr '\''#/^\0\0/'\'' '\''".....y"'\''
2
$ test-expr '\''#/^\0\0/'\'' '\''".....y"'\''
2
$ test-expr '\''/\0\0/'\'' '\''"x....."'\''
1
$ test-expr '\''/\0\0/'\'' '\''"x....."'\''
1
$ test-expr '\''/^\0\0/'\'' '\''"x....."'\''
0
$ test-expr '\''/^\0\0/'\'' '\''"x....."'\''
0
$ test-expr '\''#/\0\0/'\'' '\''"x....."'\''
2
$ test-expr '\''#/\0\0/'\'' '\''"x....."'\''
2
$ test-expr '\''#/^\0\0/'\'' '\''"x....."'\''
0
$ test-expr '\''#/^\0\0/'\'' '\''"x....."'\''
0
$ test-expr '\''/\0\0/'\'' '\''"x.....y"'\''
1
$ test-expr '\''/\0\0/'\'' '\''"x.....y"'\''
1
$ test-expr '\''/^\0\0/'\'' '\''"x.....y"'\''
0
$ test-expr '\''/^\0\0/'\'' '\''"x.....y"'\''
0
$ test-expr '\''#/\0\0/'\'' '\''"x.....y"'\''
2
$ test-expr '\''#/\0\0/'\'' '\''"x.....y"'\''
2
$ test-expr '\''#/^\0\0/'\'' '\''"x.....y"'\''
0
$ test-expr '\''#/^\0\0/'\'' '\''"x.....y"'\''
0
$ test-expr '\''/\0a\0/'\'' '\''".a."'\''
1
$ test-expr '\''/\0a\0/'\'' '\''".a."'\''
1
$ test-expr '\''/^\0a\0/'\'' '\''".a."'\''
1
$ test-expr '\''/^\0a\0/'\'' '\''".a."'\''
1
$ test-expr '\''#/\0a\0/'\'' '\''".a."'\''
1
$ test-expr '\''#/\0a\0/'\'' '\''".a."'\''
1
$ test-expr '\''#/^\0a\0/'\'' '\''".a."'\''
1
$ test-expr '\''#/^\0a\0/'\'' '\''".a."'\''
1
$ test-expr '\''/\0a\0/'\'' '\''".a.y"'\''
1
$ test-expr '\''/\0a\0/'\'' '\''".a.y"'\''
1
$ test-expr '\''/^\0a\0/'\'' '\''".a.y"'\''
1
$ test-expr '\''/^\0a\0/'\'' '\''".a.y"'\''
1
$ test-expr '\''#/\0a\0/'\'' '\''".a.y"'\''
1
$ test-expr '\''#/\0a\0/'\'' '\''".a.y"'\''
1
$ test-expr '\''#/^\0a\0/'\'' '\''".a.y"'\''
1
$ test-expr '\''#/^\0a\0/'\'' '\''".a.y"'\''
1
$ test-expr '\''/\0a\0/'\'' '\''"x.a."'\''
1
$ test-expr '\''/\0a\0/'\'' '\''"x.a."'\''
1
$ test-expr '\''/^\0a\0/'\'' '\''"x.a."'\''
0
$ test-expr '\''/^\0a\0/'\'' '\''"x.a."'\''
0
$ test-expr '\''#/\0a\0/'\'' '\''"x.a."'\''
1
$ test-expr '\''#/\0a\0/'\'' '\''"x.a."'\''
1
$ test-expr '\''#/^\0a\0/'\'' '\''"x.a."'\''
0
$ test-expr '\''#/^\0a\0/'\'' '\''"x.a."'\''
0
$ test-expr '\''/\0a\0/'\'' '\''"x.a.y"'\''
1
$ test-expr '\''/\0a\0/'\'' '\''"x.a.y"'\''
1
$ test-expr '\''/^\0a\0/'\'' '\''"x.a.y"'\''
0
$ test-expr '\''/^\0a\0/'\'' '\''"x.a.y"'\''
0
$ test-expr '\''#/\0a\0/'\'' '\''"x.a.y"'\''
1
$ test-expr '\''#/\0a\0/'\'' '\''"x.a.y"'\''
1
$ test-expr '\''#/^\0a\0/'\'' '\''"x.a.y"'\''
0
$ test-expr '\''#/^\0a\0/'\'' '\''"x.a.y"'\''
0
$ test-expr '\''/\0a\0/'\'' '\''".a...a."'\''
1
$ test-expr '\''/\0a\0/'\'' '\''".a...a."'\''
1
$ test-expr '\''/^\0a\0/'\'' '\''".a...a."'\''
1
$ test-expr '\''/^\0a\0/'\'' '\''".a...a."'\''
1
$ test-expr '\''#/\0a\0/'\'' '\''".a...a."'\''
2
$ test-expr '\''#/\0a\0/'\'' '\''".a...a."'\''
2
$ test-expr '\''#/^\0a\0/'\'' '\''".a...a."'\''
1
$ test-expr '\''#/^\0a\0/'\'' '\''".a...a."'\''
1
$ test-expr '\''/\0a\0/'\'' '\''".a...a.y"'\''
1
$ test-expr '\''/\0a\0/'\'' '\''".a...a.y"'\''
1
$ test-expr '\''/^\0a\0/'\'' '\''".a...a.y"'\''
1
$ test-expr '\''/^\0a\0/'\'' '\''".a...a.y"'\''
1
$ test-expr '\''#/\0a\0/'\'' '\''".a...a.y"'\''
2
$ test-expr '\''#/\0a\0/'\'' '\''".a...a.y"'\''
2
$ test-expr '\''#/^\0a\0/'\'' '\''".a...a.y"'\''
1
$ test-expr '\''#/^\0a\0/'\'' '\''".a...a.y"'\''
1
$ test-expr '\''/\0a\0/'\'' '\''"x.a...a."'\''
1
$ test-expr '\''/\0a\0/'\'' '\''"x.a...a."'\''
1
$ test-expr '\''/^\0a\0/'\'' '\''"x.a...a."'\''
0
$ test-expr '\''/^\0a\0/'\'' '\''"x.a...a."'\''
0
$ test-expr '\''#/\0a\0/'\'' '\''"x.a...a."'\''
2
$ test-expr '\''#/\0a\0/'\'' '\''"x.a...a."'\''
2
$ test-expr '\''#/^\0a\0/'\'' '\''"x.a...a."'\''
0
$ test-expr '\''#/^\0a\0/'\'' '\''"x.a...a."'\''
0
$ test-expr '\''/\0a\0/'\'' '\''"x.a...a.y"'\''
1
$ test-expr '\''/\0a\0/'\'' '\''"x.a...a.y"'\''
1
$ test-expr '\''/^\0a\0/'\'' '\''"x.a...a.y"'\''
0
$ test-expr '\''/^\0a\0/'\'' '\''"x.a...a.y"'\''
0
$ test-expr '\''#/\0a\0/'\'' '\''"x.a...a.y"'\''
2
$ test-expr '\''#/\0a\0/'\'' '\''"x.a...a.y"'\''
2
$ test-expr '\''#/^\0a\0/'\'' '\''"x.a...a.y"'\''
0
$ test-expr '\''#/^\0a\0/'\'' '\''"x.a...a.y"'\''
0
$ test-expr '\''/a\0b/'\'' '\''"a.b"'\''
1
$ test-expr '\''/a\0b/'\'' '\''"a.b"'\''
1
$ test-expr '\''/^a\0b/'\'' '\''"a.b"'\''
1
$ test-expr '\''/^a\0b/'\'' '\''"a.b"'\''
1
$ test-expr '\''#/a\0b/'\'' '\''"a.b"'\''
1
$ test-expr '\''#/a\0b/'\'' '\''"a.b"'\''
1
$ test-expr '\''#/^a\0b/'\'' '\''"a.b"'\''
1
$ test-expr '\''#/^a\0b/'\'' '\''"a.b"'\''
1
$ test-expr '\''/a\0b/'\'' '\''"a.by"'\''
1
$ test-expr '\''/a\0b/'\'' '\''"a.by"'\''
1
$ test-expr '\''/^a\0b/'\'' '\''"a.by"'\''
1
$ test-expr '\''/^a\0b/'\'' '\''"a.by"'\''
1
$ test-expr '\''#/a\0b/'\'' '\''"a.by"'\''
1
$ test-expr '\''#/a\0b/'\'' '\''"a.by"'\''
1
$ test-expr '\''#/^a\0b/'\'' '\''"a.by"'\''
1
$ test-expr '\''#/^a\0b/'\'' '\''"a.by"'\''
1
$ test-expr '\''/a\0b/'\'' '\''"xa.b"'\''
1
$ test-expr '\''/a\0b/'\'' '\''"xa.b"'\''
1
$ test-expr '\''/^a\0b/'\'' '\''"xa.b"'\''
0
$ test-expr '\''/^a\0b/'\'' '\''"xa.b"'\''
0
$ test-expr '\''#/a\0b/'\'' '\''"xa.b"'\''
1
$ test-expr '\''#/a\0b/'\'' '\''"xa.b"'\''
1
$ test-expr '\''#/^a\0b/'\'' '\''"xa.b"'\''
0
$ test-expr '\''#/^a\0b/'\'' '\''"xa.b"'\''
0
$ test-expr '\''/a\0b/'\'' '\''"xa.by"'\''
1
$ test-expr '\''/a\0b/'\'' '\''"xa.by"'\''
1
$ test-expr '\''/^a\0b/'\'' '\''"xa.by"'\''
0
$ test-expr '\''/^a\0b/'\'' '\''"xa.by"'\''
0
$ test-expr '\''#/a\0b/'\'' '\''"xa.by"'\''
1
$ test-expr '\''#/a\0b/'\'' '\''"xa.by"'\''
1
$ test-expr '\''#/^a\0b/'\'' '\''"xa.by"'\''
0
$ test-expr '\''#/^a\0b/'\'' '\''"xa.by"'\''
0
$ test-expr '\''/a\0b/'\'' '\''"a.b.a.b"'\''
1
$ test-expr '\''/a\0b/'\'' '\''"a.b.a.b"'\''
1
$ test-expr '\''/^a\0b/'\'' '\''"a.b.a.b"'\''
1
$ test-expr '\''/^a\0b/'\'' '\''"a.b.a.b"'\''
1
$ test-expr '\''#/a\0b/'\'' '\''"a.b.a.b"'\''
2
$ test-expr '\''#/a\0b/'\'' '\''"a.b.a.b"'\''
2
$ test-expr '\''#/^a\0b/'\'' '\''"a.b.a.b"'\''
1
$ test-expr '\''#/^a\0b/'\'' '\''"a.b.a.b"'\''
1
$ test-expr '\''/a\0b/'\'' '\''"a.b.a.by"'\''
1
$ test-expr '\''/a\0b/'\'' '\''"a.b.a.by"'\''
1
$ test-expr '\''/^a\0b/'\'' '\''"a.b.a.by"'\''
1
$ test-expr '\''/^a\0b/'\'' '\''"a.b.a.by"'\''
1
$ test-expr '\''#/a\0b/'\'' '\''"a.b.a.by"'\''
2
$ test-expr '\''#/a\0b/'\'' '\''"a.b.a.by"'\''
2
$ test-expr '\''#/^a\0b/'\'' '\''"a.b.a.by"'\''
1
$ test-expr '\''#/^a\0b/'\'' '\''"a.b.a.by"'\''
1
$ test-expr '\''/a\0b/'\'' '\''"xa.b.a.b"'\''
1
$ test-expr '\''/a\0b/'\'' '\''"xa.b.a.b"'\''
1
$ test-expr '\''/^a\0b/'\'' '\''"xa.b.a.b"'\''
0
$ test-expr '\''/^a\0b/'\'' '\''"xa.b.a.b"'\''
0
$ test-expr '\''#/a\0b/'\'' '\''"xa.b.a.b"'\''
2
$ test-expr '\''#/a\0b/'\'' '\''"xa.b.a.b"'\''
2
$ test-expr '\''#/^a\0b/'\'' '\''"xa.b.a.b"'\''
0
$ test-expr '\''#/^a\0b/'\'' '\''"xa.b.a.b"'\''
0
$ test-expr '\''/a\0b/'\'' '\''"xa.b.a.by"'\''
1
$ test-expr '\''/a\0b/'\'' '\''"xa.b.a.by"'\''
1
$ test-expr '\''/^a\0b/'\'' '\''"xa.b.a.by"'\''
0
$ test-expr '\''/^a\0b/'\'' '\''"xa.b.a.by"'\''
0
$ test-expr '\''#/a\0b/'\'' '\''"xa.b.a.by"'\''
2
$ test-expr '\''#/a\0b/'\'' '\''"xa.b.a.by"'\''
2
$ test-expr '\''#/^a\0b/'\'' '\''"xa.b.a.by"'\''
0
$ test-expr '\''#/^a\0b/'\'' '\''"xa.b.a.by"'\''
0
$ test-expr '\''/a\0b\0c/'\'' '\''"a.b.c"'\''
1
$ test-expr '\''/a\0b\0c/'\'' '\''"a.b.c"'\''
1
$ test-expr '\''/^a\0b\0c/'\'' '\''"a.b.c"'\''
1
$ test-expr '\''/^a\0b\0c/'\'' '\''"a.b.c"'\''
1
$ test-expr '\''#/a\0b\0c/'\'' '\''"a.b.c"'\''
1
$ test-expr '\''#/a\0b\0c/'\'' '\''"a.b.c"'\''
1
$ test-expr '\''#/^a\0b\0c/'\'' '\''"a.b.c"'\''
1
$ test-expr '\''#/^a\0b\0c/'\'' '\''"a.b.c"'\''
1
$ test-expr '\''/a\0b\0c/'\'' '\''"a.b.cy"'\''
1
$ test-expr '\''/a\0b\0c/'\'' '\''"a.b.cy"'\''
1
$ test-expr '\''/^a\0b\0c/'\'' '\''"a.b.cy"'\''
1
$ test-expr '\''/^a\0b\0c/'\'' '\''"a.b.cy"'\''
1
$ test-expr '\''#/a\0b\0c/'\'' '\''"a.b.cy"'\''
1
$ test-expr '\''#/a\0b\0c/'\'' '\''"a.b.cy"'\''
1
$ test-expr '\''#/^a\0b\0c/'\'' '\''"a.b.cy"'\''
1
$ test-expr '\''#/^a\0b\0c/'\'' '\''"a.b.cy"'\''
1
$ test-expr '\''/a\0b\0c/'\'' '\''"xa.b.c"'\''
1
$ test-expr '\''/a\0b\0c/'\'' '\''"xa.b.c"'\''
1
$ test-expr '\''/^a\0b\0c/'\'' '\''"xa.b.c"'\''
0
$ test-expr '\''/^a\0b\0c/'\'' '\''"xa.b.c"'\''
0
$ test-expr '\''#/a\0b\0c/'\'' '\''"xa.b.c"'\''
1
$ test-expr '\''#/a\0b\0c/'\'' '\''"xa.b.c"'\''
1
$ test-expr '\''#/^a\0b\0c/'\'' '\''"xa.b.c"'\''
0
$ test-expr '\''#/^a\0b\0c/'\'' '\''"xa.b.c"'\''
0
$ test-expr '\''/a\0b\0c/'\'' '\''"xa.b.cy"'\''
1
$ test-expr '\''/a\0b\0c/'\'' '\''"xa.b.cy"'\''
1
$ test-expr '\''/^a\0b\0c/'\'' '\''"xa.b.cy"'\''
0
$ test-expr '\''/^a\0b\0c/'\'' '\''"xa.b.cy"'\''
0
$ test-expr '\''#/a\0b\0c/'\'' '\''"xa.b.cy"'\''
1
$ test-expr '\''#/a\0b\0c/'\'' '\''"xa.b.cy"'\''
1
$ test-expr '\''#/^a\0b\0c/'\'' '\''"xa.b.cy"'\''
0
$ test-expr '\''#/^a\0b\0c/'\'' '\''"xa.b.cy"'\''
0
$ test-expr '\''/a\0b\0c/'\'' '\''"a.b.c.a.b.c"'\''
1
$ test-expr '\''/a\0b\0c/'\'' '\''"a.b.c.a.b.c"'\''
1
$ test-expr '\''/^a\0b\0c/'\'' '\''"a.b.c.a.b.c"'\''
1
$ test-expr '\''/^a\0b\0c/'\'' '\''"a.b.c.a.b.c"'\''
1
$ test-expr '\''#/a\0b\0c/'\'' '\''"a.b.c.a.b.c"'\''
2
$ test-expr '\''#/a\0b\0c/'\'' '\''"a.b.c.a.b.c"'\''
2
$ test-expr '\''#/^a\0b\0c/'\'' '\''"a.b.c.a.b.c"'\''
1
$ test-expr '\''#/^a\0b\0c/'\'' '\''"a.b.c.a.b.c"'\''
1
$ test-expr '\''/a\0b\0c/'\'' '\''"a.b.c.a.b.cy"'\''
1
$ test-expr '\''/a\0b\0c/'\'' '\''"a.b.c.a.b.cy"'\''
1
$ test-expr '\''/^a\0b\0c/'\'' '\''"a.b.c.a.b.cy"'\''
1
$ test-expr '\''/^a\0b\0c/'\'' '\''"a.b.c.a.b.cy"'\''
1
$ test-expr '\''#/a\0b\0c/'\'' '\''"a.b.c.a.b.cy"'\''
2
$ test-expr '\''#/a\0b\0c/'\'' '\''"a.b.c.a.b.cy"'\''
2
$ test-expr '\''#/^a\0b\0c/'\'' '\''"a.b.c.a.b.cy"'\''
1
$ test-expr '\''#/^a\0b\0c/'\'' '\''"a.b.c.a.b.cy"'\''
1
$ test-expr '\''/a\0b\0c/'\'' '\''"xa.b.c.a.b.c"'\''
1
$ test-expr '\''/a\0b\0c/'\'' '\''"xa.b.c.a.b.c"'\''
1
$ test-expr '\''/^a\0b\0c/'\'' '\''"xa.b.c.a.b.c"'\''
0
$ test-expr '\''/^a\0b\0c/'\'' '\''"xa.b.c.a.b.c"'\''
0
$ test-expr '\''#/a\0b\0c/'\'' '\''"xa.b.c.a.b.c"'\''
2
$ test-expr '\''#/a\0b\0c/'\'' '\''"xa.b.c.a.b.c"'\''
2
$ test-expr '\''#/^a\0b\0c/'\'' '\''"xa.b.c.a.b.c"'\''
0
$ test-expr '\''#/^a\0b\0c/'\'' '\''"xa.b.c.a.b.c"'\''
0
$ test-expr '\''/a\0b\0c/'\'' '\''"xa.b.c.a.b.cy"'\''
1
$ test-expr '\''/a\0b\0c/'\'' '\''"xa.b.c.a.b.cy"'\''
1
$ test-expr '\''/^a\0b\0c/'\'' '\''"xa.b.c.a.b.cy"'\''
0
$ test-expr '\''/^a\0b\0c/'\'' '\''"xa.b.c.a.b.cy"'\''
0
$ test-expr '\''#/a\0b\0c/'\'' '\''"xa.b.c.a.b.cy"'\''
2
$ test-expr '\''#/a\0b\0c/'\'' '\''"xa.b.c.a.b.cy"'\''
2
$ test-expr '\''#/^a\0b\0c/'\'' '\''"xa.b.c.a.b.cy"'\''
0
$ test-expr '\''#/^a\0b\0c/'\'' '\''"xa.b.c.a.b.cy"'\''
0
$ test-expr '\''/a\0b\0c\0d/'\'' '\''"a.b.c.d"'\''
1
$ test-expr '\''/a\0b\0c\0d/'\'' '\''"a.b.c.d"'\''
1
$ test-expr '\''/^a\0b\0c\0d/'\'' '\''"a.b.c.d"'\''
1
$ test-expr '\''/^a\0b\0c\0d/'\'' '\''"a.b.c.d"'\''
1
$ test-expr '\''#/a\0b\0c\0d/'\'' '\''"a.b.c.d"'\''
1
$ test-expr '\''#/a\0b\0c\0d/'\'' '\''"a.b.c.d"'\''
1
$ test-expr '\''#/^a\0b\0c\0d/'\'' '\''"a.b.c.d"'\''
1
$ test-expr '\''#/^a\0b\0c\0d/'\'' '\''"a.b.c.d"'\''
1
$ test-expr '\''/a\0b\0c\0d/'\'' '\''"a.b.c.dy"'\''
1
$ test-expr '\''/a\0b\0c\0d/'\'' '\''"a.b.c.dy"'\''
1
$ test-expr '\''/^a\0b\0c\0d/'\'' '\''"a.b.c.dy"'\''
1
$ test-expr '\''/^a\0b\0c\0d/'\'' '\''"a.b.c.dy"'\''
1
$ test-expr '\''#/a\0b\0c\0d/'\'' '\''"a.b.c.dy"'\''
1
$ test-expr '\''#/a\0b\0c\0d/'\'' '\''"a.b.c.dy"'\''
1
$ test-expr '\''#/^a\0b\0c\0d/'\'' '\''"a.b.c.dy"'\''
1
$ test-expr '\''#/^a\0b\0c\0d/'\'' '\''"a.b.c.dy"'\''
1
$ test-expr '\''/a\0b\0c\0d/'\'' '\''"xa.b.c.d"'\''
1
$ test-expr '\''/a\0b\0c\0d/'\'' '\''"xa.b.c.d"'\''
1
$ test-expr '\''/^a\0b\0c\0d/'\'' '\''"xa.b.c.d"'\''
0
$ test-expr '\''/^a\0b\0c\0d/'\'' '\''"xa.b.c.d"'\''
0
$ test-expr '\''#/a\0b\0c\0d/'\'' '\''"xa.b.c.d"'\''
1
$ test-expr '\''#/a\0b\0c\0d/'\'' '\''"xa.b.c.d"'\''
1
$ test-expr '\''#/^a\0b\0c\0d/'\'' '\''"xa.b.c.d"'\''
0
$ test-expr '\''#/^a\0b\0c\0d/'\'' '\''"xa.b.c.d"'\''
0
$ test-expr '\''/a\0b\0c\0d/'\'' '\''"xa.b.c.dy"'\''
1
$ test-expr '\''/a\0b\0c\0d/'\'' '\''"xa.b.c.dy"'\''
1
$ test-expr '\''/^a\0b\0c\0d/'\'' '\''"xa.b.c.dy"'\''
0
$ test-expr '\''/^a\0b\0c\0d/'\'' '\''"xa.b.c.dy"'\''
0
$ test-expr '\''#/a\0b\0c\0d/'\'' '\''"xa.b.c.dy"'\''
1
$ test-expr '\''#/a\0b\0c\0d/'\'' '\''"xa.b.c.dy"'\''
1
$ test-expr '\''#/^a\0b\0c\0d/'\'' '\''"xa.b.c.dy"'\''
0
$ test-expr '\''#/^a\0b\0c\0d/'\'' '\''"xa.b.c.dy"'\''
0
$ test-expr '\''/a\0b\0c\0d/'\'' '\''"a.b.c.d.a.b.c.d"'\''
1
$ test-expr '\''/a\0b\0c\0d/'\'' '\''"a.b.c.d.a.b.c.d"'\''
1
$ test-expr '\''/^a\0b\0c\0d/'\'' '\''"a.b.c.d.a.b.c.d"'\''
1
$ test-expr '\''/^a\0b\0c\0d/'\'' '\''"a.b.c.d.a.b.c.d"'\''
1
$ test-expr '\''#/a\0b\0c\0d/'\'' '\''"a.b.c.d.a.b.c.d"'\''
2
$ test-expr '\''#/a\0b\0c\0d/'\'' '\''"a.b.c.d.a.b.c.d"'\''
2
$ test-expr '\''#/^a\0b\0c\0d/'\'' '\''"a.b.c.d.a.b.c.d"'\''
1
$ test-expr '\''#/^a\0b\0c\0d/'\'' '\''"a.b.c.d.a.b.c.d"'\''
1
$ test-expr '\''/a\0b\0c\0d/'\'' '\''"a.b.c.d.a.b.c.dy"'\''
1
$ test-expr '\''/a\0b\0c\0d/'\'' '\''"a.b.c.d.a.b.c.dy"'\''
1
$ test-expr '\''/^a\0b\0c\0d/'\'' '\''"a.b.c.d.a.b.c.dy"'\''
1
$ test-expr '\''/^a\0b\0c\0d/'\'' '\''"a.b.c.d.a.b.c.dy"'\''
1
$ test-expr '\''#/a\0b\0c\0d/'\'' '\''"a.b.c.d.a.b.c.dy"'\''
2
$ test-expr '\''#/a\0b\0c\0d/'\'' '\''"a.b.c.d.a.b.c.dy"'\''
2
$ test-expr '\''#/^a\0b\0c\0d/'\'' '\''"a.b.c.d.a.b.c.dy"'\''
1
$ test-expr '\''#/^a\0b\0c\0d/'\'' '\''"a.b.c.d.a.b.c.dy"'\''
1
$ test-expr '\''/a\0b\0c\0d/'\'' '\''"xa.b.c.d.a.b.c.d"'\''
1
$ test-expr '\''/a\0b\0c\0d/'\'' '\''"xa.b.c.d.a.b.c.d"'\''
1
$ test-expr '\''/^a\0b\0c\0d/'\'' '\''"xa.b.c.d.a.b.c.d"'\''
0
$ test-expr '\''/^a\0b\0c\0d/'\'' '\''"xa.b.c.d.a.b.c.d"'\''
0
$ test-expr '\''#/a\0b\0c\0d/'\'' '\''"xa.b.c.d.a.b.c.d"'\''
2
$ test-expr '\''#/a\0b\0c\0d/'\'' '\''"xa.b.c.d.a.b.c.d"'\''
2
$ test-expr '\''#/^a\0b\0c\0d/'\'' '\''"xa.b.c.d.a.b.c.d"'\''
0
$ test-expr '\''#/^a\0b\0c\0d/'\'' '\''"xa.b.c.d.a.b.c.d"'\''
0
$ test-expr '\''/a\0b\0c\0d/'\'' '\''"xa.b.c.d.a.b.c.dy"'\''
1
$ test-expr '\''/a\0b\0c\0d/'\'' '\''"xa.b.c.d.a.b.c.dy"'\''
1
$ test-expr '\''/^a\0b\0c\0d/'\'' '\''"xa.b.c.d.a.b.c.dy"'\''
0
$ test-expr '\''/^a\0b\0c\0d/'\'' '\''"xa.b.c.d.a.b.c.dy"'\''
0
$ test-expr '\''#/a\0b\0c\0d/'\'' '\''"xa.b.c.d.a.b.c.dy"'\''
2
$ test-expr '\''#/a\0b\0c\0d/'\'' '\''"xa.b.c.d.a.b.c.dy"'\''
2
$ test-expr '\''#/^a\0b\0c\0d/'\'' '\''"xa.b.c.d.a.b.c.dy"'\''
0
$ test-expr '\''#/^a\0b\0c\0d/'\'' '\''"xa.b.c.d.a.b.c.dy"'\''
0'
) -L null-char2.new <(
echo '$ shopt -s expand_aliases'
shopt -s expand_aliases 2>&1 ||
echo 'command failed: shopt -s expand_aliases'

echo '$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'
[ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib" 2>&1 ||
echo 'command failed: [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'

echo '$ test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vc ast; }'
test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vc ast; } 2>&1 ||
echo 'command failed: test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vc ast; }'

echo '$ alias test-expr='\''test-expr -n. -E'\'''
alias test-expr='test-expr -n. -E' 2>&1 ||
echo 'command failed: alias test-expr='\''test-expr -n. -E'\'''

echo '$ test-expr '\''/\0/'\'' '\''"."'\'''
test-expr '/\0/' '"."' 2>&1 ||
echo 'command failed: test-expr '\''/\0/'\'' '\''"."'\'''

echo '$ test-expr '\''/\0/'\'' '\''"."'\'''
test-expr '/\0/' '"."' 2>&1 ||
echo 'command failed: test-expr '\''/\0/'\'' '\''"."'\'''

echo '$ test-expr '\''/^\0/'\'' '\''"."'\'''
test-expr '/^\0/' '"."' 2>&1 ||
echo 'command failed: test-expr '\''/^\0/'\'' '\''"."'\'''

echo '$ test-expr '\''/^\0/'\'' '\''"."'\'''
test-expr '/^\0/' '"."' 2>&1 ||
echo 'command failed: test-expr '\''/^\0/'\'' '\''"."'\'''

echo '$ test-expr '\''#/\0/'\'' '\''"."'\'''
test-expr '#/\0/' '"."' 2>&1 ||
echo 'command failed: test-expr '\''#/\0/'\'' '\''"."'\'''

echo '$ test-expr '\''#/\0/'\'' '\''"."'\'''
test-expr '#/\0/' '"."' 2>&1 ||
echo 'command failed: test-expr '\''#/\0/'\'' '\''"."'\'''

echo '$ test-expr '\''#/^\0/'\'' '\''"."'\'''
test-expr '#/^\0/' '"."' 2>&1 ||
echo 'command failed: test-expr '\''#/^\0/'\'' '\''"."'\'''

echo '$ test-expr '\''#/^\0/'\'' '\''"."'\'''
test-expr '#/^\0/' '"."' 2>&1 ||
echo 'command failed: test-expr '\''#/^\0/'\'' '\''"."'\'''

echo '$ test-expr '\''/\0/'\'' '\''".y"'\'''
test-expr '/\0/' '".y"' 2>&1 ||
echo 'command failed: test-expr '\''/\0/'\'' '\''".y"'\'''

echo '$ test-expr '\''/\0/'\'' '\''".y"'\'''
test-expr '/\0/' '".y"' 2>&1 ||
echo 'command failed: test-expr '\''/\0/'\'' '\''".y"'\'''

echo '$ test-expr '\''/^\0/'\'' '\''".y"'\'''
test-expr '/^\0/' '".y"' 2>&1 ||
echo 'command failed: test-expr '\''/^\0/'\'' '\''".y"'\'''

echo '$ test-expr '\''/^\0/'\'' '\''".y"'\'''
test-expr '/^\0/' '".y"' 2>&1 ||
echo 'command failed: test-expr '\''/^\0/'\'' '\''".y"'\'''

echo '$ test-expr '\''#/\0/'\'' '\''".y"'\'''
test-expr '#/\0/' '".y"' 2>&1 ||
echo 'command failed: test-expr '\''#/\0/'\'' '\''".y"'\'''

echo '$ test-expr '\''#/\0/'\'' '\''".y"'\'''
test-expr '#/\0/' '".y"' 2>&1 ||
echo 'command failed: test-expr '\''#/\0/'\'' '\''".y"'\'''

echo '$ test-expr '\''#/^\0/'\'' '\''".y"'\'''
test-expr '#/^\0/' '".y"' 2>&1 ||
echo 'command failed: test-expr '\''#/^\0/'\'' '\''".y"'\'''

echo '$ test-expr '\''#/^\0/'\'' '\''".y"'\'''
test-expr '#/^\0/' '".y"' 2>&1 ||
echo 'command failed: test-expr '\''#/^\0/'\'' '\''".y"'\'''

echo '$ test-expr '\''/\0/'\'' '\''"x."'\'''
test-expr '/\0/' '"x."' 2>&1 ||
echo 'command failed: test-expr '\''/\0/'\'' '\''"x."'\'''

echo '$ test-expr '\''/\0/'\'' '\''"x."'\'''
test-expr '/\0/' '"x."' 2>&1 ||
echo 'command failed: test-expr '\''/\0/'\'' '\''"x."'\'''

echo '$ test-expr '\''/^\0/'\'' '\''"x."'\'''
test-expr '/^\0/' '"x."' 2>&1 ||
echo 'command failed: test-expr '\''/^\0/'\'' '\''"x."'\'''

echo '$ test-expr '\''/^\0/'\'' '\''"x."'\'''
test-expr '/^\0/' '"x."' 2>&1 ||
echo 'command failed: test-expr '\''/^\0/'\'' '\''"x."'\'''

echo '$ test-expr '\''#/\0/'\'' '\''"x."'\'''
test-expr '#/\0/' '"x."' 2>&1 ||
echo 'command failed: test-expr '\''#/\0/'\'' '\''"x."'\'''

echo '$ test-expr '\''#/\0/'\'' '\''"x."'\'''
test-expr '#/\0/' '"x."' 2>&1 ||
echo 'command failed: test-expr '\''#/\0/'\'' '\''"x."'\'''

echo '$ test-expr '\''#/^\0/'\'' '\''"x."'\'''
test-expr '#/^\0/' '"x."' 2>&1 ||
echo 'command failed: test-expr '\''#/^\0/'\'' '\''"x."'\'''

echo '$ test-expr '\''#/^\0/'\'' '\''"x."'\'''
test-expr '#/^\0/' '"x."' 2>&1 ||
echo 'command failed: test-expr '\''#/^\0/'\'' '\''"x."'\'''

echo '$ test-expr '\''/\0/'\'' '\''"x.y"'\'''
test-expr '/\0/' '"x.y"' 2>&1 ||
echo 'command failed: test-expr '\''/\0/'\'' '\''"x.y"'\'''

echo '$ test-expr '\''/\0/'\'' '\''"x.y"'\'''
test-expr '/\0/' '"x.y"' 2>&1 ||
echo 'command failed: test-expr '\''/\0/'\'' '\''"x.y"'\'''

echo '$ test-expr '\''/^\0/'\'' '\''"x.y"'\'''
test-expr '/^\0/' '"x.y"' 2>&1 ||
echo 'command failed: test-expr '\''/^\0/'\'' '\''"x.y"'\'''

echo '$ test-expr '\''/^\0/'\'' '\''"x.y"'\'''
test-expr '/^\0/' '"x.y"' 2>&1 ||
echo 'command failed: test-expr '\''/^\0/'\'' '\''"x.y"'\'''

echo '$ test-expr '\''#/\0/'\'' '\''"x.y"'\'''
test-expr '#/\0/' '"x.y"' 2>&1 ||
echo 'command failed: test-expr '\''#/\0/'\'' '\''"x.y"'\'''

echo '$ test-expr '\''#/\0/'\'' '\''"x.y"'\'''
test-expr '#/\0/' '"x.y"' 2>&1 ||
echo 'command failed: test-expr '\''#/\0/'\'' '\''"x.y"'\'''

echo '$ test-expr '\''#/^\0/'\'' '\''"x.y"'\'''
test-expr '#/^\0/' '"x.y"' 2>&1 ||
echo 'command failed: test-expr '\''#/^\0/'\'' '\''"x.y"'\'''

echo '$ test-expr '\''#/^\0/'\'' '\''"x.y"'\'''
test-expr '#/^\0/' '"x.y"' 2>&1 ||
echo 'command failed: test-expr '\''#/^\0/'\'' '\''"x.y"'\'''

echo '$ test-expr '\''/\0/'\'' '\''"..."'\'''
test-expr '/\0/' '"..."' 2>&1 ||
echo 'command failed: test-expr '\''/\0/'\'' '\''"..."'\'''

echo '$ test-expr '\''/\0/'\'' '\''"..."'\'''
test-expr '/\0/' '"..."' 2>&1 ||
echo 'command failed: test-expr '\''/\0/'\'' '\''"..."'\'''

echo '$ test-expr '\''/^\0/'\'' '\''"..."'\'''
test-expr '/^\0/' '"..."' 2>&1 ||
echo 'command failed: test-expr '\''/^\0/'\'' '\''"..."'\'''

echo '$ test-expr '\''/^\0/'\'' '\''"..."'\'''
test-expr '/^\0/' '"..."' 2>&1 ||
echo 'command failed: test-expr '\''/^\0/'\'' '\''"..."'\'''

echo '$ test-expr '\''#/\0/'\'' '\''"..."'\'''
test-expr '#/\0/' '"..."' 2>&1 ||
echo 'command failed: test-expr '\''#/\0/'\'' '\''"..."'\'''

echo '$ test-expr '\''#/\0/'\'' '\''"..."'\'''
test-expr '#/\0/' '"..."' 2>&1 ||
echo 'command failed: test-expr '\''#/\0/'\'' '\''"..."'\'''

echo '$ test-expr '\''#/^\0/'\'' '\''"..."'\'''
test-expr '#/^\0/' '"..."' 2>&1 ||
echo 'command failed: test-expr '\''#/^\0/'\'' '\''"..."'\'''

echo '$ test-expr '\''#/^\0/'\'' '\''"..."'\'''
test-expr '#/^\0/' '"..."' 2>&1 ||
echo 'command failed: test-expr '\''#/^\0/'\'' '\''"..."'\'''

echo '$ test-expr '\''/\0/'\'' '\''"...y"'\'''
test-expr '/\0/' '"...y"' 2>&1 ||
echo 'command failed: test-expr '\''/\0/'\'' '\''"...y"'\'''

echo '$ test-expr '\''/\0/'\'' '\''"...y"'\'''
test-expr '/\0/' '"...y"' 2>&1 ||
echo 'command failed: test-expr '\''/\0/'\'' '\''"...y"'\'''

echo '$ test-expr '\''/^\0/'\'' '\''"...y"'\'''
test-expr '/^\0/' '"...y"' 2>&1 ||
echo 'command failed: test-expr '\''/^\0/'\'' '\''"...y"'\'''

echo '$ test-expr '\''/^\0/'\'' '\''"...y"'\'''
test-expr '/^\0/' '"...y"' 2>&1 ||
echo 'command failed: test-expr '\''/^\0/'\'' '\''"...y"'\'''

echo '$ test-expr '\''#/\0/'\'' '\''"...y"'\'''
test-expr '#/\0/' '"...y"' 2>&1 ||
echo 'command failed: test-expr '\''#/\0/'\'' '\''"...y"'\'''

echo '$ test-expr '\''#/\0/'\'' '\''"...y"'\'''
test-expr '#/\0/' '"...y"' 2>&1 ||
echo 'command failed: test-expr '\''#/\0/'\'' '\''"...y"'\'''

echo '$ test-expr '\''#/^\0/'\'' '\''"...y"'\'''
test-expr '#/^\0/' '"...y"' 2>&1 ||
echo 'command failed: test-expr '\''#/^\0/'\'' '\''"...y"'\'''

echo '$ test-expr '\''#/^\0/'\'' '\''"...y"'\'''
test-expr '#/^\0/' '"...y"' 2>&1 ||
echo 'command failed: test-expr '\''#/^\0/'\'' '\''"...y"'\'''

echo '$ test-expr '\''/\0/'\'' '\''"x..."'\'''
test-expr '/\0/' '"x..."' 2>&1 ||
echo 'command failed: test-expr '\''/\0/'\'' '\''"x..."'\'''

echo '$ test-expr '\''/\0/'\'' '\''"x..."'\'''
test-expr '/\0/' '"x..."' 2>&1 ||
echo 'command failed: test-expr '\''/\0/'\'' '\''"x..."'\'''

echo '$ test-expr '\''/^\0/'\'' '\''"x..."'\'''
test-expr '/^\0/' '"x..."' 2>&1 ||
echo 'command failed: test-expr '\''/^\0/'\'' '\''"x..."'\'''

echo '$ test-expr '\''/^\0/'\'' '\''"x..."'\'''
test-expr '/^\0/' '"x..."' 2>&1 ||
echo 'command failed: test-expr '\''/^\0/'\'' '\''"x..."'\'''

echo '$ test-expr '\''#/\0/'\'' '\''"x..."'\'''
test-expr '#/\0/' '"x..."' 2>&1 ||
echo 'command failed: test-expr '\''#/\0/'\'' '\''"x..."'\'''

echo '$ test-expr '\''#/\0/'\'' '\''"x..."'\'''
test-expr '#/\0/' '"x..."' 2>&1 ||
echo 'command failed: test-expr '\''#/\0/'\'' '\''"x..."'\'''

echo '$ test-expr '\''#/^\0/'\'' '\''"x..."'\'''
test-expr '#/^\0/' '"x..."' 2>&1 ||
echo 'command failed: test-expr '\''#/^\0/'\'' '\''"x..."'\'''

echo '$ test-expr '\''#/^\0/'\'' '\''"x..."'\'''
test-expr '#/^\0/' '"x..."' 2>&1 ||
echo 'command failed: test-expr '\''#/^\0/'\'' '\''"x..."'\'''

echo '$ test-expr '\''/\0/'\'' '\''"x...y"'\'''
test-expr '/\0/' '"x...y"' 2>&1 ||
echo 'command failed: test-expr '\''/\0/'\'' '\''"x...y"'\'''

echo '$ test-expr '\''/\0/'\'' '\''"x...y"'\'''
test-expr '/\0/' '"x...y"' 2>&1 ||
echo 'command failed: test-expr '\''/\0/'\'' '\''"x...y"'\'''

echo '$ test-expr '\''/^\0/'\'' '\''"x...y"'\'''
test-expr '/^\0/' '"x...y"' 2>&1 ||
echo 'command failed: test-expr '\''/^\0/'\'' '\''"x...y"'\'''

echo '$ test-expr '\''/^\0/'\'' '\''"x...y"'\'''
test-expr '/^\0/' '"x...y"' 2>&1 ||
echo 'command failed: test-expr '\''/^\0/'\'' '\''"x...y"'\'''

echo '$ test-expr '\''#/\0/'\'' '\''"x...y"'\'''
test-expr '#/\0/' '"x...y"' 2>&1 ||
echo 'command failed: test-expr '\''#/\0/'\'' '\''"x...y"'\'''

echo '$ test-expr '\''#/\0/'\'' '\''"x...y"'\'''
test-expr '#/\0/' '"x...y"' 2>&1 ||
echo 'command failed: test-expr '\''#/\0/'\'' '\''"x...y"'\'''

echo '$ test-expr '\''#/^\0/'\'' '\''"x...y"'\'''
test-expr '#/^\0/' '"x...y"' 2>&1 ||
echo 'command failed: test-expr '\''#/^\0/'\'' '\''"x...y"'\'''

echo '$ test-expr '\''#/^\0/'\'' '\''"x...y"'\'''
test-expr '#/^\0/' '"x...y"' 2>&1 ||
echo 'command failed: test-expr '\''#/^\0/'\'' '\''"x...y"'\'''

echo '$ test-expr '\''/\0\0/'\'' '\''".."'\'''
test-expr '/\0\0/' '".."' 2>&1 ||
echo 'command failed: test-expr '\''/\0\0/'\'' '\''".."'\'''

echo '$ test-expr '\''/\0\0/'\'' '\''".."'\'''
test-expr '/\0\0/' '".."' 2>&1 ||
echo 'command failed: test-expr '\''/\0\0/'\'' '\''".."'\'''

echo '$ test-expr '\''/^\0\0/'\'' '\''".."'\'''
test-expr '/^\0\0/' '".."' 2>&1 ||
echo 'command failed: test-expr '\''/^\0\0/'\'' '\''".."'\'''

echo '$ test-expr '\''/^\0\0/'\'' '\''".."'\'''
test-expr '/^\0\0/' '".."' 2>&1 ||
echo 'command failed: test-expr '\''/^\0\0/'\'' '\''".."'\'''

echo '$ test-expr '\''#/\0\0/'\'' '\''".."'\'''
test-expr '#/\0\0/' '".."' 2>&1 ||
echo 'command failed: test-expr '\''#/\0\0/'\'' '\''".."'\'''

echo '$ test-expr '\''#/\0\0/'\'' '\''".."'\'''
test-expr '#/\0\0/' '".."' 2>&1 ||
echo 'command failed: test-expr '\''#/\0\0/'\'' '\''".."'\'''

echo '$ test-expr '\''#/^\0\0/'\'' '\''".."'\'''
test-expr '#/^\0\0/' '".."' 2>&1 ||
echo 'command failed: test-expr '\''#/^\0\0/'\'' '\''".."'\'''

echo '$ test-expr '\''#/^\0\0/'\'' '\''".."'\'''
test-expr '#/^\0\0/' '".."' 2>&1 ||
echo 'command failed: test-expr '\''#/^\0\0/'\'' '\''".."'\'''

echo '$ test-expr '\''/\0\0/'\'' '\''"..y"'\'''
test-expr '/\0\0/' '"..y"' 2>&1 ||
echo 'command failed: test-expr '\''/\0\0/'\'' '\''"..y"'\'''

echo '$ test-expr '\''/\0\0/'\'' '\''"..y"'\'''
test-expr '/\0\0/' '"..y"' 2>&1 ||
echo 'command failed: test-expr '\''/\0\0/'\'' '\''"..y"'\'''

echo '$ test-expr '\''/^\0\0/'\'' '\''"..y"'\'''
test-expr '/^\0\0/' '"..y"' 2>&1 ||
echo 'command failed: test-expr '\''/^\0\0/'\'' '\''"..y"'\'''

echo '$ test-expr '\''/^\0\0/'\'' '\''"..y"'\'''
test-expr '/^\0\0/' '"..y"' 2>&1 ||
echo 'command failed: test-expr '\''/^\0\0/'\'' '\''"..y"'\'''

echo '$ test-expr '\''#/\0\0/'\'' '\''"..y"'\'''
test-expr '#/\0\0/' '"..y"' 2>&1 ||
echo 'command failed: test-expr '\''#/\0\0/'\'' '\''"..y"'\'''

echo '$ test-expr '\''#/\0\0/'\'' '\''"..y"'\'''
test-expr '#/\0\0/' '"..y"' 2>&1 ||
echo 'command failed: test-expr '\''#/\0\0/'\'' '\''"..y"'\'''

echo '$ test-expr '\''#/^\0\0/'\'' '\''"..y"'\'''
test-expr '#/^\0\0/' '"..y"' 2>&1 ||
echo 'command failed: test-expr '\''#/^\0\0/'\'' '\''"..y"'\'''

echo '$ test-expr '\''#/^\0\0/'\'' '\''"..y"'\'''
test-expr '#/^\0\0/' '"..y"' 2>&1 ||
echo 'command failed: test-expr '\''#/^\0\0/'\'' '\''"..y"'\'''

echo '$ test-expr '\''/\0\0/'\'' '\''"x.."'\'''
test-expr '/\0\0/' '"x.."' 2>&1 ||
echo 'command failed: test-expr '\''/\0\0/'\'' '\''"x.."'\'''

echo '$ test-expr '\''/\0\0/'\'' '\''"x.."'\'''
test-expr '/\0\0/' '"x.."' 2>&1 ||
echo 'command failed: test-expr '\''/\0\0/'\'' '\''"x.."'\'''

echo '$ test-expr '\''/^\0\0/'\'' '\''"x.."'\'''
test-expr '/^\0\0/' '"x.."' 2>&1 ||
echo 'command failed: test-expr '\''/^\0\0/'\'' '\''"x.."'\'''

echo '$ test-expr '\''/^\0\0/'\'' '\''"x.."'\'''
test-expr '/^\0\0/' '"x.."' 2>&1 ||
echo 'command failed: test-expr '\''/^\0\0/'\'' '\''"x.."'\'''

echo '$ test-expr '\''#/\0\0/'\'' '\''"x.."'\'''
test-expr '#/\0\0/' '"x.."' 2>&1 ||
echo 'command failed: test-expr '\''#/\0\0/'\'' '\''"x.."'\'''

echo '$ test-expr '\''#/\0\0/'\'' '\''"x.."'\'''
test-expr '#/\0\0/' '"x.."' 2>&1 ||
echo 'command failed: test-expr '\''#/\0\0/'\'' '\''"x.."'\'''

echo '$ test-expr '\''#/^\0\0/'\'' '\''"x.."'\'''
test-expr '#/^\0\0/' '"x.."' 2>&1 ||
echo 'command failed: test-expr '\''#/^\0\0/'\'' '\''"x.."'\'''

echo '$ test-expr '\''#/^\0\0/'\'' '\''"x.."'\'''
test-expr '#/^\0\0/' '"x.."' 2>&1 ||
echo 'command failed: test-expr '\''#/^\0\0/'\'' '\''"x.."'\'''

echo '$ test-expr '\''/\0\0/'\'' '\''"x..y"'\'''
test-expr '/\0\0/' '"x..y"' 2>&1 ||
echo 'command failed: test-expr '\''/\0\0/'\'' '\''"x..y"'\'''

echo '$ test-expr '\''/\0\0/'\'' '\''"x..y"'\'''
test-expr '/\0\0/' '"x..y"' 2>&1 ||
echo 'command failed: test-expr '\''/\0\0/'\'' '\''"x..y"'\'''

echo '$ test-expr '\''/^\0\0/'\'' '\''"x..y"'\'''
test-expr '/^\0\0/' '"x..y"' 2>&1 ||
echo 'command failed: test-expr '\''/^\0\0/'\'' '\''"x..y"'\'''

echo '$ test-expr '\''/^\0\0/'\'' '\''"x..y"'\'''
test-expr '/^\0\0/' '"x..y"' 2>&1 ||
echo 'command failed: test-expr '\''/^\0\0/'\'' '\''"x..y"'\'''

echo '$ test-expr '\''#/\0\0/'\'' '\''"x..y"'\'''
test-expr '#/\0\0/' '"x..y"' 2>&1 ||
echo 'command failed: test-expr '\''#/\0\0/'\'' '\''"x..y"'\'''

echo '$ test-expr '\''#/\0\0/'\'' '\''"x..y"'\'''
test-expr '#/\0\0/' '"x..y"' 2>&1 ||
echo 'command failed: test-expr '\''#/\0\0/'\'' '\''"x..y"'\'''

echo '$ test-expr '\''#/^\0\0/'\'' '\''"x..y"'\'''
test-expr '#/^\0\0/' '"x..y"' 2>&1 ||
echo 'command failed: test-expr '\''#/^\0\0/'\'' '\''"x..y"'\'''

echo '$ test-expr '\''#/^\0\0/'\'' '\''"x..y"'\'''
test-expr '#/^\0\0/' '"x..y"' 2>&1 ||
echo 'command failed: test-expr '\''#/^\0\0/'\'' '\''"x..y"'\'''

echo '$ test-expr '\''/\0\0/'\'' '\''"....."'\'''
test-expr '/\0\0/' '"....."' 2>&1 ||
echo 'command failed: test-expr '\''/\0\0/'\'' '\''"....."'\'''

echo '$ test-expr '\''/\0\0/'\'' '\''"....."'\'''
test-expr '/\0\0/' '"....."' 2>&1 ||
echo 'command failed: test-expr '\''/\0\0/'\'' '\''"....."'\'''

echo '$ test-expr '\''/^\0\0/'\'' '\''"....."'\'''
test-expr '/^\0\0/' '"....."' 2>&1 ||
echo 'command failed: test-expr '\''/^\0\0/'\'' '\''"....."'\'''

echo '$ test-expr '\''/^\0\0/'\'' '\''"....."'\'''
test-expr '/^\0\0/' '"....."' 2>&1 ||
echo 'command failed: test-expr '\''/^\0\0/'\'' '\''"....."'\'''

echo '$ test-expr '\''#/\0\0/'\'' '\''"....."'\'''
test-expr '#/\0\0/' '"....."' 2>&1 ||
echo 'command failed: test-expr '\''#/\0\0/'\'' '\''"....."'\'''

echo '$ test-expr '\''#/\0\0/'\'' '\''"....."'\'''
test-expr '#/\0\0/' '"....."' 2>&1 ||
echo 'command failed: test-expr '\''#/\0\0/'\'' '\''"....."'\'''

echo '$ test-expr '\''#/^\0\0/'\'' '\''"....."'\'''
test-expr '#/^\0\0/' '"....."' 2>&1 ||
echo 'command failed: test-expr '\''#/^\0\0/'\'' '\''"....."'\'''

echo '$ test-expr '\''#/^\0\0/'\'' '\''"....."'\'''
test-expr '#/^\0\0/' '"....."' 2>&1 ||
echo 'command failed: test-expr '\''#/^\0\0/'\'' '\''"....."'\'''

echo '$ test-expr '\''/\0\0/'\'' '\''".....y"'\'''
test-expr '/\0\0/' '".....y"' 2>&1 ||
echo 'command failed: test-expr '\''/\0\0/'\'' '\''".....y"'\'''

echo '$ test-expr '\''/\0\0/'\'' '\''".....y"'\'''
test-expr '/\0\0/' '".....y"' 2>&1 ||
echo 'command failed: test-expr '\''/\0\0/'\'' '\''".....y"'\'''

echo '$ test-expr '\''/^\0\0/'\'' '\''".....y"'\'''
test-expr '/^\0\0/' '".....y"' 2>&1 ||
echo 'command failed: test-expr '\''/^\0\0/'\'' '\''".....y"'\'''

echo '$ test-expr '\''/^\0\0/'\'' '\''".....y"'\'''
test-expr '/^\0\0/' '".....y"' 2>&1 ||
echo 'command failed: test-expr '\''/^\0\0/'\'' '\''".....y"'\'''

echo '$ test-expr '\''#/\0\0/'\'' '\''".....y"'\'''
test-expr '#/\0\0/' '".....y"' 2>&1 ||
echo 'command failed: test-expr '\''#/\0\0/'\'' '\''".....y"'\'''

echo '$ test-expr '\''#/\0\0/'\'' '\''".....y"'\'''
test-expr '#/\0\0/' '".....y"' 2>&1 ||
echo 'command failed: test-expr '\''#/\0\0/'\'' '\''".....y"'\'''

echo '$ test-expr '\''#/^\0\0/'\'' '\''".....y"'\'''
test-expr '#/^\0\0/' '".....y"' 2>&1 ||
echo 'command failed: test-expr '\''#/^\0\0/'\'' '\''".....y"'\'''

echo '$ test-expr '\''#/^\0\0/'\'' '\''".....y"'\'''
test-expr '#/^\0\0/' '".....y"' 2>&1 ||
echo 'command failed: test-expr '\''#/^\0\0/'\'' '\''".....y"'\'''

echo '$ test-expr '\''/\0\0/'\'' '\''"x....."'\'''
test-expr '/\0\0/' '"x....."' 2>&1 ||
echo 'command failed: test-expr '\''/\0\0/'\'' '\''"x....."'\'''

echo '$ test-expr '\''/\0\0/'\'' '\''"x....."'\'''
test-expr '/\0\0/' '"x....."' 2>&1 ||
echo 'command failed: test-expr '\''/\0\0/'\'' '\''"x....."'\'''

echo '$ test-expr '\''/^\0\0/'\'' '\''"x....."'\'''
test-expr '/^\0\0/' '"x....."' 2>&1 ||
echo 'command failed: test-expr '\''/^\0\0/'\'' '\''"x....."'\'''

echo '$ test-expr '\''/^\0\0/'\'' '\''"x....."'\'''
test-expr '/^\0\0/' '"x....."' 2>&1 ||
echo 'command failed: test-expr '\''/^\0\0/'\'' '\''"x....."'\'''

echo '$ test-expr '\''#/\0\0/'\'' '\''"x....."'\'''
test-expr '#/\0\0/' '"x....."' 2>&1 ||
echo 'command failed: test-expr '\''#/\0\0/'\'' '\''"x....."'\'''

echo '$ test-expr '\''#/\0\0/'\'' '\''"x....."'\'''
test-expr '#/\0\0/' '"x....."' 2>&1 ||
echo 'command failed: test-expr '\''#/\0\0/'\'' '\''"x....."'\'''

echo '$ test-expr '\''#/^\0\0/'\'' '\''"x....."'\'''
test-expr '#/^\0\0/' '"x....."' 2>&1 ||
echo 'command failed: test-expr '\''#/^\0\0/'\'' '\''"x....."'\'''

echo '$ test-expr '\''#/^\0\0/'\'' '\''"x....."'\'''
test-expr '#/^\0\0/' '"x....."' 2>&1 ||
echo 'command failed: test-expr '\''#/^\0\0/'\'' '\''"x....."'\'''

echo '$ test-expr '\''/\0\0/'\'' '\''"x.....y"'\'''
test-expr '/\0\0/' '"x.....y"' 2>&1 ||
echo 'command failed: test-expr '\''/\0\0/'\'' '\''"x.....y"'\'''

echo '$ test-expr '\''/\0\0/'\'' '\''"x.....y"'\'''
test-expr '/\0\0/' '"x.....y"' 2>&1 ||
echo 'command failed: test-expr '\''/\0\0/'\'' '\''"x.....y"'\'''

echo '$ test-expr '\''/^\0\0/'\'' '\''"x.....y"'\'''
test-expr '/^\0\0/' '"x.....y"' 2>&1 ||
echo 'command failed: test-expr '\''/^\0\0/'\'' '\''"x.....y"'\'''

echo '$ test-expr '\''/^\0\0/'\'' '\''"x.....y"'\'''
test-expr '/^\0\0/' '"x.....y"' 2>&1 ||
echo 'command failed: test-expr '\''/^\0\0/'\'' '\''"x.....y"'\'''

echo '$ test-expr '\''#/\0\0/'\'' '\''"x.....y"'\'''
test-expr '#/\0\0/' '"x.....y"' 2>&1 ||
echo 'command failed: test-expr '\''#/\0\0/'\'' '\''"x.....y"'\'''

echo '$ test-expr '\''#/\0\0/'\'' '\''"x.....y"'\'''
test-expr '#/\0\0/' '"x.....y"' 2>&1 ||
echo 'command failed: test-expr '\''#/\0\0/'\'' '\''"x.....y"'\'''

echo '$ test-expr '\''#/^\0\0/'\'' '\''"x.....y"'\'''
test-expr '#/^\0\0/' '"x.....y"' 2>&1 ||
echo 'command failed: test-expr '\''#/^\0\0/'\'' '\''"x.....y"'\'''

echo '$ test-expr '\''#/^\0\0/'\'' '\''"x.....y"'\'''
test-expr '#/^\0\0/' '"x.....y"' 2>&1 ||
echo 'command failed: test-expr '\''#/^\0\0/'\'' '\''"x.....y"'\'''

echo '$ test-expr '\''/\0a\0/'\'' '\''".a."'\'''
test-expr '/\0a\0/' '".a."' 2>&1 ||
echo 'command failed: test-expr '\''/\0a\0/'\'' '\''".a."'\'''

echo '$ test-expr '\''/\0a\0/'\'' '\''".a."'\'''
test-expr '/\0a\0/' '".a."' 2>&1 ||
echo 'command failed: test-expr '\''/\0a\0/'\'' '\''".a."'\'''

echo '$ test-expr '\''/^\0a\0/'\'' '\''".a."'\'''
test-expr '/^\0a\0/' '".a."' 2>&1 ||
echo 'command failed: test-expr '\''/^\0a\0/'\'' '\''".a."'\'''

echo '$ test-expr '\''/^\0a\0/'\'' '\''".a."'\'''
test-expr '/^\0a\0/' '".a."' 2>&1 ||
echo 'command failed: test-expr '\''/^\0a\0/'\'' '\''".a."'\'''

echo '$ test-expr '\''#/\0a\0/'\'' '\''".a."'\'''
test-expr '#/\0a\0/' '".a."' 2>&1 ||
echo 'command failed: test-expr '\''#/\0a\0/'\'' '\''".a."'\'''

echo '$ test-expr '\''#/\0a\0/'\'' '\''".a."'\'''
test-expr '#/\0a\0/' '".a."' 2>&1 ||
echo 'command failed: test-expr '\''#/\0a\0/'\'' '\''".a."'\'''

echo '$ test-expr '\''#/^\0a\0/'\'' '\''".a."'\'''
test-expr '#/^\0a\0/' '".a."' 2>&1 ||
echo 'command failed: test-expr '\''#/^\0a\0/'\'' '\''".a."'\'''

echo '$ test-expr '\''#/^\0a\0/'\'' '\''".a."'\'''
test-expr '#/^\0a\0/' '".a."' 2>&1 ||
echo 'command failed: test-expr '\''#/^\0a\0/'\'' '\''".a."'\'''

echo '$ test-expr '\''/\0a\0/'\'' '\''".a.y"'\'''
test-expr '/\0a\0/' '".a.y"' 2>&1 ||
echo 'command failed: test-expr '\''/\0a\0/'\'' '\''".a.y"'\'''

echo '$ test-expr '\''/\0a\0/'\'' '\''".a.y"'\'''
test-expr '/\0a\0/' '".a.y"' 2>&1 ||
echo 'command failed: test-expr '\''/\0a\0/'\'' '\''".a.y"'\'''

echo '$ test-expr '\''/^\0a\0/'\'' '\''".a.y"'\'''
test-expr '/^\0a\0/' '".a.y"' 2>&1 ||
echo 'command failed: test-expr '\''/^\0a\0/'\'' '\''".a.y"'\'''

echo '$ test-expr '\''/^\0a\0/'\'' '\''".a.y"'\'''
test-expr '/^\0a\0/' '".a.y"' 2>&1 ||
echo 'command failed: test-expr '\''/^\0a\0/'\'' '\''".a.y"'\'''

echo '$ test-expr '\''#/\0a\0/'\'' '\''".a.y"'\'''
test-expr '#/\0a\0/' '".a.y"' 2>&1 ||
echo 'command failed: test-expr '\''#/\0a\0/'\'' '\''".a.y"'\'''

echo '$ test-expr '\''#/\0a\0/'\'' '\''".a.y"'\'''
test-expr '#/\0a\0/' '".a.y"' 2>&1 ||
echo 'command failed: test-expr '\''#/\0a\0/'\'' '\''".a.y"'\'''

echo '$ test-expr '\''#/^\0a\0/'\'' '\''".a.y"'\'''
test-expr '#/^\0a\0/' '".a.y"' 2>&1 ||
echo 'command failed: test-expr '\''#/^\0a\0/'\'' '\''".a.y"'\'''

echo '$ test-expr '\''#/^\0a\0/'\'' '\''".a.y"'\'''
test-expr '#/^\0a\0/' '".a.y"' 2>&1 ||
echo 'command failed: test-expr '\''#/^\0a\0/'\'' '\''".a.y"'\'''

echo '$ test-expr '\''/\0a\0/'\'' '\''"x.a."'\'''
test-expr '/\0a\0/' '"x.a."' 2>&1 ||
echo 'command failed: test-expr '\''/\0a\0/'\'' '\''"x.a."'\'''

echo '$ test-expr '\''/\0a\0/'\'' '\''"x.a."'\'''
test-expr '/\0a\0/' '"x.a."' 2>&1 ||
echo 'command failed: test-expr '\''/\0a\0/'\'' '\''"x.a."'\'''

echo '$ test-expr '\''/^\0a\0/'\'' '\''"x.a."'\'''
test-expr '/^\0a\0/' '"x.a."' 2>&1 ||
echo 'command failed: test-expr '\''/^\0a\0/'\'' '\''"x.a."'\'''

echo '$ test-expr '\''/^\0a\0/'\'' '\''"x.a."'\'''
test-expr '/^\0a\0/' '"x.a."' 2>&1 ||
echo 'command failed: test-expr '\''/^\0a\0/'\'' '\''"x.a."'\'''

echo '$ test-expr '\''#/\0a\0/'\'' '\''"x.a."'\'''
test-expr '#/\0a\0/' '"x.a."' 2>&1 ||
echo 'command failed: test-expr '\''#/\0a\0/'\'' '\''"x.a."'\'''

echo '$ test-expr '\''#/\0a\0/'\'' '\''"x.a."'\'''
test-expr '#/\0a\0/' '"x.a."' 2>&1 ||
echo 'command failed: test-expr '\''#/\0a\0/'\'' '\''"x.a."'\'''

echo '$ test-expr '\''#/^\0a\0/'\'' '\''"x.a."'\'''
test-expr '#/^\0a\0/' '"x.a."' 2>&1 ||
echo 'command failed: test-expr '\''#/^\0a\0/'\'' '\''"x.a."'\'''

echo '$ test-expr '\''#/^\0a\0/'\'' '\''"x.a."'\'''
test-expr '#/^\0a\0/' '"x.a."' 2>&1 ||
echo 'command failed: test-expr '\''#/^\0a\0/'\'' '\''"x.a."'\'''

echo '$ test-expr '\''/\0a\0/'\'' '\''"x.a.y"'\'''
test-expr '/\0a\0/' '"x.a.y"' 2>&1 ||
echo 'command failed: test-expr '\''/\0a\0/'\'' '\''"x.a.y"'\'''

echo '$ test-expr '\''/\0a\0/'\'' '\''"x.a.y"'\'''
test-expr '/\0a\0/' '"x.a.y"' 2>&1 ||
echo 'command failed: test-expr '\''/\0a\0/'\'' '\''"x.a.y"'\'''

echo '$ test-expr '\''/^\0a\0/'\'' '\''"x.a.y"'\'''
test-expr '/^\0a\0/' '"x.a.y"' 2>&1 ||
echo 'command failed: test-expr '\''/^\0a\0/'\'' '\''"x.a.y"'\'''

echo '$ test-expr '\''/^\0a\0/'\'' '\''"x.a.y"'\'''
test-expr '/^\0a\0/' '"x.a.y"' 2>&1 ||
echo 'command failed: test-expr '\''/^\0a\0/'\'' '\''"x.a.y"'\'''

echo '$ test-expr '\''#/\0a\0/'\'' '\''"x.a.y"'\'''
test-expr '#/\0a\0/' '"x.a.y"' 2>&1 ||
echo 'command failed: test-expr '\''#/\0a\0/'\'' '\''"x.a.y"'\'''

echo '$ test-expr '\''#/\0a\0/'\'' '\''"x.a.y"'\'''
test-expr '#/\0a\0/' '"x.a.y"' 2>&1 ||
echo 'command failed: test-expr '\''#/\0a\0/'\'' '\''"x.a.y"'\'''

echo '$ test-expr '\''#/^\0a\0/'\'' '\''"x.a.y"'\'''
test-expr '#/^\0a\0/' '"x.a.y"' 2>&1 ||
echo 'command failed: test-expr '\''#/^\0a\0/'\'' '\''"x.a.y"'\'''

echo '$ test-expr '\''#/^\0a\0/'\'' '\''"x.a.y"'\'''
test-expr '#/^\0a\0/' '"x.a.y"' 2>&1 ||
echo 'command failed: test-expr '\''#/^\0a\0/'\'' '\''"x.a.y"'\'''

echo '$ test-expr '\''/\0a\0/'\'' '\''".a...a."'\'''
test-expr '/\0a\0/' '".a...a."' 2>&1 ||
echo 'command failed: test-expr '\''/\0a\0/'\'' '\''".a...a."'\'''

echo '$ test-expr '\''/\0a\0/'\'' '\''".a...a."'\'''
test-expr '/\0a\0/' '".a...a."' 2>&1 ||
echo 'command failed: test-expr '\''/\0a\0/'\'' '\''".a...a."'\'''

echo '$ test-expr '\''/^\0a\0/'\'' '\''".a...a."'\'''
test-expr '/^\0a\0/' '".a...a."' 2>&1 ||
echo 'command failed: test-expr '\''/^\0a\0/'\'' '\''".a...a."'\'''

echo '$ test-expr '\''/^\0a\0/'\'' '\''".a...a."'\'''
test-expr '/^\0a\0/' '".a...a."' 2>&1 ||
echo 'command failed: test-expr '\''/^\0a\0/'\'' '\''".a...a."'\'''

echo '$ test-expr '\''#/\0a\0/'\'' '\''".a...a."'\'''
test-expr '#/\0a\0/' '".a...a."' 2>&1 ||
echo 'command failed: test-expr '\''#/\0a\0/'\'' '\''".a...a."'\'''

echo '$ test-expr '\''#/\0a\0/'\'' '\''".a...a."'\'''
test-expr '#/\0a\0/' '".a...a."' 2>&1 ||
echo 'command failed: test-expr '\''#/\0a\0/'\'' '\''".a...a."'\'''

echo '$ test-expr '\''#/^\0a\0/'\'' '\''".a...a."'\'''
test-expr '#/^\0a\0/' '".a...a."' 2>&1 ||
echo 'command failed: test-expr '\''#/^\0a\0/'\'' '\''".a...a."'\'''

echo '$ test-expr '\''#/^\0a\0/'\'' '\''".a...a."'\'''
test-expr '#/^\0a\0/' '".a...a."' 2>&1 ||
echo 'command failed: test-expr '\''#/^\0a\0/'\'' '\''".a...a."'\'''

echo '$ test-expr '\''/\0a\0/'\'' '\''".a...a.y"'\'''
test-expr '/\0a\0/' '".a...a.y"' 2>&1 ||
echo 'command failed: test-expr '\''/\0a\0/'\'' '\''".a...a.y"'\'''

echo '$ test-expr '\''/\0a\0/'\'' '\''".a...a.y"'\'''
test-expr '/\0a\0/' '".a...a.y"' 2>&1 ||
echo 'command failed: test-expr '\''/\0a\0/'\'' '\''".a...a.y"'\'''

echo '$ test-expr '\''/^\0a\0/'\'' '\''".a...a.y"'\'''
test-expr '/^\0a\0/' '".a...a.y"' 2>&1 ||
echo 'command failed: test-expr '\''/^\0a\0/'\'' '\''".a...a.y"'\'''

echo '$ test-expr '\''/^\0a\0/'\'' '\''".a...a.y"'\'''
test-expr '/^\0a\0/' '".a...a.y"' 2>&1 ||
echo 'command failed: test-expr '\''/^\0a\0/'\'' '\''".a...a.y"'\'''

echo '$ test-expr '\''#/\0a\0/'\'' '\''".a...a.y"'\'''
test-expr '#/\0a\0/' '".a...a.y"' 2>&1 ||
echo 'command failed: test-expr '\''#/\0a\0/'\'' '\''".a...a.y"'\'''

echo '$ test-expr '\''#/\0a\0/'\'' '\''".a...a.y"'\'''
test-expr '#/\0a\0/' '".a...a.y"' 2>&1 ||
echo 'command failed: test-expr '\''#/\0a\0/'\'' '\''".a...a.y"'\'''

echo '$ test-expr '\''#/^\0a\0/'\'' '\''".a...a.y"'\'''
test-expr '#/^\0a\0/' '".a...a.y"' 2>&1 ||
echo 'command failed: test-expr '\''#/^\0a\0/'\'' '\''".a...a.y"'\'''

echo '$ test-expr '\''#/^\0a\0/'\'' '\''".a...a.y"'\'''
test-expr '#/^\0a\0/' '".a...a.y"' 2>&1 ||
echo 'command failed: test-expr '\''#/^\0a\0/'\'' '\''".a...a.y"'\'''

echo '$ test-expr '\''/\0a\0/'\'' '\''"x.a...a."'\'''
test-expr '/\0a\0/' '"x.a...a."' 2>&1 ||
echo 'command failed: test-expr '\''/\0a\0/'\'' '\''"x.a...a."'\'''

echo '$ test-expr '\''/\0a\0/'\'' '\''"x.a...a."'\'''
test-expr '/\0a\0/' '"x.a...a."' 2>&1 ||
echo 'command failed: test-expr '\''/\0a\0/'\'' '\''"x.a...a."'\'''

echo '$ test-expr '\''/^\0a\0/'\'' '\''"x.a...a."'\'''
test-expr '/^\0a\0/' '"x.a...a."' 2>&1 ||
echo 'command failed: test-expr '\''/^\0a\0/'\'' '\''"x.a...a."'\'''

echo '$ test-expr '\''/^\0a\0/'\'' '\''"x.a...a."'\'''
test-expr '/^\0a\0/' '"x.a...a."' 2>&1 ||
echo 'command failed: test-expr '\''/^\0a\0/'\'' '\''"x.a...a."'\'''

echo '$ test-expr '\''#/\0a\0/'\'' '\''"x.a...a."'\'''
test-expr '#/\0a\0/' '"x.a...a."' 2>&1 ||
echo 'command failed: test-expr '\''#/\0a\0/'\'' '\''"x.a...a."'\'''

echo '$ test-expr '\''#/\0a\0/'\'' '\''"x.a...a."'\'''
test-expr '#/\0a\0/' '"x.a...a."' 2>&1 ||
echo 'command failed: test-expr '\''#/\0a\0/'\'' '\''"x.a...a."'\'''

echo '$ test-expr '\''#/^\0a\0/'\'' '\''"x.a...a."'\'''
test-expr '#/^\0a\0/' '"x.a...a."' 2>&1 ||
echo 'command failed: test-expr '\''#/^\0a\0/'\'' '\''"x.a...a."'\'''

echo '$ test-expr '\''#/^\0a\0/'\'' '\''"x.a...a."'\'''
test-expr '#/^\0a\0/' '"x.a...a."' 2>&1 ||
echo 'command failed: test-expr '\''#/^\0a\0/'\'' '\''"x.a...a."'\'''

echo '$ test-expr '\''/\0a\0/'\'' '\''"x.a...a.y"'\'''
test-expr '/\0a\0/' '"x.a...a.y"' 2>&1 ||
echo 'command failed: test-expr '\''/\0a\0/'\'' '\''"x.a...a.y"'\'''

echo '$ test-expr '\''/\0a\0/'\'' '\''"x.a...a.y"'\'''
test-expr '/\0a\0/' '"x.a...a.y"' 2>&1 ||
echo 'command failed: test-expr '\''/\0a\0/'\'' '\''"x.a...a.y"'\'''

echo '$ test-expr '\''/^\0a\0/'\'' '\''"x.a...a.y"'\'''
test-expr '/^\0a\0/' '"x.a...a.y"' 2>&1 ||
echo 'command failed: test-expr '\''/^\0a\0/'\'' '\''"x.a...a.y"'\'''

echo '$ test-expr '\''/^\0a\0/'\'' '\''"x.a...a.y"'\'''
test-expr '/^\0a\0/' '"x.a...a.y"' 2>&1 ||
echo 'command failed: test-expr '\''/^\0a\0/'\'' '\''"x.a...a.y"'\'''

echo '$ test-expr '\''#/\0a\0/'\'' '\''"x.a...a.y"'\'''
test-expr '#/\0a\0/' '"x.a...a.y"' 2>&1 ||
echo 'command failed: test-expr '\''#/\0a\0/'\'' '\''"x.a...a.y"'\'''

echo '$ test-expr '\''#/\0a\0/'\'' '\''"x.a...a.y"'\'''
test-expr '#/\0a\0/' '"x.a...a.y"' 2>&1 ||
echo 'command failed: test-expr '\''#/\0a\0/'\'' '\''"x.a...a.y"'\'''

echo '$ test-expr '\''#/^\0a\0/'\'' '\''"x.a...a.y"'\'''
test-expr '#/^\0a\0/' '"x.a...a.y"' 2>&1 ||
echo 'command failed: test-expr '\''#/^\0a\0/'\'' '\''"x.a...a.y"'\'''

echo '$ test-expr '\''#/^\0a\0/'\'' '\''"x.a...a.y"'\'''
test-expr '#/^\0a\0/' '"x.a...a.y"' 2>&1 ||
echo 'command failed: test-expr '\''#/^\0a\0/'\'' '\''"x.a...a.y"'\'''

echo '$ test-expr '\''/a\0b/'\'' '\''"a.b"'\'''
test-expr '/a\0b/' '"a.b"' 2>&1 ||
echo 'command failed: test-expr '\''/a\0b/'\'' '\''"a.b"'\'''

echo '$ test-expr '\''/a\0b/'\'' '\''"a.b"'\'''
test-expr '/a\0b/' '"a.b"' 2>&1 ||
echo 'command failed: test-expr '\''/a\0b/'\'' '\''"a.b"'\'''

echo '$ test-expr '\''/^a\0b/'\'' '\''"a.b"'\'''
test-expr '/^a\0b/' '"a.b"' 2>&1 ||
echo 'command failed: test-expr '\''/^a\0b/'\'' '\''"a.b"'\'''

echo '$ test-expr '\''/^a\0b/'\'' '\''"a.b"'\'''
test-expr '/^a\0b/' '"a.b"' 2>&1 ||
echo 'command failed: test-expr '\''/^a\0b/'\'' '\''"a.b"'\'''

echo '$ test-expr '\''#/a\0b/'\'' '\''"a.b"'\'''
test-expr '#/a\0b/' '"a.b"' 2>&1 ||
echo 'command failed: test-expr '\''#/a\0b/'\'' '\''"a.b"'\'''

echo '$ test-expr '\''#/a\0b/'\'' '\''"a.b"'\'''
test-expr '#/a\0b/' '"a.b"' 2>&1 ||
echo 'command failed: test-expr '\''#/a\0b/'\'' '\''"a.b"'\'''

echo '$ test-expr '\''#/^a\0b/'\'' '\''"a.b"'\'''
test-expr '#/^a\0b/' '"a.b"' 2>&1 ||
echo 'command failed: test-expr '\''#/^a\0b/'\'' '\''"a.b"'\'''

echo '$ test-expr '\''#/^a\0b/'\'' '\''"a.b"'\'''
test-expr '#/^a\0b/' '"a.b"' 2>&1 ||
echo 'command failed: test-expr '\''#/^a\0b/'\'' '\''"a.b"'\'''

echo '$ test-expr '\''/a\0b/'\'' '\''"a.by"'\'''
test-expr '/a\0b/' '"a.by"' 2>&1 ||
echo 'command failed: test-expr '\''/a\0b/'\'' '\''"a.by"'\'''

echo '$ test-expr '\''/a\0b/'\'' '\''"a.by"'\'''
test-expr '/a\0b/' '"a.by"' 2>&1 ||
echo 'command failed: test-expr '\''/a\0b/'\'' '\''"a.by"'\'''

echo '$ test-expr '\''/^a\0b/'\'' '\''"a.by"'\'''
test-expr '/^a\0b/' '"a.by"' 2>&1 ||
echo 'command failed: test-expr '\''/^a\0b/'\'' '\''"a.by"'\'''

echo '$ test-expr '\''/^a\0b/'\'' '\''"a.by"'\'''
test-expr '/^a\0b/' '"a.by"' 2>&1 ||
echo 'command failed: test-expr '\''/^a\0b/'\'' '\''"a.by"'\'''

echo '$ test-expr '\''#/a\0b/'\'' '\''"a.by"'\'''
test-expr '#/a\0b/' '"a.by"' 2>&1 ||
echo 'command failed: test-expr '\''#/a\0b/'\'' '\''"a.by"'\'''

echo '$ test-expr '\''#/a\0b/'\'' '\''"a.by"'\'''
test-expr '#/a\0b/' '"a.by"' 2>&1 ||
echo 'command failed: test-expr '\''#/a\0b/'\'' '\''"a.by"'\'''

echo '$ test-expr '\''#/^a\0b/'\'' '\''"a.by"'\'''
test-expr '#/^a\0b/' '"a.by"' 2>&1 ||
echo 'command failed: test-expr '\''#/^a\0b/'\'' '\''"a.by"'\'''

echo '$ test-expr '\''#/^a\0b/'\'' '\''"a.by"'\'''
test-expr '#/^a\0b/' '"a.by"' 2>&1 ||
echo 'command failed: test-expr '\''#/^a\0b/'\'' '\''"a.by"'\'''

echo '$ test-expr '\''/a\0b/'\'' '\''"xa.b"'\'''
test-expr '/a\0b/' '"xa.b"' 2>&1 ||
echo 'command failed: test-expr '\''/a\0b/'\'' '\''"xa.b"'\'''

echo '$ test-expr '\''/a\0b/'\'' '\''"xa.b"'\'''
test-expr '/a\0b/' '"xa.b"' 2>&1 ||
echo 'command failed: test-expr '\''/a\0b/'\'' '\''"xa.b"'\'''

echo '$ test-expr '\''/^a\0b/'\'' '\''"xa.b"'\'''
test-expr '/^a\0b/' '"xa.b"' 2>&1 ||
echo 'command failed: test-expr '\''/^a\0b/'\'' '\''"xa.b"'\'''

echo '$ test-expr '\''/^a\0b/'\'' '\''"xa.b"'\'''
test-expr '/^a\0b/' '"xa.b"' 2>&1 ||
echo 'command failed: test-expr '\''/^a\0b/'\'' '\''"xa.b"'\'''

echo '$ test-expr '\''#/a\0b/'\'' '\''"xa.b"'\'''
test-expr '#/a\0b/' '"xa.b"' 2>&1 ||
echo 'command failed: test-expr '\''#/a\0b/'\'' '\''"xa.b"'\'''

echo '$ test-expr '\''#/a\0b/'\'' '\''"xa.b"'\'''
test-expr '#/a\0b/' '"xa.b"' 2>&1 ||
echo 'command failed: test-expr '\''#/a\0b/'\'' '\''"xa.b"'\'''

echo '$ test-expr '\''#/^a\0b/'\'' '\''"xa.b"'\'''
test-expr '#/^a\0b/' '"xa.b"' 2>&1 ||
echo 'command failed: test-expr '\''#/^a\0b/'\'' '\''"xa.b"'\'''

echo '$ test-expr '\''#/^a\0b/'\'' '\''"xa.b"'\'''
test-expr '#/^a\0b/' '"xa.b"' 2>&1 ||
echo 'command failed: test-expr '\''#/^a\0b/'\'' '\''"xa.b"'\'''

echo '$ test-expr '\''/a\0b/'\'' '\''"xa.by"'\'''
test-expr '/a\0b/' '"xa.by"' 2>&1 ||
echo 'command failed: test-expr '\''/a\0b/'\'' '\''"xa.by"'\'''

echo '$ test-expr '\''/a\0b/'\'' '\''"xa.by"'\'''
test-expr '/a\0b/' '"xa.by"' 2>&1 ||
echo 'command failed: test-expr '\''/a\0b/'\'' '\''"xa.by"'\'''

echo '$ test-expr '\''/^a\0b/'\'' '\''"xa.by"'\'''
test-expr '/^a\0b/' '"xa.by"' 2>&1 ||
echo 'command failed: test-expr '\''/^a\0b/'\'' '\''"xa.by"'\'''

echo '$ test-expr '\''/^a\0b/'\'' '\''"xa.by"'\'''
test-expr '/^a\0b/' '"xa.by"' 2>&1 ||
echo 'command failed: test-expr '\''/^a\0b/'\'' '\''"xa.by"'\'''

echo '$ test-expr '\''#/a\0b/'\'' '\''"xa.by"'\'''
test-expr '#/a\0b/' '"xa.by"' 2>&1 ||
echo 'command failed: test-expr '\''#/a\0b/'\'' '\''"xa.by"'\'''

echo '$ test-expr '\''#/a\0b/'\'' '\''"xa.by"'\'''
test-expr '#/a\0b/' '"xa.by"' 2>&1 ||
echo 'command failed: test-expr '\''#/a\0b/'\'' '\''"xa.by"'\'''

echo '$ test-expr '\''#/^a\0b/'\'' '\''"xa.by"'\'''
test-expr '#/^a\0b/' '"xa.by"' 2>&1 ||
echo 'command failed: test-expr '\''#/^a\0b/'\'' '\''"xa.by"'\'''

echo '$ test-expr '\''#/^a\0b/'\'' '\''"xa.by"'\'''
test-expr '#/^a\0b/' '"xa.by"' 2>&1 ||
echo 'command failed: test-expr '\''#/^a\0b/'\'' '\''"xa.by"'\'''

echo '$ test-expr '\''/a\0b/'\'' '\''"a.b.a.b"'\'''
test-expr '/a\0b/' '"a.b.a.b"' 2>&1 ||
echo 'command failed: test-expr '\''/a\0b/'\'' '\''"a.b.a.b"'\'''

echo '$ test-expr '\''/a\0b/'\'' '\''"a.b.a.b"'\'''
test-expr '/a\0b/' '"a.b.a.b"' 2>&1 ||
echo 'command failed: test-expr '\''/a\0b/'\'' '\''"a.b.a.b"'\'''

echo '$ test-expr '\''/^a\0b/'\'' '\''"a.b.a.b"'\'''
test-expr '/^a\0b/' '"a.b.a.b"' 2>&1 ||
echo 'command failed: test-expr '\''/^a\0b/'\'' '\''"a.b.a.b"'\'''

echo '$ test-expr '\''/^a\0b/'\'' '\''"a.b.a.b"'\'''
test-expr '/^a\0b/' '"a.b.a.b"' 2>&1 ||
echo 'command failed: test-expr '\''/^a\0b/'\'' '\''"a.b.a.b"'\'''

echo '$ test-expr '\''#/a\0b/'\'' '\''"a.b.a.b"'\'''
test-expr '#/a\0b/' '"a.b.a.b"' 2>&1 ||
echo 'command failed: test-expr '\''#/a\0b/'\'' '\''"a.b.a.b"'\'''

echo '$ test-expr '\''#/a\0b/'\'' '\''"a.b.a.b"'\'''
test-expr '#/a\0b/' '"a.b.a.b"' 2>&1 ||
echo 'command failed: test-expr '\''#/a\0b/'\'' '\''"a.b.a.b"'\'''

echo '$ test-expr '\''#/^a\0b/'\'' '\''"a.b.a.b"'\'''
test-expr '#/^a\0b/' '"a.b.a.b"' 2>&1 ||
echo 'command failed: test-expr '\''#/^a\0b/'\'' '\''"a.b.a.b"'\'''

echo '$ test-expr '\''#/^a\0b/'\'' '\''"a.b.a.b"'\'''
test-expr '#/^a\0b/' '"a.b.a.b"' 2>&1 ||
echo 'command failed: test-expr '\''#/^a\0b/'\'' '\''"a.b.a.b"'\'''

echo '$ test-expr '\''/a\0b/'\'' '\''"a.b.a.by"'\'''
test-expr '/a\0b/' '"a.b.a.by"' 2>&1 ||
echo 'command failed: test-expr '\''/a\0b/'\'' '\''"a.b.a.by"'\'''

echo '$ test-expr '\''/a\0b/'\'' '\''"a.b.a.by"'\'''
test-expr '/a\0b/' '"a.b.a.by"' 2>&1 ||
echo 'command failed: test-expr '\''/a\0b/'\'' '\''"a.b.a.by"'\'''

echo '$ test-expr '\''/^a\0b/'\'' '\''"a.b.a.by"'\'''
test-expr '/^a\0b/' '"a.b.a.by"' 2>&1 ||
echo 'command failed: test-expr '\''/^a\0b/'\'' '\''"a.b.a.by"'\'''

echo '$ test-expr '\''/^a\0b/'\'' '\''"a.b.a.by"'\'''
test-expr '/^a\0b/' '"a.b.a.by"' 2>&1 ||
echo 'command failed: test-expr '\''/^a\0b/'\'' '\''"a.b.a.by"'\'''

echo '$ test-expr '\''#/a\0b/'\'' '\''"a.b.a.by"'\'''
test-expr '#/a\0b/' '"a.b.a.by"' 2>&1 ||
echo 'command failed: test-expr '\''#/a\0b/'\'' '\''"a.b.a.by"'\'''

echo '$ test-expr '\''#/a\0b/'\'' '\''"a.b.a.by"'\'''
test-expr '#/a\0b/' '"a.b.a.by"' 2>&1 ||
echo 'command failed: test-expr '\''#/a\0b/'\'' '\''"a.b.a.by"'\'''

echo '$ test-expr '\''#/^a\0b/'\'' '\''"a.b.a.by"'\'''
test-expr '#/^a\0b/' '"a.b.a.by"' 2>&1 ||
echo 'command failed: test-expr '\''#/^a\0b/'\'' '\''"a.b.a.by"'\'''

echo '$ test-expr '\''#/^a\0b/'\'' '\''"a.b.a.by"'\'''
test-expr '#/^a\0b/' '"a.b.a.by"' 2>&1 ||
echo 'command failed: test-expr '\''#/^a\0b/'\'' '\''"a.b.a.by"'\'''

echo '$ test-expr '\''/a\0b/'\'' '\''"xa.b.a.b"'\'''
test-expr '/a\0b/' '"xa.b.a.b"' 2>&1 ||
echo 'command failed: test-expr '\''/a\0b/'\'' '\''"xa.b.a.b"'\'''

echo '$ test-expr '\''/a\0b/'\'' '\''"xa.b.a.b"'\'''
test-expr '/a\0b/' '"xa.b.a.b"' 2>&1 ||
echo 'command failed: test-expr '\''/a\0b/'\'' '\''"xa.b.a.b"'\'''

echo '$ test-expr '\''/^a\0b/'\'' '\''"xa.b.a.b"'\'''
test-expr '/^a\0b/' '"xa.b.a.b"' 2>&1 ||
echo 'command failed: test-expr '\''/^a\0b/'\'' '\''"xa.b.a.b"'\'''

echo '$ test-expr '\''/^a\0b/'\'' '\''"xa.b.a.b"'\'''
test-expr '/^a\0b/' '"xa.b.a.b"' 2>&1 ||
echo 'command failed: test-expr '\''/^a\0b/'\'' '\''"xa.b.a.b"'\'''

echo '$ test-expr '\''#/a\0b/'\'' '\''"xa.b.a.b"'\'''
test-expr '#/a\0b/' '"xa.b.a.b"' 2>&1 ||
echo 'command failed: test-expr '\''#/a\0b/'\'' '\''"xa.b.a.b"'\'''

echo '$ test-expr '\''#/a\0b/'\'' '\''"xa.b.a.b"'\'''
test-expr '#/a\0b/' '"xa.b.a.b"' 2>&1 ||
echo 'command failed: test-expr '\''#/a\0b/'\'' '\''"xa.b.a.b"'\'''

echo '$ test-expr '\''#/^a\0b/'\'' '\''"xa.b.a.b"'\'''
test-expr '#/^a\0b/' '"xa.b.a.b"' 2>&1 ||
echo 'command failed: test-expr '\''#/^a\0b/'\'' '\''"xa.b.a.b"'\'''

echo '$ test-expr '\''#/^a\0b/'\'' '\''"xa.b.a.b"'\'''
test-expr '#/^a\0b/' '"xa.b.a.b"' 2>&1 ||
echo 'command failed: test-expr '\''#/^a\0b/'\'' '\''"xa.b.a.b"'\'''

echo '$ test-expr '\''/a\0b/'\'' '\''"xa.b.a.by"'\'''
test-expr '/a\0b/' '"xa.b.a.by"' 2>&1 ||
echo 'command failed: test-expr '\''/a\0b/'\'' '\''"xa.b.a.by"'\'''

echo '$ test-expr '\''/a\0b/'\'' '\''"xa.b.a.by"'\'''
test-expr '/a\0b/' '"xa.b.a.by"' 2>&1 ||
echo 'command failed: test-expr '\''/a\0b/'\'' '\''"xa.b.a.by"'\'''

echo '$ test-expr '\''/^a\0b/'\'' '\''"xa.b.a.by"'\'''
test-expr '/^a\0b/' '"xa.b.a.by"' 2>&1 ||
echo 'command failed: test-expr '\''/^a\0b/'\'' '\''"xa.b.a.by"'\'''

echo '$ test-expr '\''/^a\0b/'\'' '\''"xa.b.a.by"'\'''
test-expr '/^a\0b/' '"xa.b.a.by"' 2>&1 ||
echo 'command failed: test-expr '\''/^a\0b/'\'' '\''"xa.b.a.by"'\'''

echo '$ test-expr '\''#/a\0b/'\'' '\''"xa.b.a.by"'\'''
test-expr '#/a\0b/' '"xa.b.a.by"' 2>&1 ||
echo 'command failed: test-expr '\''#/a\0b/'\'' '\''"xa.b.a.by"'\'''

echo '$ test-expr '\''#/a\0b/'\'' '\''"xa.b.a.by"'\'''
test-expr '#/a\0b/' '"xa.b.a.by"' 2>&1 ||
echo 'command failed: test-expr '\''#/a\0b/'\'' '\''"xa.b.a.by"'\'''

echo '$ test-expr '\''#/^a\0b/'\'' '\''"xa.b.a.by"'\'''
test-expr '#/^a\0b/' '"xa.b.a.by"' 2>&1 ||
echo 'command failed: test-expr '\''#/^a\0b/'\'' '\''"xa.b.a.by"'\'''

echo '$ test-expr '\''#/^a\0b/'\'' '\''"xa.b.a.by"'\'''
test-expr '#/^a\0b/' '"xa.b.a.by"' 2>&1 ||
echo 'command failed: test-expr '\''#/^a\0b/'\'' '\''"xa.b.a.by"'\'''

echo '$ test-expr '\''/a\0b\0c/'\'' '\''"a.b.c"'\'''
test-expr '/a\0b\0c/' '"a.b.c"' 2>&1 ||
echo 'command failed: test-expr '\''/a\0b\0c/'\'' '\''"a.b.c"'\'''

echo '$ test-expr '\''/a\0b\0c/'\'' '\''"a.b.c"'\'''
test-expr '/a\0b\0c/' '"a.b.c"' 2>&1 ||
echo 'command failed: test-expr '\''/a\0b\0c/'\'' '\''"a.b.c"'\'''

echo '$ test-expr '\''/^a\0b\0c/'\'' '\''"a.b.c"'\'''
test-expr '/^a\0b\0c/' '"a.b.c"' 2>&1 ||
echo 'command failed: test-expr '\''/^a\0b\0c/'\'' '\''"a.b.c"'\'''

echo '$ test-expr '\''/^a\0b\0c/'\'' '\''"a.b.c"'\'''
test-expr '/^a\0b\0c/' '"a.b.c"' 2>&1 ||
echo 'command failed: test-expr '\''/^a\0b\0c/'\'' '\''"a.b.c"'\'''

echo '$ test-expr '\''#/a\0b\0c/'\'' '\''"a.b.c"'\'''
test-expr '#/a\0b\0c/' '"a.b.c"' 2>&1 ||
echo 'command failed: test-expr '\''#/a\0b\0c/'\'' '\''"a.b.c"'\'''

echo '$ test-expr '\''#/a\0b\0c/'\'' '\''"a.b.c"'\'''
test-expr '#/a\0b\0c/' '"a.b.c"' 2>&1 ||
echo 'command failed: test-expr '\''#/a\0b\0c/'\'' '\''"a.b.c"'\'''

echo '$ test-expr '\''#/^a\0b\0c/'\'' '\''"a.b.c"'\'''
test-expr '#/^a\0b\0c/' '"a.b.c"' 2>&1 ||
echo 'command failed: test-expr '\''#/^a\0b\0c/'\'' '\''"a.b.c"'\'''

echo '$ test-expr '\''#/^a\0b\0c/'\'' '\''"a.b.c"'\'''
test-expr '#/^a\0b\0c/' '"a.b.c"' 2>&1 ||
echo 'command failed: test-expr '\''#/^a\0b\0c/'\'' '\''"a.b.c"'\'''

echo '$ test-expr '\''/a\0b\0c/'\'' '\''"a.b.cy"'\'''
test-expr '/a\0b\0c/' '"a.b.cy"' 2>&1 ||
echo 'command failed: test-expr '\''/a\0b\0c/'\'' '\''"a.b.cy"'\'''

echo '$ test-expr '\''/a\0b\0c/'\'' '\''"a.b.cy"'\'''
test-expr '/a\0b\0c/' '"a.b.cy"' 2>&1 ||
echo 'command failed: test-expr '\''/a\0b\0c/'\'' '\''"a.b.cy"'\'''

echo '$ test-expr '\''/^a\0b\0c/'\'' '\''"a.b.cy"'\'''
test-expr '/^a\0b\0c/' '"a.b.cy"' 2>&1 ||
echo 'command failed: test-expr '\''/^a\0b\0c/'\'' '\''"a.b.cy"'\'''

echo '$ test-expr '\''/^a\0b\0c/'\'' '\''"a.b.cy"'\'''
test-expr '/^a\0b\0c/' '"a.b.cy"' 2>&1 ||
echo 'command failed: test-expr '\''/^a\0b\0c/'\'' '\''"a.b.cy"'\'''

echo '$ test-expr '\''#/a\0b\0c/'\'' '\''"a.b.cy"'\'''
test-expr '#/a\0b\0c/' '"a.b.cy"' 2>&1 ||
echo 'command failed: test-expr '\''#/a\0b\0c/'\'' '\''"a.b.cy"'\'''

echo '$ test-expr '\''#/a\0b\0c/'\'' '\''"a.b.cy"'\'''
test-expr '#/a\0b\0c/' '"a.b.cy"' 2>&1 ||
echo 'command failed: test-expr '\''#/a\0b\0c/'\'' '\''"a.b.cy"'\'''

echo '$ test-expr '\''#/^a\0b\0c/'\'' '\''"a.b.cy"'\'''
test-expr '#/^a\0b\0c/' '"a.b.cy"' 2>&1 ||
echo 'command failed: test-expr '\''#/^a\0b\0c/'\'' '\''"a.b.cy"'\'''

echo '$ test-expr '\''#/^a\0b\0c/'\'' '\''"a.b.cy"'\'''
test-expr '#/^a\0b\0c/' '"a.b.cy"' 2>&1 ||
echo 'command failed: test-expr '\''#/^a\0b\0c/'\'' '\''"a.b.cy"'\'''

echo '$ test-expr '\''/a\0b\0c/'\'' '\''"xa.b.c"'\'''
test-expr '/a\0b\0c/' '"xa.b.c"' 2>&1 ||
echo 'command failed: test-expr '\''/a\0b\0c/'\'' '\''"xa.b.c"'\'''

echo '$ test-expr '\''/a\0b\0c/'\'' '\''"xa.b.c"'\'''
test-expr '/a\0b\0c/' '"xa.b.c"' 2>&1 ||
echo 'command failed: test-expr '\''/a\0b\0c/'\'' '\''"xa.b.c"'\'''

echo '$ test-expr '\''/^a\0b\0c/'\'' '\''"xa.b.c"'\'''
test-expr '/^a\0b\0c/' '"xa.b.c"' 2>&1 ||
echo 'command failed: test-expr '\''/^a\0b\0c/'\'' '\''"xa.b.c"'\'''

echo '$ test-expr '\''/^a\0b\0c/'\'' '\''"xa.b.c"'\'''
test-expr '/^a\0b\0c/' '"xa.b.c"' 2>&1 ||
echo 'command failed: test-expr '\''/^a\0b\0c/'\'' '\''"xa.b.c"'\'''

echo '$ test-expr '\''#/a\0b\0c/'\'' '\''"xa.b.c"'\'''
test-expr '#/a\0b\0c/' '"xa.b.c"' 2>&1 ||
echo 'command failed: test-expr '\''#/a\0b\0c/'\'' '\''"xa.b.c"'\'''

echo '$ test-expr '\''#/a\0b\0c/'\'' '\''"xa.b.c"'\'''
test-expr '#/a\0b\0c/' '"xa.b.c"' 2>&1 ||
echo 'command failed: test-expr '\''#/a\0b\0c/'\'' '\''"xa.b.c"'\'''

echo '$ test-expr '\''#/^a\0b\0c/'\'' '\''"xa.b.c"'\'''
test-expr '#/^a\0b\0c/' '"xa.b.c"' 2>&1 ||
echo 'command failed: test-expr '\''#/^a\0b\0c/'\'' '\''"xa.b.c"'\'''

echo '$ test-expr '\''#/^a\0b\0c/'\'' '\''"xa.b.c"'\'''
test-expr '#/^a\0b\0c/' '"xa.b.c"' 2>&1 ||
echo 'command failed: test-expr '\''#/^a\0b\0c/'\'' '\''"xa.b.c"'\'''

echo '$ test-expr '\''/a\0b\0c/'\'' '\''"xa.b.cy"'\'''
test-expr '/a\0b\0c/' '"xa.b.cy"' 2>&1 ||
echo 'command failed: test-expr '\''/a\0b\0c/'\'' '\''"xa.b.cy"'\'''

echo '$ test-expr '\''/a\0b\0c/'\'' '\''"xa.b.cy"'\'''
test-expr '/a\0b\0c/' '"xa.b.cy"' 2>&1 ||
echo 'command failed: test-expr '\''/a\0b\0c/'\'' '\''"xa.b.cy"'\'''

echo '$ test-expr '\''/^a\0b\0c/'\'' '\''"xa.b.cy"'\'''
test-expr '/^a\0b\0c/' '"xa.b.cy"' 2>&1 ||
echo 'command failed: test-expr '\''/^a\0b\0c/'\'' '\''"xa.b.cy"'\'''

echo '$ test-expr '\''/^a\0b\0c/'\'' '\''"xa.b.cy"'\'''
test-expr '/^a\0b\0c/' '"xa.b.cy"' 2>&1 ||
echo 'command failed: test-expr '\''/^a\0b\0c/'\'' '\''"xa.b.cy"'\'''

echo '$ test-expr '\''#/a\0b\0c/'\'' '\''"xa.b.cy"'\'''
test-expr '#/a\0b\0c/' '"xa.b.cy"' 2>&1 ||
echo 'command failed: test-expr '\''#/a\0b\0c/'\'' '\''"xa.b.cy"'\'''

echo '$ test-expr '\''#/a\0b\0c/'\'' '\''"xa.b.cy"'\'''
test-expr '#/a\0b\0c/' '"xa.b.cy"' 2>&1 ||
echo 'command failed: test-expr '\''#/a\0b\0c/'\'' '\''"xa.b.cy"'\'''

echo '$ test-expr '\''#/^a\0b\0c/'\'' '\''"xa.b.cy"'\'''
test-expr '#/^a\0b\0c/' '"xa.b.cy"' 2>&1 ||
echo 'command failed: test-expr '\''#/^a\0b\0c/'\'' '\''"xa.b.cy"'\'''

echo '$ test-expr '\''#/^a\0b\0c/'\'' '\''"xa.b.cy"'\'''
test-expr '#/^a\0b\0c/' '"xa.b.cy"' 2>&1 ||
echo 'command failed: test-expr '\''#/^a\0b\0c/'\'' '\''"xa.b.cy"'\'''

echo '$ test-expr '\''/a\0b\0c/'\'' '\''"a.b.c.a.b.c"'\'''
test-expr '/a\0b\0c/' '"a.b.c.a.b.c"' 2>&1 ||
echo 'command failed: test-expr '\''/a\0b\0c/'\'' '\''"a.b.c.a.b.c"'\'''

echo '$ test-expr '\''/a\0b\0c/'\'' '\''"a.b.c.a.b.c"'\'''
test-expr '/a\0b\0c/' '"a.b.c.a.b.c"' 2>&1 ||
echo 'command failed: test-expr '\''/a\0b\0c/'\'' '\''"a.b.c.a.b.c"'\'''

echo '$ test-expr '\''/^a\0b\0c/'\'' '\''"a.b.c.a.b.c"'\'''
test-expr '/^a\0b\0c/' '"a.b.c.a.b.c"' 2>&1 ||
echo 'command failed: test-expr '\''/^a\0b\0c/'\'' '\''"a.b.c.a.b.c"'\'''

echo '$ test-expr '\''/^a\0b\0c/'\'' '\''"a.b.c.a.b.c"'\'''
test-expr '/^a\0b\0c/' '"a.b.c.a.b.c"' 2>&1 ||
echo 'command failed: test-expr '\''/^a\0b\0c/'\'' '\''"a.b.c.a.b.c"'\'''

echo '$ test-expr '\''#/a\0b\0c/'\'' '\''"a.b.c.a.b.c"'\'''
test-expr '#/a\0b\0c/' '"a.b.c.a.b.c"' 2>&1 ||
echo 'command failed: test-expr '\''#/a\0b\0c/'\'' '\''"a.b.c.a.b.c"'\'''

echo '$ test-expr '\''#/a\0b\0c/'\'' '\''"a.b.c.a.b.c"'\'''
test-expr '#/a\0b\0c/' '"a.b.c.a.b.c"' 2>&1 ||
echo 'command failed: test-expr '\''#/a\0b\0c/'\'' '\''"a.b.c.a.b.c"'\'''

echo '$ test-expr '\''#/^a\0b\0c/'\'' '\''"a.b.c.a.b.c"'\'''
test-expr '#/^a\0b\0c/' '"a.b.c.a.b.c"' 2>&1 ||
echo 'command failed: test-expr '\''#/^a\0b\0c/'\'' '\''"a.b.c.a.b.c"'\'''

echo '$ test-expr '\''#/^a\0b\0c/'\'' '\''"a.b.c.a.b.c"'\'''
test-expr '#/^a\0b\0c/' '"a.b.c.a.b.c"' 2>&1 ||
echo 'command failed: test-expr '\''#/^a\0b\0c/'\'' '\''"a.b.c.a.b.c"'\'''

echo '$ test-expr '\''/a\0b\0c/'\'' '\''"a.b.c.a.b.cy"'\'''
test-expr '/a\0b\0c/' '"a.b.c.a.b.cy"' 2>&1 ||
echo 'command failed: test-expr '\''/a\0b\0c/'\'' '\''"a.b.c.a.b.cy"'\'''

echo '$ test-expr '\''/a\0b\0c/'\'' '\''"a.b.c.a.b.cy"'\'''
test-expr '/a\0b\0c/' '"a.b.c.a.b.cy"' 2>&1 ||
echo 'command failed: test-expr '\''/a\0b\0c/'\'' '\''"a.b.c.a.b.cy"'\'''

echo '$ test-expr '\''/^a\0b\0c/'\'' '\''"a.b.c.a.b.cy"'\'''
test-expr '/^a\0b\0c/' '"a.b.c.a.b.cy"' 2>&1 ||
echo 'command failed: test-expr '\''/^a\0b\0c/'\'' '\''"a.b.c.a.b.cy"'\'''

echo '$ test-expr '\''/^a\0b\0c/'\'' '\''"a.b.c.a.b.cy"'\'''
test-expr '/^a\0b\0c/' '"a.b.c.a.b.cy"' 2>&1 ||
echo 'command failed: test-expr '\''/^a\0b\0c/'\'' '\''"a.b.c.a.b.cy"'\'''

echo '$ test-expr '\''#/a\0b\0c/'\'' '\''"a.b.c.a.b.cy"'\'''
test-expr '#/a\0b\0c/' '"a.b.c.a.b.cy"' 2>&1 ||
echo 'command failed: test-expr '\''#/a\0b\0c/'\'' '\''"a.b.c.a.b.cy"'\'''

echo '$ test-expr '\''#/a\0b\0c/'\'' '\''"a.b.c.a.b.cy"'\'''
test-expr '#/a\0b\0c/' '"a.b.c.a.b.cy"' 2>&1 ||
echo 'command failed: test-expr '\''#/a\0b\0c/'\'' '\''"a.b.c.a.b.cy"'\'''

echo '$ test-expr '\''#/^a\0b\0c/'\'' '\''"a.b.c.a.b.cy"'\'''
test-expr '#/^a\0b\0c/' '"a.b.c.a.b.cy"' 2>&1 ||
echo 'command failed: test-expr '\''#/^a\0b\0c/'\'' '\''"a.b.c.a.b.cy"'\'''

echo '$ test-expr '\''#/^a\0b\0c/'\'' '\''"a.b.c.a.b.cy"'\'''
test-expr '#/^a\0b\0c/' '"a.b.c.a.b.cy"' 2>&1 ||
echo 'command failed: test-expr '\''#/^a\0b\0c/'\'' '\''"a.b.c.a.b.cy"'\'''

echo '$ test-expr '\''/a\0b\0c/'\'' '\''"xa.b.c.a.b.c"'\'''
test-expr '/a\0b\0c/' '"xa.b.c.a.b.c"' 2>&1 ||
echo 'command failed: test-expr '\''/a\0b\0c/'\'' '\''"xa.b.c.a.b.c"'\'''

echo '$ test-expr '\''/a\0b\0c/'\'' '\''"xa.b.c.a.b.c"'\'''
test-expr '/a\0b\0c/' '"xa.b.c.a.b.c"' 2>&1 ||
echo 'command failed: test-expr '\''/a\0b\0c/'\'' '\''"xa.b.c.a.b.c"'\'''

echo '$ test-expr '\''/^a\0b\0c/'\'' '\''"xa.b.c.a.b.c"'\'''
test-expr '/^a\0b\0c/' '"xa.b.c.a.b.c"' 2>&1 ||
echo 'command failed: test-expr '\''/^a\0b\0c/'\'' '\''"xa.b.c.a.b.c"'\'''

echo '$ test-expr '\''/^a\0b\0c/'\'' '\''"xa.b.c.a.b.c"'\'''
test-expr '/^a\0b\0c/' '"xa.b.c.a.b.c"' 2>&1 ||
echo 'command failed: test-expr '\''/^a\0b\0c/'\'' '\''"xa.b.c.a.b.c"'\'''

echo '$ test-expr '\''#/a\0b\0c/'\'' '\''"xa.b.c.a.b.c"'\'''
test-expr '#/a\0b\0c/' '"xa.b.c.a.b.c"' 2>&1 ||
echo 'command failed: test-expr '\''#/a\0b\0c/'\'' '\''"xa.b.c.a.b.c"'\'''

echo '$ test-expr '\''#/a\0b\0c/'\'' '\''"xa.b.c.a.b.c"'\'''
test-expr '#/a\0b\0c/' '"xa.b.c.a.b.c"' 2>&1 ||
echo 'command failed: test-expr '\''#/a\0b\0c/'\'' '\''"xa.b.c.a.b.c"'\'''

echo '$ test-expr '\''#/^a\0b\0c/'\'' '\''"xa.b.c.a.b.c"'\'''
test-expr '#/^a\0b\0c/' '"xa.b.c.a.b.c"' 2>&1 ||
echo 'command failed: test-expr '\''#/^a\0b\0c/'\'' '\''"xa.b.c.a.b.c"'\'''

echo '$ test-expr '\''#/^a\0b\0c/'\'' '\''"xa.b.c.a.b.c"'\'''
test-expr '#/^a\0b\0c/' '"xa.b.c.a.b.c"' 2>&1 ||
echo 'command failed: test-expr '\''#/^a\0b\0c/'\'' '\''"xa.b.c.a.b.c"'\'''

echo '$ test-expr '\''/a\0b\0c/'\'' '\''"xa.b.c.a.b.cy"'\'''
test-expr '/a\0b\0c/' '"xa.b.c.a.b.cy"' 2>&1 ||
echo 'command failed: test-expr '\''/a\0b\0c/'\'' '\''"xa.b.c.a.b.cy"'\'''

echo '$ test-expr '\''/a\0b\0c/'\'' '\''"xa.b.c.a.b.cy"'\'''
test-expr '/a\0b\0c/' '"xa.b.c.a.b.cy"' 2>&1 ||
echo 'command failed: test-expr '\''/a\0b\0c/'\'' '\''"xa.b.c.a.b.cy"'\'''

echo '$ test-expr '\''/^a\0b\0c/'\'' '\''"xa.b.c.a.b.cy"'\'''
test-expr '/^a\0b\0c/' '"xa.b.c.a.b.cy"' 2>&1 ||
echo 'command failed: test-expr '\''/^a\0b\0c/'\'' '\''"xa.b.c.a.b.cy"'\'''

echo '$ test-expr '\''/^a\0b\0c/'\'' '\''"xa.b.c.a.b.cy"'\'''
test-expr '/^a\0b\0c/' '"xa.b.c.a.b.cy"' 2>&1 ||
echo 'command failed: test-expr '\''/^a\0b\0c/'\'' '\''"xa.b.c.a.b.cy"'\'''

echo '$ test-expr '\''#/a\0b\0c/'\'' '\''"xa.b.c.a.b.cy"'\'''
test-expr '#/a\0b\0c/' '"xa.b.c.a.b.cy"' 2>&1 ||
echo 'command failed: test-expr '\''#/a\0b\0c/'\'' '\''"xa.b.c.a.b.cy"'\'''

echo '$ test-expr '\''#/a\0b\0c/'\'' '\''"xa.b.c.a.b.cy"'\'''
test-expr '#/a\0b\0c/' '"xa.b.c.a.b.cy"' 2>&1 ||
echo 'command failed: test-expr '\''#/a\0b\0c/'\'' '\''"xa.b.c.a.b.cy"'\'''

echo '$ test-expr '\''#/^a\0b\0c/'\'' '\''"xa.b.c.a.b.cy"'\'''
test-expr '#/^a\0b\0c/' '"xa.b.c.a.b.cy"' 2>&1 ||
echo 'command failed: test-expr '\''#/^a\0b\0c/'\'' '\''"xa.b.c.a.b.cy"'\'''

echo '$ test-expr '\''#/^a\0b\0c/'\'' '\''"xa.b.c.a.b.cy"'\'''
test-expr '#/^a\0b\0c/' '"xa.b.c.a.b.cy"' 2>&1 ||
echo 'command failed: test-expr '\''#/^a\0b\0c/'\'' '\''"xa.b.c.a.b.cy"'\'''

echo '$ test-expr '\''/a\0b\0c\0d/'\'' '\''"a.b.c.d"'\'''
test-expr '/a\0b\0c\0d/' '"a.b.c.d"' 2>&1 ||
echo 'command failed: test-expr '\''/a\0b\0c\0d/'\'' '\''"a.b.c.d"'\'''

echo '$ test-expr '\''/a\0b\0c\0d/'\'' '\''"a.b.c.d"'\'''
test-expr '/a\0b\0c\0d/' '"a.b.c.d"' 2>&1 ||
echo 'command failed: test-expr '\''/a\0b\0c\0d/'\'' '\''"a.b.c.d"'\'''

echo '$ test-expr '\''/^a\0b\0c\0d/'\'' '\''"a.b.c.d"'\'''
test-expr '/^a\0b\0c\0d/' '"a.b.c.d"' 2>&1 ||
echo 'command failed: test-expr '\''/^a\0b\0c\0d/'\'' '\''"a.b.c.d"'\'''

echo '$ test-expr '\''/^a\0b\0c\0d/'\'' '\''"a.b.c.d"'\'''
test-expr '/^a\0b\0c\0d/' '"a.b.c.d"' 2>&1 ||
echo 'command failed: test-expr '\''/^a\0b\0c\0d/'\'' '\''"a.b.c.d"'\'''

echo '$ test-expr '\''#/a\0b\0c\0d/'\'' '\''"a.b.c.d"'\'''
test-expr '#/a\0b\0c\0d/' '"a.b.c.d"' 2>&1 ||
echo 'command failed: test-expr '\''#/a\0b\0c\0d/'\'' '\''"a.b.c.d"'\'''

echo '$ test-expr '\''#/a\0b\0c\0d/'\'' '\''"a.b.c.d"'\'''
test-expr '#/a\0b\0c\0d/' '"a.b.c.d"' 2>&1 ||
echo 'command failed: test-expr '\''#/a\0b\0c\0d/'\'' '\''"a.b.c.d"'\'''

echo '$ test-expr '\''#/^a\0b\0c\0d/'\'' '\''"a.b.c.d"'\'''
test-expr '#/^a\0b\0c\0d/' '"a.b.c.d"' 2>&1 ||
echo 'command failed: test-expr '\''#/^a\0b\0c\0d/'\'' '\''"a.b.c.d"'\'''

echo '$ test-expr '\''#/^a\0b\0c\0d/'\'' '\''"a.b.c.d"'\'''
test-expr '#/^a\0b\0c\0d/' '"a.b.c.d"' 2>&1 ||
echo 'command failed: test-expr '\''#/^a\0b\0c\0d/'\'' '\''"a.b.c.d"'\'''

echo '$ test-expr '\''/a\0b\0c\0d/'\'' '\''"a.b.c.dy"'\'''
test-expr '/a\0b\0c\0d/' '"a.b.c.dy"' 2>&1 ||
echo 'command failed: test-expr '\''/a\0b\0c\0d/'\'' '\''"a.b.c.dy"'\'''

echo '$ test-expr '\''/a\0b\0c\0d/'\'' '\''"a.b.c.dy"'\'''
test-expr '/a\0b\0c\0d/' '"a.b.c.dy"' 2>&1 ||
echo 'command failed: test-expr '\''/a\0b\0c\0d/'\'' '\''"a.b.c.dy"'\'''

echo '$ test-expr '\''/^a\0b\0c\0d/'\'' '\''"a.b.c.dy"'\'''
test-expr '/^a\0b\0c\0d/' '"a.b.c.dy"' 2>&1 ||
echo 'command failed: test-expr '\''/^a\0b\0c\0d/'\'' '\''"a.b.c.dy"'\'''

echo '$ test-expr '\''/^a\0b\0c\0d/'\'' '\''"a.b.c.dy"'\'''
test-expr '/^a\0b\0c\0d/' '"a.b.c.dy"' 2>&1 ||
echo 'command failed: test-expr '\''/^a\0b\0c\0d/'\'' '\''"a.b.c.dy"'\'''

echo '$ test-expr '\''#/a\0b\0c\0d/'\'' '\''"a.b.c.dy"'\'''
test-expr '#/a\0b\0c\0d/' '"a.b.c.dy"' 2>&1 ||
echo 'command failed: test-expr '\''#/a\0b\0c\0d/'\'' '\''"a.b.c.dy"'\'''

echo '$ test-expr '\''#/a\0b\0c\0d/'\'' '\''"a.b.c.dy"'\'''
test-expr '#/a\0b\0c\0d/' '"a.b.c.dy"' 2>&1 ||
echo 'command failed: test-expr '\''#/a\0b\0c\0d/'\'' '\''"a.b.c.dy"'\'''

echo '$ test-expr '\''#/^a\0b\0c\0d/'\'' '\''"a.b.c.dy"'\'''
test-expr '#/^a\0b\0c\0d/' '"a.b.c.dy"' 2>&1 ||
echo 'command failed: test-expr '\''#/^a\0b\0c\0d/'\'' '\''"a.b.c.dy"'\'''

echo '$ test-expr '\''#/^a\0b\0c\0d/'\'' '\''"a.b.c.dy"'\'''
test-expr '#/^a\0b\0c\0d/' '"a.b.c.dy"' 2>&1 ||
echo 'command failed: test-expr '\''#/^a\0b\0c\0d/'\'' '\''"a.b.c.dy"'\'''

echo '$ test-expr '\''/a\0b\0c\0d/'\'' '\''"xa.b.c.d"'\'''
test-expr '/a\0b\0c\0d/' '"xa.b.c.d"' 2>&1 ||
echo 'command failed: test-expr '\''/a\0b\0c\0d/'\'' '\''"xa.b.c.d"'\'''

echo '$ test-expr '\''/a\0b\0c\0d/'\'' '\''"xa.b.c.d"'\'''
test-expr '/a\0b\0c\0d/' '"xa.b.c.d"' 2>&1 ||
echo 'command failed: test-expr '\''/a\0b\0c\0d/'\'' '\''"xa.b.c.d"'\'''

echo '$ test-expr '\''/^a\0b\0c\0d/'\'' '\''"xa.b.c.d"'\'''
test-expr '/^a\0b\0c\0d/' '"xa.b.c.d"' 2>&1 ||
echo 'command failed: test-expr '\''/^a\0b\0c\0d/'\'' '\''"xa.b.c.d"'\'''

echo '$ test-expr '\''/^a\0b\0c\0d/'\'' '\''"xa.b.c.d"'\'''
test-expr '/^a\0b\0c\0d/' '"xa.b.c.d"' 2>&1 ||
echo 'command failed: test-expr '\''/^a\0b\0c\0d/'\'' '\''"xa.b.c.d"'\'''

echo '$ test-expr '\''#/a\0b\0c\0d/'\'' '\''"xa.b.c.d"'\'''
test-expr '#/a\0b\0c\0d/' '"xa.b.c.d"' 2>&1 ||
echo 'command failed: test-expr '\''#/a\0b\0c\0d/'\'' '\''"xa.b.c.d"'\'''

echo '$ test-expr '\''#/a\0b\0c\0d/'\'' '\''"xa.b.c.d"'\'''
test-expr '#/a\0b\0c\0d/' '"xa.b.c.d"' 2>&1 ||
echo 'command failed: test-expr '\''#/a\0b\0c\0d/'\'' '\''"xa.b.c.d"'\'''

echo '$ test-expr '\''#/^a\0b\0c\0d/'\'' '\''"xa.b.c.d"'\'''
test-expr '#/^a\0b\0c\0d/' '"xa.b.c.d"' 2>&1 ||
echo 'command failed: test-expr '\''#/^a\0b\0c\0d/'\'' '\''"xa.b.c.d"'\'''

echo '$ test-expr '\''#/^a\0b\0c\0d/'\'' '\''"xa.b.c.d"'\'''
test-expr '#/^a\0b\0c\0d/' '"xa.b.c.d"' 2>&1 ||
echo 'command failed: test-expr '\''#/^a\0b\0c\0d/'\'' '\''"xa.b.c.d"'\'''

echo '$ test-expr '\''/a\0b\0c\0d/'\'' '\''"xa.b.c.dy"'\'''
test-expr '/a\0b\0c\0d/' '"xa.b.c.dy"' 2>&1 ||
echo 'command failed: test-expr '\''/a\0b\0c\0d/'\'' '\''"xa.b.c.dy"'\'''

echo '$ test-expr '\''/a\0b\0c\0d/'\'' '\''"xa.b.c.dy"'\'''
test-expr '/a\0b\0c\0d/' '"xa.b.c.dy"' 2>&1 ||
echo 'command failed: test-expr '\''/a\0b\0c\0d/'\'' '\''"xa.b.c.dy"'\'''

echo '$ test-expr '\''/^a\0b\0c\0d/'\'' '\''"xa.b.c.dy"'\'''
test-expr '/^a\0b\0c\0d/' '"xa.b.c.dy"' 2>&1 ||
echo 'command failed: test-expr '\''/^a\0b\0c\0d/'\'' '\''"xa.b.c.dy"'\'''

echo '$ test-expr '\''/^a\0b\0c\0d/'\'' '\''"xa.b.c.dy"'\'''
test-expr '/^a\0b\0c\0d/' '"xa.b.c.dy"' 2>&1 ||
echo 'command failed: test-expr '\''/^a\0b\0c\0d/'\'' '\''"xa.b.c.dy"'\'''

echo '$ test-expr '\''#/a\0b\0c\0d/'\'' '\''"xa.b.c.dy"'\'''
test-expr '#/a\0b\0c\0d/' '"xa.b.c.dy"' 2>&1 ||
echo 'command failed: test-expr '\''#/a\0b\0c\0d/'\'' '\''"xa.b.c.dy"'\'''

echo '$ test-expr '\''#/a\0b\0c\0d/'\'' '\''"xa.b.c.dy"'\'''
test-expr '#/a\0b\0c\0d/' '"xa.b.c.dy"' 2>&1 ||
echo 'command failed: test-expr '\''#/a\0b\0c\0d/'\'' '\''"xa.b.c.dy"'\'''

echo '$ test-expr '\''#/^a\0b\0c\0d/'\'' '\''"xa.b.c.dy"'\'''
test-expr '#/^a\0b\0c\0d/' '"xa.b.c.dy"' 2>&1 ||
echo 'command failed: test-expr '\''#/^a\0b\0c\0d/'\'' '\''"xa.b.c.dy"'\'''

echo '$ test-expr '\''#/^a\0b\0c\0d/'\'' '\''"xa.b.c.dy"'\'''
test-expr '#/^a\0b\0c\0d/' '"xa.b.c.dy"' 2>&1 ||
echo 'command failed: test-expr '\''#/^a\0b\0c\0d/'\'' '\''"xa.b.c.dy"'\'''

echo '$ test-expr '\''/a\0b\0c\0d/'\'' '\''"a.b.c.d.a.b.c.d"'\'''
test-expr '/a\0b\0c\0d/' '"a.b.c.d.a.b.c.d"' 2>&1 ||
echo 'command failed: test-expr '\''/a\0b\0c\0d/'\'' '\''"a.b.c.d.a.b.c.d"'\'''

echo '$ test-expr '\''/a\0b\0c\0d/'\'' '\''"a.b.c.d.a.b.c.d"'\'''
test-expr '/a\0b\0c\0d/' '"a.b.c.d.a.b.c.d"' 2>&1 ||
echo 'command failed: test-expr '\''/a\0b\0c\0d/'\'' '\''"a.b.c.d.a.b.c.d"'\'''

echo '$ test-expr '\''/^a\0b\0c\0d/'\'' '\''"a.b.c.d.a.b.c.d"'\'''
test-expr '/^a\0b\0c\0d/' '"a.b.c.d.a.b.c.d"' 2>&1 ||
echo 'command failed: test-expr '\''/^a\0b\0c\0d/'\'' '\''"a.b.c.d.a.b.c.d"'\'''

echo '$ test-expr '\''/^a\0b\0c\0d/'\'' '\''"a.b.c.d.a.b.c.d"'\'''
test-expr '/^a\0b\0c\0d/' '"a.b.c.d.a.b.c.d"' 2>&1 ||
echo 'command failed: test-expr '\''/^a\0b\0c\0d/'\'' '\''"a.b.c.d.a.b.c.d"'\'''

echo '$ test-expr '\''#/a\0b\0c\0d/'\'' '\''"a.b.c.d.a.b.c.d"'\'''
test-expr '#/a\0b\0c\0d/' '"a.b.c.d.a.b.c.d"' 2>&1 ||
echo 'command failed: test-expr '\''#/a\0b\0c\0d/'\'' '\''"a.b.c.d.a.b.c.d"'\'''

echo '$ test-expr '\''#/a\0b\0c\0d/'\'' '\''"a.b.c.d.a.b.c.d"'\'''
test-expr '#/a\0b\0c\0d/' '"a.b.c.d.a.b.c.d"' 2>&1 ||
echo 'command failed: test-expr '\''#/a\0b\0c\0d/'\'' '\''"a.b.c.d.a.b.c.d"'\'''

echo '$ test-expr '\''#/^a\0b\0c\0d/'\'' '\''"a.b.c.d.a.b.c.d"'\'''
test-expr '#/^a\0b\0c\0d/' '"a.b.c.d.a.b.c.d"' 2>&1 ||
echo 'command failed: test-expr '\''#/^a\0b\0c\0d/'\'' '\''"a.b.c.d.a.b.c.d"'\'''

echo '$ test-expr '\''#/^a\0b\0c\0d/'\'' '\''"a.b.c.d.a.b.c.d"'\'''
test-expr '#/^a\0b\0c\0d/' '"a.b.c.d.a.b.c.d"' 2>&1 ||
echo 'command failed: test-expr '\''#/^a\0b\0c\0d/'\'' '\''"a.b.c.d.a.b.c.d"'\'''

echo '$ test-expr '\''/a\0b\0c\0d/'\'' '\''"a.b.c.d.a.b.c.dy"'\'''
test-expr '/a\0b\0c\0d/' '"a.b.c.d.a.b.c.dy"' 2>&1 ||
echo 'command failed: test-expr '\''/a\0b\0c\0d/'\'' '\''"a.b.c.d.a.b.c.dy"'\'''

echo '$ test-expr '\''/a\0b\0c\0d/'\'' '\''"a.b.c.d.a.b.c.dy"'\'''
test-expr '/a\0b\0c\0d/' '"a.b.c.d.a.b.c.dy"' 2>&1 ||
echo 'command failed: test-expr '\''/a\0b\0c\0d/'\'' '\''"a.b.c.d.a.b.c.dy"'\'''

echo '$ test-expr '\''/^a\0b\0c\0d/'\'' '\''"a.b.c.d.a.b.c.dy"'\'''
test-expr '/^a\0b\0c\0d/' '"a.b.c.d.a.b.c.dy"' 2>&1 ||
echo 'command failed: test-expr '\''/^a\0b\0c\0d/'\'' '\''"a.b.c.d.a.b.c.dy"'\'''

echo '$ test-expr '\''/^a\0b\0c\0d/'\'' '\''"a.b.c.d.a.b.c.dy"'\'''
test-expr '/^a\0b\0c\0d/' '"a.b.c.d.a.b.c.dy"' 2>&1 ||
echo 'command failed: test-expr '\''/^a\0b\0c\0d/'\'' '\''"a.b.c.d.a.b.c.dy"'\'''

echo '$ test-expr '\''#/a\0b\0c\0d/'\'' '\''"a.b.c.d.a.b.c.dy"'\'''
test-expr '#/a\0b\0c\0d/' '"a.b.c.d.a.b.c.dy"' 2>&1 ||
echo 'command failed: test-expr '\''#/a\0b\0c\0d/'\'' '\''"a.b.c.d.a.b.c.dy"'\'''

echo '$ test-expr '\''#/a\0b\0c\0d/'\'' '\''"a.b.c.d.a.b.c.dy"'\'''
test-expr '#/a\0b\0c\0d/' '"a.b.c.d.a.b.c.dy"' 2>&1 ||
echo 'command failed: test-expr '\''#/a\0b\0c\0d/'\'' '\''"a.b.c.d.a.b.c.dy"'\'''

echo '$ test-expr '\''#/^a\0b\0c\0d/'\'' '\''"a.b.c.d.a.b.c.dy"'\'''
test-expr '#/^a\0b\0c\0d/' '"a.b.c.d.a.b.c.dy"' 2>&1 ||
echo 'command failed: test-expr '\''#/^a\0b\0c\0d/'\'' '\''"a.b.c.d.a.b.c.dy"'\'''

echo '$ test-expr '\''#/^a\0b\0c\0d/'\'' '\''"a.b.c.d.a.b.c.dy"'\'''
test-expr '#/^a\0b\0c\0d/' '"a.b.c.d.a.b.c.dy"' 2>&1 ||
echo 'command failed: test-expr '\''#/^a\0b\0c\0d/'\'' '\''"a.b.c.d.a.b.c.dy"'\'''

echo '$ test-expr '\''/a\0b\0c\0d/'\'' '\''"xa.b.c.d.a.b.c.d"'\'''
test-expr '/a\0b\0c\0d/' '"xa.b.c.d.a.b.c.d"' 2>&1 ||
echo 'command failed: test-expr '\''/a\0b\0c\0d/'\'' '\''"xa.b.c.d.a.b.c.d"'\'''

echo '$ test-expr '\''/a\0b\0c\0d/'\'' '\''"xa.b.c.d.a.b.c.d"'\'''
test-expr '/a\0b\0c\0d/' '"xa.b.c.d.a.b.c.d"' 2>&1 ||
echo 'command failed: test-expr '\''/a\0b\0c\0d/'\'' '\''"xa.b.c.d.a.b.c.d"'\'''

echo '$ test-expr '\''/^a\0b\0c\0d/'\'' '\''"xa.b.c.d.a.b.c.d"'\'''
test-expr '/^a\0b\0c\0d/' '"xa.b.c.d.a.b.c.d"' 2>&1 ||
echo 'command failed: test-expr '\''/^a\0b\0c\0d/'\'' '\''"xa.b.c.d.a.b.c.d"'\'''

echo '$ test-expr '\''/^a\0b\0c\0d/'\'' '\''"xa.b.c.d.a.b.c.d"'\'''
test-expr '/^a\0b\0c\0d/' '"xa.b.c.d.a.b.c.d"' 2>&1 ||
echo 'command failed: test-expr '\''/^a\0b\0c\0d/'\'' '\''"xa.b.c.d.a.b.c.d"'\'''

echo '$ test-expr '\''#/a\0b\0c\0d/'\'' '\''"xa.b.c.d.a.b.c.d"'\'''
test-expr '#/a\0b\0c\0d/' '"xa.b.c.d.a.b.c.d"' 2>&1 ||
echo 'command failed: test-expr '\''#/a\0b\0c\0d/'\'' '\''"xa.b.c.d.a.b.c.d"'\'''

echo '$ test-expr '\''#/a\0b\0c\0d/'\'' '\''"xa.b.c.d.a.b.c.d"'\'''
test-expr '#/a\0b\0c\0d/' '"xa.b.c.d.a.b.c.d"' 2>&1 ||
echo 'command failed: test-expr '\''#/a\0b\0c\0d/'\'' '\''"xa.b.c.d.a.b.c.d"'\'''

echo '$ test-expr '\''#/^a\0b\0c\0d/'\'' '\''"xa.b.c.d.a.b.c.d"'\'''
test-expr '#/^a\0b\0c\0d/' '"xa.b.c.d.a.b.c.d"' 2>&1 ||
echo 'command failed: test-expr '\''#/^a\0b\0c\0d/'\'' '\''"xa.b.c.d.a.b.c.d"'\'''

echo '$ test-expr '\''#/^a\0b\0c\0d/'\'' '\''"xa.b.c.d.a.b.c.d"'\'''
test-expr '#/^a\0b\0c\0d/' '"xa.b.c.d.a.b.c.d"' 2>&1 ||
echo 'command failed: test-expr '\''#/^a\0b\0c\0d/'\'' '\''"xa.b.c.d.a.b.c.d"'\'''

echo '$ test-expr '\''/a\0b\0c\0d/'\'' '\''"xa.b.c.d.a.b.c.dy"'\'''
test-expr '/a\0b\0c\0d/' '"xa.b.c.d.a.b.c.dy"' 2>&1 ||
echo 'command failed: test-expr '\''/a\0b\0c\0d/'\'' '\''"xa.b.c.d.a.b.c.dy"'\'''

echo '$ test-expr '\''/a\0b\0c\0d/'\'' '\''"xa.b.c.d.a.b.c.dy"'\'''
test-expr '/a\0b\0c\0d/' '"xa.b.c.d.a.b.c.dy"' 2>&1 ||
echo 'command failed: test-expr '\''/a\0b\0c\0d/'\'' '\''"xa.b.c.d.a.b.c.dy"'\'''

echo '$ test-expr '\''/^a\0b\0c\0d/'\'' '\''"xa.b.c.d.a.b.c.dy"'\'''
test-expr '/^a\0b\0c\0d/' '"xa.b.c.d.a.b.c.dy"' 2>&1 ||
echo 'command failed: test-expr '\''/^a\0b\0c\0d/'\'' '\''"xa.b.c.d.a.b.c.dy"'\'''

echo '$ test-expr '\''/^a\0b\0c\0d/'\'' '\''"xa.b.c.d.a.b.c.dy"'\'''
test-expr '/^a\0b\0c\0d/' '"xa.b.c.d.a.b.c.dy"' 2>&1 ||
echo 'command failed: test-expr '\''/^a\0b\0c\0d/'\'' '\''"xa.b.c.d.a.b.c.dy"'\'''

echo '$ test-expr '\''#/a\0b\0c\0d/'\'' '\''"xa.b.c.d.a.b.c.dy"'\'''
test-expr '#/a\0b\0c\0d/' '"xa.b.c.d.a.b.c.dy"' 2>&1 ||
echo 'command failed: test-expr '\''#/a\0b\0c\0d/'\'' '\''"xa.b.c.d.a.b.c.dy"'\'''

echo '$ test-expr '\''#/a\0b\0c\0d/'\'' '\''"xa.b.c.d.a.b.c.dy"'\'''
test-expr '#/a\0b\0c\0d/' '"xa.b.c.d.a.b.c.dy"' 2>&1 ||
echo 'command failed: test-expr '\''#/a\0b\0c\0d/'\'' '\''"xa.b.c.d.a.b.c.dy"'\'''

echo '$ test-expr '\''#/^a\0b\0c\0d/'\'' '\''"xa.b.c.d.a.b.c.dy"'\'''
test-expr '#/^a\0b\0c\0d/' '"xa.b.c.d.a.b.c.dy"' 2>&1 ||
echo 'command failed: test-expr '\''#/^a\0b\0c\0d/'\'' '\''"xa.b.c.d.a.b.c.dy"'\'''

echo '$ test-expr '\''#/^a\0b\0c\0d/'\'' '\''"xa.b.c.d.a.b.c.dy"'\'''
test-expr '#/^a\0b\0c\0d/' '"xa.b.c.d.a.b.c.dy"' 2>&1 ||
echo 'command failed: test-expr '\''#/^a\0b\0c\0d/'\'' '\''"xa.b.c.d.a.b.c.dy"'\'''
)

