#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -p litex -C lib:basic
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L basic.old <(echo \
'$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"
$ json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -A "$@"|sed -r '\''s/"size":[0-9]+,"bytes":\["[0-9a-f]+"(,"[0-9a-f]+")*\]//;s/("lookup":"0x)[0-9a-f]+(")/\1...\2/g'\''|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }
$ json-litex -d '\''null'\''
json: error: <text>:1:1: filter library: meta error: values must be either strings, objects or arrays
json: error: <text>:1:1: null
json: error: <text>:1:1: ^
command failed: json-litex -d '\''null'\''
$ json-litex -d '\''false'\''
json: error: <text>:1:1: filter library: meta error: values must be either strings, objects or arrays
json: error: <text>:1:1: false
json: error: <text>:1:1: ^
command failed: json-litex -d '\''false'\''
$ json-litex -d '\''true'\''
json: error: <text>:1:1: filter library: meta error: values must be either strings, objects or arrays
json: error: <text>:1:1: true
json: error: <text>:1:1: ^
command failed: json-litex -d '\''true'\''
$ json-litex -d '\''123'\''
json: error: <text>:1:1: filter library: meta error: values must be either strings, objects or arrays
json: error: <text>:1:1: 123
json: error: <text>:1:1: ^
command failed: json-litex -d '\''123'\''
$ json-litex -d '\''""'\''
json: error: <text>:1:1: filter library: attribute error: invalid string: is empty
json: error: <text>:1:1: ""
json: error: <text>:1:1: ^
command failed: json-litex -d '\''""'\''
$ json-litex -d '\''"``"'\''
json: error: <text>:1:2: filter library: expression error: empty string
json: error: <text>:1:2: "``"
json: error: <text>:1:2:  ^
command failed: json-litex -d '\''"``"'\''
$ json-litex -d '\''"//"'\''
json: error: <text>:1:2: filter library: expression error: empty regex
json: error: <text>:1:2: "//"
json: error: <text>:1:2:  ^
command failed: json-litex -d '\''"//"'\''
$ json-litex -d '\''"'\''\'\'''\'''\''\'\'''\''"'\''
json: error: <text>:1:2: filter library: expression error: empty regex
json: error: <text>:1:2: "'\'''\''"
json: error: <text>:1:2:  ^
command failed: json-litex -d '\''"'\''\'\'''\'''\''\'\'''\''"'\''
$ json-litex -d '\''"foo"'\''
json: error: <text>:1:2: filter library: expression error: unknown builtin
json: error: <text>:1:2: "foo"
json: error: <text>:1:2:  ^
command failed: json-litex -d '\''"foo"'\''
$ json-litex -d '\''"`foo`"'\''
{
    "rexes": null,
    "node": {
        "id": 2,
        "type": "string",
        "node": {
            "val": "`foo`",
            "delim": null
        },
        "attr": {
            "size": 1,
            "nodes": [
                {
                    "type": "match_str",
                    "val": "foo"
                }
            ]
        },
        "parent": null,
        "path": null
    }
}
$ json-litex -d '\''"/foo/"'\''
{
    "rexes": {
        "size": 1,
        "codes": {
            "type": "patterns",
            "code": {}
        },
        "elems": [
            {
                "text": "foo",
                "opts": ""
            }
        ]
    },
    "node": {
        "id": 5,
        "type": "string",
        "node": {
            "val": "/foo/",
            "delim": null
        },
        "attr": {
            "size": 1,
            "nodes": [
                {
                    "type": "match_rex",
                    "val": 0
                }
            ]
        },
        "parent": null,
        "path": null
    }
}
$ json-litex -d '\''"'\''\'\'''\''foo'\''\'\'''\''"'\''
{
    "rexes": {
        "size": 1,
        "codes": {
            "type": "patterns",
            "code": {}
        },
        "elems": [
            {
                "text": "foo",
                "opts": ""
            }
        ]
    },
    "node": {
        "id": 5,
        "type": "string",
        "node": {
            "val": "'\''foo'\''",
            "delim": null
        },
        "attr": {
            "size": 1,
            "nodes": [
                {
                    "type": "match_rex",
                    "val": 0
                }
            ]
        },
        "parent": null,
        "path": null
    }
}
$ json-litex -d '\''{}'\''
json: error: <text>:1:1: filter library: meta error: empty objects are not allowed
json: error: <text>:1:1: {}
json: error: <text>:1:1: ^
command failed: json-litex -d '\''{}'\''
$ json-litex -d '\''[]'\''
json: error: <text>:1:1: filter library: meta error: empty arrays are not allowed
json: error: <text>:1:1: []
json: error: <text>:1:1: ^
command failed: json-litex -d '\''[]'\'''
) -L basic.new <(
echo '$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'
[ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib" 2>&1 ||
echo 'command failed: [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'

echo '$ json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -A "$@"|sed -r '\''s/"size":[0-9]+,"bytes":\["[0-9a-f]+"(,"[0-9a-f]+")*\]//;s/("lookup":"0x)[0-9a-f]+(")/\1...\2/g'\''|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }'
json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -A "$@"|sed -r 's/"size":[0-9]+,"bytes":\["[0-9a-f]+"(,"[0-9a-f]+")*\]//;s/("lookup":"0x)[0-9a-f]+(")/\1...\2/g'|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; } 2>&1 ||
echo 'command failed: json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -A "$@"|sed -r '\''s/"size":[0-9]+,"bytes":\["[0-9a-f]+"(,"[0-9a-f]+")*\]//;s/("lookup":"0x)[0-9a-f]+(")/\1...\2/g'\''|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }'

echo '$ json-litex -d '\''null'\'''
json-litex -d 'null' 2>&1 ||
echo 'command failed: json-litex -d '\''null'\'''

echo '$ json-litex -d '\''false'\'''
json-litex -d 'false' 2>&1 ||
echo 'command failed: json-litex -d '\''false'\'''

echo '$ json-litex -d '\''true'\'''
json-litex -d 'true' 2>&1 ||
echo 'command failed: json-litex -d '\''true'\'''

echo '$ json-litex -d '\''123'\'''
json-litex -d '123' 2>&1 ||
echo 'command failed: json-litex -d '\''123'\'''

echo '$ json-litex -d '\''""'\'''
json-litex -d '""' 2>&1 ||
echo 'command failed: json-litex -d '\''""'\'''

echo '$ json-litex -d '\''"``"'\'''
json-litex -d '"``"' 2>&1 ||
echo 'command failed: json-litex -d '\''"``"'\'''

echo '$ json-litex -d '\''"//"'\'''
json-litex -d '"//"' 2>&1 ||
echo 'command failed: json-litex -d '\''"//"'\'''

echo '$ json-litex -d '\''"'\''\'\'''\'''\''\'\'''\''"'\'''
json-litex -d '"'\'''\''"' 2>&1 ||
echo 'command failed: json-litex -d '\''"'\''\'\'''\'''\''\'\'''\''"'\'''

echo '$ json-litex -d '\''"foo"'\'''
json-litex -d '"foo"' 2>&1 ||
echo 'command failed: json-litex -d '\''"foo"'\'''

echo '$ json-litex -d '\''"`foo`"'\'''
json-litex -d '"`foo`"' 2>&1 ||
echo 'command failed: json-litex -d '\''"`foo`"'\'''

echo '$ json-litex -d '\''"/foo/"'\'''
json-litex -d '"/foo/"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/foo/"'\'''

echo '$ json-litex -d '\''"'\''\'\'''\''foo'\''\'\'''\''"'\'''
json-litex -d '"'\''foo'\''"' 2>&1 ||
echo 'command failed: json-litex -d '\''"'\''\'\'''\''foo'\''\'\'''\''"'\'''

echo '$ json-litex -d '\''{}'\'''
json-litex -d '{}' 2>&1 ||
echo 'command failed: json-litex -d '\''{}'\'''

echo '$ json-litex -d '\''[]'\'''
json-litex -d '[]' 2>&1 ||
echo 'command failed: json-litex -d '\''[]'\'''
)

