#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -p litex -C lib:error-pos4
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L error-pos4.old <(echo \
'$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"
$ json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -A "$@"|sed -r '\''s/"size":[0-9]+,"bytes":\["[0-9a-f]+"(,"[0-9a-f]+")*\]//;s/("lookup":"0x)[0-9a-f]+(")/\1...\2/g'\''|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }
$ json-litex -d '\''"/\n\n\t\\g/X"'\''
json: error: <text>:1:12: filter library: expression error: pcre2 compile: \g is not followed by a braced, angle-bracketed, or quoted name/number or by a plain number
json: error: <text>:1:12: "/\\n\\n\\t\\\\g/X"
json: error: <text>:1:12:                 ^
command failed: json-litex -d '\''"/\n\n\t\\g/X"'\''
$ json-litex -d '\''"/\n\n\t\\gfoo/X"'\''
json: error: <text>:1:12: filter library: expression error: pcre2 compile: \g is not followed by a braced, angle-bracketed, or quoted name/number or by a plain number
json: error: <text>:1:12: "/\\n\\n\\t\\\\gfoo/X"
json: error: <text>:1:12:                 ^
command failed: json-litex -d '\''"/\n\n\t\\gfoo/X"'\''
$ json-litex -d '\''"/\n\n\t\\g\n/X"'\''
json: error: <text>:1:12: filter library: expression error: pcre2 compile: \g is not followed by a braced, angle-bracketed, or quoted name/number or by a plain number
json: error: <text>:1:12: "/\\n\\n\\t\\\\g\\n/X"
json: error: <text>:1:12:                 ^
command failed: json-litex -d '\''"/\n\n\t\\g\n/X"'\''
$ json-litex -d '\''"/\n\n\t\\g\nfoo/X"'\''
json: error: <text>:1:12: filter library: expression error: pcre2 compile: \g is not followed by a braced, angle-bracketed, or quoted name/number or by a plain number
json: error: <text>:1:12: "/\\n\\n\\t\\\\g\\nfoo/X"
json: error: <text>:1:12:                 ^
command failed: json-litex -d '\''"/\n\n\t\\g\nfoo/X"'\''
$ json-litex -d '\''"/\n\n\t\\g\t/X"'\''
json: error: <text>:1:12: filter library: expression error: pcre2 compile: \g is not followed by a braced, angle-bracketed, or quoted name/number or by a plain number
json: error: <text>:1:12: "/\\n\\n\\t\\\\g\\t/X"
json: error: <text>:1:12:                 ^
command failed: json-litex -d '\''"/\n\n\t\\g\t/X"'\''
$ json-litex -d '\''"/\n\n\t\\g\tfoo/X"'\''
json: error: <text>:1:12: filter library: expression error: pcre2 compile: \g is not followed by a braced, angle-bracketed, or quoted name/number or by a plain number
json: error: <text>:1:12: "/\\n\\n\\t\\\\g\\tfoo/X"
json: error: <text>:1:12:                 ^
command failed: json-litex -d '\''"/\n\n\t\\g\tfoo/X"'\''
$ json-litex -d '\''"/\n\n\t\\g\t\n/X"'\''
json: error: <text>:1:12: filter library: expression error: pcre2 compile: \g is not followed by a braced, angle-bracketed, or quoted name/number or by a plain number
json: error: <text>:1:12: "/\\n\\n\\t\\\\g\\t\\n/X"
json: error: <text>:1:12:                 ^
command failed: json-litex -d '\''"/\n\n\t\\g\t\n/X"'\''
$ json-litex -d '\''"/\n\n\t\\g\t\nfoo/X"'\''
json: error: <text>:1:12: filter library: expression error: pcre2 compile: \g is not followed by a braced, angle-bracketed, or quoted name/number or by a plain number
json: error: <text>:1:12: "/\\n\\n\\t\\\\g\\t\\nfoo/X"
json: error: <text>:1:12:                 ^
command failed: json-litex -d '\''"/\n\n\t\\g\t\nfoo/X"'\''
$ json-litex -d '\''"/\n\n\t\\g>/X"'\''
json: error: <text>:1:12: filter library: expression error: pcre2 compile: \g is not followed by a braced, angle-bracketed, or quoted name/number or by a plain number
json: error: <text>:1:12: "/\\n\\n\\t\\\\g>/X"
json: error: <text>:1:12:                 ^
command failed: json-litex -d '\''"/\n\n\t\\g>/X"'\''
$ json-litex -d '\''"/\n\n\t\\g>foo/X"'\''
json: error: <text>:1:12: filter library: expression error: pcre2 compile: \g is not followed by a braced, angle-bracketed, or quoted name/number or by a plain number
json: error: <text>:1:12: "/\\n\\n\\t\\\\g>foo/X"
json: error: <text>:1:12:                 ^
command failed: json-litex -d '\''"/\n\n\t\\g>foo/X"'\''
$ json-litex -d '\''"/\n\n\t\\g>\n/X"'\''
json: error: <text>:1:12: filter library: expression error: pcre2 compile: \g is not followed by a braced, angle-bracketed, or quoted name/number or by a plain number
json: error: <text>:1:12: "/\\n\\n\\t\\\\g>\\n/X"
json: error: <text>:1:12:                 ^
command failed: json-litex -d '\''"/\n\n\t\\g>\n/X"'\''
$ json-litex -d '\''"/\n\n\t\\g>\nfoo/X"'\''
json: error: <text>:1:12: filter library: expression error: pcre2 compile: \g is not followed by a braced, angle-bracketed, or quoted name/number or by a plain number
json: error: <text>:1:12: "/\\n\\n\\t\\\\g>\\nfoo/X"
json: error: <text>:1:12:                 ^
command failed: json-litex -d '\''"/\n\n\t\\g>\nfoo/X"'\''
$ json-litex -d '\''"/\n\n\t\\g)/X"'\''
json: error: <text>:1:12: filter library: expression error: pcre2 compile: \g is not followed by a braced, angle-bracketed, or quoted name/number or by a plain number
json: error: <text>:1:12: "/\\n\\n\\t\\\\g)/X"
json: error: <text>:1:12:                 ^
command failed: json-litex -d '\''"/\n\n\t\\g)/X"'\''
$ json-litex -d '\''"/\n\n\t\\g)foo/X"'\''
json: error: <text>:1:12: filter library: expression error: pcre2 compile: \g is not followed by a braced, angle-bracketed, or quoted name/number or by a plain number
json: error: <text>:1:12: "/\\n\\n\\t\\\\g)foo/X"
json: error: <text>:1:12:                 ^
command failed: json-litex -d '\''"/\n\n\t\\g)foo/X"'\''
$ json-litex -d '\''"/\n\n\t\\g)\n/X"'\''
json: error: <text>:1:12: filter library: expression error: pcre2 compile: \g is not followed by a braced, angle-bracketed, or quoted name/number or by a plain number
json: error: <text>:1:12: "/\\n\\n\\t\\\\g)\\n/X"
json: error: <text>:1:12:                 ^
command failed: json-litex -d '\''"/\n\n\t\\g)\n/X"'\''
$ json-litex -d '\''"/\n\n\t\\g)\nfoo/X"'\''
json: error: <text>:1:12: filter library: expression error: pcre2 compile: \g is not followed by a braced, angle-bracketed, or quoted name/number or by a plain number
json: error: <text>:1:12: "/\\n\\n\\t\\\\g)\\nfoo/X"
json: error: <text>:1:12:                 ^
command failed: json-litex -d '\''"/\n\n\t\\g)\nfoo/X"'\''
$ json-litex -d '\''"/\n\n\t\\g}/X"'\''
json: error: <text>:1:12: filter library: expression error: pcre2 compile: \g is not followed by a braced, angle-bracketed, or quoted name/number or by a plain number
json: error: <text>:1:12: "/\\n\\n\\t\\\\g}/X"
json: error: <text>:1:12:                 ^
command failed: json-litex -d '\''"/\n\n\t\\g}/X"'\''
$ json-litex -d '\''"/\n\n\t\\g}foo/X"'\''
json: error: <text>:1:12: filter library: expression error: pcre2 compile: \g is not followed by a braced, angle-bracketed, or quoted name/number or by a plain number
json: error: <text>:1:12: "/\\n\\n\\t\\\\g}foo/X"
json: error: <text>:1:12:                 ^
command failed: json-litex -d '\''"/\n\n\t\\g}foo/X"'\''
$ json-litex -d '\''"/\n\n\t\\g}\n/X"'\''
json: error: <text>:1:12: filter library: expression error: pcre2 compile: \g is not followed by a braced, angle-bracketed, or quoted name/number or by a plain number
json: error: <text>:1:12: "/\\n\\n\\t\\\\g}\\n/X"
json: error: <text>:1:12:                 ^
command failed: json-litex -d '\''"/\n\n\t\\g}\n/X"'\''
$ json-litex -d '\''"/\n\n\t\\g}\nfoo/X"'\''
json: error: <text>:1:12: filter library: expression error: pcre2 compile: \g is not followed by a braced, angle-bracketed, or quoted name/number or by a plain number
json: error: <text>:1:12: "/\\n\\n\\t\\\\g}\\nfoo/X"
json: error: <text>:1:12:                 ^
command failed: json-litex -d '\''"/\n\n\t\\g}\nfoo/X"'\''
$ json-litex -d '\''"/\n\n\t\\g /X"'\''
json: error: <text>:1:12: filter library: expression error: pcre2 compile: \g is not followed by a braced, angle-bracketed, or quoted name/number or by a plain number
json: error: <text>:1:12: "/\\n\\n\\t\\\\g /X"
json: error: <text>:1:12:                 ^
command failed: json-litex -d '\''"/\n\n\t\\g /X"'\''
$ json-litex -d '\''"/\n\n\t\\g foo/X"'\''
json: error: <text>:1:12: filter library: expression error: pcre2 compile: \g is not followed by a braced, angle-bracketed, or quoted name/number or by a plain number
json: error: <text>:1:12: "/\\n\\n\\t\\\\g foo/X"
json: error: <text>:1:12:                 ^
command failed: json-litex -d '\''"/\n\n\t\\g foo/X"'\''
$ json-litex -d '\''"/\n\n\t\\g \n/X"'\''
json: error: <text>:1:12: filter library: expression error: pcre2 compile: \g is not followed by a braced, angle-bracketed, or quoted name/number or by a plain number
json: error: <text>:1:12: "/\\n\\n\\t\\\\g \\n/X"
json: error: <text>:1:12:                 ^
command failed: json-litex -d '\''"/\n\n\t\\g \n/X"'\''
$ json-litex -d '\''"/\n\n\t\\g \nfoo/X"'\''
json: error: <text>:1:12: filter library: expression error: pcre2 compile: \g is not followed by a braced, angle-bracketed, or quoted name/number or by a plain number
json: error: <text>:1:12: "/\\n\\n\\t\\\\g \\nfoo/X"
json: error: <text>:1:12:                 ^
command failed: json-litex -d '\''"/\n\n\t\\g \nfoo/X"'\''
$ json-litex -d '\''"/\n\n\t\\g \t/X"'\''
json: error: <text>:1:12: filter library: expression error: pcre2 compile: \g is not followed by a braced, angle-bracketed, or quoted name/number or by a plain number
json: error: <text>:1:12: "/\\n\\n\\t\\\\g \\t/X"
json: error: <text>:1:12:                 ^
command failed: json-litex -d '\''"/\n\n\t\\g \t/X"'\''
$ json-litex -d '\''"/\n\n\t\\g \tfoo/X"'\''
json: error: <text>:1:12: filter library: expression error: pcre2 compile: \g is not followed by a braced, angle-bracketed, or quoted name/number or by a plain number
json: error: <text>:1:12: "/\\n\\n\\t\\\\g \\tfoo/X"
json: error: <text>:1:12:                 ^
command failed: json-litex -d '\''"/\n\n\t\\g \tfoo/X"'\''
$ json-litex -d '\''"/\n\n\t\\g \t\n/X"'\''
json: error: <text>:1:12: filter library: expression error: pcre2 compile: \g is not followed by a braced, angle-bracketed, or quoted name/number or by a plain number
json: error: <text>:1:12: "/\\n\\n\\t\\\\g \\t\\n/X"
json: error: <text>:1:12:                 ^
command failed: json-litex -d '\''"/\n\n\t\\g \t\n/X"'\''
$ json-litex -d '\''"/\n\n\t\\g \t\nfoo/X"'\''
json: error: <text>:1:12: filter library: expression error: pcre2 compile: \g is not followed by a braced, angle-bracketed, or quoted name/number or by a plain number
json: error: <text>:1:12: "/\\n\\n\\t\\\\g \\t\\nfoo/X"
json: error: <text>:1:12:                 ^
command failed: json-litex -d '\''"/\n\n\t\\g \t\nfoo/X"'\''
$ json-litex -d '\''"/\n\n\t\\g >/X"'\''
json: error: <text>:1:12: filter library: expression error: pcre2 compile: \g is not followed by a braced, angle-bracketed, or quoted name/number or by a plain number
json: error: <text>:1:12: "/\\n\\n\\t\\\\g >/X"
json: error: <text>:1:12:                 ^
command failed: json-litex -d '\''"/\n\n\t\\g >/X"'\''
$ json-litex -d '\''"/\n\n\t\\g >foo/X"'\''
json: error: <text>:1:12: filter library: expression error: pcre2 compile: \g is not followed by a braced, angle-bracketed, or quoted name/number or by a plain number
json: error: <text>:1:12: "/\\n\\n\\t\\\\g >foo/X"
json: error: <text>:1:12:                 ^
command failed: json-litex -d '\''"/\n\n\t\\g >foo/X"'\''
$ json-litex -d '\''"/\n\n\t\\g >\n/X"'\''
json: error: <text>:1:12: filter library: expression error: pcre2 compile: \g is not followed by a braced, angle-bracketed, or quoted name/number or by a plain number
json: error: <text>:1:12: "/\\n\\n\\t\\\\g >\\n/X"
json: error: <text>:1:12:                 ^
command failed: json-litex -d '\''"/\n\n\t\\g >\n/X"'\''
$ json-litex -d '\''"/\n\n\t\\g >\nfoo/X"'\''
json: error: <text>:1:12: filter library: expression error: pcre2 compile: \g is not followed by a braced, angle-bracketed, or quoted name/number or by a plain number
json: error: <text>:1:12: "/\\n\\n\\t\\\\g >\\nfoo/X"
json: error: <text>:1:12:                 ^
command failed: json-litex -d '\''"/\n\n\t\\g >\nfoo/X"'\''
$ json-litex -d '\''"/\n\n\t\\g )/X"'\''
json: error: <text>:1:12: filter library: expression error: pcre2 compile: \g is not followed by a braced, angle-bracketed, or quoted name/number or by a plain number
json: error: <text>:1:12: "/\\n\\n\\t\\\\g )/X"
json: error: <text>:1:12:                 ^
command failed: json-litex -d '\''"/\n\n\t\\g )/X"'\''
$ json-litex -d '\''"/\n\n\t\\g )foo/X"'\''
json: error: <text>:1:12: filter library: expression error: pcre2 compile: \g is not followed by a braced, angle-bracketed, or quoted name/number or by a plain number
json: error: <text>:1:12: "/\\n\\n\\t\\\\g )foo/X"
json: error: <text>:1:12:                 ^
command failed: json-litex -d '\''"/\n\n\t\\g )foo/X"'\''
$ json-litex -d '\''"/\n\n\t\\g )\n/X"'\''
json: error: <text>:1:12: filter library: expression error: pcre2 compile: \g is not followed by a braced, angle-bracketed, or quoted name/number or by a plain number
json: error: <text>:1:12: "/\\n\\n\\t\\\\g )\\n/X"
json: error: <text>:1:12:                 ^
command failed: json-litex -d '\''"/\n\n\t\\g )\n/X"'\''
$ json-litex -d '\''"/\n\n\t\\g )\nfoo/X"'\''
json: error: <text>:1:12: filter library: expression error: pcre2 compile: \g is not followed by a braced, angle-bracketed, or quoted name/number or by a plain number
json: error: <text>:1:12: "/\\n\\n\\t\\\\g )\\nfoo/X"
json: error: <text>:1:12:                 ^
command failed: json-litex -d '\''"/\n\n\t\\g )\nfoo/X"'\''
$ json-litex -d '\''"/\n\n\t\\g }/X"'\''
json: error: <text>:1:12: filter library: expression error: pcre2 compile: \g is not followed by a braced, angle-bracketed, or quoted name/number or by a plain number
json: error: <text>:1:12: "/\\n\\n\\t\\\\g }/X"
json: error: <text>:1:12:                 ^
command failed: json-litex -d '\''"/\n\n\t\\g }/X"'\''
$ json-litex -d '\''"/\n\n\t\\g }foo/X"'\''
json: error: <text>:1:12: filter library: expression error: pcre2 compile: \g is not followed by a braced, angle-bracketed, or quoted name/number or by a plain number
json: error: <text>:1:12: "/\\n\\n\\t\\\\g }foo/X"
json: error: <text>:1:12:                 ^
command failed: json-litex -d '\''"/\n\n\t\\g }foo/X"'\''
$ json-litex -d '\''"/\n\n\t\\g }\n/X"'\''
json: error: <text>:1:12: filter library: expression error: pcre2 compile: \g is not followed by a braced, angle-bracketed, or quoted name/number or by a plain number
json: error: <text>:1:12: "/\\n\\n\\t\\\\g }\\n/X"
json: error: <text>:1:12:                 ^
command failed: json-litex -d '\''"/\n\n\t\\g }\n/X"'\''
$ json-litex -d '\''"/\n\n\t\\g }\nfoo/X"'\''
json: error: <text>:1:12: filter library: expression error: pcre2 compile: \g is not followed by a braced, angle-bracketed, or quoted name/number or by a plain number
json: error: <text>:1:12: "/\\n\\n\\t\\\\g }\\nfoo/X"
json: error: <text>:1:12:                 ^
command failed: json-litex -d '\''"/\n\n\t\\g }\nfoo/X"'\''
$ json-litex -d '\''"/\n\n\t\\g</X"'\''
json: error: <text>:1:13: filter library: expression error: pcre2 compile: subpattern name expected
json: error: <text>:1:13: "/\\n\\n\\t\\\\g</X"
json: error: <text>:1:13:                  ^
command failed: json-litex -d '\''"/\n\n\t\\g</X"'\''
$ json-litex -d '\''"/\n\n\t\\g<foo/X"'\''
json: error: <text>:1:16: filter library: expression error: pcre2 compile: syntax error in subpattern name (missing terminator)
json: error: <text>:1:16: "/\\n\\n\\t\\\\g<foo/X"
json: error: <text>:1:16:                     ^
command failed: json-litex -d '\''"/\n\n\t\\g<foo/X"'\''
$ json-litex -d '\''"/\n\n\t\\g<\n/X"'\''
json: error: <text>:1:13: filter library: expression error: pcre2 compile: subpattern name expected
json: error: <text>:1:13: "/\\n\\n\\t\\\\g<\\n/X"
json: error: <text>:1:13:                  ^
command failed: json-litex -d '\''"/\n\n\t\\g<\n/X"'\''
$ json-litex -d '\''"/\n\n\t\\g<\nfoo/X"'\''
json: error: <text>:1:13: filter library: expression error: pcre2 compile: subpattern name expected
json: error: <text>:1:13: "/\\n\\n\\t\\\\g<\\nfoo/X"
json: error: <text>:1:13:                  ^
command failed: json-litex -d '\''"/\n\n\t\\g<\nfoo/X"'\''
$ json-litex -d '\''"/\n\n\t\\g<\t/X"'\''
json: error: <text>:1:13: filter library: expression error: pcre2 compile: subpattern name expected
json: error: <text>:1:13: "/\\n\\n\\t\\\\g<\\t/X"
json: error: <text>:1:13:                  ^
command failed: json-litex -d '\''"/\n\n\t\\g<\t/X"'\''
$ json-litex -d '\''"/\n\n\t\\g<\tfoo/X"'\''
json: error: <text>:1:13: filter library: expression error: pcre2 compile: subpattern name expected
json: error: <text>:1:13: "/\\n\\n\\t\\\\g<\\tfoo/X"
json: error: <text>:1:13:                  ^
command failed: json-litex -d '\''"/\n\n\t\\g<\tfoo/X"'\''
$ json-litex -d '\''"/\n\n\t\\g<\t\n/X"'\''
json: error: <text>:1:13: filter library: expression error: pcre2 compile: subpattern name expected
json: error: <text>:1:13: "/\\n\\n\\t\\\\g<\\t\\n/X"
json: error: <text>:1:13:                  ^
command failed: json-litex -d '\''"/\n\n\t\\g<\t\n/X"'\''
$ json-litex -d '\''"/\n\n\t\\g<\t\nfoo/X"'\''
json: error: <text>:1:13: filter library: expression error: pcre2 compile: subpattern name expected
json: error: <text>:1:13: "/\\n\\n\\t\\\\g<\\t\\nfoo/X"
json: error: <text>:1:13:                  ^
command failed: json-litex -d '\''"/\n\n\t\\g<\t\nfoo/X"'\''
$ json-litex -d '\''"/\n\n\t\\g<>/X"'\''
json: error: <text>:1:13: filter library: expression error: pcre2 compile: subpattern name expected
json: error: <text>:1:13: "/\\n\\n\\t\\\\g<>/X"
json: error: <text>:1:13:                  ^
command failed: json-litex -d '\''"/\n\n\t\\g<>/X"'\''
$ json-litex -d '\''"/\n\n\t\\g<>foo/X"'\''
json: error: <text>:1:13: filter library: expression error: pcre2 compile: subpattern name expected
json: error: <text>:1:13: "/\\n\\n\\t\\\\g<>foo/X"
json: error: <text>:1:13:                  ^
command failed: json-litex -d '\''"/\n\n\t\\g<>foo/X"'\''
$ json-litex -d '\''"/\n\n\t\\g<>\n/X"'\''
json: error: <text>:1:13: filter library: expression error: pcre2 compile: subpattern name expected
json: error: <text>:1:13: "/\\n\\n\\t\\\\g<>\\n/X"
json: error: <text>:1:13:                  ^
command failed: json-litex -d '\''"/\n\n\t\\g<>\n/X"'\''
$ json-litex -d '\''"/\n\n\t\\g<>\nfoo/X"'\''
json: error: <text>:1:13: filter library: expression error: pcre2 compile: subpattern name expected
json: error: <text>:1:13: "/\\n\\n\\t\\\\g<>\\nfoo/X"
json: error: <text>:1:13:                  ^
command failed: json-litex -d '\''"/\n\n\t\\g<>\nfoo/X"'\''
$ json-litex -d '\''"/\n\n\t\\g<)/X"'\''
json: error: <text>:1:13: filter library: expression error: pcre2 compile: subpattern name expected
json: error: <text>:1:13: "/\\n\\n\\t\\\\g<)/X"
json: error: <text>:1:13:                  ^
command failed: json-litex -d '\''"/\n\n\t\\g<)/X"'\''
$ json-litex -d '\''"/\n\n\t\\g<)foo/X"'\''
json: error: <text>:1:13: filter library: expression error: pcre2 compile: subpattern name expected
json: error: <text>:1:13: "/\\n\\n\\t\\\\g<)foo/X"
json: error: <text>:1:13:                  ^
command failed: json-litex -d '\''"/\n\n\t\\g<)foo/X"'\''
$ json-litex -d '\''"/\n\n\t\\g<)\n/X"'\''
json: error: <text>:1:13: filter library: expression error: pcre2 compile: subpattern name expected
json: error: <text>:1:13: "/\\n\\n\\t\\\\g<)\\n/X"
json: error: <text>:1:13:                  ^
command failed: json-litex -d '\''"/\n\n\t\\g<)\n/X"'\''
$ json-litex -d '\''"/\n\n\t\\g<)\nfoo/X"'\''
json: error: <text>:1:13: filter library: expression error: pcre2 compile: subpattern name expected
json: error: <text>:1:13: "/\\n\\n\\t\\\\g<)\\nfoo/X"
json: error: <text>:1:13:                  ^
command failed: json-litex -d '\''"/\n\n\t\\g<)\nfoo/X"'\''
$ json-litex -d '\''"/\n\n\t\\g<}/X"'\''
json: error: <text>:1:13: filter library: expression error: pcre2 compile: subpattern name expected
json: error: <text>:1:13: "/\\n\\n\\t\\\\g<}/X"
json: error: <text>:1:13:                  ^
command failed: json-litex -d '\''"/\n\n\t\\g<}/X"'\''
$ json-litex -d '\''"/\n\n\t\\g<}foo/X"'\''
json: error: <text>:1:13: filter library: expression error: pcre2 compile: subpattern name expected
json: error: <text>:1:13: "/\\n\\n\\t\\\\g<}foo/X"
json: error: <text>:1:13:                  ^
command failed: json-litex -d '\''"/\n\n\t\\g<}foo/X"'\''
$ json-litex -d '\''"/\n\n\t\\g<}\n/X"'\''
json: error: <text>:1:13: filter library: expression error: pcre2 compile: subpattern name expected
json: error: <text>:1:13: "/\\n\\n\\t\\\\g<}\\n/X"
json: error: <text>:1:13:                  ^
command failed: json-litex -d '\''"/\n\n\t\\g<}\n/X"'\''
$ json-litex -d '\''"/\n\n\t\\g<}\nfoo/X"'\''
json: error: <text>:1:13: filter library: expression error: pcre2 compile: subpattern name expected
json: error: <text>:1:13: "/\\n\\n\\t\\\\g<}\\nfoo/X"
json: error: <text>:1:13:                  ^
command failed: json-litex -d '\''"/\n\n\t\\g<}\nfoo/X"'\''
$ json-litex -d '\''"/\n\n\t\\g(/X"'\''
json: error: <text>:1:12: filter library: expression error: pcre2 compile: \g is not followed by a braced, angle-bracketed, or quoted name/number or by a plain number
json: error: <text>:1:12: "/\\n\\n\\t\\\\g(/X"
json: error: <text>:1:12:                 ^
command failed: json-litex -d '\''"/\n\n\t\\g(/X"'\''
$ json-litex -d '\''"/\n\n\t\\g(foo/X"'\''
json: error: <text>:1:12: filter library: expression error: pcre2 compile: \g is not followed by a braced, angle-bracketed, or quoted name/number or by a plain number
json: error: <text>:1:12: "/\\n\\n\\t\\\\g(foo/X"
json: error: <text>:1:12:                 ^
command failed: json-litex -d '\''"/\n\n\t\\g(foo/X"'\''
$ json-litex -d '\''"/\n\n\t\\g(\n/X"'\''
json: error: <text>:1:12: filter library: expression error: pcre2 compile: \g is not followed by a braced, angle-bracketed, or quoted name/number or by a plain number
json: error: <text>:1:12: "/\\n\\n\\t\\\\g(\\n/X"
json: error: <text>:1:12:                 ^
command failed: json-litex -d '\''"/\n\n\t\\g(\n/X"'\''
$ json-litex -d '\''"/\n\n\t\\g(\nfoo/X"'\''
json: error: <text>:1:12: filter library: expression error: pcre2 compile: \g is not followed by a braced, angle-bracketed, or quoted name/number or by a plain number
json: error: <text>:1:12: "/\\n\\n\\t\\\\g(\\nfoo/X"
json: error: <text>:1:12:                 ^
command failed: json-litex -d '\''"/\n\n\t\\g(\nfoo/X"'\''
$ json-litex -d '\''"/\n\n\t\\g(\t/X"'\''
json: error: <text>:1:12: filter library: expression error: pcre2 compile: \g is not followed by a braced, angle-bracketed, or quoted name/number or by a plain number
json: error: <text>:1:12: "/\\n\\n\\t\\\\g(\\t/X"
json: error: <text>:1:12:                 ^
command failed: json-litex -d '\''"/\n\n\t\\g(\t/X"'\''
$ json-litex -d '\''"/\n\n\t\\g(\tfoo/X"'\''
json: error: <text>:1:12: filter library: expression error: pcre2 compile: \g is not followed by a braced, angle-bracketed, or quoted name/number or by a plain number
json: error: <text>:1:12: "/\\n\\n\\t\\\\g(\\tfoo/X"
json: error: <text>:1:12:                 ^
command failed: json-litex -d '\''"/\n\n\t\\g(\tfoo/X"'\''
$ json-litex -d '\''"/\n\n\t\\g(\t\n/X"'\''
json: error: <text>:1:12: filter library: expression error: pcre2 compile: \g is not followed by a braced, angle-bracketed, or quoted name/number or by a plain number
json: error: <text>:1:12: "/\\n\\n\\t\\\\g(\\t\\n/X"
json: error: <text>:1:12:                 ^
command failed: json-litex -d '\''"/\n\n\t\\g(\t\n/X"'\''
$ json-litex -d '\''"/\n\n\t\\g(\t\nfoo/X"'\''
json: error: <text>:1:12: filter library: expression error: pcre2 compile: \g is not followed by a braced, angle-bracketed, or quoted name/number or by a plain number
json: error: <text>:1:12: "/\\n\\n\\t\\\\g(\\t\\nfoo/X"
json: error: <text>:1:12:                 ^
command failed: json-litex -d '\''"/\n\n\t\\g(\t\nfoo/X"'\''
$ json-litex -d '\''"/\n\n\t\\g(>/X"'\''
json: error: <text>:1:12: filter library: expression error: pcre2 compile: \g is not followed by a braced, angle-bracketed, or quoted name/number or by a plain number
json: error: <text>:1:12: "/\\n\\n\\t\\\\g(>/X"
json: error: <text>:1:12:                 ^
command failed: json-litex -d '\''"/\n\n\t\\g(>/X"'\''
$ json-litex -d '\''"/\n\n\t\\g(>foo/X"'\''
json: error: <text>:1:12: filter library: expression error: pcre2 compile: \g is not followed by a braced, angle-bracketed, or quoted name/number or by a plain number
json: error: <text>:1:12: "/\\n\\n\\t\\\\g(>foo/X"
json: error: <text>:1:12:                 ^
command failed: json-litex -d '\''"/\n\n\t\\g(>foo/X"'\''
$ json-litex -d '\''"/\n\n\t\\g(>\n/X"'\''
json: error: <text>:1:12: filter library: expression error: pcre2 compile: \g is not followed by a braced, angle-bracketed, or quoted name/number or by a plain number
json: error: <text>:1:12: "/\\n\\n\\t\\\\g(>\\n/X"
json: error: <text>:1:12:                 ^
command failed: json-litex -d '\''"/\n\n\t\\g(>\n/X"'\''
$ json-litex -d '\''"/\n\n\t\\g(>\nfoo/X"'\''
json: error: <text>:1:12: filter library: expression error: pcre2 compile: \g is not followed by a braced, angle-bracketed, or quoted name/number or by a plain number
json: error: <text>:1:12: "/\\n\\n\\t\\\\g(>\\nfoo/X"
json: error: <text>:1:12:                 ^
command failed: json-litex -d '\''"/\n\n\t\\g(>\nfoo/X"'\''
$ json-litex -d '\''"/\n\n\t\\g()/X"'\''
json: error: <text>:1:12: filter library: expression error: pcre2 compile: \g is not followed by a braced, angle-bracketed, or quoted name/number or by a plain number
json: error: <text>:1:12: "/\\n\\n\\t\\\\g()/X"
json: error: <text>:1:12:                 ^
command failed: json-litex -d '\''"/\n\n\t\\g()/X"'\''
$ json-litex -d '\''"/\n\n\t\\g()foo/X"'\''
json: error: <text>:1:12: filter library: expression error: pcre2 compile: \g is not followed by a braced, angle-bracketed, or quoted name/number or by a plain number
json: error: <text>:1:12: "/\\n\\n\\t\\\\g()foo/X"
json: error: <text>:1:12:                 ^
command failed: json-litex -d '\''"/\n\n\t\\g()foo/X"'\''
$ json-litex -d '\''"/\n\n\t\\g()\n/X"'\''
json: error: <text>:1:12: filter library: expression error: pcre2 compile: \g is not followed by a braced, angle-bracketed, or quoted name/number or by a plain number
json: error: <text>:1:12: "/\\n\\n\\t\\\\g()\\n/X"
json: error: <text>:1:12:                 ^
command failed: json-litex -d '\''"/\n\n\t\\g()\n/X"'\''
$ json-litex -d '\''"/\n\n\t\\g()\nfoo/X"'\''
json: error: <text>:1:12: filter library: expression error: pcre2 compile: \g is not followed by a braced, angle-bracketed, or quoted name/number or by a plain number
json: error: <text>:1:12: "/\\n\\n\\t\\\\g()\\nfoo/X"
json: error: <text>:1:12:                 ^
command failed: json-litex -d '\''"/\n\n\t\\g()\nfoo/X"'\''
$ json-litex -d '\''"/\n\n\t\\g(}/X"'\''
json: error: <text>:1:12: filter library: expression error: pcre2 compile: \g is not followed by a braced, angle-bracketed, or quoted name/number or by a plain number
json: error: <text>:1:12: "/\\n\\n\\t\\\\g(}/X"
json: error: <text>:1:12:                 ^
command failed: json-litex -d '\''"/\n\n\t\\g(}/X"'\''
$ json-litex -d '\''"/\n\n\t\\g(}foo/X"'\''
json: error: <text>:1:12: filter library: expression error: pcre2 compile: \g is not followed by a braced, angle-bracketed, or quoted name/number or by a plain number
json: error: <text>:1:12: "/\\n\\n\\t\\\\g(}foo/X"
json: error: <text>:1:12:                 ^
command failed: json-litex -d '\''"/\n\n\t\\g(}foo/X"'\''
$ json-litex -d '\''"/\n\n\t\\g(}\n/X"'\''
json: error: <text>:1:12: filter library: expression error: pcre2 compile: \g is not followed by a braced, angle-bracketed, or quoted name/number or by a plain number
json: error: <text>:1:12: "/\\n\\n\\t\\\\g(}\\n/X"
json: error: <text>:1:12:                 ^
command failed: json-litex -d '\''"/\n\n\t\\g(}\n/X"'\''
$ json-litex -d '\''"/\n\n\t\\g(}\nfoo/X"'\''
json: error: <text>:1:12: filter library: expression error: pcre2 compile: \g is not followed by a braced, angle-bracketed, or quoted name/number or by a plain number
json: error: <text>:1:12: "/\\n\\n\\t\\\\g(}\\nfoo/X"
json: error: <text>:1:12:                 ^
command failed: json-litex -d '\''"/\n\n\t\\g(}\nfoo/X"'\''
$ json-litex -d '\''"/\n\n\t\\g{/X"'\''
json: error: <text>:1:13: filter library: expression error: pcre2 compile: subpattern name expected
json: error: <text>:1:13: "/\\n\\n\\t\\\\g{/X"
json: error: <text>:1:13:                  ^
command failed: json-litex -d '\''"/\n\n\t\\g{/X"'\''
$ json-litex -d '\''"/\n\n\t\\g{foo/X"'\''
json: error: <text>:1:16: filter library: expression error: pcre2 compile: syntax error in subpattern name (missing terminator)
json: error: <text>:1:16: "/\\n\\n\\t\\\\g{foo/X"
json: error: <text>:1:16:                     ^
command failed: json-litex -d '\''"/\n\n\t\\g{foo/X"'\''
$ json-litex -d '\''"/\n\n\t\\g{\n/X"'\''
json: error: <text>:1:13: filter library: expression error: pcre2 compile: subpattern name expected
json: error: <text>:1:13: "/\\n\\n\\t\\\\g{\\n/X"
json: error: <text>:1:13:                  ^
command failed: json-litex -d '\''"/\n\n\t\\g{\n/X"'\''
$ json-litex -d '\''"/\n\n\t\\g{\nfoo/X"'\''
json: error: <text>:1:13: filter library: expression error: pcre2 compile: subpattern name expected
json: error: <text>:1:13: "/\\n\\n\\t\\\\g{\\nfoo/X"
json: error: <text>:1:13:                  ^
command failed: json-litex -d '\''"/\n\n\t\\g{\nfoo/X"'\''
$ json-litex -d '\''"/\n\n\t\\g{\t/X"'\''
json: error: <text>:1:13: filter library: expression error: pcre2 compile: subpattern name expected
json: error: <text>:1:13: "/\\n\\n\\t\\\\g{\\t/X"
json: error: <text>:1:13:                  ^
command failed: json-litex -d '\''"/\n\n\t\\g{\t/X"'\''
$ json-litex -d '\''"/\n\n\t\\g{\tfoo/X"'\''
json: error: <text>:1:13: filter library: expression error: pcre2 compile: subpattern name expected
json: error: <text>:1:13: "/\\n\\n\\t\\\\g{\\tfoo/X"
json: error: <text>:1:13:                  ^
command failed: json-litex -d '\''"/\n\n\t\\g{\tfoo/X"'\''
$ json-litex -d '\''"/\n\n\t\\g{\t\n/X"'\''
json: error: <text>:1:13: filter library: expression error: pcre2 compile: subpattern name expected
json: error: <text>:1:13: "/\\n\\n\\t\\\\g{\\t\\n/X"
json: error: <text>:1:13:                  ^
command failed: json-litex -d '\''"/\n\n\t\\g{\t\n/X"'\''
$ json-litex -d '\''"/\n\n\t\\g{\t\nfoo/X"'\''
json: error: <text>:1:13: filter library: expression error: pcre2 compile: subpattern name expected
json: error: <text>:1:13: "/\\n\\n\\t\\\\g{\\t\\nfoo/X"
json: error: <text>:1:13:                  ^
command failed: json-litex -d '\''"/\n\n\t\\g{\t\nfoo/X"'\''
$ json-litex -d '\''"/\n\n\t\\g{>/X"'\''
json: error: <text>:1:13: filter library: expression error: pcre2 compile: subpattern name expected
json: error: <text>:1:13: "/\\n\\n\\t\\\\g{>/X"
json: error: <text>:1:13:                  ^
command failed: json-litex -d '\''"/\n\n\t\\g{>/X"'\''
$ json-litex -d '\''"/\n\n\t\\g{>foo/X"'\''
json: error: <text>:1:13: filter library: expression error: pcre2 compile: subpattern name expected
json: error: <text>:1:13: "/\\n\\n\\t\\\\g{>foo/X"
json: error: <text>:1:13:                  ^
command failed: json-litex -d '\''"/\n\n\t\\g{>foo/X"'\''
$ json-litex -d '\''"/\n\n\t\\g{>\n/X"'\''
json: error: <text>:1:13: filter library: expression error: pcre2 compile: subpattern name expected
json: error: <text>:1:13: "/\\n\\n\\t\\\\g{>\\n/X"
json: error: <text>:1:13:                  ^
command failed: json-litex -d '\''"/\n\n\t\\g{>\n/X"'\''
$ json-litex -d '\''"/\n\n\t\\g{>\nfoo/X"'\''
json: error: <text>:1:13: filter library: expression error: pcre2 compile: subpattern name expected
json: error: <text>:1:13: "/\\n\\n\\t\\\\g{>\\nfoo/X"
json: error: <text>:1:13:                  ^
command failed: json-litex -d '\''"/\n\n\t\\g{>\nfoo/X"'\''
$ json-litex -d '\''"/\n\n\t\\g{)/X"'\''
json: error: <text>:1:13: filter library: expression error: pcre2 compile: subpattern name expected
json: error: <text>:1:13: "/\\n\\n\\t\\\\g{)/X"
json: error: <text>:1:13:                  ^
command failed: json-litex -d '\''"/\n\n\t\\g{)/X"'\''
$ json-litex -d '\''"/\n\n\t\\g{)foo/X"'\''
json: error: <text>:1:13: filter library: expression error: pcre2 compile: subpattern name expected
json: error: <text>:1:13: "/\\n\\n\\t\\\\g{)foo/X"
json: error: <text>:1:13:                  ^
command failed: json-litex -d '\''"/\n\n\t\\g{)foo/X"'\''
$ json-litex -d '\''"/\n\n\t\\g{)\n/X"'\''
json: error: <text>:1:13: filter library: expression error: pcre2 compile: subpattern name expected
json: error: <text>:1:13: "/\\n\\n\\t\\\\g{)\\n/X"
json: error: <text>:1:13:                  ^
command failed: json-litex -d '\''"/\n\n\t\\g{)\n/X"'\''
$ json-litex -d '\''"/\n\n\t\\g{)\nfoo/X"'\''
json: error: <text>:1:13: filter library: expression error: pcre2 compile: subpattern name expected
json: error: <text>:1:13: "/\\n\\n\\t\\\\g{)\\nfoo/X"
json: error: <text>:1:13:                  ^
command failed: json-litex -d '\''"/\n\n\t\\g{)\nfoo/X"'\''
$ json-litex -d '\''"/\n\n\t\\g{}/X"'\''
json: error: <text>:1:13: filter library: expression error: pcre2 compile: subpattern name expected
json: error: <text>:1:13: "/\\n\\n\\t\\\\g{}/X"
json: error: <text>:1:13:                  ^
command failed: json-litex -d '\''"/\n\n\t\\g{}/X"'\''
$ json-litex -d '\''"/\n\n\t\\g{}foo/X"'\''
json: error: <text>:1:13: filter library: expression error: pcre2 compile: subpattern name expected
json: error: <text>:1:13: "/\\n\\n\\t\\\\g{}foo/X"
json: error: <text>:1:13:                  ^
command failed: json-litex -d '\''"/\n\n\t\\g{}foo/X"'\''
$ json-litex -d '\''"/\n\n\t\\g{}\n/X"'\''
json: error: <text>:1:13: filter library: expression error: pcre2 compile: subpattern name expected
json: error: <text>:1:13: "/\\n\\n\\t\\\\g{}\\n/X"
json: error: <text>:1:13:                  ^
command failed: json-litex -d '\''"/\n\n\t\\g{}\n/X"'\''
$ json-litex -d '\''"/\n\n\t\\g{}\nfoo/X"'\''
json: error: <text>:1:13: filter library: expression error: pcre2 compile: subpattern name expected
json: error: <text>:1:13: "/\\n\\n\\t\\\\g{}\\nfoo/X"
json: error: <text>:1:13:                  ^
command failed: json-litex -d '\''"/\n\n\t\\g{}\nfoo/X"'\'''
) -L error-pos4.new <(
echo '$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'
[ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib" 2>&1 ||
echo 'command failed: [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'

echo '$ json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -A "$@"|sed -r '\''s/"size":[0-9]+,"bytes":\["[0-9a-f]+"(,"[0-9a-f]+")*\]//;s/("lookup":"0x)[0-9a-f]+(")/\1...\2/g'\''|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }'
json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -A "$@"|sed -r 's/"size":[0-9]+,"bytes":\["[0-9a-f]+"(,"[0-9a-f]+")*\]//;s/("lookup":"0x)[0-9a-f]+(")/\1...\2/g'|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; } 2>&1 ||
echo 'command failed: json-litex() { set -o pipefail && LD_LIBRARY_PATH=../lib:"$JSON_LITEX_TEST_PCRE2_LIB" ../src/json --literal-value -VF -- ../lib/json-litex.so -A "$@"|sed -r '\''s/"size":[0-9]+,"bytes":\["[0-9a-f]+"(,"[0-9a-f]+")*\]//;s/("lookup":"0x)[0-9a-f]+(")/\1...\2/g'\''|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }'

echo '$ json-litex -d '\''"/\n\n\t\\g/X"'\'''
json-litex -d '"/\n\n\t\\g/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\gfoo/X"'\'''
json-litex -d '"/\n\n\t\\gfoo/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\gfoo/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g\n/X"'\'''
json-litex -d '"/\n\n\t\\g\n/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g\n/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g\nfoo/X"'\'''
json-litex -d '"/\n\n\t\\g\nfoo/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g\nfoo/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g\t/X"'\'''
json-litex -d '"/\n\n\t\\g\t/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g\t/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g\tfoo/X"'\'''
json-litex -d '"/\n\n\t\\g\tfoo/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g\tfoo/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g\t\n/X"'\'''
json-litex -d '"/\n\n\t\\g\t\n/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g\t\n/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g\t\nfoo/X"'\'''
json-litex -d '"/\n\n\t\\g\t\nfoo/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g\t\nfoo/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g>/X"'\'''
json-litex -d '"/\n\n\t\\g>/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g>/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g>foo/X"'\'''
json-litex -d '"/\n\n\t\\g>foo/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g>foo/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g>\n/X"'\'''
json-litex -d '"/\n\n\t\\g>\n/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g>\n/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g>\nfoo/X"'\'''
json-litex -d '"/\n\n\t\\g>\nfoo/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g>\nfoo/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g)/X"'\'''
json-litex -d '"/\n\n\t\\g)/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g)/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g)foo/X"'\'''
json-litex -d '"/\n\n\t\\g)foo/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g)foo/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g)\n/X"'\'''
json-litex -d '"/\n\n\t\\g)\n/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g)\n/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g)\nfoo/X"'\'''
json-litex -d '"/\n\n\t\\g)\nfoo/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g)\nfoo/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g}/X"'\'''
json-litex -d '"/\n\n\t\\g}/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g}/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g}foo/X"'\'''
json-litex -d '"/\n\n\t\\g}foo/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g}foo/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g}\n/X"'\'''
json-litex -d '"/\n\n\t\\g}\n/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g}\n/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g}\nfoo/X"'\'''
json-litex -d '"/\n\n\t\\g}\nfoo/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g}\nfoo/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g /X"'\'''
json-litex -d '"/\n\n\t\\g /X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g /X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g foo/X"'\'''
json-litex -d '"/\n\n\t\\g foo/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g foo/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g \n/X"'\'''
json-litex -d '"/\n\n\t\\g \n/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g \n/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g \nfoo/X"'\'''
json-litex -d '"/\n\n\t\\g \nfoo/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g \nfoo/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g \t/X"'\'''
json-litex -d '"/\n\n\t\\g \t/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g \t/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g \tfoo/X"'\'''
json-litex -d '"/\n\n\t\\g \tfoo/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g \tfoo/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g \t\n/X"'\'''
json-litex -d '"/\n\n\t\\g \t\n/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g \t\n/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g \t\nfoo/X"'\'''
json-litex -d '"/\n\n\t\\g \t\nfoo/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g \t\nfoo/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g >/X"'\'''
json-litex -d '"/\n\n\t\\g >/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g >/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g >foo/X"'\'''
json-litex -d '"/\n\n\t\\g >foo/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g >foo/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g >\n/X"'\'''
json-litex -d '"/\n\n\t\\g >\n/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g >\n/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g >\nfoo/X"'\'''
json-litex -d '"/\n\n\t\\g >\nfoo/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g >\nfoo/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g )/X"'\'''
json-litex -d '"/\n\n\t\\g )/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g )/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g )foo/X"'\'''
json-litex -d '"/\n\n\t\\g )foo/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g )foo/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g )\n/X"'\'''
json-litex -d '"/\n\n\t\\g )\n/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g )\n/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g )\nfoo/X"'\'''
json-litex -d '"/\n\n\t\\g )\nfoo/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g )\nfoo/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g }/X"'\'''
json-litex -d '"/\n\n\t\\g }/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g }/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g }foo/X"'\'''
json-litex -d '"/\n\n\t\\g }foo/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g }foo/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g }\n/X"'\'''
json-litex -d '"/\n\n\t\\g }\n/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g }\n/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g }\nfoo/X"'\'''
json-litex -d '"/\n\n\t\\g }\nfoo/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g }\nfoo/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g</X"'\'''
json-litex -d '"/\n\n\t\\g</X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g</X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g<foo/X"'\'''
json-litex -d '"/\n\n\t\\g<foo/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g<foo/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g<\n/X"'\'''
json-litex -d '"/\n\n\t\\g<\n/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g<\n/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g<\nfoo/X"'\'''
json-litex -d '"/\n\n\t\\g<\nfoo/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g<\nfoo/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g<\t/X"'\'''
json-litex -d '"/\n\n\t\\g<\t/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g<\t/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g<\tfoo/X"'\'''
json-litex -d '"/\n\n\t\\g<\tfoo/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g<\tfoo/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g<\t\n/X"'\'''
json-litex -d '"/\n\n\t\\g<\t\n/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g<\t\n/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g<\t\nfoo/X"'\'''
json-litex -d '"/\n\n\t\\g<\t\nfoo/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g<\t\nfoo/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g<>/X"'\'''
json-litex -d '"/\n\n\t\\g<>/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g<>/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g<>foo/X"'\'''
json-litex -d '"/\n\n\t\\g<>foo/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g<>foo/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g<>\n/X"'\'''
json-litex -d '"/\n\n\t\\g<>\n/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g<>\n/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g<>\nfoo/X"'\'''
json-litex -d '"/\n\n\t\\g<>\nfoo/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g<>\nfoo/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g<)/X"'\'''
json-litex -d '"/\n\n\t\\g<)/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g<)/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g<)foo/X"'\'''
json-litex -d '"/\n\n\t\\g<)foo/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g<)foo/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g<)\n/X"'\'''
json-litex -d '"/\n\n\t\\g<)\n/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g<)\n/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g<)\nfoo/X"'\'''
json-litex -d '"/\n\n\t\\g<)\nfoo/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g<)\nfoo/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g<}/X"'\'''
json-litex -d '"/\n\n\t\\g<}/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g<}/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g<}foo/X"'\'''
json-litex -d '"/\n\n\t\\g<}foo/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g<}foo/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g<}\n/X"'\'''
json-litex -d '"/\n\n\t\\g<}\n/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g<}\n/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g<}\nfoo/X"'\'''
json-litex -d '"/\n\n\t\\g<}\nfoo/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g<}\nfoo/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g(/X"'\'''
json-litex -d '"/\n\n\t\\g(/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g(/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g(foo/X"'\'''
json-litex -d '"/\n\n\t\\g(foo/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g(foo/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g(\n/X"'\'''
json-litex -d '"/\n\n\t\\g(\n/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g(\n/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g(\nfoo/X"'\'''
json-litex -d '"/\n\n\t\\g(\nfoo/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g(\nfoo/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g(\t/X"'\'''
json-litex -d '"/\n\n\t\\g(\t/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g(\t/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g(\tfoo/X"'\'''
json-litex -d '"/\n\n\t\\g(\tfoo/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g(\tfoo/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g(\t\n/X"'\'''
json-litex -d '"/\n\n\t\\g(\t\n/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g(\t\n/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g(\t\nfoo/X"'\'''
json-litex -d '"/\n\n\t\\g(\t\nfoo/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g(\t\nfoo/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g(>/X"'\'''
json-litex -d '"/\n\n\t\\g(>/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g(>/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g(>foo/X"'\'''
json-litex -d '"/\n\n\t\\g(>foo/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g(>foo/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g(>\n/X"'\'''
json-litex -d '"/\n\n\t\\g(>\n/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g(>\n/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g(>\nfoo/X"'\'''
json-litex -d '"/\n\n\t\\g(>\nfoo/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g(>\nfoo/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g()/X"'\'''
json-litex -d '"/\n\n\t\\g()/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g()/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g()foo/X"'\'''
json-litex -d '"/\n\n\t\\g()foo/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g()foo/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g()\n/X"'\'''
json-litex -d '"/\n\n\t\\g()\n/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g()\n/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g()\nfoo/X"'\'''
json-litex -d '"/\n\n\t\\g()\nfoo/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g()\nfoo/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g(}/X"'\'''
json-litex -d '"/\n\n\t\\g(}/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g(}/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g(}foo/X"'\'''
json-litex -d '"/\n\n\t\\g(}foo/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g(}foo/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g(}\n/X"'\'''
json-litex -d '"/\n\n\t\\g(}\n/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g(}\n/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g(}\nfoo/X"'\'''
json-litex -d '"/\n\n\t\\g(}\nfoo/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g(}\nfoo/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g{/X"'\'''
json-litex -d '"/\n\n\t\\g{/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g{/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g{foo/X"'\'''
json-litex -d '"/\n\n\t\\g{foo/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g{foo/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g{\n/X"'\'''
json-litex -d '"/\n\n\t\\g{\n/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g{\n/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g{\nfoo/X"'\'''
json-litex -d '"/\n\n\t\\g{\nfoo/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g{\nfoo/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g{\t/X"'\'''
json-litex -d '"/\n\n\t\\g{\t/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g{\t/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g{\tfoo/X"'\'''
json-litex -d '"/\n\n\t\\g{\tfoo/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g{\tfoo/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g{\t\n/X"'\'''
json-litex -d '"/\n\n\t\\g{\t\n/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g{\t\n/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g{\t\nfoo/X"'\'''
json-litex -d '"/\n\n\t\\g{\t\nfoo/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g{\t\nfoo/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g{>/X"'\'''
json-litex -d '"/\n\n\t\\g{>/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g{>/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g{>foo/X"'\'''
json-litex -d '"/\n\n\t\\g{>foo/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g{>foo/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g{>\n/X"'\'''
json-litex -d '"/\n\n\t\\g{>\n/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g{>\n/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g{>\nfoo/X"'\'''
json-litex -d '"/\n\n\t\\g{>\nfoo/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g{>\nfoo/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g{)/X"'\'''
json-litex -d '"/\n\n\t\\g{)/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g{)/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g{)foo/X"'\'''
json-litex -d '"/\n\n\t\\g{)foo/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g{)foo/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g{)\n/X"'\'''
json-litex -d '"/\n\n\t\\g{)\n/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g{)\n/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g{)\nfoo/X"'\'''
json-litex -d '"/\n\n\t\\g{)\nfoo/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g{)\nfoo/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g{}/X"'\'''
json-litex -d '"/\n\n\t\\g{}/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g{}/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g{}foo/X"'\'''
json-litex -d '"/\n\n\t\\g{}foo/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g{}foo/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g{}\n/X"'\'''
json-litex -d '"/\n\n\t\\g{}\n/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g{}\n/X"'\'''

echo '$ json-litex -d '\''"/\n\n\t\\g{}\nfoo/X"'\'''
json-litex -d '"/\n\n\t\\g{}\nfoo/X"' 2>&1 ||
echo 'command failed: json-litex -d '\''"/\n\n\t\\g{}\nfoo/X"'\'''
)

