#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-cases:61
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L 61.old <(echo \
'$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '\''/error:/s|(/dev/fd/)[0-9]+|\1??|'\''; }
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"type":"object","args":[{"name":"foo","type":"object"}]}]},"boolean"]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"boolean"'\'' or `{"type":"array",...}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"type":"object","args":[{"name":"foo","type":"object"}]}]},"boolean"]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"type":"object","args":[{"name":"foo","type":"object"}]}]},"boolean"]}'\'' <<< '\''false'\''
false
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"type":"object","args":[{"name":"foo","type":"object"}]}]},"boolean"]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: []
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"type":"object","args":[{"name":"foo","type":"object"}]}]},"boolean"]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"type":"object","args":[{"name":"foo","type":"object"}]}]},"boolean"]}'\'' <<< '\''[null]'\''
json: error: <stdin>:1:2: type check error: type mismatch: expected a value of type `{"type":"object","args":[...]}'\''
json: error: <stdin>:1:2: [null]
json: error: <stdin>:1:2:  ^
[
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"type":"object","args":[{"name":"foo","type":"object"}]}]},"boolean"]}'\'' <<< '\''[null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"type":"object","args":[{"name":"foo","type":"object"}]}]},"boolean"]}'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:3: type check error: too few arguments
json: error: <stdin>:1:3: [{}]
json: error: <stdin>:1:3:   ^
[{
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"type":"object","args":[{"name":"foo","type":"object"}]}]},"boolean"]}'\'' <<< '\''[{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"type":"object","args":[{"name":"foo","type":"object"}]}]},"boolean"]}'\'' <<< '\''[{"bar":null}]'\''
json: error: <stdin>:1:3: type check error: invalid argument name: expected "foo"
json: error: <stdin>:1:3: [{"bar":null}]
json: error: <stdin>:1:3:   ^
[{
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"type":"object","args":[{"name":"foo","type":"object"}]}]},"boolean"]}'\'' <<< '\''[{"bar":null}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"type":"object","args":[{"name":"foo","type":"object"}]}]},"boolean"]}'\'' <<< '\''[{"foo":null}]'\''
json: error: <stdin>:1:9: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:9: [{"foo":null}]
json: error: <stdin>:1:9:         ^
[{"foo":
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"type":"object","args":[{"name":"foo","type":"object"}]}]},"boolean"]}'\'' <<< '\''[{"foo":null}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"type":"object","args":[{"name":"foo","type":"object"}]}]},"boolean"]}'\'' <<< '\''[{"foo":{}}]'\''
[{"foo":{}}]
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"type":"object","args":[{"name":"foo","type":"object"}]}]},"boolean"]}'\'' <<< '\''[{"foo":{"bar":null}}]'\''
[{"foo":{"bar":null}}]'
) -L 61.new <(
echo '$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '\''/error:/s|(/dev/fd/)[0-9]+|\1??|'\''; }'
json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '/error:/s|(/dev/fd/)[0-9]+|\1??|'; } 2>&1 ||
echo 'command failed: json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '\''/error:/s|(/dev/fd/)[0-9]+|\1??|'\''; }'

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"type":"object","args":[{"name":"foo","type":"object"}]}]},"boolean"]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"type":"object","args":[{"name":"foo","type":"object"}]}]},"boolean"]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"type":"object","args":[{"name":"foo","type":"object"}]}]},"boolean"]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"type":"object","args":[{"name":"foo","type":"object"}]}]},"boolean"]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"type":"object","args":[{"name":"foo","type":"object"}]}]},"boolean"]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"type":"object","args":[{"name":"foo","type":"object"}]}]},"boolean"]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"type":"object","args":[{"name":"foo","type":"object"}]}]},"boolean"]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"type":"object","args":[{"name":"foo","type":"object"}]}]},"boolean"]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"type":"object","args":[{"name":"foo","type":"object"}]}]},"boolean"]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"type":"object","args":[{"name":"foo","type":"object"}]}]},"boolean"]}'\'' <<< '\''[null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"type":"object","args":[{"name":"foo","type":"object"}]}]},"boolean"]}' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"type":"object","args":[{"name":"foo","type":"object"}]}]},"boolean"]}'\'' <<< '\''[null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"type":"object","args":[{"name":"foo","type":"object"}]}]},"boolean"]}'\'' <<< '\''[{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"type":"object","args":[{"name":"foo","type":"object"}]}]},"boolean"]}' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"type":"object","args":[{"name":"foo","type":"object"}]}]},"boolean"]}'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"type":"object","args":[{"name":"foo","type":"object"}]}]},"boolean"]}'\'' <<< '\''[{"bar":null}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"type":"object","args":[{"name":"foo","type":"object"}]}]},"boolean"]}' <<< '[{"bar":null}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"type":"object","args":[{"name":"foo","type":"object"}]}]},"boolean"]}'\'' <<< '\''[{"bar":null}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"type":"object","args":[{"name":"foo","type":"object"}]}]},"boolean"]}'\'' <<< '\''[{"foo":null}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"type":"object","args":[{"name":"foo","type":"object"}]}]},"boolean"]}' <<< '[{"foo":null}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"type":"object","args":[{"name":"foo","type":"object"}]}]},"boolean"]}'\'' <<< '\''[{"foo":null}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"type":"object","args":[{"name":"foo","type":"object"}]}]},"boolean"]}'\'' <<< '\''[{"foo":{}}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"type":"object","args":[{"name":"foo","type":"object"}]}]},"boolean"]}' <<< '[{"foo":{}}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"type":"object","args":[{"name":"foo","type":"object"}]}]},"boolean"]}'\'' <<< '\''[{"foo":{}}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"type":"object","args":[{"name":"foo","type":"object"}]}]},"boolean"]}'\'' <<< '\''[{"foo":{"bar":null}}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"type":"object","args":[{"name":"foo","type":"object"}]}]},"boolean"]}' <<< '[{"foo":{"bar":null}}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"type":"object","args":[{"name":"foo","type":"object"}]}]},"boolean"]}'\'' <<< '\''[{"foo":{"bar":null}}]'\'''
)

