#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-cases:87
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L 87.old <(echo \
'$ json() { set -o pipefail && ../lib/test-gen --dict -V -d1 -k32 -a${2:+e "$2"}|LD_LIBRARY_PATH=../lib ../src/json -EV -t <(../lib/test-gen --dict -T -d1 -k32 -ae "$1"); }
$ json '\''0'\''
{"a":0,"b":1,"c":2,"d":3,"e":4,"f":5,"g":6,"h":7,"i":8,"j":9,"k":10,"l":11,"m":12,"n":13,"o":14,"p":15,"q":16,"r":17,"s":18,"t":19,"u":20,"v":21,"w":22,"x":23,"y":24,"z":25,"ba":26,"bb":27,"bc":28,"bd":29,"be":30,"bf":31}
$ json '\''0'\'' '\''a'\''
{"a":0}
$ json '\''0'\'' '\''bf'\''
{"bf":31}
$ json '\''0'\'' '\''a,bf'\''
{"a":0,"bf":31}
$ json '\''1'\''
{"a":0,"b":1,"c":2,"d":3,"e":4,"f":5,"g":6,"h":7,"i":8,"j":9,"k":10,"l":11,"m":12,"n":13,"o":14,"p":15,"q":16,"r":17,"s":18,"t":19,"u":20,"v":21,"w":22,"x":23,"y":24,"z":25,"ba":26,"bb":27,"bc":28,"bd":29,"be":30,"bf":31}
$ json '\''1'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "ba", "bb", "bc", "bd", "be" and "bf"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''1'\'' '\''a'\''
$ json '\''1'\'' '\''bf'\''
json: error: <stdin>:1:9: type check error: "dict" expression falsified: missing required args: "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "ba", "bb", "bc", "bd" and "be"
json: error: <stdin>:1:9: {"bf":31}
json: error: <stdin>:1:9:         ^
{"bf":31}
command failed: json '\''1'\'' '\''bf'\''
$ json '\''1'\'' '\''a,bf'\''
json: error: <stdin>:1:15: type check error: "dict" expression falsified: missing required args: "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "ba", "bb", "bc", "bd" and "be"
json: error: <stdin>:1:15: {"a":0,"bf":31}
json: error: <stdin>:1:15:               ^
{"a":0,"bf":31}
command failed: json '\''1'\'' '\''a,bf'\''
$ json '\''a'\''
{"a":0,"b":1,"c":2,"d":3,"e":4,"f":5,"g":6,"h":7,"i":8,"j":9,"k":10,"l":11,"m":12,"n":13,"o":14,"p":15,"q":16,"r":17,"s":18,"t":19,"u":20,"v":21,"w":22,"x":23,"y":24,"z":25,"ba":26,"bb":27,"bc":28,"bd":29,"be":30,"bf":31}
$ json '\''a'\'' '\''a'\''
{"a":0}
$ json '\''a'\'' '\''bf'\''
json: error: <stdin>:1:9: type check error: "dict" expression falsified: missing required args: "a"
json: error: <stdin>:1:9: {"bf":31}
json: error: <stdin>:1:9:         ^
{"bf":31}
command failed: json '\''a'\'' '\''bf'\''
$ json '\''a'\'' '\''a,bf'\''
{"a":0,"bf":31}
$ json '\''~a'\''
{"a":0,"b":1,"c":2,"d":3,"e":4,"f":5,"g":6,"h":7,"i":8,"j":9,"k":10,"l":11,"m":12,"n":13,"o":14,"p":15,"q":16,"r":17,"s":18,"t":19,"u":20,"v":21,"w":22,"x":23,"y":24,"z":25,"ba":26,"bb":27,"bc":28,"bd":29,"be":30,"bf":31}
$ json '\''~a'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "ba", "bb", "bc", "bd", "be" and "bf"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a'\'' '\''a'\''
$ json '\''~a'\'' '\''bf'\''
json: error: <stdin>:1:9: type check error: "dict" expression falsified: missing required args: "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "ba", "bb", "bc", "bd" and "be"
json: error: <stdin>:1:9: {"bf":31}
json: error: <stdin>:1:9:         ^
{"bf":31}
command failed: json '\''~a'\'' '\''bf'\''
$ json '\''~a'\'' '\''a,bf'\''
json: error: <stdin>:1:15: type check error: "dict" expression falsified: missing required args: "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "ba", "bb", "bc", "bd" and "be"
json: error: <stdin>:1:15: {"a":0,"bf":31}
json: error: <stdin>:1:15:               ^
{"a":0,"bf":31}
command failed: json '\''~a'\'' '\''a,bf'\''
$ json '\''bf'\''
{"a":0,"b":1,"c":2,"d":3,"e":4,"f":5,"g":6,"h":7,"i":8,"j":9,"k":10,"l":11,"m":12,"n":13,"o":14,"p":15,"q":16,"r":17,"s":18,"t":19,"u":20,"v":21,"w":22,"x":23,"y":24,"z":25,"ba":26,"bb":27,"bc":28,"bd":29,"be":30,"bf":31}
$ json '\''bf'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "bf"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''bf'\'' '\''a'\''
$ json '\''bf'\'' '\''bf'\''
{"bf":31}
$ json '\''bf'\'' '\''a,bf'\''
{"a":0,"bf":31}
$ json '\''~bf'\''
{"a":0,"b":1,"c":2,"d":3,"e":4,"f":5,"g":6,"h":7,"i":8,"j":9,"k":10,"l":11,"m":12,"n":13,"o":14,"p":15,"q":16,"r":17,"s":18,"t":19,"u":20,"v":21,"w":22,"x":23,"y":24,"z":25,"ba":26,"bb":27,"bc":28,"bd":29,"be":30,"bf":31}
$ json '\''~bf'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "ba", "bb", "bc", "bd" and "be"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~bf'\'' '\''a'\''
$ json '\''~bf'\'' '\''bf'\''
json: error: <stdin>:1:9: type check error: "dict" expression falsified: missing required args: "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "ba", "bb", "bc", "bd" and "be"
json: error: <stdin>:1:9: {"bf":31}
json: error: <stdin>:1:9:         ^
{"bf":31}
command failed: json '\''~bf'\'' '\''bf'\''
$ json '\''~bf'\'' '\''a,bf'\''
json: error: <stdin>:1:15: type check error: "dict" expression falsified: missing required args: "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "ba", "bb", "bc", "bd" and "be"
json: error: <stdin>:1:15: {"a":0,"bf":31}
json: error: <stdin>:1:15:               ^
{"a":0,"bf":31}
command failed: json '\''~bf'\'' '\''a,bf'\''
$ json '\''a|bf'\''
{"a":0,"b":1,"c":2,"d":3,"e":4,"f":5,"g":6,"h":7,"i":8,"j":9,"k":10,"l":11,"m":12,"n":13,"o":14,"p":15,"q":16,"r":17,"s":18,"t":19,"u":20,"v":21,"w":22,"x":23,"y":24,"z":25,"ba":26,"bb":27,"bc":28,"bd":29,"be":30,"bf":31}
$ json '\''a|bf'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "bf"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''a|bf'\'' '\''a'\''
$ json '\''a|bf'\'' '\''bf'\''
json: error: <stdin>:1:9: type check error: "dict" expression falsified: missing required args: "a"
json: error: <stdin>:1:9: {"bf":31}
json: error: <stdin>:1:9:         ^
{"bf":31}
command failed: json '\''a|bf'\'' '\''bf'\''
$ json '\''a|bf'\'' '\''a,bf'\''
{"a":0,"bf":31}
$ json '\''~a~bf'\''
{"a":0,"b":1,"c":2,"d":3,"e":4,"f":5,"g":6,"h":7,"i":8,"j":9,"k":10,"l":11,"m":12,"n":13,"o":14,"p":15,"q":16,"r":17,"s":18,"t":19,"u":20,"v":21,"w":22,"x":23,"y":24,"z":25,"ba":26,"bb":27,"bc":28,"bd":29,"be":30,"bf":31}
$ json '\''~a~bf'\'' '\''a'\''
json: error: <stdin>:1:7: type check error: "dict" expression falsified: missing required args: "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "ba", "bb", "bc", "bd" and "be"
json: error: <stdin>:1:7: {"a":0}
json: error: <stdin>:1:7:       ^
{"a":0}
command failed: json '\''~a~bf'\'' '\''a'\''
$ json '\''~a~bf'\'' '\''bf'\''
json: error: <stdin>:1:9: type check error: "dict" expression falsified: missing required args: "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "ba", "bb", "bc", "bd" and "be"
json: error: <stdin>:1:9: {"bf":31}
json: error: <stdin>:1:9:         ^
{"bf":31}
command failed: json '\''~a~bf'\'' '\''bf'\''
$ json '\''~a~bf'\'' '\''a,bf'\''
json: error: <stdin>:1:15: type check error: "dict" expression falsified: missing required args: "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "ba", "bb", "bc", "bd" and "be"
json: error: <stdin>:1:15: {"a":0,"bf":31}
json: error: <stdin>:1:15:               ^
{"a":0,"bf":31}
command failed: json '\''~a~bf'\'' '\''a,bf'\'''
) -L 87.new <(
echo '$ json() { set -o pipefail && ../lib/test-gen --dict -V -d1 -k32 -a${2:+e "$2"}|LD_LIBRARY_PATH=../lib ../src/json -EV -t <(../lib/test-gen --dict -T -d1 -k32 -ae "$1"); }'
json() { set -o pipefail && ../lib/test-gen --dict -V -d1 -k32 -a${2:+e "$2"}|LD_LIBRARY_PATH=../lib ../src/json -EV -t <(../lib/test-gen --dict -T -d1 -k32 -ae "$1"); } 2>&1 ||
echo 'command failed: json() { set -o pipefail && ../lib/test-gen --dict -V -d1 -k32 -a${2:+e "$2"}|LD_LIBRARY_PATH=../lib ../src/json -EV -t <(../lib/test-gen --dict -T -d1 -k32 -ae "$1"); }'

echo '$ json '\''0'\'''
json '0' 2>&1 ||
echo 'command failed: json '\''0'\'''

echo '$ json '\''0'\'' '\''a'\'''
json '0' 'a' 2>&1 ||
echo 'command failed: json '\''0'\'' '\''a'\'''

echo '$ json '\''0'\'' '\''bf'\'''
json '0' 'bf' 2>&1 ||
echo 'command failed: json '\''0'\'' '\''bf'\'''

echo '$ json '\''0'\'' '\''a,bf'\'''
json '0' 'a,bf' 2>&1 ||
echo 'command failed: json '\''0'\'' '\''a,bf'\'''

echo '$ json '\''1'\'''
json '1' 2>&1 ||
echo 'command failed: json '\''1'\'''

echo '$ json '\''1'\'' '\''a'\'''
json '1' 'a' 2>&1 ||
echo 'command failed: json '\''1'\'' '\''a'\'''

echo '$ json '\''1'\'' '\''bf'\'''
json '1' 'bf' 2>&1 ||
echo 'command failed: json '\''1'\'' '\''bf'\'''

echo '$ json '\''1'\'' '\''a,bf'\'''
json '1' 'a,bf' 2>&1 ||
echo 'command failed: json '\''1'\'' '\''a,bf'\'''

echo '$ json '\''a'\'''
json 'a' 2>&1 ||
echo 'command failed: json '\''a'\'''

echo '$ json '\''a'\'' '\''a'\'''
json 'a' 'a' 2>&1 ||
echo 'command failed: json '\''a'\'' '\''a'\'''

echo '$ json '\''a'\'' '\''bf'\'''
json 'a' 'bf' 2>&1 ||
echo 'command failed: json '\''a'\'' '\''bf'\'''

echo '$ json '\''a'\'' '\''a,bf'\'''
json 'a' 'a,bf' 2>&1 ||
echo 'command failed: json '\''a'\'' '\''a,bf'\'''

echo '$ json '\''~a'\'''
json '~a' 2>&1 ||
echo 'command failed: json '\''~a'\'''

echo '$ json '\''~a'\'' '\''a'\'''
json '~a' 'a' 2>&1 ||
echo 'command failed: json '\''~a'\'' '\''a'\'''

echo '$ json '\''~a'\'' '\''bf'\'''
json '~a' 'bf' 2>&1 ||
echo 'command failed: json '\''~a'\'' '\''bf'\'''

echo '$ json '\''~a'\'' '\''a,bf'\'''
json '~a' 'a,bf' 2>&1 ||
echo 'command failed: json '\''~a'\'' '\''a,bf'\'''

echo '$ json '\''bf'\'''
json 'bf' 2>&1 ||
echo 'command failed: json '\''bf'\'''

echo '$ json '\''bf'\'' '\''a'\'''
json 'bf' 'a' 2>&1 ||
echo 'command failed: json '\''bf'\'' '\''a'\'''

echo '$ json '\''bf'\'' '\''bf'\'''
json 'bf' 'bf' 2>&1 ||
echo 'command failed: json '\''bf'\'' '\''bf'\'''

echo '$ json '\''bf'\'' '\''a,bf'\'''
json 'bf' 'a,bf' 2>&1 ||
echo 'command failed: json '\''bf'\'' '\''a,bf'\'''

echo '$ json '\''~bf'\'''
json '~bf' 2>&1 ||
echo 'command failed: json '\''~bf'\'''

echo '$ json '\''~bf'\'' '\''a'\'''
json '~bf' 'a' 2>&1 ||
echo 'command failed: json '\''~bf'\'' '\''a'\'''

echo '$ json '\''~bf'\'' '\''bf'\'''
json '~bf' 'bf' 2>&1 ||
echo 'command failed: json '\''~bf'\'' '\''bf'\'''

echo '$ json '\''~bf'\'' '\''a,bf'\'''
json '~bf' 'a,bf' 2>&1 ||
echo 'command failed: json '\''~bf'\'' '\''a,bf'\'''

echo '$ json '\''a|bf'\'''
json 'a|bf' 2>&1 ||
echo 'command failed: json '\''a|bf'\'''

echo '$ json '\''a|bf'\'' '\''a'\'''
json 'a|bf' 'a' 2>&1 ||
echo 'command failed: json '\''a|bf'\'' '\''a'\'''

echo '$ json '\''a|bf'\'' '\''bf'\'''
json 'a|bf' 'bf' 2>&1 ||
echo 'command failed: json '\''a|bf'\'' '\''bf'\'''

echo '$ json '\''a|bf'\'' '\''a,bf'\'''
json 'a|bf' 'a,bf' 2>&1 ||
echo 'command failed: json '\''a|bf'\'' '\''a,bf'\'''

echo '$ json '\''~a~bf'\'''
json '~a~bf' 2>&1 ||
echo 'command failed: json '\''~a~bf'\'''

echo '$ json '\''~a~bf'\'' '\''a'\'''
json '~a~bf' 'a' 2>&1 ||
echo 'command failed: json '\''~a~bf'\'' '\''a'\'''

echo '$ json '\''~a~bf'\'' '\''bf'\'''
json '~a~bf' 'bf' 2>&1 ||
echo 'command failed: json '\''~a~bf'\'' '\''bf'\'''

echo '$ json '\''~a~bf'\'' '\''a,bf'\'''
json '~a~bf' 'a,bf' 2>&1 ||
echo 'command failed: json '\''~a~bf'\'' '\''a,bf'\'''
)

