#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-cases:88
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L 88.old <(echo \
'$ json() { LD_LIBRARY_PATH=../lib ../src/json --verbose "$@" <<< '\'''\''; }
$ json -d '\''"boolean"'\'' -nfoo
json: error: <text>: type lib error: library error: type name '\''foo'\'' not available
command failed: json -d '\''"boolean"'\'' -nfoo
$ json -d '\''[{"name":"foo","type":"boolean"}]'\'' -nbar
json: error: <text>: type lib error: library error: type def '\''bar'\'' not found
command failed: json -d '\''[{"name":"foo","type":"boolean"}]'\'' -nbar
$ json -d '\''[{"name":"foo","type":"boolean"}]'\'' -n
json: error: <text>: type lib error: library error: type name not specified
command failed: json -d '\''[{"name":"foo","type":"boolean"}]'\'' -n
$ json -d '\''[{"name":"foo","type":"boolean"}]'\''
json: error: <text>: type lib error: library error: type name not specified
command failed: json -d '\''[{"name":"foo","type":"boolean"}]'\'''
) -L 88.new <(
echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --verbose "$@" <<< '\'''\''; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --verbose "$@" <<< ''; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --verbose "$@" <<< '\'''\''; }'

echo '$ json -d '\''"boolean"'\'' -nfoo'
json -d '"boolean"' -nfoo 2>&1 ||
echo 'command failed: json -d '\''"boolean"'\'' -nfoo'

echo '$ json -d '\''[{"name":"foo","type":"boolean"}]'\'' -nbar'
json -d '[{"name":"foo","type":"boolean"}]' -nbar 2>&1 ||
echo 'command failed: json -d '\''[{"name":"foo","type":"boolean"}]'\'' -nbar'

echo '$ json -d '\''[{"name":"foo","type":"boolean"}]'\'' -n'
json -d '[{"name":"foo","type":"boolean"}]' -n 2>&1 ||
echo 'command failed: json -d '\''[{"name":"foo","type":"boolean"}]'\'' -n'

echo '$ json -d '\''[{"name":"foo","type":"boolean"}]'\'''
json -d '[{"name":"foo","type":"boolean"}]' 2>&1 ||
echo 'command failed: json -d '\''[{"name":"foo","type":"boolean"}]'\'''
)

