#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker-list:list-closed-array-plain-plain-val-array-basic-basic
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L list-closed-array-plain-plain-val-array-basic-basic.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''[null,null]'\''
[null,null]
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''[null,false]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:7: [null,false]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''[null,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''[null,true]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:7: [null,true]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''[null,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''[null,123]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:7: [null,123]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''[null,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''[null,456]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:7: [null,456]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''[null,456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''[null,"foo"]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:7: [null,"foo"]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''[null,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''[null,"bar"]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:7: [null,"bar"]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''[null,"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''[null,{}]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:7: [null,{}]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''[null,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''[null,[]]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:7: [null,[]]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''[null,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:7: [null,null]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''[null,false]'\''
[null,false]
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''[null,true]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:7: [null,true]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''[null,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''[null,123]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:7: [null,123]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''[null,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''[null,456]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:7: [null,456]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''[null,456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''[null,"foo"]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:7: [null,"foo"]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''[null,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''[null,"bar"]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:7: [null,"bar"]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''[null,"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''[null,{}]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:7: [null,{}]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''[null,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''[null,[]]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:7: [null,[]]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''[null,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:7: [null,null]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''[null,false]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:7: [null,false]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''[null,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''[null,true]'\''
[null,true]
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''[null,123]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:7: [null,123]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''[null,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''[null,456]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:7: [null,456]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''[null,456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''[null,"foo"]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:7: [null,"foo"]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''[null,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''[null,"bar"]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:7: [null,"bar"]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''[null,"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''[null,{}]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:7: [null,{}]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''[null,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''[null,[]]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:7: [null,[]]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''[null,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":456}'\''
json: error: <stdin>:1:7: [null,null]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''[null,false]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":456}'\''
json: error: <stdin>:1:7: [null,false]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''[null,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''[null,true]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":456}'\''
json: error: <stdin>:1:7: [null,true]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''[null,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''[null,123]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":456}'\''
json: error: <stdin>:1:7: [null,123]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''[null,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''[null,456]'\''
[null,456]
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''[null,"foo"]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":456}'\''
json: error: <stdin>:1:7: [null,"foo"]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''[null,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''[null,"bar"]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":456}'\''
json: error: <stdin>:1:7: [null,"bar"]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''[null,"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''[null,{}]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":456}'\''
json: error: <stdin>:1:7: [null,{}]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''[null,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''[null,[]]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":456}'\''
json: error: <stdin>:1:7: [null,[]]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''[null,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''[null,null]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":"bar"}'\''
json: error: <stdin>:1:7: [null,null]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''[null,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''[null,false]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":"bar"}'\''
json: error: <stdin>:1:7: [null,false]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''[null,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''[null,true]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":"bar"}'\''
json: error: <stdin>:1:7: [null,true]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''[null,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''[null,123]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":"bar"}'\''
json: error: <stdin>:1:7: [null,123]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''[null,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''[null,456]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":"bar"}'\''
json: error: <stdin>:1:7: [null,456]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''[null,456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''[null,"foo"]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":"bar"}'\''
json: error: <stdin>:1:7: [null,"foo"]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''[null,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''[null,"bar"]'\''
[null,"bar"]
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''[null,{}]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":"bar"}'\''
json: error: <stdin>:1:7: [null,{}]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''[null,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''[null,[]]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":"bar"}'\''
json: error: <stdin>:1:7: [null,[]]
json: error: <stdin>:1:7:       ^
[null,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''[null,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''[false,null]'\''
[false,null]
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''[false,false]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: [false,false]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''[false,true]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: [false,true]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''[false,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''[false,123]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: [false,123]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''[false,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''[false,456]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: [false,456]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''[false,456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''[false,"foo"]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: [false,"foo"]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''[false,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''[false,"bar"]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: [false,"bar"]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''[false,"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''[false,{}]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: [false,{}]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''[false,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''[false,[]]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: [false,[]]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''[false,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''[false,null]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: [false,null]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''[false,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''[false,false]'\''
[false,false]
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''[false,true]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: [false,true]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''[false,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''[false,123]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: [false,123]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''[false,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''[false,456]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: [false,456]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''[false,456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''[false,"foo"]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: [false,"foo"]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''[false,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''[false,"bar"]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: [false,"bar"]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''[false,"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''[false,{}]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: [false,{}]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''[false,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''[false,[]]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: [false,[]]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''[false,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''[false,null]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: [false,null]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''[false,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''[false,false]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: [false,false]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''[false,true]'\''
[false,true]
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''[false,123]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: [false,123]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''[false,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''[false,456]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: [false,456]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''[false,456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''[false,"foo"]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: [false,"foo"]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''[false,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''[false,"bar"]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: [false,"bar"]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''[false,"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''[false,{}]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: [false,{}]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''[false,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''[false,[]]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: [false,[]]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''[false,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''[false,null]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":456}'\''
json: error: <stdin>:1:8: [false,null]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''[false,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''[false,false]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":456}'\''
json: error: <stdin>:1:8: [false,false]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''[false,true]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":456}'\''
json: error: <stdin>:1:8: [false,true]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''[false,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''[false,123]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":456}'\''
json: error: <stdin>:1:8: [false,123]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''[false,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''[false,456]'\''
[false,456]
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''[false,"foo"]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":456}'\''
json: error: <stdin>:1:8: [false,"foo"]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''[false,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''[false,"bar"]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":456}'\''
json: error: <stdin>:1:8: [false,"bar"]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''[false,"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''[false,{}]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":456}'\''
json: error: <stdin>:1:8: [false,{}]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''[false,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''[false,[]]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":456}'\''
json: error: <stdin>:1:8: [false,[]]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''[false,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''[false,null]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"bar"}'\''
json: error: <stdin>:1:8: [false,null]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''[false,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''[false,false]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"bar"}'\''
json: error: <stdin>:1:8: [false,false]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''[false,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''[false,true]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"bar"}'\''
json: error: <stdin>:1:8: [false,true]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''[false,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''[false,123]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"bar"}'\''
json: error: <stdin>:1:8: [false,123]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''[false,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''[false,456]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"bar"}'\''
json: error: <stdin>:1:8: [false,456]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''[false,456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''[false,"foo"]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"bar"}'\''
json: error: <stdin>:1:8: [false,"foo"]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''[false,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''[false,"bar"]'\''
[false,"bar"]
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''[false,{}]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"bar"}'\''
json: error: <stdin>:1:8: [false,{}]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''[false,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''[false,[]]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"bar"}'\''
json: error: <stdin>:1:8: [false,[]]
json: error: <stdin>:1:8:        ^
[false,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''[false,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''[true,null]'\''
[true,null]
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''[true,false]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:7: [true,false]
json: error: <stdin>:1:7:       ^
[true,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''[true,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''[true,true]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:7: [true,true]
json: error: <stdin>:1:7:       ^
[true,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''[true,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''[true,123]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:7: [true,123]
json: error: <stdin>:1:7:       ^
[true,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''[true,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''[true,456]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:7: [true,456]
json: error: <stdin>:1:7:       ^
[true,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''[true,456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''[true,"foo"]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:7: [true,"foo"]
json: error: <stdin>:1:7:       ^
[true,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''[true,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''[true,"bar"]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:7: [true,"bar"]
json: error: <stdin>:1:7:       ^
[true,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''[true,"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''[true,{}]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:7: [true,{}]
json: error: <stdin>:1:7:       ^
[true,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''[true,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''[true,[]]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:7: [true,[]]
json: error: <stdin>:1:7:       ^
[true,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''[true,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''[true,null]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:7: [true,null]
json: error: <stdin>:1:7:       ^
[true,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''[true,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''[true,false]'\''
[true,false]
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''[true,true]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:7: [true,true]
json: error: <stdin>:1:7:       ^
[true,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''[true,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''[true,123]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:7: [true,123]
json: error: <stdin>:1:7:       ^
[true,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''[true,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''[true,456]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:7: [true,456]
json: error: <stdin>:1:7:       ^
[true,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''[true,456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''[true,"foo"]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:7: [true,"foo"]
json: error: <stdin>:1:7:       ^
[true,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''[true,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''[true,"bar"]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:7: [true,"bar"]
json: error: <stdin>:1:7:       ^
[true,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''[true,"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''[true,{}]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:7: [true,{}]
json: error: <stdin>:1:7:       ^
[true,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''[true,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''[true,[]]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:7: [true,[]]
json: error: <stdin>:1:7:       ^
[true,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''[true,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''[true,null]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:7: [true,null]
json: error: <stdin>:1:7:       ^
[true,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''[true,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''[true,false]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:7: [true,false]
json: error: <stdin>:1:7:       ^
[true,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''[true,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''[true,true]'\''
[true,true]
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''[true,123]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:7: [true,123]
json: error: <stdin>:1:7:       ^
[true,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''[true,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''[true,456]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:7: [true,456]
json: error: <stdin>:1:7:       ^
[true,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''[true,456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''[true,"foo"]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:7: [true,"foo"]
json: error: <stdin>:1:7:       ^
[true,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''[true,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''[true,"bar"]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:7: [true,"bar"]
json: error: <stdin>:1:7:       ^
[true,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''[true,"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''[true,{}]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:7: [true,{}]
json: error: <stdin>:1:7:       ^
[true,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''[true,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''[true,[]]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:7: [true,[]]
json: error: <stdin>:1:7:       ^
[true,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''[true,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''[true,null]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":456}'\''
json: error: <stdin>:1:7: [true,null]
json: error: <stdin>:1:7:       ^
[true,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''[true,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''[true,false]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":456}'\''
json: error: <stdin>:1:7: [true,false]
json: error: <stdin>:1:7:       ^
[true,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''[true,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''[true,true]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":456}'\''
json: error: <stdin>:1:7: [true,true]
json: error: <stdin>:1:7:       ^
[true,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''[true,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''[true,123]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":456}'\''
json: error: <stdin>:1:7: [true,123]
json: error: <stdin>:1:7:       ^
[true,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''[true,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''[true,456]'\''
[true,456]
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''[true,"foo"]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":456}'\''
json: error: <stdin>:1:7: [true,"foo"]
json: error: <stdin>:1:7:       ^
[true,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''[true,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''[true,"bar"]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":456}'\''
json: error: <stdin>:1:7: [true,"bar"]
json: error: <stdin>:1:7:       ^
[true,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''[true,"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''[true,{}]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":456}'\''
json: error: <stdin>:1:7: [true,{}]
json: error: <stdin>:1:7:       ^
[true,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''[true,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''[true,[]]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":456}'\''
json: error: <stdin>:1:7: [true,[]]
json: error: <stdin>:1:7:       ^
[true,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''[true,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''[true,null]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":"bar"}'\''
json: error: <stdin>:1:7: [true,null]
json: error: <stdin>:1:7:       ^
[true,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''[true,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''[true,false]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":"bar"}'\''
json: error: <stdin>:1:7: [true,false]
json: error: <stdin>:1:7:       ^
[true,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''[true,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''[true,true]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":"bar"}'\''
json: error: <stdin>:1:7: [true,true]
json: error: <stdin>:1:7:       ^
[true,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''[true,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''[true,123]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":"bar"}'\''
json: error: <stdin>:1:7: [true,123]
json: error: <stdin>:1:7:       ^
[true,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''[true,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''[true,456]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":"bar"}'\''
json: error: <stdin>:1:7: [true,456]
json: error: <stdin>:1:7:       ^
[true,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''[true,456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''[true,"foo"]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":"bar"}'\''
json: error: <stdin>:1:7: [true,"foo"]
json: error: <stdin>:1:7:       ^
[true,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''[true,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''[true,"bar"]'\''
[true,"bar"]
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''[true,{}]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":"bar"}'\''
json: error: <stdin>:1:7: [true,{}]
json: error: <stdin>:1:7:       ^
[true,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''[true,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''[true,[]]'\''
json: error: <stdin>:1:7: type check error: type mismatch: expected a value of type `{"plain":"bar"}'\''
json: error: <stdin>:1:7: [true,[]]
json: error: <stdin>:1:7:       ^
[true,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''[true,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''[123,null]'\''
[123,null]
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''[123,false]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:6: [123,false]
json: error: <stdin>:1:6:      ^
[123,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''[123,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''[123,true]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:6: [123,true]
json: error: <stdin>:1:6:      ^
[123,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''[123,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''[123,123]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:6: [123,123]
json: error: <stdin>:1:6:      ^
[123,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''[123,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''[123,456]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:6: [123,456]
json: error: <stdin>:1:6:      ^
[123,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''[123,456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''[123,"foo"]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:6: [123,"foo"]
json: error: <stdin>:1:6:      ^
[123,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''[123,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''[123,"bar"]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:6: [123,"bar"]
json: error: <stdin>:1:6:      ^
[123,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''[123,"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''[123,{}]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:6: [123,{}]
json: error: <stdin>:1:6:      ^
[123,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''[123,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''[123,[]]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:6: [123,[]]
json: error: <stdin>:1:6:      ^
[123,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''[123,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''[123,null]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:6: [123,null]
json: error: <stdin>:1:6:      ^
[123,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''[123,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''[123,false]'\''
[123,false]
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''[123,true]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:6: [123,true]
json: error: <stdin>:1:6:      ^
[123,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''[123,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''[123,123]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:6: [123,123]
json: error: <stdin>:1:6:      ^
[123,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''[123,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''[123,456]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:6: [123,456]
json: error: <stdin>:1:6:      ^
[123,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''[123,456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''[123,"foo"]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:6: [123,"foo"]
json: error: <stdin>:1:6:      ^
[123,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''[123,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''[123,"bar"]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:6: [123,"bar"]
json: error: <stdin>:1:6:      ^
[123,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''[123,"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''[123,{}]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:6: [123,{}]
json: error: <stdin>:1:6:      ^
[123,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''[123,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''[123,[]]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:6: [123,[]]
json: error: <stdin>:1:6:      ^
[123,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''[123,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''[123,null]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:6: [123,null]
json: error: <stdin>:1:6:      ^
[123,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''[123,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''[123,false]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:6: [123,false]
json: error: <stdin>:1:6:      ^
[123,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''[123,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''[123,true]'\''
[123,true]
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''[123,123]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:6: [123,123]
json: error: <stdin>:1:6:      ^
[123,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''[123,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''[123,456]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:6: [123,456]
json: error: <stdin>:1:6:      ^
[123,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''[123,456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''[123,"foo"]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:6: [123,"foo"]
json: error: <stdin>:1:6:      ^
[123,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''[123,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''[123,"bar"]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:6: [123,"bar"]
json: error: <stdin>:1:6:      ^
[123,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''[123,"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''[123,{}]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:6: [123,{}]
json: error: <stdin>:1:6:      ^
[123,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''[123,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''[123,[]]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:6: [123,[]]
json: error: <stdin>:1:6:      ^
[123,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''[123,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''[123,null]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":456}'\''
json: error: <stdin>:1:6: [123,null]
json: error: <stdin>:1:6:      ^
[123,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''[123,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''[123,false]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":456}'\''
json: error: <stdin>:1:6: [123,false]
json: error: <stdin>:1:6:      ^
[123,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''[123,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''[123,true]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":456}'\''
json: error: <stdin>:1:6: [123,true]
json: error: <stdin>:1:6:      ^
[123,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''[123,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''[123,123]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":456}'\''
json: error: <stdin>:1:6: [123,123]
json: error: <stdin>:1:6:      ^
[123,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''[123,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''[123,456]'\''
[123,456]
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''[123,"foo"]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":456}'\''
json: error: <stdin>:1:6: [123,"foo"]
json: error: <stdin>:1:6:      ^
[123,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''[123,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''[123,"bar"]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":456}'\''
json: error: <stdin>:1:6: [123,"bar"]
json: error: <stdin>:1:6:      ^
[123,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''[123,"bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''[123,{}]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":456}'\''
json: error: <stdin>:1:6: [123,{}]
json: error: <stdin>:1:6:      ^
[123,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''[123,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''[123,[]]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":456}'\''
json: error: <stdin>:1:6: [123,[]]
json: error: <stdin>:1:6:      ^
[123,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''[123,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''[123,null]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":"bar"}'\''
json: error: <stdin>:1:6: [123,null]
json: error: <stdin>:1:6:      ^
[123,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''[123,null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''[123,false]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":"bar"}'\''
json: error: <stdin>:1:6: [123,false]
json: error: <stdin>:1:6:      ^
[123,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''[123,false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''[123,true]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":"bar"}'\''
json: error: <stdin>:1:6: [123,true]
json: error: <stdin>:1:6:      ^
[123,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''[123,true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''[123,123]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":"bar"}'\''
json: error: <stdin>:1:6: [123,123]
json: error: <stdin>:1:6:      ^
[123,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''[123,123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''[123,456]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":"bar"}'\''
json: error: <stdin>:1:6: [123,456]
json: error: <stdin>:1:6:      ^
[123,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''[123,456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''[123,"foo"]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":"bar"}'\''
json: error: <stdin>:1:6: [123,"foo"]
json: error: <stdin>:1:6:      ^
[123,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''[123,"foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''[123,"bar"]'\''
[123,"bar"]
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''[123,{}]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":"bar"}'\''
json: error: <stdin>:1:6: [123,{}]
json: error: <stdin>:1:6:      ^
[123,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''[123,{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''[123,[]]'\''
json: error: <stdin>:1:6: type check error: type mismatch: expected a value of type `{"plain":"bar"}'\''
json: error: <stdin>:1:6: [123,[]]
json: error: <stdin>:1:6:      ^
[123,
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''[123,[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''["foo",null]'\''
["foo",null]
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''["foo",false]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: ["foo",false]
json: error: <stdin>:1:8:        ^
["foo",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''["foo",false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''["foo",true]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: ["foo",true]
json: error: <stdin>:1:8:        ^
["foo",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''["foo",true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''["foo",123]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: ["foo",123]
json: error: <stdin>:1:8:        ^
["foo",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''["foo",123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''["foo",456]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: ["foo",456]
json: error: <stdin>:1:8:        ^
["foo",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''["foo",456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''["foo","foo"]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: ["foo","foo"]
json: error: <stdin>:1:8:        ^
["foo",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''["foo","foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''["foo","bar"]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: ["foo","bar"]
json: error: <stdin>:1:8:        ^
["foo",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''["foo","bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''["foo",{}]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: ["foo",{}]
json: error: <stdin>:1:8:        ^
["foo",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''["foo",{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''["foo",[]]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":null}'\''
json: error: <stdin>:1:8: ["foo",[]]
json: error: <stdin>:1:8:        ^
["foo",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''["foo",[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''["foo",null]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: ["foo",null]
json: error: <stdin>:1:8:        ^
["foo",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''["foo",null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''["foo",false]'\''
["foo",false]
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''["foo",true]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: ["foo",true]
json: error: <stdin>:1:8:        ^
["foo",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''["foo",true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''["foo",123]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: ["foo",123]
json: error: <stdin>:1:8:        ^
["foo",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''["foo",123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''["foo",456]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: ["foo",456]
json: error: <stdin>:1:8:        ^
["foo",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''["foo",456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''["foo","foo"]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: ["foo","foo"]
json: error: <stdin>:1:8:        ^
["foo",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''["foo","foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''["foo","bar"]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: ["foo","bar"]
json: error: <stdin>:1:8:        ^
["foo",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''["foo","bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''["foo",{}]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: ["foo",{}]
json: error: <stdin>:1:8:        ^
["foo",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''["foo",{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''["foo",[]]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":false}'\''
json: error: <stdin>:1:8: ["foo",[]]
json: error: <stdin>:1:8:        ^
["foo",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''["foo",[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''["foo",null]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: ["foo",null]
json: error: <stdin>:1:8:        ^
["foo",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''["foo",null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''["foo",false]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: ["foo",false]
json: error: <stdin>:1:8:        ^
["foo",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''["foo",false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''["foo",true]'\''
["foo",true]
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''["foo",123]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: ["foo",123]
json: error: <stdin>:1:8:        ^
["foo",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''["foo",123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''["foo",456]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: ["foo",456]
json: error: <stdin>:1:8:        ^
["foo",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''["foo",456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''["foo","foo"]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: ["foo","foo"]
json: error: <stdin>:1:8:        ^
["foo",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''["foo","foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''["foo","bar"]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: ["foo","bar"]
json: error: <stdin>:1:8:        ^
["foo",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''["foo","bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''["foo",{}]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: ["foo",{}]
json: error: <stdin>:1:8:        ^
["foo",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''["foo",{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''["foo",[]]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":true}'\''
json: error: <stdin>:1:8: ["foo",[]]
json: error: <stdin>:1:8:        ^
["foo",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''["foo",[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''["foo",null]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":456}'\''
json: error: <stdin>:1:8: ["foo",null]
json: error: <stdin>:1:8:        ^
["foo",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''["foo",null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''["foo",false]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":456}'\''
json: error: <stdin>:1:8: ["foo",false]
json: error: <stdin>:1:8:        ^
["foo",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''["foo",false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''["foo",true]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":456}'\''
json: error: <stdin>:1:8: ["foo",true]
json: error: <stdin>:1:8:        ^
["foo",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''["foo",true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''["foo",123]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":456}'\''
json: error: <stdin>:1:8: ["foo",123]
json: error: <stdin>:1:8:        ^
["foo",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''["foo",123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''["foo",456]'\''
["foo",456]
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''["foo","foo"]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":456}'\''
json: error: <stdin>:1:8: ["foo","foo"]
json: error: <stdin>:1:8:        ^
["foo",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''["foo","foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''["foo","bar"]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":456}'\''
json: error: <stdin>:1:8: ["foo","bar"]
json: error: <stdin>:1:8:        ^
["foo",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''["foo","bar"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''["foo",{}]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":456}'\''
json: error: <stdin>:1:8: ["foo",{}]
json: error: <stdin>:1:8:        ^
["foo",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''["foo",{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''["foo",[]]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":456}'\''
json: error: <stdin>:1:8: ["foo",[]]
json: error: <stdin>:1:8:        ^
["foo",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''["foo",[]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''["foo",null]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"bar"}'\''
json: error: <stdin>:1:8: ["foo",null]
json: error: <stdin>:1:8:        ^
["foo",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''["foo",null]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''["foo",false]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"bar"}'\''
json: error: <stdin>:1:8: ["foo",false]
json: error: <stdin>:1:8:        ^
["foo",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''["foo",false]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''["foo",true]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"bar"}'\''
json: error: <stdin>:1:8: ["foo",true]
json: error: <stdin>:1:8:        ^
["foo",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''["foo",true]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''["foo",123]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"bar"}'\''
json: error: <stdin>:1:8: ["foo",123]
json: error: <stdin>:1:8:        ^
["foo",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''["foo",123]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''["foo",456]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"bar"}'\''
json: error: <stdin>:1:8: ["foo",456]
json: error: <stdin>:1:8:        ^
["foo",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''["foo",456]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''["foo","foo"]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"bar"}'\''
json: error: <stdin>:1:8: ["foo","foo"]
json: error: <stdin>:1:8:        ^
["foo",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''["foo","foo"]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''["foo","bar"]'\''
["foo","bar"]
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''["foo",{}]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"bar"}'\''
json: error: <stdin>:1:8: ["foo",{}]
json: error: <stdin>:1:8:        ^
["foo",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''["foo",{}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''["foo",[]]'\''
json: error: <stdin>:1:8: type check error: type mismatch: expected a value of type `{"plain":"bar"}'\''
json: error: <stdin>:1:8: ["foo",[]]
json: error: <stdin>:1:8:        ^
["foo",
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''["foo",[]]'\'''
) -L list-closed-array-plain-plain-val-array-basic-basic.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''[null,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}' <<< '[null,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''[null,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''[null,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}' <<< '[null,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''[null,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''[null,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}' <<< '[null,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''[null,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''[null,456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}' <<< '[null,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''[null,456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''[null,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}' <<< '[null,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''[null,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''[null,"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}' <<< '[null,"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''[null,"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''[null,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}' <<< '[null,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''[null,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''[null,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}' <<< '[null,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":null}]}]}'\'' <<< '\''[null,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''[null,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}' <<< '[null,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''[null,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''[null,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}' <<< '[null,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''[null,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''[null,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}' <<< '[null,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''[null,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''[null,456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}' <<< '[null,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''[null,456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''[null,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}' <<< '[null,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''[null,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''[null,"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}' <<< '[null,"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''[null,"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''[null,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}' <<< '[null,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''[null,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''[null,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}' <<< '[null,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":false}]}]}'\'' <<< '\''[null,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''[null,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}' <<< '[null,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''[null,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''[null,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}' <<< '[null,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''[null,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''[null,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}' <<< '[null,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''[null,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''[null,456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}' <<< '[null,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''[null,456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''[null,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}' <<< '[null,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''[null,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''[null,"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}' <<< '[null,"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''[null,"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''[null,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}' <<< '[null,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''[null,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''[null,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}' <<< '[null,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":true}]}]}'\'' <<< '\''[null,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''[null,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}' <<< '[null,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''[null,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''[null,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}' <<< '[null,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''[null,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''[null,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}' <<< '[null,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''[null,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''[null,456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}' <<< '[null,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''[null,456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''[null,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}' <<< '[null,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''[null,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''[null,"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}' <<< '[null,"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''[null,"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''[null,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}' <<< '[null,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''[null,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''[null,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}' <<< '[null,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":456}]}]}'\'' <<< '\''[null,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''[null,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}' <<< '[null,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''[null,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''[null,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}' <<< '[null,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''[null,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''[null,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}' <<< '[null,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''[null,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''[null,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}' <<< '[null,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''[null,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''[null,456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}' <<< '[null,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''[null,456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''[null,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}' <<< '[null,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''[null,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''[null,"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}' <<< '[null,"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''[null,"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''[null,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}' <<< '[null,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''[null,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''[null,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}' <<< '[null,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":null},{"plain":"bar"}]}]}'\'' <<< '\''[null,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''[false,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}' <<< '[false,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''[false,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''[false,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}' <<< '[false,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''[false,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''[false,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}' <<< '[false,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''[false,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''[false,456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}' <<< '[false,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''[false,456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''[false,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}' <<< '[false,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''[false,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''[false,"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}' <<< '[false,"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''[false,"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''[false,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}' <<< '[false,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''[false,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''[false,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}' <<< '[false,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":null}]}]}'\'' <<< '\''[false,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''[false,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}' <<< '[false,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''[false,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''[false,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}' <<< '[false,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''[false,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''[false,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}' <<< '[false,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''[false,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''[false,456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}' <<< '[false,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''[false,456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''[false,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}' <<< '[false,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''[false,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''[false,"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}' <<< '[false,"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''[false,"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''[false,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}' <<< '[false,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''[false,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''[false,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}' <<< '[false,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":false}]}]}'\'' <<< '\''[false,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''[false,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}' <<< '[false,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''[false,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''[false,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}' <<< '[false,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''[false,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''[false,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}' <<< '[false,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''[false,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''[false,456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}' <<< '[false,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''[false,456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''[false,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}' <<< '[false,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''[false,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''[false,"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}' <<< '[false,"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''[false,"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''[false,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}' <<< '[false,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''[false,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''[false,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}' <<< '[false,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":true}]}]}'\'' <<< '\''[false,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''[false,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}' <<< '[false,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''[false,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''[false,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}' <<< '[false,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''[false,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''[false,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}' <<< '[false,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''[false,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''[false,456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}' <<< '[false,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''[false,456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''[false,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}' <<< '[false,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''[false,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''[false,"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}' <<< '[false,"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''[false,"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''[false,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}' <<< '[false,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''[false,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''[false,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}' <<< '[false,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":456}]}]}'\'' <<< '\''[false,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''[false,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}' <<< '[false,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''[false,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''[false,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}' <<< '[false,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''[false,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''[false,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}' <<< '[false,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''[false,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''[false,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}' <<< '[false,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''[false,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''[false,456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}' <<< '[false,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''[false,456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''[false,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}' <<< '[false,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''[false,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''[false,"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}' <<< '[false,"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''[false,"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''[false,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}' <<< '[false,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''[false,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''[false,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}' <<< '[false,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":false},{"plain":"bar"}]}]}'\'' <<< '\''[false,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''[true,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}' <<< '[true,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''[true,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''[true,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}' <<< '[true,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''[true,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''[true,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}' <<< '[true,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''[true,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''[true,456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}' <<< '[true,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''[true,456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''[true,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}' <<< '[true,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''[true,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''[true,"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}' <<< '[true,"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''[true,"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''[true,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}' <<< '[true,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''[true,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''[true,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}' <<< '[true,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":null}]}]}'\'' <<< '\''[true,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''[true,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}' <<< '[true,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''[true,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''[true,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}' <<< '[true,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''[true,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''[true,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}' <<< '[true,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''[true,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''[true,456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}' <<< '[true,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''[true,456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''[true,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}' <<< '[true,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''[true,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''[true,"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}' <<< '[true,"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''[true,"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''[true,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}' <<< '[true,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''[true,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''[true,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}' <<< '[true,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":false}]}]}'\'' <<< '\''[true,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''[true,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}' <<< '[true,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''[true,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''[true,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}' <<< '[true,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''[true,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''[true,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}' <<< '[true,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''[true,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''[true,456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}' <<< '[true,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''[true,456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''[true,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}' <<< '[true,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''[true,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''[true,"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}' <<< '[true,"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''[true,"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''[true,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}' <<< '[true,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''[true,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''[true,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}' <<< '[true,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":true}]}]}'\'' <<< '\''[true,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''[true,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}' <<< '[true,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''[true,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''[true,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}' <<< '[true,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''[true,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''[true,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}' <<< '[true,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''[true,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''[true,456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}' <<< '[true,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''[true,456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''[true,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}' <<< '[true,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''[true,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''[true,"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}' <<< '[true,"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''[true,"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''[true,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}' <<< '[true,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''[true,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''[true,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}' <<< '[true,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":456}]}]}'\'' <<< '\''[true,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''[true,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}' <<< '[true,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''[true,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''[true,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}' <<< '[true,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''[true,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''[true,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}' <<< '[true,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''[true,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''[true,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}' <<< '[true,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''[true,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''[true,456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}' <<< '[true,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''[true,456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''[true,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}' <<< '[true,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''[true,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''[true,"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}' <<< '[true,"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''[true,"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''[true,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}' <<< '[true,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''[true,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''[true,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}' <<< '[true,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":true},{"plain":"bar"}]}]}'\'' <<< '\''[true,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''[123,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}' <<< '[123,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''[123,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''[123,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}' <<< '[123,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''[123,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''[123,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}' <<< '[123,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''[123,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''[123,456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}' <<< '[123,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''[123,456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''[123,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}' <<< '[123,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''[123,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''[123,"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}' <<< '[123,"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''[123,"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''[123,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}' <<< '[123,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''[123,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''[123,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}' <<< '[123,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":null}]}]}'\'' <<< '\''[123,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''[123,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}' <<< '[123,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''[123,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''[123,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}' <<< '[123,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''[123,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''[123,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}' <<< '[123,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''[123,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''[123,456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}' <<< '[123,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''[123,456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''[123,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}' <<< '[123,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''[123,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''[123,"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}' <<< '[123,"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''[123,"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''[123,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}' <<< '[123,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''[123,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''[123,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}' <<< '[123,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":false}]}]}'\'' <<< '\''[123,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''[123,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}' <<< '[123,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''[123,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''[123,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}' <<< '[123,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''[123,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''[123,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}' <<< '[123,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''[123,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''[123,456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}' <<< '[123,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''[123,456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''[123,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}' <<< '[123,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''[123,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''[123,"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}' <<< '[123,"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''[123,"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''[123,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}' <<< '[123,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''[123,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''[123,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}' <<< '[123,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":true}]}]}'\'' <<< '\''[123,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''[123,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}' <<< '[123,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''[123,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''[123,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}' <<< '[123,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''[123,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''[123,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}' <<< '[123,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''[123,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''[123,456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}' <<< '[123,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''[123,456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''[123,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}' <<< '[123,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''[123,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''[123,"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}' <<< '[123,"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''[123,"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''[123,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}' <<< '[123,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''[123,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''[123,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}' <<< '[123,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":456}]}]}'\'' <<< '\''[123,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''[123,null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}' <<< '[123,null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''[123,null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''[123,false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}' <<< '[123,false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''[123,false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''[123,true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}' <<< '[123,true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''[123,true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''[123,123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}' <<< '[123,123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''[123,123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''[123,456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}' <<< '[123,456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''[123,456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''[123,"foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}' <<< '[123,"foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''[123,"foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''[123,"bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}' <<< '[123,"bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''[123,"bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''[123,{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}' <<< '[123,{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''[123,{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''[123,[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}' <<< '[123,[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":123},{"plain":"bar"}]}]}'\'' <<< '\''[123,[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''["foo",null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}' <<< '["foo",null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''["foo",null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''["foo",false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}' <<< '["foo",false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''["foo",false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''["foo",true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}' <<< '["foo",true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''["foo",true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''["foo",123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}' <<< '["foo",123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''["foo",123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''["foo",456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}' <<< '["foo",456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''["foo",456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''["foo","foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}' <<< '["foo","foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''["foo","foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''["foo","bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}' <<< '["foo","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''["foo","bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''["foo",{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}' <<< '["foo",{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''["foo",{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''["foo",[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}' <<< '["foo",[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":null}]}]}'\'' <<< '\''["foo",[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''["foo",null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}' <<< '["foo",null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''["foo",null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''["foo",false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}' <<< '["foo",false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''["foo",false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''["foo",true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}' <<< '["foo",true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''["foo",true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''["foo",123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}' <<< '["foo",123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''["foo",123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''["foo",456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}' <<< '["foo",456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''["foo",456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''["foo","foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}' <<< '["foo","foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''["foo","foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''["foo","bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}' <<< '["foo","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''["foo","bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''["foo",{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}' <<< '["foo",{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''["foo",{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''["foo",[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}' <<< '["foo",[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":false}]}]}'\'' <<< '\''["foo",[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''["foo",null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}' <<< '["foo",null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''["foo",null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''["foo",false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}' <<< '["foo",false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''["foo",false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''["foo",true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}' <<< '["foo",true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''["foo",true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''["foo",123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}' <<< '["foo",123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''["foo",123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''["foo",456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}' <<< '["foo",456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''["foo",456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''["foo","foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}' <<< '["foo","foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''["foo","foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''["foo","bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}' <<< '["foo","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''["foo","bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''["foo",{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}' <<< '["foo",{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''["foo",{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''["foo",[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}' <<< '["foo",[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":true}]}]}'\'' <<< '\''["foo",[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''["foo",null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}' <<< '["foo",null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''["foo",null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''["foo",false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}' <<< '["foo",false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''["foo",false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''["foo",true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}' <<< '["foo",true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''["foo",true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''["foo",123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}' <<< '["foo",123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''["foo",123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''["foo",456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}' <<< '["foo",456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''["foo",456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''["foo","foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}' <<< '["foo","foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''["foo","foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''["foo","bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}' <<< '["foo","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''["foo","bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''["foo",{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}' <<< '["foo",{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''["foo",{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''["foo",[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}' <<< '["foo",[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":456}]}]}'\'' <<< '\''["foo",[]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''["foo",null]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}' <<< '["foo",null]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''["foo",null]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''["foo",false]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}' <<< '["foo",false]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''["foo",false]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''["foo",true]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}' <<< '["foo",true]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''["foo",true]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''["foo",123]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}' <<< '["foo",123]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''["foo",123]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''["foo",456]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}' <<< '["foo",456]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''["foo",456]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''["foo","foo"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}' <<< '["foo","foo"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''["foo","foo"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''["foo","bar"]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}' <<< '["foo","bar"]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''["foo","bar"]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''["foo",{}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}' <<< '["foo",{}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''["foo",{}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''["foo",[]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}' <<< '["foo",[]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":[{"plain":"foo"},{"plain":"bar"}]}]}'\'' <<< '\''["foo",[]]'\'''
)

