#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker-list:list-object-foo-basic-object-foo-plain-val-basic
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L list-object-foo-basic-object-foo-plain-val-basic.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''null'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''false'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''true'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''123'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''"bar"'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{}'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''[]'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''null'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''false'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''true'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''123'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''"bar"'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{}'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''[]'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''null'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''false'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''true'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''123'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''"bar"'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{}'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''[]'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''null'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''false'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''true'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''123'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''"bar"'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{}'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''[]'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''null'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''false'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''true'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''123'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''"bar"'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{}'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''[]'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''null'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''false'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''true'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''123'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''"bar"'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{}'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''[]'\''
json: error: <text>:1:126: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''null'\''
json: error: <text>:1:129: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''false'\''
json: error: <text>:1:129: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''true'\''
json: error: <text>:1:129: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''123'\''
json: error: <text>:1:129: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''"bar"'\''
json: error: <text>:1:129: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{}'\''
json: error: <text>:1:129: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''[]'\''
json: error: <text>:1:129: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''null'\''
json: error: <text>:1:129: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''false'\''
json: error: <text>:1:129: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''true'\''
json: error: <text>:1:129: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''123'\''
json: error: <text>:1:129: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''"bar"'\''
json: error: <text>:1:129: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{}'\''
json: error: <text>:1:129: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''[]'\''
json: error: <text>:1:129: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''null'\''
json: error: <text>:1:128: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''false'\''
json: error: <text>:1:128: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''true'\''
json: error: <text>:1:128: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''123'\''
json: error: <text>:1:128: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''"bar"'\''
json: error: <text>:1:128: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{}'\''
json: error: <text>:1:128: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''[]'\''
json: error: <text>:1:128: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''null'\''
json: error: <text>:1:128: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''false'\''
json: error: <text>:1:128: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''true'\''
json: error: <text>:1:128: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''123'\''
json: error: <text>:1:128: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''"bar"'\''
json: error: <text>:1:128: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{}'\''
json: error: <text>:1:128: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''[]'\''
json: error: <text>:1:128: type lib error: attribute error: invalid "list" type object: object argument ambiguity (the other is at 1:70)
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''[]'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''null'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''false'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''true'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''123'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''"bar"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\''
json: error: <stdin>:1:1: "bar"
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''"bar"'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{}'\''
json: error: <stdin>:1:2: type check error: too few arguments
json: error: <stdin>:1:2: {}
json: error: <stdin>:1:2:  ^
{
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{}'\''
$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''[]'\'''
) -L list-object-foo-basic-object-foo-plain-val-basic.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"type"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"null"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"boolean"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"number"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"string"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"object"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":null}}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":false}}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":true}}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":123}}]}]}'\'' <<< '\''[]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''null'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''null'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''false'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''false'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''true'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''true'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''123'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''123'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''"bar"'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '"bar"' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''"bar"'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{}'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''{}'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''[]'\'''
json -d '{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"object","args":[{"name":"foo","type":"array"}]},{"type":"object","args":[{"name":"foo","type":{"plain":"baz"}}]}]}'\'' <<< '\''[]'\'''
)

