#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-lib:list-any-type
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L list-any-type.old <(echo \
'$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }
$ json <<< '\''{"type":"list","args":["type"]}'\''
{
    "type": "list",
    "args": [
        "type"
    ],
    "attr": {
        "any": {
            "sym": "type",
            "lo": null,
            "eq": {
                "val": "type",
                "lo": null,
                "hi": null
            },
            "hi": null
        },
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": null
        }
    }
}
$ json <<< '\''{"type":"list","args":["null"]}'\''
{
    "type": "list",
    "args": [
        "null"
    ],
    "attr": {
        "any": {
            "sym": "null",
            "lo": null,
            "eq": {
                "val": "null",
                "lo": null,
                "hi": null
            },
            "hi": null
        },
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": null
        }
    }
}
$ json <<< '\''{"type":"list","args":["boolean"]}'\''
{
    "type": "list",
    "args": [
        "boolean"
    ],
    "attr": {
        "any": {
            "sym": "boolean",
            "lo": null,
            "eq": {
                "val": "boolean",
                "lo": null,
                "hi": null
            },
            "hi": null
        },
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": null
        }
    }
}
$ json <<< '\''{"type":"list","args":["number"]}'\''
{
    "type": "list",
    "args": [
        "number"
    ],
    "attr": {
        "any": {
            "sym": "number",
            "lo": null,
            "eq": {
                "val": "number",
                "lo": null,
                "hi": null
            },
            "hi": null
        },
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": null
        }
    }
}
$ json <<< '\''{"type":"list","args":["string"]}'\''
{
    "type": "list",
    "args": [
        "string"
    ],
    "attr": {
        "any": {
            "sym": "string",
            "lo": null,
            "eq": {
                "val": "string",
                "lo": null,
                "hi": null
            },
            "hi": null
        },
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": null
        }
    }
}
$ json <<< '\''{"type":"list","args":["object"]}'\''
{
    "type": "list",
    "args": [
        "object"
    ],
    "attr": {
        "any": {
            "sym": "object",
            "lo": null,
            "eq": {
                "val": "object",
                "lo": null,
                "hi": null
            },
            "hi": null
        },
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": null
        }
    }
}
$ json <<< '\''{"type":"list","args":["array"]}'\''
{
    "type": "list",
    "args": [
        "array"
    ],
    "attr": {
        "any": {
            "sym": "array",
            "lo": null,
            "eq": {
                "val": "array",
                "lo": null,
                "hi": null
            },
            "hi": null
        },
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": null
        }
    }
}'
) -L list-any-type.new <(
echo '$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }'
json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; } 2>&1 ||
echo 'command failed: json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }'

echo '$ json <<< '\''{"type":"list","args":["type"]}'\'''
json <<< '{"type":"list","args":["type"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":["type"]}'\'''

echo '$ json <<< '\''{"type":"list","args":["null"]}'\'''
json <<< '{"type":"list","args":["null"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":["null"]}'\'''

echo '$ json <<< '\''{"type":"list","args":["boolean"]}'\'''
json <<< '{"type":"list","args":["boolean"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":["boolean"]}'\'''

echo '$ json <<< '\''{"type":"list","args":["number"]}'\'''
json <<< '{"type":"list","args":["number"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":["number"]}'\'''

echo '$ json <<< '\''{"type":"list","args":["string"]}'\'''
json <<< '{"type":"list","args":["string"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":["string"]}'\'''

echo '$ json <<< '\''{"type":"list","args":["object"]}'\'''
json <<< '{"type":"list","args":["object"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":["object"]}'\'''

echo '$ json <<< '\''{"type":"list","args":["array"]}'\'''
json <<< '{"type":"list","args":["array"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":["array"]}'\'''
)

