#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-lib:list-any-type2
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L list-any-type2.old <(echo \
'$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }
$ json <<< '\''{"type":"list","args":["type","type"]}'\''
json: error: <stdin>:1:31: attribute error: invalid "list" type object: duplicated '\''any'\'' entry (previous defined at 1:24)
json: error: <stdin>:1:31: {"type":"list","args":["type","type"]}
json: error: <stdin>:1:31:                               ^
command failed: json <<< '\''{"type":"list","args":["type","type"]}'\''
$ json <<< '\''{"type":"list","args":["type","null"]}'\''
{
    "type": "list",
    "args": [
        "type",
        "null"
    ],
    "attr": {
        "any": {
            "sym": "type",
            "lo": {
                "sym": "null",
                "lo": null,
                "eq": {
                    "val": "null",
                    "lo": null,
                    "hi": null
                },
                "hi": null
            },
            "eq": {
                "val": "type",
                "lo": null,
                "hi": null
            },
            "hi": null
        },
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": null
        }
    }
}
$ json <<< '\''{"type":"list","args":["type","boolean"]}'\''
{
    "type": "list",
    "args": [
        "type",
        "boolean"
    ],
    "attr": {
        "any": {
            "sym": "type",
            "lo": {
                "sym": "boolean",
                "lo": null,
                "eq": {
                    "val": "boolean",
                    "lo": null,
                    "hi": null
                },
                "hi": null
            },
            "eq": {
                "val": "type",
                "lo": null,
                "hi": null
            },
            "hi": null
        },
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": null
        }
    }
}
$ json <<< '\''{"type":"list","args":["type","number"]}'\''
{
    "type": "list",
    "args": [
        "type",
        "number"
    ],
    "attr": {
        "any": {
            "sym": "type",
            "lo": {
                "sym": "number",
                "lo": null,
                "eq": {
                    "val": "number",
                    "lo": null,
                    "hi": null
                },
                "hi": null
            },
            "eq": {
                "val": "type",
                "lo": null,
                "hi": null
            },
            "hi": null
        },
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": null
        }
    }
}
$ json <<< '\''{"type":"list","args":["type","string"]}'\''
{
    "type": "list",
    "args": [
        "type",
        "string"
    ],
    "attr": {
        "any": {
            "sym": "type",
            "lo": {
                "sym": "string",
                "lo": null,
                "eq": {
                    "val": "string",
                    "lo": null,
                    "hi": null
                },
                "hi": null
            },
            "eq": {
                "val": "type",
                "lo": null,
                "hi": null
            },
            "hi": null
        },
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": null
        }
    }
}
$ json <<< '\''{"type":"list","args":["type","object"]}'\''
{
    "type": "list",
    "args": [
        "type",
        "object"
    ],
    "attr": {
        "any": {
            "sym": "type",
            "lo": {
                "sym": "object",
                "lo": null,
                "eq": {
                    "val": "object",
                    "lo": null,
                    "hi": null
                },
                "hi": null
            },
            "eq": {
                "val": "type",
                "lo": null,
                "hi": null
            },
            "hi": null
        },
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": null
        }
    }
}
$ json <<< '\''{"type":"list","args":["type","array"]}'\''
{
    "type": "list",
    "args": [
        "type",
        "array"
    ],
    "attr": {
        "any": {
            "sym": "type",
            "lo": {
                "sym": "array",
                "lo": null,
                "eq": {
                    "val": "array",
                    "lo": null,
                    "hi": null
                },
                "hi": null
            },
            "eq": {
                "val": "type",
                "lo": null,
                "hi": null
            },
            "hi": null
        },
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": null
        }
    }
}
$ json <<< '\''{"type":"list","args":["null","type"]}'\''
{
    "type": "list",
    "args": [
        "null",
        "type"
    ],
    "attr": {
        "any": {
            "sym": "null",
            "lo": null,
            "eq": {
                "val": "null",
                "lo": null,
                "hi": null
            },
            "hi": {
                "sym": "type",
                "lo": null,
                "eq": {
                    "val": "type",
                    "lo": null,
                    "hi": null
                },
                "hi": null
            }
        },
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": null
        }
    }
}
$ json <<< '\''{"type":"list","args":["null","null"]}'\''
json: error: <stdin>:1:31: attribute error: invalid "list" type object: duplicated '\''any'\'' entry (previous defined at 1:24)
json: error: <stdin>:1:31: {"type":"list","args":["null","null"]}
json: error: <stdin>:1:31:                               ^
command failed: json <<< '\''{"type":"list","args":["null","null"]}'\''
$ json <<< '\''{"type":"list","args":["null","boolean"]}'\''
{
    "type": "list",
    "args": [
        "null",
        "boolean"
    ],
    "attr": {
        "any": {
            "sym": "null",
            "lo": null,
            "eq": {
                "val": "null",
                "lo": null,
                "hi": null
            },
            "hi": {
                "sym": "boolean",
                "lo": null,
                "eq": {
                    "val": "boolean",
                    "lo": null,
                    "hi": null
                },
                "hi": null
            }
        },
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": null
        }
    }
}
$ json <<< '\''{"type":"list","args":["null","number"]}'\''
{
    "type": "list",
    "args": [
        "null",
        "number"
    ],
    "attr": {
        "any": {
            "sym": "null",
            "lo": null,
            "eq": {
                "val": "null",
                "lo": null,
                "hi": null
            },
            "hi": {
                "sym": "number",
                "lo": null,
                "eq": {
                    "val": "number",
                    "lo": null,
                    "hi": null
                },
                "hi": null
            }
        },
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": null
        }
    }
}
$ json <<< '\''{"type":"list","args":["null","string"]}'\''
{
    "type": "list",
    "args": [
        "null",
        "string"
    ],
    "attr": {
        "any": {
            "sym": "null",
            "lo": null,
            "eq": {
                "val": "null",
                "lo": null,
                "hi": null
            },
            "hi": {
                "sym": "string",
                "lo": null,
                "eq": {
                    "val": "string",
                    "lo": null,
                    "hi": null
                },
                "hi": null
            }
        },
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": null
        }
    }
}
$ json <<< '\''{"type":"list","args":["null","object"]}'\''
{
    "type": "list",
    "args": [
        "null",
        "object"
    ],
    "attr": {
        "any": {
            "sym": "null",
            "lo": null,
            "eq": {
                "val": "null",
                "lo": null,
                "hi": null
            },
            "hi": {
                "sym": "object",
                "lo": null,
                "eq": {
                    "val": "object",
                    "lo": null,
                    "hi": null
                },
                "hi": null
            }
        },
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": null
        }
    }
}
$ json <<< '\''{"type":"list","args":["null","array"]}'\''
{
    "type": "list",
    "args": [
        "null",
        "array"
    ],
    "attr": {
        "any": {
            "sym": "null",
            "lo": null,
            "eq": {
                "val": "null",
                "lo": null,
                "hi": null
            },
            "hi": {
                "sym": "array",
                "lo": null,
                "eq": {
                    "val": "array",
                    "lo": null,
                    "hi": null
                },
                "hi": null
            }
        },
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": null
        }
    }
}
$ json <<< '\''{"type":"list","args":["boolean","type"]}'\''
{
    "type": "list",
    "args": [
        "boolean",
        "type"
    ],
    "attr": {
        "any": {
            "sym": "boolean",
            "lo": null,
            "eq": {
                "val": "boolean",
                "lo": null,
                "hi": null
            },
            "hi": {
                "sym": "type",
                "lo": null,
                "eq": {
                    "val": "type",
                    "lo": null,
                    "hi": null
                },
                "hi": null
            }
        },
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": null
        }
    }
}
$ json <<< '\''{"type":"list","args":["boolean","null"]}'\''
{
    "type": "list",
    "args": [
        "boolean",
        "null"
    ],
    "attr": {
        "any": {
            "sym": "boolean",
            "lo": {
                "sym": "null",
                "lo": null,
                "eq": {
                    "val": "null",
                    "lo": null,
                    "hi": null
                },
                "hi": null
            },
            "eq": {
                "val": "boolean",
                "lo": null,
                "hi": null
            },
            "hi": null
        },
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": null
        }
    }
}
$ json <<< '\''{"type":"list","args":["boolean","boolean"]}'\''
json: error: <stdin>:1:34: attribute error: invalid "list" type object: duplicated '\''any'\'' entry (previous defined at 1:24)
json: error: <stdin>:1:34: "type":"list","args":["boolean","boolean"]}
json: error: <stdin>:1:34:                                 ^
command failed: json <<< '\''{"type":"list","args":["boolean","boolean"]}'\''
$ json <<< '\''{"type":"list","args":["boolean","number"]}'\''
{
    "type": "list",
    "args": [
        "boolean",
        "number"
    ],
    "attr": {
        "any": {
            "sym": "boolean",
            "lo": null,
            "eq": {
                "val": "boolean",
                "lo": null,
                "hi": null
            },
            "hi": {
                "sym": "number",
                "lo": null,
                "eq": {
                    "val": "number",
                    "lo": null,
                    "hi": null
                },
                "hi": null
            }
        },
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": null
        }
    }
}
$ json <<< '\''{"type":"list","args":["boolean","string"]}'\''
{
    "type": "list",
    "args": [
        "boolean",
        "string"
    ],
    "attr": {
        "any": {
            "sym": "boolean",
            "lo": null,
            "eq": {
                "val": "boolean",
                "lo": null,
                "hi": null
            },
            "hi": {
                "sym": "string",
                "lo": null,
                "eq": {
                    "val": "string",
                    "lo": null,
                    "hi": null
                },
                "hi": null
            }
        },
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": null
        }
    }
}
$ json <<< '\''{"type":"list","args":["boolean","object"]}'\''
{
    "type": "list",
    "args": [
        "boolean",
        "object"
    ],
    "attr": {
        "any": {
            "sym": "boolean",
            "lo": null,
            "eq": {
                "val": "boolean",
                "lo": null,
                "hi": null
            },
            "hi": {
                "sym": "object",
                "lo": null,
                "eq": {
                    "val": "object",
                    "lo": null,
                    "hi": null
                },
                "hi": null
            }
        },
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": null
        }
    }
}
$ json <<< '\''{"type":"list","args":["boolean","array"]}'\''
{
    "type": "list",
    "args": [
        "boolean",
        "array"
    ],
    "attr": {
        "any": {
            "sym": "boolean",
            "lo": null,
            "eq": {
                "val": "boolean",
                "lo": null,
                "hi": null
            },
            "hi": {
                "sym": "array",
                "lo": null,
                "eq": {
                    "val": "array",
                    "lo": null,
                    "hi": null
                },
                "hi": null
            }
        },
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": null
        }
    }
}
$ json <<< '\''{"type":"list","args":["number","type"]}'\''
{
    "type": "list",
    "args": [
        "number",
        "type"
    ],
    "attr": {
        "any": {
            "sym": "number",
            "lo": null,
            "eq": {
                "val": "number",
                "lo": null,
                "hi": null
            },
            "hi": {
                "sym": "type",
                "lo": null,
                "eq": {
                    "val": "type",
                    "lo": null,
                    "hi": null
                },
                "hi": null
            }
        },
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": null
        }
    }
}
$ json <<< '\''{"type":"list","args":["number","null"]}'\''
{
    "type": "list",
    "args": [
        "number",
        "null"
    ],
    "attr": {
        "any": {
            "sym": "number",
            "lo": {
                "sym": "null",
                "lo": null,
                "eq": {
                    "val": "null",
                    "lo": null,
                    "hi": null
                },
                "hi": null
            },
            "eq": {
                "val": "number",
                "lo": null,
                "hi": null
            },
            "hi": null
        },
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": null
        }
    }
}
$ json <<< '\''{"type":"list","args":["number","boolean"]}'\''
{
    "type": "list",
    "args": [
        "number",
        "boolean"
    ],
    "attr": {
        "any": {
            "sym": "number",
            "lo": {
                "sym": "boolean",
                "lo": null,
                "eq": {
                    "val": "boolean",
                    "lo": null,
                    "hi": null
                },
                "hi": null
            },
            "eq": {
                "val": "number",
                "lo": null,
                "hi": null
            },
            "hi": null
        },
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": null
        }
    }
}
$ json <<< '\''{"type":"list","args":["number","number"]}'\''
json: error: <stdin>:1:33: attribute error: invalid "list" type object: duplicated '\''any'\'' entry (previous defined at 1:24)
json: error: <stdin>:1:33: {"type":"list","args":["number","number"]}
json: error: <stdin>:1:33:                                 ^
command failed: json <<< '\''{"type":"list","args":["number","number"]}'\''
$ json <<< '\''{"type":"list","args":["number","string"]}'\''
{
    "type": "list",
    "args": [
        "number",
        "string"
    ],
    "attr": {
        "any": {
            "sym": "number",
            "lo": null,
            "eq": {
                "val": "number",
                "lo": null,
                "hi": null
            },
            "hi": {
                "sym": "string",
                "lo": null,
                "eq": {
                    "val": "string",
                    "lo": null,
                    "hi": null
                },
                "hi": null
            }
        },
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": null
        }
    }
}
$ json <<< '\''{"type":"list","args":["number","object"]}'\''
{
    "type": "list",
    "args": [
        "number",
        "object"
    ],
    "attr": {
        "any": {
            "sym": "number",
            "lo": null,
            "eq": {
                "val": "number",
                "lo": null,
                "hi": null
            },
            "hi": {
                "sym": "object",
                "lo": null,
                "eq": {
                    "val": "object",
                    "lo": null,
                    "hi": null
                },
                "hi": null
            }
        },
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": null
        }
    }
}
$ json <<< '\''{"type":"list","args":["number","array"]}'\''
{
    "type": "list",
    "args": [
        "number",
        "array"
    ],
    "attr": {
        "any": {
            "sym": "number",
            "lo": null,
            "eq": {
                "val": "number",
                "lo": null,
                "hi": null
            },
            "hi": {
                "sym": "array",
                "lo": null,
                "eq": {
                    "val": "array",
                    "lo": null,
                    "hi": null
                },
                "hi": null
            }
        },
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": null
        }
    }
}
$ json <<< '\''{"type":"list","args":["string","type"]}'\''
{
    "type": "list",
    "args": [
        "string",
        "type"
    ],
    "attr": {
        "any": {
            "sym": "string",
            "lo": null,
            "eq": {
                "val": "string",
                "lo": null,
                "hi": null
            },
            "hi": {
                "sym": "type",
                "lo": null,
                "eq": {
                    "val": "type",
                    "lo": null,
                    "hi": null
                },
                "hi": null
            }
        },
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": null
        }
    }
}
$ json <<< '\''{"type":"list","args":["string","null"]}'\''
{
    "type": "list",
    "args": [
        "string",
        "null"
    ],
    "attr": {
        "any": {
            "sym": "string",
            "lo": {
                "sym": "null",
                "lo": null,
                "eq": {
                    "val": "null",
                    "lo": null,
                    "hi": null
                },
                "hi": null
            },
            "eq": {
                "val": "string",
                "lo": null,
                "hi": null
            },
            "hi": null
        },
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": null
        }
    }
}
$ json <<< '\''{"type":"list","args":["string","boolean"]}'\''
{
    "type": "list",
    "args": [
        "string",
        "boolean"
    ],
    "attr": {
        "any": {
            "sym": "string",
            "lo": {
                "sym": "boolean",
                "lo": null,
                "eq": {
                    "val": "boolean",
                    "lo": null,
                    "hi": null
                },
                "hi": null
            },
            "eq": {
                "val": "string",
                "lo": null,
                "hi": null
            },
            "hi": null
        },
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": null
        }
    }
}
$ json <<< '\''{"type":"list","args":["string","number"]}'\''
{
    "type": "list",
    "args": [
        "string",
        "number"
    ],
    "attr": {
        "any": {
            "sym": "string",
            "lo": {
                "sym": "number",
                "lo": null,
                "eq": {
                    "val": "number",
                    "lo": null,
                    "hi": null
                },
                "hi": null
            },
            "eq": {
                "val": "string",
                "lo": null,
                "hi": null
            },
            "hi": null
        },
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": null
        }
    }
}
$ json <<< '\''{"type":"list","args":["string","string"]}'\''
json: error: <stdin>:1:33: attribute error: invalid "list" type object: duplicated '\''any'\'' entry (previous defined at 1:24)
json: error: <stdin>:1:33: {"type":"list","args":["string","string"]}
json: error: <stdin>:1:33:                                 ^
command failed: json <<< '\''{"type":"list","args":["string","string"]}'\''
$ json <<< '\''{"type":"list","args":["string","object"]}'\''
{
    "type": "list",
    "args": [
        "string",
        "object"
    ],
    "attr": {
        "any": {
            "sym": "string",
            "lo": null,
            "eq": {
                "val": "string",
                "lo": null,
                "hi": null
            },
            "hi": {
                "sym": "object",
                "lo": null,
                "eq": {
                    "val": "object",
                    "lo": null,
                    "hi": null
                },
                "hi": null
            }
        },
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": null
        }
    }
}
$ json <<< '\''{"type":"list","args":["string","array"]}'\''
{
    "type": "list",
    "args": [
        "string",
        "array"
    ],
    "attr": {
        "any": {
            "sym": "string",
            "lo": null,
            "eq": {
                "val": "string",
                "lo": null,
                "hi": null
            },
            "hi": {
                "sym": "array",
                "lo": null,
                "eq": {
                    "val": "array",
                    "lo": null,
                    "hi": null
                },
                "hi": null
            }
        },
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": null
        }
    }
}
$ json <<< '\''{"type":"list","args":["object","type"]}'\''
{
    "type": "list",
    "args": [
        "object",
        "type"
    ],
    "attr": {
        "any": {
            "sym": "object",
            "lo": null,
            "eq": {
                "val": "object",
                "lo": null,
                "hi": null
            },
            "hi": {
                "sym": "type",
                "lo": null,
                "eq": {
                    "val": "type",
                    "lo": null,
                    "hi": null
                },
                "hi": null
            }
        },
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": null
        }
    }
}
$ json <<< '\''{"type":"list","args":["object","null"]}'\''
{
    "type": "list",
    "args": [
        "object",
        "null"
    ],
    "attr": {
        "any": {
            "sym": "object",
            "lo": {
                "sym": "null",
                "lo": null,
                "eq": {
                    "val": "null",
                    "lo": null,
                    "hi": null
                },
                "hi": null
            },
            "eq": {
                "val": "object",
                "lo": null,
                "hi": null
            },
            "hi": null
        },
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": null
        }
    }
}
$ json <<< '\''{"type":"list","args":["object","boolean"]}'\''
{
    "type": "list",
    "args": [
        "object",
        "boolean"
    ],
    "attr": {
        "any": {
            "sym": "object",
            "lo": {
                "sym": "boolean",
                "lo": null,
                "eq": {
                    "val": "boolean",
                    "lo": null,
                    "hi": null
                },
                "hi": null
            },
            "eq": {
                "val": "object",
                "lo": null,
                "hi": null
            },
            "hi": null
        },
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": null
        }
    }
}
$ json <<< '\''{"type":"list","args":["object","number"]}'\''
{
    "type": "list",
    "args": [
        "object",
        "number"
    ],
    "attr": {
        "any": {
            "sym": "object",
            "lo": {
                "sym": "number",
                "lo": null,
                "eq": {
                    "val": "number",
                    "lo": null,
                    "hi": null
                },
                "hi": null
            },
            "eq": {
                "val": "object",
                "lo": null,
                "hi": null
            },
            "hi": null
        },
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": null
        }
    }
}
$ json <<< '\''{"type":"list","args":["object","string"]}'\''
{
    "type": "list",
    "args": [
        "object",
        "string"
    ],
    "attr": {
        "any": {
            "sym": "object",
            "lo": {
                "sym": "string",
                "lo": null,
                "eq": {
                    "val": "string",
                    "lo": null,
                    "hi": null
                },
                "hi": null
            },
            "eq": {
                "val": "object",
                "lo": null,
                "hi": null
            },
            "hi": null
        },
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": null
        }
    }
}
$ json <<< '\''{"type":"list","args":["object","object"]}'\''
json: error: <stdin>:1:33: attribute error: invalid "list" type object: duplicated '\''any'\'' entry (previous defined at 1:24)
json: error: <stdin>:1:33: {"type":"list","args":["object","object"]}
json: error: <stdin>:1:33:                                 ^
command failed: json <<< '\''{"type":"list","args":["object","object"]}'\''
$ json <<< '\''{"type":"list","args":["object","array"]}'\''
{
    "type": "list",
    "args": [
        "object",
        "array"
    ],
    "attr": {
        "any": {
            "sym": "object",
            "lo": null,
            "eq": {
                "val": "object",
                "lo": null,
                "hi": null
            },
            "hi": {
                "sym": "array",
                "lo": null,
                "eq": {
                    "val": "array",
                    "lo": null,
                    "hi": null
                },
                "hi": null
            }
        },
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": null
        }
    }
}
$ json <<< '\''{"type":"list","args":["array","type"]}'\''
{
    "type": "list",
    "args": [
        "array",
        "type"
    ],
    "attr": {
        "any": {
            "sym": "array",
            "lo": null,
            "eq": {
                "val": "array",
                "lo": null,
                "hi": null
            },
            "hi": {
                "sym": "type",
                "lo": null,
                "eq": {
                    "val": "type",
                    "lo": null,
                    "hi": null
                },
                "hi": null
            }
        },
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": null
        }
    }
}
$ json <<< '\''{"type":"list","args":["array","null"]}'\''
{
    "type": "list",
    "args": [
        "array",
        "null"
    ],
    "attr": {
        "any": {
            "sym": "array",
            "lo": {
                "sym": "null",
                "lo": null,
                "eq": {
                    "val": "null",
                    "lo": null,
                    "hi": null
                },
                "hi": null
            },
            "eq": {
                "val": "array",
                "lo": null,
                "hi": null
            },
            "hi": null
        },
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": null
        }
    }
}
$ json <<< '\''{"type":"list","args":["array","boolean"]}'\''
{
    "type": "list",
    "args": [
        "array",
        "boolean"
    ],
    "attr": {
        "any": {
            "sym": "array",
            "lo": {
                "sym": "boolean",
                "lo": null,
                "eq": {
                    "val": "boolean",
                    "lo": null,
                    "hi": null
                },
                "hi": null
            },
            "eq": {
                "val": "array",
                "lo": null,
                "hi": null
            },
            "hi": null
        },
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": null
        }
    }
}
$ json <<< '\''{"type":"list","args":["array","number"]}'\''
{
    "type": "list",
    "args": [
        "array",
        "number"
    ],
    "attr": {
        "any": {
            "sym": "array",
            "lo": {
                "sym": "number",
                "lo": null,
                "eq": {
                    "val": "number",
                    "lo": null,
                    "hi": null
                },
                "hi": null
            },
            "eq": {
                "val": "array",
                "lo": null,
                "hi": null
            },
            "hi": null
        },
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": null
        }
    }
}
$ json <<< '\''{"type":"list","args":["array","string"]}'\''
{
    "type": "list",
    "args": [
        "array",
        "string"
    ],
    "attr": {
        "any": {
            "sym": "array",
            "lo": {
                "sym": "string",
                "lo": null,
                "eq": {
                    "val": "string",
                    "lo": null,
                    "hi": null
                },
                "hi": null
            },
            "eq": {
                "val": "array",
                "lo": null,
                "hi": null
            },
            "hi": null
        },
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": null
        }
    }
}
$ json <<< '\''{"type":"list","args":["array","object"]}'\''
{
    "type": "list",
    "args": [
        "array",
        "object"
    ],
    "attr": {
        "any": {
            "sym": "array",
            "lo": {
                "sym": "object",
                "lo": null,
                "eq": {
                    "val": "object",
                    "lo": null,
                    "hi": null
                },
                "hi": null
            },
            "eq": {
                "val": "array",
                "lo": null,
                "hi": null
            },
            "hi": null
        },
        "plain": null,
        "object": null,
        "array": {
            "open": null,
            "closed": null
        }
    }
}
$ json <<< '\''{"type":"list","args":["array","array"]}'\''
json: error: <stdin>:1:32: attribute error: invalid "list" type object: duplicated '\''any'\'' entry (previous defined at 1:24)
json: error: <stdin>:1:32: {"type":"list","args":["array","array"]}
json: error: <stdin>:1:32:                                ^
command failed: json <<< '\''{"type":"list","args":["array","array"]}'\'''
) -L list-any-type2.new <(
echo '$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }'
json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; } 2>&1 ||
echo 'command failed: json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --literal-value -V -TA "$@"|LD_LIBRARY_PATH=../lib ../src/json --literal-value --from-ast-print --verbose --no-error; }'

echo '$ json <<< '\''{"type":"list","args":["type","type"]}'\'''
json <<< '{"type":"list","args":["type","type"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":["type","type"]}'\'''

echo '$ json <<< '\''{"type":"list","args":["type","null"]}'\'''
json <<< '{"type":"list","args":["type","null"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":["type","null"]}'\'''

echo '$ json <<< '\''{"type":"list","args":["type","boolean"]}'\'''
json <<< '{"type":"list","args":["type","boolean"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":["type","boolean"]}'\'''

echo '$ json <<< '\''{"type":"list","args":["type","number"]}'\'''
json <<< '{"type":"list","args":["type","number"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":["type","number"]}'\'''

echo '$ json <<< '\''{"type":"list","args":["type","string"]}'\'''
json <<< '{"type":"list","args":["type","string"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":["type","string"]}'\'''

echo '$ json <<< '\''{"type":"list","args":["type","object"]}'\'''
json <<< '{"type":"list","args":["type","object"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":["type","object"]}'\'''

echo '$ json <<< '\''{"type":"list","args":["type","array"]}'\'''
json <<< '{"type":"list","args":["type","array"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":["type","array"]}'\'''

echo '$ json <<< '\''{"type":"list","args":["null","type"]}'\'''
json <<< '{"type":"list","args":["null","type"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":["null","type"]}'\'''

echo '$ json <<< '\''{"type":"list","args":["null","null"]}'\'''
json <<< '{"type":"list","args":["null","null"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":["null","null"]}'\'''

echo '$ json <<< '\''{"type":"list","args":["null","boolean"]}'\'''
json <<< '{"type":"list","args":["null","boolean"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":["null","boolean"]}'\'''

echo '$ json <<< '\''{"type":"list","args":["null","number"]}'\'''
json <<< '{"type":"list","args":["null","number"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":["null","number"]}'\'''

echo '$ json <<< '\''{"type":"list","args":["null","string"]}'\'''
json <<< '{"type":"list","args":["null","string"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":["null","string"]}'\'''

echo '$ json <<< '\''{"type":"list","args":["null","object"]}'\'''
json <<< '{"type":"list","args":["null","object"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":["null","object"]}'\'''

echo '$ json <<< '\''{"type":"list","args":["null","array"]}'\'''
json <<< '{"type":"list","args":["null","array"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":["null","array"]}'\'''

echo '$ json <<< '\''{"type":"list","args":["boolean","type"]}'\'''
json <<< '{"type":"list","args":["boolean","type"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":["boolean","type"]}'\'''

echo '$ json <<< '\''{"type":"list","args":["boolean","null"]}'\'''
json <<< '{"type":"list","args":["boolean","null"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":["boolean","null"]}'\'''

echo '$ json <<< '\''{"type":"list","args":["boolean","boolean"]}'\'''
json <<< '{"type":"list","args":["boolean","boolean"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":["boolean","boolean"]}'\'''

echo '$ json <<< '\''{"type":"list","args":["boolean","number"]}'\'''
json <<< '{"type":"list","args":["boolean","number"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":["boolean","number"]}'\'''

echo '$ json <<< '\''{"type":"list","args":["boolean","string"]}'\'''
json <<< '{"type":"list","args":["boolean","string"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":["boolean","string"]}'\'''

echo '$ json <<< '\''{"type":"list","args":["boolean","object"]}'\'''
json <<< '{"type":"list","args":["boolean","object"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":["boolean","object"]}'\'''

echo '$ json <<< '\''{"type":"list","args":["boolean","array"]}'\'''
json <<< '{"type":"list","args":["boolean","array"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":["boolean","array"]}'\'''

echo '$ json <<< '\''{"type":"list","args":["number","type"]}'\'''
json <<< '{"type":"list","args":["number","type"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":["number","type"]}'\'''

echo '$ json <<< '\''{"type":"list","args":["number","null"]}'\'''
json <<< '{"type":"list","args":["number","null"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":["number","null"]}'\'''

echo '$ json <<< '\''{"type":"list","args":["number","boolean"]}'\'''
json <<< '{"type":"list","args":["number","boolean"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":["number","boolean"]}'\'''

echo '$ json <<< '\''{"type":"list","args":["number","number"]}'\'''
json <<< '{"type":"list","args":["number","number"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":["number","number"]}'\'''

echo '$ json <<< '\''{"type":"list","args":["number","string"]}'\'''
json <<< '{"type":"list","args":["number","string"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":["number","string"]}'\'''

echo '$ json <<< '\''{"type":"list","args":["number","object"]}'\'''
json <<< '{"type":"list","args":["number","object"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":["number","object"]}'\'''

echo '$ json <<< '\''{"type":"list","args":["number","array"]}'\'''
json <<< '{"type":"list","args":["number","array"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":["number","array"]}'\'''

echo '$ json <<< '\''{"type":"list","args":["string","type"]}'\'''
json <<< '{"type":"list","args":["string","type"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":["string","type"]}'\'''

echo '$ json <<< '\''{"type":"list","args":["string","null"]}'\'''
json <<< '{"type":"list","args":["string","null"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":["string","null"]}'\'''

echo '$ json <<< '\''{"type":"list","args":["string","boolean"]}'\'''
json <<< '{"type":"list","args":["string","boolean"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":["string","boolean"]}'\'''

echo '$ json <<< '\''{"type":"list","args":["string","number"]}'\'''
json <<< '{"type":"list","args":["string","number"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":["string","number"]}'\'''

echo '$ json <<< '\''{"type":"list","args":["string","string"]}'\'''
json <<< '{"type":"list","args":["string","string"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":["string","string"]}'\'''

echo '$ json <<< '\''{"type":"list","args":["string","object"]}'\'''
json <<< '{"type":"list","args":["string","object"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":["string","object"]}'\'''

echo '$ json <<< '\''{"type":"list","args":["string","array"]}'\'''
json <<< '{"type":"list","args":["string","array"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":["string","array"]}'\'''

echo '$ json <<< '\''{"type":"list","args":["object","type"]}'\'''
json <<< '{"type":"list","args":["object","type"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":["object","type"]}'\'''

echo '$ json <<< '\''{"type":"list","args":["object","null"]}'\'''
json <<< '{"type":"list","args":["object","null"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":["object","null"]}'\'''

echo '$ json <<< '\''{"type":"list","args":["object","boolean"]}'\'''
json <<< '{"type":"list","args":["object","boolean"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":["object","boolean"]}'\'''

echo '$ json <<< '\''{"type":"list","args":["object","number"]}'\'''
json <<< '{"type":"list","args":["object","number"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":["object","number"]}'\'''

echo '$ json <<< '\''{"type":"list","args":["object","string"]}'\'''
json <<< '{"type":"list","args":["object","string"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":["object","string"]}'\'''

echo '$ json <<< '\''{"type":"list","args":["object","object"]}'\'''
json <<< '{"type":"list","args":["object","object"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":["object","object"]}'\'''

echo '$ json <<< '\''{"type":"list","args":["object","array"]}'\'''
json <<< '{"type":"list","args":["object","array"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":["object","array"]}'\'''

echo '$ json <<< '\''{"type":"list","args":["array","type"]}'\'''
json <<< '{"type":"list","args":["array","type"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":["array","type"]}'\'''

echo '$ json <<< '\''{"type":"list","args":["array","null"]}'\'''
json <<< '{"type":"list","args":["array","null"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":["array","null"]}'\'''

echo '$ json <<< '\''{"type":"list","args":["array","boolean"]}'\'''
json <<< '{"type":"list","args":["array","boolean"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":["array","boolean"]}'\'''

echo '$ json <<< '\''{"type":"list","args":["array","number"]}'\'''
json <<< '{"type":"list","args":["array","number"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":["array","number"]}'\'''

echo '$ json <<< '\''{"type":"list","args":["array","string"]}'\'''
json <<< '{"type":"list","args":["array","string"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":["array","string"]}'\'''

echo '$ json <<< '\''{"type":"list","args":["array","object"]}'\'''
json <<< '{"type":"list","args":["array","object"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":["array","object"]}'\'''

echo '$ json <<< '\''{"type":"list","args":["array","array"]}'\'''
json <<< '{"type":"list","args":["array","array"]}' 2>&1 ||
echo 'command failed: json <<< '\''{"type":"list","args":["array","array"]}'\'''
)

