#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020, 2021  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -p litex -C expr-flat:reverse-cmp
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L reverse-cmp.old <(echo \
'$ shopt -s expand_aliases
$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"
$ test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vc flat; }
$ alias test-expr='\''test-expr -b alpha -C'\''
$ diff-expr() { diff -u100 -L "$1" <(test-expr "$1") -L "$2" <(test-expr "$2") && echo OK; }
$ test-expr '\''#`a` < #`b`'\''
0 count_str("a")
1 count_str("b")
2 cmp_op(lt)
$ diff-expr '\''#`a` < #`b`'\'' '\''#`b` > #`a`'\''
--- #`a` < #`b`
+++ #`b` > #`a`
@@ -1,3 +1,3 @@
-0 count_str("a")
-1 count_str("b")
-2 cmp_op(lt)
+0 count_str("b")
+1 count_str("a")
+2 cmp_op(gt)
command failed: diff-expr '\''#`a` < #`b`'\'' '\''#`b` > #`a`'\''
$ test-expr '\''#`a` <= #`b`'\''
0 count_str("a")
1 count_str("b")
2 cmp_op(le)
$ diff-expr '\''#`a` <= #`b`'\'' '\''#`b` >= #`a`'\''
--- #`a` <= #`b`
+++ #`b` >= #`a`
@@ -1,3 +1,3 @@
-0 count_str("a")
-1 count_str("b")
-2 cmp_op(le)
+0 count_str("b")
+1 count_str("a")
+2 cmp_op(ge)
command failed: diff-expr '\''#`a` <= #`b`'\'' '\''#`b` >= #`a`'\''
$ test-expr '\''#`a` < #/b/'\''
0 count_str("a")
1 count_rex("b")
2 cmp_op(lt)
$ diff-expr '\''#`a` < #/b/'\'' '\''#/b/ > #`a`'\''
--- #`a` < #/b/
+++ #/b/ > #`a`
@@ -1,3 +1,3 @@
-0 count_str("a")
-1 count_rex("b")
-2 cmp_op(lt)
+0 count_rex("b")
+1 count_str("a")
+2 cmp_op(gt)
command failed: diff-expr '\''#`a` < #/b/'\'' '\''#/b/ > #`a`'\''
$ test-expr '\''#`a` <= #/b/'\''
0 count_str("a")
1 count_rex("b")
2 cmp_op(le)
$ diff-expr '\''#`a` <= #/b/'\'' '\''#/b/ >= #`a`'\''
--- #`a` <= #/b/
+++ #/b/ >= #`a`
@@ -1,3 +1,3 @@
-0 count_str("a")
-1 count_rex("b")
-2 cmp_op(le)
+0 count_rex("b")
+1 count_str("a")
+2 cmp_op(ge)
command failed: diff-expr '\''#`a` <= #/b/'\'' '\''#/b/ >= #`a`'\''
$ test-expr '\''#`a` < b'\''
0 call_builtin(b)
1 count_str("a")
2 cmp_op(gt)
$ diff-expr '\''#`a` < b'\'' '\''b > #`a`'\''
OK
$ test-expr '\''#`a` <= b'\''
0 call_builtin(b)
1 count_str("a")
2 cmp_op(ge)
$ diff-expr '\''#`a` <= b'\'' '\''b >= #`a`'\''
OK
$ test-expr '\''#`a` < !b'\''
0 call_builtin(b)
1 not_op()
2 count_str("a")
3 cmp_op(gt)
$ diff-expr '\''#`a` < !b'\'' '\''!b > #`a`'\''
OK
$ test-expr '\''#`a` <= !b'\''
0 call_builtin(b)
1 not_op()
2 count_str("a")
3 cmp_op(ge)
$ diff-expr '\''#`a` <= !b'\'' '\''!b >= #`a`'\''
OK
$ test-expr '\''#`a` < (x || y)'\''
0 call_builtin(x)
1 jump_true(4)
2 call_builtin(y)
3 make_bool()
4 count_str("a")
5 cmp_op(gt)
$ diff-expr '\''#`a` < (x || y)'\'' '\''(x || y) > #`a`'\''
OK
$ test-expr '\''#`a` <= (x || y)'\''
0 call_builtin(x)
1 jump_true(4)
2 call_builtin(y)
3 make_bool()
4 count_str("a")
5 cmp_op(ge)
$ diff-expr '\''#`a` <= (x || y)'\'' '\''(x || y) >= #`a`'\''
OK
$ test-expr '\''#`a` < (x && y)'\''
0 call_builtin(x)
1 jump_false(4)
2 call_builtin(y)
3 make_bool()
4 count_str("a")
5 cmp_op(gt)
$ diff-expr '\''#`a` < (x && y)'\'' '\''(x && y) > #`a`'\''
OK
$ test-expr '\''#`a` <= (x && y)'\''
0 call_builtin(x)
1 jump_false(4)
2 call_builtin(y)
3 make_bool()
4 count_str("a")
5 cmp_op(ge)
$ diff-expr '\''#`a` <= (x && y)'\'' '\''(x && y) >= #`a`'\''
OK
$ test-expr '\''#`a` < (x == y)'\''
0 call_builtin(x)
1 call_builtin(y)
2 cmp_op(eq)
3 count_str("a")
4 cmp_op(gt)
$ diff-expr '\''#`a` < (x == y)'\'' '\''(x == y) > #`a`'\''
OK
$ test-expr '\''#`a` <= (x == y)'\''
0 call_builtin(x)
1 call_builtin(y)
2 cmp_op(eq)
3 count_str("a")
4 cmp_op(ge)
$ diff-expr '\''#`a` <= (x == y)'\'' '\''(x == y) >= #`a`'\''
OK
$ test-expr '\''#`a` < (x != y)'\''
0 call_builtin(x)
1 call_builtin(y)
2 cmp_op(ne)
3 count_str("a")
4 cmp_op(gt)
$ diff-expr '\''#`a` < (x != y)'\'' '\''(x != y) > #`a`'\''
OK
$ test-expr '\''#`a` <= (x != y)'\''
0 call_builtin(x)
1 call_builtin(y)
2 cmp_op(ne)
3 count_str("a")
4 cmp_op(ge)
$ diff-expr '\''#`a` <= (x != y)'\'' '\''(x != y) >= #`a`'\''
OK
$ test-expr '\''#`a` < (x < y)'\''
0 call_builtin(x)
1 call_builtin(y)
2 cmp_op(lt)
3 count_str("a")
4 cmp_op(gt)
$ diff-expr '\''#`a` < (x < y)'\'' '\''(x < y) > #`a`'\''
OK
$ test-expr '\''#`a` <= (x < y)'\''
0 call_builtin(x)
1 call_builtin(y)
2 cmp_op(lt)
3 count_str("a")
4 cmp_op(ge)
$ diff-expr '\''#`a` <= (x < y)'\'' '\''(x < y) >= #`a`'\''
OK
$ test-expr '\''#`a` < (x <= y)'\''
0 call_builtin(x)
1 call_builtin(y)
2 cmp_op(le)
3 count_str("a")
4 cmp_op(gt)
$ diff-expr '\''#`a` < (x <= y)'\'' '\''(x <= y) > #`a`'\''
OK
$ test-expr '\''#`a` <= (x <= y)'\''
0 call_builtin(x)
1 call_builtin(y)
2 cmp_op(le)
3 count_str("a")
4 cmp_op(ge)
$ diff-expr '\''#`a` <= (x <= y)'\'' '\''(x <= y) >= #`a`'\''
OK
$ test-expr '\''#`a` < (x > y)'\''
0 call_builtin(x)
1 call_builtin(y)
2 cmp_op(gt)
3 count_str("a")
4 cmp_op(gt)
$ diff-expr '\''#`a` < (x > y)'\'' '\''(x > y) > #`a`'\''
OK
$ test-expr '\''#`a` <= (x > y)'\''
0 call_builtin(x)
1 call_builtin(y)
2 cmp_op(gt)
3 count_str("a")
4 cmp_op(ge)
$ diff-expr '\''#`a` <= (x > y)'\'' '\''(x > y) >= #`a`'\''
OK
$ test-expr '\''#`a` < (x >= y)'\''
0 call_builtin(x)
1 call_builtin(y)
2 cmp_op(ge)
3 count_str("a")
4 cmp_op(gt)
$ diff-expr '\''#`a` < (x >= y)'\'' '\''(x >= y) > #`a`'\''
OK
$ test-expr '\''#`a` <= (x >= y)'\''
0 call_builtin(x)
1 call_builtin(y)
2 cmp_op(ge)
3 count_str("a")
4 cmp_op(ge)
$ diff-expr '\''#`a` <= (x >= y)'\'' '\''(x >= y) >= #`a`'\''
OK
$ test-expr '\''#/a/ < #`b`'\''
0 count_rex("a")
1 count_str("b")
2 cmp_op(lt)
$ diff-expr '\''#/a/ < #`b`'\'' '\''#`b` > #/a/'\''
--- #/a/ < #`b`
+++ #`b` > #/a/
@@ -1,3 +1,3 @@
-0 count_rex("a")
-1 count_str("b")
-2 cmp_op(lt)
+0 count_str("b")
+1 count_rex("a")
+2 cmp_op(gt)
command failed: diff-expr '\''#/a/ < #`b`'\'' '\''#`b` > #/a/'\''
$ test-expr '\''#/a/ <= #`b`'\''
0 count_rex("a")
1 count_str("b")
2 cmp_op(le)
$ diff-expr '\''#/a/ <= #`b`'\'' '\''#`b` >= #/a/'\''
--- #/a/ <= #`b`
+++ #`b` >= #/a/
@@ -1,3 +1,3 @@
-0 count_rex("a")
-1 count_str("b")
-2 cmp_op(le)
+0 count_str("b")
+1 count_rex("a")
+2 cmp_op(ge)
command failed: diff-expr '\''#/a/ <= #`b`'\'' '\''#`b` >= #/a/'\''
$ test-expr '\''#/a/ < #/b/'\''
0 count_rex("a")
1 count_rex("b")
2 cmp_op(lt)
$ diff-expr '\''#/a/ < #/b/'\'' '\''#/b/ > #/a/'\''
--- #/a/ < #/b/
+++ #/b/ > #/a/
@@ -1,3 +1,3 @@
-0 count_rex("a")
-1 count_rex("b")
-2 cmp_op(lt)
+0 count_rex("b")
+1 count_rex("a")
+2 cmp_op(gt)
command failed: diff-expr '\''#/a/ < #/b/'\'' '\''#/b/ > #/a/'\''
$ test-expr '\''#/a/ <= #/b/'\''
0 count_rex("a")
1 count_rex("b")
2 cmp_op(le)
$ diff-expr '\''#/a/ <= #/b/'\'' '\''#/b/ >= #/a/'\''
--- #/a/ <= #/b/
+++ #/b/ >= #/a/
@@ -1,3 +1,3 @@
-0 count_rex("a")
-1 count_rex("b")
-2 cmp_op(le)
+0 count_rex("b")
+1 count_rex("a")
+2 cmp_op(ge)
command failed: diff-expr '\''#/a/ <= #/b/'\'' '\''#/b/ >= #/a/'\''
$ test-expr '\''#/a/ < b'\''
0 call_builtin(b)
1 count_rex("a")
2 cmp_op(gt)
$ diff-expr '\''#/a/ < b'\'' '\''b > #/a/'\''
OK
$ test-expr '\''#/a/ <= b'\''
0 call_builtin(b)
1 count_rex("a")
2 cmp_op(ge)
$ diff-expr '\''#/a/ <= b'\'' '\''b >= #/a/'\''
OK
$ test-expr '\''#/a/ < !b'\''
0 call_builtin(b)
1 not_op()
2 count_rex("a")
3 cmp_op(gt)
$ diff-expr '\''#/a/ < !b'\'' '\''!b > #/a/'\''
OK
$ test-expr '\''#/a/ <= !b'\''
0 call_builtin(b)
1 not_op()
2 count_rex("a")
3 cmp_op(ge)
$ diff-expr '\''#/a/ <= !b'\'' '\''!b >= #/a/'\''
OK
$ test-expr '\''#/a/ < (x || y)'\''
0 call_builtin(x)
1 jump_true(4)
2 call_builtin(y)
3 make_bool()
4 count_rex("a")
5 cmp_op(gt)
$ diff-expr '\''#/a/ < (x || y)'\'' '\''(x || y) > #/a/'\''
OK
$ test-expr '\''#/a/ <= (x || y)'\''
0 call_builtin(x)
1 jump_true(4)
2 call_builtin(y)
3 make_bool()
4 count_rex("a")
5 cmp_op(ge)
$ diff-expr '\''#/a/ <= (x || y)'\'' '\''(x || y) >= #/a/'\''
OK
$ test-expr '\''#/a/ < (x && y)'\''
0 call_builtin(x)
1 jump_false(4)
2 call_builtin(y)
3 make_bool()
4 count_rex("a")
5 cmp_op(gt)
$ diff-expr '\''#/a/ < (x && y)'\'' '\''(x && y) > #/a/'\''
OK
$ test-expr '\''#/a/ <= (x && y)'\''
0 call_builtin(x)
1 jump_false(4)
2 call_builtin(y)
3 make_bool()
4 count_rex("a")
5 cmp_op(ge)
$ diff-expr '\''#/a/ <= (x && y)'\'' '\''(x && y) >= #/a/'\''
OK
$ test-expr '\''#/a/ < (x == y)'\''
0 call_builtin(x)
1 call_builtin(y)
2 cmp_op(eq)
3 count_rex("a")
4 cmp_op(gt)
$ diff-expr '\''#/a/ < (x == y)'\'' '\''(x == y) > #/a/'\''
OK
$ test-expr '\''#/a/ <= (x == y)'\''
0 call_builtin(x)
1 call_builtin(y)
2 cmp_op(eq)
3 count_rex("a")
4 cmp_op(ge)
$ diff-expr '\''#/a/ <= (x == y)'\'' '\''(x == y) >= #/a/'\''
OK
$ test-expr '\''#/a/ < (x != y)'\''
0 call_builtin(x)
1 call_builtin(y)
2 cmp_op(ne)
3 count_rex("a")
4 cmp_op(gt)
$ diff-expr '\''#/a/ < (x != y)'\'' '\''(x != y) > #/a/'\''
OK
$ test-expr '\''#/a/ <= (x != y)'\''
0 call_builtin(x)
1 call_builtin(y)
2 cmp_op(ne)
3 count_rex("a")
4 cmp_op(ge)
$ diff-expr '\''#/a/ <= (x != y)'\'' '\''(x != y) >= #/a/'\''
OK
$ test-expr '\''#/a/ < (x < y)'\''
0 call_builtin(x)
1 call_builtin(y)
2 cmp_op(lt)
3 count_rex("a")
4 cmp_op(gt)
$ diff-expr '\''#/a/ < (x < y)'\'' '\''(x < y) > #/a/'\''
OK
$ test-expr '\''#/a/ <= (x < y)'\''
0 call_builtin(x)
1 call_builtin(y)
2 cmp_op(lt)
3 count_rex("a")
4 cmp_op(ge)
$ diff-expr '\''#/a/ <= (x < y)'\'' '\''(x < y) >= #/a/'\''
OK
$ test-expr '\''#/a/ < (x <= y)'\''
0 call_builtin(x)
1 call_builtin(y)
2 cmp_op(le)
3 count_rex("a")
4 cmp_op(gt)
$ diff-expr '\''#/a/ < (x <= y)'\'' '\''(x <= y) > #/a/'\''
OK
$ test-expr '\''#/a/ <= (x <= y)'\''
0 call_builtin(x)
1 call_builtin(y)
2 cmp_op(le)
3 count_rex("a")
4 cmp_op(ge)
$ diff-expr '\''#/a/ <= (x <= y)'\'' '\''(x <= y) >= #/a/'\''
OK
$ test-expr '\''#/a/ < (x > y)'\''
0 call_builtin(x)
1 call_builtin(y)
2 cmp_op(gt)
3 count_rex("a")
4 cmp_op(gt)
$ diff-expr '\''#/a/ < (x > y)'\'' '\''(x > y) > #/a/'\''
OK
$ test-expr '\''#/a/ <= (x > y)'\''
0 call_builtin(x)
1 call_builtin(y)
2 cmp_op(gt)
3 count_rex("a")
4 cmp_op(ge)
$ diff-expr '\''#/a/ <= (x > y)'\'' '\''(x > y) >= #/a/'\''
OK
$ test-expr '\''#/a/ < (x >= y)'\''
0 call_builtin(x)
1 call_builtin(y)
2 cmp_op(ge)
3 count_rex("a")
4 cmp_op(gt)
$ diff-expr '\''#/a/ < (x >= y)'\'' '\''(x >= y) > #/a/'\''
OK
$ test-expr '\''#/a/ <= (x >= y)'\''
0 call_builtin(x)
1 call_builtin(y)
2 cmp_op(ge)
3 count_rex("a")
4 cmp_op(ge)
$ diff-expr '\''#/a/ <= (x >= y)'\'' '\''(x >= y) >= #/a/'\''
OK
$ test-expr '\''a < #`b`'\''
0 call_builtin(a)
1 count_str("b")
2 cmp_op(lt)
$ diff-expr '\''a < #`b`'\'' '\''#`b` > a'\''
OK
$ test-expr '\''a <= #`b`'\''
0 call_builtin(a)
1 count_str("b")
2 cmp_op(le)
$ diff-expr '\''a <= #`b`'\'' '\''#`b` >= a'\''
OK
$ test-expr '\''a < #/b/'\''
0 call_builtin(a)
1 count_rex("b")
2 cmp_op(lt)
$ diff-expr '\''a < #/b/'\'' '\''#/b/ > a'\''
OK
$ test-expr '\''a <= #/b/'\''
0 call_builtin(a)
1 count_rex("b")
2 cmp_op(le)
$ diff-expr '\''a <= #/b/'\'' '\''#/b/ >= a'\''
OK
$ test-expr '\''!a < #`b`'\''
0 call_builtin(a)
1 not_op()
2 count_str("b")
3 cmp_op(lt)
$ diff-expr '\''!a < #`b`'\'' '\''#`b` > !a'\''
OK
$ test-expr '\''!a <= #`b`'\''
0 call_builtin(a)
1 not_op()
2 count_str("b")
3 cmp_op(le)
$ diff-expr '\''!a <= #`b`'\'' '\''#`b` >= !a'\''
OK
$ test-expr '\''!a < #/b/'\''
0 call_builtin(a)
1 not_op()
2 count_rex("b")
3 cmp_op(lt)
$ diff-expr '\''!a < #/b/'\'' '\''#/b/ > !a'\''
OK
$ test-expr '\''!a <= #/b/'\''
0 call_builtin(a)
1 not_op()
2 count_rex("b")
3 cmp_op(le)
$ diff-expr '\''!a <= #/b/'\'' '\''#/b/ >= !a'\''
OK
$ test-expr '\''(x || y) < #`b`'\''
0 call_builtin(x)
1 jump_true(4)
2 call_builtin(y)
3 make_bool()
4 count_str("b")
5 cmp_op(lt)
$ diff-expr '\''(x || y) < #`b`'\'' '\''#`b` > (x || y)'\''
OK
$ test-expr '\''(x || y) <= #`b`'\''
0 call_builtin(x)
1 jump_true(4)
2 call_builtin(y)
3 make_bool()
4 count_str("b")
5 cmp_op(le)
$ diff-expr '\''(x || y) <= #`b`'\'' '\''#`b` >= (x || y)'\''
OK
$ test-expr '\''(x || y) < #/b/'\''
0 call_builtin(x)
1 jump_true(4)
2 call_builtin(y)
3 make_bool()
4 count_rex("b")
5 cmp_op(lt)
$ diff-expr '\''(x || y) < #/b/'\'' '\''#/b/ > (x || y)'\''
OK
$ test-expr '\''(x || y) <= #/b/'\''
0 call_builtin(x)
1 jump_true(4)
2 call_builtin(y)
3 make_bool()
4 count_rex("b")
5 cmp_op(le)
$ diff-expr '\''(x || y) <= #/b/'\'' '\''#/b/ >= (x || y)'\''
OK
$ test-expr '\''(x && y) < #`b`'\''
0 call_builtin(x)
1 jump_false(4)
2 call_builtin(y)
3 make_bool()
4 count_str("b")
5 cmp_op(lt)
$ diff-expr '\''(x && y) < #`b`'\'' '\''#`b` > (x && y)'\''
OK
$ test-expr '\''(x && y) <= #`b`'\''
0 call_builtin(x)
1 jump_false(4)
2 call_builtin(y)
3 make_bool()
4 count_str("b")
5 cmp_op(le)
$ diff-expr '\''(x && y) <= #`b`'\'' '\''#`b` >= (x && y)'\''
OK
$ test-expr '\''(x && y) < #/b/'\''
0 call_builtin(x)
1 jump_false(4)
2 call_builtin(y)
3 make_bool()
4 count_rex("b")
5 cmp_op(lt)
$ diff-expr '\''(x && y) < #/b/'\'' '\''#/b/ > (x && y)'\''
OK
$ test-expr '\''(x && y) <= #/b/'\''
0 call_builtin(x)
1 jump_false(4)
2 call_builtin(y)
3 make_bool()
4 count_rex("b")
5 cmp_op(le)
$ diff-expr '\''(x && y) <= #/b/'\'' '\''#/b/ >= (x && y)'\''
OK
$ test-expr '\''(x == y) < #`b`'\''
0 call_builtin(x)
1 call_builtin(y)
2 cmp_op(eq)
3 count_str("b")
4 cmp_op(lt)
$ diff-expr '\''(x == y) < #`b`'\'' '\''#`b` > (x == y)'\''
OK
$ test-expr '\''(x == y) <= #`b`'\''
0 call_builtin(x)
1 call_builtin(y)
2 cmp_op(eq)
3 count_str("b")
4 cmp_op(le)
$ diff-expr '\''(x == y) <= #`b`'\'' '\''#`b` >= (x == y)'\''
OK
$ test-expr '\''(x == y) < #/b/'\''
0 call_builtin(x)
1 call_builtin(y)
2 cmp_op(eq)
3 count_rex("b")
4 cmp_op(lt)
$ diff-expr '\''(x == y) < #/b/'\'' '\''#/b/ > (x == y)'\''
OK
$ test-expr '\''(x == y) <= #/b/'\''
0 call_builtin(x)
1 call_builtin(y)
2 cmp_op(eq)
3 count_rex("b")
4 cmp_op(le)
$ diff-expr '\''(x == y) <= #/b/'\'' '\''#/b/ >= (x == y)'\''
OK
$ test-expr '\''(x != y) < #`b`'\''
0 call_builtin(x)
1 call_builtin(y)
2 cmp_op(ne)
3 count_str("b")
4 cmp_op(lt)
$ diff-expr '\''(x != y) < #`b`'\'' '\''#`b` > (x != y)'\''
OK
$ test-expr '\''(x != y) <= #`b`'\''
0 call_builtin(x)
1 call_builtin(y)
2 cmp_op(ne)
3 count_str("b")
4 cmp_op(le)
$ diff-expr '\''(x != y) <= #`b`'\'' '\''#`b` >= (x != y)'\''
OK
$ test-expr '\''(x != y) < #/b/'\''
0 call_builtin(x)
1 call_builtin(y)
2 cmp_op(ne)
3 count_rex("b")
4 cmp_op(lt)
$ diff-expr '\''(x != y) < #/b/'\'' '\''#/b/ > (x != y)'\''
OK
$ test-expr '\''(x != y) <= #/b/'\''
0 call_builtin(x)
1 call_builtin(y)
2 cmp_op(ne)
3 count_rex("b")
4 cmp_op(le)
$ diff-expr '\''(x != y) <= #/b/'\'' '\''#/b/ >= (x != y)'\''
OK
$ test-expr '\''(x < y) < #`b`'\''
0 call_builtin(x)
1 call_builtin(y)
2 cmp_op(lt)
3 count_str("b")
4 cmp_op(lt)
$ diff-expr '\''(x < y) < #`b`'\'' '\''#`b` > (x < y)'\''
OK
$ test-expr '\''(x < y) <= #`b`'\''
0 call_builtin(x)
1 call_builtin(y)
2 cmp_op(lt)
3 count_str("b")
4 cmp_op(le)
$ diff-expr '\''(x < y) <= #`b`'\'' '\''#`b` >= (x < y)'\''
OK
$ test-expr '\''(x < y) < #/b/'\''
0 call_builtin(x)
1 call_builtin(y)
2 cmp_op(lt)
3 count_rex("b")
4 cmp_op(lt)
$ diff-expr '\''(x < y) < #/b/'\'' '\''#/b/ > (x < y)'\''
OK
$ test-expr '\''(x < y) <= #/b/'\''
0 call_builtin(x)
1 call_builtin(y)
2 cmp_op(lt)
3 count_rex("b")
4 cmp_op(le)
$ diff-expr '\''(x < y) <= #/b/'\'' '\''#/b/ >= (x < y)'\''
OK
$ test-expr '\''(x <= y) < #`b`'\''
0 call_builtin(x)
1 call_builtin(y)
2 cmp_op(le)
3 count_str("b")
4 cmp_op(lt)
$ diff-expr '\''(x <= y) < #`b`'\'' '\''#`b` > (x <= y)'\''
OK
$ test-expr '\''(x <= y) <= #`b`'\''
0 call_builtin(x)
1 call_builtin(y)
2 cmp_op(le)
3 count_str("b")
4 cmp_op(le)
$ diff-expr '\''(x <= y) <= #`b`'\'' '\''#`b` >= (x <= y)'\''
OK
$ test-expr '\''(x <= y) < #/b/'\''
0 call_builtin(x)
1 call_builtin(y)
2 cmp_op(le)
3 count_rex("b")
4 cmp_op(lt)
$ diff-expr '\''(x <= y) < #/b/'\'' '\''#/b/ > (x <= y)'\''
OK
$ test-expr '\''(x <= y) <= #/b/'\''
0 call_builtin(x)
1 call_builtin(y)
2 cmp_op(le)
3 count_rex("b")
4 cmp_op(le)
$ diff-expr '\''(x <= y) <= #/b/'\'' '\''#/b/ >= (x <= y)'\''
OK
$ test-expr '\''(x > y) < #`b`'\''
0 call_builtin(x)
1 call_builtin(y)
2 cmp_op(gt)
3 count_str("b")
4 cmp_op(lt)
$ diff-expr '\''(x > y) < #`b`'\'' '\''#`b` > (x > y)'\''
OK
$ test-expr '\''(x > y) <= #`b`'\''
0 call_builtin(x)
1 call_builtin(y)
2 cmp_op(gt)
3 count_str("b")
4 cmp_op(le)
$ diff-expr '\''(x > y) <= #`b`'\'' '\''#`b` >= (x > y)'\''
OK
$ test-expr '\''(x > y) < #/b/'\''
0 call_builtin(x)
1 call_builtin(y)
2 cmp_op(gt)
3 count_rex("b")
4 cmp_op(lt)
$ diff-expr '\''(x > y) < #/b/'\'' '\''#/b/ > (x > y)'\''
OK
$ test-expr '\''(x > y) <= #/b/'\''
0 call_builtin(x)
1 call_builtin(y)
2 cmp_op(gt)
3 count_rex("b")
4 cmp_op(le)
$ diff-expr '\''(x > y) <= #/b/'\'' '\''#/b/ >= (x > y)'\''
OK
$ test-expr '\''(x >= y) < #`b`'\''
0 call_builtin(x)
1 call_builtin(y)
2 cmp_op(ge)
3 count_str("b")
4 cmp_op(lt)
$ diff-expr '\''(x >= y) < #`b`'\'' '\''#`b` > (x >= y)'\''
OK
$ test-expr '\''(x >= y) <= #`b`'\''
0 call_builtin(x)
1 call_builtin(y)
2 cmp_op(ge)
3 count_str("b")
4 cmp_op(le)
$ diff-expr '\''(x >= y) <= #`b`'\'' '\''#`b` >= (x >= y)'\''
OK
$ test-expr '\''(x >= y) < #/b/'\''
0 call_builtin(x)
1 call_builtin(y)
2 cmp_op(ge)
3 count_rex("b")
4 cmp_op(lt)
$ diff-expr '\''(x >= y) < #/b/'\'' '\''#/b/ > (x >= y)'\''
OK
$ test-expr '\''(x >= y) <= #/b/'\''
0 call_builtin(x)
1 call_builtin(y)
2 cmp_op(ge)
3 count_rex("b")
4 cmp_op(le)
$ diff-expr '\''(x >= y) <= #/b/'\'' '\''#/b/ >= (x >= y)'\''
OK'
) -L reverse-cmp.new <(
echo '$ shopt -s expand_aliases'
shopt -s expand_aliases 2>&1 ||
echo 'command failed: shopt -s expand_aliases'

echo '$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'
[ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib" 2>&1 ||
echo 'command failed: [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'

echo '$ test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vc flat; }'
test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vc flat; } 2>&1 ||
echo 'command failed: test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vc flat; }'

echo '$ alias test-expr='\''test-expr -b alpha -C'\'''
alias test-expr='test-expr -b alpha -C' 2>&1 ||
echo 'command failed: alias test-expr='\''test-expr -b alpha -C'\'''

echo '$ diff-expr() { diff -u100 -L "$1" <(test-expr "$1") -L "$2" <(test-expr "$2") && echo OK; }'
diff-expr() { diff -u100 -L "$1" <(test-expr "$1") -L "$2" <(test-expr "$2") && echo OK; } 2>&1 ||
echo 'command failed: diff-expr() { diff -u100 -L "$1" <(test-expr "$1") -L "$2" <(test-expr "$2") && echo OK; }'

echo '$ test-expr '\''#`a` < #`b`'\'''
test-expr '#`a` < #`b`' 2>&1 ||
echo 'command failed: test-expr '\''#`a` < #`b`'\'''

echo '$ diff-expr '\''#`a` < #`b`'\'' '\''#`b` > #`a`'\'''
diff-expr '#`a` < #`b`' '#`b` > #`a`' 2>&1 ||
echo 'command failed: diff-expr '\''#`a` < #`b`'\'' '\''#`b` > #`a`'\'''

echo '$ test-expr '\''#`a` <= #`b`'\'''
test-expr '#`a` <= #`b`' 2>&1 ||
echo 'command failed: test-expr '\''#`a` <= #`b`'\'''

echo '$ diff-expr '\''#`a` <= #`b`'\'' '\''#`b` >= #`a`'\'''
diff-expr '#`a` <= #`b`' '#`b` >= #`a`' 2>&1 ||
echo 'command failed: diff-expr '\''#`a` <= #`b`'\'' '\''#`b` >= #`a`'\'''

echo '$ test-expr '\''#`a` < #/b/'\'''
test-expr '#`a` < #/b/' 2>&1 ||
echo 'command failed: test-expr '\''#`a` < #/b/'\'''

echo '$ diff-expr '\''#`a` < #/b/'\'' '\''#/b/ > #`a`'\'''
diff-expr '#`a` < #/b/' '#/b/ > #`a`' 2>&1 ||
echo 'command failed: diff-expr '\''#`a` < #/b/'\'' '\''#/b/ > #`a`'\'''

echo '$ test-expr '\''#`a` <= #/b/'\'''
test-expr '#`a` <= #/b/' 2>&1 ||
echo 'command failed: test-expr '\''#`a` <= #/b/'\'''

echo '$ diff-expr '\''#`a` <= #/b/'\'' '\''#/b/ >= #`a`'\'''
diff-expr '#`a` <= #/b/' '#/b/ >= #`a`' 2>&1 ||
echo 'command failed: diff-expr '\''#`a` <= #/b/'\'' '\''#/b/ >= #`a`'\'''

echo '$ test-expr '\''#`a` < b'\'''
test-expr '#`a` < b' 2>&1 ||
echo 'command failed: test-expr '\''#`a` < b'\'''

echo '$ diff-expr '\''#`a` < b'\'' '\''b > #`a`'\'''
diff-expr '#`a` < b' 'b > #`a`' 2>&1 ||
echo 'command failed: diff-expr '\''#`a` < b'\'' '\''b > #`a`'\'''

echo '$ test-expr '\''#`a` <= b'\'''
test-expr '#`a` <= b' 2>&1 ||
echo 'command failed: test-expr '\''#`a` <= b'\'''

echo '$ diff-expr '\''#`a` <= b'\'' '\''b >= #`a`'\'''
diff-expr '#`a` <= b' 'b >= #`a`' 2>&1 ||
echo 'command failed: diff-expr '\''#`a` <= b'\'' '\''b >= #`a`'\'''

echo '$ test-expr '\''#`a` < !b'\'''
test-expr '#`a` < !b' 2>&1 ||
echo 'command failed: test-expr '\''#`a` < !b'\'''

echo '$ diff-expr '\''#`a` < !b'\'' '\''!b > #`a`'\'''
diff-expr '#`a` < !b' '!b > #`a`' 2>&1 ||
echo 'command failed: diff-expr '\''#`a` < !b'\'' '\''!b > #`a`'\'''

echo '$ test-expr '\''#`a` <= !b'\'''
test-expr '#`a` <= !b' 2>&1 ||
echo 'command failed: test-expr '\''#`a` <= !b'\'''

echo '$ diff-expr '\''#`a` <= !b'\'' '\''!b >= #`a`'\'''
diff-expr '#`a` <= !b' '!b >= #`a`' 2>&1 ||
echo 'command failed: diff-expr '\''#`a` <= !b'\'' '\''!b >= #`a`'\'''

echo '$ test-expr '\''#`a` < (x || y)'\'''
test-expr '#`a` < (x || y)' 2>&1 ||
echo 'command failed: test-expr '\''#`a` < (x || y)'\'''

echo '$ diff-expr '\''#`a` < (x || y)'\'' '\''(x || y) > #`a`'\'''
diff-expr '#`a` < (x || y)' '(x || y) > #`a`' 2>&1 ||
echo 'command failed: diff-expr '\''#`a` < (x || y)'\'' '\''(x || y) > #`a`'\'''

echo '$ test-expr '\''#`a` <= (x || y)'\'''
test-expr '#`a` <= (x || y)' 2>&1 ||
echo 'command failed: test-expr '\''#`a` <= (x || y)'\'''

echo '$ diff-expr '\''#`a` <= (x || y)'\'' '\''(x || y) >= #`a`'\'''
diff-expr '#`a` <= (x || y)' '(x || y) >= #`a`' 2>&1 ||
echo 'command failed: diff-expr '\''#`a` <= (x || y)'\'' '\''(x || y) >= #`a`'\'''

echo '$ test-expr '\''#`a` < (x && y)'\'''
test-expr '#`a` < (x && y)' 2>&1 ||
echo 'command failed: test-expr '\''#`a` < (x && y)'\'''

echo '$ diff-expr '\''#`a` < (x && y)'\'' '\''(x && y) > #`a`'\'''
diff-expr '#`a` < (x && y)' '(x && y) > #`a`' 2>&1 ||
echo 'command failed: diff-expr '\''#`a` < (x && y)'\'' '\''(x && y) > #`a`'\'''

echo '$ test-expr '\''#`a` <= (x && y)'\'''
test-expr '#`a` <= (x && y)' 2>&1 ||
echo 'command failed: test-expr '\''#`a` <= (x && y)'\'''

echo '$ diff-expr '\''#`a` <= (x && y)'\'' '\''(x && y) >= #`a`'\'''
diff-expr '#`a` <= (x && y)' '(x && y) >= #`a`' 2>&1 ||
echo 'command failed: diff-expr '\''#`a` <= (x && y)'\'' '\''(x && y) >= #`a`'\'''

echo '$ test-expr '\''#`a` < (x == y)'\'''
test-expr '#`a` < (x == y)' 2>&1 ||
echo 'command failed: test-expr '\''#`a` < (x == y)'\'''

echo '$ diff-expr '\''#`a` < (x == y)'\'' '\''(x == y) > #`a`'\'''
diff-expr '#`a` < (x == y)' '(x == y) > #`a`' 2>&1 ||
echo 'command failed: diff-expr '\''#`a` < (x == y)'\'' '\''(x == y) > #`a`'\'''

echo '$ test-expr '\''#`a` <= (x == y)'\'''
test-expr '#`a` <= (x == y)' 2>&1 ||
echo 'command failed: test-expr '\''#`a` <= (x == y)'\'''

echo '$ diff-expr '\''#`a` <= (x == y)'\'' '\''(x == y) >= #`a`'\'''
diff-expr '#`a` <= (x == y)' '(x == y) >= #`a`' 2>&1 ||
echo 'command failed: diff-expr '\''#`a` <= (x == y)'\'' '\''(x == y) >= #`a`'\'''

echo '$ test-expr '\''#`a` < (x != y)'\'''
test-expr '#`a` < (x != y)' 2>&1 ||
echo 'command failed: test-expr '\''#`a` < (x != y)'\'''

echo '$ diff-expr '\''#`a` < (x != y)'\'' '\''(x != y) > #`a`'\'''
diff-expr '#`a` < (x != y)' '(x != y) > #`a`' 2>&1 ||
echo 'command failed: diff-expr '\''#`a` < (x != y)'\'' '\''(x != y) > #`a`'\'''

echo '$ test-expr '\''#`a` <= (x != y)'\'''
test-expr '#`a` <= (x != y)' 2>&1 ||
echo 'command failed: test-expr '\''#`a` <= (x != y)'\'''

echo '$ diff-expr '\''#`a` <= (x != y)'\'' '\''(x != y) >= #`a`'\'''
diff-expr '#`a` <= (x != y)' '(x != y) >= #`a`' 2>&1 ||
echo 'command failed: diff-expr '\''#`a` <= (x != y)'\'' '\''(x != y) >= #`a`'\'''

echo '$ test-expr '\''#`a` < (x < y)'\'''
test-expr '#`a` < (x < y)' 2>&1 ||
echo 'command failed: test-expr '\''#`a` < (x < y)'\'''

echo '$ diff-expr '\''#`a` < (x < y)'\'' '\''(x < y) > #`a`'\'''
diff-expr '#`a` < (x < y)' '(x < y) > #`a`' 2>&1 ||
echo 'command failed: diff-expr '\''#`a` < (x < y)'\'' '\''(x < y) > #`a`'\'''

echo '$ test-expr '\''#`a` <= (x < y)'\'''
test-expr '#`a` <= (x < y)' 2>&1 ||
echo 'command failed: test-expr '\''#`a` <= (x < y)'\'''

echo '$ diff-expr '\''#`a` <= (x < y)'\'' '\''(x < y) >= #`a`'\'''
diff-expr '#`a` <= (x < y)' '(x < y) >= #`a`' 2>&1 ||
echo 'command failed: diff-expr '\''#`a` <= (x < y)'\'' '\''(x < y) >= #`a`'\'''

echo '$ test-expr '\''#`a` < (x <= y)'\'''
test-expr '#`a` < (x <= y)' 2>&1 ||
echo 'command failed: test-expr '\''#`a` < (x <= y)'\'''

echo '$ diff-expr '\''#`a` < (x <= y)'\'' '\''(x <= y) > #`a`'\'''
diff-expr '#`a` < (x <= y)' '(x <= y) > #`a`' 2>&1 ||
echo 'command failed: diff-expr '\''#`a` < (x <= y)'\'' '\''(x <= y) > #`a`'\'''

echo '$ test-expr '\''#`a` <= (x <= y)'\'''
test-expr '#`a` <= (x <= y)' 2>&1 ||
echo 'command failed: test-expr '\''#`a` <= (x <= y)'\'''

echo '$ diff-expr '\''#`a` <= (x <= y)'\'' '\''(x <= y) >= #`a`'\'''
diff-expr '#`a` <= (x <= y)' '(x <= y) >= #`a`' 2>&1 ||
echo 'command failed: diff-expr '\''#`a` <= (x <= y)'\'' '\''(x <= y) >= #`a`'\'''

echo '$ test-expr '\''#`a` < (x > y)'\'''
test-expr '#`a` < (x > y)' 2>&1 ||
echo 'command failed: test-expr '\''#`a` < (x > y)'\'''

echo '$ diff-expr '\''#`a` < (x > y)'\'' '\''(x > y) > #`a`'\'''
diff-expr '#`a` < (x > y)' '(x > y) > #`a`' 2>&1 ||
echo 'command failed: diff-expr '\''#`a` < (x > y)'\'' '\''(x > y) > #`a`'\'''

echo '$ test-expr '\''#`a` <= (x > y)'\'''
test-expr '#`a` <= (x > y)' 2>&1 ||
echo 'command failed: test-expr '\''#`a` <= (x > y)'\'''

echo '$ diff-expr '\''#`a` <= (x > y)'\'' '\''(x > y) >= #`a`'\'''
diff-expr '#`a` <= (x > y)' '(x > y) >= #`a`' 2>&1 ||
echo 'command failed: diff-expr '\''#`a` <= (x > y)'\'' '\''(x > y) >= #`a`'\'''

echo '$ test-expr '\''#`a` < (x >= y)'\'''
test-expr '#`a` < (x >= y)' 2>&1 ||
echo 'command failed: test-expr '\''#`a` < (x >= y)'\'''

echo '$ diff-expr '\''#`a` < (x >= y)'\'' '\''(x >= y) > #`a`'\'''
diff-expr '#`a` < (x >= y)' '(x >= y) > #`a`' 2>&1 ||
echo 'command failed: diff-expr '\''#`a` < (x >= y)'\'' '\''(x >= y) > #`a`'\'''

echo '$ test-expr '\''#`a` <= (x >= y)'\'''
test-expr '#`a` <= (x >= y)' 2>&1 ||
echo 'command failed: test-expr '\''#`a` <= (x >= y)'\'''

echo '$ diff-expr '\''#`a` <= (x >= y)'\'' '\''(x >= y) >= #`a`'\'''
diff-expr '#`a` <= (x >= y)' '(x >= y) >= #`a`' 2>&1 ||
echo 'command failed: diff-expr '\''#`a` <= (x >= y)'\'' '\''(x >= y) >= #`a`'\'''

echo '$ test-expr '\''#/a/ < #`b`'\'''
test-expr '#/a/ < #`b`' 2>&1 ||
echo 'command failed: test-expr '\''#/a/ < #`b`'\'''

echo '$ diff-expr '\''#/a/ < #`b`'\'' '\''#`b` > #/a/'\'''
diff-expr '#/a/ < #`b`' '#`b` > #/a/' 2>&1 ||
echo 'command failed: diff-expr '\''#/a/ < #`b`'\'' '\''#`b` > #/a/'\'''

echo '$ test-expr '\''#/a/ <= #`b`'\'''
test-expr '#/a/ <= #`b`' 2>&1 ||
echo 'command failed: test-expr '\''#/a/ <= #`b`'\'''

echo '$ diff-expr '\''#/a/ <= #`b`'\'' '\''#`b` >= #/a/'\'''
diff-expr '#/a/ <= #`b`' '#`b` >= #/a/' 2>&1 ||
echo 'command failed: diff-expr '\''#/a/ <= #`b`'\'' '\''#`b` >= #/a/'\'''

echo '$ test-expr '\''#/a/ < #/b/'\'''
test-expr '#/a/ < #/b/' 2>&1 ||
echo 'command failed: test-expr '\''#/a/ < #/b/'\'''

echo '$ diff-expr '\''#/a/ < #/b/'\'' '\''#/b/ > #/a/'\'''
diff-expr '#/a/ < #/b/' '#/b/ > #/a/' 2>&1 ||
echo 'command failed: diff-expr '\''#/a/ < #/b/'\'' '\''#/b/ > #/a/'\'''

echo '$ test-expr '\''#/a/ <= #/b/'\'''
test-expr '#/a/ <= #/b/' 2>&1 ||
echo 'command failed: test-expr '\''#/a/ <= #/b/'\'''

echo '$ diff-expr '\''#/a/ <= #/b/'\'' '\''#/b/ >= #/a/'\'''
diff-expr '#/a/ <= #/b/' '#/b/ >= #/a/' 2>&1 ||
echo 'command failed: diff-expr '\''#/a/ <= #/b/'\'' '\''#/b/ >= #/a/'\'''

echo '$ test-expr '\''#/a/ < b'\'''
test-expr '#/a/ < b' 2>&1 ||
echo 'command failed: test-expr '\''#/a/ < b'\'''

echo '$ diff-expr '\''#/a/ < b'\'' '\''b > #/a/'\'''
diff-expr '#/a/ < b' 'b > #/a/' 2>&1 ||
echo 'command failed: diff-expr '\''#/a/ < b'\'' '\''b > #/a/'\'''

echo '$ test-expr '\''#/a/ <= b'\'''
test-expr '#/a/ <= b' 2>&1 ||
echo 'command failed: test-expr '\''#/a/ <= b'\'''

echo '$ diff-expr '\''#/a/ <= b'\'' '\''b >= #/a/'\'''
diff-expr '#/a/ <= b' 'b >= #/a/' 2>&1 ||
echo 'command failed: diff-expr '\''#/a/ <= b'\'' '\''b >= #/a/'\'''

echo '$ test-expr '\''#/a/ < !b'\'''
test-expr '#/a/ < !b' 2>&1 ||
echo 'command failed: test-expr '\''#/a/ < !b'\'''

echo '$ diff-expr '\''#/a/ < !b'\'' '\''!b > #/a/'\'''
diff-expr '#/a/ < !b' '!b > #/a/' 2>&1 ||
echo 'command failed: diff-expr '\''#/a/ < !b'\'' '\''!b > #/a/'\'''

echo '$ test-expr '\''#/a/ <= !b'\'''
test-expr '#/a/ <= !b' 2>&1 ||
echo 'command failed: test-expr '\''#/a/ <= !b'\'''

echo '$ diff-expr '\''#/a/ <= !b'\'' '\''!b >= #/a/'\'''
diff-expr '#/a/ <= !b' '!b >= #/a/' 2>&1 ||
echo 'command failed: diff-expr '\''#/a/ <= !b'\'' '\''!b >= #/a/'\'''

echo '$ test-expr '\''#/a/ < (x || y)'\'''
test-expr '#/a/ < (x || y)' 2>&1 ||
echo 'command failed: test-expr '\''#/a/ < (x || y)'\'''

echo '$ diff-expr '\''#/a/ < (x || y)'\'' '\''(x || y) > #/a/'\'''
diff-expr '#/a/ < (x || y)' '(x || y) > #/a/' 2>&1 ||
echo 'command failed: diff-expr '\''#/a/ < (x || y)'\'' '\''(x || y) > #/a/'\'''

echo '$ test-expr '\''#/a/ <= (x || y)'\'''
test-expr '#/a/ <= (x || y)' 2>&1 ||
echo 'command failed: test-expr '\''#/a/ <= (x || y)'\'''

echo '$ diff-expr '\''#/a/ <= (x || y)'\'' '\''(x || y) >= #/a/'\'''
diff-expr '#/a/ <= (x || y)' '(x || y) >= #/a/' 2>&1 ||
echo 'command failed: diff-expr '\''#/a/ <= (x || y)'\'' '\''(x || y) >= #/a/'\'''

echo '$ test-expr '\''#/a/ < (x && y)'\'''
test-expr '#/a/ < (x && y)' 2>&1 ||
echo 'command failed: test-expr '\''#/a/ < (x && y)'\'''

echo '$ diff-expr '\''#/a/ < (x && y)'\'' '\''(x && y) > #/a/'\'''
diff-expr '#/a/ < (x && y)' '(x && y) > #/a/' 2>&1 ||
echo 'command failed: diff-expr '\''#/a/ < (x && y)'\'' '\''(x && y) > #/a/'\'''

echo '$ test-expr '\''#/a/ <= (x && y)'\'''
test-expr '#/a/ <= (x && y)' 2>&1 ||
echo 'command failed: test-expr '\''#/a/ <= (x && y)'\'''

echo '$ diff-expr '\''#/a/ <= (x && y)'\'' '\''(x && y) >= #/a/'\'''
diff-expr '#/a/ <= (x && y)' '(x && y) >= #/a/' 2>&1 ||
echo 'command failed: diff-expr '\''#/a/ <= (x && y)'\'' '\''(x && y) >= #/a/'\'''

echo '$ test-expr '\''#/a/ < (x == y)'\'''
test-expr '#/a/ < (x == y)' 2>&1 ||
echo 'command failed: test-expr '\''#/a/ < (x == y)'\'''

echo '$ diff-expr '\''#/a/ < (x == y)'\'' '\''(x == y) > #/a/'\'''
diff-expr '#/a/ < (x == y)' '(x == y) > #/a/' 2>&1 ||
echo 'command failed: diff-expr '\''#/a/ < (x == y)'\'' '\''(x == y) > #/a/'\'''

echo '$ test-expr '\''#/a/ <= (x == y)'\'''
test-expr '#/a/ <= (x == y)' 2>&1 ||
echo 'command failed: test-expr '\''#/a/ <= (x == y)'\'''

echo '$ diff-expr '\''#/a/ <= (x == y)'\'' '\''(x == y) >= #/a/'\'''
diff-expr '#/a/ <= (x == y)' '(x == y) >= #/a/' 2>&1 ||
echo 'command failed: diff-expr '\''#/a/ <= (x == y)'\'' '\''(x == y) >= #/a/'\'''

echo '$ test-expr '\''#/a/ < (x != y)'\'''
test-expr '#/a/ < (x != y)' 2>&1 ||
echo 'command failed: test-expr '\''#/a/ < (x != y)'\'''

echo '$ diff-expr '\''#/a/ < (x != y)'\'' '\''(x != y) > #/a/'\'''
diff-expr '#/a/ < (x != y)' '(x != y) > #/a/' 2>&1 ||
echo 'command failed: diff-expr '\''#/a/ < (x != y)'\'' '\''(x != y) > #/a/'\'''

echo '$ test-expr '\''#/a/ <= (x != y)'\'''
test-expr '#/a/ <= (x != y)' 2>&1 ||
echo 'command failed: test-expr '\''#/a/ <= (x != y)'\'''

echo '$ diff-expr '\''#/a/ <= (x != y)'\'' '\''(x != y) >= #/a/'\'''
diff-expr '#/a/ <= (x != y)' '(x != y) >= #/a/' 2>&1 ||
echo 'command failed: diff-expr '\''#/a/ <= (x != y)'\'' '\''(x != y) >= #/a/'\'''

echo '$ test-expr '\''#/a/ < (x < y)'\'''
test-expr '#/a/ < (x < y)' 2>&1 ||
echo 'command failed: test-expr '\''#/a/ < (x < y)'\'''

echo '$ diff-expr '\''#/a/ < (x < y)'\'' '\''(x < y) > #/a/'\'''
diff-expr '#/a/ < (x < y)' '(x < y) > #/a/' 2>&1 ||
echo 'command failed: diff-expr '\''#/a/ < (x < y)'\'' '\''(x < y) > #/a/'\'''

echo '$ test-expr '\''#/a/ <= (x < y)'\'''
test-expr '#/a/ <= (x < y)' 2>&1 ||
echo 'command failed: test-expr '\''#/a/ <= (x < y)'\'''

echo '$ diff-expr '\''#/a/ <= (x < y)'\'' '\''(x < y) >= #/a/'\'''
diff-expr '#/a/ <= (x < y)' '(x < y) >= #/a/' 2>&1 ||
echo 'command failed: diff-expr '\''#/a/ <= (x < y)'\'' '\''(x < y) >= #/a/'\'''

echo '$ test-expr '\''#/a/ < (x <= y)'\'''
test-expr '#/a/ < (x <= y)' 2>&1 ||
echo 'command failed: test-expr '\''#/a/ < (x <= y)'\'''

echo '$ diff-expr '\''#/a/ < (x <= y)'\'' '\''(x <= y) > #/a/'\'''
diff-expr '#/a/ < (x <= y)' '(x <= y) > #/a/' 2>&1 ||
echo 'command failed: diff-expr '\''#/a/ < (x <= y)'\'' '\''(x <= y) > #/a/'\'''

echo '$ test-expr '\''#/a/ <= (x <= y)'\'''
test-expr '#/a/ <= (x <= y)' 2>&1 ||
echo 'command failed: test-expr '\''#/a/ <= (x <= y)'\'''

echo '$ diff-expr '\''#/a/ <= (x <= y)'\'' '\''(x <= y) >= #/a/'\'''
diff-expr '#/a/ <= (x <= y)' '(x <= y) >= #/a/' 2>&1 ||
echo 'command failed: diff-expr '\''#/a/ <= (x <= y)'\'' '\''(x <= y) >= #/a/'\'''

echo '$ test-expr '\''#/a/ < (x > y)'\'''
test-expr '#/a/ < (x > y)' 2>&1 ||
echo 'command failed: test-expr '\''#/a/ < (x > y)'\'''

echo '$ diff-expr '\''#/a/ < (x > y)'\'' '\''(x > y) > #/a/'\'''
diff-expr '#/a/ < (x > y)' '(x > y) > #/a/' 2>&1 ||
echo 'command failed: diff-expr '\''#/a/ < (x > y)'\'' '\''(x > y) > #/a/'\'''

echo '$ test-expr '\''#/a/ <= (x > y)'\'''
test-expr '#/a/ <= (x > y)' 2>&1 ||
echo 'command failed: test-expr '\''#/a/ <= (x > y)'\'''

echo '$ diff-expr '\''#/a/ <= (x > y)'\'' '\''(x > y) >= #/a/'\'''
diff-expr '#/a/ <= (x > y)' '(x > y) >= #/a/' 2>&1 ||
echo 'command failed: diff-expr '\''#/a/ <= (x > y)'\'' '\''(x > y) >= #/a/'\'''

echo '$ test-expr '\''#/a/ < (x >= y)'\'''
test-expr '#/a/ < (x >= y)' 2>&1 ||
echo 'command failed: test-expr '\''#/a/ < (x >= y)'\'''

echo '$ diff-expr '\''#/a/ < (x >= y)'\'' '\''(x >= y) > #/a/'\'''
diff-expr '#/a/ < (x >= y)' '(x >= y) > #/a/' 2>&1 ||
echo 'command failed: diff-expr '\''#/a/ < (x >= y)'\'' '\''(x >= y) > #/a/'\'''

echo '$ test-expr '\''#/a/ <= (x >= y)'\'''
test-expr '#/a/ <= (x >= y)' 2>&1 ||
echo 'command failed: test-expr '\''#/a/ <= (x >= y)'\'''

echo '$ diff-expr '\''#/a/ <= (x >= y)'\'' '\''(x >= y) >= #/a/'\'''
diff-expr '#/a/ <= (x >= y)' '(x >= y) >= #/a/' 2>&1 ||
echo 'command failed: diff-expr '\''#/a/ <= (x >= y)'\'' '\''(x >= y) >= #/a/'\'''

echo '$ test-expr '\''a < #`b`'\'''
test-expr 'a < #`b`' 2>&1 ||
echo 'command failed: test-expr '\''a < #`b`'\'''

echo '$ diff-expr '\''a < #`b`'\'' '\''#`b` > a'\'''
diff-expr 'a < #`b`' '#`b` > a' 2>&1 ||
echo 'command failed: diff-expr '\''a < #`b`'\'' '\''#`b` > a'\'''

echo '$ test-expr '\''a <= #`b`'\'''
test-expr 'a <= #`b`' 2>&1 ||
echo 'command failed: test-expr '\''a <= #`b`'\'''

echo '$ diff-expr '\''a <= #`b`'\'' '\''#`b` >= a'\'''
diff-expr 'a <= #`b`' '#`b` >= a' 2>&1 ||
echo 'command failed: diff-expr '\''a <= #`b`'\'' '\''#`b` >= a'\'''

echo '$ test-expr '\''a < #/b/'\'''
test-expr 'a < #/b/' 2>&1 ||
echo 'command failed: test-expr '\''a < #/b/'\'''

echo '$ diff-expr '\''a < #/b/'\'' '\''#/b/ > a'\'''
diff-expr 'a < #/b/' '#/b/ > a' 2>&1 ||
echo 'command failed: diff-expr '\''a < #/b/'\'' '\''#/b/ > a'\'''

echo '$ test-expr '\''a <= #/b/'\'''
test-expr 'a <= #/b/' 2>&1 ||
echo 'command failed: test-expr '\''a <= #/b/'\'''

echo '$ diff-expr '\''a <= #/b/'\'' '\''#/b/ >= a'\'''
diff-expr 'a <= #/b/' '#/b/ >= a' 2>&1 ||
echo 'command failed: diff-expr '\''a <= #/b/'\'' '\''#/b/ >= a'\'''

echo '$ test-expr '\''!a < #`b`'\'''
test-expr '!a < #`b`' 2>&1 ||
echo 'command failed: test-expr '\''!a < #`b`'\'''

echo '$ diff-expr '\''!a < #`b`'\'' '\''#`b` > !a'\'''
diff-expr '!a < #`b`' '#`b` > !a' 2>&1 ||
echo 'command failed: diff-expr '\''!a < #`b`'\'' '\''#`b` > !a'\'''

echo '$ test-expr '\''!a <= #`b`'\'''
test-expr '!a <= #`b`' 2>&1 ||
echo 'command failed: test-expr '\''!a <= #`b`'\'''

echo '$ diff-expr '\''!a <= #`b`'\'' '\''#`b` >= !a'\'''
diff-expr '!a <= #`b`' '#`b` >= !a' 2>&1 ||
echo 'command failed: diff-expr '\''!a <= #`b`'\'' '\''#`b` >= !a'\'''

echo '$ test-expr '\''!a < #/b/'\'''
test-expr '!a < #/b/' 2>&1 ||
echo 'command failed: test-expr '\''!a < #/b/'\'''

echo '$ diff-expr '\''!a < #/b/'\'' '\''#/b/ > !a'\'''
diff-expr '!a < #/b/' '#/b/ > !a' 2>&1 ||
echo 'command failed: diff-expr '\''!a < #/b/'\'' '\''#/b/ > !a'\'''

echo '$ test-expr '\''!a <= #/b/'\'''
test-expr '!a <= #/b/' 2>&1 ||
echo 'command failed: test-expr '\''!a <= #/b/'\'''

echo '$ diff-expr '\''!a <= #/b/'\'' '\''#/b/ >= !a'\'''
diff-expr '!a <= #/b/' '#/b/ >= !a' 2>&1 ||
echo 'command failed: diff-expr '\''!a <= #/b/'\'' '\''#/b/ >= !a'\'''

echo '$ test-expr '\''(x || y) < #`b`'\'''
test-expr '(x || y) < #`b`' 2>&1 ||
echo 'command failed: test-expr '\''(x || y) < #`b`'\'''

echo '$ diff-expr '\''(x || y) < #`b`'\'' '\''#`b` > (x || y)'\'''
diff-expr '(x || y) < #`b`' '#`b` > (x || y)' 2>&1 ||
echo 'command failed: diff-expr '\''(x || y) < #`b`'\'' '\''#`b` > (x || y)'\'''

echo '$ test-expr '\''(x || y) <= #`b`'\'''
test-expr '(x || y) <= #`b`' 2>&1 ||
echo 'command failed: test-expr '\''(x || y) <= #`b`'\'''

echo '$ diff-expr '\''(x || y) <= #`b`'\'' '\''#`b` >= (x || y)'\'''
diff-expr '(x || y) <= #`b`' '#`b` >= (x || y)' 2>&1 ||
echo 'command failed: diff-expr '\''(x || y) <= #`b`'\'' '\''#`b` >= (x || y)'\'''

echo '$ test-expr '\''(x || y) < #/b/'\'''
test-expr '(x || y) < #/b/' 2>&1 ||
echo 'command failed: test-expr '\''(x || y) < #/b/'\'''

echo '$ diff-expr '\''(x || y) < #/b/'\'' '\''#/b/ > (x || y)'\'''
diff-expr '(x || y) < #/b/' '#/b/ > (x || y)' 2>&1 ||
echo 'command failed: diff-expr '\''(x || y) < #/b/'\'' '\''#/b/ > (x || y)'\'''

echo '$ test-expr '\''(x || y) <= #/b/'\'''
test-expr '(x || y) <= #/b/' 2>&1 ||
echo 'command failed: test-expr '\''(x || y) <= #/b/'\'''

echo '$ diff-expr '\''(x || y) <= #/b/'\'' '\''#/b/ >= (x || y)'\'''
diff-expr '(x || y) <= #/b/' '#/b/ >= (x || y)' 2>&1 ||
echo 'command failed: diff-expr '\''(x || y) <= #/b/'\'' '\''#/b/ >= (x || y)'\'''

echo '$ test-expr '\''(x && y) < #`b`'\'''
test-expr '(x && y) < #`b`' 2>&1 ||
echo 'command failed: test-expr '\''(x && y) < #`b`'\'''

echo '$ diff-expr '\''(x && y) < #`b`'\'' '\''#`b` > (x && y)'\'''
diff-expr '(x && y) < #`b`' '#`b` > (x && y)' 2>&1 ||
echo 'command failed: diff-expr '\''(x && y) < #`b`'\'' '\''#`b` > (x && y)'\'''

echo '$ test-expr '\''(x && y) <= #`b`'\'''
test-expr '(x && y) <= #`b`' 2>&1 ||
echo 'command failed: test-expr '\''(x && y) <= #`b`'\'''

echo '$ diff-expr '\''(x && y) <= #`b`'\'' '\''#`b` >= (x && y)'\'''
diff-expr '(x && y) <= #`b`' '#`b` >= (x && y)' 2>&1 ||
echo 'command failed: diff-expr '\''(x && y) <= #`b`'\'' '\''#`b` >= (x && y)'\'''

echo '$ test-expr '\''(x && y) < #/b/'\'''
test-expr '(x && y) < #/b/' 2>&1 ||
echo 'command failed: test-expr '\''(x && y) < #/b/'\'''

echo '$ diff-expr '\''(x && y) < #/b/'\'' '\''#/b/ > (x && y)'\'''
diff-expr '(x && y) < #/b/' '#/b/ > (x && y)' 2>&1 ||
echo 'command failed: diff-expr '\''(x && y) < #/b/'\'' '\''#/b/ > (x && y)'\'''

echo '$ test-expr '\''(x && y) <= #/b/'\'''
test-expr '(x && y) <= #/b/' 2>&1 ||
echo 'command failed: test-expr '\''(x && y) <= #/b/'\'''

echo '$ diff-expr '\''(x && y) <= #/b/'\'' '\''#/b/ >= (x && y)'\'''
diff-expr '(x && y) <= #/b/' '#/b/ >= (x && y)' 2>&1 ||
echo 'command failed: diff-expr '\''(x && y) <= #/b/'\'' '\''#/b/ >= (x && y)'\'''

echo '$ test-expr '\''(x == y) < #`b`'\'''
test-expr '(x == y) < #`b`' 2>&1 ||
echo 'command failed: test-expr '\''(x == y) < #`b`'\'''

echo '$ diff-expr '\''(x == y) < #`b`'\'' '\''#`b` > (x == y)'\'''
diff-expr '(x == y) < #`b`' '#`b` > (x == y)' 2>&1 ||
echo 'command failed: diff-expr '\''(x == y) < #`b`'\'' '\''#`b` > (x == y)'\'''

echo '$ test-expr '\''(x == y) <= #`b`'\'''
test-expr '(x == y) <= #`b`' 2>&1 ||
echo 'command failed: test-expr '\''(x == y) <= #`b`'\'''

echo '$ diff-expr '\''(x == y) <= #`b`'\'' '\''#`b` >= (x == y)'\'''
diff-expr '(x == y) <= #`b`' '#`b` >= (x == y)' 2>&1 ||
echo 'command failed: diff-expr '\''(x == y) <= #`b`'\'' '\''#`b` >= (x == y)'\'''

echo '$ test-expr '\''(x == y) < #/b/'\'''
test-expr '(x == y) < #/b/' 2>&1 ||
echo 'command failed: test-expr '\''(x == y) < #/b/'\'''

echo '$ diff-expr '\''(x == y) < #/b/'\'' '\''#/b/ > (x == y)'\'''
diff-expr '(x == y) < #/b/' '#/b/ > (x == y)' 2>&1 ||
echo 'command failed: diff-expr '\''(x == y) < #/b/'\'' '\''#/b/ > (x == y)'\'''

echo '$ test-expr '\''(x == y) <= #/b/'\'''
test-expr '(x == y) <= #/b/' 2>&1 ||
echo 'command failed: test-expr '\''(x == y) <= #/b/'\'''

echo '$ diff-expr '\''(x == y) <= #/b/'\'' '\''#/b/ >= (x == y)'\'''
diff-expr '(x == y) <= #/b/' '#/b/ >= (x == y)' 2>&1 ||
echo 'command failed: diff-expr '\''(x == y) <= #/b/'\'' '\''#/b/ >= (x == y)'\'''

echo '$ test-expr '\''(x != y) < #`b`'\'''
test-expr '(x != y) < #`b`' 2>&1 ||
echo 'command failed: test-expr '\''(x != y) < #`b`'\'''

echo '$ diff-expr '\''(x != y) < #`b`'\'' '\''#`b` > (x != y)'\'''
diff-expr '(x != y) < #`b`' '#`b` > (x != y)' 2>&1 ||
echo 'command failed: diff-expr '\''(x != y) < #`b`'\'' '\''#`b` > (x != y)'\'''

echo '$ test-expr '\''(x != y) <= #`b`'\'''
test-expr '(x != y) <= #`b`' 2>&1 ||
echo 'command failed: test-expr '\''(x != y) <= #`b`'\'''

echo '$ diff-expr '\''(x != y) <= #`b`'\'' '\''#`b` >= (x != y)'\'''
diff-expr '(x != y) <= #`b`' '#`b` >= (x != y)' 2>&1 ||
echo 'command failed: diff-expr '\''(x != y) <= #`b`'\'' '\''#`b` >= (x != y)'\'''

echo '$ test-expr '\''(x != y) < #/b/'\'''
test-expr '(x != y) < #/b/' 2>&1 ||
echo 'command failed: test-expr '\''(x != y) < #/b/'\'''

echo '$ diff-expr '\''(x != y) < #/b/'\'' '\''#/b/ > (x != y)'\'''
diff-expr '(x != y) < #/b/' '#/b/ > (x != y)' 2>&1 ||
echo 'command failed: diff-expr '\''(x != y) < #/b/'\'' '\''#/b/ > (x != y)'\'''

echo '$ test-expr '\''(x != y) <= #/b/'\'''
test-expr '(x != y) <= #/b/' 2>&1 ||
echo 'command failed: test-expr '\''(x != y) <= #/b/'\'''

echo '$ diff-expr '\''(x != y) <= #/b/'\'' '\''#/b/ >= (x != y)'\'''
diff-expr '(x != y) <= #/b/' '#/b/ >= (x != y)' 2>&1 ||
echo 'command failed: diff-expr '\''(x != y) <= #/b/'\'' '\''#/b/ >= (x != y)'\'''

echo '$ test-expr '\''(x < y) < #`b`'\'''
test-expr '(x < y) < #`b`' 2>&1 ||
echo 'command failed: test-expr '\''(x < y) < #`b`'\'''

echo '$ diff-expr '\''(x < y) < #`b`'\'' '\''#`b` > (x < y)'\'''
diff-expr '(x < y) < #`b`' '#`b` > (x < y)' 2>&1 ||
echo 'command failed: diff-expr '\''(x < y) < #`b`'\'' '\''#`b` > (x < y)'\'''

echo '$ test-expr '\''(x < y) <= #`b`'\'''
test-expr '(x < y) <= #`b`' 2>&1 ||
echo 'command failed: test-expr '\''(x < y) <= #`b`'\'''

echo '$ diff-expr '\''(x < y) <= #`b`'\'' '\''#`b` >= (x < y)'\'''
diff-expr '(x < y) <= #`b`' '#`b` >= (x < y)' 2>&1 ||
echo 'command failed: diff-expr '\''(x < y) <= #`b`'\'' '\''#`b` >= (x < y)'\'''

echo '$ test-expr '\''(x < y) < #/b/'\'''
test-expr '(x < y) < #/b/' 2>&1 ||
echo 'command failed: test-expr '\''(x < y) < #/b/'\'''

echo '$ diff-expr '\''(x < y) < #/b/'\'' '\''#/b/ > (x < y)'\'''
diff-expr '(x < y) < #/b/' '#/b/ > (x < y)' 2>&1 ||
echo 'command failed: diff-expr '\''(x < y) < #/b/'\'' '\''#/b/ > (x < y)'\'''

echo '$ test-expr '\''(x < y) <= #/b/'\'''
test-expr '(x < y) <= #/b/' 2>&1 ||
echo 'command failed: test-expr '\''(x < y) <= #/b/'\'''

echo '$ diff-expr '\''(x < y) <= #/b/'\'' '\''#/b/ >= (x < y)'\'''
diff-expr '(x < y) <= #/b/' '#/b/ >= (x < y)' 2>&1 ||
echo 'command failed: diff-expr '\''(x < y) <= #/b/'\'' '\''#/b/ >= (x < y)'\'''

echo '$ test-expr '\''(x <= y) < #`b`'\'''
test-expr '(x <= y) < #`b`' 2>&1 ||
echo 'command failed: test-expr '\''(x <= y) < #`b`'\'''

echo '$ diff-expr '\''(x <= y) < #`b`'\'' '\''#`b` > (x <= y)'\'''
diff-expr '(x <= y) < #`b`' '#`b` > (x <= y)' 2>&1 ||
echo 'command failed: diff-expr '\''(x <= y) < #`b`'\'' '\''#`b` > (x <= y)'\'''

echo '$ test-expr '\''(x <= y) <= #`b`'\'''
test-expr '(x <= y) <= #`b`' 2>&1 ||
echo 'command failed: test-expr '\''(x <= y) <= #`b`'\'''

echo '$ diff-expr '\''(x <= y) <= #`b`'\'' '\''#`b` >= (x <= y)'\'''
diff-expr '(x <= y) <= #`b`' '#`b` >= (x <= y)' 2>&1 ||
echo 'command failed: diff-expr '\''(x <= y) <= #`b`'\'' '\''#`b` >= (x <= y)'\'''

echo '$ test-expr '\''(x <= y) < #/b/'\'''
test-expr '(x <= y) < #/b/' 2>&1 ||
echo 'command failed: test-expr '\''(x <= y) < #/b/'\'''

echo '$ diff-expr '\''(x <= y) < #/b/'\'' '\''#/b/ > (x <= y)'\'''
diff-expr '(x <= y) < #/b/' '#/b/ > (x <= y)' 2>&1 ||
echo 'command failed: diff-expr '\''(x <= y) < #/b/'\'' '\''#/b/ > (x <= y)'\'''

echo '$ test-expr '\''(x <= y) <= #/b/'\'''
test-expr '(x <= y) <= #/b/' 2>&1 ||
echo 'command failed: test-expr '\''(x <= y) <= #/b/'\'''

echo '$ diff-expr '\''(x <= y) <= #/b/'\'' '\''#/b/ >= (x <= y)'\'''
diff-expr '(x <= y) <= #/b/' '#/b/ >= (x <= y)' 2>&1 ||
echo 'command failed: diff-expr '\''(x <= y) <= #/b/'\'' '\''#/b/ >= (x <= y)'\'''

echo '$ test-expr '\''(x > y) < #`b`'\'''
test-expr '(x > y) < #`b`' 2>&1 ||
echo 'command failed: test-expr '\''(x > y) < #`b`'\'''

echo '$ diff-expr '\''(x > y) < #`b`'\'' '\''#`b` > (x > y)'\'''
diff-expr '(x > y) < #`b`' '#`b` > (x > y)' 2>&1 ||
echo 'command failed: diff-expr '\''(x > y) < #`b`'\'' '\''#`b` > (x > y)'\'''

echo '$ test-expr '\''(x > y) <= #`b`'\'''
test-expr '(x > y) <= #`b`' 2>&1 ||
echo 'command failed: test-expr '\''(x > y) <= #`b`'\'''

echo '$ diff-expr '\''(x > y) <= #`b`'\'' '\''#`b` >= (x > y)'\'''
diff-expr '(x > y) <= #`b`' '#`b` >= (x > y)' 2>&1 ||
echo 'command failed: diff-expr '\''(x > y) <= #`b`'\'' '\''#`b` >= (x > y)'\'''

echo '$ test-expr '\''(x > y) < #/b/'\'''
test-expr '(x > y) < #/b/' 2>&1 ||
echo 'command failed: test-expr '\''(x > y) < #/b/'\'''

echo '$ diff-expr '\''(x > y) < #/b/'\'' '\''#/b/ > (x > y)'\'''
diff-expr '(x > y) < #/b/' '#/b/ > (x > y)' 2>&1 ||
echo 'command failed: diff-expr '\''(x > y) < #/b/'\'' '\''#/b/ > (x > y)'\'''

echo '$ test-expr '\''(x > y) <= #/b/'\'''
test-expr '(x > y) <= #/b/' 2>&1 ||
echo 'command failed: test-expr '\''(x > y) <= #/b/'\'''

echo '$ diff-expr '\''(x > y) <= #/b/'\'' '\''#/b/ >= (x > y)'\'''
diff-expr '(x > y) <= #/b/' '#/b/ >= (x > y)' 2>&1 ||
echo 'command failed: diff-expr '\''(x > y) <= #/b/'\'' '\''#/b/ >= (x > y)'\'''

echo '$ test-expr '\''(x >= y) < #`b`'\'''
test-expr '(x >= y) < #`b`' 2>&1 ||
echo 'command failed: test-expr '\''(x >= y) < #`b`'\'''

echo '$ diff-expr '\''(x >= y) < #`b`'\'' '\''#`b` > (x >= y)'\'''
diff-expr '(x >= y) < #`b`' '#`b` > (x >= y)' 2>&1 ||
echo 'command failed: diff-expr '\''(x >= y) < #`b`'\'' '\''#`b` > (x >= y)'\'''

echo '$ test-expr '\''(x >= y) <= #`b`'\'''
test-expr '(x >= y) <= #`b`' 2>&1 ||
echo 'command failed: test-expr '\''(x >= y) <= #`b`'\'''

echo '$ diff-expr '\''(x >= y) <= #`b`'\'' '\''#`b` >= (x >= y)'\'''
diff-expr '(x >= y) <= #`b`' '#`b` >= (x >= y)' 2>&1 ||
echo 'command failed: diff-expr '\''(x >= y) <= #`b`'\'' '\''#`b` >= (x >= y)'\'''

echo '$ test-expr '\''(x >= y) < #/b/'\'''
test-expr '(x >= y) < #/b/' 2>&1 ||
echo 'command failed: test-expr '\''(x >= y) < #/b/'\'''

echo '$ diff-expr '\''(x >= y) < #/b/'\'' '\''#/b/ > (x >= y)'\'''
diff-expr '(x >= y) < #/b/' '#/b/ > (x >= y)' 2>&1 ||
echo 'command failed: diff-expr '\''(x >= y) < #/b/'\'' '\''#/b/ > (x >= y)'\'''

echo '$ test-expr '\''(x >= y) <= #/b/'\'''
test-expr '(x >= y) <= #/b/' 2>&1 ||
echo 'command failed: test-expr '\''(x >= y) <= #/b/'\'''

echo '$ diff-expr '\''(x >= y) <= #/b/'\'' '\''#/b/ >= (x >= y)'\'''
diff-expr '(x >= y) <= #/b/' '#/b/ >= (x >= y)' 2>&1 ||
echo 'command failed: diff-expr '\''(x >= y) <= #/b/'\'' '\''#/b/ >= (x >= y)'\'''
)

