#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020, 2021  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C parser:number3
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L number3.old <(echo \
'$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }
$ json() { json0 --literal-value "$@"; }
$ echo 00|json -b 1
json: error: <stdin>:1:2: parse error: multiple objects are not allowed
json: error: <stdin>:1:2: 00
json: error: <stdin>:1:2:  ^
0
command failed: echo 00|json -b 1
$ echo 01|json -b 1
json: error: <stdin>:1:2: parse error: multiple objects are not allowed
json: error: <stdin>:1:2: 01
json: error: <stdin>:1:2:  ^
0
command failed: echo 01|json -b 1
$ echo 02|json -b 1
json: error: <stdin>:1:2: parse error: multiple objects are not allowed
json: error: <stdin>:1:2: 02
json: error: <stdin>:1:2:  ^
0
command failed: echo 02|json -b 1
$ echo 03|json -b 1
json: error: <stdin>:1:2: parse error: multiple objects are not allowed
json: error: <stdin>:1:2: 03
json: error: <stdin>:1:2:  ^
0
command failed: echo 03|json -b 1
$ echo 04|json -b 1
json: error: <stdin>:1:2: parse error: multiple objects are not allowed
json: error: <stdin>:1:2: 04
json: error: <stdin>:1:2:  ^
0
command failed: echo 04|json -b 1
$ echo 05|json -b 1
json: error: <stdin>:1:2: parse error: multiple objects are not allowed
json: error: <stdin>:1:2: 05
json: error: <stdin>:1:2:  ^
0
command failed: echo 05|json -b 1
$ echo 06|json -b 1
json: error: <stdin>:1:2: parse error: multiple objects are not allowed
json: error: <stdin>:1:2: 06
json: error: <stdin>:1:2:  ^
0
command failed: echo 06|json -b 1
$ echo 07|json -b 1
json: error: <stdin>:1:2: parse error: multiple objects are not allowed
json: error: <stdin>:1:2: 07
json: error: <stdin>:1:2:  ^
0
command failed: echo 07|json -b 1
$ echo 08|json -b 1
json: error: <stdin>:1:2: parse error: multiple objects are not allowed
json: error: <stdin>:1:2: 08
json: error: <stdin>:1:2:  ^
0
command failed: echo 08|json -b 1
$ echo 09|json -b 1
json: error: <stdin>:1:2: parse error: multiple objects are not allowed
json: error: <stdin>:1:2: 09
json: error: <stdin>:1:2:  ^
0
command failed: echo 09|json -b 1'
) -L number3.new <(
echo '$ json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'
json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; } 2>&1 ||
echo 'command failed: json0() { LD_LIBRARY_PATH=../lib ../src/json --pretty --verbose "$@"; }'

echo '$ json() { json0 --literal-value "$@"; }'
json() { json0 --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { json0 --literal-value "$@"; }'

echo '$ echo 00|json -b 1'
echo 00|json -b 1 2>&1 ||
echo 'command failed: echo 00|json -b 1'

echo '$ echo 01|json -b 1'
echo 01|json -b 1 2>&1 ||
echo 'command failed: echo 01|json -b 1'

echo '$ echo 02|json -b 1'
echo 02|json -b 1 2>&1 ||
echo 'command failed: echo 02|json -b 1'

echo '$ echo 03|json -b 1'
echo 03|json -b 1 2>&1 ||
echo 'command failed: echo 03|json -b 1'

echo '$ echo 04|json -b 1'
echo 04|json -b 1 2>&1 ||
echo 'command failed: echo 04|json -b 1'

echo '$ echo 05|json -b 1'
echo 05|json -b 1 2>&1 ||
echo 'command failed: echo 05|json -b 1'

echo '$ echo 06|json -b 1'
echo 06|json -b 1 2>&1 ||
echo 'command failed: echo 06|json -b 1'

echo '$ echo 07|json -b 1'
echo 07|json -b 1 2>&1 ||
echo 'command failed: echo 07|json -b 1'

echo '$ echo 08|json -b 1'
echo 08|json -b 1 2>&1 ||
echo 'command failed: echo 08|json -b 1'

echo '$ echo 09|json -b 1'
echo 09|json -b 1 2>&1 ||
echo 'command failed: echo 09|json -b 1'
)

