#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020, 2021  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C bugs:16
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L 16.old <(echo \
'$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '\''/error:/s|(/dev/fd/)[0-9]+|\1??|'\''; }
$ json -d '\''{"type":"list","args":[{"type":"array","args":{"type":"array","args":"number"}},{"type":"array","args":{"type":"array","args":"string"}}]}'\'' <<< '\''[[""]]'\''
json: error: <text>:1:47: type lib error: attribute error: invalid "list" type object: sort of array of array type not yet supported (the other inner array is at 1:104)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"type":"array","args":"number"}},{"type":"array","args":{"type":"array","args":"string"}}]}'\'' <<< '\''[[""]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":{"type":"array","args":["number"]}},{"type":"array","args":{"type":"array","args":["string"]}}]}'\'' <<< '\''[[""]]'\''
json: error: <text>:1:47: type lib error: attribute error: invalid "list" type object: sort of array of array type not yet supported (the other inner array is at 1:106)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"type":"array","args":["number"]}},{"type":"array","args":{"type":"array","args":["string"]}}]}'\'' <<< '\''[[""]]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"number"}]}},{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"string"}]}}]}'\'' <<< '\''[{"foo":""}]'\''
json: error: <text>:1:47: type lib error: attribute error: invalid "list" type object: sort of array of object type not yet supported (the other inner object is at 1:129)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"number"}]}},{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"string"}]}}]}'\'' <<< '\''[{"foo":""}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"number"}]}},{"type":"array","args":{"type":"object","args":[{"name":"bar","type":"string"}]}}]}'\'' <<< '\''[{"bar":""}]'\''
json: error: <text>:1:129: type lib error: attribute error: invalid "list" type object: sort of array of object type not yet supported (the other inner object is at 1:47)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"number"}]}},{"type":"array","args":{"type":"object","args":[{"name":"bar","type":"string"}]}}]}'\'' <<< '\''[{"bar":""}]'\''
$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"type":"array","args":"number"}]},{"type":"array","args":["boolean",{"type":"array","args":"string"}]}]}'\'' <<< '\''[false,[""]]'\''
json: error: <text>:1:58: type lib error: attribute error: invalid "list" type object: sort of array of array type not yet supported (the other inner array is at 1:127)
command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"type":"array","args":"number"}]},{"type":"array","args":["boolean",{"type":"array","args":"string"}]}]}'\'' <<< '\''[false,[""]]'\'''
) -L 16.new <(
echo '$ json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '\''/error:/s|(/dev/fd/)[0-9]+|\1??|'\''; }'
json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '/error:/s|(/dev/fd/)[0-9]+|\1??|'; } 2>&1 ||
echo 'command failed: json() { set -o pipefail && LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@" 2>&1|sed -r '\''/error:/s|(/dev/fd/)[0-9]+|\1??|'\''; }'

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":{"type":"array","args":"number"}},{"type":"array","args":{"type":"array","args":"string"}}]}'\'' <<< '\''[[""]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":{"type":"array","args":"number"}},{"type":"array","args":{"type":"array","args":"string"}}]}' <<< '[[""]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"type":"array","args":"number"}},{"type":"array","args":{"type":"array","args":"string"}}]}'\'' <<< '\''[[""]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":{"type":"array","args":["number"]}},{"type":"array","args":{"type":"array","args":["string"]}}]}'\'' <<< '\''[[""]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":{"type":"array","args":["number"]}},{"type":"array","args":{"type":"array","args":["string"]}}]}' <<< '[[""]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"type":"array","args":["number"]}},{"type":"array","args":{"type":"array","args":["string"]}}]}'\'' <<< '\''[[""]]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"number"}]}},{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"string"}]}}]}'\'' <<< '\''[{"foo":""}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"number"}]}},{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"string"}]}}]}' <<< '[{"foo":""}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"number"}]}},{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"string"}]}}]}'\'' <<< '\''[{"foo":""}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"number"}]}},{"type":"array","args":{"type":"object","args":[{"name":"bar","type":"string"}]}}]}'\'' <<< '\''[{"bar":""}]'\'''
json -d '{"type":"list","args":[{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"number"}]}},{"type":"array","args":{"type":"object","args":[{"name":"bar","type":"string"}]}}]}' <<< '[{"bar":""}]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":{"type":"object","args":[{"name":"foo","type":"number"}]}},{"type":"array","args":{"type":"object","args":[{"name":"bar","type":"string"}]}}]}'\'' <<< '\''[{"bar":""}]'\'''

echo '$ json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"type":"array","args":"number"}]},{"type":"array","args":["boolean",{"type":"array","args":"string"}]}]}'\'' <<< '\''[false,[""]]'\'''
json -d '{"type":"list","args":[{"type":"array","args":["boolean",{"type":"array","args":"number"}]},{"type":"array","args":["boolean",{"type":"array","args":"string"}]}]}' <<< '[false,[""]]' 2>&1 ||
echo 'command failed: json -d '\''{"type":"list","args":[{"type":"array","args":["boolean",{"type":"array","args":"number"}]},{"type":"array","args":["boolean",{"type":"array","args":"string"}]}]}'\'' <<< '\''[false,[""]]'\'''
)

