#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020, 2021  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C trie:gen-code-expanded-base
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L gen-code-expanded-base.old <(echo \
'$ test -x ../lib/test-trie
$ print() { printf '\''%s\n'\'' "$@"; }
$ set -o pipefail
$ test-trie() { ../lib/test-trie -G --expanded-path; }
$ echo -n|test-trie
    return NULL;
$ print a|test-trie
    if (*p ++ == '\''a'\'' &&
        *p == 0)
        return "a";
    return NULL;
$ print a b|test-trie
    switch (*p ++) {
    case '\''a'\'':
        if (*p == 0)
            return "a";
        return NULL;
    case '\''b'\'':
        if (*p == 0)
            return "b";
    }
    return NULL;
$ print a b c|test-trie
    switch (*p ++) {
    case '\''a'\'':
        if (*p == 0)
            return "a";
        return NULL;
    case '\''b'\'':
        if (*p == 0)
            return "b";
        return NULL;
    case '\''c'\'':
        if (*p == 0)
            return "c";
    }
    return NULL;
$ print a ab abc|test-trie
    if (*p ++ == '\''a'\'') {
        if (*p == 0)
            return "a";
        if (*p ++ == '\''b'\'') {
            if (*p == 0)
                return "ab";
            if (*p ++ == '\''c'\'' &&
                *p == 0)
                return "abc";
        }
    }
    return NULL;
$ print a ab ac|test-trie
    if (*p ++ == '\''a'\'') {
        if (*p == 0)
            return "a";
        switch (*p ++) {
        case '\''b'\'':
            if (*p == 0)
                return "ab";
            return NULL;
        case '\''c'\'':
            if (*p == 0)
                return "ac";
        }
    }
    return NULL;
$ print a ab ac ad|test-trie
    if (*p ++ == '\''a'\'') {
        if (*p == 0)
            return "a";
        switch (*p ++) {
        case '\''b'\'':
            if (*p == 0)
                return "ab";
            return NULL;
        case '\''c'\'':
            if (*p == 0)
                return "ac";
            return NULL;
        case '\''d'\'':
            if (*p == 0)
                return "ad";
        }
    }
    return NULL;
$ print a abd ac|test-trie
    if (*p ++ == '\''a'\'') {
        if (*p == 0)
            return "a";
        switch (*p ++) {
        case '\''b'\'':
            if (*p ++ == '\''d'\'' &&
                *p == 0)
                return "abd";
            return NULL;
        case '\''c'\'':
            if (*p == 0)
                return "ac";
        }
    }
    return NULL;
$ print a ab ac acd|test-trie
    if (*p ++ == '\''a'\'') {
        if (*p == 0)
            return "a";
        switch (*p ++) {
        case '\''b'\'':
            if (*p == 0)
                return "ab";
            return NULL;
        case '\''c'\'':
            if (*p == 0)
                return "ac";
            if (*p ++ == '\''d'\'' &&
                *p == 0)
                return "acd";
        }
    }
    return NULL;
$ print a bb ba ccc|test-trie
    switch (*p ++) {
    case '\''a'\'':
        if (*p == 0)
            return "a";
        return NULL;
    case '\''b'\'':
        switch (*p ++) {
        case '\''a'\'':
            if (*p == 0)
                return "ba";
            return NULL;
        case '\''b'\'':
            if (*p == 0)
                return "bb";
        }
        return NULL;
    case '\''c'\'':
        if (*p ++ == '\''c'\'' &&
            *p ++ == '\''c'\'' &&
            *p == 0)
            return "ccc";
    }
    return NULL;
$ print a bb ccc|test-trie
    switch (*p ++) {
    case '\''a'\'':
        if (*p == 0)
            return "a";
        return NULL;
    case '\''b'\'':
        if (*p ++ == '\''b'\'' &&
            *p == 0)
            return "bb";
        return NULL;
    case '\''c'\'':
        if (*p ++ == '\''c'\'' &&
            *p ++ == '\''c'\'' &&
            *p == 0)
            return "ccc";
    }
    return NULL;
$ print a bb ba ccc|test-trie
    switch (*p ++) {
    case '\''a'\'':
        if (*p == 0)
            return "a";
        return NULL;
    case '\''b'\'':
        switch (*p ++) {
        case '\''a'\'':
            if (*p == 0)
                return "ba";
            return NULL;
        case '\''b'\'':
            if (*p == 0)
                return "bb";
        }
        return NULL;
    case '\''c'\'':
        if (*p ++ == '\''c'\'' &&
            *p ++ == '\''c'\'' &&
            *p == 0)
            return "ccc";
    }
    return NULL;
$ print abc abd acde|test-trie
    if (*p ++ == '\''a'\'') {
        switch (*p ++) {
        case '\''b'\'':
            switch (*p ++) {
            case '\''c'\'':
                if (*p == 0)
                    return "abc";
                return NULL;
            case '\''d'\'':
                if (*p == 0)
                    return "abd";
            }
            return NULL;
        case '\''c'\'':
            if (*p ++ == '\''d'\'' &&
                *p ++ == '\''e'\'' &&
                *p == 0)
                return "acde";
        }
    }
    return NULL;
$ print abc abd acde ac|test-trie
    if (*p ++ == '\''a'\'') {
        switch (*p ++) {
        case '\''b'\'':
            switch (*p ++) {
            case '\''c'\'':
                if (*p == 0)
                    return "abc";
                return NULL;
            case '\''d'\'':
                if (*p == 0)
                    return "abd";
            }
            return NULL;
        case '\''c'\'':
            if (*p == 0)
                return "ac";
            if (*p ++ == '\''d'\'' &&
                *p ++ == '\''e'\'' &&
                *p == 0)
                return "acde";
        }
    }
    return NULL;
$ print abc abd acde acfg|test-trie
    if (*p ++ == '\''a'\'') {
        switch (*p ++) {
        case '\''b'\'':
            switch (*p ++) {
            case '\''c'\'':
                if (*p == 0)
                    return "abc";
                return NULL;
            case '\''d'\'':
                if (*p == 0)
                    return "abd";
            }
            return NULL;
        case '\''c'\'':
            switch (*p ++) {
            case '\''d'\'':
                if (*p ++ == '\''e'\'' &&
                    *p == 0)
                    return "acde";
                return NULL;
            case '\''f'\'':
                if (*p ++ == '\''g'\'' &&
                    *p == 0)
                    return "acfg";
            }
        }
    }
    return NULL;
$ print cde cfg cfgx cfgxy cfgxyz cfgxzzz|test-trie
    if (*p ++ == '\''c'\'') {
        switch (*p ++) {
        case '\''d'\'':
            if (*p ++ == '\''e'\'' &&
                *p == 0)
                return "cde";
            return NULL;
        case '\''f'\'':
            if (*p ++ == '\''g'\'') {
                if (*p == 0)
                    return "cfg";
                if (*p ++ == '\''x'\'') {
                    if (*p == 0)
                        return "cfgx";
                    switch (*p ++) {
                    case '\''y'\'':
                        if (*p == 0)
                            return "cfgxy";
                        if (*p ++ == '\''z'\'' &&
                            *p == 0)
                            return "cfgxyz";
                        return NULL;
                    case '\''z'\'':
                        if (*p ++ == '\''z'\'' &&
                            *p ++ == '\''z'\'' &&
                            *p == 0)
                            return "cfgxzzz";
                    }
                }
            }
        }
    }
    return NULL;
$ print cge cfg cfgx cfgxy cfgxyz cfgxzzz|test-trie
    if (*p ++ == '\''c'\'') {
        switch (*p ++) {
        case '\''f'\'':
            if (*p ++ == '\''g'\'') {
                if (*p == 0)
                    return "cfg";
                if (*p ++ == '\''x'\'') {
                    if (*p == 0)
                        return "cfgx";
                    switch (*p ++) {
                    case '\''y'\'':
                        if (*p == 0)
                            return "cfgxy";
                        if (*p ++ == '\''z'\'' &&
                            *p == 0)
                            return "cfgxyz";
                        return NULL;
                    case '\''z'\'':
                        if (*p ++ == '\''z'\'' &&
                            *p ++ == '\''z'\'' &&
                            *p == 0)
                            return "cfgxzzz";
                    }
                }
            }
            return NULL;
        case '\''g'\'':
            if (*p ++ == '\''e'\'' &&
                *p == 0)
                return "cge";
        }
    }
    return NULL;
$ print a abcd abcdefg h hijk|test-trie
    switch (*p ++) {
    case '\''a'\'':
        if (*p == 0)
            return "a";
        if (*p ++ == '\''b'\'' &&
            *p ++ == '\''c'\'' &&
            *p ++ == '\''d'\'') {
            if (*p == 0)
                return "abcd";
            if (*p ++ == '\''e'\'' &&
                *p ++ == '\''f'\'' &&
                *p ++ == '\''g'\'' &&
                *p == 0)
                return "abcdefg";
        }
        return NULL;
    case '\''h'\'':
        if (*p == 0)
            return "h";
        if (*p ++ == '\''i'\'' &&
            *p ++ == '\''j'\'' &&
            *p ++ == '\''k'\'' &&
            *p == 0)
            return "hijk";
    }
    return NULL;
$ print a abcd abcdefg abcdxyz h hijk|test-trie
    switch (*p ++) {
    case '\''a'\'':
        if (*p == 0)
            return "a";
        if (*p ++ == '\''b'\'' &&
            *p ++ == '\''c'\'' &&
            *p ++ == '\''d'\'') {
            if (*p == 0)
                return "abcd";
            switch (*p ++) {
            case '\''e'\'':
                if (*p ++ == '\''f'\'' &&
                    *p ++ == '\''g'\'' &&
                    *p == 0)
                    return "abcdefg";
                return NULL;
            case '\''x'\'':
                if (*p ++ == '\''y'\'' &&
                    *p ++ == '\''z'\'' &&
                    *p == 0)
                    return "abcdxyz";
            }
        }
        return NULL;
    case '\''h'\'':
        if (*p == 0)
            return "h";
        if (*p ++ == '\''i'\'' &&
            *p ++ == '\''j'\'' &&
            *p ++ == '\''k'\'' &&
            *p == 0)
            return "hijk";
    }
    return NULL;
$ print a abcd abcdefg abcdxyz h hijk hlm|test-trie
    switch (*p ++) {
    case '\''a'\'':
        if (*p == 0)
            return "a";
        if (*p ++ == '\''b'\'' &&
            *p ++ == '\''c'\'' &&
            *p ++ == '\''d'\'') {
            if (*p == 0)
                return "abcd";
            switch (*p ++) {
            case '\''e'\'':
                if (*p ++ == '\''f'\'' &&
                    *p ++ == '\''g'\'' &&
                    *p == 0)
                    return "abcdefg";
                return NULL;
            case '\''x'\'':
                if (*p ++ == '\''y'\'' &&
                    *p ++ == '\''z'\'' &&
                    *p == 0)
                    return "abcdxyz";
            }
        }
        return NULL;
    case '\''h'\'':
        if (*p == 0)
            return "h";
        switch (*p ++) {
        case '\''i'\'':
            if (*p ++ == '\''j'\'' &&
                *p ++ == '\''k'\'' &&
                *p == 0)
                return "hijk";
            return NULL;
        case '\''l'\'':
            if (*p ++ == '\''m'\'' &&
                *p == 0)
                return "hlm";
        }
    }
    return NULL;'
) -L gen-code-expanded-base.new <(
echo '$ test -x ../lib/test-trie'
test -x ../lib/test-trie 2>&1 ||
echo 'command failed: test -x ../lib/test-trie'

echo '$ print() { printf '\''%s\n'\'' "$@"; }'
print() { printf '%s\n' "$@"; } 2>&1 ||
echo 'command failed: print() { printf '\''%s\n'\'' "$@"; }'

echo '$ set -o pipefail'
set -o pipefail 2>&1 ||
echo 'command failed: set -o pipefail'

echo '$ test-trie() { ../lib/test-trie -G --expanded-path; }'
test-trie() { ../lib/test-trie -G --expanded-path; } 2>&1 ||
echo 'command failed: test-trie() { ../lib/test-trie -G --expanded-path; }'

echo '$ echo -n|test-trie'
echo -n|test-trie 2>&1 ||
echo 'command failed: echo -n|test-trie'

echo '$ print a|test-trie'
print a|test-trie 2>&1 ||
echo 'command failed: print a|test-trie'

echo '$ print a b|test-trie'
print a b|test-trie 2>&1 ||
echo 'command failed: print a b|test-trie'

echo '$ print a b c|test-trie'
print a b c|test-trie 2>&1 ||
echo 'command failed: print a b c|test-trie'

echo '$ print a ab abc|test-trie'
print a ab abc|test-trie 2>&1 ||
echo 'command failed: print a ab abc|test-trie'

echo '$ print a ab ac|test-trie'
print a ab ac|test-trie 2>&1 ||
echo 'command failed: print a ab ac|test-trie'

echo '$ print a ab ac ad|test-trie'
print a ab ac ad|test-trie 2>&1 ||
echo 'command failed: print a ab ac ad|test-trie'

echo '$ print a abd ac|test-trie'
print a abd ac|test-trie 2>&1 ||
echo 'command failed: print a abd ac|test-trie'

echo '$ print a ab ac acd|test-trie'
print a ab ac acd|test-trie 2>&1 ||
echo 'command failed: print a ab ac acd|test-trie'

echo '$ print a bb ba ccc|test-trie'
print a bb ba ccc|test-trie 2>&1 ||
echo 'command failed: print a bb ba ccc|test-trie'

echo '$ print a bb ccc|test-trie'
print a bb ccc|test-trie 2>&1 ||
echo 'command failed: print a bb ccc|test-trie'

echo '$ print a bb ba ccc|test-trie'
print a bb ba ccc|test-trie 2>&1 ||
echo 'command failed: print a bb ba ccc|test-trie'

echo '$ print abc abd acde|test-trie'
print abc abd acde|test-trie 2>&1 ||
echo 'command failed: print abc abd acde|test-trie'

echo '$ print abc abd acde ac|test-trie'
print abc abd acde ac|test-trie 2>&1 ||
echo 'command failed: print abc abd acde ac|test-trie'

echo '$ print abc abd acde acfg|test-trie'
print abc abd acde acfg|test-trie 2>&1 ||
echo 'command failed: print abc abd acde acfg|test-trie'

echo '$ print cde cfg cfgx cfgxy cfgxyz cfgxzzz|test-trie'
print cde cfg cfgx cfgxy cfgxyz cfgxzzz|test-trie 2>&1 ||
echo 'command failed: print cde cfg cfgx cfgxy cfgxyz cfgxzzz|test-trie'

echo '$ print cge cfg cfgx cfgxy cfgxyz cfgxzzz|test-trie'
print cge cfg cfgx cfgxy cfgxyz cfgxzzz|test-trie 2>&1 ||
echo 'command failed: print cge cfg cfgx cfgxy cfgxyz cfgxzzz|test-trie'

echo '$ print a abcd abcdefg h hijk|test-trie'
print a abcd abcdefg h hijk|test-trie 2>&1 ||
echo 'command failed: print a abcd abcdefg h hijk|test-trie'

echo '$ print a abcd abcdefg abcdxyz h hijk|test-trie'
print a abcd abcdefg abcdxyz h hijk|test-trie 2>&1 ||
echo 'command failed: print a abcd abcdefg abcdxyz h hijk|test-trie'

echo '$ print a abcd abcdefg abcdxyz h hijk hlm|test-trie'
print a abcd abcdefg abcdxyz h hijk hlm|test-trie 2>&1 ||
echo 'command failed: print a abcd abcdefg abcdxyz h hijk hlm|test-trie'
)

