#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020, 2021  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-checker:basic
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L basic.old <(echo \
'$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes
$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }
$ json -d '\''"type"'\'' <<< '\''null'\''
null
$ json -d '\''"type"'\'' <<< '\''false'\''
false
$ json -d '\''"type"'\'' <<< '\''true'\''
true
$ json -d '\''"type"'\'' <<< '\''123'\''
123
$ json -d '\''"type"'\'' <<< '\''"foo"'\''
"foo"
$ json -d '\''"type"'\'' <<< '\''{}'\''
{}
$ json -d '\''"type"'\'' <<< '\''{"foo":null}'\''
{"foo":null}
$ json -d '\''"type"'\'' <<< '\''{"foo":false,"bar":123}'\''
{"foo":false,"bar":123}
$ json -d '\''"type"'\'' <<< '\''{"foo":{},"bar":[]}'\''
{"foo":{},"bar":[]}
$ json -d '\''"type"'\'' <<< '\''{"foo":{"bar":{"baz":[]}}}'\''
{"foo":{"bar":{"baz":[]}}}
$ json -d '\''"type"'\'' <<< '\''[]'\''
[]
$ json -d '\''"type"'\'' <<< '\''[null]'\''
[null]
$ json -d '\''"type"'\'' <<< '\''[false]'\''
[false]
$ json -d '\''"type"'\'' <<< '\''[456]'\''
[456]
$ json -d '\''"type"'\'' <<< '\''[""]'\''
[""]
$ json -d '\''"type"'\'' <<< '\''[{}]'\''
[{}]
$ json -d '\''"type"'\'' <<< '\''[{"foo":null}]'\''
[{"foo":null}]
$ json -d '\''"type"'\'' <<< '\''[{"foo":null,"bar":false}]'\''
[{"foo":null,"bar":false}]
$ json -d '\''"type"'\'' <<< '\''[{"foo":[],"bar":{}}]'\''
[{"foo":[],"bar":{}}]
$ json -d '\''"type"'\'' <<< '\''[[]]'\''
[[]]
$ json -d '\''"type"'\'' <<< '\''[[],[]]'\''
[[],[]]
$ json -d '\''"null"'\'' <<< '\''null'\''
null
$ json -d '\''"null"'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''"null"'\'' <<< '\''false'\''
$ json -d '\''"null"'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''"null"'\'' <<< '\''true'\''
$ json -d '\''"null"'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''"null"'\'' <<< '\''123'\''
$ json -d '\''"null"'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''"null"'\'' <<< '\''"foo"'\''
$ json -d '\''"null"'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''"null"'\'' <<< '\''{}'\''
$ json -d '\''"null"'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:1: {"foo":null}
json: error: <stdin>:1:1: ^
command failed: json -d '\''"null"'\'' <<< '\''{"foo":null}'\''
$ json -d '\''"null"'\'' <<< '\''{"foo":false,"bar":123}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:1: {"foo":false,"bar":123}
json: error: <stdin>:1:1: ^
command failed: json -d '\''"null"'\'' <<< '\''{"foo":false,"bar":123}'\''
$ json -d '\''"null"'\'' <<< '\''{"foo":{},"bar":[]}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:1: {"foo":{},"bar":[]}
json: error: <stdin>:1:1: ^
command failed: json -d '\''"null"'\'' <<< '\''{"foo":{},"bar":[]}'\''
$ json -d '\''"null"'\'' <<< '\''{"foo":{"bar":{"baz":[]}}}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:1: {"foo":{"bar":{"baz":[]}}}
json: error: <stdin>:1:1: ^
command failed: json -d '\''"null"'\'' <<< '\''{"foo":{"bar":{"baz":[]}}}'\''
$ json -d '\''"null"'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''"null"'\'' <<< '\''[]'\''
$ json -d '\''"null"'\'' <<< '\''[null]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:1: [null]
json: error: <stdin>:1:1: ^
command failed: json -d '\''"null"'\'' <<< '\''[null]'\''
$ json -d '\''"null"'\'' <<< '\''[false]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:1: [false]
json: error: <stdin>:1:1: ^
command failed: json -d '\''"null"'\'' <<< '\''[false]'\''
$ json -d '\''"null"'\'' <<< '\''[456]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:1: [456]
json: error: <stdin>:1:1: ^
command failed: json -d '\''"null"'\'' <<< '\''[456]'\''
$ json -d '\''"null"'\'' <<< '\''[""]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:1: [""]
json: error: <stdin>:1:1: ^
command failed: json -d '\''"null"'\'' <<< '\''[""]'\''
$ json -d '\''"null"'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:1: [{}]
json: error: <stdin>:1:1: ^
command failed: json -d '\''"null"'\'' <<< '\''[{}]'\''
$ json -d '\''"null"'\'' <<< '\''[{"foo":null}]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:1: [{"foo":null}]
json: error: <stdin>:1:1: ^
command failed: json -d '\''"null"'\'' <<< '\''[{"foo":null}]'\''
$ json -d '\''"null"'\'' <<< '\''[{"foo":null,"bar":false}]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:1: [{"foo":null,"bar":false}]
json: error: <stdin>:1:1: ^
command failed: json -d '\''"null"'\'' <<< '\''[{"foo":null,"bar":false}]'\''
$ json -d '\''"null"'\'' <<< '\''[{"foo":[],"bar":{}}]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:1: [{"foo":[],"bar":{}}]
json: error: <stdin>:1:1: ^
command failed: json -d '\''"null"'\'' <<< '\''[{"foo":[],"bar":{}}]'\''
$ json -d '\''"null"'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:1: [[]]
json: error: <stdin>:1:1: ^
command failed: json -d '\''"null"'\'' <<< '\''[[]]'\''
$ json -d '\''"null"'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"null"'\''
json: error: <stdin>:1:1: [[],[]]
json: error: <stdin>:1:1: ^
command failed: json -d '\''"null"'\'' <<< '\''[[],[]]'\''
$ json -d '\''"boolean"'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''"boolean"'\'' <<< '\''null'\''
$ json -d '\''"boolean"'\'' <<< '\''false'\''
false
$ json -d '\''"boolean"'\'' <<< '\''true'\''
true
$ json -d '\''"boolean"'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''"boolean"'\'' <<< '\''123'\''
$ json -d '\''"boolean"'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''"boolean"'\'' <<< '\''"foo"'\''
$ json -d '\''"boolean"'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''"boolean"'\'' <<< '\''{}'\''
$ json -d '\''"boolean"'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:1: {"foo":null}
json: error: <stdin>:1:1: ^
command failed: json -d '\''"boolean"'\'' <<< '\''{"foo":null}'\''
$ json -d '\''"boolean"'\'' <<< '\''{"foo":false,"bar":123}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:1: {"foo":false,"bar":123}
json: error: <stdin>:1:1: ^
command failed: json -d '\''"boolean"'\'' <<< '\''{"foo":false,"bar":123}'\''
$ json -d '\''"boolean"'\'' <<< '\''{"foo":{},"bar":[]}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:1: {"foo":{},"bar":[]}
json: error: <stdin>:1:1: ^
command failed: json -d '\''"boolean"'\'' <<< '\''{"foo":{},"bar":[]}'\''
$ json -d '\''"boolean"'\'' <<< '\''{"foo":{"bar":{"baz":[]}}}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:1: {"foo":{"bar":{"baz":[]}}}
json: error: <stdin>:1:1: ^
command failed: json -d '\''"boolean"'\'' <<< '\''{"foo":{"bar":{"baz":[]}}}'\''
$ json -d '\''"boolean"'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''"boolean"'\'' <<< '\''[]'\''
$ json -d '\''"boolean"'\'' <<< '\''[null]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:1: [null]
json: error: <stdin>:1:1: ^
command failed: json -d '\''"boolean"'\'' <<< '\''[null]'\''
$ json -d '\''"boolean"'\'' <<< '\''[false]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:1: [false]
json: error: <stdin>:1:1: ^
command failed: json -d '\''"boolean"'\'' <<< '\''[false]'\''
$ json -d '\''"boolean"'\'' <<< '\''[456]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:1: [456]
json: error: <stdin>:1:1: ^
command failed: json -d '\''"boolean"'\'' <<< '\''[456]'\''
$ json -d '\''"boolean"'\'' <<< '\''[""]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:1: [""]
json: error: <stdin>:1:1: ^
command failed: json -d '\''"boolean"'\'' <<< '\''[""]'\''
$ json -d '\''"boolean"'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:1: [{}]
json: error: <stdin>:1:1: ^
command failed: json -d '\''"boolean"'\'' <<< '\''[{}]'\''
$ json -d '\''"boolean"'\'' <<< '\''[{"foo":null}]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:1: [{"foo":null}]
json: error: <stdin>:1:1: ^
command failed: json -d '\''"boolean"'\'' <<< '\''[{"foo":null}]'\''
$ json -d '\''"boolean"'\'' <<< '\''[{"foo":null,"bar":false}]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:1: [{"foo":null,"bar":false}]
json: error: <stdin>:1:1: ^
command failed: json -d '\''"boolean"'\'' <<< '\''[{"foo":null,"bar":false}]'\''
$ json -d '\''"boolean"'\'' <<< '\''[{"foo":[],"bar":{}}]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:1: [{"foo":[],"bar":{}}]
json: error: <stdin>:1:1: ^
command failed: json -d '\''"boolean"'\'' <<< '\''[{"foo":[],"bar":{}}]'\''
$ json -d '\''"boolean"'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:1: [[]]
json: error: <stdin>:1:1: ^
command failed: json -d '\''"boolean"'\'' <<< '\''[[]]'\''
$ json -d '\''"boolean"'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"boolean"'\''
json: error: <stdin>:1:1: [[],[]]
json: error: <stdin>:1:1: ^
command failed: json -d '\''"boolean"'\'' <<< '\''[[],[]]'\''
$ json -d '\''"number"'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''"number"'\'' <<< '\''null'\''
$ json -d '\''"number"'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''"number"'\'' <<< '\''false'\''
$ json -d '\''"number"'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''"number"'\'' <<< '\''true'\''
$ json -d '\''"number"'\'' <<< '\''123'\''
123
$ json -d '\''"number"'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''"number"'\'' <<< '\''"foo"'\''
$ json -d '\''"number"'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''"number"'\'' <<< '\''{}'\''
$ json -d '\''"number"'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:1: {"foo":null}
json: error: <stdin>:1:1: ^
command failed: json -d '\''"number"'\'' <<< '\''{"foo":null}'\''
$ json -d '\''"number"'\'' <<< '\''{"foo":false,"bar":123}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:1: {"foo":false,"bar":123}
json: error: <stdin>:1:1: ^
command failed: json -d '\''"number"'\'' <<< '\''{"foo":false,"bar":123}'\''
$ json -d '\''"number"'\'' <<< '\''{"foo":{},"bar":[]}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:1: {"foo":{},"bar":[]}
json: error: <stdin>:1:1: ^
command failed: json -d '\''"number"'\'' <<< '\''{"foo":{},"bar":[]}'\''
$ json -d '\''"number"'\'' <<< '\''{"foo":{"bar":{"baz":[]}}}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:1: {"foo":{"bar":{"baz":[]}}}
json: error: <stdin>:1:1: ^
command failed: json -d '\''"number"'\'' <<< '\''{"foo":{"bar":{"baz":[]}}}'\''
$ json -d '\''"number"'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''"number"'\'' <<< '\''[]'\''
$ json -d '\''"number"'\'' <<< '\''[null]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:1: [null]
json: error: <stdin>:1:1: ^
command failed: json -d '\''"number"'\'' <<< '\''[null]'\''
$ json -d '\''"number"'\'' <<< '\''[false]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:1: [false]
json: error: <stdin>:1:1: ^
command failed: json -d '\''"number"'\'' <<< '\''[false]'\''
$ json -d '\''"number"'\'' <<< '\''[456]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:1: [456]
json: error: <stdin>:1:1: ^
command failed: json -d '\''"number"'\'' <<< '\''[456]'\''
$ json -d '\''"number"'\'' <<< '\''[""]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:1: [""]
json: error: <stdin>:1:1: ^
command failed: json -d '\''"number"'\'' <<< '\''[""]'\''
$ json -d '\''"number"'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:1: [{}]
json: error: <stdin>:1:1: ^
command failed: json -d '\''"number"'\'' <<< '\''[{}]'\''
$ json -d '\''"number"'\'' <<< '\''[{"foo":null}]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:1: [{"foo":null}]
json: error: <stdin>:1:1: ^
command failed: json -d '\''"number"'\'' <<< '\''[{"foo":null}]'\''
$ json -d '\''"number"'\'' <<< '\''[{"foo":null,"bar":false}]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:1: [{"foo":null,"bar":false}]
json: error: <stdin>:1:1: ^
command failed: json -d '\''"number"'\'' <<< '\''[{"foo":null,"bar":false}]'\''
$ json -d '\''"number"'\'' <<< '\''[{"foo":[],"bar":{}}]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:1: [{"foo":[],"bar":{}}]
json: error: <stdin>:1:1: ^
command failed: json -d '\''"number"'\'' <<< '\''[{"foo":[],"bar":{}}]'\''
$ json -d '\''"number"'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:1: [[]]
json: error: <stdin>:1:1: ^
command failed: json -d '\''"number"'\'' <<< '\''[[]]'\''
$ json -d '\''"number"'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"number"'\''
json: error: <stdin>:1:1: [[],[]]
json: error: <stdin>:1:1: ^
command failed: json -d '\''"number"'\'' <<< '\''[[],[]]'\''
$ json -d '\''"string"'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''"string"'\'' <<< '\''null'\''
$ json -d '\''"string"'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''"string"'\'' <<< '\''false'\''
$ json -d '\''"string"'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''"string"'\'' <<< '\''true'\''
$ json -d '\''"string"'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''"string"'\'' <<< '\''123'\''
$ json -d '\''"string"'\'' <<< '\''"foo"'\''
"foo"
$ json -d '\''"string"'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''"string"'\'' <<< '\''{}'\''
$ json -d '\''"string"'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:1: {"foo":null}
json: error: <stdin>:1:1: ^
command failed: json -d '\''"string"'\'' <<< '\''{"foo":null}'\''
$ json -d '\''"string"'\'' <<< '\''{"foo":false,"bar":123}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:1: {"foo":false,"bar":123}
json: error: <stdin>:1:1: ^
command failed: json -d '\''"string"'\'' <<< '\''{"foo":false,"bar":123}'\''
$ json -d '\''"string"'\'' <<< '\''{"foo":{},"bar":[]}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:1: {"foo":{},"bar":[]}
json: error: <stdin>:1:1: ^
command failed: json -d '\''"string"'\'' <<< '\''{"foo":{},"bar":[]}'\''
$ json -d '\''"string"'\'' <<< '\''{"foo":{"bar":{"baz":[]}}}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:1: {"foo":{"bar":{"baz":[]}}}
json: error: <stdin>:1:1: ^
command failed: json -d '\''"string"'\'' <<< '\''{"foo":{"bar":{"baz":[]}}}'\''
$ json -d '\''"string"'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''"string"'\'' <<< '\''[]'\''
$ json -d '\''"string"'\'' <<< '\''[null]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:1: [null]
json: error: <stdin>:1:1: ^
command failed: json -d '\''"string"'\'' <<< '\''[null]'\''
$ json -d '\''"string"'\'' <<< '\''[false]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:1: [false]
json: error: <stdin>:1:1: ^
command failed: json -d '\''"string"'\'' <<< '\''[false]'\''
$ json -d '\''"string"'\'' <<< '\''[456]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:1: [456]
json: error: <stdin>:1:1: ^
command failed: json -d '\''"string"'\'' <<< '\''[456]'\''
$ json -d '\''"string"'\'' <<< '\''[""]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:1: [""]
json: error: <stdin>:1:1: ^
command failed: json -d '\''"string"'\'' <<< '\''[""]'\''
$ json -d '\''"string"'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:1: [{}]
json: error: <stdin>:1:1: ^
command failed: json -d '\''"string"'\'' <<< '\''[{}]'\''
$ json -d '\''"string"'\'' <<< '\''[{"foo":null}]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:1: [{"foo":null}]
json: error: <stdin>:1:1: ^
command failed: json -d '\''"string"'\'' <<< '\''[{"foo":null}]'\''
$ json -d '\''"string"'\'' <<< '\''[{"foo":null,"bar":false}]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:1: [{"foo":null,"bar":false}]
json: error: <stdin>:1:1: ^
command failed: json -d '\''"string"'\'' <<< '\''[{"foo":null,"bar":false}]'\''
$ json -d '\''"string"'\'' <<< '\''[{"foo":[],"bar":{}}]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:1: [{"foo":[],"bar":{}}]
json: error: <stdin>:1:1: ^
command failed: json -d '\''"string"'\'' <<< '\''[{"foo":[],"bar":{}}]'\''
$ json -d '\''"string"'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:1: [[]]
json: error: <stdin>:1:1: ^
command failed: json -d '\''"string"'\'' <<< '\''[[]]'\''
$ json -d '\''"string"'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"string"'\''
json: error: <stdin>:1:1: [[],[]]
json: error: <stdin>:1:1: ^
command failed: json -d '\''"string"'\'' <<< '\''[[],[]]'\''
$ json -d '\''"object"'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''"object"'\'' <<< '\''null'\''
$ json -d '\''"object"'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''"object"'\'' <<< '\''false'\''
$ json -d '\''"object"'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''"object"'\'' <<< '\''true'\''
$ json -d '\''"object"'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''"object"'\'' <<< '\''123'\''
$ json -d '\''"object"'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''"object"'\'' <<< '\''"foo"'\''
$ json -d '\''"object"'\'' <<< '\''{}'\''
{}
$ json -d '\''"object"'\'' <<< '\''{"foo":null}'\''
{"foo":null}
$ json -d '\''"object"'\'' <<< '\''{"foo":false,"bar":123}'\''
{"foo":false,"bar":123}
$ json -d '\''"object"'\'' <<< '\''{"foo":{},"bar":[]}'\''
{"foo":{},"bar":[]}
$ json -d '\''"object"'\'' <<< '\''{"foo":{"bar":{"baz":[]}}}'\''
{"foo":{"bar":{"baz":[]}}}
$ json -d '\''"object"'\'' <<< '\''[]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:1: []
json: error: <stdin>:1:1: ^
command failed: json -d '\''"object"'\'' <<< '\''[]'\''
$ json -d '\''"object"'\'' <<< '\''[null]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:1: [null]
json: error: <stdin>:1:1: ^
command failed: json -d '\''"object"'\'' <<< '\''[null]'\''
$ json -d '\''"object"'\'' <<< '\''[false]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:1: [false]
json: error: <stdin>:1:1: ^
command failed: json -d '\''"object"'\'' <<< '\''[false]'\''
$ json -d '\''"object"'\'' <<< '\''[456]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:1: [456]
json: error: <stdin>:1:1: ^
command failed: json -d '\''"object"'\'' <<< '\''[456]'\''
$ json -d '\''"object"'\'' <<< '\''[""]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:1: [""]
json: error: <stdin>:1:1: ^
command failed: json -d '\''"object"'\'' <<< '\''[""]'\''
$ json -d '\''"object"'\'' <<< '\''[{}]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:1: [{}]
json: error: <stdin>:1:1: ^
command failed: json -d '\''"object"'\'' <<< '\''[{}]'\''
$ json -d '\''"object"'\'' <<< '\''[{"foo":null}]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:1: [{"foo":null}]
json: error: <stdin>:1:1: ^
command failed: json -d '\''"object"'\'' <<< '\''[{"foo":null}]'\''
$ json -d '\''"object"'\'' <<< '\''[{"foo":null,"bar":false}]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:1: [{"foo":null,"bar":false}]
json: error: <stdin>:1:1: ^
command failed: json -d '\''"object"'\'' <<< '\''[{"foo":null,"bar":false}]'\''
$ json -d '\''"object"'\'' <<< '\''[{"foo":[],"bar":{}}]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:1: [{"foo":[],"bar":{}}]
json: error: <stdin>:1:1: ^
command failed: json -d '\''"object"'\'' <<< '\''[{"foo":[],"bar":{}}]'\''
$ json -d '\''"object"'\'' <<< '\''[[]]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:1: [[]]
json: error: <stdin>:1:1: ^
command failed: json -d '\''"object"'\'' <<< '\''[[]]'\''
$ json -d '\''"object"'\'' <<< '\''[[],[]]'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"object"'\''
json: error: <stdin>:1:1: [[],[]]
json: error: <stdin>:1:1: ^
command failed: json -d '\''"object"'\'' <<< '\''[[],[]]'\''
$ json -d '\''"array"'\'' <<< '\''null'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:1: null
json: error: <stdin>:1:1: ^
command failed: json -d '\''"array"'\'' <<< '\''null'\''
$ json -d '\''"array"'\'' <<< '\''false'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:1: false
json: error: <stdin>:1:1: ^
command failed: json -d '\''"array"'\'' <<< '\''false'\''
$ json -d '\''"array"'\'' <<< '\''true'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:1: true
json: error: <stdin>:1:1: ^
command failed: json -d '\''"array"'\'' <<< '\''true'\''
$ json -d '\''"array"'\'' <<< '\''123'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:1: 123
json: error: <stdin>:1:1: ^
command failed: json -d '\''"array"'\'' <<< '\''123'\''
$ json -d '\''"array"'\'' <<< '\''"foo"'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:1: "foo"
json: error: <stdin>:1:1: ^
command failed: json -d '\''"array"'\'' <<< '\''"foo"'\''
$ json -d '\''"array"'\'' <<< '\''{}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:1: {}
json: error: <stdin>:1:1: ^
command failed: json -d '\''"array"'\'' <<< '\''{}'\''
$ json -d '\''"array"'\'' <<< '\''{"foo":null}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:1: {"foo":null}
json: error: <stdin>:1:1: ^
command failed: json -d '\''"array"'\'' <<< '\''{"foo":null}'\''
$ json -d '\''"array"'\'' <<< '\''{"foo":false,"bar":123}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:1: {"foo":false,"bar":123}
json: error: <stdin>:1:1: ^
command failed: json -d '\''"array"'\'' <<< '\''{"foo":false,"bar":123}'\''
$ json -d '\''"array"'\'' <<< '\''{"foo":{},"bar":[]}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:1: {"foo":{},"bar":[]}
json: error: <stdin>:1:1: ^
command failed: json -d '\''"array"'\'' <<< '\''{"foo":{},"bar":[]}'\''
$ json -d '\''"array"'\'' <<< '\''{"foo":{"bar":{"baz":[]}}}'\''
json: error: <stdin>:1:1: type check error: type mismatch: expected a value of type `"array"'\''
json: error: <stdin>:1:1: {"foo":{"bar":{"baz":[]}}}
json: error: <stdin>:1:1: ^
command failed: json -d '\''"array"'\'' <<< '\''{"foo":{"bar":{"baz":[]}}}'\''
$ json -d '\''"array"'\'' <<< '\''[]'\''
[]
$ json -d '\''"array"'\'' <<< '\''[null]'\''
[null]
$ json -d '\''"array"'\'' <<< '\''[false]'\''
[false]
$ json -d '\''"array"'\'' <<< '\''[456]'\''
[456]
$ json -d '\''"array"'\'' <<< '\''[""]'\''
[""]
$ json -d '\''"array"'\'' <<< '\''[{}]'\''
[{}]
$ json -d '\''"array"'\'' <<< '\''[{"foo":null}]'\''
[{"foo":null}]
$ json -d '\''"array"'\'' <<< '\''[{"foo":null,"bar":false}]'\''
[{"foo":null,"bar":false}]
$ json -d '\''"array"'\'' <<< '\''[{"foo":[],"bar":{}}]'\''
[{"foo":[],"bar":{}}]
$ json -d '\''"array"'\'' <<< '\''[[]]'\''
[[]]
$ json -d '\''"array"'\'' <<< '\''[[],[]]'\''
[[],[]]'
) -L basic.new <(
echo '$ export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'
export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes 2>&1 ||
echo 'command failed: export JSON_TYPE_CHECK_ERROR_COMPLETE_TYPES=yes'

echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'
json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json --terse --verbose --literal-value "$@"; }'

echo '$ json -d '\''"type"'\'' <<< '\''null'\'''
json -d '"type"' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''"type"'\'' <<< '\''null'\'''

echo '$ json -d '\''"type"'\'' <<< '\''false'\'''
json -d '"type"' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''"type"'\'' <<< '\''false'\'''

echo '$ json -d '\''"type"'\'' <<< '\''true'\'''
json -d '"type"' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''"type"'\'' <<< '\''true'\'''

echo '$ json -d '\''"type"'\'' <<< '\''123'\'''
json -d '"type"' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''"type"'\'' <<< '\''123'\'''

echo '$ json -d '\''"type"'\'' <<< '\''"foo"'\'''
json -d '"type"' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''"type"'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''"type"'\'' <<< '\''{}'\'''
json -d '"type"' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''"type"'\'' <<< '\''{}'\'''

echo '$ json -d '\''"type"'\'' <<< '\''{"foo":null}'\'''
json -d '"type"' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''"type"'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''"type"'\'' <<< '\''{"foo":false,"bar":123}'\'''
json -d '"type"' <<< '{"foo":false,"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''"type"'\'' <<< '\''{"foo":false,"bar":123}'\'''

echo '$ json -d '\''"type"'\'' <<< '\''{"foo":{},"bar":[]}'\'''
json -d '"type"' <<< '{"foo":{},"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''"type"'\'' <<< '\''{"foo":{},"bar":[]}'\'''

echo '$ json -d '\''"type"'\'' <<< '\''{"foo":{"bar":{"baz":[]}}}'\'''
json -d '"type"' <<< '{"foo":{"bar":{"baz":[]}}}' 2>&1 ||
echo 'command failed: json -d '\''"type"'\'' <<< '\''{"foo":{"bar":{"baz":[]}}}'\'''

echo '$ json -d '\''"type"'\'' <<< '\''[]'\'''
json -d '"type"' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''"type"'\'' <<< '\''[]'\'''

echo '$ json -d '\''"type"'\'' <<< '\''[null]'\'''
json -d '"type"' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''"type"'\'' <<< '\''[null]'\'''

echo '$ json -d '\''"type"'\'' <<< '\''[false]'\'''
json -d '"type"' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''"type"'\'' <<< '\''[false]'\'''

echo '$ json -d '\''"type"'\'' <<< '\''[456]'\'''
json -d '"type"' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''"type"'\'' <<< '\''[456]'\'''

echo '$ json -d '\''"type"'\'' <<< '\''[""]'\'''
json -d '"type"' <<< '[""]' 2>&1 ||
echo 'command failed: json -d '\''"type"'\'' <<< '\''[""]'\'''

echo '$ json -d '\''"type"'\'' <<< '\''[{}]'\'''
json -d '"type"' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''"type"'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''"type"'\'' <<< '\''[{"foo":null}]'\'''
json -d '"type"' <<< '[{"foo":null}]' 2>&1 ||
echo 'command failed: json -d '\''"type"'\'' <<< '\''[{"foo":null}]'\'''

echo '$ json -d '\''"type"'\'' <<< '\''[{"foo":null,"bar":false}]'\'''
json -d '"type"' <<< '[{"foo":null,"bar":false}]' 2>&1 ||
echo 'command failed: json -d '\''"type"'\'' <<< '\''[{"foo":null,"bar":false}]'\'''

echo '$ json -d '\''"type"'\'' <<< '\''[{"foo":[],"bar":{}}]'\'''
json -d '"type"' <<< '[{"foo":[],"bar":{}}]' 2>&1 ||
echo 'command failed: json -d '\''"type"'\'' <<< '\''[{"foo":[],"bar":{}}]'\'''

echo '$ json -d '\''"type"'\'' <<< '\''[[]]'\'''
json -d '"type"' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''"type"'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''"type"'\'' <<< '\''[[],[]]'\'''
json -d '"type"' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''"type"'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''"null"'\'' <<< '\''null'\'''
json -d '"null"' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''"null"'\'' <<< '\''null'\'''

echo '$ json -d '\''"null"'\'' <<< '\''false'\'''
json -d '"null"' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''"null"'\'' <<< '\''false'\'''

echo '$ json -d '\''"null"'\'' <<< '\''true'\'''
json -d '"null"' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''"null"'\'' <<< '\''true'\'''

echo '$ json -d '\''"null"'\'' <<< '\''123'\'''
json -d '"null"' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''"null"'\'' <<< '\''123'\'''

echo '$ json -d '\''"null"'\'' <<< '\''"foo"'\'''
json -d '"null"' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''"null"'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''"null"'\'' <<< '\''{}'\'''
json -d '"null"' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''"null"'\'' <<< '\''{}'\'''

echo '$ json -d '\''"null"'\'' <<< '\''{"foo":null}'\'''
json -d '"null"' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''"null"'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''"null"'\'' <<< '\''{"foo":false,"bar":123}'\'''
json -d '"null"' <<< '{"foo":false,"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''"null"'\'' <<< '\''{"foo":false,"bar":123}'\'''

echo '$ json -d '\''"null"'\'' <<< '\''{"foo":{},"bar":[]}'\'''
json -d '"null"' <<< '{"foo":{},"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''"null"'\'' <<< '\''{"foo":{},"bar":[]}'\'''

echo '$ json -d '\''"null"'\'' <<< '\''{"foo":{"bar":{"baz":[]}}}'\'''
json -d '"null"' <<< '{"foo":{"bar":{"baz":[]}}}' 2>&1 ||
echo 'command failed: json -d '\''"null"'\'' <<< '\''{"foo":{"bar":{"baz":[]}}}'\'''

echo '$ json -d '\''"null"'\'' <<< '\''[]'\'''
json -d '"null"' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''"null"'\'' <<< '\''[]'\'''

echo '$ json -d '\''"null"'\'' <<< '\''[null]'\'''
json -d '"null"' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''"null"'\'' <<< '\''[null]'\'''

echo '$ json -d '\''"null"'\'' <<< '\''[false]'\'''
json -d '"null"' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''"null"'\'' <<< '\''[false]'\'''

echo '$ json -d '\''"null"'\'' <<< '\''[456]'\'''
json -d '"null"' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''"null"'\'' <<< '\''[456]'\'''

echo '$ json -d '\''"null"'\'' <<< '\''[""]'\'''
json -d '"null"' <<< '[""]' 2>&1 ||
echo 'command failed: json -d '\''"null"'\'' <<< '\''[""]'\'''

echo '$ json -d '\''"null"'\'' <<< '\''[{}]'\'''
json -d '"null"' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''"null"'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''"null"'\'' <<< '\''[{"foo":null}]'\'''
json -d '"null"' <<< '[{"foo":null}]' 2>&1 ||
echo 'command failed: json -d '\''"null"'\'' <<< '\''[{"foo":null}]'\'''

echo '$ json -d '\''"null"'\'' <<< '\''[{"foo":null,"bar":false}]'\'''
json -d '"null"' <<< '[{"foo":null,"bar":false}]' 2>&1 ||
echo 'command failed: json -d '\''"null"'\'' <<< '\''[{"foo":null,"bar":false}]'\'''

echo '$ json -d '\''"null"'\'' <<< '\''[{"foo":[],"bar":{}}]'\'''
json -d '"null"' <<< '[{"foo":[],"bar":{}}]' 2>&1 ||
echo 'command failed: json -d '\''"null"'\'' <<< '\''[{"foo":[],"bar":{}}]'\'''

echo '$ json -d '\''"null"'\'' <<< '\''[[]]'\'''
json -d '"null"' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''"null"'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''"null"'\'' <<< '\''[[],[]]'\'''
json -d '"null"' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''"null"'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''"boolean"'\'' <<< '\''null'\'''
json -d '"boolean"' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''"boolean"'\'' <<< '\''null'\'''

echo '$ json -d '\''"boolean"'\'' <<< '\''false'\'''
json -d '"boolean"' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''"boolean"'\'' <<< '\''false'\'''

echo '$ json -d '\''"boolean"'\'' <<< '\''true'\'''
json -d '"boolean"' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''"boolean"'\'' <<< '\''true'\'''

echo '$ json -d '\''"boolean"'\'' <<< '\''123'\'''
json -d '"boolean"' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''"boolean"'\'' <<< '\''123'\'''

echo '$ json -d '\''"boolean"'\'' <<< '\''"foo"'\'''
json -d '"boolean"' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''"boolean"'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''"boolean"'\'' <<< '\''{}'\'''
json -d '"boolean"' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''"boolean"'\'' <<< '\''{}'\'''

echo '$ json -d '\''"boolean"'\'' <<< '\''{"foo":null}'\'''
json -d '"boolean"' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''"boolean"'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''"boolean"'\'' <<< '\''{"foo":false,"bar":123}'\'''
json -d '"boolean"' <<< '{"foo":false,"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''"boolean"'\'' <<< '\''{"foo":false,"bar":123}'\'''

echo '$ json -d '\''"boolean"'\'' <<< '\''{"foo":{},"bar":[]}'\'''
json -d '"boolean"' <<< '{"foo":{},"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''"boolean"'\'' <<< '\''{"foo":{},"bar":[]}'\'''

echo '$ json -d '\''"boolean"'\'' <<< '\''{"foo":{"bar":{"baz":[]}}}'\'''
json -d '"boolean"' <<< '{"foo":{"bar":{"baz":[]}}}' 2>&1 ||
echo 'command failed: json -d '\''"boolean"'\'' <<< '\''{"foo":{"bar":{"baz":[]}}}'\'''

echo '$ json -d '\''"boolean"'\'' <<< '\''[]'\'''
json -d '"boolean"' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''"boolean"'\'' <<< '\''[]'\'''

echo '$ json -d '\''"boolean"'\'' <<< '\''[null]'\'''
json -d '"boolean"' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''"boolean"'\'' <<< '\''[null]'\'''

echo '$ json -d '\''"boolean"'\'' <<< '\''[false]'\'''
json -d '"boolean"' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''"boolean"'\'' <<< '\''[false]'\'''

echo '$ json -d '\''"boolean"'\'' <<< '\''[456]'\'''
json -d '"boolean"' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''"boolean"'\'' <<< '\''[456]'\'''

echo '$ json -d '\''"boolean"'\'' <<< '\''[""]'\'''
json -d '"boolean"' <<< '[""]' 2>&1 ||
echo 'command failed: json -d '\''"boolean"'\'' <<< '\''[""]'\'''

echo '$ json -d '\''"boolean"'\'' <<< '\''[{}]'\'''
json -d '"boolean"' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''"boolean"'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''"boolean"'\'' <<< '\''[{"foo":null}]'\'''
json -d '"boolean"' <<< '[{"foo":null}]' 2>&1 ||
echo 'command failed: json -d '\''"boolean"'\'' <<< '\''[{"foo":null}]'\'''

echo '$ json -d '\''"boolean"'\'' <<< '\''[{"foo":null,"bar":false}]'\'''
json -d '"boolean"' <<< '[{"foo":null,"bar":false}]' 2>&1 ||
echo 'command failed: json -d '\''"boolean"'\'' <<< '\''[{"foo":null,"bar":false}]'\'''

echo '$ json -d '\''"boolean"'\'' <<< '\''[{"foo":[],"bar":{}}]'\'''
json -d '"boolean"' <<< '[{"foo":[],"bar":{}}]' 2>&1 ||
echo 'command failed: json -d '\''"boolean"'\'' <<< '\''[{"foo":[],"bar":{}}]'\'''

echo '$ json -d '\''"boolean"'\'' <<< '\''[[]]'\'''
json -d '"boolean"' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''"boolean"'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''"boolean"'\'' <<< '\''[[],[]]'\'''
json -d '"boolean"' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''"boolean"'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''"number"'\'' <<< '\''null'\'''
json -d '"number"' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''"number"'\'' <<< '\''null'\'''

echo '$ json -d '\''"number"'\'' <<< '\''false'\'''
json -d '"number"' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''"number"'\'' <<< '\''false'\'''

echo '$ json -d '\''"number"'\'' <<< '\''true'\'''
json -d '"number"' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''"number"'\'' <<< '\''true'\'''

echo '$ json -d '\''"number"'\'' <<< '\''123'\'''
json -d '"number"' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''"number"'\'' <<< '\''123'\'''

echo '$ json -d '\''"number"'\'' <<< '\''"foo"'\'''
json -d '"number"' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''"number"'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''"number"'\'' <<< '\''{}'\'''
json -d '"number"' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''"number"'\'' <<< '\''{}'\'''

echo '$ json -d '\''"number"'\'' <<< '\''{"foo":null}'\'''
json -d '"number"' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''"number"'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''"number"'\'' <<< '\''{"foo":false,"bar":123}'\'''
json -d '"number"' <<< '{"foo":false,"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''"number"'\'' <<< '\''{"foo":false,"bar":123}'\'''

echo '$ json -d '\''"number"'\'' <<< '\''{"foo":{},"bar":[]}'\'''
json -d '"number"' <<< '{"foo":{},"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''"number"'\'' <<< '\''{"foo":{},"bar":[]}'\'''

echo '$ json -d '\''"number"'\'' <<< '\''{"foo":{"bar":{"baz":[]}}}'\'''
json -d '"number"' <<< '{"foo":{"bar":{"baz":[]}}}' 2>&1 ||
echo 'command failed: json -d '\''"number"'\'' <<< '\''{"foo":{"bar":{"baz":[]}}}'\'''

echo '$ json -d '\''"number"'\'' <<< '\''[]'\'''
json -d '"number"' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''"number"'\'' <<< '\''[]'\'''

echo '$ json -d '\''"number"'\'' <<< '\''[null]'\'''
json -d '"number"' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''"number"'\'' <<< '\''[null]'\'''

echo '$ json -d '\''"number"'\'' <<< '\''[false]'\'''
json -d '"number"' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''"number"'\'' <<< '\''[false]'\'''

echo '$ json -d '\''"number"'\'' <<< '\''[456]'\'''
json -d '"number"' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''"number"'\'' <<< '\''[456]'\'''

echo '$ json -d '\''"number"'\'' <<< '\''[""]'\'''
json -d '"number"' <<< '[""]' 2>&1 ||
echo 'command failed: json -d '\''"number"'\'' <<< '\''[""]'\'''

echo '$ json -d '\''"number"'\'' <<< '\''[{}]'\'''
json -d '"number"' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''"number"'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''"number"'\'' <<< '\''[{"foo":null}]'\'''
json -d '"number"' <<< '[{"foo":null}]' 2>&1 ||
echo 'command failed: json -d '\''"number"'\'' <<< '\''[{"foo":null}]'\'''

echo '$ json -d '\''"number"'\'' <<< '\''[{"foo":null,"bar":false}]'\'''
json -d '"number"' <<< '[{"foo":null,"bar":false}]' 2>&1 ||
echo 'command failed: json -d '\''"number"'\'' <<< '\''[{"foo":null,"bar":false}]'\'''

echo '$ json -d '\''"number"'\'' <<< '\''[{"foo":[],"bar":{}}]'\'''
json -d '"number"' <<< '[{"foo":[],"bar":{}}]' 2>&1 ||
echo 'command failed: json -d '\''"number"'\'' <<< '\''[{"foo":[],"bar":{}}]'\'''

echo '$ json -d '\''"number"'\'' <<< '\''[[]]'\'''
json -d '"number"' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''"number"'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''"number"'\'' <<< '\''[[],[]]'\'''
json -d '"number"' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''"number"'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''"string"'\'' <<< '\''null'\'''
json -d '"string"' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''"string"'\'' <<< '\''null'\'''

echo '$ json -d '\''"string"'\'' <<< '\''false'\'''
json -d '"string"' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''"string"'\'' <<< '\''false'\'''

echo '$ json -d '\''"string"'\'' <<< '\''true'\'''
json -d '"string"' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''"string"'\'' <<< '\''true'\'''

echo '$ json -d '\''"string"'\'' <<< '\''123'\'''
json -d '"string"' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''"string"'\'' <<< '\''123'\'''

echo '$ json -d '\''"string"'\'' <<< '\''"foo"'\'''
json -d '"string"' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''"string"'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''"string"'\'' <<< '\''{}'\'''
json -d '"string"' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''"string"'\'' <<< '\''{}'\'''

echo '$ json -d '\''"string"'\'' <<< '\''{"foo":null}'\'''
json -d '"string"' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''"string"'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''"string"'\'' <<< '\''{"foo":false,"bar":123}'\'''
json -d '"string"' <<< '{"foo":false,"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''"string"'\'' <<< '\''{"foo":false,"bar":123}'\'''

echo '$ json -d '\''"string"'\'' <<< '\''{"foo":{},"bar":[]}'\'''
json -d '"string"' <<< '{"foo":{},"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''"string"'\'' <<< '\''{"foo":{},"bar":[]}'\'''

echo '$ json -d '\''"string"'\'' <<< '\''{"foo":{"bar":{"baz":[]}}}'\'''
json -d '"string"' <<< '{"foo":{"bar":{"baz":[]}}}' 2>&1 ||
echo 'command failed: json -d '\''"string"'\'' <<< '\''{"foo":{"bar":{"baz":[]}}}'\'''

echo '$ json -d '\''"string"'\'' <<< '\''[]'\'''
json -d '"string"' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''"string"'\'' <<< '\''[]'\'''

echo '$ json -d '\''"string"'\'' <<< '\''[null]'\'''
json -d '"string"' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''"string"'\'' <<< '\''[null]'\'''

echo '$ json -d '\''"string"'\'' <<< '\''[false]'\'''
json -d '"string"' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''"string"'\'' <<< '\''[false]'\'''

echo '$ json -d '\''"string"'\'' <<< '\''[456]'\'''
json -d '"string"' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''"string"'\'' <<< '\''[456]'\'''

echo '$ json -d '\''"string"'\'' <<< '\''[""]'\'''
json -d '"string"' <<< '[""]' 2>&1 ||
echo 'command failed: json -d '\''"string"'\'' <<< '\''[""]'\'''

echo '$ json -d '\''"string"'\'' <<< '\''[{}]'\'''
json -d '"string"' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''"string"'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''"string"'\'' <<< '\''[{"foo":null}]'\'''
json -d '"string"' <<< '[{"foo":null}]' 2>&1 ||
echo 'command failed: json -d '\''"string"'\'' <<< '\''[{"foo":null}]'\'''

echo '$ json -d '\''"string"'\'' <<< '\''[{"foo":null,"bar":false}]'\'''
json -d '"string"' <<< '[{"foo":null,"bar":false}]' 2>&1 ||
echo 'command failed: json -d '\''"string"'\'' <<< '\''[{"foo":null,"bar":false}]'\'''

echo '$ json -d '\''"string"'\'' <<< '\''[{"foo":[],"bar":{}}]'\'''
json -d '"string"' <<< '[{"foo":[],"bar":{}}]' 2>&1 ||
echo 'command failed: json -d '\''"string"'\'' <<< '\''[{"foo":[],"bar":{}}]'\'''

echo '$ json -d '\''"string"'\'' <<< '\''[[]]'\'''
json -d '"string"' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''"string"'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''"string"'\'' <<< '\''[[],[]]'\'''
json -d '"string"' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''"string"'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''"object"'\'' <<< '\''null'\'''
json -d '"object"' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''"object"'\'' <<< '\''null'\'''

echo '$ json -d '\''"object"'\'' <<< '\''false'\'''
json -d '"object"' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''"object"'\'' <<< '\''false'\'''

echo '$ json -d '\''"object"'\'' <<< '\''true'\'''
json -d '"object"' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''"object"'\'' <<< '\''true'\'''

echo '$ json -d '\''"object"'\'' <<< '\''123'\'''
json -d '"object"' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''"object"'\'' <<< '\''123'\'''

echo '$ json -d '\''"object"'\'' <<< '\''"foo"'\'''
json -d '"object"' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''"object"'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''"object"'\'' <<< '\''{}'\'''
json -d '"object"' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''"object"'\'' <<< '\''{}'\'''

echo '$ json -d '\''"object"'\'' <<< '\''{"foo":null}'\'''
json -d '"object"' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''"object"'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''"object"'\'' <<< '\''{"foo":false,"bar":123}'\'''
json -d '"object"' <<< '{"foo":false,"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''"object"'\'' <<< '\''{"foo":false,"bar":123}'\'''

echo '$ json -d '\''"object"'\'' <<< '\''{"foo":{},"bar":[]}'\'''
json -d '"object"' <<< '{"foo":{},"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''"object"'\'' <<< '\''{"foo":{},"bar":[]}'\'''

echo '$ json -d '\''"object"'\'' <<< '\''{"foo":{"bar":{"baz":[]}}}'\'''
json -d '"object"' <<< '{"foo":{"bar":{"baz":[]}}}' 2>&1 ||
echo 'command failed: json -d '\''"object"'\'' <<< '\''{"foo":{"bar":{"baz":[]}}}'\'''

echo '$ json -d '\''"object"'\'' <<< '\''[]'\'''
json -d '"object"' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''"object"'\'' <<< '\''[]'\'''

echo '$ json -d '\''"object"'\'' <<< '\''[null]'\'''
json -d '"object"' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''"object"'\'' <<< '\''[null]'\'''

echo '$ json -d '\''"object"'\'' <<< '\''[false]'\'''
json -d '"object"' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''"object"'\'' <<< '\''[false]'\'''

echo '$ json -d '\''"object"'\'' <<< '\''[456]'\'''
json -d '"object"' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''"object"'\'' <<< '\''[456]'\'''

echo '$ json -d '\''"object"'\'' <<< '\''[""]'\'''
json -d '"object"' <<< '[""]' 2>&1 ||
echo 'command failed: json -d '\''"object"'\'' <<< '\''[""]'\'''

echo '$ json -d '\''"object"'\'' <<< '\''[{}]'\'''
json -d '"object"' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''"object"'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''"object"'\'' <<< '\''[{"foo":null}]'\'''
json -d '"object"' <<< '[{"foo":null}]' 2>&1 ||
echo 'command failed: json -d '\''"object"'\'' <<< '\''[{"foo":null}]'\'''

echo '$ json -d '\''"object"'\'' <<< '\''[{"foo":null,"bar":false}]'\'''
json -d '"object"' <<< '[{"foo":null,"bar":false}]' 2>&1 ||
echo 'command failed: json -d '\''"object"'\'' <<< '\''[{"foo":null,"bar":false}]'\'''

echo '$ json -d '\''"object"'\'' <<< '\''[{"foo":[],"bar":{}}]'\'''
json -d '"object"' <<< '[{"foo":[],"bar":{}}]' 2>&1 ||
echo 'command failed: json -d '\''"object"'\'' <<< '\''[{"foo":[],"bar":{}}]'\'''

echo '$ json -d '\''"object"'\'' <<< '\''[[]]'\'''
json -d '"object"' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''"object"'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''"object"'\'' <<< '\''[[],[]]'\'''
json -d '"object"' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''"object"'\'' <<< '\''[[],[]]'\'''

echo '$ json -d '\''"array"'\'' <<< '\''null'\'''
json -d '"array"' <<< 'null' 2>&1 ||
echo 'command failed: json -d '\''"array"'\'' <<< '\''null'\'''

echo '$ json -d '\''"array"'\'' <<< '\''false'\'''
json -d '"array"' <<< 'false' 2>&1 ||
echo 'command failed: json -d '\''"array"'\'' <<< '\''false'\'''

echo '$ json -d '\''"array"'\'' <<< '\''true'\'''
json -d '"array"' <<< 'true' 2>&1 ||
echo 'command failed: json -d '\''"array"'\'' <<< '\''true'\'''

echo '$ json -d '\''"array"'\'' <<< '\''123'\'''
json -d '"array"' <<< '123' 2>&1 ||
echo 'command failed: json -d '\''"array"'\'' <<< '\''123'\'''

echo '$ json -d '\''"array"'\'' <<< '\''"foo"'\'''
json -d '"array"' <<< '"foo"' 2>&1 ||
echo 'command failed: json -d '\''"array"'\'' <<< '\''"foo"'\'''

echo '$ json -d '\''"array"'\'' <<< '\''{}'\'''
json -d '"array"' <<< '{}' 2>&1 ||
echo 'command failed: json -d '\''"array"'\'' <<< '\''{}'\'''

echo '$ json -d '\''"array"'\'' <<< '\''{"foo":null}'\'''
json -d '"array"' <<< '{"foo":null}' 2>&1 ||
echo 'command failed: json -d '\''"array"'\'' <<< '\''{"foo":null}'\'''

echo '$ json -d '\''"array"'\'' <<< '\''{"foo":false,"bar":123}'\'''
json -d '"array"' <<< '{"foo":false,"bar":123}' 2>&1 ||
echo 'command failed: json -d '\''"array"'\'' <<< '\''{"foo":false,"bar":123}'\'''

echo '$ json -d '\''"array"'\'' <<< '\''{"foo":{},"bar":[]}'\'''
json -d '"array"' <<< '{"foo":{},"bar":[]}' 2>&1 ||
echo 'command failed: json -d '\''"array"'\'' <<< '\''{"foo":{},"bar":[]}'\'''

echo '$ json -d '\''"array"'\'' <<< '\''{"foo":{"bar":{"baz":[]}}}'\'''
json -d '"array"' <<< '{"foo":{"bar":{"baz":[]}}}' 2>&1 ||
echo 'command failed: json -d '\''"array"'\'' <<< '\''{"foo":{"bar":{"baz":[]}}}'\'''

echo '$ json -d '\''"array"'\'' <<< '\''[]'\'''
json -d '"array"' <<< '[]' 2>&1 ||
echo 'command failed: json -d '\''"array"'\'' <<< '\''[]'\'''

echo '$ json -d '\''"array"'\'' <<< '\''[null]'\'''
json -d '"array"' <<< '[null]' 2>&1 ||
echo 'command failed: json -d '\''"array"'\'' <<< '\''[null]'\'''

echo '$ json -d '\''"array"'\'' <<< '\''[false]'\'''
json -d '"array"' <<< '[false]' 2>&1 ||
echo 'command failed: json -d '\''"array"'\'' <<< '\''[false]'\'''

echo '$ json -d '\''"array"'\'' <<< '\''[456]'\'''
json -d '"array"' <<< '[456]' 2>&1 ||
echo 'command failed: json -d '\''"array"'\'' <<< '\''[456]'\'''

echo '$ json -d '\''"array"'\'' <<< '\''[""]'\'''
json -d '"array"' <<< '[""]' 2>&1 ||
echo 'command failed: json -d '\''"array"'\'' <<< '\''[""]'\'''

echo '$ json -d '\''"array"'\'' <<< '\''[{}]'\'''
json -d '"array"' <<< '[{}]' 2>&1 ||
echo 'command failed: json -d '\''"array"'\'' <<< '\''[{}]'\'''

echo '$ json -d '\''"array"'\'' <<< '\''[{"foo":null}]'\'''
json -d '"array"' <<< '[{"foo":null}]' 2>&1 ||
echo 'command failed: json -d '\''"array"'\'' <<< '\''[{"foo":null}]'\'''

echo '$ json -d '\''"array"'\'' <<< '\''[{"foo":null,"bar":false}]'\'''
json -d '"array"' <<< '[{"foo":null,"bar":false}]' 2>&1 ||
echo 'command failed: json -d '\''"array"'\'' <<< '\''[{"foo":null,"bar":false}]'\'''

echo '$ json -d '\''"array"'\'' <<< '\''[{"foo":[],"bar":{}}]'\'''
json -d '"array"' <<< '[{"foo":[],"bar":{}}]' 2>&1 ||
echo 'command failed: json -d '\''"array"'\'' <<< '\''[{"foo":[],"bar":{}}]'\'''

echo '$ json -d '\''"array"'\'' <<< '\''[[]]'\'''
json -d '"array"' <<< '[[]]' 2>&1 ||
echo 'command failed: json -d '\''"array"'\'' <<< '\''[[]]'\'''

echo '$ json -d '\''"array"'\'' <<< '\''[[],[]]'\'''
json -d '"array"' <<< '[[],[]]' 2>&1 ||
echo 'command failed: json -d '\''"array"'\'' <<< '\''[[],[]]'\'''
)

