#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020, 2021  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -C type-lib:dict-expr-escape
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L dict-expr-escape.old <(echo \
'$ json() { LD_LIBRARY_PATH=../lib ../src/json -V -TA <<< '\''{"type":"dict","args":[{"name":"a","type":"number"},{"name":"b","type":"number"},{"name":"c","type":"number"}],"expr":'\''$'\''\n"'\''"$1"'\''"}'\''; }
$ json '\''a \n\f\"|'\''
json: error: <stdin>:2:8: meta error: invalid dict expression: unexpected char
json: error: <stdin>:2:8: type":"number"}],"expr":\n"a \\n\\f\\"|"}
json: error: <stdin>:2:8:                                    ^
command failed: json '\''a \n\f\"|'\''
$ json '\''a \n\f\\|'\''
json: error: <stdin>:2:8: meta error: invalid dict expression: unexpected char
json: error: <stdin>:2:8: type":"number"}],"expr":\n"a \\n\\f\\\\|"}
json: error: <stdin>:2:8:                                    ^
command failed: json '\''a \n\f\\|'\''
$ json '\''a \n\f\/|'\''
json: error: <stdin>:2:8: meta error: invalid dict expression: unexpected char
json: error: <stdin>:2:8: type":"number"}],"expr":\n"a \\n\\f\\/|"}
json: error: <stdin>:2:8:                                    ^
command failed: json '\''a \n\f\/|'\''
$ json '\''a \n\f\b|'\''
json: error: <stdin>:2:8: meta error: invalid dict expression: unexpected char
json: error: <stdin>:2:8: type":"number"}],"expr":\n"a \\n\\f\\b|"}
json: error: <stdin>:2:8:                                    ^
command failed: json '\''a \n\f\b|'\''
$ json '\''a \n\f\f|'\''
json: error: <stdin>:2:11: meta error: invalid dict expression: unexpected end of expression
json: error: <stdin>:2:11: e":"number"}],"expr":\n"a \\n\\f\\f|"}
json: error: <stdin>:2:11:                                     ^
command failed: json '\''a \n\f\f|'\''
$ json '\''a \n\f\n|'\''
json: error: <stdin>:2:11: meta error: invalid dict expression: unexpected end of expression
json: error: <stdin>:2:11: e":"number"}],"expr":\n"a \\n\\f\\n|"}
json: error: <stdin>:2:11:                                     ^
command failed: json '\''a \n\f\n|'\''
$ json '\''a \n\f\r|'\''
json: error: <stdin>:2:11: meta error: invalid dict expression: unexpected end of expression
json: error: <stdin>:2:11: e":"number"}],"expr":\n"a \\n\\f\\r|"}
json: error: <stdin>:2:11:                                     ^
command failed: json '\''a \n\f\r|'\''
$ json '\''a \n\f\t|'\''
json: error: <stdin>:2:11: meta error: invalid dict expression: unexpected end of expression
json: error: <stdin>:2:11: e":"number"}],"expr":\n"a \\n\\f\\t|"}
json: error: <stdin>:2:11:                                     ^
command failed: json '\''a \n\f\t|'\'''
) -L dict-expr-escape.new <(
echo '$ json() { LD_LIBRARY_PATH=../lib ../src/json -V -TA <<< '\''{"type":"dict","args":[{"name":"a","type":"number"},{"name":"b","type":"number"},{"name":"c","type":"number"}],"expr":'\''$'\''\n"'\''"$1"'\''"}'\''; }'
json() { LD_LIBRARY_PATH=../lib ../src/json -V -TA <<< '{"type":"dict","args":[{"name":"a","type":"number"},{"name":"b","type":"number"},{"name":"c","type":"number"}],"expr":'$'\n"'"$1"'"}'; } 2>&1 ||
echo 'command failed: json() { LD_LIBRARY_PATH=../lib ../src/json -V -TA <<< '\''{"type":"dict","args":[{"name":"a","type":"number"},{"name":"b","type":"number"},{"name":"c","type":"number"}],"expr":'\''$'\''\n"'\''"$1"'\''"}'\''; }'

echo '$ json '\''a \n\f\"|'\'''
json 'a \n\f\"|' 2>&1 ||
echo 'command failed: json '\''a \n\f\"|'\'''

echo '$ json '\''a \n\f\\|'\'''
json 'a \n\f\\|' 2>&1 ||
echo 'command failed: json '\''a \n\f\\|'\'''

echo '$ json '\''a \n\f\/|'\'''
json 'a \n\f\/|' 2>&1 ||
echo 'command failed: json '\''a \n\f\/|'\'''

echo '$ json '\''a \n\f\b|'\'''
json 'a \n\f\b|' 2>&1 ||
echo 'command failed: json '\''a \n\f\b|'\'''

echo '$ json '\''a \n\f\f|'\'''
json 'a \n\f\f|' 2>&1 ||
echo 'command failed: json '\''a \n\f\f|'\'''

echo '$ json '\''a \n\f\n|'\'''
json 'a \n\f\n|' 2>&1 ||
echo 'command failed: json '\''a \n\f\n|'\'''

echo '$ json '\''a \n\f\r|'\'''
json 'a \n\f\r|' 2>&1 ||
echo 'command failed: json '\''a \n\f\r|'\'''

echo '$ json '\''a \n\f\t|'\'''
json 'a \n\f\t|' 2>&1 ||
echo 'command failed: json '\''a \n\f\t|'\'''
)

