#!/bin/bash

# Copyright (C) 2016, 2017, 2018, 2019, 2020, 2021  Stefan Vargyas
# 
# This file is part of Json-Type.
# 
# Json-Type is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# Json-Type is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Json-Type.  If not, see <http://www.gnu.org/licenses/>.

#
# File generated by a command like:
# $ json-gentest -p litex -C expr-ast:op12
#

[[ "$1" =~ ^-u[0-9]+$ ]] &&
u="${1:2}" ||
u=""

diff -u$u -L op12.old <(echo \
'$ shopt -s expand_aliases
$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"
$ test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vc ast; }
$ alias test-expr='\''test-expr -b alpha -E'\''
$ test-expr '\''a != (b && (c >= (d || e)))'\'' -a 0,0,1,1,2
0
$ test-expr '\''a != (b && (c >= (d || e)))'\'' -a 0,0,1,2,2
0
$ test-expr '\''a != (b && (c >= (d || e)))'\'' -a 0,1,0,1,0
0
$ test-expr '\''a != (b && (c >= (d || e)))'\'' -a 0,1,0,1,2
0
$ test-expr '\''a != (b && (c >= (d || e)))'\'' -a 0,1,1,1,0
1
$ test-expr '\''a != (b && (c >= (d || e)))'\'' -a 0,2,0,0,1
0
$ test-expr '\''a != (b && (c >= (d || e)))'\'' -a 0,2,2,2,1
1
$ test-expr '\''a != (b && (c >= (d || e)))'\'' -a 1,0,0,0,1
1
$ test-expr '\''a != (b && (c >= (d || e)))'\'' -a 1,0,0,2,0
1
$ test-expr '\''a != (b && (c >= (d || e)))'\'' -a 1,0,2,1,0
1
$ test-expr '\''a != (b && (c >= (d || e)))'\'' -a 1,0,2,2,1
1
$ test-expr '\''a != (b && (c >= (d || e)))'\'' -a 1,1,1,1,1
0
$ test-expr '\''a != (b && (c >= (d || e)))'\'' -a 1,1,2,0,0
0
$ test-expr '\''a != (b && (c >= (d || e)))'\'' -a 1,2,1,0,1
0
$ test-expr '\''a != (b && (c >= (d || e)))'\'' -a 1,2,1,1,1
0
$ test-expr '\''a != (b && (c >= (d || e)))'\'' -a 1,2,1,1,2
0
$ test-expr '\''a != (b && (c >= (d || e)))'\'' -a 1,2,2,2,1
0
$ test-expr '\''a != (b && (c >= (d || e)))'\'' -a 2,0,1,0,1
1
$ test-expr '\''a != (b && (c >= (d || e)))'\'' -a 2,0,1,1,0
1
$ test-expr '\''a != (b && (c >= (d || e)))'\'' -a 2,0,2,1,0
1
$ test-expr '\''a != (b && (c >= (d || e)))'\'' -a 2,1,0,0,0
1
$ test-expr '\''a != (b && (c >= (d || e)))'\'' -a 2,1,1,2,2
1
$ test-expr '\''a != (b && (c >= (d || e)))'\'' -a 2,1,2,1,2
1
$ test-expr '\''a != (b && (c >= (d || e)))'\'' -a 2,2,2,1,1
1
$ test-expr '\''a != (b && (c >= (d || e)))'\'' -a 2,2,2,2,2
1
$ test-expr '\''a != (b && (c || (d >= e)))'\'' -a 0,1,0,0,0
1
$ test-expr '\''a != (b && (c || (d >= e)))'\'' -a 0,1,1,2,2
1
$ test-expr '\''a != (b && (c || (d >= e)))'\'' -a 0,1,2,0,2
1
$ test-expr '\''a != (b && (c || (d >= e)))'\'' -a 0,2,1,0,2
1
$ test-expr '\''a != (b && (c || (d >= e)))'\'' -a 0,2,2,1,2
1
$ test-expr '\''a != (b && (c || (d >= e)))'\'' -a 1,0,1,2,2
1
$ test-expr '\''a != (b && (c || (d >= e)))'\'' -a 1,1,0,0,0
0
$ test-expr '\''a != (b && (c || (d >= e)))'\'' -a 1,1,0,0,2
1
$ test-expr '\''a != (b && (c || (d >= e)))'\'' -a 1,1,1,2,1
0
$ test-expr '\''a != (b && (c || (d >= e)))'\'' -a 1,1,1,2,2
0
$ test-expr '\''a != (b && (c || (d >= e)))'\'' -a 1,1,2,1,0
0
$ test-expr '\''a != (b && (c || (d >= e)))'\'' -a 1,2,0,1,2
1
$ test-expr '\''a != (b && (c || (d >= e)))'\'' -a 2,0,0,2,0
1
$ test-expr '\''a != (b && (c || (d >= e)))'\'' -a 2,0,0,2,1
1
$ test-expr '\''a != (b && (c || (d >= e)))'\'' -a 2,0,1,1,2
1
$ test-expr '\''a != (b && (c || (d >= e)))'\'' -a 2,0,1,2,1
1
$ test-expr '\''a != (b && (c || (d >= e)))'\'' -a 2,0,1,2,2
1
$ test-expr '\''a != (b && (c || (d >= e)))'\'' -a 2,0,2,1,0
1
$ test-expr '\''a != (b && (c || (d >= e)))'\'' -a 2,1,0,1,2
1
$ test-expr '\''a != (b && (c || (d >= e)))'\'' -a 2,1,0,2,1
1
$ test-expr '\''a != (b && (c || (d >= e)))'\'' -a 2,1,1,2,1
1
$ test-expr '\''a != (b && (c || (d >= e)))'\'' -a 2,2,1,0,0
1
$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 0,0,0,2,1
0
$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 0,0,1,2,0
0
$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 0,0,2,2,0
0
$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 0,0,2,2,1
0
$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 0,1,1,0,1
1
$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 0,2,1,0,1
1
$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 0,2,1,1,0
1
$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 0,2,1,2,0
0
$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 0,2,1,2,2
1
$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 0,2,2,0,1
1
$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 0,2,2,1,0
1
$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 0,2,2,1,2
1
$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 0,2,2,2,2
1
$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 1,0,0,0,1
1
$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 1,0,2,2,0
1
$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 1,1,0,1,0
1
$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 1,1,1,0,0
0
$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 1,1,1,2,0
1
$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 1,1,2,0,0
0
$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 1,1,2,0,1
0
$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 1,1,2,2,2
0
$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 1,2,0,2,2
0
$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 1,2,1,0,1
0
$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 2,0,2,0,0
1
$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 2,0,2,0,1
1
$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 2,1,1,0,1
1
$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 2,1,1,1,1
1
$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 2,1,1,1,2
1
$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 2,1,1,2,1
1
$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 2,1,1,2,2
1
$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 2,1,2,1,2
1
$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 2,2,0,0,1
1
$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 2,2,0,1,1
1
$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 2,2,0,2,0
1
$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 2,2,1,0,2
1
$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 2,2,1,1,1
1
$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 2,2,2,2,1
1
$ test-expr '\''a != (b && ((c || d) >= e))'\'' -a 0,0,0,1,0
0
$ test-expr '\''a != (b && ((c || d) >= e))'\'' -a 0,0,1,0,1
0
$ test-expr '\''a != (b && ((c || d) >= e))'\'' -a 0,0,1,2,2
0
$ test-expr '\''a != (b && ((c || d) >= e))'\'' -a 0,0,2,0,0
0
$ test-expr '\''a != (b && ((c || d) >= e))'\'' -a 0,0,2,0,2
0
$ test-expr '\''a != (b && ((c || d) >= e))'\'' -a 0,0,2,1,2
0
$ test-expr '\''a != (b && ((c || d) >= e))'\'' -a 0,1,1,1,1
1
$ test-expr '\''a != (b && ((c || d) >= e))'\'' -a 0,1,1,2,0
1
$ test-expr '\''a != (b && ((c || d) >= e))'\'' -a 0,1,1,2,2
0
$ test-expr '\''a != (b && ((c || d) >= e))'\'' -a 0,1,2,0,0
1
$ test-expr '\''a != (b && ((c || d) >= e))'\'' -a 0,2,0,2,2
0
$ test-expr '\''a != (b && ((c || d) >= e))'\'' -a 1,0,0,2,2
1
$ test-expr '\''a != (b && ((c || d) >= e))'\'' -a 1,0,1,1,1
1
$ test-expr '\''a != (b && ((c || d) >= e))'\'' -a 1,0,2,1,2
1
$ test-expr '\''a != (b && ((c || d) >= e))'\'' -a 1,1,0,0,1
1
$ test-expr '\''a != (b && ((c || d) >= e))'\'' -a 1,1,0,1,0
0
$ test-expr '\''a != (b && ((c || d) >= e))'\'' -a 1,1,0,1,2
1
$ test-expr '\''a != (b && ((c || d) >= e))'\'' -a 1,1,0,2,0
0
$ test-expr '\''a != (b && ((c || d) >= e))'\'' -a 1,1,1,0,0
0
$ test-expr '\''a != (b && ((c || d) >= e))'\'' -a 1,1,2,0,1
0
$ test-expr '\''a != (b && ((c || d) >= e))'\'' -a 1,2,0,1,1
0
$ test-expr '\''a != (b && ((c || d) >= e))'\'' -a 1,2,1,0,2
1
$ test-expr '\''a != (b && ((c || d) >= e))'\'' -a 1,2,2,0,1
0
$ test-expr '\''a != (b && ((c || d) >= e))'\'' -a 2,0,1,0,0
1
$ test-expr '\''a != (b && ((c || d) >= e))'\'' -a 2,0,1,1,1
1
$ test-expr '\''a != (b && ((c || d) >= e))'\'' -a 2,0,2,2,2
1
$ test-expr '\''a != (b && ((c || d) >= e))'\'' -a 2,1,1,0,0
1
$ test-expr '\''a != (b && ((c || d) >= e))'\'' -a 2,1,1,1,1
1
$ test-expr '\''a != (b && ((c || d) >= e))'\'' -a 2,2,2,0,2
1
$ test-expr '\''a != (b && ((c || d) >= e))'\'' -a 2,2,2,2,2
1
$ test-expr '\''a != (b >= (c && (d || e)))'\'' -a 0,0,0,2,2
1
$ test-expr '\''a != (b >= (c && (d || e)))'\'' -a 0,0,1,0,0
1
$ test-expr '\''a != (b >= (c && (d || e)))'\'' -a 0,1,0,0,1
1
$ test-expr '\''a != (b >= (c && (d || e)))'\'' -a 0,1,0,1,0
1
$ test-expr '\''a != (b >= (c && (d || e)))'\'' -a 0,1,1,2,1
1
$ test-expr '\''a != (b >= (c && (d || e)))'\'' -a 0,1,2,1,1
1
$ test-expr '\''a != (b >= (c && (d || e)))'\'' -a 0,1,2,2,1
1
$ test-expr '\''a != (b >= (c && (d || e)))'\'' -a 0,2,0,1,0
1
$ test-expr '\''a != (b >= (c && (d || e)))'\'' -a 0,2,0,2,1
1
$ test-expr '\''a != (b >= (c && (d || e)))'\'' -a 0,2,0,2,2
1
$ test-expr '\''a != (b >= (c && (d || e)))'\'' -a 1,0,0,2,2
0
$ test-expr '\''a != (b >= (c && (d || e)))'\'' -a 1,0,1,2,1
1
$ test-expr '\''a != (b >= (c && (d || e)))'\'' -a 1,0,2,2,1
1
$ test-expr '\''a != (b >= (c && (d || e)))'\'' -a 1,1,0,1,1
0
$ test-expr '\''a != (b >= (c && (d || e)))'\'' -a 1,1,0,2,0
0
$ test-expr '\''a != (b >= (c && (d || e)))'\'' -a 1,1,0,2,2
0
$ test-expr '\''a != (b >= (c && (d || e)))'\'' -a 1,1,1,2,0
0
$ test-expr '\''a != (b >= (c && (d || e)))'\'' -a 1,1,2,1,1
0
$ test-expr '\''a != (b >= (c && (d || e)))'\'' -a 1,2,0,2,2
0
$ test-expr '\''a != (b >= (c && (d || e)))'\'' -a 1,2,2,0,2
0
$ test-expr '\''a != (b >= (c && (d || e)))'\'' -a 1,2,2,2,1
0
$ test-expr '\''a != (b >= (c && (d || e)))'\'' -a 2,0,0,0,2
1
$ test-expr '\''a != (b >= (c && (d || e)))'\'' -a 2,0,0,1,1
1
$ test-expr '\''a != (b >= (c && (d || e)))'\'' -a 2,0,1,2,2
1
$ test-expr '\''a != (b >= (c && (d || e)))'\'' -a 2,0,2,1,1
1
$ test-expr '\''a != (b >= (c && (d || e)))'\'' -a 2,0,2,2,1
1
$ test-expr '\''a != (b >= (c && (d || e)))'\'' -a 2,1,0,1,0
1
$ test-expr '\''a != (b >= (c && (d || e)))'\'' -a 2,1,2,0,2
1
$ test-expr '\''a != (b >= (c && (d || e)))'\'' -a 2,1,2,2,0
1
$ test-expr '\''a != (b >= (c && (d || e)))'\'' -a 2,2,0,0,1
1
$ test-expr '\''a != (b >= (c && (d || e)))'\'' -a 2,2,0,1,0
1
$ test-expr '\''a != (b >= (c && (d || e)))'\'' -a 2,2,1,2,1
1
$ test-expr '\''a != (b >= (c && (d || e)))'\'' -a 2,2,1,2,2
1
$ test-expr '\''a != (b >= (c || (d && e)))'\'' -a 0,0,2,1,1
0
$ test-expr '\''a != (b >= (c || (d && e)))'\'' -a 0,0,2,2,2
0
$ test-expr '\''a != (b >= (c || (d && e)))'\'' -a 0,1,0,0,0
1
$ test-expr '\''a != (b >= (c || (d && e)))'\'' -a 0,1,0,0,2
1
$ test-expr '\''a != (b >= (c || (d && e)))'\'' -a 0,1,1,1,1
1
$ test-expr '\''a != (b >= (c || (d && e)))'\'' -a 0,1,1,2,0
1
$ test-expr '\''a != (b >= (c || (d && e)))'\'' -a 0,1,2,2,1
1
$ test-expr '\''a != (b >= (c || (d && e)))'\'' -a 0,2,0,0,2
1
$ test-expr '\''a != (b >= (c || (d && e)))'\'' -a 0,2,2,0,0
1
$ test-expr '\''a != (b >= (c || (d && e)))'\'' -a 1,0,0,2,0
0
$ test-expr '\''a != (b >= (c || (d && e)))'\'' -a 1,0,1,0,2
1
$ test-expr '\''a != (b >= (c || (d && e)))'\'' -a 1,1,0,0,2
0
$ test-expr '\''a != (b >= (c || (d && e)))'\'' -a 1,1,0,1,0
0
$ test-expr '\''a != (b >= (c || (d && e)))'\'' -a 1,1,0,1,2
0
$ test-expr '\''a != (b >= (c || (d && e)))'\'' -a 1,1,1,0,1
0
$ test-expr '\''a != (b >= (c || (d && e)))'\'' -a 1,1,2,0,0
0
$ test-expr '\''a != (b >= (c || (d && e)))'\'' -a 1,1,2,0,2
0
$ test-expr '\''a != (b >= (c || (d && e)))'\'' -a 1,1,2,1,1
0
$ test-expr '\''a != (b >= (c || (d && e)))'\'' -a 1,1,2,2,1
0
$ test-expr '\''a != (b >= (c || (d && e)))'\'' -a 1,2,1,0,0
0
$ test-expr '\''a != (b >= (c || (d && e)))'\'' -a 1,2,2,0,1
0
$ test-expr '\''a != (b >= (c || (d && e)))'\'' -a 2,0,0,0,0
1
$ test-expr '\''a != (b >= (c || (d && e)))'\'' -a 2,0,1,0,0
1
$ test-expr '\''a != (b >= (c || (d && e)))'\'' -a 2,0,1,0,1
1
$ test-expr '\''a != (b >= (c || (d && e)))'\'' -a 2,0,2,2,1
1
$ test-expr '\''a != (b >= (c || (d && e)))'\'' -a 2,1,0,0,0
1
$ test-expr '\''a != (b >= (c || (d && e)))'\'' -a 2,1,1,1,2
1
$ test-expr '\''a != (b >= (c || (d && e)))'\'' -a 2,1,2,2,2
1
$ test-expr '\''a != (b >= (c || (d && e)))'\'' -a 2,2,0,0,1
1
$ test-expr '\''a != (b >= (c || (d && e)))'\'' -a 2,2,0,0,2
1
$ test-expr '\''a != (b >= (c || (d && e)))'\'' -a 2,2,1,0,2
1
$ test-expr '\''a != (b >= (c || (d && e)))'\'' -a 2,2,1,2,1
1
$ test-expr '\''a != (b >= (c || (d && e)))'\'' -a 2,2,2,2,1
1
$ test-expr '\''a != (b >= ((c && d) || e))'\'' -a 0,0,1,1,0
0
$ test-expr '\''a != (b >= ((c && d) || e))'\'' -a 0,0,2,0,0
1
$ test-expr '\''a != (b >= ((c && d) || e))'\'' -a 0,0,2,1,2
0
$ test-expr '\''a != (b >= ((c && d) || e))'\'' -a 0,0,2,2,1
0
$ test-expr '\''a != (b >= ((c && d) || e))'\'' -a 0,1,0,0,1
1
$ test-expr '\''a != (b >= ((c && d) || e))'\'' -a 0,1,0,1,0
1
$ test-expr '\''a != (b >= ((c && d) || e))'\'' -a 0,1,0,2,0
1
$ test-expr '\''a != (b >= ((c && d) || e))'\'' -a 0,1,2,0,1
1
$ test-expr '\''a != (b >= ((c && d) || e))'\'' -a 0,2,1,0,1
1
$ test-expr '\''a != (b >= ((c && d) || e))'\'' -a 0,2,2,1,0
1
$ test-expr '\''a != (b >= ((c && d) || e))'\'' -a 1,0,0,0,0
0
$ test-expr '\''a != (b >= ((c && d) || e))'\'' -a 1,0,0,2,1
1
$ test-expr '\''a != (b >= ((c && d) || e))'\'' -a 1,0,1,1,0
1
$ test-expr '\''a != (b >= ((c && d) || e))'\'' -a 1,0,2,2,2
1
$ test-expr '\''a != (b >= ((c && d) || e))'\'' -a 1,1,0,1,2
0
$ test-expr '\''a != (b >= ((c && d) || e))'\'' -a 2,0,0,0,2
1
$ test-expr '\''a != (b >= ((c && d) || e))'\'' -a 2,0,0,1,1
1
$ test-expr '\''a != (b >= ((c && d) || e))'\'' -a 2,0,1,2,1
1
$ test-expr '\''a != (b >= ((c && d) || e))'\'' -a 2,0,2,1,2
1
$ test-expr '\''a != (b >= ((c && d) || e))'\'' -a 2,1,1,0,2
1
$ test-expr '\''a != (b >= ((c && d) || e))'\'' -a 2,1,1,1,2
1
$ test-expr '\''a != (b >= ((c && d) || e))'\'' -a 2,1,2,0,0
1
$ test-expr '\''a != (b >= ((c && d) || e))'\'' -a 2,2,0,0,1
1
$ test-expr '\''a != (b >= ((c && d) || e))'\'' -a 2,2,2,1,1
1
$ test-expr '\''a != (b >= ((c && d) || e))'\'' -a 2,2,2,2,0
1
$ test-expr '\''a != (b >= ((c || d) && e))'\'' -a 0,0,0,0,1
1
$ test-expr '\''a != (b >= ((c || d) && e))'\'' -a 0,0,1,1,1
0
$ test-expr '\''a != (b >= ((c || d) && e))'\'' -a 0,0,1,2,1
0
$ test-expr '\''a != (b >= ((c || d) && e))'\'' -a 0,1,1,2,2
1
$ test-expr '\''a != (b >= ((c || d) && e))'\'' -a 0,1,2,0,1
1
$ test-expr '\''a != (b >= ((c || d) && e))'\'' -a 0,1,2,1,2
1
$ test-expr '\''a != (b >= ((c || d) && e))'\'' -a 0,2,0,0,1
1
$ test-expr '\''a != (b >= ((c || d) && e))'\'' -a 0,2,1,0,0
1
$ test-expr '\''a != (b >= ((c || d) && e))'\'' -a 0,2,1,1,2
1
$ test-expr '\''a != (b >= ((c || d) && e))'\'' -a 0,2,2,0,2
1
$ test-expr '\''a != (b >= ((c || d) && e))'\'' -a 0,2,2,1,1
1
$ test-expr '\''a != (b >= ((c || d) && e))'\'' -a 1,0,0,0,1
0
$ test-expr '\''a != (b >= ((c || d) && e))'\'' -a 1,0,0,2,0
0
$ test-expr '\''a != (b >= ((c || d) && e))'\'' -a 1,0,1,1,1
1
$ test-expr '\''a != (b >= ((c || d) && e))'\'' -a 1,0,2,1,2
1
$ test-expr '\''a != (b >= ((c || d) && e))'\'' -a 1,1,0,1,0
0
$ test-expr '\''a != (b >= ((c || d) && e))'\'' -a 1,1,1,0,2
0
$ test-expr '\''a != (b >= ((c || d) && e))'\'' -a 1,1,1,1,2
0
$ test-expr '\''a != (b >= ((c || d) && e))'\'' -a 1,1,1,2,1
0
$ test-expr '\''a != (b >= ((c || d) && e))'\'' -a 1,1,2,2,1
0
$ test-expr '\''a != (b >= ((c || d) && e))'\'' -a 1,1,2,2,2
0
$ test-expr '\''a != (b >= ((c || d) && e))'\'' -a 1,2,0,0,1
0
$ test-expr '\''a != (b >= ((c || d) && e))'\'' -a 1,2,0,2,1
0
$ test-expr '\''a != (b >= ((c || d) && e))'\'' -a 1,2,2,1,2
0
$ test-expr '\''a != (b >= ((c || d) && e))'\'' -a 1,2,2,2,2
0
$ test-expr '\''a != (b >= ((c || d) && e))'\'' -a 2,0,0,2,2
1
$ test-expr '\''a != (b >= ((c || d) && e))'\'' -a 2,0,1,1,0
1
$ test-expr '\''a != (b >= ((c || d) && e))'\'' -a 2,0,2,1,1
1
$ test-expr '\''a != (b >= ((c || d) && e))'\'' -a 2,1,0,1,1
1
$ test-expr '\''a != (b || (c && (d >= e)))'\'' -a 0,0,1,0,2
0
$ test-expr '\''a != (b || (c && (d >= e)))'\'' -a 0,0,2,1,0
1
$ test-expr '\''a != (b || (c && (d >= e)))'\'' -a 0,1,0,1,1
1
$ test-expr '\''a != (b || (c && (d >= e)))'\'' -a 0,1,2,0,0
1
$ test-expr '\''a != (b || (c && (d >= e)))'\'' -a 0,1,2,0,2
1
$ test-expr '\''a != (b || (c && (d >= e)))'\'' -a 0,1,2,2,1
1
$ test-expr '\''a != (b || (c && (d >= e)))'\'' -a 0,2,0,0,2
1
$ test-expr '\''a != (b || (c && (d >= e)))'\'' -a 0,2,0,2,2
1
$ test-expr '\''a != (b || (c && (d >= e)))'\'' -a 0,2,1,0,1
1
$ test-expr '\''a != (b || (c && (d >= e)))'\'' -a 0,2,1,0,2
1
$ test-expr '\''a != (b || (c && (d >= e)))'\'' -a 0,2,1,1,1
1
$ test-expr '\''a != (b || (c && (d >= e)))'\'' -a 1,0,0,1,2
1
$ test-expr '\''a != (b || (c && (d >= e)))'\'' -a 1,0,1,0,0
0
$ test-expr '\''a != (b || (c && (d >= e)))'\'' -a 1,0,1,2,2
0
$ test-expr '\''a != (b || (c && (d >= e)))'\'' -a 1,1,0,1,1
0
$ test-expr '\''a != (b || (c && (d >= e)))'\'' -a 1,1,0,1,2
0
$ test-expr '\''a != (b || (c && (d >= e)))'\'' -a 1,1,0,2,2
0
$ test-expr '\''a != (b || (c && (d >= e)))'\'' -a 1,1,1,1,1
0
$ test-expr '\''a != (b || (c && (d >= e)))'\'' -a 1,1,2,0,1
0
$ test-expr '\''a != (b || (c && (d >= e)))'\'' -a 1,1,2,2,2
0
$ test-expr '\''a != (b || (c && (d >= e)))'\'' -a 1,2,0,0,0
0
$ test-expr '\''a != (b || (c && (d >= e)))'\'' -a 1,2,0,1,1
0
$ test-expr '\''a != (b || (c && (d >= e)))'\'' -a 1,2,0,2,1
0
$ test-expr '\''a != (b || (c && (d >= e)))'\'' -a 1,2,1,0,1
0
$ test-expr '\''a != (b || (c && (d >= e)))'\'' -a 1,2,2,2,2
0
$ test-expr '\''a != (b || (c && (d >= e)))'\'' -a 2,1,0,1,0
1
$ test-expr '\''a != (b || (c && (d >= e)))'\'' -a 2,1,0,2,2
1
$ test-expr '\''a != (b || (c && (d >= e)))'\'' -a 2,1,1,2,2
1
$ test-expr '\''a != (b || (c && (d >= e)))'\'' -a 2,2,0,0,1
1
$ test-expr '\''a != (b || (c && (d >= e)))'\'' -a 2,2,0,1,1
1
$ test-expr '\''a != (b || (c && (d >= e)))'\'' -a 2,2,2,1,1
1
$ test-expr '\''a != (b || (c && (d >= e)))'\'' -a 2,2,2,1,2
1
$ test-expr '\''a != (b || (c && (d >= e)))'\'' -a 2,2,2,2,2
1
$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 0,0,1,0,0
1
$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 0,0,1,0,1
1
$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 0,0,1,2,0
1
$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 0,0,1,2,1
1
$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 0,0,1,2,2
1
$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 0,0,2,0,2
1
$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 0,0,2,1,2
1
$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 0,0,2,2,2
1
$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 0,1,0,0,2
1
$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 0,1,0,2,1
1
$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 0,1,1,0,1
1
$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 0,1,1,2,2
1
$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 0,1,2,2,1
1
$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 0,2,0,0,0
1
$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 0,2,0,2,0
1
$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 0,2,0,2,1
1
$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 0,2,1,1,0
1
$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 0,2,1,2,0
1
$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 1,0,1,1,1
0
$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 1,0,2,1,0
0
$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 1,1,0,2,2
0
$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 1,1,1,0,0
0
$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 1,1,1,1,0
0
$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 1,1,2,0,2
0
$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 1,2,2,1,0
0
$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 2,0,0,0,0
1
$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 2,0,0,1,1
1
$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 2,0,0,1,2
1
$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 2,1,1,0,0
1
$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 2,1,1,2,1
1
$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 2,2,0,0,1
1
$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 2,2,0,2,0
1
$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 2,2,0,2,1
1
$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 2,2,1,0,1
1
$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 2,2,1,1,0
1
$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 2,2,1,2,0
1
$ test-expr '\''a != (b || ((c && d) >= e))'\'' -a 0,0,0,0,0
1
$ test-expr '\''a != (b || ((c && d) >= e))'\'' -a 0,0,0,1,0
1
$ test-expr '\''a != (b || ((c && d) >= e))'\'' -a 0,0,1,2,1
1
$ test-expr '\''a != (b || ((c && d) >= e))'\'' -a 0,1,0,0,2
1
$ test-expr '\''a != (b || ((c && d) >= e))'\'' -a 0,1,2,0,1
1
$ test-expr '\''a != (b || ((c && d) >= e))'\'' -a 0,2,0,0,1
1
$ test-expr '\''a != (b || ((c && d) >= e))'\'' -a 0,2,1,0,0
1
$ test-expr '\''a != (b || ((c && d) >= e))'\'' -a 0,2,2,0,1
1
$ test-expr '\''a != (b || ((c && d) >= e))'\'' -a 0,2,2,1,0
1
$ test-expr '\''a != (b || ((c && d) >= e))'\'' -a 0,2,2,2,0
1
$ test-expr '\''a != (b || ((c && d) >= e))'\'' -a 1,0,1,0,1
1
$ test-expr '\''a != (b || ((c && d) >= e))'\'' -a 1,0,1,2,1
0
$ test-expr '\''a != (b || ((c && d) >= e))'\'' -a 1,0,2,0,0
0
$ test-expr '\''a != (b || ((c && d) >= e))'\'' -a 1,1,2,0,2
0
$ test-expr '\''a != (b || ((c && d) >= e))'\'' -a 1,2,0,0,1
0
$ test-expr '\''a != (b || ((c && d) >= e))'\'' -a 1,2,0,2,1
0
$ test-expr '\''a != (b || ((c && d) >= e))'\'' -a 1,2,2,0,0
0
$ test-expr '\''a != (b || ((c && d) >= e))'\'' -a 1,2,2,1,1
0
$ test-expr '\''a != (b || ((c && d) >= e))'\'' -a 2,0,0,0,0
1
$ test-expr '\''a != (b || ((c && d) >= e))'\'' -a 2,0,1,2,2
1
$ test-expr '\''a != (b || ((c && d) >= e))'\'' -a 2,1,0,1,1
1
$ test-expr '\''a != (b || ((c && d) >= e))'\'' -a 2,1,1,1,0
1
$ test-expr '\''a != (b || ((c && d) >= e))'\'' -a 2,1,1,1,2
1
$ test-expr '\''a != (b || ((c && d) >= e))'\'' -a 2,2,0,0,0
1
$ test-expr '\''a != (b || ((c && d) >= e))'\'' -a 2,2,0,2,1
1
$ test-expr '\''a != (b || ((c && d) >= e))'\'' -a 2,2,1,1,2
1
$ test-expr '\''a != (b || ((c && d) >= e))'\'' -a 2,2,2,1,2
1
$ test-expr '\''a != (b || ((c && d) >= e))'\'' -a 2,2,2,2,0
1
$ test-expr '\''a != (b || ((c >= d) && e))'\'' -a 0,0,0,0,0
0
$ test-expr '\''a != (b || ((c >= d) && e))'\'' -a 0,0,1,2,2
0
$ test-expr '\''a != (b || ((c >= d) && e))'\'' -a 0,0,2,0,0
0
$ test-expr '\''a != (b || ((c >= d) && e))'\'' -a 0,0,2,0,2
1
$ test-expr '\''a != (b || ((c >= d) && e))'\'' -a 0,1,1,2,0
1
$ test-expr '\''a != (b || ((c >= d) && e))'\'' -a 0,1,2,1,1
1
$ test-expr '\''a != (b || ((c >= d) && e))'\'' -a 0,1,2,1,2
1
$ test-expr '\''a != (b || ((c >= d) && e))'\'' -a 0,2,0,0,0
1
$ test-expr '\''a != (b || ((c >= d) && e))'\'' -a 0,2,0,1,1
1
$ test-expr '\''a != (b || ((c >= d) && e))'\'' -a 0,2,0,2,0
1
$ test-expr '\''a != (b || ((c >= d) && e))'\'' -a 0,2,0,2,1
1
$ test-expr '\''a != (b || ((c >= d) && e))'\'' -a 1,0,0,1,2
1
$ test-expr '\''a != (b || ((c >= d) && e))'\'' -a 1,0,1,1,2
0
$ test-expr '\''a != (b || ((c >= d) && e))'\'' -a 1,0,2,0,2
0
$ test-expr '\''a != (b || ((c >= d) && e))'\'' -a 1,1,0,1,2
0
$ test-expr '\''a != (b || ((c >= d) && e))'\'' -a 1,1,1,0,1
0
$ test-expr '\''a != (b || ((c >= d) && e))'\'' -a 1,2,0,2,0
0
$ test-expr '\''a != (b || ((c >= d) && e))'\'' -a 1,2,1,0,0
0
$ test-expr '\''a != (b || ((c >= d) && e))'\'' -a 1,2,1,1,0
0
$ test-expr '\''a != (b || ((c >= d) && e))'\'' -a 1,2,1,2,2
0
$ test-expr '\''a != (b || ((c >= d) && e))'\'' -a 1,2,2,2,2
0
$ test-expr '\''a != (b || ((c >= d) && e))'\'' -a 2,0,0,0,2
1
$ test-expr '\''a != (b || ((c >= d) && e))'\'' -a 2,0,0,2,2
1
$ test-expr '\''a != (b || ((c >= d) && e))'\'' -a 2,0,1,2,1
1
$ test-expr '\''a != (b || ((c >= d) && e))'\'' -a 2,0,2,1,1
1
$ test-expr '\''a != (b || ((c >= d) && e))'\'' -a 2,1,1,1,2
1
$ test-expr '\''a != (b || ((c >= d) && e))'\'' -a 2,1,2,2,1
1
$ test-expr '\''a != (b || ((c >= d) && e))'\'' -a 2,2,0,0,0
1
$ test-expr '\''a != (b || ((c >= d) && e))'\'' -a 2,2,0,2,0
1
$ test-expr '\''a != ((b && c) >= (d || e))'\'' -a 0,0,1,1,0
0
$ test-expr '\''a != ((b && c) >= (d || e))'\'' -a 0,0,2,0,1
0
$ test-expr '\''a != ((b && c) >= (d || e))'\'' -a 0,1,0,2,2
0
$ test-expr '\''a != ((b && c) >= (d || e))'\'' -a 0,1,1,0,2
1
$ test-expr '\''a != ((b && c) >= (d || e))'\'' -a 0,2,2,0,1
1
$ test-expr '\''a != ((b && c) >= (d || e))'\'' -a 1,0,0,0,0
0
$ test-expr '\''a != ((b && c) >= (d || e))'\'' -a 1,0,0,2,0
1
$ test-expr '\''a != ((b && c) >= (d || e))'\'' -a 1,0,1,0,1
1
$ test-expr '\''a != ((b && c) >= (d || e))'\'' -a 1,0,2,2,2
1
$ test-expr '\''a != ((b && c) >= (d || e))'\'' -a 1,1,0,0,1
1
$ test-expr '\''a != ((b && c) >= (d || e))'\'' -a 1,1,1,2,0
0
$ test-expr '\''a != ((b && c) >= (d || e))'\'' -a 1,1,2,1,1
0
$ test-expr '\''a != ((b && c) >= (d || e))'\'' -a 1,2,1,2,0
0
$ test-expr '\''a != ((b && c) >= (d || e))'\'' -a 1,2,1,2,1
0
$ test-expr '\''a != ((b && c) >= (d || e))'\'' -a 1,2,2,1,2
0
$ test-expr '\''a != ((b && c) >= (d || e))'\'' -a 2,0,0,0,1
1
$ test-expr '\''a != ((b && c) >= (d || e))'\'' -a 2,0,0,2,1
1
$ test-expr '\''a != ((b && c) >= (d || e))'\'' -a 2,0,2,0,1
1
$ test-expr '\''a != ((b && c) >= (d || e))'\'' -a 2,1,0,0,2
1
$ test-expr '\''a != ((b && c) >= (d || e))'\'' -a 2,1,0,2,0
1
$ test-expr '\''a != ((b && c) >= (d || e))'\'' -a 2,1,0,2,1
1
$ test-expr '\''a != ((b && c) >= (d || e))'\'' -a 2,1,1,0,2
1
$ test-expr '\''a != ((b && c) >= (d || e))'\'' -a 2,1,1,1,2
1
$ test-expr '\''a != ((b && c) >= (d || e))'\'' -a 2,2,0,0,1
1
$ test-expr '\''a != ((b && c) >= (d || e))'\'' -a 2,2,1,2,2
1
$ test-expr '\''a != ((b && c) >= (d || e))'\'' -a 2,2,2,2,1
1
$ test-expr '\''a != ((b && c) || (d >= e))'\'' -a 0,0,0,0,0
1
$ test-expr '\''a != ((b && c) || (d >= e))'\'' -a 0,0,0,1,0
1
$ test-expr '\''a != ((b && c) || (d >= e))'\'' -a 0,0,0,2,2
1
$ test-expr '\''a != ((b && c) || (d >= e))'\'' -a 0,1,0,2,1
1
$ test-expr '\''a != ((b && c) || (d >= e))'\'' -a 0,1,1,0,0
1
$ test-expr '\''a != ((b && c) || (d >= e))'\'' -a 0,1,2,0,0
1
$ test-expr '\''a != ((b && c) || (d >= e))'\'' -a 0,2,0,2,1
1
$ test-expr '\''a != ((b && c) || (d >= e))'\'' -a 0,2,1,0,2
1
$ test-expr '\''a != ((b && c) || (d >= e))'\'' -a 0,2,1,1,2
1
$ test-expr '\''a != ((b && c) || (d >= e))'\'' -a 0,2,1,2,1
1
$ test-expr '\''a != ((b && c) || (d >= e))'\'' -a 1,0,1,0,0
0
$ test-expr '\''a != ((b && c) || (d >= e))'\'' -a 1,0,1,1,2
1
$ test-expr '\''a != ((b && c) || (d >= e))'\'' -a 1,1,0,2,2
0
$ test-expr '\''a != ((b && c) || (d >= e))'\'' -a 2,0,0,2,2
1
$ test-expr '\''a != ((b && c) || (d >= e))'\'' -a 2,0,1,2,2
1
$ test-expr '\''a != ((b && c) || (d >= e))'\'' -a 2,0,2,0,0
1
$ test-expr '\''a != ((b && c) || (d >= e))'\'' -a 2,1,0,1,1
1
$ test-expr '\''a != ((b && c) || (d >= e))'\'' -a 2,1,0,2,2
1
$ test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 0,0,0,0,1
1
$ test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 0,0,0,1,2
1
$ test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 0,0,0,2,0
0
$ test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 0,0,1,0,2
1
$ test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 0,0,1,1,0
0
$ test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 0,0,1,1,1
1
$ test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 0,0,2,2,1
1
$ test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 0,1,0,1,1
1
$ test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 0,2,0,0,1
1
$ test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 0,2,0,1,1
1
$ test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 0,2,2,0,0
1
$ test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 0,2,2,0,1
1
$ test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 0,2,2,1,2
1
$ test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 0,2,2,2,0
1
$ test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 1,0,0,2,0
1
$ test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 1,0,1,0,2
0
$ test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 1,0,1,2,2
0
$ test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 1,0,2,0,2
0
$ test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 1,1,0,0,1
0
$ test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 1,1,1,2,2
0
$ test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 1,2,0,2,2
0
$ test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 1,2,2,1,0
0
$ test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 1,2,2,2,0
0
$ test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 2,0,0,1,1
1
$ test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 2,1,0,1,0
1
$ test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 2,1,0,1,2
1
$ test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 2,1,1,2,1
1
$ test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 2,2,0,0,1
1
$ test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 2,2,0,0,2
1
$ test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 2,2,0,1,2
1
$ test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 2,2,1,0,0
1
$ test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 2,2,2,2,1
1
$ test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 0,0,0,1,2
0
$ test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 0,0,0,2,0
1
$ test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 0,1,2,0,2
0
$ test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 0,1,2,1,1
1
$ test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 0,1,2,1,2
0
$ test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 0,2,0,1,0
1
$ test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 0,2,0,2,2
0
$ test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 1,0,0,1,2
1
$ test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 1,0,1,0,0
0
$ test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 1,0,1,2,2
1
$ test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 1,1,2,0,1
0
$ test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 1,2,1,1,0
0
$ test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 1,2,1,2,0
0
$ test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 2,0,0,1,1
1
$ test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 2,0,1,0,0
1
$ test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 2,0,1,2,1
1
$ test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 2,0,2,0,2
1
$ test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 2,1,0,0,2
1
$ test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 2,1,0,2,0
1
$ test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 2,1,0,2,2
1
$ test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 2,1,1,0,2
1
$ test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 2,1,2,1,2
1
$ test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 2,2,0,0,2
1
$ test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 2,2,1,2,2
1
$ test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 2,2,2,1,2
1
$ test-expr '\''a != ((b >= c) && (d || e))'\'' -a 0,0,1,0,1
0
$ test-expr '\''a != ((b >= c) && (d || e))'\'' -a 0,1,0,2,1
1
$ test-expr '\''a != ((b >= c) && (d || e))'\'' -a 0,1,2,0,1
0
$ test-expr '\''a != ((b >= c) && (d || e))'\'' -a 0,1,2,2,2
0
$ test-expr '\''a != ((b >= c) && (d || e))'\'' -a 0,2,0,2,0
1
$ test-expr '\''a != ((b >= c) && (d || e))'\'' -a 0,2,1,0,2
1
$ test-expr '\''a != ((b >= c) && (d || e))'\'' -a 0,2,2,0,2
1
$ test-expr '\''a != ((b >= c) && (d || e))'\'' -a 1,0,1,1,2
1
$ test-expr '\''a != ((b >= c) && (d || e))'\'' -a 1,0,1,2,1
1
$ test-expr '\''a != ((b >= c) && (d || e))'\'' -a 1,1,0,0,0
1
$ test-expr '\''a != ((b >= c) && (d || e))'\'' -a 1,1,0,1,2
0
$ test-expr '\''a != ((b >= c) && (d || e))'\'' -a 1,1,1,1,0
0
$ test-expr '\''a != ((b >= c) && (d || e))'\'' -a 1,1,2,2,0
1
$ test-expr '\''a != ((b >= c) && (d || e))'\'' -a 1,2,0,0,2
0
$ test-expr '\''a != ((b >= c) && (d || e))'\'' -a 1,2,1,0,0
1
$ test-expr '\''a != ((b >= c) && (d || e))'\'' -a 1,2,2,0,2
0
$ test-expr '\''a != ((b >= c) && (d || e))'\'' -a 2,0,1,1,1
1
$ test-expr '\''a != ((b >= c) && (d || e))'\'' -a 2,1,0,2,1
1
$ test-expr '\''a != ((b >= c) && (d || e))'\'' -a 2,1,2,1,1
1
$ test-expr '\''a != ((b >= c) && (d || e))'\'' -a 2,2,0,0,0
1
$ test-expr '\''a != ((b >= c) && (d || e))'\'' -a 2,2,1,0,1
1
$ test-expr '\''a != ((b >= c) && (d || e))'\'' -a 2,2,2,1,2
1
$ test-expr '\''a != ((b >= c) || (d && e))'\'' -a 0,0,0,0,0
1
$ test-expr '\''a != ((b >= c) || (d && e))'\'' -a 0,0,0,0,1
1
$ test-expr '\''a != ((b >= c) || (d && e))'\'' -a 0,0,1,2,1
1
$ test-expr '\''a != ((b >= c) || (d && e))'\'' -a 0,0,2,2,0
0
$ test-expr '\''a != ((b >= c) || (d && e))'\'' -a 0,1,0,1,1
1
$ test-expr '\''a != ((b >= c) || (d && e))'\'' -a 0,1,1,0,2
1
$ test-expr '\''a != ((b >= c) || (d && e))'\'' -a 0,1,1,2,1
1
$ test-expr '\''a != ((b >= c) || (d && e))'\'' -a 0,1,2,2,0
0
$ test-expr '\''a != ((b >= c) || (d && e))'\'' -a 0,2,0,0,2
1
$ test-expr '\''a != ((b >= c) || (d && e))'\'' -a 0,2,2,0,2
1
$ test-expr '\''a != ((b >= c) || (d && e))'\'' -a 0,2,2,1,0
1
$ test-expr '\''a != ((b >= c) || (d && e))'\'' -a 1,0,0,0,0
0
$ test-expr '\''a != ((b >= c) || (d && e))'\'' -a 1,0,0,0,1
0
$ test-expr '\''a != ((b >= c) || (d && e))'\'' -a 1,0,1,0,0
1
$ test-expr '\''a != ((b >= c) || (d && e))'\'' -a 1,1,0,2,2
0
$ test-expr '\''a != ((b >= c) || (d && e))'\'' -a 1,2,0,0,1
0
$ test-expr '\''a != ((b >= c) || (d && e))'\'' -a 1,2,0,1,0
0
$ test-expr '\''a != ((b >= c) || (d && e))'\'' -a 1,2,1,2,0
0
$ test-expr '\''a != ((b >= c) || (d && e))'\'' -a 1,2,2,0,1
0
$ test-expr '\''a != ((b >= c) || (d && e))'\'' -a 1,2,2,1,0
0
$ test-expr '\''a != ((b >= c) || (d && e))'\'' -a 2,0,1,0,0
1
$ test-expr '\''a != ((b >= c) || (d && e))'\'' -a 2,0,1,2,1
1
$ test-expr '\''a != ((b >= c) || (d && e))'\'' -a 2,0,2,1,2
1
$ test-expr '\''a != ((b >= c) || (d && e))'\'' -a 2,1,0,0,1
1
$ test-expr '\''a != ((b >= c) || (d && e))'\'' -a 2,1,0,1,2
1
$ test-expr '\''a != ((b >= c) || (d && e))'\'' -a 2,1,2,0,1
1
$ test-expr '\''a != ((b >= c) || (d && e))'\'' -a 2,1,2,2,1
1
$ test-expr '\''a != ((b >= c) || (d && e))'\'' -a 2,2,0,1,0
1
$ test-expr '\''a != ((b >= c) || (d && e))'\'' -a 2,2,2,2,1
1
$ test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 0,0,1,2,1
1
$ test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 0,0,2,1,0
0
$ test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 0,0,2,2,1
1
$ test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 0,1,0,1,0
1
$ test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 0,1,2,0,0
1
$ test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 0,1,2,2,2
1
$ test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 0,2,1,0,1
1
$ test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 0,2,2,0,0
1
$ test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 1,0,0,2,0
0
$ test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 1,0,1,0,1
0
$ test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 1,0,2,0,1
0
$ test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 1,0,2,1,2
0
$ test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 1,0,2,2,2
0
$ test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 1,1,1,0,0
0
$ test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 1,2,0,2,0
0
$ test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 1,2,1,0,1
0
$ test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 1,2,2,2,2
0
$ test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 2,0,0,0,0
1
$ test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 2,0,2,1,1
1
$ test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 2,0,2,2,0
1
$ test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 2,0,2,2,1
1
$ test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 2,1,1,2,0
1
$ test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 2,1,2,0,0
1
$ test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 2,2,0,1,0
1
$ test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 2,2,2,1,0
1
$ test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 2,2,2,2,2
1
$ test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 0,0,0,0,0
0
$ test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 0,0,1,0,2
0
$ test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 0,1,0,0,2
1
$ test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 0,1,1,2,0
0
$ test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 0,2,0,1,0
0
$ test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 0,2,0,2,0
0
$ test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 0,2,0,2,1
1
$ test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 0,2,2,1,1
1
$ test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 1,0,1,0,0
1
$ test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 1,0,1,0,1
1
$ test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 1,0,1,2,2
1
$ test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 1,0,2,1,1
1
$ test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 1,0,2,2,1
1
$ test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 1,1,1,0,0
1
$ test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 1,1,1,0,1
0
$ test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 1,1,2,1,2
0
$ test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 1,2,1,2,0
1
$ test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 2,0,0,2,0
1
$ test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 2,0,0,2,2
1
$ test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 2,0,1,0,1
1
$ test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 2,1,1,0,0
1
$ test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 2,1,2,2,0
1
$ test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 2,2,0,1,0
1
$ test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 2,2,0,2,1
1
$ test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 2,2,2,2,2
1
$ test-expr '\''a != ((b || c) && (d >= e))'\'' -a 0,0,0,0,0
0
$ test-expr '\''a != ((b || c) && (d >= e))'\'' -a 0,0,1,0,0
1
$ test-expr '\''a != ((b || c) && (d >= e))'\'' -a 0,0,1,1,2
0
$ test-expr '\''a != ((b || c) && (d >= e))'\'' -a 0,0,1,2,0
1
$ test-expr '\''a != ((b || c) && (d >= e))'\'' -a 0,0,2,0,0
1
$ test-expr '\''a != ((b || c) && (d >= e))'\'' -a 0,0,2,1,0
1
$ test-expr '\''a != ((b || c) && (d >= e))'\'' -a 0,0,2,1,1
1
$ test-expr '\''a != ((b || c) && (d >= e))'\'' -a 0,1,1,0,0
1
$ test-expr '\''a != ((b || c) && (d >= e))'\'' -a 0,1,1,1,1
1
$ test-expr '\''a != ((b || c) && (d >= e))'\'' -a 0,2,0,2,2
1
$ test-expr '\''a != ((b || c) && (d >= e))'\'' -a 0,2,1,2,1
1
$ test-expr '\''a != ((b || c) && (d >= e))'\'' -a 0,2,2,1,0
1
$ test-expr '\''a != ((b || c) && (d >= e))'\'' -a 1,0,0,0,0
1
$ test-expr '\''a != ((b || c) && (d >= e))'\'' -a 1,0,0,1,2
1
$ test-expr '\''a != ((b || c) && (d >= e))'\'' -a 1,0,2,1,2
1
$ test-expr '\''a != ((b || c) && (d >= e))'\'' -a 1,0,2,2,2
0
$ test-expr '\''a != ((b || c) && (d >= e))'\'' -a 1,1,0,0,2
1
$ test-expr '\''a != ((b || c) && (d >= e))'\'' -a 1,1,1,1,1
0
$ test-expr '\''a != ((b || c) && (d >= e))'\'' -a 1,1,2,0,0
0
$ test-expr '\''a != ((b || c) && (d >= e))'\'' -a 1,1,2,1,2
1
$ test-expr '\''a != ((b || c) && (d >= e))'\'' -a 1,1,2,2,2
0
$ test-expr '\''a != ((b || c) && (d >= e))'\'' -a 1,2,1,0,0
0
$ test-expr '\''a != ((b || c) && (d >= e))'\'' -a 1,2,1,0,2
1
$ test-expr '\''a != ((b || c) && (d >= e))'\'' -a 2,1,0,1,2
1
$ test-expr '\''a != ((b || c) && (d >= e))'\'' -a 2,1,0,2,2
1
$ test-expr '\''a != ((b || c) && (d >= e))'\'' -a 2,1,1,0,0
1
$ test-expr '\''a != ((b || c) && (d >= e))'\'' -a 2,1,1,1,0
1
$ test-expr '\''a != ((b || c) && (d >= e))'\'' -a 2,1,2,1,1
1
$ test-expr '\''a != ((b || c) && (d >= e))'\'' -a 2,2,0,0,1
1
$ test-expr '\''a != ((b || c) && (d >= e))'\'' -a 2,2,0,0,2
1
$ test-expr '\''a != ((b || c) && (d >= e))'\'' -a 2,2,1,1,2
1
$ test-expr '\''a != ((b || c) && (d >= e))'\'' -a 2,2,1,2,0
1
$ test-expr '\''a != ((b || c) && (d >= e))'\'' -a 2,2,2,0,0
1
$ test-expr '\''a != ((b || c) && (d >= e))'\'' -a 2,2,2,1,1
1
$ test-expr '\''a != ((b || c) >= (d && e))'\'' -a 0,0,0,0,0
1
$ test-expr '\''a != ((b || c) >= (d && e))'\'' -a 0,0,0,1,0
1
$ test-expr '\''a != ((b || c) >= (d && e))'\'' -a 0,0,1,2,2
1
$ test-expr '\''a != ((b || c) >= (d && e))'\'' -a 0,1,2,1,0
1
$ test-expr '\''a != ((b || c) >= (d && e))'\'' -a 0,2,0,2,1
1
$ test-expr '\''a != ((b || c) >= (d && e))'\'' -a 0,2,0,2,2
1
$ test-expr '\''a != ((b || c) >= (d && e))'\'' -a 0,2,2,0,1
1
$ test-expr '\''a != ((b || c) >= (d && e))'\'' -a 0,2,2,1,2
1
$ test-expr '\''a != ((b || c) >= (d && e))'\'' -a 1,0,0,1,2
1
$ test-expr '\''a != ((b || c) >= (d && e))'\'' -a 1,0,0,2,0
0
$ test-expr '\''a != ((b || c) >= (d && e))'\'' -a 1,0,1,1,1
0
$ test-expr '\''a != ((b || c) >= (d && e))'\'' -a 1,0,2,2,0
0
$ test-expr '\''a != ((b || c) >= (d && e))'\'' -a 1,1,0,1,2
0
$ test-expr '\''a != ((b || c) >= (d && e))'\'' -a 1,1,0,2,0
0
$ test-expr '\''a != ((b || c) >= (d && e))'\'' -a 1,1,1,1,0
0
$ test-expr '\''a != ((b || c) >= (d && e))'\'' -a 1,2,0,1,1
0
$ test-expr '\''a != ((b || c) >= (d && e))'\'' -a 1,2,1,0,2
0
$ test-expr '\''a != ((b || c) >= (d && e))'\'' -a 1,2,2,0,1
0
$ test-expr '\''a != ((b || c) >= (d && e))'\'' -a 1,2,2,0,2
0
$ test-expr '\''a != ((b || c) >= (d && e))'\'' -a 1,2,2,1,1
0
$ test-expr '\''a != ((b || c) >= (d && e))'\'' -a 1,2,2,2,1
0
$ test-expr '\''a != ((b || c) >= (d && e))'\'' -a 1,2,2,2,2
0
$ test-expr '\''a != ((b || c) >= (d && e))'\'' -a 2,0,1,0,0
1
$ test-expr '\''a != ((b || c) >= (d && e))'\'' -a 2,0,1,0,1
1
$ test-expr '\''a != ((b || c) >= (d && e))'\'' -a 2,1,2,0,0
1
$ test-expr '\''a != ((b || c) >= (d && e))'\'' -a 2,2,0,0,0
1
$ test-expr '\''a != ((b || c) >= (d && e))'\'' -a 2,2,1,0,1
1
$ test-expr '\''a != ((b || c) >= (d && e))'\'' -a 2,2,2,2,2
1
$ test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 0,0,0,2,2
0
$ test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 0,0,1,0,2
0
$ test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 0,0,1,1,0
1
$ test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 0,0,1,1,1
1
$ test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 0,0,1,2,2
0
$ test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 0,1,0,1,2
0
$ test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 0,1,1,0,0
1
$ test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 0,1,1,1,2
0
$ test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 0,1,2,0,0
1
$ test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 0,1,2,0,1
1
$ test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 0,1,2,1,0
1
$ test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 0,2,0,0,0
1
$ test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 0,2,0,2,1
1
$ test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 0,2,2,2,0
1
$ test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 1,0,0,0,2
1
$ test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 1,0,0,1,1
1
$ test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 1,0,1,0,0
0
$ test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 1,0,1,2,0
0
$ test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 1,1,0,0,1
0
$ test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 2,0,0,1,2
1
$ test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 2,0,1,2,0
1
$ test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 2,0,2,0,0
1
$ test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 2,0,2,2,2
1
$ test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 2,2,0,2,0
1
$ test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 2,2,2,1,0
1
$ test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 2,2,2,1,2
1
$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 0,0,1,0,1
1
$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 0,0,1,2,1
0
$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 0,1,0,1,2
1
$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 0,1,0,2,0
0
$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 0,1,0,2,2
1
$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 0,1,1,0,1
1
$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 0,1,1,0,2
1
$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 0,1,1,1,0
0
$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 0,1,2,1,1
1
$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 0,1,2,2,0
0
$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 0,2,2,1,1
1
$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 0,2,2,2,2
1
$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 1,0,1,1,0
1
$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 1,0,1,1,1
0
$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 1,0,1,2,2
1
$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 1,0,2,2,0
1
$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 1,0,2,2,1
0
$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 1,1,0,0,1
0
$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 1,1,0,0,2
0
$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 1,1,1,0,0
1
$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 1,1,2,1,0
1
$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 1,1,2,2,0
1
$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 1,2,0,0,0
1
$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 1,2,0,0,2
0
$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 1,2,1,2,1
0
$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 1,2,2,0,1
0
$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 2,0,1,1,2
1
$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 2,0,1,2,2
1
$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 2,0,2,1,2
1
$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 2,1,0,0,0
1
$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 2,1,1,1,0
1
$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 2,1,1,2,2
1
$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 2,2,0,0,1
1
$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 2,2,1,0,0
1
$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 2,2,2,0,1
1
$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 2,2,2,2,2
1
$ test-expr '\''a != (((b && c) >= d) || e)'\'' -a 0,0,0,0,2
1
$ test-expr '\''a != (((b && c) >= d) || e)'\'' -a 0,0,2,0,0
1
$ test-expr '\''a != (((b && c) >= d) || e)'\'' -a 0,0,2,0,1
1
$ test-expr '\''a != (((b && c) >= d) || e)'\'' -a 0,0,2,2,2
1
$ test-expr '\''a != (((b && c) >= d) || e)'\'' -a 0,1,0,1,1
1
$ test-expr '\''a != (((b && c) >= d) || e)'\'' -a 0,1,0,2,0
0
$ test-expr '\''a != (((b && c) >= d) || e)'\'' -a 0,1,0,2,2
1
$ test-expr '\''a != (((b && c) >= d) || e)'\'' -a 0,1,2,1,1
1
$ test-expr '\''a != (((b && c) >= d) || e)'\'' -a 0,1,2,2,0
0
$ test-expr '\''a != (((b && c) >= d) || e)'\'' -a 0,1,2,2,1
1
$ test-expr '\''a != (((b && c) >= d) || e)'\'' -a 0,1,2,2,2
1
$ test-expr '\''a != (((b && c) >= d) || e)'\'' -a 1,0,0,1,0
1
$ test-expr '\''a != (((b && c) >= d) || e)'\'' -a 1,0,1,0,1
0
$ test-expr '\''a != (((b && c) >= d) || e)'\'' -a 1,0,2,0,1
0
$ test-expr '\''a != (((b && c) >= d) || e)'\'' -a 1,0,2,1,2
0
$ test-expr '\''a != (((b && c) >= d) || e)'\'' -a 1,1,2,1,1
0
$ test-expr '\''a != (((b && c) >= d) || e)'\'' -a 1,1,2,2,1
0
$ test-expr '\''a != (((b && c) >= d) || e)'\'' -a 1,2,0,1,1
0
$ test-expr '\''a != (((b && c) >= d) || e)'\'' -a 1,2,2,1,0
0
$ test-expr '\''a != (((b && c) >= d) || e)'\'' -a 2,0,0,1,1
1
$ test-expr '\''a != (((b && c) >= d) || e)'\'' -a 2,0,1,1,1
1
$ test-expr '\''a != (((b && c) >= d) || e)'\'' -a 2,0,1,2,1
1
$ test-expr '\''a != (((b && c) >= d) || e)'\'' -a 2,0,2,0,1
1
$ test-expr '\''a != (((b && c) >= d) || e)'\'' -a 2,0,2,2,1
1
$ test-expr '\''a != (((b && c) >= d) || e)'\'' -a 2,1,0,0,2
1
$ test-expr '\''a != (((b && c) >= d) || e)'\'' -a 2,2,2,0,2
1
$ test-expr '\''a != (((b && c) >= d) || e)'\'' -a 2,2,2,2,1
1
$ test-expr '\''a != (((b && c) || d) >= e)'\'' -a 0,0,0,1,1
1
$ test-expr '\''a != (((b && c) || d) >= e)'\'' -a 0,0,0,1,2
0
$ test-expr '\''a != (((b && c) || d) >= e)'\'' -a 0,0,2,1,1
1
$ test-expr '\''a != (((b && c) || d) >= e)'\'' -a 0,0,2,1,2
0
$ test-expr '\''a != (((b && c) || d) >= e)'\'' -a 0,1,1,1,0
1
$ test-expr '\''a != (((b && c) || d) >= e)'\'' -a 0,1,1,2,1
1
$ test-expr '\''a != (((b && c) || d) >= e)'\'' -a 0,1,2,2,1
1
$ test-expr '\''a != (((b && c) || d) >= e)'\'' -a 0,2,1,1,2
0
$ test-expr '\''a != (((b && c) || d) >= e)'\'' -a 0,2,2,2,0
1
$ test-expr '\''a != (((b && c) || d) >= e)'\'' -a 0,2,2,2,2
0
$ test-expr '\''a != (((b && c) || d) >= e)'\'' -a 1,0,0,0,0
0
$ test-expr '\''a != (((b && c) || d) >= e)'\'' -a 1,0,0,2,1
0
$ test-expr '\''a != (((b && c) || d) >= e)'\'' -a 1,0,1,2,1
0
$ test-expr '\''a != (((b && c) || d) >= e)'\'' -a 1,0,2,0,0
0
$ test-expr '\''a != (((b && c) || d) >= e)'\'' -a 1,0,2,0,1
1
$ test-expr '\''a != (((b && c) || d) >= e)'\'' -a 1,1,0,0,0
0
$ test-expr '\''a != (((b && c) || d) >= e)'\'' -a 1,1,1,0,0
0
$ test-expr '\''a != (((b && c) || d) >= e)'\'' -a 1,2,0,1,0
0
$ test-expr '\''a != (((b && c) || d) >= e)'\'' -a 1,2,1,1,0
0
$ test-expr '\''a != (((b && c) || d) >= e)'\'' -a 2,0,0,1,0
1
$ test-expr '\''a != (((b && c) || d) >= e)'\'' -a 2,0,0,1,1
1
$ test-expr '\''a != (((b && c) || d) >= e)'\'' -a 2,0,1,1,2
1
$ test-expr '\''a != (((b && c) || d) >= e)'\'' -a 2,0,1,2,1
1
$ test-expr '\''a != (((b && c) || d) >= e)'\'' -a 2,0,2,1,1
1
$ test-expr '\''a != (((b && c) || d) >= e)'\'' -a 2,0,2,2,1
1
$ test-expr '\''a != (((b && c) || d) >= e)'\'' -a 2,1,0,1,2
1
$ test-expr '\''a != (((b && c) || d) >= e)'\'' -a 2,1,1,0,1
1
$ test-expr '\''a != (((b && c) || d) >= e)'\'' -a 2,1,1,0,2
1
$ test-expr '\''a != (((b && c) || d) >= e)'\'' -a 2,1,1,2,2
1
$ test-expr '\''a != (((b && c) || d) >= e)'\'' -a 2,1,2,1,0
1
$ test-expr '\''a != (((b && c) || d) >= e)'\'' -a 2,2,0,2,0
1
$ test-expr '\''a != (((b && c) || d) >= e)'\'' -a 2,2,0,2,1
1
$ test-expr '\''a != (((b >= c) && d) || e)'\'' -a 0,0,1,1,1
1
$ test-expr '\''a != (((b >= c) && d) || e)'\'' -a 0,0,2,0,0
0
$ test-expr '\''a != (((b >= c) && d) || e)'\'' -a 0,0,2,2,2
1
$ test-expr '\''a != (((b >= c) && d) || e)'\'' -a 0,1,0,1,2
1
$ test-expr '\''a != (((b >= c) && d) || e)'\'' -a 0,1,1,2,0
1
$ test-expr '\''a != (((b >= c) && d) || e)'\'' -a 0,1,2,0,2
1
$ test-expr '\''a != (((b >= c) && d) || e)'\'' -a 0,1,2,1,0
0
$ test-expr '\''a != (((b >= c) && d) || e)'\'' -a 0,1,2,2,1
1
$ test-expr '\''a != (((b >= c) && d) || e)'\'' -a 0,2,2,0,1
1
$ test-expr '\''a != (((b >= c) && d) || e)'\'' -a 1,0,2,2,0
1
$ test-expr '\''a != (((b >= c) && d) || e)'\'' -a 1,0,2,2,1
0
$ test-expr '\''a != (((b >= c) && d) || e)'\'' -a 1,1,0,2,1
0
$ test-expr '\''a != (((b >= c) && d) || e)'\'' -a 1,1,0,2,2
0
$ test-expr '\''a != (((b >= c) && d) || e)'\'' -a 1,1,1,0,1
0
$ test-expr '\''a != (((b >= c) && d) || e)'\'' -a 1,1,1,0,2
0
$ test-expr '\''a != (((b >= c) && d) || e)'\'' -a 1,1,2,2,1
0
$ test-expr '\''a != (((b >= c) && d) || e)'\'' -a 1,2,0,0,2
0
$ test-expr '\''a != (((b >= c) && d) || e)'\'' -a 1,2,0,1,0
0
$ test-expr '\''a != (((b >= c) && d) || e)'\'' -a 1,2,1,0,1
0
$ test-expr '\''a != (((b >= c) && d) || e)'\'' -a 1,2,1,0,2
0
$ test-expr '\''a != (((b >= c) && d) || e)'\'' -a 1,2,2,0,0
1
$ test-expr '\''a != (((b >= c) && d) || e)'\'' -a 2,0,0,0,2
1
$ test-expr '\''a != (((b >= c) && d) || e)'\'' -a 2,0,1,1,2
1
$ test-expr '\''a != (((b >= c) && d) || e)'\'' -a 2,0,1,2,2
1
$ test-expr '\''a != (((b >= c) && d) || e)'\'' -a 2,0,2,2,2
1
$ test-expr '\''a != (((b >= c) && d) || e)'\'' -a 2,1,0,0,2
1
$ test-expr '\''a != (((b >= c) && d) || e)'\'' -a 2,1,0,1,1
1
$ test-expr '\''a != (((b >= c) && d) || e)'\'' -a 2,1,1,1,1
1
$ test-expr '\''a != (((b >= c) && d) || e)'\'' -a 2,1,2,0,0
1
$ test-expr '\''a != (((b >= c) && d) || e)'\'' -a 2,2,0,1,1
1
$ test-expr '\''a != (((b >= c) && d) || e)'\'' -a 2,2,1,1,1
1
$ test-expr '\''a != (((b >= c) && d) || e)'\'' -a 2,2,1,2,0
1
$ test-expr '\''a != (((b >= c) || d) && e)'\'' -a 0,0,0,0,2
1
$ test-expr '\''a != (((b >= c) || d) && e)'\'' -a 0,0,1,1,2
1
$ test-expr '\''a != (((b >= c) || d) && e)'\'' -a 0,0,2,2,2
1
$ test-expr '\''a != (((b >= c) || d) && e)'\'' -a 0,1,0,0,1
1
$ test-expr '\''a != (((b >= c) || d) && e)'\'' -a 0,1,0,1,1
1
$ test-expr '\''a != (((b >= c) || d) && e)'\'' -a 0,1,2,2,0
0
$ test-expr '\''a != (((b >= c) || d) && e)'\'' -a 0,1,2,2,1
1
$ test-expr '\''a != (((b >= c) || d) && e)'\'' -a 0,2,0,0,2
1
$ test-expr '\''a != (((b >= c) || d) && e)'\'' -a 0,2,0,1,0
0
$ test-expr '\''a != (((b >= c) || d) && e)'\'' -a 0,2,1,1,2
1
$ test-expr '\''a != (((b >= c) || d) && e)'\'' -a 0,2,1,2,1
1
$ test-expr '\''a != (((b >= c) || d) && e)'\'' -a 0,2,2,2,0
0
$ test-expr '\''a != (((b >= c) || d) && e)'\'' -a 1,0,0,1,2
0
$ test-expr '\''a != (((b >= c) || d) && e)'\'' -a 1,0,1,0,2
1
$ test-expr '\''a != (((b >= c) || d) && e)'\'' -a 1,1,0,0,0
1
$ test-expr '\''a != (((b >= c) || d) && e)'\'' -a 1,1,0,1,0
1
$ test-expr '\''a != (((b >= c) || d) && e)'\'' -a 1,1,2,0,0
1
$ test-expr '\''a != (((b >= c) || d) && e)'\'' -a 1,1,2,2,0
1
$ test-expr '\''a != (((b >= c) || d) && e)'\'' -a 1,2,1,0,1
0
$ test-expr '\''a != (((b >= c) || d) && e)'\'' -a 1,2,2,0,0
1
$ test-expr '\''a != (((b >= c) || d) && e)'\'' -a 1,2,2,0,1
0
$ test-expr '\''a != (((b >= c) || d) && e)'\'' -a 1,2,2,1,1
0
$ test-expr '\''a != (((b >= c) || d) && e)'\'' -a 1,2,2,1,2
0
$ test-expr '\''a != (((b >= c) || d) && e)'\'' -a 2,0,0,2,0
1
$ test-expr '\''a != (((b >= c) || d) && e)'\'' -a 2,0,0,2,2
1
$ test-expr '\''a != (((b >= c) || d) && e)'\'' -a 2,0,1,2,1
1
$ test-expr '\''a != (((b >= c) || d) && e)'\'' -a 2,0,2,0,1
1
$ test-expr '\''a != (((b >= c) || d) && e)'\'' -a 2,1,1,1,2
1
$ test-expr '\''a != (((b >= c) || d) && e)'\'' -a 2,2,1,0,0
1
$ test-expr '\''a != (((b || c) && d) >= e)'\'' -a 0,0,0,2,0
1
$ test-expr '\''a != (((b || c) && d) >= e)'\'' -a 0,0,2,1,1
1
$ test-expr '\''a != (((b || c) && d) >= e)'\'' -a 0,0,2,2,0
1
$ test-expr '\''a != (((b || c) && d) >= e)'\'' -a 0,1,0,0,1
0
$ test-expr '\''a != (((b || c) && d) >= e)'\'' -a 0,1,0,1,0
1
$ test-expr '\''a != (((b || c) && d) >= e)'\'' -a 0,1,1,0,0
1
$ test-expr '\''a != (((b || c) && d) >= e)'\'' -a 0,1,1,0,2
0
$ test-expr '\''a != (((b || c) && d) >= e)'\'' -a 0,1,1,1,2
0
$ test-expr '\''a != (((b || c) && d) >= e)'\'' -a 0,2,1,0,1
0
$ test-expr '\''a != (((b || c) && d) >= e)'\'' -a 0,2,1,1,2
0
$ test-expr '\''a != (((b || c) && d) >= e)'\'' -a 1,0,0,2,1
1
$ test-expr '\''a != (((b || c) && d) >= e)'\'' -a 1,0,2,1,1
0
$ test-expr '\''a != (((b || c) && d) >= e)'\'' -a 1,1,0,1,1
0
$ test-expr '\''a != (((b || c) && d) >= e)'\'' -a 1,1,0,1,2
1
$ test-expr '\''a != (((b || c) && d) >= e)'\'' -a 1,1,2,0,2
1
$ test-expr '\''a != (((b || c) && d) >= e)'\'' -a 1,1,2,1,1
0
$ test-expr '\''a != (((b || c) && d) >= e)'\'' -a 1,2,2,2,1
0
$ test-expr '\''a != (((b || c) && d) >= e)'\'' -a 1,2,2,2,2
1
$ test-expr '\''a != (((b || c) && d) >= e)'\'' -a 2,0,0,0,1
1
$ test-expr '\''a != (((b || c) && d) >= e)'\'' -a 2,0,0,2,1
1
$ test-expr '\''a != (((b || c) && d) >= e)'\'' -a 2,0,1,2,2
1
$ test-expr '\''a != (((b || c) && d) >= e)'\'' -a 2,0,2,0,0
1
$ test-expr '\''a != (((b || c) && d) >= e)'\'' -a 2,0,2,2,0
1
$ test-expr '\''a != (((b || c) && d) >= e)'\'' -a 2,0,2,2,2
1
$ test-expr '\''a != (((b || c) && d) >= e)'\'' -a 2,1,0,0,1
1
$ test-expr '\''a != (((b || c) && d) >= e)'\'' -a 2,1,1,0,1
1
$ test-expr '\''a != (((b || c) && d) >= e)'\'' -a 2,1,1,1,0
1
$ test-expr '\''a != (((b || c) && d) >= e)'\'' -a 2,1,2,0,0
1
$ test-expr '\''a != (((b || c) && d) >= e)'\'' -a 2,1,2,0,2
1
$ test-expr '\''a != (((b || c) && d) >= e)'\'' -a 2,1,2,1,1
1
$ test-expr '\''a != (((b || c) && d) >= e)'\'' -a 2,1,2,2,2
1
$ test-expr '\''a != (((b || c) && d) >= e)'\'' -a 2,2,0,2,0
1
$ test-expr '\''a != (((b || c) && d) >= e)'\'' -a 2,2,1,2,1
1
$ test-expr '\''a != (((b || c) && d) >= e)'\'' -a 2,2,2,1,2
1
$ test-expr '\''a != (((b || c) >= d) && e)'\'' -a 0,0,0,0,2
1
$ test-expr '\''a != (((b || c) >= d) && e)'\'' -a 0,0,0,1,1
0
$ test-expr '\''a != (((b || c) >= d) && e)'\'' -a 0,0,0,1,2
0
$ test-expr '\''a != (((b || c) >= d) && e)'\'' -a 0,0,1,1,1
1
$ test-expr '\''a != (((b || c) >= d) && e)'\'' -a 0,0,1,1,2
1
$ test-expr '\''a != (((b || c) >= d) && e)'\'' -a 0,0,1,2,1
0
$ test-expr '\''a != (((b || c) >= d) && e)'\'' -a 0,1,0,1,1
1
$ test-expr '\''a != (((b || c) >= d) && e)'\'' -a 0,1,2,0,1
1
$ test-expr '\''a != (((b || c) >= d) && e)'\'' -a 0,1,2,2,1
0
$ test-expr '\''a != (((b || c) >= d) && e)'\'' -a 0,2,0,0,1
1
$ test-expr '\''a != (((b || c) >= d) && e)'\'' -a 0,2,0,2,1
0
$ test-expr '\''a != (((b || c) >= d) && e)'\'' -a 0,2,1,2,2
0
$ test-expr '\''a != (((b || c) >= d) && e)'\'' -a 1,0,0,2,0
1
$ test-expr '\''a != (((b || c) >= d) && e)'\'' -a 1,0,2,0,0
1
$ test-expr '\''a != (((b || c) >= d) && e)'\'' -a 1,0,2,0,1
0
$ test-expr '\''a != (((b || c) >= d) && e)'\'' -a 1,0,2,1,0
1
$ test-expr '\''a != (((b || c) >= d) && e)'\'' -a 1,1,0,0,0
1
$ test-expr '\''a != (((b || c) >= d) && e)'\'' -a 1,1,0,2,1
1
$ test-expr '\''a != (((b || c) >= d) && e)'\'' -a 1,1,1,1,0
1
$ test-expr '\''a != (((b || c) >= d) && e)'\'' -a 1,1,1,2,2
1
$ test-expr '\''a != (((b || c) >= d) && e)'\'' -a 1,1,2,0,1
0
$ test-expr '\''a != (((b || c) >= d) && e)'\'' -a 1,1,2,0,2
0
$ test-expr '\''a != (((b || c) >= d) && e)'\'' -a 1,1,2,1,1
0
$ test-expr '\''a != (((b || c) >= d) && e)'\'' -a 1,2,0,0,1
0
$ test-expr '\''a != (((b || c) >= d) && e)'\'' -a 1,2,0,1,0
1
$ test-expr '\''a != (((b || c) >= d) && e)'\'' -a 1,2,1,0,2
0
$ test-expr '\''a != (((b || c) >= d) && e)'\'' -a 1,2,2,1,0
1
$ test-expr '\''a != (((b || c) >= d) && e)'\'' -a 2,0,1,0,2
1
$ test-expr '\''a != (((b || c) >= d) && e)'\'' -a 2,0,2,2,2
1
$ test-expr '\''a != (((b || c) >= d) && e)'\'' -a 2,1,2,1,2
1
$ test-expr '\''a != (((b || c) >= d) && e)'\'' -a 2,2,0,1,2
1
$ test-expr '\''a != (((b || c) >= d) && e)'\'' -a 2,2,1,2,1
1
$ test-expr '\''a && (b != (c >= (d || e)))'\'' -a 0,0,0,2,1
0
$ test-expr '\''a && (b != (c >= (d || e)))'\'' -a 0,0,1,1,1
0
$ test-expr '\''a && (b != (c >= (d || e)))'\'' -a 0,0,2,2,1
0
$ test-expr '\''a && (b != (c >= (d || e)))'\'' -a 0,1,0,0,2
0
$ test-expr '\''a && (b != (c >= (d || e)))'\'' -a 0,1,1,0,0
0
$ test-expr '\''a && (b != (c >= (d || e)))'\'' -a 0,1,1,0,1
0
$ test-expr '\''a && (b != (c >= (d || e)))'\'' -a 0,1,2,2,2
0
$ test-expr '\''a && (b != (c >= (d || e)))'\'' -a 1,0,0,1,0
0
$ test-expr '\''a && (b != (c >= (d || e)))'\'' -a 1,0,2,0,2
1
$ test-expr '\''a && (b != (c >= (d || e)))'\'' -a 1,1,0,1,0
1
$ test-expr '\''a && (b != (c >= (d || e)))'\'' -a 1,1,2,2,1
0
$ test-expr '\''a && (b != (c >= (d || e)))'\'' -a 1,1,2,2,2
0
$ test-expr '\''a && (b != (c >= (d || e)))'\'' -a 1,2,0,0,2
1
$ test-expr '\''a && (b != (c >= (d || e)))'\'' -a 1,2,0,2,0
1
$ test-expr '\''a && (b != (c >= (d || e)))'\'' -a 1,2,1,1,1
1
$ test-expr '\''a && (b != (c >= (d || e)))'\'' -a 1,2,1,1,2
1
$ test-expr '\''a && (b != (c >= (d || e)))'\'' -a 1,2,2,2,2
1
$ test-expr '\''a && (b != (c >= (d || e)))'\'' -a 2,0,0,0,1
0
$ test-expr '\''a && (b != (c >= (d || e)))'\'' -a 2,0,0,1,0
0
$ test-expr '\''a && (b != (c >= (d || e)))'\'' -a 2,0,0,2,2
0
$ test-expr '\''a && (b != (c >= (d || e)))'\'' -a 2,0,1,2,0
1
$ test-expr '\''a && (b != (c >= (d || e)))'\'' -a 2,0,1,2,1
1
$ test-expr '\''a && (b != (c >= (d || e)))'\'' -a 2,0,2,1,0
1
$ test-expr '\''a && (b != (c >= (d || e)))'\'' -a 2,0,2,2,2
1
$ test-expr '\''a && (b != (c >= (d || e)))'\'' -a 2,1,0,0,1
1
$ test-expr '\''a && (b != (c >= (d || e)))'\'' -a 2,1,0,0,2
1
$ test-expr '\''a && (b != (c >= (d || e)))'\'' -a 2,1,0,1,0
1
$ test-expr '\''a && (b != (c >= (d || e)))'\'' -a 2,1,0,1,2
1
$ test-expr '\''a && (b != (c >= (d || e)))'\'' -a 2,2,2,0,2
1
$ test-expr '\''a && (b != (c >= (d || e)))'\'' -a 2,2,2,2,2
1
$ test-expr '\''a && (b != (c || (d >= e)))'\'' -a 0,0,0,0,1
0
$ test-expr '\''a && (b != (c || (d >= e)))'\'' -a 0,0,0,1,1
0
$ test-expr '\''a && (b != (c || (d >= e)))'\'' -a 0,0,2,0,1
0
$ test-expr '\''a && (b != (c || (d >= e)))'\'' -a 0,1,0,2,2
0
$ test-expr '\''a && (b != (c || (d >= e)))'\'' -a 0,2,0,2,1
0
$ test-expr '\''a && (b != (c || (d >= e)))'\'' -a 0,2,1,0,1
0
$ test-expr '\''a && (b != (c || (d >= e)))'\'' -a 0,2,2,2,1
0
$ test-expr '\''a && (b != (c || (d >= e)))'\'' -a 1,0,0,0,2
0
$ test-expr '\''a && (b != (c || (d >= e)))'\'' -a 1,0,1,1,2
1
$ test-expr '\''a && (b != (c || (d >= e)))'\'' -a 1,1,0,2,2
0
$ test-expr '\''a && (b != (c || (d >= e)))'\'' -a 1,1,1,2,0
0
$ test-expr '\''a && (b != (c || (d >= e)))'\'' -a 1,2,0,1,0
1
$ test-expr '\''a && (b != (c || (d >= e)))'\'' -a 1,2,0,2,1
1
$ test-expr '\''a && (b != (c || (d >= e)))'\'' -a 1,2,1,1,1
1
$ test-expr '\''a && (b != (c || (d >= e)))'\'' -a 1,2,2,0,0
1
$ test-expr '\''a && (b != (c || (d >= e)))'\'' -a 1,2,2,1,0
1
$ test-expr '\''a && (b != (c || (d >= e)))'\'' -a 1,2,2,1,2
1
$ test-expr '\''a && (b != (c || (d >= e)))'\'' -a 2,0,2,0,0
1
$ test-expr '\''a && (b != (c || (d >= e)))'\'' -a 2,1,0,2,1
0
$ test-expr '\''a && (b != (c || (d >= e)))'\'' -a 2,1,0,2,2
0
$ test-expr '\''a && (b != (c || (d >= e)))'\'' -a 2,2,1,0,2
1
$ test-expr '\''a && (b != (c || (d >= e)))'\'' -a 2,2,1,1,0
1
$ test-expr '\''a && (b != (c || (d >= e)))'\'' -a 2,2,1,1,2
1
$ test-expr '\''a && (b != ((c >= d) || e))'\'' -a 0,0,0,2,0
0
$ test-expr '\''a && (b != ((c >= d) || e))'\'' -a 0,0,1,1,2
0
$ test-expr '\''a && (b != ((c >= d) || e))'\'' -a 0,0,2,1,0
0
$ test-expr '\''a && (b != ((c >= d) || e))'\'' -a 0,0,2,1,1
0
$ test-expr '\''a && (b != ((c >= d) || e))'\'' -a 0,1,1,2,0
0
$ test-expr '\''a && (b != ((c >= d) || e))'\'' -a 0,2,2,2,1
0
$ test-expr '\''a && (b != ((c >= d) || e))'\'' -a 1,0,0,0,2
1
$ test-expr '\''a && (b != ((c >= d) || e))'\'' -a 1,0,0,1,0
0
$ test-expr '\''a && (b != ((c >= d) || e))'\'' -a 1,0,1,0,0
1
$ test-expr '\''a && (b != ((c >= d) || e))'\'' -a 1,0,1,1,1
1
$ test-expr '\''a && (b != ((c >= d) || e))'\'' -a 1,0,2,0,0
1
$ test-expr '\''a && (b != ((c >= d) || e))'\'' -a 1,0,2,0,2
1
$ test-expr '\''a && (b != ((c >= d) || e))'\'' -a 1,1,2,1,2
0
$ test-expr '\''a && (b != ((c >= d) || e))'\'' -a 1,2,0,2,0
1
$ test-expr '\''a && (b != ((c >= d) || e))'\'' -a 1,2,0,2,2
1
$ test-expr '\''a && (b != ((c >= d) || e))'\'' -a 1,2,1,1,0
1
$ test-expr '\''a && (b != ((c >= d) || e))'\'' -a 1,2,2,1,0
1
$ test-expr '\''a && (b != ((c >= d) || e))'\'' -a 2,0,0,0,2
1
$ test-expr '\''a && (b != ((c >= d) || e))'\'' -a 2,0,0,1,0
0
$ test-expr '\''a && (b != ((c >= d) || e))'\'' -a 2,0,2,0,1
1
$ test-expr '\''a && (b != ((c >= d) || e))'\'' -a 2,0,2,0,2
1
$ test-expr '\''a && (b != ((c >= d) || e))'\'' -a 2,0,2,2,2
1
$ test-expr '\''a && (b != ((c >= d) || e))'\'' -a 2,1,1,0,0
0
$ test-expr '\''a && (b != ((c >= d) || e))'\'' -a 2,1,1,2,0
1
$ test-expr '\''a && (b != ((c >= d) || e))'\'' -a 2,2,0,1,2
1
$ test-expr '\''a && (b != ((c >= d) || e))'\'' -a 2,2,0,2,1
1
$ test-expr '\''a && (b != ((c >= d) || e))'\'' -a 2,2,1,1,0
1
$ test-expr '\''a && (b != ((c || d) >= e))'\'' -a 0,0,1,2,1
0
$ test-expr '\''a && (b != ((c || d) >= e))'\'' -a 0,0,1,2,2
0
$ test-expr '\''a && (b != ((c || d) >= e))'\'' -a 0,0,2,2,1
0
$ test-expr '\''a && (b != ((c || d) >= e))'\'' -a 0,1,0,0,0
0
$ test-expr '\''a && (b != ((c || d) >= e))'\'' -a 0,1,0,2,2
0
$ test-expr '\''a && (b != ((c || d) >= e))'\'' -a 0,1,1,0,1
0
$ test-expr '\''a && (b != ((c || d) >= e))'\'' -a 0,1,1,1,2
0
$ test-expr '\''a && (b != ((c || d) >= e))'\'' -a 0,2,0,0,2
0
$ test-expr '\''a && (b != ((c || d) >= e))'\'' -a 0,2,0,1,0
0
$ test-expr '\''a && (b != ((c || d) >= e))'\'' -a 0,2,0,1,2
0
$ test-expr '\''a && (b != ((c || d) >= e))'\'' -a 0,2,1,0,0
0
$ test-expr '\''a && (b != ((c || d) >= e))'\'' -a 0,2,2,0,2
0
$ test-expr '\''a && (b != ((c || d) >= e))'\'' -a 1,0,1,2,0
1
$ test-expr '\''a && (b != ((c || d) >= e))'\'' -a 1,0,2,1,2
0
$ test-expr '\''a && (b != ((c || d) >= e))'\'' -a 1,1,0,1,2
1
$ test-expr '\''a && (b != ((c || d) >= e))'\'' -a 1,1,1,0,0
0
$ test-expr '\''a && (b != ((c || d) >= e))'\'' -a 1,1,2,1,1
0
$ test-expr '\''a && (b != ((c || d) >= e))'\'' -a 1,2,0,1,2
1
$ test-expr '\''a && (b != ((c || d) >= e))'\'' -a 1,2,2,1,0
1
$ test-expr '\''a && (b != ((c || d) >= e))'\'' -a 1,2,2,1,1
1
$ test-expr '\''a && (b != ((c || d) >= e))'\'' -a 1,2,2,1,2
1
$ test-expr '\''a && (b != ((c || d) >= e))'\'' -a 1,2,2,2,0
1
$ test-expr '\''a && (b != ((c || d) >= e))'\'' -a 2,0,0,0,0
1
$ test-expr '\''a && (b != ((c || d) >= e))'\'' -a 2,0,1,0,2
0
$ test-expr '\''a && (b != ((c || d) >= e))'\'' -a 2,0,1,2,2
0
$ test-expr '\''a && (b != ((c || d) >= e))'\'' -a 2,0,2,0,1
1
$ test-expr '\''a && (b != ((c || d) >= e))'\'' -a 2,0,2,1,1
1
$ test-expr '\''a && (b != ((c || d) >= e))'\'' -a 2,1,1,0,2
1
$ test-expr '\''a && (b != ((c || d) >= e))'\'' -a 2,1,1,1,0
0
$ test-expr '\''a && (b != ((c || d) >= e))'\'' -a 2,2,0,0,0
1
$ test-expr '\''a && (b != ((c || d) >= e))'\'' -a 2,2,1,0,1
1
$ test-expr '\''a && (b != ((c || d) >= e))'\'' -a 2,2,1,1,0
1
$ test-expr '\''a && (b != ((c || d) >= e))'\'' -a 2,2,2,2,1
1
$ test-expr '\''a && (b >= (c != (d || e)))'\'' -a 0,0,1,2,1
0
$ test-expr '\''a && (b >= (c != (d || e)))'\'' -a 0,1,0,2,2
0
$ test-expr '\''a && (b >= (c != (d || e)))'\'' -a 0,1,1,0,1
0
$ test-expr '\''a && (b >= (c != (d || e)))'\'' -a 0,1,2,0,1
0
$ test-expr '\''a && (b >= (c != (d || e)))'\'' -a 0,2,1,2,1
0
$ test-expr '\''a && (b >= (c != (d || e)))'\'' -a 0,2,1,2,2
0
$ test-expr '\''a && (b >= (c != (d || e)))'\'' -a 0,2,2,1,2
0
$ test-expr '\''a && (b >= (c != (d || e)))'\'' -a 0,2,2,2,1
0
$ test-expr '\''a && (b >= (c != (d || e)))'\'' -a 1,0,1,0,0
0
$ test-expr '\''a && (b >= (c != (d || e)))'\'' -a 1,0,1,1,2
1
$ test-expr '\''a && (b >= (c != (d || e)))'\'' -a 1,0,2,2,2
0
$ test-expr '\''a && (b >= (c != (d || e)))'\'' -a 1,1,2,0,1
1
$ test-expr '\''a && (b >= (c != (d || e)))'\'' -a 1,1,2,0,2
1
$ test-expr '\''a && (b >= (c != (d || e)))'\'' -a 1,1,2,1,1
1
$ test-expr '\''a && (b >= (c != (d || e)))'\'' -a 1,1,2,2,0
1
$ test-expr '\''a && (b >= (c != (d || e)))'\'' -a 1,2,0,0,1
1
$ test-expr '\''a && (b >= (c != (d || e)))'\'' -a 1,2,2,0,1
1
$ test-expr '\''a && (b >= (c != (d || e)))'\'' -a 2,0,0,1,0
0
$ test-expr '\''a && (b >= (c != (d || e)))'\'' -a 2,0,1,0,0
0
$ test-expr '\''a && (b >= (c != (d || e)))'\'' -a 2,0,1,2,0
1
$ test-expr '\''a && (b >= (c != (d || e)))'\'' -a 2,0,2,0,1
0
$ test-expr '\''a && (b >= (c != (d || e)))'\'' -a 2,1,0,0,1
1
$ test-expr '\''a && (b >= (c != (d || e)))'\'' -a 2,1,0,1,0
1
$ test-expr '\''a && (b >= (c != (d || e)))'\'' -a 2,1,0,2,2
1
$ test-expr '\''a && (b >= (c != (d || e)))'\'' -a 2,1,1,1,0
1
$ test-expr '\''a && (b >= (c != (d || e)))'\'' -a 2,1,2,2,2
1
$ test-expr '\''a && (b >= (c != (d || e)))'\'' -a 2,2,0,0,1
1
$ test-expr '\''a && (b >= (c != (d || e)))'\'' -a 2,2,0,2,1
1
$ test-expr '\''a && (b >= (c != (d || e)))'\'' -a 2,2,1,2,1
1
$ test-expr '\''a && (b >= (c != (d || e)))'\'' -a 2,2,2,1,0
1
$ test-expr '\''a && (b >= (c != (d || e)))'\'' -a 2,2,2,2,0
1
$ test-expr '\''a && (b >= (c != (d || e)))'\'' -a 2,2,2,2,2
1
$ test-expr '\''a && (b >= (c || (d != e)))'\'' -a 0,0,1,1,1
0
$ test-expr '\''a && (b >= (c || (d != e)))'\'' -a 0,0,2,1,0
0
$ test-expr '\''a && (b >= (c || (d != e)))'\'' -a 0,1,2,0,1
0
$ test-expr '\''a && (b >= (c || (d != e)))'\'' -a 0,1,2,2,2
0
$ test-expr '\''a && (b >= (c || (d != e)))'\'' -a 0,2,0,1,1
0
$ test-expr '\''a && (b >= (c || (d != e)))'\'' -a 0,2,0,1,2
0
$ test-expr '\''a && (b >= (c || (d != e)))'\'' -a 0,2,0,2,2
0
$ test-expr '\''a && (b >= (c || (d != e)))'\'' -a 0,2,1,0,1
0
$ test-expr '\''a && (b >= (c || (d != e)))'\'' -a 0,2,1,1,2
0
$ test-expr '\''a && (b >= (c || (d != e)))'\'' -a 0,2,2,1,2
0
$ test-expr '\''a && (b >= (c || (d != e)))'\'' -a 1,0,0,1,1
1
$ test-expr '\''a && (b >= (c || (d != e)))'\'' -a 1,0,0,2,1
0
$ test-expr '\''a && (b >= (c || (d != e)))'\'' -a 1,1,1,0,1
1
$ test-expr '\''a && (b >= (c || (d != e)))'\'' -a 1,1,1,1,1
1
$ test-expr '\''a && (b >= (c || (d != e)))'\'' -a 1,2,2,2,2
1
$ test-expr '\''a && (b >= (c || (d != e)))'\'' -a 2,0,1,1,0
0
$ test-expr '\''a && (b >= (c || (d != e)))'\'' -a 2,0,2,1,1
0
$ test-expr '\''a && (b >= (c || (d != e)))'\'' -a 2,1,0,1,1
1
$ test-expr '\''a && (b >= (c || (d != e)))'\'' -a 2,1,0,2,1
1
$ test-expr '\''a && (b >= (c || (d != e)))'\'' -a 2,1,2,1,1
1
$ test-expr '\''a && (b >= (c || (d != e)))'\'' -a 2,2,0,2,1
1
$ test-expr '\''a && (b >= (c || (d != e)))'\'' -a 2,2,1,2,0
1
$ test-expr '\''a && (b >= ((c != d) || e))'\'' -a 0,0,0,1,2
0
$ test-expr '\''a && (b >= ((c != d) || e))'\'' -a 0,0,0,2,2
0
$ test-expr '\''a && (b >= ((c != d) || e))'\'' -a 0,0,1,0,0
0
$ test-expr '\''a && (b >= ((c != d) || e))'\'' -a 0,0,1,1,0
0
$ test-expr '\''a && (b >= ((c != d) || e))'\'' -a 0,0,2,1,1
0
$ test-expr '\''a && (b >= ((c != d) || e))'\'' -a 0,1,2,1,2
0
$ test-expr '\''a && (b >= ((c != d) || e))'\'' -a 0,2,0,1,0
0
$ test-expr '\''a && (b >= ((c != d) || e))'\'' -a 0,2,2,0,2
0
$ test-expr '\''a && (b >= ((c != d) || e))'\'' -a 1,0,0,0,0
1
$ test-expr '\''a && (b >= ((c != d) || e))'\'' -a 1,0,1,0,0
0
$ test-expr '\''a && (b >= ((c != d) || e))'\'' -a 1,0,1,0,2
0
$ test-expr '\''a && (b >= ((c != d) || e))'\'' -a 1,0,1,1,2
0
$ test-expr '\''a && (b >= ((c != d) || e))'\'' -a 1,0,1,2,1
0
$ test-expr '\''a && (b >= ((c != d) || e))'\'' -a 1,1,1,0,1
1
$ test-expr '\''a && (b >= ((c != d) || e))'\'' -a 1,1,1,1,1
1
$ test-expr '\''a && (b >= ((c != d) || e))'\'' -a 1,2,0,0,1
1
$ test-expr '\''a && (b >= ((c != d) || e))'\'' -a 1,2,1,1,0
1
$ test-expr '\''a && (b >= ((c != d) || e))'\'' -a 1,2,2,1,0
1
$ test-expr '\''a && (b >= ((c != d) || e))'\'' -a 1,2,2,2,0
1
$ test-expr '\''a && (b >= ((c != d) || e))'\'' -a 2,0,0,2,2
0
$ test-expr '\''a && (b >= ((c != d) || e))'\'' -a 2,0,2,1,1
0
$ test-expr '\''a && (b >= ((c != d) || e))'\'' -a 2,0,2,2,1
0
$ test-expr '\''a && (b >= ((c != d) || e))'\'' -a 2,0,2,2,2
0
$ test-expr '\''a && (b >= ((c != d) || e))'\'' -a 2,1,0,2,0
1
$ test-expr '\''a && (b >= ((c != d) || e))'\'' -a 2,1,2,2,0
1
$ test-expr '\''a && (b >= ((c != d) || e))'\'' -a 2,2,0,1,2
1
$ test-expr '\''a && (b >= ((c != d) || e))'\'' -a 2,2,0,2,2
1
$ test-expr '\''a && (b >= ((c != d) || e))'\'' -a 2,2,1,0,1
1
$ test-expr '\''a && (b >= ((c != d) || e))'\'' -a 2,2,1,0,2
1
$ test-expr '\''a && (b >= ((c || d) != e))'\'' -a 0,0,1,0,0
0
$ test-expr '\''a && (b >= ((c || d) != e))'\'' -a 0,0,2,1,0
0
$ test-expr '\''a && (b >= ((c || d) != e))'\'' -a 0,1,0,0,2
0
$ test-expr '\''a && (b >= ((c || d) != e))'\'' -a 0,1,2,0,1
0
$ test-expr '\''a && (b >= ((c || d) != e))'\'' -a 0,2,0,0,1
0
$ test-expr '\''a && (b >= ((c || d) != e))'\'' -a 0,2,1,0,1
0
$ test-expr '\''a && (b >= ((c || d) != e))'\'' -a 0,2,1,2,0
0
$ test-expr '\''a && (b >= ((c || d) != e))'\'' -a 0,2,2,2,2
0
$ test-expr '\''a && (b >= ((c || d) != e))'\'' -a 1,0,1,1,0
0
$ test-expr '\''a && (b >= ((c || d) != e))'\'' -a 1,1,2,2,2
1
$ test-expr '\''a && (b >= ((c || d) != e))'\'' -a 1,2,0,1,0
1
$ test-expr '\''a && (b >= ((c || d) != e))'\'' -a 1,2,1,0,0
1
$ test-expr '\''a && (b >= ((c || d) != e))'\'' -a 1,2,1,0,2
1
$ test-expr '\''a && (b >= ((c || d) != e))'\'' -a 2,0,0,1,0
0
$ test-expr '\''a && (b >= ((c || d) != e))'\'' -a 2,0,2,2,1
1
$ test-expr '\''a && (b >= ((c || d) != e))'\'' -a 2,1,0,0,2
1
$ test-expr '\''a && (b >= ((c || d) != e))'\'' -a 2,1,1,0,1
1
$ test-expr '\''a && (b >= ((c || d) != e))'\'' -a 2,1,2,1,2
1
$ test-expr '\''a && (b >= ((c || d) != e))'\'' -a 2,2,2,0,2
1
$ test-expr '\''a && (b || (c != (d >= e)))'\'' -a 0,0,0,1,1
0
$ test-expr '\''a && (b || (c != (d >= e)))'\'' -a 0,1,1,0,0
0
$ test-expr '\''a && (b || (c != (d >= e)))'\'' -a 0,1,2,2,2
0
$ test-expr '\''a && (b || (c != (d >= e)))'\'' -a 0,2,0,2,0
0
$ test-expr '\''a && (b || (c != (d >= e)))'\'' -a 0,2,0,2,1
0
$ test-expr '\''a && (b || (c != (d >= e)))'\'' -a 0,2,2,0,0
0
$ test-expr '\''a && (b || (c != (d >= e)))'\'' -a 0,2,2,1,2
0
$ test-expr '\''a && (b || (c != (d >= e)))'\'' -a 1,0,0,0,0
1
$ test-expr '\''a && (b || (c != (d >= e)))'\'' -a 1,0,0,1,1
1
$ test-expr '\''a && (b || (c != (d >= e)))'\'' -a 1,0,0,2,0
1
$ test-expr '\''a && (b || (c != (d >= e)))'\'' -a 1,0,1,1,1
0
$ test-expr '\''a && (b || (c != (d >= e)))'\'' -a 1,0,2,0,2
1
$ test-expr '\''a && (b || (c != (d >= e)))'\'' -a 1,1,0,0,2
1
$ test-expr '\''a && (b || (c != (d >= e)))'\'' -a 1,1,1,0,1
1
$ test-expr '\''a && (b || (c != (d >= e)))'\'' -a 1,1,1,1,2
1
$ test-expr '\''a && (b || (c != (d >= e)))'\'' -a 1,2,0,0,1
1
$ test-expr '\''a && (b || (c != (d >= e)))'\'' -a 1,2,1,1,0
1
$ test-expr '\''a && (b || (c != (d >= e)))'\'' -a 1,2,1,1,2
1
$ test-expr '\''a && (b || (c != (d >= e)))'\'' -a 2,0,0,0,1
0
$ test-expr '\''a && (b || (c != (d >= e)))'\'' -a 2,0,0,1,1
1
$ test-expr '\''a && (b || (c != (d >= e)))'\'' -a 2,0,1,1,1
0
$ test-expr '\''a && (b || (c != (d >= e)))'\'' -a 2,0,1,2,2
0
$ test-expr '\''a && (b || (c != (d >= e)))'\'' -a 2,0,2,0,0
1
$ test-expr '\''a && (b || (c != (d >= e)))'\'' -a 2,0,2,0,2
1
$ test-expr '\''a && (b || (c != (d >= e)))'\'' -a 2,1,1,0,2
1
$ test-expr '\''a && (b || (c != (d >= e)))'\'' -a 2,2,0,1,0
1
$ test-expr '\''a && (b || (c != (d >= e)))'\'' -a 2,2,0,2,2
1
$ test-expr '\''a && (b || (c != (d >= e)))'\'' -a 2,2,2,0,0
1
$ test-expr '\''a && (b || (c != (d >= e)))'\'' -a 2,2,2,0,1
1
$ test-expr '\''a && (b || (c >= (d != e)))'\'' -a 0,0,0,0,0
0
$ test-expr '\''a && (b || (c >= (d != e)))'\'' -a 0,0,2,1,2
0
$ test-expr '\''a && (b || (c >= (d != e)))'\'' -a 0,1,0,0,1
0
$ test-expr '\''a && (b || (c >= (d != e)))'\'' -a 0,1,0,2,2
0
$ test-expr '\''a && (b || (c >= (d != e)))'\'' -a 0,1,1,0,1
0
$ test-expr '\''a && (b || (c >= (d != e)))'\'' -a 0,1,1,0,2
0
$ test-expr '\''a && (b || (c >= (d != e)))'\'' -a 0,1,2,2,1
0
$ test-expr '\''a && (b || (c >= (d != e)))'\'' -a 0,2,0,0,0
0
$ test-expr '\''a && (b || (c >= (d != e)))'\'' -a 0,2,1,0,1
0
$ test-expr '\''a && (b || (c >= (d != e)))'\'' -a 0,2,1,1,0
0
$ test-expr '\''a && (b || (c >= (d != e)))'\'' -a 1,0,0,0,1
0
$ test-expr '\''a && (b || (c >= (d != e)))'\'' -a 1,0,0,2,1
0
$ test-expr '\''a && (b || (c >= (d != e)))'\'' -a 1,0,1,0,2
1
$ test-expr '\''a && (b || (c >= (d != e)))'\'' -a 1,0,1,1,2
1
$ test-expr '\''a && (b || (c >= (d != e)))'\'' -a 1,1,0,0,0
1
$ test-expr '\''a && (b || (c >= (d != e)))'\'' -a 1,1,0,1,2
1
$ test-expr '\''a && (b || (c >= (d != e)))'\'' -a 1,1,2,0,2
1
$ test-expr '\''a && (b || (c >= (d != e)))'\'' -a 1,1,2,1,0
1
$ test-expr '\''a && (b || (c >= (d != e)))'\'' -a 1,1,2,2,2
1
$ test-expr '\''a && (b || (c >= (d != e)))'\'' -a 1,2,2,1,1
1
$ test-expr '\''a && (b || (c >= (d != e)))'\'' -a 2,0,0,2,1
0
$ test-expr '\''a && (b || (c >= (d != e)))'\'' -a 2,0,2,1,2
1
$ test-expr '\''a && (b || (c >= (d != e)))'\'' -a 2,1,0,1,2
1
$ test-expr '\''a && (b || (c >= (d != e)))'\'' -a 2,1,2,0,1
1
$ test-expr '\''a && (b || (c >= (d != e)))'\'' -a 2,1,2,1,0
1
$ test-expr '\''a && (b || (c >= (d != e)))'\'' -a 2,2,0,0,1
1
$ test-expr '\''a && (b || (c >= (d != e)))'\'' -a 2,2,2,1,0
1
$ test-expr '\''a && (b || ((c != d) >= e))'\'' -a 0,0,0,0,1
0
$ test-expr '\''a && (b || ((c != d) >= e))'\'' -a 0,0,0,2,0
0
$ test-expr '\''a && (b || ((c != d) >= e))'\'' -a 0,0,1,1,2
0
$ test-expr '\''a && (b || ((c != d) >= e))'\'' -a 0,0,2,2,1
0
$ test-expr '\''a && (b || ((c != d) >= e))'\'' -a 0,1,1,0,0
0
$ test-expr '\''a && (b || ((c != d) >= e))'\'' -a 0,1,1,0,2
0
$ test-expr '\''a && (b || ((c != d) >= e))'\'' -a 0,1,2,0,2
0
$ test-expr '\''a && (b || ((c != d) >= e))'\'' -a 0,1,2,1,0
0
$ test-expr '\''a && (b || ((c != d) >= e))'\'' -a 0,2,0,2,0
0
$ test-expr '\''a && (b || ((c != d) >= e))'\'' -a 0,2,0,2,2
0
$ test-expr '\''a && (b || ((c != d) >= e))'\'' -a 0,2,1,0,2
0
$ test-expr '\''a && (b || ((c != d) >= e))'\'' -a 0,2,1,1,0
0
$ test-expr '\''a && (b || ((c != d) >= e))'\'' -a 1,0,2,0,1
1
$ test-expr '\''a && (b || ((c != d) >= e))'\'' -a 1,0,2,1,1
1
$ test-expr '\''a && (b || ((c != d) >= e))'\'' -a 1,1,0,1,1
1
$ test-expr '\''a && (b || ((c != d) >= e))'\'' -a 1,1,0,1,2
1
$ test-expr '\''a && (b || ((c != d) >= e))'\'' -a 1,1,0,2,1
1
$ test-expr '\''a && (b || ((c != d) >= e))'\'' -a 1,1,1,2,2
1
$ test-expr '\''a && (b || ((c != d) >= e))'\'' -a 1,2,1,2,0
1
$ test-expr '\''a && (b || ((c != d) >= e))'\'' -a 1,2,2,1,0
1
$ test-expr '\''a && (b || ((c != d) >= e))'\'' -a 1,2,2,1,1
1
$ test-expr '\''a && (b || ((c != d) >= e))'\'' -a 2,0,1,2,2
0
$ test-expr '\''a && (b || ((c != d) >= e))'\'' -a 2,1,2,0,2
1
$ test-expr '\''a && (b || ((c != d) >= e))'\'' -a 2,2,0,0,2
1
$ test-expr '\''a && (b || ((c != d) >= e))'\'' -a 2,2,0,2,0
1
$ test-expr '\''a && (b || ((c != d) >= e))'\'' -a 2,2,1,0,0
1
$ test-expr '\''a && (b || ((c != d) >= e))'\'' -a 2,2,1,2,0
1
$ test-expr '\''a && (b || ((c >= d) != e))'\'' -a 0,0,0,0,1
0
$ test-expr '\''a && (b || ((c >= d) != e))'\'' -a 0,0,1,1,0
0
$ test-expr '\''a && (b || ((c >= d) != e))'\'' -a 0,0,1,1,2
0
$ test-expr '\''a && (b || ((c >= d) != e))'\'' -a 0,1,0,0,2
0
$ test-expr '\''a && (b || ((c >= d) != e))'\'' -a 0,1,1,1,1
0
$ test-expr '\''a && (b || ((c >= d) != e))'\'' -a 0,1,1,2,1
0
$ test-expr '\''a && (b || ((c >= d) != e))'\'' -a 0,2,2,1,1
0
$ test-expr '\''a && (b || ((c >= d) != e))'\'' -a 1,0,0,0,2
1
$ test-expr '\''a && (b || ((c >= d) != e))'\'' -a 1,0,0,1,0
0
$ test-expr '\''a && (b || ((c >= d) != e))'\'' -a 1,0,0,1,1
1
$ test-expr '\''a && (b || ((c >= d) != e))'\'' -a 1,0,1,2,0
0
$ test-expr '\''a && (b || ((c >= d) != e))'\'' -a 1,0,1,2,2
1
$ test-expr '\''a && (b || ((c >= d) != e))'\'' -a 1,1,0,1,2
1
$ test-expr '\''a && (b || ((c >= d) != e))'\'' -a 1,1,1,2,2
1
$ test-expr '\''a && (b || ((c >= d) != e))'\'' -a 1,1,2,1,2
1
$ test-expr '\''a && (b || ((c >= d) != e))'\'' -a 1,1,2,2,2
1
$ test-expr '\''a && (b || ((c >= d) != e))'\'' -a 1,2,2,1,1
1
$ test-expr '\''a && (b || ((c >= d) != e))'\'' -a 2,0,0,2,2
1
$ test-expr '\''a && (b || ((c >= d) != e))'\'' -a 2,0,1,2,2
1
$ test-expr '\''a && (b || ((c >= d) != e))'\'' -a 2,0,2,2,2
1
$ test-expr '\''a && (b || ((c >= d) != e))'\'' -a 2,1,0,2,2
1
$ test-expr '\''a && (b || ((c >= d) != e))'\'' -a 2,1,1,0,0
1
$ test-expr '\''a && (b || ((c >= d) != e))'\'' -a 2,1,1,2,0
1
$ test-expr '\''a && (b || ((c >= d) != e))'\'' -a 2,2,0,1,2
1
$ test-expr '\''a && (b || ((c >= d) != e))'\'' -a 2,2,0,2,0
1
$ test-expr '\''a && ((b != c) >= (d || e))'\'' -a 0,0,0,0,0
0
$ test-expr '\''a && ((b != c) >= (d || e))'\'' -a 0,0,0,1,0
0
$ test-expr '\''a && ((b != c) >= (d || e))'\'' -a 0,0,1,1,1
0
$ test-expr '\''a && ((b != c) >= (d || e))'\'' -a 0,0,2,0,1
0
$ test-expr '\''a && ((b != c) >= (d || e))'\'' -a 0,1,1,0,0
0
$ test-expr '\''a && ((b != c) >= (d || e))'\'' -a 0,1,1,1,1
0
$ test-expr '\''a && ((b != c) >= (d || e))'\'' -a 0,1,1,2,0
0
$ test-expr '\''a && ((b != c) >= (d || e))'\'' -a 0,2,1,2,0
0
$ test-expr '\''a && ((b != c) >= (d || e))'\'' -a 0,2,2,0,0
0
$ test-expr '\''a && ((b != c) >= (d || e))'\'' -a 0,2,2,2,1
0
$ test-expr '\''a && ((b != c) >= (d || e))'\'' -a 0,2,2,2,2
0
$ test-expr '\''a && ((b != c) >= (d || e))'\'' -a 1,0,0,2,1
0
$ test-expr '\''a && ((b != c) >= (d || e))'\'' -a 1,0,1,1,1
1
$ test-expr '\''a && ((b != c) >= (d || e))'\'' -a 1,1,0,0,0
1
$ test-expr '\''a && ((b != c) >= (d || e))'\'' -a 1,1,0,1,2
1
$ test-expr '\''a && ((b != c) >= (d || e))'\'' -a 1,1,2,0,1
1
$ test-expr '\''a && ((b != c) >= (d || e))'\'' -a 1,1,2,1,1
1
$ test-expr '\''a && ((b != c) >= (d || e))'\'' -a 1,2,0,0,1
1
$ test-expr '\''a && ((b != c) >= (d || e))'\'' -a 1,2,0,1,2
1
$ test-expr '\''a && ((b != c) >= (d || e))'\'' -a 1,2,1,1,2
1
$ test-expr '\''a && ((b != c) >= (d || e))'\'' -a 1,2,2,1,1
0
$ test-expr '\''a && ((b != c) >= (d || e))'\'' -a 2,0,0,2,1
0
$ test-expr '\''a && ((b != c) >= (d || e))'\'' -a 2,0,2,0,2
1
$ test-expr '\''a && ((b != c) >= (d || e))'\'' -a 2,1,0,2,0
1
$ test-expr '\''a && ((b != c) >= (d || e))'\'' -a 2,1,2,2,2
1
$ test-expr '\''a && ((b != c) >= (d || e))'\'' -a 2,2,1,1,0
1
$ test-expr '\''a && ((b != c) >= (d || e))'\'' -a 2,2,2,1,1
0
$ test-expr '\''a && ((b != c) >= (d || e))'\'' -a 2,2,2,2,0
0
$ test-expr '\''a && ((b != c) || (d >= e))'\'' -a 0,0,0,0,1
0
$ test-expr '\''a && ((b != c) || (d >= e))'\'' -a 0,0,0,2,0
0
$ test-expr '\''a && ((b != c) || (d >= e))'\'' -a 0,2,0,0,0
0
$ test-expr '\''a && ((b != c) || (d >= e))'\'' -a 0,2,1,0,0
0
$ test-expr '\''a && ((b != c) || (d >= e))'\'' -a 0,2,1,2,0
0
$ test-expr '\''a && ((b != c) || (d >= e))'\'' -a 1,0,0,2,2
1
$ test-expr '\''a && ((b != c) || (d >= e))'\'' -a 1,0,1,0,0
1
$ test-expr '\''a && ((b != c) || (d >= e))'\'' -a 1,0,2,1,2
1
$ test-expr '\''a && ((b != c) || (d >= e))'\'' -a 1,0,2,2,0
1
$ test-expr '\''a && ((b != c) || (d >= e))'\'' -a 1,1,2,1,0
1
$ test-expr '\''a && ((b != c) || (d >= e))'\'' -a 1,1,2,2,2
1
$ test-expr '\''a && ((b != c) || (d >= e))'\'' -a 1,2,1,0,0
1
$ test-expr '\''a && ((b != c) || (d >= e))'\'' -a 2,0,0,1,0
1
$ test-expr '\''a && ((b != c) || (d >= e))'\'' -a 2,0,0,2,0
1
$ test-expr '\''a && ((b != c) || (d >= e))'\'' -a 2,0,2,0,0
1
$ test-expr '\''a && ((b != c) || (d >= e))'\'' -a 2,0,2,0,1
1
$ test-expr '\''a && ((b != c) || (d >= e))'\'' -a 2,1,0,0,1
1
$ test-expr '\''a && ((b != c) || (d >= e))'\'' -a 2,1,0,1,1
1
$ test-expr '\''a && ((b != c) || (d >= e))'\'' -a 2,1,0,2,0
1
$ test-expr '\''a && ((b != c) || (d >= e))'\'' -a 2,1,1,0,2
0
$ test-expr '\''a && ((b != c) || (d >= e))'\'' -a 2,1,2,0,1
1
$ test-expr '\''a && ((b != c) || (d >= e))'\'' -a 2,2,1,0,1
1
$ test-expr '\''a && ((b != c) || (d >= e))'\'' -a 2,2,2,1,2
0
$ test-expr '\''a && ((b != c) || (d >= e))'\'' -a 2,2,2,2,1
1
$ test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 0,0,0,2,0
0
$ test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 0,0,1,2,0
0
$ test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 0,1,0,0,0
0
$ test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 0,1,0,1,0
0
$ test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 0,1,0,1,2
0
$ test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 0,1,1,1,2
0
$ test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 0,1,1,2,0
0
$ test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 0,1,2,1,0
0
$ test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 0,1,2,2,1
0
$ test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 1,0,0,2,1
1
$ test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 1,0,1,2,0
0
$ test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 1,0,2,2,0
1
$ test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 1,1,0,2,2
1
$ test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 1,1,1,2,1
1
$ test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 1,1,2,0,2
1
$ test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 1,1,2,2,0
0
$ test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 1,2,0,0,1
1
$ test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 1,2,1,0,2
1
$ test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 1,2,1,1,2
1
$ test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 1,2,2,1,1
1
$ test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 2,0,0,0,1
1
$ test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 2,0,0,2,0
0
$ test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 2,0,1,0,0
1
$ test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 2,0,2,1,0
1
$ test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 2,1,0,1,2
1
$ test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 2,1,1,0,1
1
$ test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 2,1,1,0,2
1
$ test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 2,1,1,2,0
1
$ test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 2,1,1,2,1
1
$ test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 2,2,2,1,1
1
$ test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 2,2,2,2,1
1
$ test-expr '\''a && ((b != (c || d)) >= e)'\'' -a 0,1,0,2,0
0
$ test-expr '\''a && ((b != (c || d)) >= e)'\'' -a 0,2,1,1,1
0
$ test-expr '\''a && ((b != (c || d)) >= e)'\'' -a 0,2,2,1,2
0
$ test-expr '\''a && ((b != (c || d)) >= e)'\'' -a 1,0,0,0,0
1
$ test-expr '\''a && ((b != (c || d)) >= e)'\'' -a 1,0,1,0,0
1
$ test-expr '\''a && ((b != (c || d)) >= e)'\'' -a 1,1,2,1,0
1
$ test-expr '\''a && ((b != (c || d)) >= e)'\'' -a 1,1,2,1,2
0
$ test-expr '\''a && ((b != (c || d)) >= e)'\'' -a 1,2,0,0,2
0
$ test-expr '\''a && ((b != (c || d)) >= e)'\'' -a 1,2,1,0,2
0
$ test-expr '\''a && ((b != (c || d)) >= e)'\'' -a 1,2,1,1,1
1
$ test-expr '\''a && ((b != (c || d)) >= e)'\'' -a 1,2,2,0,0
1
$ test-expr '\''a && ((b != (c || d)) >= e)'\'' -a 2,0,0,0,2
0
$ test-expr '\''a && ((b != (c || d)) >= e)'\'' -a 2,0,2,0,2
0
$ test-expr '\''a && ((b != (c || d)) >= e)'\'' -a 2,1,1,0,2
0
$ test-expr '\''a && ((b != (c || d)) >= e)'\'' -a 2,1,1,1,1
0
$ test-expr '\''a && ((b != (c || d)) >= e)'\'' -a 2,1,2,1,2
0
$ test-expr '\''a && ((b != (c || d)) >= e)'\'' -a 2,2,0,1,2
0
$ test-expr '\''a && ((b != (c || d)) >= e)'\'' -a 2,2,0,2,0
1
$ test-expr '\''a && ((b != (c || d)) >= e)'\'' -a 2,2,2,2,0
1
$ test-expr '\''a && ((b != (c || d)) >= e)'\'' -a 2,2,2,2,2
0
$ test-expr '\''a && ((b >= c) != (d || e))'\'' -a 0,0,0,0,2
0
$ test-expr '\''a && ((b >= c) != (d || e))'\'' -a 0,1,1,2,0
0
$ test-expr '\''a && ((b >= c) != (d || e))'\'' -a 0,1,2,1,0
0
$ test-expr '\''a && ((b >= c) != (d || e))'\'' -a 0,1,2,1,1
0
$ test-expr '\''a && ((b >= c) != (d || e))'\'' -a 0,1,2,2,0
0
$ test-expr '\''a && ((b >= c) != (d || e))'\'' -a 0,2,0,0,0
0
$ test-expr '\''a && ((b >= c) != (d || e))'\'' -a 0,2,1,0,1
0
$ test-expr '\''a && ((b >= c) != (d || e))'\'' -a 0,2,1,2,1
0
$ test-expr '\''a && ((b >= c) != (d || e))'\'' -a 0,2,2,0,0
0
$ test-expr '\''a && ((b >= c) != (d || e))'\'' -a 1,0,0,1,1
0
$ test-expr '\''a && ((b >= c) != (d || e))'\'' -a 1,0,0,2,1
0
$ test-expr '\''a && ((b >= c) != (d || e))'\'' -a 1,0,1,1,2
1
$ test-expr '\''a && ((b >= c) != (d || e))'\'' -a 1,1,0,0,0
1
$ test-expr '\''a && ((b >= c) != (d || e))'\'' -a 1,1,1,1,2
0
$ test-expr '\''a && ((b >= c) != (d || e))'\'' -a 1,2,0,1,1
0
$ test-expr '\''a && ((b >= c) != (d || e))'\'' -a 1,2,1,1,2
0
$ test-expr '\''a && ((b >= c) != (d || e))'\'' -a 1,2,1,2,0
0
$ test-expr '\''a && ((b >= c) != (d || e))'\'' -a 1,2,2,1,0
0
$ test-expr '\''a && ((b >= c) != (d || e))'\'' -a 1,2,2,2,2
0
$ test-expr '\''a && ((b >= c) != (d || e))'\'' -a 2,0,0,0,2
0
$ test-expr '\''a && ((b >= c) != (d || e))'\'' -a 2,0,0,1,0
0
$ test-expr '\''a && ((b >= c) != (d || e))'\'' -a 2,0,2,2,2
1
$ test-expr '\''a && ((b >= c) != (d || e))'\'' -a 2,1,1,0,1
0
$ test-expr '\''a && ((b >= c) != (d || e))'\'' -a 2,1,2,1,2
1
$ test-expr '\''a && ((b >= c) != (d || e))'\'' -a 2,2,0,2,0
0
$ test-expr '\''a && ((b >= c) != (d || e))'\'' -a 2,2,1,2,2
0
$ test-expr '\''a && ((b >= c) || (d != e))'\'' -a 0,0,0,0,2
0
$ test-expr '\''a && ((b >= c) || (d != e))'\'' -a 0,0,0,1,2
0
$ test-expr '\''a && ((b >= c) || (d != e))'\'' -a 0,0,2,1,1
0
$ test-expr '\''a && ((b >= c) || (d != e))'\'' -a 0,0,2,1,2
0
$ test-expr '\''a && ((b >= c) || (d != e))'\'' -a 0,0,2,2,0
0
$ test-expr '\''a && ((b >= c) || (d != e))'\'' -a 0,1,0,1,0
0
$ test-expr '\''a && ((b >= c) || (d != e))'\'' -a 0,1,1,0,2
0
$ test-expr '\''a && ((b >= c) || (d != e))'\'' -a 0,1,1,2,1
0
$ test-expr '\''a && ((b >= c) || (d != e))'\'' -a 0,1,1,2,2
0
$ test-expr '\''a && ((b >= c) || (d != e))'\'' -a 0,1,2,1,2
0
$ test-expr '\''a && ((b >= c) || (d != e))'\'' -a 0,2,0,0,2
0
$ test-expr '\''a && ((b >= c) || (d != e))'\'' -a 0,2,1,2,0
0
$ test-expr '\''a && ((b >= c) || (d != e))'\'' -a 0,2,2,1,1
0
$ test-expr '\''a && ((b >= c) || (d != e))'\'' -a 1,0,1,0,2
1
$ test-expr '\''a && ((b >= c) || (d != e))'\'' -a 1,0,1,1,2
1
$ test-expr '\''a && ((b >= c) || (d != e))'\'' -a 1,0,2,0,2
1
$ test-expr '\''a && ((b >= c) || (d != e))'\'' -a 1,0,2,2,1
1
$ test-expr '\''a && ((b >= c) || (d != e))'\'' -a 1,1,1,2,2
1
$ test-expr '\''a && ((b >= c) || (d != e))'\'' -a 1,2,0,0,0
1
$ test-expr '\''a && ((b >= c) || (d != e))'\'' -a 1,2,0,1,1
1
$ test-expr '\''a && ((b >= c) || (d != e))'\'' -a 2,0,0,1,1
1
$ test-expr '\''a && ((b >= c) || (d != e))'\'' -a 2,0,1,1,1
0
$ test-expr '\''a && ((b >= c) || (d != e))'\'' -a 2,1,0,0,2
1
$ test-expr '\''a && ((b >= c) || (d != e))'\'' -a 2,1,0,1,1
1
$ test-expr '\''a && ((b >= c) || (d != e))'\'' -a 2,1,0,2,0
1
$ test-expr '\''a && ((b >= c) || (d != e))'\'' -a 2,1,1,2,2
1
$ test-expr '\''a && ((b >= c) || (d != e))'\'' -a 2,2,1,2,2
1
$ test-expr '\''a && ((b >= c) || (d != e))'\'' -a 2,2,2,0,1
1
$ test-expr '\''a && ((b >= c) || (d != e))'\'' -a 2,2,2,2,0
1
$ test-expr '\''a && ((b >= c) || (d != e))'\'' -a 2,2,2,2,2
1
$ test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 0,0,0,0,2
0
$ test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 0,0,0,1,2
0
$ test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 0,0,1,0,1
0
$ test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 0,0,1,2,0
0
$ test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 0,0,1,2,1
0
$ test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 0,0,2,1,0
0
$ test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 0,1,1,0,2
0
$ test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 0,1,2,2,2
0
$ test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 0,2,0,1,0
0
$ test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 0,2,0,1,2
0
$ test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 0,2,2,1,2
0
$ test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 1,0,1,0,2
1
$ test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 1,0,1,1,0
1
$ test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 1,0,2,0,2
1
$ test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 1,0,2,2,0
1
$ test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 1,1,0,1,1
1
$ test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 1,1,0,2,1
1
$ test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 1,1,1,1,0
1
$ test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 1,1,2,0,2
1
$ test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 1,1,2,1,0
1
$ test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 1,2,1,1,0
1
$ test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 1,2,2,0,1
1
$ test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 1,2,2,2,0
1
$ test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 2,0,0,0,1
1
$ test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 2,2,1,1,2
1
$ test-expr '\''a && ((b >= (c || d)) != e)'\'' -a 0,0,0,2,0
0
$ test-expr '\''a && ((b >= (c || d)) != e)'\'' -a 0,0,1,2,1
0
$ test-expr '\''a && ((b >= (c || d)) != e)'\'' -a 0,1,0,1,2
0
$ test-expr '\''a && ((b >= (c || d)) != e)'\'' -a 0,1,2,0,1
0
$ test-expr '\''a && ((b >= (c || d)) != e)'\'' -a 0,1,2,0,2
0
$ test-expr '\''a && ((b >= (c || d)) != e)'\'' -a 1,0,0,1,1
1
$ test-expr '\''a && ((b >= (c || d)) != e)'\'' -a 1,0,0,2,1
1
$ test-expr '\''a && ((b >= (c || d)) != e)'\'' -a 1,0,1,0,2
1
$ test-expr '\''a && ((b >= (c || d)) != e)'\'' -a 1,0,2,2,0
0
$ test-expr '\''a && ((b >= (c || d)) != e)'\'' -a 1,1,0,1,0
1
$ test-expr '\''a && ((b >= (c || d)) != e)'\'' -a 1,1,0,2,0
1
$ test-expr '\''a && ((b >= (c || d)) != e)'\'' -a 1,1,1,1,2
1
$ test-expr '\''a && ((b >= (c || d)) != e)'\'' -a 1,2,0,1,2
1
$ test-expr '\''a && ((b >= (c || d)) != e)'\'' -a 2,0,1,0,0
0
$ test-expr '\''a && ((b >= (c || d)) != e)'\'' -a 2,0,1,1,1
1
$ test-expr '\''a && ((b >= (c || d)) != e)'\'' -a 2,0,1,1,2
1
$ test-expr '\''a && ((b >= (c || d)) != e)'\'' -a 2,0,1,2,1
1
$ test-expr '\''a && ((b >= (c || d)) != e)'\'' -a 2,0,2,1,1
1
$ test-expr '\''a && ((b >= (c || d)) != e)'\'' -a 2,1,0,1,0
1
$ test-expr '\''a && ((b >= (c || d)) != e)'\'' -a 2,1,0,2,2
1
$ test-expr '\''a && ((b >= (c || d)) != e)'\'' -a 2,2,0,1,1
0
$ test-expr '\''a && ((b || c) != (d >= e))'\'' -a 0,0,0,1,0
0
$ test-expr '\''a && ((b || c) != (d >= e))'\'' -a 0,0,2,0,0
0
$ test-expr '\''a && ((b || c) != (d >= e))'\'' -a 0,0,2,0,1
0
$ test-expr '\''a && ((b || c) != (d >= e))'\'' -a 0,0,2,2,1
0
$ test-expr '\''a && ((b || c) != (d >= e))'\'' -a 0,1,0,0,2
0
$ test-expr '\''a && ((b || c) != (d >= e))'\'' -a 0,1,2,0,1
0
$ test-expr '\''a && ((b || c) != (d >= e))'\'' -a 0,1,2,1,1
0
$ test-expr '\''a && ((b || c) != (d >= e))'\'' -a 0,1,2,1,2
0
$ test-expr '\''a && ((b || c) != (d >= e))'\'' -a 0,2,0,1,1
0
$ test-expr '\''a && ((b || c) != (d >= e))'\'' -a 0,2,1,1,1
0
$ test-expr '\''a && ((b || c) != (d >= e))'\'' -a 0,2,1,1,2
0
$ test-expr '\''a && ((b || c) != (d >= e))'\'' -a 1,0,0,1,0
1
$ test-expr '\''a && ((b || c) != (d >= e))'\'' -a 1,0,1,0,1
1
$ test-expr '\''a && ((b || c) != (d >= e))'\'' -a 1,0,1,0,2
1
$ test-expr '\''a && ((b || c) != (d >= e))'\'' -a 1,0,2,0,1
1
$ test-expr '\''a && ((b || c) != (d >= e))'\'' -a 1,0,2,1,1
0
$ test-expr '\''a && ((b || c) != (d >= e))'\'' -a 1,0,2,1,2
1
$ test-expr '\''a && ((b || c) != (d >= e))'\'' -a 1,0,2,2,2
0
$ test-expr '\''a && ((b || c) != (d >= e))'\'' -a 1,1,0,0,2
1
$ test-expr '\''a && ((b || c) != (d >= e))'\'' -a 1,1,0,2,0
0
$ test-expr '\''a && ((b || c) != (d >= e))'\'' -a 1,1,1,0,1
1
$ test-expr '\''a && ((b || c) != (d >= e))'\'' -a 1,1,1,0,2
1
$ test-expr '\''a && ((b || c) != (d >= e))'\'' -a 1,1,1,1,1
0
$ test-expr '\''a && ((b || c) != (d >= e))'\'' -a 1,1,2,2,0
0
$ test-expr '\''a && ((b || c) != (d >= e))'\'' -a 1,2,0,2,1
0
$ test-expr '\''a && ((b || c) != (d >= e))'\'' -a 1,2,1,1,2
1
$ test-expr '\''a && ((b || c) != (d >= e))'\'' -a 1,2,2,2,0
0
$ test-expr '\''a && ((b || c) != (d >= e))'\'' -a 2,0,0,2,1
1
$ test-expr '\''a && ((b || c) != (d >= e))'\'' -a 2,0,1,1,2
1
$ test-expr '\''a && ((b || c) != (d >= e))'\'' -a 2,1,1,0,0
0
$ test-expr '\''a && ((b || c) != (d >= e))'\'' -a 2,1,1,0,1
1
$ test-expr '\''a && ((b || c) != (d >= e))'\'' -a 2,1,1,1,2
1
$ test-expr '\''a && ((b || c) != (d >= e))'\'' -a 2,2,0,2,1
0
$ test-expr '\''a && ((b || c) >= (d != e))'\'' -a 0,0,0,0,1
0
$ test-expr '\''a && ((b || c) >= (d != e))'\'' -a 0,0,0,2,2
0
$ test-expr '\''a && ((b || c) >= (d != e))'\'' -a 0,0,1,2,0
0
$ test-expr '\''a && ((b || c) >= (d != e))'\'' -a 0,0,2,1,1
0
$ test-expr '\''a && ((b || c) >= (d != e))'\'' -a 0,1,0,2,0
0
$ test-expr '\''a && ((b || c) >= (d != e))'\'' -a 0,1,1,1,0
0
$ test-expr '\''a && ((b || c) >= (d != e))'\'' -a 0,2,2,2,2
0
$ test-expr '\''a && ((b || c) >= (d != e))'\'' -a 1,0,0,0,0
1
$ test-expr '\''a && ((b || c) >= (d != e))'\'' -a 1,0,1,0,0
1
$ test-expr '\''a && ((b || c) >= (d != e))'\'' -a 1,0,1,0,2
1
$ test-expr '\''a && ((b || c) >= (d != e))'\'' -a 1,0,1,1,1
1
$ test-expr '\''a && ((b || c) >= (d != e))'\'' -a 1,0,1,2,2
1
$ test-expr '\''a && ((b || c) >= (d != e))'\'' -a 1,0,2,2,0
1
$ test-expr '\''a && ((b || c) >= (d != e))'\'' -a 1,1,0,2,0
1
$ test-expr '\''a && ((b || c) >= (d != e))'\'' -a 1,1,1,0,2
1
$ test-expr '\''a && ((b || c) >= (d != e))'\'' -a 1,1,1,2,0
1
$ test-expr '\''a && ((b || c) >= (d != e))'\'' -a 1,1,2,1,2
1
$ test-expr '\''a && ((b || c) >= (d != e))'\'' -a 1,2,0,1,1
1
$ test-expr '\''a && ((b || c) >= (d != e))'\'' -a 1,2,2,0,2
1
$ test-expr '\''a && ((b || c) >= (d != e))'\'' -a 2,0,0,0,2
0
$ test-expr '\''a && ((b || c) >= (d != e))'\'' -a 2,0,0,1,2
0
$ test-expr '\''a && ((b || c) >= (d != e))'\'' -a 2,0,2,1,2
1
$ test-expr '\''a && ((b || c) >= (d != e))'\'' -a 2,0,2,2,2
1
$ test-expr '\''a && ((b || c) >= (d != e))'\'' -a 2,1,0,0,0
1
$ test-expr '\''a && ((b || c) >= (d != e))'\'' -a 2,1,0,1,0
1
$ test-expr '\''a && ((b || c) >= (d != e))'\'' -a 2,1,1,1,0
1
$ test-expr '\''a && ((b || c) >= (d != e))'\'' -a 2,1,2,0,0
1
$ test-expr '\''a && ((b || c) >= (d != e))'\'' -a 2,1,2,1,0
1
$ test-expr '\''a && ((b || c) >= (d != e))'\'' -a 2,2,0,0,1
1
$ test-expr '\''a && ((b || c) >= (d != e))'\'' -a 2,2,2,1,0
1
$ test-expr '\''a && ((b || c) >= (d != e))'\'' -a 2,2,2,2,1
1
$ test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 0,0,0,0,1
0
$ test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 0,0,2,0,0
0
$ test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 0,0,2,1,2
0
$ test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 0,2,0,1,2
0
$ test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 0,2,1,1,1
0
$ test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 0,2,2,1,0
0
$ test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 1,0,1,2,0
1
$ test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 1,0,2,2,0
1
$ test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 1,1,1,0,1
1
$ test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 1,1,2,1,0
1
$ test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 1,1,2,1,1
1
$ test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 1,1,2,2,2
0
$ test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 1,2,0,2,0
1
$ test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 1,2,2,0,1
1
$ test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 1,2,2,0,2
0
$ test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 2,0,0,1,0
1
$ test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 2,0,0,2,0
1
$ test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 2,0,0,2,1
1
$ test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 2,0,1,2,0
1
$ test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 2,0,2,1,1
1
$ test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 2,1,0,0,1
1
$ test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 2,1,1,2,0
1
$ test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 2,1,2,1,0
1
$ test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 2,2,0,1,1
1
$ test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 2,2,1,0,1
1
$ test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 2,2,1,2,1
1
$ test-expr '\''a && ((b || (c >= d)) != e)'\'' -a 0,0,1,1,2
0
$ test-expr '\''a && ((b || (c >= d)) != e)'\'' -a 0,0,1,2,2
0
$ test-expr '\''a && ((b || (c >= d)) != e)'\'' -a 0,0,2,1,2
0
$ test-expr '\''a && ((b || (c >= d)) != e)'\'' -a 0,1,0,1,1
0
$ test-expr '\''a && ((b || (c >= d)) != e)'\'' -a 0,1,0,2,0
0
$ test-expr '\''a && ((b || (c >= d)) != e)'\'' -a 0,1,1,0,2
0
$ test-expr '\''a && ((b || (c >= d)) != e)'\'' -a 0,1,1,2,2
0
$ test-expr '\''a && ((b || (c >= d)) != e)'\'' -a 0,1,2,0,0
0
$ test-expr '\''a && ((b || (c >= d)) != e)'\'' -a 0,2,0,1,2
0
$ test-expr '\''a && ((b || (c >= d)) != e)'\'' -a 0,2,2,0,1
0
$ test-expr '\''a && ((b || (c >= d)) != e)'\'' -a 0,2,2,2,0
0
$ test-expr '\''a && ((b || (c >= d)) != e)'\'' -a 1,0,0,0,0
1
$ test-expr '\''a && ((b || (c >= d)) != e)'\'' -a 1,0,0,2,2
1
$ test-expr '\''a && ((b || (c >= d)) != e)'\'' -a 1,1,0,1,1
0
$ test-expr '\''a && ((b || (c >= d)) != e)'\'' -a 1,1,1,2,0
1
$ test-expr '\''a && ((b || (c >= d)) != e)'\'' -a 1,2,0,0,0
1
$ test-expr '\''a && ((b || (c >= d)) != e)'\'' -a 1,2,1,1,2
1
$ test-expr '\''a && ((b || (c >= d)) != e)'\'' -a 1,2,2,1,0
1
$ test-expr '\''a && ((b || (c >= d)) != e)'\'' -a 2,0,0,1,2
1
$ test-expr '\''a && ((b || (c >= d)) != e)'\'' -a 2,1,1,1,0
1
$ test-expr '\''a && ((b || (c >= d)) != e)'\'' -a 2,1,2,1,2
1
$ test-expr '\''a && ((b || (c >= d)) != e)'\'' -a 2,1,2,2,1
0
$ test-expr '\''a && ((b || (c >= d)) != e)'\'' -a 2,2,0,1,2
1
$ test-expr '\''a && (((b != c) >= d) || e)'\'' -a 0,0,0,2,2
0
$ test-expr '\''a && (((b != c) >= d) || e)'\'' -a 0,0,1,1,1
0
$ test-expr '\''a && (((b != c) >= d) || e)'\'' -a 0,0,2,1,0
0
$ test-expr '\''a && (((b != c) >= d) || e)'\'' -a 0,1,0,0,2
0
$ test-expr '\''a && (((b != c) >= d) || e)'\'' -a 0,1,1,1,2
0
$ test-expr '\''a && (((b != c) >= d) || e)'\'' -a 0,1,1,2,0
0
$ test-expr '\''a && (((b != c) >= d) || e)'\'' -a 0,2,0,2,2
0
$ test-expr '\''a && (((b != c) >= d) || e)'\'' -a 0,2,1,1,0
0
$ test-expr '\''a && (((b != c) >= d) || e)'\'' -a 0,2,1,2,2
0
$ test-expr '\''a && (((b != c) >= d) || e)'\'' -a 1,0,2,2,0
0
$ test-expr '\''a && (((b != c) >= d) || e)'\'' -a 1,0,2,2,2
1
$ test-expr '\''a && (((b != c) >= d) || e)'\'' -a 1,1,2,1,2
1
$ test-expr '\''a && (((b != c) >= d) || e)'\'' -a 1,2,0,2,2
1
$ test-expr '\''a && (((b != c) >= d) || e)'\'' -a 1,2,1,1,0
1
$ test-expr '\''a && (((b != c) >= d) || e)'\'' -a 1,2,1,1,2
1
$ test-expr '\''a && (((b != c) >= d) || e)'\'' -a 1,2,1,2,2
1
$ test-expr '\''a && (((b != c) >= d) || e)'\'' -a 1,2,2,0,0
1
$ test-expr '\''a && (((b != c) >= d) || e)'\'' -a 2,0,0,0,1
1
$ test-expr '\''a && (((b != c) >= d) || e)'\'' -a 2,0,0,1,0
0
$ test-expr '\''a && (((b != c) >= d) || e)'\'' -a 2,0,0,1,2
1
$ test-expr '\''a && (((b != c) >= d) || e)'\'' -a 2,0,0,2,0
0
$ test-expr '\''a && (((b != c) >= d) || e)'\'' -a 2,0,0,2,2
1
$ test-expr '\''a && (((b != c) >= d) || e)'\'' -a 2,0,1,0,2
1
$ test-expr '\''a && (((b != c) >= d) || e)'\'' -a 2,0,1,1,2
1
$ test-expr '\''a && (((b != c) >= d) || e)'\'' -a 2,0,2,2,2
1
$ test-expr '\''a && (((b != c) >= d) || e)'\'' -a 2,1,0,1,0
1
$ test-expr '\''a && (((b != c) >= d) || e)'\'' -a 2,1,2,0,1
1
$ test-expr '\''a && (((b != c) >= d) || e)'\'' -a 2,2,0,0,1
1
$ test-expr '\''a && (((b != c) >= d) || e)'\'' -a 2,2,0,2,2
1
$ test-expr '\''a && (((b != c) >= d) || e)'\'' -a 2,2,1,0,2
1
$ test-expr '\''a && (((b != c) >= d) || e)'\'' -a 2,2,1,2,0
0
$ test-expr '\''a && (((b != c) >= d) || e)'\'' -a 2,2,2,1,0
0
$ test-expr '\''a && (((b != c) || d) >= e)'\'' -a 0,0,0,2,0
0
$ test-expr '\''a && (((b != c) || d) >= e)'\'' -a 0,0,1,1,1
0
$ test-expr '\''a && (((b != c) || d) >= e)'\'' -a 0,0,1,1,2
0
$ test-expr '\''a && (((b != c) || d) >= e)'\'' -a 0,0,2,2,2
0
$ test-expr '\''a && (((b != c) || d) >= e)'\'' -a 0,1,0,0,0
0
$ test-expr '\''a && (((b != c) || d) >= e)'\'' -a 0,1,0,1,2
0
$ test-expr '\''a && (((b != c) || d) >= e)'\'' -a 0,1,1,2,0
0
$ test-expr '\''a && (((b != c) || d) >= e)'\'' -a 0,1,1,2,1
0
$ test-expr '\''a && (((b != c) || d) >= e)'\'' -a 0,2,0,1,1
0
$ test-expr '\''a && (((b != c) || d) >= e)'\'' -a 0,2,0,2,2
0
$ test-expr '\''a && (((b != c) || d) >= e)'\'' -a 0,2,1,2,1
0
$ test-expr '\''a && (((b != c) || d) >= e)'\'' -a 1,0,2,0,1
1
$ test-expr '\''a && (((b != c) || d) >= e)'\'' -a 1,0,2,1,1
1
$ test-expr '\''a && (((b != c) || d) >= e)'\'' -a 1,0,2,1,2
0
$ test-expr '\''a && (((b != c) || d) >= e)'\'' -a 1,1,0,2,1
1
$ test-expr '\''a && (((b != c) || d) >= e)'\'' -a 1,1,1,0,1
0
$ test-expr '\''a && (((b != c) || d) >= e)'\'' -a 1,1,1,2,0
1
$ test-expr '\''a && (((b != c) || d) >= e)'\'' -a 1,1,2,0,0
1
$ test-expr '\''a && (((b != c) || d) >= e)'\'' -a 1,1,2,1,1
1
$ test-expr '\''a && (((b != c) || d) >= e)'\'' -a 1,2,0,1,2
0
$ test-expr '\''a && (((b != c) || d) >= e)'\'' -a 1,2,0,2,1
1
$ test-expr '\''a && (((b != c) || d) >= e)'\'' -a 1,2,0,2,2
0
$ test-expr '\''a && (((b != c) || d) >= e)'\'' -a 2,0,0,1,0
1
$ test-expr '\''a && (((b != c) || d) >= e)'\'' -a 2,1,0,0,2
0
$ test-expr '\''a && (((b != c) || d) >= e)'\'' -a 2,1,0,2,2
0
$ test-expr '\''a && (((b != c) || d) >= e)'\'' -a 2,1,1,2,0
1
$ test-expr '\''a && (((b != c) || d) >= e)'\'' -a 2,2,0,2,2
0
$ test-expr '\''a && (((b != c) || d) >= e)'\'' -a 2,2,1,1,1
1
$ test-expr '\''a && (((b != c) || d) >= e)'\'' -a 2,2,1,2,1
1
$ test-expr '\''a && (((b != c) || d) >= e)'\'' -a 2,2,2,0,2
0
$ test-expr '\''a && (((b >= c) != d) || e)'\'' -a 0,0,0,0,0
0
$ test-expr '\''a && (((b >= c) != d) || e)'\'' -a 0,1,1,2,1
0
$ test-expr '\''a && (((b >= c) != d) || e)'\'' -a 0,1,2,2,0
0
$ test-expr '\''a && (((b >= c) != d) || e)'\'' -a 0,2,0,0,1
0
$ test-expr '\''a && (((b >= c) != d) || e)'\'' -a 0,2,2,0,0
0
$ test-expr '\''a && (((b >= c) != d) || e)'\'' -a 0,2,2,0,1
0
$ test-expr '\''a && (((b >= c) != d) || e)'\'' -a 0,2,2,0,2
0
$ test-expr '\''a && (((b >= c) != d) || e)'\'' -a 1,0,1,0,1
1
$ test-expr '\''a && (((b >= c) != d) || e)'\'' -a 1,0,2,1,0
1
$ test-expr '\''a && (((b >= c) != d) || e)'\'' -a 1,0,2,2,1
1
$ test-expr '\''a && (((b >= c) != d) || e)'\'' -a 1,1,2,1,2
1
$ test-expr '\''a && (((b >= c) != d) || e)'\'' -a 1,2,0,2,2
1
$ test-expr '\''a && (((b >= c) != d) || e)'\'' -a 1,2,2,1,2
1
$ test-expr '\''a && (((b >= c) != d) || e)'\'' -a 1,2,2,2,2
1
$ test-expr '\''a && (((b >= c) != d) || e)'\'' -a 2,0,0,0,0
1
$ test-expr '\''a && (((b >= c) != d) || e)'\'' -a 2,0,0,0,1
1
$ test-expr '\''a && (((b >= c) != d) || e)'\'' -a 2,0,0,0,2
1
$ test-expr '\''a && (((b >= c) != d) || e)'\'' -a 2,0,0,2,2
1
$ test-expr '\''a && (((b >= c) != d) || e)'\'' -a 2,0,2,1,0
1
$ test-expr '\''a && (((b >= c) != d) || e)'\'' -a 2,0,2,2,2
1
$ test-expr '\''a && (((b >= c) != d) || e)'\'' -a 2,1,1,1,1
1
$ test-expr '\''a && (((b >= c) != d) || e)'\'' -a 2,1,2,0,0
0
$ test-expr '\''a && (((b >= c) != d) || e)'\'' -a 2,2,0,1,0
0
$ test-expr '\''a && (((b >= c) != d) || e)'\'' -a 2,2,0,2,1
1
$ test-expr '\''a && (((b >= c) != d) || e)'\'' -a 2,2,1,1,2
1
$ test-expr '\''a && (((b >= c) != d) || e)'\'' -a 2,2,2,2,1
1
$ test-expr '\''a && (((b >= c) || d) != e)'\'' -a 0,0,0,2,1
0
$ test-expr '\''a && (((b >= c) || d) != e)'\'' -a 0,0,2,1,1
0
$ test-expr '\''a && (((b >= c) || d) != e)'\'' -a 0,1,2,0,1
0
$ test-expr '\''a && (((b >= c) || d) != e)'\'' -a 0,2,2,1,0
0
$ test-expr '\''a && (((b >= c) || d) != e)'\'' -a 1,0,0,0,1
0
$ test-expr '\''a && (((b >= c) || d) != e)'\'' -a 1,0,1,0,2
1
$ test-expr '\''a && (((b >= c) || d) != e)'\'' -a 1,0,2,1,0
1
$ test-expr '\''a && (((b >= c) || d) != e)'\'' -a 1,0,2,1,1
0
$ test-expr '\''a && (((b >= c) || d) != e)'\'' -a 1,0,2,2,2
1
$ test-expr '\''a && (((b >= c) || d) != e)'\'' -a 1,1,2,1,1
0
$ test-expr '\''a && (((b >= c) || d) != e)'\'' -a 1,2,0,2,1
0
$ test-expr '\''a && (((b >= c) || d) != e)'\'' -a 1,2,2,1,2
1
$ test-expr '\''a && (((b >= c) || d) != e)'\'' -a 2,0,0,0,1
0
$ test-expr '\''a && (((b >= c) || d) != e)'\'' -a 2,0,0,0,2
1
$ test-expr '\''a && (((b >= c) || d) != e)'\'' -a 2,0,0,2,1
0
$ test-expr '\''a && (((b >= c) || d) != e)'\'' -a 2,0,2,1,0
1
$ test-expr '\''a && (((b >= c) || d) != e)'\'' -a 2,0,2,2,2
1
$ test-expr '\''a && (((b >= c) || d) != e)'\'' -a 2,1,0,1,0
1
$ test-expr '\''a && (((b >= c) || d) != e)'\'' -a 2,1,0,1,2
1
$ test-expr '\''a && (((b >= c) || d) != e)'\'' -a 2,1,0,2,0
1
$ test-expr '\''a && (((b >= c) || d) != e)'\'' -a 2,1,1,1,1
0
$ test-expr '\''a && (((b >= c) || d) != e)'\'' -a 2,1,2,2,0
1
$ test-expr '\''a && (((b >= c) || d) != e)'\'' -a 2,1,2,2,1
0
$ test-expr '\''a && (((b >= c) || d) != e)'\'' -a 2,1,2,2,2
1
$ test-expr '\''a && (((b >= c) || d) != e)'\'' -a 2,2,0,1,2
1
$ test-expr '\''a && (((b >= c) || d) != e)'\'' -a 2,2,1,1,1
0
$ test-expr '\''a && (((b || c) != d) >= e)'\'' -a 0,0,1,1,1
0
$ test-expr '\''a && (((b || c) != d) >= e)'\'' -a 0,0,1,2,1
0
$ test-expr '\''a && (((b || c) != d) >= e)'\'' -a 0,0,1,2,2
0
$ test-expr '\''a && (((b || c) != d) >= e)'\'' -a 0,0,2,2,0
0
$ test-expr '\''a && (((b || c) != d) >= e)'\'' -a 0,1,0,0,1
0
$ test-expr '\''a && (((b || c) != d) >= e)'\'' -a 0,1,1,0,1
0
$ test-expr '\''a && (((b || c) != d) >= e)'\'' -a 0,2,1,0,2
0
$ test-expr '\''a && (((b || c) != d) >= e)'\'' -a 0,2,1,1,0
0
$ test-expr '\''a && (((b || c) != d) >= e)'\'' -a 0,2,1,1,2
0
$ test-expr '\''a && (((b || c) != d) >= e)'\'' -a 0,2,1,2,0
0
$ test-expr '\''a && (((b || c) != d) >= e)'\'' -a 0,2,2,0,1
0
$ test-expr '\''a && (((b || c) != d) >= e)'\'' -a 1,0,1,0,2
0
$ test-expr '\''a && (((b || c) != d) >= e)'\'' -a 1,0,1,1,2
0
$ test-expr '\''a && (((b || c) != d) >= e)'\'' -a 1,0,2,0,2
0
$ test-expr '\''a && (((b || c) != d) >= e)'\'' -a 1,1,1,1,0
1
$ test-expr '\''a && (((b || c) != d) >= e)'\'' -a 1,1,1,1,2
0
$ test-expr '\''a && (((b || c) != d) >= e)'\'' -a 1,2,0,1,0
1
$ test-expr '\''a && (((b || c) != d) >= e)'\'' -a 1,2,0,2,0
1
$ test-expr '\''a && (((b || c) != d) >= e)'\'' -a 1,2,1,0,0
1
$ test-expr '\''a && (((b || c) != d) >= e)'\'' -a 1,2,2,0,0
1
$ test-expr '\''a && (((b || c) != d) >= e)'\'' -a 1,2,2,1,1
0
$ test-expr '\''a && (((b || c) != d) >= e)'\'' -a 2,0,0,0,1
0
$ test-expr '\''a && (((b || c) != d) >= e)'\'' -a 2,0,0,2,1
1
$ test-expr '\''a && (((b || c) != d) >= e)'\'' -a 2,0,1,0,2
0
$ test-expr '\''a && (((b || c) != d) >= e)'\'' -a 2,0,1,2,1
1
$ test-expr '\''a && (((b || c) != d) >= e)'\'' -a 2,1,0,1,2
0
$ test-expr '\''a && (((b || c) != d) >= e)'\'' -a 2,1,1,1,2
0
$ test-expr '\''a && (((b || c) != d) >= e)'\'' -a 2,1,1,2,2
0
$ test-expr '\''a && (((b || c) != d) >= e)'\'' -a 2,1,2,2,0
1
$ test-expr '\''a && (((b || c) != d) >= e)'\'' -a 2,2,1,1,0
1
$ test-expr '\''a && (((b || c) != d) >= e)'\'' -a 2,2,1,2,2
0
$ test-expr '\''a && (((b || c) >= d) != e)'\'' -a 0,0,0,2,2
0
$ test-expr '\''a && (((b || c) >= d) != e)'\'' -a 0,0,2,0,2
0
$ test-expr '\''a && (((b || c) >= d) != e)'\'' -a 0,1,2,0,2
0
$ test-expr '\''a && (((b || c) >= d) != e)'\'' -a 0,2,1,1,2
0
$ test-expr '\''a && (((b || c) >= d) != e)'\'' -a 0,2,1,2,2
0
$ test-expr '\''a && (((b || c) >= d) != e)'\'' -a 0,2,2,1,0
0
$ test-expr '\''a && (((b || c) >= d) != e)'\'' -a 1,0,0,1,2
1
$ test-expr '\''a && (((b || c) >= d) != e)'\'' -a 1,0,1,0,1
0
$ test-expr '\''a && (((b || c) >= d) != e)'\'' -a 1,0,2,1,0
1
$ test-expr '\''a && (((b || c) >= d) != e)'\'' -a 1,0,2,1,1
0
$ test-expr '\''a && (((b || c) >= d) != e)'\'' -a 1,1,0,0,2
1
$ test-expr '\''a && (((b || c) >= d) != e)'\'' -a 1,1,0,1,0
1
$ test-expr '\''a && (((b || c) >= d) != e)'\'' -a 1,1,0,2,1
1
$ test-expr '\''a && (((b || c) >= d) != e)'\'' -a 1,1,1,0,1
0
$ test-expr '\''a && (((b || c) >= d) != e)'\'' -a 1,1,2,0,1
0
$ test-expr '\''a && (((b || c) >= d) != e)'\'' -a 1,1,2,0,2
1
$ test-expr '\''a && (((b || c) >= d) != e)'\'' -a 1,1,2,1,1
0
$ test-expr '\''a && (((b || c) >= d) != e)'\'' -a 1,1,2,2,0
0
$ test-expr '\''a && (((b || c) >= d) != e)'\'' -a 1,2,0,0,2
1
$ test-expr '\''a && (((b || c) >= d) != e)'\'' -a 1,2,1,2,0
0
$ test-expr '\''a && (((b || c) >= d) != e)'\'' -a 2,0,1,0,1
0
$ test-expr '\''a && (((b || c) >= d) != e)'\'' -a 2,0,1,0,2
1
$ test-expr '\''a && (((b || c) >= d) != e)'\'' -a 2,0,2,0,0
1
$ test-expr '\''a && (((b || c) >= d) != e)'\'' -a 2,1,2,0,2
1
$ test-expr '\''a && (((b || c) >= d) != e)'\'' -a 2,2,1,0,1
0
$ test-expr '\''a && (((b || c) >= d) != e)'\'' -a 2,2,2,1,0
1
$ test-expr '\''a >= (b != (c && (d || e)))'\'' -a 0,0,0,0,0
1
$ test-expr '\''a >= (b != (c && (d || e)))'\'' -a 0,0,0,2,1
1
$ test-expr '\''a >= (b != (c && (d || e)))'\'' -a 0,0,2,1,0
0
$ test-expr '\''a >= (b != (c && (d || e)))'\'' -a 0,0,2,1,1
0
$ test-expr '\''a >= (b != (c && (d || e)))'\'' -a 0,1,2,0,1
1
$ test-expr '\''a >= (b != (c && (d || e)))'\'' -a 0,2,0,0,2
0
$ test-expr '\''a >= (b != (c && (d || e)))'\'' -a 0,2,0,2,1
0
$ test-expr '\''a >= (b != (c && (d || e)))'\'' -a 0,2,1,0,2
0
$ test-expr '\''a >= (b != (c && (d || e)))'\'' -a 0,2,1,2,1
0
$ test-expr '\''a >= (b != (c && (d || e)))'\'' -a 0,2,2,1,0
0
$ test-expr '\''a >= (b != (c && (d || e)))'\'' -a 1,0,0,0,0
1
$ test-expr '\''a >= (b != (c && (d || e)))'\'' -a 1,0,1,0,2
1
$ test-expr '\''a >= (b != (c && (d || e)))'\'' -a 1,0,1,1,1
1
$ test-expr '\''a >= (b != (c && (d || e)))'\'' -a 1,0,1,2,2
1
$ test-expr '\''a >= (b != (c && (d || e)))'\'' -a 1,0,2,0,0
1
$ test-expr '\''a >= (b != (c && (d || e)))'\'' -a 1,0,2,1,0
1
$ test-expr '\''a >= (b != (c && (d || e)))'\'' -a 1,0,2,1,1
1
$ test-expr '\''a >= (b != (c && (d || e)))'\'' -a 1,1,1,0,1
1
$ test-expr '\''a >= (b != (c && (d || e)))'\'' -a 1,1,1,1,0
1
$ test-expr '\''a >= (b != (c && (d || e)))'\'' -a 1,1,1,2,0
1
$ test-expr '\''a >= (b != (c && (d || e)))'\'' -a 1,2,0,0,2
1
$ test-expr '\''a >= (b != (c && (d || e)))'\'' -a 1,2,0,1,1
1
$ test-expr '\''a >= (b != (c && (d || e)))'\'' -a 1,2,1,0,2
1
$ test-expr '\''a >= (b != (c && (d || e)))'\'' -a 1,2,1,2,2
1
$ test-expr '\''a >= (b != (c && (d || e)))'\'' -a 1,2,2,2,1
1
$ test-expr '\''a >= (b != (c && (d || e)))'\'' -a 2,0,2,1,0
1
$ test-expr '\''a >= (b != (c && (d || e)))'\'' -a 2,1,0,2,1
1
$ test-expr '\''a >= (b != (c && (d || e)))'\'' -a 2,1,1,2,0
1
$ test-expr '\''a >= (b != (c && (d || e)))'\'' -a 2,1,1,2,2
1
$ test-expr '\''a >= (b != (c && (d || e)))'\'' -a 2,2,0,0,0
1
$ test-expr '\''a >= (b != (c || (d && e)))'\'' -a 0,0,0,2,0
1
$ test-expr '\''a >= (b != (c || (d && e)))'\'' -a 0,0,1,0,2
0
$ test-expr '\''a >= (b != (c || (d && e)))'\'' -a 0,0,1,1,2
0
$ test-expr '\''a >= (b != (c || (d && e)))'\'' -a 0,0,1,2,0
0
$ test-expr '\''a >= (b != (c || (d && e)))'\'' -a 0,0,2,1,1
0
$ test-expr '\''a >= (b != (c || (d && e)))'\'' -a 0,1,0,0,2
0
$ test-expr '\''a >= (b != (c || (d && e)))'\'' -a 0,1,0,2,1
1
$ test-expr '\''a >= (b != (c || (d && e)))'\'' -a 0,1,1,1,1
1
$ test-expr '\''a >= (b != (c || (d && e)))'\'' -a 0,1,1,2,0
1
$ test-expr '\''a >= (b != (c || (d && e)))'\'' -a 0,1,2,0,2
1
$ test-expr '\''a >= (b != (c || (d && e)))'\'' -a 0,1,2,1,0
1
$ test-expr '\''a >= (b != (c || (d && e)))'\'' -a 0,1,2,2,0
1
$ test-expr '\''a >= (b != (c || (d && e)))'\'' -a 0,2,0,2,0
0
$ test-expr '\''a >= (b != (c || (d && e)))'\'' -a 0,2,1,0,1
0
$ test-expr '\''a >= (b != (c || (d && e)))'\'' -a 0,2,1,2,0
0
$ test-expr '\''a >= (b != (c || (d && e)))'\'' -a 0,2,2,1,1
0
$ test-expr '\''a >= (b != (c || (d && e)))'\'' -a 1,0,1,1,0
1
$ test-expr '\''a >= (b != (c || (d && e)))'\'' -a 1,0,1,2,2
1
$ test-expr '\''a >= (b != (c || (d && e)))'\'' -a 1,0,2,2,1
1
$ test-expr '\''a >= (b != (c || (d && e)))'\'' -a 1,2,0,0,1
1
$ test-expr '\''a >= (b != (c || (d && e)))'\'' -a 1,2,0,1,0
1
$ test-expr '\''a >= (b != (c || (d && e)))'\'' -a 1,2,0,2,0
1
$ test-expr '\''a >= (b != (c || (d && e)))'\'' -a 1,2,1,1,2
1
$ test-expr '\''a >= (b != (c || (d && e)))'\'' -a 1,2,2,0,2
1
$ test-expr '\''a >= (b != (c || (d && e)))'\'' -a 1,2,2,1,0
1
$ test-expr '\''a >= (b != (c || (d && e)))'\'' -a 1,2,2,1,2
1
$ test-expr '\''a >= (b != (c || (d && e)))'\'' -a 1,2,2,2,1
1
$ test-expr '\''a >= (b != (c || (d && e)))'\'' -a 2,0,1,2,0
1
$ test-expr '\''a >= (b != (c || (d && e)))'\'' -a 2,1,1,0,1
1
$ test-expr '\''a >= (b != (c || (d && e)))'\'' -a 2,2,0,0,1
1
$ test-expr '\''a >= (b != (c || (d && e)))'\'' -a 2,2,0,0,2
1
$ test-expr '\''a >= (b != (c || (d && e)))'\'' -a 2,2,1,1,2
1
$ test-expr '\''a >= (b != ((c && d) || e))'\'' -a 0,0,0,1,0
1
$ test-expr '\''a >= (b != ((c && d) || e))'\'' -a 0,0,1,0,2
0
$ test-expr '\''a >= (b != ((c && d) || e))'\'' -a 0,2,0,0,0
0
$ test-expr '\''a >= (b != ((c && d) || e))'\'' -a 0,2,1,0,0
0
$ test-expr '\''a >= (b != ((c && d) || e))'\'' -a 0,2,1,0,1
0
$ test-expr '\''a >= (b != ((c && d) || e))'\'' -a 0,2,1,2,0
0
$ test-expr '\''a >= (b != ((c && d) || e))'\'' -a 0,2,2,1,0
0
$ test-expr '\''a >= (b != ((c && d) || e))'\'' -a 1,0,2,0,0
1
$ test-expr '\''a >= (b != ((c && d) || e))'\'' -a 1,1,1,0,2
1
$ test-expr '\''a >= (b != ((c && d) || e))'\'' -a 1,1,2,0,0
1
$ test-expr '\''a >= (b != ((c && d) || e))'\'' -a 1,2,0,1,1
1
$ test-expr '\''a >= (b != ((c && d) || e))'\'' -a 1,2,1,1,2
1
$ test-expr '\''a >= (b != ((c && d) || e))'\'' -a 2,0,0,0,2
1
$ test-expr '\''a >= (b != ((c && d) || e))'\'' -a 2,0,0,2,2
1
$ test-expr '\''a >= (b != ((c && d) || e))'\'' -a 2,0,1,1,2
1
$ test-expr '\''a >= (b != ((c && d) || e))'\'' -a 2,0,1,2,0
1
$ test-expr '\''a >= (b != ((c && d) || e))'\'' -a 2,0,1,2,1
1
$ test-expr '\''a >= (b != ((c && d) || e))'\'' -a 2,0,2,1,0
1
$ test-expr '\''a >= (b != ((c && d) || e))'\'' -a 2,0,2,1,1
1
$ test-expr '\''a >= (b != ((c && d) || e))'\'' -a 2,1,0,2,0
1
$ test-expr '\''a >= (b != ((c && d) || e))'\'' -a 2,1,2,1,2
1
$ test-expr '\''a >= (b != ((c && d) || e))'\'' -a 2,1,2,2,0
1
$ test-expr '\''a >= (b != ((c && d) || e))'\'' -a 2,2,0,1,1
1
$ test-expr '\''a >= (b != ((c || d) && e))'\'' -a 0,0,0,0,1
1
$ test-expr '\''a >= (b != ((c || d) && e))'\'' -a 0,0,0,2,0
1
$ test-expr '\''a >= (b != ((c || d) && e))'\'' -a 0,0,0,2,1
0
$ test-expr '\''a >= (b != ((c || d) && e))'\'' -a 0,0,2,0,2
0
$ test-expr '\''a >= (b != ((c || d) && e))'\'' -a 0,0,2,2,0
1
$ test-expr '\''a >= (b != ((c || d) && e))'\'' -a 0,1,0,1,2
1
$ test-expr '\''a >= (b != ((c || d) && e))'\'' -a 0,1,2,0,2
1
$ test-expr '\''a >= (b != ((c || d) && e))'\'' -a 0,2,0,0,0
0
$ test-expr '\''a >= (b != ((c || d) && e))'\'' -a 0,2,0,1,0
0
$ test-expr '\''a >= (b != ((c || d) && e))'\'' -a 0,2,0,2,2
0
$ test-expr '\''a >= (b != ((c || d) && e))'\'' -a 1,0,1,2,0
1
$ test-expr '\''a >= (b != ((c || d) && e))'\'' -a 1,0,2,1,0
1
$ test-expr '\''a >= (b != ((c || d) && e))'\'' -a 1,0,2,1,2
1
$ test-expr '\''a >= (b != ((c || d) && e))'\'' -a 1,0,2,2,2
1
$ test-expr '\''a >= (b != ((c || d) && e))'\'' -a 1,1,2,2,2
1
$ test-expr '\''a >= (b != ((c || d) && e))'\'' -a 1,2,0,2,0
1
$ test-expr '\''a >= (b != ((c || d) && e))'\'' -a 1,2,1,0,2
1
$ test-expr '\''a >= (b != ((c || d) && e))'\'' -a 1,2,2,2,2
1
$ test-expr '\''a >= (b != ((c || d) && e))'\'' -a 2,0,0,0,0
1
$ test-expr '\''a >= (b != ((c || d) && e))'\'' -a 2,0,1,0,2
1
$ test-expr '\''a >= (b != ((c || d) && e))'\'' -a 2,0,1,2,2
1
$ test-expr '\''a >= (b != ((c || d) && e))'\'' -a 2,1,0,0,2
1
$ test-expr '\''a >= (b != ((c || d) && e))'\'' -a 2,1,0,2,0
1
$ test-expr '\''a >= (b != ((c || d) && e))'\'' -a 2,1,1,0,2
1
$ test-expr '\''a >= (b != ((c || d) && e))'\'' -a 2,1,1,1,0
1
$ test-expr '\''a >= (b != ((c || d) && e))'\'' -a 2,1,1,1,2
1
$ test-expr '\''a >= (b != ((c || d) && e))'\'' -a 2,1,1,2,0
1
$ test-expr '\''a >= (b && (c != (d || e)))'\'' -a 0,0,0,2,1
1
$ test-expr '\''a >= (b && (c != (d || e)))'\'' -a 0,0,1,1,1
1
$ test-expr '\''a >= (b && (c != (d || e)))'\'' -a 0,2,0,0,2
0
$ test-expr '\''a >= (b && (c != (d || e)))'\'' -a 0,2,0,1,0
0
$ test-expr '\''a >= (b && (c != (d || e)))'\'' -a 0,2,0,2,0
0
$ test-expr '\''a >= (b && (c != (d || e)))'\'' -a 0,2,1,1,2
1
$ test-expr '\''a >= (b && (c != (d || e)))'\'' -a 0,2,1,2,2
1
$ test-expr '\''a >= (b && (c != (d || e)))'\'' -a 0,2,2,0,0
0
$ test-expr '\''a >= (b && (c != (d || e)))'\'' -a 0,2,2,1,0
0
$ test-expr '\''a >= (b && (c != (d || e)))'\'' -a 1,1,0,0,1
1
$ test-expr '\''a >= (b && (c != (d || e)))'\'' -a 1,1,0,2,0
1
$ test-expr '\''a >= (b && (c != (d || e)))'\'' -a 1,1,1,1,2
1
$ test-expr '\''a >= (b && (c != (d || e)))'\'' -a 1,1,2,1,0
1
$ test-expr '\''a >= (b && (c != (d || e)))'\'' -a 1,2,0,0,1
1
$ test-expr '\''a >= (b && (c != (d || e)))'\'' -a 1,2,0,0,2
1
$ test-expr '\''a >= (b && (c != (d || e)))'\'' -a 1,2,1,1,0
1
$ test-expr '\''a >= (b && (c != (d || e)))'\'' -a 1,2,2,1,2
1
$ test-expr '\''a >= (b && (c != (d || e)))'\'' -a 2,0,0,2,2
1
$ test-expr '\''a >= (b && (c != (d || e)))'\'' -a 2,0,2,0,0
1
$ test-expr '\''a >= (b && (c != (d || e)))'\'' -a 2,1,0,0,2
1
$ test-expr '\''a >= (b && (c != (d || e)))'\'' -a 2,1,0,1,0
1
$ test-expr '\''a >= (b && (c != (d || e)))'\'' -a 2,1,0,2,1
1
$ test-expr '\''a >= (b && (c != (d || e)))'\'' -a 2,1,0,2,2
1
$ test-expr '\''a >= (b && (c != (d || e)))'\'' -a 2,1,1,1,1
1
$ test-expr '\''a >= (b && (c != (d || e)))'\'' -a 2,2,0,1,1
1
$ test-expr '\''a >= (b && (c != (d || e)))'\'' -a 2,2,0,2,1
1
$ test-expr '\''a >= (b && (c != (d || e)))'\'' -a 2,2,1,1,1
1
$ test-expr '\''a >= (b && (c != (d || e)))'\'' -a 2,2,1,2,0
1
$ test-expr '\''a >= (b && (c != (d || e)))'\'' -a 2,2,2,1,1
1
$ test-expr '\''a >= (b && (c || (d != e)))'\'' -a 0,0,0,0,0
1
$ test-expr '\''a >= (b && (c || (d != e)))'\'' -a 0,0,1,1,2
1
$ test-expr '\''a >= (b && (c || (d != e)))'\'' -a 0,0,1,2,1
1
$ test-expr '\''a >= (b && (c || (d != e)))'\'' -a 0,0,2,0,0
1
$ test-expr '\''a >= (b && (c || (d != e)))'\'' -a 0,1,0,1,0
0
$ test-expr '\''a >= (b && (c || (d != e)))'\'' -a 0,1,1,0,1
0
$ test-expr '\''a >= (b && (c || (d != e)))'\'' -a 0,1,2,2,1
0
$ test-expr '\''a >= (b && (c || (d != e)))'\'' -a 0,2,0,0,0
1
$ test-expr '\''a >= (b && (c || (d != e)))'\'' -a 0,2,0,0,1
0
$ test-expr '\''a >= (b && (c || (d != e)))'\'' -a 0,2,1,2,2
0
$ test-expr '\''a >= (b && (c || (d != e)))'\'' -a 0,2,2,2,0
0
$ test-expr '\''a >= (b && (c || (d != e)))'\'' -a 1,0,0,1,2
1
$ test-expr '\''a >= (b && (c || (d != e)))'\'' -a 1,0,1,2,2
1
$ test-expr '\''a >= (b && (c || (d != e)))'\'' -a 1,1,0,0,2
1
$ test-expr '\''a >= (b && (c || (d != e)))'\'' -a 1,1,0,1,0
1
$ test-expr '\''a >= (b && (c || (d != e)))'\'' -a 1,1,1,0,2
1
$ test-expr '\''a >= (b && (c || (d != e)))'\'' -a 1,1,2,0,2
1
$ test-expr '\''a >= (b && (c || (d != e)))'\'' -a 1,2,2,2,0
1
$ test-expr '\''a >= (b && (c || (d != e)))'\'' -a 2,0,0,1,1
1
$ test-expr '\''a >= (b && (c || (d != e)))'\'' -a 2,0,0,1,2
1
$ test-expr '\''a >= (b && (c || (d != e)))'\'' -a 2,1,2,2,2
1
$ test-expr '\''a >= (b && (c || (d != e)))'\'' -a 2,2,0,0,0
1
$ test-expr '\''a >= (b && (c || (d != e)))'\'' -a 2,2,0,0,2
1
$ test-expr '\''a >= (b && (c || (d != e)))'\'' -a 2,2,0,1,2
1
$ test-expr '\''a >= (b && (c || (d != e)))'\'' -a 2,2,0,2,1
1
$ test-expr '\''a >= (b && (c || (d != e)))'\'' -a 2,2,1,1,1
1
$ test-expr '\''a >= (b && ((c != d) || e))'\'' -a 0,0,0,0,0
1
$ test-expr '\''a >= (b && ((c != d) || e))'\'' -a 0,0,0,1,0
1
$ test-expr '\''a >= (b && ((c != d) || e))'\'' -a 0,0,0,2,1
1
$ test-expr '\''a >= (b && ((c != d) || e))'\'' -a 0,0,2,1,2
1
$ test-expr '\''a >= (b && ((c != d) || e))'\'' -a 0,0,2,2,1
1
$ test-expr '\''a >= (b && ((c != d) || e))'\'' -a 0,1,0,2,0
0
$ test-expr '\''a >= (b && ((c != d) || e))'\'' -a 0,1,2,2,2
0
$ test-expr '\''a >= (b && ((c != d) || e))'\'' -a 0,2,0,1,1
0
$ test-expr '\''a >= (b && ((c != d) || e))'\'' -a 0,2,1,1,1
0
$ test-expr '\''a >= (b && ((c != d) || e))'\'' -a 0,2,2,1,0
0
$ test-expr '\''a >= (b && ((c != d) || e))'\'' -a 1,0,0,2,0
1
$ test-expr '\''a >= (b && ((c != d) || e))'\'' -a 1,0,1,1,1
1
$ test-expr '\''a >= (b && ((c != d) || e))'\'' -a 1,0,2,1,0
1
$ test-expr '\''a >= (b && ((c != d) || e))'\'' -a 1,1,2,1,2
1
$ test-expr '\''a >= (b && ((c != d) || e))'\'' -a 1,1,2,2,1
1
$ test-expr '\''a >= (b && ((c != d) || e))'\'' -a 1,1,2,2,2
1
$ test-expr '\''a >= (b && ((c != d) || e))'\'' -a 1,2,0,1,0
1
$ test-expr '\''a >= (b && ((c != d) || e))'\'' -a 1,2,1,2,1
1
$ test-expr '\''a >= (b && ((c != d) || e))'\'' -a 2,0,1,0,1
1
$ test-expr '\''a >= (b && ((c != d) || e))'\'' -a 2,0,2,1,0
1
$ test-expr '\''a >= (b && ((c != d) || e))'\'' -a 2,1,0,2,1
1
$ test-expr '\''a >= (b && ((c != d) || e))'\'' -a 2,1,1,1,0
1
$ test-expr '\''a >= (b && ((c != d) || e))'\'' -a 2,1,1,1,2
1
$ test-expr '\''a >= (b && ((c != d) || e))'\'' -a 2,1,2,0,1
1
$ test-expr '\''a >= (b && ((c != d) || e))'\'' -a 2,1,2,0,2
1
$ test-expr '\''a >= (b && ((c != d) || e))'\'' -a 2,2,0,0,0
1
$ test-expr '\''a >= (b && ((c != d) || e))'\'' -a 2,2,0,0,2
1
$ test-expr '\''a >= (b && ((c != d) || e))'\'' -a 2,2,0,2,1
1
$ test-expr '\''a >= (b && ((c != d) || e))'\'' -a 2,2,1,2,0
1
$ test-expr '\''a >= (b && ((c != d) || e))'\'' -a 2,2,2,2,1
1
$ test-expr '\''a >= (b && ((c || d) != e))'\'' -a 0,0,0,1,0
1
$ test-expr '\''a >= (b && ((c || d) != e))'\'' -a 0,0,1,1,0
1
$ test-expr '\''a >= (b && ((c || d) != e))'\'' -a 0,0,2,0,0
1
$ test-expr '\''a >= (b && ((c || d) != e))'\'' -a 0,0,2,2,1
1
$ test-expr '\''a >= (b && ((c || d) != e))'\'' -a 0,2,0,0,2
0
$ test-expr '\''a >= (b && ((c || d) != e))'\'' -a 1,0,0,1,0
1
$ test-expr '\''a >= (b && ((c || d) != e))'\'' -a 1,0,0,2,0
1
$ test-expr '\''a >= (b && ((c || d) != e))'\'' -a 1,0,1,0,0
1
$ test-expr '\''a >= (b && ((c || d) != e))'\'' -a 1,0,2,0,2
1
$ test-expr '\''a >= (b && ((c || d) != e))'\'' -a 1,1,1,1,2
1
$ test-expr '\''a >= (b && ((c || d) != e))'\'' -a 1,1,2,1,0
1
$ test-expr '\''a >= (b && ((c || d) != e))'\'' -a 1,1,2,2,2
1
$ test-expr '\''a >= (b && ((c || d) != e))'\'' -a 1,2,0,1,1
1
$ test-expr '\''a >= (b && ((c || d) != e))'\'' -a 1,2,0,1,2
1
$ test-expr '\''a >= (b && ((c || d) != e))'\'' -a 1,2,0,2,1
1
$ test-expr '\''a >= (b && ((c || d) != e))'\'' -a 1,2,1,1,2
1
$ test-expr '\''a >= (b && ((c || d) != e))'\'' -a 1,2,2,1,2
1
$ test-expr '\''a >= (b && ((c || d) != e))'\'' -a 1,2,2,2,1
1
$ test-expr '\''a >= (b && ((c || d) != e))'\'' -a 2,0,0,0,2
1
$ test-expr '\''a >= (b && ((c || d) != e))'\'' -a 2,0,0,2,0
1
$ test-expr '\''a >= (b && ((c || d) != e))'\'' -a 2,0,0,2,2
1
$ test-expr '\''a >= (b && ((c || d) != e))'\'' -a 2,0,1,2,0
1
$ test-expr '\''a >= (b && ((c || d) != e))'\'' -a 2,0,2,0,2
1
$ test-expr '\''a >= (b && ((c || d) != e))'\'' -a 2,1,0,0,1
1
$ test-expr '\''a >= (b && ((c || d) != e))'\'' -a 2,1,2,0,1
1
$ test-expr '\''a >= (b && ((c || d) != e))'\'' -a 2,2,0,1,2
1
$ test-expr '\''a >= (b || (c != (d && e)))'\'' -a 0,0,1,0,0
0
$ test-expr '\''a >= (b || (c != (d && e)))'\'' -a 0,0,1,1,1
1
$ test-expr '\''a >= (b || (c != (d && e)))'\'' -a 0,0,1,2,0
0
$ test-expr '\''a >= (b || (c != (d && e)))'\'' -a 0,0,2,0,1
0
$ test-expr '\''a >= (b || (c != (d && e)))'\'' -a 0,1,0,2,0
0
$ test-expr '\''a >= (b || (c != (d && e)))'\'' -a 0,1,1,1,0
0
$ test-expr '\''a >= (b || (c != (d && e)))'\'' -a 0,1,1,2,0
0
$ test-expr '\''a >= (b || (c != (d && e)))'\'' -a 0,1,2,0,1
0
$ test-expr '\''a >= (b || (c != (d && e)))'\'' -a 1,0,0,0,0
1
$ test-expr '\''a >= (b || (c != (d && e)))'\'' -a 1,0,0,1,1
1
$ test-expr '\''a >= (b || (c != (d && e)))'\'' -a 1,0,1,0,2
1
$ test-expr '\''a >= (b || (c != (d && e)))'\'' -a 1,0,1,1,2
1
$ test-expr '\''a >= (b || (c != (d && e)))'\'' -a 1,1,0,2,2
1
$ test-expr '\''a >= (b || (c != (d && e)))'\'' -a 1,1,2,0,1
1
$ test-expr '\''a >= (b || (c != (d && e)))'\'' -a 1,2,1,0,0
1
$ test-expr '\''a >= (b || (c != (d && e)))'\'' -a 1,2,1,2,2
1
$ test-expr '\''a >= (b || (c != (d && e)))'\'' -a 1,2,2,1,1
1
$ test-expr '\''a >= (b || (c != (d && e)))'\'' -a 2,0,0,2,0
1
$ test-expr '\''a >= (b || (c != (d && e)))'\'' -a 2,0,1,2,2
1
$ test-expr '\''a >= (b || (c != (d && e)))'\'' -a 2,0,2,2,0
1
$ test-expr '\''a >= (b || (c != (d && e)))'\'' -a 2,1,1,1,0
1
$ test-expr '\''a >= (b || (c != (d && e)))'\'' -a 2,2,0,0,2
1
$ test-expr '\''a >= (b || (c != (d && e)))'\'' -a 2,2,0,1,0
1
$ test-expr '\''a >= (b || (c != (d && e)))'\'' -a 2,2,1,0,2
1
$ test-expr '\''a >= (b || (c != (d && e)))'\'' -a 2,2,1,2,0
1
$ test-expr '\''a >= (b || (c && (d != e)))'\'' -a 0,0,0,2,2
1
$ test-expr '\''a >= (b || (c && (d != e)))'\'' -a 0,0,2,2,1
0
$ test-expr '\''a >= (b || (c && (d != e)))'\'' -a 0,1,1,1,0
0
$ test-expr '\''a >= (b || (c && (d != e)))'\'' -a 0,1,1,1,1
0
$ test-expr '\''a >= (b || (c && (d != e)))'\'' -a 0,1,2,2,1
0
$ test-expr '\''a >= (b || (c && (d != e)))'\'' -a 0,2,1,0,0
0
$ test-expr '\''a >= (b || (c && (d != e)))'\'' -a 0,2,1,1,1
0
$ test-expr '\''a >= (b || (c && (d != e)))'\'' -a 0,2,1,2,0
0
$ test-expr '\''a >= (b || (c && (d != e)))'\'' -a 0,2,2,2,1
0
$ test-expr '\''a >= (b || (c && (d != e)))'\'' -a 1,1,0,1,2
1
$ test-expr '\''a >= (b || (c && (d != e)))'\'' -a 1,1,0,2,0
1
$ test-expr '\''a >= (b || (c && (d != e)))'\'' -a 1,1,0,2,1
1
$ test-expr '\''a >= (b || (c && (d != e)))'\'' -a 1,1,1,0,0
1
$ test-expr '\''a >= (b || (c && (d != e)))'\'' -a 1,1,2,0,0
1
$ test-expr '\''a >= (b || (c && (d != e)))'\'' -a 1,2,0,0,2
1
$ test-expr '\''a >= (b || (c && (d != e)))'\'' -a 1,2,0,1,1
1
$ test-expr '\''a >= (b || (c && (d != e)))'\'' -a 1,2,0,1,2
1
$ test-expr '\''a >= (b || (c && (d != e)))'\'' -a 1,2,2,0,1
1
$ test-expr '\''a >= (b || (c && (d != e)))'\'' -a 1,2,2,2,0
1
$ test-expr '\''a >= (b || (c && (d != e)))'\'' -a 2,0,2,2,1
1
$ test-expr '\''a >= (b || (c && (d != e)))'\'' -a 2,0,2,2,2
1
$ test-expr '\''a >= (b || (c && (d != e)))'\'' -a 2,1,0,1,1
1
$ test-expr '\''a >= (b || (c && (d != e)))'\'' -a 2,1,0,1,2
1
$ test-expr '\''a >= (b || (c && (d != e)))'\'' -a 2,1,0,2,1
1
$ test-expr '\''a >= (b || (c && (d != e)))'\'' -a 2,1,1,1,0
1
$ test-expr '\''a >= (b || (c && (d != e)))'\'' -a 2,1,1,1,1
1
$ test-expr '\''a >= (b || (c && (d != e)))'\'' -a 2,1,1,2,0
1
$ test-expr '\''a >= (b || (c && (d != e)))'\'' -a 2,1,2,0,1
1
$ test-expr '\''a >= (b || (c && (d != e)))'\'' -a 2,1,2,0,2
1
$ test-expr '\''a >= (b || (c && (d != e)))'\'' -a 2,1,2,1,0
1
$ test-expr '\''a >= (b || (c && (d != e)))'\'' -a 2,1,2,1,1
1
$ test-expr '\''a >= (b || (c && (d != e)))'\'' -a 2,2,0,1,0
1
$ test-expr '\''a >= (b || (c && (d != e)))'\'' -a 2,2,0,2,2
1
$ test-expr '\''a >= (b || (c && (d != e)))'\'' -a 2,2,2,0,0
1
$ test-expr '\''a >= (b || (c && (d != e)))'\'' -a 2,2,2,1,1
1
$ test-expr '\''a >= (b || ((c != d) && e))'\'' -a 0,0,0,0,1
1
$ test-expr '\''a >= (b || ((c != d) && e))'\'' -a 0,0,1,1,1
1
$ test-expr '\''a >= (b || ((c != d) && e))'\'' -a 0,0,2,0,2
0
$ test-expr '\''a >= (b || ((c != d) && e))'\'' -a 0,0,2,1,2
0
$ test-expr '\''a >= (b || ((c != d) && e))'\'' -a 0,2,0,2,1
0
$ test-expr '\''a >= (b || ((c != d) && e))'\'' -a 0,2,1,1,0
0
$ test-expr '\''a >= (b || ((c != d) && e))'\'' -a 0,2,2,0,0
0
$ test-expr '\''a >= (b || ((c != d) && e))'\'' -a 1,0,0,1,1
1
$ test-expr '\''a >= (b || ((c != d) && e))'\'' -a 1,1,0,0,0
1
$ test-expr '\''a >= (b || ((c != d) && e))'\'' -a 1,1,0,0,1
1
$ test-expr '\''a >= (b || ((c != d) && e))'\'' -a 1,1,0,0,2
1
$ test-expr '\''a >= (b || ((c != d) && e))'\'' -a 1,1,0,2,2
1
$ test-expr '\''a >= (b || ((c != d) && e))'\'' -a 1,1,1,0,0
1
$ test-expr '\''a >= (b || ((c != d) && e))'\'' -a 1,1,1,2,2
1
$ test-expr '\''a >= (b || ((c != d) && e))'\'' -a 1,1,2,1,1
1
$ test-expr '\''a >= (b || ((c != d) && e))'\'' -a 1,2,0,1,0
1
$ test-expr '\''a >= (b || ((c != d) && e))'\'' -a 1,2,0,1,2
1
$ test-expr '\''a >= (b || ((c != d) && e))'\'' -a 2,0,0,1,0
1
$ test-expr '\''a >= (b || ((c != d) && e))'\'' -a 2,1,1,2,1
1
$ test-expr '\''a >= (b || ((c != d) && e))'\'' -a 2,1,2,0,1
1
$ test-expr '\''a >= (b || ((c != d) && e))'\'' -a 2,1,2,2,2
1
$ test-expr '\''a >= (b || ((c != d) && e))'\'' -a 2,2,0,2,1
1
$ test-expr '\''a >= (b || ((c != d) && e))'\'' -a 2,2,1,2,1
1
$ test-expr '\''a >= (b || ((c != d) && e))'\'' -a 2,2,1,2,2
1
$ test-expr '\''a >= (b || ((c && d) != e))'\'' -a 0,0,2,2,1
1
$ test-expr '\''a >= (b || ((c && d) != e))'\'' -a 0,1,0,0,1
0
$ test-expr '\''a >= (b || ((c && d) != e))'\'' -a 0,1,0,0,2
0
$ test-expr '\''a >= (b || ((c && d) != e))'\'' -a 0,1,1,2,2
0
$ test-expr '\''a >= (b || ((c && d) != e))'\'' -a 0,1,2,0,0
0
$ test-expr '\''a >= (b || ((c && d) != e))'\'' -a 0,1,2,2,1
0
$ test-expr '\''a >= (b || ((c && d) != e))'\'' -a 0,2,0,1,2
0
$ test-expr '\''a >= (b || ((c && d) != e))'\'' -a 0,2,0,2,0
0
$ test-expr '\''a >= (b || ((c && d) != e))'\'' -a 0,2,0,2,1
0
$ test-expr '\''a >= (b || ((c && d) != e))'\'' -a 0,2,1,0,0
0
$ test-expr '\''a >= (b || ((c && d) != e))'\'' -a 1,0,0,1,0
1
$ test-expr '\''a >= (b || ((c && d) != e))'\'' -a 1,0,0,2,1
1
$ test-expr '\''a >= (b || ((c && d) != e))'\'' -a 1,1,0,0,0
1
$ test-expr '\''a >= (b || ((c && d) != e))'\'' -a 1,1,2,0,1
1
$ test-expr '\''a >= (b || ((c && d) != e))'\'' -a 1,2,0,1,1
1
$ test-expr '\''a >= (b || ((c && d) != e))'\'' -a 1,2,0,1,2
1
$ test-expr '\''a >= (b || ((c && d) != e))'\'' -a 1,2,1,2,2
1
$ test-expr '\''a >= (b || ((c && d) != e))'\'' -a 2,0,0,0,0
1
$ test-expr '\''a >= (b || ((c && d) != e))'\'' -a 2,0,2,0,1
1
$ test-expr '\''a >= (b || ((c && d) != e))'\'' -a 2,0,2,1,2
1
$ test-expr '\''a >= (b || ((c && d) != e))'\'' -a 2,1,0,1,2
1
$ test-expr '\''a >= (b || ((c && d) != e))'\'' -a 2,1,1,2,0
1
$ test-expr '\''a >= (b || ((c && d) != e))'\'' -a 2,1,2,0,0
1
$ test-expr '\''a >= (b || ((c && d) != e))'\'' -a 2,2,0,0,1
1
$ test-expr '\''a >= (b || ((c && d) != e))'\'' -a 2,2,1,1,2
1
$ test-expr '\''a >= (b || ((c && d) != e))'\'' -a 2,2,1,2,1
1
$ test-expr '\''a >= ((b != c) && (d || e))'\'' -a 0,0,1,0,1
0
$ test-expr '\''a >= ((b != c) && (d || e))'\'' -a 0,0,2,1,1
0
$ test-expr '\''a >= ((b != c) && (d || e))'\'' -a 0,1,1,0,0
1
$ test-expr '\''a >= ((b != c) && (d || e))'\'' -a 0,1,1,0,1
1
$ test-expr '\''a >= ((b != c) && (d || e))'\'' -a 0,1,1,1,1
1
$ test-expr '\''a >= ((b != c) && (d || e))'\'' -a 0,2,0,0,0
1
$ test-expr '\''a >= ((b != c) && (d || e))'\'' -a 1,0,2,2,0
1
$ test-expr '\''a >= ((b != c) && (d || e))'\'' -a 1,1,2,0,2
1
$ test-expr '\''a >= ((b != c) && (d || e))'\'' -a 1,1,2,2,1
1
$ test-expr '\''a >= ((b != c) && (d || e))'\'' -a 1,2,2,1,2
1
$ test-expr '\''a >= ((b != c) && (d || e))'\'' -a 2,0,1,2,0
1
$ test-expr '\''a >= ((b != c) && (d || e))'\'' -a 2,0,1,2,1
1
$ test-expr '\''a >= ((b != c) && (d || e))'\'' -a 2,0,2,2,2
1
$ test-expr '\''a >= ((b != c) && (d || e))'\'' -a 2,1,0,0,1
1
$ test-expr '\''a >= ((b != c) && (d || e))'\'' -a 2,1,0,1,0
1
$ test-expr '\''a >= ((b != c) && (d || e))'\'' -a 2,1,0,1,2
1
$ test-expr '\''a >= ((b != c) && (d || e))'\'' -a 2,1,1,2,2
1
$ test-expr '\''a >= ((b != c) && (d || e))'\'' -a 2,2,0,1,1
1
$ test-expr '\''a >= ((b != c) && (d || e))'\'' -a 2,2,1,0,0
1
$ test-expr '\''a >= ((b != c) && (d || e))'\'' -a 2,2,1,2,0
1
$ test-expr '\''a >= ((b != c) || (d && e))'\'' -a 0,0,0,1,0
1
$ test-expr '\''a >= ((b != c) || (d && e))'\'' -a 0,0,0,1,1
0
$ test-expr '\''a >= ((b != c) || (d && e))'\'' -a 0,0,0,2,0
1
$ test-expr '\''a >= ((b != c) || (d && e))'\'' -a 0,0,1,0,2
0
$ test-expr '\''a >= ((b != c) || (d && e))'\'' -a 0,0,2,0,1
0
$ test-expr '\''a >= ((b != c) || (d && e))'\'' -a 0,1,2,0,1
0
$ test-expr '\''a >= ((b != c) || (d && e))'\'' -a 0,1,2,1,0
0
$ test-expr '\''a >= ((b != c) || (d && e))'\'' -a 0,1,2,2,2
0
$ test-expr '\''a >= ((b != c) || (d && e))'\'' -a 0,2,2,0,1
1
$ test-expr '\''a >= ((b != c) || (d && e))'\'' -a 0,2,2,0,2
1
$ test-expr '\''a >= ((b != c) || (d && e))'\'' -a 0,2,2,1,2
0
$ test-expr '\''a >= ((b != c) || (d && e))'\'' -a 1,0,0,1,0
1
$ test-expr '\''a >= ((b != c) || (d && e))'\'' -a 1,0,0,1,2
1
$ test-expr '\''a >= ((b != c) || (d && e))'\'' -a 1,0,0,2,1
1
$ test-expr '\''a >= ((b != c) || (d && e))'\'' -a 1,0,1,1,0
1
$ test-expr '\''a >= ((b != c) || (d && e))'\'' -a 1,0,1,2,1
1
$ test-expr '\''a >= ((b != c) || (d && e))'\'' -a 1,0,2,1,2
1
$ test-expr '\''a >= ((b != c) || (d && e))'\'' -a 1,1,0,0,0
1
$ test-expr '\''a >= ((b != c) || (d && e))'\'' -a 1,1,0,1,1
1
$ test-expr '\''a >= ((b != c) || (d && e))'\'' -a 1,1,0,1,2
1
$ test-expr '\''a >= ((b != c) || (d && e))'\'' -a 1,1,1,1,2
1
$ test-expr '\''a >= ((b != c) || (d && e))'\'' -a 1,1,2,2,1
1
$ test-expr '\''a >= ((b != c) || (d && e))'\'' -a 1,2,0,0,2
1
$ test-expr '\''a >= ((b != c) || (d && e))'\'' -a 1,2,2,0,1
1
$ test-expr '\''a >= ((b != c) || (d && e))'\'' -a 1,2,2,1,0
1
$ test-expr '\''a >= ((b != c) || (d && e))'\'' -a 2,0,0,0,1
1
$ test-expr '\''a >= ((b != c) || (d && e))'\'' -a 2,0,0,0,2
1
$ test-expr '\''a >= ((b != c) || (d && e))'\'' -a 2,0,0,1,1
1
$ test-expr '\''a >= ((b != c) || (d && e))'\'' -a 2,0,1,0,0
1
$ test-expr '\''a >= ((b != c) || (d && e))'\'' -a 2,0,2,0,0
1
$ test-expr '\''a >= ((b != c) || (d && e))'\'' -a 2,0,2,1,1
1
$ test-expr '\''a >= ((b != c) || (d && e))'\'' -a 2,1,1,2,0
1
$ test-expr '\''a >= ((b != c) || (d && e))'\'' -a 2,1,2,1,1
1
$ test-expr '\''a >= ((b != c) || (d && e))'\'' -a 2,2,0,0,1
1
$ test-expr '\''a >= ((b != c) || (d && e))'\'' -a 2,2,0,1,2
1
$ test-expr '\''a >= ((b != c) || (d && e))'\'' -a 2,2,0,2,1
1
$ test-expr '\''a >= ((b != c) || (d && e))'\'' -a 2,2,1,0,0
1
$ test-expr '\''a >= ((b != c) || (d && e))'\'' -a 2,2,2,0,2
1
$ test-expr '\''a >= ((b != c) || (d && e))'\'' -a 2,2,2,2,0
1
$ test-expr '\''a >= ((b != (c && d)) || e)'\'' -a 0,0,1,0,0
1
$ test-expr '\''a >= ((b != (c && d)) || e)'\'' -a 0,0,1,1,2
0
$ test-expr '\''a >= ((b != (c && d)) || e)'\'' -a 0,0,2,2,0
0
$ test-expr '\''a >= ((b != (c && d)) || e)'\'' -a 0,1,0,0,2
0
$ test-expr '\''a >= ((b != (c && d)) || e)'\'' -a 0,2,1,0,1
0
$ test-expr '\''a >= ((b != (c && d)) || e)'\'' -a 0,2,2,0,0
0
$ test-expr '\''a >= ((b != (c && d)) || e)'\'' -a 1,0,0,2,2
1
$ test-expr '\''a >= ((b != (c && d)) || e)'\'' -a 1,0,2,0,1
1
$ test-expr '\''a >= ((b != (c && d)) || e)'\'' -a 1,0,2,0,2
1
$ test-expr '\''a >= ((b != (c && d)) || e)'\'' -a 1,0,2,1,1
1
$ test-expr '\''a >= ((b != (c && d)) || e)'\'' -a 1,1,0,0,2
1
$ test-expr '\''a >= ((b != (c && d)) || e)'\'' -a 1,1,0,1,1
1
$ test-expr '\''a >= ((b != (c && d)) || e)'\'' -a 1,1,1,0,1
1
$ test-expr '\''a >= ((b != (c && d)) || e)'\'' -a 1,1,2,0,2
1
$ test-expr '\''a >= ((b != (c && d)) || e)'\'' -a 1,2,1,1,1
1
$ test-expr '\''a >= ((b != (c && d)) || e)'\'' -a 1,2,2,0,0
1
$ test-expr '\''a >= ((b != (c && d)) || e)'\'' -a 1,2,2,1,0
1
$ test-expr '\''a >= ((b != (c && d)) || e)'\'' -a 1,2,2,2,0
1
$ test-expr '\''a >= ((b != (c && d)) || e)'\'' -a 1,2,2,2,1
1
$ test-expr '\''a >= ((b != (c && d)) || e)'\'' -a 1,2,2,2,2
1
$ test-expr '\''a >= ((b != (c && d)) || e)'\'' -a 2,0,0,0,0
1
$ test-expr '\''a >= ((b != (c && d)) || e)'\'' -a 2,0,0,1,2
1
$ test-expr '\''a >= ((b != (c && d)) || e)'\'' -a 2,0,1,1,1
1
$ test-expr '\''a >= ((b != (c && d)) || e)'\'' -a 2,0,1,2,0
1
$ test-expr '\''a >= ((b != (c && d)) || e)'\'' -a 2,0,2,1,2
1
$ test-expr '\''a >= ((b != (c && d)) || e)'\'' -a 2,1,0,0,1
1
$ test-expr '\''a >= ((b != (c && d)) || e)'\'' -a 2,1,2,0,0
1
$ test-expr '\''a >= ((b != (c && d)) || e)'\'' -a 2,1,2,0,2
1
$ test-expr '\''a >= ((b != (c && d)) || e)'\'' -a 2,1,2,1,0
1
$ test-expr '\''a >= ((b != (c || d)) && e)'\'' -a 0,0,0,0,2
1
$ test-expr '\''a >= ((b != (c || d)) && e)'\'' -a 0,0,0,1,2
0
$ test-expr '\''a >= ((b != (c || d)) && e)'\'' -a 0,0,1,0,0
1
$ test-expr '\''a >= ((b != (c || d)) && e)'\'' -a 0,0,1,0,1
0
$ test-expr '\''a >= ((b != (c || d)) && e)'\'' -a 0,0,1,2,1
0
$ test-expr '\''a >= ((b != (c || d)) && e)'\'' -a 0,0,2,0,1
0
$ test-expr '\''a >= ((b != (c || d)) && e)'\'' -a 0,1,0,0,1
0
$ test-expr '\''a >= ((b != (c || d)) && e)'\'' -a 0,1,0,1,1
1
$ test-expr '\''a >= ((b != (c || d)) && e)'\'' -a 0,1,1,2,2
1
$ test-expr '\''a >= ((b != (c || d)) && e)'\'' -a 1,0,1,2,1
1
$ test-expr '\''a >= ((b != (c || d)) && e)'\'' -a 1,0,2,1,2
1
$ test-expr '\''a >= ((b != (c || d)) && e)'\'' -a 1,1,1,0,0
1
$ test-expr '\''a >= ((b != (c || d)) && e)'\'' -a 1,1,1,1,0
1
$ test-expr '\''a >= ((b != (c || d)) && e)'\'' -a 1,1,1,2,1
1
$ test-expr '\''a >= ((b != (c || d)) && e)'\'' -a 1,1,2,0,0
1
$ test-expr '\''a >= ((b != (c || d)) && e)'\'' -a 1,2,0,2,0
1
$ test-expr '\''a >= ((b != (c || d)) && e)'\'' -a 2,0,2,0,2
1
$ test-expr '\''a >= ((b != (c || d)) && e)'\'' -a 2,1,1,2,2
1
$ test-expr '\''a >= ((b != (c || d)) && e)'\'' -a 2,1,2,2,1
1
$ test-expr '\''a >= ((b != (c || d)) && e)'\'' -a 2,1,2,2,2
1
$ test-expr '\''a >= ((b != (c || d)) && e)'\'' -a 2,2,0,0,1
1
$ test-expr '\''a >= ((b != (c || d)) && e)'\'' -a 2,2,1,1,2
1
$ test-expr '\''a >= ((b != (c || d)) && e)'\'' -a 2,2,1,2,2
1
$ test-expr '\''a >= ((b && c) != (d || e))'\'' -a 0,0,0,1,2
0
$ test-expr '\''a >= ((b && c) != (d || e))'\'' -a 0,0,1,1,2
0
$ test-expr '\''a >= ((b && c) != (d || e))'\'' -a 0,0,2,1,1
0
$ test-expr '\''a >= ((b && c) != (d || e))'\'' -a 0,1,0,0,2
0
$ test-expr '\''a >= ((b && c) != (d || e))'\'' -a 0,1,0,1,2
0
$ test-expr '\''a >= ((b && c) != (d || e))'\'' -a 0,1,0,2,1
0
$ test-expr '\''a >= ((b && c) != (d || e))'\'' -a 0,1,2,2,0
1
$ test-expr '\''a >= ((b && c) != (d || e))'\'' -a 0,2,1,0,1
1
$ test-expr '\''a >= ((b && c) != (d || e))'\'' -a 0,2,2,2,0
1
$ test-expr '\''a >= ((b && c) != (d || e))'\'' -a 0,2,2,2,1
1
$ test-expr '\''a >= ((b && c) != (d || e))'\'' -a 1,0,0,0,1
1
$ test-expr '\''a >= ((b && c) != (d || e))'\'' -a 1,0,0,2,1
1
$ test-expr '\''a >= ((b && c) != (d || e))'\'' -a 1,0,1,2,0
1
$ test-expr '\''a >= ((b && c) != (d || e))'\'' -a 1,0,2,0,0
1
$ test-expr '\''a >= ((b && c) != (d || e))'\'' -a 1,0,2,0,1
1
$ test-expr '\''a >= ((b && c) != (d || e))'\'' -a 1,1,0,1,2
1
$ test-expr '\''a >= ((b && c) != (d || e))'\'' -a 1,1,1,2,0
1
$ test-expr '\''a >= ((b && c) != (d || e))'\'' -a 1,1,2,1,1
1
$ test-expr '\''a >= ((b && c) != (d || e))'\'' -a 1,1,2,2,1
1
$ test-expr '\''a >= ((b && c) != (d || e))'\'' -a 1,2,0,0,1
1
$ test-expr '\''a >= ((b && c) != (d || e))'\'' -a 1,2,1,0,2
1
$ test-expr '\''a >= ((b && c) != (d || e))'\'' -a 1,2,2,0,1
1
$ test-expr '\''a >= ((b && c) != (d || e))'\'' -a 1,2,2,1,2
1
$ test-expr '\''a >= ((b && c) != (d || e))'\'' -a 1,2,2,2,2
1
$ test-expr '\''a >= ((b && c) != (d || e))'\'' -a 2,0,0,2,0
1
$ test-expr '\''a >= ((b && c) != (d || e))'\'' -a 2,0,1,0,2
1
$ test-expr '\''a >= ((b && c) != (d || e))'\'' -a 2,1,1,2,1
1
$ test-expr '\''a >= ((b && c) != (d || e))'\'' -a 2,2,0,0,2
1
$ test-expr '\''a >= ((b && c) != (d || e))'\'' -a 2,2,2,0,1
1
$ test-expr '\''a >= ((b && c) != (d || e))'\'' -a 2,2,2,1,2
1
$ test-expr '\''a >= ((b && c) != (d || e))'\'' -a 2,2,2,2,1
1
$ test-expr '\''a >= ((b && c) || (d != e))'\'' -a 0,0,0,1,2
0
$ test-expr '\''a >= ((b && c) || (d != e))'\'' -a 0,0,1,0,1
0
$ test-expr '\''a >= ((b && c) || (d != e))'\'' -a 0,0,2,1,1
1
$ test-expr '\''a >= ((b && c) || (d != e))'\'' -a 0,1,0,1,0
0
$ test-expr '\''a >= ((b && c) || (d != e))'\'' -a 0,1,0,1,2
0
$ test-expr '\''a >= ((b && c) || (d != e))'\'' -a 0,1,1,2,2
0
$ test-expr '\''a >= ((b && c) || (d != e))'\'' -a 0,2,0,1,1
1
$ test-expr '\''a >= ((b && c) || (d != e))'\'' -a 0,2,0,2,1
0
$ test-expr '\''a >= ((b && c) || (d != e))'\'' -a 0,2,1,1,0
0
$ test-expr '\''a >= ((b && c) || (d != e))'\'' -a 0,2,2,0,2
0
$ test-expr '\''a >= ((b && c) || (d != e))'\'' -a 1,0,1,1,1
1
$ test-expr '\''a >= ((b && c) || (d != e))'\'' -a 1,1,2,1,0
1
$ test-expr '\''a >= ((b && c) || (d != e))'\'' -a 1,2,0,1,1
1
$ test-expr '\''a >= ((b && c) || (d != e))'\'' -a 1,2,0,1,2
1
$ test-expr '\''a >= ((b && c) || (d != e))'\'' -a 1,2,0,2,1
1
$ test-expr '\''a >= ((b && c) || (d != e))'\'' -a 1,2,1,2,1
1
$ test-expr '\''a >= ((b && c) || (d != e))'\'' -a 1,2,2,0,2
1
$ test-expr '\''a >= ((b && c) || (d != e))'\'' -a 1,2,2,2,1
1
$ test-expr '\''a >= ((b && c) || (d != e))'\'' -a 2,0,2,2,2
1
$ test-expr '\''a >= ((b && c) || (d != e))'\'' -a 2,2,0,0,0
1
$ test-expr '\''a >= ((b && c) || (d != e))'\'' -a 2,2,2,0,2
1
$ test-expr '\''a >= ((b && (c != d)) || e)'\'' -a 0,0,0,1,1
0
$ test-expr '\''a >= ((b && (c != d)) || e)'\'' -a 0,0,0,2,1
0
$ test-expr '\''a >= ((b && (c != d)) || e)'\'' -a 0,0,0,2,2
0
$ test-expr '\''a >= ((b && (c != d)) || e)'\'' -a 0,0,1,0,1
0
$ test-expr '\''a >= ((b && (c != d)) || e)'\'' -a 0,0,1,1,0
1
$ test-expr '\''a >= ((b && (c != d)) || e)'\'' -a 0,0,2,0,2
0
$ test-expr '\''a >= ((b && (c != d)) || e)'\'' -a 0,0,2,2,0
1
$ test-expr '\''a >= ((b && (c != d)) || e)'\'' -a 0,1,1,1,1
0
$ test-expr '\''a >= ((b && (c != d)) || e)'\'' -a 0,1,1,2,1
0
$ test-expr '\''a >= ((b && (c != d)) || e)'\'' -a 0,1,1,2,2
0
$ test-expr '\''a >= ((b && (c != d)) || e)'\'' -a 0,2,1,1,0
1
$ test-expr '\''a >= ((b && (c != d)) || e)'\'' -a 0,2,2,0,1
0
$ test-expr '\''a >= ((b && (c != d)) || e)'\'' -a 1,0,0,0,0
1
$ test-expr '\''a >= ((b && (c != d)) || e)'\'' -a 1,0,0,2,0
1
$ test-expr '\''a >= ((b && (c != d)) || e)'\'' -a 1,0,1,2,2
1
$ test-expr '\''a >= ((b && (c != d)) || e)'\'' -a 1,0,2,0,0
1
$ test-expr '\''a >= ((b && (c != d)) || e)'\'' -a 1,1,0,1,1
1
$ test-expr '\''a >= ((b && (c != d)) || e)'\'' -a 1,1,2,2,1
1
$ test-expr '\''a >= ((b && (c != d)) || e)'\'' -a 1,2,1,0,1
1
$ test-expr '\''a >= ((b && (c != d)) || e)'\'' -a 1,2,2,0,1
1
$ test-expr '\''a >= ((b && (c != d)) || e)'\'' -a 1,2,2,2,0
1
$ test-expr '\''a >= ((b && (c != d)) || e)'\'' -a 2,0,0,2,1
1
$ test-expr '\''a >= ((b && (c != d)) || e)'\'' -a 2,0,1,2,1
1
$ test-expr '\''a >= ((b && (c != d)) || e)'\'' -a 2,0,1,2,2
1
$ test-expr '\''a >= ((b && (c != d)) || e)'\'' -a 2,0,2,0,0
1
$ test-expr '\''a >= ((b && (c != d)) || e)'\'' -a 2,0,2,0,1
1
$ test-expr '\''a >= ((b && (c != d)) || e)'\'' -a 2,1,2,0,0
1
$ test-expr '\''a >= ((b && (c != d)) || e)'\'' -a 2,1,2,1,0
1
$ test-expr '\''a >= ((b && (c != d)) || e)'\'' -a 2,2,0,1,0
1
$ test-expr '\''a >= ((b && (c != d)) || e)'\'' -a 2,2,0,1,1
1
$ test-expr '\''a >= ((b && (c != d)) || e)'\'' -a 2,2,0,2,2
1
$ test-expr '\''a >= ((b && (c || d)) != e)'\'' -a 0,0,1,1,0
1
$ test-expr '\''a >= ((b && (c || d)) != e)'\'' -a 0,0,2,2,0
1
$ test-expr '\''a >= ((b && (c || d)) != e)'\'' -a 0,1,0,2,1
1
$ test-expr '\''a >= ((b && (c || d)) != e)'\'' -a 0,1,1,2,0
0
$ test-expr '\''a >= ((b && (c || d)) != e)'\'' -a 0,2,0,1,0
0
$ test-expr '\''a >= ((b && (c || d)) != e)'\'' -a 0,2,1,2,1
1
$ test-expr '\''a >= ((b && (c || d)) != e)'\'' -a 0,2,2,2,1
1
$ test-expr '\''a >= ((b && (c || d)) != e)'\'' -a 1,0,0,2,2
1
$ test-expr '\''a >= ((b && (c || d)) != e)'\'' -a 1,1,0,1,1
1
$ test-expr '\''a >= ((b && (c || d)) != e)'\'' -a 1,1,1,1,0
1
$ test-expr '\''a >= ((b && (c || d)) != e)'\'' -a 1,2,0,0,1
1
$ test-expr '\''a >= ((b && (c || d)) != e)'\'' -a 1,2,1,1,2
1
$ test-expr '\''a >= ((b && (c || d)) != e)'\'' -a 2,0,2,1,0
1
$ test-expr '\''a >= ((b && (c || d)) != e)'\'' -a 2,0,2,2,0
1
$ test-expr '\''a >= ((b && (c || d)) != e)'\'' -a 2,0,2,2,1
1
$ test-expr '\''a >= ((b && (c || d)) != e)'\'' -a 2,1,0,2,0
1
$ test-expr '\''a >= ((b && (c || d)) != e)'\'' -a 2,2,0,1,2
1
$ test-expr '\''a >= ((b || c) != (d && e))'\'' -a 0,0,0,0,1
1
$ test-expr '\''a >= ((b || c) != (d && e))'\'' -a 0,0,1,1,2
1
$ test-expr '\''a >= ((b || c) != (d && e))'\'' -a 0,1,0,1,2
1
$ test-expr '\''a >= ((b || c) != (d && e))'\'' -a 0,1,1,0,1
0
$ test-expr '\''a >= ((b || c) != (d && e))'\'' -a 0,1,1,2,2
1
$ test-expr '\''a >= ((b || c) != (d && e))'\'' -a 0,2,1,2,1
1
$ test-expr '\''a >= ((b || c) != (d && e))'\'' -a 0,2,2,0,0
0
$ test-expr '\''a >= ((b || c) != (d && e))'\'' -a 1,0,0,2,0
1
$ test-expr '\''a >= ((b || c) != (d && e))'\'' -a 1,0,0,2,1
1
$ test-expr '\''a >= ((b || c) != (d && e))'\'' -a 1,0,1,0,2
1
$ test-expr '\''a >= ((b || c) != (d && e))'\'' -a 1,0,2,2,0
1
$ test-expr '\''a >= ((b || c) != (d && e))'\'' -a 1,1,0,0,0
1
$ test-expr '\''a >= ((b || c) != (d && e))'\'' -a 1,1,0,2,2
1
$ test-expr '\''a >= ((b || c) != (d && e))'\'' -a 1,1,1,2,2
1
$ test-expr '\''a >= ((b || c) != (d && e))'\'' -a 1,1,2,1,1
1
$ test-expr '\''a >= ((b || c) != (d && e))'\'' -a 1,1,2,2,1
1
$ test-expr '\''a >= ((b || c) != (d && e))'\'' -a 1,2,0,2,2
1
$ test-expr '\''a >= ((b || c) != (d && e))'\'' -a 1,2,1,1,2
1
$ test-expr '\''a >= ((b || c) != (d && e))'\'' -a 1,2,2,0,0
1
$ test-expr '\''a >= ((b || c) != (d && e))'\'' -a 1,2,2,0,1
1
$ test-expr '\''a >= ((b || c) != (d && e))'\'' -a 2,0,1,1,2
1
$ test-expr '\''a >= ((b || c) != (d && e))'\'' -a 2,0,1,2,1
1
$ test-expr '\''a >= ((b || c) != (d && e))'\'' -a 2,0,2,0,1
1
$ test-expr '\''a >= ((b || c) != (d && e))'\'' -a 2,0,2,1,1
1
$ test-expr '\''a >= ((b || c) != (d && e))'\'' -a 2,0,2,1,2
1
$ test-expr '\''a >= ((b || c) != (d && e))'\'' -a 2,2,0,2,1
1
$ test-expr '\''a >= ((b || c) != (d && e))'\'' -a 2,2,1,1,0
1
$ test-expr '\''a >= ((b || c) != (d && e))'\'' -a 2,2,1,1,1
1
$ test-expr '\''a >= ((b || c) != (d && e))'\'' -a 2,2,2,1,0
1
$ test-expr '\''a >= ((b || c) && (d != e))'\'' -a 0,0,1,1,1
1
$ test-expr '\''a >= ((b || c) && (d != e))'\'' -a 0,0,2,2,1
0
$ test-expr '\''a >= ((b || c) && (d != e))'\'' -a 0,2,0,2,0
0
$ test-expr '\''a >= ((b || c) && (d != e))'\'' -a 0,2,0,2,2
1
$ test-expr '\''a >= ((b || c) && (d != e))'\'' -a 0,2,1,0,2
0
$ test-expr '\''a >= ((b || c) && (d != e))'\'' -a 0,2,1,1,1
1
$ test-expr '\''a >= ((b || c) && (d != e))'\'' -a 0,2,1,2,2
1
$ test-expr '\''a >= ((b || c) && (d != e))'\'' -a 0,2,2,2,2
1
$ test-expr '\''a >= ((b || c) && (d != e))'\'' -a 1,0,0,0,0
1
$ test-expr '\''a >= ((b || c) && (d != e))'\'' -a 1,0,1,1,2
1
$ test-expr '\''a >= ((b || c) && (d != e))'\'' -a 1,0,2,2,1
1
$ test-expr '\''a >= ((b || c) && (d != e))'\'' -a 1,0,2,2,2
1
$ test-expr '\''a >= ((b || c) && (d != e))'\'' -a 1,1,0,1,2
1
$ test-expr '\''a >= ((b || c) && (d != e))'\'' -a 1,1,2,0,0
1
$ test-expr '\''a >= ((b || c) && (d != e))'\'' -a 1,1,2,0,1
1
$ test-expr '\''a >= ((b || c) && (d != e))'\'' -a 1,1,2,1,0
1
$ test-expr '\''a >= ((b || c) && (d != e))'\'' -a 1,1,2,1,2
1
$ test-expr '\''a >= ((b || c) && (d != e))'\'' -a 1,2,0,0,0
1
$ test-expr '\''a >= ((b || c) && (d != e))'\'' -a 1,2,0,0,1
1
$ test-expr '\''a >= ((b || c) && (d != e))'\'' -a 1,2,2,1,2
1
$ test-expr '\''a >= ((b || c) && (d != e))'\'' -a 2,0,0,2,2
1
$ test-expr '\''a >= ((b || c) && (d != e))'\'' -a 2,0,1,2,0
1
$ test-expr '\''a >= ((b || c) && (d != e))'\'' -a 2,0,2,0,2
1
$ test-expr '\''a >= ((b || c) && (d != e))'\'' -a 2,0,2,1,1
1
$ test-expr '\''a >= ((b || c) && (d != e))'\'' -a 2,1,2,2,2
1
$ test-expr '\''a >= ((b || c) && (d != e))'\'' -a 2,2,0,0,0
1
$ test-expr '\''a >= ((b || c) && (d != e))'\'' -a 2,2,1,0,0
1
$ test-expr '\''a >= ((b || c) && (d != e))'\'' -a 2,2,1,1,1
1
$ test-expr '\''a >= ((b || c) && (d != e))'\'' -a 2,2,1,2,0
1
$ test-expr '\''a >= ((b || c) && (d != e))'\'' -a 2,2,2,2,1
1
$ test-expr '\''a >= ((b || (c != d)) && e)'\'' -a 0,0,1,1,2
1
$ test-expr '\''a >= ((b || (c != d)) && e)'\'' -a 0,0,1,2,0
1
$ test-expr '\''a >= ((b || (c != d)) && e)'\'' -a 0,0,1,2,2
0
$ test-expr '\''a >= ((b || (c != d)) && e)'\'' -a 0,0,2,2,2
1
$ test-expr '\''a >= ((b || (c != d)) && e)'\'' -a 0,1,1,1,2
0
$ test-expr '\''a >= ((b || (c != d)) && e)'\'' -a 0,1,2,1,0
1
$ test-expr '\''a >= ((b || (c != d)) && e)'\'' -a 0,1,2,2,1
0
$ test-expr '\''a >= ((b || (c != d)) && e)'\'' -a 0,2,0,1,1
0
$ test-expr '\''a >= ((b || (c != d)) && e)'\'' -a 0,2,2,2,2
0
$ test-expr '\''a >= ((b || (c != d)) && e)'\'' -a 1,0,0,2,0
1
$ test-expr '\''a >= ((b || (c != d)) && e)'\'' -a 1,0,0,2,2
1
$ test-expr '\''a >= ((b || (c != d)) && e)'\'' -a 1,0,2,1,2
1
$ test-expr '\''a >= ((b || (c != d)) && e)'\'' -a 1,1,2,0,1
1
$ test-expr '\''a >= ((b || (c != d)) && e)'\'' -a 1,2,0,0,0
1
$ test-expr '\''a >= ((b || (c != d)) && e)'\'' -a 1,2,1,2,0
1
$ test-expr '\''a >= ((b || (c != d)) && e)'\'' -a 1,2,2,0,0
1
$ test-expr '\''a >= ((b || (c != d)) && e)'\'' -a 1,2,2,0,1
1
$ test-expr '\''a >= ((b || (c != d)) && e)'\'' -a 2,0,0,1,2
1
$ test-expr '\''a >= ((b || (c != d)) && e)'\'' -a 2,0,2,0,2
1
$ test-expr '\''a >= ((b || (c != d)) && e)'\'' -a 2,0,2,1,2
1
$ test-expr '\''a >= ((b || (c != d)) && e)'\'' -a 2,1,2,1,0
1
$ test-expr '\''a >= ((b || (c != d)) && e)'\'' -a 2,2,0,1,2
1
$ test-expr '\''a >= ((b || (c != d)) && e)'\'' -a 2,2,2,1,1
1
$ test-expr '\''a >= ((b || (c != d)) && e)'\'' -a 2,2,2,2,1
1
$ test-expr '\''a >= ((b || (c && d)) != e)'\'' -a 0,0,1,0,0
1
$ test-expr '\''a >= ((b || (c && d)) != e)'\'' -a 0,0,1,1,2
0
$ test-expr '\''a >= ((b || (c && d)) != e)'\'' -a 0,0,2,1,2
0
$ test-expr '\''a >= ((b || (c && d)) != e)'\'' -a 0,1,1,1,1
1
$ test-expr '\''a >= ((b || (c && d)) != e)'\'' -a 0,1,2,0,1
1
$ test-expr '\''a >= ((b || (c && d)) != e)'\'' -a 0,2,0,0,0
0
$ test-expr '\''a >= ((b || (c && d)) != e)'\'' -a 0,2,0,0,1
1
$ test-expr '\''a >= ((b || (c && d)) != e)'\'' -a 0,2,0,1,0
0
$ test-expr '\''a >= ((b || (c && d)) != e)'\'' -a 0,2,1,2,2
0
$ test-expr '\''a >= ((b || (c && d)) != e)'\'' -a 0,2,2,1,1
1
$ test-expr '\''a >= ((b || (c && d)) != e)'\'' -a 1,0,0,0,1
1
$ test-expr '\''a >= ((b || (c && d)) != e)'\'' -a 1,1,0,0,0
1
$ test-expr '\''a >= ((b || (c && d)) != e)'\'' -a 1,1,0,2,2
1
$ test-expr '\''a >= ((b || (c && d)) != e)'\'' -a 1,1,1,1,2
1
$ test-expr '\''a >= ((b || (c && d)) != e)'\'' -a 1,1,1,2,0
1
$ test-expr '\''a >= ((b || (c && d)) != e)'\'' -a 1,2,0,2,1
1
$ test-expr '\''a >= ((b || (c && d)) != e)'\'' -a 1,2,1,2,0
1
$ test-expr '\''a >= ((b || (c && d)) != e)'\'' -a 1,2,2,1,2
1
$ test-expr '\''a >= ((b || (c && d)) != e)'\'' -a 2,0,1,0,0
1
$ test-expr '\''a >= ((b || (c && d)) != e)'\'' -a 2,0,1,0,2
1
$ test-expr '\''a >= ((b || (c && d)) != e)'\'' -a 2,0,1,1,0
1
$ test-expr '\''a >= ((b || (c && d)) != e)'\'' -a 2,0,1,2,0
1
$ test-expr '\''a >= ((b || (c && d)) != e)'\'' -a 2,0,2,0,2
1
$ test-expr '\''a >= ((b || (c && d)) != e)'\'' -a 2,1,1,0,1
1
$ test-expr '\''a >= ((b || (c && d)) != e)'\'' -a 2,1,2,1,1
1
$ test-expr '\''a >= ((b || (c && d)) != e)'\'' -a 2,2,0,1,0
1
$ test-expr '\''a >= ((b || (c && d)) != e)'\'' -a 2,2,0,1,1
1
$ test-expr '\''a >= ((b || (c && d)) != e)'\'' -a 2,2,1,0,2
1
$ test-expr '\''a >= ((b || (c && d)) != e)'\'' -a 2,2,2,1,1
1
$ test-expr '\''a >= (((b != c) && d) || e)'\'' -a 0,0,0,1,0
1
$ test-expr '\''a >= (((b != c) && d) || e)'\'' -a 0,0,0,2,1
0
$ test-expr '\''a >= (((b != c) && d) || e)'\'' -a 0,0,0,2,2
0
$ test-expr '\''a >= (((b != c) && d) || e)'\'' -a 0,0,2,0,2
0
$ test-expr '\''a >= (((b != c) && d) || e)'\'' -a 0,0,2,2,0
0
$ test-expr '\''a >= (((b != c) && d) || e)'\'' -a 0,1,0,0,2
0
$ test-expr '\''a >= (((b != c) && d) || e)'\'' -a 0,1,1,2,0
1
$ test-expr '\''a >= (((b != c) && d) || e)'\'' -a 0,1,2,0,0
1
$ test-expr '\''a >= (((b != c) && d) || e)'\'' -a 0,1,2,2,2
0
$ test-expr '\''a >= (((b != c) && d) || e)'\'' -a 0,2,0,1,1
0
$ test-expr '\''a >= (((b != c) && d) || e)'\'' -a 0,2,1,0,0
1
$ test-expr '\''a >= (((b != c) && d) || e)'\'' -a 0,2,1,1,2
0
$ test-expr '\''a >= (((b != c) && d) || e)'\'' -a 0,2,2,1,2
0
$ test-expr '\''a >= (((b != c) && d) || e)'\'' -a 1,0,0,0,2
1
$ test-expr '\''a >= (((b != c) && d) || e)'\'' -a 1,0,0,1,1
1
$ test-expr '\''a >= (((b != c) && d) || e)'\'' -a 1,0,1,1,0
1
$ test-expr '\''a >= (((b != c) && d) || e)'\'' -a 1,0,1,2,0
1
$ test-expr '\''a >= (((b != c) && d) || e)'\'' -a 1,0,2,1,2
1
$ test-expr '\''a >= (((b != c) && d) || e)'\'' -a 1,0,2,2,2
1
$ test-expr '\''a >= (((b != c) && d) || e)'\'' -a 1,1,0,1,0
1
$ test-expr '\''a >= (((b != c) && d) || e)'\'' -a 1,1,0,1,1
1
$ test-expr '\''a >= (((b != c) && d) || e)'\'' -a 1,1,0,2,1
1
$ test-expr '\''a >= (((b != c) && d) || e)'\'' -a 1,1,1,2,0
1
$ test-expr '\''a >= (((b != c) && d) || e)'\'' -a 1,2,0,2,0
1
$ test-expr '\''a >= (((b != c) && d) || e)'\'' -a 1,2,1,0,1
1
$ test-expr '\''a >= (((b != c) && d) || e)'\'' -a 1,2,1,1,2
1
$ test-expr '\''a >= (((b != c) && d) || e)'\'' -a 1,2,2,0,0
1
$ test-expr '\''a >= (((b != c) && d) || e)'\'' -a 2,0,1,0,1
1
$ test-expr '\''a >= (((b != c) && d) || e)'\'' -a 2,0,1,1,2
1
$ test-expr '\''a >= (((b != c) && d) || e)'\'' -a 2,0,2,2,2
1
$ test-expr '\''a >= (((b != c) && d) || e)'\'' -a 2,1,0,2,0
1
$ test-expr '\''a >= (((b != c) && d) || e)'\'' -a 2,2,2,0,0
1
$ test-expr '\''a >= (((b != c) || d) && e)'\'' -a 0,0,1,1,2
0
$ test-expr '\''a >= (((b != c) || d) && e)'\'' -a 0,0,1,2,0
1
$ test-expr '\''a >= (((b != c) || d) && e)'\'' -a 0,0,2,2,0
1
$ test-expr '\''a >= (((b != c) || d) && e)'\'' -a 0,1,0,0,0
1
$ test-expr '\''a >= (((b != c) || d) && e)'\'' -a 0,1,0,1,2
0
$ test-expr '\''a >= (((b != c) || d) && e)'\'' -a 0,1,1,0,2
1
$ test-expr '\''a >= (((b != c) || d) && e)'\'' -a 0,1,2,0,2
0
$ test-expr '\''a >= (((b != c) || d) && e)'\'' -a 1,0,0,0,0
1
$ test-expr '\''a >= (((b != c) || d) && e)'\'' -a 1,0,0,1,0
1
$ test-expr '\''a >= (((b != c) || d) && e)'\'' -a 1,0,1,0,1
1
$ test-expr '\''a >= (((b != c) || d) && e)'\'' -a 1,1,1,0,0
1
$ test-expr '\''a >= (((b != c) || d) && e)'\'' -a 1,1,1,0,2
1
$ test-expr '\''a >= (((b != c) || d) && e)'\'' -a 1,1,2,1,2
1
$ test-expr '\''a >= (((b != c) || d) && e)'\'' -a 1,1,2,2,2
1
$ test-expr '\''a >= (((b != c) || d) && e)'\'' -a 1,2,0,2,1
1
$ test-expr '\''a >= (((b != c) || d) && e)'\'' -a 1,2,1,0,0
1
$ test-expr '\''a >= (((b != c) || d) && e)'\'' -a 1,2,1,2,2
1
$ test-expr '\''a >= (((b != c) || d) && e)'\'' -a 1,2,2,0,0
1
$ test-expr '\''a >= (((b != c) || d) && e)'\'' -a 1,2,2,2,0
1
$ test-expr '\''a >= (((b != c) || d) && e)'\'' -a 1,2,2,2,1
1
$ test-expr '\''a >= (((b != c) || d) && e)'\'' -a 2,0,0,2,2
1
$ test-expr '\''a >= (((b != c) || d) && e)'\'' -a 2,0,1,0,2
1
$ test-expr '\''a >= (((b != c) || d) && e)'\'' -a 2,0,1,1,1
1
$ test-expr '\''a >= (((b != c) || d) && e)'\'' -a 2,1,0,0,0
1
$ test-expr '\''a >= (((b != c) || d) && e)'\'' -a 2,1,0,2,0
1
$ test-expr '\''a >= (((b != c) || d) && e)'\'' -a 2,1,1,0,1
1
$ test-expr '\''a >= (((b != c) || d) && e)'\'' -a 2,1,1,2,2
1
$ test-expr '\''a >= (((b != c) || d) && e)'\'' -a 2,2,0,1,2
1
$ test-expr '\''a >= (((b != c) || d) && e)'\'' -a 2,2,2,0,0
1
$ test-expr '\''a >= (((b != c) || d) && e)'\'' -a 2,2,2,2,1
1
$ test-expr '\''a >= (((b && c) != d) || e)'\'' -a 0,0,0,1,0
0
$ test-expr '\''a >= (((b && c) != d) || e)'\'' -a 0,0,1,0,1
0
$ test-expr '\''a >= (((b && c) != d) || e)'\'' -a 0,0,1,1,2
0
$ test-expr '\''a >= (((b && c) != d) || e)'\'' -a 0,0,1,2,1
0
$ test-expr '\''a >= (((b && c) != d) || e)'\'' -a 0,0,2,0,2
0
$ test-expr '\''a >= (((b && c) != d) || e)'\'' -a 0,1,2,0,2
0
$ test-expr '\''a >= (((b && c) != d) || e)'\'' -a 0,1,2,2,1
0
$ test-expr '\''a >= (((b && c) != d) || e)'\'' -a 0,2,0,1,1
0
$ test-expr '\''a >= (((b && c) != d) || e)'\'' -a 0,2,1,1,1
0
$ test-expr '\''a >= (((b && c) != d) || e)'\'' -a 0,2,2,0,0
0
$ test-expr '\''a >= (((b && c) != d) || e)'\'' -a 0,2,2,2,0
0
$ test-expr '\''a >= (((b && c) != d) || e)'\'' -a 1,0,2,1,0
1
$ test-expr '\''a >= (((b && c) != d) || e)'\'' -a 1,0,2,2,0
1
$ test-expr '\''a >= (((b && c) != d) || e)'\'' -a 1,1,0,1,1
1
$ test-expr '\''a >= (((b && c) != d) || e)'\'' -a 1,1,0,2,0
1
$ test-expr '\''a >= (((b && c) != d) || e)'\'' -a 1,1,1,0,1
1
$ test-expr '\''a >= (((b && c) != d) || e)'\'' -a 1,1,1,0,2
1
$ test-expr '\''a >= (((b && c) != d) || e)'\'' -a 1,1,1,1,1
1
$ test-expr '\''a >= (((b && c) != d) || e)'\'' -a 1,1,2,2,1
1
$ test-expr '\''a >= (((b && c) != d) || e)'\'' -a 1,2,0,1,0
1
$ test-expr '\''a >= (((b && c) != d) || e)'\'' -a 1,2,1,2,1
1
$ test-expr '\''a >= (((b && c) != d) || e)'\'' -a 1,2,2,2,1
1
$ test-expr '\''a >= (((b && c) != d) || e)'\'' -a 2,0,0,0,0
1
$ test-expr '\''a >= (((b && c) != d) || e)'\'' -a 2,0,2,1,0
1
$ test-expr '\''a >= (((b && c) != d) || e)'\'' -a 2,0,2,2,2
1
$ test-expr '\''a >= (((b && c) != d) || e)'\'' -a 2,1,0,0,0
1
$ test-expr '\''a >= (((b && c) != d) || e)'\'' -a 2,1,0,1,0
1
$ test-expr '\''a >= (((b && c) != d) || e)'\'' -a 2,1,0,1,2
1
$ test-expr '\''a >= (((b && c) != d) || e)'\'' -a 2,1,1,2,0
1
$ test-expr '\''a >= (((b && c) != d) || e)'\'' -a 2,2,0,2,1
1
$ test-expr '\''a >= (((b && c) || d) != e)'\'' -a 0,0,1,0,1
0
$ test-expr '\''a >= (((b && c) || d) != e)'\'' -a 0,0,1,1,0
0
$ test-expr '\''a >= (((b && c) || d) != e)'\'' -a 0,1,1,0,0
0
$ test-expr '\''a >= (((b && c) || d) != e)'\'' -a 0,1,2,1,0
0
$ test-expr '\''a >= (((b && c) || d) != e)'\'' -a 0,1,2,2,0
0
$ test-expr '\''a >= (((b && c) || d) != e)'\'' -a 1,0,0,0,0
1
$ test-expr '\''a >= (((b && c) || d) != e)'\'' -a 1,0,0,0,2
1
$ test-expr '\''a >= (((b && c) || d) != e)'\'' -a 1,0,1,0,1
1
$ test-expr '\''a >= (((b && c) || d) != e)'\'' -a 1,0,1,2,0
1
$ test-expr '\''a >= (((b && c) || d) != e)'\'' -a 1,0,2,2,2
1
$ test-expr '\''a >= (((b && c) || d) != e)'\'' -a 1,1,0,1,2
1
$ test-expr '\''a >= (((b && c) || d) != e)'\'' -a 1,1,1,1,0
1
$ test-expr '\''a >= (((b && c) || d) != e)'\'' -a 1,2,0,0,0
1
$ test-expr '\''a >= (((b && c) || d) != e)'\'' -a 1,2,0,0,2
1
$ test-expr '\''a >= (((b && c) || d) != e)'\'' -a 1,2,1,1,0
1
$ test-expr '\''a >= (((b && c) || d) != e)'\'' -a 1,2,1,2,1
1
$ test-expr '\''a >= (((b && c) || d) != e)'\'' -a 2,0,2,1,0
1
$ test-expr '\''a >= (((b && c) || d) != e)'\'' -a 2,0,2,2,2
1
$ test-expr '\''a >= (((b && c) || d) != e)'\'' -a 2,1,1,0,1
1
$ test-expr '\''a >= (((b && c) || d) != e)'\'' -a 2,1,1,1,0
1
$ test-expr '\''a >= (((b || c) != d) && e)'\'' -a 0,0,0,0,0
1
$ test-expr '\''a >= (((b || c) != d) && e)'\'' -a 0,0,0,0,1
1
$ test-expr '\''a >= (((b || c) != d) && e)'\'' -a 0,0,0,0,2
1
$ test-expr '\''a >= (((b || c) != d) && e)'\'' -a 0,0,0,1,0
1
$ test-expr '\''a >= (((b || c) != d) && e)'\'' -a 0,1,1,1,1
1
$ test-expr '\''a >= (((b || c) != d) && e)'\'' -a 0,1,1,1,2
1
$ test-expr '\''a >= (((b || c) != d) && e)'\'' -a 0,2,1,0,2
0
$ test-expr '\''a >= (((b || c) != d) && e)'\'' -a 0,2,1,1,2
1
$ test-expr '\''a >= (((b || c) != d) && e)'\'' -a 0,2,2,0,1
0
$ test-expr '\''a >= (((b || c) != d) && e)'\'' -a 1,0,2,0,1
1
$ test-expr '\''a >= (((b || c) != d) && e)'\'' -a 1,0,2,0,2
1
$ test-expr '\''a >= (((b || c) != d) && e)'\'' -a 1,2,0,1,2
1
$ test-expr '\''a >= (((b || c) != d) && e)'\'' -a 1,2,1,1,2
1
$ test-expr '\''a >= (((b || c) != d) && e)'\'' -a 1,2,1,2,2
1
$ test-expr '\''a >= (((b || c) != d) && e)'\'' -a 1,2,2,0,0
1
$ test-expr '\''a >= (((b || c) != d) && e)'\'' -a 1,2,2,2,0
1
$ test-expr '\''a >= (((b || c) != d) && e)'\'' -a 2,0,0,0,0
1
$ test-expr '\''a >= (((b || c) != d) && e)'\'' -a 2,0,0,2,0
1
$ test-expr '\''a >= (((b || c) != d) && e)'\'' -a 2,0,1,1,2
1
$ test-expr '\''a >= (((b || c) != d) && e)'\'' -a 2,0,1,2,0
1
$ test-expr '\''a >= (((b || c) != d) && e)'\'' -a 2,0,1,2,1
1
$ test-expr '\''a >= (((b || c) != d) && e)'\'' -a 2,1,0,1,1
1
$ test-expr '\''a >= (((b || c) != d) && e)'\'' -a 2,1,1,1,2
1
$ test-expr '\''a >= (((b || c) != d) && e)'\'' -a 2,1,2,0,1
1
$ test-expr '\''a >= (((b || c) != d) && e)'\'' -a 2,2,0,0,2
1
$ test-expr '\''a >= (((b || c) != d) && e)'\'' -a 2,2,0,1,1
1
$ test-expr '\''a >= (((b || c) != d) && e)'\'' -a 2,2,0,2,2
1
$ test-expr '\''a >= (((b || c) != d) && e)'\'' -a 2,2,1,2,1
1
$ test-expr '\''a >= (((b || c) != d) && e)'\'' -a 2,2,2,0,0
1
$ test-expr '\''a >= (((b || c) != d) && e)'\'' -a 2,2,2,0,2
1
$ test-expr '\''a >= (((b || c) != d) && e)'\'' -a 2,2,2,2,2
1
$ test-expr '\''a >= (((b || c) && d) != e)'\'' -a 0,0,1,0,0
1
$ test-expr '\''a >= (((b || c) && d) != e)'\'' -a 0,0,2,2,1
1
$ test-expr '\''a >= (((b || c) && d) != e)'\'' -a 0,1,1,0,2
0
$ test-expr '\''a >= (((b || c) && d) != e)'\'' -a 0,1,2,2,0
0
$ test-expr '\''a >= (((b || c) && d) != e)'\'' -a 0,2,0,2,1
1
$ test-expr '\''a >= (((b || c) && d) != e)'\'' -a 1,0,0,0,1
1
$ test-expr '\''a >= (((b || c) && d) != e)'\'' -a 1,0,0,0,2
1
$ test-expr '\''a >= (((b || c) && d) != e)'\'' -a 1,0,1,1,1
1
$ test-expr '\''a >= (((b || c) && d) != e)'\'' -a 1,0,2,2,2
1
$ test-expr '\''a >= (((b || c) && d) != e)'\'' -a 1,1,0,0,2
1
$ test-expr '\''a >= (((b || c) && d) != e)'\'' -a 1,2,0,0,2
1
$ test-expr '\''a >= (((b || c) && d) != e)'\'' -a 1,2,0,1,0
1
$ test-expr '\''a >= (((b || c) && d) != e)'\'' -a 1,2,0,1,1
1
$ test-expr '\''a >= (((b || c) && d) != e)'\'' -a 1,2,1,0,2
1
$ test-expr '\''a >= (((b || c) && d) != e)'\'' -a 1,2,1,2,0
1
$ test-expr '\''a >= (((b || c) && d) != e)'\'' -a 1,2,1,2,2
1
$ test-expr '\''a >= (((b || c) && d) != e)'\'' -a 1,2,2,2,0
1
$ test-expr '\''a >= (((b || c) && d) != e)'\'' -a 2,0,1,0,0
1
$ test-expr '\''a >= (((b || c) && d) != e)'\'' -a 2,0,1,0,1
1
$ test-expr '\''a >= (((b || c) && d) != e)'\'' -a 2,0,2,1,0
1
$ test-expr '\''a >= (((b || c) && d) != e)'\'' -a 2,0,2,1,1
1
$ test-expr '\''a >= (((b || c) && d) != e)'\'' -a 2,1,1,0,0
1
$ test-expr '\''a >= (((b || c) && d) != e)'\'' -a 2,1,1,0,1
1
$ test-expr '\''a >= (((b || c) && d) != e)'\'' -a 2,1,1,1,1
1
$ test-expr '\''a >= (((b || c) && d) != e)'\'' -a 2,1,2,1,0
1
$ test-expr '\''a >= (((b || c) && d) != e)'\'' -a 2,1,2,2,0
1
$ test-expr '\''a >= (((b || c) && d) != e)'\'' -a 2,2,0,1,1
1
$ test-expr '\''a >= (((b || c) && d) != e)'\'' -a 2,2,1,1,0
1
$ test-expr '\''a >= (((b || c) && d) != e)'\'' -a 2,2,2,0,0
1
$ test-expr '\''a >= (((b || c) && d) != e)'\'' -a 2,2,2,1,1
1
$ test-expr '\''a || (b != (c && (d >= e)))'\'' -a 0,0,0,2,1
0
$ test-expr '\''a || (b != (c && (d >= e)))'\'' -a 0,0,1,0,0
1
$ test-expr '\''a || (b != (c && (d >= e)))'\'' -a 0,0,1,0,1
0
$ test-expr '\''a || (b != (c && (d >= e)))'\'' -a 0,0,2,0,0
1
$ test-expr '\''a || (b != (c && (d >= e)))'\'' -a 0,0,2,2,0
1
$ test-expr '\''a || (b != (c && (d >= e)))'\'' -a 0,1,0,0,1
1
$ test-expr '\''a || (b != (c && (d >= e)))'\'' -a 0,1,0,1,1
1
$ test-expr '\''a || (b != (c && (d >= e)))'\'' -a 0,1,0,1,2
1
$ test-expr '\''a || (b != (c && (d >= e)))'\'' -a 0,1,0,2,1
1
$ test-expr '\''a || (b != (c && (d >= e)))'\'' -a 0,1,1,0,0
0
$ test-expr '\''a || (b != (c && (d >= e)))'\'' -a 0,2,0,2,2
1
$ test-expr '\''a || (b != (c && (d >= e)))'\'' -a 0,2,1,0,0
1
$ test-expr '\''a || (b != (c && (d >= e)))'\'' -a 0,2,1,1,1
1
$ test-expr '\''a || (b != (c && (d >= e)))'\'' -a 1,0,0,0,1
1
$ test-expr '\''a || (b != (c && (d >= e)))'\'' -a 1,0,0,0,2
1
$ test-expr '\''a || (b != (c && (d >= e)))'\'' -a 1,0,1,2,1
1
$ test-expr '\''a || (b != (c && (d >= e)))'\'' -a 1,0,2,1,2
1
$ test-expr '\''a || (b != (c && (d >= e)))'\'' -a 1,1,1,0,1
1
$ test-expr '\''a || (b != (c && (d >= e)))'\'' -a 1,2,1,1,2
1
$ test-expr '\''a || (b != (c && (d >= e)))'\'' -a 1,2,2,0,1
1
$ test-expr '\''a || (b != (c && (d >= e)))'\'' -a 1,2,2,1,0
1
$ test-expr '\''a || (b != (c && (d >= e)))'\'' -a 1,2,2,1,1
1
$ test-expr '\''a || (b != (c && (d >= e)))'\'' -a 1,2,2,1,2
1
$ test-expr '\''a || (b != (c && (d >= e)))'\'' -a 1,2,2,2,1
1
$ test-expr '\''a || (b != (c && (d >= e)))'\'' -a 2,0,0,0,2
1
$ test-expr '\''a || (b != (c && (d >= e)))'\'' -a 2,0,0,1,1
1
$ test-expr '\''a || (b != (c && (d >= e)))'\'' -a 2,0,0,2,0
1
$ test-expr '\''a || (b != (c && (d >= e)))'\'' -a 2,0,1,0,0
1
$ test-expr '\''a || (b != (c && (d >= e)))'\'' -a 2,1,0,1,1
1
$ test-expr '\''a || (b != (c && (d >= e)))'\'' -a 2,1,2,0,0
1
$ test-expr '\''a || (b != (c && (d >= e)))'\'' -a 2,1,2,1,1
1
$ test-expr '\''a || (b != (c && (d >= e)))'\'' -a 2,2,0,2,2
1
$ test-expr '\''a || (b != (c && (d >= e)))'\'' -a 2,2,2,1,1
1
$ test-expr '\''a || (b != (c && (d >= e)))'\'' -a 2,2,2,1,2
1
$ test-expr '\''a || (b != (c && (d >= e)))'\'' -a 2,2,2,2,0
1
$ test-expr '\''a || (b != (c && (d >= e)))'\'' -a 2,2,2,2,2
1
$ test-expr '\''a || (b != (c >= (d && e)))'\'' -a 0,0,0,0,1
1
$ test-expr '\''a || (b != (c >= (d && e)))'\'' -a 0,1,2,0,1
0
$ test-expr '\''a || (b != (c >= (d && e)))'\'' -a 0,1,2,0,2
0
$ test-expr '\''a || (b != (c >= (d && e)))'\'' -a 0,1,2,1,0
0
$ test-expr '\''a || (b != (c >= (d && e)))'\'' -a 0,2,0,0,1
1
$ test-expr '\''a || (b != (c >= (d && e)))'\'' -a 0,2,0,2,1
1
$ test-expr '\''a || (b != (c >= (d && e)))'\'' -a 0,2,1,0,2
1
$ test-expr '\''a || (b != (c >= (d && e)))'\'' -a 0,2,1,1,2
1
$ test-expr '\''a || (b != (c >= (d && e)))'\'' -a 0,2,2,0,2
1
$ test-expr '\''a || (b != (c >= (d && e)))'\'' -a 0,2,2,1,2
1
$ test-expr '\''a || (b != (c >= (d && e)))'\'' -a 1,0,0,1,2
1
$ test-expr '\''a || (b != (c >= (d && e)))'\'' -a 1,0,0,2,0
1
$ test-expr '\''a || (b != (c >= (d && e)))'\'' -a 1,0,1,2,2
1
$ test-expr '\''a || (b != (c >= (d && e)))'\'' -a 1,0,2,2,0
1
$ test-expr '\''a || (b != (c >= (d && e)))'\'' -a 1,0,2,2,1
1
$ test-expr '\''a || (b != (c >= (d && e)))'\'' -a 1,1,0,1,0
1
$ test-expr '\''a || (b != (c >= (d && e)))'\'' -a 1,1,0,2,2
1
$ test-expr '\''a || (b != (c >= (d && e)))'\'' -a 1,2,1,2,2
1
$ test-expr '\''a || (b != (c >= (d && e)))'\'' -a 2,0,0,2,2
1
$ test-expr '\''a || (b != (c >= (d && e)))'\'' -a 2,0,2,1,2
1
$ test-expr '\''a || (b != (c >= (d && e)))'\'' -a 2,1,0,1,2
1
$ test-expr '\''a || (b != (c >= (d && e)))'\'' -a 2,1,2,0,2
1
$ test-expr '\''a || (b != (c >= (d && e)))'\'' -a 2,2,2,1,2
1
$ test-expr '\''a || (b != ((c && d) >= e))'\'' -a 0,0,1,2,0
1
$ test-expr '\''a || (b != ((c && d) >= e))'\'' -a 0,0,2,1,0
1
$ test-expr '\''a || (b != ((c && d) >= e))'\'' -a 0,1,0,0,1
1
$ test-expr '\''a || (b != ((c && d) >= e))'\'' -a 0,2,0,1,1
1
$ test-expr '\''a || (b != ((c && d) >= e))'\'' -a 0,2,2,0,2
1
$ test-expr '\''a || (b != ((c && d) >= e))'\'' -a 0,2,2,2,2
1
$ test-expr '\''a || (b != ((c && d) >= e))'\'' -a 1,0,0,1,1
1
$ test-expr '\''a || (b != ((c && d) >= e))'\'' -a 1,0,0,2,0
1
$ test-expr '\''a || (b != ((c && d) >= e))'\'' -a 1,0,2,0,0
1
$ test-expr '\''a || (b != ((c && d) >= e))'\'' -a 1,0,2,2,0
1
$ test-expr '\''a || (b != ((c && d) >= e))'\'' -a 1,1,0,1,2
1
$ test-expr '\''a || (b != ((c && d) >= e))'\'' -a 1,1,0,2,1
1
$ test-expr '\''a || (b != ((c && d) >= e))'\'' -a 2,0,0,0,2
1
$ test-expr '\''a || (b != ((c && d) >= e))'\'' -a 2,0,0,2,2
1
$ test-expr '\''a || (b != ((c && d) >= e))'\'' -a 2,0,1,1,2
1
$ test-expr '\''a || (b != ((c && d) >= e))'\'' -a 2,0,2,1,0
1
$ test-expr '\''a || (b != ((c && d) >= e))'\'' -a 2,1,0,2,1
1
$ test-expr '\''a || (b != ((c && d) >= e))'\'' -a 2,1,2,2,1
1
$ test-expr '\''a || (b != ((c && d) >= e))'\'' -a 2,2,0,1,0
1
$ test-expr '\''a || (b != ((c && d) >= e))'\'' -a 2,2,0,2,2
1
$ test-expr '\''a || (b != ((c >= d) && e))'\'' -a 0,1,0,1,0
1
$ test-expr '\''a || (b != ((c >= d) && e))'\'' -a 0,1,0,1,2
1
$ test-expr '\''a || (b != ((c >= d) && e))'\'' -a 0,1,1,0,0
1
$ test-expr '\''a || (b != ((c >= d) && e))'\'' -a 0,1,2,0,0
1
$ test-expr '\''a || (b != ((c >= d) && e))'\'' -a 0,1,2,1,0
1
$ test-expr '\''a || (b != ((c >= d) && e))'\'' -a 0,2,1,2,0
1
$ test-expr '\''a || (b != ((c >= d) && e))'\'' -a 0,2,2,0,1
1
$ test-expr '\''a || (b != ((c >= d) && e))'\'' -a 1,0,0,0,2
1
$ test-expr '\''a || (b != ((c >= d) && e))'\'' -a 1,0,1,0,1
1
$ test-expr '\''a || (b != ((c >= d) && e))'\'' -a 1,0,1,2,0
1
$ test-expr '\''a || (b != ((c >= d) && e))'\'' -a 1,0,2,0,0
1
$ test-expr '\''a || (b != ((c >= d) && e))'\'' -a 1,0,2,0,1
1
$ test-expr '\''a || (b != ((c >= d) && e))'\'' -a 1,1,0,2,1
1
$ test-expr '\''a || (b != ((c >= d) && e))'\'' -a 1,1,2,2,2
1
$ test-expr '\''a || (b != ((c >= d) && e))'\'' -a 2,0,1,0,2
1
$ test-expr '\''a || (b != ((c >= d) && e))'\'' -a 2,0,1,1,2
1
$ test-expr '\''a || (b != ((c >= d) && e))'\'' -a 2,0,2,1,0
1
$ test-expr '\''a || (b != ((c >= d) && e))'\'' -a 2,1,0,0,1
1
$ test-expr '\''a || (b && (c != (d >= e)))'\'' -a 0,0,0,0,2
0
$ test-expr '\''a || (b && (c != (d >= e)))'\'' -a 0,0,1,1,0
0
$ test-expr '\''a || (b && (c != (d >= e)))'\'' -a 0,0,1,2,1
0
$ test-expr '\''a || (b && (c != (d >= e)))'\'' -a 0,0,2,0,2
0
$ test-expr '\''a || (b && (c != (d >= e)))'\'' -a 0,1,0,2,2
1
$ test-expr '\''a || (b && (c != (d >= e)))'\'' -a 0,1,1,0,0
0
$ test-expr '\''a || (b && (c != (d >= e)))'\'' -a 0,2,1,0,0
0
$ test-expr '\''a || (b && (c != (d >= e)))'\'' -a 0,2,1,1,2
1
$ test-expr '\''a || (b && (c != (d >= e)))'\'' -a 0,2,1,2,2
0
$ test-expr '\''a || (b && (c != (d >= e)))'\'' -a 0,2,2,1,1
1
$ test-expr '\''a || (b && (c != (d >= e)))'\'' -a 1,0,1,0,1
1
$ test-expr '\''a || (b && (c != (d >= e)))'\'' -a 1,0,1,0,2
1
$ test-expr '\''a || (b && (c != (d >= e)))'\'' -a 1,0,1,2,2
1
$ test-expr '\''a || (b && (c != (d >= e)))'\'' -a 1,0,2,0,1
1
$ test-expr '\''a || (b && (c != (d >= e)))'\'' -a 1,1,0,1,2
1
$ test-expr '\''a || (b && (c != (d >= e)))'\'' -a 1,1,1,1,2
1
$ test-expr '\''a || (b && (c != (d >= e)))'\'' -a 1,1,2,0,1
1
$ test-expr '\''a || (b && (c != (d >= e)))'\'' -a 1,1,2,1,0
1
$ test-expr '\''a || (b && (c != (d >= e)))'\'' -a 1,1,2,1,1
1
$ test-expr '\''a || (b && (c != (d >= e)))'\'' -a 1,2,0,1,0
1
$ test-expr '\''a || (b && (c != (d >= e)))'\'' -a 2,0,0,1,2
1
$ test-expr '\''a || (b && (c != (d >= e)))'\'' -a 2,0,1,1,0
1
$ test-expr '\''a || (b && (c != (d >= e)))'\'' -a 2,0,2,0,0
1
$ test-expr '\''a || (b && (c != (d >= e)))'\'' -a 2,0,2,0,2
1
$ test-expr '\''a || (b && (c != (d >= e)))'\'' -a 2,0,2,1,2
1
$ test-expr '\''a || (b && (c != (d >= e)))'\'' -a 2,1,1,1,0
1
$ test-expr '\''a || (b && (c != (d >= e)))'\'' -a 2,1,1,1,2
1
$ test-expr '\''a || (b && (c != (d >= e)))'\'' -a 2,2,0,0,1
1
$ test-expr '\''a || (b && (c != (d >= e)))'\'' -a 2,2,0,1,2
1
$ test-expr '\''a || (b && (c != (d >= e)))'\'' -a 2,2,1,0,1
1
$ test-expr '\''a || (b && (c != (d >= e)))'\'' -a 2,2,1,2,1
1
$ test-expr '\''a || (b && (c != (d >= e)))'\'' -a 2,2,2,0,2
1
$ test-expr '\''a || (b && (c != (d >= e)))'\'' -a 2,2,2,1,0
1
$ test-expr '\''a || (b && (c != (d >= e)))'\'' -a 2,2,2,1,2
1
$ test-expr '\''a || (b && (c != (d >= e)))'\'' -a 2,2,2,2,2
1
$ test-expr '\''a || (b && (c >= (d != e)))'\'' -a 0,0,0,2,2
0
$ test-expr '\''a || (b && (c >= (d != e)))'\'' -a 0,0,1,1,1
0
$ test-expr '\''a || (b && (c >= (d != e)))'\'' -a 0,0,1,2,2
0
$ test-expr '\''a || (b && (c >= (d != e)))'\'' -a 0,0,2,2,0
0
$ test-expr '\''a || (b && (c >= (d != e)))'\'' -a 0,1,0,0,1
0
$ test-expr '\''a || (b && (c >= (d != e)))'\'' -a 0,2,0,2,0
0
$ test-expr '\''a || (b && (c >= (d != e)))'\'' -a 0,2,0,2,2
1
$ test-expr '\''a || (b && (c >= (d != e)))'\'' -a 0,2,2,1,2
1
$ test-expr '\''a || (b && (c >= (d != e)))'\'' -a 0,2,2,2,1
1
$ test-expr '\''a || (b && (c >= (d != e)))'\'' -a 0,2,2,2,2
1
$ test-expr '\''a || (b && (c >= (d != e)))'\'' -a 1,0,0,0,0
1
$ test-expr '\''a || (b && (c >= (d != e)))'\'' -a 1,0,0,2,1
1
$ test-expr '\''a || (b && (c >= (d != e)))'\'' -a 1,0,1,0,2
1
$ test-expr '\''a || (b && (c >= (d != e)))'\'' -a 1,0,2,0,1
1
$ test-expr '\''a || (b && (c >= (d != e)))'\'' -a 1,0,2,2,0
1
$ test-expr '\''a || (b && (c >= (d != e)))'\'' -a 1,0,2,2,2
1
$ test-expr '\''a || (b && (c >= (d != e)))'\'' -a 1,1,0,0,0
1
$ test-expr '\''a || (b && (c >= (d != e)))'\'' -a 1,1,1,1,2
1
$ test-expr '\''a || (b && (c >= (d != e)))'\'' -a 1,1,1,2,2
1
$ test-expr '\''a || (b && (c >= (d != e)))'\'' -a 1,1,2,1,0
1
$ test-expr '\''a || (b && (c >= (d != e)))'\'' -a 1,2,0,0,2
1
$ test-expr '\''a || (b && (c >= (d != e)))'\'' -a 1,2,0,1,2
1
$ test-expr '\''a || (b && (c >= (d != e)))'\'' -a 1,2,1,0,0
1
$ test-expr '\''a || (b && (c >= (d != e)))'\'' -a 1,2,1,0,1
1
$ test-expr '\''a || (b && (c >= (d != e)))'\'' -a 1,2,2,1,2
1
$ test-expr '\''a || (b && (c >= (d != e)))'\'' -a 2,0,1,2,2
1
$ test-expr '\''a || (b && (c >= (d != e)))'\'' -a 2,1,0,0,2
1
$ test-expr '\''a || (b && (c >= (d != e)))'\'' -a 2,1,0,1,1
1
$ test-expr '\''a || (b && (c >= (d != e)))'\'' -a 2,1,0,2,2
1
$ test-expr '\''a || (b && (c >= (d != e)))'\'' -a 2,2,1,2,0
1
$ test-expr '\''a || (b && (c >= (d != e)))'\'' -a 2,2,2,1,1
1
$ test-expr '\''a || (b && (c >= (d != e)))'\'' -a 2,2,2,2,0
1
$ test-expr '\''a || (b && ((c != d) >= e))'\'' -a 0,0,0,1,2
0
$ test-expr '\''a || (b && ((c != d) >= e))'\'' -a 0,1,0,1,0
1
$ test-expr '\''a || (b && ((c != d) >= e))'\'' -a 0,2,1,0,1
1
$ test-expr '\''a || (b && ((c != d) >= e))'\'' -a 0,2,1,2,0
1
$ test-expr '\''a || (b && ((c != d) >= e))'\'' -a 0,2,2,1,2
0
$ test-expr '\''a || (b && ((c != d) >= e))'\'' -a 1,0,0,2,0
1
$ test-expr '\''a || (b && ((c != d) >= e))'\'' -a 1,0,1,0,1
1
$ test-expr '\''a || (b && ((c != d) >= e))'\'' -a 1,0,1,0,2
1
$ test-expr '\''a || (b && ((c != d) >= e))'\'' -a 1,0,1,1,2
1
$ test-expr '\''a || (b && ((c != d) >= e))'\'' -a 1,0,2,1,1
1
$ test-expr '\''a || (b && ((c != d) >= e))'\'' -a 1,1,2,1,1
1
$ test-expr '\''a || (b && ((c != d) >= e))'\'' -a 1,1,2,2,0
1
$ test-expr '\''a || (b && ((c != d) >= e))'\'' -a 1,2,0,0,2
1
$ test-expr '\''a || (b && ((c != d) >= e))'\'' -a 1,2,1,0,1
1
$ test-expr '\''a || (b && ((c != d) >= e))'\'' -a 1,2,1,1,0
1
$ test-expr '\''a || (b && ((c != d) >= e))'\'' -a 1,2,2,1,0
1
$ test-expr '\''a || (b && ((c != d) >= e))'\'' -a 1,2,2,2,0
1
$ test-expr '\''a || (b && ((c != d) >= e))'\'' -a 2,0,0,1,2
1
$ test-expr '\''a || (b && ((c != d) >= e))'\'' -a 2,0,2,0,0
1
$ test-expr '\''a || (b && ((c != d) >= e))'\'' -a 2,0,2,1,1
1
$ test-expr '\''a || (b && ((c != d) >= e))'\'' -a 2,1,0,0,2
1
$ test-expr '\''a || (b && ((c != d) >= e))'\'' -a 2,1,1,1,2
1
$ test-expr '\''a || (b && ((c != d) >= e))'\'' -a 2,2,0,1,0
1
$ test-expr '\''a || (b && ((c != d) >= e))'\'' -a 2,2,0,1,2
1
$ test-expr '\''a || (b && ((c != d) >= e))'\'' -a 2,2,1,1,2
1
$ test-expr '\''a || (b && ((c != d) >= e))'\'' -a 2,2,2,1,0
1
$ test-expr '\''a || (b && ((c >= d) != e))'\'' -a 0,0,0,1,2
0
$ test-expr '\''a || (b && ((c >= d) != e))'\'' -a 0,0,2,2,0
0
$ test-expr '\''a || (b && ((c >= d) != e))'\'' -a 0,1,0,0,2
1
$ test-expr '\''a || (b && ((c >= d) != e))'\'' -a 0,2,0,2,2
1
$ test-expr '\''a || (b && ((c >= d) != e))'\'' -a 1,0,0,2,0
1
$ test-expr '\''a || (b && ((c >= d) != e))'\'' -a 1,0,1,0,0
1
$ test-expr '\''a || (b && ((c >= d) != e))'\'' -a 1,0,1,0,2
1
$ test-expr '\''a || (b && ((c >= d) != e))'\'' -a 1,1,2,0,2
1
$ test-expr '\''a || (b && ((c >= d) != e))'\'' -a 1,1,2,1,0
1
$ test-expr '\''a || (b && ((c >= d) != e))'\'' -a 1,1,2,1,1
1
$ test-expr '\''a || (b && ((c >= d) != e))'\'' -a 1,2,2,1,1
1
$ test-expr '\''a || (b && ((c >= d) != e))'\'' -a 2,0,0,0,2
1
$ test-expr '\''a || (b && ((c >= d) != e))'\'' -a 2,0,1,0,0
1
$ test-expr '\''a || (b && ((c >= d) != e))'\'' -a 2,0,1,2,2
1
$ test-expr '\''a || (b && ((c >= d) != e))'\'' -a 2,0,2,1,0
1
$ test-expr '\''a || (b && ((c >= d) != e))'\'' -a 2,1,0,0,2
1
$ test-expr '\''a || (b && ((c >= d) != e))'\'' -a 2,1,0,1,2
1
$ test-expr '\''a || (b && ((c >= d) != e))'\'' -a 2,2,0,0,0
1
$ test-expr '\''a || (b && ((c >= d) != e))'\'' -a 2,2,0,2,2
1
$ test-expr '\''a || (b && ((c >= d) != e))'\'' -a 2,2,1,1,0
1
$ test-expr '\''a || (b && ((c >= d) != e))'\'' -a 2,2,1,1,2
1
$ test-expr '\''a || (b && ((c >= d) != e))'\'' -a 2,2,1,2,2
1
$ test-expr '\''a || (b && ((c >= d) != e))'\'' -a 2,2,2,0,0
1
$ test-expr '\''a || (b >= (c != (d && e)))'\'' -a 0,0,1,1,1
1
$ test-expr '\''a || (b >= (c != (d && e)))'\'' -a 0,0,1,1,2
1
$ test-expr '\''a || (b >= (c != (d && e)))'\'' -a 0,0,1,2,0
0
$ test-expr '\''a || (b >= (c != (d && e)))'\'' -a 0,0,1,2,2
1
$ test-expr '\''a || (b >= (c != (d && e)))'\'' -a 0,1,1,0,0
1
$ test-expr '\''a || (b >= (c != (d && e)))'\'' -a 0,1,1,1,0
1
$ test-expr '\''a || (b >= (c != (d && e)))'\'' -a 0,1,1,1,1
1
$ test-expr '\''a || (b >= (c != (d && e)))'\'' -a 0,1,2,2,0
1
$ test-expr '\''a || (b >= (c != (d && e)))'\'' -a 0,2,0,1,2
1
$ test-expr '\''a || (b >= (c != (d && e)))'\'' -a 0,2,0,2,1
1
$ test-expr '\''a || (b >= (c != (d && e)))'\'' -a 0,2,1,1,2
1
$ test-expr '\''a || (b >= (c != (d && e)))'\'' -a 0,2,2,0,2
1
$ test-expr '\''a || (b >= (c != (d && e)))'\'' -a 0,2,2,1,0
1
$ test-expr '\''a || (b >= (c != (d && e)))'\'' -a 0,2,2,1,1
1
$ test-expr '\''a || (b >= (c != (d && e)))'\'' -a 0,2,2,2,2
1
$ test-expr '\''a || (b >= (c != (d && e)))'\'' -a 1,0,2,0,1
1
$ test-expr '\''a || (b >= (c != (d && e)))'\'' -a 1,0,2,1,0
1
$ test-expr '\''a || (b >= (c != (d && e)))'\'' -a 1,1,0,2,1
1
$ test-expr '\''a || (b >= (c != (d && e)))'\'' -a 1,1,1,2,2
1
$ test-expr '\''a || (b >= (c != (d && e)))'\'' -a 1,1,2,2,1
1
$ test-expr '\''a || (b >= (c != (d && e)))'\'' -a 1,2,1,1,0
1
$ test-expr '\''a || (b >= (c != (d && e)))'\'' -a 1,2,2,0,2
1
$ test-expr '\''a || (b >= (c != (d && e)))'\'' -a 2,0,0,0,2
1
$ test-expr '\''a || (b >= (c != (d && e)))'\'' -a 2,1,1,0,1
1
$ test-expr '\''a || (b >= (c != (d && e)))'\'' -a 2,2,0,1,1
1
$ test-expr '\''a || (b >= (c != (d && e)))'\'' -a 2,2,0,1,2
1
$ test-expr '\''a || (b >= (c != (d && e)))'\'' -a 2,2,0,2,0
1
$ test-expr '\''a || (b >= (c != (d && e)))'\'' -a 2,2,2,0,0
1
$ test-expr '\''a || (b >= (c != (d && e)))'\'' -a 2,2,2,0,2
1
$ test-expr '\''a || (b >= (c != (d && e)))'\'' -a 2,2,2,1,1
1
$ test-expr '\''a || (b >= (c && (d != e)))'\'' -a 0,0,1,1,0
0
$ test-expr '\''a || (b >= (c && (d != e)))'\'' -a 0,0,1,2,0
0
$ test-expr '\''a || (b >= (c && (d != e)))'\'' -a 0,0,2,0,0
1
$ test-expr '\''a || (b >= (c && (d != e)))'\'' -a 0,0,2,1,2
0
$ test-expr '\''a || (b >= (c && (d != e)))'\'' -a 0,0,2,2,0
0
$ test-expr '\''a || (b >= (c && (d != e)))'\'' -a 0,1,0,0,0
1
$ test-expr '\''a || (b >= (c && (d != e)))'\'' -a 0,1,0,2,2
1
$ test-expr '\''a || (b >= (c && (d != e)))'\'' -a 0,1,1,1,1
1
$ test-expr '\''a || (b >= (c && (d != e)))'\'' -a 0,1,2,1,2
1
$ test-expr '\''a || (b >= (c && (d != e)))'\'' -a 0,2,0,0,0
1
$ test-expr '\''a || (b >= (c && (d != e)))'\'' -a 0,2,2,2,0
1
$ test-expr '\''a || (b >= (c && (d != e)))'\'' -a 1,0,0,0,1
1
$ test-expr '\''a || (b >= (c && (d != e)))'\'' -a 1,0,0,2,1
1
$ test-expr '\''a || (b >= (c && (d != e)))'\'' -a 1,0,1,0,2
1
$ test-expr '\''a || (b >= (c && (d != e)))'\'' -a 1,0,2,0,2
1
$ test-expr '\''a || (b >= (c && (d != e)))'\'' -a 1,0,2,1,0
1
$ test-expr '\''a || (b >= (c && (d != e)))'\'' -a 1,0,2,2,1
1
$ test-expr '\''a || (b >= (c && (d != e)))'\'' -a 1,0,2,2,2
1
$ test-expr '\''a || (b >= (c && (d != e)))'\'' -a 1,1,1,0,1
1
$ test-expr '\''a || (b >= (c && (d != e)))'\'' -a 1,1,2,0,1
1
$ test-expr '\''a || (b >= (c && (d != e)))'\'' -a 1,1,2,1,2
1
$ test-expr '\''a || (b >= (c && (d != e)))'\'' -a 1,2,0,2,2
1
$ test-expr '\''a || (b >= (c && (d != e)))'\'' -a 1,2,1,0,0
1
$ test-expr '\''a || (b >= (c && (d != e)))'\'' -a 1,2,1,2,2
1
$ test-expr '\''a || (b >= (c && (d != e)))'\'' -a 1,2,2,2,1
1
$ test-expr '\''a || (b >= (c && (d != e)))'\'' -a 2,0,0,0,1
1
$ test-expr '\''a || (b >= (c && (d != e)))'\'' -a 2,0,1,0,2
1
$ test-expr '\''a || (b >= (c && (d != e)))'\'' -a 2,0,1,2,1
1
$ test-expr '\''a || (b >= (c && (d != e)))'\'' -a 2,0,2,0,1
1
$ test-expr '\''a || (b >= (c && (d != e)))'\'' -a 2,0,2,2,0
1
$ test-expr '\''a || (b >= (c && (d != e)))'\'' -a 2,1,0,2,1
1
$ test-expr '\''a || (b >= (c && (d != e)))'\'' -a 2,1,1,0,0
1
$ test-expr '\''a || (b >= (c && (d != e)))'\'' -a 2,1,1,0,1
1
$ test-expr '\''a || (b >= (c && (d != e)))'\'' -a 2,1,1,1,0
1
$ test-expr '\''a || (b >= (c && (d != e)))'\'' -a 2,1,2,2,2
1
$ test-expr '\''a || (b >= (c && (d != e)))'\'' -a 2,2,0,2,2
1
$ test-expr '\''a || (b >= (c && (d != e)))'\'' -a 2,2,1,1,2
1
$ test-expr '\''a || (b >= (c && (d != e)))'\'' -a 2,2,2,2,1
1
$ test-expr '\''a || (b >= ((c != d) && e))'\'' -a 0,0,0,1,2
0
$ test-expr '\''a || (b >= ((c != d) && e))'\'' -a 0,0,1,0,0
1
$ test-expr '\''a || (b >= ((c != d) && e))'\'' -a 0,0,1,1,0
1
$ test-expr '\''a || (b >= ((c != d) && e))'\'' -a 0,0,1,2,2
0
$ test-expr '\''a || (b >= ((c != d) && e))'\'' -a 0,0,2,2,0
1
$ test-expr '\''a || (b >= ((c != d) && e))'\'' -a 0,1,2,2,1
1
$ test-expr '\''a || (b >= ((c != d) && e))'\'' -a 0,2,0,0,2
1
$ test-expr '\''a || (b >= ((c != d) && e))'\'' -a 0,2,0,1,2
1
$ test-expr '\''a || (b >= ((c != d) && e))'\'' -a 0,2,1,0,0
1
$ test-expr '\''a || (b >= ((c != d) && e))'\'' -a 1,0,0,1,0
1
$ test-expr '\''a || (b >= ((c != d) && e))'\'' -a 1,0,0,2,1
1
$ test-expr '\''a || (b >= ((c != d) && e))'\'' -a 1,0,1,1,1
1
$ test-expr '\''a || (b >= ((c != d) && e))'\'' -a 1,0,2,1,1
1
$ test-expr '\''a || (b >= ((c != d) && e))'\'' -a 1,1,0,1,1
1
$ test-expr '\''a || (b >= ((c != d) && e))'\'' -a 1,1,1,2,0
1
$ test-expr '\''a || (b >= ((c != d) && e))'\'' -a 1,1,1,2,2
1
$ test-expr '\''a || (b >= ((c != d) && e))'\'' -a 1,1,2,2,0
1
$ test-expr '\''a || (b >= ((c != d) && e))'\'' -a 1,2,0,2,2
1
$ test-expr '\''a || (b >= ((c != d) && e))'\'' -a 1,2,2,2,1
1
$ test-expr '\''a || (b >= ((c != d) && e))'\'' -a 2,0,0,0,1
1
$ test-expr '\''a || (b >= ((c != d) && e))'\'' -a 2,0,0,2,0
1
$ test-expr '\''a || (b >= ((c != d) && e))'\'' -a 2,0,1,1,0
1
$ test-expr '\''a || (b >= ((c != d) && e))'\'' -a 2,0,2,0,1
1
$ test-expr '\''a || (b >= ((c != d) && e))'\'' -a 2,0,2,1,1
1
$ test-expr '\''a || (b >= ((c != d) && e))'\'' -a 2,1,0,0,1
1
$ test-expr '\''a || (b >= ((c != d) && e))'\'' -a 2,1,1,2,2
1
$ test-expr '\''a || (b >= ((c != d) && e))'\'' -a 2,2,0,1,0
1
$ test-expr '\''a || (b >= ((c != d) && e))'\'' -a 2,2,0,1,2
1
$ test-expr '\''a || (b >= ((c != d) && e))'\'' -a 2,2,1,1,0
1
$ test-expr '\''a || (b >= ((c != d) && e))'\'' -a 2,2,1,2,0
1
$ test-expr '\''a || (b >= ((c != d) && e))'\'' -a 2,2,2,2,2
1
$ test-expr '\''a || (b >= ((c && d) != e))'\'' -a 0,0,2,1,2
0
$ test-expr '\''a || (b >= ((c && d) != e))'\'' -a 0,1,0,1,0
1
$ test-expr '\''a || (b >= ((c && d) != e))'\'' -a 0,1,2,0,1
1
$ test-expr '\''a || (b >= ((c && d) != e))'\'' -a 0,1,2,1,1
1
$ test-expr '\''a || (b >= ((c && d) != e))'\'' -a 0,2,0,1,1
1
$ test-expr '\''a || (b >= ((c && d) != e))'\'' -a 1,0,0,1,1
1
$ test-expr '\''a || (b >= ((c && d) != e))'\'' -a 1,0,1,1,2
1
$ test-expr '\''a || (b >= ((c && d) != e))'\'' -a 1,0,2,0,2
1
$ test-expr '\''a || (b >= ((c && d) != e))'\'' -a 1,1,1,0,2
1
$ test-expr '\''a || (b >= ((c && d) != e))'\'' -a 1,1,1,1,0
1
$ test-expr '\''a || (b >= ((c && d) != e))'\'' -a 1,1,2,0,0
1
$ test-expr '\''a || (b >= ((c && d) != e))'\'' -a 1,1,2,1,1
1
$ test-expr '\''a || (b >= ((c && d) != e))'\'' -a 2,0,0,0,2
1
$ test-expr '\''a || (b >= ((c && d) != e))'\'' -a 2,0,2,1,2
1
$ test-expr '\''a || (b >= ((c && d) != e))'\'' -a 2,1,0,2,1
1
$ test-expr '\''a || (b >= ((c && d) != e))'\'' -a 2,1,0,2,2
1
$ test-expr '\''a || (b >= ((c && d) != e))'\'' -a 2,1,2,0,2
1
$ test-expr '\''a || (b >= ((c && d) != e))'\'' -a 2,2,0,1,2
1
$ test-expr '\''a || (b >= ((c && d) != e))'\'' -a 2,2,0,2,0
1
$ test-expr '\''a || (b >= ((c && d) != e))'\'' -a 2,2,1,2,0
1
$ test-expr '\''a || (b >= ((c && d) != e))'\'' -a 2,2,2,0,2
1
$ test-expr '\''a || ((b != c) && (d >= e))'\'' -a 0,0,0,0,0
0
$ test-expr '\''a || ((b != c) && (d >= e))'\'' -a 0,0,1,0,2
0
$ test-expr '\''a || ((b != c) && (d >= e))'\'' -a 0,0,2,1,2
0
$ test-expr '\''a || ((b != c) && (d >= e))'\'' -a 0,0,2,2,0
1
$ test-expr '\''a || ((b != c) && (d >= e))'\'' -a 0,1,0,0,0
1
$ test-expr '\''a || ((b != c) && (d >= e))'\'' -a 0,1,0,1,0
1
$ test-expr '\''a || ((b != c) && (d >= e))'\'' -a 0,1,2,1,1
1
$ test-expr '\''a || ((b != c) && (d >= e))'\'' -a 0,1,2,2,1
1
$ test-expr '\''a || ((b != c) && (d >= e))'\'' -a 0,2,2,0,2
0
$ test-expr '\''a || ((b != c) && (d >= e))'\'' -a 0,2,2,1,1
0
$ test-expr '\''a || ((b != c) && (d >= e))'\'' -a 1,0,0,0,0
1
$ test-expr '\''a || ((b != c) && (d >= e))'\'' -a 1,0,0,1,2
1
$ test-expr '\''a || ((b != c) && (d >= e))'\'' -a 1,0,1,1,2
1
$ test-expr '\''a || ((b != c) && (d >= e))'\'' -a 1,0,1,2,0
1
$ test-expr '\''a || ((b != c) && (d >= e))'\'' -a 1,0,1,2,2
1
$ test-expr '\''a || ((b != c) && (d >= e))'\'' -a 1,0,2,0,0
1
$ test-expr '\''a || ((b != c) && (d >= e))'\'' -a 1,0,2,2,0
1
$ test-expr '\''a || ((b != c) && (d >= e))'\'' -a 1,1,0,0,2
1
$ test-expr '\''a || ((b != c) && (d >= e))'\'' -a 1,1,2,0,0
1
$ test-expr '\''a || ((b != c) && (d >= e))'\'' -a 1,2,0,0,0
1
$ test-expr '\''a || ((b != c) && (d >= e))'\'' -a 1,2,0,0,1
1
$ test-expr '\''a || ((b != c) && (d >= e))'\'' -a 1,2,0,2,0
1
$ test-expr '\''a || ((b != c) && (d >= e))'\'' -a 1,2,1,0,1
1
$ test-expr '\''a || ((b != c) && (d >= e))'\'' -a 1,2,1,1,2
1
$ test-expr '\''a || ((b != c) && (d >= e))'\'' -a 1,2,1,2,1
1
$ test-expr '\''a || ((b != c) && (d >= e))'\'' -a 1,2,2,1,2
1
$ test-expr '\''a || ((b != c) && (d >= e))'\'' -a 1,2,2,2,1
1
$ test-expr '\''a || ((b != c) && (d >= e))'\'' -a 2,0,1,0,0
1
$ test-expr '\''a || ((b != c) && (d >= e))'\'' -a 2,0,1,1,0
1
$ test-expr '\''a || ((b != c) && (d >= e))'\'' -a 2,0,1,1,1
1
$ test-expr '\''a || ((b != c) && (d >= e))'\'' -a 2,0,1,2,0
1
$ test-expr '\''a || ((b != c) && (d >= e))'\'' -a 2,0,2,1,1
1
$ test-expr '\''a || ((b != c) && (d >= e))'\'' -a 2,0,2,1,2
1
$ test-expr '\''a || ((b != c) && (d >= e))'\'' -a 2,1,0,2,0
1
$ test-expr '\''a || ((b != c) && (d >= e))'\'' -a 2,1,1,1,2
1
$ test-expr '\''a || ((b != c) && (d >= e))'\'' -a 2,2,1,1,0
1
$ test-expr '\''a || ((b != c) && (d >= e))'\'' -a 2,2,2,0,1
1
$ test-expr '\''a || ((b != c) && (d >= e))'\'' -a 2,2,2,2,0
1
$ test-expr '\''a || ((b != c) >= (d && e))'\'' -a 0,0,1,0,0
1
$ test-expr '\''a || ((b != c) >= (d && e))'\'' -a 0,0,1,2,0
1
$ test-expr '\''a || ((b != c) >= (d && e))'\'' -a 0,0,2,1,0
1
$ test-expr '\''a || ((b != c) >= (d && e))'\'' -a 0,0,2,2,0
1
$ test-expr '\''a || ((b != c) >= (d && e))'\'' -a 0,0,2,2,2
1
$ test-expr '\''a || ((b != c) >= (d && e))'\'' -a 0,1,1,2,1
0
$ test-expr '\''a || ((b != c) >= (d && e))'\'' -a 0,1,2,2,1
1
$ test-expr '\''a || ((b != c) >= (d && e))'\'' -a 0,2,1,2,0
1
$ test-expr '\''a || ((b != c) >= (d && e))'\'' -a 0,2,1,2,2
1
$ test-expr '\''a || ((b != c) >= (d && e))'\'' -a 0,2,2,1,0
1
$ test-expr '\''a || ((b != c) >= (d && e))'\'' -a 0,2,2,2,2
0
$ test-expr '\''a || ((b != c) >= (d && e))'\'' -a 1,0,0,2,2
1
$ test-expr '\''a || ((b != c) >= (d && e))'\'' -a 1,0,2,1,2
1
$ test-expr '\''a || ((b != c) >= (d && e))'\'' -a 1,1,0,1,2
1
$ test-expr '\''a || ((b != c) >= (d && e))'\'' -a 1,1,0,2,1
1
$ test-expr '\''a || ((b != c) >= (d && e))'\'' -a 1,1,1,1,1
1
$ test-expr '\''a || ((b != c) >= (d && e))'\'' -a 1,1,1,2,1
1
$ test-expr '\''a || ((b != c) >= (d && e))'\'' -a 1,1,1,2,2
1
$ test-expr '\''a || ((b != c) >= (d && e))'\'' -a 1,1,2,0,1
1
$ test-expr '\''a || ((b != c) >= (d && e))'\'' -a 1,1,2,1,1
1
$ test-expr '\''a || ((b != c) >= (d && e))'\'' -a 1,1,2,2,0
1
$ test-expr '\''a || ((b != c) >= (d && e))'\'' -a 1,1,2,2,1
1
$ test-expr '\''a || ((b != c) >= (d && e))'\'' -a 1,2,1,0,1
1
$ test-expr '\''a || ((b != c) >= (d && e))'\'' -a 1,2,1,1,1
1
$ test-expr '\''a || ((b != c) >= (d && e))'\'' -a 1,2,1,1,2
1
$ test-expr '\''a || ((b != c) >= (d && e))'\'' -a 1,2,2,1,2
1
$ test-expr '\''a || ((b != c) >= (d && e))'\'' -a 2,0,0,1,1
1
$ test-expr '\''a || ((b != c) >= (d && e))'\'' -a 2,0,1,2,0
1
$ test-expr '\''a || ((b != c) >= (d && e))'\'' -a 2,1,0,1,2
1
$ test-expr '\''a || ((b != c) >= (d && e))'\'' -a 2,2,0,1,0
1
$ test-expr '\''a || ((b != c) >= (d && e))'\'' -a 2,2,2,2,2
1
$ test-expr '\''a || ((b != (c && d)) >= e)'\'' -a 0,0,0,2,0
1
$ test-expr '\''a || ((b != (c && d)) >= e)'\'' -a 0,0,0,2,2
0
$ test-expr '\''a || ((b != (c && d)) >= e)'\'' -a 0,0,1,0,1
0
$ test-expr '\''a || ((b != (c && d)) >= e)'\'' -a 0,0,1,2,2
0
$ test-expr '\''a || ((b != (c && d)) >= e)'\'' -a 0,0,2,2,2
0
$ test-expr '\''a || ((b != (c && d)) >= e)'\'' -a 0,1,0,1,0
1
$ test-expr '\''a || ((b != (c && d)) >= e)'\'' -a 0,1,1,0,1
1
$ test-expr '\''a || ((b != (c && d)) >= e)'\'' -a 0,1,1,1,2
0
$ test-expr '\''a || ((b != (c && d)) >= e)'\'' -a 0,1,2,1,0
1
$ test-expr '\''a || ((b != (c && d)) >= e)'\'' -a 0,1,2,1,2
0
$ test-expr '\''a || ((b != (c && d)) >= e)'\'' -a 0,2,0,1,1
1
$ test-expr '\''a || ((b != (c && d)) >= e)'\'' -a 0,2,0,1,2
0
$ test-expr '\''a || ((b != (c && d)) >= e)'\'' -a 0,2,1,1,0
1
$ test-expr '\''a || ((b != (c && d)) >= e)'\'' -a 0,2,2,2,1
1
$ test-expr '\''a || ((b != (c && d)) >= e)'\'' -a 1,0,0,1,2
1
$ test-expr '\''a || ((b != (c && d)) >= e)'\'' -a 1,0,0,2,0
1
$ test-expr '\''a || ((b != (c && d)) >= e)'\'' -a 1,0,1,1,2
1
$ test-expr '\''a || ((b != (c && d)) >= e)'\'' -a 1,0,1,2,1
1
$ test-expr '\''a || ((b != (c && d)) >= e)'\'' -a 1,1,0,1,1
1
$ test-expr '\''a || ((b != (c && d)) >= e)'\'' -a 1,1,1,0,1
1
$ test-expr '\''a || ((b != (c && d)) >= e)'\'' -a 1,1,1,0,2
1
$ test-expr '\''a || ((b != (c && d)) >= e)'\'' -a 1,1,1,2,2
1
$ test-expr '\''a || ((b != (c && d)) >= e)'\'' -a 1,1,2,0,1
1
$ test-expr '\''a || ((b != (c && d)) >= e)'\'' -a 1,1,2,1,1
1
$ test-expr '\''a || ((b != (c && d)) >= e)'\'' -a 1,2,1,0,1
1
$ test-expr '\''a || ((b != (c && d)) >= e)'\'' -a 1,2,1,0,2
1
$ test-expr '\''a || ((b != (c && d)) >= e)'\'' -a 1,2,2,1,0
1
$ test-expr '\''a || ((b != (c && d)) >= e)'\'' -a 2,0,0,1,1
1
$ test-expr '\''a || ((b != (c && d)) >= e)'\'' -a 2,0,0,1,2
1
$ test-expr '\''a || ((b != (c && d)) >= e)'\'' -a 2,0,0,2,0
1
$ test-expr '\''a || ((b != (c && d)) >= e)'\'' -a 2,0,2,0,0
1
$ test-expr '\''a || ((b != (c && d)) >= e)'\'' -a 2,0,2,1,0
1
$ test-expr '\''a || ((b != (c && d)) >= e)'\'' -a 2,0,2,2,0
1
$ test-expr '\''a || ((b != (c && d)) >= e)'\'' -a 2,2,0,0,2
1
$ test-expr '\''a || ((b != (c && d)) >= e)'\'' -a 2,2,0,1,2
1
$ test-expr '\''a || ((b != (c && d)) >= e)'\'' -a 2,2,1,0,0
1
$ test-expr '\''a || ((b != (c && d)) >= e)'\'' -a 2,2,2,1,0
1
$ test-expr '\''a || ((b != (c && d)) >= e)'\'' -a 2,2,2,2,1
1
$ test-expr '\''a || ((b != (c >= d)) && e)'\'' -a 0,0,0,1,0
0
$ test-expr '\''a || ((b != (c >= d)) && e)'\'' -a 0,0,0,2,0
0
$ test-expr '\''a || ((b != (c >= d)) && e)'\'' -a 0,0,0,2,1
0
$ test-expr '\''a || ((b != (c >= d)) && e)'\'' -a 0,0,2,1,1
1
$ test-expr '\''a || ((b != (c >= d)) && e)'\'' -a 0,1,1,0,1
0
$ test-expr '\''a || ((b != (c >= d)) && e)'\'' -a 0,1,1,0,2
0
$ test-expr '\''a || ((b != (c >= d)) && e)'\'' -a 0,1,1,1,0
0
$ test-expr '\''a || ((b != (c >= d)) && e)'\'' -a 0,1,1,2,1
1
$ test-expr '\''a || ((b != (c >= d)) && e)'\'' -a 0,1,2,0,2
0
$ test-expr '\''a || ((b != (c >= d)) && e)'\'' -a 0,1,2,1,2
0
$ test-expr '\''a || ((b != (c >= d)) && e)'\'' -a 0,1,2,2,1
0
$ test-expr '\''a || ((b != (c >= d)) && e)'\'' -a 0,2,0,1,1
1
$ test-expr '\''a || ((b != (c >= d)) && e)'\'' -a 1,0,0,0,1
1
$ test-expr '\''a || ((b != (c >= d)) && e)'\'' -a 1,0,1,1,0
1
$ test-expr '\''a || ((b != (c >= d)) && e)'\'' -a 1,0,2,0,1
1
$ test-expr '\''a || ((b != (c >= d)) && e)'\'' -a 1,0,2,0,2
1
$ test-expr '\''a || ((b != (c >= d)) && e)'\'' -a 1,0,2,2,1
1
$ test-expr '\''a || ((b != (c >= d)) && e)'\'' -a 1,1,1,2,1
1
$ test-expr '\''a || ((b != (c >= d)) && e)'\'' -a 1,2,1,0,1
1
$ test-expr '\''a || ((b != (c >= d)) && e)'\'' -a 2,0,1,2,1
1
$ test-expr '\''a || ((b != (c >= d)) && e)'\'' -a 2,0,2,0,1
1
$ test-expr '\''a || ((b != (c >= d)) && e)'\'' -a 2,0,2,0,2
1
$ test-expr '\''a || ((b != (c >= d)) && e)'\'' -a 2,0,2,2,1
1
$ test-expr '\''a || ((b != (c >= d)) && e)'\'' -a 2,1,0,1,0
1
$ test-expr '\''a || ((b != (c >= d)) && e)'\'' -a 2,2,1,0,0
1
$ test-expr '\''a || ((b && c) != (d >= e))'\'' -a 0,0,2,0,1
0
$ test-expr '\''a || ((b && c) != (d >= e))'\'' -a 0,1,1,2,0
0
$ test-expr '\''a || ((b && c) != (d >= e))'\'' -a 0,1,2,0,0
0
$ test-expr '\''a || ((b && c) != (d >= e))'\'' -a 0,2,0,0,0
1
$ test-expr '\''a || ((b && c) != (d >= e))'\'' -a 0,2,0,0,2
0
$ test-expr '\''a || ((b && c) != (d >= e))'\'' -a 0,2,0,2,1
1
$ test-expr '\''a || ((b && c) != (d >= e))'\'' -a 0,2,1,2,1
0
$ test-expr '\''a || ((b && c) != (d >= e))'\'' -a 0,2,2,1,2
1
$ test-expr '\''a || ((b && c) != (d >= e))'\'' -a 0,2,2,2,0
0
$ test-expr '\''a || ((b && c) != (d >= e))'\'' -a 0,2,2,2,1
0
$ test-expr '\''a || ((b && c) != (d >= e))'\'' -a 1,0,2,0,2
1
$ test-expr '\''a || ((b && c) != (d >= e))'\'' -a 1,1,0,1,2
1
$ test-expr '\''a || ((b && c) != (d >= e))'\'' -a 1,1,0,2,0
1
$ test-expr '\''a || ((b && c) != (d >= e))'\'' -a 1,1,1,0,0
1
$ test-expr '\''a || ((b && c) != (d >= e))'\'' -a 1,2,2,1,0
1
$ test-expr '\''a || ((b && c) != (d >= e))'\'' -a 1,2,2,1,2
1
$ test-expr '\''a || ((b && c) != (d >= e))'\'' -a 2,0,2,1,0
1
$ test-expr '\''a || ((b && c) != (d >= e))'\'' -a 2,0,2,1,2
1
$ test-expr '\''a || ((b && c) != (d >= e))'\'' -a 2,0,2,2,0
1
$ test-expr '\''a || ((b && c) != (d >= e))'\'' -a 2,1,1,0,0
1
$ test-expr '\''a || ((b && c) != (d >= e))'\'' -a 2,1,1,2,0
1
$ test-expr '\''a || ((b && c) != (d >= e))'\'' -a 2,1,1,2,2
1
$ test-expr '\''a || ((b && c) != (d >= e))'\'' -a 2,1,2,0,0
1
$ test-expr '\''a || ((b && c) != (d >= e))'\'' -a 2,1,2,1,2
1
$ test-expr '\''a || ((b && c) != (d >= e))'\'' -a 2,2,1,0,2
1
$ test-expr '\''a || ((b && c) != (d >= e))'\'' -a 2,2,2,1,1
1
$ test-expr '\''a || ((b && c) >= (d != e))'\'' -a 0,0,1,0,0
1
$ test-expr '\''a || ((b && c) >= (d != e))'\'' -a 0,0,1,0,2
0
$ test-expr '\''a || ((b && c) >= (d != e))'\'' -a 0,1,0,0,0
1
$ test-expr '\''a || ((b && c) >= (d != e))'\'' -a 0,1,0,1,2
0
$ test-expr '\''a || ((b && c) >= (d != e))'\'' -a 0,1,0,2,2
1
$ test-expr '\''a || ((b && c) >= (d != e))'\'' -a 0,1,1,2,1
1
$ test-expr '\''a || ((b && c) >= (d != e))'\'' -a 0,1,2,0,0
1
$ test-expr '\''a || ((b && c) >= (d != e))'\'' -a 0,1,2,1,0
1
$ test-expr '\''a || ((b && c) >= (d != e))'\'' -a 0,1,2,2,1
1
$ test-expr '\''a || ((b && c) >= (d != e))'\'' -a 0,2,2,2,2
1
$ test-expr '\''a || ((b && c) >= (d != e))'\'' -a 1,0,0,1,0
1
$ test-expr '\''a || ((b && c) >= (d != e))'\'' -a 1,0,2,0,0
1
$ test-expr '\''a || ((b && c) >= (d != e))'\'' -a 1,0,2,2,0
1
$ test-expr '\''a || ((b && c) >= (d != e))'\'' -a 1,1,2,1,0
1
$ test-expr '\''a || ((b && c) >= (d != e))'\'' -a 1,2,0,1,1
1
$ test-expr '\''a || ((b && c) >= (d != e))'\'' -a 1,2,1,2,2
1
$ test-expr '\''a || ((b && c) >= (d != e))'\'' -a 1,2,2,1,2
1
$ test-expr '\''a || ((b && c) >= (d != e))'\'' -a 1,2,2,2,1
1
$ test-expr '\''a || ((b && c) >= (d != e))'\'' -a 2,0,0,0,0
1
$ test-expr '\''a || ((b && c) >= (d != e))'\'' -a 2,0,0,0,1
1
$ test-expr '\''a || ((b && c) >= (d != e))'\'' -a 2,0,0,2,2
1
$ test-expr '\''a || ((b && c) >= (d != e))'\'' -a 2,0,1,0,0
1
$ test-expr '\''a || ((b && c) >= (d != e))'\'' -a 2,0,2,1,2
1
$ test-expr '\''a || ((b && c) >= (d != e))'\'' -a 2,1,0,0,0
1
$ test-expr '\''a || ((b && c) >= (d != e))'\'' -a 2,1,0,1,0
1
$ test-expr '\''a || ((b && c) >= (d != e))'\'' -a 2,1,0,1,1
1
$ test-expr '\''a || ((b && c) >= (d != e))'\'' -a 2,1,1,0,0
1
$ test-expr '\''a || ((b && c) >= (d != e))'\'' -a 2,1,1,1,1
1
$ test-expr '\''a || ((b && c) >= (d != e))'\'' -a 2,1,1,2,0
1
$ test-expr '\''a || ((b && c) >= (d != e))'\'' -a 2,1,2,0,1
1
$ test-expr '\''a || ((b && c) >= (d != e))'\'' -a 2,1,2,0,2
1
$ test-expr '\''a || ((b && c) >= (d != e))'\'' -a 2,2,0,2,2
1
$ test-expr '\''a || ((b && c) >= (d != e))'\'' -a 2,2,1,0,0
1
$ test-expr '\''a || ((b && c) >= (d != e))'\'' -a 2,2,2,0,0
1
$ test-expr '\''a || ((b && (c != d)) >= e)'\'' -a 0,0,0,0,2
0
$ test-expr '\''a || ((b && (c != d)) >= e)'\'' -a 0,1,1,2,1
1
$ test-expr '\''a || ((b && (c != d)) >= e)'\'' -a 0,1,2,1,0
1
$ test-expr '\''a || ((b && (c != d)) >= e)'\'' -a 0,2,1,2,2
0
$ test-expr '\''a || ((b && (c != d)) >= e)'\'' -a 0,2,2,2,2
0
$ test-expr '\''a || ((b && (c != d)) >= e)'\'' -a 1,0,0,0,0
1
$ test-expr '\''a || ((b && (c != d)) >= e)'\'' -a 1,0,0,2,1
1
$ test-expr '\''a || ((b && (c != d)) >= e)'\'' -a 1,0,1,0,0
1
$ test-expr '\''a || ((b && (c != d)) >= e)'\'' -a 1,0,1,0,2
1
$ test-expr '\''a || ((b && (c != d)) >= e)'\'' -a 1,0,1,2,2
1
$ test-expr '\''a || ((b && (c != d)) >= e)'\'' -a 1,1,0,0,0
1
$ test-expr '\''a || ((b && (c != d)) >= e)'\'' -a 1,1,0,0,2
1
$ test-expr '\''a || ((b && (c != d)) >= e)'\'' -a 1,2,0,1,1
1
$ test-expr '\''a || ((b && (c != d)) >= e)'\'' -a 1,2,0,1,2
1
$ test-expr '\''a || ((b && (c != d)) >= e)'\'' -a 1,2,0,2,0
1
$ test-expr '\''a || ((b && (c != d)) >= e)'\'' -a 1,2,0,2,2
1
$ test-expr '\''a || ((b && (c != d)) >= e)'\'' -a 1,2,1,1,0
1
$ test-expr '\''a || ((b && (c != d)) >= e)'\'' -a 1,2,1,1,2
1
$ test-expr '\''a || ((b && (c != d)) >= e)'\'' -a 1,2,1,2,1
1
$ test-expr '\''a || ((b && (c != d)) >= e)'\'' -a 1,2,2,0,1
1
$ test-expr '\''a || ((b && (c != d)) >= e)'\'' -a 1,2,2,0,2
1
$ test-expr '\''a || ((b && (c != d)) >= e)'\'' -a 2,0,0,2,1
1
$ test-expr '\''a || ((b && (c != d)) >= e)'\'' -a 2,0,1,1,1
1
$ test-expr '\''a || ((b && (c != d)) >= e)'\'' -a 2,1,0,2,1
1
$ test-expr '\''a || ((b && (c != d)) >= e)'\'' -a 2,1,1,0,0
1
$ test-expr '\''a || ((b && (c != d)) >= e)'\'' -a 2,1,2,1,0
1
$ test-expr '\''a || ((b && (c != d)) >= e)'\'' -a 2,2,0,2,1
1
$ test-expr '\''a || ((b && (c != d)) >= e)'\'' -a 2,2,1,0,2
1
$ test-expr '\''a || ((b && (c != d)) >= e)'\'' -a 2,2,2,1,0
1
$ test-expr '\''a || ((b && (c != d)) >= e)'\'' -a 2,2,2,1,2
1
$ test-expr '\''a || ((b && (c >= d)) != e)'\'' -a 0,0,0,0,1
1
$ test-expr '\''a || ((b && (c >= d)) != e)'\'' -a 0,0,2,1,0
0
$ test-expr '\''a || ((b && (c >= d)) != e)'\'' -a 0,1,0,0,0
1
$ test-expr '\''a || ((b && (c >= d)) != e)'\'' -a 0,1,0,1,2
1
$ test-expr '\''a || ((b && (c >= d)) != e)'\'' -a 0,1,0,2,1
1
$ test-expr '\''a || ((b && (c >= d)) != e)'\'' -a 0,1,2,2,0
1
$ test-expr '\''a || ((b && (c >= d)) != e)'\'' -a 0,1,2,2,1
0
$ test-expr '\''a || ((b && (c >= d)) != e)'\'' -a 0,2,1,1,1
0
$ test-expr '\''a || ((b && (c >= d)) != e)'\'' -a 0,2,2,1,0
1
$ test-expr '\''a || ((b && (c >= d)) != e)'\'' -a 1,0,1,1,1
1
$ test-expr '\''a || ((b && (c >= d)) != e)'\'' -a 1,0,1,1,2
1
$ test-expr '\''a || ((b && (c >= d)) != e)'\'' -a 1,0,2,1,0
1
$ test-expr '\''a || ((b && (c >= d)) != e)'\'' -a 1,0,2,2,2
1
$ test-expr '\''a || ((b && (c >= d)) != e)'\'' -a 1,1,0,0,0
1
$ test-expr '\''a || ((b && (c >= d)) != e)'\'' -a 1,1,0,1,2
1
$ test-expr '\''a || ((b && (c >= d)) != e)'\'' -a 1,1,1,1,1
1
$ test-expr '\''a || ((b && (c >= d)) != e)'\'' -a 1,1,1,1,2
1
$ test-expr '\''a || ((b && (c >= d)) != e)'\'' -a 1,1,2,0,2
1
$ test-expr '\''a || ((b && (c >= d)) != e)'\'' -a 1,2,0,1,2
1
$ test-expr '\''a || ((b && (c >= d)) != e)'\'' -a 1,2,2,0,1
1
$ test-expr '\''a || ((b && (c >= d)) != e)'\'' -a 2,0,1,1,0
1
$ test-expr '\''a || ((b && (c >= d)) != e)'\'' -a 2,0,2,0,1
1
$ test-expr '\''a || ((b && (c >= d)) != e)'\'' -a 2,1,0,0,0
1
$ test-expr '\''a || ((b && (c >= d)) != e)'\'' -a 2,1,1,1,0
1
$ test-expr '\''a || ((b && (c >= d)) != e)'\'' -a 2,2,0,1,0
1
$ test-expr '\''a || ((b && (c >= d)) != e)'\'' -a 2,2,1,2,0
1
$ test-expr '\''a || ((b && (c >= d)) != e)'\'' -a 2,2,2,0,1
1
$ test-expr '\''a || ((b && (c >= d)) != e)'\'' -a 2,2,2,1,0
1
$ test-expr '\''a || ((b && (c >= d)) != e)'\'' -a 2,2,2,2,1
1
$ test-expr '\''a || ((b >= c) != (d && e))'\'' -a 0,0,0,0,1
1
$ test-expr '\''a || ((b >= c) != (d && e))'\'' -a 0,0,0,1,2
0
$ test-expr '\''a || ((b >= c) != (d && e))'\'' -a 0,0,2,1,1
1
$ test-expr '\''a || ((b >= c) != (d && e))'\'' -a 0,1,1,1,1
0
$ test-expr '\''a || ((b >= c) != (d && e))'\'' -a 0,1,1,2,0
1
$ test-expr '\''a || ((b >= c) != (d && e))'\'' -a 0,1,1,2,2
0
$ test-expr '\''a || ((b >= c) != (d && e))'\'' -a 0,1,2,0,1
0
$ test-expr '\''a || ((b >= c) != (d && e))'\'' -a 0,1,2,1,0
0
$ test-expr '\''a || ((b >= c) != (d && e))'\'' -a 0,1,2,1,2
1
$ test-expr '\''a || ((b >= c) != (d && e))'\'' -a 0,1,2,2,1
1
$ test-expr '\''a || ((b >= c) != (d && e))'\'' -a 0,2,0,0,1
1
$ test-expr '\''a || ((b >= c) != (d && e))'\'' -a 0,2,1,1,1
0
$ test-expr '\''a || ((b >= c) != (d && e))'\'' -a 0,2,2,0,1
1
$ test-expr '\''a || ((b >= c) != (d && e))'\'' -a 0,2,2,1,1
0
$ test-expr '\''a || ((b >= c) != (d && e))'\'' -a 1,0,1,0,0
1
$ test-expr '\''a || ((b >= c) != (d && e))'\'' -a 1,0,2,0,0
1
$ test-expr '\''a || ((b >= c) != (d && e))'\'' -a 1,0,2,2,2
1
$ test-expr '\''a || ((b >= c) != (d && e))'\'' -a 1,1,0,0,2
1
$ test-expr '\''a || ((b >= c) != (d && e))'\'' -a 1,1,0,1,0
1
$ test-expr '\''a || ((b >= c) != (d && e))'\'' -a 1,1,1,1,1
1
$ test-expr '\''a || ((b >= c) != (d && e))'\'' -a 1,1,2,1,0
1
$ test-expr '\''a || ((b >= c) != (d && e))'\'' -a 1,2,0,0,1
1
$ test-expr '\''a || ((b >= c) != (d && e))'\'' -a 1,2,0,2,2
1
$ test-expr '\''a || ((b >= c) != (d && e))'\'' -a 1,2,1,1,2
1
$ test-expr '\''a || ((b >= c) != (d && e))'\'' -a 1,2,2,1,1
1
$ test-expr '\''a || ((b >= c) != (d && e))'\'' -a 2,0,0,0,1
1
$ test-expr '\''a || ((b >= c) != (d && e))'\'' -a 2,0,0,0,2
1
$ test-expr '\''a || ((b >= c) != (d && e))'\'' -a 2,0,0,1,2
1
$ test-expr '\''a || ((b >= c) != (d && e))'\'' -a 2,0,1,0,2
1
$ test-expr '\''a || ((b >= c) != (d && e))'\'' -a 2,1,1,1,2
1
$ test-expr '\''a || ((b >= c) != (d && e))'\'' -a 2,1,1,2,1
1
$ test-expr '\''a || ((b >= c) != (d && e))'\'' -a 2,1,2,2,0
1
$ test-expr '\''a || ((b >= c) != (d && e))'\'' -a 2,1,2,2,1
1
$ test-expr '\''a || ((b >= c) != (d && e))'\'' -a 2,2,0,2,2
1
$ test-expr '\''a || ((b >= c) != (d && e))'\'' -a 2,2,1,0,2
1
$ test-expr '\''a || ((b >= c) != (d && e))'\'' -a 2,2,2,0,1
1
$ test-expr '\''a || ((b >= c) != (d && e))'\'' -a 2,2,2,2,1
1
$ test-expr '\''a || ((b >= c) && (d != e))'\'' -a 0,0,1,0,0
0
$ test-expr '\''a || ((b >= c) && (d != e))'\'' -a 0,0,1,1,1
0
$ test-expr '\''a || ((b >= c) && (d != e))'\'' -a 0,0,2,1,2
0
$ test-expr '\''a || ((b >= c) && (d != e))'\'' -a 0,1,0,2,1
1
$ test-expr '\''a || ((b >= c) && (d != e))'\'' -a 0,1,2,0,2
0
$ test-expr '\''a || ((b >= c) && (d != e))'\'' -a 0,2,2,0,0
0
$ test-expr '\''a || ((b >= c) && (d != e))'\'' -a 1,0,0,0,1
1
$ test-expr '\''a || ((b >= c) && (d != e))'\'' -a 1,0,0,1,2
1
$ test-expr '\''a || ((b >= c) && (d != e))'\'' -a 1,0,1,2,1
1
$ test-expr '\''a || ((b >= c) && (d != e))'\'' -a 1,0,1,2,2
1
$ test-expr '\''a || ((b >= c) && (d != e))'\'' -a 1,1,0,0,2
1
$ test-expr '\''a || ((b >= c) && (d != e))'\'' -a 1,1,1,1,1
1
$ test-expr '\''a || ((b >= c) && (d != e))'\'' -a 1,1,1,1,2
1
$ test-expr '\''a || ((b >= c) && (d != e))'\'' -a 1,1,2,2,0
1
$ test-expr '\''a || ((b >= c) && (d != e))'\'' -a 1,2,0,1,0
1
$ test-expr '\''a || ((b >= c) && (d != e))'\'' -a 1,2,0,1,2
1
$ test-expr '\''a || ((b >= c) && (d != e))'\'' -a 1,2,1,1,0
1
$ test-expr '\''a || ((b >= c) && (d != e))'\'' -a 1,2,2,1,2
1
$ test-expr '\''a || ((b >= c) && (d != e))'\'' -a 2,0,0,2,0
1
$ test-expr '\''a || ((b >= c) && (d != e))'\'' -a 2,0,0,2,1
1
$ test-expr '\''a || ((b >= c) && (d != e))'\'' -a 2,0,0,2,2
1
$ test-expr '\''a || ((b >= c) && (d != e))'\'' -a 2,0,2,1,0
1
$ test-expr '\''a || ((b >= c) && (d != e))'\'' -a 2,1,0,0,2
1
$ test-expr '\''a || ((b >= c) && (d != e))'\'' -a 2,1,1,1,0
1
$ test-expr '\''a || ((b >= c) && (d != e))'\'' -a 2,1,2,1,1
1
$ test-expr '\''a || ((b >= c) && (d != e))'\'' -a 2,2,1,2,1
1
$ test-expr '\''a || ((b >= (c != d)) && e)'\'' -a 0,0,0,0,2
1
$ test-expr '\''a || ((b >= (c != d)) && e)'\'' -a 0,0,0,1,2
0
$ test-expr '\''a || ((b >= (c != d)) && e)'\'' -a 0,0,0,2,0
0
$ test-expr '\''a || ((b >= (c != d)) && e)'\'' -a 0,0,1,0,1
0
$ test-expr '\''a || ((b >= (c != d)) && e)'\'' -a 0,0,1,0,2
0
$ test-expr '\''a || ((b >= (c != d)) && e)'\'' -a 0,0,2,0,1
0
$ test-expr '\''a || ((b >= (c != d)) && e)'\'' -a 0,0,2,0,2
0
$ test-expr '\''a || ((b >= (c != d)) && e)'\'' -a 0,0,2,2,2
1
$ test-expr '\''a || ((b >= (c != d)) && e)'\'' -a 0,1,1,0,0
0
$ test-expr '\''a || ((b >= (c != d)) && e)'\'' -a 0,1,1,0,1
1
$ test-expr '\''a || ((b >= (c != d)) && e)'\'' -a 0,1,1,1,0
0
$ test-expr '\''a || ((b >= (c != d)) && e)'\'' -a 0,2,1,0,0
0
$ test-expr '\''a || ((b >= (c != d)) && e)'\'' -a 0,2,1,0,1
1
$ test-expr '\''a || ((b >= (c != d)) && e)'\'' -a 0,2,1,0,2
1
$ test-expr '\''a || ((b >= (c != d)) && e)'\'' -a 0,2,1,2,0
0
$ test-expr '\''a || ((b >= (c != d)) && e)'\'' -a 0,2,1,2,2
1
$ test-expr '\''a || ((b >= (c != d)) && e)'\'' -a 1,0,1,0,0
1
$ test-expr '\''a || ((b >= (c != d)) && e)'\'' -a 1,0,1,0,1
1
$ test-expr '\''a || ((b >= (c != d)) && e)'\'' -a 1,0,1,1,1
1
$ test-expr '\''a || ((b >= (c != d)) && e)'\'' -a 1,0,2,0,1
1
$ test-expr '\''a || ((b >= (c != d)) && e)'\'' -a 1,0,2,2,0
1
$ test-expr '\''a || ((b >= (c != d)) && e)'\'' -a 1,0,2,2,1
1
$ test-expr '\''a || ((b >= (c != d)) && e)'\'' -a 1,1,1,0,2
1
$ test-expr '\''a || ((b >= (c != d)) && e)'\'' -a 1,1,2,1,0
1
$ test-expr '\''a || ((b >= (c != d)) && e)'\'' -a 1,2,1,0,2
1
$ test-expr '\''a || ((b >= (c != d)) && e)'\'' -a 1,2,2,2,2
1
$ test-expr '\''a || ((b >= (c != d)) && e)'\'' -a 2,0,0,0,2
1
$ test-expr '\''a || ((b >= (c != d)) && e)'\'' -a 2,0,1,0,1
1
$ test-expr '\''a || ((b >= (c != d)) && e)'\'' -a 2,0,1,2,2
1
$ test-expr '\''a || ((b >= (c != d)) && e)'\'' -a 2,0,2,0,0
1
$ test-expr '\''a || ((b >= (c != d)) && e)'\'' -a 2,1,0,0,1
1
$ test-expr '\''a || ((b >= (c != d)) && e)'\'' -a 2,1,0,2,1
1
$ test-expr '\''a || ((b >= (c != d)) && e)'\'' -a 2,1,1,1,1
1
$ test-expr '\''a || ((b >= (c != d)) && e)'\'' -a 2,1,1,2,2
1
$ test-expr '\''a || ((b >= (c != d)) && e)'\'' -a 2,1,2,0,0
1
$ test-expr '\''a || ((b >= (c != d)) && e)'\'' -a 2,2,0,1,0
1
$ test-expr '\''a || ((b >= (c != d)) && e)'\'' -a 2,2,0,1,1
1
$ test-expr '\''a || ((b >= (c != d)) && e)'\'' -a 2,2,1,1,0
1
$ test-expr '\''a || ((b >= (c != d)) && e)'\'' -a 2,2,1,2,0
1
$ test-expr '\''a || ((b >= (c != d)) && e)'\'' -a 2,2,2,0,0
1
$ test-expr '\''a || ((b >= (c != d)) && e)'\'' -a 2,2,2,2,2
1
$ test-expr '\''a || ((b >= (c && d)) != e)'\'' -a 0,0,1,1,2
1
$ test-expr '\''a || ((b >= (c && d)) != e)'\'' -a 0,0,2,1,0
0
$ test-expr '\''a || ((b >= (c && d)) != e)'\'' -a 0,1,0,1,1
0
$ test-expr '\''a || ((b >= (c && d)) != e)'\'' -a 0,1,2,2,0
1
$ test-expr '\''a || ((b >= (c && d)) != e)'\'' -a 0,2,0,0,2
1
$ test-expr '\''a || ((b >= (c && d)) != e)'\'' -a 0,2,0,2,0
1
$ test-expr '\''a || ((b >= (c && d)) != e)'\'' -a 0,2,1,0,0
1
$ test-expr '\''a || ((b >= (c && d)) != e)'\'' -a 0,2,1,1,1
0
$ test-expr '\''a || ((b >= (c && d)) != e)'\'' -a 0,2,1,2,1
0
$ test-expr '\''a || ((b >= (c && d)) != e)'\'' -a 1,0,0,0,1
1
$ test-expr '\''a || ((b >= (c && d)) != e)'\'' -a 1,0,1,1,0
1
$ test-expr '\''a || ((b >= (c && d)) != e)'\'' -a 1,0,1,2,1
1
$ test-expr '\''a || ((b >= (c && d)) != e)'\'' -a 1,0,2,0,2
1
$ test-expr '\''a || ((b >= (c && d)) != e)'\'' -a 1,0,2,2,0
1
$ test-expr '\''a || ((b >= (c && d)) != e)'\'' -a 1,0,2,2,2
1
$ test-expr '\''a || ((b >= (c && d)) != e)'\'' -a 1,1,0,1,1
1
$ test-expr '\''a || ((b >= (c && d)) != e)'\'' -a 1,1,2,1,0
1
$ test-expr '\''a || ((b >= (c && d)) != e)'\'' -a 1,1,2,1,2
1
$ test-expr '\''a || ((b >= (c && d)) != e)'\'' -a 1,2,0,1,1
1
$ test-expr '\''a || ((b >= (c && d)) != e)'\'' -a 1,2,0,2,1
1
$ test-expr '\''a || ((b >= (c && d)) != e)'\'' -a 1,2,1,0,1
1
$ test-expr '\''a || ((b >= (c && d)) != e)'\'' -a 1,2,1,2,1
1
$ test-expr '\''a || ((b >= (c && d)) != e)'\'' -a 1,2,2,2,0
1
$ test-expr '\''a || ((b >= (c && d)) != e)'\'' -a 2,0,0,0,0
1
$ test-expr '\''a || ((b >= (c && d)) != e)'\'' -a 2,0,0,1,0
1
$ test-expr '\''a || ((b >= (c && d)) != e)'\'' -a 2,0,1,1,2
1
$ test-expr '\''a || ((b >= (c && d)) != e)'\'' -a 2,0,1,2,1
1
$ test-expr '\''a || ((b >= (c && d)) != e)'\'' -a 2,0,1,2,2
1
$ test-expr '\''a || ((b >= (c && d)) != e)'\'' -a 2,0,2,1,2
1
$ test-expr '\''a || ((b >= (c && d)) != e)'\'' -a 2,0,2,2,0
1
$ test-expr '\''a || ((b >= (c && d)) != e)'\'' -a 2,1,0,0,1
1
$ test-expr '\''a || ((b >= (c && d)) != e)'\'' -a 2,1,1,1,1
1
$ test-expr '\''a || ((b >= (c && d)) != e)'\'' -a 2,1,2,0,2
1
$ test-expr '\''a || ((b >= (c && d)) != e)'\'' -a 2,1,2,1,2
1
$ test-expr '\''a || ((b >= (c && d)) != e)'\'' -a 2,1,2,2,2
1
$ test-expr '\''a || ((b >= (c && d)) != e)'\'' -a 2,2,0,0,0
1
$ test-expr '\''a || ((b >= (c && d)) != e)'\'' -a 2,2,1,1,1
1
$ test-expr '\''a || ((b >= (c && d)) != e)'\'' -a 2,2,1,2,2
1
$ test-expr '\''a || ((b >= (c && d)) != e)'\'' -a 2,2,2,2,0
1
$ test-expr '\''a || (((b != c) && d) >= e)'\'' -a 0,1,1,0,2
0
$ test-expr '\''a || (((b != c) && d) >= e)'\'' -a 0,2,0,1,0
1
$ test-expr '\''a || (((b != c) && d) >= e)'\'' -a 1,0,0,1,1
1
$ test-expr '\''a || (((b != c) && d) >= e)'\'' -a 1,0,1,2,1
1
$ test-expr '\''a || (((b != c) && d) >= e)'\'' -a 1,1,1,0,1
1
$ test-expr '\''a || (((b != c) && d) >= e)'\'' -a 1,1,2,1,1
1
$ test-expr '\''a || (((b != c) && d) >= e)'\'' -a 1,2,1,0,2
1
$ test-expr '\''a || (((b != c) && d) >= e)'\'' -a 1,2,1,2,2
1
$ test-expr '\''a || (((b != c) && d) >= e)'\'' -a 2,0,0,1,2
1
$ test-expr '\''a || (((b != c) && d) >= e)'\'' -a 2,1,0,2,2
1
$ test-expr '\''a || (((b != c) && d) >= e)'\'' -a 2,1,1,1,1
1
$ test-expr '\''a || (((b != c) && d) >= e)'\'' -a 2,1,1,2,0
1
$ test-expr '\''a || (((b != c) && d) >= e)'\'' -a 2,1,2,0,0
1
$ test-expr '\''a || (((b != c) && d) >= e)'\'' -a 2,1,2,1,2
1
$ test-expr '\''a || (((b != c) && d) >= e)'\'' -a 2,1,2,2,1
1
$ test-expr '\''a || (((b != c) && d) >= e)'\'' -a 2,2,0,0,0
1
$ test-expr '\''a || (((b != c) && d) >= e)'\'' -a 2,2,0,0,2
1
$ test-expr '\''a || (((b != c) && d) >= e)'\'' -a 2,2,0,2,0
1
$ test-expr '\''a || (((b != c) && d) >= e)'\'' -a 2,2,1,1,0
1
$ test-expr '\''a || (((b != c) && d) >= e)'\'' -a 2,2,1,2,2
1
$ test-expr '\''a || (((b != c) && d) >= e)'\'' -a 2,2,2,2,2
1
$ test-expr '\''a || (((b != c) >= d) && e)'\'' -a 0,0,2,0,0
0
$ test-expr '\''a || (((b != c) >= d) && e)'\'' -a 0,1,0,0,1
1
$ test-expr '\''a || (((b != c) >= d) && e)'\'' -a 0,1,0,1,1
1
$ test-expr '\''a || (((b != c) >= d) && e)'\'' -a 0,1,2,0,2
1
$ test-expr '\''a || (((b != c) >= d) && e)'\'' -a 0,1,2,1,0
0
$ test-expr '\''a || (((b != c) >= d) && e)'\'' -a 0,1,2,1,1
1
$ test-expr '\''a || (((b != c) >= d) && e)'\'' -a 0,2,0,1,2
1
$ test-expr '\''a || (((b != c) >= d) && e)'\'' -a 0,2,1,2,2
0
$ test-expr '\''a || (((b != c) >= d) && e)'\'' -a 0,2,2,0,0
0
$ test-expr '\''a || (((b != c) >= d) && e)'\'' -a 0,2,2,1,2
0
$ test-expr '\''a || (((b != c) >= d) && e)'\'' -a 1,0,0,0,1
1
$ test-expr '\''a || (((b != c) >= d) && e)'\'' -a 1,0,0,1,1
1
$ test-expr '\''a || (((b != c) >= d) && e)'\'' -a 1,0,1,2,1
1
$ test-expr '\''a || (((b != c) >= d) && e)'\'' -a 1,1,0,1,0
1
$ test-expr '\''a || (((b != c) >= d) && e)'\'' -a 1,1,0,2,1
1
$ test-expr '\''a || (((b != c) >= d) && e)'\'' -a 1,1,2,0,2
1
$ test-expr '\''a || (((b != c) >= d) && e)'\'' -a 1,2,0,0,1
1
$ test-expr '\''a || (((b != c) >= d) && e)'\'' -a 1,2,0,0,2
1
$ test-expr '\''a || (((b != c) >= d) && e)'\'' -a 1,2,0,1,0
1
$ test-expr '\''a || (((b != c) >= d) && e)'\'' -a 1,2,1,2,1
1
$ test-expr '\''a || (((b != c) >= d) && e)'\'' -a 2,1,0,2,2
1
$ test-expr '\''a || (((b != c) >= d) && e)'\'' -a 2,1,2,0,0
1
$ test-expr '\''a || (((b != c) >= d) && e)'\'' -a 2,1,2,0,2
1
$ test-expr '\''a || (((b != c) >= d) && e)'\'' -a 2,1,2,2,2
1
$ test-expr '\''a || (((b != c) >= d) && e)'\'' -a 2,2,1,0,0
1
$ test-expr '\''a || (((b != c) >= d) && e)'\'' -a 2,2,1,2,2
1
$ test-expr '\''a || (((b && c) != d) >= e)'\'' -a 0,0,0,2,0
1
$ test-expr '\''a || (((b && c) != d) >= e)'\'' -a 0,0,1,0,0
1
$ test-expr '\''a || (((b && c) != d) >= e)'\'' -a 0,1,0,0,0
1
$ test-expr '\''a || (((b && c) != d) >= e)'\'' -a 0,1,0,2,2
0
$ test-expr '\''a || (((b && c) != d) >= e)'\'' -a 0,1,1,1,0
1
$ test-expr '\''a || (((b && c) != d) >= e)'\'' -a 0,1,2,1,1
0
$ test-expr '\''a || (((b && c) != d) >= e)'\'' -a 0,2,0,0,2
0
$ test-expr '\''a || (((b && c) != d) >= e)'\'' -a 0,2,0,2,2
0
$ test-expr '\''a || (((b && c) != d) >= e)'\'' -a 0,2,1,1,1
0
$ test-expr '\''a || (((b && c) != d) >= e)'\'' -a 0,2,1,2,1
1
$ test-expr '\''a || (((b && c) != d) >= e)'\'' -a 0,2,2,0,2
0
$ test-expr '\''a || (((b && c) != d) >= e)'\'' -a 0,2,2,1,2
0
$ test-expr '\''a || (((b && c) != d) >= e)'\'' -a 1,0,1,1,2
1
$ test-expr '\''a || (((b && c) != d) >= e)'\'' -a 1,0,2,0,1
1
$ test-expr '\''a || (((b && c) != d) >= e)'\'' -a 1,0,2,1,2
1
$ test-expr '\''a || (((b && c) != d) >= e)'\'' -a 1,0,2,2,2
1
$ test-expr '\''a || (((b && c) != d) >= e)'\'' -a 1,1,0,0,0
1
$ test-expr '\''a || (((b && c) != d) >= e)'\'' -a 1,1,0,0,1
1
$ test-expr '\''a || (((b && c) != d) >= e)'\'' -a 1,1,1,1,2
1
$ test-expr '\''a || (((b && c) != d) >= e)'\'' -a 1,1,2,0,2
1
$ test-expr '\''a || (((b && c) != d) >= e)'\'' -a 2,0,1,2,0
1
$ test-expr '\''a || (((b && c) != d) >= e)'\'' -a 2,1,0,0,0
1
$ test-expr '\''a || (((b && c) != d) >= e)'\'' -a 2,1,0,2,0
1
$ test-expr '\''a || (((b && c) != d) >= e)'\'' -a 2,1,2,1,0
1
$ test-expr '\''a || (((b && c) != d) >= e)'\'' -a 2,2,1,1,1
1
$ test-expr '\''a || (((b && c) != d) >= e)'\'' -a 2,2,2,0,0
1
$ test-expr '\''a || (((b && c) >= d) != e)'\'' -a 0,0,0,0,2
1
$ test-expr '\''a || (((b && c) >= d) != e)'\'' -a 0,0,0,1,2
1
$ test-expr '\''a || (((b && c) >= d) != e)'\'' -a 0,0,2,0,1
0
$ test-expr '\''a || (((b && c) >= d) != e)'\'' -a 0,1,0,0,1
0
$ test-expr '\''a || (((b && c) >= d) != e)'\'' -a 0,1,1,0,0
1
$ test-expr '\''a || (((b && c) >= d) != e)'\'' -a 0,1,1,0,2
1
$ test-expr '\''a || (((b && c) >= d) != e)'\'' -a 0,1,1,1,2
1
$ test-expr '\''a || (((b && c) >= d) != e)'\'' -a 0,1,2,2,0
0
$ test-expr '\''a || (((b && c) >= d) != e)'\'' -a 0,2,0,2,2
1
$ test-expr '\''a || (((b && c) >= d) != e)'\'' -a 0,2,1,1,1
0
$ test-expr '\''a || (((b && c) >= d) != e)'\'' -a 0,2,2,0,1
0
$ test-expr '\''a || (((b && c) >= d) != e)'\'' -a 1,0,0,1,1
1
$ test-expr '\''a || (((b && c) >= d) != e)'\'' -a 1,0,0,2,1
1
$ test-expr '\''a || (((b && c) >= d) != e)'\'' -a 1,0,1,0,1
1
$ test-expr '\''a || (((b && c) >= d) != e)'\'' -a 1,0,1,1,0
1
$ test-expr '\''a || (((b && c) >= d) != e)'\'' -a 1,0,2,0,1
1
$ test-expr '\''a || (((b && c) >= d) != e)'\'' -a 1,1,1,1,2
1
$ test-expr '\''a || (((b && c) >= d) != e)'\'' -a 1,1,2,0,1
1
$ test-expr '\''a || (((b && c) >= d) != e)'\'' -a 1,2,0,0,1
1
$ test-expr '\''a || (((b && c) >= d) != e)'\'' -a 2,0,2,2,2
1
$ test-expr '\''a || (((b && c) >= d) != e)'\'' -a 2,1,0,1,0
1
$ test-expr '\''a || (((b && c) >= d) != e)'\'' -a 2,1,1,0,1
1
$ test-expr '\''a || (((b && c) >= d) != e)'\'' -a 2,1,2,2,2
1
$ test-expr '\''a || (((b && c) >= d) != e)'\'' -a 2,2,0,1,2
1
$ test-expr '\''a || (((b && c) >= d) != e)'\'' -a 2,2,0,2,1
1
$ test-expr '\''a || (((b >= c) != d) && e)'\'' -a 0,0,2,1,0
0
$ test-expr '\''a || (((b >= c) != d) && e)'\'' -a 0,1,0,0,2
1
$ test-expr '\''a || (((b >= c) != d) && e)'\'' -a 0,1,1,2,2
1
$ test-expr '\''a || (((b >= c) != d) && e)'\'' -a 0,2,1,0,0
0
$ test-expr '\''a || (((b >= c) != d) && e)'\'' -a 1,0,1,1,2
1
$ test-expr '\''a || (((b >= c) != d) && e)'\'' -a 1,0,1,2,0
1
$ test-expr '\''a || (((b >= c) != d) && e)'\'' -a 1,0,2,0,1
1
$ test-expr '\''a || (((b >= c) != d) && e)'\'' -a 1,1,0,1,1
1
$ test-expr '\''a || (((b >= c) != d) && e)'\'' -a 1,1,2,0,0
1
$ test-expr '\''a || (((b >= c) != d) && e)'\'' -a 1,1,2,0,1
1
$ test-expr '\''a || (((b >= c) != d) && e)'\'' -a 1,1,2,2,2
1
$ test-expr '\''a || (((b >= c) != d) && e)'\'' -a 1,2,0,0,1
1
$ test-expr '\''a || (((b >= c) != d) && e)'\'' -a 1,2,0,1,2
1
$ test-expr '\''a || (((b >= c) != d) && e)'\'' -a 1,2,1,1,1
1
$ test-expr '\''a || (((b >= c) != d) && e)'\'' -a 1,2,1,2,1
1
$ test-expr '\''a || (((b >= c) != d) && e)'\'' -a 1,2,2,2,2
1
$ test-expr '\''a || (((b >= c) != d) && e)'\'' -a 2,0,0,0,1
1
$ test-expr '\''a || (((b >= c) != d) && e)'\'' -a 2,0,1,1,1
1
$ test-expr '\''a || (((b >= c) != d) && e)'\'' -a 2,0,2,0,2
1
$ test-expr '\''a || (((b >= c) != d) && e)'\'' -a 2,0,2,2,0
1
$ test-expr '\''a || (((b >= c) != d) && e)'\'' -a 2,1,1,1,1
1
$ test-expr '\''a || (((b >= c) != d) && e)'\'' -a 2,2,0,1,0
1
$ test-expr '\''a || (((b >= c) != d) && e)'\'' -a 2,2,0,2,0
1
$ test-expr '\''a || (((b >= c) != d) && e)'\'' -a 2,2,1,0,0
1
$ test-expr '\''a || (((b >= c) != d) && e)'\'' -a 2,2,2,1,1
1
$ test-expr '\''a || (((b >= c) && d) != e)'\'' -a 0,0,0,0,1
1
$ test-expr '\''a || (((b >= c) && d) != e)'\'' -a 0,0,0,1,2
1
$ test-expr '\''a || (((b >= c) && d) != e)'\'' -a 0,0,0,2,0
1
$ test-expr '\''a || (((b >= c) && d) != e)'\'' -a 0,0,0,2,2
1
$ test-expr '\''a || (((b >= c) && d) != e)'\'' -a 0,0,1,2,2
1
$ test-expr '\''a || (((b >= c) && d) != e)'\'' -a 0,1,0,2,0
1
$ test-expr '\''a || (((b >= c) && d) != e)'\'' -a 0,2,0,1,2
1
$ test-expr '\''a || (((b >= c) && d) != e)'\'' -a 0,2,1,0,0
0
$ test-expr '\''a || (((b >= c) && d) != e)'\'' -a 1,0,0,1,2
1
$ test-expr '\''a || (((b >= c) && d) != e)'\'' -a 1,0,1,2,2
1
$ test-expr '\''a || (((b >= c) && d) != e)'\'' -a 1,1,0,1,2
1
$ test-expr '\''a || (((b >= c) && d) != e)'\'' -a 1,1,1,1,1
1
$ test-expr '\''a || (((b >= c) && d) != e)'\'' -a 1,1,2,1,0
1
$ test-expr '\''a || (((b >= c) && d) != e)'\'' -a 1,2,0,0,2
1
$ test-expr '\''a || (((b >= c) && d) != e)'\'' -a 1,2,0,1,1
1
$ test-expr '\''a || (((b >= c) && d) != e)'\'' -a 1,2,0,2,1
1
$ test-expr '\''a || (((b >= c) && d) != e)'\'' -a 1,2,0,2,2
1
$ test-expr '\''a || (((b >= c) && d) != e)'\'' -a 1,2,1,0,2
1
$ test-expr '\''a || (((b >= c) && d) != e)'\'' -a 1,2,2,0,0
1
$ test-expr '\''a || (((b >= c) && d) != e)'\'' -a 2,0,0,0,2
1
$ test-expr '\''a || (((b >= c) && d) != e)'\'' -a 2,0,1,1,0
1
$ test-expr '\''a || (((b >= c) && d) != e)'\'' -a 2,0,1,1,2
1
$ test-expr '\''a || (((b >= c) && d) != e)'\'' -a 2,0,1,2,1
1
$ test-expr '\''a || (((b >= c) && d) != e)'\'' -a 2,0,2,0,0
1
$ test-expr '\''a || (((b >= c) && d) != e)'\'' -a 2,0,2,2,0
1
$ test-expr '\''a || (((b >= c) && d) != e)'\'' -a 2,0,2,2,1
1
$ test-expr '\''a || (((b >= c) && d) != e)'\'' -a 2,0,2,2,2
1
$ test-expr '\''a || (((b >= c) && d) != e)'\'' -a 2,1,0,2,2
1
$ test-expr '\''a || (((b >= c) && d) != e)'\'' -a 2,1,1,1,0
1
$ test-expr '\''a || (((b >= c) && d) != e)'\'' -a 2,1,1,2,2
1
$ test-expr '\''a || (((b >= c) && d) != e)'\'' -a 2,1,2,2,2
1
$ test-expr '\''a || (((b >= c) && d) != e)'\'' -a 2,2,0,0,2
1
$ test-expr '\''a || (((b >= c) && d) != e)'\'' -a 2,2,1,0,0
1
$ test-expr '\''(a != b) && (c >= (d || e))'\'' -a 0,0,1,0,0
0
$ test-expr '\''(a != b) && (c >= (d || e))'\'' -a 0,0,2,0,1
0
$ test-expr '\''(a != b) && (c >= (d || e))'\'' -a 0,1,0,2,0
0
$ test-expr '\''(a != b) && (c >= (d || e))'\'' -a 0,1,1,2,0
1
$ test-expr '\''(a != b) && (c >= (d || e))'\'' -a 0,1,1,2,2
1
$ test-expr '\''(a != b) && (c >= (d || e))'\'' -a 0,2,1,2,0
1
$ test-expr '\''(a != b) && (c >= (d || e))'\'' -a 0,2,2,0,0
1
$ test-expr '\''(a != b) && (c >= (d || e))'\'' -a 1,0,0,2,1
0
$ test-expr '\''(a != b) && (c >= (d || e))'\'' -a 1,0,1,0,1
1
$ test-expr '\''(a != b) && (c >= (d || e))'\'' -a 1,0,1,0,2
1
$ test-expr '\''(a != b) && (c >= (d || e))'\'' -a 1,0,1,1,2
1
$ test-expr '\''(a != b) && (c >= (d || e))'\'' -a 1,0,1,2,2
1
$ test-expr '\''(a != b) && (c >= (d || e))'\'' -a 1,0,2,0,1
1
$ test-expr '\''(a != b) && (c >= (d || e))'\'' -a 1,0,2,1,0
1
$ test-expr '\''(a != b) && (c >= (d || e))'\'' -a 1,0,2,1,1
1
$ test-expr '\''(a != b) && (c >= (d || e))'\'' -a 1,1,0,2,2
0
$ test-expr '\''(a != b) && (c >= (d || e))'\'' -a 1,1,1,1,0
0
$ test-expr '\''(a != b) && (c >= (d || e))'\'' -a 1,1,1,2,2
0
$ test-expr '\''(a != b) && (c >= (d || e))'\'' -a 1,2,0,2,0
0
$ test-expr '\''(a != b) && (c >= (d || e))'\'' -a 1,2,1,0,0
1
$ test-expr '\''(a != b) && (c >= (d || e))'\'' -a 1,2,1,0,1
1
$ test-expr '\''(a != b) && (c >= (d || e))'\'' -a 1,2,2,0,1
1
$ test-expr '\''(a != b) && (c >= (d || e))'\'' -a 2,0,0,1,1
0
$ test-expr '\''(a != b) && (c >= (d || e))'\'' -a 2,0,1,1,0
1
$ test-expr '\''(a != b) && (c >= (d || e))'\'' -a 2,0,1,1,1
1
$ test-expr '\''(a != b) && (c >= (d || e))'\'' -a 2,0,1,2,1
1
$ test-expr '\''(a != b) && (c >= (d || e))'\'' -a 2,0,2,0,1
1
$ test-expr '\''(a != b) && (c >= (d || e))'\'' -a 2,0,2,1,2
1
$ test-expr '\''(a != b) && (c >= (d || e))'\'' -a 2,1,0,0,0
1
$ test-expr '\''(a != b) && (c >= (d || e))'\'' -a 2,1,0,0,2
0
$ test-expr '\''(a != b) && (c >= (d || e))'\'' -a 2,1,0,2,0
0
$ test-expr '\''(a != b) && (c >= (d || e))'\'' -a 2,1,1,0,0
1
$ test-expr '\''(a != b) && (c >= (d || e))'\'' -a 2,1,2,0,0
1
$ test-expr '\''(a != b) && (c >= (d || e))'\'' -a 2,2,0,2,1
0
$ test-expr '\''(a != b) && (c >= (d || e))'\'' -a 2,2,2,0,2
0
$ test-expr '\''(a != b) && (c || (d >= e))'\'' -a 0,0,2,0,2
0
$ test-expr '\''(a != b) && (c || (d >= e))'\'' -a 0,0,2,1,2
0
$ test-expr '\''(a != b) && (c || (d >= e))'\'' -a 0,0,2,2,1
0
$ test-expr '\''(a != b) && (c || (d >= e))'\'' -a 0,1,0,1,2
0
$ test-expr '\''(a != b) && (c || (d >= e))'\'' -a 0,1,0,2,0
1
$ test-expr '\''(a != b) && (c || (d >= e))'\'' -a 0,1,2,0,2
1
$ test-expr '\''(a != b) && (c || (d >= e))'\'' -a 0,2,1,0,2
1
$ test-expr '\''(a != b) && (c || (d >= e))'\'' -a 0,2,1,1,1
1
$ test-expr '\''(a != b) && (c || (d >= e))'\'' -a 0,2,1,2,0
1
$ test-expr '\''(a != b) && (c || (d >= e))'\'' -a 0,2,1,2,1
1
$ test-expr '\''(a != b) && (c || (d >= e))'\'' -a 0,2,2,0,2
1
$ test-expr '\''(a != b) && (c || (d >= e))'\'' -a 1,0,0,0,0
1
$ test-expr '\''(a != b) && (c || (d >= e))'\'' -a 1,1,1,1,2
0
$ test-expr '\''(a != b) && (c || (d >= e))'\'' -a 1,1,2,2,2
0
$ test-expr '\''(a != b) && (c || (d >= e))'\'' -a 1,2,0,1,2
0
$ test-expr '\''(a != b) && (c || (d >= e))'\'' -a 1,2,2,2,1
1
$ test-expr '\''(a != b) && (c || (d >= e))'\'' -a 2,0,0,1,0
1
$ test-expr '\''(a != b) && (c || (d >= e))'\'' -a 2,0,1,2,1
1
$ test-expr '\''(a != b) && (c || (d >= e))'\'' -a 2,0,2,0,0
1
$ test-expr '\''(a != b) && (c || (d >= e))'\'' -a 2,0,2,0,2
1
$ test-expr '\''(a != b) && (c || (d >= e))'\'' -a 2,2,1,1,1
0
$ test-expr '\''(a != b) && ((c >= d) || e)'\'' -a 0,0,0,1,0
0
$ test-expr '\''(a != b) && ((c >= d) || e)'\'' -a 0,0,1,1,2
0
$ test-expr '\''(a != b) && ((c >= d) || e)'\'' -a 0,0,2,2,0
0
$ test-expr '\''(a != b) && ((c >= d) || e)'\'' -a 0,1,0,0,1
1
$ test-expr '\''(a != b) && ((c >= d) || e)'\'' -a 0,2,0,0,0
1
$ test-expr '\''(a != b) && ((c >= d) || e)'\'' -a 0,2,0,0,1
1
$ test-expr '\''(a != b) && ((c >= d) || e)'\'' -a 1,0,0,0,0
1
$ test-expr '\''(a != b) && ((c >= d) || e)'\'' -a 1,0,0,2,0
0
$ test-expr '\''(a != b) && ((c >= d) || e)'\'' -a 1,0,1,2,2
1
$ test-expr '\''(a != b) && ((c >= d) || e)'\'' -a 1,0,2,0,2
1
$ test-expr '\''(a != b) && ((c >= d) || e)'\'' -a 1,1,0,1,1
0
$ test-expr '\''(a != b) && ((c >= d) || e)'\'' -a 1,1,0,2,0
0
$ test-expr '\''(a != b) && ((c >= d) || e)'\'' -a 1,1,2,1,0
0
$ test-expr '\''(a != b) && ((c >= d) || e)'\'' -a 1,2,0,2,2
1
$ test-expr '\''(a != b) && ((c >= d) || e)'\'' -a 1,2,2,0,0
1
$ test-expr '\''(a != b) && ((c >= d) || e)'\'' -a 2,0,1,1,2
1
$ test-expr '\''(a != b) && ((c >= d) || e)'\'' -a 2,0,2,2,1
1
$ test-expr '\''(a != b) && ((c >= d) || e)'\'' -a 2,1,0,1,2
1
$ test-expr '\''(a != b) && ((c >= d) || e)'\'' -a 2,1,2,0,1
1
$ test-expr '\''(a != b) && ((c >= d) || e)'\'' -a 2,1,2,1,2
1
$ test-expr '\''(a != b) && ((c >= d) || e)'\'' -a 2,2,0,0,0
0
$ test-expr '\''(a != b) && ((c >= d) || e)'\'' -a 2,2,0,0,1
0
$ test-expr '\''(a != b) && ((c >= d) || e)'\'' -a 2,2,0,2,2
0
$ test-expr '\''(a != b) && ((c >= d) || e)'\'' -a 2,2,2,1,0
0
$ test-expr '\''(a != b) && ((c || d) >= e)'\'' -a 0,0,0,0,2
0
$ test-expr '\''(a != b) && ((c || d) >= e)'\'' -a 0,0,0,1,0
0
$ test-expr '\''(a != b) && ((c || d) >= e)'\'' -a 0,0,1,1,2
0
$ test-expr '\''(a != b) && ((c || d) >= e)'\'' -a 0,0,2,1,1
0
$ test-expr '\''(a != b) && ((c || d) >= e)'\'' -a 0,0,2,2,1
0
$ test-expr '\''(a != b) && ((c || d) >= e)'\'' -a 0,1,0,2,2
0
$ test-expr '\''(a != b) && ((c || d) >= e)'\'' -a 0,2,0,2,0
1
$ test-expr '\''(a != b) && ((c || d) >= e)'\'' -a 0,2,0,2,2
0
$ test-expr '\''(a != b) && ((c || d) >= e)'\'' -a 0,2,1,1,0
1
$ test-expr '\''(a != b) && ((c || d) >= e)'\'' -a 0,2,1,2,0
1
$ test-expr '\''(a != b) && ((c || d) >= e)'\'' -a 0,2,1,2,2
0
$ test-expr '\''(a != b) && ((c || d) >= e)'\'' -a 0,2,2,0,0
1
$ test-expr '\''(a != b) && ((c || d) >= e)'\'' -a 1,0,0,0,0
1
$ test-expr '\''(a != b) && ((c || d) >= e)'\'' -a 1,0,1,1,2
0
$ test-expr '\''(a != b) && ((c || d) >= e)'\'' -a 1,0,2,0,0
1
$ test-expr '\''(a != b) && ((c || d) >= e)'\'' -a 1,0,2,1,1
1
$ test-expr '\''(a != b) && ((c || d) >= e)'\'' -a 1,0,2,2,0
1
$ test-expr '\''(a != b) && ((c || d) >= e)'\'' -a 1,1,0,0,1
0
$ test-expr '\''(a != b) && ((c || d) >= e)'\'' -a 1,1,1,0,1
0
$ test-expr '\''(a != b) && ((c || d) >= e)'\'' -a 1,1,1,1,0
0
$ test-expr '\''(a != b) && ((c || d) >= e)'\'' -a 1,1,2,0,0
0
$ test-expr '\''(a != b) && ((c || d) >= e)'\'' -a 1,2,0,1,2
0
$ test-expr '\''(a != b) && ((c || d) >= e)'\'' -a 1,2,0,2,0
1
$ test-expr '\''(a != b) && ((c || d) >= e)'\'' -a 1,2,1,1,1
1
$ test-expr '\''(a != b) && ((c || d) >= e)'\'' -a 1,2,1,2,2
0
$ test-expr '\''(a != b) && ((c || d) >= e)'\'' -a 1,2,2,0,1
1
$ test-expr '\''(a != b) && ((c || d) >= e)'\'' -a 1,2,2,1,1
1
$ test-expr '\''(a != b) && ((c || d) >= e)'\'' -a 1,2,2,1,2
0
$ test-expr '\''(a != b) && ((c || d) >= e)'\'' -a 2,0,0,2,2
0
$ test-expr '\''(a != b) && ((c || d) >= e)'\'' -a 2,0,1,2,0
1
$ test-expr '\''(a != b) && ((c || d) >= e)'\'' -a 2,1,0,1,1
1
$ test-expr '\''(a != b) && ((c || d) >= e)'\'' -a 2,1,1,2,0
1
$ test-expr '\''(a != b) && ((c || d) >= e)'\'' -a 2,1,1,2,2
0
$ test-expr '\''(a != b) && ((c || d) >= e)'\'' -a 2,2,1,0,2
0
$ test-expr '\''(a != b) && ((c || d) >= e)'\'' -a 2,2,1,2,1
0
$ test-expr '\''(a != b) && ((c || d) >= e)'\'' -a 2,2,2,2,1
0
$ test-expr '\''(a != b) >= (c && (d || e))'\'' -a 0,0,0,1,0
1
$ test-expr '\''(a != b) >= (c && (d || e))'\'' -a 0,0,1,0,1
0
$ test-expr '\''(a != b) >= (c && (d || e))'\'' -a 0,1,1,1,1
1
$ test-expr '\''(a != b) >= (c && (d || e))'\'' -a 0,1,1,1,2
1
$ test-expr '\''(a != b) >= (c && (d || e))'\'' -a 0,1,2,2,0
1
$ test-expr '\''(a != b) >= (c && (d || e))'\'' -a 0,2,0,2,0
1
$ test-expr '\''(a != b) >= (c && (d || e))'\'' -a 0,2,0,2,1
1
$ test-expr '\''(a != b) >= (c && (d || e))'\'' -a 0,2,1,2,2
1
$ test-expr '\''(a != b) >= (c && (d || e))'\'' -a 0,2,2,1,0
1
$ test-expr '\''(a != b) >= (c && (d || e))'\'' -a 1,0,0,0,0
1
$ test-expr '\''(a != b) >= (c && (d || e))'\'' -a 1,0,0,1,2
1
$ test-expr '\''(a != b) >= (c && (d || e))'\'' -a 1,0,1,2,2
1
$ test-expr '\''(a != b) >= (c && (d || e))'\'' -a 1,1,1,0,2
0
$ test-expr '\''(a != b) >= (c && (d || e))'\'' -a 1,2,0,0,0
1
$ test-expr '\''(a != b) >= (c && (d || e))'\'' -a 1,2,1,1,0
1
$ test-expr '\''(a != b) >= (c && (d || e))'\'' -a 1,2,2,0,0
1
$ test-expr '\''(a != b) >= (c && (d || e))'\'' -a 1,2,2,2,2
1
$ test-expr '\''(a != b) >= (c && (d || e))'\'' -a 2,0,0,1,2
1
$ test-expr '\''(a != b) >= (c && (d || e))'\'' -a 2,0,0,2,0
1
$ test-expr '\''(a != b) >= (c && (d || e))'\'' -a 2,0,1,2,1
1
$ test-expr '\''(a != b) >= (c && (d || e))'\'' -a 2,1,0,2,2
1
$ test-expr '\''(a != b) >= (c && (d || e))'\'' -a 2,1,2,2,2
1
$ test-expr '\''(a != b) >= (c || (d && e))'\'' -a 0,0,0,2,2
0
$ test-expr '\''(a != b) >= (c || (d && e))'\'' -a 0,1,0,0,2
1
$ test-expr '\''(a != b) >= (c || (d && e))'\'' -a 0,1,0,1,2
1
$ test-expr '\''(a != b) >= (c || (d && e))'\'' -a 0,1,1,2,2
1
$ test-expr '\''(a != b) >= (c || (d && e))'\'' -a 0,1,2,0,1
1
$ test-expr '\''(a != b) >= (c || (d && e))'\'' -a 0,1,2,2,1
1
$ test-expr '\''(a != b) >= (c || (d && e))'\'' -a 0,2,0,2,2
1
$ test-expr '\''(a != b) >= (c || (d && e))'\'' -a 0,2,1,1,1
1
$ test-expr '\''(a != b) >= (c || (d && e))'\'' -a 1,0,0,1,0
1
$ test-expr '\''(a != b) >= (c || (d && e))'\'' -a 1,0,1,0,0
1
$ test-expr '\''(a != b) >= (c || (d && e))'\'' -a 1,0,1,0,1
1
$ test-expr '\''(a != b) >= (c || (d && e))'\'' -a 1,0,1,1,0
1
$ test-expr '\''(a != b) >= (c || (d && e))'\'' -a 1,0,1,1,1
1
$ test-expr '\''(a != b) >= (c || (d && e))'\'' -a 1,1,2,0,0
0
$ test-expr '\''(a != b) >= (c || (d && e))'\'' -a 1,1,2,0,2
0
$ test-expr '\''(a != b) >= (c || (d && e))'\'' -a 1,2,1,0,0
1
$ test-expr '\''(a != b) >= (c || (d && e))'\'' -a 1,2,2,0,0
1
$ test-expr '\''(a != b) >= (c || (d && e))'\'' -a 2,0,0,1,2
1
$ test-expr '\''(a != b) >= (c || (d && e))'\'' -a 2,0,1,0,0
1
$ test-expr '\''(a != b) >= (c || (d && e))'\'' -a 2,1,0,1,2
1
$ test-expr '\''(a != b) >= (c || (d && e))'\'' -a 2,1,1,0,0
1
$ test-expr '\''(a != b) >= (c || (d && e))'\'' -a 2,2,2,1,0
0
$ test-expr '\''(a != b) >= ((c && d) || e)'\'' -a 0,0,0,0,1
0
$ test-expr '\''(a != b) >= ((c && d) || e)'\'' -a 0,0,2,0,0
1
$ test-expr '\''(a != b) >= ((c && d) || e)'\'' -a 0,0,2,0,2
0
$ test-expr '\''(a != b) >= ((c && d) || e)'\'' -a 0,1,1,0,1
1
$ test-expr '\''(a != b) >= ((c && d) || e)'\'' -a 0,1,1,0,2
1
$ test-expr '\''(a != b) >= ((c && d) || e)'\'' -a 0,1,1,2,1
1
$ test-expr '\''(a != b) >= ((c && d) || e)'\'' -a 0,1,2,2,0
1
$ test-expr '\''(a != b) >= ((c && d) || e)'\'' -a 0,1,2,2,2
1
$ test-expr '\''(a != b) >= ((c && d) || e)'\'' -a 0,2,0,1,1
1
$ test-expr '\''(a != b) >= ((c && d) || e)'\'' -a 0,2,0,2,2
1
$ test-expr '\''(a != b) >= ((c && d) || e)'\'' -a 0,2,1,1,2
1
$ test-expr '\''(a != b) >= ((c && d) || e)'\'' -a 0,2,1,2,2
1
$ test-expr '\''(a != b) >= ((c && d) || e)'\'' -a 0,2,2,0,1
1
$ test-expr '\''(a != b) >= ((c && d) || e)'\'' -a 1,0,0,0,0
1
$ test-expr '\''(a != b) >= ((c && d) || e)'\'' -a 1,0,0,1,2
1
$ test-expr '\''(a != b) >= ((c && d) || e)'\'' -a 1,0,0,2,2
1
$ test-expr '\''(a != b) >= ((c && d) || e)'\'' -a 1,0,1,0,2
1
$ test-expr '\''(a != b) >= ((c && d) || e)'\'' -a 1,0,2,2,0
1
$ test-expr '\''(a != b) >= ((c && d) || e)'\'' -a 1,0,2,2,1
1
$ test-expr '\''(a != b) >= ((c && d) || e)'\'' -a 1,0,2,2,2
1
$ test-expr '\''(a != b) >= ((c && d) || e)'\'' -a 1,1,0,1,1
0
$ test-expr '\''(a != b) >= ((c && d) || e)'\'' -a 1,1,1,1,1
0
$ test-expr '\''(a != b) >= ((c && d) || e)'\'' -a 1,2,0,2,2
1
$ test-expr '\''(a != b) >= ((c && d) || e)'\'' -a 1,2,1,0,0
1
$ test-expr '\''(a != b) >= ((c && d) || e)'\'' -a 1,2,1,1,0
1
$ test-expr '\''(a != b) >= ((c && d) || e)'\'' -a 1,2,2,1,0
1
$ test-expr '\''(a != b) >= ((c && d) || e)'\'' -a 2,0,0,0,0
1
$ test-expr '\''(a != b) >= ((c && d) || e)'\'' -a 2,0,0,0,2
1
$ test-expr '\''(a != b) >= ((c && d) || e)'\'' -a 2,0,0,1,2
1
$ test-expr '\''(a != b) >= ((c && d) || e)'\'' -a 2,0,0,2,2
1
$ test-expr '\''(a != b) >= ((c && d) || e)'\'' -a 2,0,1,1,1
1
$ test-expr '\''(a != b) >= ((c && d) || e)'\'' -a 2,1,0,1,0
1
$ test-expr '\''(a != b) >= ((c && d) || e)'\'' -a 2,1,0,2,0
1
$ test-expr '\''(a != b) >= ((c && d) || e)'\'' -a 2,1,0,2,2
1
$ test-expr '\''(a != b) >= ((c && d) || e)'\'' -a 2,1,1,1,0
1
$ test-expr '\''(a != b) >= ((c && d) || e)'\'' -a 2,1,2,2,0
1
$ test-expr '\''(a != b) >= ((c && d) || e)'\'' -a 2,2,0,2,1
0
$ test-expr '\''(a != b) >= ((c && d) || e)'\'' -a 2,2,1,1,2
0
$ test-expr '\''(a != b) >= ((c && d) || e)'\'' -a 2,2,1,2,1
0
$ test-expr '\''(a != b) >= ((c || d) && e)'\'' -a 0,0,1,1,1
0
$ test-expr '\''(a != b) >= ((c || d) && e)'\'' -a 0,0,1,1,2
0
$ test-expr '\''(a != b) >= ((c || d) && e)'\'' -a 0,0,2,2,0
1
$ test-expr '\''(a != b) >= ((c || d) && e)'\'' -a 0,0,2,2,1
0
$ test-expr '\''(a != b) >= ((c || d) && e)'\'' -a 0,1,0,0,1
1
$ test-expr '\''(a != b) >= ((c || d) && e)'\'' -a 0,1,0,1,1
1
$ test-expr '\''(a != b) >= ((c || d) && e)'\'' -a 0,1,1,2,2
1
$ test-expr '\''(a != b) >= ((c || d) && e)'\'' -a 0,2,0,1,1
1
$ test-expr '\''(a != b) >= ((c || d) && e)'\'' -a 1,0,1,0,2
1
$ test-expr '\''(a != b) >= ((c || d) && e)'\'' -a 1,0,1,1,0
1
$ test-expr '\''(a != b) >= ((c || d) && e)'\'' -a 1,0,2,0,2
1
$ test-expr '\''(a != b) >= ((c || d) && e)'\'' -a 1,0,2,2,2
1
$ test-expr '\''(a != b) >= ((c || d) && e)'\'' -a 1,1,0,0,2
1
$ test-expr '\''(a != b) >= ((c || d) && e)'\'' -a 1,1,1,1,0
1
$ test-expr '\''(a != b) >= ((c || d) && e)'\'' -a 1,1,2,1,0
1
$ test-expr '\''(a != b) >= ((c || d) && e)'\'' -a 1,1,2,1,2
0
$ test-expr '\''(a != b) >= ((c || d) && e)'\'' -a 1,1,2,2,2
0
$ test-expr '\''(a != b) >= ((c || d) && e)'\'' -a 1,2,0,0,0
1
$ test-expr '\''(a != b) >= ((c || d) && e)'\'' -a 1,2,0,0,1
1
$ test-expr '\''(a != b) >= ((c || d) && e)'\'' -a 1,2,1,2,0
1
$ test-expr '\''(a != b) >= ((c || d) && e)'\'' -a 1,2,1,2,1
1
$ test-expr '\''(a != b) >= ((c || d) && e)'\'' -a 2,0,0,0,1
1
$ test-expr '\''(a != b) >= ((c || d) && e)'\'' -a 2,0,0,1,1
1
$ test-expr '\''(a != b) >= ((c || d) && e)'\'' -a 2,0,1,2,0
1
$ test-expr '\''(a != b) >= ((c || d) && e)'\'' -a 2,0,2,0,1
1
$ test-expr '\''(a != b) >= ((c || d) && e)'\'' -a 2,0,2,2,1
1
$ test-expr '\''(a != b) >= ((c || d) && e)'\'' -a 2,1,0,1,0
1
$ test-expr '\''(a != b) >= ((c || d) && e)'\'' -a 2,1,1,1,0
1
$ test-expr '\''(a != b) >= ((c || d) && e)'\'' -a 2,1,1,1,2
1
$ test-expr '\''(a != b) >= ((c || d) && e)'\'' -a 2,1,2,0,2
1
$ test-expr '\''(a != b) >= ((c || d) && e)'\'' -a 2,2,0,2,1
0
$ test-expr '\''(a != b) >= ((c || d) && e)'\'' -a 2,2,1,2,1
0
$ test-expr '\''(a != b) || (c && (d >= e))'\'' -a 0,0,0,2,0
0
$ test-expr '\''(a != b) || (c && (d >= e))'\'' -a 0,0,1,0,2
0
$ test-expr '\''(a != b) || (c && (d >= e))'\'' -a 0,0,1,1,2
0
$ test-expr '\''(a != b) || (c && (d >= e))'\'' -a 0,1,0,1,1
1
$ test-expr '\''(a != b) || (c && (d >= e))'\'' -a 0,1,2,2,0
1
$ test-expr '\''(a != b) || (c && (d >= e))'\'' -a 1,0,0,0,0
1
$ test-expr '\''(a != b) || (c && (d >= e))'\'' -a 1,0,0,0,2
1
$ test-expr '\''(a != b) || (c && (d >= e))'\'' -a 1,0,1,1,1
1
$ test-expr '\''(a != b) || (c && (d >= e))'\'' -a 1,0,2,0,2
1
$ test-expr '\''(a != b) || (c && (d >= e))'\'' -a 1,0,2,1,2
1
$ test-expr '\''(a != b) || (c && (d >= e))'\'' -a 1,1,0,2,1
0
$ test-expr '\''(a != b) || (c && (d >= e))'\'' -a 1,1,1,0,1
0
$ test-expr '\''(a != b) || (c && (d >= e))'\'' -a 1,1,1,1,1
1
$ test-expr '\''(a != b) || (c && (d >= e))'\'' -a 1,1,1,2,1
1
$ test-expr '\''(a != b) || (c && (d >= e))'\'' -a 1,2,0,0,1
1
$ test-expr '\''(a != b) || (c && (d >= e))'\'' -a 1,2,0,1,1
1
$ test-expr '\''(a != b) || (c && (d >= e))'\'' -a 1,2,1,2,0
1
$ test-expr '\''(a != b) || (c && (d >= e))'\'' -a 2,0,0,2,1
1
$ test-expr '\''(a != b) || (c && (d >= e))'\'' -a 2,0,2,2,0
1
$ test-expr '\''(a != b) || (c && (d >= e))'\'' -a 2,1,0,2,0
1
$ test-expr '\''(a != b) || (c && (d >= e))'\'' -a 2,1,2,1,0
1
$ test-expr '\''(a != b) || (c && (d >= e))'\'' -a 2,1,2,2,1
1
$ test-expr '\''(a != b) || (c && (d >= e))'\'' -a 2,2,1,2,2
1
$ test-expr '\''(a != b) || (c && (d >= e))'\'' -a 2,2,2,0,0
1
$ test-expr '\''(a != b) || (c && (d >= e))'\'' -a 2,2,2,2,1
1
$ test-expr '\''(a != b) || (c >= (d && e))'\'' -a 0,1,0,0,0
1
$ test-expr '\''(a != b) || (c >= (d && e))'\'' -a 0,1,2,1,0
1
$ test-expr '\''(a != b) || (c >= (d && e))'\'' -a 0,1,2,1,1
1
$ test-expr '\''(a != b) || (c >= (d && e))'\'' -a 0,1,2,2,2
1
$ test-expr '\''(a != b) || (c >= (d && e))'\'' -a 0,2,0,1,2
1
$ test-expr '\''(a != b) || (c >= (d && e))'\'' -a 0,2,0,2,0
1
$ test-expr '\''(a != b) || (c >= (d && e))'\'' -a 0,2,0,2,2
1
$ test-expr '\''(a != b) || (c >= (d && e))'\'' -a 0,2,2,1,1
1
$ test-expr '\''(a != b) || (c >= (d && e))'\'' -a 1,0,0,0,0
1
$ test-expr '\''(a != b) || (c >= (d && e))'\'' -a 1,0,0,1,1
1
$ test-expr '\''(a != b) || (c >= (d && e))'\'' -a 1,0,2,0,2
1
$ test-expr '\''(a != b) || (c >= (d && e))'\'' -a 1,0,2,2,1
1
$ test-expr '\''(a != b) || (c >= (d && e))'\'' -a 1,1,0,0,1
1
$ test-expr '\''(a != b) || (c >= (d && e))'\'' -a 1,1,1,0,1
1
$ test-expr '\''(a != b) || (c >= (d && e))'\'' -a 1,1,1,0,2
1
$ test-expr '\''(a != b) || (c >= (d && e))'\'' -a 1,1,1,1,0
1
$ test-expr '\''(a != b) || (c >= (d && e))'\'' -a 1,1,1,1,2
1
$ test-expr '\''(a != b) || (c >= (d && e))'\'' -a 1,1,1,2,2
1
$ test-expr '\''(a != b) || (c >= (d && e))'\'' -a 1,2,0,0,1
1
$ test-expr '\''(a != b) || (c >= (d && e))'\'' -a 1,2,0,1,0
1
$ test-expr '\''(a != b) || (c >= (d && e))'\'' -a 1,2,0,2,2
1
$ test-expr '\''(a != b) || (c >= (d && e))'\'' -a 1,2,1,2,2
1
$ test-expr '\''(a != b) || (c >= (d && e))'\'' -a 1,2,2,0,1
1
$ test-expr '\''(a != b) || (c >= (d && e))'\'' -a 1,2,2,2,1
1
$ test-expr '\''(a != b) || (c >= (d && e))'\'' -a 2,1,0,1,1
1
$ test-expr '\''(a != b) || (c >= (d && e))'\'' -a 2,1,2,0,0
1
$ test-expr '\''(a != b) || (c >= (d && e))'\'' -a 2,1,2,0,2
1
$ test-expr '\''(a != b) || (c >= (d && e))'\'' -a 2,1,2,2,0
1
$ test-expr '\''(a != b) || (c >= (d && e))'\'' -a 2,1,2,2,1
1
$ test-expr '\''(a != b) || (c >= (d && e))'\'' -a 2,2,1,1,0
1
$ test-expr '\''(a != b) || (c >= (d && e))'\'' -a 2,2,1,1,2
1
$ test-expr '\''(a != b) || ((c && d) >= e)'\'' -a 0,0,2,0,0
1
$ test-expr '\''(a != b) || ((c && d) >= e)'\'' -a 0,0,2,0,1
0
$ test-expr '\''(a != b) || ((c && d) >= e)'\'' -a 0,0,2,2,2
0
$ test-expr '\''(a != b) || ((c && d) >= e)'\'' -a 0,1,0,0,0
1
$ test-expr '\''(a != b) || ((c && d) >= e)'\'' -a 0,2,1,0,2
1
$ test-expr '\''(a != b) || ((c && d) >= e)'\'' -a 1,0,2,1,2
1
$ test-expr '\''(a != b) || ((c && d) >= e)'\'' -a 1,0,2,2,1
1
$ test-expr '\''(a != b) || ((c && d) >= e)'\'' -a 1,1,0,0,0
1
$ test-expr '\''(a != b) || ((c && d) >= e)'\'' -a 1,1,0,1,1
0
$ test-expr '\''(a != b) || ((c && d) >= e)'\'' -a 1,1,1,1,2
0
$ test-expr '\''(a != b) || ((c && d) >= e)'\'' -a 1,2,0,2,0
1
$ test-expr '\''(a != b) || ((c && d) >= e)'\'' -a 1,2,0,2,1
1
$ test-expr '\''(a != b) || ((c && d) >= e)'\'' -a 1,2,1,0,0
1
$ test-expr '\''(a != b) || ((c && d) >= e)'\'' -a 1,2,1,1,0
1
$ test-expr '\''(a != b) || ((c && d) >= e)'\'' -a 1,2,1,2,0
1
$ test-expr '\''(a != b) || ((c && d) >= e)'\'' -a 2,0,0,0,0
1
$ test-expr '\''(a != b) || ((c && d) >= e)'\'' -a 2,1,0,0,0
1
$ test-expr '\''(a != b) || ((c && d) >= e)'\'' -a 2,1,0,2,0
1
$ test-expr '\''(a != b) || ((c && d) >= e)'\'' -a 2,1,1,1,2
1
$ test-expr '\''(a != b) || ((c && d) >= e)'\'' -a 2,1,1,2,0
1
$ test-expr '\''(a != b) || ((c && d) >= e)'\'' -a 2,1,2,1,2
1
$ test-expr '\''(a != b) || ((c && d) >= e)'\'' -a 2,2,0,1,2
0
$ test-expr '\''(a != b) || ((c && d) >= e)'\'' -a 2,2,1,0,1
0
$ test-expr '\''(a != b) || ((c >= d) && e)'\'' -a 0,0,0,0,0
0
$ test-expr '\''(a != b) || ((c >= d) && e)'\'' -a 0,0,0,1,0
0
$ test-expr '\''(a != b) || ((c >= d) && e)'\'' -a 0,1,0,0,2
1
$ test-expr '\''(a != b) || ((c >= d) && e)'\'' -a 0,1,0,2,0
1
$ test-expr '\''(a != b) || ((c >= d) && e)'\'' -a 0,1,1,2,0
1
$ test-expr '\''(a != b) || ((c >= d) && e)'\'' -a 0,1,2,1,0
1
$ test-expr '\''(a != b) || ((c >= d) && e)'\'' -a 0,2,0,0,2
1
$ test-expr '\''(a != b) || ((c >= d) && e)'\'' -a 0,2,1,0,1
1
$ test-expr '\''(a != b) || ((c >= d) && e)'\'' -a 0,2,1,0,2
1
$ test-expr '\''(a != b) || ((c >= d) && e)'\'' -a 0,2,1,2,0
1
$ test-expr '\''(a != b) || ((c >= d) && e)'\'' -a 0,2,2,0,2
1
$ test-expr '\''(a != b) || ((c >= d) && e)'\'' -a 0,2,2,2,2
1
$ test-expr '\''(a != b) || ((c >= d) && e)'\'' -a 1,0,0,1,2
1
$ test-expr '\''(a != b) || ((c >= d) && e)'\'' -a 1,0,1,1,1
1
$ test-expr '\''(a != b) || ((c >= d) && e)'\'' -a 1,0,2,1,0
1
$ test-expr '\''(a != b) || ((c >= d) && e)'\'' -a 1,0,2,1,2
1
$ test-expr '\''(a != b) || ((c >= d) && e)'\'' -a 1,1,0,1,0
0
$ test-expr '\''(a != b) || ((c >= d) && e)'\'' -a 1,1,1,2,1
0
$ test-expr '\''(a != b) || ((c >= d) && e)'\'' -a 1,1,2,0,0
0
$ test-expr '\''(a != b) || ((c >= d) && e)'\'' -a 1,1,2,1,2
1
$ test-expr '\''(a != b) || ((c >= d) && e)'\'' -a 1,2,1,1,1
1
$ test-expr '\''(a != b) || ((c >= d) && e)'\'' -a 1,2,1,2,0
1
$ test-expr '\''(a != b) || ((c >= d) && e)'\'' -a 1,2,1,2,1
1
$ test-expr '\''(a != b) || ((c >= d) && e)'\'' -a 2,0,0,0,1
1
$ test-expr '\''(a != b) || ((c >= d) && e)'\'' -a 2,0,1,0,0
1
$ test-expr '\''(a != b) || ((c >= d) && e)'\'' -a 2,0,2,1,2
1
$ test-expr '\''(a != b) || ((c >= d) && e)'\'' -a 2,1,2,0,1
1
$ test-expr '\''(a != b) || ((c >= d) && e)'\'' -a 2,1,2,1,1
1
$ test-expr '\''(a != b) || ((c >= d) && e)'\'' -a 2,2,0,0,1
1
$ test-expr '\''(a != b) || ((c >= d) && e)'\'' -a 2,2,0,2,2
0
$ test-expr '\''(a != b) || ((c >= d) && e)'\'' -a 2,2,2,1,2
1
$ test-expr '\''(a != b) || ((c >= d) && e)'\'' -a 2,2,2,2,1
1
$ test-expr '\''(a != (b && c)) >= (d || e)'\'' -a 0,0,0,2,2
0
$ test-expr '\''(a != (b && c)) >= (d || e)'\'' -a 0,0,1,1,1
0
$ test-expr '\''(a != (b && c)) >= (d || e)'\'' -a 0,0,2,2,1
0
$ test-expr '\''(a != (b && c)) >= (d || e)'\'' -a 0,1,2,2,0
1
$ test-expr '\''(a != (b && c)) >= (d || e)'\'' -a 0,1,2,2,1
1
$ test-expr '\''(a != (b && c)) >= (d || e)'\'' -a 0,2,0,1,1
0
$ test-expr '\''(a != (b && c)) >= (d || e)'\'' -a 0,2,1,0,0
1
$ test-expr '\''(a != (b && c)) >= (d || e)'\'' -a 0,2,1,0,2
1
$ test-expr '\''(a != (b && c)) >= (d || e)'\'' -a 1,0,0,0,1
1
$ test-expr '\''(a != (b && c)) >= (d || e)'\'' -a 1,0,1,0,0
1
$ test-expr '\''(a != (b && c)) >= (d || e)'\'' -a 1,0,1,1,2
1
$ test-expr '\''(a != (b && c)) >= (d || e)'\'' -a 1,0,1,2,1
1
$ test-expr '\''(a != (b && c)) >= (d || e)'\'' -a 1,0,2,0,0
1
$ test-expr '\''(a != (b && c)) >= (d || e)'\'' -a 1,0,2,0,2
1
$ test-expr '\''(a != (b && c)) >= (d || e)'\'' -a 1,0,2,2,0
1
$ test-expr '\''(a != (b && c)) >= (d || e)'\'' -a 1,1,0,0,0
1
$ test-expr '\''(a != (b && c)) >= (d || e)'\'' -a 1,1,0,0,2
1
$ test-expr '\''(a != (b && c)) >= (d || e)'\'' -a 1,1,1,0,0
1
$ test-expr '\''(a != (b && c)) >= (d || e)'\'' -a 1,1,1,0,1
0
$ test-expr '\''(a != (b && c)) >= (d || e)'\'' -a 1,1,1,1,0
0
$ test-expr '\''(a != (b && c)) >= (d || e)'\'' -a 1,1,1,1,1
0
$ test-expr '\''(a != (b && c)) >= (d || e)'\'' -a 1,1,1,2,1
0
$ test-expr '\''(a != (b && c)) >= (d || e)'\'' -a 1,2,0,0,0
1
$ test-expr '\''(a != (b && c)) >= (d || e)'\'' -a 1,2,0,1,1
1
$ test-expr '\''(a != (b && c)) >= (d || e)'\'' -a 1,2,1,1,2
0
$ test-expr '\''(a != (b && c)) >= (d || e)'\'' -a 1,2,1,2,2
0
$ test-expr '\''(a != (b && c)) >= (d || e)'\'' -a 2,0,0,0,1
1
$ test-expr '\''(a != (b && c)) >= (d || e)'\'' -a 2,0,1,2,1
1
$ test-expr '\''(a != (b && c)) >= (d || e)'\'' -a 2,0,2,1,2
1
$ test-expr '\''(a != (b && c)) >= (d || e)'\'' -a 2,0,2,2,1
1
$ test-expr '\''(a != (b && c)) >= (d || e)'\'' -a 2,2,0,2,1
1
$ test-expr '\''(a != (b && c)) >= (d || e)'\'' -a 2,2,1,1,1
1
$ test-expr '\''(a != (b && c)) >= (d || e)'\'' -a 2,2,2,0,1
1
$ test-expr '\''(a != (b && c)) || (d >= e)'\'' -a 0,0,1,1,1
1
$ test-expr '\''(a != (b && c)) || (d >= e)'\'' -a 0,0,1,1,2
0
$ test-expr '\''(a != (b && c)) || (d >= e)'\'' -a 0,0,1,2,2
1
$ test-expr '\''(a != (b && c)) || (d >= e)'\'' -a 0,0,2,2,2
1
$ test-expr '\''(a != (b && c)) || (d >= e)'\'' -a 0,1,1,0,1
1
$ test-expr '\''(a != (b && c)) || (d >= e)'\'' -a 0,1,1,0,2
1
$ test-expr '\''(a != (b && c)) || (d >= e)'\'' -a 0,1,2,2,0
1
$ test-expr '\''(a != (b && c)) || (d >= e)'\'' -a 0,2,0,0,0
1
$ test-expr '\''(a != (b && c)) || (d >= e)'\'' -a 0,2,0,1,0
1
$ test-expr '\''(a != (b && c)) || (d >= e)'\'' -a 0,2,1,0,1
1
$ test-expr '\''(a != (b && c)) || (d >= e)'\'' -a 0,2,2,1,0
1
$ test-expr '\''(a != (b && c)) || (d >= e)'\'' -a 1,0,0,2,2
1
$ test-expr '\''(a != (b && c)) || (d >= e)'\'' -a 1,0,1,1,2
1
$ test-expr '\''(a != (b && c)) || (d >= e)'\'' -a 1,1,0,1,0
1
$ test-expr '\''(a != (b && c)) || (d >= e)'\'' -a 1,1,1,0,2
0
$ test-expr '\''(a != (b && c)) || (d >= e)'\'' -a 1,2,0,2,1
1
$ test-expr '\''(a != (b && c)) || (d >= e)'\'' -a 1,2,2,0,2
0
$ test-expr '\''(a != (b && c)) || (d >= e)'\'' -a 2,0,0,0,0
1
$ test-expr '\''(a != (b && c)) || (d >= e)'\'' -a 2,0,1,0,2
1
$ test-expr '\''(a != (b && c)) || (d >= e)'\'' -a 2,0,1,2,1
1
$ test-expr '\''(a != (b && c)) || (d >= e)'\'' -a 2,0,1,2,2
1
$ test-expr '\''(a != (b && c)) || (d >= e)'\'' -a 2,1,1,2,1
1
$ test-expr '\''(a != (b && c)) || (d >= e)'\'' -a 2,1,1,2,2
1
$ test-expr '\''(a != (b && c)) || (d >= e)'\'' -a 2,1,2,1,1
1
$ test-expr '\''(a != (b && c)) || (d >= e)'\'' -a 2,1,2,2,2
1
$ test-expr '\''(a != (b && c)) || (d >= e)'\'' -a 2,2,0,1,0
1
$ test-expr '\''(a != (b && c)) || (d >= e)'\'' -a 2,2,0,1,2
1
$ test-expr '\''(a != (b && c)) || (d >= e)'\'' -a 2,2,0,2,1
1
$ test-expr '\''(a != (b && c)) || (d >= e)'\'' -a 2,2,1,1,0
1
$ test-expr '\''(a != (b && c)) || (d >= e)'\'' -a 2,2,2,0,1
1
$ test-expr '\''(a != (b && c)) || (d >= e)'\'' -a 2,2,2,2,0
1
$ test-expr '\''(a != (b && (c >= d))) || e'\'' -a 0,0,0,0,2
1
$ test-expr '\''(a != (b && (c >= d))) || e'\'' -a 0,0,0,1,0
0
$ test-expr '\''(a != (b && (c >= d))) || e'\'' -a 0,0,0,2,1
1
$ test-expr '\''(a != (b && (c >= d))) || e'\'' -a 0,0,1,2,2
1
$ test-expr '\''(a != (b && (c >= d))) || e'\'' -a 0,1,0,0,1
1
$ test-expr '\''(a != (b && (c >= d))) || e'\'' -a 0,1,0,1,0
0
$ test-expr '\''(a != (b && (c >= d))) || e'\'' -a 0,1,1,2,2
1
$ test-expr '\''(a != (b && (c >= d))) || e'\'' -a 0,1,2,0,0
1
$ test-expr '\''(a != (b && (c >= d))) || e'\'' -a 0,1,2,2,0
1
$ test-expr '\''(a != (b && (c >= d))) || e'\'' -a 0,1,2,2,1
1
$ test-expr '\''(a != (b && (c >= d))) || e'\'' -a 0,1,2,2,2
1
$ test-expr '\''(a != (b && (c >= d))) || e'\'' -a 0,2,1,1,2
1
$ test-expr '\''(a != (b && (c >= d))) || e'\'' -a 0,2,1,2,2
1
$ test-expr '\''(a != (b && (c >= d))) || e'\'' -a 0,2,2,1,1
1
$ test-expr '\''(a != (b && (c >= d))) || e'\'' -a 1,0,1,0,0
1
$ test-expr '\''(a != (b && (c >= d))) || e'\'' -a 1,0,1,2,0
1
$ test-expr '\''(a != (b && (c >= d))) || e'\'' -a 1,1,0,0,1
1
$ test-expr '\''(a != (b && (c >= d))) || e'\'' -a 1,1,0,1,0
1
$ test-expr '\''(a != (b && (c >= d))) || e'\'' -a 1,1,1,0,1
1
$ test-expr '\''(a != (b && (c >= d))) || e'\'' -a 1,1,2,2,2
1
$ test-expr '\''(a != (b && (c >= d))) || e'\'' -a 1,2,0,1,0
1
$ test-expr '\''(a != (b && (c >= d))) || e'\'' -a 1,2,1,0,1
1
$ test-expr '\''(a != (b && (c >= d))) || e'\'' -a 1,2,2,0,2
1
$ test-expr '\''(a != (b && (c >= d))) || e'\'' -a 1,2,2,1,1
1
$ test-expr '\''(a != (b && (c >= d))) || e'\'' -a 2,0,1,0,2
1
$ test-expr '\''(a != (b && (c >= d))) || e'\'' -a 2,0,1,2,0
1
$ test-expr '\''(a != (b && (c >= d))) || e'\'' -a 2,0,2,2,1
1
$ test-expr '\''(a != (b && (c >= d))) || e'\'' -a 2,1,0,0,2
1
$ test-expr '\''(a != (b && (c >= d))) || e'\'' -a 2,1,1,0,0
1
$ test-expr '\''(a != (b && (c >= d))) || e'\'' -a 2,1,1,1,2
1
$ test-expr '\''(a != (b && (c >= d))) || e'\'' -a 2,1,2,0,1
1
$ test-expr '\''(a != (b && (c >= d))) || e'\'' -a 2,1,2,0,2
1
$ test-expr '\''(a != (b && (c >= d))) || e'\'' -a 2,1,2,1,2
1
$ test-expr '\''(a != (b && (c >= d))) || e'\'' -a 2,1,2,2,0
1
$ test-expr '\''(a != (b && (c >= d))) || e'\'' -a 2,2,0,1,1
1
$ test-expr '\''(a != (b && (c >= d))) || e'\'' -a 2,2,2,0,0
1
$ test-expr '\''(a != (b && (c >= d))) || e'\'' -a 2,2,2,1,0
1
$ test-expr '\''(a != (b && (c || d))) >= e'\'' -a 0,0,2,0,2
0
$ test-expr '\''(a != (b && (c || d))) >= e'\'' -a 0,0,2,1,0
1
$ test-expr '\''(a != (b && (c || d))) >= e'\'' -a 0,1,0,2,2
0
$ test-expr '\''(a != (b && (c || d))) >= e'\'' -a 0,1,2,1,0
1
$ test-expr '\''(a != (b && (c || d))) >= e'\'' -a 0,1,2,2,0
1
$ test-expr '\''(a != (b && (c || d))) >= e'\'' -a 0,2,0,0,1
0
$ test-expr '\''(a != (b && (c || d))) >= e'\'' -a 0,2,0,0,2
0
$ test-expr '\''(a != (b && (c || d))) >= e'\'' -a 0,2,0,1,0
1
$ test-expr '\''(a != (b && (c || d))) >= e'\'' -a 0,2,0,2,2
0
$ test-expr '\''(a != (b && (c || d))) >= e'\'' -a 0,2,1,2,1
1
$ test-expr '\''(a != (b && (c || d))) >= e'\'' -a 0,2,2,2,0
1
$ test-expr '\''(a != (b && (c || d))) >= e'\'' -a 1,0,1,0,1
1
$ test-expr '\''(a != (b && (c || d))) >= e'\'' -a 1,0,1,1,2
0
$ test-expr '\''(a != (b && (c || d))) >= e'\'' -a 1,0,1,2,0
1
$ test-expr '\''(a != (b && (c || d))) >= e'\'' -a 1,1,0,0,1
1
$ test-expr '\''(a != (b && (c || d))) >= e'\'' -a 1,1,1,1,0
1
$ test-expr '\''(a != (b && (c || d))) >= e'\'' -a 1,1,1,1,1
0
$ test-expr '\''(a != (b && (c || d))) >= e'\'' -a 1,1,1,2,0
1
$ test-expr '\''(a != (b && (c || d))) >= e'\'' -a 1,2,0,0,1
1
$ test-expr '\''(a != (b && (c || d))) >= e'\'' -a 1,2,0,2,0
1
$ test-expr '\''(a != (b && (c || d))) >= e'\'' -a 1,2,0,2,2
0
$ test-expr '\''(a != (b && (c || d))) >= e'\'' -a 1,2,1,1,1
0
$ test-expr '\''(a != (b && (c || d))) >= e'\'' -a 1,2,2,0,2
0
$ test-expr '\''(a != (b && (c || d))) >= e'\'' -a 1,2,2,1,2
0
$ test-expr '\''(a != (b && (c || d))) >= e'\'' -a 2,0,2,2,0
1
$ test-expr '\''(a != (b && (c || d))) >= e'\'' -a 2,1,0,0,1
1
$ test-expr '\''(a != (b && (c || d))) >= e'\'' -a 2,1,0,1,2
0
$ test-expr '\''(a != (b && (c || d))) >= e'\'' -a 2,1,1,0,1
1
$ test-expr '\''(a != (b && (c || d))) >= e'\'' -a 2,1,1,0,2
0
$ test-expr '\''(a != (b && (c || d))) >= e'\'' -a 2,1,2,2,0
1
$ test-expr '\''(a != (b && (c || d))) >= e'\'' -a 2,2,0,1,1
1
$ test-expr '\''(a != (b && (c || d))) >= e'\'' -a 2,2,1,0,2
0
$ test-expr '\''(a != (b && (c || d))) >= e'\'' -a 2,2,2,2,0
1
$ test-expr '\''(a != (b && (c || d))) >= e'\'' -a 2,2,2,2,2
0
$ test-expr '\''(a != (b >= c)) && (d || e)'\'' -a 0,0,0,2,0
1
$ test-expr '\''(a != (b >= c)) && (d || e)'\'' -a 0,0,2,0,0
0
$ test-expr '\''(a != (b >= c)) && (d || e)'\'' -a 0,0,2,1,2
0
$ test-expr '\''(a != (b >= c)) && (d || e)'\'' -a 0,0,2,2,0
0
$ test-expr '\''(a != (b >= c)) && (d || e)'\'' -a 0,0,2,2,2
0
$ test-expr '\''(a != (b >= c)) && (d || e)'\'' -a 0,1,0,0,0
0
$ test-expr '\''(a != (b >= c)) && (d || e)'\'' -a 0,1,0,2,1
1
$ test-expr '\''(a != (b >= c)) && (d || e)'\'' -a 0,2,0,0,0
0
$ test-expr '\''(a != (b >= c)) && (d || e)'\'' -a 0,2,0,0,1
1
$ test-expr '\''(a != (b >= c)) && (d || e)'\'' -a 0,2,1,0,2
1
$ test-expr '\''(a != (b >= c)) && (d || e)'\'' -a 0,2,2,2,0
1
$ test-expr '\''(a != (b >= c)) && (d || e)'\'' -a 1,0,1,1,0
1
$ test-expr '\''(a != (b >= c)) && (d || e)'\'' -a 1,1,0,1,0
0
$ test-expr '\''(a != (b >= c)) && (d || e)'\'' -a 1,1,1,0,2
0
$ test-expr '\''(a != (b >= c)) && (d || e)'\'' -a 1,1,1,1,2
0
$ test-expr '\''(a != (b >= c)) && (d || e)'\'' -a 1,2,0,1,2
0
$ test-expr '\''(a != (b >= c)) && (d || e)'\'' -a 1,2,1,0,1
0
$ test-expr '\''(a != (b >= c)) && (d || e)'\'' -a 1,2,1,2,0
0
$ test-expr '\''(a != (b >= c)) && (d || e)'\'' -a 1,2,2,0,0
0
$ test-expr '\''(a != (b >= c)) && (d || e)'\'' -a 1,2,2,1,0
0
$ test-expr '\''(a != (b >= c)) && (d || e)'\'' -a 2,0,1,1,0
1
$ test-expr '\''(a != (b >= c)) && (d || e)'\'' -a 2,0,1,2,1
1
$ test-expr '\''(a != (b >= c)) && (d || e)'\'' -a 2,0,2,0,1
1
$ test-expr '\''(a != (b >= c)) && (d || e)'\'' -a 2,1,0,1,2
1
$ test-expr '\''(a != (b >= c)) && (d || e)'\'' -a 2,1,1,2,2
1
$ test-expr '\''(a != (b >= c)) && (d || e)'\'' -a 2,2,0,1,0
1
$ test-expr '\''(a != (b >= c)) && (d || e)'\'' -a 2,2,0,2,0
1
$ test-expr '\''(a != (b >= c)) && (d || e)'\'' -a 2,2,1,0,0
0
$ test-expr '\''(a != (b >= c)) && (d || e)'\'' -a 2,2,1,0,1
1
$ test-expr '\''(a != (b >= c)) && (d || e)'\'' -a 2,2,2,1,0
1
$ test-expr '\''(a != (b >= c)) || (d && e)'\'' -a 0,0,1,1,1
1
$ test-expr '\''(a != (b >= c)) || (d && e)'\'' -a 0,1,0,0,0
1
$ test-expr '\''(a != (b >= c)) || (d && e)'\'' -a 0,1,0,2,0
1
$ test-expr '\''(a != (b >= c)) || (d && e)'\'' -a 0,1,2,1,2
1
$ test-expr '\''(a != (b >= c)) || (d && e)'\'' -a 0,1,2,2,2
1
$ test-expr '\''(a != (b >= c)) || (d && e)'\'' -a 0,2,1,0,1
1
$ test-expr '\''(a != (b >= c)) || (d && e)'\'' -a 0,2,1,0,2
1
$ test-expr '\''(a != (b >= c)) || (d && e)'\'' -a 0,2,2,0,1
1
$ test-expr '\''(a != (b >= c)) || (d && e)'\'' -a 1,0,0,0,0
0
$ test-expr '\''(a != (b >= c)) || (d && e)'\'' -a 1,0,0,0,1
0
$ test-expr '\''(a != (b >= c)) || (d && e)'\'' -a 1,0,0,1,1
1
$ test-expr '\''(a != (b >= c)) || (d && e)'\'' -a 1,0,1,0,1
1
$ test-expr '\''(a != (b >= c)) || (d && e)'\'' -a 1,1,0,2,0
0
$ test-expr '\''(a != (b >= c)) || (d && e)'\'' -a 1,1,0,2,1
1
$ test-expr '\''(a != (b >= c)) || (d && e)'\'' -a 1,1,2,0,0
1
$ test-expr '\''(a != (b >= c)) || (d && e)'\'' -a 1,2,0,0,2
0
$ test-expr '\''(a != (b >= c)) || (d && e)'\'' -a 1,2,0,1,1
1
$ test-expr '\''(a != (b >= c)) || (d && e)'\'' -a 1,2,0,1,2
1
$ test-expr '\''(a != (b >= c)) || (d && e)'\'' -a 1,2,1,0,1
0
$ test-expr '\''(a != (b >= c)) || (d && e)'\'' -a 1,2,1,2,1
1
$ test-expr '\''(a != (b >= c)) || (d && e)'\'' -a 1,2,2,1,2
1
$ test-expr '\''(a != (b >= c)) || (d && e)'\'' -a 2,0,0,0,1
1
$ test-expr '\''(a != (b >= c)) || (d && e)'\'' -a 2,0,1,0,0
1
$ test-expr '\''(a != (b >= c)) || (d && e)'\'' -a 2,0,1,1,1
1
$ test-expr '\''(a != (b >= c)) || (d && e)'\'' -a 2,1,0,0,0
1
$ test-expr '\''(a != (b >= c)) || (d && e)'\'' -a 2,1,0,2,2
1
$ test-expr '\''(a != (b >= c)) || (d && e)'\'' -a 2,1,1,1,0
1
$ test-expr '\''(a != (b >= c)) || (d && e)'\'' -a 2,1,2,1,1
1
$ test-expr '\''(a != (b >= c)) || (d && e)'\'' -a 2,1,2,2,2
1
$ test-expr '\''(a != (b >= c)) || (d && e)'\'' -a 2,2,0,0,0
1
$ test-expr '\''(a != (b >= c)) || (d && e)'\'' -a 2,2,0,1,1
1
$ test-expr '\''(a != (b >= c)) || (d && e)'\'' -a 2,2,1,1,2
1
$ test-expr '\''(a != (b >= c)) || (d && e)'\'' -a 2,2,1,2,1
1
$ test-expr '\''(a != (b >= c)) || (d && e)'\'' -a 2,2,2,1,0
1
$ test-expr '\''(a != (b >= (c && d))) || e'\'' -a 0,0,0,0,2
1
$ test-expr '\''(a != (b >= (c && d))) || e'\'' -a 0,0,0,2,2
1
$ test-expr '\''(a != (b >= (c && d))) || e'\'' -a 0,0,1,1,0
0
$ test-expr '\''(a != (b >= (c && d))) || e'\'' -a 0,0,2,1,2
1
$ test-expr '\''(a != (b >= (c && d))) || e'\'' -a 0,1,2,2,0
1
$ test-expr '\''(a != (b >= (c && d))) || e'\'' -a 0,1,2,2,2
1
$ test-expr '\''(a != (b >= (c && d))) || e'\'' -a 0,2,2,2,2
1
$ test-expr '\''(a != (b >= (c && d))) || e'\'' -a 1,0,0,1,0
0
$ test-expr '\''(a != (b >= (c && d))) || e'\'' -a 1,0,0,1,2
1
$ test-expr '\''(a != (b >= (c && d))) || e'\'' -a 1,0,1,0,2
1
$ test-expr '\''(a != (b >= (c && d))) || e'\'' -a 1,0,1,1,2
1
$ test-expr '\''(a != (b >= (c && d))) || e'\'' -a 1,0,1,2,2
1
$ test-expr '\''(a != (b >= (c && d))) || e'\'' -a 1,1,1,1,1
1
$ test-expr '\''(a != (b >= (c && d))) || e'\'' -a 1,1,1,2,1
1
$ test-expr '\''(a != (b >= (c && d))) || e'\'' -a 1,1,2,0,0
0
$ test-expr '\''(a != (b >= (c && d))) || e'\'' -a 1,1,2,0,1
1
$ test-expr '\''(a != (b >= (c && d))) || e'\'' -a 1,2,1,0,0
0
$ test-expr '\''(a != (b >= (c && d))) || e'\'' -a 1,2,2,0,0
0
$ test-expr '\''(a != (b >= (c && d))) || e'\'' -a 1,2,2,0,2
1
$ test-expr '\''(a != (b >= (c && d))) || e'\'' -a 1,2,2,1,2
1
$ test-expr '\''(a != (b >= (c && d))) || e'\'' -a 1,2,2,2,2
1
$ test-expr '\''(a != (b >= (c && d))) || e'\'' -a 2,0,2,0,2
1
$ test-expr '\''(a != (b >= (c && d))) || e'\'' -a 2,1,0,2,0
1
$ test-expr '\''(a != (b >= (c && d))) || e'\'' -a 2,1,1,0,1
1
$ test-expr '\''(a != (b >= (c && d))) || e'\'' -a 2,1,1,2,2
1
$ test-expr '\''(a != (b >= (c && d))) || e'\'' -a 2,1,2,1,1
1
$ test-expr '\''(a != (b >= (c && d))) || e'\'' -a 2,1,2,2,0
1
$ test-expr '\''(a != (b >= (c && d))) || e'\'' -a 2,1,2,2,2
1
$ test-expr '\''(a != (b >= (c && d))) || e'\'' -a 2,2,0,2,2
1
$ test-expr '\''(a != (b >= (c && d))) || e'\'' -a 2,2,1,0,2
1
$ test-expr '\''(a != (b >= (c && d))) || e'\'' -a 2,2,1,2,2
1
$ test-expr '\''(a != (b >= (c && d))) || e'\'' -a 2,2,2,0,2
1
$ test-expr '\''(a != (b >= (c && d))) || e'\'' -a 2,2,2,1,2
1
$ test-expr '\''(a != (b >= (c || d))) && e'\'' -a 0,0,0,0,0
0
$ test-expr '\''(a != (b >= (c || d))) && e'\'' -a 0,0,1,2,1
0
$ test-expr '\''(a != (b >= (c || d))) && e'\'' -a 0,0,2,2,0
0
$ test-expr '\''(a != (b >= (c || d))) && e'\'' -a 0,1,0,2,1
1
$ test-expr '\''(a != (b >= (c || d))) && e'\'' -a 0,2,0,1,2
1
$ test-expr '\''(a != (b >= (c || d))) && e'\'' -a 0,2,2,0,0
0
$ test-expr '\''(a != (b >= (c || d))) && e'\'' -a 0,2,2,1,1
1
$ test-expr '\''(a != (b >= (c || d))) && e'\'' -a 0,2,2,2,1
1
$ test-expr '\''(a != (b >= (c || d))) && e'\'' -a 1,0,1,1,0
0
$ test-expr '\''(a != (b >= (c || d))) && e'\'' -a 1,0,1,2,1
1
$ test-expr '\''(a != (b >= (c || d))) && e'\'' -a 1,0,2,2,0
0
$ test-expr '\''(a != (b >= (c || d))) && e'\'' -a 1,0,2,2,2
1
$ test-expr '\''(a != (b >= (c || d))) && e'\'' -a 1,1,1,1,2
0
$ test-expr '\''(a != (b >= (c || d))) && e'\'' -a 1,2,0,0,1
0
$ test-expr '\''(a != (b >= (c || d))) && e'\'' -a 1,2,0,1,2
0
$ test-expr '\''(a != (b >= (c || d))) && e'\'' -a 1,2,1,2,2
0
$ test-expr '\''(a != (b >= (c || d))) && e'\'' -a 1,2,2,1,1
0
$ test-expr '\''(a != (b >= (c || d))) && e'\'' -a 1,2,2,2,2
0
$ test-expr '\''(a != (b >= (c || d))) && e'\'' -a 2,0,0,1,1
1
$ test-expr '\''(a != (b >= (c || d))) && e'\'' -a 2,0,1,1,0
0
$ test-expr '\''(a != (b >= (c || d))) && e'\'' -a 2,0,2,2,2
1
$ test-expr '\''(a != (b >= (c || d))) && e'\'' -a 2,1,0,2,0
0
$ test-expr '\''(a != (b >= (c || d))) && e'\'' -a 2,1,1,0,0
0
$ test-expr '\''(a != (b >= (c || d))) && e'\'' -a 2,1,2,0,1
1
$ test-expr '\''(a != (b >= (c || d))) && e'\'' -a 2,1,2,1,1
1
$ test-expr '\''(a != (b >= (c || d))) && e'\'' -a 2,1,2,2,1
1
$ test-expr '\''(a != (b >= (c || d))) && e'\'' -a 2,2,0,1,0
0
$ test-expr '\''(a != (b >= (c || d))) && e'\'' -a 2,2,0,1,1
1
$ test-expr '\''(a != (b >= (c || d))) && e'\'' -a 2,2,1,0,1
1
$ test-expr '\''(a != (b >= (c || d))) && e'\'' -a 2,2,1,1,1
1
$ test-expr '\''(a != (b || c)) && (d >= e)'\'' -a 0,0,1,2,2
1
$ test-expr '\''(a != (b || c)) && (d >= e)'\'' -a 0,1,0,0,0
1
$ test-expr '\''(a != (b || c)) && (d >= e)'\'' -a 0,1,1,1,2
0
$ test-expr '\''(a != (b || c)) && (d >= e)'\'' -a 0,2,0,2,1
1
$ test-expr '\''(a != (b || c)) && (d >= e)'\'' -a 0,2,1,0,2
0
$ test-expr '\''(a != (b || c)) && (d >= e)'\'' -a 0,2,2,1,0
1
$ test-expr '\''(a != (b || c)) && (d >= e)'\'' -a 0,2,2,1,1
1
$ test-expr '\''(a != (b || c)) && (d >= e)'\'' -a 1,0,0,0,2
0
$ test-expr '\''(a != (b || c)) && (d >= e)'\'' -a 1,0,0,2,2
1
$ test-expr '\''(a != (b || c)) && (d >= e)'\'' -a 1,0,1,2,1
0
$ test-expr '\''(a != (b || c)) && (d >= e)'\'' -a 1,0,1,2,2
0
$ test-expr '\''(a != (b || c)) && (d >= e)'\'' -a 1,1,2,0,1
0
$ test-expr '\''(a != (b || c)) && (d >= e)'\'' -a 1,1,2,1,2
0
$ test-expr '\''(a != (b || c)) && (d >= e)'\'' -a 1,1,2,2,0
0
$ test-expr '\''(a != (b || c)) && (d >= e)'\'' -a 1,2,0,0,1
0
$ test-expr '\''(a != (b || c)) && (d >= e)'\'' -a 1,2,1,0,2
0
$ test-expr '\''(a != (b || c)) && (d >= e)'\'' -a 1,2,2,1,2
0
$ test-expr '\''(a != (b || c)) && (d >= e)'\'' -a 2,1,1,0,2
0
$ test-expr '\''(a != (b || c)) && (d >= e)'\'' -a 2,1,1,1,0
1
$ test-expr '\''(a != (b || c)) && (d >= e)'\'' -a 2,1,1,2,0
1
$ test-expr '\''(a != (b || c)) && (d >= e)'\'' -a 2,1,2,2,1
1
$ test-expr '\''(a != (b || c)) && (d >= e)'\'' -a 2,1,2,2,2
1
$ test-expr '\''(a != (b || c)) && (d >= e)'\'' -a 2,2,0,0,0
1
$ test-expr '\''(a != (b || c)) && (d >= e)'\'' -a 2,2,0,2,1
1
$ test-expr '\''(a != (b || c)) && (d >= e)'\'' -a 2,2,1,1,0
1
$ test-expr '\''(a != (b || c)) && (d >= e)'\'' -a 2,2,1,2,1
1
$ test-expr '\''(a != (b || c)) && (d >= e)'\'' -a 2,2,2,0,1
0
$ test-expr '\''(a != (b || c)) >= (d && e)'\'' -a 0,0,0,2,0
1
$ test-expr '\''(a != (b || c)) >= (d && e)'\'' -a 0,0,1,0,1
1
$ test-expr '\''(a != (b || c)) >= (d && e)'\'' -a 0,0,2,1,2
1
$ test-expr '\''(a != (b || c)) >= (d && e)'\'' -a 0,1,0,1,0
1
$ test-expr '\''(a != (b || c)) >= (d && e)'\'' -a 0,1,0,1,1
1
$ test-expr '\''(a != (b || c)) >= (d && e)'\'' -a 0,1,0,2,1
1
$ test-expr '\''(a != (b || c)) >= (d && e)'\'' -a 0,1,1,0,1
1
$ test-expr '\''(a != (b || c)) >= (d && e)'\'' -a 0,1,1,1,0
1
$ test-expr '\''(a != (b || c)) >= (d && e)'\'' -a 0,1,2,0,0
1
$ test-expr '\''(a != (b || c)) >= (d && e)'\'' -a 0,1,2,0,2
1
$ test-expr '\''(a != (b || c)) >= (d && e)'\'' -a 0,2,0,2,2
1
$ test-expr '\''(a != (b || c)) >= (d && e)'\'' -a 0,2,1,1,0
1
$ test-expr '\''(a != (b || c)) >= (d && e)'\'' -a 0,2,1,1,2
1
$ test-expr '\''(a != (b || c)) >= (d && e)'\'' -a 0,2,1,2,0
1
$ test-expr '\''(a != (b || c)) >= (d && e)'\'' -a 0,2,1,2,1
1
$ test-expr '\''(a != (b || c)) >= (d && e)'\'' -a 0,2,2,2,0
1
$ test-expr '\''(a != (b || c)) >= (d && e)'\'' -a 1,0,0,1,1
1
$ test-expr '\''(a != (b || c)) >= (d && e)'\'' -a 1,0,0,2,2
1
$ test-expr '\''(a != (b || c)) >= (d && e)'\'' -a 1,0,1,0,1
1
$ test-expr '\''(a != (b || c)) >= (d && e)'\'' -a 1,0,1,1,2
0
$ test-expr '\''(a != (b || c)) >= (d && e)'\'' -a 1,0,2,1,0
1
$ test-expr '\''(a != (b || c)) >= (d && e)'\'' -a 1,1,0,0,0
1
$ test-expr '\''(a != (b || c)) >= (d && e)'\'' -a 1,1,0,1,0
1
$ test-expr '\''(a != (b || c)) >= (d && e)'\'' -a 1,1,0,2,0
1
$ test-expr '\''(a != (b || c)) >= (d && e)'\'' -a 1,1,0,2,1
0
$ test-expr '\''(a != (b || c)) >= (d && e)'\'' -a 1,1,1,1,1
0
$ test-expr '\''(a != (b || c)) >= (d && e)'\'' -a 1,1,2,2,0
1
$ test-expr '\''(a != (b || c)) >= (d && e)'\'' -a 1,2,1,0,0
1
$ test-expr '\''(a != (b || c)) >= (d && e)'\'' -a 1,2,2,0,2
1
$ test-expr '\''(a != (b || c)) >= (d && e)'\'' -a 2,0,0,0,2
1
$ test-expr '\''(a != (b || c)) >= (d && e)'\'' -a 2,1,0,0,1
1
$ test-expr '\''(a != (b || c)) >= (d && e)'\'' -a 2,1,1,2,0
1
$ test-expr '\''(a != (b || c)) >= (d && e)'\'' -a 2,1,1,2,1
1
$ test-expr '\''(a != (b || c)) >= (d && e)'\'' -a 2,1,2,1,0
1
$ test-expr '\''(a != (b || c)) >= (d && e)'\'' -a 2,2,0,1,1
1
$ test-expr '\''(a != (b || c)) >= (d && e)'\'' -a 2,2,2,0,0
1
$ test-expr '\''(a != (b || c)) >= (d && e)'\'' -a 2,2,2,2,1
1
$ test-expr '\''(a != (b || (c && d))) >= e'\'' -a 0,0,0,0,1
0
$ test-expr '\''(a != (b || (c && d))) >= e'\'' -a 0,0,0,2,0
1
$ test-expr '\''(a != (b || (c && d))) >= e'\'' -a 0,0,1,0,0
1
$ test-expr '\''(a != (b || (c && d))) >= e'\'' -a 0,0,1,2,0
1
$ test-expr '\''(a != (b || (c && d))) >= e'\'' -a 0,0,1,2,1
1
$ test-expr '\''(a != (b || (c && d))) >= e'\'' -a 0,0,2,1,0
1
$ test-expr '\''(a != (b || (c && d))) >= e'\'' -a 0,1,0,0,1
1
$ test-expr '\''(a != (b || (c && d))) >= e'\'' -a 0,1,0,2,2
0
$ test-expr '\''(a != (b || (c && d))) >= e'\'' -a 0,1,2,0,0
1
$ test-expr '\''(a != (b || (c && d))) >= e'\'' -a 0,1,2,1,2
0
$ test-expr '\''(a != (b || (c && d))) >= e'\'' -a 0,1,2,2,0
1
$ test-expr '\''(a != (b || (c && d))) >= e'\'' -a 0,1,2,2,1
1
$ test-expr '\''(a != (b || (c && d))) >= e'\'' -a 0,1,2,2,2
0
$ test-expr '\''(a != (b || (c && d))) >= e'\'' -a 1,0,1,0,0
1
$ test-expr '\''(a != (b || (c && d))) >= e'\'' -a 1,0,2,1,2
0
$ test-expr '\''(a != (b || (c && d))) >= e'\'' -a 1,0,2,2,0
1
$ test-expr '\''(a != (b || (c && d))) >= e'\'' -a 1,1,0,1,0
1
$ test-expr '\''(a != (b || (c && d))) >= e'\'' -a 1,1,1,2,1
0
$ test-expr '\''(a != (b || (c && d))) >= e'\'' -a 1,1,2,1,2
0
$ test-expr '\''(a != (b || (c && d))) >= e'\'' -a 1,2,1,0,2
0
$ test-expr '\''(a != (b || (c && d))) >= e'\'' -a 1,2,1,1,0
1
$ test-expr '\''(a != (b || (c && d))) >= e'\'' -a 1,2,1,1,1
0
$ test-expr '\''(a != (b || (c && d))) >= e'\'' -a 1,2,1,2,1
0
$ test-expr '\''(a != (b || (c && d))) >= e'\'' -a 1,2,2,1,0
1
$ test-expr '\''(a != (b || (c && d))) >= e'\'' -a 2,0,0,1,0
1
$ test-expr '\''(a != (b || (c && d))) >= e'\'' -a 2,0,0,2,0
1
$ test-expr '\''(a != (b || (c && d))) >= e'\'' -a 2,0,1,0,2
0
$ test-expr '\''(a != (b || (c && d))) >= e'\'' -a 2,0,2,2,1
1
$ test-expr '\''(a != (b || (c && d))) >= e'\'' -a 2,1,0,0,0
1
$ test-expr '\''(a != (b || (c && d))) >= e'\'' -a 2,1,0,1,2
0
$ test-expr '\''(a != (b || (c && d))) >= e'\'' -a 2,1,1,2,2
0
$ test-expr '\''(a != (b || (c && d))) >= e'\'' -a 2,1,2,1,2
0
$ test-expr '\''(a != (b || (c && d))) >= e'\'' -a 2,2,0,2,0
1
$ test-expr '\''(a != (b || (c && d))) >= e'\'' -a 2,2,1,0,1
1
$ test-expr '\''(a != (b || (c && d))) >= e'\'' -a 2,2,1,1,0
1
$ test-expr '\''(a != (b || (c >= d))) && e'\'' -a 0,1,0,0,0
0
$ test-expr '\''(a != (b || (c >= d))) && e'\'' -a 0,1,0,1,1
1
$ test-expr '\''(a != (b || (c >= d))) && e'\'' -a 0,1,2,2,1
1
$ test-expr '\''(a != (b || (c >= d))) && e'\'' -a 0,2,0,1,0
0
$ test-expr '\''(a != (b || (c >= d))) && e'\'' -a 0,2,0,1,2
1
$ test-expr '\''(a != (b || (c >= d))) && e'\'' -a 0,2,1,0,1
1
$ test-expr '\''(a != (b || (c >= d))) && e'\'' -a 0,2,1,0,2
1
$ test-expr '\''(a != (b || (c >= d))) && e'\'' -a 0,2,2,1,2
1
$ test-expr '\''(a != (b || (c >= d))) && e'\'' -a 1,0,0,0,0
0
$ test-expr '\''(a != (b || (c >= d))) && e'\'' -a 1,0,0,0,2
0
$ test-expr '\''(a != (b || (c >= d))) && e'\'' -a 1,0,0,2,2
1
$ test-expr '\''(a != (b || (c >= d))) && e'\'' -a 1,0,1,2,1
1
$ test-expr '\''(a != (b || (c >= d))) && e'\'' -a 1,0,2,1,0
0
$ test-expr '\''(a != (b || (c >= d))) && e'\'' -a 1,1,0,2,0
0
$ test-expr '\''(a != (b || (c >= d))) && e'\'' -a 1,2,0,1,0
0
$ test-expr '\''(a != (b || (c >= d))) && e'\'' -a 1,2,0,1,2
0
$ test-expr '\''(a != (b || (c >= d))) && e'\'' -a 1,2,1,1,2
0
$ test-expr '\''(a != (b || (c >= d))) && e'\'' -a 1,2,2,0,2
0
$ test-expr '\''(a != (b || (c >= d))) && e'\'' -a 1,2,2,2,0
0
$ test-expr '\''(a != (b || (c >= d))) && e'\'' -a 1,2,2,2,1
0
$ test-expr '\''(a != (b || (c >= d))) && e'\'' -a 2,0,0,0,1
1
$ test-expr '\''(a != (b || (c >= d))) && e'\'' -a 2,1,1,0,1
1
$ test-expr '\''(a != (b || (c >= d))) && e'\'' -a 2,1,1,1,0
0
$ test-expr '\''(a != (b || (c >= d))) && e'\'' -a 2,1,1,1,2
1
$ test-expr '\''(a != (b || (c >= d))) && e'\'' -a 2,1,1,2,1
1
$ test-expr '\''(a != (b || (c >= d))) && e'\'' -a 2,1,1,2,2
1
$ test-expr '\''(a != (b || (c >= d))) && e'\'' -a 2,1,2,1,0
0
$ test-expr '\''(a != (b || (c >= d))) && e'\'' -a 2,1,2,2,1
1
$ test-expr '\''(a != (b || (c >= d))) && e'\'' -a 2,1,2,2,2
1
$ test-expr '\''(a != (b || (c >= d))) && e'\'' -a 2,2,1,1,2
1
$ test-expr '\''(a != (b || (c >= d))) && e'\'' -a 2,2,2,0,0
0
$ test-expr '\''(a != ((b && c) >= d)) || e'\'' -a 0,0,0,0,2
1
$ test-expr '\''(a != ((b && c) >= d)) || e'\'' -a 0,0,0,1,1
1
$ test-expr '\''(a != ((b && c) >= d)) || e'\'' -a 0,0,0,1,2
1
$ test-expr '\''(a != ((b && c) >= d)) || e'\'' -a 0,0,2,1,2
1
$ test-expr '\''(a != ((b && c) >= d)) || e'\'' -a 0,1,0,2,0
0
$ test-expr '\''(a != ((b && c) >= d)) || e'\'' -a 0,1,2,0,0
1
$ test-expr '\''(a != ((b && c) >= d)) || e'\'' -a 0,1,2,0,1
1
$ test-expr '\''(a != ((b && c) >= d)) || e'\'' -a 0,1,2,2,0
0
$ test-expr '\''(a != ((b && c) >= d)) || e'\'' -a 0,2,1,2,0
0
$ test-expr '\''(a != ((b && c) >= d)) || e'\'' -a 0,2,1,2,2
1
$ test-expr '\''(a != ((b && c) >= d)) || e'\'' -a 0,2,2,2,2
1
$ test-expr '\''(a != ((b && c) >= d)) || e'\'' -a 1,0,0,2,1
1
$ test-expr '\''(a != ((b && c) >= d)) || e'\'' -a 1,0,1,0,1
1
$ test-expr '\''(a != ((b && c) >= d)) || e'\'' -a 1,0,1,1,1
1
$ test-expr '\''(a != ((b && c) >= d)) || e'\'' -a 1,0,2,0,2
1
$ test-expr '\''(a != ((b && c) >= d)) || e'\'' -a 1,1,0,2,1
1
$ test-expr '\''(a != ((b && c) >= d)) || e'\'' -a 1,1,1,2,1
1
$ test-expr '\''(a != ((b && c) >= d)) || e'\'' -a 1,1,1,2,2
1
$ test-expr '\''(a != ((b && c) >= d)) || e'\'' -a 1,1,2,2,0
1
$ test-expr '\''(a != ((b && c) >= d)) || e'\'' -a 1,2,2,0,2
1
$ test-expr '\''(a != ((b && c) >= d)) || e'\'' -a 1,2,2,1,0
0
$ test-expr '\''(a != ((b && c) >= d)) || e'\'' -a 2,0,0,1,0
1
$ test-expr '\''(a != ((b && c) >= d)) || e'\'' -a 2,0,0,1,2
1
$ test-expr '\''(a != ((b && c) >= d)) || e'\'' -a 2,0,2,0,2
1
$ test-expr '\''(a != ((b && c) >= d)) || e'\'' -a 2,0,2,1,0
1
$ test-expr '\''(a != ((b && c) >= d)) || e'\'' -a 2,0,2,2,2
1
$ test-expr '\''(a != ((b && c) >= d)) || e'\'' -a 2,1,0,0,0
1
$ test-expr '\''(a != ((b && c) >= d)) || e'\'' -a 2,1,0,1,0
1
$ test-expr '\''(a != ((b && c) >= d)) || e'\'' -a 2,1,0,1,2
1
$ test-expr '\''(a != ((b && c) >= d)) || e'\'' -a 2,1,0,2,0
1
$ test-expr '\''(a != ((b && c) >= d)) || e'\'' -a 2,1,0,2,1
1
$ test-expr '\''(a != ((b && c) >= d)) || e'\'' -a 2,1,1,1,1
1
$ test-expr '\''(a != ((b && c) >= d)) || e'\'' -a 2,2,2,0,1
1
$ test-expr '\''(a != ((b && c) >= d)) || e'\'' -a 2,2,2,1,1
1
$ test-expr '\''(a != ((b && c) || d)) >= e'\'' -a 0,0,0,2,0
1
$ test-expr '\''(a != ((b && c) || d)) >= e'\'' -a 0,0,0,2,1
1
$ test-expr '\''(a != ((b && c) || d)) >= e'\'' -a 0,0,1,0,2
0
$ test-expr '\''(a != ((b && c) || d)) >= e'\'' -a 0,0,2,1,1
1
$ test-expr '\''(a != ((b && c) || d)) >= e'\'' -a 0,1,0,0,2
0
$ test-expr '\''(a != ((b && c) || d)) >= e'\'' -a 0,1,0,1,0
1
$ test-expr '\''(a != ((b && c) || d)) >= e'\'' -a 0,1,0,2,0
1
$ test-expr '\''(a != ((b && c) || d)) >= e'\'' -a 0,1,1,0,1
1
$ test-expr '\''(a != ((b && c) || d)) >= e'\'' -a 0,2,0,2,0
1
$ test-expr '\''(a != ((b && c) || d)) >= e'\'' -a 0,2,1,1,0
1
$ test-expr '\''(a != ((b && c) || d)) >= e'\'' -a 0,2,2,1,2
0
$ test-expr '\''(a != ((b && c) || d)) >= e'\'' -a 1,0,1,1,0
1
$ test-expr '\''(a != ((b && c) || d)) >= e'\'' -a 1,0,2,1,0
1
$ test-expr '\''(a != ((b && c) || d)) >= e'\'' -a 1,0,2,2,2
0
$ test-expr '\''(a != ((b && c) || d)) >= e'\'' -a 1,1,1,2,0
1
$ test-expr '\''(a != ((b && c) || d)) >= e'\'' -a 1,1,1,2,2
0
$ test-expr '\''(a != ((b && c) || d)) >= e'\'' -a 1,2,0,0,1
1
$ test-expr '\''(a != ((b && c) || d)) >= e'\'' -a 1,2,0,0,2
0
$ test-expr '\''(a != ((b && c) || d)) >= e'\'' -a 1,2,1,0,1
0
$ test-expr '\''(a != ((b && c) || d)) >= e'\'' -a 2,0,0,1,1
1
$ test-expr '\''(a != ((b && c) || d)) >= e'\'' -a 2,0,0,2,2
0
$ test-expr '\''(a != ((b && c) || d)) >= e'\'' -a 2,0,1,0,2
0
$ test-expr '\''(a != ((b && c) || d)) >= e'\'' -a 2,0,1,1,2
0
$ test-expr '\''(a != ((b && c) || d)) >= e'\'' -a 2,1,0,0,2
0
$ test-expr '\''(a != ((b && c) || d)) >= e'\'' -a 2,1,1,1,2
0
$ test-expr '\''(a != ((b && c) || d)) >= e'\'' -a 2,1,1,2,2
0
$ test-expr '\''(a != ((b && c) || d)) >= e'\'' -a 2,2,0,0,0
1
$ test-expr '\''(a != ((b && c) || d)) >= e'\'' -a 2,2,0,2,0
1
$ test-expr '\''(a != ((b && c) || d)) >= e'\'' -a 2,2,1,0,1
1
$ test-expr '\''(a != ((b && c) || d)) >= e'\'' -a 2,2,1,2,1
1
$ test-expr '\''(a != ((b >= c) && d)) || e'\'' -a 0,0,0,1,0
1
$ test-expr '\''(a != ((b >= c) && d)) || e'\'' -a 0,0,1,1,1
1
$ test-expr '\''(a != ((b >= c) && d)) || e'\'' -a 0,0,2,0,2
1
$ test-expr '\''(a != ((b >= c) && d)) || e'\'' -a 0,0,2,2,1
1
$ test-expr '\''(a != ((b >= c) && d)) || e'\'' -a 0,1,2,2,0
0
$ test-expr '\''(a != ((b >= c) && d)) || e'\'' -a 0,2,1,0,0
0
$ test-expr '\''(a != ((b >= c) && d)) || e'\'' -a 0,2,1,1,0
1
$ test-expr '\''(a != ((b >= c) && d)) || e'\'' -a 0,2,2,0,0
0
$ test-expr '\''(a != ((b >= c) && d)) || e'\'' -a 0,2,2,0,1
1
$ test-expr '\''(a != ((b >= c) && d)) || e'\'' -a 1,0,0,2,2
1
$ test-expr '\''(a != ((b >= c) && d)) || e'\'' -a 1,0,1,1,0
1
$ test-expr '\''(a != ((b >= c) && d)) || e'\'' -a 1,1,0,1,0
0
$ test-expr '\''(a != ((b >= c) && d)) || e'\'' -a 1,2,0,2,0
0
$ test-expr '\''(a != ((b >= c) && d)) || e'\'' -a 1,2,1,0,2
1
$ test-expr '\''(a != ((b >= c) && d)) || e'\'' -a 1,2,2,1,0
0
$ test-expr '\''(a != ((b >= c) && d)) || e'\'' -a 2,0,0,0,2
1
$ test-expr '\''(a != ((b >= c) && d)) || e'\'' -a 2,0,2,2,1
1
$ test-expr '\''(a != ((b >= c) && d)) || e'\'' -a 2,1,0,1,0
1
$ test-expr '\''(a != ((b >= c) && d)) || e'\'' -a 2,1,0,1,1
1
$ test-expr '\''(a != ((b >= c) && d)) || e'\'' -a 2,1,1,0,2
1
$ test-expr '\''(a != ((b >= c) && d)) || e'\'' -a 2,1,2,2,1
1
$ test-expr '\''(a != ((b >= c) && d)) || e'\'' -a 2,1,2,2,2
1
$ test-expr '\''(a != ((b >= c) && d)) || e'\'' -a 2,2,0,1,2
1
$ test-expr '\''(a != ((b >= c) && d)) || e'\'' -a 2,2,2,2,2
1
$ test-expr '\''(a != ((b >= c) || d)) && e'\'' -a 0,0,0,1,2
1
$ test-expr '\''(a != ((b >= c) || d)) && e'\'' -a 0,0,1,0,1
0
$ test-expr '\''(a != ((b >= c) || d)) && e'\'' -a 0,0,2,1,2
1
$ test-expr '\''(a != ((b >= c) || d)) && e'\'' -a 0,1,0,2,1
1
$ test-expr '\''(a != ((b >= c) || d)) && e'\'' -a 0,2,1,1,2
1
$ test-expr '\''(a != ((b >= c) || d)) && e'\'' -a 0,2,2,1,0
0
$ test-expr '\''(a != ((b >= c) || d)) && e'\'' -a 0,2,2,2,0
0
$ test-expr '\''(a != ((b >= c) || d)) && e'\'' -a 1,0,1,2,1
0
$ test-expr '\''(a != ((b >= c) || d)) && e'\'' -a 1,0,2,0,2
1
$ test-expr '\''(a != ((b >= c) || d)) && e'\'' -a 1,0,2,1,0
0
$ test-expr '\''(a != ((b >= c) || d)) && e'\'' -a 1,1,0,0,0
0
$ test-expr '\''(a != ((b >= c) || d)) && e'\'' -a 1,1,0,2,2
0
$ test-expr '\''(a != ((b >= c) || d)) && e'\'' -a 1,1,1,0,2
0
$ test-expr '\''(a != ((b >= c) || d)) && e'\'' -a 1,1,1,1,0
0
$ test-expr '\''(a != ((b >= c) || d)) && e'\'' -a 1,1,1,2,1
0
$ test-expr '\''(a != ((b >= c) || d)) && e'\'' -a 1,1,2,0,2
1
$ test-expr '\''(a != ((b >= c) || d)) && e'\'' -a 1,2,1,0,0
0
$ test-expr '\''(a != ((b >= c) || d)) && e'\'' -a 1,2,2,0,2
0
$ test-expr '\''(a != ((b >= c) || d)) && e'\'' -a 1,2,2,2,2
0
$ test-expr '\''(a != ((b >= c) || d)) && e'\'' -a 2,0,1,1,1
1
$ test-expr '\''(a != ((b >= c) || d)) && e'\'' -a 2,0,2,0,1
1
$ test-expr '\''(a != ((b >= c) || d)) && e'\'' -a 2,2,1,0,1
1
$ test-expr '\''(a != ((b >= c) || d)) && e'\'' -a 2,2,1,1,0
0
$ test-expr '\''(a != ((b >= c) || d)) && e'\'' -a 2,2,1,1,1
1
$ test-expr '\''(a != ((b >= c) || d)) && e'\'' -a 2,2,2,1,2
1
$ test-expr '\''(a != ((b || c) && d)) >= e'\'' -a 0,0,0,0,0
1
$ test-expr '\''(a != ((b || c) && d)) >= e'\'' -a 0,0,0,2,0
1
$ test-expr '\''(a != ((b || c) && d)) >= e'\'' -a 0,0,2,2,2
0
$ test-expr '\''(a != ((b || c) && d)) >= e'\'' -a 0,1,0,1,2
0
$ test-expr '\''(a != ((b || c) && d)) >= e'\'' -a 0,1,2,1,0
1
$ test-expr '\''(a != ((b || c) && d)) >= e'\'' -a 0,1,2,1,2
0
$ test-expr '\''(a != ((b || c) && d)) >= e'\'' -a 0,2,2,1,2
0
$ test-expr '\''(a != ((b || c) && d)) >= e'\'' -a 0,2,2,2,0
1
$ test-expr '\''(a != ((b || c) && d)) >= e'\'' -a 1,0,0,0,1
1
$ test-expr '\''(a != ((b || c) && d)) >= e'\'' -a 1,0,1,0,0
1
$ test-expr '\''(a != ((b || c) && d)) >= e'\'' -a 1,1,0,0,0
1
$ test-expr '\''(a != ((b || c) && d)) >= e'\'' -a 1,1,0,0,1
1
$ test-expr '\''(a != ((b || c) && d)) >= e'\'' -a 1,1,0,1,0
1
$ test-expr '\''(a != ((b || c) && d)) >= e'\'' -a 1,1,0,2,2
0
$ test-expr '\''(a != ((b || c) && d)) >= e'\'' -a 1,1,1,1,0
1
$ test-expr '\''(a != ((b || c) && d)) >= e'\'' -a 1,2,0,1,2
0
$ test-expr '\''(a != ((b || c) && d)) >= e'\'' -a 1,2,1,0,0
1
$ test-expr '\''(a != ((b || c) && d)) >= e'\'' -a 1,2,1,2,2
0
$ test-expr '\''(a != ((b || c) && d)) >= e'\'' -a 2,0,0,0,2
0
$ test-expr '\''(a != ((b || c) && d)) >= e'\'' -a 2,1,0,1,1
1
$ test-expr '\''(a != ((b || c) && d)) >= e'\'' -a 2,1,0,2,0
1
$ test-expr '\''(a != ((b || c) && d)) >= e'\'' -a 2,1,0,2,1
1
$ test-expr '\''(a != ((b || c) && d)) >= e'\'' -a 2,1,2,1,0
1
$ test-expr '\''(a != ((b || c) && d)) >= e'\'' -a 2,2,1,2,2
0
$ test-expr '\''(a != ((b || c) >= d)) && e'\'' -a 0,0,0,1,1
0
$ test-expr '\''(a != ((b || c) >= d)) && e'\'' -a 0,0,1,0,2
1
$ test-expr '\''(a != ((b || c) >= d)) && e'\'' -a 0,1,1,2,0
0
$ test-expr '\''(a != ((b || c) >= d)) && e'\'' -a 0,1,2,0,0
0
$ test-expr '\''(a != ((b || c) >= d)) && e'\'' -a 0,2,0,1,1
1
$ test-expr '\''(a != ((b || c) >= d)) && e'\'' -a 0,2,0,2,0
0
$ test-expr '\''(a != ((b || c) >= d)) && e'\'' -a 0,2,1,2,0
0
$ test-expr '\''(a != ((b || c) >= d)) && e'\'' -a 0,2,1,2,2
0
$ test-expr '\''(a != ((b || c) >= d)) && e'\'' -a 1,0,0,2,1
1
$ test-expr '\''(a != ((b || c) >= d)) && e'\'' -a 1,0,1,2,0
0
$ test-expr '\''(a != ((b || c) >= d)) && e'\'' -a 1,0,1,2,2
1
$ test-expr '\''(a != ((b || c) >= d)) && e'\'' -a 1,0,2,1,1
0
$ test-expr '\''(a != ((b || c) >= d)) && e'\'' -a 1,1,0,1,1
0
$ test-expr '\''(a != ((b || c) >= d)) && e'\'' -a 1,1,1,0,0
0
$ test-expr '\''(a != ((b || c) >= d)) && e'\'' -a 1,1,1,0,1
0
$ test-expr '\''(a != ((b || c) >= d)) && e'\'' -a 1,1,2,1,1
0
$ test-expr '\''(a != ((b || c) >= d)) && e'\'' -a 1,2,0,0,0
0
$ test-expr '\''(a != ((b || c) >= d)) && e'\'' -a 1,2,1,0,0
0
$ test-expr '\''(a != ((b || c) >= d)) && e'\'' -a 1,2,2,1,1
0
$ test-expr '\''(a != ((b || c) >= d)) && e'\'' -a 1,2,2,2,0
0
$ test-expr '\''(a != ((b || c) >= d)) && e'\'' -a 2,0,1,0,2
1
$ test-expr '\''(a != ((b || c) >= d)) && e'\'' -a 2,0,1,2,0
0
$ test-expr '\''(a != ((b || c) >= d)) && e'\'' -a 2,0,2,1,2
1
$ test-expr '\''(a != ((b || c) >= d)) && e'\'' -a 2,1,0,0,1
1
$ test-expr '\''(a != ((b || c) >= d)) && e'\'' -a 2,1,1,1,1
1
$ test-expr '\''(a != ((b || c) >= d)) && e'\'' -a 2,1,1,1,2
1
$ test-expr '\''(a != ((b || c) >= d)) && e'\'' -a 2,1,2,1,2
1
$ test-expr '\''(a != ((b || c) >= d)) && e'\'' -a 2,2,0,0,0
0
$ test-expr '\''(a != ((b || c) >= d)) && e'\'' -a 2,2,2,2,1
1
$ test-expr '\''(a && b) != (c >= (d || e))'\'' -a 0,0,0,2,2
0
$ test-expr '\''(a && b) != (c >= (d || e))'\'' -a 0,1,0,2,1
0
$ test-expr '\''(a && b) != (c >= (d || e))'\'' -a 0,1,0,2,2
0
$ test-expr '\''(a && b) != (c >= (d || e))'\'' -a 0,1,1,1,1
1
$ test-expr '\''(a && b) != (c >= (d || e))'\'' -a 0,1,1,2,0
1
$ test-expr '\''(a && b) != (c >= (d || e))'\'' -a 0,1,2,2,0
1
$ test-expr '\''(a && b) != (c >= (d || e))'\'' -a 0,2,0,0,0
1
$ test-expr '\''(a && b) != (c >= (d || e))'\'' -a 0,2,1,0,1
1
$ test-expr '\''(a && b) != (c >= (d || e))'\'' -a 0,2,2,0,2
1
$ test-expr '\''(a && b) != (c >= (d || e))'\'' -a 0,2,2,1,2
1
$ test-expr '\''(a && b) != (c >= (d || e))'\'' -a 0,2,2,2,0
1
$ test-expr '\''(a && b) != (c >= (d || e))'\'' -a 0,2,2,2,1
1
$ test-expr '\''(a && b) != (c >= (d || e))'\'' -a 1,0,1,0,1
1
$ test-expr '\''(a && b) != (c >= (d || e))'\'' -a 1,0,1,1,0
1
$ test-expr '\''(a && b) != (c >= (d || e))'\'' -a 1,0,1,2,1
1
$ test-expr '\''(a && b) != (c >= (d || e))'\'' -a 1,1,2,1,2
0
$ test-expr '\''(a && b) != (c >= (d || e))'\'' -a 1,2,0,1,0
1
$ test-expr '\''(a && b) != (c >= (d || e))'\'' -a 1,2,0,2,1
1
$ test-expr '\''(a && b) != (c >= (d || e))'\'' -a 1,2,1,0,2
0
$ test-expr '\''(a && b) != (c >= (d || e))'\'' -a 1,2,1,2,0
0
$ test-expr '\''(a && b) != (c >= (d || e))'\'' -a 1,2,1,2,2
0
$ test-expr '\''(a && b) != (c >= (d || e))'\'' -a 1,2,2,1,1
0
$ test-expr '\''(a && b) != (c >= (d || e))'\'' -a 2,0,0,1,0
0
$ test-expr '\''(a && b) != (c >= (d || e))'\'' -a 2,0,2,2,1
1
$ test-expr '\''(a && b) != (c >= (d || e))'\'' -a 2,0,2,2,2
1
$ test-expr '\''(a && b) != (c >= (d || e))'\'' -a 2,1,0,0,2
1
$ test-expr '\''(a && b) != (c >= (d || e))'\'' -a 2,1,2,0,0
0
$ test-expr '\''(a && b) != (c >= (d || e))'\'' -a 2,2,0,0,0
0
$ test-expr '\''(a && b) != (c >= (d || e))'\'' -a 2,2,0,1,1
1
$ test-expr '\''(a && b) != (c >= (d || e))'\'' -a 2,2,2,1,0
0
$ test-expr '\''(a && b) != (c || (d >= e))'\'' -a 0,0,0,0,2
0
$ test-expr '\''(a && b) != (c || (d >= e))'\'' -a 0,0,0,1,2
0
$ test-expr '\''(a && b) != (c || (d >= e))'\'' -a 0,0,2,0,0
1
$ test-expr '\''(a && b) != (c || (d >= e))'\'' -a 0,0,2,1,1
1
$ test-expr '\''(a && b) != (c || (d >= e))'\'' -a 0,0,2,1,2
1
$ test-expr '\''(a && b) != (c || (d >= e))'\'' -a 0,1,0,0,2
0
$ test-expr '\''(a && b) != (c || (d >= e))'\'' -a 0,1,2,1,1
1
$ test-expr '\''(a && b) != (c || (d >= e))'\'' -a 0,2,0,1,1
1
$ test-expr '\''(a && b) != (c || (d >= e))'\'' -a 0,2,0,1,2
0
$ test-expr '\''(a && b) != (c || (d >= e))'\'' -a 0,2,0,2,0
1
$ test-expr '\''(a && b) != (c || (d >= e))'\'' -a 0,2,1,1,1
1
$ test-expr '\''(a && b) != (c || (d >= e))'\'' -a 0,2,2,0,2
1
$ test-expr '\''(a && b) != (c || (d >= e))'\'' -a 0,2,2,1,0
1
$ test-expr '\''(a && b) != (c || (d >= e))'\'' -a 0,2,2,1,2
1
$ test-expr '\''(a && b) != (c || (d >= e))'\'' -a 0,2,2,2,2
1
$ test-expr '\''(a && b) != (c || (d >= e))'\'' -a 1,0,0,0,0
1
$ test-expr '\''(a && b) != (c || (d >= e))'\'' -a 1,0,0,2,0
1
$ test-expr '\''(a && b) != (c || (d >= e))'\'' -a 1,0,0,2,2
1
$ test-expr '\''(a && b) != (c || (d >= e))'\'' -a 1,0,1,1,2
1
$ test-expr '\''(a && b) != (c || (d >= e))'\'' -a 1,1,0,0,2
1
$ test-expr '\''(a && b) != (c || (d >= e))'\'' -a 1,1,0,1,0
0
$ test-expr '\''(a && b) != (c || (d >= e))'\'' -a 1,1,0,1,1
0
$ test-expr '\''(a && b) != (c || (d >= e))'\'' -a 1,1,2,0,1
0
$ test-expr '\''(a && b) != (c || (d >= e))'\'' -a 1,1,2,2,2
0
$ test-expr '\''(a && b) != (c || (d >= e))'\'' -a 1,2,0,1,0
0
$ test-expr '\''(a && b) != (c || (d >= e))'\'' -a 2,0,1,0,1
1
$ test-expr '\''(a && b) != (c || (d >= e))'\'' -a 2,0,2,0,0
1
$ test-expr '\''(a && b) != (c || (d >= e))'\'' -a 2,1,0,0,0
0
$ test-expr '\''(a && b) != (c || (d >= e))'\'' -a 2,1,2,0,2
0
$ test-expr '\''(a && b) != (c || (d >= e))'\'' -a 2,1,2,1,1
0
$ test-expr '\''(a && b) != (c || (d >= e))'\'' -a 2,2,1,2,2
0
$ test-expr '\''(a && b) != ((c >= d) || e)'\'' -a 0,0,1,0,1
1
$ test-expr '\''(a && b) != ((c >= d) || e)'\'' -a 0,0,2,0,2
1
$ test-expr '\''(a && b) != ((c >= d) || e)'\'' -a 0,0,2,1,0
1
$ test-expr '\''(a && b) != ((c >= d) || e)'\'' -a 0,1,0,0,0
1
$ test-expr '\''(a && b) != ((c >= d) || e)'\'' -a 0,1,0,1,1
1
$ test-expr '\''(a && b) != ((c >= d) || e)'\'' -a 0,1,0,1,2
1
$ test-expr '\''(a && b) != ((c >= d) || e)'\'' -a 0,1,1,2,2
1
$ test-expr '\''(a && b) != ((c >= d) || e)'\'' -a 0,1,2,0,2
1
$ test-expr '\''(a && b) != ((c >= d) || e)'\'' -a 0,2,1,0,1
1
$ test-expr '\''(a && b) != ((c >= d) || e)'\'' -a 0,2,1,1,2
1
$ test-expr '\''(a && b) != ((c >= d) || e)'\'' -a 0,2,2,2,0
1
$ test-expr '\''(a && b) != ((c >= d) || e)'\'' -a 1,0,1,0,2
1
$ test-expr '\''(a && b) != ((c >= d) || e)'\'' -a 1,0,1,1,1
1
$ test-expr '\''(a && b) != ((c >= d) || e)'\'' -a 1,1,0,0,2
0
$ test-expr '\''(a && b) != ((c >= d) || e)'\'' -a 1,1,0,2,1
0
$ test-expr '\''(a && b) != ((c >= d) || e)'\'' -a 1,1,1,2,0
1
$ test-expr '\''(a && b) != ((c >= d) || e)'\'' -a 1,1,1,2,2
0
$ test-expr '\''(a && b) != ((c >= d) || e)'\'' -a 1,1,2,1,0
0
$ test-expr '\''(a && b) != ((c >= d) || e)'\'' -a 1,2,2,1,1
0
$ test-expr '\''(a && b) != ((c >= d) || e)'\'' -a 1,2,2,1,2
0
$ test-expr '\''(a && b) != ((c >= d) || e)'\'' -a 2,1,0,0,1
0
$ test-expr '\''(a && b) != ((c >= d) || e)'\'' -a 2,1,0,0,2
0
$ test-expr '\''(a && b) != ((c >= d) || e)'\'' -a 2,1,0,1,0
1
$ test-expr '\''(a && b) != ((c >= d) || e)'\'' -a 2,1,0,1,1
0
$ test-expr '\''(a && b) != ((c >= d) || e)'\'' -a 2,1,1,0,2
0
$ test-expr '\''(a && b) != ((c >= d) || e)'\'' -a 2,1,1,1,0
0
$ test-expr '\''(a && b) != ((c >= d) || e)'\'' -a 2,1,1,1,1
0
$ test-expr '\''(a && b) != ((c >= d) || e)'\'' -a 2,1,1,1,2
0
$ test-expr '\''(a && b) != ((c >= d) || e)'\'' -a 2,2,0,1,1
0
$ test-expr '\''(a && b) != ((c >= d) || e)'\'' -a 2,2,0,2,2
0
$ test-expr '\''(a && b) != ((c >= d) || e)'\'' -a 2,2,1,2,2
0
$ test-expr '\''(a && b) != ((c >= d) || e)'\'' -a 2,2,2,2,0
0
$ test-expr '\''(a && b) != ((c || d) >= e)'\'' -a 0,0,0,2,0
1
$ test-expr '\''(a && b) != ((c || d) >= e)'\'' -a 0,0,1,2,1
1
$ test-expr '\''(a && b) != ((c || d) >= e)'\'' -a 0,1,0,1,0
1
$ test-expr '\''(a && b) != ((c || d) >= e)'\'' -a 0,1,0,1,1
1
$ test-expr '\''(a && b) != ((c || d) >= e)'\'' -a 0,1,0,1,2
0
$ test-expr '\''(a && b) != ((c || d) >= e)'\'' -a 0,1,0,2,2
0
$ test-expr '\''(a && b) != ((c || d) >= e)'\'' -a 0,1,1,2,1
1
$ test-expr '\''(a && b) != ((c || d) >= e)'\'' -a 0,2,1,0,0
1
$ test-expr '\''(a && b) != ((c || d) >= e)'\'' -a 0,2,1,0,2
0
$ test-expr '\''(a && b) != ((c || d) >= e)'\'' -a 0,2,1,1,1
1
$ test-expr '\''(a && b) != ((c || d) >= e)'\'' -a 0,2,2,0,0
1
$ test-expr '\''(a && b) != ((c || d) >= e)'\'' -a 1,0,0,0,1
0
$ test-expr '\''(a && b) != ((c || d) >= e)'\'' -a 1,0,0,0,2
0
$ test-expr '\''(a && b) != ((c || d) >= e)'\'' -a 1,0,0,2,1
1
$ test-expr '\''(a && b) != ((c || d) >= e)'\'' -a 1,0,1,2,1
1
$ test-expr '\''(a && b) != ((c || d) >= e)'\'' -a 1,0,2,0,0
1
$ test-expr '\''(a && b) != ((c || d) >= e)'\'' -a 1,1,1,1,2
1
$ test-expr '\''(a && b) != ((c || d) >= e)'\'' -a 1,1,1,2,2
1
$ test-expr '\''(a && b) != ((c || d) >= e)'\'' -a 1,2,0,0,1
1
$ test-expr '\''(a && b) != ((c || d) >= e)'\'' -a 1,2,2,1,2
1
$ test-expr '\''(a && b) != ((c || d) >= e)'\'' -a 1,2,2,2,0
0
$ test-expr '\''(a && b) != ((c || d) >= e)'\'' -a 2,1,0,2,0
0
$ test-expr '\''(a && b) != ((c || d) >= e)'\'' -a 2,1,1,2,0
0
$ test-expr '\''(a && b) != ((c || d) >= e)'\'' -a 2,2,0,1,1
0
$ test-expr '\''(a && b) != ((c || d) >= e)'\'' -a 2,2,0,2,0
0
$ test-expr '\''(a && b) != ((c || d) >= e)'\'' -a 2,2,1,0,2
1
$ test-expr '\''(a && b) >= (c != (d || e))'\'' -a 0,0,0,1,2
0
$ test-expr '\''(a && b) >= (c != (d || e))'\'' -a 0,0,0,2,2
0
$ test-expr '\''(a && b) >= (c != (d || e))'\'' -a 0,0,1,0,1
1
$ test-expr '\''(a && b) >= (c != (d || e))'\'' -a 0,0,2,2,1
0
$ test-expr '\''(a && b) >= (c != (d || e))'\'' -a 0,1,0,0,0
1
$ test-expr '\''(a && b) >= (c != (d || e))'\'' -a 0,1,0,1,2
0
$ test-expr '\''(a && b) >= (c != (d || e))'\'' -a 0,2,0,0,2
0
$ test-expr '\''(a && b) >= (c != (d || e))'\'' -a 0,2,0,1,1
0
$ test-expr '\''(a && b) >= (c != (d || e))'\'' -a 0,2,0,2,1
0
$ test-expr '\''(a && b) >= (c != (d || e))'\'' -a 0,2,1,1,0
1
$ test-expr '\''(a && b) >= (c != (d || e))'\'' -a 0,2,1,2,0
1
$ test-expr '\''(a && b) >= (c != (d || e))'\'' -a 0,2,2,2,0
0
$ test-expr '\''(a && b) >= (c != (d || e))'\'' -a 1,0,0,1,1
0
$ test-expr '\''(a && b) >= (c != (d || e))'\'' -a 1,0,1,0,1
1
$ test-expr '\''(a && b) >= (c != (d || e))'\'' -a 1,0,1,0,2
1
$ test-expr '\''(a && b) >= (c != (d || e))'\'' -a 1,0,1,1,0
1
$ test-expr '\''(a && b) >= (c != (d || e))'\'' -a 1,0,2,1,2
0
$ test-expr '\''(a && b) >= (c != (d || e))'\'' -a 1,1,1,1,0
1
$ test-expr '\''(a && b) >= (c != (d || e))'\'' -a 1,1,1,1,2
1
$ test-expr '\''(a && b) >= (c != (d || e))'\'' -a 1,1,1,2,2
1
$ test-expr '\''(a && b) >= (c != (d || e))'\'' -a 1,2,1,0,1
1
$ test-expr '\''(a && b) >= (c != (d || e))'\'' -a 1,2,1,1,0
1
$ test-expr '\''(a && b) >= (c != (d || e))'\'' -a 2,0,0,1,0
0
$ test-expr '\''(a && b) >= (c != (d || e))'\'' -a 2,0,1,0,0
0
$ test-expr '\''(a && b) >= (c != (d || e))'\'' -a 2,1,0,0,1
1
$ test-expr '\''(a && b) >= (c != (d || e))'\'' -a 2,1,0,2,2
1
$ test-expr '\''(a && b) >= (c != (d || e))'\'' -a 2,1,2,0,0
1
$ test-expr '\''(a && b) >= (c != (d || e))'\'' -a 2,1,2,2,0
1
$ test-expr '\''(a && b) >= (c || (d != e))'\'' -a 0,1,1,2,2
0
$ test-expr '\''(a && b) >= (c || (d != e))'\'' -a 0,2,0,1,1
1
$ test-expr '\''(a && b) >= (c || (d != e))'\'' -a 1,0,0,0,0
1
$ test-expr '\''(a && b) >= (c || (d != e))'\'' -a 1,0,1,1,0
0
$ test-expr '\''(a && b) >= (c || (d != e))'\'' -a 1,0,2,0,0
0
$ test-expr '\''(a && b) >= (c || (d != e))'\'' -a 1,0,2,1,2
0
$ test-expr '\''(a && b) >= (c || (d != e))'\'' -a 1,0,2,2,0
0
$ test-expr '\''(a && b) >= (c || (d != e))'\'' -a 1,0,2,2,2
0
$ test-expr '\''(a && b) >= (c || (d != e))'\'' -a 1,1,0,2,2
1
$ test-expr '\''(a && b) >= (c || (d != e))'\'' -a 1,1,1,0,0
1
$ test-expr '\''(a && b) >= (c || (d != e))'\'' -a 1,1,1,1,1
1
$ test-expr '\''(a && b) >= (c || (d != e))'\'' -a 1,1,2,2,1
1
$ test-expr '\''(a && b) >= (c || (d != e))'\'' -a 1,2,1,0,0
1
$ test-expr '\''(a && b) >= (c || (d != e))'\'' -a 1,2,1,2,1
1
$ test-expr '\''(a && b) >= (c || (d != e))'\'' -a 2,0,1,0,0
0
$ test-expr '\''(a && b) >= (c || (d != e))'\'' -a 2,0,1,2,2
0
$ test-expr '\''(a && b) >= (c || (d != e))'\'' -a 2,0,2,0,0
0
$ test-expr '\''(a && b) >= (c || (d != e))'\'' -a 2,1,0,2,2
1
$ test-expr '\''(a && b) >= (c || (d != e))'\'' -a 2,1,1,0,2
1
$ test-expr '\''(a && b) >= (c || (d != e))'\'' -a 2,1,2,2,1
1
$ test-expr '\''(a && b) >= (c || (d != e))'\'' -a 2,2,1,2,0
1
$ test-expr '\''(a && b) >= (c || (d != e))'\'' -a 2,2,1,2,1
1
$ test-expr '\''(a && b) >= (c || (d != e))'\'' -a 2,2,2,0,1
1
$ test-expr '\''(a && b) >= (c || (d != e))'\'' -a 2,2,2,0,2
1
$ test-expr '\''(a && b) >= ((c != d) || e)'\'' -a 0,0,0,0,0
1
$ test-expr '\''(a && b) >= ((c != d) || e)'\'' -a 0,0,1,0,2
0
$ test-expr '\''(a && b) >= ((c != d) || e)'\'' -a 0,1,0,1,0
0
$ test-expr '\''(a && b) >= ((c != d) || e)'\'' -a 0,1,0,2,2
0
$ test-expr '\''(a && b) >= ((c != d) || e)'\'' -a 0,1,1,0,2
0
$ test-expr '\''(a && b) >= ((c != d) || e)'\'' -a 0,2,0,1,0
0
$ test-expr '\''(a && b) >= ((c != d) || e)'\'' -a 1,0,0,2,0
0
$ test-expr '\''(a && b) >= ((c != d) || e)'\'' -a 1,0,1,0,1
0
$ test-expr '\''(a && b) >= ((c != d) || e)'\'' -a 1,0,1,2,1
0
$ test-expr '\''(a && b) >= ((c != d) || e)'\'' -a 1,0,1,2,2
0
$ test-expr '\''(a && b) >= ((c != d) || e)'\'' -a 1,0,2,1,1
0
$ test-expr '\''(a && b) >= ((c != d) || e)'\'' -a 1,0,2,1,2
0
$ test-expr '\''(a && b) >= ((c != d) || e)'\'' -a 1,1,0,2,1
1
$ test-expr '\''(a && b) >= ((c != d) || e)'\'' -a 1,2,0,0,0
1
$ test-expr '\''(a && b) >= ((c != d) || e)'\'' -a 1,2,0,1,1
1
$ test-expr '\''(a && b) >= ((c != d) || e)'\'' -a 1,2,1,1,1
1
$ test-expr '\''(a && b) >= ((c != d) || e)'\'' -a 1,2,2,1,1
1
$ test-expr '\''(a && b) >= ((c != d) || e)'\'' -a 2,0,0,0,0
1
$ test-expr '\''(a && b) >= ((c != d) || e)'\'' -a 2,0,1,2,2
0
$ test-expr '\''(a && b) >= ((c != d) || e)'\'' -a 2,0,2,2,2
0
$ test-expr '\''(a && b) >= ((c != d) || e)'\'' -a 2,1,0,0,2
1
$ test-expr '\''(a && b) >= ((c != d) || e)'\'' -a 2,1,0,1,0
1
$ test-expr '\''(a && b) >= ((c != d) || e)'\'' -a 2,2,0,1,0
1
$ test-expr '\''(a && b) >= ((c != d) || e)'\'' -a 2,2,0,2,1
1
$ test-expr '\''(a && b) >= ((c != d) || e)'\'' -a 2,2,1,1,2
1
$ test-expr '\''(a && b) >= ((c != d) || e)'\'' -a 2,2,2,1,0
1
$ test-expr '\''(a && b) >= ((c != d) || e)'\'' -a 2,2,2,2,1
1
$ test-expr '\''(a && b) >= ((c || d) != e)'\'' -a 0,0,0,0,1
0
$ test-expr '\''(a && b) >= ((c || d) != e)'\'' -a 0,1,0,1,0
0
$ test-expr '\''(a && b) >= ((c || d) != e)'\'' -a 0,1,0,2,0
0
$ test-expr '\''(a && b) >= ((c || d) != e)'\'' -a 0,1,1,0,1
1
$ test-expr '\''(a && b) >= ((c || d) != e)'\'' -a 0,1,1,0,2
0
$ test-expr '\''(a && b) >= ((c || d) != e)'\'' -a 0,1,2,2,0
0
$ test-expr '\''(a && b) >= ((c || d) != e)'\'' -a 0,2,1,0,1
1
$ test-expr '\''(a && b) >= ((c || d) != e)'\'' -a 0,2,2,1,1
1
$ test-expr '\''(a && b) >= ((c || d) != e)'\'' -a 0,2,2,1,2
0
$ test-expr '\''(a && b) >= ((c || d) != e)'\'' -a 1,0,1,0,2
0
$ test-expr '\''(a && b) >= ((c || d) != e)'\'' -a 1,0,1,1,1
1
$ test-expr '\''(a && b) >= ((c || d) != e)'\'' -a 1,1,0,0,0
1
$ test-expr '\''(a && b) >= ((c || d) != e)'\'' -a 1,1,0,2,1
1
$ test-expr '\''(a && b) >= ((c || d) != e)'\'' -a 1,1,0,2,2
1
$ test-expr '\''(a && b) >= ((c || d) != e)'\'' -a 1,1,1,1,0
1
$ test-expr '\''(a && b) >= ((c || d) != e)'\'' -a 1,1,1,2,1
1
$ test-expr '\''(a && b) >= ((c || d) != e)'\'' -a 1,1,2,2,1
1
$ test-expr '\''(a && b) >= ((c || d) != e)'\'' -a 1,2,0,0,0
1
$ test-expr '\''(a && b) >= ((c || d) != e)'\'' -a 1,2,0,0,1
1
$ test-expr '\''(a && b) >= ((c || d) != e)'\'' -a 1,2,0,1,2
1
$ test-expr '\''(a && b) >= ((c || d) != e)'\'' -a 1,2,1,1,0
1
$ test-expr '\''(a && b) >= ((c || d) != e)'\'' -a 2,0,1,1,0
0
$ test-expr '\''(a && b) >= ((c || d) != e)'\'' -a 2,1,1,1,1
1
$ test-expr '\''(a && b) >= ((c || d) != e)'\'' -a 2,1,1,2,2
1
$ test-expr '\''(a && b) >= ((c || d) != e)'\'' -a 2,1,2,0,0
1
$ test-expr '\''(a && b) >= ((c || d) != e)'\'' -a 2,1,2,0,1
1
$ test-expr '\''(a && b) || (c != (d >= e))'\'' -a 0,0,0,0,2
0
$ test-expr '\''(a && b) || (c != (d >= e))'\'' -a 0,0,0,2,1
1
$ test-expr '\''(a && b) || (c != (d >= e))'\'' -a 0,0,1,0,1
1
$ test-expr '\''(a && b) || (c != (d >= e))'\'' -a 0,0,1,1,1
0
$ test-expr '\''(a && b) || (c != (d >= e))'\'' -a 0,0,1,2,1
0
$ test-expr '\''(a && b) || (c != (d >= e))'\'' -a 0,0,2,0,1
1
$ test-expr '\''(a && b) || (c != (d >= e))'\'' -a 0,0,2,1,2
1
$ test-expr '\''(a && b) || (c != (d >= e))'\'' -a 0,2,1,1,2
1
$ test-expr '\''(a && b) || (c != (d >= e))'\'' -a 0,2,1,2,1
0
$ test-expr '\''(a && b) || (c != (d >= e))'\'' -a 0,2,1,2,2
0
$ test-expr '\''(a && b) || (c != (d >= e))'\'' -a 0,2,2,0,2
1
$ test-expr '\''(a && b) || (c != (d >= e))'\'' -a 0,2,2,1,2
1
$ test-expr '\''(a && b) || (c != (d >= e))'\'' -a 0,2,2,2,2
1
$ test-expr '\''(a && b) || (c != (d >= e))'\'' -a 1,0,0,0,0
1
$ test-expr '\''(a && b) || (c != (d >= e))'\'' -a 1,0,1,2,0
0
$ test-expr '\''(a && b) || (c != (d >= e))'\'' -a 1,0,1,2,2
0
$ test-expr '\''(a && b) || (c != (d >= e))'\'' -a 1,0,2,0,2
1
$ test-expr '\''(a && b) || (c != (d >= e))'\'' -a 1,0,2,2,1
1
$ test-expr '\''(a && b) || (c != (d >= e))'\'' -a 1,0,2,2,2
1
$ test-expr '\''(a && b) || (c != (d >= e))'\'' -a 1,1,0,0,0
1
$ test-expr '\''(a && b) || (c != (d >= e))'\'' -a 1,1,0,1,0
1
$ test-expr '\''(a && b) || (c != (d >= e))'\'' -a 1,1,2,2,0
1
$ test-expr '\''(a && b) || (c != (d >= e))'\'' -a 1,2,0,1,2
1
$ test-expr '\''(a && b) || (c != (d >= e))'\'' -a 2,0,0,0,1
0
$ test-expr '\''(a && b) || (c != (d >= e))'\'' -a 2,0,1,0,1
1
$ test-expr '\''(a && b) || (c != (d >= e))'\'' -a 2,0,1,2,2
0
$ test-expr '\''(a && b) || (c != (d >= e))'\'' -a 2,0,2,0,2
1
$ test-expr '\''(a && b) || (c != (d >= e))'\'' -a 2,0,2,1,1
1
$ test-expr '\''(a && b) || (c != (d >= e))'\'' -a 2,0,2,1,2
1
$ test-expr '\''(a && b) || (c != (d >= e))'\'' -a 2,1,0,0,2
1
$ test-expr '\''(a && b) || (c != (d >= e))'\'' -a 2,1,0,2,2
1
$ test-expr '\''(a && b) || (c != (d >= e))'\'' -a 2,1,1,1,0
1
$ test-expr '\''(a && b) || (c != (d >= e))'\'' -a 2,1,2,2,2
1
$ test-expr '\''(a && b) || (c != (d >= e))'\'' -a 2,2,0,1,0
1
$ test-expr '\''(a && b) || (c != (d >= e))'\'' -a 2,2,0,1,2
1
$ test-expr '\''(a && b) || (c != (d >= e))'\'' -a 2,2,1,2,2
1
$ test-expr '\''(a && b) || (c != (d >= e))'\'' -a 2,2,2,0,0
1
$ test-expr '\''(a && b) || (c != (d >= e))'\'' -a 2,2,2,1,0
1
$ test-expr '\''(a && b) || (c != (d >= e))'\'' -a 2,2,2,2,2
1
$ test-expr '\''(a && b) || (c >= (d != e))'\'' -a 0,0,1,0,0
1
$ test-expr '\''(a && b) || (c >= (d != e))'\'' -a 0,0,1,2,2
1
$ test-expr '\''(a && b) || (c >= (d != e))'\'' -a 0,0,2,2,1
1
$ test-expr '\''(a && b) || (c >= (d != e))'\'' -a 0,1,0,0,2
0
$ test-expr '\''(a && b) || (c >= (d != e))'\'' -a 0,1,1,0,1
1
$ test-expr '\''(a && b) || (c >= (d != e))'\'' -a 0,1,2,0,0
1
$ test-expr '\''(a && b) || (c >= (d != e))'\'' -a 0,1,2,0,1
1
$ test-expr '\''(a && b) || (c >= (d != e))'\'' -a 0,1,2,1,1
1
$ test-expr '\''(a && b) || (c >= (d != e))'\'' -a 0,1,2,2,1
1
$ test-expr '\''(a && b) || (c >= (d != e))'\'' -a 0,2,1,2,1
1
$ test-expr '\''(a && b) || (c >= (d != e))'\'' -a 1,0,1,2,1
1
$ test-expr '\''(a && b) || (c >= (d != e))'\'' -a 1,0,2,2,2
1
$ test-expr '\''(a && b) || (c >= (d != e))'\'' -a 1,1,0,2,0
1
$ test-expr '\''(a && b) || (c >= (d != e))'\'' -a 1,1,2,2,0
1
$ test-expr '\''(a && b) || (c >= (d != e))'\'' -a 1,2,1,1,2
1
$ test-expr '\''(a && b) || (c >= (d != e))'\'' -a 1,2,2,2,2
1
$ test-expr '\''(a && b) || (c >= (d != e))'\'' -a 2,0,1,1,0
1
$ test-expr '\''(a && b) || (c >= (d != e))'\'' -a 2,0,1,2,1
1
$ test-expr '\''(a && b) || (c >= (d != e))'\'' -a 2,0,2,2,0
1
$ test-expr '\''(a && b) || (c >= (d != e))'\'' -a 2,0,2,2,1
1
$ test-expr '\''(a && b) || (c >= (d != e))'\'' -a 2,1,0,1,1
1
$ test-expr '\''(a && b) || (c >= (d != e))'\'' -a 2,1,1,0,0
1
$ test-expr '\''(a && b) || (c >= (d != e))'\'' -a 2,2,0,1,2
1
$ test-expr '\''(a && b) || (c >= (d != e))'\'' -a 2,2,1,1,2
1
$ test-expr '\''(a && b) || (c >= (d != e))'\'' -a 2,2,1,2,0
1
$ test-expr '\''(a && b) || ((c != d) >= e)'\'' -a 0,0,0,1,1
1
$ test-expr '\''(a && b) || ((c != d) >= e)'\'' -a 0,0,1,1,0
1
$ test-expr '\''(a && b) || ((c != d) >= e)'\'' -a 0,0,1,2,1
1
$ test-expr '\''(a && b) || ((c != d) >= e)'\'' -a 0,0,2,1,0
1
$ test-expr '\''(a && b) || ((c != d) >= e)'\'' -a 0,1,0,1,0
1
$ test-expr '\''(a && b) || ((c != d) >= e)'\'' -a 0,1,1,2,1
1
$ test-expr '\''(a && b) || ((c != d) >= e)'\'' -a 0,1,2,1,0
1
$ test-expr '\''(a && b) || ((c != d) >= e)'\'' -a 0,2,1,0,0
1
$ test-expr '\''(a && b) || ((c != d) >= e)'\'' -a 0,2,1,0,1
1
$ test-expr '\''(a && b) || ((c != d) >= e)'\'' -a 1,0,0,1,2
0
$ test-expr '\''(a && b) || ((c != d) >= e)'\'' -a 1,0,0,2,1
1
$ test-expr '\''(a && b) || ((c != d) >= e)'\'' -a 1,0,1,1,0
1
$ test-expr '\''(a && b) || ((c != d) >= e)'\'' -a 1,0,1,2,0
1
$ test-expr '\''(a && b) || ((c != d) >= e)'\'' -a 1,1,0,1,2
1
$ test-expr '\''(a && b) || ((c != d) >= e)'\'' -a 1,1,1,0,0
1
$ test-expr '\''(a && b) || ((c != d) >= e)'\'' -a 1,1,2,0,1
1
$ test-expr '\''(a && b) || ((c != d) >= e)'\'' -a 1,1,2,1,1
1
$ test-expr '\''(a && b) || ((c != d) >= e)'\'' -a 1,2,0,1,0
1
$ test-expr '\''(a && b) || ((c != d) >= e)'\'' -a 1,2,1,1,1
1
$ test-expr '\''(a && b) || ((c != d) >= e)'\'' -a 1,2,1,2,1
1
$ test-expr '\''(a && b) || ((c != d) >= e)'\'' -a 1,2,2,1,1
1
$ test-expr '\''(a && b) || ((c != d) >= e)'\'' -a 2,0,0,0,0
1
$ test-expr '\''(a && b) || ((c != d) >= e)'\'' -a 2,0,2,2,0
1
$ test-expr '\''(a && b) || ((c != d) >= e)'\'' -a 2,0,2,2,2
0
$ test-expr '\''(a && b) || ((c != d) >= e)'\'' -a 2,1,0,0,2
1
$ test-expr '\''(a && b) || ((c != d) >= e)'\'' -a 2,1,2,0,1
1
$ test-expr '\''(a && b) || ((c != d) >= e)'\'' -a 2,2,1,1,2
1
$ test-expr '\''(a && b) || ((c != d) >= e)'\'' -a 2,2,2,2,0
1
$ test-expr '\''(a && b) || ((c >= d) != e)'\'' -a 0,0,0,2,2
1
$ test-expr '\''(a && b) || ((c >= d) != e)'\'' -a 0,0,1,2,0
0
$ test-expr '\''(a && b) || ((c >= d) != e)'\'' -a 0,1,2,0,0
1
$ test-expr '\''(a && b) || ((c >= d) != e)'\'' -a 0,1,2,2,0
1
$ test-expr '\''(a && b) || ((c >= d) != e)'\'' -a 0,2,2,0,1
0
$ test-expr '\''(a && b) || ((c >= d) != e)'\'' -a 0,2,2,1,0
1
$ test-expr '\''(a && b) || ((c >= d) != e)'\'' -a 1,0,1,1,0
1
$ test-expr '\''(a && b) || ((c >= d) != e)'\'' -a 1,0,1,2,2
1
$ test-expr '\''(a && b) || ((c >= d) != e)'\'' -a 1,0,2,0,2
1
$ test-expr '\''(a && b) || ((c >= d) != e)'\'' -a 1,1,1,0,2
1
$ test-expr '\''(a && b) || ((c >= d) != e)'\'' -a 1,1,2,0,0
1
$ test-expr '\''(a && b) || ((c >= d) != e)'\'' -a 1,1,2,1,0
1
$ test-expr '\''(a && b) || ((c >= d) != e)'\'' -a 1,1,2,1,1
1
$ test-expr '\''(a && b) || ((c >= d) != e)'\'' -a 1,2,1,0,1
1
$ test-expr '\''(a && b) || ((c >= d) != e)'\'' -a 1,2,1,1,1
1
$ test-expr '\''(a && b) || ((c >= d) != e)'\'' -a 2,0,0,1,0
0
$ test-expr '\''(a && b) || ((c >= d) != e)'\'' -a 2,0,2,0,2
1
$ test-expr '\''(a && b) || ((c >= d) != e)'\'' -a 2,0,2,1,0
1
$ test-expr '\''(a && b) || ((c >= d) != e)'\'' -a 2,0,2,2,0
1
$ test-expr '\''(a && b) || ((c >= d) != e)'\'' -a 2,1,0,1,1
1
$ test-expr '\''(a && b) || ((c >= d) != e)'\'' -a 2,1,0,2,2
1
$ test-expr '\''(a && b) || ((c >= d) != e)'\'' -a 2,1,2,2,1
1
$ test-expr '\''(a && b) || ((c >= d) != e)'\'' -a 2,1,2,2,2
1
$ test-expr '\''(a && b) || ((c >= d) != e)'\'' -a 2,2,0,2,2
1
$ test-expr '\''(a && b) || ((c >= d) != e)'\'' -a 2,2,1,0,1
1
$ test-expr '\''(a && b) || ((c >= d) != e)'\'' -a 2,2,1,2,0
1
$ test-expr '\''(a && b) || ((c >= d) != e)'\'' -a 2,2,1,2,1
1
$ test-expr '\''(a && (b != c)) >= (d || e)'\'' -a 0,0,0,2,0
0
$ test-expr '\''(a && (b != c)) >= (d || e)'\'' -a 0,0,1,0,0
1
$ test-expr '\''(a && (b != c)) >= (d || e)'\'' -a 0,0,1,2,1
0
$ test-expr '\''(a && (b != c)) >= (d || e)'\'' -a 0,1,0,1,0
0
$ test-expr '\''(a && (b != c)) >= (d || e)'\'' -a 0,1,1,0,2
0
$ test-expr '\''(a && (b != c)) >= (d || e)'\'' -a 0,1,1,2,0
0
$ test-expr '\''(a && (b != c)) >= (d || e)'\'' -a 0,1,1,2,1
0
$ test-expr '\''(a && (b != c)) >= (d || e)'\'' -a 0,1,2,2,0
0
$ test-expr '\''(a && (b != c)) >= (d || e)'\'' -a 0,2,0,1,1
0
$ test-expr '\''(a && (b != c)) >= (d || e)'\'' -a 0,2,1,0,0
1
$ test-expr '\''(a && (b != c)) >= (d || e)'\'' -a 0,2,1,1,0
0
$ test-expr '\''(a && (b != c)) >= (d || e)'\'' -a 1,0,1,1,1
1
$ test-expr '\''(a && (b != c)) >= (d || e)'\'' -a 1,0,2,0,1
1
$ test-expr '\''(a && (b != c)) >= (d || e)'\'' -a 1,0,2,2,2
1
$ test-expr '\''(a && (b != c)) >= (d || e)'\'' -a 1,1,0,0,0
1
$ test-expr '\''(a && (b != c)) >= (d || e)'\'' -a 1,1,0,0,1
1
$ test-expr '\''(a && (b != c)) >= (d || e)'\'' -a 1,1,0,1,2
1
$ test-expr '\''(a && (b != c)) >= (d || e)'\'' -a 1,1,0,2,1
1
$ test-expr '\''(a && (b != c)) >= (d || e)'\'' -a 1,1,1,2,0
0
$ test-expr '\''(a && (b != c)) >= (d || e)'\'' -a 1,1,2,1,1
1
$ test-expr '\''(a && (b != c)) >= (d || e)'\'' -a 1,2,0,2,0
1
$ test-expr '\''(a && (b != c)) >= (d || e)'\'' -a 1,2,2,1,2
0
$ test-expr '\''(a && (b != c)) >= (d || e)'\'' -a 1,2,2,2,1
0
$ test-expr '\''(a && (b != c)) >= (d || e)'\'' -a 2,0,0,2,1
0
$ test-expr '\''(a && (b != c)) >= (d || e)'\'' -a 2,0,2,2,2
1
$ test-expr '\''(a && (b != c)) >= (d || e)'\'' -a 2,1,0,1,0
1
$ test-expr '\''(a && (b != c)) >= (d || e)'\'' -a 2,1,1,1,2
0
$ test-expr '\''(a && (b != c)) >= (d || e)'\'' -a 2,1,1,2,0
0
$ test-expr '\''(a && (b != c)) >= (d || e)'\'' -a 2,2,1,1,1
1
$ test-expr '\''(a && (b != c)) >= (d || e)'\'' -a 2,2,2,0,2
0
$ test-expr '\''(a && (b != c)) >= (d || e)'\'' -a 2,2,2,1,1
0
$ test-expr '\''(a && (b != c)) || (d >= e)'\'' -a 0,0,1,2,0
1
$ test-expr '\''(a && (b != c)) || (d >= e)'\'' -a 0,1,0,1,2
0
$ test-expr '\''(a && (b != c)) || (d >= e)'\'' -a 0,1,1,0,0
1
$ test-expr '\''(a && (b != c)) || (d >= e)'\'' -a 0,1,1,0,2
0
$ test-expr '\''(a && (b != c)) || (d >= e)'\'' -a 0,1,1,2,1
1
$ test-expr '\''(a && (b != c)) || (d >= e)'\'' -a 0,1,2,0,1
0
$ test-expr '\''(a && (b != c)) || (d >= e)'\'' -a 0,1,2,0,2
0
$ test-expr '\''(a && (b != c)) || (d >= e)'\'' -a 0,1,2,1,1
1
$ test-expr '\''(a && (b != c)) || (d >= e)'\'' -a 0,2,0,0,1
0
$ test-expr '\''(a && (b != c)) || (d >= e)'\'' -a 0,2,2,1,0
1
$ test-expr '\''(a && (b != c)) || (d >= e)'\'' -a 1,0,2,2,0
1
$ test-expr '\''(a && (b != c)) || (d >= e)'\'' -a 1,1,0,1,2
1
$ test-expr '\''(a && (b != c)) || (d >= e)'\'' -a 1,2,1,2,0
1
$ test-expr '\''(a && (b != c)) || (d >= e)'\'' -a 1,2,1,2,2
1
$ test-expr '\''(a && (b != c)) || (d >= e)'\'' -a 1,2,2,1,2
0
$ test-expr '\''(a && (b != c)) || (d >= e)'\'' -a 2,0,1,0,1
1
$ test-expr '\''(a && (b != c)) || (d >= e)'\'' -a 2,0,1,2,2
1
$ test-expr '\''(a && (b != c)) || (d >= e)'\'' -a 2,0,2,0,0
1
$ test-expr '\''(a && (b != c)) || (d >= e)'\'' -a 2,0,2,1,2
1
$ test-expr '\''(a && (b != c)) || (d >= e)'\'' -a 2,1,2,2,1
1
$ test-expr '\''(a && (b != c)) || (d >= e)'\'' -a 2,2,0,1,2
1
$ test-expr '\''(a && (b != c)) || (d >= e)'\'' -a 2,2,0,2,2
1
$ test-expr '\''(a && (b != c)) || (d >= e)'\'' -a 2,2,1,1,0
1
$ test-expr '\''(a && (b != c)) || (d >= e)'\'' -a 2,2,1,1,1
1
$ test-expr '\''(a && (b != c)) || (d >= e)'\'' -a 2,2,2,0,2
0
$ test-expr '\''(a && (b != c)) || (d >= e)'\'' -a 2,2,2,1,1
1
$ test-expr '\''(a && (b != c)) || (d >= e)'\'' -a 2,2,2,2,2
1
$ test-expr '\''(a && (b != (c >= d))) || e'\'' -a 0,1,0,2,1
1
$ test-expr '\''(a && (b != (c >= d))) || e'\'' -a 0,1,2,0,1
1
$ test-expr '\''(a && (b != (c >= d))) || e'\'' -a 0,1,2,0,2
1
$ test-expr '\''(a && (b != (c >= d))) || e'\'' -a 0,2,0,2,0
0
$ test-expr '\''(a && (b != (c >= d))) || e'\'' -a 0,2,0,2,1
1
$ test-expr '\''(a && (b != (c >= d))) || e'\'' -a 0,2,1,0,0
0
$ test-expr '\''(a && (b != (c >= d))) || e'\'' -a 0,2,2,2,2
1
$ test-expr '\''(a && (b != (c >= d))) || e'\'' -a 1,0,0,1,2
1
$ test-expr '\''(a && (b != (c >= d))) || e'\'' -a 1,0,1,1,1
1
$ test-expr '\''(a && (b != (c >= d))) || e'\'' -a 1,0,2,0,0
1
$ test-expr '\''(a && (b != (c >= d))) || e'\'' -a 1,0,2,1,0
1
$ test-expr '\''(a && (b != (c >= d))) || e'\'' -a 1,1,0,0,2
1
$ test-expr '\''(a && (b != (c >= d))) || e'\'' -a 1,1,0,1,1
1
$ test-expr '\''(a && (b != (c >= d))) || e'\'' -a 1,1,0,2,1
1
$ test-expr '\''(a && (b != (c >= d))) || e'\'' -a 1,1,2,2,2
1
$ test-expr '\''(a && (b != (c >= d))) || e'\'' -a 1,2,0,1,1
1
$ test-expr '\''(a && (b != (c >= d))) || e'\'' -a 1,2,1,0,2
1
$ test-expr '\''(a && (b != (c >= d))) || e'\'' -a 2,0,0,1,1
1
$ test-expr '\''(a && (b != (c >= d))) || e'\'' -a 2,0,0,2,1
1
$ test-expr '\''(a && (b != (c >= d))) || e'\'' -a 2,0,2,1,1
1
$ test-expr '\''(a && (b != (c >= d))) || e'\'' -a 2,1,0,0,0
0
$ test-expr '\''(a && (b != (c >= d))) || e'\'' -a 2,1,0,2,1
1
$ test-expr '\''(a && (b != (c >= d))) || e'\'' -a 2,1,1,0,0
0
$ test-expr '\''(a && (b != (c >= d))) || e'\'' -a 2,2,0,2,1
1
$ test-expr '\''(a && (b != (c >= d))) || e'\'' -a 2,2,1,2,1
1
$ test-expr '\''(a && (b != (c >= d))) || e'\'' -a 2,2,2,1,0
1
$ test-expr '\''(a && (b != (c || d))) >= e'\'' -a 0,0,0,0,0
1
$ test-expr '\''(a && (b != (c || d))) >= e'\'' -a 0,0,2,0,2
0
$ test-expr '\''(a && (b != (c || d))) >= e'\'' -a 0,0,2,2,2
0
$ test-expr '\''(a && (b != (c || d))) >= e'\'' -a 0,1,0,0,1
0
$ test-expr '\''(a && (b != (c || d))) >= e'\'' -a 0,1,0,0,2
0
$ test-expr '\''(a && (b != (c || d))) >= e'\'' -a 0,1,0,2,1
0
$ test-expr '\''(a && (b != (c || d))) >= e'\'' -a 0,1,1,2,2
0
$ test-expr '\''(a && (b != (c || d))) >= e'\'' -a 0,1,2,0,0
1
$ test-expr '\''(a && (b != (c || d))) >= e'\'' -a 0,1,2,0,1
0
$ test-expr '\''(a && (b != (c || d))) >= e'\'' -a 0,1,2,0,2
0
$ test-expr '\''(a && (b != (c || d))) >= e'\'' -a 0,1,2,1,0
1
$ test-expr '\''(a && (b != (c || d))) >= e'\'' -a 0,2,0,0,0
1
$ test-expr '\''(a && (b != (c || d))) >= e'\'' -a 0,2,1,0,1
0
$ test-expr '\''(a && (b != (c || d))) >= e'\'' -a 1,0,0,0,1
0
$ test-expr '\''(a && (b != (c || d))) >= e'\'' -a 1,0,0,2,2
0
$ test-expr '\''(a && (b != (c || d))) >= e'\'' -a 1,1,1,0,1
0
$ test-expr '\''(a && (b != (c || d))) >= e'\'' -a 1,1,2,2,0
1
$ test-expr '\''(a && (b != (c || d))) >= e'\'' -a 1,2,0,0,2
0
$ test-expr '\''(a && (b != (c || d))) >= e'\'' -a 1,2,1,1,2
0
$ test-expr '\''(a && (b != (c || d))) >= e'\'' -a 2,0,0,1,0
1
$ test-expr '\''(a && (b != (c || d))) >= e'\'' -a 2,0,1,0,2
0
$ test-expr '\''(a && (b != (c || d))) >= e'\'' -a 2,0,1,1,1
1
$ test-expr '\''(a && (b != (c || d))) >= e'\'' -a 2,0,1,2,2
0
$ test-expr '\''(a && (b != (c || d))) >= e'\'' -a 2,1,1,0,0
1
$ test-expr '\''(a && (b != (c || d))) >= e'\'' -a 2,1,2,0,1
0
$ test-expr '\''(a && (b != (c || d))) >= e'\'' -a 2,2,0,0,2
0
$ test-expr '\''(a && (b != (c || d))) >= e'\'' -a 2,2,0,2,0
1
$ test-expr '\''(a && (b != (c || d))) >= e'\'' -a 2,2,1,1,0
1
$ test-expr '\''(a && (b != (c || d))) >= e'\'' -a 2,2,1,1,2
0
$ test-expr '\''(a && (b != (c || d))) >= e'\'' -a 2,2,1,2,0
1
$ test-expr '\''(a && (b != (c || d))) >= e'\'' -a 2,2,1,2,2
0
$ test-expr '\''(a && (b != (c || d))) >= e'\'' -a 2,2,2,1,0
1
$ test-expr '\''(a && (b >= c)) != (d || e)'\'' -a 0,0,0,0,1
1
$ test-expr '\''(a && (b >= c)) != (d || e)'\'' -a 0,0,0,1,2
1
$ test-expr '\''(a && (b >= c)) != (d || e)'\'' -a 0,0,0,2,2
1
$ test-expr '\''(a && (b >= c)) != (d || e)'\'' -a 0,0,1,0,0
0
$ test-expr '\''(a && (b >= c)) != (d || e)'\'' -a 0,0,2,0,2
1
$ test-expr '\''(a && (b >= c)) != (d || e)'\'' -a 0,0,2,1,0
1
$ test-expr '\''(a && (b >= c)) != (d || e)'\'' -a 0,1,0,1,2
1
$ test-expr '\''(a && (b >= c)) != (d || e)'\'' -a 0,1,1,0,0
0
$ test-expr '\''(a && (b >= c)) != (d || e)'\'' -a 0,1,2,2,1
1
$ test-expr '\''(a && (b >= c)) != (d || e)'\'' -a 0,1,2,2,2
1
$ test-expr '\''(a && (b >= c)) != (d || e)'\'' -a 0,2,0,2,1
1
$ test-expr '\''(a && (b >= c)) != (d || e)'\'' -a 0,2,1,0,0
0
$ test-expr '\''(a && (b >= c)) != (d || e)'\'' -a 0,2,1,1,1
1
$ test-expr '\''(a && (b >= c)) != (d || e)'\'' -a 1,0,2,0,2
1
$ test-expr '\''(a && (b >= c)) != (d || e)'\'' -a 1,0,2,2,1
1
$ test-expr '\''(a && (b >= c)) != (d || e)'\'' -a 1,1,0,1,0
0
$ test-expr '\''(a && (b >= c)) != (d || e)'\'' -a 1,1,1,0,0
1
$ test-expr '\''(a && (b >= c)) != (d || e)'\'' -a 1,1,1,1,0
0
$ test-expr '\''(a && (b >= c)) != (d || e)'\'' -a 1,1,2,2,1
1
$ test-expr '\''(a && (b >= c)) != (d || e)'\'' -a 1,2,0,0,2
0
$ test-expr '\''(a && (b >= c)) != (d || e)'\'' -a 1,2,0,1,0
0
$ test-expr '\''(a && (b >= c)) != (d || e)'\'' -a 1,2,0,1,1
0
$ test-expr '\''(a && (b >= c)) != (d || e)'\'' -a 2,1,0,0,1
0
$ test-expr '\''(a && (b >= c)) != (d || e)'\'' -a 2,1,0,2,2
0
$ test-expr '\''(a && (b >= c)) != (d || e)'\'' -a 2,2,1,1,2
0
$ test-expr '\''(a && (b >= c)) != (d || e)'\'' -a 2,2,2,0,1
0
$ test-expr '\''(a && (b >= c)) || (d != e)'\'' -a 0,0,1,0,1
1
$ test-expr '\''(a && (b >= c)) || (d != e)'\'' -a 0,0,2,0,1
1
$ test-expr '\''(a && (b >= c)) || (d != e)'\'' -a 0,0,2,1,2
1
$ test-expr '\''(a && (b >= c)) || (d != e)'\'' -a 0,0,2,2,0
1
$ test-expr '\''(a && (b >= c)) || (d != e)'\'' -a 0,1,0,2,0
1
$ test-expr '\''(a && (b >= c)) || (d != e)'\'' -a 0,1,1,1,1
0
$ test-expr '\''(a && (b >= c)) || (d != e)'\'' -a 0,1,2,0,2
1
$ test-expr '\''(a && (b >= c)) || (d != e)'\'' -a 0,1,2,2,0
1
$ test-expr '\''(a && (b >= c)) || (d != e)'\'' -a 0,1,2,2,2
0
$ test-expr '\''(a && (b >= c)) || (d != e)'\'' -a 0,2,0,1,2
1
$ test-expr '\''(a && (b >= c)) || (d != e)'\'' -a 0,2,2,1,0
1
$ test-expr '\''(a && (b >= c)) || (d != e)'\'' -a 1,0,1,0,2
1
$ test-expr '\''(a && (b >= c)) || (d != e)'\'' -a 1,0,1,2,1
1
$ test-expr '\''(a && (b >= c)) || (d != e)'\'' -a 1,0,2,0,0
0
$ test-expr '\''(a && (b >= c)) || (d != e)'\'' -a 1,0,2,2,2
0
$ test-expr '\''(a && (b >= c)) || (d != e)'\'' -a 1,1,0,2,1
1
$ test-expr '\''(a && (b >= c)) || (d != e)'\'' -a 1,1,1,0,2
1
$ test-expr '\''(a && (b >= c)) || (d != e)'\'' -a 1,1,1,1,1
1
$ test-expr '\''(a && (b >= c)) || (d != e)'\'' -a 1,1,2,2,0
1
$ test-expr '\''(a && (b >= c)) || (d != e)'\'' -a 1,1,2,2,2
0
$ test-expr '\''(a && (b >= c)) || (d != e)'\'' -a 1,2,0,0,1
1
$ test-expr '\''(a && (b >= c)) || (d != e)'\'' -a 1,2,0,1,0
1
$ test-expr '\''(a && (b >= c)) || (d != e)'\'' -a 1,2,0,1,1
1
$ test-expr '\''(a && (b >= c)) || (d != e)'\'' -a 1,2,1,0,2
1
$ test-expr '\''(a && (b >= c)) || (d != e)'\'' -a 1,2,1,2,0
1
$ test-expr '\''(a && (b >= c)) || (d != e)'\'' -a 1,2,2,0,1
1
$ test-expr '\''(a && (b >= c)) || (d != e)'\'' -a 1,2,2,1,0
1
$ test-expr '\''(a && (b >= c)) || (d != e)'\'' -a 2,0,0,0,0
1
$ test-expr '\''(a && (b >= c)) || (d != e)'\'' -a 2,0,1,1,1
0
$ test-expr '\''(a && (b >= c)) || (d != e)'\'' -a 2,0,1,2,1
1
$ test-expr '\''(a && (b >= c)) || (d != e)'\'' -a 2,0,1,2,2
0
$ test-expr '\''(a && (b >= c)) || (d != e)'\'' -a 2,0,2,1,0
1
$ test-expr '\''(a && (b >= c)) || (d != e)'\'' -a 2,0,2,2,0
1
$ test-expr '\''(a && (b >= c)) || (d != e)'\'' -a 2,1,2,0,0
0
$ test-expr '\''(a && (b >= c)) || (d != e)'\'' -a 2,1,2,0,1
1
$ test-expr '\''(a && (b >= c)) || (d != e)'\'' -a 2,1,2,1,1
0
$ test-expr '\''(a && (b >= c)) || (d != e)'\'' -a 2,2,1,0,2
1
$ test-expr '\''(a && (b >= c)) || (d != e)'\'' -a 2,2,2,0,2
1
$ test-expr '\''(a && (b >= c)) || (d != e)'\'' -a 2,2,2,1,0
1
$ test-expr '\''(a && (b >= (c != d))) || e'\'' -a 0,0,0,1,1
1
$ test-expr '\''(a && (b >= (c != d))) || e'\'' -a 0,0,1,0,0
0
$ test-expr '\''(a && (b >= (c != d))) || e'\'' -a 0,0,2,1,1
1
$ test-expr '\''(a && (b >= (c != d))) || e'\'' -a 0,1,0,0,1
1
$ test-expr '\''(a && (b >= (c != d))) || e'\'' -a 0,1,0,1,0
0
$ test-expr '\''(a && (b >= (c != d))) || e'\'' -a 0,1,0,1,1
1
$ test-expr '\''(a && (b >= (c != d))) || e'\'' -a 0,1,2,2,0
0
$ test-expr '\''(a && (b >= (c != d))) || e'\'' -a 0,2,0,1,1
1
$ test-expr '\''(a && (b >= (c != d))) || e'\'' -a 0,2,2,0,2
1
$ test-expr '\''(a && (b >= (c != d))) || e'\'' -a 1,0,0,0,1
1
$ test-expr '\''(a && (b >= (c != d))) || e'\'' -a 1,0,0,0,2
1
$ test-expr '\''(a && (b >= (c != d))) || e'\'' -a 1,0,1,0,0
0
$ test-expr '\''(a && (b >= (c != d))) || e'\'' -a 1,0,1,0,2
1
$ test-expr '\''(a && (b >= (c != d))) || e'\'' -a 1,0,1,1,0
1
$ test-expr '\''(a && (b >= (c != d))) || e'\'' -a 1,0,2,0,0
0
$ test-expr '\''(a && (b >= (c != d))) || e'\'' -a 1,0,2,2,1
1
$ test-expr '\''(a && (b >= (c != d))) || e'\'' -a 1,0,2,2,2
1
$ test-expr '\''(a && (b >= (c != d))) || e'\'' -a 1,1,0,2,2
1
$ test-expr '\''(a && (b >= (c != d))) || e'\'' -a 1,1,1,1,1
1
$ test-expr '\''(a && (b >= (c != d))) || e'\'' -a 1,1,1,2,0
1
$ test-expr '\''(a && (b >= (c != d))) || e'\'' -a 1,1,2,0,0
1
$ test-expr '\''(a && (b >= (c != d))) || e'\'' -a 1,2,0,1,2
1
$ test-expr '\''(a && (b >= (c != d))) || e'\'' -a 2,0,0,0,0
1
$ test-expr '\''(a && (b >= (c != d))) || e'\'' -a 2,0,0,1,0
0
$ test-expr '\''(a && (b >= (c != d))) || e'\'' -a 2,0,1,0,1
1
$ test-expr '\''(a && (b >= (c != d))) || e'\'' -a 2,0,2,0,0
0
$ test-expr '\''(a && (b >= (c != d))) || e'\'' -a 2,1,0,2,0
1
$ test-expr '\''(a && (b >= (c != d))) || e'\'' -a 2,1,1,0,2
1
$ test-expr '\''(a && (b >= (c != d))) || e'\'' -a 2,1,1,1,0
1
$ test-expr '\''(a && (b >= (c != d))) || e'\'' -a 2,1,1,2,1
1
$ test-expr '\''(a && (b >= (c != d))) || e'\'' -a 2,1,2,2,2
1
$ test-expr '\''(a && (b >= (c != d))) || e'\'' -a 2,2,0,0,2
1
$ test-expr '\''(a && (b >= (c != d))) || e'\'' -a 2,2,0,1,0
1
$ test-expr '\''(a && (b >= (c != d))) || e'\'' -a 2,2,0,2,1
1
$ test-expr '\''(a && (b >= (c != d))) || e'\'' -a 2,2,2,1,1
1
$ test-expr '\''(a && (b >= (c != d))) || e'\'' -a 2,2,2,2,2
1
$ test-expr '\''(a && (b >= (c || d))) != e'\'' -a 0,0,0,0,1
1
$ test-expr '\''(a && (b >= (c || d))) != e'\'' -a 0,0,1,1,0
0
$ test-expr '\''(a && (b >= (c || d))) != e'\'' -a 0,0,1,1,1
1
$ test-expr '\''(a && (b >= (c || d))) != e'\'' -a 0,1,2,0,1
1
$ test-expr '\''(a && (b >= (c || d))) != e'\'' -a 0,1,2,1,0
0
$ test-expr '\''(a && (b >= (c || d))) != e'\'' -a 0,1,2,1,1
1
$ test-expr '\''(a && (b >= (c || d))) != e'\'' -a 0,1,2,2,1
1
$ test-expr '\''(a && (b >= (c || d))) != e'\'' -a 0,2,0,1,0
0
$ test-expr '\''(a && (b >= (c || d))) != e'\'' -a 0,2,0,1,1
1
$ test-expr '\''(a && (b >= (c || d))) != e'\'' -a 0,2,0,2,0
0
$ test-expr '\''(a && (b >= (c || d))) != e'\'' -a 1,1,0,2,1
0
$ test-expr '\''(a && (b >= (c || d))) != e'\'' -a 1,2,1,0,2
1
$ test-expr '\''(a && (b >= (c || d))) != e'\'' -a 1,2,1,2,0
1
$ test-expr '\''(a && (b >= (c || d))) != e'\'' -a 1,2,2,0,1
0
$ test-expr '\''(a && (b >= (c || d))) != e'\'' -a 1,2,2,2,0
1
$ test-expr '\''(a && (b >= (c || d))) != e'\'' -a 2,0,1,0,1
1
$ test-expr '\''(a && (b >= (c || d))) != e'\'' -a 2,0,1,1,0
0
$ test-expr '\''(a && (b >= (c || d))) != e'\'' -a 2,0,1,2,2
1
$ test-expr '\''(a && (b >= (c || d))) != e'\'' -a 2,0,2,0,1
1
$ test-expr '\''(a && (b >= (c || d))) != e'\'' -a 2,1,0,1,2
1
$ test-expr '\''(a && (b >= (c || d))) != e'\'' -a 2,1,0,2,1
0
$ test-expr '\''(a && (b >= (c || d))) != e'\'' -a 2,1,1,2,2
1
$ test-expr '\''(a && (b >= (c || d))) != e'\'' -a 2,2,1,1,2
1
$ test-expr '\''(a && (b >= (c || d))) != e'\'' -a 2,2,1,2,2
1
$ test-expr '\''(a && (b >= (c || d))) != e'\'' -a 2,2,2,0,1
0
$ test-expr '\''(a && (b >= (c || d))) != e'\'' -a 2,2,2,0,2
1
$ test-expr '\''(a && (b >= (c || d))) != e'\'' -a 2,2,2,2,0
1
$ test-expr '\''(a && (b || c)) != (d >= e)'\'' -a 0,0,0,1,1
1
$ test-expr '\''(a && (b || c)) != (d >= e)'\'' -a 0,0,1,2,2
1
$ test-expr '\''(a && (b || c)) != (d >= e)'\'' -a 0,1,0,0,2
0
$ test-expr '\''(a && (b || c)) != (d >= e)'\'' -a 0,1,1,0,0
1
$ test-expr '\''(a && (b || c)) != (d >= e)'\'' -a 0,1,1,1,2
0
$ test-expr '\''(a && (b || c)) != (d >= e)'\'' -a 0,1,1,2,1
1
$ test-expr '\''(a && (b || c)) != (d >= e)'\'' -a 0,1,2,0,0
1
$ test-expr '\''(a && (b || c)) != (d >= e)'\'' -a 0,2,0,0,1
0
$ test-expr '\''(a && (b || c)) != (d >= e)'\'' -a 0,2,0,2,0
1
$ test-expr '\''(a && (b || c)) != (d >= e)'\'' -a 0,2,1,0,0
1
$ test-expr '\''(a && (b || c)) != (d >= e)'\'' -a 0,2,2,1,0
1
$ test-expr '\''(a && (b || c)) != (d >= e)'\'' -a 0,2,2,2,0
1
$ test-expr '\''(a && (b || c)) != (d >= e)'\'' -a 0,2,2,2,2
1
$ test-expr '\''(a && (b || c)) != (d >= e)'\'' -a 1,0,0,2,0
1
$ test-expr '\''(a && (b || c)) != (d >= e)'\'' -a 1,0,1,1,0
0
$ test-expr '\''(a && (b || c)) != (d >= e)'\'' -a 1,1,0,0,1
1
$ test-expr '\''(a && (b || c)) != (d >= e)'\'' -a 1,1,0,2,2
0
$ test-expr '\''(a && (b || c)) != (d >= e)'\'' -a 1,1,1,0,2
1
$ test-expr '\''(a && (b || c)) != (d >= e)'\'' -a 1,1,2,0,1
1
$ test-expr '\''(a && (b || c)) != (d >= e)'\'' -a 1,2,0,0,1
1
$ test-expr '\''(a && (b || c)) != (d >= e)'\'' -a 1,2,0,2,0
0
$ test-expr '\''(a && (b || c)) != (d >= e)'\'' -a 1,2,1,2,1
0
$ test-expr '\''(a && (b || c)) != (d >= e)'\'' -a 1,2,1,2,2
0
$ test-expr '\''(a && (b || c)) != (d >= e)'\'' -a 1,2,2,0,1
1
$ test-expr '\''(a && (b || c)) != (d >= e)'\'' -a 2,0,1,1,0
0
$ test-expr '\''(a && (b || c)) != (d >= e)'\'' -a 2,0,2,1,1
0
$ test-expr '\''(a && (b || c)) != (d >= e)'\'' -a 2,1,0,1,2
1
$ test-expr '\''(a && (b || c)) != (d >= e)'\'' -a 2,1,1,0,1
1
$ test-expr '\''(a && (b || c)) != (d >= e)'\'' -a 2,1,1,2,1
0
$ test-expr '\''(a && (b || c)) != (d >= e)'\'' -a 2,1,1,2,2
0
$ test-expr '\''(a && (b || c)) != (d >= e)'\'' -a 2,2,0,1,1
0
$ test-expr '\''(a && (b || c)) != (d >= e)'\'' -a 2,2,1,1,0
0
$ test-expr '\''(a && (b || c)) != (d >= e)'\'' -a 2,2,1,2,1
0
$ test-expr '\''(a && (b || c)) >= (d != e)'\'' -a 0,0,0,1,1
1
$ test-expr '\''(a && (b || c)) >= (d != e)'\'' -a 0,0,2,0,2
0
$ test-expr '\''(a && (b || c)) >= (d != e)'\'' -a 0,1,1,2,1
0
$ test-expr '\''(a && (b || c)) >= (d != e)'\'' -a 0,1,2,1,0
0
$ test-expr '\''(a && (b || c)) >= (d != e)'\'' -a 0,1,2,1,2
0
$ test-expr '\''(a && (b || c)) >= (d != e)'\'' -a 0,1,2,2,0
0
$ test-expr '\''(a && (b || c)) >= (d != e)'\'' -a 0,2,0,0,2
0
$ test-expr '\''(a && (b || c)) >= (d != e)'\'' -a 0,2,0,2,2
1
$ test-expr '\''(a && (b || c)) >= (d != e)'\'' -a 0,2,1,0,1
0
$ test-expr '\''(a && (b || c)) >= (d != e)'\'' -a 0,2,2,1,0
0
$ test-expr '\''(a && (b || c)) >= (d != e)'\'' -a 0,2,2,1,1
1
$ test-expr '\''(a && (b || c)) >= (d != e)'\'' -a 1,0,0,2,1
0
$ test-expr '\''(a && (b || c)) >= (d != e)'\'' -a 1,0,1,2,0
1
$ test-expr '\''(a && (b || c)) >= (d != e)'\'' -a 1,1,0,0,2
1
$ test-expr '\''(a && (b || c)) >= (d != e)'\'' -a 1,1,0,1,2
1
$ test-expr '\''(a && (b || c)) >= (d != e)'\'' -a 1,1,1,0,0
1
$ test-expr '\''(a && (b || c)) >= (d != e)'\'' -a 1,1,1,2,1
1
$ test-expr '\''(a && (b || c)) >= (d != e)'\'' -a 1,1,2,2,1
1
$ test-expr '\''(a && (b || c)) >= (d != e)'\'' -a 1,2,0,2,1
1
$ test-expr '\''(a && (b || c)) >= (d != e)'\'' -a 2,0,0,0,1
0
$ test-expr '\''(a && (b || c)) >= (d != e)'\'' -a 2,0,1,1,0
1
$ test-expr '\''(a && (b || c)) >= (d != e)'\'' -a 2,0,1,2,1
1
$ test-expr '\''(a && (b || c)) >= (d != e)'\'' -a 2,0,2,1,1
1
$ test-expr '\''(a && (b || c)) >= (d != e)'\'' -a 2,0,2,2,1
1
$ test-expr '\''(a && (b || c)) >= (d != e)'\'' -a 2,0,2,2,2
1
$ test-expr '\''(a && (b || c)) >= (d != e)'\'' -a 2,1,0,0,0
1
$ test-expr '\''(a && (b || c)) >= (d != e)'\'' -a 2,1,0,2,1
1
$ test-expr '\''(a && (b || c)) >= (d != e)'\'' -a 2,1,2,0,1
1
$ test-expr '\''(a && (b || c)) >= (d != e)'\'' -a 2,1,2,1,2
1
$ test-expr '\''(a && (b || c)) >= (d != e)'\'' -a 2,2,0,1,0
1
$ test-expr '\''(a && (b || (c != d))) >= e'\'' -a 0,0,0,0,0
1
$ test-expr '\''(a && (b || (c != d))) >= e'\'' -a 0,0,1,1,2
0
$ test-expr '\''(a && (b || (c != d))) >= e'\'' -a 0,0,1,2,0
1
$ test-expr '\''(a && (b || (c != d))) >= e'\'' -a 0,0,2,0,2
0
$ test-expr '\''(a && (b || (c != d))) >= e'\'' -a 0,1,0,1,0
1
$ test-expr '\''(a && (b || (c != d))) >= e'\'' -a 0,1,0,2,0
1
$ test-expr '\''(a && (b || (c != d))) >= e'\'' -a 0,1,1,0,0
1
$ test-expr '\''(a && (b || (c != d))) >= e'\'' -a 0,1,2,1,0
1
$ test-expr '\''(a && (b || (c != d))) >= e'\'' -a 0,2,0,0,2
0
$ test-expr '\''(a && (b || (c != d))) >= e'\'' -a 0,2,0,2,0
1
$ test-expr '\''(a && (b || (c != d))) >= e'\'' -a 0,2,2,2,2
0
$ test-expr '\''(a && (b || (c != d))) >= e'\'' -a 1,0,0,0,2
0
$ test-expr '\''(a && (b || (c != d))) >= e'\'' -a 1,0,2,1,0
1
$ test-expr '\''(a && (b || (c != d))) >= e'\'' -a 1,1,1,1,2
0
$ test-expr '\''(a && (b || (c != d))) >= e'\'' -a 1,1,2,2,0
1
$ test-expr '\''(a && (b || (c != d))) >= e'\'' -a 1,1,2,2,1
1
$ test-expr '\''(a && (b || (c != d))) >= e'\'' -a 1,2,0,0,0
1
$ test-expr '\''(a && (b || (c != d))) >= e'\'' -a 1,2,2,0,2
0
$ test-expr '\''(a && (b || (c != d))) >= e'\'' -a 1,2,2,1,2
0
$ test-expr '\''(a && (b || (c != d))) >= e'\'' -a 1,2,2,2,1
1
$ test-expr '\''(a && (b || (c != d))) >= e'\'' -a 2,0,0,1,2
0
$ test-expr '\''(a && (b || (c != d))) >= e'\'' -a 2,0,1,2,0
1
$ test-expr '\''(a && (b || (c != d))) >= e'\'' -a 2,0,1,2,1
1
$ test-expr '\''(a && (b || (c != d))) >= e'\'' -a 2,1,0,2,1
1
$ test-expr '\''(a && (b || (c != d))) >= e'\'' -a 2,1,2,0,1
1
$ test-expr '\''(a && (b || (c != d))) >= e'\'' -a 2,2,1,1,2
0
$ test-expr '\''(a && (b || (c != d))) >= e'\'' -a 2,2,2,1,2
0
$ test-expr '\''(a && (b || (c != d))) >= e'\'' -a 2,2,2,2,0
1
$ test-expr '\''(a && (b || (c >= d))) != e'\'' -a 0,0,0,2,0
0
$ test-expr '\''(a && (b || (c >= d))) != e'\'' -a 0,0,0,2,2
1
$ test-expr '\''(a && (b || (c >= d))) != e'\'' -a 0,0,1,1,0
0
$ test-expr '\''(a && (b || (c >= d))) != e'\'' -a 0,0,2,2,0
0
$ test-expr '\''(a && (b || (c >= d))) != e'\'' -a 0,1,0,1,1
1
$ test-expr '\''(a && (b || (c >= d))) != e'\'' -a 0,1,1,0,0
0
$ test-expr '\''(a && (b || (c >= d))) != e'\'' -a 0,1,1,0,1
1
$ test-expr '\''(a && (b || (c >= d))) != e'\'' -a 0,1,1,1,2
1
$ test-expr '\''(a && (b || (c >= d))) != e'\'' -a 0,2,0,2,0
0
$ test-expr '\''(a && (b || (c >= d))) != e'\'' -a 0,2,0,2,2
1
$ test-expr '\''(a && (b || (c >= d))) != e'\'' -a 0,2,1,2,0
0
$ test-expr '\''(a && (b || (c >= d))) != e'\'' -a 0,2,1,2,1
1
$ test-expr '\''(a && (b || (c >= d))) != e'\'' -a 0,2,1,2,2
1
$ test-expr '\''(a && (b || (c >= d))) != e'\'' -a 0,2,2,2,2
1
$ test-expr '\''(a && (b || (c >= d))) != e'\'' -a 1,0,0,2,0
0
$ test-expr '\''(a && (b || (c >= d))) != e'\'' -a 1,0,2,0,1
0
$ test-expr '\''(a && (b || (c >= d))) != e'\'' -a 1,1,0,0,0
1
$ test-expr '\''(a && (b || (c >= d))) != e'\'' -a 1,1,0,1,1
0
$ test-expr '\''(a && (b || (c >= d))) != e'\'' -a 1,1,0,2,2
1
$ test-expr '\''(a && (b || (c >= d))) != e'\'' -a 1,1,1,0,1
0
$ test-expr '\''(a && (b || (c >= d))) != e'\'' -a 1,2,2,0,1
0
$ test-expr '\''(a && (b || (c >= d))) != e'\'' -a 2,0,0,1,2
1
$ test-expr '\''(a && (b || (c >= d))) != e'\'' -a 2,0,1,0,2
1
$ test-expr '\''(a && (b || (c >= d))) != e'\'' -a 2,0,2,2,0
1
$ test-expr '\''(a && (b || (c >= d))) != e'\'' -a 2,1,0,1,1
0
$ test-expr '\''(a && (b || (c >= d))) != e'\'' -a 2,1,1,2,0
1
$ test-expr '\''(a && (b || (c >= d))) != e'\'' -a 2,1,2,2,1
0
$ test-expr '\''(a && ((b != c) >= d)) || e'\'' -a 0,0,1,0,2
1
$ test-expr '\''(a && ((b != c) >= d)) || e'\'' -a 0,0,1,1,2
1
$ test-expr '\''(a && ((b != c) >= d)) || e'\'' -a 0,0,2,0,2
1
$ test-expr '\''(a && ((b != c) >= d)) || e'\'' -a 0,1,0,0,2
1
$ test-expr '\''(a && ((b != c) >= d)) || e'\'' -a 0,1,0,1,0
0
$ test-expr '\''(a && ((b != c) >= d)) || e'\'' -a 0,1,0,2,0
0
$ test-expr '\''(a && ((b != c) >= d)) || e'\'' -a 0,1,1,1,2
1
$ test-expr '\''(a && ((b != c) >= d)) || e'\'' -a 0,1,2,0,2
1
$ test-expr '\''(a && ((b != c) >= d)) || e'\'' -a 0,2,0,0,0
0
$ test-expr '\''(a && ((b != c) >= d)) || e'\'' -a 0,2,1,0,1
1
$ test-expr '\''(a && ((b != c) >= d)) || e'\'' -a 0,2,2,0,0
0
$ test-expr '\''(a && ((b != c) >= d)) || e'\'' -a 0,2,2,2,1
1
$ test-expr '\''(a && ((b != c) >= d)) || e'\'' -a 1,0,0,2,0
0
$ test-expr '\''(a && ((b != c) >= d)) || e'\'' -a 1,0,0,2,1
1
$ test-expr '\''(a && ((b != c) >= d)) || e'\'' -a 1,0,1,1,2
1
$ test-expr '\''(a && ((b != c) >= d)) || e'\'' -a 1,0,1,2,2
1
$ test-expr '\''(a && ((b != c) >= d)) || e'\'' -a 1,0,2,0,0
1
$ test-expr '\''(a && ((b != c) >= d)) || e'\'' -a 1,0,2,0,1
1
$ test-expr '\''(a && ((b != c) >= d)) || e'\'' -a 1,1,0,0,0
1
$ test-expr '\''(a && ((b != c) >= d)) || e'\'' -a 1,1,1,1,1
1
$ test-expr '\''(a && ((b != c) >= d)) || e'\'' -a 1,1,1,2,2
1
$ test-expr '\''(a && ((b != c) >= d)) || e'\'' -a 1,1,2,1,2
1
$ test-expr '\''(a && ((b != c) >= d)) || e'\'' -a 1,2,1,1,1
1
$ test-expr '\''(a && ((b != c) >= d)) || e'\'' -a 1,2,2,0,0
1
$ test-expr '\''(a && ((b != c) >= d)) || e'\'' -a 1,2,2,0,2
1
$ test-expr '\''(a && ((b != c) >= d)) || e'\'' -a 1,2,2,1,1
1
$ test-expr '\''(a && ((b != c) >= d)) || e'\'' -a 2,0,0,1,1
1
$ test-expr '\''(a && ((b != c) >= d)) || e'\'' -a 2,0,0,2,0
0
$ test-expr '\''(a && ((b != c) >= d)) || e'\'' -a 2,0,0,2,2
1
$ test-expr '\''(a && ((b != c) >= d)) || e'\'' -a 2,0,1,0,1
1
$ test-expr '\''(a && ((b != c) >= d)) || e'\'' -a 2,0,1,1,0
1
$ test-expr '\''(a && ((b != c) >= d)) || e'\'' -a 2,0,2,0,1
1
$ test-expr '\''(a && ((b != c) >= d)) || e'\'' -a 2,0,2,1,0
1
$ test-expr '\''(a && ((b != c) >= d)) || e'\'' -a 2,0,2,2,0
0
$ test-expr '\''(a && ((b != c) >= d)) || e'\'' -a 2,1,0,1,2
1
$ test-expr '\''(a && ((b != c) >= d)) || e'\'' -a 2,1,1,1,1
1
$ test-expr '\''(a && ((b != c) >= d)) || e'\'' -a 2,1,2,1,2
1
$ test-expr '\''(a && ((b != c) >= d)) || e'\'' -a 2,1,2,2,2
1
$ test-expr '\''(a && ((b != c) >= d)) || e'\'' -a 2,2,0,1,2
1
$ test-expr '\''(a && ((b != c) >= d)) || e'\'' -a 2,2,0,2,1
1
$ test-expr '\''(a && ((b != c) >= d)) || e'\'' -a 2,2,1,0,2
1
$ test-expr '\''(a && ((b != c) >= d)) || e'\'' -a 2,2,2,0,1
1
$ test-expr '\''(a && ((b != c) >= d)) || e'\'' -a 2,2,2,0,2
1
$ test-expr '\''(a && ((b != c) >= d)) || e'\'' -a 2,2,2,1,0
0
$ test-expr '\''(a && ((b != c) >= d)) || e'\'' -a 2,2,2,2,0
0
$ test-expr '\''(a && ((b != c) || d)) >= e'\'' -a 0,0,1,1,0
1
$ test-expr '\''(a && ((b != c) || d)) >= e'\'' -a 0,0,2,2,2
0
$ test-expr '\''(a && ((b != c) || d)) >= e'\'' -a 0,1,0,0,2
0
$ test-expr '\''(a && ((b != c) || d)) >= e'\'' -a 0,1,0,2,1
0
$ test-expr '\''(a && ((b != c) || d)) >= e'\'' -a 0,1,2,1,1
0
$ test-expr '\''(a && ((b != c) || d)) >= e'\'' -a 0,2,0,1,2
0
$ test-expr '\''(a && ((b != c) || d)) >= e'\'' -a 0,2,1,0,0
1
$ test-expr '\''(a && ((b != c) || d)) >= e'\'' -a 0,2,1,0,2
0
$ test-expr '\''(a && ((b != c) || d)) >= e'\'' -a 0,2,1,2,2
0
$ test-expr '\''(a && ((b != c) || d)) >= e'\'' -a 0,2,2,2,0
1
$ test-expr '\''(a && ((b != c) || d)) >= e'\'' -a 1,0,0,0,0
1
$ test-expr '\''(a && ((b != c) || d)) >= e'\'' -a 1,0,0,1,1
1
$ test-expr '\''(a && ((b != c) || d)) >= e'\'' -a 1,0,0,2,1
1
$ test-expr '\''(a && ((b != c) || d)) >= e'\'' -a 1,0,2,1,1
1
$ test-expr '\''(a && ((b != c) || d)) >= e'\'' -a 1,1,1,2,0
1
$ test-expr '\''(a && ((b != c) || d)) >= e'\'' -a 1,1,2,1,2
0
$ test-expr '\''(a && ((b != c) || d)) >= e'\'' -a 1,1,2,2,0
1
$ test-expr '\''(a && ((b != c) || d)) >= e'\'' -a 2,0,0,1,1
1
$ test-expr '\''(a && ((b != c) || d)) >= e'\'' -a 2,0,1,2,0
1
$ test-expr '\''(a && ((b != c) || d)) >= e'\'' -a 2,0,1,2,1
1
$ test-expr '\''(a && ((b != c) || d)) >= e'\'' -a 2,1,0,2,0
1
$ test-expr '\''(a && ((b != c) || d)) >= e'\'' -a 2,1,1,0,0
1
$ test-expr '\''(a && ((b != c) || d)) >= e'\'' -a 2,1,1,1,0
1
$ test-expr '\''(a && ((b != c) || d)) >= e'\'' -a 2,1,1,2,1
1
$ test-expr '\''(a && ((b != c) || d)) >= e'\'' -a 2,1,2,1,1
1
$ test-expr '\''(a && ((b != c) || d)) >= e'\'' -a 2,2,0,0,0
1
$ test-expr '\''(a && ((b != c) || d)) >= e'\'' -a 2,2,0,1,2
0
$ test-expr '\''(a && ((b != c) || d)) >= e'\'' -a 2,2,0,2,2
0
$ test-expr '\''(a && ((b != c) || d)) >= e'\'' -a 2,2,1,2,1
1
$ test-expr '\''(a && ((b != c) || d)) >= e'\'' -a 2,2,2,0,2
0
$ test-expr '\''(a && ((b != c) || d)) >= e'\'' -a 2,2,2,1,0
1
$ test-expr '\''(a && ((b != c) || d)) >= e'\'' -a 2,2,2,2,0
1
$ test-expr '\''(a && ((b >= c) != d)) || e'\'' -a 0,0,1,1,1
1
$ test-expr '\''(a && ((b >= c) != d)) || e'\'' -a 0,0,1,1,2
1
$ test-expr '\''(a && ((b >= c) != d)) || e'\'' -a 0,0,1,2,1
1
$ test-expr '\''(a && ((b >= c) != d)) || e'\'' -a 0,0,2,2,1
1
$ test-expr '\''(a && ((b >= c) != d)) || e'\'' -a 0,2,0,0,2
1
$ test-expr '\''(a && ((b >= c) != d)) || e'\'' -a 0,2,0,1,0
0
$ test-expr '\''(a && ((b >= c) != d)) || e'\'' -a 0,2,0,1,1
1
$ test-expr '\''(a && ((b >= c) != d)) || e'\'' -a 0,2,1,0,1
1
$ test-expr '\''(a && ((b >= c) != d)) || e'\'' -a 0,2,1,2,2
1
$ test-expr '\''(a && ((b >= c) != d)) || e'\'' -a 0,2,2,0,2
1
$ test-expr '\''(a && ((b >= c) != d)) || e'\'' -a 0,2,2,1,1
1
$ test-expr '\''(a && ((b >= c) != d)) || e'\'' -a 0,2,2,2,1
1
$ test-expr '\''(a && ((b >= c) != d)) || e'\'' -a 1,0,1,1,0
1
$ test-expr '\''(a && ((b >= c) != d)) || e'\'' -a 1,0,1,2,0
1
$ test-expr '\''(a && ((b >= c) != d)) || e'\'' -a 1,0,1,2,1
1
$ test-expr '\''(a && ((b >= c) != d)) || e'\'' -a 1,0,2,2,1
1
$ test-expr '\''(a && ((b >= c) != d)) || e'\'' -a 1,1,0,0,1
1
$ test-expr '\''(a && ((b >= c) != d)) || e'\'' -a 1,1,0,1,2
1
$ test-expr '\''(a && ((b >= c) != d)) || e'\'' -a 1,1,0,2,0
1
$ test-expr '\''(a && ((b >= c) != d)) || e'\'' -a 1,1,1,2,1
1
$ test-expr '\''(a && ((b >= c) != d)) || e'\'' -a 1,1,2,1,0
1
$ test-expr '\''(a && ((b >= c) != d)) || e'\'' -a 1,1,2,2,1
1
$ test-expr '\''(a && ((b >= c) != d)) || e'\'' -a 1,2,0,1,1
1
$ test-expr '\''(a && ((b >= c) != d)) || e'\'' -a 1,2,0,2,0
1
$ test-expr '\''(a && ((b >= c) != d)) || e'\'' -a 1,2,1,2,0
1
$ test-expr '\''(a && ((b >= c) != d)) || e'\'' -a 1,2,1,2,2
1
$ test-expr '\''(a && ((b >= c) != d)) || e'\'' -a 1,2,2,1,2
1
$ test-expr '\''(a && ((b >= c) != d)) || e'\'' -a 1,2,2,2,2
1
$ test-expr '\''(a && ((b >= c) != d)) || e'\'' -a 2,0,1,1,2
1
$ test-expr '\''(a && ((b >= c) != d)) || e'\'' -a 2,1,0,0,0
1
$ test-expr '\''(a && ((b >= c) != d)) || e'\'' -a 2,2,0,1,1
1
$ test-expr '\''(a && ((b >= c) != d)) || e'\'' -a 2,2,2,1,2
1
$ test-expr '\''(a && ((b >= c) || d)) != e'\'' -a 0,0,0,0,2
1
$ test-expr '\''(a && ((b >= c) || d)) != e'\'' -a 0,0,0,1,1
1
$ test-expr '\''(a && ((b >= c) || d)) != e'\'' -a 0,0,1,0,0
0
$ test-expr '\''(a && ((b >= c) || d)) != e'\'' -a 0,0,1,0,1
1
$ test-expr '\''(a && ((b >= c) || d)) != e'\'' -a 0,0,1,0,2
1
$ test-expr '\''(a && ((b >= c) || d)) != e'\'' -a 0,0,1,2,0
0
$ test-expr '\''(a && ((b >= c) || d)) != e'\'' -a 0,0,2,2,0
0
$ test-expr '\''(a && ((b >= c) || d)) != e'\'' -a 0,1,0,0,1
1
$ test-expr '\''(a && ((b >= c) || d)) != e'\'' -a 0,1,0,2,2
1
$ test-expr '\''(a && ((b >= c) || d)) != e'\'' -a 0,1,1,2,0
0
$ test-expr '\''(a && ((b >= c) || d)) != e'\'' -a 0,2,1,1,0
0
$ test-expr '\''(a && ((b >= c) || d)) != e'\'' -a 0,2,1,2,0
0
$ test-expr '\''(a && ((b >= c) || d)) != e'\'' -a 1,0,1,0,2
1
$ test-expr '\''(a && ((b >= c) || d)) != e'\'' -a 1,0,1,2,1
0
$ test-expr '\''(a && ((b >= c) || d)) != e'\'' -a 1,0,2,0,0
0
$ test-expr '\''(a && ((b >= c) || d)) != e'\'' -a 1,0,2,0,1
1
$ test-expr '\''(a && ((b >= c) || d)) != e'\'' -a 1,0,2,0,2
1
$ test-expr '\''(a && ((b >= c) || d)) != e'\'' -a 1,1,0,2,0
1
$ test-expr '\''(a && ((b >= c) || d)) != e'\'' -a 1,1,2,0,0
0
$ test-expr '\''(a && ((b >= c) || d)) != e'\'' -a 1,1,2,0,1
1
$ test-expr '\''(a && ((b >= c) || d)) != e'\'' -a 1,1,2,2,0
1
$ test-expr '\''(a && ((b >= c) || d)) != e'\'' -a 1,1,2,2,2
1
$ test-expr '\''(a && ((b >= c) || d)) != e'\'' -a 1,2,0,0,1
0
$ test-expr '\''(a && ((b >= c) || d)) != e'\'' -a 1,2,2,0,0
1
$ test-expr '\''(a && ((b >= c) || d)) != e'\'' -a 2,0,2,1,0
1
$ test-expr '\''(a && ((b >= c) || d)) != e'\'' -a 2,0,2,2,2
1
$ test-expr '\''(a && ((b >= c) || d)) != e'\'' -a 2,1,0,1,1
0
$ test-expr '\''(a && ((b >= c) || d)) != e'\'' -a 2,1,2,1,1
0
$ test-expr '\''(a && ((b >= c) || d)) != e'\'' -a 2,2,0,0,0
1
$ test-expr '\''(a && ((b >= c) || d)) != e'\'' -a 2,2,0,0,2
1
$ test-expr '\''(a && ((b >= c) || d)) != e'\'' -a 2,2,0,1,0
1
$ test-expr '\''(a && ((b >= c) || d)) != e'\'' -a 2,2,0,2,1
0
$ test-expr '\''(a && ((b >= c) || d)) != e'\'' -a 2,2,1,0,1
0
$ test-expr '\''(a && ((b >= c) || d)) != e'\'' -a 2,2,1,1,1
0
$ test-expr '\''(a && ((b || c) != d)) >= e'\'' -a 0,0,0,1,1
0
$ test-expr '\''(a && ((b || c) != d)) >= e'\'' -a 0,0,0,2,0
1
$ test-expr '\''(a && ((b || c) != d)) >= e'\'' -a 0,0,1,0,0
1
$ test-expr '\''(a && ((b || c) != d)) >= e'\'' -a 0,0,1,0,1
0
$ test-expr '\''(a && ((b || c) != d)) >= e'\'' -a 0,0,1,1,2
0
$ test-expr '\''(a && ((b || c) != d)) >= e'\'' -a 0,0,2,1,2
0
$ test-expr '\''(a && ((b || c) != d)) >= e'\'' -a 0,1,0,0,1
0
$ test-expr '\''(a && ((b || c) != d)) >= e'\'' -a 0,1,0,1,1
0
$ test-expr '\''(a && ((b || c) != d)) >= e'\'' -a 0,1,1,0,0
1
$ test-expr '\''(a && ((b || c) != d)) >= e'\'' -a 0,1,2,0,2
0
$ test-expr '\''(a && ((b || c) != d)) >= e'\'' -a 0,2,1,0,2
0
$ test-expr '\''(a && ((b || c) != d)) >= e'\'' -a 1,0,2,1,1
0
$ test-expr '\''(a && ((b || c) != d)) >= e'\'' -a 1,1,0,0,1
1
$ test-expr '\''(a && ((b || c) != d)) >= e'\'' -a 1,1,1,1,2
0
$ test-expr '\''(a && ((b || c) != d)) >= e'\'' -a 1,2,0,1,2
0
$ test-expr '\''(a && ((b || c) != d)) >= e'\'' -a 1,2,1,1,2
0
$ test-expr '\''(a && ((b || c) != d)) >= e'\'' -a 1,2,2,0,1
1
$ test-expr '\''(a && ((b || c) != d)) >= e'\'' -a 1,2,2,1,2
0
$ test-expr '\''(a && ((b || c) != d)) >= e'\'' -a 2,0,0,1,1
1
$ test-expr '\''(a && ((b || c) != d)) >= e'\'' -a 2,0,1,1,0
1
$ test-expr '\''(a && ((b || c) != d)) >= e'\'' -a 2,0,1,1,2
0
$ test-expr '\''(a && ((b || c) != d)) >= e'\'' -a 2,0,1,2,0
1
$ test-expr '\''(a && ((b || c) != d)) >= e'\'' -a 2,1,0,1,0
1
$ test-expr '\''(a && ((b || c) != d)) >= e'\'' -a 2,1,0,1,1
0
$ test-expr '\''(a && ((b || c) != d)) >= e'\'' -a 2,1,0,2,1
1
$ test-expr '\''(a && ((b || c) != d)) >= e'\'' -a 2,1,1,2,2
0
$ test-expr '\''(a && ((b || c) != d)) >= e'\'' -a 2,1,2,1,1
0
$ test-expr '\''(a && ((b || c) != d)) >= e'\'' -a 2,1,2,2,0
1
$ test-expr '\''(a && ((b || c) != d)) >= e'\'' -a 2,1,2,2,1
1
$ test-expr '\''(a && ((b || c) != d)) >= e'\'' -a 2,2,0,1,1
0
$ test-expr '\''(a && ((b || c) >= d)) != e'\'' -a 0,0,1,0,2
1
$ test-expr '\''(a && ((b || c) >= d)) != e'\'' -a 0,0,2,0,1
1
$ test-expr '\''(a && ((b || c) >= d)) != e'\'' -a 0,0,2,1,0
0
$ test-expr '\''(a && ((b || c) >= d)) != e'\'' -a 0,0,2,2,0
0
$ test-expr '\''(a && ((b || c) >= d)) != e'\'' -a 0,0,2,2,1
1
$ test-expr '\''(a && ((b || c) >= d)) != e'\'' -a 0,1,0,2,1
1
$ test-expr '\''(a && ((b || c) >= d)) != e'\'' -a 0,1,1,0,0
0
$ test-expr '\''(a && ((b || c) >= d)) != e'\'' -a 0,1,2,1,1
1
$ test-expr '\''(a && ((b || c) >= d)) != e'\'' -a 0,2,0,1,1
1
$ test-expr '\''(a && ((b || c) >= d)) != e'\'' -a 0,2,0,2,1
1
$ test-expr '\''(a && ((b || c) >= d)) != e'\'' -a 0,2,2,0,1
1
$ test-expr '\''(a && ((b || c) >= d)) != e'\'' -a 0,2,2,1,0
0
$ test-expr '\''(a && ((b || c) >= d)) != e'\'' -a 1,0,0,2,0
0
$ test-expr '\''(a && ((b || c) >= d)) != e'\'' -a 1,0,2,0,2
1
$ test-expr '\''(a && ((b || c) >= d)) != e'\'' -a 1,0,2,1,1
0
$ test-expr '\''(a && ((b || c) >= d)) != e'\'' -a 1,1,0,0,2
1
$ test-expr '\''(a && ((b || c) >= d)) != e'\'' -a 1,1,1,2,1
1
$ test-expr '\''(a && ((b || c) >= d)) != e'\'' -a 1,1,2,2,0
0
$ test-expr '\''(a && ((b || c) >= d)) != e'\'' -a 1,2,1,1,0
1
$ test-expr '\''(a && ((b || c) >= d)) != e'\'' -a 1,2,1,2,0
0
$ test-expr '\''(a && ((b || c) >= d)) != e'\'' -a 1,2,2,1,1
0
$ test-expr '\''(a && ((b || c) >= d)) != e'\'' -a 1,2,2,2,0
0
$ test-expr '\''(a && ((b || c) >= d)) != e'\'' -a 2,0,1,0,1
0
$ test-expr '\''(a && ((b || c) >= d)) != e'\'' -a 2,0,1,0,2
1
$ test-expr '\''(a && ((b || c) >= d)) != e'\'' -a 2,0,1,1,2
1
$ test-expr '\''(a && ((b || c) >= d)) != e'\'' -a 2,0,2,1,2
1
$ test-expr '\''(a && ((b || c) >= d)) != e'\'' -a 2,2,0,1,2
1
$ test-expr '\''(a && ((b || c) >= d)) != e'\'' -a 2,2,0,2,0
0
$ test-expr '\''(a && ((b || c) >= d)) != e'\'' -a 2,2,2,0,1
0
$ test-expr '\''(a && ((b || c) >= d)) != e'\'' -a 2,2,2,2,0
0
$ test-expr '\''(a >= b) != (c && (d || e))'\'' -a 0,0,2,0,1
0
$ test-expr '\''(a >= b) != (c && (d || e))'\'' -a 0,1,0,0,1
0
$ test-expr '\''(a >= b) != (c && (d || e))'\'' -a 0,1,0,2,2
0
$ test-expr '\''(a >= b) != (c && (d || e))'\'' -a 0,1,2,1,1
1
$ test-expr '\''(a >= b) != (c && (d || e))'\'' -a 0,1,2,2,1
1
$ test-expr '\''(a >= b) != (c && (d || e))'\'' -a 0,2,0,1,1
0
$ test-expr '\''(a >= b) != (c && (d || e))'\'' -a 0,2,2,2,2
1
$ test-expr '\''(a >= b) != (c && (d || e))'\'' -a 1,0,1,2,0
0
$ test-expr '\''(a >= b) != (c && (d || e))'\'' -a 1,0,2,0,0
1
$ test-expr '\''(a >= b) != (c && (d || e))'\'' -a 1,0,2,2,2
0
$ test-expr '\''(a >= b) != (c && (d || e))'\'' -a 1,1,1,1,1
0
$ test-expr '\''(a >= b) != (c && (d || e))'\'' -a 1,2,0,0,0
0
$ test-expr '\''(a >= b) != (c && (d || e))'\'' -a 1,2,1,1,0
1
$ test-expr '\''(a >= b) != (c && (d || e))'\'' -a 1,2,2,0,2
1
$ test-expr '\''(a >= b) != (c && (d || e))'\'' -a 2,0,0,2,2
1
$ test-expr '\''(a >= b) != (c && (d || e))'\'' -a 2,0,1,0,1
0
$ test-expr '\''(a >= b) != (c && (d || e))'\'' -a 2,0,2,0,0
1
$ test-expr '\''(a >= b) != (c && (d || e))'\'' -a 2,1,0,1,2
1
$ test-expr '\''(a >= b) != (c && (d || e))'\'' -a 2,1,0,2,2
1
$ test-expr '\''(a >= b) != (c && (d || e))'\'' -a 2,1,1,0,2
0
$ test-expr '\''(a >= b) != (c && (d || e))'\'' -a 2,1,2,0,1
0
$ test-expr '\''(a >= b) != (c && (d || e))'\'' -a 2,2,0,0,1
1
$ test-expr '\''(a >= b) != (c && (d || e))'\'' -a 2,2,1,1,0
0
$ test-expr '\''(a >= b) != (c && (d || e))'\'' -a 2,2,1,1,1
0
$ test-expr '\''(a >= b) != (c || (d && e))'\'' -a 0,0,0,1,0
1
$ test-expr '\''(a >= b) != (c || (d && e))'\'' -a 0,0,1,1,2
0
$ test-expr '\''(a >= b) != (c || (d && e))'\'' -a 0,0,1,2,1
0
$ test-expr '\''(a >= b) != (c || (d && e))'\'' -a 0,0,2,1,0
0
$ test-expr '\''(a >= b) != (c || (d && e))'\'' -a 0,1,0,0,1
0
$ test-expr '\''(a >= b) != (c || (d && e))'\'' -a 0,1,1,1,1
1
$ test-expr '\''(a >= b) != (c || (d && e))'\'' -a 0,1,1,2,0
1
$ test-expr '\''(a >= b) != (c || (d && e))'\'' -a 0,1,2,1,0
1
$ test-expr '\''(a >= b) != (c || (d && e))'\'' -a 0,2,1,0,0
1
$ test-expr '\''(a >= b) != (c || (d && e))'\'' -a 0,2,1,1,2
1
$ test-expr '\''(a >= b) != (c || (d && e))'\'' -a 0,2,1,2,1
1
$ test-expr '\''(a >= b) != (c || (d && e))'\'' -a 0,2,2,0,1
1
$ test-expr '\''(a >= b) != (c || (d && e))'\'' -a 1,0,1,2,2
0
$ test-expr '\''(a >= b) != (c || (d && e))'\'' -a 1,1,0,2,2
0
$ test-expr '\''(a >= b) != (c || (d && e))'\'' -a 1,1,1,2,1
0
$ test-expr '\''(a >= b) != (c || (d && e))'\'' -a 1,2,0,1,0
0
$ test-expr '\''(a >= b) != (c || (d && e))'\'' -a 1,2,0,2,1
1
$ test-expr '\''(a >= b) != (c || (d && e))'\'' -a 1,2,1,2,0
1
$ test-expr '\''(a >= b) != (c || (d && e))'\'' -a 2,0,0,0,1
1
$ test-expr '\''(a >= b) != (c || (d && e))'\'' -a 2,0,0,1,2
0
$ test-expr '\''(a >= b) != (c || (d && e))'\'' -a 2,0,0,2,2
0
$ test-expr '\''(a >= b) != (c || (d && e))'\'' -a 2,0,1,1,2
0
$ test-expr '\''(a >= b) != (c || (d && e))'\'' -a 2,1,1,0,2
0
$ test-expr '\''(a >= b) != (c || (d && e))'\'' -a 2,2,0,0,0
1
$ test-expr '\''(a >= b) != (c || (d && e))'\'' -a 2,2,1,1,2
0
$ test-expr '\''(a >= b) != (c || (d && e))'\'' -a 2,2,1,2,0
0
$ test-expr '\''(a >= b) != (c || (d && e))'\'' -a 2,2,1,2,2
0
$ test-expr '\''(a >= b) != ((c && d) || e)'\'' -a 0,0,0,0,1
0
$ test-expr '\''(a >= b) != ((c && d) || e)'\'' -a 0,0,0,2,1
0
$ test-expr '\''(a >= b) != ((c && d) || e)'\'' -a 0,0,1,1,2
0
$ test-expr '\''(a >= b) != ((c && d) || e)'\'' -a 0,0,1,2,1
0
$ test-expr '\''(a >= b) != ((c && d) || e)'\'' -a 0,1,1,0,0
0
$ test-expr '\''(a >= b) != ((c && d) || e)'\'' -a 0,1,1,2,2
1
$ test-expr '\''(a >= b) != ((c && d) || e)'\'' -a 0,1,2,1,0
1
$ test-expr '\''(a >= b) != ((c && d) || e)'\'' -a 0,1,2,1,1
1
$ test-expr '\''(a >= b) != ((c && d) || e)'\'' -a 0,2,0,1,1
1
$ test-expr '\''(a >= b) != ((c && d) || e)'\'' -a 0,2,0,2,0
0
$ test-expr '\''(a >= b) != ((c && d) || e)'\'' -a 0,2,1,2,0
1
$ test-expr '\''(a >= b) != ((c && d) || e)'\'' -a 0,2,2,0,1
1
$ test-expr '\''(a >= b) != ((c && d) || e)'\'' -a 0,2,2,2,2
1
$ test-expr '\''(a >= b) != ((c && d) || e)'\'' -a 1,0,1,0,2
0
$ test-expr '\''(a >= b) != ((c && d) || e)'\'' -a 1,0,2,0,2
0
$ test-expr '\''(a >= b) != ((c && d) || e)'\'' -a 1,1,0,1,1
0
$ test-expr '\''(a >= b) != ((c && d) || e)'\'' -a 1,1,2,1,1
0
$ test-expr '\''(a >= b) != ((c && d) || e)'\'' -a 1,2,0,0,2
1
$ test-expr '\''(a >= b) != ((c && d) || e)'\'' -a 1,2,0,2,2
1
$ test-expr '\''(a >= b) != ((c && d) || e)'\'' -a 1,2,1,0,0
0
$ test-expr '\''(a >= b) != ((c && d) || e)'\'' -a 1,2,2,1,0
1
$ test-expr '\''(a >= b) != ((c && d) || e)'\'' -a 1,2,2,1,1
1
$ test-expr '\''(a >= b) != ((c && d) || e)'\'' -a 1,2,2,1,2
1
$ test-expr '\''(a >= b) != ((c && d) || e)'\'' -a 2,0,0,2,1
0
$ test-expr '\''(a >= b) != ((c && d) || e)'\'' -a 2,1,0,1,0
1
$ test-expr '\''(a >= b) != ((c && d) || e)'\'' -a 2,1,1,0,0
1
$ test-expr '\''(a >= b) != ((c && d) || e)'\'' -a 2,1,1,1,1
0
$ test-expr '\''(a >= b) != ((c && d) || e)'\'' -a 2,1,1,2,1
0
$ test-expr '\''(a >= b) != ((c && d) || e)'\'' -a 2,2,0,1,0
1
$ test-expr '\''(a >= b) != ((c && d) || e)'\'' -a 2,2,1,0,0
1
$ test-expr '\''(a >= b) != ((c && d) || e)'\'' -a 2,2,2,0,2
0
$ test-expr '\''(a >= b) != ((c || d) && e)'\'' -a 0,0,1,1,1
0
$ test-expr '\''(a >= b) != ((c || d) && e)'\'' -a 0,0,2,1,0
1
$ test-expr '\''(a >= b) != ((c || d) && e)'\'' -a 0,0,2,1,2
0
$ test-expr '\''(a >= b) != ((c || d) && e)'\'' -a 0,1,0,1,0
0
$ test-expr '\''(a >= b) != ((c || d) && e)'\'' -a 0,1,1,2,2
1
$ test-expr '\''(a >= b) != ((c || d) && e)'\'' -a 0,1,2,2,1
1
$ test-expr '\''(a >= b) != ((c || d) && e)'\'' -a 0,2,0,1,2
1
$ test-expr '\''(a >= b) != ((c || d) && e)'\'' -a 0,2,2,0,0
0
$ test-expr '\''(a >= b) != ((c || d) && e)'\'' -a 1,0,0,0,1
1
$ test-expr '\''(a >= b) != ((c || d) && e)'\'' -a 1,0,0,1,1
0
$ test-expr '\''(a >= b) != ((c || d) && e)'\'' -a 1,0,0,1,2
0
$ test-expr '\''(a >= b) != ((c || d) && e)'\'' -a 1,0,1,1,0
1
$ test-expr '\''(a >= b) != ((c || d) && e)'\'' -a 1,0,2,0,0
1
$ test-expr '\''(a >= b) != ((c || d) && e)'\'' -a 1,0,2,1,0
1
$ test-expr '\''(a >= b) != ((c || d) && e)'\'' -a 1,1,0,1,2
0
$ test-expr '\''(a >= b) != ((c || d) && e)'\'' -a 1,1,0,2,2
0
$ test-expr '\''(a >= b) != ((c || d) && e)'\'' -a 1,1,1,2,1
0
$ test-expr '\''(a >= b) != ((c || d) && e)'\'' -a 1,1,2,1,2
0
$ test-expr '\''(a >= b) != ((c || d) && e)'\'' -a 1,1,2,2,0
1
$ test-expr '\''(a >= b) != ((c || d) && e)'\'' -a 1,2,0,0,0
0
$ test-expr '\''(a >= b) != ((c || d) && e)'\'' -a 1,2,1,0,0
0
$ test-expr '\''(a >= b) != ((c || d) && e)'\'' -a 1,2,1,0,1
1
$ test-expr '\''(a >= b) != ((c || d) && e)'\'' -a 1,2,2,0,1
1
$ test-expr '\''(a >= b) != ((c || d) && e)'\'' -a 2,0,0,2,0
1
$ test-expr '\''(a >= b) != ((c || d) && e)'\'' -a 2,1,1,1,1
0
$ test-expr '\''(a >= b) != ((c || d) && e)'\'' -a 2,2,0,1,0
1
$ test-expr '\''(a >= b) != ((c || d) && e)'\'' -a 2,2,1,2,0
1
$ test-expr '\''(a >= b) != ((c || d) && e)'\'' -a 2,2,1,2,1
0
$ test-expr '\''(a >= b) != ((c || d) && e)'\'' -a 2,2,2,1,2
0
$ test-expr '\''(a >= b) && (c != (d || e))'\'' -a 0,0,0,0,1
1
$ test-expr '\''(a >= b) && (c != (d || e))'\'' -a 0,0,0,2,0
1
$ test-expr '\''(a >= b) && (c != (d || e))'\'' -a 0,0,1,1,2
0
$ test-expr '\''(a >= b) && (c != (d || e))'\'' -a 0,0,1,2,1
0
$ test-expr '\''(a >= b) && (c != (d || e))'\'' -a 0,1,0,1,0
0
$ test-expr '\''(a >= b) && (c != (d || e))'\'' -a 0,1,1,2,1
0
$ test-expr '\''(a >= b) && (c != (d || e))'\'' -a 0,1,2,0,2
0
$ test-expr '\''(a >= b) && (c != (d || e))'\'' -a 0,1,2,2,1
0
$ test-expr '\''(a >= b) && (c != (d || e))'\'' -a 0,2,0,2,1
0
$ test-expr '\''(a >= b) && (c != (d || e))'\'' -a 0,2,1,1,0
0
$ test-expr '\''(a >= b) && (c != (d || e))'\'' -a 0,2,2,0,0
0
$ test-expr '\''(a >= b) && (c != (d || e))'\'' -a 1,0,1,1,0
0
$ test-expr '\''(a >= b) && (c != (d || e))'\'' -a 1,0,2,0,1
1
$ test-expr '\''(a >= b) && (c != (d || e))'\'' -a 1,0,2,0,2
1
$ test-expr '\''(a >= b) && (c != (d || e))'\'' -a 1,1,0,0,0
0
$ test-expr '\''(a >= b) && (c != (d || e))'\'' -a 1,1,0,0,1
1
$ test-expr '\''(a >= b) && (c != (d || e))'\'' -a 1,1,1,0,0
1
$ test-expr '\''(a >= b) && (c != (d || e))'\'' -a 1,1,2,0,0
1
$ test-expr '\''(a >= b) && (c != (d || e))'\'' -a 1,1,2,1,2
1
$ test-expr '\''(a >= b) && (c != (d || e))'\'' -a 1,2,0,0,1
0
$ test-expr '\''(a >= b) && (c != (d || e))'\'' -a 1,2,2,0,2
0
$ test-expr '\''(a >= b) && (c != (d || e))'\'' -a 1,2,2,1,0
0
$ test-expr '\''(a >= b) && (c != (d || e))'\'' -a 2,0,1,0,0
1
$ test-expr '\''(a >= b) && (c != (d || e))'\'' -a 2,0,1,1,1
0
$ test-expr '\''(a >= b) && (c != (d || e))'\'' -a 2,0,1,2,1
0
$ test-expr '\''(a >= b) && (c != (d || e))'\'' -a 2,0,2,2,0
1
$ test-expr '\''(a >= b) && (c != (d || e))'\'' -a 2,1,0,1,0
1
$ test-expr '\''(a >= b) && (c != (d || e))'\'' -a 2,1,1,0,1
0
$ test-expr '\''(a >= b) && (c != (d || e))'\'' -a 2,1,1,2,0
0
$ test-expr '\''(a >= b) && (c != (d || e))'\'' -a 2,1,2,2,2
1
$ test-expr '\''(a >= b) && (c != (d || e))'\'' -a 2,2,0,1,0
1
$ test-expr '\''(a >= b) && (c != (d || e))'\'' -a 2,2,0,2,2
1
$ test-expr '\''(a >= b) && (c || (d != e))'\'' -a 0,0,0,2,0
1
$ test-expr '\''(a >= b) && (c || (d != e))'\'' -a 0,0,1,0,0
1
$ test-expr '\''(a >= b) && (c || (d != e))'\'' -a 0,1,0,2,0
0
$ test-expr '\''(a >= b) && (c || (d != e))'\'' -a 0,2,0,2,0
0
$ test-expr '\''(a >= b) && (c || (d != e))'\'' -a 0,2,1,0,2
0
$ test-expr '\''(a >= b) && (c || (d != e))'\'' -a 0,2,1,1,0
0
$ test-expr '\''(a >= b) && (c || (d != e))'\'' -a 0,2,1,1,1
0
$ test-expr '\''(a >= b) && (c || (d != e))'\'' -a 0,2,2,0,2
0
$ test-expr '\''(a >= b) && (c || (d != e))'\'' -a 1,0,2,0,0
1
$ test-expr '\''(a >= b) && (c || (d != e))'\'' -a 1,0,2,0,2
1
$ test-expr '\''(a >= b) && (c || (d != e))'\'' -a 1,1,0,1,1
0
$ test-expr '\''(a >= b) && (c || (d != e))'\'' -a 1,1,2,0,1
1
$ test-expr '\''(a >= b) && (c || (d != e))'\'' -a 1,2,0,0,0
0
$ test-expr '\''(a >= b) && (c || (d != e))'\'' -a 1,2,1,0,1
0
$ test-expr '\''(a >= b) && (c || (d != e))'\'' -a 1,2,1,1,0
0
$ test-expr '\''(a >= b) && (c || (d != e))'\'' -a 2,0,0,2,2
0
$ test-expr '\''(a >= b) && (c || (d != e))'\'' -a 2,0,2,2,0
1
$ test-expr '\''(a >= b) && (c || (d != e))'\'' -a 2,0,2,2,2
1
$ test-expr '\''(a >= b) && (c || (d != e))'\'' -a 2,1,1,1,0
1
$ test-expr '\''(a >= b) && (c || (d != e))'\'' -a 2,1,1,2,2
1
$ test-expr '\''(a >= b) && (c || (d != e))'\'' -a 2,1,2,1,0
1
$ test-expr '\''(a >= b) && (c || (d != e))'\'' -a 2,2,1,1,0
1
$ test-expr '\''(a >= b) && (c || (d != e))'\'' -a 2,2,1,2,1
1
$ test-expr '\''(a >= b) && (c || (d != e))'\'' -a 2,2,2,1,0
1
$ test-expr '\''(a >= b) && ((c != d) || e)'\'' -a 0,0,1,2,2
1
$ test-expr '\''(a >= b) && ((c != d) || e)'\'' -a 0,0,2,1,2
1
$ test-expr '\''(a >= b) && ((c != d) || e)'\'' -a 0,1,0,1,2
0
$ test-expr '\''(a >= b) && ((c != d) || e)'\'' -a 0,1,1,1,1
0
$ test-expr '\''(a >= b) && ((c != d) || e)'\'' -a 0,1,1,2,0
0
$ test-expr '\''(a >= b) && ((c != d) || e)'\'' -a 0,1,2,0,0
0
$ test-expr '\''(a >= b) && ((c != d) || e)'\'' -a 0,1,2,2,1
0
$ test-expr '\''(a >= b) && ((c != d) || e)'\'' -a 0,2,1,0,1
0
$ test-expr '\''(a >= b) && ((c != d) || e)'\'' -a 0,2,2,0,2
0
$ test-expr '\''(a >= b) && ((c != d) || e)'\'' -a 1,0,1,0,2
1
$ test-expr '\''(a >= b) && ((c != d) || e)'\'' -a 1,0,1,1,0
0
$ test-expr '\''(a >= b) && ((c != d) || e)'\'' -a 1,0,2,0,1
1
$ test-expr '\''(a >= b) && ((c != d) || e)'\'' -a 1,0,2,2,1
1
$ test-expr '\''(a >= b) && ((c != d) || e)'\'' -a 1,0,2,2,2
1
$ test-expr '\''(a >= b) && ((c != d) || e)'\'' -a 1,1,0,0,1
1
$ test-expr '\''(a >= b) && ((c != d) || e)'\'' -a 1,1,0,1,0
1
$ test-expr '\''(a >= b) && ((c != d) || e)'\'' -a 1,1,0,2,1
1
$ test-expr '\''(a >= b) && ((c != d) || e)'\'' -a 1,1,1,1,2
1
$ test-expr '\''(a >= b) && ((c != d) || e)'\'' -a 1,1,2,1,1
1
$ test-expr '\''(a >= b) && ((c != d) || e)'\'' -a 1,2,1,1,1
0
$ test-expr '\''(a >= b) && ((c != d) || e)'\'' -a 1,2,1,2,2
0
$ test-expr '\''(a >= b) && ((c != d) || e)'\'' -a 1,2,2,1,2
0
$ test-expr '\''(a >= b) && ((c != d) || e)'\'' -a 2,0,0,2,2
1
$ test-expr '\''(a >= b) && ((c != d) || e)'\'' -a 2,0,1,1,0
0
$ test-expr '\''(a >= b) && ((c != d) || e)'\'' -a 2,0,1,1,2
1
$ test-expr '\''(a >= b) && ((c != d) || e)'\'' -a 2,0,1,2,0
1
$ test-expr '\''(a >= b) && ((c != d) || e)'\'' -a 2,1,0,2,1
1
$ test-expr '\''(a >= b) && ((c != d) || e)'\'' -a 2,1,1,1,1
1
$ test-expr '\''(a >= b) && ((c != d) || e)'\'' -a 2,1,1,2,0
1
$ test-expr '\''(a >= b) && ((c != d) || e)'\'' -a 2,1,2,2,0
0
$ test-expr '\''(a >= b) && ((c != d) || e)'\'' -a 2,2,0,0,0
0
$ test-expr '\''(a >= b) && ((c != d) || e)'\'' -a 2,2,0,2,0
1
$ test-expr '\''(a >= b) && ((c != d) || e)'\'' -a 2,2,1,0,2
1
$ test-expr '\''(a >= b) && ((c != d) || e)'\'' -a 2,2,1,2,1
1
$ test-expr '\''(a >= b) && ((c != d) || e)'\'' -a 2,2,1,2,2
1
$ test-expr '\''(a >= b) && ((c != d) || e)'\'' -a 2,2,2,0,1
1
$ test-expr '\''(a >= b) && ((c != d) || e)'\'' -a 2,2,2,1,1
1
$ test-expr '\''(a >= b) && ((c != d) || e)'\'' -a 2,2,2,2,0
0
$ test-expr '\''(a >= b) && ((c || d) != e)'\'' -a 0,0,1,0,2
1
$ test-expr '\''(a >= b) && ((c || d) != e)'\'' -a 0,1,0,2,0
0
$ test-expr '\''(a >= b) && ((c || d) != e)'\'' -a 0,1,0,2,2
0
$ test-expr '\''(a >= b) && ((c || d) != e)'\'' -a 0,2,2,1,2
0
$ test-expr '\''(a >= b) && ((c || d) != e)'\'' -a 1,0,0,0,0
0
$ test-expr '\''(a >= b) && ((c || d) != e)'\'' -a 1,0,0,1,0
1
$ test-expr '\''(a >= b) && ((c || d) != e)'\'' -a 1,0,2,0,1
0
$ test-expr '\''(a >= b) && ((c || d) != e)'\'' -a 1,0,2,1,0
1
$ test-expr '\''(a >= b) && ((c || d) != e)'\'' -a 1,0,2,2,2
1
$ test-expr '\''(a >= b) && ((c || d) != e)'\'' -a 1,1,0,1,1
0
$ test-expr '\''(a >= b) && ((c || d) != e)'\'' -a 1,1,0,2,1
0
$ test-expr '\''(a >= b) && ((c || d) != e)'\'' -a 1,1,1,0,1
0
$ test-expr '\''(a >= b) && ((c || d) != e)'\'' -a 1,1,1,1,2
1
$ test-expr '\''(a >= b) && ((c || d) != e)'\'' -a 1,1,1,2,2
1
$ test-expr '\''(a >= b) && ((c || d) != e)'\'' -a 1,2,0,0,1
0
$ test-expr '\''(a >= b) && ((c || d) != e)'\'' -a 1,2,1,1,1
0
$ test-expr '\''(a >= b) && ((c || d) != e)'\'' -a 1,2,2,0,2
0
$ test-expr '\''(a >= b) && ((c || d) != e)'\'' -a 1,2,2,1,1
0
$ test-expr '\''(a >= b) && ((c || d) != e)'\'' -a 2,0,0,0,2
1
$ test-expr '\''(a >= b) && ((c || d) != e)'\'' -a 2,0,0,1,0
1
$ test-expr '\''(a >= b) && ((c || d) != e)'\'' -a 2,0,0,1,2
1
$ test-expr '\''(a >= b) && ((c || d) != e)'\'' -a 2,0,2,0,0
1
$ test-expr '\''(a >= b) && ((c || d) != e)'\'' -a 2,0,2,1,1
0
$ test-expr '\''(a >= b) && ((c || d) != e)'\'' -a 2,1,0,0,2
1
$ test-expr '\''(a >= b) && ((c || d) != e)'\'' -a 2,1,0,1,1
0
$ test-expr '\''(a >= b) && ((c || d) != e)'\'' -a 2,1,1,0,0
1
$ test-expr '\''(a >= b) && ((c || d) != e)'\'' -a 2,1,1,0,1
0
$ test-expr '\''(a >= b) && ((c || d) != e)'\'' -a 2,1,1,1,2
1
$ test-expr '\''(a >= b) && ((c || d) != e)'\'' -a 2,1,2,0,1
0
$ test-expr '\''(a >= b) && ((c || d) != e)'\'' -a 2,1,2,1,1
0
$ test-expr '\''(a >= b) && ((c || d) != e)'\'' -a 2,2,0,0,2
1
$ test-expr '\''(a >= b) && ((c || d) != e)'\'' -a 2,2,0,2,1
0
$ test-expr '\''(a >= b) || (c != (d && e))'\'' -a 0,0,0,2,1
1
$ test-expr '\''(a >= b) || (c != (d && e))'\'' -a 0,0,1,1,0
1
$ test-expr '\''(a >= b) || (c != (d && e))'\'' -a 0,0,1,1,1
1
$ test-expr '\''(a >= b) || (c != (d && e))'\'' -a 0,0,2,1,0
1
$ test-expr '\''(a >= b) || (c != (d && e))'\'' -a 0,0,2,2,0
1
$ test-expr '\''(a >= b) || (c != (d && e))'\'' -a 0,1,0,0,0
0
$ test-expr '\''(a >= b) || (c != (d && e))'\'' -a 0,1,0,1,1
1
$ test-expr '\''(a >= b) || (c != (d && e))'\'' -a 0,1,0,2,0
0
$ test-expr '\''(a >= b) || (c != (d && e))'\'' -a 0,1,1,1,2
0
$ test-expr '\''(a >= b) || (c != (d && e))'\'' -a 0,1,1,2,1
0
$ test-expr '\''(a >= b) || (c != (d && e))'\'' -a 0,1,1,2,2
0
$ test-expr '\''(a >= b) || (c != (d && e))'\'' -a 0,1,2,2,0
1
$ test-expr '\''(a >= b) || (c != (d && e))'\'' -a 0,1,2,2,2
1
$ test-expr '\''(a >= b) || (c != (d && e))'\'' -a 0,2,0,1,0
0
$ test-expr '\''(a >= b) || (c != (d && e))'\'' -a 0,2,0,2,0
0
$ test-expr '\''(a >= b) || (c != (d && e))'\'' -a 0,2,1,2,2
0
$ test-expr '\''(a >= b) || (c != (d && e))'\'' -a 0,2,2,2,0
1
$ test-expr '\''(a >= b) || (c != (d && e))'\'' -a 1,0,2,1,0
1
$ test-expr '\''(a >= b) || (c != (d && e))'\'' -a 1,0,2,1,1
1
$ test-expr '\''(a >= b) || (c != (d && e))'\'' -a 1,1,1,2,0
1
$ test-expr '\''(a >= b) || (c != (d && e))'\'' -a 1,1,2,0,2
1
$ test-expr '\''(a >= b) || (c != (d && e))'\'' -a 1,2,1,2,2
0
$ test-expr '\''(a >= b) || (c != (d && e))'\'' -a 1,2,2,1,0
1
$ test-expr '\''(a >= b) || (c != (d && e))'\'' -a 2,0,1,1,0
1
$ test-expr '\''(a >= b) || (c != (d && e))'\'' -a 2,0,2,2,0
1
$ test-expr '\''(a >= b) || (c != (d && e))'\'' -a 2,1,1,1,0
1
$ test-expr '\''(a >= b) || (c != (d && e))'\'' -a 2,1,1,2,2
1
$ test-expr '\''(a >= b) || (c != (d && e))'\'' -a 2,1,2,0,1
1
$ test-expr '\''(a >= b) || (c != (d && e))'\'' -a 2,1,2,0,2
1
$ test-expr '\''(a >= b) || (c != (d && e))'\'' -a 2,2,2,1,0
1
$ test-expr '\''(a >= b) || (c && (d != e))'\'' -a 0,0,0,2,2
1
$ test-expr '\''(a >= b) || (c && (d != e))'\'' -a 0,0,2,2,2
1
$ test-expr '\''(a >= b) || (c && (d != e))'\'' -a 0,1,0,0,0
0
$ test-expr '\''(a >= b) || (c && (d != e))'\'' -a 0,2,2,0,2
1
$ test-expr '\''(a >= b) || (c && (d != e))'\'' -a 1,0,1,2,1
1
$ test-expr '\''(a >= b) || (c && (d != e))'\'' -a 1,0,1,2,2
1
$ test-expr '\''(a >= b) || (c && (d != e))'\'' -a 1,0,2,1,1
1
$ test-expr '\''(a >= b) || (c && (d != e))'\'' -a 1,1,0,1,1
1
$ test-expr '\''(a >= b) || (c && (d != e))'\'' -a 1,1,0,2,0
1
$ test-expr '\''(a >= b) || (c && (d != e))'\'' -a 1,1,0,2,2
1
$ test-expr '\''(a >= b) || (c && (d != e))'\'' -a 1,1,1,2,2
1
$ test-expr '\''(a >= b) || (c && (d != e))'\'' -a 1,2,0,0,1
0
$ test-expr '\''(a >= b) || (c && (d != e))'\'' -a 1,2,1,0,1
1
$ test-expr '\''(a >= b) || (c && (d != e))'\'' -a 2,0,0,0,1
1
$ test-expr '\''(a >= b) || (c && (d != e))'\'' -a 2,0,1,1,0
1
$ test-expr '\''(a >= b) || (c && (d != e))'\'' -a 2,0,1,2,1
1
$ test-expr '\''(a >= b) || (c && (d != e))'\'' -a 2,0,2,1,1
1
$ test-expr '\''(a >= b) || (c && (d != e))'\'' -a 2,0,2,2,2
1
$ test-expr '\''(a >= b) || (c && (d != e))'\'' -a 2,1,0,1,1
1
$ test-expr '\''(a >= b) || (c && (d != e))'\'' -a 2,1,0,2,2
1
$ test-expr '\''(a >= b) || (c && (d != e))'\'' -a 2,1,1,0,2
1
$ test-expr '\''(a >= b) || (c && (d != e))'\'' -a 2,1,1,1,1
1
$ test-expr '\''(a >= b) || (c && (d != e))'\'' -a 2,2,0,0,1
1
$ test-expr '\''(a >= b) || (c && (d != e))'\'' -a 2,2,2,0,0
1
$ test-expr '\''(a >= b) || ((c != d) && e)'\'' -a 0,0,0,0,0
1
$ test-expr '\''(a >= b) || ((c != d) && e)'\'' -a 0,0,1,2,2
1
$ test-expr '\''(a >= b) || ((c != d) && e)'\'' -a 0,0,2,2,1
1
$ test-expr '\''(a >= b) || ((c != d) && e)'\'' -a 0,1,0,0,1
0
$ test-expr '\''(a >= b) || ((c != d) && e)'\'' -a 0,1,0,2,1
1
$ test-expr '\''(a >= b) || ((c != d) && e)'\'' -a 0,1,1,2,0
0
$ test-expr '\''(a >= b) || ((c != d) && e)'\'' -a 0,1,1,2,1
1
$ test-expr '\''(a >= b) || ((c != d) && e)'\'' -a 0,1,2,1,2
1
$ test-expr '\''(a >= b) || ((c != d) && e)'\'' -a 0,1,2,2,0
0
$ test-expr '\''(a >= b) || ((c != d) && e)'\'' -a 0,2,0,1,0
0
$ test-expr '\''(a >= b) || ((c != d) && e)'\'' -a 0,2,0,1,1
1
$ test-expr '\''(a >= b) || ((c != d) && e)'\'' -a 0,2,1,1,1
0
$ test-expr '\''(a >= b) || ((c != d) && e)'\'' -a 0,2,1,1,2
0
$ test-expr '\''(a >= b) || ((c != d) && e)'\'' -a 0,2,2,0,2
1
$ test-expr '\''(a >= b) || ((c != d) && e)'\'' -a 1,0,1,2,1
1
$ test-expr '\''(a >= b) || ((c != d) && e)'\'' -a 1,1,0,1,1
1
$ test-expr '\''(a >= b) || ((c != d) && e)'\'' -a 1,1,1,1,1
1
$ test-expr '\''(a >= b) || ((c != d) && e)'\'' -a 1,1,2,0,0
1
$ test-expr '\''(a >= b) || ((c != d) && e)'\'' -a 1,1,2,1,1
1
$ test-expr '\''(a >= b) || ((c != d) && e)'\'' -a 1,2,0,1,1
1
$ test-expr '\''(a >= b) || ((c != d) && e)'\'' -a 1,2,1,1,1
0
$ test-expr '\''(a >= b) || ((c != d) && e)'\'' -a 1,2,2,1,1
1
$ test-expr '\''(a >= b) || ((c != d) && e)'\'' -a 2,0,0,0,1
1
$ test-expr '\''(a >= b) || ((c != d) && e)'\'' -a 2,0,0,2,0
1
$ test-expr '\''(a >= b) || ((c != d) && e)'\'' -a 2,0,1,0,1
1
$ test-expr '\''(a >= b) || ((c != d) && e)'\'' -a 2,0,1,1,1
1
$ test-expr '\''(a >= b) || ((c != d) && e)'\'' -a 2,0,2,0,1
1
$ test-expr '\''(a >= b) || ((c != d) && e)'\'' -a 2,1,1,2,0
1
$ test-expr '\''(a >= b) || ((c != d) && e)'\'' -a 2,2,0,0,2
1
$ test-expr '\''(a >= b) || ((c != d) && e)'\'' -a 2,2,1,0,0
1
$ test-expr '\''(a >= b) || ((c != d) && e)'\'' -a 2,2,1,2,0
1
$ test-expr '\''(a >= b) || ((c != d) && e)'\'' -a 2,2,2,1,2
1
$ test-expr '\''(a >= b) || ((c && d) != e)'\'' -a 0,0,0,0,1
1
$ test-expr '\''(a >= b) || ((c && d) != e)'\'' -a 0,0,1,2,0
1
$ test-expr '\''(a >= b) || ((c && d) != e)'\'' -a 0,0,1,2,2
1
$ test-expr '\''(a >= b) || ((c && d) != e)'\'' -a 0,0,2,0,1
1
$ test-expr '\''(a >= b) || ((c && d) != e)'\'' -a 0,0,2,2,2
1
$ test-expr '\''(a >= b) || ((c && d) != e)'\'' -a 0,1,0,0,1
1
$ test-expr '\''(a >= b) || ((c && d) != e)'\'' -a 0,1,0,1,0
0
$ test-expr '\''(a >= b) || ((c && d) != e)'\'' -a 0,1,0,2,1
1
$ test-expr '\''(a >= b) || ((c && d) != e)'\'' -a 0,2,0,1,1
1
$ test-expr '\''(a >= b) || ((c && d) != e)'\'' -a 0,2,2,1,2
1
$ test-expr '\''(a >= b) || ((c && d) != e)'\'' -a 1,0,0,0,1
1
$ test-expr '\''(a >= b) || ((c && d) != e)'\'' -a 1,0,1,0,1
1
$ test-expr '\''(a >= b) || ((c && d) != e)'\'' -a 1,0,2,2,1
1
$ test-expr '\''(a >= b) || ((c && d) != e)'\'' -a 1,1,2,0,1
1
$ test-expr '\''(a >= b) || ((c && d) != e)'\'' -a 1,1,2,2,2
1
$ test-expr '\''(a >= b) || ((c && d) != e)'\'' -a 1,2,0,0,1
1
$ test-expr '\''(a >= b) || ((c && d) != e)'\'' -a 1,2,1,1,1
0
$ test-expr '\''(a >= b) || ((c && d) != e)'\'' -a 1,2,1,2,1
0
$ test-expr '\''(a >= b) || ((c && d) != e)'\'' -a 1,2,1,2,2
1
$ test-expr '\''(a >= b) || ((c && d) != e)'\'' -a 2,0,0,2,2
1
$ test-expr '\''(a >= b) || ((c && d) != e)'\'' -a 2,0,1,1,0
1
$ test-expr '\''(a >= b) || ((c && d) != e)'\'' -a 2,0,1,2,0
1
$ test-expr '\''(a >= b) || ((c && d) != e)'\'' -a 2,1,0,0,0
1
$ test-expr '\''(a >= b) || ((c && d) != e)'\'' -a 2,1,1,0,0
1
$ test-expr '\''(a >= b) || ((c && d) != e)'\'' -a 2,1,2,0,1
1
$ test-expr '\''(a >= b) || ((c && d) != e)'\'' -a 2,2,0,2,2
1
$ test-expr '\''(a >= b) || ((c && d) != e)'\'' -a 2,2,1,1,1
1
$ test-expr '\''(a >= b) || ((c && d) != e)'\'' -a 2,2,1,2,2
1
$ test-expr '\''(a >= b) || ((c && d) != e)'\'' -a 2,2,2,1,2
1
$ test-expr '\''(a >= (b != c)) && (d || e)'\'' -a 0,0,0,2,2
1
$ test-expr '\''(a >= (b != c)) && (d || e)'\'' -a 0,0,1,1,1
0
$ test-expr '\''(a >= (b != c)) && (d || e)'\'' -a 0,0,1,2,2
0
$ test-expr '\''(a >= (b != c)) && (d || e)'\'' -a 0,0,2,1,1
0
$ test-expr '\''(a >= (b != c)) && (d || e)'\'' -a 0,0,2,2,0
0
$ test-expr '\''(a >= (b != c)) && (d || e)'\'' -a 0,1,0,2,1
0
$ test-expr '\''(a >= (b != c)) && (d || e)'\'' -a 0,1,1,0,1
1
$ test-expr '\''(a >= (b != c)) && (d || e)'\'' -a 0,2,0,0,0
0
$ test-expr '\''(a >= (b != c)) && (d || e)'\'' -a 0,2,0,2,0
0
$ test-expr '\''(a >= (b != c)) && (d || e)'\'' -a 0,2,0,2,1
0
$ test-expr '\''(a >= (b != c)) && (d || e)'\'' -a 0,2,1,2,0
0
$ test-expr '\''(a >= (b != c)) && (d || e)'\'' -a 0,2,2,1,0
1
$ test-expr '\''(a >= (b != c)) && (d || e)'\'' -a 0,2,2,1,1
1
$ test-expr '\''(a >= (b != c)) && (d || e)'\'' -a 1,0,0,2,2
1
$ test-expr '\''(a >= (b != c)) && (d || e)'\'' -a 1,1,0,2,2
1
$ test-expr '\''(a >= (b != c)) && (d || e)'\'' -a 1,2,0,0,0
0
$ test-expr '\''(a >= (b != c)) && (d || e)'\'' -a 1,2,0,0,2
1
$ test-expr '\''(a >= (b != c)) && (d || e)'\'' -a 1,2,0,1,0
1
$ test-expr '\''(a >= (b != c)) && (d || e)'\'' -a 1,2,1,0,1
1
$ test-expr '\''(a >= (b != c)) && (d || e)'\'' -a 1,2,1,1,1
1
$ test-expr '\''(a >= (b != c)) && (d || e)'\'' -a 1,2,2,2,1
1
$ test-expr '\''(a >= (b != c)) && (d || e)'\'' -a 1,2,2,2,2
1
$ test-expr '\''(a >= (b != c)) && (d || e)'\'' -a 2,0,0,2,2
1
$ test-expr '\''(a >= (b != c)) && (d || e)'\'' -a 2,0,1,0,0
0
$ test-expr '\''(a >= (b != c)) && (d || e)'\'' -a 2,0,1,2,2
1
$ test-expr '\''(a >= (b != c)) && (d || e)'\'' -a 2,0,2,1,0
1
$ test-expr '\''(a >= (b != c)) && (d || e)'\'' -a 2,1,0,1,2
1
$ test-expr '\''(a >= (b != c)) && (d || e)'\'' -a 2,1,0,2,0
1
$ test-expr '\''(a >= (b != c)) && (d || e)'\'' -a 2,1,0,2,2
1
$ test-expr '\''(a >= (b != c)) && (d || e)'\'' -a 2,1,1,0,1
1
$ test-expr '\''(a >= (b != c)) && (d || e)'\'' -a 2,1,1,1,1
1
$ test-expr '\''(a >= (b != c)) && (d || e)'\'' -a 2,2,0,0,0
0
$ test-expr '\''(a >= (b != c)) && (d || e)'\'' -a 2,2,0,0,1
1
$ test-expr '\''(a >= (b != c)) && (d || e)'\'' -a 2,2,1,2,2
1
$ test-expr '\''(a >= (b != c)) && (d || e)'\'' -a 2,2,2,1,1
1
$ test-expr '\''(a >= (b != c)) || (d && e)'\'' -a 0,0,0,0,0
1
$ test-expr '\''(a >= (b != c)) || (d && e)'\'' -a 0,1,1,2,0
1
$ test-expr '\''(a >= (b != c)) || (d && e)'\'' -a 0,1,1,2,2
1
$ test-expr '\''(a >= (b != c)) || (d && e)'\'' -a 0,2,1,2,2
1
$ test-expr '\''(a >= (b != c)) || (d && e)'\'' -a 0,2,2,0,0
1
$ test-expr '\''(a >= (b != c)) || (d && e)'\'' -a 0,2,2,2,2
1
$ test-expr '\''(a >= (b != c)) || (d && e)'\'' -a 1,1,1,0,2
1
$ test-expr '\''(a >= (b != c)) || (d && e)'\'' -a 1,1,1,2,1
1
$ test-expr '\''(a >= (b != c)) || (d && e)'\'' -a 1,1,1,2,2
1
$ test-expr '\''(a >= (b != c)) || (d && e)'\'' -a 1,2,0,0,1
1
$ test-expr '\''(a >= (b != c)) || (d && e)'\'' -a 1,2,0,2,1
1
$ test-expr '\''(a >= (b != c)) || (d && e)'\'' -a 1,2,0,2,2
1
$ test-expr '\''(a >= (b != c)) || (d && e)'\'' -a 2,0,0,2,1
1
$ test-expr '\''(a >= (b != c)) || (d && e)'\'' -a 2,0,2,1,1
1
$ test-expr '\''(a >= (b != c)) || (d && e)'\'' -a 2,1,0,0,2
1
$ test-expr '\''(a >= (b != c)) || (d && e)'\'' -a 2,1,1,0,1
1
$ test-expr '\''(a >= (b != c)) || (d && e)'\'' -a 2,1,2,2,2
1
$ test-expr '\''(a >= (b != c)) || (d && e)'\'' -a 2,2,0,2,0
1
$ test-expr '\''(a >= (b != c)) || (d && e)'\'' -a 2,2,1,0,2
1
$ test-expr '\''(a >= (b != c)) || (d && e)'\'' -a 2,2,1,1,2
1
$ test-expr '\''(a >= (b != c)) || (d && e)'\'' -a 2,2,2,2,0
1
$ test-expr '\''(a >= (b != (c && d))) || e'\'' -a 0,0,2,0,1
1
$ test-expr '\''(a >= (b != (c && d))) || e'\'' -a 0,0,2,1,0
0
$ test-expr '\''(a >= (b != (c && d))) || e'\'' -a 0,0,2,1,1
1
$ test-expr '\''(a >= (b != (c && d))) || e'\'' -a 0,1,2,0,2
1
$ test-expr '\''(a >= (b != (c && d))) || e'\'' -a 0,2,2,0,1
1
$ test-expr '\''(a >= (b != (c && d))) || e'\'' -a 0,2,2,2,1
1
$ test-expr '\''(a >= (b != (c && d))) || e'\'' -a 1,0,0,0,1
1
$ test-expr '\''(a >= (b != (c && d))) || e'\'' -a 1,0,0,1,0
1
$ test-expr '\''(a >= (b != (c && d))) || e'\'' -a 1,0,2,2,1
1
$ test-expr '\''(a >= (b != (c && d))) || e'\'' -a 1,0,2,2,2
1
$ test-expr '\''(a >= (b != (c && d))) || e'\'' -a 1,1,1,0,1
1
$ test-expr '\''(a >= (b != (c && d))) || e'\'' -a 1,2,1,2,2
1
$ test-expr '\''(a >= (b != (c && d))) || e'\'' -a 2,0,0,0,2
1
$ test-expr '\''(a >= (b != (c && d))) || e'\'' -a 2,0,1,0,2
1
$ test-expr '\''(a >= (b != (c && d))) || e'\'' -a 2,0,2,1,2
1
$ test-expr '\''(a >= (b != (c && d))) || e'\'' -a 2,1,0,0,0
1
$ test-expr '\''(a >= (b != (c && d))) || e'\'' -a 2,1,0,2,2
1
$ test-expr '\''(a >= (b != (c && d))) || e'\'' -a 2,1,1,1,2
1
$ test-expr '\''(a >= (b != (c && d))) || e'\'' -a 2,1,2,0,1
1
$ test-expr '\''(a >= (b != (c && d))) || e'\'' -a 2,1,2,1,1
1
$ test-expr '\''(a >= (b != (c && d))) || e'\'' -a 2,2,0,1,0
1
$ test-expr '\''(a >= (b != (c && d))) || e'\'' -a 2,2,1,0,2
1
$ test-expr '\''(a >= (b != (c && d))) || e'\'' -a 2,2,1,1,1
1
$ test-expr '\''(a >= (b != (c && d))) || e'\'' -a 2,2,1,2,0
1
$ test-expr '\''(a >= (b != (c && d))) || e'\'' -a 2,2,2,1,2
1
$ test-expr '\''(a >= (b != (c || d))) && e'\'' -a 0,0,0,1,2
0
$ test-expr '\''(a >= (b != (c || d))) && e'\'' -a 0,0,1,0,2
0
$ test-expr '\''(a >= (b != (c || d))) && e'\'' -a 0,1,2,1,0
0
$ test-expr '\''(a >= (b != (c || d))) && e'\'' -a 0,2,0,1,1
0
$ test-expr '\''(a >= (b != (c || d))) && e'\'' -a 0,2,1,1,1
0
$ test-expr '\''(a >= (b != (c || d))) && e'\'' -a 0,2,2,1,1
0
$ test-expr '\''(a >= (b != (c || d))) && e'\'' -a 1,0,0,0,0
0
$ test-expr '\''(a >= (b != (c || d))) && e'\'' -a 1,0,0,0,1
1
$ test-expr '\''(a >= (b != (c || d))) && e'\'' -a 1,0,0,2,2
1
$ test-expr '\''(a >= (b != (c || d))) && e'\'' -a 1,0,1,1,0
0
$ test-expr '\''(a >= (b != (c || d))) && e'\'' -a 1,0,2,0,0
0
$ test-expr '\''(a >= (b != (c || d))) && e'\'' -a 1,1,0,0,0
0
$ test-expr '\''(a >= (b != (c || d))) && e'\'' -a 1,1,1,0,0
0
$ test-expr '\''(a >= (b != (c || d))) && e'\'' -a 1,1,1,0,2
1
$ test-expr '\''(a >= (b != (c || d))) && e'\'' -a 1,1,1,2,0
0
$ test-expr '\''(a >= (b != (c || d))) && e'\'' -a 1,2,0,1,0
0
$ test-expr '\''(a >= (b != (c || d))) && e'\'' -a 1,2,1,1,0
0
$ test-expr '\''(a >= (b != (c || d))) && e'\'' -a 2,0,0,1,1
1
$ test-expr '\''(a >= (b != (c || d))) && e'\'' -a 2,0,2,0,2
1
$ test-expr '\''(a >= (b != (c || d))) && e'\'' -a 2,0,2,1,0
0
$ test-expr '\''(a >= (b != (c || d))) && e'\'' -a 2,0,2,1,2
1
$ test-expr '\''(a >= (b != (c || d))) && e'\'' -a 2,0,2,2,1
1
$ test-expr '\''(a >= (b != (c || d))) && e'\'' -a 2,1,1,0,2
1
$ test-expr '\''(a >= (b != (c || d))) && e'\'' -a 2,1,2,2,0
0
$ test-expr '\''(a >= (b != (c || d))) && e'\'' -a 2,2,2,0,1
1
$ test-expr '\''(a >= (b != (c || d))) && e'\'' -a 2,2,2,1,2
1
$ test-expr '\''(a >= (b != (c || d))) && e'\'' -a 2,2,2,2,1
1
$ test-expr '\''(a >= (b && c)) != (d || e)'\'' -a 0,0,0,2,0
0
$ test-expr '\''(a >= (b && c)) != (d || e)'\'' -a 0,0,1,2,2
0
$ test-expr '\''(a >= (b && c)) != (d || e)'\'' -a 0,1,2,2,0
1
$ test-expr '\''(a >= (b && c)) != (d || e)'\'' -a 0,1,2,2,1
1
$ test-expr '\''(a >= (b && c)) != (d || e)'\'' -a 0,2,0,2,2
0
$ test-expr '\''(a >= (b && c)) != (d || e)'\'' -a 0,2,1,0,0
0
$ test-expr '\''(a >= (b && c)) != (d || e)'\'' -a 1,0,0,2,2
0
$ test-expr '\''(a >= (b && c)) != (d || e)'\'' -a 1,0,1,2,2
0
$ test-expr '\''(a >= (b && c)) != (d || e)'\'' -a 1,0,2,2,0
0
$ test-expr '\''(a >= (b && c)) != (d || e)'\'' -a 1,1,0,1,0
0
$ test-expr '\''(a >= (b && c)) != (d || e)'\'' -a 1,1,0,1,1
0
$ test-expr '\''(a >= (b && c)) != (d || e)'\'' -a 1,1,2,2,1
0
$ test-expr '\''(a >= (b && c)) != (d || e)'\'' -a 1,2,0,1,1
0
$ test-expr '\''(a >= (b && c)) != (d || e)'\'' -a 1,2,1,1,1
0
$ test-expr '\''(a >= (b && c)) != (d || e)'\'' -a 1,2,1,2,2
0
$ test-expr '\''(a >= (b && c)) != (d || e)'\'' -a 1,2,2,0,1
0
$ test-expr '\''(a >= (b && c)) != (d || e)'\'' -a 1,2,2,1,2
0
$ test-expr '\''(a >= (b && c)) != (d || e)'\'' -a 1,2,2,2,1
0
$ test-expr '\''(a >= (b && c)) != (d || e)'\'' -a 2,0,0,0,2
0
$ test-expr '\''(a >= (b && c)) != (d || e)'\'' -a 2,0,0,1,2
0
$ test-expr '\''(a >= (b && c)) != (d || e)'\'' -a 2,0,2,0,1
0
$ test-expr '\''(a >= (b && c)) != (d || e)'\'' -a 2,0,2,1,1
0
$ test-expr '\''(a >= (b && c)) != (d || e)'\'' -a 2,1,0,2,0
0
$ test-expr '\''(a >= (b && c)) != (d || e)'\'' -a 2,1,1,1,0
0
$ test-expr '\''(a >= (b && c)) != (d || e)'\'' -a 2,1,1,1,2
0
$ test-expr '\''(a >= (b && c)) != (d || e)'\'' -a 2,1,1,2,2
0
$ test-expr '\''(a >= (b && c)) != (d || e)'\'' -a 2,1,2,0,1
0
$ test-expr '\''(a >= (b && c)) != (d || e)'\'' -a 2,1,2,2,2
0
$ test-expr '\''(a >= (b && c)) != (d || e)'\'' -a 2,2,0,1,2
0
$ test-expr '\''(a >= (b && c)) != (d || e)'\'' -a 2,2,1,1,2
0
$ test-expr '\''(a >= (b && c)) || (d != e)'\'' -a 0,0,0,0,0
1
$ test-expr '\''(a >= (b && c)) || (d != e)'\'' -a 0,0,1,1,0
1
$ test-expr '\''(a >= (b && c)) || (d != e)'\'' -a 0,0,1,1,2
1
$ test-expr '\''(a >= (b && c)) || (d != e)'\'' -a 0,0,1,2,0
1
$ test-expr '\''(a >= (b && c)) || (d != e)'\'' -a 0,0,2,1,0
1
$ test-expr '\''(a >= (b && c)) || (d != e)'\'' -a 0,0,2,1,2
1
$ test-expr '\''(a >= (b && c)) || (d != e)'\'' -a 0,1,0,1,1
1
$ test-expr '\''(a >= (b && c)) || (d != e)'\'' -a 0,1,0,1,2
1
$ test-expr '\''(a >= (b && c)) || (d != e)'\'' -a 0,1,0,2,2
1
$ test-expr '\''(a >= (b && c)) || (d != e)'\'' -a 0,2,0,1,0
1
$ test-expr '\''(a >= (b && c)) || (d != e)'\'' -a 0,2,1,1,1
0
$ test-expr '\''(a >= (b && c)) || (d != e)'\'' -a 1,0,0,1,2
1
$ test-expr '\''(a >= (b && c)) || (d != e)'\'' -a 1,0,2,0,0
1
$ test-expr '\''(a >= (b && c)) || (d != e)'\'' -a 1,1,1,0,0
1
$ test-expr '\''(a >= (b && c)) || (d != e)'\'' -a 1,1,1,1,0
1
$ test-expr '\''(a >= (b && c)) || (d != e)'\'' -a 1,2,0,0,0
1
$ test-expr '\''(a >= (b && c)) || (d != e)'\'' -a 1,2,1,1,2
1
$ test-expr '\''(a >= (b && c)) || (d != e)'\'' -a 1,2,2,2,0
1
$ test-expr '\''(a >= (b && c)) || (d != e)'\'' -a 2,0,2,0,2
1
$ test-expr '\''(a >= (b && c)) || (d != e)'\'' -a 2,1,0,2,2
1
$ test-expr '\''(a >= (b && c)) || (d != e)'\'' -a 2,1,1,1,0
1
$ test-expr '\''(a >= (b && c)) || (d != e)'\'' -a 2,1,1,1,1
1
$ test-expr '\''(a >= (b && c)) || (d != e)'\'' -a 2,1,1,1,2
1
$ test-expr '\''(a >= (b && c)) || (d != e)'\'' -a 2,1,1,2,0
1
$ test-expr '\''(a >= (b && c)) || (d != e)'\'' -a 2,1,1,2,2
1
$ test-expr '\''(a >= (b && c)) || (d != e)'\'' -a 2,1,2,1,2
1
$ test-expr '\''(a >= (b && c)) || (d != e)'\'' -a 2,2,1,0,0
1
$ test-expr '\''(a >= (b && c)) || (d != e)'\'' -a 2,2,2,0,2
1
$ test-expr '\''(a >= (b && c)) || (d != e)'\'' -a 2,2,2,1,1
1
$ test-expr '\''(a >= (b && (c != d))) || e'\'' -a 0,0,0,0,1
1
$ test-expr '\''(a >= (b && (c != d))) || e'\'' -a 0,0,2,1,2
1
$ test-expr '\''(a >= (b && (c != d))) || e'\'' -a 0,1,0,1,2
1
$ test-expr '\''(a >= (b && (c != d))) || e'\'' -a 0,1,2,1,2
1
$ test-expr '\''(a >= (b && (c != d))) || e'\'' -a 0,2,1,2,2
1
$ test-expr '\''(a >= (b && (c != d))) || e'\'' -a 0,2,2,0,0
0
$ test-expr '\''(a >= (b && (c != d))) || e'\'' -a 0,2,2,1,0
0
$ test-expr '\''(a >= (b && (c != d))) || e'\'' -a 0,2,2,2,2
1
$ test-expr '\''(a >= (b && (c != d))) || e'\'' -a 1,0,0,1,1
1
$ test-expr '\''(a >= (b && (c != d))) || e'\'' -a 1,0,0,1,2
1
$ test-expr '\''(a >= (b && (c != d))) || e'\'' -a 1,0,0,2,0
1
$ test-expr '\''(a >= (b && (c != d))) || e'\'' -a 1,1,1,0,0
1
$ test-expr '\''(a >= (b && (c != d))) || e'\'' -a 1,1,1,2,2
1
$ test-expr '\''(a >= (b && (c != d))) || e'\'' -a 1,2,1,0,2
1
$ test-expr '\''(a >= (b && (c != d))) || e'\'' -a 1,2,2,2,2
1
$ test-expr '\''(a >= (b && (c != d))) || e'\'' -a 2,0,1,1,1
1
$ test-expr '\''(a >= (b && (c != d))) || e'\'' -a 2,0,1,2,1
1
$ test-expr '\''(a >= (b && (c != d))) || e'\'' -a 2,0,2,2,1
1
$ test-expr '\''(a >= (b && (c != d))) || e'\'' -a 2,1,1,1,0
1
$ test-expr '\''(a >= (b && (c != d))) || e'\'' -a 2,1,1,1,2
1
$ test-expr '\''(a >= (b && (c != d))) || e'\'' -a 2,1,2,2,0
1
$ test-expr '\''(a >= (b && (c != d))) || e'\'' -a 2,1,2,2,2
1
$ test-expr '\''(a >= (b && (c != d))) || e'\'' -a 2,2,1,2,0
1
$ test-expr '\''(a >= (b && (c != d))) || e'\'' -a 2,2,1,2,1
1
$ test-expr '\''(a >= (b && (c != d))) || e'\'' -a 2,2,2,0,1
1
$ test-expr '\''(a >= (b && (c || d))) != e'\'' -a 0,0,1,2,1
0
$ test-expr '\''(a >= (b && (c || d))) != e'\'' -a 0,0,2,2,1
0
$ test-expr '\''(a >= (b && (c || d))) != e'\'' -a 0,1,0,0,1
0
$ test-expr '\''(a >= (b && (c || d))) != e'\'' -a 0,1,1,0,0
0
$ test-expr '\''(a >= (b && (c || d))) != e'\'' -a 0,1,2,1,1
1
$ test-expr '\''(a >= (b && (c || d))) != e'\'' -a 0,1,2,2,2
1
$ test-expr '\''(a >= (b && (c || d))) != e'\'' -a 0,2,0,0,2
1
$ test-expr '\''(a >= (b && (c || d))) != e'\'' -a 0,2,0,1,2
1
$ test-expr '\''(a >= (b && (c || d))) != e'\'' -a 0,2,0,2,2
1
$ test-expr '\''(a >= (b && (c || d))) != e'\'' -a 0,2,2,0,0
0
$ test-expr '\''(a >= (b && (c || d))) != e'\'' -a 0,2,2,1,2
1
$ test-expr '\''(a >= (b && (c || d))) != e'\'' -a 0,2,2,2,1
1
$ test-expr '\''(a >= (b && (c || d))) != e'\'' -a 1,0,0,2,1
0
$ test-expr '\''(a >= (b && (c || d))) != e'\'' -a 1,0,0,2,2
1
$ test-expr '\''(a >= (b && (c || d))) != e'\'' -a 1,0,2,0,0
1
$ test-expr '\''(a >= (b && (c || d))) != e'\'' -a 1,1,0,2,2
1
$ test-expr '\''(a >= (b && (c || d))) != e'\'' -a 1,1,2,2,1
0
$ test-expr '\''(a >= (b && (c || d))) != e'\'' -a 1,2,1,0,0
1
$ test-expr '\''(a >= (b && (c || d))) != e'\'' -a 1,2,1,2,0
1
$ test-expr '\''(a >= (b && (c || d))) != e'\'' -a 1,2,2,1,1
0
$ test-expr '\''(a >= (b && (c || d))) != e'\'' -a 2,0,0,2,1
0
$ test-expr '\''(a >= (b && (c || d))) != e'\'' -a 2,0,1,1,1
0
$ test-expr '\''(a >= (b && (c || d))) != e'\'' -a 2,0,2,0,0
1
$ test-expr '\''(a >= (b && (c || d))) != e'\'' -a 2,1,0,2,0
1
$ test-expr '\''(a >= (b && (c || d))) != e'\'' -a 2,2,1,2,0
1
$ test-expr '\''(a >= (b && (c || d))) != e'\'' -a 2,2,1,2,2
1
$ test-expr '\''(a >= (b && (c || d))) != e'\'' -a 2,2,2,0,2
1
$ test-expr '\''(a >= (b || c)) != (d && e)'\'' -a 0,0,0,0,2
1
$ test-expr '\''(a >= (b || c)) != (d && e)'\'' -a 0,0,1,1,0
0
$ test-expr '\''(a >= (b || c)) != (d && e)'\'' -a 0,0,1,1,1
1
$ test-expr '\''(a >= (b || c)) != (d && e)'\'' -a 0,0,2,1,0
0
$ test-expr '\''(a >= (b || c)) != (d && e)'\'' -a 0,1,0,1,0
0
$ test-expr '\''(a >= (b || c)) != (d && e)'\'' -a 0,1,2,0,1
0
$ test-expr '\''(a >= (b || c)) != (d && e)'\'' -a 0,2,0,0,2
0
$ test-expr '\''(a >= (b || c)) != (d && e)'\'' -a 0,2,1,2,1
1
$ test-expr '\''(a >= (b || c)) != (d && e)'\'' -a 0,2,2,2,1
1
$ test-expr '\''(a >= (b || c)) != (d && e)'\'' -a 1,0,0,0,1
1
$ test-expr '\''(a >= (b || c)) != (d && e)'\'' -a 1,0,1,2,0
1
$ test-expr '\''(a >= (b || c)) != (d && e)'\'' -a 1,1,0,0,2
1
$ test-expr '\''(a >= (b || c)) != (d && e)'\'' -a 1,1,0,1,0
1
$ test-expr '\''(a >= (b || c)) != (d && e)'\'' -a 1,1,1,0,1
1
$ test-expr '\''(a >= (b || c)) != (d && e)'\'' -a 1,2,0,0,0
1
$ test-expr '\''(a >= (b || c)) != (d && e)'\'' -a 1,2,2,0,2
1
$ test-expr '\''(a >= (b || c)) != (d && e)'\'' -a 1,2,2,2,0
1
$ test-expr '\''(a >= (b || c)) != (d && e)'\'' -a 1,2,2,2,2
0
$ test-expr '\''(a >= (b || c)) != (d && e)'\'' -a 2,0,0,0,2
1
$ test-expr '\''(a >= (b || c)) != (d && e)'\'' -a 2,0,0,2,2
0
$ test-expr '\''(a >= (b || c)) != (d && e)'\'' -a 2,0,1,1,0
1
$ test-expr '\''(a >= (b || c)) != (d && e)'\'' -a 2,0,1,1,1
0
$ test-expr '\''(a >= (b || c)) != (d && e)'\'' -a 2,0,1,2,2
0
$ test-expr '\''(a >= (b || c)) != (d && e)'\'' -a 2,0,2,1,0
1
$ test-expr '\''(a >= (b || c)) != (d && e)'\'' -a 2,1,1,0,2
1
$ test-expr '\''(a >= (b || c)) != (d && e)'\'' -a 2,1,1,1,0
1
$ test-expr '\''(a >= (b || c)) != (d && e)'\'' -a 2,1,2,0,1
1
$ test-expr '\''(a >= (b || c)) != (d && e)'\'' -a 2,1,2,0,2
1
$ test-expr '\''(a >= (b || c)) != (d && e)'\'' -a 2,1,2,1,0
1
$ test-expr '\''(a >= (b || c)) != (d && e)'\'' -a 2,2,0,1,0
1
$ test-expr '\''(a >= (b || c)) != (d && e)'\'' -a 2,2,0,2,0
1
$ test-expr '\''(a >= (b || c)) != (d && e)'\'' -a 2,2,2,0,0
1
$ test-expr '\''(a >= (b || c)) != (d && e)'\'' -a 2,2,2,1,1
0
$ test-expr '\''(a >= (b || c)) && (d != e)'\'' -a 0,0,1,1,0
0
$ test-expr '\''(a >= (b || c)) && (d != e)'\'' -a 0,0,1,1,2
0
$ test-expr '\''(a >= (b || c)) && (d != e)'\'' -a 0,0,2,1,2
0
$ test-expr '\''(a >= (b || c)) && (d != e)'\'' -a 0,1,0,0,2
0
$ test-expr '\''(a >= (b || c)) && (d != e)'\'' -a 0,1,0,1,0
0
$ test-expr '\''(a >= (b || c)) && (d != e)'\'' -a 0,1,0,1,1
0
$ test-expr '\''(a >= (b || c)) && (d != e)'\'' -a 0,1,2,2,2
0
$ test-expr '\''(a >= (b || c)) && (d != e)'\'' -a 0,2,1,2,1
0
$ test-expr '\''(a >= (b || c)) && (d != e)'\'' -a 0,2,1,2,2
0
$ test-expr '\''(a >= (b || c)) && (d != e)'\'' -a 0,2,2,1,0
0
$ test-expr '\''(a >= (b || c)) && (d != e)'\'' -a 0,2,2,1,1
0
$ test-expr '\''(a >= (b || c)) && (d != e)'\'' -a 1,0,0,1,1
0
$ test-expr '\''(a >= (b || c)) && (d != e)'\'' -a 1,0,2,2,0
1
$ test-expr '\''(a >= (b || c)) && (d != e)'\'' -a 1,1,0,0,1
1
$ test-expr '\''(a >= (b || c)) && (d != e)'\'' -a 1,1,1,0,1
1
$ test-expr '\''(a >= (b || c)) && (d != e)'\'' -a 1,1,1,1,1
0
$ test-expr '\''(a >= (b || c)) && (d != e)'\'' -a 1,2,1,0,0
0
$ test-expr '\''(a >= (b || c)) && (d != e)'\'' -a 1,2,1,1,2
1
$ test-expr '\''(a >= (b || c)) && (d != e)'\'' -a 1,2,2,1,1
0
$ test-expr '\''(a >= (b || c)) && (d != e)'\'' -a 1,2,2,2,1
1
$ test-expr '\''(a >= (b || c)) && (d != e)'\'' -a 2,0,0,0,2
1
$ test-expr '\''(a >= (b || c)) && (d != e)'\'' -a 2,0,0,2,1
1
$ test-expr '\''(a >= (b || c)) && (d != e)'\'' -a 2,0,1,1,0
1
$ test-expr '\''(a >= (b || c)) && (d != e)'\'' -a 2,0,1,2,2
0
$ test-expr '\''(a >= (b || c)) && (d != e)'\'' -a 2,0,2,1,1
0
$ test-expr '\''(a >= (b || c)) && (d != e)'\'' -a 2,0,2,1,2
1
$ test-expr '\''(a >= (b || c)) && (d != e)'\'' -a 2,1,0,0,0
0
$ test-expr '\''(a >= (b || c)) && (d != e)'\'' -a 2,1,0,2,1
1
$ test-expr '\''(a >= (b || c)) && (d != e)'\'' -a 2,1,1,0,0
0
$ test-expr '\''(a >= (b || c)) && (d != e)'\'' -a 2,1,2,1,0
1
$ test-expr '\''(a >= (b || c)) && (d != e)'\'' -a 2,2,0,1,0
1
$ test-expr '\''(a >= (b || c)) && (d != e)'\'' -a 2,2,0,2,2
0
$ test-expr '\''(a >= (b || c)) && (d != e)'\'' -a 2,2,1,1,2
1
$ test-expr '\''(a >= (b || c)) && (d != e)'\'' -a 2,2,2,0,0
0
$ test-expr '\''(a >= (b || (c != d))) && e'\'' -a 0,0,0,1,0
0
$ test-expr '\''(a >= (b || (c != d))) && e'\'' -a 0,0,1,0,2
0
$ test-expr '\''(a >= (b || (c != d))) && e'\'' -a 0,0,2,1,0
0
$ test-expr '\''(a >= (b || (c != d))) && e'\'' -a 0,0,2,1,2
0
$ test-expr '\''(a >= (b || (c != d))) && e'\'' -a 0,0,2,2,0
0
$ test-expr '\''(a >= (b || (c != d))) && e'\'' -a 0,1,0,0,0
0
$ test-expr '\''(a >= (b || (c != d))) && e'\'' -a 0,1,0,0,1
0
$ test-expr '\''(a >= (b || (c != d))) && e'\'' -a 0,1,0,2,1
0
$ test-expr '\''(a >= (b || (c != d))) && e'\'' -a 0,1,1,0,2
0
$ test-expr '\''(a >= (b || (c != d))) && e'\'' -a 0,1,2,0,1
0
$ test-expr '\''(a >= (b || (c != d))) && e'\'' -a 0,1,2,2,2
0
$ test-expr '\''(a >= (b || (c != d))) && e'\'' -a 0,2,0,2,2
0
$ test-expr '\''(a >= (b || (c != d))) && e'\'' -a 1,0,0,2,2
1
$ test-expr '\''(a >= (b || (c != d))) && e'\'' -a 1,0,2,0,1
1
$ test-expr '\''(a >= (b || (c != d))) && e'\'' -a 1,1,1,0,2
1
$ test-expr '\''(a >= (b || (c != d))) && e'\'' -a 1,1,1,1,1
1
$ test-expr '\''(a >= (b || (c != d))) && e'\'' -a 1,1,1,2,1
1
$ test-expr '\''(a >= (b || (c != d))) && e'\'' -a 1,1,2,0,0
0
$ test-expr '\''(a >= (b || (c != d))) && e'\'' -a 1,1,2,1,1
1
$ test-expr '\''(a >= (b || (c != d))) && e'\'' -a 1,1,2,1,2
1
$ test-expr '\''(a >= (b || (c != d))) && e'\'' -a 1,2,0,0,0
0
$ test-expr '\''(a >= (b || (c != d))) && e'\'' -a 1,2,0,2,1
1
$ test-expr '\''(a >= (b || (c != d))) && e'\'' -a 1,2,1,0,2
1
$ test-expr '\''(a >= (b || (c != d))) && e'\'' -a 1,2,2,1,1
1
$ test-expr '\''(a >= (b || (c != d))) && e'\'' -a 2,0,0,0,2
1
$ test-expr '\''(a >= (b || (c != d))) && e'\'' -a 2,0,2,0,1
1
$ test-expr '\''(a >= (b || (c != d))) && e'\'' -a 2,1,1,2,0
0
$ test-expr '\''(a >= (b || (c != d))) && e'\'' -a 2,1,1,2,1
1
$ test-expr '\''(a >= (b || (c != d))) && e'\'' -a 2,1,1,2,2
1
$ test-expr '\''(a >= (b || (c != d))) && e'\'' -a 2,1,2,0,1
1
$ test-expr '\''(a >= (b || (c != d))) && e'\'' -a 2,2,0,1,0
0
$ test-expr '\''(a >= (b || (c != d))) && e'\'' -a 2,2,0,2,2
1
$ test-expr '\''(a >= (b || (c != d))) && e'\'' -a 2,2,1,0,2
1
$ test-expr '\''(a >= (b || (c && d))) != e'\'' -a 0,0,1,0,2
1
$ test-expr '\''(a >= (b || (c && d))) != e'\'' -a 0,0,1,1,0
0
$ test-expr '\''(a >= (b || (c && d))) != e'\'' -a 0,0,1,1,1
1
$ test-expr '\''(a >= (b || (c && d))) != e'\'' -a 0,0,2,1,0
0
$ test-expr '\''(a >= (b || (c && d))) != e'\'' -a 0,0,2,2,1
1
$ test-expr '\''(a >= (b || (c && d))) != e'\'' -a 0,1,0,2,0
0
$ test-expr '\''(a >= (b || (c && d))) != e'\'' -a 0,1,1,2,1
1
$ test-expr '\''(a >= (b || (c && d))) != e'\'' -a 0,1,2,1,1
1
$ test-expr '\''(a >= (b || (c && d))) != e'\'' -a 0,2,0,2,0
0
$ test-expr '\''(a >= (b || (c && d))) != e'\'' -a 1,0,0,1,2
1
$ test-expr '\''(a >= (b || (c && d))) != e'\'' -a 1,0,0,2,2
1
$ test-expr '\''(a >= (b || (c && d))) != e'\'' -a 1,0,1,1,2
1
$ test-expr '\''(a >= (b || (c && d))) != e'\'' -a 1,0,2,1,2
1
$ test-expr '\''(a >= (b || (c && d))) != e'\'' -a 1,0,2,2,1
0
$ test-expr '\''(a >= (b || (c && d))) != e'\'' -a 1,1,0,0,1
0
$ test-expr '\''(a >= (b || (c && d))) != e'\'' -a 1,1,0,2,0
1
$ test-expr '\''(a >= (b || (c && d))) != e'\'' -a 1,1,1,2,1
0
$ test-expr '\''(a >= (b || (c && d))) != e'\'' -a 1,1,2,0,1
0
$ test-expr '\''(a >= (b || (c && d))) != e'\'' -a 1,2,1,0,0
1
$ test-expr '\''(a >= (b || (c && d))) != e'\'' -a 1,2,1,0,1
0
$ test-expr '\''(a >= (b || (c && d))) != e'\'' -a 1,2,2,0,1
0
$ test-expr '\''(a >= (b || (c && d))) != e'\'' -a 1,2,2,1,0
1
$ test-expr '\''(a >= (b || (c && d))) != e'\'' -a 1,2,2,1,1
0
$ test-expr '\''(a >= (b || (c && d))) != e'\'' -a 1,2,2,1,2
1
$ test-expr '\''(a >= (b || (c && d))) != e'\'' -a 2,0,0,0,2
1
$ test-expr '\''(a >= (b || (c && d))) != e'\'' -a 2,0,1,0,0
1
$ test-expr '\''(a >= (b || (c && d))) != e'\'' -a 2,0,2,1,2
1
$ test-expr '\''(a >= (b || (c && d))) != e'\'' -a 2,1,0,2,0
1
$ test-expr '\''(a >= (b || (c && d))) != e'\'' -a 2,2,1,1,0
1
$ test-expr '\''(a >= (b || (c && d))) != e'\'' -a 2,2,1,2,0
1
$ test-expr '\''(a >= (b || (c && d))) != e'\'' -a 2,2,2,2,0
1
$ test-expr '\''(a >= ((b != c) && d)) || e'\'' -a 0,0,0,2,2
1
$ test-expr '\''(a >= ((b != c) && d)) || e'\'' -a 0,0,2,1,0
0
$ test-expr '\''(a >= ((b != c) && d)) || e'\'' -a 0,0,2,1,2
1
$ test-expr '\''(a >= ((b != c) && d)) || e'\'' -a 0,0,2,2,2
1
$ test-expr '\''(a >= ((b != c) && d)) || e'\'' -a 0,1,0,0,0
1
$ test-expr '\''(a >= ((b != c) && d)) || e'\'' -a 0,1,0,1,2
1
$ test-expr '\''(a >= ((b != c) && d)) || e'\'' -a 0,2,0,0,0
1
$ test-expr '\''(a >= ((b != c) && d)) || e'\'' -a 0,2,0,1,2
1
$ test-expr '\''(a >= ((b != c) && d)) || e'\'' -a 0,2,1,1,2
1
$ test-expr '\''(a >= ((b != c) && d)) || e'\'' -a 1,0,0,0,1
1
$ test-expr '\''(a >= ((b != c) && d)) || e'\'' -a 1,0,0,1,0
1
$ test-expr '\''(a >= ((b != c) && d)) || e'\'' -a 1,1,1,1,2
1
$ test-expr '\''(a >= ((b != c) && d)) || e'\'' -a 1,1,2,2,2
1
$ test-expr '\''(a >= ((b != c) && d)) || e'\'' -a 1,2,0,2,2
1
$ test-expr '\''(a >= ((b != c) && d)) || e'\'' -a 1,2,1,0,1
1
$ test-expr '\''(a >= ((b != c) && d)) || e'\'' -a 2,0,2,1,2
1
$ test-expr '\''(a >= ((b != c) && d)) || e'\'' -a 2,1,0,0,1
1
$ test-expr '\''(a >= ((b != c) && d)) || e'\'' -a 2,1,1,0,2
1
$ test-expr '\''(a >= ((b != c) && d)) || e'\'' -a 2,1,1,1,1
1
$ test-expr '\''(a >= ((b != c) && d)) || e'\'' -a 2,1,1,2,1
1
$ test-expr '\''(a >= ((b != c) && d)) || e'\'' -a 2,1,2,1,2
1
$ test-expr '\''(a >= ((b != c) && d)) || e'\'' -a 2,2,0,2,2
1
$ test-expr '\''(a >= ((b != c) && d)) || e'\'' -a 2,2,2,0,0
1
$ test-expr '\''(a >= ((b != c) && d)) || e'\'' -a 2,2,2,2,1
1
$ test-expr '\''(a >= ((b != c) || d)) && e'\'' -a 0,0,0,0,1
1
$ test-expr '\''(a >= ((b != c) || d)) && e'\'' -a 0,0,2,2,0
0
$ test-expr '\''(a >= ((b != c) || d)) && e'\'' -a 0,1,0,0,2
0
$ test-expr '\''(a >= ((b != c) || d)) && e'\'' -a 0,1,0,1,1
0
$ test-expr '\''(a >= ((b != c) || d)) && e'\'' -a 0,2,0,0,2
0
$ test-expr '\''(a >= ((b != c) || d)) && e'\'' -a 0,2,0,1,0
0
$ test-expr '\''(a >= ((b != c) || d)) && e'\'' -a 0,2,0,2,2
0
$ test-expr '\''(a >= ((b != c) || d)) && e'\'' -a 1,0,0,2,0
0
$ test-expr '\''(a >= ((b != c) || d)) && e'\'' -a 1,0,1,1,0
0
$ test-expr '\''(a >= ((b != c) || d)) && e'\'' -a 1,0,1,1,1
1
$ test-expr '\''(a >= ((b != c) || d)) && e'\'' -a 1,1,0,0,1
1
$ test-expr '\''(a >= ((b != c) || d)) && e'\'' -a 1,1,1,1,2
1
$ test-expr '\''(a >= ((b != c) || d)) && e'\'' -a 1,1,2,1,0
0
$ test-expr '\''(a >= ((b != c) || d)) && e'\'' -a 1,1,2,1,1
1
$ test-expr '\''(a >= ((b != c) || d)) && e'\'' -a 1,2,0,0,2
1
$ test-expr '\''(a >= ((b != c) || d)) && e'\'' -a 1,2,2,1,0
0
$ test-expr '\''(a >= ((b != c) || d)) && e'\'' -a 1,2,2,2,1
1
$ test-expr '\''(a >= ((b != c) || d)) && e'\'' -a 1,2,2,2,2
1
$ test-expr '\''(a >= ((b != c) || d)) && e'\'' -a 2,0,1,2,1
1
$ test-expr '\''(a >= ((b != c) || d)) && e'\'' -a 2,0,2,0,0
0
$ test-expr '\''(a >= ((b != c) || d)) && e'\'' -a 2,0,2,1,0
0
$ test-expr '\''(a >= ((b != c) || d)) && e'\'' -a 2,1,0,0,2
1
$ test-expr '\''(a >= ((b != c) || d)) && e'\'' -a 2,1,0,2,2
1
$ test-expr '\''(a >= ((b != c) || d)) && e'\'' -a 2,1,2,1,1
1
$ test-expr '\''(a >= ((b != c) || d)) && e'\'' -a 2,2,1,0,0
0
$ test-expr '\''(a >= ((b != c) || d)) && e'\'' -a 2,2,1,2,1
1
$ test-expr '\''(a >= ((b != c) || d)) && e'\'' -a 2,2,2,0,2
1
$ test-expr '\''(a >= ((b != c) || d)) && e'\'' -a 2,2,2,2,0
0
$ test-expr '\''(a >= ((b && c) != d)) || e'\'' -a 0,0,0,0,1
1
$ test-expr '\''(a >= ((b && c) != d)) || e'\'' -a 0,0,2,0,1
1
$ test-expr '\''(a >= ((b && c) != d)) || e'\'' -a 0,0,2,2,2
1
$ test-expr '\''(a >= ((b && c) != d)) || e'\'' -a 0,1,0,0,0
1
$ test-expr '\''(a >= ((b && c) != d)) || e'\'' -a 0,2,0,1,0
0
$ test-expr '\''(a >= ((b && c) != d)) || e'\'' -a 1,0,0,0,1
1
$ test-expr '\''(a >= ((b && c) != d)) || e'\'' -a 1,0,0,0,2
1
$ test-expr '\''(a >= ((b && c) != d)) || e'\'' -a 1,1,0,1,1
1
$ test-expr '\''(a >= ((b && c) != d)) || e'\'' -a 1,1,0,2,2
1
$ test-expr '\''(a >= ((b && c) != d)) || e'\'' -a 1,1,1,2,0
1
$ test-expr '\''(a >= ((b && c) != d)) || e'\'' -a 1,1,1,2,1
1
$ test-expr '\''(a >= ((b && c) != d)) || e'\'' -a 1,1,2,1,2
1
$ test-expr '\''(a >= ((b && c) != d)) || e'\'' -a 1,1,2,2,1
1
$ test-expr '\''(a >= ((b && c) != d)) || e'\'' -a 1,2,0,0,0
1
$ test-expr '\''(a >= ((b && c) != d)) || e'\'' -a 1,2,0,0,2
1
$ test-expr '\''(a >= ((b && c) != d)) || e'\'' -a 1,2,0,2,0
1
$ test-expr '\''(a >= ((b && c) != d)) || e'\'' -a 1,2,0,2,1
1
$ test-expr '\''(a >= ((b && c) != d)) || e'\'' -a 1,2,1,1,2
1
$ test-expr '\''(a >= ((b && c) != d)) || e'\'' -a 2,0,2,0,2
1
$ test-expr '\''(a >= ((b && c) != d)) || e'\'' -a 2,1,0,0,0
1
$ test-expr '\''(a >= ((b && c) != d)) || e'\'' -a 2,1,0,1,1
1
$ test-expr '\''(a >= ((b && c) != d)) || e'\'' -a 2,1,1,2,0
1
$ test-expr '\''(a >= ((b && c) != d)) || e'\'' -a 2,2,0,1,2
1
$ test-expr '\''(a >= ((b && c) != d)) || e'\'' -a 2,2,0,2,1
1
$ test-expr '\''(a >= ((b && c) != d)) || e'\'' -a 2,2,1,0,0
1
$ test-expr '\''(a >= ((b && c) || d)) != e'\'' -a 0,0,0,1,0
0
$ test-expr '\''(a >= ((b && c) || d)) != e'\'' -a 0,0,1,0,0
1
$ test-expr '\''(a >= ((b && c) || d)) != e'\'' -a 0,0,1,1,0
0
$ test-expr '\''(a >= ((b && c) || d)) != e'\'' -a 0,0,1,1,1
1
$ test-expr '\''(a >= ((b && c) || d)) != e'\'' -a 0,0,1,2,1
1
$ test-expr '\''(a >= ((b && c) || d)) != e'\'' -a 0,1,0,0,2
1
$ test-expr '\''(a >= ((b && c) || d)) != e'\'' -a 0,1,0,2,0
0
$ test-expr '\''(a >= ((b && c) || d)) != e'\'' -a 0,1,0,2,2
1
$ test-expr '\''(a >= ((b && c) || d)) != e'\'' -a 0,1,2,0,2
1
$ test-expr '\''(a >= ((b && c) || d)) != e'\'' -a 0,2,0,2,1
1
$ test-expr '\''(a >= ((b && c) || d)) != e'\'' -a 0,2,1,2,0
0
$ test-expr '\''(a >= ((b && c) || d)) != e'\'' -a 0,2,2,0,2
1
$ test-expr '\''(a >= ((b && c) || d)) != e'\'' -a 0,2,2,2,2
1
$ test-expr '\''(a >= ((b && c) || d)) != e'\'' -a 1,0,1,0,0
1
$ test-expr '\''(a >= ((b && c) || d)) != e'\'' -a 1,0,1,1,0
1
$ test-expr '\''(a >= ((b && c) || d)) != e'\'' -a 1,0,2,2,1
0
$ test-expr '\''(a >= ((b && c) || d)) != e'\'' -a 1,1,0,2,1
0
$ test-expr '\''(a >= ((b && c) || d)) != e'\'' -a 1,1,2,1,2
1
$ test-expr '\''(a >= ((b && c) || d)) != e'\'' -a 1,1,2,2,0
1
$ test-expr '\''(a >= ((b && c) || d)) != e'\'' -a 1,1,2,2,1
0
$ test-expr '\''(a >= ((b && c) || d)) != e'\'' -a 1,2,0,0,1
0
$ test-expr '\''(a >= ((b && c) || d)) != e'\'' -a 2,0,2,0,1
0
$ test-expr '\''(a >= ((b && c) || d)) != e'\'' -a 2,1,2,2,2
1
$ test-expr '\''(a >= ((b && c) || d)) != e'\'' -a 2,2,0,0,1
0
$ test-expr '\''(a >= ((b && c) || d)) != e'\'' -a 2,2,0,1,0
1
$ test-expr '\''(a >= ((b && c) || d)) != e'\'' -a 2,2,1,2,2
1
$ test-expr '\''(a >= ((b && c) || d)) != e'\'' -a 2,2,2,2,0
1
$ test-expr '\''(a >= ((b && c) || d)) != e'\'' -a 2,2,2,2,1
0
$ test-expr '\''(a >= ((b || c) != d)) && e'\'' -a 0,0,2,2,1
0
$ test-expr '\''(a >= ((b || c) != d)) && e'\'' -a 0,0,2,2,2
0
$ test-expr '\''(a >= ((b || c) != d)) && e'\'' -a 0,1,1,1,1
1
$ test-expr '\''(a >= ((b || c) != d)) && e'\'' -a 0,1,2,1,1
1
$ test-expr '\''(a >= ((b || c) != d)) && e'\'' -a 0,2,2,0,1
0
$ test-expr '\''(a >= ((b || c) != d)) && e'\'' -a 1,0,0,1,1
1
$ test-expr '\''(a >= ((b || c) != d)) && e'\'' -a 1,0,0,1,2
1
$ test-expr '\''(a >= ((b || c) != d)) && e'\'' -a 1,0,1,1,0
0
$ test-expr '\''(a >= ((b || c) != d)) && e'\'' -a 1,0,1,2,0
0
$ test-expr '\''(a >= ((b || c) != d)) && e'\'' -a 1,0,2,1,0
0
$ test-expr '\''(a >= ((b || c) != d)) && e'\'' -a 1,0,2,2,2
1
$ test-expr '\''(a >= ((b || c) != d)) && e'\'' -a 1,1,0,0,2
1
$ test-expr '\''(a >= ((b || c) != d)) && e'\'' -a 1,1,1,1,0
0
$ test-expr '\''(a >= ((b || c) != d)) && e'\'' -a 1,2,1,0,1
1
$ test-expr '\''(a >= ((b || c) != d)) && e'\'' -a 1,2,1,2,0
0
$ test-expr '\''(a >= ((b || c) != d)) && e'\'' -a 1,2,2,2,1
1
$ test-expr '\''(a >= ((b || c) != d)) && e'\'' -a 1,2,2,2,2
1
$ test-expr '\''(a >= ((b || c) != d)) && e'\'' -a 2,0,0,0,1
1
$ test-expr '\''(a >= ((b || c) != d)) && e'\'' -a 2,0,0,1,1
1
$ test-expr '\''(a >= ((b || c) != d)) && e'\'' -a 2,1,1,2,1
1
$ test-expr '\''(a >= ((b || c) != d)) && e'\'' -a 2,1,2,1,1
1
$ test-expr '\''(a >= ((b || c) != d)) && e'\'' -a 2,2,2,2,2
1
$ test-expr '\''(a >= ((b || c) && d)) != e'\'' -a 0,0,0,2,1
0
$ test-expr '\''(a >= ((b || c) && d)) != e'\'' -a 0,0,0,2,2
1
$ test-expr '\''(a >= ((b || c) && d)) != e'\'' -a 0,0,1,2,1
1
$ test-expr '\''(a >= ((b || c) && d)) != e'\'' -a 0,0,2,0,0
1
$ test-expr '\''(a >= ((b || c) && d)) != e'\'' -a 0,1,1,2,1
1
$ test-expr '\''(a >= ((b || c) && d)) != e'\'' -a 0,1,2,0,0
1
$ test-expr '\''(a >= ((b || c) && d)) != e'\'' -a 0,2,0,0,1
0
$ test-expr '\''(a >= ((b || c) && d)) != e'\'' -a 0,2,0,1,0
0
$ test-expr '\''(a >= ((b || c) && d)) != e'\'' -a 0,2,0,1,1
1
$ test-expr '\''(a >= ((b || c) && d)) != e'\'' -a 0,2,0,2,2
1
$ test-expr '\''(a >= ((b || c) && d)) != e'\'' -a 0,2,1,1,1
1
$ test-expr '\''(a >= ((b || c) && d)) != e'\'' -a 1,0,0,0,0
1
$ test-expr '\''(a >= ((b || c) && d)) != e'\'' -a 1,0,0,2,2
1
$ test-expr '\''(a >= ((b || c) && d)) != e'\'' -a 1,0,1,1,2
1
$ test-expr '\''(a >= ((b || c) && d)) != e'\'' -a 1,0,2,0,1
0
$ test-expr '\''(a >= ((b || c) && d)) != e'\'' -a 1,0,2,1,2
1
$ test-expr '\''(a >= ((b || c) && d)) != e'\'' -a 1,1,1,0,0
1
$ test-expr '\''(a >= ((b || c) && d)) != e'\'' -a 1,1,2,0,1
0
$ test-expr '\''(a >= ((b || c) && d)) != e'\'' -a 1,1,2,0,2
1
$ test-expr '\''(a >= ((b || c) && d)) != e'\'' -a 1,1,2,2,0
1
$ test-expr '\''(a >= ((b || c) && d)) != e'\'' -a 1,2,1,2,1
0
$ test-expr '\''(a >= ((b || c) && d)) != e'\'' -a 2,0,1,0,0
1
$ test-expr '\''(a >= ((b || c) && d)) != e'\'' -a 2,0,2,2,2
1
$ test-expr '\''(a >= ((b || c) && d)) != e'\'' -a 2,1,0,1,1
0
$ test-expr '\''(a >= ((b || c) && d)) != e'\'' -a 2,2,0,0,1
0
$ test-expr '\''(a >= ((b || c) && d)) != e'\'' -a 2,2,1,0,0
1
$ test-expr '\''(a >= ((b || c) && d)) != e'\'' -a 2,2,1,1,1
0
$ test-expr '\''(a >= ((b || c) && d)) != e'\'' -a 2,2,1,1,2
1
$ test-expr '\''(a >= ((b || c) && d)) != e'\'' -a 2,2,1,2,2
1
$ test-expr '\''(a || b) != (c && (d >= e))'\'' -a 0,0,0,0,0
0
$ test-expr '\''(a || b) != (c && (d >= e))'\'' -a 0,0,1,0,0
1
$ test-expr '\''(a || b) != (c && (d >= e))'\'' -a 0,0,2,2,0
1
$ test-expr '\''(a || b) != (c && (d >= e))'\'' -a 0,1,0,0,2
1
$ test-expr '\''(a || b) != (c && (d >= e))'\'' -a 0,1,0,2,0
1
$ test-expr '\''(a || b) != (c && (d >= e))'\'' -a 0,1,1,2,2
0
$ test-expr '\''(a || b) != (c && (d >= e))'\'' -a 0,1,2,1,0
0
$ test-expr '\''(a || b) != (c && (d >= e))'\'' -a 0,1,2,2,1
0
$ test-expr '\''(a || b) != (c && (d >= e))'\'' -a 0,2,0,2,1
1
$ test-expr '\''(a || b) != (c && (d >= e))'\'' -a 0,2,0,2,2
1
$ test-expr '\''(a || b) != (c && (d >= e))'\'' -a 1,0,1,0,1
1
$ test-expr '\''(a || b) != (c && (d >= e))'\'' -a 1,0,1,1,0
0
$ test-expr '\''(a || b) != (c && (d >= e))'\'' -a 1,0,1,2,0
0
$ test-expr '\''(a || b) != (c && (d >= e))'\'' -a 1,1,0,1,1
1
$ test-expr '\''(a || b) != (c && (d >= e))'\'' -a 1,2,2,1,1
0
$ test-expr '\''(a || b) != (c && (d >= e))'\'' -a 2,0,1,2,1
0
$ test-expr '\''(a || b) != (c && (d >= e))'\'' -a 2,0,2,2,0
0
$ test-expr '\''(a || b) != (c && (d >= e))'\'' -a 2,1,1,1,0
0
$ test-expr '\''(a || b) != (c && (d >= e))'\'' -a 2,1,2,1,0
0
$ test-expr '\''(a || b) != (c && (d >= e))'\'' -a 2,2,0,0,2
1
$ test-expr '\''(a || b) != (c && (d >= e))'\'' -a 2,2,0,2,0
1
$ test-expr '\''(a || b) != (c && (d >= e))'\'' -a 2,2,1,0,1
1
$ test-expr '\''(a || b) != (c && (d >= e))'\'' -a 2,2,1,2,2
0
$ test-expr '\''(a || b) != (c >= (d && e))'\'' -a 0,0,0,0,0
1
$ test-expr '\''(a || b) != (c >= (d && e))'\'' -a 0,0,1,0,1
1
$ test-expr '\''(a || b) != (c >= (d && e))'\'' -a 0,0,1,1,1
1
$ test-expr '\''(a || b) != (c >= (d && e))'\'' -a 0,0,1,2,0
1
$ test-expr '\''(a || b) != (c >= (d && e))'\'' -a 0,0,2,0,2
1
$ test-expr '\''(a || b) != (c >= (d && e))'\'' -a 0,1,0,1,0
0
$ test-expr '\''(a || b) != (c >= (d && e))'\'' -a 0,1,1,1,0
0
$ test-expr '\''(a || b) != (c >= (d && e))'\'' -a 0,1,1,1,1
0
$ test-expr '\''(a || b) != (c >= (d && e))'\'' -a 0,1,2,1,1
0
$ test-expr '\''(a || b) != (c >= (d && e))'\'' -a 0,1,2,2,0
0
$ test-expr '\''(a || b) != (c >= (d && e))'\'' -a 0,2,0,0,0
0
$ test-expr '\''(a || b) != (c >= (d && e))'\'' -a 0,2,1,2,1
0
$ test-expr '\''(a || b) != (c >= (d && e))'\'' -a 1,0,2,0,1
0
$ test-expr '\''(a || b) != (c >= (d && e))'\'' -a 1,0,2,1,2
0
$ test-expr '\''(a || b) != (c >= (d && e))'\'' -a 1,0,2,2,1
0
$ test-expr '\''(a || b) != (c >= (d && e))'\'' -a 1,1,0,1,0
0
$ test-expr '\''(a || b) != (c >= (d && e))'\'' -a 1,1,0,1,2
1
$ test-expr '\''(a || b) != (c >= (d && e))'\'' -a 1,1,0,2,2
1
$ test-expr '\''(a || b) != (c >= (d && e))'\'' -a 1,1,1,2,1
0
$ test-expr '\''(a || b) != (c >= (d && e))'\'' -a 1,1,2,0,1
0
$ test-expr '\''(a || b) != (c >= (d && e))'\'' -a 1,1,2,2,1
0
$ test-expr '\''(a || b) != (c >= (d && e))'\'' -a 1,2,0,1,0
0
$ test-expr '\''(a || b) != (c >= (d && e))'\'' -a 1,2,1,1,0
0
$ test-expr '\''(a || b) != (c >= (d && e))'\'' -a 2,0,0,0,0
0
$ test-expr '\''(a || b) != (c >= (d && e))'\'' -a 2,0,0,0,1
0
$ test-expr '\''(a || b) != (c >= (d && e))'\'' -a 2,0,0,2,2
1
$ test-expr '\''(a || b) != (c >= (d && e))'\'' -a 2,0,1,0,1
0
$ test-expr '\''(a || b) != (c >= (d && e))'\'' -a 2,0,2,1,0
0
$ test-expr '\''(a || b) != (c >= (d && e))'\'' -a 2,0,2,2,2
0
$ test-expr '\''(a || b) != (c >= (d && e))'\'' -a 2,1,0,1,1
1
$ test-expr '\''(a || b) != (c >= (d && e))'\'' -a 2,1,0,2,0
0
$ test-expr '\''(a || b) != (c >= (d && e))'\'' -a 2,1,1,0,0
0
$ test-expr '\''(a || b) != (c >= (d && e))'\'' -a 2,1,2,0,2
0
$ test-expr '\''(a || b) != (c >= (d && e))'\'' -a 2,2,0,0,0
0
$ test-expr '\''(a || b) != (c >= (d && e))'\'' -a 2,2,0,2,2
1
$ test-expr '\''(a || b) != (c >= (d && e))'\'' -a 2,2,1,0,2
0
$ test-expr '\''(a || b) != (c >= (d && e))'\'' -a 2,2,2,0,2
0
$ test-expr '\''(a || b) != (c >= (d && e))'\'' -a 2,2,2,2,1
0
$ test-expr '\''(a || b) != ((c && d) >= e)'\'' -a 0,0,2,2,1
1
$ test-expr '\''(a || b) != ((c && d) >= e)'\'' -a 0,0,2,2,2
0
$ test-expr '\''(a || b) != ((c && d) >= e)'\'' -a 0,1,0,0,0
0
$ test-expr '\''(a || b) != ((c && d) >= e)'\'' -a 0,2,0,2,0
0
$ test-expr '\''(a || b) != ((c && d) >= e)'\'' -a 0,2,0,2,1
1
$ test-expr '\''(a || b) != ((c && d) >= e)'\'' -a 0,2,1,0,0
0
$ test-expr '\''(a || b) != ((c && d) >= e)'\'' -a 0,2,2,2,0
0
$ test-expr '\''(a || b) != ((c && d) >= e)'\'' -a 1,0,1,2,2
1
$ test-expr '\''(a || b) != ((c && d) >= e)'\'' -a 1,0,2,2,2
1
$ test-expr '\''(a || b) != ((c && d) >= e)'\'' -a 1,1,0,1,1
1
$ test-expr '\''(a || b) != ((c && d) >= e)'\'' -a 1,2,0,2,2
1
$ test-expr '\''(a || b) != ((c && d) >= e)'\'' -a 1,2,2,0,1
1
$ test-expr '\''(a || b) != ((c && d) >= e)'\'' -a 2,0,0,2,0
0
$ test-expr '\''(a || b) != ((c && d) >= e)'\'' -a 2,0,0,2,1
1
$ test-expr '\''(a || b) != ((c && d) >= e)'\'' -a 2,0,1,2,0
0
$ test-expr '\''(a || b) != ((c && d) >= e)'\'' -a 2,0,1,2,2
1
$ test-expr '\''(a || b) != ((c && d) >= e)'\'' -a 2,0,2,2,2
1
$ test-expr '\''(a || b) != ((c && d) >= e)'\'' -a 2,1,0,0,0
0
$ test-expr '\''(a || b) != ((c && d) >= e)'\'' -a 2,1,1,1,0
0
$ test-expr '\''(a || b) != ((c && d) >= e)'\'' -a 2,1,1,2,0
0
$ test-expr '\''(a || b) != ((c && d) >= e)'\'' -a 2,1,2,0,0
0
$ test-expr '\''(a || b) != ((c >= d) && e)'\'' -a 0,0,0,1,0
0
$ test-expr '\''(a || b) != ((c >= d) && e)'\'' -a 0,0,1,1,1
1
$ test-expr '\''(a || b) != ((c >= d) && e)'\'' -a 0,0,2,2,1
1
$ test-expr '\''(a || b) != ((c >= d) && e)'\'' -a 0,1,1,0,2
0
$ test-expr '\''(a || b) != ((c >= d) && e)'\'' -a 0,2,0,0,2
0
$ test-expr '\''(a || b) != ((c >= d) && e)'\'' -a 0,2,2,0,1
0
$ test-expr '\''(a || b) != ((c >= d) && e)'\'' -a 1,0,0,0,1
0
$ test-expr '\''(a || b) != ((c >= d) && e)'\'' -a 1,0,0,2,2
1
$ test-expr '\''(a || b) != ((c >= d) && e)'\'' -a 1,0,1,0,1
0
$ test-expr '\''(a || b) != ((c >= d) && e)'\'' -a 1,0,2,1,1
0
$ test-expr '\''(a || b) != ((c >= d) && e)'\'' -a 1,0,2,1,2
0
$ test-expr '\''(a || b) != ((c >= d) && e)'\'' -a 1,1,1,2,2
1
$ test-expr '\''(a || b) != ((c >= d) && e)'\'' -a 1,1,2,1,2
0
$ test-expr '\''(a || b) != ((c >= d) && e)'\'' -a 1,2,0,1,1
1
$ test-expr '\''(a || b) != ((c >= d) && e)'\'' -a 2,0,1,0,0
1
$ test-expr '\''(a || b) != ((c >= d) && e)'\'' -a 2,0,2,0,2
0
$ test-expr '\''(a || b) != ((c >= d) && e)'\'' -a 2,0,2,1,1
0
$ test-expr '\''(a || b) != ((c >= d) && e)'\'' -a 2,0,2,2,1
0
$ test-expr '\''(a || b) != ((c >= d) && e)'\'' -a 2,1,0,0,2
0
$ test-expr '\''(a || b) != ((c >= d) && e)'\'' -a 2,1,1,0,2
0
$ test-expr '\''(a || b) != ((c >= d) && e)'\'' -a 2,1,1,1,0
1
$ test-expr '\''(a || b) != ((c >= d) && e)'\'' -a 2,2,0,1,0
1
$ test-expr '\''(a || b) != ((c >= d) && e)'\'' -a 2,2,1,0,1
0
$ test-expr '\''(a || b) != ((c >= d) && e)'\'' -a 2,2,1,1,2
0
$ test-expr '\''(a || b) != ((c >= d) && e)'\'' -a 2,2,2,1,1
0
$ test-expr '\''(a || b) && (c != (d >= e))'\'' -a 0,0,0,0,1
0
$ test-expr '\''(a || b) && (c != (d >= e))'\'' -a 0,0,1,0,2
0
$ test-expr '\''(a || b) && (c != (d >= e))'\'' -a 0,0,1,2,2
0
$ test-expr '\''(a || b) && (c != (d >= e))'\'' -a 0,1,1,0,0
0
$ test-expr '\''(a || b) && (c != (d >= e))'\'' -a 0,1,1,1,2
1
$ test-expr '\''(a || b) && (c != (d >= e))'\'' -a 0,1,1,2,0
0
$ test-expr '\''(a || b) && (c != (d >= e))'\'' -a 0,1,2,1,1
1
$ test-expr '\''(a || b) && (c != (d >= e))'\'' -a 0,2,0,1,0
1
$ test-expr '\''(a || b) && (c != (d >= e))'\'' -a 0,2,0,2,1
1
$ test-expr '\''(a || b) && (c != (d >= e))'\'' -a 0,2,1,0,2
1
$ test-expr '\''(a || b) && (c != (d >= e))'\'' -a 0,2,1,1,2
1
$ test-expr '\''(a || b) && (c != (d >= e))'\'' -a 0,2,2,0,0
1
$ test-expr '\''(a || b) && (c != (d >= e))'\'' -a 0,2,2,0,1
1
$ test-expr '\''(a || b) && (c != (d >= e))'\'' -a 0,2,2,2,1
1
$ test-expr '\''(a || b) && (c != (d >= e))'\'' -a 1,0,1,0,1
1
$ test-expr '\''(a || b) && (c != (d >= e))'\'' -a 1,0,1,1,1
0
$ test-expr '\''(a || b) && (c != (d >= e))'\'' -a 1,0,2,0,1
1
$ test-expr '\''(a || b) && (c != (d >= e))'\'' -a 1,1,0,0,0
1
$ test-expr '\''(a || b) && (c != (d >= e))'\'' -a 1,1,0,1,2
0
$ test-expr '\''(a || b) && (c != (d >= e))'\'' -a 1,1,2,1,0
1
$ test-expr '\''(a || b) && (c != (d >= e))'\'' -a 1,2,0,1,1
1
$ test-expr '\''(a || b) && (c != (d >= e))'\'' -a 2,0,1,0,1
1
$ test-expr '\''(a || b) && (c != (d >= e))'\'' -a 2,1,1,0,1
1
$ test-expr '\''(a || b) && (c != (d >= e))'\'' -a 2,1,2,0,1
1
$ test-expr '\''(a || b) && (c != (d >= e))'\'' -a 2,2,0,1,0
1
$ test-expr '\''(a || b) && (c != (d >= e))'\'' -a 2,2,0,2,0
1
$ test-expr '\''(a || b) && (c != (d >= e))'\'' -a 2,2,1,1,1
0
$ test-expr '\''(a || b) && (c != (d >= e))'\'' -a 2,2,1,2,1
0
$ test-expr '\''(a || b) && (c >= (d != e))'\'' -a 0,0,0,2,2
0
$ test-expr '\''(a || b) && (c >= (d != e))'\'' -a 0,0,1,0,0
0
$ test-expr '\''(a || b) && (c >= (d != e))'\'' -a 0,0,2,1,0
0
$ test-expr '\''(a || b) && (c >= (d != e))'\'' -a 0,0,2,1,2
0
$ test-expr '\''(a || b) && (c >= (d != e))'\'' -a 0,0,2,2,1
0
$ test-expr '\''(a || b) && (c >= (d != e))'\'' -a 0,0,2,2,2
0
$ test-expr '\''(a || b) && (c >= (d != e))'\'' -a 0,1,0,0,0
1
$ test-expr '\''(a || b) && (c >= (d != e))'\'' -a 0,1,0,2,0
0
$ test-expr '\''(a || b) && (c >= (d != e))'\'' -a 0,1,1,1,1
1
$ test-expr '\''(a || b) && (c >= (d != e))'\'' -a 0,1,2,0,2
1
$ test-expr '\''(a || b) && (c >= (d != e))'\'' -a 0,1,2,1,2
1
$ test-expr '\''(a || b) && (c >= (d != e))'\'' -a 0,2,0,0,1
0
$ test-expr '\''(a || b) && (c >= (d != e))'\'' -a 0,2,0,1,0
0
$ test-expr '\''(a || b) && (c >= (d != e))'\'' -a 0,2,0,1,2
0
$ test-expr '\''(a || b) && (c >= (d != e))'\'' -a 0,2,0,2,2
1
$ test-expr '\''(a || b) && (c >= (d != e))'\'' -a 0,2,1,0,1
1
$ test-expr '\''(a || b) && (c >= (d != e))'\'' -a 0,2,1,0,2
1
$ test-expr '\''(a || b) && (c >= (d != e))'\'' -a 1,0,0,1,0
0
$ test-expr '\''(a || b) && (c >= (d != e))'\'' -a 1,0,0,1,1
1
$ test-expr '\''(a || b) && (c >= (d != e))'\'' -a 1,0,0,2,2
1
$ test-expr '\''(a || b) && (c >= (d != e))'\'' -a 1,0,2,0,1
1
$ test-expr '\''(a || b) && (c >= (d != e))'\'' -a 1,0,2,1,0
1
$ test-expr '\''(a || b) && (c >= (d != e))'\'' -a 1,0,2,2,2
1
$ test-expr '\''(a || b) && (c >= (d != e))'\'' -a 1,1,0,0,0
1
$ test-expr '\''(a || b) && (c >= (d != e))'\'' -a 1,1,0,1,0
0
$ test-expr '\''(a || b) && (c >= (d != e))'\'' -a 1,1,1,1,2
1
$ test-expr '\''(a || b) && (c >= (d != e))'\'' -a 1,1,2,2,0
1
$ test-expr '\''(a || b) && (c >= (d != e))'\'' -a 1,1,2,2,1
1
$ test-expr '\''(a || b) && (c >= (d != e))'\'' -a 1,2,0,0,1
0
$ test-expr '\''(a || b) && (c >= (d != e))'\'' -a 1,2,1,2,0
1
$ test-expr '\''(a || b) && (c >= (d != e))'\'' -a 2,0,0,0,2
0
$ test-expr '\''(a || b) && (c >= (d != e))'\'' -a 2,0,2,1,0
1
$ test-expr '\''(a || b) && (c >= (d != e))'\'' -a 2,1,0,0,0
1
$ test-expr '\''(a || b) && (c >= (d != e))'\'' -a 2,1,0,2,0
0
$ test-expr '\''(a || b) && (c >= (d != e))'\'' -a 2,1,1,2,0
1
$ test-expr '\''(a || b) && (c >= (d != e))'\'' -a 2,1,1,2,2
1
$ test-expr '\''(a || b) && (c >= (d != e))'\'' -a 2,1,2,0,0
1
$ test-expr '\''(a || b) && (c >= (d != e))'\'' -a 2,1,2,2,2
1
$ test-expr '\''(a || b) && (c >= (d != e))'\'' -a 2,2,2,0,1
1
$ test-expr '\''(a || b) && (c >= (d != e))'\'' -a 2,2,2,1,1
1
$ test-expr '\''(a || b) && ((c != d) >= e)'\'' -a 0,0,0,1,1
0
$ test-expr '\''(a || b) && ((c != d) >= e)'\'' -a 0,0,2,1,2
0
$ test-expr '\''(a || b) && ((c != d) >= e)'\'' -a 0,1,1,0,2
0
$ test-expr '\''(a || b) && ((c != d) >= e)'\'' -a 0,1,2,0,0
1
$ test-expr '\''(a || b) && ((c != d) >= e)'\'' -a 0,2,1,2,0
1
$ test-expr '\''(a || b) && ((c != d) >= e)'\'' -a 0,2,1,2,1
1
$ test-expr '\''(a || b) && ((c != d) >= e)'\'' -a 0,2,1,2,2
0
$ test-expr '\''(a || b) && ((c != d) >= e)'\'' -a 1,0,0,2,1
1
$ test-expr '\''(a || b) && ((c != d) >= e)'\'' -a 1,0,1,1,0
1
$ test-expr '\''(a || b) && ((c != d) >= e)'\'' -a 1,1,2,0,1
1
$ test-expr '\''(a || b) && ((c != d) >= e)'\'' -a 1,1,2,1,2
0
$ test-expr '\''(a || b) && ((c != d) >= e)'\'' -a 1,2,0,1,0
1
$ test-expr '\''(a || b) && ((c != d) >= e)'\'' -a 1,2,0,1,2
0
$ test-expr '\''(a || b) && ((c != d) >= e)'\'' -a 1,2,0,2,0
1
$ test-expr '\''(a || b) && ((c != d) >= e)'\'' -a 1,2,2,0,0
1
$ test-expr '\''(a || b) && ((c != d) >= e)'\'' -a 2,0,0,0,1
0
$ test-expr '\''(a || b) && ((c != d) >= e)'\'' -a 2,1,1,0,2
0
$ test-expr '\''(a || b) && ((c != d) >= e)'\'' -a 2,1,2,0,2
0
$ test-expr '\''(a || b) && ((c != d) >= e)'\'' -a 2,2,0,2,1
1
$ test-expr '\''(a || b) && ((c != d) >= e)'\'' -a 2,2,1,0,1
1
$ test-expr '\''(a || b) && ((c != d) >= e)'\'' -a 2,2,1,1,0
1
$ test-expr '\''(a || b) && ((c >= d) != e)'\'' -a 0,0,0,0,0
0
$ test-expr '\''(a || b) && ((c >= d) != e)'\'' -a 0,0,1,0,1
0
$ test-expr '\''(a || b) && ((c >= d) != e)'\'' -a 0,1,0,0,2
1
$ test-expr '\''(a || b) && ((c >= d) != e)'\'' -a 0,1,0,2,2
1
$ test-expr '\''(a || b) && ((c >= d) != e)'\'' -a 0,1,2,0,1
0
$ test-expr '\''(a || b) && ((c >= d) != e)'\'' -a 0,1,2,1,0
1
$ test-expr '\''(a || b) && ((c >= d) != e)'\'' -a 0,2,0,0,2
1
$ test-expr '\''(a || b) && ((c >= d) != e)'\'' -a 0,2,0,2,1
1
$ test-expr '\''(a || b) && ((c >= d) != e)'\'' -a 0,2,1,1,0
1
$ test-expr '\''(a || b) && ((c >= d) != e)'\'' -a 1,0,0,0,1
0
$ test-expr '\''(a || b) && ((c >= d) != e)'\'' -a 1,0,0,1,2
1
$ test-expr '\''(a || b) && ((c >= d) != e)'\'' -a 1,0,1,2,2
1
$ test-expr '\''(a || b) && ((c >= d) != e)'\'' -a 1,0,2,0,0
1
$ test-expr '\''(a || b) && ((c >= d) != e)'\'' -a 1,1,1,0,0
1
$ test-expr '\''(a || b) && ((c >= d) != e)'\'' -a 1,1,2,2,0
1
$ test-expr '\''(a || b) && ((c >= d) != e)'\'' -a 1,1,2,2,1
0
$ test-expr '\''(a || b) && ((c >= d) != e)'\'' -a 1,1,2,2,2
1
$ test-expr '\''(a || b) && ((c >= d) != e)'\'' -a 1,2,1,2,1
1
$ test-expr '\''(a || b) && ((c >= d) != e)'\'' -a 1,2,2,1,2
1
$ test-expr '\''(a || b) && ((c >= d) != e)'\'' -a 1,2,2,2,0
1
$ test-expr '\''(a || b) && ((c >= d) != e)'\'' -a 2,0,0,0,0
1
$ test-expr '\''(a || b) && ((c >= d) != e)'\'' -a 2,0,1,0,2
1
$ test-expr '\''(a || b) && ((c >= d) != e)'\'' -a 2,0,2,0,2
1
$ test-expr '\''(a || b) && ((c >= d) != e)'\'' -a 2,1,0,0,2
1
$ test-expr '\''(a || b) && ((c >= d) != e)'\'' -a 2,1,0,1,0
0
$ test-expr '\''(a || b) && ((c >= d) != e)'\'' -a 2,1,1,1,2
1
$ test-expr '\''(a || b) && ((c >= d) != e)'\'' -a 2,1,2,1,2
1
$ test-expr '\''(a || b) && ((c >= d) != e)'\'' -a 2,2,1,1,0
1
$ test-expr '\''(a || b) && ((c >= d) != e)'\'' -a 2,2,1,2,0
0
$ test-expr '\''(a || b) && ((c >= d) != e)'\'' -a 2,2,2,1,1
0
$ test-expr '\''(a || b) && ((c >= d) != e)'\'' -a 2,2,2,2,0
1
$ test-expr '\''(a || b) >= (c != (d && e))'\'' -a 0,0,0,2,1
0
$ test-expr '\''(a || b) >= (c != (d && e))'\'' -a 0,0,0,2,2
0
$ test-expr '\''(a || b) >= (c != (d && e))'\'' -a 0,0,2,2,0
0
$ test-expr '\''(a || b) >= (c != (d && e))'\'' -a 0,1,0,1,1
1
$ test-expr '\''(a || b) >= (c != (d && e))'\'' -a 0,1,1,0,2
1
$ test-expr '\''(a || b) >= (c != (d && e))'\'' -a 0,1,1,1,1
1
$ test-expr '\''(a || b) >= (c != (d && e))'\'' -a 0,2,0,2,0
1
$ test-expr '\''(a || b) >= (c != (d && e))'\'' -a 0,2,0,2,2
1
$ test-expr '\''(a || b) >= (c != (d && e))'\'' -a 1,0,1,0,2
1
$ test-expr '\''(a || b) >= (c != (d && e))'\'' -a 1,0,1,1,1
1
$ test-expr '\''(a || b) >= (c != (d && e))'\'' -a 1,0,1,2,2
1
$ test-expr '\''(a || b) >= (c != (d && e))'\'' -a 1,0,2,0,0
1
$ test-expr '\''(a || b) >= (c != (d && e))'\'' -a 1,0,2,2,0
1
$ test-expr '\''(a || b) >= (c != (d && e))'\'' -a 1,0,2,2,2
1
$ test-expr '\''(a || b) >= (c != (d && e))'\'' -a 1,1,0,0,0
1
$ test-expr '\''(a || b) >= (c != (d && e))'\'' -a 1,1,0,0,2
1
$ test-expr '\''(a || b) >= (c != (d && e))'\'' -a 1,1,2,2,1
1
$ test-expr '\''(a || b) >= (c != (d && e))'\'' -a 1,2,1,2,0
1
$ test-expr '\''(a || b) >= (c != (d && e))'\'' -a 2,0,0,1,1
1
$ test-expr '\''(a || b) >= (c != (d && e))'\'' -a 2,0,0,2,1
1
$ test-expr '\''(a || b) >= (c != (d && e))'\'' -a 2,0,1,2,2
1
$ test-expr '\''(a || b) >= (c != (d && e))'\'' -a 2,1,0,0,0
1
$ test-expr '\''(a || b) >= (c != (d && e))'\'' -a 2,1,1,2,1
1
$ test-expr '\''(a || b) >= (c != (d && e))'\'' -a 2,2,0,0,0
1
$ test-expr '\''(a || b) >= (c != (d && e))'\'' -a 2,2,1,0,1
1
$ test-expr '\''(a || b) >= (c != (d && e))'\'' -a 2,2,1,1,0
1
$ test-expr '\''(a || b) >= (c != (d && e))'\'' -a 2,2,1,1,2
1
$ test-expr '\''(a || b) >= (c && (d != e))'\'' -a 0,1,0,1,2
1
$ test-expr '\''(a || b) >= (c && (d != e))'\'' -a 0,1,0,2,1
1
$ test-expr '\''(a || b) >= (c && (d != e))'\'' -a 0,1,2,1,0
1
$ test-expr '\''(a || b) >= (c && (d != e))'\'' -a 0,1,2,1,2
1
$ test-expr '\''(a || b) >= (c && (d != e))'\'' -a 0,2,0,1,2
1
$ test-expr '\''(a || b) >= (c && (d != e))'\'' -a 0,2,1,0,0
1
$ test-expr '\''(a || b) >= (c && (d != e))'\'' -a 0,2,2,1,2
1
$ test-expr '\''(a || b) >= (c && (d != e))'\'' -a 0,2,2,2,1
1
$ test-expr '\''(a || b) >= (c && (d != e))'\'' -a 1,0,0,2,2
1
$ test-expr '\''(a || b) >= (c && (d != e))'\'' -a 1,1,0,0,1
1
$ test-expr '\''(a || b) >= (c && (d != e))'\'' -a 1,1,1,0,1
1
$ test-expr '\''(a || b) >= (c && (d != e))'\'' -a 1,1,1,2,2
1
$ test-expr '\''(a || b) >= (c && (d != e))'\'' -a 1,2,0,0,2
1
$ test-expr '\''(a || b) >= (c && (d != e))'\'' -a 1,2,1,1,1
1
$ test-expr '\''(a || b) >= (c && (d != e))'\'' -a 1,2,1,2,0
1
$ test-expr '\''(a || b) >= (c && (d != e))'\'' -a 1,2,1,2,1
1
$ test-expr '\''(a || b) >= (c && (d != e))'\'' -a 1,2,2,0,0
1
$ test-expr '\''(a || b) >= (c && (d != e))'\'' -a 1,2,2,0,1
1
$ test-expr '\''(a || b) >= (c && (d != e))'\'' -a 1,2,2,0,2
1
$ test-expr '\''(a || b) >= (c && (d != e))'\'' -a 1,2,2,2,2
1
$ test-expr '\''(a || b) >= (c && (d != e))'\'' -a 2,0,0,2,1
1
$ test-expr '\''(a || b) >= (c && (d != e))'\'' -a 2,0,0,2,2
1
$ test-expr '\''(a || b) >= (c && (d != e))'\'' -a 2,1,2,0,0
1
$ test-expr '\''(a || b) >= (c && (d != e))'\'' -a 2,2,0,0,0
1
$ test-expr '\''(a || b) >= (c && (d != e))'\'' -a 2,2,2,2,1
1
$ test-expr '\''(a || b) >= ((c != d) && e)'\'' -a 0,0,0,1,1
0
$ test-expr '\''(a || b) >= ((c != d) && e)'\'' -a 0,0,1,2,1
0
$ test-expr '\''(a || b) >= ((c != d) && e)'\'' -a 0,0,1,2,2
0
$ test-expr '\''(a || b) >= ((c != d) && e)'\'' -a 0,1,0,0,0
1
$ test-expr '\''(a || b) >= ((c != d) && e)'\'' -a 0,2,0,1,2
1
$ test-expr '\''(a || b) >= ((c != d) && e)'\'' -a 0,2,0,2,2
1
$ test-expr '\''(a || b) >= ((c != d) && e)'\'' -a 0,2,1,2,0
1
$ test-expr '\''(a || b) >= ((c != d) && e)'\'' -a 1,0,1,1,1
1
$ test-expr '\''(a || b) >= ((c != d) && e)'\'' -a 1,0,1,2,0
1
$ test-expr '\''(a || b) >= ((c != d) && e)'\'' -a 1,0,2,0,1
1
$ test-expr '\''(a || b) >= ((c != d) && e)'\'' -a 1,1,1,1,2
1
$ test-expr '\''(a || b) >= ((c != d) && e)'\'' -a 1,2,0,2,1
1
$ test-expr '\''(a || b) >= ((c != d) && e)'\'' -a 1,2,1,1,2
1
$ test-expr '\''(a || b) >= ((c != d) && e)'\'' -a 1,2,2,1,0
1
$ test-expr '\''(a || b) >= ((c != d) && e)'\'' -a 2,0,0,2,0
1
$ test-expr '\''(a || b) >= ((c != d) && e)'\'' -a 2,0,0,2,2
1
$ test-expr '\''(a || b) >= ((c != d) && e)'\'' -a 2,0,1,0,0
1
$ test-expr '\''(a || b) >= ((c != d) && e)'\'' -a 2,0,1,1,1
1
$ test-expr '\''(a || b) >= ((c != d) && e)'\'' -a 2,1,0,0,2
1
$ test-expr '\''(a || b) >= ((c != d) && e)'\'' -a 2,1,2,2,0
1
$ test-expr '\''(a || b) >= ((c != d) && e)'\'' -a 2,2,0,0,2
1
$ test-expr '\''(a || b) >= ((c != d) && e)'\'' -a 2,2,1,0,2
1
$ test-expr '\''(a || b) >= ((c != d) && e)'\'' -a 2,2,1,2,1
1
$ test-expr '\''(a || b) >= ((c != d) && e)'\'' -a 2,2,2,1,2
1
$ test-expr '\''(a || b) >= ((c && d) != e)'\'' -a 0,0,0,0,1
0
$ test-expr '\''(a || b) >= ((c && d) != e)'\'' -a 0,0,0,1,0
1
$ test-expr '\''(a || b) >= ((c && d) != e)'\'' -a 0,0,0,2,1
0
$ test-expr '\''(a || b) >= ((c && d) != e)'\'' -a 0,0,1,0,1
0
$ test-expr '\''(a || b) >= ((c && d) != e)'\'' -a 0,1,0,0,0
1
$ test-expr '\''(a || b) >= ((c && d) != e)'\'' -a 0,1,0,0,1
1
$ test-expr '\''(a || b) >= ((c && d) != e)'\'' -a 0,2,0,0,0
1
$ test-expr '\''(a || b) >= ((c && d) != e)'\'' -a 0,2,0,2,0
1
$ test-expr '\''(a || b) >= ((c && d) != e)'\'' -a 0,2,0,2,2
1
$ test-expr '\''(a || b) >= ((c && d) != e)'\'' -a 0,2,2,1,0
1
$ test-expr '\''(a || b) >= ((c && d) != e)'\'' -a 1,0,0,1,0
1
$ test-expr '\''(a || b) >= ((c && d) != e)'\'' -a 1,0,1,1,2
1
$ test-expr '\''(a || b) >= ((c && d) != e)'\'' -a 1,0,2,2,2
1
$ test-expr '\''(a || b) >= ((c && d) != e)'\'' -a 1,1,1,0,2
1
$ test-expr '\''(a || b) >= ((c && d) != e)'\'' -a 1,1,1,2,1
1
$ test-expr '\''(a || b) >= ((c && d) != e)'\'' -a 1,2,0,2,1
1
$ test-expr '\''(a || b) >= ((c && d) != e)'\'' -a 1,2,1,2,0
1
$ test-expr '\''(a || b) >= ((c && d) != e)'\'' -a 1,2,2,0,1
1
$ test-expr '\''(a || b) >= ((c && d) != e)'\'' -a 1,2,2,2,0
1
$ test-expr '\''(a || b) >= ((c && d) != e)'\'' -a 2,0,0,0,1
1
$ test-expr '\''(a || b) >= ((c && d) != e)'\'' -a 2,0,0,2,0
1
$ test-expr '\''(a || b) >= ((c && d) != e)'\'' -a 2,0,2,0,0
1
$ test-expr '\''(a || b) >= ((c && d) != e)'\'' -a 2,1,0,2,0
1
$ test-expr '\''(a || b) >= ((c && d) != e)'\'' -a 2,1,1,0,1
1
$ test-expr '\''(a || b) >= ((c && d) != e)'\'' -a 2,1,1,1,0
1
$ test-expr '\''(a || b) >= ((c && d) != e)'\'' -a 2,1,1,1,2
1
$ test-expr '\''(a || b) >= ((c && d) != e)'\'' -a 2,1,1,2,0
1
$ test-expr '\''(a || b) >= ((c && d) != e)'\'' -a 2,2,0,1,0
1
$ test-expr '\''(a || b) >= ((c && d) != e)'\'' -a 2,2,1,2,1
1
$ test-expr '\''(a || b) >= ((c && d) != e)'\'' -a 2,2,2,0,0
1
$ test-expr '\''(a || b) >= ((c && d) != e)'\'' -a 2,2,2,1,1
1
$ test-expr '\''(a || b) >= ((c && d) != e)'\'' -a 2,2,2,2,0
1
$ test-expr '\''(a || (b != c)) && (d >= e)'\'' -a 0,0,1,0,1
0
$ test-expr '\''(a || (b != c)) && (d >= e)'\'' -a 0,0,2,2,1
1
$ test-expr '\''(a || (b != c)) && (d >= e)'\'' -a 0,1,0,2,2
1
$ test-expr '\''(a || (b != c)) && (d >= e)'\'' -a 0,1,2,0,0
1
$ test-expr '\''(a || (b != c)) && (d >= e)'\'' -a 0,2,1,1,2
0
$ test-expr '\''(a || (b != c)) && (d >= e)'\'' -a 0,2,2,0,1
0
$ test-expr '\''(a || (b != c)) && (d >= e)'\'' -a 0,2,2,0,2
0
$ test-expr '\''(a || (b != c)) && (d >= e)'\'' -a 0,2,2,1,2
0
$ test-expr '\''(a || (b != c)) && (d >= e)'\'' -a 0,2,2,2,0
0
$ test-expr '\''(a || (b != c)) && (d >= e)'\'' -a 1,0,1,2,1
1
$ test-expr '\''(a || (b != c)) && (d >= e)'\'' -a 1,0,2,0,1
0
$ test-expr '\''(a || (b != c)) && (d >= e)'\'' -a 1,1,0,0,1
0
$ test-expr '\''(a || (b != c)) && (d >= e)'\'' -a 1,1,1,0,1
0
$ test-expr '\''(a || (b != c)) && (d >= e)'\'' -a 1,1,1,1,0
1
$ test-expr '\''(a || (b != c)) && (d >= e)'\'' -a 1,1,2,0,1
0
$ test-expr '\''(a || (b != c)) && (d >= e)'\'' -a 1,1,2,0,2
0
$ test-expr '\''(a || (b != c)) && (d >= e)'\'' -a 1,2,2,2,2
1
$ test-expr '\''(a || (b != c)) && (d >= e)'\'' -a 2,0,0,0,1
0
$ test-expr '\''(a || (b != c)) && (d >= e)'\'' -a 2,0,1,1,0
1
$ test-expr '\''(a || (b != c)) && (d >= e)'\'' -a 2,0,1,1,1
1
$ test-expr '\''(a || (b != c)) && (d >= e)'\'' -a 2,0,2,1,0
1
$ test-expr '\''(a || (b != c)) && (d >= e)'\'' -a 2,2,0,0,2
0
$ test-expr '\''(a || (b != c)) && (d >= e)'\'' -a 2,2,1,1,0
1
$ test-expr '\''(a || (b != c)) && (d >= e)'\'' -a 2,2,2,1,0
1
$ test-expr '\''(a || (b != c)) >= (d && e)'\'' -a 0,0,0,0,2
1
$ test-expr '\''(a || (b != c)) >= (d && e)'\'' -a 0,1,0,0,2
1
$ test-expr '\''(a || (b != c)) >= (d && e)'\'' -a 0,1,1,1,2
0
$ test-expr '\''(a || (b != c)) >= (d && e)'\'' -a 0,1,2,0,0
1
$ test-expr '\''(a || (b != c)) >= (d && e)'\'' -a 0,1,2,0,2
1
$ test-expr '\''(a || (b != c)) >= (d && e)'\'' -a 0,2,1,1,0
1
$ test-expr '\''(a || (b != c)) >= (d && e)'\'' -a 0,2,1,2,2
1
$ test-expr '\''(a || (b != c)) >= (d && e)'\'' -a 0,2,2,1,2
0
$ test-expr '\''(a || (b != c)) >= (d && e)'\'' -a 1,0,0,0,1
1
$ test-expr '\''(a || (b != c)) >= (d && e)'\'' -a 1,0,1,2,1
1
$ test-expr '\''(a || (b != c)) >= (d && e)'\'' -a 1,1,0,1,1
1
$ test-expr '\''(a || (b != c)) >= (d && e)'\'' -a 1,1,1,2,0
1
$ test-expr '\''(a || (b != c)) >= (d && e)'\'' -a 1,1,2,1,1
1
$ test-expr '\''(a || (b != c)) >= (d && e)'\'' -a 1,2,1,1,2
1
$ test-expr '\''(a || (b != c)) >= (d && e)'\'' -a 2,0,1,0,2
1
$ test-expr '\''(a || (b != c)) >= (d && e)'\'' -a 2,0,1,1,1
1
$ test-expr '\''(a || (b != c)) >= (d && e)'\'' -a 2,0,1,2,1
1
$ test-expr '\''(a || (b != c)) >= (d && e)'\'' -a 2,1,2,1,0
1
$ test-expr '\''(a || (b != c)) >= (d && e)'\'' -a 2,2,0,0,2
1
$ test-expr '\''(a || (b != c)) >= (d && e)'\'' -a 2,2,1,0,0
1
$ test-expr '\''(a || (b != c)) >= (d && e)'\'' -a 2,2,1,2,2
1
$ test-expr '\''(a || (b != (c && d))) >= e'\'' -a 0,0,0,2,2
0
$ test-expr '\''(a || (b != (c && d))) >= e'\'' -a 0,0,1,0,2
0
$ test-expr '\''(a || (b != (c && d))) >= e'\'' -a 0,0,1,1,0
1
$ test-expr '\''(a || (b != (c && d))) >= e'\'' -a 0,0,1,2,2
0
$ test-expr '\''(a || (b != (c && d))) >= e'\'' -a 0,0,2,2,1
1
$ test-expr '\''(a || (b != (c && d))) >= e'\'' -a 0,1,0,0,1
1
$ test-expr '\''(a || (b != (c && d))) >= e'\'' -a 0,1,0,0,2
0
$ test-expr '\''(a || (b != (c && d))) >= e'\'' -a 0,1,1,1,0
1
$ test-expr '\''(a || (b != (c && d))) >= e'\'' -a 0,1,1,2,0
1
$ test-expr '\''(a || (b != (c && d))) >= e'\'' -a 0,1,2,0,0
1
$ test-expr '\''(a || (b != (c && d))) >= e'\'' -a 0,1,2,2,2
0
$ test-expr '\''(a || (b != (c && d))) >= e'\'' -a 0,2,0,0,0
1
$ test-expr '\''(a || (b != (c && d))) >= e'\'' -a 0,2,0,1,2
0
$ test-expr '\''(a || (b != (c && d))) >= e'\'' -a 0,2,1,1,2
0
$ test-expr '\''(a || (b != (c && d))) >= e'\'' -a 0,2,2,2,1
1
$ test-expr '\''(a || (b != (c && d))) >= e'\'' -a 1,0,0,2,0
1
$ test-expr '\''(a || (b != (c && d))) >= e'\'' -a 1,0,0,2,2
0
$ test-expr '\''(a || (b != (c && d))) >= e'\'' -a 1,0,1,1,0
1
$ test-expr '\''(a || (b != (c && d))) >= e'\'' -a 1,0,2,0,0
1
$ test-expr '\''(a || (b != (c && d))) >= e'\'' -a 1,1,1,1,1
1
$ test-expr '\''(a || (b != (c && d))) >= e'\'' -a 1,1,1,1,2
0
$ test-expr '\''(a || (b != (c && d))) >= e'\'' -a 1,1,2,0,2
0
$ test-expr '\''(a || (b != (c && d))) >= e'\'' -a 1,1,2,1,1
1
$ test-expr '\''(a || (b != (c && d))) >= e'\'' -a 1,1,2,2,1
1
$ test-expr '\''(a || (b != (c && d))) >= e'\'' -a 1,2,0,2,2
0
$ test-expr '\''(a || (b != (c && d))) >= e'\'' -a 1,2,2,0,2
0
$ test-expr '\''(a || (b != (c && d))) >= e'\'' -a 1,2,2,2,0
1
$ test-expr '\''(a || (b != (c && d))) >= e'\'' -a 2,0,0,1,2
0
$ test-expr '\''(a || (b != (c && d))) >= e'\'' -a 2,0,1,0,1
1
$ test-expr '\''(a || (b != (c && d))) >= e'\'' -a 2,2,0,0,0
1
$ test-expr '\''(a || (b != (c && d))) >= e'\'' -a 2,2,2,1,1
1
$ test-expr '\''(a || (b != (c >= d))) && e'\'' -a 0,0,1,2,1
0
$ test-expr '\''(a || (b != (c >= d))) && e'\'' -a 0,1,0,2,1
1
$ test-expr '\''(a || (b != (c >= d))) && e'\'' -a 0,1,2,1,1
0
$ test-expr '\''(a || (b != (c >= d))) && e'\'' -a 0,1,2,2,2
0
$ test-expr '\''(a || (b != (c >= d))) && e'\'' -a 0,2,1,1,1
1
$ test-expr '\''(a || (b != (c >= d))) && e'\'' -a 0,2,2,0,1
1
$ test-expr '\''(a || (b != (c >= d))) && e'\'' -a 1,0,0,0,2
1
$ test-expr '\''(a || (b != (c >= d))) && e'\'' -a 1,0,1,0,0
0
$ test-expr '\''(a || (b != (c >= d))) && e'\'' -a 1,0,1,2,0
0
$ test-expr '\''(a || (b != (c >= d))) && e'\'' -a 1,0,1,2,1
1
$ test-expr '\''(a || (b != (c >= d))) && e'\'' -a 1,0,2,1,2
1
$ test-expr '\''(a || (b != (c >= d))) && e'\'' -a 1,1,0,0,1
1
$ test-expr '\''(a || (b != (c >= d))) && e'\'' -a 1,1,0,1,0
0
$ test-expr '\''(a || (b != (c >= d))) && e'\'' -a 1,1,1,1,0
0
$ test-expr '\''(a || (b != (c >= d))) && e'\'' -a 1,1,2,1,2
1
$ test-expr '\''(a || (b != (c >= d))) && e'\'' -a 1,2,0,0,0
0
$ test-expr '\''(a || (b != (c >= d))) && e'\'' -a 1,2,0,0,1
1
$ test-expr '\''(a || (b != (c >= d))) && e'\'' -a 1,2,1,1,0
0
$ test-expr '\''(a || (b != (c >= d))) && e'\'' -a 1,2,1,1,2
1
$ test-expr '\''(a || (b != (c >= d))) && e'\'' -a 1,2,2,1,1
1
$ test-expr '\''(a || (b != (c >= d))) && e'\'' -a 2,0,2,1,0
0
$ test-expr '\''(a || (b != (c >= d))) && e'\'' -a 2,1,0,2,1
1
$ test-expr '\''(a || (b != (c >= d))) && e'\'' -a 2,1,1,2,0
0
$ test-expr '\''(a || (b != (c >= d))) && e'\'' -a 2,1,2,0,2
1
$ test-expr '\''(a || (b != (c >= d))) && e'\'' -a 2,2,0,1,2
1
$ test-expr '\''(a || (b != (c >= d))) && e'\'' -a 2,2,1,2,0
0
$ test-expr '\''(a || (b && c)) != (d >= e)'\'' -a 0,0,0,2,1
1
$ test-expr '\''(a || (b && c)) != (d >= e)'\'' -a 0,0,1,1,1
1
$ test-expr '\''(a || (b && c)) != (d >= e)'\'' -a 0,1,0,0,2
0
$ test-expr '\''(a || (b && c)) != (d >= e)'\'' -a 0,1,1,0,1
1
$ test-expr '\''(a || (b && c)) != (d >= e)'\'' -a 0,1,2,1,2
1
$ test-expr '\''(a || (b && c)) != (d >= e)'\'' -a 0,2,0,0,0
1
$ test-expr '\''(a || (b && c)) != (d >= e)'\'' -a 0,2,1,0,1
1
$ test-expr '\''(a || (b && c)) != (d >= e)'\'' -a 0,2,2,0,0
0
$ test-expr '\''(a || (b && c)) != (d >= e)'\'' -a 0,2,2,1,0
0
$ test-expr '\''(a || (b && c)) != (d >= e)'\'' -a 0,2,2,2,1
0
$ test-expr '\''(a || (b && c)) != (d >= e)'\'' -a 1,0,0,0,0
0
$ test-expr '\''(a || (b && c)) != (d >= e)'\'' -a 1,0,0,0,2
1
$ test-expr '\''(a || (b && c)) != (d >= e)'\'' -a 1,0,2,0,1
1
$ test-expr '\''(a || (b && c)) != (d >= e)'\'' -a 1,0,2,0,2
1
$ test-expr '\''(a || (b && c)) != (d >= e)'\'' -a 1,1,1,1,1
0
$ test-expr '\''(a || (b && c)) != (d >= e)'\'' -a 1,1,2,1,1
0
$ test-expr '\''(a || (b && c)) != (d >= e)'\'' -a 1,2,0,1,1
0
$ test-expr '\''(a || (b && c)) != (d >= e)'\'' -a 1,2,1,0,0
0
$ test-expr '\''(a || (b && c)) != (d >= e)'\'' -a 1,2,1,0,2
1
$ test-expr '\''(a || (b && c)) != (d >= e)'\'' -a 1,2,2,0,0
0
$ test-expr '\''(a || (b && c)) != (d >= e)'\'' -a 1,2,2,0,2
1
$ test-expr '\''(a || (b && c)) != (d >= e)'\'' -a 2,0,0,2,2
0
$ test-expr '\''(a || (b && c)) != (d >= e)'\'' -a 2,0,1,1,1
0
$ test-expr '\''(a || (b && c)) != (d >= e)'\'' -a 2,0,1,1,2
1
$ test-expr '\''(a || (b && c)) != (d >= e)'\'' -a 2,0,1,2,1
0
$ test-expr '\''(a || (b && c)) != (d >= e)'\'' -a 2,0,2,0,0
0
$ test-expr '\''(a || (b && c)) != (d >= e)'\'' -a 2,0,2,0,2
1
$ test-expr '\''(a || (b && c)) != (d >= e)'\'' -a 2,1,0,0,2
1
$ test-expr '\''(a || (b && c)) != (d >= e)'\'' -a 2,1,0,1,1
0
$ test-expr '\''(a || (b && c)) != (d >= e)'\'' -a 2,1,0,1,2
1
$ test-expr '\''(a || (b && c)) != (d >= e)'\'' -a 2,1,1,0,1
1
$ test-expr '\''(a || (b && c)) != (d >= e)'\'' -a 2,1,2,2,0
0
$ test-expr '\''(a || (b && c)) != (d >= e)'\'' -a 2,2,0,0,0
0
$ test-expr '\''(a || (b && c)) != (d >= e)'\'' -a 2,2,0,0,2
1
$ test-expr '\''(a || (b && c)) != (d >= e)'\'' -a 2,2,1,1,0
0
$ test-expr '\''(a || (b && c)) != (d >= e)'\'' -a 2,2,2,0,2
1
$ test-expr '\''(a || (b && c)) >= (d != e)'\'' -a 0,0,0,2,1
0
$ test-expr '\''(a || (b && c)) >= (d != e)'\'' -a 0,0,1,0,0
1
$ test-expr '\''(a || (b && c)) >= (d != e)'\'' -a 0,0,1,0,2
0
$ test-expr '\''(a || (b && c)) >= (d != e)'\'' -a 0,0,1,1,0
0
$ test-expr '\''(a || (b && c)) >= (d != e)'\'' -a 0,0,2,1,0
0
$ test-expr '\''(a || (b && c)) >= (d != e)'\'' -a 0,1,1,0,0
1
$ test-expr '\''(a || (b && c)) >= (d != e)'\'' -a 0,1,2,0,1
1
$ test-expr '\''(a || (b && c)) >= (d != e)'\'' -a 0,1,2,1,0
1
$ test-expr '\''(a || (b && c)) >= (d != e)'\'' -a 0,2,0,0,0
1
$ test-expr '\''(a || (b && c)) >= (d != e)'\'' -a 1,0,0,0,1
1
$ test-expr '\''(a || (b && c)) >= (d != e)'\'' -a 1,0,0,2,2
1
$ test-expr '\''(a || (b && c)) >= (d != e)'\'' -a 1,0,1,2,0
1
$ test-expr '\''(a || (b && c)) >= (d != e)'\'' -a 1,0,1,2,1
1
$ test-expr '\''(a || (b && c)) >= (d != e)'\'' -a 1,0,2,2,0
1
$ test-expr '\''(a || (b && c)) >= (d != e)'\'' -a 1,1,0,0,1
1
$ test-expr '\''(a || (b && c)) >= (d != e)'\'' -a 1,1,1,1,1
1
$ test-expr '\''(a || (b && c)) >= (d != e)'\'' -a 1,1,1,2,1
1
$ test-expr '\''(a || (b && c)) >= (d != e)'\'' -a 1,2,2,0,1
1
$ test-expr '\''(a || (b && c)) >= (d != e)'\'' -a 2,0,2,1,0
1
$ test-expr '\''(a || (b && c)) >= (d != e)'\'' -a 2,1,0,2,1
1
$ test-expr '\''(a || (b && c)) >= (d != e)'\'' -a 2,1,1,2,2
1
$ test-expr '\''(a || (b && c)) >= (d != e)'\'' -a 2,1,2,1,0
1
$ test-expr '\''(a || (b && c)) >= (d != e)'\'' -a 2,1,2,1,1
1
$ test-expr '\''(a || (b && c)) >= (d != e)'\'' -a 2,1,2,2,0
1
$ test-expr '\''(a || (b && c)) >= (d != e)'\'' -a 2,1,2,2,1
1
$ test-expr '\''(a || (b && c)) >= (d != e)'\'' -a 2,2,1,2,1
1
$ test-expr '\''(a || (b && (c != d))) >= e'\'' -a 0,0,2,1,0
1
$ test-expr '\''(a || (b && (c != d))) >= e'\'' -a 0,0,2,1,1
0
$ test-expr '\''(a || (b && (c != d))) >= e'\'' -a 0,0,2,2,1
0
$ test-expr '\''(a || (b && (c != d))) >= e'\'' -a 0,1,0,0,0
1
$ test-expr '\''(a || (b && (c != d))) >= e'\'' -a 0,1,1,2,0
1
$ test-expr '\''(a || (b && (c != d))) >= e'\'' -a 0,1,1,2,1
1
$ test-expr '\''(a || (b && (c != d))) >= e'\'' -a 0,2,0,0,1
0
$ test-expr '\''(a || (b && (c != d))) >= e'\'' -a 0,2,0,0,2
0
$ test-expr '\''(a || (b && (c != d))) >= e'\'' -a 0,2,0,1,1
1
$ test-expr '\''(a || (b && (c != d))) >= e'\'' -a 0,2,1,0,2
0
$ test-expr '\''(a || (b && (c != d))) >= e'\'' -a 0,2,2,1,1
1
$ test-expr '\''(a || (b && (c != d))) >= e'\'' -a 1,0,0,0,0
1
$ test-expr '\''(a || (b && (c != d))) >= e'\'' -a 1,0,0,1,1
1
$ test-expr '\''(a || (b && (c != d))) >= e'\'' -a 1,0,1,1,0
1
$ test-expr '\''(a || (b && (c != d))) >= e'\'' -a 1,0,1,2,0
1
$ test-expr '\''(a || (b && (c != d))) >= e'\'' -a 1,0,1,2,1
1
$ test-expr '\''(a || (b && (c != d))) >= e'\'' -a 1,0,2,0,1
1
$ test-expr '\''(a || (b && (c != d))) >= e'\'' -a 1,0,2,0,2
0
$ test-expr '\''(a || (b && (c != d))) >= e'\'' -a 1,1,1,1,1
1
$ test-expr '\''(a || (b && (c != d))) >= e'\'' -a 1,1,1,1,2
0
$ test-expr '\''(a || (b && (c != d))) >= e'\'' -a 1,1,2,2,2
0
$ test-expr '\''(a || (b && (c != d))) >= e'\'' -a 1,2,0,0,1
1
$ test-expr '\''(a || (b && (c != d))) >= e'\'' -a 1,2,1,0,2
0
$ test-expr '\''(a || (b && (c != d))) >= e'\'' -a 1,2,2,1,2
0
$ test-expr '\''(a || (b && (c != d))) >= e'\'' -a 2,0,0,0,0
1
$ test-expr '\''(a || (b && (c != d))) >= e'\'' -a 2,0,0,2,2
0
$ test-expr '\''(a || (b && (c != d))) >= e'\'' -a 2,0,2,0,1
1
$ test-expr '\''(a || (b && (c != d))) >= e'\'' -a 2,0,2,0,2
0
$ test-expr '\''(a || (b && (c != d))) >= e'\'' -a 2,0,2,2,0
1
$ test-expr '\''(a || (b && (c != d))) >= e'\'' -a 2,1,0,2,1
1
$ test-expr '\''(a || (b && (c != d))) >= e'\'' -a 2,1,1,1,1
1
$ test-expr '\''(a || (b && (c != d))) >= e'\'' -a 2,1,1,2,2
0
$ test-expr '\''(a || (b && (c != d))) >= e'\'' -a 2,1,2,0,0
1
$ test-expr '\''(a || (b && (c != d))) >= e'\'' -a 2,2,0,1,1
1
$ test-expr '\''(a || (b && (c != d))) >= e'\'' -a 2,2,0,1,2
0
$ test-expr '\''(a || (b && (c >= d))) != e'\'' -a 0,0,1,0,2
1
$ test-expr '\''(a || (b && (c >= d))) != e'\'' -a 0,0,1,1,0
0
$ test-expr '\''(a || (b && (c >= d))) != e'\'' -a 0,0,2,1,1
1
$ test-expr '\''(a || (b && (c >= d))) != e'\'' -a 0,1,0,1,0
0
$ test-expr '\''(a || (b && (c >= d))) != e'\'' -a 0,1,0,1,1
1
$ test-expr '\''(a || (b && (c >= d))) != e'\'' -a 0,2,0,0,1
0
$ test-expr '\''(a || (b && (c >= d))) != e'\'' -a 0,2,2,0,0
1
$ test-expr '\''(a || (b && (c >= d))) != e'\'' -a 1,0,0,1,1
0
$ test-expr '\''(a || (b && (c >= d))) != e'\'' -a 1,0,0,2,0
1
$ test-expr '\''(a || (b && (c >= d))) != e'\'' -a 1,0,1,0,1
0
$ test-expr '\''(a || (b && (c >= d))) != e'\'' -a 1,0,2,0,2
1
$ test-expr '\''(a || (b && (c >= d))) != e'\'' -a 1,1,0,1,2
1
$ test-expr '\''(a || (b && (c >= d))) != e'\'' -a 1,1,1,1,0
1
$ test-expr '\''(a || (b && (c >= d))) != e'\'' -a 1,1,1,1,2
1
$ test-expr '\''(a || (b && (c >= d))) != e'\'' -a 1,1,2,1,2
1
$ test-expr '\''(a || (b && (c >= d))) != e'\'' -a 1,1,2,2,2
1
$ test-expr '\''(a || (b && (c >= d))) != e'\'' -a 1,2,0,0,0
1
$ test-expr '\''(a || (b && (c >= d))) != e'\'' -a 1,2,0,0,2
1
$ test-expr '\''(a || (b && (c >= d))) != e'\'' -a 1,2,0,1,2
1
$ test-expr '\''(a || (b && (c >= d))) != e'\'' -a 1,2,0,2,0
1
$ test-expr '\''(a || (b && (c >= d))) != e'\'' -a 1,2,1,0,0
1
$ test-expr '\''(a || (b && (c >= d))) != e'\'' -a 1,2,2,1,0
1
$ test-expr '\''(a || (b && (c >= d))) != e'\'' -a 1,2,2,1,1
0
$ test-expr '\''(a || (b && (c >= d))) != e'\'' -a 1,2,2,2,2
1
$ test-expr '\''(a || (b && (c >= d))) != e'\'' -a 2,0,1,2,0
1
$ test-expr '\''(a || (b && (c >= d))) != e'\'' -a 2,0,2,1,0
1
$ test-expr '\''(a || (b && (c >= d))) != e'\'' -a 2,1,1,0,0
1
$ test-expr '\''(a || (b && (c >= d))) != e'\'' -a 2,1,1,1,1
0
$ test-expr '\''(a || (b && (c >= d))) != e'\'' -a 2,1,1,2,2
1
$ test-expr '\''(a || (b && (c >= d))) != e'\'' -a 2,2,0,0,2
1
$ test-expr '\''(a || (b && (c >= d))) != e'\'' -a 2,2,0,2,0
1
$ test-expr '\''(a || (b && (c >= d))) != e'\'' -a 2,2,1,0,0
1
$ test-expr '\''(a || (b && (c >= d))) != e'\'' -a 2,2,1,1,0
1
$ test-expr '\''(a || (b && (c >= d))) != e'\'' -a 2,2,2,2,2
1
$ test-expr '\''(a || (b >= c)) != (d && e)'\'' -a 0,0,1,2,2
1
$ test-expr '\''(a || (b >= c)) != (d && e)'\'' -a 0,1,1,0,0
1
$ test-expr '\''(a || (b >= c)) != (d && e)'\'' -a 0,1,1,2,2
0
$ test-expr '\''(a || (b >= c)) != (d && e)'\'' -a 0,1,2,0,2
0
$ test-expr '\''(a || (b >= c)) != (d && e)'\'' -a 0,2,2,2,1
0
$ test-expr '\''(a || (b >= c)) != (d && e)'\'' -a 1,0,1,0,2
1
$ test-expr '\''(a || (b >= c)) != (d && e)'\'' -a 1,0,2,2,1
0
$ test-expr '\''(a || (b >= c)) != (d && e)'\'' -a 1,1,0,1,1
0
$ test-expr '\''(a || (b >= c)) != (d && e)'\'' -a 1,1,0,2,2
0
$ test-expr '\''(a || (b >= c)) != (d && e)'\'' -a 1,1,1,0,2
1
$ test-expr '\''(a || (b >= c)) != (d && e)'\'' -a 1,1,2,1,2
0
$ test-expr '\''(a || (b >= c)) != (d && e)'\'' -a 1,1,2,2,0
1
$ test-expr '\''(a || (b >= c)) != (d && e)'\'' -a 1,2,0,0,2
1
$ test-expr '\''(a || (b >= c)) != (d && e)'\'' -a 1,2,0,2,0
1
$ test-expr '\''(a || (b >= c)) != (d && e)'\'' -a 1,2,2,0,1
1
$ test-expr '\''(a || (b >= c)) != (d && e)'\'' -a 2,0,0,1,0
1
$ test-expr '\''(a || (b >= c)) != (d && e)'\'' -a 2,0,0,2,0
1
$ test-expr '\''(a || (b >= c)) != (d && e)'\'' -a 2,0,0,2,1
0
$ test-expr '\''(a || (b >= c)) != (d && e)'\'' -a 2,0,2,1,1
0
$ test-expr '\''(a || (b >= c)) != (d && e)'\'' -a 2,0,2,2,0
1
$ test-expr '\''(a || (b >= c)) != (d && e)'\'' -a 2,1,1,0,2
1
$ test-expr '\''(a || (b >= c)) != (d && e)'\'' -a 2,1,1,1,0
1
$ test-expr '\''(a || (b >= c)) != (d && e)'\'' -a 2,2,0,2,0
1
$ test-expr '\''(a || (b >= c)) != (d && e)'\'' -a 2,2,1,0,0
1
$ test-expr '\''(a || (b >= c)) != (d && e)'\'' -a 2,2,1,0,2
1
$ test-expr '\''(a || (b >= c)) != (d && e)'\'' -a 2,2,2,0,2
1
$ test-expr '\''(a || (b >= c)) && (d != e)'\'' -a 0,0,1,2,1
0
$ test-expr '\''(a || (b >= c)) && (d != e)'\'' -a 0,1,0,2,1
1
$ test-expr '\''(a || (b >= c)) && (d != e)'\'' -a 0,1,1,0,2
1
$ test-expr '\''(a || (b >= c)) && (d != e)'\'' -a 0,2,1,1,2
1
$ test-expr '\''(a || (b >= c)) && (d != e)'\'' -a 0,2,2,0,1
1
$ test-expr '\''(a || (b >= c)) && (d != e)'\'' -a 0,2,2,2,2
0
$ test-expr '\''(a || (b >= c)) && (d != e)'\'' -a 1,0,0,0,1
1
$ test-expr '\''(a || (b >= c)) && (d != e)'\'' -a 1,0,0,2,0
1
$ test-expr '\''(a || (b >= c)) && (d != e)'\'' -a 1,0,2,0,0
0
$ test-expr '\''(a || (b >= c)) && (d != e)'\'' -a 1,0,2,0,2
1
$ test-expr '\''(a || (b >= c)) && (d != e)'\'' -a 1,0,2,2,0
1
$ test-expr '\''(a || (b >= c)) && (d != e)'\'' -a 1,2,0,0,0
0
$ test-expr '\''(a || (b >= c)) && (d != e)'\'' -a 1,2,1,1,2
1
$ test-expr '\''(a || (b >= c)) && (d != e)'\'' -a 1,2,1,2,0
1
$ test-expr '\''(a || (b >= c)) && (d != e)'\'' -a 1,2,2,1,2
1
$ test-expr '\''(a || (b >= c)) && (d != e)'\'' -a 1,2,2,2,1
1
$ test-expr '\''(a || (b >= c)) && (d != e)'\'' -a 2,0,0,0,1
1
$ test-expr '\''(a || (b >= c)) && (d != e)'\'' -a 2,1,1,1,1
0
$ test-expr '\''(a || (b >= c)) && (d != e)'\'' -a 2,1,1,2,1
1
$ test-expr '\''(a || (b >= c)) && (d != e)'\'' -a 2,1,2,0,1
1
$ test-expr '\''(a || (b >= c)) && (d != e)'\'' -a 2,1,2,1,0
1
$ test-expr '\''(a || (b >= c)) && (d != e)'\'' -a 2,1,2,2,0
1
$ test-expr '\''(a || (b >= c)) && (d != e)'\'' -a 2,2,0,1,0
1
$ test-expr '\''(a || (b >= c)) && (d != e)'\'' -a 2,2,0,1,2
1
$ test-expr '\''(a || (b >= (c != d))) && e'\'' -a 0,0,1,1,1
1
$ test-expr '\''(a || (b >= (c != d))) && e'\'' -a 0,0,1,2,1
0
$ test-expr '\''(a || (b >= (c != d))) && e'\'' -a 0,1,0,1,1
1
$ test-expr '\''(a || (b >= (c != d))) && e'\'' -a 0,1,0,1,2
1
$ test-expr '\''(a || (b >= (c != d))) && e'\'' -a 0,1,0,2,0
0
$ test-expr '\''(a || (b >= (c != d))) && e'\'' -a 0,1,1,0,0
0
$ test-expr '\''(a || (b >= (c != d))) && e'\'' -a 0,1,1,1,0
0
$ test-expr '\''(a || (b >= (c != d))) && e'\'' -a 0,1,2,0,1
1
$ test-expr '\''(a || (b >= (c != d))) && e'\'' -a 0,2,1,1,2
1
$ test-expr '\''(a || (b >= (c != d))) && e'\'' -a 0,2,1,2,0
0
$ test-expr '\''(a || (b >= (c != d))) && e'\'' -a 0,2,2,2,1
1
$ test-expr '\''(a || (b >= (c != d))) && e'\'' -a 1,0,1,0,2
1
$ test-expr '\''(a || (b >= (c != d))) && e'\'' -a 1,0,2,0,1
1
$ test-expr '\''(a || (b >= (c != d))) && e'\'' -a 1,0,2,0,2
1
$ test-expr '\''(a || (b >= (c != d))) && e'\'' -a 1,0,2,2,0
0
$ test-expr '\''(a || (b >= (c != d))) && e'\'' -a 1,1,0,1,1
1
$ test-expr '\''(a || (b >= (c != d))) && e'\'' -a 1,1,2,1,1
1
$ test-expr '\''(a || (b >= (c != d))) && e'\'' -a 1,1,2,2,1
1
$ test-expr '\''(a || (b >= (c != d))) && e'\'' -a 1,2,0,1,2
1
$ test-expr '\''(a || (b >= (c != d))) && e'\'' -a 1,2,1,2,0
0
$ test-expr '\''(a || (b >= (c != d))) && e'\'' -a 2,0,0,0,1
1
$ test-expr '\''(a || (b >= (c != d))) && e'\'' -a 2,0,1,1,1
1
$ test-expr '\''(a || (b >= (c != d))) && e'\'' -a 2,0,1,1,2
1
$ test-expr '\''(a || (b >= (c != d))) && e'\'' -a 2,0,2,0,2
1
$ test-expr '\''(a || (b >= (c != d))) && e'\'' -a 2,1,0,2,2
1
$ test-expr '\''(a || (b >= (c != d))) && e'\'' -a 2,1,1,0,2
1
$ test-expr '\''(a || (b >= (c != d))) && e'\'' -a 2,1,2,1,1
1
$ test-expr '\''(a || (b >= (c != d))) && e'\'' -a 2,1,2,2,0
0
$ test-expr '\''(a || (b >= (c != d))) && e'\'' -a 2,2,0,1,0
0
$ test-expr '\''(a || (b >= (c != d))) && e'\'' -a 2,2,0,2,0
0
$ test-expr '\''(a || (b >= (c && d))) != e'\'' -a 0,0,0,0,1
0
$ test-expr '\''(a || (b >= (c && d))) != e'\'' -a 0,0,0,2,2
1
$ test-expr '\''(a || (b >= (c && d))) != e'\'' -a 0,0,1,2,1
1
$ test-expr '\''(a || (b >= (c && d))) != e'\'' -a 0,0,2,1,0
0
$ test-expr '\''(a || (b >= (c && d))) != e'\'' -a 0,1,0,2,0
1
$ test-expr '\''(a || (b >= (c && d))) != e'\'' -a 0,1,2,1,0
1
$ test-expr '\''(a || (b >= (c && d))) != e'\'' -a 0,2,2,1,2
1
$ test-expr '\''(a || (b >= (c && d))) != e'\'' -a 0,2,2,2,1
0
$ test-expr '\''(a || (b >= (c && d))) != e'\'' -a 1,0,0,0,2
1
$ test-expr '\''(a || (b >= (c && d))) != e'\'' -a 1,0,0,2,0
1
$ test-expr '\''(a || (b >= (c && d))) != e'\'' -a 1,0,2,1,1
0
$ test-expr '\''(a || (b >= (c && d))) != e'\'' -a 1,1,0,1,1
0
$ test-expr '\''(a || (b >= (c && d))) != e'\'' -a 1,1,1,0,0
1
$ test-expr '\''(a || (b >= (c && d))) != e'\'' -a 1,1,1,1,0
1
$ test-expr '\''(a || (b >= (c && d))) != e'\'' -a 1,1,1,1,2
1
$ test-expr '\''(a || (b >= (c && d))) != e'\'' -a 1,1,1,2,0
1
$ test-expr '\''(a || (b >= (c && d))) != e'\'' -a 1,1,1,2,2
1
$ test-expr '\''(a || (b >= (c && d))) != e'\'' -a 1,1,2,2,2
1
$ test-expr '\''(a || (b >= (c && d))) != e'\'' -a 1,2,0,0,2
1
$ test-expr '\''(a || (b >= (c && d))) != e'\'' -a 1,2,0,2,2
1
$ test-expr '\''(a || (b >= (c && d))) != e'\'' -a 1,2,1,1,0
1
$ test-expr '\''(a || (b >= (c && d))) != e'\'' -a 2,0,0,1,0
1
$ test-expr '\''(a || (b >= (c && d))) != e'\'' -a 2,0,1,1,0
1
$ test-expr '\''(a || (b >= (c && d))) != e'\'' -a 2,0,1,2,1
0
$ test-expr '\''(a || (b >= (c && d))) != e'\'' -a 2,0,2,0,2
1
$ test-expr '\''(a || (b >= (c && d))) != e'\'' -a 2,1,0,0,1
0
$ test-expr '\''(a || (b >= (c && d))) != e'\'' -a 2,1,0,1,0
1
$ test-expr '\''(a || (b >= (c && d))) != e'\'' -a 2,1,0,1,1
0
$ test-expr '\''(a || (b >= (c && d))) != e'\'' -a 2,1,0,2,2
1
$ test-expr '\''(a || (b >= (c && d))) != e'\'' -a 2,2,0,0,2
1
$ test-expr '\''(a || (b >= (c && d))) != e'\'' -a 2,2,1,1,0
1
$ test-expr '\''(a || ((b != c) && d)) >= e'\'' -a 0,0,0,0,0
1
$ test-expr '\''(a || ((b != c) && d)) >= e'\'' -a 0,0,0,0,1
0
$ test-expr '\''(a || ((b != c) && d)) >= e'\'' -a 0,0,0,1,1
0
$ test-expr '\''(a || ((b != c) && d)) >= e'\'' -a 0,0,1,1,1
1
$ test-expr '\''(a || ((b != c) && d)) >= e'\'' -a 0,0,1,2,2
0
$ test-expr '\''(a || ((b != c) && d)) >= e'\'' -a 0,0,2,2,0
1
$ test-expr '\''(a || ((b != c) && d)) >= e'\'' -a 0,0,2,2,2
0
$ test-expr '\''(a || ((b != c) && d)) >= e'\'' -a 0,1,0,0,0
1
$ test-expr '\''(a || ((b != c) && d)) >= e'\'' -a 0,1,2,0,0
1
$ test-expr '\''(a || ((b != c) && d)) >= e'\'' -a 0,2,0,1,2
0
$ test-expr '\''(a || ((b != c) && d)) >= e'\'' -a 0,2,1,0,1
0
$ test-expr '\''(a || ((b != c) && d)) >= e'\'' -a 0,2,2,1,1
0
$ test-expr '\''(a || ((b != c) && d)) >= e'\'' -a 0,2,2,1,2
0
$ test-expr '\''(a || ((b != c) && d)) >= e'\'' -a 1,0,0,1,0
1
$ test-expr '\''(a || ((b != c) && d)) >= e'\'' -a 1,0,2,1,0
1
$ test-expr '\''(a || ((b != c) && d)) >= e'\'' -a 1,0,2,1,1
1
$ test-expr '\''(a || ((b != c) && d)) >= e'\'' -a 1,0,2,2,1
1
$ test-expr '\''(a || ((b != c) && d)) >= e'\'' -a 1,1,0,1,0
1
$ test-expr '\''(a || ((b != c) && d)) >= e'\'' -a 1,1,0,1,2
0
$ test-expr '\''(a || ((b != c) && d)) >= e'\'' -a 1,1,1,0,0
1
$ test-expr '\''(a || ((b != c) && d)) >= e'\'' -a 1,1,1,0,2
0
$ test-expr '\''(a || ((b != c) && d)) >= e'\'' -a 1,2,0,0,1
1
$ test-expr '\''(a || ((b != c) && d)) >= e'\'' -a 1,2,1,1,2
0
$ test-expr '\''(a || ((b != c) && d)) >= e'\'' -a 1,2,2,2,0
1
$ test-expr '\''(a || ((b != c) && d)) >= e'\'' -a 2,0,0,0,0
1
$ test-expr '\''(a || ((b != c) && d)) >= e'\'' -a 2,0,1,0,0
1
$ test-expr '\''(a || ((b != c) && d)) >= e'\'' -a 2,0,1,2,0
1
$ test-expr '\''(a || ((b != c) && d)) >= e'\'' -a 2,0,2,0,1
1
$ test-expr '\''(a || ((b != c) && d)) >= e'\'' -a 2,2,0,1,1
1
$ test-expr '\''(a || ((b != c) && d)) >= e'\'' -a 2,2,2,1,0
1
$ test-expr '\''(a || ((b != c) && d)) >= e'\'' -a 2,2,2,1,1
1
$ test-expr '\''(a || ((b != c) >= d)) && e'\'' -a 0,0,0,1,0
0
$ test-expr '\''(a || ((b != c) >= d)) && e'\'' -a 0,0,1,0,2
1
$ test-expr '\''(a || ((b != c) >= d)) && e'\'' -a 0,0,1,2,0
0
$ test-expr '\''(a || ((b != c) >= d)) && e'\'' -a 0,1,0,2,1
0
$ test-expr '\''(a || ((b != c) >= d)) && e'\'' -a 0,1,0,2,2
0
$ test-expr '\''(a || ((b != c) >= d)) && e'\'' -a 0,1,1,0,2
1
$ test-expr '\''(a || ((b != c) >= d)) && e'\'' -a 0,1,1,2,0
0
$ test-expr '\''(a || ((b != c) >= d)) && e'\'' -a 0,2,0,1,0
0
$ test-expr '\''(a || ((b != c) >= d)) && e'\'' -a 0,2,1,0,1
1
$ test-expr '\''(a || ((b != c) >= d)) && e'\'' -a 0,2,1,1,2
1
$ test-expr '\''(a || ((b != c) >= d)) && e'\'' -a 1,0,0,2,1
1
$ test-expr '\''(a || ((b != c) >= d)) && e'\'' -a 1,0,1,2,2
1
$ test-expr '\''(a || ((b != c) >= d)) && e'\'' -a 1,0,2,2,0
0
$ test-expr '\''(a || ((b != c) >= d)) && e'\'' -a 1,0,2,2,2
1
$ test-expr '\''(a || ((b != c) >= d)) && e'\'' -a 1,1,0,0,1
1
$ test-expr '\''(a || ((b != c) >= d)) && e'\'' -a 1,1,0,1,2
1
$ test-expr '\''(a || ((b != c) >= d)) && e'\'' -a 1,1,1,2,1
1
$ test-expr '\''(a || ((b != c) >= d)) && e'\'' -a 1,1,2,2,0
0
$ test-expr '\''(a || ((b != c) >= d)) && e'\'' -a 1,2,0,2,1
1
$ test-expr '\''(a || ((b != c) >= d)) && e'\'' -a 1,2,1,0,1
1
$ test-expr '\''(a || ((b != c) >= d)) && e'\'' -a 1,2,1,2,1
1
$ test-expr '\''(a || ((b != c) >= d)) && e'\'' -a 1,2,1,2,2
1
$ test-expr '\''(a || ((b != c) >= d)) && e'\'' -a 2,0,1,2,0
0
$ test-expr '\''(a || ((b != c) >= d)) && e'\'' -a 2,0,1,2,2
1
$ test-expr '\''(a || ((b != c) >= d)) && e'\'' -a 2,0,2,1,1
1
$ test-expr '\''(a || ((b != c) >= d)) && e'\'' -a 2,0,2,2,2
1
$ test-expr '\''(a || ((b != c) >= d)) && e'\'' -a 2,1,0,2,0
0
$ test-expr '\''(a || ((b != c) >= d)) && e'\'' -a 2,1,1,2,0
0
$ test-expr '\''(a || ((b != c) >= d)) && e'\'' -a 2,1,2,1,0
0
$ test-expr '\''(a || ((b != c) >= d)) && e'\'' -a 2,2,0,0,0
0
$ test-expr '\''(a || ((b != c) >= d)) && e'\'' -a 2,2,2,1,2
1
$ test-expr '\''(a || ((b && c) != d)) >= e'\'' -a 0,0,1,2,2
0
$ test-expr '\''(a || ((b && c) != d)) >= e'\'' -a 0,0,2,0,0
1
$ test-expr '\''(a || ((b && c) != d)) >= e'\'' -a 0,1,1,0,2
0
$ test-expr '\''(a || ((b && c) != d)) >= e'\'' -a 0,1,2,1,1
0
$ test-expr '\''(a || ((b && c) != d)) >= e'\'' -a 0,2,0,2,1
1
$ test-expr '\''(a || ((b && c) != d)) >= e'\'' -a 0,2,1,1,1
0
$ test-expr '\''(a || ((b && c) != d)) >= e'\'' -a 0,2,1,2,1
1
$ test-expr '\''(a || ((b && c) != d)) >= e'\'' -a 0,2,2,1,2
0
$ test-expr '\''(a || ((b && c) != d)) >= e'\'' -a 0,2,2,2,0
1
$ test-expr '\''(a || ((b && c) != d)) >= e'\'' -a 1,0,1,1,0
1
$ test-expr '\''(a || ((b && c) != d)) >= e'\'' -a 1,1,0,2,0
1
$ test-expr '\''(a || ((b && c) != d)) >= e'\'' -a 1,1,1,1,1
1
$ test-expr '\''(a || ((b && c) != d)) >= e'\'' -a 1,1,2,0,2
0
$ test-expr '\''(a || ((b && c) != d)) >= e'\'' -a 1,2,0,2,1
1
$ test-expr '\''(a || ((b && c) != d)) >= e'\'' -a 1,2,2,0,1
1
$ test-expr '\''(a || ((b && c) != d)) >= e'\'' -a 2,0,0,0,2
0
$ test-expr '\''(a || ((b && c) != d)) >= e'\'' -a 2,0,1,1,0
1
$ test-expr '\''(a || ((b && c) != d)) >= e'\'' -a 2,0,1,2,1
1
$ test-expr '\''(a || ((b && c) != d)) >= e'\'' -a 2,1,0,1,1
1
$ test-expr '\''(a || ((b && c) != d)) >= e'\'' -a 2,1,2,1,2
0
$ test-expr '\''(a || ((b && c) != d)) >= e'\'' -a 2,1,2,2,0
1
$ test-expr '\''(a || ((b && c) != d)) >= e'\'' -a 2,1,2,2,1
1
$ test-expr '\''(a || ((b && c) != d)) >= e'\'' -a 2,2,0,0,0
1
$ test-expr '\''(a || ((b && c) != d)) >= e'\'' -a 2,2,0,2,2
0
$ test-expr '\''(a || ((b && c) != d)) >= e'\'' -a 2,2,2,1,2
0
$ test-expr '\''(a || ((b && c) >= d)) != e'\'' -a 0,0,2,1,1
1
$ test-expr '\''(a || ((b && c) >= d)) != e'\'' -a 0,1,0,1,0
0
$ test-expr '\''(a || ((b && c) >= d)) != e'\'' -a 0,1,0,1,1
1
$ test-expr '\''(a || ((b && c) >= d)) != e'\'' -a 0,1,1,1,0
1
$ test-expr '\''(a || ((b && c) >= d)) != e'\'' -a 0,1,1,1,1
0
$ test-expr '\''(a || ((b && c) >= d)) != e'\'' -a 0,1,2,0,1
0
$ test-expr '\''(a || ((b && c) >= d)) != e'\'' -a 0,2,0,0,1
0
$ test-expr '\''(a || ((b && c) >= d)) != e'\'' -a 0,2,0,2,1
1
$ test-expr '\''(a || ((b && c) >= d)) != e'\'' -a 0,2,1,1,2
1
$ test-expr '\''(a || ((b && c) >= d)) != e'\'' -a 1,0,1,1,0
1
$ test-expr '\''(a || ((b && c) >= d)) != e'\'' -a 1,0,1,2,1
0
$ test-expr '\''(a || ((b && c) >= d)) != e'\'' -a 1,0,2,1,0
1
$ test-expr '\''(a || ((b && c) >= d)) != e'\'' -a 1,1,0,0,0
1
$ test-expr '\''(a || ((b && c) >= d)) != e'\'' -a 1,1,0,2,2
1
$ test-expr '\''(a || ((b && c) >= d)) != e'\'' -a 1,1,2,1,0
1
$ test-expr '\''(a || ((b && c) >= d)) != e'\'' -a 1,1,2,1,1
0
$ test-expr '\''(a || ((b && c) >= d)) != e'\'' -a 1,2,0,1,0
1
$ test-expr '\''(a || ((b && c) >= d)) != e'\'' -a 1,2,0,2,1
0
$ test-expr '\''(a || ((b && c) >= d)) != e'\'' -a 2,1,0,1,2
1
$ test-expr '\''(a || ((b && c) >= d)) != e'\'' -a 2,1,2,1,0
1
$ test-expr '\''(a || ((b && c) >= d)) != e'\'' -a 2,1,2,2,0
1
$ test-expr '\''(a || ((b && c) >= d)) != e'\'' -a 2,2,0,0,1
0
$ test-expr '\''(a || ((b && c) >= d)) != e'\'' -a 2,2,0,2,1
0
$ test-expr '\''(a || ((b && c) >= d)) != e'\'' -a 2,2,1,1,1
0
$ test-expr '\''(a || ((b && c) >= d)) != e'\'' -a 2,2,1,2,2
1
$ test-expr '\''(a || ((b && c) >= d)) != e'\'' -a 2,2,2,0,0
1
$ test-expr '\''(a || ((b && c) >= d)) != e'\'' -a 2,2,2,0,1
0
$ test-expr '\''(a || ((b >= c) != d)) && e'\'' -a 0,0,0,1,2
0
$ test-expr '\''(a || ((b >= c) != d)) && e'\'' -a 0,0,1,0,0
0
$ test-expr '\''(a || ((b >= c) != d)) && e'\'' -a 0,0,1,2,2
1
$ test-expr '\''(a || ((b >= c) != d)) && e'\'' -a 0,0,2,1,0
0
$ test-expr '\''(a || ((b >= c) != d)) && e'\'' -a 0,0,2,2,0
0
$ test-expr '\''(a || ((b >= c) != d)) && e'\'' -a 0,0,2,2,2
1
$ test-expr '\''(a || ((b >= c) != d)) && e'\'' -a 0,1,0,1,2
0
$ test-expr '\''(a || ((b >= c) != d)) && e'\'' -a 0,1,0,2,1
1
$ test-expr '\''(a || ((b >= c) != d)) && e'\'' -a 0,1,2,2,2
1
$ test-expr '\''(a || ((b >= c) != d)) && e'\'' -a 0,2,1,1,1
0
$ test-expr '\''(a || ((b >= c) != d)) && e'\'' -a 0,2,2,2,2
1
$ test-expr '\''(a || ((b >= c) != d)) && e'\'' -a 1,0,0,1,0
0
$ test-expr '\''(a || ((b >= c) != d)) && e'\'' -a 1,0,0,2,1
1
$ test-expr '\''(a || ((b >= c) != d)) && e'\'' -a 1,0,2,0,1
1
$ test-expr '\''(a || ((b >= c) != d)) && e'\'' -a 1,0,2,1,2
1
$ test-expr '\''(a || ((b >= c) != d)) && e'\'' -a 1,0,2,2,1
1
$ test-expr '\''(a || ((b >= c) != d)) && e'\'' -a 1,1,0,1,2
1
$ test-expr '\''(a || ((b >= c) != d)) && e'\'' -a 1,1,1,0,0
0
$ test-expr '\''(a || ((b >= c) != d)) && e'\'' -a 1,1,2,0,0
0
$ test-expr '\''(a || ((b >= c) != d)) && e'\'' -a 1,1,2,0,1
1
$ test-expr '\''(a || ((b >= c) != d)) && e'\'' -a 1,1,2,1,0
0
$ test-expr '\''(a || ((b >= c) != d)) && e'\'' -a 1,2,0,1,2
1
$ test-expr '\''(a || ((b >= c) != d)) && e'\'' -a 1,2,0,2,2
1
$ test-expr '\''(a || ((b >= c) != d)) && e'\'' -a 1,2,1,0,0
0
$ test-expr '\''(a || ((b >= c) != d)) && e'\'' -a 1,2,1,2,0
0
$ test-expr '\''(a || ((b >= c) != d)) && e'\'' -a 1,2,2,0,0
0
$ test-expr '\''(a || ((b >= c) != d)) && e'\'' -a 2,0,0,1,1
1
$ test-expr '\''(a || ((b >= c) != d)) && e'\'' -a 2,0,1,2,0
0
$ test-expr '\''(a || ((b >= c) != d)) && e'\'' -a 2,0,2,0,1
1
$ test-expr '\''(a || ((b >= c) != d)) && e'\'' -a 2,1,1,0,0
0
$ test-expr '\''(a || ((b >= c) != d)) && e'\'' -a 2,1,2,2,1
1
$ test-expr '\''(a || ((b >= c) != d)) && e'\'' -a 2,2,0,0,2
1
$ test-expr '\''(a || ((b >= c) != d)) && e'\'' -a 2,2,0,2,1
1
$ test-expr '\''(a || ((b >= c) != d)) && e'\'' -a 2,2,1,2,1
1
$ test-expr '\''(a || ((b >= c) != d)) && e'\'' -a 2,2,2,2,0
0
$ test-expr '\''(a || ((b >= c) && d)) != e'\'' -a 0,1,0,1,2
1
$ test-expr '\''(a || ((b >= c) && d)) != e'\'' -a 0,1,2,2,2
1
$ test-expr '\''(a || ((b >= c) && d)) != e'\'' -a 0,2,1,0,2
1
$ test-expr '\''(a || ((b >= c) && d)) != e'\'' -a 0,2,1,1,2
1
$ test-expr '\''(a || ((b >= c) && d)) != e'\'' -a 0,2,1,2,1
0
$ test-expr '\''(a || ((b >= c) && d)) != e'\'' -a 0,2,2,1,1
0
$ test-expr '\''(a || ((b >= c) && d)) != e'\'' -a 1,0,0,0,0
1
$ test-expr '\''(a || ((b >= c) && d)) != e'\'' -a 1,0,1,0,2
1
$ test-expr '\''(a || ((b >= c) && d)) != e'\'' -a 1,0,1,1,1
0
$ test-expr '\''(a || ((b >= c) && d)) != e'\'' -a 1,0,2,0,2
1
$ test-expr '\''(a || ((b >= c) && d)) != e'\'' -a 1,1,0,0,0
1
$ test-expr '\''(a || ((b >= c) && d)) != e'\'' -a 1,1,1,0,1
0
$ test-expr '\''(a || ((b >= c) && d)) != e'\'' -a 1,1,2,0,1
0
$ test-expr '\''(a || ((b >= c) && d)) != e'\'' -a 1,1,2,0,2
1
$ test-expr '\''(a || ((b >= c) && d)) != e'\'' -a 1,1,2,2,0
1
$ test-expr '\''(a || ((b >= c) && d)) != e'\'' -a 1,2,2,1,0
1
$ test-expr '\''(a || ((b >= c) && d)) != e'\'' -a 2,0,0,1,1
0
$ test-expr '\''(a || ((b >= c) && d)) != e'\'' -a 2,0,1,1,1
0
$ test-expr '\''(a || ((b >= c) && d)) != e'\'' -a 2,0,1,2,2
1
$ test-expr '\''(a || ((b >= c) && d)) != e'\'' -a 2,1,0,0,1
0
$ test-expr '\''(a || ((b >= c) && d)) != e'\'' -a 2,1,0,1,0
1
$ test-expr '\''(a || ((b >= c) && d)) != e'\'' -a 2,1,1,1,1
0
$ test-expr '\''(a || ((b >= c) && d)) != e'\'' -a 2,1,2,2,2
1
$ test-expr '\''(a || ((b >= c) && d)) != e'\'' -a 2,2,0,1,2
1
$ test-expr '\''(a || ((b >= c) && d)) != e'\'' -a 2,2,0,2,1
0
$ test-expr '\''((a != b) && c) >= (d || e)'\'' -a 0,0,0,1,1
0
$ test-expr '\''((a != b) && c) >= (d || e)'\'' -a 0,0,1,2,1
0
$ test-expr '\''((a != b) && c) >= (d || e)'\'' -a 0,0,2,1,1
0
$ test-expr '\''((a != b) && c) >= (d || e)'\'' -a 0,1,0,0,1
0
$ test-expr '\''((a != b) && c) >= (d || e)'\'' -a 0,1,0,1,1
0
$ test-expr '\''((a != b) && c) >= (d || e)'\'' -a 0,1,0,2,1
0
$ test-expr '\''((a != b) && c) >= (d || e)'\'' -a 0,2,0,2,2
0
$ test-expr '\''((a != b) && c) >= (d || e)'\'' -a 0,2,1,0,0
1
$ test-expr '\''((a != b) && c) >= (d || e)'\'' -a 1,0,0,1,0
0
$ test-expr '\''((a != b) && c) >= (d || e)'\'' -a 1,0,1,1,0
1
$ test-expr '\''((a != b) && c) >= (d || e)'\'' -a 1,0,2,1,1
1
$ test-expr '\''((a != b) && c) >= (d || e)'\'' -a 1,1,0,1,2
0
$ test-expr '\''((a != b) && c) >= (d || e)'\'' -a 1,1,0,2,2
0
$ test-expr '\''((a != b) && c) >= (d || e)'\'' -a 1,1,1,1,0
0
$ test-expr '\''((a != b) && c) >= (d || e)'\'' -a 1,1,1,2,1
0
$ test-expr '\''((a != b) && c) >= (d || e)'\'' -a 1,1,2,0,0
1
$ test-expr '\''((a != b) && c) >= (d || e)'\'' -a 1,2,0,0,2
0
$ test-expr '\''((a != b) && c) >= (d || e)'\'' -a 1,2,0,1,2
0
$ test-expr '\''((a != b) && c) >= (d || e)'\'' -a 1,2,0,2,2
0
$ test-expr '\''((a != b) && c) >= (d || e)'\'' -a 1,2,2,0,0
1
$ test-expr '\''((a != b) && c) >= (d || e)'\'' -a 1,2,2,0,1
1
$ test-expr '\''((a != b) && c) >= (d || e)'\'' -a 1,2,2,1,1
1
$ test-expr '\''((a != b) && c) >= (d || e)'\'' -a 2,0,1,1,2
1
$ test-expr '\''((a != b) && c) >= (d || e)'\'' -a 2,0,2,0,1
1
$ test-expr '\''((a != b) && c) >= (d || e)'\'' -a 2,1,0,0,2
0
$ test-expr '\''((a != b) && c) >= (d || e)'\'' -a 2,1,0,2,0
0
$ test-expr '\''((a != b) && c) >= (d || e)'\'' -a 2,1,0,2,1
0
$ test-expr '\''((a != b) && c) >= (d || e)'\'' -a 2,1,1,0,0
1
$ test-expr '\''((a != b) && c) >= (d || e)'\'' -a 2,1,1,2,0
1
$ test-expr '\''((a != b) && c) >= (d || e)'\'' -a 2,2,0,0,2
0
$ test-expr '\''((a != b) && c) >= (d || e)'\'' -a 2,2,1,2,2
0
$ test-expr '\''((a != b) && c) >= (d || e)'\'' -a 2,2,2,2,0
0
$ test-expr '\''((a != b) && c) || (d >= e)'\'' -a 0,0,0,2,1
1
$ test-expr '\''((a != b) && c) || (d >= e)'\'' -a 0,0,1,1,2
0
$ test-expr '\''((a != b) && c) || (d >= e)'\'' -a 0,0,1,2,2
1
$ test-expr '\''((a != b) && c) || (d >= e)'\'' -a 0,1,0,2,2
1
$ test-expr '\''((a != b) && c) || (d >= e)'\'' -a 0,2,0,1,2
0
$ test-expr '\''((a != b) && c) || (d >= e)'\'' -a 0,2,1,2,1
1
$ test-expr '\''((a != b) && c) || (d >= e)'\'' -a 0,2,2,1,1
1
$ test-expr '\''((a != b) && c) || (d >= e)'\'' -a 0,2,2,2,2
1
$ test-expr '\''((a != b) && c) || (d >= e)'\'' -a 1,0,1,2,0
1
$ test-expr '\''((a != b) && c) || (d >= e)'\'' -a 1,0,2,1,0
1
$ test-expr '\''((a != b) && c) || (d >= e)'\'' -a 1,0,2,1,2
1
$ test-expr '\''((a != b) && c) || (d >= e)'\'' -a 1,1,0,2,0
1
$ test-expr '\''((a != b) && c) || (d >= e)'\'' -a 1,1,1,2,1
1
$ test-expr '\''((a != b) && c) || (d >= e)'\'' -a 1,1,2,1,2
0
$ test-expr '\''((a != b) && c) || (d >= e)'\'' -a 1,1,2,2,1
1
$ test-expr '\''((a != b) && c) || (d >= e)'\'' -a 1,2,0,1,0
1
$ test-expr '\''((a != b) && c) || (d >= e)'\'' -a 1,2,0,2,2
1
$ test-expr '\''((a != b) && c) || (d >= e)'\'' -a 1,2,2,2,1
1
$ test-expr '\''((a != b) && c) || (d >= e)'\'' -a 2,0,0,1,2
0
$ test-expr '\''((a != b) && c) || (d >= e)'\'' -a 2,0,2,0,2
1
$ test-expr '\''((a != b) && c) || (d >= e)'\'' -a 2,1,0,2,0
1
$ test-expr '\''((a != b) && c) || (d >= e)'\'' -a 2,1,1,0,2
1
$ test-expr '\''((a != b) && c) || (d >= e)'\'' -a 2,1,1,2,2
1
$ test-expr '\''((a != b) && c) || (d >= e)'\'' -a 2,1,2,0,2
1
$ test-expr '\''((a != b) && c) || (d >= e)'\'' -a 2,1,2,1,1
1
$ test-expr '\''((a != b) && c) || (d >= e)'\'' -a 2,2,0,0,2
0
$ test-expr '\''((a != b) && c) || (d >= e)'\'' -a 2,2,0,1,2
0
$ test-expr '\''((a != b) && c) || (d >= e)'\'' -a 2,2,2,1,2
0
$ test-expr '\''((a != b) && c) || (d >= e)'\'' -a 2,2,2,2,0
1
$ test-expr '\''((a != b) && (c >= d)) || e'\'' -a 0,0,0,0,0
0
$ test-expr '\''((a != b) && (c >= d)) || e'\'' -a 0,0,0,2,0
0
$ test-expr '\''((a != b) && (c >= d)) || e'\'' -a 0,0,2,0,2
1
$ test-expr '\''((a != b) && (c >= d)) || e'\'' -a 0,1,2,1,2
1
$ test-expr '\''((a != b) && (c >= d)) || e'\'' -a 0,1,2,2,0
1
$ test-expr '\''((a != b) && (c >= d)) || e'\'' -a 0,2,0,0,2
1
$ test-expr '\''((a != b) && (c >= d)) || e'\'' -a 0,2,2,1,1
1
$ test-expr '\''((a != b) && (c >= d)) || e'\'' -a 1,0,0,1,1
1
$ test-expr '\''((a != b) && (c >= d)) || e'\'' -a 1,0,1,0,0
1
$ test-expr '\''((a != b) && (c >= d)) || e'\'' -a 1,1,2,2,0
0
$ test-expr '\''((a != b) && (c >= d)) || e'\'' -a 1,2,0,0,1
1
$ test-expr '\''((a != b) && (c >= d)) || e'\'' -a 1,2,1,0,2
1
$ test-expr '\''((a != b) && (c >= d)) || e'\'' -a 2,0,1,2,0
0
$ test-expr '\''((a != b) && (c >= d)) || e'\'' -a 2,0,2,2,0
1
$ test-expr '\''((a != b) && (c >= d)) || e'\'' -a 2,1,1,0,2
1
$ test-expr '\''((a != b) && (c >= d)) || e'\'' -a 2,1,2,1,1
1
$ test-expr '\''((a != b) && (c >= d)) || e'\'' -a 2,1,2,2,2
1
$ test-expr '\''((a != b) && (c >= d)) || e'\'' -a 2,2,0,0,0
0
$ test-expr '\''((a != b) && (c >= d)) || e'\'' -a 2,2,1,0,1
1
$ test-expr '\''((a != b) && (c >= d)) || e'\'' -a 2,2,1,0,2
1
$ test-expr '\''((a != b) && (c >= d)) || e'\'' -a 2,2,2,2,0
0
$ test-expr '\''((a != b) && (c || d)) >= e'\'' -a 0,0,1,0,0
1
$ test-expr '\''((a != b) && (c || d)) >= e'\'' -a 0,0,1,1,0
1
$ test-expr '\''((a != b) && (c || d)) >= e'\'' -a 0,0,1,2,2
0
$ test-expr '\''((a != b) && (c || d)) >= e'\'' -a 0,1,2,2,0
1
$ test-expr '\''((a != b) && (c || d)) >= e'\'' -a 0,2,1,1,1
1
$ test-expr '\''((a != b) && (c || d)) >= e'\'' -a 0,2,1,1,2
0
$ test-expr '\''((a != b) && (c || d)) >= e'\'' -a 0,2,2,0,2
0
$ test-expr '\''((a != b) && (c || d)) >= e'\'' -a 0,2,2,1,0
1
$ test-expr '\''((a != b) && (c || d)) >= e'\'' -a 0,2,2,2,2
0
$ test-expr '\''((a != b) && (c || d)) >= e'\'' -a 1,0,0,1,2
0
$ test-expr '\''((a != b) && (c || d)) >= e'\'' -a 1,0,0,2,0
1
$ test-expr '\''((a != b) && (c || d)) >= e'\'' -a 1,0,1,0,2
0
$ test-expr '\''((a != b) && (c || d)) >= e'\'' -a 1,0,1,1,2
0
$ test-expr '\''((a != b) && (c || d)) >= e'\'' -a 1,1,0,0,0
1
$ test-expr '\''((a != b) && (c || d)) >= e'\'' -a 1,2,1,1,2
0
$ test-expr '\''((a != b) && (c || d)) >= e'\'' -a 1,2,1,2,2
0
$ test-expr '\''((a != b) && (c || d)) >= e'\'' -a 2,0,0,0,0
1
$ test-expr '\''((a != b) && (c || d)) >= e'\'' -a 2,0,1,2,1
1
$ test-expr '\''((a != b) && (c || d)) >= e'\'' -a 2,1,0,2,0
1
$ test-expr '\''((a != b) && (c || d)) >= e'\'' -a 2,1,0,2,1
1
$ test-expr '\''((a != b) && (c || d)) >= e'\'' -a 2,1,2,0,0
1
$ test-expr '\''((a != b) && (c || d)) >= e'\'' -a 2,2,0,2,0
1
$ test-expr '\''((a != b) && (c || d)) >= e'\'' -a 2,2,1,2,1
0
$ test-expr '\''((a != b) && (c || d)) >= e'\'' -a 2,2,2,1,0
1
$ test-expr '\''((a != b) && (c || d)) >= e'\'' -a 2,2,2,2,1
0
$ test-expr '\''((a != b) >= c) && (d || e)'\'' -a 0,0,0,2,1
1
$ test-expr '\''((a != b) >= c) && (d || e)'\'' -a 0,0,2,0,1
0
$ test-expr '\''((a != b) >= c) && (d || e)'\'' -a 0,1,0,0,1
1
$ test-expr '\''((a != b) >= c) && (d || e)'\'' -a 0,1,0,1,1
1
$ test-expr '\''((a != b) >= c) && (d || e)'\'' -a 0,1,1,0,1
1
$ test-expr '\''((a != b) >= c) && (d || e)'\'' -a 0,1,1,1,2
1
$ test-expr '\''((a != b) >= c) && (d || e)'\'' -a 0,1,2,0,1
0
$ test-expr '\''((a != b) >= c) && (d || e)'\'' -a 0,1,2,1,0
0
$ test-expr '\''((a != b) >= c) && (d || e)'\'' -a 0,2,0,1,0
1
$ test-expr '\''((a != b) >= c) && (d || e)'\'' -a 0,2,0,1,1
1
$ test-expr '\''((a != b) >= c) && (d || e)'\'' -a 0,2,1,0,2
1
$ test-expr '\''((a != b) >= c) && (d || e)'\'' -a 0,2,1,2,0
1
$ test-expr '\''((a != b) >= c) && (d || e)'\'' -a 0,2,2,0,1
0
$ test-expr '\''((a != b) >= c) && (d || e)'\'' -a 0,2,2,2,2
0
$ test-expr '\''((a != b) >= c) && (d || e)'\'' -a 1,0,2,2,2
0
$ test-expr '\''((a != b) >= c) && (d || e)'\'' -a 1,1,0,2,2
1
$ test-expr '\''((a != b) >= c) && (d || e)'\'' -a 1,1,2,0,0
0
$ test-expr '\''((a != b) >= c) && (d || e)'\'' -a 1,1,2,1,0
0
$ test-expr '\''((a != b) >= c) && (d || e)'\'' -a 1,2,1,0,0
0
$ test-expr '\''((a != b) >= c) && (d || e)'\'' -a 1,2,2,1,0
0
$ test-expr '\''((a != b) >= c) && (d || e)'\'' -a 2,0,1,0,0
0
$ test-expr '\''((a != b) >= c) && (d || e)'\'' -a 2,0,2,1,2
0
$ test-expr '\''((a != b) >= c) && (d || e)'\'' -a 2,1,0,0,1
1
$ test-expr '\''((a != b) >= c) && (d || e)'\'' -a 2,1,0,1,1
1
$ test-expr '\''((a != b) >= c) && (d || e)'\'' -a 2,1,1,0,0
0
$ test-expr '\''((a != b) >= c) && (d || e)'\'' -a 2,2,1,2,1
0
$ test-expr '\''((a != b) >= c) || (d && e)'\'' -a 0,0,1,2,2
1
$ test-expr '\''((a != b) >= c) || (d && e)'\'' -a 0,0,2,0,1
0
$ test-expr '\''((a != b) >= c) || (d && e)'\'' -a 0,0,2,0,2
0
$ test-expr '\''((a != b) >= c) || (d && e)'\'' -a 0,0,2,2,1
1
$ test-expr '\''((a != b) >= c) || (d && e)'\'' -a 0,1,0,1,2
1
$ test-expr '\''((a != b) >= c) || (d && e)'\'' -a 0,1,1,0,0
1
$ test-expr '\''((a != b) >= c) || (d && e)'\'' -a 0,1,1,0,1
1
$ test-expr '\''((a != b) >= c) || (d && e)'\'' -a 0,1,1,2,0
1
$ test-expr '\''((a != b) >= c) || (d && e)'\'' -a 0,1,2,0,2
0
$ test-expr '\''((a != b) >= c) || (d && e)'\'' -a 0,1,2,2,1
1
$ test-expr '\''((a != b) >= c) || (d && e)'\'' -a 0,2,0,0,0
1
$ test-expr '\''((a != b) >= c) || (d && e)'\'' -a 0,2,2,0,1
0
$ test-expr '\''((a != b) >= c) || (d && e)'\'' -a 1,0,0,1,2
1
$ test-expr '\''((a != b) >= c) || (d && e)'\'' -a 1,0,0,2,1
1
$ test-expr '\''((a != b) >= c) || (d && e)'\'' -a 1,0,0,2,2
1
$ test-expr '\''((a != b) >= c) || (d && e)'\'' -a 1,0,1,0,0
1
$ test-expr '\''((a != b) >= c) || (d && e)'\'' -a 1,0,2,0,1
0
$ test-expr '\''((a != b) >= c) || (d && e)'\'' -a 1,0,2,0,2
0
$ test-expr '\''((a != b) >= c) || (d && e)'\'' -a 1,1,1,1,0
0
$ test-expr '\''((a != b) >= c) || (d && e)'\'' -a 1,2,0,0,1
1
$ test-expr '\''((a != b) >= c) || (d && e)'\'' -a 1,2,0,2,0
1
$ test-expr '\''((a != b) >= c) || (d && e)'\'' -a 1,2,2,1,1
1
$ test-expr '\''((a != b) >= c) || (d && e)'\'' -a 2,0,0,2,0
1
$ test-expr '\''((a != b) >= c) || (d && e)'\'' -a 2,0,1,2,0
1
$ test-expr '\''((a != b) >= c) || (d && e)'\'' -a 2,0,1,2,1
1
$ test-expr '\''((a != b) >= c) || (d && e)'\'' -a 2,0,2,0,1
0
$ test-expr '\''((a != b) >= c) || (d && e)'\'' -a 2,0,2,1,0
0
$ test-expr '\''((a != b) >= c) || (d && e)'\'' -a 2,0,2,2,2
1
$ test-expr '\''((a != b) >= c) || (d && e)'\'' -a 2,1,1,1,0
1
$ test-expr '\''((a != b) >= c) || (d && e)'\'' -a 2,1,2,2,0
0
$ test-expr '\''((a != b) >= c) || (d && e)'\'' -a 2,1,2,2,1
1
$ test-expr '\''((a != b) >= c) || (d && e)'\'' -a 2,2,0,2,2
1
$ test-expr '\''((a != b) >= c) || (d && e)'\'' -a 2,2,2,0,2
0
$ test-expr '\''((a != b) >= (c && d)) || e'\'' -a 0,0,0,0,1
1
$ test-expr '\''((a != b) >= (c && d)) || e'\'' -a 0,0,0,2,0
1
$ test-expr '\''((a != b) >= (c && d)) || e'\'' -a 0,0,0,2,1
1
$ test-expr '\''((a != b) >= (c && d)) || e'\'' -a 0,0,2,0,2
1
$ test-expr '\''((a != b) >= (c && d)) || e'\'' -a 0,0,2,1,0
0
$ test-expr '\''((a != b) >= (c && d)) || e'\'' -a 0,0,2,1,1
1
$ test-expr '\''((a != b) >= (c && d)) || e'\'' -a 0,0,2,2,1
1
$ test-expr '\''((a != b) >= (c && d)) || e'\'' -a 0,1,0,0,1
1
$ test-expr '\''((a != b) >= (c && d)) || e'\'' -a 0,1,2,1,0
1
$ test-expr '\''((a != b) >= (c && d)) || e'\'' -a 0,2,1,2,0
1
$ test-expr '\''((a != b) >= (c && d)) || e'\'' -a 1,0,0,1,2
1
$ test-expr '\''((a != b) >= (c && d)) || e'\'' -a 1,2,0,2,0
1
$ test-expr '\''((a != b) >= (c && d)) || e'\'' -a 1,2,0,2,1
1
$ test-expr '\''((a != b) >= (c && d)) || e'\'' -a 1,2,0,2,2
1
$ test-expr '\''((a != b) >= (c && d)) || e'\'' -a 1,2,1,2,1
1
$ test-expr '\''((a != b) >= (c && d)) || e'\'' -a 2,0,0,1,0
1
$ test-expr '\''((a != b) >= (c && d)) || e'\'' -a 2,1,0,0,1
1
$ test-expr '\''((a != b) >= (c && d)) || e'\'' -a 2,1,2,0,1
1
$ test-expr '\''((a != b) >= (c && d)) || e'\'' -a 2,1,2,2,0
1
$ test-expr '\''((a != b) >= (c && d)) || e'\'' -a 2,1,2,2,2
1
$ test-expr '\''((a != b) >= (c && d)) || e'\'' -a 2,2,0,1,1
1
$ test-expr '\''((a != b) >= (c && d)) || e'\'' -a 2,2,0,2,1
1
$ test-expr '\''((a != b) >= (c && d)) || e'\'' -a 2,2,1,0,0
1
$ test-expr '\''((a != b) >= (c && d)) || e'\'' -a 2,2,2,1,0
0
$ test-expr '\''((a != b) >= (c || d)) && e'\'' -a 0,0,0,1,2
0
$ test-expr '\''((a != b) >= (c || d)) && e'\'' -a 0,1,0,1,1
1
$ test-expr '\''((a != b) >= (c || d)) && e'\'' -a 0,1,2,0,1
1
$ test-expr '\''((a != b) >= (c || d)) && e'\'' -a 0,1,2,1,2
1
$ test-expr '\''((a != b) >= (c || d)) && e'\'' -a 0,2,0,0,2
1
$ test-expr '\''((a != b) >= (c || d)) && e'\'' -a 0,2,2,1,2
1
$ test-expr '\''((a != b) >= (c || d)) && e'\'' -a 1,0,0,0,1
1
$ test-expr '\''((a != b) >= (c || d)) && e'\'' -a 1,0,0,2,0
0
$ test-expr '\''((a != b) >= (c || d)) && e'\'' -a 1,0,1,1,0
0
$ test-expr '\''((a != b) >= (c || d)) && e'\'' -a 1,0,2,2,0
0
$ test-expr '\''((a != b) >= (c || d)) && e'\'' -a 1,1,0,1,2
0
$ test-expr '\''((a != b) >= (c || d)) && e'\'' -a 1,1,1,1,0
0
$ test-expr '\''((a != b) >= (c || d)) && e'\'' -a 1,1,2,1,2
0
$ test-expr '\''((a != b) >= (c || d)) && e'\'' -a 1,2,1,2,0
0
$ test-expr '\''((a != b) >= (c || d)) && e'\'' -a 1,2,2,0,2
1
$ test-expr '\''((a != b) >= (c || d)) && e'\'' -a 1,2,2,1,2
1
$ test-expr '\''((a != b) >= (c || d)) && e'\'' -a 1,2,2,2,0
0
$ test-expr '\''((a != b) >= (c || d)) && e'\'' -a 2,0,0,2,0
0
$ test-expr '\''((a != b) >= (c || d)) && e'\'' -a 2,0,2,2,1
1
$ test-expr '\''((a != b) >= (c || d)) && e'\'' -a 2,1,0,1,0
0
$ test-expr '\''((a != b) >= (c || d)) && e'\'' -a 2,1,0,1,1
1
$ test-expr '\''((a != b) >= (c || d)) && e'\'' -a 2,1,1,0,0
0
$ test-expr '\''((a != b) >= (c || d)) && e'\'' -a 2,2,0,2,1
0
$ test-expr '\''((a != b) >= (c || d)) && e'\'' -a 2,2,1,1,2
0
$ test-expr '\''((a != b) >= (c || d)) && e'\'' -a 2,2,1,2,0
0
$ test-expr '\''((a != b) >= (c || d)) && e'\'' -a 2,2,2,0,1
0
$ test-expr '\''((a != b) >= (c || d)) && e'\'' -a 2,2,2,0,2
0
$ test-expr '\''((a != b) || c) && (d >= e)'\'' -a 0,0,0,2,1
0
$ test-expr '\''((a != b) || c) && (d >= e)'\'' -a 0,0,1,1,1
1
$ test-expr '\''((a != b) || c) && (d >= e)'\'' -a 0,0,2,2,0
1
$ test-expr '\''((a != b) || c) && (d >= e)'\'' -a 0,1,0,0,0
1
$ test-expr '\''((a != b) || c) && (d >= e)'\'' -a 0,1,1,1,2
0
$ test-expr '\''((a != b) || c) && (d >= e)'\'' -a 0,1,2,1,1
1
$ test-expr '\''((a != b) || c) && (d >= e)'\'' -a 0,1,2,2,2
1
$ test-expr '\''((a != b) || c) && (d >= e)'\'' -a 0,2,0,2,2
1
$ test-expr '\''((a != b) || c) && (d >= e)'\'' -a 0,2,1,2,0
1
$ test-expr '\''((a != b) || c) && (d >= e)'\'' -a 0,2,2,2,2
1
$ test-expr '\''((a != b) || c) && (d >= e)'\'' -a 1,0,0,0,1
0
$ test-expr '\''((a != b) || c) && (d >= e)'\'' -a 1,0,0,0,2
0
$ test-expr '\''((a != b) || c) && (d >= e)'\'' -a 1,0,1,1,2
0
$ test-expr '\''((a != b) || c) && (d >= e)'\'' -a 1,0,2,0,2
0
$ test-expr '\''((a != b) || c) && (d >= e)'\'' -a 1,0,2,1,0
1
$ test-expr '\''((a != b) || c) && (d >= e)'\'' -a 1,0,2,1,2
0
$ test-expr '\''((a != b) || c) && (d >= e)'\'' -a 1,1,1,0,1
0
$ test-expr '\''((a != b) || c) && (d >= e)'\'' -a 1,1,2,1,1
1
$ test-expr '\''((a != b) || c) && (d >= e)'\'' -a 1,2,1,0,2
0
$ test-expr '\''((a != b) || c) && (d >= e)'\'' -a 1,2,1,1,2
0
$ test-expr '\''((a != b) || c) && (d >= e)'\'' -a 2,0,1,1,1
1
$ test-expr '\''((a != b) || c) && (d >= e)'\'' -a 2,1,0,0,0
1
$ test-expr '\''((a != b) || c) && (d >= e)'\'' -a 2,1,1,1,0
1
$ test-expr '\''((a != b) || c) && (d >= e)'\'' -a 2,1,1,2,0
1
$ test-expr '\''((a != b) || c) && (d >= e)'\'' -a 2,1,1,2,1
1
$ test-expr '\''((a != b) || c) && (d >= e)'\'' -a 2,2,0,2,1
0
$ test-expr '\''((a != b) || c) && (d >= e)'\'' -a 2,2,0,2,2
0
$ test-expr '\''((a != b) || c) && (d >= e)'\'' -a 2,2,1,2,0
1
$ test-expr '\''((a != b) || c) && (d >= e)'\'' -a 2,2,2,2,0
1
$ test-expr '\''((a != b) || c) >= (d && e)'\'' -a 0,0,0,0,2
1
$ test-expr '\''((a != b) || c) >= (d && e)'\'' -a 0,0,0,2,2
0
$ test-expr '\''((a != b) || c) >= (d && e)'\'' -a 0,0,1,0,2
1
$ test-expr '\''((a != b) || c) >= (d && e)'\'' -a 0,0,2,2,0
1
$ test-expr '\''((a != b) || c) >= (d && e)'\'' -a 0,0,2,2,2
1
$ test-expr '\''((a != b) || c) >= (d && e)'\'' -a 0,1,0,1,1
1
$ test-expr '\''((a != b) || c) >= (d && e)'\'' -a 0,1,0,2,1
1
$ test-expr '\''((a != b) || c) >= (d && e)'\'' -a 0,1,1,0,0
1
$ test-expr '\''((a != b) || c) >= (d && e)'\'' -a 0,2,0,0,0
1
$ test-expr '\''((a != b) || c) >= (d && e)'\'' -a 0,2,1,0,0
1
$ test-expr '\''((a != b) || c) >= (d && e)'\'' -a 0,2,2,1,1
1
$ test-expr '\''((a != b) || c) >= (d && e)'\'' -a 1,0,0,2,2
1
$ test-expr '\''((a != b) || c) >= (d && e)'\'' -a 1,0,2,0,0
1
$ test-expr '\''((a != b) || c) >= (d && e)'\'' -a 1,0,2,2,0
1
$ test-expr '\''((a != b) || c) >= (d && e)'\'' -a 1,0,2,2,2
1
$ test-expr '\''((a != b) || c) >= (d && e)'\'' -a 1,1,0,0,1
1
$ test-expr '\''((a != b) || c) >= (d && e)'\'' -a 1,1,0,2,1
0
$ test-expr '\''((a != b) || c) >= (d && e)'\'' -a 1,1,0,2,2
0
$ test-expr '\''((a != b) || c) >= (d && e)'\'' -a 1,1,2,2,1
1
$ test-expr '\''((a != b) || c) >= (d && e)'\'' -a 1,2,0,1,2
1
$ test-expr '\''((a != b) || c) >= (d && e)'\'' -a 1,2,1,1,0
1
$ test-expr '\''((a != b) || c) >= (d && e)'\'' -a 1,2,2,0,2
1
$ test-expr '\''((a != b) || c) >= (d && e)'\'' -a 2,0,2,0,1
1
$ test-expr '\''((a != b) || c) >= (d && e)'\'' -a 2,1,0,0,2
1
$ test-expr '\''((a != b) || c) >= (d && e)'\'' -a 2,1,1,0,2
1
$ test-expr '\''((a != b) || c) >= (d && e)'\'' -a 2,1,2,0,1
1
$ test-expr '\''((a != b) || c) >= (d && e)'\'' -a 2,1,2,2,2
1
$ test-expr '\''((a != b) || c) >= (d && e)'\'' -a 2,2,0,0,1
1
$ test-expr '\''((a != b) || c) >= (d && e)'\'' -a 2,2,1,2,2
1
$ test-expr '\''((a != b) || c) >= (d && e)'\'' -a 2,2,2,0,0
1
$ test-expr '\''((a != b) || (c && d)) >= e'\'' -a 0,0,0,0,2
0
$ test-expr '\''((a != b) || (c && d)) >= e'\'' -a 0,0,0,1,1
0
$ test-expr '\''((a != b) || (c && d)) >= e'\'' -a 0,0,1,0,2
0
$ test-expr '\''((a != b) || (c && d)) >= e'\'' -a 0,0,1,2,2
0
$ test-expr '\''((a != b) || (c && d)) >= e'\'' -a 0,1,0,1,2
0
$ test-expr '\''((a != b) || (c && d)) >= e'\'' -a 0,2,0,1,2
0
$ test-expr '\''((a != b) || (c && d)) >= e'\'' -a 0,2,2,2,0
1
$ test-expr '\''((a != b) || (c && d)) >= e'\'' -a 1,0,0,0,0
1
$ test-expr '\''((a != b) || (c && d)) >= e'\'' -a 1,0,0,0,2
0
$ test-expr '\''((a != b) || (c && d)) >= e'\'' -a 1,0,1,0,0
1
$ test-expr '\''((a != b) || (c && d)) >= e'\'' -a 1,0,1,2,2
0
$ test-expr '\''((a != b) || (c && d)) >= e'\'' -a 1,0,2,1,0
1
$ test-expr '\''((a != b) || (c && d)) >= e'\'' -a 1,1,0,0,0
1
$ test-expr '\''((a != b) || (c && d)) >= e'\'' -a 1,1,0,0,1
0
$ test-expr '\''((a != b) || (c && d)) >= e'\'' -a 1,1,2,1,0
1
$ test-expr '\''((a != b) || (c && d)) >= e'\'' -a 1,1,2,2,0
1
$ test-expr '\''((a != b) || (c && d)) >= e'\'' -a 2,0,1,0,0
1
$ test-expr '\''((a != b) || (c && d)) >= e'\'' -a 2,0,2,0,0
1
$ test-expr '\''((a != b) || (c && d)) >= e'\'' -a 2,1,0,0,2
0
$ test-expr '\''((a != b) || (c && d)) >= e'\'' -a 2,1,0,1,2
0
$ test-expr '\''((a != b) || (c && d)) >= e'\'' -a 2,1,0,2,1
1
$ test-expr '\''((a != b) || (c && d)) >= e'\'' -a 2,1,1,0,1
1
$ test-expr '\''((a != b) || (c && d)) >= e'\'' -a 2,1,1,0,2
0
$ test-expr '\''((a != b) || (c && d)) >= e'\'' -a 2,1,2,0,2
0
$ test-expr '\''((a != b) || (c && d)) >= e'\'' -a 2,1,2,1,1
1
$ test-expr '\''((a != b) || (c && d)) >= e'\'' -a 2,1,2,2,0
1
$ test-expr '\''((a != b) || (c && d)) >= e'\'' -a 2,2,0,2,2
0
$ test-expr '\''((a != b) || (c && d)) >= e'\'' -a 2,2,1,2,1
1
$ test-expr '\''((a != b) || (c && d)) >= e'\'' -a 2,2,2,0,0
1
$ test-expr '\''((a != b) || (c && d)) >= e'\'' -a 2,2,2,1,1
1
$ test-expr '\''((a != b) || (c && d)) >= e'\'' -a 2,2,2,2,1
1
$ test-expr '\''((a != b) || (c >= d)) && e'\'' -a 0,0,0,0,0
0
$ test-expr '\''((a != b) || (c >= d)) && e'\'' -a 0,0,1,2,1
0
$ test-expr '\''((a != b) || (c >= d)) && e'\'' -a 0,0,2,1,2
1
$ test-expr '\''((a != b) || (c >= d)) && e'\'' -a 0,1,0,0,2
1
$ test-expr '\''((a != b) || (c >= d)) && e'\'' -a 0,1,0,1,2
1
$ test-expr '\''((a != b) || (c >= d)) && e'\'' -a 0,1,1,2,2
1
$ test-expr '\''((a != b) || (c >= d)) && e'\'' -a 0,1,2,2,0
0
$ test-expr '\''((a != b) || (c >= d)) && e'\'' -a 0,2,1,0,2
1
$ test-expr '\''((a != b) || (c >= d)) && e'\'' -a 0,2,1,1,2
1
$ test-expr '\''((a != b) || (c >= d)) && e'\'' -a 0,2,2,1,2
1
$ test-expr '\''((a != b) || (c >= d)) && e'\'' -a 1,0,1,0,2
1
$ test-expr '\''((a != b) || (c >= d)) && e'\'' -a 1,0,1,1,0
0
$ test-expr '\''((a != b) || (c >= d)) && e'\'' -a 1,0,1,1,1
1
$ test-expr '\''((a != b) || (c >= d)) && e'\'' -a 1,0,2,0,1
1
$ test-expr '\''((a != b) || (c >= d)) && e'\'' -a 1,1,0,0,0
0
$ test-expr '\''((a != b) || (c >= d)) && e'\'' -a 1,1,0,1,0
0
$ test-expr '\''((a != b) || (c >= d)) && e'\'' -a 1,1,2,2,1
1
$ test-expr '\''((a != b) || (c >= d)) && e'\'' -a 1,2,2,2,0
0
$ test-expr '\''((a != b) || (c >= d)) && e'\'' -a 2,0,2,2,1
1
$ test-expr '\''((a != b) || (c >= d)) && e'\'' -a 2,2,0,2,2
0
$ test-expr '\''((a != b) || (c >= d)) && e'\'' -a 2,2,1,0,1
1
$ test-expr '\''((a != b) || (c >= d)) && e'\'' -a 2,2,1,2,2
0
$ test-expr '\''((a != (b && c)) >= d) || e'\'' -a 0,0,0,2,1
1
$ test-expr '\''((a != (b && c)) >= d) || e'\'' -a 0,0,1,0,0
1
$ test-expr '\''((a != (b && c)) >= d) || e'\'' -a 0,0,1,1,2
1
$ test-expr '\''((a != (b && c)) >= d) || e'\'' -a 0,0,2,2,2
1
$ test-expr '\''((a != (b && c)) >= d) || e'\'' -a 0,1,0,1,1
1
$ test-expr '\''((a != (b && c)) >= d) || e'\'' -a 0,1,1,0,1
1
$ test-expr '\''((a != (b && c)) >= d) || e'\'' -a 0,1,1,1,0
1
$ test-expr '\''((a != (b && c)) >= d) || e'\'' -a 0,1,1,2,0
0
$ test-expr '\''((a != (b && c)) >= d) || e'\'' -a 0,1,1,2,1
1
$ test-expr '\''((a != (b && c)) >= d) || e'\'' -a 0,1,2,0,1
1
$ test-expr '\''((a != (b && c)) >= d) || e'\'' -a 0,2,0,1,2
1
$ test-expr '\''((a != (b && c)) >= d) || e'\'' -a 0,2,0,2,1
1
$ test-expr '\''((a != (b && c)) >= d) || e'\'' -a 0,2,1,2,2
1
$ test-expr '\''((a != (b && c)) >= d) || e'\'' -a 0,2,2,1,1
1
$ test-expr '\''((a != (b && c)) >= d) || e'\'' -a 0,2,2,1,2
1
$ test-expr '\''((a != (b && c)) >= d) || e'\'' -a 0,2,2,2,2
1
$ test-expr '\''((a != (b && c)) >= d) || e'\'' -a 1,0,0,1,0
1
$ test-expr '\''((a != (b && c)) >= d) || e'\'' -a 1,1,0,0,1
1
$ test-expr '\''((a != (b && c)) >= d) || e'\'' -a 1,1,1,0,0
1
$ test-expr '\''((a != (b && c)) >= d) || e'\'' -a 1,1,1,1,0
0
$ test-expr '\''((a != (b && c)) >= d) || e'\'' -a 1,2,2,2,1
1
$ test-expr '\''((a != (b && c)) >= d) || e'\'' -a 2,0,0,0,2
1
$ test-expr '\''((a != (b && c)) >= d) || e'\'' -a 2,0,0,2,1
1
$ test-expr '\''((a != (b && c)) >= d) || e'\'' -a 2,0,2,1,0
1
$ test-expr '\''((a != (b && c)) >= d) || e'\'' -a 2,1,0,0,0
1
$ test-expr '\''((a != (b && c)) >= d) || e'\'' -a 2,1,2,0,1
1
$ test-expr '\''((a != (b && c)) >= d) || e'\'' -a 2,2,0,1,2
1
$ test-expr '\''((a != (b && c)) >= d) || e'\'' -a 2,2,2,2,1
1
$ test-expr '\''((a != (b && c)) || d) >= e'\'' -a 0,0,0,2,1
1
$ test-expr '\''((a != (b && c)) || d) >= e'\'' -a 0,0,1,0,0
1
$ test-expr '\''((a != (b && c)) || d) >= e'\'' -a 0,0,1,0,2
0
$ test-expr '\''((a != (b && c)) || d) >= e'\'' -a 0,0,1,1,2
0
$ test-expr '\''((a != (b && c)) || d) >= e'\'' -a 0,0,2,0,2
0
$ test-expr '\''((a != (b && c)) || d) >= e'\'' -a 0,1,0,1,0
1
$ test-expr '\''((a != (b && c)) || d) >= e'\'' -a 0,1,1,0,0
1
$ test-expr '\''((a != (b && c)) || d) >= e'\'' -a 0,1,1,2,0
1
$ test-expr '\''((a != (b && c)) || d) >= e'\'' -a 0,2,0,2,2
0
$ test-expr '\''((a != (b && c)) || d) >= e'\'' -a 0,2,1,0,2
0
$ test-expr '\''((a != (b && c)) || d) >= e'\'' -a 0,2,1,2,1
1
$ test-expr '\''((a != (b && c)) || d) >= e'\'' -a 1,0,0,1,1
1
$ test-expr '\''((a != (b && c)) || d) >= e'\'' -a 1,0,0,1,2
0
$ test-expr '\''((a != (b && c)) || d) >= e'\'' -a 1,0,0,2,0
1
$ test-expr '\''((a != (b && c)) || d) >= e'\'' -a 1,0,1,0,0
1
$ test-expr '\''((a != (b && c)) || d) >= e'\'' -a 1,0,2,2,0
1
$ test-expr '\''((a != (b && c)) || d) >= e'\'' -a 1,1,1,1,0
1
$ test-expr '\''((a != (b && c)) || d) >= e'\'' -a 1,1,2,1,0
1
$ test-expr '\''((a != (b && c)) || d) >= e'\'' -a 1,2,0,0,1
1
$ test-expr '\''((a != (b && c)) || d) >= e'\'' -a 1,2,1,0,0
1
$ test-expr '\''((a != (b && c)) || d) >= e'\'' -a 1,2,1,0,1
0
$ test-expr '\''((a != (b && c)) || d) >= e'\'' -a 2,0,1,0,2
0
$ test-expr '\''((a != (b && c)) || d) >= e'\'' -a 2,0,1,1,0
1
$ test-expr '\''((a != (b && c)) || d) >= e'\'' -a 2,0,1,2,1
1
$ test-expr '\''((a != (b && c)) || d) >= e'\'' -a 2,0,2,2,1
1
$ test-expr '\''((a != (b && c)) || d) >= e'\'' -a 2,1,1,0,0
1
$ test-expr '\''((a != (b && c)) || d) >= e'\'' -a 2,1,1,1,0
1
$ test-expr '\''((a != (b && c)) || d) >= e'\'' -a 2,1,2,1,2
0
$ test-expr '\''((a != (b && c)) || d) >= e'\'' -a 2,2,1,1,2
0
$ test-expr '\''((a != (b >= c)) && d) || e'\'' -a 0,0,0,2,0
1
$ test-expr '\''((a != (b >= c)) && d) || e'\'' -a 0,0,0,2,1
1
$ test-expr '\''((a != (b >= c)) && d) || e'\'' -a 0,0,1,1,0
0
$ test-expr '\''((a != (b >= c)) && d) || e'\'' -a 0,0,2,2,0
0
$ test-expr '\''((a != (b >= c)) && d) || e'\'' -a 0,1,1,1,2
1
$ test-expr '\''((a != (b >= c)) && d) || e'\'' -a 0,2,0,0,2
1
$ test-expr '\''((a != (b >= c)) && d) || e'\'' -a 0,2,0,2,1
1
$ test-expr '\''((a != (b >= c)) && d) || e'\'' -a 0,2,1,2,1
1
$ test-expr '\''((a != (b >= c)) && d) || e'\'' -a 0,2,2,0,2
1
$ test-expr '\''((a != (b >= c)) && d) || e'\'' -a 1,0,0,0,1
1
$ test-expr '\''((a != (b >= c)) && d) || e'\'' -a 1,0,1,2,0
1
$ test-expr '\''((a != (b >= c)) && d) || e'\'' -a 1,0,2,0,1
1
$ test-expr '\''((a != (b >= c)) && d) || e'\'' -a 1,0,2,1,1
1
$ test-expr '\''((a != (b >= c)) && d) || e'\'' -a 1,0,2,2,0
1
$ test-expr '\''((a != (b >= c)) && d) || e'\'' -a 1,0,2,2,1
1
$ test-expr '\''((a != (b >= c)) && d) || e'\'' -a 1,1,1,0,0
0
$ test-expr '\''((a != (b >= c)) && d) || e'\'' -a 1,1,1,0,1
1
$ test-expr '\''((a != (b >= c)) && d) || e'\'' -a 1,1,1,2,1
1
$ test-expr '\''((a != (b >= c)) && d) || e'\'' -a 1,1,1,2,2
1
$ test-expr '\''((a != (b >= c)) && d) || e'\'' -a 2,0,0,1,0
1
$ test-expr '\''((a != (b >= c)) && d) || e'\'' -a 2,0,0,1,1
1
$ test-expr '\''((a != (b >= c)) && d) || e'\'' -a 2,0,0,2,1
1
$ test-expr '\''((a != (b >= c)) && d) || e'\'' -a 2,0,1,0,1
1
$ test-expr '\''((a != (b >= c)) && d) || e'\'' -a 2,1,0,1,1
1
$ test-expr '\''((a != (b >= c)) && d) || e'\'' -a 2,1,0,1,2
1
$ test-expr '\''((a != (b >= c)) && d) || e'\'' -a 2,1,0,2,1
1
$ test-expr '\''((a != (b >= c)) && d) || e'\'' -a 2,1,1,0,2
1
$ test-expr '\''((a != (b >= c)) && d) || e'\'' -a 2,1,1,2,0
1
$ test-expr '\''((a != (b >= c)) && d) || e'\'' -a 2,1,2,0,2
1
$ test-expr '\''((a != (b >= c)) && d) || e'\'' -a 2,1,2,1,0
1
$ test-expr '\''((a != (b >= c)) && d) || e'\'' -a 2,1,2,2,0
1
$ test-expr '\''((a != (b >= c)) && d) || e'\'' -a 2,1,2,2,1
1
$ test-expr '\''((a != (b >= c)) && d) || e'\'' -a 2,2,0,0,0
0
$ test-expr '\''((a != (b >= c)) && d) || e'\'' -a 2,2,2,1,1
1
$ test-expr '\''((a != (b >= c)) && d) || e'\'' -a 2,2,2,2,0
1
$ test-expr '\''((a != (b >= c)) || d) && e'\'' -a 0,0,0,1,1
1
$ test-expr '\''((a != (b >= c)) || d) && e'\'' -a 0,0,2,1,2
1
$ test-expr '\''((a != (b >= c)) || d) && e'\'' -a 0,0,2,2,0
0
$ test-expr '\''((a != (b >= c)) || d) && e'\'' -a 0,1,1,0,2
1
$ test-expr '\''((a != (b >= c)) || d) && e'\'' -a 0,1,1,1,1
1
$ test-expr '\''((a != (b >= c)) || d) && e'\'' -a 0,2,0,1,0
0
$ test-expr '\''((a != (b >= c)) || d) && e'\'' -a 0,2,1,0,1
1
$ test-expr '\''((a != (b >= c)) || d) && e'\'' -a 0,2,1,2,1
1
$ test-expr '\''((a != (b >= c)) || d) && e'\'' -a 1,0,0,2,0
0
$ test-expr '\''((a != (b >= c)) || d) && e'\'' -a 1,0,1,1,1
1
$ test-expr '\''((a != (b >= c)) || d) && e'\'' -a 1,0,2,1,2
1
$ test-expr '\''((a != (b >= c)) || d) && e'\'' -a 1,1,0,1,0
0
$ test-expr '\''((a != (b >= c)) || d) && e'\'' -a 1,1,1,0,0
0
$ test-expr '\''((a != (b >= c)) || d) && e'\'' -a 1,1,2,2,1
1
$ test-expr '\''((a != (b >= c)) || d) && e'\'' -a 1,2,0,0,1
0
$ test-expr '\''((a != (b >= c)) || d) && e'\'' -a 1,2,0,1,1
1
$ test-expr '\''((a != (b >= c)) || d) && e'\'' -a 1,2,0,2,1
1
$ test-expr '\''((a != (b >= c)) || d) && e'\'' -a 1,2,1,0,1
0
$ test-expr '\''((a != (b >= c)) || d) && e'\'' -a 1,2,1,1,1
1
$ test-expr '\''((a != (b >= c)) || d) && e'\'' -a 2,0,0,0,1
1
$ test-expr '\''((a != (b >= c)) || d) && e'\'' -a 2,0,2,0,1
1
$ test-expr '\''((a != (b >= c)) || d) && e'\'' -a 2,0,2,1,2
1
$ test-expr '\''((a != (b >= c)) || d) && e'\'' -a 2,1,0,0,1
1
$ test-expr '\''((a != (b >= c)) || d) && e'\'' -a 2,1,0,2,1
1
$ test-expr '\''((a != (b >= c)) || d) && e'\'' -a 2,1,1,2,0
0
$ test-expr '\''((a != (b >= c)) || d) && e'\'' -a 2,2,0,0,1
1
$ test-expr '\''((a != (b >= c)) || d) && e'\'' -a 2,2,0,2,0
0
$ test-expr '\''((a != (b >= c)) || d) && e'\'' -a 2,2,1,1,2
1
$ test-expr '\''((a != (b || c)) && d) >= e'\'' -a 0,0,0,1,0
1
$ test-expr '\''((a != (b || c)) && d) >= e'\'' -a 0,1,2,0,1
0
$ test-expr '\''((a != (b || c)) && d) >= e'\'' -a 0,2,0,1,0
1
$ test-expr '\''((a != (b || c)) && d) >= e'\'' -a 0,2,0,2,1
1
$ test-expr '\''((a != (b || c)) && d) >= e'\'' -a 0,2,1,1,1
1
$ test-expr '\''((a != (b || c)) && d) >= e'\'' -a 1,0,1,1,0
1
$ test-expr '\''((a != (b || c)) && d) >= e'\'' -a 1,0,1,1,2
0
$ test-expr '\''((a != (b || c)) && d) >= e'\'' -a 1,1,0,1,0
1
$ test-expr '\''((a != (b || c)) && d) >= e'\'' -a 1,1,0,2,2
0
$ test-expr '\''((a != (b || c)) && d) >= e'\'' -a 1,1,1,0,1
0
$ test-expr '\''((a != (b || c)) && d) >= e'\'' -a 1,1,1,0,2
0
$ test-expr '\''((a != (b || c)) && d) >= e'\'' -a 1,1,1,1,1
0
$ test-expr '\''((a != (b || c)) && d) >= e'\'' -a 1,1,2,2,0
1
$ test-expr '\''((a != (b || c)) && d) >= e'\'' -a 1,2,0,0,0
1
$ test-expr '\''((a != (b || c)) && d) >= e'\'' -a 1,2,2,0,2
0
$ test-expr '\''((a != (b || c)) && d) >= e'\'' -a 1,2,2,1,2
0
$ test-expr '\''((a != (b || c)) && d) >= e'\'' -a 2,0,1,0,0
1
$ test-expr '\''((a != (b || c)) && d) >= e'\'' -a 2,0,1,1,1
1
$ test-expr '\''((a != (b || c)) && d) >= e'\'' -a 2,0,1,2,1
1
$ test-expr '\''((a != (b || c)) && d) >= e'\'' -a 2,1,0,0,1
0
$ test-expr '\''((a != (b || c)) && d) >= e'\'' -a 2,1,1,1,2
0
$ test-expr '\''((a != (b || c)) && d) >= e'\'' -a 2,1,1,2,1
1
$ test-expr '\''((a != (b || c)) && d) >= e'\'' -a 2,1,2,0,2
0
$ test-expr '\''((a != (b || c)) && d) >= e'\'' -a 2,1,2,2,1
1
$ test-expr '\''((a != (b || c)) && d) >= e'\'' -a 2,2,2,0,0
1
$ test-expr '\''((a != (b || c)) >= d) && e'\'' -a 0,0,1,0,1
1
$ test-expr '\''((a != (b || c)) >= d) && e'\'' -a 0,0,1,0,2
1
$ test-expr '\''((a != (b || c)) >= d) && e'\'' -a 0,0,1,2,1
0
$ test-expr '\''((a != (b || c)) >= d) && e'\'' -a 0,1,0,0,0
0
$ test-expr '\''((a != (b || c)) >= d) && e'\'' -a 0,1,0,2,0
0
$ test-expr '\''((a != (b || c)) >= d) && e'\'' -a 0,1,2,1,0
0
$ test-expr '\''((a != (b || c)) >= d) && e'\'' -a 0,1,2,1,2
1
$ test-expr '\''((a != (b || c)) >= d) && e'\'' -a 0,2,0,1,0
0
$ test-expr '\''((a != (b || c)) >= d) && e'\'' -a 0,2,1,0,2
1
$ test-expr '\''((a != (b || c)) >= d) && e'\'' -a 0,2,1,1,1
1
$ test-expr '\''((a != (b || c)) >= d) && e'\'' -a 0,2,2,0,2
1
$ test-expr '\''((a != (b || c)) >= d) && e'\'' -a 1,0,0,0,0
0
$ test-expr '\''((a != (b || c)) >= d) && e'\'' -a 1,0,0,1,1
1
$ test-expr '\''((a != (b || c)) >= d) && e'\'' -a 1,0,0,2,2
0
$ test-expr '\''((a != (b || c)) >= d) && e'\'' -a 1,0,1,1,0
0
$ test-expr '\''((a != (b || c)) >= d) && e'\'' -a 1,0,2,2,2
0
$ test-expr '\''((a != (b || c)) >= d) && e'\'' -a 1,1,2,1,0
0
$ test-expr '\''((a != (b || c)) >= d) && e'\'' -a 1,1,2,1,2
0
$ test-expr '\''((a != (b || c)) >= d) && e'\'' -a 1,2,1,2,0
0
$ test-expr '\''((a != (b || c)) >= d) && e'\'' -a 1,2,1,2,2
0
$ test-expr '\''((a != (b || c)) >= d) && e'\'' -a 1,2,2,0,0
0
$ test-expr '\''((a != (b || c)) >= d) && e'\'' -a 2,0,0,0,0
0
$ test-expr '\''((a != (b || c)) >= d) && e'\'' -a 2,0,0,1,2
1
$ test-expr '\''((a != (b || c)) >= d) && e'\'' -a 2,0,1,0,0
0
$ test-expr '\''((a != (b || c)) >= d) && e'\'' -a 2,0,1,2,1
0
$ test-expr '\''((a != (b || c)) >= d) && e'\'' -a 2,0,2,2,2
0
$ test-expr '\''((a != (b || c)) >= d) && e'\'' -a 2,1,1,1,0
0
$ test-expr '\''((a != (b || c)) >= d) && e'\'' -a 2,1,2,0,1
1
$ test-expr '\''((a != (b || c)) >= d) && e'\'' -a 2,1,2,2,1
0
$ test-expr '\''((a != (b || c)) >= d) && e'\'' -a 2,2,0,0,0
0
$ test-expr '\''((a != (b || c)) >= d) && e'\'' -a 2,2,0,1,0
0
$ test-expr '\''((a != (b || c)) >= d) && e'\'' -a 2,2,1,2,1
0
$ test-expr '\''((a != (b || c)) >= d) && e'\'' -a 2,2,1,2,2
0
$ test-expr '\''((a && b) != c) >= (d || e)'\'' -a 0,0,0,1,2
0
$ test-expr '\''((a && b) != c) >= (d || e)'\'' -a 0,0,1,2,2
1
$ test-expr '\''((a && b) != c) >= (d || e)'\'' -a 0,0,2,0,2
1
$ test-expr '\''((a && b) != c) >= (d || e)'\'' -a 0,0,2,2,0
1
$ test-expr '\''((a && b) != c) >= (d || e)'\'' -a 0,0,2,2,1
1
$ test-expr '\''((a && b) != c) >= (d || e)'\'' -a 0,1,0,1,2
0
$ test-expr '\''((a && b) != c) >= (d || e)'\'' -a 0,1,1,0,0
1
$ test-expr '\''((a && b) != c) >= (d || e)'\'' -a 0,2,0,2,0
0
$ test-expr '\''((a && b) != c) >= (d || e)'\'' -a 0,2,1,2,2
1
$ test-expr '\''((a && b) != c) >= (d || e)'\'' -a 0,2,2,0,0
1
$ test-expr '\''((a && b) != c) >= (d || e)'\'' -a 0,2,2,2,1
1
$ test-expr '\''((a && b) != c) >= (d || e)'\'' -a 1,0,0,1,1
0
$ test-expr '\''((a && b) != c) >= (d || e)'\'' -a 1,0,0,1,2
0
$ test-expr '\''((a && b) != c) >= (d || e)'\'' -a 1,0,0,2,1
0
$ test-expr '\''((a && b) != c) >= (d || e)'\'' -a 1,0,1,1,1
1
$ test-expr '\''((a && b) != c) >= (d || e)'\'' -a 1,0,2,0,2
1
$ test-expr '\''((a && b) != c) >= (d || e)'\'' -a 1,0,2,1,1
1
$ test-expr '\''((a && b) != c) >= (d || e)'\'' -a 1,1,1,0,1
0
$ test-expr '\''((a && b) != c) >= (d || e)'\'' -a 1,1,1,0,2
0
$ test-expr '\''((a && b) != c) >= (d || e)'\'' -a 1,2,0,0,1
1
$ test-expr '\''((a && b) != c) >= (d || e)'\'' -a 1,2,0,1,1
1
$ test-expr '\''((a && b) != c) >= (d || e)'\'' -a 1,2,1,0,1
0
$ test-expr '\''((a && b) != c) >= (d || e)'\'' -a 2,0,0,1,0
0
$ test-expr '\''((a && b) != c) >= (d || e)'\'' -a 2,0,0,1,1
0
$ test-expr '\''((a && b) != c) >= (d || e)'\'' -a 2,0,0,1,2
0
$ test-expr '\''((a && b) != c) >= (d || e)'\'' -a 2,1,0,2,0
1
$ test-expr '\''((a && b) != c) >= (d || e)'\'' -a 2,1,1,0,1
0
$ test-expr '\''((a && b) != c) >= (d || e)'\'' -a 2,1,1,1,0
0
$ test-expr '\''((a && b) != c) >= (d || e)'\'' -a 2,1,1,2,2
0
$ test-expr '\''((a && b) != c) >= (d || e)'\'' -a 2,2,0,0,2
1
$ test-expr '\''((a && b) != c) >= (d || e)'\'' -a 2,2,0,2,2
1
$ test-expr '\''((a && b) != c) >= (d || e)'\'' -a 2,2,2,2,1
1
$ test-expr '\''((a && b) != c) >= (d || e)'\'' -a 2,2,2,2,2
1
$ test-expr '\''((a && b) != c) || (d >= e)'\'' -a 0,0,0,2,2
1
$ test-expr '\''((a && b) != c) || (d >= e)'\'' -a 0,0,1,0,0
1
$ test-expr '\''((a && b) != c) || (d >= e)'\'' -a 0,1,0,2,0
1
$ test-expr '\''((a && b) != c) || (d >= e)'\'' -a 0,1,2,0,1
1
$ test-expr '\''((a && b) != c) || (d >= e)'\'' -a 0,2,0,2,1
1
$ test-expr '\''((a && b) != c) || (d >= e)'\'' -a 0,2,1,2,0
1
$ test-expr '\''((a && b) != c) || (d >= e)'\'' -a 1,0,0,0,0
1
$ test-expr '\''((a && b) != c) || (d >= e)'\'' -a 1,0,1,1,0
1
$ test-expr '\''((a && b) != c) || (d >= e)'\'' -a 1,0,2,2,0
1
$ test-expr '\''((a && b) != c) || (d >= e)'\'' -a 1,1,0,1,1
1
$ test-expr '\''((a && b) != c) || (d >= e)'\'' -a 1,1,0,2,1
1
$ test-expr '\''((a && b) != c) || (d >= e)'\'' -a 1,1,1,0,0
1
$ test-expr '\''((a && b) != c) || (d >= e)'\'' -a 1,1,2,0,2
1
$ test-expr '\''((a && b) != c) || (d >= e)'\'' -a 1,1,2,2,1
1
$ test-expr '\''((a && b) != c) || (d >= e)'\'' -a 1,1,2,2,2
1
$ test-expr '\''((a && b) != c) || (d >= e)'\'' -a 1,2,0,2,1
1
$ test-expr '\''((a && b) != c) || (d >= e)'\'' -a 1,2,2,1,0
1
$ test-expr '\''((a && b) != c) || (d >= e)'\'' -a 1,2,2,1,2
1
$ test-expr '\''((a && b) != c) || (d >= e)'\'' -a 2,0,0,0,2
0
$ test-expr '\''((a && b) != c) || (d >= e)'\'' -a 2,0,0,2,2
1
$ test-expr '\''((a && b) != c) || (d >= e)'\'' -a 2,0,1,0,2
1
$ test-expr '\''((a && b) != c) || (d >= e)'\'' -a 2,0,2,1,0
1
$ test-expr '\''((a && b) != c) || (d >= e)'\'' -a 2,1,2,1,0
1
$ test-expr '\''((a && b) != c) || (d >= e)'\'' -a 2,1,2,2,1
1
$ test-expr '\''((a && b) != c) || (d >= e)'\'' -a 2,1,2,2,2
1
$ test-expr '\''((a && b) != c) || (d >= e)'\'' -a 2,2,0,1,1
1
$ test-expr '\''((a && b) != c) || (d >= e)'\'' -a 2,2,0,2,2
1
$ test-expr '\''((a && b) != c) || (d >= e)'\'' -a 2,2,2,1,2
1
$ test-expr '\''((a && b) != (c >= d)) || e'\'' -a 0,0,1,2,2
1
$ test-expr '\''((a && b) != (c >= d)) || e'\'' -a 0,0,2,1,1
1
$ test-expr '\''((a && b) != (c >= d)) || e'\'' -a 0,1,0,0,1
1
$ test-expr '\''((a && b) != (c >= d)) || e'\'' -a 0,1,2,1,0
1
$ test-expr '\''((a && b) != (c >= d)) || e'\'' -a 0,1,2,1,1
1
$ test-expr '\''((a && b) != (c >= d)) || e'\'' -a 0,2,0,0,1
1
$ test-expr '\''((a && b) != (c >= d)) || e'\'' -a 0,2,0,2,1
1
$ test-expr '\''((a && b) != (c >= d)) || e'\'' -a 0,2,2,0,0
1
$ test-expr '\''((a && b) != (c >= d)) || e'\'' -a 0,2,2,1,0
1
$ test-expr '\''((a && b) != (c >= d)) || e'\'' -a 1,0,0,0,0
1
$ test-expr '\''((a && b) != (c >= d)) || e'\'' -a 1,0,2,0,0
1
$ test-expr '\''((a && b) != (c >= d)) || e'\'' -a 1,1,0,0,2
1
$ test-expr '\''((a && b) != (c >= d)) || e'\'' -a 1,1,0,2,2
1
$ test-expr '\''((a && b) != (c >= d)) || e'\'' -a 1,1,1,0,0
0
$ test-expr '\''((a && b) != (c >= d)) || e'\'' -a 1,1,1,0,1
1
$ test-expr '\''((a && b) != (c >= d)) || e'\'' -a 1,1,1,2,2
1
$ test-expr '\''((a && b) != (c >= d)) || e'\'' -a 1,1,2,2,1
1
$ test-expr '\''((a && b) != (c >= d)) || e'\'' -a 1,2,2,2,1
1
$ test-expr '\''((a && b) != (c >= d)) || e'\'' -a 2,0,0,0,1
1
$ test-expr '\''((a && b) != (c >= d)) || e'\'' -a 2,0,0,1,1
1
$ test-expr '\''((a && b) != (c >= d)) || e'\'' -a 2,0,0,2,1
1
$ test-expr '\''((a && b) != (c >= d)) || e'\'' -a 2,0,1,0,2
1
$ test-expr '\''((a && b) != (c >= d)) || e'\'' -a 2,0,1,1,1
1
$ test-expr '\''((a && b) != (c >= d)) || e'\'' -a 2,1,1,0,0
0
$ test-expr '\''((a && b) != (c >= d)) || e'\'' -a 2,1,1,1,2
1
$ test-expr '\''((a && b) != (c >= d)) || e'\'' -a 2,1,2,0,1
1
$ test-expr '\''((a && b) != (c >= d)) || e'\'' -a 2,1,2,1,1
1
$ test-expr '\''((a && b) != (c >= d)) || e'\'' -a 2,2,0,2,1
1
$ test-expr '\''((a && b) != (c >= d)) || e'\'' -a 2,2,1,1,1
1
$ test-expr '\''((a && b) != (c >= d)) || e'\'' -a 2,2,1,2,0
1
$ test-expr '\''((a && b) != (c >= d)) || e'\'' -a 2,2,2,1,0
0
$ test-expr '\''((a && b) != (c >= d)) || e'\'' -a 2,2,2,2,0
0
$ test-expr '\''((a && b) != (c >= d)) || e'\'' -a 2,2,2,2,2
1
$ test-expr '\''((a && b) != (c || d)) >= e'\'' -a 0,0,0,0,0
1
$ test-expr '\''((a && b) != (c || d)) >= e'\'' -a 0,0,0,1,2
0
$ test-expr '\''((a && b) != (c || d)) >= e'\'' -a 0,0,1,1,1
1
$ test-expr '\''((a && b) != (c || d)) >= e'\'' -a 0,0,1,2,2
0
$ test-expr '\''((a && b) != (c || d)) >= e'\'' -a 0,1,0,1,1
1
$ test-expr '\''((a && b) != (c || d)) >= e'\'' -a 0,1,0,1,2
0
$ test-expr '\''((a && b) != (c || d)) >= e'\'' -a 0,1,1,1,2
0
$ test-expr '\''((a && b) != (c || d)) >= e'\'' -a 0,1,1,2,0
1
$ test-expr '\''((a && b) != (c || d)) >= e'\'' -a 0,1,2,1,1
1
$ test-expr '\''((a && b) != (c || d)) >= e'\'' -a 0,1,2,2,1
1
$ test-expr '\''((a && b) != (c || d)) >= e'\'' -a 0,2,0,1,1
1
$ test-expr '\''((a && b) != (c || d)) >= e'\'' -a 0,2,1,2,0
1
$ test-expr '\''((a && b) != (c || d)) >= e'\'' -a 0,2,2,2,1
1
$ test-expr '\''((a && b) != (c || d)) >= e'\'' -a 0,2,2,2,2
0
$ test-expr '\''((a && b) != (c || d)) >= e'\'' -a 1,0,0,1,0
1
$ test-expr '\''((a && b) != (c || d)) >= e'\'' -a 1,0,0,2,0
1
$ test-expr '\''((a && b) != (c || d)) >= e'\'' -a 1,0,1,1,1
1
$ test-expr '\''((a && b) != (c || d)) >= e'\'' -a 1,0,2,0,1
1
$ test-expr '\''((a && b) != (c || d)) >= e'\'' -a 1,0,2,2,2
0
$ test-expr '\''((a && b) != (c || d)) >= e'\'' -a 1,1,0,2,1
0
$ test-expr '\''((a && b) != (c || d)) >= e'\'' -a 1,1,0,2,2
0
$ test-expr '\''((a && b) != (c || d)) >= e'\'' -a 1,1,1,0,1
0
$ test-expr '\''((a && b) != (c || d)) >= e'\'' -a 1,1,2,0,1
0
$ test-expr '\''((a && b) != (c || d)) >= e'\'' -a 1,2,0,0,2
0
$ test-expr '\''((a && b) != (c || d)) >= e'\'' -a 1,2,0,1,0
1
$ test-expr '\''((a && b) != (c || d)) >= e'\'' -a 1,2,2,0,1
0
$ test-expr '\''((a && b) != (c || d)) >= e'\'' -a 2,0,0,2,2
0
$ test-expr '\''((a && b) != (c || d)) >= e'\'' -a 2,0,1,0,0
1
$ test-expr '\''((a && b) != (c || d)) >= e'\'' -a 2,0,1,2,2
0
$ test-expr '\''((a && b) != (c || d)) >= e'\'' -a 2,0,2,2,0
1
$ test-expr '\''((a && b) != (c || d)) >= e'\'' -a 2,1,0,0,1
1
$ test-expr '\''((a && b) != (c || d)) >= e'\'' -a 2,1,0,2,1
0
$ test-expr '\''((a && b) != (c || d)) >= e'\'' -a 2,1,1,1,2
0
$ test-expr '\''((a && b) != (c || d)) >= e'\'' -a 2,1,1,2,0
1
$ test-expr '\''((a && b) != (c || d)) >= e'\'' -a 2,1,2,2,1
0
$ test-expr '\''((a && b) != (c || d)) >= e'\'' -a 2,2,0,2,1
0
$ test-expr '\''((a && b) != (c || d)) >= e'\'' -a 2,2,2,0,2
0
$ test-expr '\''((a && b) >= c) != (d || e)'\'' -a 0,0,0,2,2
0
$ test-expr '\''((a && b) >= c) != (d || e)'\'' -a 0,0,1,0,0
0
$ test-expr '\''((a && b) >= c) != (d || e)'\'' -a 0,0,1,2,0
1
$ test-expr '\''((a && b) >= c) != (d || e)'\'' -a 0,1,0,1,2
0
$ test-expr '\''((a && b) >= c) != (d || e)'\'' -a 0,1,1,0,0
0
$ test-expr '\''((a && b) >= c) != (d || e)'\'' -a 0,1,1,2,0
1
$ test-expr '\''((a && b) >= c) != (d || e)'\'' -a 0,2,0,0,0
1
$ test-expr '\''((a && b) >= c) != (d || e)'\'' -a 0,2,0,0,2
0
$ test-expr '\''((a && b) >= c) != (d || e)'\'' -a 0,2,0,1,1
0
$ test-expr '\''((a && b) >= c) != (d || e)'\'' -a 0,2,1,0,2
1
$ test-expr '\''((a && b) >= c) != (d || e)'\'' -a 0,2,1,1,2
1
$ test-expr '\''((a && b) >= c) != (d || e)'\'' -a 1,0,0,1,1
0
$ test-expr '\''((a && b) >= c) != (d || e)'\'' -a 1,0,1,0,0
0
$ test-expr '\''((a && b) >= c) != (d || e)'\'' -a 1,0,1,0,2
1
$ test-expr '\''((a && b) >= c) != (d || e)'\'' -a 1,0,1,1,0
1
$ test-expr '\''((a && b) >= c) != (d || e)'\'' -a 1,0,1,2,1
1
$ test-expr '\''((a && b) >= c) != (d || e)'\'' -a 1,1,0,2,0
0
$ test-expr '\''((a && b) >= c) != (d || e)'\'' -a 1,1,1,0,2
0
$ test-expr '\''((a && b) >= c) != (d || e)'\'' -a 1,1,1,2,1
0
$ test-expr '\''((a && b) >= c) != (d || e)'\'' -a 2,0,0,0,0
1
$ test-expr '\''((a && b) >= c) != (d || e)'\'' -a 2,0,0,1,1
0
$ test-expr '\''((a && b) >= c) != (d || e)'\'' -a 2,0,0,1,2
0
$ test-expr '\''((a && b) >= c) != (d || e)'\'' -a 2,0,1,2,0
1
$ test-expr '\''((a && b) >= c) != (d || e)'\'' -a 2,0,2,2,1
1
$ test-expr '\''((a && b) >= c) != (d || e)'\'' -a 2,1,1,0,1
0
$ test-expr '\''((a && b) >= c) != (d || e)'\'' -a 2,1,1,0,2
0
$ test-expr '\''((a && b) >= c) != (d || e)'\'' -a 2,1,2,0,1
1
$ test-expr '\''((a && b) >= c) != (d || e)'\'' -a 2,1,2,1,2
1
$ test-expr '\''((a && b) >= c) != (d || e)'\'' -a 2,2,0,0,0
1
$ test-expr '\''((a && b) >= c) != (d || e)'\'' -a 2,2,0,2,0
0
$ test-expr '\''((a && b) >= c) != (d || e)'\'' -a 2,2,1,1,2
0
$ test-expr '\''((a && b) >= c) != (d || e)'\'' -a 2,2,2,0,2
1
$ test-expr '\''((a && b) >= c) || (d != e)'\'' -a 0,0,2,2,1
1
$ test-expr '\''((a && b) >= c) || (d != e)'\'' -a 0,1,0,2,2
1
$ test-expr '\''((a && b) >= c) || (d != e)'\'' -a 0,1,1,0,0
0
$ test-expr '\''((a && b) >= c) || (d != e)'\'' -a 0,1,2,0,2
1
$ test-expr '\''((a && b) >= c) || (d != e)'\'' -a 0,1,2,1,0
1
$ test-expr '\''((a && b) >= c) || (d != e)'\'' -a 0,1,2,2,2
0
$ test-expr '\''((a && b) >= c) || (d != e)'\'' -a 0,2,0,0,1
1
$ test-expr '\''((a && b) >= c) || (d != e)'\'' -a 0,2,0,0,2
1
$ test-expr '\''((a && b) >= c) || (d != e)'\'' -a 0,2,0,1,1
1
$ test-expr '\''((a && b) >= c) || (d != e)'\'' -a 0,2,1,0,1
1
$ test-expr '\''((a && b) >= c) || (d != e)'\'' -a 0,2,1,1,0
1
$ test-expr '\''((a && b) >= c) || (d != e)'\'' -a 0,2,2,0,0
0
$ test-expr '\''((a && b) >= c) || (d != e)'\'' -a 0,2,2,0,2
1
$ test-expr '\''((a && b) >= c) || (d != e)'\'' -a 1,1,1,0,0
1
$ test-expr '\''((a && b) >= c) || (d != e)'\'' -a 1,1,2,0,1
1
$ test-expr '\''((a && b) >= c) || (d != e)'\'' -a 1,1,2,0,2
1
$ test-expr '\''((a && b) >= c) || (d != e)'\'' -a 1,2,0,1,1
1
$ test-expr '\''((a && b) >= c) || (d != e)'\'' -a 1,2,2,0,0
0
$ test-expr '\''((a && b) >= c) || (d != e)'\'' -a 1,2,2,1,0
1
$ test-expr '\''((a && b) >= c) || (d != e)'\'' -a 2,0,0,0,1
1
$ test-expr '\''((a && b) >= c) || (d != e)'\'' -a 2,0,1,0,0
0
$ test-expr '\''((a && b) >= c) || (d != e)'\'' -a 2,0,1,1,0
1
$ test-expr '\''((a && b) >= c) || (d != e)'\'' -a 2,1,0,0,1
1
$ test-expr '\''((a && b) >= c) || (d != e)'\'' -a 2,1,2,1,1
0
$ test-expr '\''((a && b) >= c) || (d != e)'\'' -a 2,2,0,1,0
1
$ test-expr '\''((a && b) >= c) || (d != e)'\'' -a 2,2,0,2,1
1
$ test-expr '\''((a && b) >= c) || (d != e)'\'' -a 2,2,1,1,0
1
$ test-expr '\''((a && b) >= c) || (d != e)'\'' -a 2,2,1,2,0
1
$ test-expr '\''((a && b) >= c) || (d != e)'\'' -a 2,2,2,1,0
1
$ test-expr '\''((a && b) >= c) || (d != e)'\'' -a 2,2,2,1,2
1
$ test-expr '\''((a && b) >= c) || (d != e)'\'' -a 2,2,2,2,0
1
$ test-expr '\''((a && b) >= (c != d)) || e'\'' -a 0,1,2,1,2
1
$ test-expr '\''((a && b) >= (c != d)) || e'\'' -a 0,2,1,0,1
1
$ test-expr '\''((a && b) >= (c != d)) || e'\'' -a 1,0,1,0,0
0
$ test-expr '\''((a && b) >= (c != d)) || e'\'' -a 1,0,1,2,1
1
$ test-expr '\''((a && b) >= (c != d)) || e'\'' -a 1,0,2,1,2
1
$ test-expr '\''((a && b) >= (c != d)) || e'\'' -a 1,0,2,2,1
1
$ test-expr '\''((a && b) >= (c != d)) || e'\'' -a 1,1,2,1,2
1
$ test-expr '\''((a && b) >= (c != d)) || e'\'' -a 1,2,0,2,0
1
$ test-expr '\''((a && b) >= (c != d)) || e'\'' -a 1,2,1,1,2
1
$ test-expr '\''((a && b) >= (c != d)) || e'\'' -a 1,2,2,1,0
1
$ test-expr '\''((a && b) >= (c != d)) || e'\'' -a 1,2,2,2,0
1
$ test-expr '\''((a && b) >= (c != d)) || e'\'' -a 2,0,0,0,1
1
$ test-expr '\''((a && b) >= (c != d)) || e'\'' -a 2,0,2,0,0
0
$ test-expr '\''((a && b) >= (c != d)) || e'\'' -a 2,0,2,1,2
1
$ test-expr '\''((a && b) >= (c != d)) || e'\'' -a 2,1,0,1,2
1
$ test-expr '\''((a && b) >= (c != d)) || e'\'' -a 2,1,0,2,0
1
$ test-expr '\''((a && b) >= (c != d)) || e'\'' -a 2,1,2,0,1
1
$ test-expr '\''((a && b) >= (c != d)) || e'\'' -a 2,1,2,1,1
1
$ test-expr '\''((a && b) >= (c != d)) || e'\'' -a 2,1,2,2,2
1
$ test-expr '\''((a && b) >= (c != d)) || e'\'' -a 2,2,0,2,2
1
$ test-expr '\''((a && b) >= (c != d)) || e'\'' -a 2,2,2,1,1
1
$ test-expr '\''((a && b) >= (c || d)) != e'\'' -a 0,0,1,2,2
1
$ test-expr '\''((a && b) >= (c || d)) != e'\'' -a 0,0,2,0,2
1
$ test-expr '\''((a && b) >= (c || d)) != e'\'' -a 0,0,2,2,0
0
$ test-expr '\''((a && b) >= (c || d)) != e'\'' -a 0,0,2,2,2
1
$ test-expr '\''((a && b) >= (c || d)) != e'\'' -a 0,1,0,0,1
0
$ test-expr '\''((a && b) >= (c || d)) != e'\'' -a 0,1,0,1,1
1
$ test-expr '\''((a && b) >= (c || d)) != e'\'' -a 0,1,0,2,2
1
$ test-expr '\''((a && b) >= (c || d)) != e'\'' -a 0,1,1,0,2
1
$ test-expr '\''((a && b) >= (c || d)) != e'\'' -a 0,1,1,1,2
1
$ test-expr '\''((a && b) >= (c || d)) != e'\'' -a 0,1,1,2,1
1
$ test-expr '\''((a && b) >= (c || d)) != e'\'' -a 0,1,2,0,1
1
$ test-expr '\''((a && b) >= (c || d)) != e'\'' -a 0,2,0,1,1
1
$ test-expr '\''((a && b) >= (c || d)) != e'\'' -a 0,2,1,2,0
0
$ test-expr '\''((a && b) >= (c || d)) != e'\'' -a 0,2,2,0,1
1
$ test-expr '\''((a && b) >= (c || d)) != e'\'' -a 1,0,0,0,2
1
$ test-expr '\''((a && b) >= (c || d)) != e'\'' -a 1,0,0,2,2
1
$ test-expr '\''((a && b) >= (c || d)) != e'\'' -a 1,0,1,0,1
1
$ test-expr '\''((a && b) >= (c || d)) != e'\'' -a 1,0,1,2,0
0
$ test-expr '\''((a && b) >= (c || d)) != e'\'' -a 1,0,2,0,1
1
$ test-expr '\''((a && b) >= (c || d)) != e'\'' -a 1,0,2,1,0
0
$ test-expr '\''((a && b) >= (c || d)) != e'\'' -a 1,0,2,1,1
1
$ test-expr '\''((a && b) >= (c || d)) != e'\'' -a 1,1,1,1,1
0
$ test-expr '\''((a && b) >= (c || d)) != e'\'' -a 1,1,2,0,0
1
$ test-expr '\''((a && b) >= (c || d)) != e'\'' -a 1,1,2,1,1
0
$ test-expr '\''((a && b) >= (c || d)) != e'\'' -a 1,2,0,0,1
0
$ test-expr '\''((a && b) >= (c || d)) != e'\'' -a 2,0,0,1,2
1
$ test-expr '\''((a && b) >= (c || d)) != e'\'' -a 2,0,1,0,2
1
$ test-expr '\''((a && b) >= (c || d)) != e'\'' -a 2,0,1,2,0
0
$ test-expr '\''((a && b) >= (c || d)) != e'\'' -a 2,0,1,2,2
1
$ test-expr '\''((a && b) >= (c || d)) != e'\'' -a 2,0,2,1,1
1
$ test-expr '\''((a && b) >= (c || d)) != e'\'' -a 2,0,2,2,1
1
$ test-expr '\''((a && b) >= (c || d)) != e'\'' -a 2,1,0,0,0
1
$ test-expr '\''((a && b) >= (c || d)) != e'\'' -a 2,1,1,0,0
1
$ test-expr '\''((a && b) >= (c || d)) != e'\'' -a 2,1,1,0,1
0
$ test-expr '\''((a && b) >= (c || d)) != e'\'' -a 2,1,1,1,2
1
$ test-expr '\''((a && b) >= (c || d)) != e'\'' -a 2,1,2,1,0
1
$ test-expr '\''((a && b) >= (c || d)) != e'\'' -a 2,1,2,1,2
1
$ test-expr '\''((a && b) >= (c || d)) != e'\'' -a 2,2,0,2,0
1
$ test-expr '\''((a && b) >= (c || d)) != e'\'' -a 2,2,1,0,2
1
$ test-expr '\''((a && b) >= (c || d)) != e'\'' -a 2,2,1,2,2
1
$ test-expr '\''((a && b) >= (c || d)) != e'\'' -a 2,2,2,1,2
1
$ test-expr '\''((a && b) >= (c || d)) != e'\'' -a 2,2,2,2,2
1
$ test-expr '\''((a && b) || c) != (d >= e)'\'' -a 0,0,0,0,1
0
$ test-expr '\''((a && b) || c) != (d >= e)'\'' -a 0,0,1,1,0
0
$ test-expr '\''((a && b) || c) != (d >= e)'\'' -a 0,0,2,2,2
0
$ test-expr '\''((a && b) || c) != (d >= e)'\'' -a 0,1,0,2,2
1
$ test-expr '\''((a && b) || c) != (d >= e)'\'' -a 0,1,1,1,0
0
$ test-expr '\''((a && b) || c) != (d >= e)'\'' -a 0,1,2,1,0
0
$ test-expr '\''((a && b) || c) != (d >= e)'\'' -a 0,2,0,2,2
1
$ test-expr '\''((a && b) || c) != (d >= e)'\'' -a 0,2,1,2,0
0
$ test-expr '\''((a && b) || c) != (d >= e)'\'' -a 0,2,2,1,1
0
$ test-expr '\''((a && b) || c) != (d >= e)'\'' -a 1,0,0,1,0
1
$ test-expr '\''((a && b) || c) != (d >= e)'\'' -a 1,0,0,1,2
0
$ test-expr '\''((a && b) || c) != (d >= e)'\'' -a 1,0,1,0,1
1
$ test-expr '\''((a && b) || c) != (d >= e)'\'' -a 1,0,2,0,0
0
$ test-expr '\''((a && b) || c) != (d >= e)'\'' -a 1,0,2,1,0
0
$ test-expr '\''((a && b) || c) != (d >= e)'\'' -a 1,0,2,1,2
1
$ test-expr '\''((a && b) || c) != (d >= e)'\'' -a 1,1,0,2,0
0
$ test-expr '\''((a && b) || c) != (d >= e)'\'' -a 1,1,1,0,0
0
$ test-expr '\''((a && b) || c) != (d >= e)'\'' -a 1,1,1,0,1
1
$ test-expr '\''((a && b) || c) != (d >= e)'\'' -a 1,1,1,1,1
0
$ test-expr '\''((a && b) || c) != (d >= e)'\'' -a 1,1,1,2,0
0
$ test-expr '\''((a && b) || c) != (d >= e)'\'' -a 1,2,0,0,0
0
$ test-expr '\''((a && b) || c) != (d >= e)'\'' -a 1,2,1,1,0
0
$ test-expr '\''((a && b) || c) != (d >= e)'\'' -a 1,2,2,2,2
0
$ test-expr '\''((a && b) || c) != (d >= e)'\'' -a 2,0,0,2,1
1
$ test-expr '\''((a && b) || c) != (d >= e)'\'' -a 2,0,0,2,2
1
$ test-expr '\''((a && b) || c) != (d >= e)'\'' -a 2,0,1,1,2
1
$ test-expr '\''((a && b) || c) != (d >= e)'\'' -a 2,0,1,2,1
0
$ test-expr '\''((a && b) || c) != (d >= e)'\'' -a 2,0,2,0,2
1
$ test-expr '\''((a && b) || c) != (d >= e)'\'' -a 2,1,0,1,1
0
$ test-expr '\''((a && b) || c) != (d >= e)'\'' -a 2,1,1,0,1
1
$ test-expr '\''((a && b) || c) != (d >= e)'\'' -a 2,1,2,0,1
1
$ test-expr '\''((a && b) || c) != (d >= e)'\'' -a 2,1,2,0,2
1
$ test-expr '\''((a && b) || c) != (d >= e)'\'' -a 2,1,2,2,2
0
$ test-expr '\''((a && b) || c) != (d >= e)'\'' -a 2,2,0,2,0
0
$ test-expr '\''((a && b) || c) != (d >= e)'\'' -a 2,2,1,2,1
0
$ test-expr '\''((a && b) || c) != (d >= e)'\'' -a 2,2,2,1,2
1
$ test-expr '\''((a && b) || c) >= (d != e)'\'' -a 0,0,1,2,1
1
$ test-expr '\''((a && b) || c) >= (d != e)'\'' -a 0,1,0,0,1
0
$ test-expr '\''((a && b) || c) >= (d != e)'\'' -a 0,1,0,2,2
1
$ test-expr '\''((a && b) || c) >= (d != e)'\'' -a 0,1,1,0,0
1
$ test-expr '\''((a && b) || c) >= (d != e)'\'' -a 0,2,0,2,1
0
$ test-expr '\''((a && b) || c) >= (d != e)'\'' -a 0,2,1,1,0
1
$ test-expr '\''((a && b) || c) >= (d != e)'\'' -a 0,2,2,0,1
1
$ test-expr '\''((a && b) || c) >= (d != e)'\'' -a 1,0,0,1,0
0
$ test-expr '\''((a && b) || c) >= (d != e)'\'' -a 1,0,1,0,0
1
$ test-expr '\''((a && b) || c) >= (d != e)'\'' -a 1,0,2,2,0
1
$ test-expr '\''((a && b) || c) >= (d != e)'\'' -a 1,0,2,2,1
1
$ test-expr '\''((a && b) || c) >= (d != e)'\'' -a 1,1,0,0,1
1
$ test-expr '\''((a && b) || c) >= (d != e)'\'' -a 1,1,0,1,1
1
$ test-expr '\''((a && b) || c) >= (d != e)'\'' -a 1,1,0,1,2
1
$ test-expr '\''((a && b) || c) >= (d != e)'\'' -a 1,1,1,0,0
1
$ test-expr '\''((a && b) || c) >= (d != e)'\'' -a 1,1,2,2,0
1
$ test-expr '\''((a && b) || c) >= (d != e)'\'' -a 1,2,0,0,0
1
$ test-expr '\''((a && b) || c) >= (d != e)'\'' -a 1,2,0,1,2
1
$ test-expr '\''((a && b) || c) >= (d != e)'\'' -a 1,2,1,0,2
1
$ test-expr '\''((a && b) || c) >= (d != e)'\'' -a 1,2,1,1,2
1
$ test-expr '\''((a && b) || c) >= (d != e)'\'' -a 1,2,2,0,1
1
$ test-expr '\''((a && b) || c) >= (d != e)'\'' -a 2,0,0,0,1
0
$ test-expr '\''((a && b) || c) >= (d != e)'\'' -a 2,0,0,2,0
0
$ test-expr '\''((a && b) || c) >= (d != e)'\'' -a 2,0,1,0,1
1
$ test-expr '\''((a && b) || c) >= (d != e)'\'' -a 2,1,0,2,0
1
$ test-expr '\''((a && b) || c) >= (d != e)'\'' -a 2,1,0,2,1
1
$ test-expr '\''((a && b) || c) >= (d != e)'\'' -a 2,1,1,1,1
1
$ test-expr '\''((a && b) || c) >= (d != e)'\'' -a 2,1,1,1,2
1
$ test-expr '\''((a && b) || c) >= (d != e)'\'' -a 2,2,0,2,2
1
$ test-expr '\''((a && b) || c) >= (d != e)'\'' -a 2,2,1,1,1
1
$ test-expr '\''((a && b) || c) >= (d != e)'\'' -a 2,2,1,2,0
1
$ test-expr '\''((a && b) || c) >= (d != e)'\'' -a 2,2,2,0,1
1
$ test-expr '\''((a && b) || (c != d)) >= e'\'' -a 0,0,0,0,2
0
$ test-expr '\''((a && b) || (c != d)) >= e'\'' -a 0,0,1,1,0
1
$ test-expr '\''((a && b) || (c != d)) >= e'\'' -a 0,0,1,1,2
0
$ test-expr '\''((a && b) || (c != d)) >= e'\'' -a 0,1,0,2,1
1
$ test-expr '\''((a && b) || (c != d)) >= e'\'' -a 0,1,1,0,0
1
$ test-expr '\''((a && b) || (c != d)) >= e'\'' -a 0,1,2,2,2
0
$ test-expr '\''((a && b) || (c != d)) >= e'\'' -a 0,2,1,0,0
1
$ test-expr '\''((a && b) || (c != d)) >= e'\'' -a 0,2,1,2,2
0
$ test-expr '\''((a && b) || (c != d)) >= e'\'' -a 0,2,2,0,0
1
$ test-expr '\''((a && b) || (c != d)) >= e'\'' -a 0,2,2,1,2
0
$ test-expr '\''((a && b) || (c != d)) >= e'\'' -a 1,0,0,2,1
1
$ test-expr '\''((a && b) || (c != d)) >= e'\'' -a 1,0,1,0,2
0
$ test-expr '\''((a && b) || (c != d)) >= e'\'' -a 1,0,2,1,0
1
$ test-expr '\''((a && b) || (c != d)) >= e'\'' -a 1,1,0,1,2
0
$ test-expr '\''((a && b) || (c != d)) >= e'\'' -a 1,1,0,2,1
1
$ test-expr '\''((a && b) || (c != d)) >= e'\'' -a 1,1,1,0,1
1
$ test-expr '\''((a && b) || (c != d)) >= e'\'' -a 1,1,2,0,0
1
$ test-expr '\''((a && b) || (c != d)) >= e'\'' -a 2,0,0,1,2
0
$ test-expr '\''((a && b) || (c != d)) >= e'\'' -a 2,0,2,2,0
1
$ test-expr '\''((a && b) || (c != d)) >= e'\'' -a 2,0,2,2,2
0
$ test-expr '\''((a && b) || (c != d)) >= e'\'' -a 2,1,2,1,1
1
$ test-expr '\''((a && b) || (c != d)) >= e'\'' -a 2,2,1,0,0
1
$ test-expr '\''((a && b) || (c != d)) >= e'\'' -a 2,2,1,1,1
1
$ test-expr '\''((a && b) || (c != d)) >= e'\'' -a 2,2,2,0,1
1
$ test-expr '\''((a && b) || (c != d)) >= e'\'' -a 2,2,2,2,1
1
$ test-expr '\''((a && b) || (c >= d)) != e'\'' -a 0,0,0,1,1
1
$ test-expr '\''((a && b) || (c >= d)) != e'\'' -a 0,0,0,2,2
1
$ test-expr '\''((a && b) || (c >= d)) != e'\'' -a 0,0,1,0,2
1
$ test-expr '\''((a && b) || (c >= d)) != e'\'' -a 0,0,2,1,1
0
$ test-expr '\''((a && b) || (c >= d)) != e'\'' -a 0,1,2,1,0
1
$ test-expr '\''((a && b) || (c >= d)) != e'\'' -a 0,2,0,2,2
1
$ test-expr '\''((a && b) || (c >= d)) != e'\'' -a 0,2,2,1,1
0
$ test-expr '\''((a && b) || (c >= d)) != e'\'' -a 0,2,2,2,0
1
$ test-expr '\''((a && b) || (c >= d)) != e'\'' -a 0,2,2,2,2
1
$ test-expr '\''((a && b) || (c >= d)) != e'\'' -a 1,0,0,2,0
0
$ test-expr '\''((a && b) || (c >= d)) != e'\'' -a 1,0,1,1,1
0
$ test-expr '\''((a && b) || (c >= d)) != e'\'' -a 1,0,1,2,1
1
$ test-expr '\''((a && b) || (c >= d)) != e'\'' -a 1,0,2,2,2
1
$ test-expr '\''((a && b) || (c >= d)) != e'\'' -a 1,2,0,1,2
1
$ test-expr '\''((a && b) || (c >= d)) != e'\'' -a 1,2,0,2,2
1
$ test-expr '\''((a && b) || (c >= d)) != e'\'' -a 1,2,1,2,2
1
$ test-expr '\''((a && b) || (c >= d)) != e'\'' -a 1,2,2,1,0
1
$ test-expr '\''((a && b) || (c >= d)) != e'\'' -a 1,2,2,1,2
1
$ test-expr '\''((a && b) || (c >= d)) != e'\'' -a 2,0,0,2,0
0
$ test-expr '\''((a && b) || (c >= d)) != e'\'' -a 2,0,0,2,1
1
$ test-expr '\''((a && b) || (c >= d)) != e'\'' -a 2,0,2,2,1
0
$ test-expr '\''((a && b) || (c >= d)) != e'\'' -a 2,1,0,0,0
1
$ test-expr '\''((a && b) || (c >= d)) != e'\'' -a 2,1,0,0,2
1
$ test-expr '\''((a && b) || (c >= d)) != e'\'' -a 2,1,0,1,1
0
$ test-expr '\''((a && b) || (c >= d)) != e'\'' -a 2,1,0,1,2
1
$ test-expr '\''((a && b) || (c >= d)) != e'\'' -a 2,1,0,2,1
0
$ test-expr '\''((a && b) || (c >= d)) != e'\'' -a 2,1,2,2,1
0
$ test-expr '\''((a && b) || (c >= d)) != e'\'' -a 2,2,1,0,0
1
$ test-expr '\''((a && b) || (c >= d)) != e'\'' -a 2,2,1,0,1
0
$ test-expr '\''((a && b) || (c >= d)) != e'\'' -a 2,2,1,2,0
1
$ test-expr '\''((a && (b != c)) >= d) || e'\'' -a 0,0,0,0,2
1
$ test-expr '\''((a && (b != c)) >= d) || e'\'' -a 0,0,1,2,2
1
$ test-expr '\''((a && (b != c)) >= d) || e'\'' -a 0,1,0,0,0
1
$ test-expr '\''((a && (b != c)) >= d) || e'\'' -a 0,1,0,2,0
0
$ test-expr '\''((a && (b != c)) >= d) || e'\'' -a 0,1,1,2,0
0
$ test-expr '\''((a && (b != c)) >= d) || e'\'' -a 0,2,0,2,1
1
$ test-expr '\''((a && (b != c)) >= d) || e'\'' -a 0,2,1,1,0
0
$ test-expr '\''((a && (b != c)) >= d) || e'\'' -a 0,2,2,0,0
1
$ test-expr '\''((a && (b != c)) >= d) || e'\'' -a 0,2,2,1,1
1
$ test-expr '\''((a && (b != c)) >= d) || e'\'' -a 1,0,0,1,1
1
$ test-expr '\''((a && (b != c)) >= d) || e'\'' -a 1,0,1,1,2
1
$ test-expr '\''((a && (b != c)) >= d) || e'\'' -a 1,0,2,0,0
1
$ test-expr '\''((a && (b != c)) >= d) || e'\'' -a 1,1,0,1,1
1
$ test-expr '\''((a && (b != c)) >= d) || e'\'' -a 1,1,1,1,2
1
$ test-expr '\''((a && (b != c)) >= d) || e'\'' -a 1,1,1,2,0
0
$ test-expr '\''((a && (b != c)) >= d) || e'\'' -a 1,1,2,0,2
1
$ test-expr '\''((a && (b != c)) >= d) || e'\'' -a 1,1,2,1,0
1
$ test-expr '\''((a && (b != c)) >= d) || e'\'' -a 1,2,0,1,2
1
$ test-expr '\''((a && (b != c)) >= d) || e'\'' -a 2,0,0,0,0
1
$ test-expr '\''((a && (b != c)) >= d) || e'\'' -a 2,0,1,1,1
1
$ test-expr '\''((a && (b != c)) >= d) || e'\'' -a 2,1,0,1,1
1
$ test-expr '\''((a && (b != c)) >= d) || e'\'' -a 2,1,0,1,2
1
$ test-expr '\''((a && (b != c)) >= d) || e'\'' -a 2,1,1,2,1
1
$ test-expr '\''((a && (b != c)) >= d) || e'\'' -a 2,2,0,1,0
1
$ test-expr '\''((a && (b != c)) >= d) || e'\'' -a 2,2,0,2,2
1
$ test-expr '\''((a && (b != c)) >= d) || e'\'' -a 2,2,2,0,2
1
$ test-expr '\''((a && (b != c)) >= d) || e'\'' -a 2,2,2,1,1
1
$ test-expr '\''((a && (b != c)) || d) >= e'\'' -a 0,0,0,1,0
1
$ test-expr '\''((a && (b != c)) || d) >= e'\'' -a 0,0,2,1,2
0
$ test-expr '\''((a && (b != c)) || d) >= e'\'' -a 0,1,0,2,2
0
$ test-expr '\''((a && (b != c)) || d) >= e'\'' -a 0,1,2,0,2
0
$ test-expr '\''((a && (b != c)) || d) >= e'\'' -a 0,1,2,1,1
1
$ test-expr '\''((a && (b != c)) || d) >= e'\'' -a 0,1,2,2,1
1
$ test-expr '\''((a && (b != c)) || d) >= e'\'' -a 0,2,0,0,0
1
$ test-expr '\''((a && (b != c)) || d) >= e'\'' -a 0,2,0,1,1
1
$ test-expr '\''((a && (b != c)) || d) >= e'\'' -a 0,2,1,0,0
1
$ test-expr '\''((a && (b != c)) || d) >= e'\'' -a 0,2,1,2,1
1
$ test-expr '\''((a && (b != c)) || d) >= e'\'' -a 1,0,0,1,2
0
$ test-expr '\''((a && (b != c)) || d) >= e'\'' -a 1,0,1,1,2
0
$ test-expr '\''((a && (b != c)) || d) >= e'\'' -a 1,0,2,1,1
1
$ test-expr '\''((a && (b != c)) || d) >= e'\'' -a 1,0,2,1,2
0
$ test-expr '\''((a && (b != c)) || d) >= e'\'' -a 1,1,0,1,1
1
$ test-expr '\''((a && (b != c)) || d) >= e'\'' -a 1,1,0,1,2
0
$ test-expr '\''((a && (b != c)) || d) >= e'\'' -a 1,1,0,2,2
0
$ test-expr '\''((a && (b != c)) || d) >= e'\'' -a 1,1,2,2,0
1
$ test-expr '\''((a && (b != c)) || d) >= e'\'' -a 1,1,2,2,1
1
$ test-expr '\''((a && (b != c)) || d) >= e'\'' -a 1,2,1,2,0
1
$ test-expr '\''((a && (b != c)) || d) >= e'\'' -a 1,2,2,1,2
0
$ test-expr '\''((a && (b != c)) || d) >= e'\'' -a 2,0,1,0,0
1
$ test-expr '\''((a && (b != c)) || d) >= e'\'' -a 2,0,2,0,2
0
$ test-expr '\''((a && (b != c)) || d) >= e'\'' -a 2,0,2,1,1
1
$ test-expr '\''((a && (b != c)) || d) >= e'\'' -a 2,1,0,1,0
1
$ test-expr '\''((a && (b != c)) || d) >= e'\'' -a 2,1,0,1,1
1
$ test-expr '\''((a && (b != c)) || d) >= e'\'' -a 2,1,1,1,0
1
$ test-expr '\''((a && (b != c)) || d) >= e'\'' -a 2,1,1,2,1
1
$ test-expr '\''((a && (b != c)) || d) >= e'\'' -a 2,1,1,2,2
0
$ test-expr '\''((a && (b != c)) || d) >= e'\'' -a 2,2,0,0,1
1
$ test-expr '\''((a && (b != c)) || d) >= e'\'' -a 2,2,0,1,0
1
$ test-expr '\''((a && (b != c)) || d) >= e'\'' -a 2,2,1,0,0
1
$ test-expr '\''((a && (b != c)) || d) >= e'\'' -a 2,2,1,1,0
1
$ test-expr '\''((a && (b != c)) || d) >= e'\'' -a 2,2,1,2,0
1
$ test-expr '\''((a && (b != c)) || d) >= e'\'' -a 2,2,2,1,1
1
$ test-expr '\''((a && (b != c)) || d) >= e'\'' -a 2,2,2,2,1
1
$ test-expr '\''((a && (b != c)) || d) >= e'\'' -a 2,2,2,2,2
0
$ test-expr '\''((a && (b >= c)) != d) || e'\'' -a 0,0,0,0,0
0
$ test-expr '\''((a && (b >= c)) != d) || e'\'' -a 0,0,0,1,1
1
$ test-expr '\''((a && (b >= c)) != d) || e'\'' -a 0,0,0,1,2
1
$ test-expr '\''((a && (b >= c)) != d) || e'\'' -a 0,0,1,0,0
0
$ test-expr '\''((a && (b >= c)) != d) || e'\'' -a 0,0,2,0,0
0
$ test-expr '\''((a && (b >= c)) != d) || e'\'' -a 0,1,0,2,2
1
$ test-expr '\''((a && (b >= c)) != d) || e'\'' -a 0,2,0,1,1
1
$ test-expr '\''((a && (b >= c)) != d) || e'\'' -a 0,2,2,0,0
0
$ test-expr '\''((a && (b >= c)) != d) || e'\'' -a 0,2,2,0,2
1
$ test-expr '\''((a && (b >= c)) != d) || e'\'' -a 0,2,2,1,2
1
$ test-expr '\''((a && (b >= c)) != d) || e'\'' -a 1,0,0,2,2
1
$ test-expr '\''((a && (b >= c)) != d) || e'\'' -a 1,0,2,1,0
1
$ test-expr '\''((a && (b >= c)) != d) || e'\'' -a 1,1,0,2,0
1
$ test-expr '\''((a && (b >= c)) != d) || e'\'' -a 1,1,1,0,2
1
$ test-expr '\''((a && (b >= c)) != d) || e'\'' -a 1,1,1,1,0
0
$ test-expr '\''((a && (b >= c)) != d) || e'\'' -a 1,2,0,2,2
1
$ test-expr '\''((a && (b >= c)) != d) || e'\'' -a 1,2,1,0,2
1
$ test-expr '\''((a && (b >= c)) != d) || e'\'' -a 1,2,2,0,2
1
$ test-expr '\''((a && (b >= c)) != d) || e'\'' -a 2,0,0,2,1
1
$ test-expr '\''((a && (b >= c)) != d) || e'\'' -a 2,0,0,2,2
1
$ test-expr '\''((a && (b >= c)) != d) || e'\'' -a 2,0,2,2,1
1
$ test-expr '\''((a && (b >= c)) != d) || e'\'' -a 2,0,2,2,2
1
$ test-expr '\''((a && (b >= c)) != d) || e'\'' -a 2,1,0,0,1
1
$ test-expr '\''((a && (b >= c)) != d) || e'\'' -a 2,1,1,0,1
1
$ test-expr '\''((a && (b >= c)) != d) || e'\'' -a 2,1,1,2,2
1
$ test-expr '\''((a && (b >= c)) != d) || e'\'' -a 2,2,0,0,2
1
$ test-expr '\''((a && (b >= c)) != d) || e'\'' -a 2,2,2,0,0
1
$ test-expr '\''((a && (b >= c)) != d) || e'\'' -a 2,2,2,1,1
1
$ test-expr '\''((a && (b >= c)) != d) || e'\'' -a 2,2,2,2,0
1
$ test-expr '\''((a && (b >= c)) != d) || e'\'' -a 2,2,2,2,1
1
$ test-expr '\''((a && (b >= c)) || d) != e'\'' -a 0,0,2,0,2
1
$ test-expr '\''((a && (b >= c)) || d) != e'\'' -a 0,0,2,1,0
1
$ test-expr '\''((a && (b >= c)) || d) != e'\'' -a 0,0,2,1,2
1
$ test-expr '\''((a && (b >= c)) || d) != e'\'' -a 0,0,2,2,0
1
$ test-expr '\''((a && (b >= c)) || d) != e'\'' -a 0,0,2,2,2
1
$ test-expr '\''((a && (b >= c)) || d) != e'\'' -a 0,1,1,0,1
1
$ test-expr '\''((a && (b >= c)) || d) != e'\'' -a 0,1,1,1,1
0
$ test-expr '\''((a && (b >= c)) || d) != e'\'' -a 0,1,1,2,0
1
$ test-expr '\''((a && (b >= c)) || d) != e'\'' -a 0,1,2,0,2
1
$ test-expr '\''((a && (b >= c)) || d) != e'\'' -a 0,2,1,2,0
1
$ test-expr '\''((a && (b >= c)) || d) != e'\'' -a 0,2,2,0,2
1
$ test-expr '\''((a && (b >= c)) || d) != e'\'' -a 1,0,0,0,2
1
$ test-expr '\''((a && (b >= c)) || d) != e'\'' -a 1,0,1,0,1
1
$ test-expr '\''((a && (b >= c)) || d) != e'\'' -a 1,0,1,1,0
1
$ test-expr '\''((a && (b >= c)) || d) != e'\'' -a 1,0,1,1,1
0
$ test-expr '\''((a && (b >= c)) || d) != e'\'' -a 1,0,1,2,1
0
$ test-expr '\''((a && (b >= c)) || d) != e'\'' -a 1,1,0,2,1
0
$ test-expr '\''((a && (b >= c)) || d) != e'\'' -a 1,1,1,2,0
1
$ test-expr '\''((a && (b >= c)) || d) != e'\'' -a 1,1,1,2,2
1
$ test-expr '\''((a && (b >= c)) || d) != e'\'' -a 1,1,2,0,0
0
$ test-expr '\''((a && (b >= c)) || d) != e'\'' -a 1,1,2,0,2
1
$ test-expr '\''((a && (b >= c)) || d) != e'\'' -a 1,1,2,1,2
1
$ test-expr '\''((a && (b >= c)) || d) != e'\'' -a 1,1,2,2,0
1
$ test-expr '\''((a && (b >= c)) || d) != e'\'' -a 1,2,1,0,2
1
$ test-expr '\''((a && (b >= c)) || d) != e'\'' -a 1,2,1,1,0
1
$ test-expr '\''((a && (b >= c)) || d) != e'\'' -a 1,2,1,2,0
1
$ test-expr '\''((a && (b >= c)) || d) != e'\'' -a 2,0,0,2,1
0
$ test-expr '\''((a && (b >= c)) || d) != e'\'' -a 2,0,1,2,1
0
$ test-expr '\''((a && (b >= c)) || d) != e'\'' -a 2,1,1,0,1
0
$ test-expr '\''((a && (b >= c)) || d) != e'\'' -a 2,1,2,0,0
0
$ test-expr '\''((a && (b >= c)) || d) != e'\'' -a 2,2,0,1,2
1
$ test-expr '\''((a && (b >= c)) || d) != e'\'' -a 2,2,0,2,1
0
$ test-expr '\''((a && (b >= c)) || d) != e'\'' -a 2,2,0,2,2
1
$ test-expr '\''((a && (b || c)) != d) >= e'\'' -a 0,0,0,2,0
1
$ test-expr '\''((a && (b || c)) != d) >= e'\'' -a 0,0,2,1,0
1
$ test-expr '\''((a && (b || c)) != d) >= e'\'' -a 0,1,1,1,2
0
$ test-expr '\''((a && (b || c)) != d) >= e'\'' -a 0,1,2,1,0
1
$ test-expr '\''((a && (b || c)) != d) >= e'\'' -a 0,2,1,2,0
1
$ test-expr '\''((a && (b || c)) != d) >= e'\'' -a 1,0,0,0,0
1
$ test-expr '\''((a && (b || c)) != d) >= e'\'' -a 1,0,1,0,0
1
$ test-expr '\''((a && (b || c)) != d) >= e'\'' -a 1,0,2,1,1
0
$ test-expr '\''((a && (b || c)) != d) >= e'\'' -a 1,1,0,2,0
1
$ test-expr '\''((a && (b || c)) != d) >= e'\'' -a 1,1,0,2,1
1
$ test-expr '\''((a && (b || c)) != d) >= e'\'' -a 1,1,1,0,1
1
$ test-expr '\''((a && (b || c)) != d) >= e'\'' -a 1,1,2,1,0
1
$ test-expr '\''((a && (b || c)) != d) >= e'\'' -a 1,2,2,2,2
0
$ test-expr '\''((a && (b || c)) != d) >= e'\'' -a 2,0,0,2,2
0
$ test-expr '\''((a && (b || c)) != d) >= e'\'' -a 2,0,1,2,1
1
$ test-expr '\''((a && (b || c)) != d) >= e'\'' -a 2,0,1,2,2
0
$ test-expr '\''((a && (b || c)) != d) >= e'\'' -a 2,0,2,0,1
1
$ test-expr '\''((a && (b || c)) != d) >= e'\'' -a 2,0,2,1,0
1
$ test-expr '\''((a && (b || c)) != d) >= e'\'' -a 2,1,0,1,0
1
$ test-expr '\''((a && (b || c)) != d) >= e'\'' -a 2,1,1,1,2
0
$ test-expr '\''((a && (b || c)) != d) >= e'\'' -a 2,2,0,0,1
1
$ test-expr '\''((a && (b || c)) != d) >= e'\'' -a 2,2,0,1,2
0
$ test-expr '\''((a && (b || c)) != d) >= e'\'' -a 2,2,0,2,0
1
$ test-expr '\''((a && (b || c)) != d) >= e'\'' -a 2,2,1,1,2
0
$ test-expr '\''((a && (b || c)) >= d) != e'\'' -a 0,0,0,0,1
0
$ test-expr '\''((a && (b || c)) >= d) != e'\'' -a 0,0,1,0,0
1
$ test-expr '\''((a && (b || c)) >= d) != e'\'' -a 0,0,1,0,1
0
$ test-expr '\''((a && (b || c)) >= d) != e'\'' -a 0,0,2,0,1
0
$ test-expr '\''((a && (b || c)) >= d) != e'\'' -a 0,1,1,0,0
1
$ test-expr '\''((a && (b || c)) >= d) != e'\'' -a 0,1,1,2,0
0
$ test-expr '\''((a && (b || c)) >= d) != e'\'' -a 0,2,2,1,1
1
$ test-expr '\''((a && (b || c)) >= d) != e'\'' -a 1,0,0,1,1
1
$ test-expr '\''((a && (b || c)) >= d) != e'\'' -a 1,0,0,1,2
1
$ test-expr '\''((a && (b || c)) >= d) != e'\'' -a 1,1,0,2,0
0
$ test-expr '\''((a && (b || c)) >= d) != e'\'' -a 1,1,1,2,0
0
$ test-expr '\''((a && (b || c)) >= d) != e'\'' -a 1,1,2,2,0
0
$ test-expr '\''((a && (b || c)) >= d) != e'\'' -a 1,2,1,1,0
1
$ test-expr '\''((a && (b || c)) >= d) != e'\'' -a 2,1,0,2,1
1
$ test-expr '\''((a && (b || c)) >= d) != e'\'' -a 2,1,0,2,2
1
$ test-expr '\''((a && (b || c)) >= d) != e'\'' -a 2,1,2,0,2
1
$ test-expr '\''((a && (b || c)) >= d) != e'\'' -a 2,1,2,1,2
1
$ test-expr '\''((a && (b || c)) >= d) != e'\'' -a 2,1,2,2,2
1
$ test-expr '\''((a && (b || c)) >= d) != e'\'' -a 2,2,1,1,1
0
$ test-expr '\''((a && (b || c)) >= d) != e'\'' -a 2,2,1,1,2
1
$ test-expr '\''((a && (b || c)) >= d) != e'\'' -a 2,2,1,2,0
0
$ test-expr '\''((a && (b || c)) >= d) != e'\'' -a 2,2,2,2,2
1
$ test-expr '\''((a >= b) != c) && (d || e)'\'' -a 0,0,1,1,0
0
$ test-expr '\''((a >= b) != c) && (d || e)'\'' -a 0,0,1,1,2
0
$ test-expr '\''((a >= b) != c) && (d || e)'\'' -a 0,0,1,2,0
0
$ test-expr '\''((a >= b) != c) && (d || e)'\'' -a 0,1,0,0,0
0
$ test-expr '\''((a >= b) != c) && (d || e)'\'' -a 0,1,0,1,1
0
$ test-expr '\''((a >= b) != c) && (d || e)'\'' -a 0,1,1,2,0
1
$ test-expr '\''((a >= b) != c) && (d || e)'\'' -a 0,1,2,2,1
1
$ test-expr '\''((a >= b) != c) && (d || e)'\'' -a 0,2,2,0,0
0
$ test-expr '\''((a >= b) != c) && (d || e)'\'' -a 0,2,2,2,0
1
$ test-expr '\''((a >= b) != c) && (d || e)'\'' -a 1,0,1,0,2
0
$ test-expr '\''((a >= b) != c) && (d || e)'\'' -a 1,0,1,2,0
0
$ test-expr '\''((a >= b) != c) && (d || e)'\'' -a 1,0,2,1,2
1
$ test-expr '\''((a >= b) != c) && (d || e)'\'' -a 1,1,0,0,0
0
$ test-expr '\''((a >= b) != c) && (d || e)'\'' -a 1,1,0,1,0
1
$ test-expr '\''((a >= b) != c) && (d || e)'\'' -a 1,1,2,0,0
0
$ test-expr '\''((a >= b) != c) && (d || e)'\'' -a 1,2,1,1,2
1
$ test-expr '\''((a >= b) != c) && (d || e)'\'' -a 2,0,0,0,0
0
$ test-expr '\''((a >= b) != c) && (d || e)'\'' -a 2,0,2,2,0
1
$ test-expr '\''((a >= b) != c) && (d || e)'\'' -a 2,1,0,1,1
1
$ test-expr '\''((a >= b) != c) && (d || e)'\'' -a 2,1,0,2,1
1
$ test-expr '\''((a >= b) != c) && (d || e)'\'' -a 2,1,1,2,0
0
$ test-expr '\''((a >= b) != c) && (d || e)'\'' -a 2,1,2,0,1
1
$ test-expr '\''((a >= b) != c) && (d || e)'\'' -a 2,2,0,2,1
1
$ test-expr '\''((a >= b) != c) || (d && e)'\'' -a 0,0,0,0,2
1
$ test-expr '\''((a >= b) != c) || (d && e)'\'' -a 0,0,2,1,1
1
$ test-expr '\''((a >= b) != c) || (d && e)'\'' -a 0,0,2,2,1
1
$ test-expr '\''((a >= b) != c) || (d && e)'\'' -a 0,1,0,0,1
0
$ test-expr '\''((a >= b) != c) || (d && e)'\'' -a 0,1,0,1,2
1
$ test-expr '\''((a >= b) != c) || (d && e)'\'' -a 0,1,2,1,1
1
$ test-expr '\''((a >= b) != c) || (d && e)'\'' -a 0,2,0,0,1
0
$ test-expr '\''((a >= b) != c) || (d && e)'\'' -a 0,2,0,2,1
1
$ test-expr '\''((a >= b) != c) || (d && e)'\'' -a 0,2,0,2,2
1
$ test-expr '\''((a >= b) != c) || (d && e)'\'' -a 0,2,2,1,0
1
$ test-expr '\''((a >= b) != c) || (d && e)'\'' -a 0,2,2,2,2
1
$ test-expr '\''((a >= b) != c) || (d && e)'\'' -a 1,0,0,1,2
1
$ test-expr '\''((a >= b) != c) || (d && e)'\'' -a 1,0,1,1,1
1
$ test-expr '\''((a >= b) != c) || (d && e)'\'' -a 1,0,2,0,2
1
$ test-expr '\''((a >= b) != c) || (d && e)'\'' -a 1,1,2,0,2
1
$ test-expr '\''((a >= b) != c) || (d && e)'\'' -a 1,1,2,2,2
1
$ test-expr '\''((a >= b) != c) || (d && e)'\'' -a 1,2,0,1,1
1
$ test-expr '\''((a >= b) != c) || (d && e)'\'' -a 1,2,1,0,1
1
$ test-expr '\''((a >= b) != c) || (d && e)'\'' -a 1,2,2,1,2
1
$ test-expr '\''((a >= b) != c) || (d && e)'\'' -a 2,0,0,2,0
1
$ test-expr '\''((a >= b) != c) || (d && e)'\'' -a 2,0,1,0,0
0
$ test-expr '\''((a >= b) != c) || (d && e)'\'' -a 2,0,2,0,0
1
$ test-expr '\''((a >= b) != c) || (d && e)'\'' -a 2,0,2,1,2
1
$ test-expr '\''((a >= b) != c) || (d && e)'\'' -a 2,0,2,2,0
1
$ test-expr '\''((a >= b) != c) || (d && e)'\'' -a 2,1,0,1,2
1
$ test-expr '\''((a >= b) != c) || (d && e)'\'' -a 2,1,1,1,0
0
$ test-expr '\''((a >= b) != c) || (d && e)'\'' -a 2,1,2,0,0
1
$ test-expr '\''((a >= b) != c) || (d && e)'\'' -a 2,2,0,1,0
1
$ test-expr '\''((a >= b) != c) || (d && e)'\'' -a 2,2,1,0,2
0
$ test-expr '\''((a >= b) != c) || (d && e)'\'' -a 2,2,1,2,0
0
$ test-expr '\''((a >= b) != (c && d)) || e'\'' -a 0,0,0,1,1
1
$ test-expr '\''((a >= b) != (c && d)) || e'\'' -a 0,0,0,1,2
1
$ test-expr '\''((a >= b) != (c && d)) || e'\'' -a 0,0,2,2,2
1
$ test-expr '\''((a >= b) != (c && d)) || e'\'' -a 0,1,1,1,1
1
$ test-expr '\''((a >= b) != (c && d)) || e'\'' -a 0,2,2,0,2
1
$ test-expr '\''((a >= b) != (c && d)) || e'\'' -a 1,0,0,1,0
1
$ test-expr '\''((a >= b) != (c && d)) || e'\'' -a 1,0,0,2,1
1
$ test-expr '\''((a >= b) != (c && d)) || e'\'' -a 1,0,1,0,1
1
$ test-expr '\''((a >= b) != (c && d)) || e'\'' -a 1,1,0,2,1
1
$ test-expr '\''((a >= b) != (c && d)) || e'\'' -a 1,1,1,1,0
0
$ test-expr '\''((a >= b) != (c && d)) || e'\'' -a 1,2,0,0,0
0
$ test-expr '\''((a >= b) != (c && d)) || e'\'' -a 1,2,2,0,2
1
$ test-expr '\''((a >= b) != (c && d)) || e'\'' -a 1,2,2,2,2
1
$ test-expr '\''((a >= b) != (c && d)) || e'\'' -a 2,0,0,0,1
1
$ test-expr '\''((a >= b) != (c && d)) || e'\'' -a 2,0,0,1,1
1
$ test-expr '\''((a >= b) != (c && d)) || e'\'' -a 2,0,0,2,1
1
$ test-expr '\''((a >= b) != (c && d)) || e'\'' -a 2,0,1,1,2
1
$ test-expr '\''((a >= b) != (c && d)) || e'\'' -a 2,0,2,2,0
0
$ test-expr '\''((a >= b) != (c && d)) || e'\'' -a 2,1,0,1,1
1
$ test-expr '\''((a >= b) != (c && d)) || e'\'' -a 2,1,1,2,1
1
$ test-expr '\''((a >= b) != (c && d)) || e'\'' -a 2,1,1,2,2
1
$ test-expr '\''((a >= b) != (c && d)) || e'\'' -a 2,2,0,0,2
1
$ test-expr '\''((a >= b) != (c && d)) || e'\'' -a 2,2,0,1,1
1
$ test-expr '\''((a >= b) != (c && d)) || e'\'' -a 2,2,2,0,1
1
$ test-expr '\''((a >= b) != (c || d)) && e'\'' -a 0,0,0,0,2
1
$ test-expr '\''((a >= b) != (c || d)) && e'\'' -a 0,0,2,1,1
0
$ test-expr '\''((a >= b) != (c || d)) && e'\'' -a 0,0,2,1,2
0
$ test-expr '\''((a >= b) != (c || d)) && e'\'' -a 0,1,1,1,0
0
$ test-expr '\''((a >= b) != (c || d)) && e'\'' -a 0,1,2,2,0
0
$ test-expr '\''((a >= b) != (c || d)) && e'\'' -a 0,1,2,2,1
1
$ test-expr '\''((a >= b) != (c || d)) && e'\'' -a 0,2,0,1,0
0
$ test-expr '\''((a >= b) != (c || d)) && e'\'' -a 0,2,1,2,0
0
$ test-expr '\''((a >= b) != (c || d)) && e'\'' -a 0,2,1,2,2
1
$ test-expr '\''((a >= b) != (c || d)) && e'\'' -a 1,0,0,0,2
1
$ test-expr '\''((a >= b) != (c || d)) && e'\'' -a 1,0,0,2,0
0
$ test-expr '\''((a >= b) != (c || d)) && e'\'' -a 1,0,2,0,1
0
$ test-expr '\''((a >= b) != (c || d)) && e'\'' -a 1,0,2,0,2
0
$ test-expr '\''((a >= b) != (c || d)) && e'\'' -a 1,0,2,1,0
0
$ test-expr '\''((a >= b) != (c || d)) && e'\'' -a 1,1,2,0,2
0
$ test-expr '\''((a >= b) != (c || d)) && e'\'' -a 1,2,0,0,0
0
$ test-expr '\''((a >= b) != (c || d)) && e'\'' -a 1,2,0,1,1
1
$ test-expr '\''((a >= b) != (c || d)) && e'\'' -a 1,2,0,2,0
0
$ test-expr '\''((a >= b) != (c || d)) && e'\'' -a 1,2,2,1,0
0
$ test-expr '\''((a >= b) != (c || d)) && e'\'' -a 1,2,2,1,1
1
$ test-expr '\''((a >= b) != (c || d)) && e'\'' -a 2,0,0,0,0
0
$ test-expr '\''((a >= b) != (c || d)) && e'\'' -a 2,0,0,1,0
0
$ test-expr '\''((a >= b) != (c || d)) && e'\'' -a 2,0,2,1,0
0
$ test-expr '\''((a >= b) != (c || d)) && e'\'' -a 2,0,2,2,2
0
$ test-expr '\''((a >= b) != (c || d)) && e'\'' -a 2,1,0,1,2
0
$ test-expr '\''((a >= b) != (c || d)) && e'\'' -a 2,1,2,0,1
0
$ test-expr '\''((a >= b) != (c || d)) && e'\'' -a 2,2,0,2,1
0
$ test-expr '\''((a >= b) != (c || d)) && e'\'' -a 2,2,1,0,1
0
$ test-expr '\''((a >= b) != (c || d)) && e'\'' -a 2,2,2,1,2
0
$ test-expr '\''((a >= b) && c) != (d || e)'\'' -a 0,0,0,0,0
0
$ test-expr '\''((a >= b) && c) != (d || e)'\'' -a 0,1,1,0,0
0
$ test-expr '\''((a >= b) && c) != (d || e)'\'' -a 0,1,1,0,1
1
$ test-expr '\''((a >= b) && c) != (d || e)'\'' -a 0,1,1,1,0
1
$ test-expr '\''((a >= b) && c) != (d || e)'\'' -a 0,2,0,0,1
1
$ test-expr '\''((a >= b) && c) != (d || e)'\'' -a 0,2,0,1,1
1
$ test-expr '\''((a >= b) && c) != (d || e)'\'' -a 0,2,1,2,0
1
$ test-expr '\''((a >= b) && c) != (d || e)'\'' -a 0,2,2,0,0
0
$ test-expr '\''((a >= b) && c) != (d || e)'\'' -a 1,0,0,1,1
1
$ test-expr '\''((a >= b) && c) != (d || e)'\'' -a 1,0,0,2,0
1
$ test-expr '\''((a >= b) && c) != (d || e)'\'' -a 1,0,0,2,1
1
$ test-expr '\''((a >= b) && c) != (d || e)'\'' -a 1,0,1,2,0
0
$ test-expr '\''((a >= b) && c) != (d || e)'\'' -a 1,0,2,1,0
0
$ test-expr '\''((a >= b) && c) != (d || e)'\'' -a 1,1,0,0,2
1
$ test-expr '\''((a >= b) && c) != (d || e)'\'' -a 1,1,1,0,0
1
$ test-expr '\''((a >= b) && c) != (d || e)'\'' -a 1,1,1,1,1
0
$ test-expr '\''((a >= b) && c) != (d || e)'\'' -a 1,1,1,2,0
0
$ test-expr '\''((a >= b) && c) != (d || e)'\'' -a 1,1,2,0,0
1
$ test-expr '\''((a >= b) && c) != (d || e)'\'' -a 1,2,0,0,1
1
$ test-expr '\''((a >= b) && c) != (d || e)'\'' -a 1,2,0,0,2
1
$ test-expr '\''((a >= b) && c) != (d || e)'\'' -a 1,2,2,1,0
1
$ test-expr '\''((a >= b) && c) != (d || e)'\'' -a 1,2,2,2,2
1
$ test-expr '\''((a >= b) && c) != (d || e)'\'' -a 2,0,0,2,1
1
$ test-expr '\''((a >= b) && c) != (d || e)'\'' -a 2,0,1,0,0
1
$ test-expr '\''((a >= b) && c) != (d || e)'\'' -a 2,0,1,1,0
0
$ test-expr '\''((a >= b) && c) != (d || e)'\'' -a 2,1,0,1,0
1
$ test-expr '\''((a >= b) && c) != (d || e)'\'' -a 2,1,0,2,2
1
$ test-expr '\''((a >= b) && c) != (d || e)'\'' -a 2,1,1,0,2
0
$ test-expr '\''((a >= b) && c) != (d || e)'\'' -a 2,1,1,1,1
0
$ test-expr '\''((a >= b) && c) != (d || e)'\'' -a 2,1,1,2,1
0
$ test-expr '\''((a >= b) && c) != (d || e)'\'' -a 2,1,2,1,1
0
$ test-expr '\''((a >= b) && c) != (d || e)'\'' -a 2,2,1,2,0
0
$ test-expr '\''((a >= b) && c) != (d || e)'\'' -a 2,2,1,2,1
0
$ test-expr '\''((a >= b) && c) != (d || e)'\'' -a 2,2,2,0,2
0
$ test-expr '\''((a >= b) && c) || (d != e)'\'' -a 0,0,0,1,1
0
$ test-expr '\''((a >= b) && c) || (d != e)'\'' -a 0,0,1,2,1
1
$ test-expr '\''((a >= b) && c) || (d != e)'\'' -a 0,0,2,1,0
1
$ test-expr '\''((a >= b) && c) || (d != e)'\'' -a 0,1,1,2,0
1
$ test-expr '\''((a >= b) && c) || (d != e)'\'' -a 0,1,2,0,0
0
$ test-expr '\''((a >= b) && c) || (d != e)'\'' -a 0,1,2,0,1
1
$ test-expr '\''((a >= b) && c) || (d != e)'\'' -a 0,1,2,2,1
1
$ test-expr '\''((a >= b) && c) || (d != e)'\'' -a 0,2,1,2,1
1
$ test-expr '\''((a >= b) && c) || (d != e)'\'' -a 1,0,1,1,0
1
$ test-expr '\''((a >= b) && c) || (d != e)'\'' -a 1,0,1,1,2
1
$ test-expr '\''((a >= b) && c) || (d != e)'\'' -a 1,0,2,1,2
1
$ test-expr '\''((a >= b) && c) || (d != e)'\'' -a 1,0,2,2,0
1
$ test-expr '\''((a >= b) && c) || (d != e)'\'' -a 1,1,0,2,0
1
$ test-expr '\''((a >= b) && c) || (d != e)'\'' -a 1,1,1,1,0
1
$ test-expr '\''((a >= b) && c) || (d != e)'\'' -a 1,1,1,1,2
1
$ test-expr '\''((a >= b) && c) || (d != e)'\'' -a 1,1,2,0,1
1
$ test-expr '\''((a >= b) && c) || (d != e)'\'' -a 1,2,0,0,0
0
$ test-expr '\''((a >= b) && c) || (d != e)'\'' -a 1,2,0,2,2
0
$ test-expr '\''((a >= b) && c) || (d != e)'\'' -a 1,2,1,0,0
0
$ test-expr '\''((a >= b) && c) || (d != e)'\'' -a 1,2,1,1,0
1
$ test-expr '\''((a >= b) && c) || (d != e)'\'' -a 1,2,2,0,0
0
$ test-expr '\''((a >= b) && c) || (d != e)'\'' -a 1,2,2,1,2
1
$ test-expr '\''((a >= b) && c) || (d != e)'\'' -a 2,0,1,1,0
1
$ test-expr '\''((a >= b) && c) || (d != e)'\'' -a 2,0,1,1,1
1
$ test-expr '\''((a >= b) && c) || (d != e)'\'' -a 2,0,1,2,1
1
$ test-expr '\''((a >= b) && c) || (d != e)'\'' -a 2,0,2,2,1
1
$ test-expr '\''((a >= b) && c) || (d != e)'\'' -a 2,1,0,2,0
1
$ test-expr '\''((a >= b) && c) || (d != e)'\'' -a 2,1,2,0,1
1
$ test-expr '\''((a >= b) && c) || (d != e)'\'' -a 2,1,2,2,0
1
$ test-expr '\''((a >= b) && c) || (d != e)'\'' -a 2,2,2,2,2
1
$ test-expr '\''((a >= b) && (c != d)) || e'\'' -a 0,0,0,1,2
1
$ test-expr '\''((a >= b) && (c != d)) || e'\'' -a 0,0,0,2,1
1
$ test-expr '\''((a >= b) && (c != d)) || e'\'' -a 0,0,1,2,0
1
$ test-expr '\''((a >= b) && (c != d)) || e'\'' -a 0,0,1,2,1
1
$ test-expr '\''((a >= b) && (c != d)) || e'\'' -a 0,0,2,2,2
1
$ test-expr '\''((a >= b) && (c != d)) || e'\'' -a 0,1,0,1,2
1
$ test-expr '\''((a >= b) && (c != d)) || e'\'' -a 0,1,1,0,1
1
$ test-expr '\''((a >= b) && (c != d)) || e'\'' -a 0,2,0,0,1
1
$ test-expr '\''((a >= b) && (c != d)) || e'\'' -a 0,2,0,1,1
1
$ test-expr '\''((a >= b) && (c != d)) || e'\'' -a 0,2,0,1,2
1
$ test-expr '\''((a >= b) && (c != d)) || e'\'' -a 1,0,0,2,0
1
$ test-expr '\''((a >= b) && (c != d)) || e'\'' -a 1,0,2,0,1
1
$ test-expr '\''((a >= b) && (c != d)) || e'\'' -a 1,0,2,2,0
0
$ test-expr '\''((a >= b) && (c != d)) || e'\'' -a 1,1,1,1,2
1
$ test-expr '\''((a >= b) && (c != d)) || e'\'' -a 1,1,2,2,1
1
$ test-expr '\''((a >= b) && (c != d)) || e'\'' -a 1,2,0,2,0
0
$ test-expr '\''((a >= b) && (c != d)) || e'\'' -a 1,2,1,0,0
0
$ test-expr '\''((a >= b) && (c != d)) || e'\'' -a 1,2,1,2,1
1
$ test-expr '\''((a >= b) && (c != d)) || e'\'' -a 1,2,2,0,2
1
$ test-expr '\''((a >= b) && (c != d)) || e'\'' -a 1,2,2,1,0
0
$ test-expr '\''((a >= b) && (c != d)) || e'\'' -a 1,2,2,1,1
1
$ test-expr '\''((a >= b) && (c != d)) || e'\'' -a 2,0,1,0,1
1
$ test-expr '\''((a >= b) && (c != d)) || e'\'' -a 2,0,1,1,2
1
$ test-expr '\''((a >= b) && (c != d)) || e'\'' -a 2,0,1,2,1
1
$ test-expr '\''((a >= b) && (c != d)) || e'\'' -a 2,0,2,2,0
0
$ test-expr '\''((a >= b) && (c != d)) || e'\'' -a 2,0,2,2,1
1
$ test-expr '\''((a >= b) && (c != d)) || e'\'' -a 2,1,0,0,0
0
$ test-expr '\''((a >= b) && (c != d)) || e'\'' -a 2,1,1,1,2
1
$ test-expr '\''((a >= b) && (c != d)) || e'\'' -a 2,1,2,1,1
1
$ test-expr '\''((a >= b) && (c != d)) || e'\'' -a 2,1,2,2,0
0
$ test-expr '\''((a >= b) && (c != d)) || e'\'' -a 2,2,0,0,2
1
$ test-expr '\''((a >= b) && (c != d)) || e'\'' -a 2,2,0,1,0
1
$ test-expr '\''((a >= b) && (c != d)) || e'\'' -a 2,2,1,0,1
1
$ test-expr '\''((a >= b) && (c != d)) || e'\'' -a 2,2,1,0,2
1
$ test-expr '\''((a >= b) && (c != d)) || e'\'' -a 2,2,1,2,2
1
$ test-expr '\''((a >= b) && (c != d)) || e'\'' -a 2,2,2,2,2
1
$ test-expr '\''((a >= b) && (c || d)) != e'\'' -a 0,0,1,0,0
1
$ test-expr '\''((a >= b) && (c || d)) != e'\'' -a 0,0,1,2,0
1
$ test-expr '\''((a >= b) && (c || d)) != e'\'' -a 0,0,2,2,0
1
$ test-expr '\''((a >= b) && (c || d)) != e'\'' -a 0,1,0,2,0
0
$ test-expr '\''((a >= b) && (c || d)) != e'\'' -a 0,1,1,0,1
1
$ test-expr '\''((a >= b) && (c || d)) != e'\'' -a 0,1,1,2,0
0
$ test-expr '\''((a >= b) && (c || d)) != e'\'' -a 0,1,2,1,1
1
$ test-expr '\''((a >= b) && (c || d)) != e'\'' -a 0,1,2,1,2
1
$ test-expr '\''((a >= b) && (c || d)) != e'\'' -a 0,2,1,2,2
1
$ test-expr '\''((a >= b) && (c || d)) != e'\'' -a 1,1,0,1,0
1
$ test-expr '\''((a >= b) && (c || d)) != e'\'' -a 1,1,0,1,1
0
$ test-expr '\''((a >= b) && (c || d)) != e'\'' -a 1,1,1,0,1
0
$ test-expr '\''((a >= b) && (c || d)) != e'\'' -a 1,1,1,0,2
1
$ test-expr '\''((a >= b) && (c || d)) != e'\'' -a 1,1,1,1,2
1
$ test-expr '\''((a >= b) && (c || d)) != e'\'' -a 1,1,2,1,1
0
$ test-expr '\''((a >= b) && (c || d)) != e'\'' -a 1,1,2,2,2
1
$ test-expr '\''((a >= b) && (c || d)) != e'\'' -a 1,2,0,1,1
1
$ test-expr '\''((a >= b) && (c || d)) != e'\'' -a 1,2,0,2,2
1
$ test-expr '\''((a >= b) && (c || d)) != e'\'' -a 1,2,1,1,2
1
$ test-expr '\''((a >= b) && (c || d)) != e'\'' -a 1,2,2,0,0
0
$ test-expr '\''((a >= b) && (c || d)) != e'\'' -a 2,0,0,2,0
1
$ test-expr '\''((a >= b) && (c || d)) != e'\'' -a 2,0,1,1,0
1
$ test-expr '\''((a >= b) && (c || d)) != e'\'' -a 2,0,1,1,1
0
$ test-expr '\''((a >= b) && (c || d)) != e'\'' -a 2,1,1,0,2
1
$ test-expr '\''((a >= b) && (c || d)) != e'\'' -a 2,1,1,1,0
1
$ test-expr '\''((a >= b) && (c || d)) != e'\'' -a 2,1,2,0,1
0
$ test-expr '\''((a >= b) && (c || d)) != e'\'' -a 2,1,2,2,0
1
$ test-expr '\''((a >= b) && (c || d)) != e'\'' -a 2,2,0,1,1
0
$ test-expr '\''((a >= b) && (c || d)) != e'\'' -a 2,2,0,2,1
0
$ test-expr '\''((a >= b) && (c || d)) != e'\'' -a 2,2,0,2,2
1
$ test-expr '\''((a >= b) && (c || d)) != e'\'' -a 2,2,1,0,1
0
$ test-expr '\''((a >= b) && (c || d)) != e'\'' -a 2,2,2,0,0
1
$ test-expr '\''((a >= b) && (c || d)) != e'\'' -a 2,2,2,2,2
1
$ test-expr '\''((a >= b) || c) != (d && e)'\'' -a 0,0,0,0,0
1
$ test-expr '\''((a >= b) || c) != (d && e)'\'' -a 0,0,0,0,2
1
$ test-expr '\''((a >= b) || c) != (d && e)'\'' -a 0,0,0,1,0
1
$ test-expr '\''((a >= b) || c) != (d && e)'\'' -a 0,0,0,2,0
1
$ test-expr '\''((a >= b) || c) != (d && e)'\'' -a 0,0,1,1,1
0
$ test-expr '\''((a >= b) || c) != (d && e)'\'' -a 0,2,1,0,2
1
$ test-expr '\''((a >= b) || c) != (d && e)'\'' -a 0,2,1,1,1
0
$ test-expr '\''((a >= b) || c) != (d && e)'\'' -a 0,2,2,0,1
1
$ test-expr '\''((a >= b) || c) != (d && e)'\'' -a 0,2,2,2,0
1
$ test-expr '\''((a >= b) || c) != (d && e)'\'' -a 0,2,2,2,1
0
$ test-expr '\''((a >= b) || c) != (d && e)'\'' -a 0,2,2,2,2
0
$ test-expr '\''((a >= b) || c) != (d && e)'\'' -a 1,0,1,1,1
0
$ test-expr '\''((a >= b) || c) != (d && e)'\'' -a 1,0,2,0,0
1
$ test-expr '\''((a >= b) || c) != (d && e)'\'' -a 1,0,2,0,2
1
$ test-expr '\''((a >= b) || c) != (d && e)'\'' -a 1,0,2,1,0
1
$ test-expr '\''((a >= b) || c) != (d && e)'\'' -a 1,1,0,1,0
1
$ test-expr '\''((a >= b) || c) != (d && e)'\'' -a 1,1,2,0,1
1
$ test-expr '\''((a >= b) || c) != (d && e)'\'' -a 1,1,2,1,1
0
$ test-expr '\''((a >= b) || c) != (d && e)'\'' -a 1,2,0,2,2
1
$ test-expr '\''((a >= b) || c) != (d && e)'\'' -a 1,2,1,0,2
1
$ test-expr '\''((a >= b) || c) != (d && e)'\'' -a 1,2,2,0,0
1
$ test-expr '\''((a >= b) || c) != (d && e)'\'' -a 1,2,2,1,0
1
$ test-expr '\''((a >= b) || c) != (d && e)'\'' -a 2,0,0,2,0
1
$ test-expr '\''((a >= b) || c) != (d && e)'\'' -a 2,0,1,0,1
1
$ test-expr '\''((a >= b) || c) != (d && e)'\'' -a 2,0,2,1,1
0
$ test-expr '\''((a >= b) || c) != (d && e)'\'' -a 2,0,2,1,2
0
$ test-expr '\''((a >= b) || c) != (d && e)'\'' -a 2,1,0,0,1
1
$ test-expr '\''((a >= b) || c) != (d && e)'\'' -a 2,1,0,2,0
1
$ test-expr '\''((a >= b) || c) != (d && e)'\'' -a 2,1,2,1,0
1
$ test-expr '\''((a >= b) || c) != (d && e)'\'' -a 2,2,1,0,1
1
$ test-expr '\''((a >= b) || c) != (d && e)'\'' -a 2,2,1,2,0
1
$ test-expr '\''((a >= b) || c) != (d && e)'\'' -a 2,2,2,1,1
0
$ test-expr '\''((a >= b) || c) && (d != e)'\'' -a 0,0,0,0,1
1
$ test-expr '\''((a >= b) || c) && (d != e)'\'' -a 0,0,1,1,1
0
$ test-expr '\''((a >= b) || c) && (d != e)'\'' -a 0,1,1,0,1
1
$ test-expr '\''((a >= b) || c) && (d != e)'\'' -a 0,1,1,0,2
1
$ test-expr '\''((a >= b) || c) && (d != e)'\'' -a 0,2,2,2,2
0
$ test-expr '\''((a >= b) || c) && (d != e)'\'' -a 1,0,2,1,1
0
$ test-expr '\''((a >= b) || c) && (d != e)'\'' -a 1,1,0,0,2
1
$ test-expr '\''((a >= b) || c) && (d != e)'\'' -a 1,1,1,2,1
1
$ test-expr '\''((a >= b) || c) && (d != e)'\'' -a 1,2,0,2,1
0
$ test-expr '\''((a >= b) || c) && (d != e)'\'' -a 1,2,1,2,0
1
$ test-expr '\''((a >= b) || c) && (d != e)'\'' -a 2,0,0,1,1
0
$ test-expr '\''((a >= b) || c) && (d != e)'\'' -a 2,0,2,0,1
1
$ test-expr '\''((a >= b) || c) && (d != e)'\'' -a 2,1,1,2,1
1
$ test-expr '\''((a >= b) || c) && (d != e)'\'' -a 2,1,2,0,2
1
$ test-expr '\''((a >= b) || c) && (d != e)'\'' -a 2,1,2,1,0
1
$ test-expr '\''((a >= b) || c) && (d != e)'\'' -a 2,2,1,1,1
0
$ test-expr '\''((a >= b) || c) && (d != e)'\'' -a 2,2,1,2,0
1
$ test-expr '\''((a >= b) || c) && (d != e)'\'' -a 2,2,2,2,2
0
$ test-expr '\''((a >= b) || (c != d)) && e'\'' -a 0,0,0,0,2
1
$ test-expr '\''((a >= b) || (c != d)) && e'\'' -a 0,0,2,2,0
0
$ test-expr '\''((a >= b) || (c != d)) && e'\'' -a 0,1,1,1,1
0
$ test-expr '\''((a >= b) || (c != d)) && e'\'' -a 0,1,2,2,2
0
$ test-expr '\''((a >= b) || (c != d)) && e'\'' -a 0,2,0,0,1
0
$ test-expr '\''((a >= b) || (c != d)) && e'\'' -a 0,2,0,2,1
1
$ test-expr '\''((a >= b) || (c != d)) && e'\'' -a 0,2,1,0,0
0
$ test-expr '\''((a >= b) || (c != d)) && e'\'' -a 1,0,1,0,2
1
$ test-expr '\''((a >= b) || (c != d)) && e'\'' -a 1,0,2,1,2
1
$ test-expr '\''((a >= b) || (c != d)) && e'\'' -a 1,0,2,2,1
1
$ test-expr '\''((a >= b) || (c != d)) && e'\'' -a 1,1,0,1,0
0
$ test-expr '\''((a >= b) || (c != d)) && e'\'' -a 1,1,0,2,1
1
$ test-expr '\''((a >= b) || (c != d)) && e'\'' -a 1,1,1,0,1
1
$ test-expr '\''((a >= b) || (c != d)) && e'\'' -a 1,1,1,1,1
1
$ test-expr '\''((a >= b) || (c != d)) && e'\'' -a 1,1,1,2,0
0
$ test-expr '\''((a >= b) || (c != d)) && e'\'' -a 1,2,2,0,0
0
$ test-expr '\''((a >= b) || (c != d)) && e'\'' -a 1,2,2,1,1
1
$ test-expr '\''((a >= b) || (c != d)) && e'\'' -a 1,2,2,2,2
0
$ test-expr '\''((a >= b) || (c != d)) && e'\'' -a 2,0,0,0,0
0
$ test-expr '\''((a >= b) || (c != d)) && e'\'' -a 2,0,0,1,0
0
$ test-expr '\''((a >= b) || (c != d)) && e'\'' -a 2,0,0,2,1
1
$ test-expr '\''((a >= b) || (c != d)) && e'\'' -a 2,0,2,2,1
1
$ test-expr '\''((a >= b) || (c != d)) && e'\'' -a 2,1,0,0,0
0
$ test-expr '\''((a >= b) || (c != d)) && e'\'' -a 2,2,0,0,1
1
$ test-expr '\''((a >= b) || (c != d)) && e'\'' -a 2,2,0,1,0
0
$ test-expr '\''((a >= b) || (c != d)) && e'\'' -a 2,2,0,1,2
1
$ test-expr '\''((a >= b) || (c != d)) && e'\'' -a 2,2,1,2,1
1
$ test-expr '\''((a >= b) || (c != d)) && e'\'' -a 2,2,2,1,1
1
$ test-expr '\''((a >= b) || (c != d)) && e'\'' -a 2,2,2,1,2
1
$ test-expr '\''((a >= b) || (c && d)) != e'\'' -a 0,0,0,2,2
1
$ test-expr '\''((a >= b) || (c && d)) != e'\'' -a 0,0,1,0,2
1
$ test-expr '\''((a >= b) || (c && d)) != e'\'' -a 0,0,2,0,2
1
$ test-expr '\''((a >= b) || (c && d)) != e'\'' -a 0,0,2,2,0
1
$ test-expr '\''((a >= b) || (c && d)) != e'\'' -a 0,1,0,1,1
1
$ test-expr '\''((a >= b) || (c && d)) != e'\'' -a 0,1,0,2,0
0
$ test-expr '\''((a >= b) || (c && d)) != e'\'' -a 0,1,0,2,2
1
$ test-expr '\''((a >= b) || (c && d)) != e'\'' -a 0,2,0,1,0
0
$ test-expr '\''((a >= b) || (c && d)) != e'\'' -a 0,2,0,1,2
1
$ test-expr '\''((a >= b) || (c && d)) != e'\'' -a 0,2,1,1,2
1
$ test-expr '\''((a >= b) || (c && d)) != e'\'' -a 0,2,2,1,0
1
$ test-expr '\''((a >= b) || (c && d)) != e'\'' -a 1,0,1,0,1
0
$ test-expr '\''((a >= b) || (c && d)) != e'\'' -a 1,0,1,1,0
1
$ test-expr '\''((a >= b) || (c && d)) != e'\'' -a 1,0,1,1,2
1
$ test-expr '\''((a >= b) || (c && d)) != e'\'' -a 1,0,1,2,0
1
$ test-expr '\''((a >= b) || (c && d)) != e'\'' -a 1,2,0,0,0
0
$ test-expr '\''((a >= b) || (c && d)) != e'\'' -a 2,0,0,2,2
1
$ test-expr '\''((a >= b) || (c && d)) != e'\'' -a 2,0,1,0,2
1
$ test-expr '\''((a >= b) || (c && d)) != e'\'' -a 2,0,2,0,0
1
$ test-expr '\''((a >= b) || (c && d)) != e'\'' -a 2,1,0,0,1
0
$ test-expr '\''((a >= b) || (c && d)) != e'\'' -a 2,1,1,2,2
1
$ test-expr '\''((a >= b) || (c && d)) != e'\'' -a 2,1,2,0,2
1
$ test-expr '\''((a >= b) || (c && d)) != e'\'' -a 2,1,2,2,2
1
$ test-expr '\''((a >= b) || (c && d)) != e'\'' -a 2,2,0,1,2
1
$ test-expr '\''((a >= b) || (c && d)) != e'\'' -a 2,2,2,1,0
1
$ test-expr '\''((a >= (b != c)) && d) || e'\'' -a 0,1,1,0,2
1
$ test-expr '\''((a >= (b != c)) && d) || e'\'' -a 0,2,2,0,1
1
$ test-expr '\''((a >= (b != c)) && d) || e'\'' -a 1,0,0,2,1
1
$ test-expr '\''((a >= (b != c)) && d) || e'\'' -a 1,0,1,0,1
1
$ test-expr '\''((a >= (b != c)) && d) || e'\'' -a 1,0,2,0,2
1
$ test-expr '\''((a >= (b != c)) && d) || e'\'' -a 1,1,0,1,2
1
$ test-expr '\''((a >= (b != c)) && d) || e'\'' -a 1,1,1,0,1
1
$ test-expr '\''((a >= (b != c)) && d) || e'\'' -a 1,1,2,0,0
0
$ test-expr '\''((a >= (b != c)) && d) || e'\'' -a 1,2,1,1,0
1
$ test-expr '\''((a >= (b != c)) && d) || e'\'' -a 1,2,2,0,2
1
$ test-expr '\''((a >= (b != c)) && d) || e'\'' -a 2,0,0,1,1
1
$ test-expr '\''((a >= (b != c)) && d) || e'\'' -a 2,0,2,2,1
1
$ test-expr '\''((a >= (b != c)) && d) || e'\'' -a 2,1,2,0,1
1
$ test-expr '\''((a >= (b != c)) && d) || e'\'' -a 2,1,2,2,2
1
$ test-expr '\''((a >= (b != c)) && d) || e'\'' -a 2,2,0,0,1
1
$ test-expr '\''((a >= (b != c)) && d) || e'\'' -a 2,2,0,1,1
1
$ test-expr '\''((a >= (b != c)) && d) || e'\'' -a 2,2,1,0,2
1
$ test-expr '\''((a >= (b != c)) && d) || e'\'' -a 2,2,1,1,1
1
$ test-expr '\''((a >= (b != c)) && d) || e'\'' -a 2,2,2,0,1
1
$ test-expr '\''((a >= (b != c)) && d) || e'\'' -a 2,2,2,1,2
1
$ test-expr '\''((a >= (b != c)) || d) && e'\'' -a 0,0,0,0,2
1
$ test-expr '\''((a >= (b != c)) || d) && e'\'' -a 0,0,0,1,2
1
$ test-expr '\''((a >= (b != c)) || d) && e'\'' -a 0,0,2,0,1
0
$ test-expr '\''((a >= (b != c)) || d) && e'\'' -a 0,1,1,0,2
1
$ test-expr '\''((a >= (b != c)) || d) && e'\'' -a 0,1,2,0,2
0
$ test-expr '\''((a >= (b != c)) || d) && e'\'' -a 0,2,0,0,1
0
$ test-expr '\''((a >= (b != c)) || d) && e'\'' -a 0,2,1,0,1
0
$ test-expr '\''((a >= (b != c)) || d) && e'\'' -a 0,2,2,1,0
0
$ test-expr '\''((a >= (b != c)) || d) && e'\'' -a 0,2,2,2,2
1
$ test-expr '\''((a >= (b != c)) || d) && e'\'' -a 1,0,0,2,0
0
$ test-expr '\''((a >= (b != c)) || d) && e'\'' -a 1,0,2,1,0
0
$ test-expr '\''((a >= (b != c)) || d) && e'\'' -a 1,1,0,0,0
0
$ test-expr '\''((a >= (b != c)) || d) && e'\'' -a 1,1,0,2,1
1
$ test-expr '\''((a >= (b != c)) || d) && e'\'' -a 1,2,1,1,1
1
$ test-expr '\''((a >= (b != c)) || d) && e'\'' -a 1,2,2,1,0
0
$ test-expr '\''((a >= (b != c)) || d) && e'\'' -a 1,2,2,2,2
1
$ test-expr '\''((a >= (b != c)) || d) && e'\'' -a 2,0,0,0,1
1
$ test-expr '\''((a >= (b != c)) || d) && e'\'' -a 2,0,1,0,1
1
$ test-expr '\''((a >= (b != c)) || d) && e'\'' -a 2,0,2,0,1
1
$ test-expr '\''((a >= (b != c)) || d) && e'\'' -a 2,0,2,1,0
0
$ test-expr '\''((a >= (b != c)) || d) && e'\'' -a 2,1,0,1,2
1
$ test-expr '\''((a >= (b != c)) || d) && e'\'' -a 2,1,0,2,1
1
$ test-expr '\''((a >= (b != c)) || d) && e'\'' -a 2,1,1,2,0
0
$ test-expr '\''((a >= (b != c)) || d) && e'\'' -a 2,1,2,1,0
0
$ test-expr '\''((a >= (b != c)) || d) && e'\'' -a 2,2,0,2,1
1
$ test-expr '\''((a >= (b != c)) || d) && e'\'' -a 2,2,1,2,0
0
$ test-expr '\''((a >= (b && c)) != d) || e'\'' -a 0,0,0,0,1
1
$ test-expr '\''((a >= (b && c)) != d) || e'\'' -a 0,0,0,1,2
1
$ test-expr '\''((a >= (b && c)) != d) || e'\'' -a 0,1,1,1,0
1
$ test-expr '\''((a >= (b && c)) != d) || e'\'' -a 0,2,0,0,2
1
$ test-expr '\''((a >= (b && c)) != d) || e'\'' -a 0,2,1,0,0
0
$ test-expr '\''((a >= (b && c)) != d) || e'\'' -a 0,2,1,2,0
1
$ test-expr '\''((a >= (b && c)) != d) || e'\'' -a 0,2,2,0,2
1
$ test-expr '\''((a >= (b && c)) != d) || e'\'' -a 0,2,2,2,2
1
$ test-expr '\''((a >= (b && c)) != d) || e'\'' -a 1,0,1,0,1
1
$ test-expr '\''((a >= (b && c)) != d) || e'\'' -a 1,0,2,2,1
1
$ test-expr '\''((a >= (b && c)) != d) || e'\'' -a 1,1,0,1,1
1
$ test-expr '\''((a >= (b && c)) != d) || e'\'' -a 1,1,0,1,2
1
$ test-expr '\''((a >= (b && c)) != d) || e'\'' -a 1,1,1,0,0
1
$ test-expr '\''((a >= (b && c)) != d) || e'\'' -a 1,2,0,2,0
1
$ test-expr '\''((a >= (b && c)) != d) || e'\'' -a 1,2,0,2,1
1
$ test-expr '\''((a >= (b && c)) != d) || e'\'' -a 2,0,0,0,2
1
$ test-expr '\''((a >= (b && c)) != d) || e'\'' -a 2,0,1,0,0
1
$ test-expr '\''((a >= (b && c)) != d) || e'\'' -a 2,1,0,1,2
1
$ test-expr '\''((a >= (b && c)) != d) || e'\'' -a 2,1,2,1,1
1
$ test-expr '\''((a >= (b && c)) != d) || e'\'' -a 2,2,0,0,2
1
$ test-expr '\''((a >= (b && c)) != d) || e'\'' -a 2,2,0,1,1
1
$ test-expr '\''((a >= (b && c)) != d) || e'\'' -a 2,2,0,2,1
1
$ test-expr '\''((a >= (b && c)) != d) || e'\'' -a 2,2,0,2,2
1
$ test-expr '\''((a >= (b && c)) != d) || e'\'' -a 2,2,1,1,1
1
$ test-expr '\''((a >= (b && c)) != d) || e'\'' -a 2,2,1,2,0
1
$ test-expr '\''((a >= (b && c)) || d) != e'\'' -a 0,0,0,2,0
1
$ test-expr '\''((a >= (b && c)) || d) != e'\'' -a 0,1,1,2,1
0
$ test-expr '\''((a >= (b && c)) || d) != e'\'' -a 0,1,2,0,0
0
$ test-expr '\''((a >= (b && c)) || d) != e'\'' -a 0,2,1,2,0
1
$ test-expr '\''((a >= (b && c)) || d) != e'\'' -a 0,2,1,2,2
1
$ test-expr '\''((a >= (b && c)) || d) != e'\'' -a 1,0,1,1,2
1
$ test-expr '\''((a >= (b && c)) || d) != e'\'' -a 1,1,1,0,0
1
$ test-expr '\''((a >= (b && c)) || d) != e'\'' -a 1,1,1,1,1
0
$ test-expr '\''((a >= (b && c)) || d) != e'\'' -a 1,1,1,2,1
0
$ test-expr '\''((a >= (b && c)) || d) != e'\'' -a 1,1,2,1,2
1
$ test-expr '\''((a >= (b && c)) || d) != e'\'' -a 1,2,0,0,1
0
$ test-expr '\''((a >= (b && c)) || d) != e'\'' -a 1,2,0,0,2
1
$ test-expr '\''((a >= (b && c)) || d) != e'\'' -a 1,2,2,0,0
1
$ test-expr '\''((a >= (b && c)) || d) != e'\'' -a 2,0,1,0,0
1
$ test-expr '\''((a >= (b && c)) || d) != e'\'' -a 2,0,1,2,0
1
$ test-expr '\''((a >= (b && c)) || d) != e'\'' -a 2,0,2,0,0
1
$ test-expr '\''((a >= (b && c)) || d) != e'\'' -a 2,0,2,2,2
1
$ test-expr '\''((a >= (b && c)) || d) != e'\'' -a 2,1,0,0,1
0
$ test-expr '\''((a >= (b && c)) || d) != e'\'' -a 2,2,0,1,2
1
$ test-expr '\''((a >= (b && c)) || d) != e'\'' -a 2,2,1,2,1
0
$ test-expr '\''((a >= (b || c)) != d) && e'\'' -a 0,0,1,0,0
0
$ test-expr '\''((a >= (b || c)) != d) && e'\'' -a 0,0,2,2,1
1
$ test-expr '\''((a >= (b || c)) != d) && e'\'' -a 0,1,0,1,1
1
$ test-expr '\''((a >= (b || c)) != d) && e'\'' -a 0,1,1,1,1
1
$ test-expr '\''((a >= (b || c)) != d) && e'\'' -a 0,1,2,2,0
0
$ test-expr '\''((a >= (b || c)) != d) && e'\'' -a 0,2,0,0,1
0
$ test-expr '\''((a >= (b || c)) != d) && e'\'' -a 0,2,1,1,1
1
$ test-expr '\''((a >= (b || c)) != d) && e'\'' -a 0,2,2,2,0
0
$ test-expr '\''((a >= (b || c)) != d) && e'\'' -a 1,0,1,2,1
1
$ test-expr '\''((a >= (b || c)) != d) && e'\'' -a 1,0,2,1,1
0
$ test-expr '\''((a >= (b || c)) != d) && e'\'' -a 1,0,2,2,2
1
$ test-expr '\''((a >= (b || c)) != d) && e'\'' -a 1,1,0,0,2
1
$ test-expr '\''((a >= (b || c)) != d) && e'\'' -a 1,1,1,2,0
0
$ test-expr '\''((a >= (b || c)) != d) && e'\'' -a 1,1,2,1,0
0
$ test-expr '\''((a >= (b || c)) != d) && e'\'' -a 1,2,0,2,2
1
$ test-expr '\''((a >= (b || c)) != d) && e'\'' -a 2,0,0,2,1
1
$ test-expr '\''((a >= (b || c)) != d) && e'\'' -a 2,0,1,2,0
0
$ test-expr '\''((a >= (b || c)) != d) && e'\'' -a 2,0,2,0,2
1
$ test-expr '\''((a >= (b || c)) != d) && e'\'' -a 2,1,1,0,1
1
$ test-expr '\''((a >= (b || c)) != d) && e'\'' -a 2,1,2,1,1
0
$ test-expr '\''((a >= (b || c)) != d) && e'\'' -a 2,1,2,2,0
0
$ test-expr '\''((a >= (b || c)) != d) && e'\'' -a 2,2,0,0,2
1
$ test-expr '\''((a >= (b || c)) != d) && e'\'' -a 2,2,0,2,1
1
$ test-expr '\''((a >= (b || c)) != d) && e'\'' -a 2,2,2,0,2
1
$ test-expr '\''((a >= (b || c)) && d) != e'\'' -a 0,0,0,0,0
0
$ test-expr '\''((a >= (b || c)) && d) != e'\'' -a 0,0,1,1,2
1
$ test-expr '\''((a >= (b || c)) && d) != e'\'' -a 0,0,2,2,2
1
$ test-expr '\''((a >= (b || c)) && d) != e'\'' -a 0,1,0,0,2
1
$ test-expr '\''((a >= (b || c)) && d) != e'\'' -a 0,1,0,1,1
1
$ test-expr '\''((a >= (b || c)) && d) != e'\'' -a 0,1,0,2,1
1
$ test-expr '\''((a >= (b || c)) && d) != e'\'' -a 0,1,1,0,2
1
$ test-expr '\''((a >= (b || c)) && d) != e'\'' -a 0,1,1,2,0
0
$ test-expr '\''((a >= (b || c)) && d) != e'\'' -a 0,1,2,0,1
1
$ test-expr '\''((a >= (b || c)) && d) != e'\'' -a 0,1,2,1,1
1
$ test-expr '\''((a >= (b || c)) && d) != e'\'' -a 0,1,2,1,2
1
$ test-expr '\''((a >= (b || c)) && d) != e'\'' -a 0,2,0,1,1
1
$ test-expr '\''((a >= (b || c)) && d) != e'\'' -a 0,2,1,1,0
0
$ test-expr '\''((a >= (b || c)) && d) != e'\'' -a 0,2,2,1,0
0
$ test-expr '\''((a >= (b || c)) && d) != e'\'' -a 0,2,2,1,1
1
$ test-expr '\''((a >= (b || c)) && d) != e'\'' -a 1,0,1,0,1
1
$ test-expr '\''((a >= (b || c)) && d) != e'\'' -a 1,0,1,0,2
1
$ test-expr '\''((a >= (b || c)) && d) != e'\'' -a 1,0,1,1,1
0
$ test-expr '\''((a >= (b || c)) && d) != e'\'' -a 1,0,2,2,1
0
$ test-expr '\''((a >= (b || c)) && d) != e'\'' -a 1,1,1,0,0
0
$ test-expr '\''((a >= (b || c)) && d) != e'\'' -a 1,2,0,1,2
1
$ test-expr '\''((a >= (b || c)) && d) != e'\'' -a 1,2,0,2,1
0
$ test-expr '\''((a >= (b || c)) && d) != e'\'' -a 1,2,1,2,2
1
$ test-expr '\''((a >= (b || c)) && d) != e'\'' -a 1,2,2,2,1
0
$ test-expr '\''((a >= (b || c)) && d) != e'\'' -a 2,0,1,1,2
1
$ test-expr '\''((a >= (b || c)) && d) != e'\'' -a 2,0,2,2,0
1
$ test-expr '\''((a >= (b || c)) && d) != e'\'' -a 2,1,0,2,1
0
$ test-expr '\''((a >= (b || c)) && d) != e'\'' -a 2,1,2,0,0
0
$ test-expr '\''((a >= (b || c)) && d) != e'\'' -a 2,1,2,2,1
0
$ test-expr '\''((a >= (b || c)) && d) != e'\'' -a 2,2,1,0,0
0
$ test-expr '\''((a >= (b || c)) && d) != e'\'' -a 2,2,2,2,0
1
$ test-expr '\''((a || b) != c) && (d >= e)'\'' -a 0,0,0,0,0
0
$ test-expr '\''((a || b) != c) && (d >= e)'\'' -a 0,0,0,2,0
0
$ test-expr '\''((a || b) != c) && (d >= e)'\'' -a 0,0,1,2,0
1
$ test-expr '\''((a || b) != c) && (d >= e)'\'' -a 0,0,2,0,2
0
$ test-expr '\''((a || b) != c) && (d >= e)'\'' -a 0,0,2,1,0
1
$ test-expr '\''((a || b) != c) && (d >= e)'\'' -a 0,1,0,2,0
1
$ test-expr '\''((a || b) != c) && (d >= e)'\'' -a 0,1,0,2,1
1
$ test-expr '\''((a || b) != c) && (d >= e)'\'' -a 0,1,0,2,2
1
$ test-expr '\''((a || b) != c) && (d >= e)'\'' -a 0,1,1,1,2
0
$ test-expr '\''((a || b) != c) && (d >= e)'\'' -a 0,1,1,2,0
0
$ test-expr '\''((a || b) != c) && (d >= e)'\'' -a 0,2,1,0,0
0
$ test-expr '\''((a || b) != c) && (d >= e)'\'' -a 0,2,1,1,0
0
$ test-expr '\''((a || b) != c) && (d >= e)'\'' -a 1,0,2,2,1
1
$ test-expr '\''((a || b) != c) && (d >= e)'\'' -a 1,1,1,0,2
0
$ test-expr '\''((a || b) != c) && (d >= e)'\'' -a 1,1,1,1,0
0
$ test-expr '\''((a || b) != c) && (d >= e)'\'' -a 1,1,1,2,2
0
$ test-expr '\''((a || b) != c) && (d >= e)'\'' -a 1,2,0,0,0
1
$ test-expr '\''((a || b) != c) && (d >= e)'\'' -a 1,2,1,0,0
0
$ test-expr '\''((a || b) != c) && (d >= e)'\'' -a 1,2,1,0,2
0
$ test-expr '\''((a || b) != c) && (d >= e)'\'' -a 1,2,1,1,0
0
$ test-expr '\''((a || b) != c) && (d >= e)'\'' -a 1,2,2,1,1
1
$ test-expr '\''((a || b) != c) && (d >= e)'\'' -a 1,2,2,2,2
1
$ test-expr '\''((a || b) != c) && (d >= e)'\'' -a 2,0,1,0,1
0
$ test-expr '\''((a || b) != c) && (d >= e)'\'' -a 2,0,1,1,0
0
$ test-expr '\''((a || b) != c) && (d >= e)'\'' -a 2,0,2,2,0
1
$ test-expr '\''((a || b) != c) && (d >= e)'\'' -a 2,0,2,2,2
1
$ test-expr '\''((a || b) != c) && (d >= e)'\'' -a 2,1,0,0,0
1
$ test-expr '\''((a || b) != c) && (d >= e)'\'' -a 2,1,0,0,1
0
$ test-expr '\''((a || b) != c) && (d >= e)'\'' -a 2,1,1,2,2
0
$ test-expr '\''((a || b) != c) && (d >= e)'\'' -a 2,2,0,0,0
1
$ test-expr '\''((a || b) != c) && (d >= e)'\'' -a 2,2,1,1,2
0
$ test-expr '\''((a || b) != c) && (d >= e)'\'' -a 2,2,2,2,1
1
$ test-expr '\''((a || b) != c) && (d >= e)'\'' -a 2,2,2,2,2
1
$ test-expr '\''((a || b) != c) >= (d && e)'\'' -a 0,0,0,2,1
0
$ test-expr '\''((a || b) != c) >= (d && e)'\'' -a 0,0,2,0,1
1
$ test-expr '\''((a || b) != c) >= (d && e)'\'' -a 0,0,2,1,2
1
$ test-expr '\''((a || b) != c) >= (d && e)'\'' -a 0,0,2,2,2
1
$ test-expr '\''((a || b) != c) >= (d && e)'\'' -a 0,1,0,1,1
1
$ test-expr '\''((a || b) != c) >= (d && e)'\'' -a 0,1,2,0,2
1
$ test-expr '\''((a || b) != c) >= (d && e)'\'' -a 0,2,0,1,0
1
$ test-expr '\''((a || b) != c) >= (d && e)'\'' -a 0,2,0,2,1
1
$ test-expr '\''((a || b) != c) >= (d && e)'\'' -a 0,2,1,1,0
1
$ test-expr '\''((a || b) != c) >= (d && e)'\'' -a 0,2,2,0,0
1
$ test-expr '\''((a || b) != c) >= (d && e)'\'' -a 0,2,2,2,1
1
$ test-expr '\''((a || b) != c) >= (d && e)'\'' -a 1,2,0,1,2
1
$ test-expr '\''((a || b) != c) >= (d && e)'\'' -a 1,2,1,1,2
0
$ test-expr '\''((a || b) != c) >= (d && e)'\'' -a 2,0,0,1,0
1
$ test-expr '\''((a || b) != c) >= (d && e)'\'' -a 2,0,1,0,0
1
$ test-expr '\''((a || b) != c) >= (d && e)'\'' -a 2,0,1,1,2
0
$ test-expr '\''((a || b) != c) >= (d && e)'\'' -a 2,1,0,0,1
1
$ test-expr '\''((a || b) != c) >= (d && e)'\'' -a 2,1,0,1,2
1
$ test-expr '\''((a || b) != c) >= (d && e)'\'' -a 2,1,0,2,1
1
$ test-expr '\''((a || b) != c) >= (d && e)'\'' -a 2,1,2,1,0
1
$ test-expr '\''((a || b) != c) >= (d && e)'\'' -a 2,2,0,0,0
1
$ test-expr '\''((a || b) != c) >= (d && e)'\'' -a 2,2,0,2,0
1
$ test-expr '\''((a || b) != (c && d)) >= e'\'' -a 0,0,0,0,0
1
$ test-expr '\''((a || b) != (c && d)) >= e'\'' -a 0,0,1,1,0
1
$ test-expr '\''((a || b) != (c && d)) >= e'\'' -a 0,0,2,0,1
0
$ test-expr '\''((a || b) != (c && d)) >= e'\'' -a 0,1,0,1,1
1
$ test-expr '\''((a || b) != (c && d)) >= e'\'' -a 0,1,1,0,0
1
$ test-expr '\''((a || b) != (c && d)) >= e'\'' -a 0,1,1,2,0
1
$ test-expr '\''((a || b) != (c && d)) >= e'\'' -a 0,1,2,2,0
1
$ test-expr '\''((a || b) != (c && d)) >= e'\'' -a 0,2,0,2,1
1
$ test-expr '\''((a || b) != (c && d)) >= e'\'' -a 0,2,1,0,0
1
$ test-expr '\''((a || b) != (c && d)) >= e'\'' -a 0,2,2,2,2
0
$ test-expr '\''((a || b) != (c && d)) >= e'\'' -a 1,0,0,1,2
0
$ test-expr '\''((a || b) != (c && d)) >= e'\'' -a 1,0,1,0,2
0
$ test-expr '\''((a || b) != (c && d)) >= e'\'' -a 1,1,0,2,0
1
$ test-expr '\''((a || b) != (c && d)) >= e'\'' -a 1,1,1,2,1
0
$ test-expr '\''((a || b) != (c && d)) >= e'\'' -a 1,2,0,0,0
1
$ test-expr '\''((a || b) != (c && d)) >= e'\'' -a 1,2,1,0,2
0
$ test-expr '\''((a || b) != (c && d)) >= e'\'' -a 1,2,1,2,2
0
$ test-expr '\''((a || b) != (c && d)) >= e'\'' -a 1,2,2,0,0
1
$ test-expr '\''((a || b) != (c && d)) >= e'\'' -a 1,2,2,1,2
0
$ test-expr '\''((a || b) != (c && d)) >= e'\'' -a 2,0,0,1,1
1
$ test-expr '\''((a || b) != (c && d)) >= e'\'' -a 2,0,0,1,2
0
$ test-expr '\''((a || b) != (c && d)) >= e'\'' -a 2,0,1,0,2
0
$ test-expr '\''((a || b) != (c && d)) >= e'\'' -a 2,1,1,0,0
1
$ test-expr '\''((a || b) != (c && d)) >= e'\'' -a 2,2,0,0,0
1
$ test-expr '\''((a || b) != (c && d)) >= e'\'' -a 2,2,1,0,1
1
$ test-expr '\''((a || b) != (c && d)) >= e'\'' -a 2,2,1,2,1
0
$ test-expr '\''((a || b) != (c >= d)) && e'\'' -a 0,0,0,0,0
0
$ test-expr '\''((a || b) != (c >= d)) && e'\'' -a 0,0,0,0,1
1
$ test-expr '\''((a || b) != (c >= d)) && e'\'' -a 0,0,1,0,1
1
$ test-expr '\''((a || b) != (c >= d)) && e'\'' -a 0,0,2,0,1
1
$ test-expr '\''((a || b) != (c >= d)) && e'\'' -a 0,0,2,0,2
1
$ test-expr '\''((a || b) != (c >= d)) && e'\'' -a 0,0,2,1,2
1
$ test-expr '\''((a || b) != (c >= d)) && e'\'' -a 0,0,2,2,0
0
$ test-expr '\''((a || b) != (c >= d)) && e'\'' -a 0,1,0,0,2
0
$ test-expr '\''((a || b) != (c >= d)) && e'\'' -a 0,1,0,1,1
1
$ test-expr '\''((a || b) != (c >= d)) && e'\'' -a 0,1,1,1,2
0
$ test-expr '\''((a || b) != (c >= d)) && e'\'' -a 0,1,2,1,1
0
$ test-expr '\''((a || b) != (c >= d)) && e'\'' -a 0,2,1,1,0
0
$ test-expr '\''((a || b) != (c >= d)) && e'\'' -a 0,2,2,1,0
0
$ test-expr '\''((a || b) != (c >= d)) && e'\'' -a 0,2,2,2,0
0
$ test-expr '\''((a || b) != (c >= d)) && e'\'' -a 1,0,0,2,1
1
$ test-expr '\''((a || b) != (c >= d)) && e'\'' -a 1,0,0,2,2
1
$ test-expr '\''((a || b) != (c >= d)) && e'\'' -a 1,0,1,0,0
0
$ test-expr '\''((a || b) != (c >= d)) && e'\'' -a 1,0,1,1,1
0
$ test-expr '\''((a || b) != (c >= d)) && e'\'' -a 1,1,1,2,0
0
$ test-expr '\''((a || b) != (c >= d)) && e'\'' -a 1,1,1,2,1
1
$ test-expr '\''((a || b) != (c >= d)) && e'\'' -a 1,2,0,1,0
0
$ test-expr '\''((a || b) != (c >= d)) && e'\'' -a 1,2,1,2,1
1
$ test-expr '\''((a || b) != (c >= d)) && e'\'' -a 1,2,1,2,2
1
$ test-expr '\''((a || b) != (c >= d)) && e'\'' -a 2,0,0,0,0
0
$ test-expr '\''((a || b) != (c >= d)) && e'\'' -a 2,0,0,0,2
0
$ test-expr '\''((a || b) != (c >= d)) && e'\'' -a 2,0,0,2,0
0
$ test-expr '\''((a || b) != (c >= d)) && e'\'' -a 2,0,2,1,1
0
$ test-expr '\''((a || b) != (c >= d)) && e'\'' -a 2,1,0,0,1
0
$ test-expr '\''((a || b) != (c >= d)) && e'\'' -a 2,1,0,1,1
1
$ test-expr '\''((a || b) != (c >= d)) && e'\'' -a 2,1,0,2,1
1
$ test-expr '\''((a || b) != (c >= d)) && e'\'' -a 2,1,2,1,0
0
$ test-expr '\''((a || b) != (c >= d)) && e'\'' -a 2,1,2,2,1
0
$ test-expr '\''((a || b) != (c >= d)) && e'\'' -a 2,2,0,1,1
1
$ test-expr '\''((a || b) != (c >= d)) && e'\'' -a 2,2,1,2,1
1
$ test-expr '\''((a || b) != (c >= d)) && e'\'' -a 2,2,2,2,1
0
$ test-expr '\''((a || b) && c) != (d >= e)'\'' -a 0,0,0,2,1
1
$ test-expr '\''((a || b) && c) != (d >= e)'\'' -a 0,0,1,0,1
0
$ test-expr '\''((a || b) && c) != (d >= e)'\'' -a 0,0,1,1,1
1
$ test-expr '\''((a || b) && c) != (d >= e)'\'' -a 0,0,2,2,0
1
$ test-expr '\''((a || b) && c) != (d >= e)'\'' -a 0,1,0,0,2
0
$ test-expr '\''((a || b) && c) != (d >= e)'\'' -a 0,1,2,0,1
1
$ test-expr '\''((a || b) && c) != (d >= e)'\'' -a 0,2,1,2,0
0
$ test-expr '\''((a || b) && c) != (d >= e)'\'' -a 0,2,1,2,2
0
$ test-expr '\''((a || b) && c) != (d >= e)'\'' -a 0,2,2,0,1
1
$ test-expr '\''((a || b) && c) != (d >= e)'\'' -a 0,2,2,1,1
0
$ test-expr '\''((a || b) && c) != (d >= e)'\'' -a 0,2,2,2,0
0
$ test-expr '\''((a || b) && c) != (d >= e)'\'' -a 0,2,2,2,2
0
$ test-expr '\''((a || b) && c) != (d >= e)'\'' -a 1,0,1,0,0
0
$ test-expr '\''((a || b) && c) != (d >= e)'\'' -a 1,0,2,1,2
1
$ test-expr '\''((a || b) && c) != (d >= e)'\'' -a 1,0,2,2,0
0
$ test-expr '\''((a || b) && c) != (d >= e)'\'' -a 1,1,0,1,1
1
$ test-expr '\''((a || b) && c) != (d >= e)'\'' -a 1,1,0,1,2
0
$ test-expr '\''((a || b) && c) != (d >= e)'\'' -a 1,1,2,2,2
0
$ test-expr '\''((a || b) && c) != (d >= e)'\'' -a 1,2,0,1,1
1
$ test-expr '\''((a || b) && c) != (d >= e)'\'' -a 2,0,0,1,0
1
$ test-expr '\''((a || b) && c) != (d >= e)'\'' -a 2,0,1,1,0
0
$ test-expr '\''((a || b) && c) != (d >= e)'\'' -a 2,0,1,1,2
1
$ test-expr '\''((a || b) && c) != (d >= e)'\'' -a 2,1,0,0,0
1
$ test-expr '\''((a || b) && c) != (d >= e)'\'' -a 2,1,0,1,2
0
$ test-expr '\''((a || b) && c) != (d >= e)'\'' -a 2,1,0,2,1
1
$ test-expr '\''((a || b) && c) != (d >= e)'\'' -a 2,1,2,1,0
0
$ test-expr '\''((a || b) && c) != (d >= e)'\'' -a 2,2,0,1,1
1
$ test-expr '\''((a || b) && c) >= (d != e)'\'' -a 0,0,0,2,2
1
$ test-expr '\''((a || b) && c) >= (d != e)'\'' -a 0,0,1,1,0
0
$ test-expr '\''((a || b) && c) >= (d != e)'\'' -a 0,1,0,0,1
0
$ test-expr '\''((a || b) && c) >= (d != e)'\'' -a 0,1,1,0,1
1
$ test-expr '\''((a || b) && c) >= (d != e)'\'' -a 0,1,2,1,2
1
$ test-expr '\''((a || b) && c) >= (d != e)'\'' -a 0,2,1,0,2
1
$ test-expr '\''((a || b) && c) >= (d != e)'\'' -a 0,2,2,0,2
1
$ test-expr '\''((a || b) && c) >= (d != e)'\'' -a 1,1,0,1,0
0
$ test-expr '\''((a || b) && c) >= (d != e)'\'' -a 2,0,0,2,1
0
$ test-expr '\''((a || b) && c) >= (d != e)'\'' -a 2,0,2,0,1
1
$ test-expr '\''((a || b) && c) >= (d != e)'\'' -a 2,0,2,1,2
1
$ test-expr '\''((a || b) && c) >= (d != e)'\'' -a 2,1,1,0,2
1
$ test-expr '\''((a || b) && c) >= (d != e)'\'' -a 2,1,1,2,0
1
$ test-expr '\''((a || b) && c) >= (d != e)'\'' -a 2,2,1,2,2
1
$ test-expr '\''((a || b) && c) >= (d != e)'\'' -a 2,2,2,1,2
1
$ test-expr '\''((a || b) && (c != d)) >= e'\'' -a 0,0,0,0,1
0
$ test-expr '\''((a || b) && (c != d)) >= e'\'' -a 0,0,0,1,2
0
$ test-expr '\''((a || b) && (c != d)) >= e'\'' -a 0,0,0,2,0
1
$ test-expr '\''((a || b) && (c != d)) >= e'\'' -a 0,1,1,0,0
1
$ test-expr '\''((a || b) && (c != d)) >= e'\'' -a 0,1,1,1,0
1
$ test-expr '\''((a || b) && (c != d)) >= e'\'' -a 0,1,1,1,2
0
$ test-expr '\''((a || b) && (c != d)) >= e'\'' -a 0,1,2,0,0
1
$ test-expr '\''((a || b) && (c != d)) >= e'\'' -a 0,1,2,2,1
0
$ test-expr '\''((a || b) && (c != d)) >= e'\'' -a 0,2,1,2,0
1
$ test-expr '\''((a || b) && (c != d)) >= e'\'' -a 1,0,0,0,2
0
$ test-expr '\''((a || b) && (c != d)) >= e'\'' -a 1,0,0,2,2
0
$ test-expr '\''((a || b) && (c != d)) >= e'\'' -a 1,0,1,0,0
1
$ test-expr '\''((a || b) && (c != d)) >= e'\'' -a 1,0,1,1,1
0
$ test-expr '\''((a || b) && (c != d)) >= e'\'' -a 1,0,2,1,2
0
$ test-expr '\''((a || b) && (c != d)) >= e'\'' -a 1,1,0,0,0
1
$ test-expr '\''((a || b) && (c != d)) >= e'\'' -a 1,1,0,2,0
1
$ test-expr '\''((a || b) && (c != d)) >= e'\'' -a 1,2,0,0,1
0
$ test-expr '\''((a || b) && (c != d)) >= e'\'' -a 1,2,1,0,0
1
$ test-expr '\''((a || b) && (c != d)) >= e'\'' -a 1,2,2,2,1
0
$ test-expr '\''((a || b) && (c != d)) >= e'\'' -a 2,0,0,0,0
1
$ test-expr '\''((a || b) && (c != d)) >= e'\'' -a 2,0,1,1,2
0
$ test-expr '\''((a || b) && (c != d)) >= e'\'' -a 2,1,0,0,1
0
$ test-expr '\''((a || b) && (c != d)) >= e'\'' -a 2,1,0,1,2
0
$ test-expr '\''((a || b) && (c != d)) >= e'\'' -a 2,1,0,2,2
0
$ test-expr '\''((a || b) && (c != d)) >= e'\'' -a 2,1,1,1,2
0
$ test-expr '\''((a || b) && (c != d)) >= e'\'' -a 2,1,2,0,0
1
$ test-expr '\''((a || b) && (c != d)) >= e'\'' -a 2,2,0,0,1
0
$ test-expr '\''((a || b) && (c != d)) >= e'\'' -a 2,2,2,1,1
1
$ test-expr '\''((a || b) && (c >= d)) != e'\'' -a 0,0,0,2,2
1
$ test-expr '\''((a || b) && (c >= d)) != e'\'' -a 0,0,1,1,0
0
$ test-expr '\''((a || b) && (c >= d)) != e'\'' -a 0,0,1,2,0
0
$ test-expr '\''((a || b) && (c >= d)) != e'\'' -a 0,0,2,2,1
1
$ test-expr '\''((a || b) && (c >= d)) != e'\'' -a 0,1,0,1,2
1
$ test-expr '\''((a || b) && (c >= d)) != e'\'' -a 0,1,2,0,0
1
$ test-expr '\''((a || b) && (c >= d)) != e'\'' -a 0,2,0,0,2
1
$ test-expr '\''((a || b) && (c >= d)) != e'\'' -a 0,2,0,2,2
1
$ test-expr '\''((a || b) && (c >= d)) != e'\'' -a 1,0,0,1,2
1
$ test-expr '\''((a || b) && (c >= d)) != e'\'' -a 1,0,2,0,0
1
$ test-expr '\''((a || b) && (c >= d)) != e'\'' -a 1,0,2,0,1
0
$ test-expr '\''((a || b) && (c >= d)) != e'\'' -a 1,0,2,1,2
1
$ test-expr '\''((a || b) && (c >= d)) != e'\'' -a 1,1,2,0,1
0
$ test-expr '\''((a || b) && (c >= d)) != e'\'' -a 1,1,2,2,2
1
$ test-expr '\''((a || b) && (c >= d)) != e'\'' -a 1,2,0,1,0
0
$ test-expr '\''((a || b) && (c >= d)) != e'\'' -a 1,2,1,0,1
0
$ test-expr '\''((a || b) && (c >= d)) != e'\'' -a 1,2,1,1,1
0
$ test-expr '\''((a || b) && (c >= d)) != e'\'' -a 1,2,1,2,0
0
$ test-expr '\''((a || b) && (c >= d)) != e'\'' -a 1,2,2,2,0
1
$ test-expr '\''((a || b) && (c >= d)) != e'\'' -a 1,2,2,2,1
0
$ test-expr '\''((a || b) && (c >= d)) != e'\'' -a 1,2,2,2,2
1
$ test-expr '\''((a || b) && (c >= d)) != e'\'' -a 2,0,0,2,1
1
$ test-expr '\''((a || b) && (c >= d)) != e'\'' -a 2,0,1,1,0
1
$ test-expr '\''((a || b) && (c >= d)) != e'\'' -a 2,0,1,2,2
1
$ test-expr '\''((a || b) && (c >= d)) != e'\'' -a 2,0,2,0,0
1
$ test-expr '\''((a || b) && (c >= d)) != e'\'' -a 2,1,1,0,2
1
$ test-expr '\''((a || b) && (c >= d)) != e'\'' -a 2,1,1,1,1
0
$ test-expr '\''((a || b) && (c >= d)) != e'\'' -a 2,1,1,2,1
1
$ test-expr '\''((a || b) && (c >= d)) != e'\'' -a 2,1,2,1,1
0
$ test-expr '\''((a || b) && (c >= d)) != e'\'' -a 2,1,2,2,1
0
$ test-expr '\''((a || b) && (c >= d)) != e'\'' -a 2,2,0,0,1
0
$ test-expr '\''((a || b) && (c >= d)) != e'\'' -a 2,2,1,2,1
1
$ test-expr '\''((a || b) && (c >= d)) != e'\'' -a 2,2,1,2,2
1
$ test-expr '\''((a || b) && (c >= d)) != e'\'' -a 2,2,2,1,1
0
$ test-expr '\''((a || b) && (c >= d)) != e'\'' -a 2,2,2,2,1
0
$ test-expr '\''((a || b) >= c) != (d && e)'\'' -a 0,0,0,1,2
0
$ test-expr '\''((a || b) >= c) != (d && e)'\'' -a 0,0,1,0,0
0
$ test-expr '\''((a || b) >= c) != (d && e)'\'' -a 0,0,1,0,2
0
$ test-expr '\''((a || b) >= c) != (d && e)'\'' -a 0,0,2,2,0
0
$ test-expr '\''((a || b) >= c) != (d && e)'\'' -a 0,1,0,0,1
1
$ test-expr '\''((a || b) >= c) != (d && e)'\'' -a 0,1,1,0,1
1
$ test-expr '\''((a || b) >= c) != (d && e)'\'' -a 0,1,1,2,2
0
$ test-expr '\''((a || b) >= c) != (d && e)'\'' -a 0,1,2,0,2
0
$ test-expr '\''((a || b) >= c) != (d && e)'\'' -a 0,1,2,1,0
0
$ test-expr '\''((a || b) >= c) != (d && e)'\'' -a 0,1,2,1,1
1
$ test-expr '\''((a || b) >= c) != (d && e)'\'' -a 0,1,2,1,2
1
$ test-expr '\''((a || b) >= c) != (d && e)'\'' -a 0,2,0,1,2
0
$ test-expr '\''((a || b) >= c) != (d && e)'\'' -a 0,2,2,1,0
0
$ test-expr '\''((a || b) >= c) != (d && e)'\'' -a 1,0,0,1,1
0
$ test-expr '\''((a || b) >= c) != (d && e)'\'' -a 1,0,0,1,2
0
$ test-expr '\''((a || b) >= c) != (d && e)'\'' -a 1,0,1,1,0
1
$ test-expr '\''((a || b) >= c) != (d && e)'\'' -a 1,0,1,1,2
0
$ test-expr '\''((a || b) >= c) != (d && e)'\'' -a 1,0,1,2,2
0
$ test-expr '\''((a || b) >= c) != (d && e)'\'' -a 1,1,2,2,2
1
$ test-expr '\''((a || b) >= c) != (d && e)'\'' -a 1,2,0,2,2
0
$ test-expr '\''((a || b) >= c) != (d && e)'\'' -a 1,2,1,0,2
1
$ test-expr '\''((a || b) >= c) != (d && e)'\'' -a 1,2,1,2,2
0
$ test-expr '\''((a || b) >= c) != (d && e)'\'' -a 2,0,0,1,0
1
$ test-expr '\''((a || b) >= c) != (d && e)'\'' -a 2,0,0,1,1
0
$ test-expr '\''((a || b) >= c) != (d && e)'\'' -a 2,0,0,2,1
0
$ test-expr '\''((a || b) >= c) != (d && e)'\'' -a 2,0,2,2,0
0
$ test-expr '\''((a || b) >= c) != (d && e)'\'' -a 2,1,2,1,0
0
$ test-expr '\''((a || b) >= c) != (d && e)'\'' -a 2,1,2,1,2
1
$ test-expr '\''((a || b) >= c) && (d != e)'\'' -a 0,0,1,0,2
0
$ test-expr '\''((a || b) >= c) && (d != e)'\'' -a 0,0,2,0,0
0
$ test-expr '\''((a || b) >= c) && (d != e)'\'' -a 0,0,2,0,2
0
$ test-expr '\''((a || b) >= c) && (d != e)'\'' -a 0,0,2,1,2
0
$ test-expr '\''((a || b) >= c) && (d != e)'\'' -a 0,1,0,1,2
1
$ test-expr '\''((a || b) >= c) && (d != e)'\'' -a 0,1,1,2,1
1
$ test-expr '\''((a || b) >= c) && (d != e)'\'' -a 0,2,0,1,0
1
$ test-expr '\''((a || b) >= c) && (d != e)'\'' -a 0,2,1,2,2
0
$ test-expr '\''((a || b) >= c) && (d != e)'\'' -a 0,2,2,2,1
0
$ test-expr '\''((a || b) >= c) && (d != e)'\'' -a 1,0,0,0,0
0
$ test-expr '\''((a || b) >= c) && (d != e)'\'' -a 1,0,2,0,0
0
$ test-expr '\''((a || b) >= c) && (d != e)'\'' -a 1,0,2,2,2
0
$ test-expr '\''((a || b) >= c) && (d != e)'\'' -a 1,1,0,0,2
1
$ test-expr '\''((a || b) >= c) && (d != e)'\'' -a 1,1,1,0,0
0
$ test-expr '\''((a || b) >= c) && (d != e)'\'' -a 1,1,1,1,0
1
$ test-expr '\''((a || b) >= c) && (d != e)'\'' -a 1,1,2,2,0
0
$ test-expr '\''((a || b) >= c) && (d != e)'\'' -a 1,2,0,0,0
0
$ test-expr '\''((a || b) >= c) && (d != e)'\'' -a 1,2,0,0,2
1
$ test-expr '\''((a || b) >= c) && (d != e)'\'' -a 1,2,0,1,2
1
$ test-expr '\''((a || b) >= c) && (d != e)'\'' -a 1,2,1,1,0
1
$ test-expr '\''((a || b) >= c) && (d != e)'\'' -a 2,0,0,0,0
0
$ test-expr '\''((a || b) >= c) && (d != e)'\'' -a 2,0,0,0,1
1
$ test-expr '\''((a || b) >= c) && (d != e)'\'' -a 2,0,1,0,1
1
$ test-expr '\''((a || b) >= c) && (d != e)'\'' -a 2,0,1,0,2
1
$ test-expr '\''((a || b) >= c) && (d != e)'\'' -a 2,0,1,1,0
1
$ test-expr '\''((a || b) >= c) && (d != e)'\'' -a 2,0,2,1,0
0
$ test-expr '\''((a || b) >= c) && (d != e)'\'' -a 2,1,0,1,0
1
$ test-expr '\''((a || b) >= c) && (d != e)'\'' -a 2,1,1,0,1
1
$ test-expr '\''((a || b) >= c) && (d != e)'\'' -a 2,1,1,2,1
1
$ test-expr '\''((a || b) >= c) && (d != e)'\'' -a 2,1,2,1,0
0
$ test-expr '\''((a || b) >= c) && (d != e)'\'' -a 2,2,0,0,1
1
$ test-expr '\''((a || b) >= c) && (d != e)'\'' -a 2,2,2,0,1
0
$ test-expr '\''((a || b) >= c) && (d != e)'\'' -a 2,2,2,0,2
0
$ test-expr '\''((a || b) >= c) && (d != e)'\'' -a 2,2,2,1,2
0
$ test-expr '\''((a || b) >= c) && (d != e)'\'' -a 2,2,2,2,0
0
$ test-expr '\''((a || b) >= c) && (d != e)'\'' -a 2,2,2,2,2
0
$ test-expr '\''((a || b) >= (c != d)) && e'\'' -a 0,0,0,0,1
1
$ test-expr '\''((a || b) >= (c != d)) && e'\'' -a 0,0,2,0,2
0
$ test-expr '\''((a || b) >= (c != d)) && e'\'' -a 0,1,1,1,1
1
$ test-expr '\''((a || b) >= (c != d)) && e'\'' -a 0,1,2,0,2
1
$ test-expr '\''((a || b) >= (c != d)) && e'\'' -a 0,1,2,1,0
0
$ test-expr '\''((a || b) >= (c != d)) && e'\'' -a 0,2,0,1,1
1
$ test-expr '\''((a || b) >= (c != d)) && e'\'' -a 0,2,2,2,2
1
$ test-expr '\''((a || b) >= (c != d)) && e'\'' -a 1,0,0,1,2
1
$ test-expr '\''((a || b) >= (c != d)) && e'\'' -a 1,0,1,0,0
0
$ test-expr '\''((a || b) >= (c != d)) && e'\'' -a 1,0,1,0,1
1
$ test-expr '\''((a || b) >= (c != d)) && e'\'' -a 1,1,0,0,0
0
$ test-expr '\''((a || b) >= (c != d)) && e'\'' -a 1,1,0,2,0
0
$ test-expr '\''((a || b) >= (c != d)) && e'\'' -a 1,1,0,2,2
1
$ test-expr '\''((a || b) >= (c != d)) && e'\'' -a 1,1,1,0,0
0
$ test-expr '\''((a || b) >= (c != d)) && e'\'' -a 1,1,2,1,2
1
$ test-expr '\''((a || b) >= (c != d)) && e'\'' -a 1,1,2,2,2
1
$ test-expr '\''((a || b) >= (c != d)) && e'\'' -a 1,2,0,0,1
1
$ test-expr '\''((a || b) >= (c != d)) && e'\'' -a 1,2,0,2,1
1
$ test-expr '\''((a || b) >= (c != d)) && e'\'' -a 1,2,2,0,2
1
$ test-expr '\''((a || b) >= (c != d)) && e'\'' -a 2,0,0,2,0
0
$ test-expr '\''((a || b) >= (c != d)) && e'\'' -a 2,0,0,2,1
1
$ test-expr '\''((a || b) >= (c != d)) && e'\'' -a 2,0,2,1,1
1
$ test-expr '\''((a || b) >= (c != d)) && e'\'' -a 2,1,2,0,1
1
$ test-expr '\''((a || b) >= (c != d)) && e'\'' -a 2,1,2,1,1
1
$ test-expr '\''((a || b) >= (c != d)) && e'\'' -a 2,2,2,1,1
1
$ test-expr '\''((a || b) >= (c != d)) && e'\'' -a 2,2,2,2,1
1
$ test-expr '\''((a || b) >= (c && d)) != e'\'' -a 0,0,0,2,1
0
$ test-expr '\''((a || b) >= (c && d)) != e'\'' -a 0,0,1,0,2
1
$ test-expr '\''((a || b) >= (c && d)) != e'\'' -a 0,0,2,1,0
0
$ test-expr '\''((a || b) >= (c && d)) != e'\'' -a 0,0,2,2,2
1
$ test-expr '\''((a || b) >= (c && d)) != e'\'' -a 0,1,0,1,0
1
$ test-expr '\''((a || b) >= (c && d)) != e'\'' -a 0,1,0,2,1
0
$ test-expr '\''((a || b) >= (c && d)) != e'\'' -a 0,1,1,0,1
0
$ test-expr '\''((a || b) >= (c && d)) != e'\'' -a 0,1,1,1,2
1
$ test-expr '\''((a || b) >= (c && d)) != e'\'' -a 0,1,2,0,2
1
$ test-expr '\''((a || b) >= (c && d)) != e'\'' -a 0,1,2,1,1
0
$ test-expr '\''((a || b) >= (c && d)) != e'\'' -a 0,1,2,2,1
0
$ test-expr '\''((a || b) >= (c && d)) != e'\'' -a 0,2,0,1,0
1
$ test-expr '\''((a || b) >= (c && d)) != e'\'' -a 0,2,1,0,1
0
$ test-expr '\''((a || b) >= (c && d)) != e'\'' -a 0,2,2,0,2
1
$ test-expr '\''((a || b) >= (c && d)) != e'\'' -a 0,2,2,2,2
1
$ test-expr '\''((a || b) >= (c && d)) != e'\'' -a 1,0,0,0,2
1
$ test-expr '\''((a || b) >= (c && d)) != e'\'' -a 1,0,0,1,1
0
$ test-expr '\''((a || b) >= (c && d)) != e'\'' -a 1,0,1,0,2
1
$ test-expr '\''((a || b) >= (c && d)) != e'\'' -a 1,0,1,1,2
1
$ test-expr '\''((a || b) >= (c && d)) != e'\'' -a 1,0,2,0,1
0
$ test-expr '\''((a || b) >= (c && d)) != e'\'' -a 1,2,1,1,1
0
$ test-expr '\''((a || b) >= (c && d)) != e'\'' -a 2,0,1,0,1
0
$ test-expr '\''((a || b) >= (c && d)) != e'\'' -a 2,0,1,1,0
1
$ test-expr '\''((a || b) >= (c && d)) != e'\'' -a 2,0,2,0,2
1
$ test-expr '\''((a || b) >= (c && d)) != e'\'' -a 2,1,0,1,1
0
$ test-expr '\''((a || b) >= (c && d)) != e'\'' -a 2,1,2,2,0
1
$ test-expr '\''((a || b) >= (c && d)) != e'\'' -a 2,2,0,2,0
1
$ test-expr '\''((a || b) >= (c && d)) != e'\'' -a 2,2,0,2,1
0
$ test-expr '\''((a || b) >= (c && d)) != e'\'' -a 2,2,1,1,1
0
$ test-expr '\''((a || (b != c)) && d) >= e'\'' -a 0,0,0,1,1
0
$ test-expr '\''((a || (b != c)) && d) >= e'\'' -a 0,1,0,0,1
0
$ test-expr '\''((a || (b != c)) && d) >= e'\'' -a 0,1,0,2,2
0
$ test-expr '\''((a || (b != c)) && d) >= e'\'' -a 0,1,1,1,2
0
$ test-expr '\''((a || (b != c)) && d) >= e'\'' -a 0,2,0,0,1
0
$ test-expr '\''((a || (b != c)) && d) >= e'\'' -a 0,2,1,0,1
0
$ test-expr '\''((a || (b != c)) && d) >= e'\'' -a 0,2,1,1,2
0
$ test-expr '\''((a || (b != c)) && d) >= e'\'' -a 1,0,0,1,2
0
$ test-expr '\''((a || (b != c)) && d) >= e'\'' -a 1,0,0,2,0
1
$ test-expr '\''((a || (b != c)) && d) >= e'\'' -a 1,0,1,0,1
0
$ test-expr '\''((a || (b != c)) && d) >= e'\'' -a 1,0,1,1,0
1
$ test-expr '\''((a || (b != c)) && d) >= e'\'' -a 1,0,2,1,2
0
$ test-expr '\''((a || (b != c)) && d) >= e'\'' -a 1,1,1,1,2
0
$ test-expr '\''((a || (b != c)) && d) >= e'\'' -a 1,1,1,2,2
0
$ test-expr '\''((a || (b != c)) && d) >= e'\'' -a 1,1,2,2,0
1
$ test-expr '\''((a || (b != c)) && d) >= e'\'' -a 1,2,0,1,2
0
$ test-expr '\''((a || (b != c)) && d) >= e'\'' -a 1,2,2,1,0
1
$ test-expr '\''((a || (b != c)) && d) >= e'\'' -a 2,0,0,2,0
1
$ test-expr '\''((a || (b != c)) && d) >= e'\'' -a 2,0,1,0,2
0
$ test-expr '\''((a || (b != c)) && d) >= e'\'' -a 2,0,2,0,1
0
$ test-expr '\''((a || (b != c)) && d) >= e'\'' -a 2,1,0,1,2
0
$ test-expr '\''((a || (b != c)) && d) >= e'\'' -a 2,1,2,1,1
1
$ test-expr '\''((a || (b != c)) && d) >= e'\'' -a 2,2,1,0,2
0
$ test-expr '\''((a || (b != c)) && d) >= e'\'' -a 2,2,1,1,0
1
$ test-expr '\''((a || (b != c)) && d) >= e'\'' -a 2,2,2,0,2
0
$ test-expr '\''((a || (b != c)) >= d) && e'\'' -a 0,0,0,1,1
0
$ test-expr '\''((a || (b != c)) >= d) && e'\'' -a 0,0,0,2,1
0
$ test-expr '\''((a || (b != c)) >= d) && e'\'' -a 0,0,1,1,2
1
$ test-expr '\''((a || (b != c)) >= d) && e'\'' -a 0,0,1,2,0
0
$ test-expr '\''((a || (b != c)) >= d) && e'\'' -a 0,0,1,2,2
0
$ test-expr '\''((a || (b != c)) >= d) && e'\'' -a 0,0,2,0,1
1
$ test-expr '\''((a || (b != c)) >= d) && e'\'' -a 0,1,0,1,2
1
$ test-expr '\''((a || (b != c)) >= d) && e'\'' -a 0,1,1,0,2
1
$ test-expr '\''((a || (b != c)) >= d) && e'\'' -a 0,1,2,2,2
0
$ test-expr '\''((a || (b != c)) >= d) && e'\'' -a 0,2,1,0,2
1
$ test-expr '\''((a || (b != c)) >= d) && e'\'' -a 0,2,2,0,0
0
$ test-expr '\''((a || (b != c)) >= d) && e'\'' -a 0,2,2,1,0
0
$ test-expr '\''((a || (b != c)) >= d) && e'\'' -a 1,0,0,1,2
1
$ test-expr '\''((a || (b != c)) >= d) && e'\'' -a 1,0,1,0,2
1
$ test-expr '\''((a || (b != c)) >= d) && e'\'' -a 1,0,2,1,2
1
$ test-expr '\''((a || (b != c)) >= d) && e'\'' -a 1,1,0,0,2
1
$ test-expr '\''((a || (b != c)) >= d) && e'\'' -a 1,1,0,1,1
1
$ test-expr '\''((a || (b != c)) >= d) && e'\'' -a 1,2,2,2,0
0
$ test-expr '\''((a || (b != c)) >= d) && e'\'' -a 2,0,0,1,0
0
$ test-expr '\''((a || (b != c)) >= d) && e'\'' -a 2,0,0,2,2
0
$ test-expr '\''((a || (b != c)) >= d) && e'\'' -a 2,0,1,2,1
0
$ test-expr '\''((a || (b != c)) >= d) && e'\'' -a 2,0,2,1,2
1
$ test-expr '\''((a || (b != c)) >= d) && e'\'' -a 2,1,1,1,0
0
$ test-expr '\''((a || (b != c)) >= d) && e'\'' -a 2,1,1,2,0
0
$ test-expr '\''((a || (b != c)) >= d) && e'\'' -a 2,1,2,2,1
0
$ test-expr '\''((a || (b != c)) >= d) && e'\'' -a 2,2,0,0,2
1
$ test-expr '\''((a || (b != c)) >= d) && e'\'' -a 2,2,0,2,0
0
$ test-expr '\''((a || (b != c)) >= d) && e'\'' -a 2,2,2,0,0
0
$ test-expr '\''((a || (b != c)) >= d) && e'\'' -a 2,2,2,0,1
1
$ test-expr '\''((a || (b && c)) != d) >= e'\'' -a 0,0,0,0,2
0
$ test-expr '\''((a || (b && c)) != d) >= e'\'' -a 0,0,1,0,0
1
$ test-expr '\''((a || (b && c)) != d) >= e'\'' -a 0,0,1,2,1
1
$ test-expr '\''((a || (b && c)) != d) >= e'\'' -a 0,0,2,1,2
0
$ test-expr '\''((a || (b && c)) != d) >= e'\'' -a 0,1,0,0,1
0
$ test-expr '\''((a || (b && c)) != d) >= e'\'' -a 0,1,1,1,1
0
$ test-expr '\''((a || (b && c)) != d) >= e'\'' -a 0,1,1,2,2
0
$ test-expr '\''((a || (b && c)) != d) >= e'\'' -a 0,1,2,1,2
0
$ test-expr '\''((a || (b && c)) != d) >= e'\'' -a 0,1,2,2,0
1
$ test-expr '\''((a || (b && c)) != d) >= e'\'' -a 0,1,2,2,2
0
$ test-expr '\''((a || (b && c)) != d) >= e'\'' -a 0,2,0,1,0
1
$ test-expr '\''((a || (b && c)) != d) >= e'\'' -a 0,2,0,1,2
0
$ test-expr '\''((a || (b && c)) != d) >= e'\'' -a 0,2,2,0,0
1
$ test-expr '\''((a || (b && c)) != d) >= e'\'' -a 0,2,2,1,0
1
$ test-expr '\''((a || (b && c)) != d) >= e'\'' -a 0,2,2,2,0
1
$ test-expr '\''((a || (b && c)) != d) >= e'\'' -a 1,0,0,0,0
1
$ test-expr '\''((a || (b && c)) != d) >= e'\'' -a 1,0,0,1,0
1
$ test-expr '\''((a || (b && c)) != d) >= e'\'' -a 1,0,1,2,1
1
$ test-expr '\''((a || (b && c)) != d) >= e'\'' -a 1,0,2,2,1
1
$ test-expr '\''((a || (b && c)) != d) >= e'\'' -a 1,0,2,2,2
0
$ test-expr '\''((a || (b && c)) != d) >= e'\'' -a 1,1,1,0,1
1
$ test-expr '\''((a || (b && c)) != d) >= e'\'' -a 1,1,2,2,0
1
$ test-expr '\''((a || (b && c)) != d) >= e'\'' -a 1,2,0,1,2
0
$ test-expr '\''((a || (b && c)) != d) >= e'\'' -a 1,2,1,2,1
1
$ test-expr '\''((a || (b && c)) != d) >= e'\'' -a 1,2,2,1,2
0
$ test-expr '\''((a || (b && c)) != d) >= e'\'' -a 1,2,2,2,2
0
$ test-expr '\''((a || (b && c)) != d) >= e'\'' -a 2,0,0,1,0
1
$ test-expr '\''((a || (b && c)) != d) >= e'\'' -a 2,0,0,2,2
0
$ test-expr '\''((a || (b && c)) != d) >= e'\'' -a 2,0,1,0,2
0
$ test-expr '\''((a || (b && c)) != d) >= e'\'' -a 2,0,1,1,0
1
$ test-expr '\''((a || (b && c)) != d) >= e'\'' -a 2,0,2,0,1
1
$ test-expr '\''((a || (b && c)) != d) >= e'\'' -a 2,0,2,1,1
0
$ test-expr '\''((a || (b && c)) != d) >= e'\'' -a 2,0,2,2,1
1
$ test-expr '\''((a || (b && c)) != d) >= e'\'' -a 2,1,0,2,0
1
$ test-expr '\''((a || (b && c)) != d) >= e'\'' -a 2,1,1,1,0
1
$ test-expr '\''((a || (b && c)) != d) >= e'\'' -a 2,1,1,2,2
0
$ test-expr '\''((a || (b && c)) != d) >= e'\'' -a 2,1,2,1,0
1
$ test-expr '\''((a || (b && c)) != d) >= e'\'' -a 2,2,0,1,2
0
$ test-expr '\''((a || (b && c)) != d) >= e'\'' -a 2,2,1,2,1
1
$ test-expr '\''((a || (b && c)) != d) >= e'\'' -a 2,2,2,2,0
1
$ test-expr '\''((a || (b && c)) >= d) != e'\'' -a 0,0,0,1,1
1
$ test-expr '\''((a || (b && c)) >= d) != e'\'' -a 0,0,1,0,1
0
$ test-expr '\''((a || (b && c)) >= d) != e'\'' -a 0,0,1,2,2
1
$ test-expr '\''((a || (b && c)) >= d) != e'\'' -a 0,0,2,0,1
0
$ test-expr '\''((a || (b && c)) >= d) != e'\'' -a 0,1,0,0,1
0
$ test-expr '\''((a || (b && c)) >= d) != e'\'' -a 0,1,0,0,2
1
$ test-expr '\''((a || (b && c)) >= d) != e'\'' -a 0,1,0,1,0
0
$ test-expr '\''((a || (b && c)) >= d) != e'\'' -a 0,1,1,2,0
0
$ test-expr '\''((a || (b && c)) >= d) != e'\'' -a 0,1,2,2,2
1
$ test-expr '\''((a || (b && c)) >= d) != e'\'' -a 0,2,0,1,2
1
$ test-expr '\''((a || (b && c)) >= d) != e'\'' -a 0,2,1,2,2
1
$ test-expr '\''((a || (b && c)) >= d) != e'\'' -a 1,0,0,0,1
0
$ test-expr '\''((a || (b && c)) >= d) != e'\'' -a 1,0,0,2,1
1
$ test-expr '\''((a || (b && c)) >= d) != e'\'' -a 1,0,1,0,0
1
$ test-expr '\''((a || (b && c)) >= d) != e'\'' -a 1,0,1,1,1
0
$ test-expr '\''((a || (b && c)) >= d) != e'\'' -a 1,0,2,2,0
0
$ test-expr '\''((a || (b && c)) >= d) != e'\'' -a 1,0,2,2,2
1
$ test-expr '\''((a || (b && c)) >= d) != e'\'' -a 1,1,0,1,1
0
$ test-expr '\''((a || (b && c)) >= d) != e'\'' -a 1,1,0,1,2
1
$ test-expr '\''((a || (b && c)) >= d) != e'\'' -a 1,1,1,0,1
0
$ test-expr '\''((a || (b && c)) >= d) != e'\'' -a 1,1,2,1,2
1
$ test-expr '\''((a || (b && c)) >= d) != e'\'' -a 1,1,2,2,0
0
$ test-expr '\''((a || (b && c)) >= d) != e'\'' -a 1,2,2,0,1
0
$ test-expr '\''((a || (b && c)) >= d) != e'\'' -a 1,2,2,2,2
1
$ test-expr '\''((a || (b && c)) >= d) != e'\'' -a 2,0,0,0,0
1
$ test-expr '\''((a || (b && c)) >= d) != e'\'' -a 2,0,0,0,1
0
$ test-expr '\''((a || (b && c)) >= d) != e'\'' -a 2,0,0,1,2
1
$ test-expr '\''((a || (b && c)) >= d) != e'\'' -a 2,0,1,0,1
0
$ test-expr '\''((a || (b && c)) >= d) != e'\'' -a 2,0,1,1,0
1
$ test-expr '\''((a || (b && c)) >= d) != e'\'' -a 2,0,2,0,0
1
$ test-expr '\''((a || (b && c)) >= d) != e'\'' -a 2,1,2,1,0
1
$ test-expr '\''((a || (b && c)) >= d) != e'\'' -a 2,2,0,1,2
1
$ test-expr '\''((a || (b && c)) >= d) != e'\'' -a 2,2,1,1,0
1
$ test-expr '\''((a || (b && c)) >= d) != e'\'' -a 2,2,1,1,1
0
$ test-expr '\''((a || (b && c)) >= d) != e'\'' -a 2,2,1,2,0
0
$ test-expr '\''((a || (b >= c)) != d) && e'\'' -a 0,0,1,1,1
1
$ test-expr '\''((a || (b >= c)) != d) && e'\'' -a 0,1,0,1,1
0
$ test-expr '\''((a || (b >= c)) != d) && e'\'' -a 0,1,2,0,1
0
$ test-expr '\''((a || (b >= c)) != d) && e'\'' -a 0,1,2,2,2
1
$ test-expr '\''((a || (b >= c)) != d) && e'\'' -a 0,2,0,0,0
0
$ test-expr '\''((a || (b >= c)) != d) && e'\'' -a 0,2,0,1,0
0
$ test-expr '\''((a || (b >= c)) != d) && e'\'' -a 0,2,0,2,0
0
$ test-expr '\''((a || (b >= c)) != d) && e'\'' -a 1,0,0,2,1
1
$ test-expr '\''((a || (b >= c)) != d) && e'\'' -a 1,0,1,1,2
0
$ test-expr '\''((a || (b >= c)) != d) && e'\'' -a 1,0,2,2,2
1
$ test-expr '\''((a || (b >= c)) != d) && e'\'' -a 1,1,0,0,1
1
$ test-expr '\''((a || (b >= c)) != d) && e'\'' -a 1,1,1,2,2
1
$ test-expr '\''((a || (b >= c)) != d) && e'\'' -a 1,1,2,1,0
0
$ test-expr '\''((a || (b >= c)) != d) && e'\'' -a 1,1,2,1,1
0
$ test-expr '\''((a || (b >= c)) != d) && e'\'' -a 1,1,2,2,2
1
$ test-expr '\''((a || (b >= c)) != d) && e'\'' -a 1,2,1,1,0
0
$ test-expr '\''((a || (b >= c)) != d) && e'\'' -a 2,0,0,2,2
1
$ test-expr '\''((a || (b >= c)) != d) && e'\'' -a 2,0,1,0,0
0
$ test-expr '\''((a || (b >= c)) != d) && e'\'' -a 2,0,1,1,1
0
$ test-expr '\''((a || (b >= c)) != d) && e'\'' -a 2,0,2,1,2
0
$ test-expr '\''((a || (b >= c)) != d) && e'\'' -a 2,1,1,2,0
0
$ test-expr '\''((a || (b >= c)) && d) != e'\'' -a 0,0,0,1,1
0
$ test-expr '\''((a || (b >= c)) && d) != e'\'' -a 0,0,1,0,1
1
$ test-expr '\''((a || (b >= c)) && d) != e'\'' -a 0,0,2,0,1
1
$ test-expr '\''((a || (b >= c)) && d) != e'\'' -a 0,0,2,1,1
1
$ test-expr '\''((a || (b >= c)) && d) != e'\'' -a 0,1,0,0,0
0
$ test-expr '\''((a || (b >= c)) && d) != e'\'' -a 0,1,2,0,1
1
$ test-expr '\''((a || (b >= c)) && d) != e'\'' -a 0,2,0,1,2
1
$ test-expr '\''((a || (b >= c)) && d) != e'\'' -a 0,2,1,0,0
0
$ test-expr '\''((a || (b >= c)) && d) != e'\'' -a 0,2,1,1,2
1
$ test-expr '\''((a || (b >= c)) && d) != e'\'' -a 0,2,2,0,1
1
$ test-expr '\''((a || (b >= c)) && d) != e'\'' -a 0,2,2,2,0
1
$ test-expr '\''((a || (b >= c)) && d) != e'\'' -a 1,0,0,0,0
0
$ test-expr '\''((a || (b >= c)) && d) != e'\'' -a 1,0,0,1,1
0
$ test-expr '\''((a || (b >= c)) && d) != e'\'' -a 1,0,0,2,2
1
$ test-expr '\''((a || (b >= c)) && d) != e'\'' -a 1,0,1,0,2
1
$ test-expr '\''((a || (b >= c)) && d) != e'\'' -a 1,0,1,2,1
0
$ test-expr '\''((a || (b >= c)) && d) != e'\'' -a 1,0,2,1,0
1
$ test-expr '\''((a || (b >= c)) && d) != e'\'' -a 1,0,2,1,1
0
$ test-expr '\''((a || (b >= c)) && d) != e'\'' -a 1,1,1,0,1
1
$ test-expr '\''((a || (b >= c)) && d) != e'\'' -a 1,1,2,2,1
0
$ test-expr '\''((a || (b >= c)) && d) != e'\'' -a 1,2,0,0,0
0
$ test-expr '\''((a || (b >= c)) && d) != e'\'' -a 1,2,0,0,1
1
$ test-expr '\''((a || (b >= c)) && d) != e'\'' -a 1,2,0,2,1
0
$ test-expr '\''((a || (b >= c)) && d) != e'\'' -a 1,2,1,0,1
1
$ test-expr '\''((a || (b >= c)) && d) != e'\'' -a 1,2,2,0,2
1
$ test-expr '\''((a || (b >= c)) && d) != e'\'' -a 1,2,2,2,2
1
$ test-expr '\''((a || (b >= c)) && d) != e'\'' -a 2,0,1,2,2
1
$ test-expr '\''((a || (b >= c)) && d) != e'\'' -a 2,0,2,2,1
0
$ test-expr '\''((a || (b >= c)) && d) != e'\'' -a 2,1,0,0,1
1
$ test-expr '\''((a || (b >= c)) && d) != e'\'' -a 2,1,2,1,1
0
$ test-expr '\''((a || (b >= c)) && d) != e'\'' -a 2,1,2,1,2
1
$ test-expr '\''((a || (b >= c)) && d) != e'\'' -a 2,1,2,2,0
1
$ test-expr '\''((a || (b >= c)) && d) != e'\'' -a 2,1,2,2,1
0
$ test-expr '\''((a || (b >= c)) && d) != e'\'' -a 2,2,0,0,0
0
$ test-expr '\''((a || (b >= c)) && d) != e'\'' -a 2,2,0,1,2
1
$ test-expr '\''((a || (b >= c)) && d) != e'\'' -a 2,2,2,0,1
1
$ test-expr '\''((a || (b >= c)) && d) != e'\'' -a 2,2,2,2,2
1
$ test-expr '\''(((a != b) && c) >= d) || e'\'' -a 0,0,0,2,1
1
$ test-expr '\''(((a != b) && c) >= d) || e'\'' -a 0,0,1,0,1
1
$ test-expr '\''(((a != b) && c) >= d) || e'\'' -a 0,0,2,0,2
1
$ test-expr '\''(((a != b) && c) >= d) || e'\'' -a 0,1,0,0,1
1
$ test-expr '\''(((a != b) && c) >= d) || e'\'' -a 0,1,0,2,1
1
$ test-expr '\''(((a != b) && c) >= d) || e'\'' -a 0,1,1,1,0
1
$ test-expr '\''(((a != b) && c) >= d) || e'\'' -a 0,1,1,2,1
1
$ test-expr '\''(((a != b) && c) >= d) || e'\'' -a 0,2,2,1,0
1
$ test-expr '\''(((a != b) && c) >= d) || e'\'' -a 1,0,1,0,0
1
$ test-expr '\''(((a != b) && c) >= d) || e'\'' -a 1,0,1,0,1
1
$ test-expr '\''(((a != b) && c) >= d) || e'\'' -a 1,0,1,1,0
1
$ test-expr '\''(((a != b) && c) >= d) || e'\'' -a 1,0,2,0,0
1
$ test-expr '\''(((a != b) && c) >= d) || e'\'' -a 1,0,2,1,2
1
$ test-expr '\''(((a != b) && c) >= d) || e'\'' -a 1,1,0,0,0
1
$ test-expr '\''(((a != b) && c) >= d) || e'\'' -a 1,1,0,0,2
1
$ test-expr '\''(((a != b) && c) >= d) || e'\'' -a 1,1,0,2,1
1
$ test-expr '\''(((a != b) && c) >= d) || e'\'' -a 1,1,0,2,2
1
$ test-expr '\''(((a != b) && c) >= d) || e'\'' -a 1,1,2,1,0
0
$ test-expr '\''(((a != b) && c) >= d) || e'\'' -a 1,2,0,1,0
0
$ test-expr '\''(((a != b) && c) >= d) || e'\'' -a 1,2,0,2,1
1
$ test-expr '\''(((a != b) && c) >= d) || e'\'' -a 1,2,1,0,2
1
$ test-expr '\''(((a != b) && c) >= d) || e'\'' -a 2,0,0,0,1
1
$ test-expr '\''(((a != b) && c) >= d) || e'\'' -a 2,0,0,2,2
1
$ test-expr '\''(((a != b) && c) >= d) || e'\'' -a 2,0,1,1,2
1
$ test-expr '\''(((a != b) && c) >= d) || e'\'' -a 2,0,1,2,1
1
$ test-expr '\''(((a != b) && c) >= d) || e'\'' -a 2,0,2,0,2
1
$ test-expr '\''(((a != b) && c) >= d) || e'\'' -a 2,0,2,2,2
1
$ test-expr '\''(((a != b) && c) >= d) || e'\'' -a 2,1,0,2,0
0
$ test-expr '\''(((a != b) && c) >= d) || e'\'' -a 2,1,2,0,0
1
$ test-expr '\''(((a != b) && c) >= d) || e'\'' -a 2,1,2,1,1
1
$ test-expr '\''(((a != b) && c) >= d) || e'\'' -a 2,1,2,2,2
1
$ test-expr '\''(((a != b) && c) >= d) || e'\'' -a 2,2,1,0,0
1
$ test-expr '\''(((a != b) && c) >= d) || e'\'' -a 2,2,1,2,0
0
$ test-expr '\''(((a != b) && c) || d) >= e'\'' -a 0,0,0,1,2
0
$ test-expr '\''(((a != b) && c) || d) >= e'\'' -a 0,0,0,2,0
1
$ test-expr '\''(((a != b) && c) || d) >= e'\'' -a 0,0,1,0,1
0
$ test-expr '\''(((a != b) && c) || d) >= e'\'' -a 0,0,1,0,2
0
$ test-expr '\''(((a != b) && c) || d) >= e'\'' -a 0,0,1,1,0
1
$ test-expr '\''(((a != b) && c) || d) >= e'\'' -a 0,1,2,0,0
1
$ test-expr '\''(((a != b) && c) || d) >= e'\'' -a 0,1,2,2,0
1
$ test-expr '\''(((a != b) && c) || d) >= e'\'' -a 0,2,0,0,2
0
$ test-expr '\''(((a != b) && c) || d) >= e'\'' -a 0,2,1,0,0
1
$ test-expr '\''(((a != b) && c) || d) >= e'\'' -a 0,2,1,1,0
1
$ test-expr '\''(((a != b) && c) || d) >= e'\'' -a 1,0,0,1,0
1
$ test-expr '\''(((a != b) && c) || d) >= e'\'' -a 1,0,1,1,1
1
$ test-expr '\''(((a != b) && c) || d) >= e'\'' -a 1,0,1,2,0
1
$ test-expr '\''(((a != b) && c) || d) >= e'\'' -a 1,0,2,1,2
0
$ test-expr '\''(((a != b) && c) || d) >= e'\'' -a 1,1,0,0,2
0
$ test-expr '\''(((a != b) && c) || d) >= e'\'' -a 1,1,0,1,0
1
$ test-expr '\''(((a != b) && c) || d) >= e'\'' -a 1,1,0,1,2
0
$ test-expr '\''(((a != b) && c) || d) >= e'\'' -a 1,1,0,2,1
1
$ test-expr '\''(((a != b) && c) || d) >= e'\'' -a 1,1,1,0,2
0
$ test-expr '\''(((a != b) && c) || d) >= e'\'' -a 1,1,1,2,1
1
$ test-expr '\''(((a != b) && c) || d) >= e'\'' -a 1,1,2,2,1
1
$ test-expr '\''(((a != b) && c) || d) >= e'\'' -a 1,1,2,2,2
0
$ test-expr '\''(((a != b) && c) || d) >= e'\'' -a 1,2,1,0,2
0
$ test-expr '\''(((a != b) && c) || d) >= e'\'' -a 1,2,2,0,2
0
$ test-expr '\''(((a != b) && c) || d) >= e'\'' -a 1,2,2,2,1
1
$ test-expr '\''(((a != b) && c) || d) >= e'\'' -a 2,0,0,0,0
1
$ test-expr '\''(((a != b) && c) || d) >= e'\'' -a 2,0,2,0,1
1
$ test-expr '\''(((a != b) && c) || d) >= e'\'' -a 2,0,2,1,0
1
$ test-expr '\''(((a != b) && c) || d) >= e'\'' -a 2,1,0,0,2
0
$ test-expr '\''(((a != b) && c) || d) >= e'\'' -a 2,1,0,1,1
1
$ test-expr '\''(((a != b) && c) || d) >= e'\'' -a 2,1,1,1,2
0
$ test-expr '\''(((a != b) && c) || d) >= e'\'' -a 2,1,1,2,0
1
$ test-expr '\''(((a != b) && c) || d) >= e'\'' -a 2,1,2,1,1
1
$ test-expr '\''(((a != b) && c) || d) >= e'\'' -a 2,1,2,2,1
1
$ test-expr '\''(((a != b) && c) || d) >= e'\'' -a 2,2,0,0,2
0
$ test-expr '\''(((a != b) && c) || d) >= e'\'' -a 2,2,0,2,2
0
$ test-expr '\''(((a != b) && c) || d) >= e'\'' -a 2,2,1,1,0
1
$ test-expr '\''(((a != b) && c) || d) >= e'\'' -a 2,2,2,0,2
0
$ test-expr '\''(((a != b) && c) || d) >= e'\'' -a 2,2,2,2,2
0
$ test-expr '\''(((a != b) >= c) && d) || e'\'' -a 0,0,0,2,0
1
$ test-expr '\''(((a != b) >= c) && d) || e'\'' -a 0,0,0,2,1
1
$ test-expr '\''(((a != b) >= c) && d) || e'\'' -a 0,0,2,1,2
1
$ test-expr '\''(((a != b) >= c) && d) || e'\'' -a 0,1,0,0,1
1
$ test-expr '\''(((a != b) >= c) && d) || e'\'' -a 0,1,1,2,1
1
$ test-expr '\''(((a != b) >= c) && d) || e'\'' -a 0,2,0,1,0
1
$ test-expr '\''(((a != b) >= c) && d) || e'\'' -a 0,2,2,0,1
1
$ test-expr '\''(((a != b) >= c) && d) || e'\'' -a 0,2,2,1,0
0
$ test-expr '\''(((a != b) >= c) && d) || e'\'' -a 0,2,2,2,1
1
$ test-expr '\''(((a != b) >= c) && d) || e'\'' -a 1,0,0,0,1
1
$ test-expr '\''(((a != b) >= c) && d) || e'\'' -a 1,0,0,2,1
1
$ test-expr '\''(((a != b) >= c) && d) || e'\'' -a 1,0,0,2,2
1
$ test-expr '\''(((a != b) >= c) && d) || e'\'' -a 1,0,1,0,2
1
$ test-expr '\''(((a != b) >= c) && d) || e'\'' -a 1,0,1,1,1
1
$ test-expr '\''(((a != b) >= c) && d) || e'\'' -a 1,1,1,1,2
1
$ test-expr '\''(((a != b) >= c) && d) || e'\'' -a 1,1,1,2,2
1
$ test-expr '\''(((a != b) >= c) && d) || e'\'' -a 1,1,2,0,2
1
$ test-expr '\''(((a != b) >= c) && d) || e'\'' -a 1,2,0,2,0
1
$ test-expr '\''(((a != b) >= c) && d) || e'\'' -a 1,2,1,2,1
1
$ test-expr '\''(((a != b) >= c) && d) || e'\'' -a 2,0,0,0,2
1
$ test-expr '\''(((a != b) >= c) && d) || e'\'' -a 2,0,0,1,1
1
$ test-expr '\''(((a != b) >= c) && d) || e'\'' -a 2,0,1,0,1
1
$ test-expr '\''(((a != b) >= c) && d) || e'\'' -a 2,0,1,0,2
1
$ test-expr '\''(((a != b) >= c) && d) || e'\'' -a 2,0,2,0,1
1
$ test-expr '\''(((a != b) >= c) && d) || e'\'' -a 2,1,0,1,0
1
$ test-expr '\''(((a != b) >= c) && d) || e'\'' -a 2,1,0,1,1
1
$ test-expr '\''(((a != b) >= c) && d) || e'\'' -a 2,1,0,1,2
1
$ test-expr '\''(((a != b) >= c) && d) || e'\'' -a 2,1,0,2,0
1
$ test-expr '\''(((a != b) >= c) && d) || e'\'' -a 2,2,0,1,2
1
$ test-expr '\''(((a != b) >= c) && d) || e'\'' -a 2,2,0,2,2
1
$ test-expr '\''(((a != b) >= c) && d) || e'\'' -a 2,2,1,0,1
1
$ test-expr '\''(((a != b) >= c) && d) || e'\'' -a 2,2,1,0,2
1
$ test-expr '\''(((a != b) >= c) && d) || e'\'' -a 2,2,2,0,2
1
$ test-expr '\''(((a != b) >= c) || d) && e'\'' -a 0,0,0,2,2
1
$ test-expr '\''(((a != b) >= c) || d) && e'\'' -a 0,0,2,0,1
0
$ test-expr '\''(((a != b) >= c) || d) && e'\'' -a 0,1,0,1,0
0
$ test-expr '\''(((a != b) >= c) || d) && e'\'' -a 0,1,2,0,0
0
$ test-expr '\''(((a != b) >= c) || d) && e'\'' -a 0,1,2,1,2
1
$ test-expr '\''(((a != b) >= c) || d) && e'\'' -a 0,2,1,0,2
1
$ test-expr '\''(((a != b) >= c) || d) && e'\'' -a 0,2,1,1,0
0
$ test-expr '\''(((a != b) >= c) || d) && e'\'' -a 0,2,2,0,0
0
$ test-expr '\''(((a != b) >= c) || d) && e'\'' -a 0,2,2,1,2
1
$ test-expr '\''(((a != b) >= c) || d) && e'\'' -a 1,0,0,0,1
1
$ test-expr '\''(((a != b) >= c) || d) && e'\'' -a 1,0,2,2,2
1
$ test-expr '\''(((a != b) >= c) || d) && e'\'' -a 1,1,0,0,2
1
$ test-expr '\''(((a != b) >= c) || d) && e'\'' -a 1,1,1,0,2
0
$ test-expr '\''(((a != b) >= c) || d) && e'\'' -a 1,1,2,0,1
0
$ test-expr '\''(((a != b) >= c) || d) && e'\'' -a 1,2,1,0,1
1
$ test-expr '\''(((a != b) >= c) || d) && e'\'' -a 2,0,1,0,2
1
$ test-expr '\''(((a != b) >= c) || d) && e'\'' -a 2,0,1,1,2
1
$ test-expr '\''(((a != b) >= c) || d) && e'\'' -a 2,0,1,2,0
0
$ test-expr '\''(((a != b) >= c) || d) && e'\'' -a 2,0,2,0,2
0
$ test-expr '\''(((a != b) >= c) || d) && e'\'' -a 2,1,0,2,0
0
$ test-expr '\''(((a != b) >= c) || d) && e'\'' -a 2,1,1,1,2
1
$ test-expr '\''(((a != b) >= c) || d) && e'\'' -a 2,1,1,2,2
1
$ test-expr '\''(((a != b) >= c) || d) && e'\'' -a 2,1,2,2,2
1
$ test-expr '\''(((a != b) >= c) || d) && e'\'' -a 2,2,0,1,0
0
$ test-expr '\''(((a != b) >= c) || d) && e'\'' -a 2,2,2,0,1
0
$ test-expr '\''(((a != b) >= c) || d) && e'\'' -a 2,2,2,0,2
0
$ test-expr '\''(((a != b) || c) && d) >= e'\'' -a 0,0,0,2,0
1
$ test-expr '\''(((a != b) || c) && d) >= e'\'' -a 0,0,1,1,1
1
$ test-expr '\''(((a != b) || c) && d) >= e'\'' -a 0,0,2,0,1
0
$ test-expr '\''(((a != b) || c) && d) >= e'\'' -a 0,0,2,2,0
1
$ test-expr '\''(((a != b) || c) && d) >= e'\'' -a 0,1,0,0,2
0
$ test-expr '\''(((a != b) || c) && d) >= e'\'' -a 0,1,0,1,2
0
$ test-expr '\''(((a != b) || c) && d) >= e'\'' -a 0,1,1,0,0
1
$ test-expr '\''(((a != b) || c) && d) >= e'\'' -a 0,1,1,0,2
0
$ test-expr '\''(((a != b) || c) && d) >= e'\'' -a 0,1,1,2,1
1
$ test-expr '\''(((a != b) || c) && d) >= e'\'' -a 0,1,2,1,1
1
$ test-expr '\''(((a != b) || c) && d) >= e'\'' -a 0,2,0,0,2
0
$ test-expr '\''(((a != b) || c) && d) >= e'\'' -a 0,2,0,1,0
1
$ test-expr '\''(((a != b) || c) && d) >= e'\'' -a 0,2,1,0,2
0
$ test-expr '\''(((a != b) || c) && d) >= e'\'' -a 0,2,1,1,1
1
$ test-expr '\''(((a != b) || c) && d) >= e'\'' -a 0,2,2,0,0
1
$ test-expr '\''(((a != b) || c) && d) >= e'\'' -a 0,2,2,1,1
1
$ test-expr '\''(((a != b) || c) && d) >= e'\'' -a 1,0,0,0,0
1
$ test-expr '\''(((a != b) || c) && d) >= e'\'' -a 1,0,0,1,0
1
$ test-expr '\''(((a != b) || c) && d) >= e'\'' -a 1,0,0,2,0
1
$ test-expr '\''(((a != b) || c) && d) >= e'\'' -a 1,0,1,1,2
0
$ test-expr '\''(((a != b) || c) && d) >= e'\'' -a 1,0,1,2,2
0
$ test-expr '\''(((a != b) || c) && d) >= e'\'' -a 1,0,2,0,2
0
$ test-expr '\''(((a != b) || c) && d) >= e'\'' -a 1,0,2,2,0
1
$ test-expr '\''(((a != b) || c) && d) >= e'\'' -a 1,1,1,1,0
1
$ test-expr '\''(((a != b) || c) && d) >= e'\'' -a 1,1,1,1,1
1
$ test-expr '\''(((a != b) || c) && d) >= e'\'' -a 1,1,2,0,2
0
$ test-expr '\''(((a != b) || c) && d) >= e'\'' -a 1,1,2,2,2
0
$ test-expr '\''(((a != b) || c) && d) >= e'\'' -a 1,2,0,1,0
1
$ test-expr '\''(((a != b) || c) && d) >= e'\'' -a 1,2,1,1,0
1
$ test-expr '\''(((a != b) || c) && d) >= e'\'' -a 1,2,2,2,1
1
$ test-expr '\''(((a != b) || c) && d) >= e'\'' -a 2,0,1,2,0
1
$ test-expr '\''(((a != b) || c) && d) >= e'\'' -a 2,0,2,0,2
0
$ test-expr '\''(((a != b) || c) && d) >= e'\'' -a 2,1,0,0,2
0
$ test-expr '\''(((a != b) || c) && d) >= e'\'' -a 2,1,1,0,0
1
$ test-expr '\''(((a != b) || c) && d) >= e'\'' -a 2,1,2,1,2
0
$ test-expr '\''(((a != b) || c) && d) >= e'\'' -a 2,2,0,0,0
1
$ test-expr '\''(((a != b) || c) && d) >= e'\'' -a 2,2,0,0,2
0
$ test-expr '\''(((a != b) || c) && d) >= e'\'' -a 2,2,0,1,2
0
$ test-expr '\''(((a != b) || c) && d) >= e'\'' -a 2,2,1,1,2
0
$ test-expr '\''(((a != b) || c) && d) >= e'\'' -a 2,2,1,2,0
1
$ test-expr '\''(((a != b) || c) >= d) && e'\'' -a 0,0,0,2,0
0
$ test-expr '\''(((a != b) || c) >= d) && e'\'' -a 0,0,0,2,1
0
$ test-expr '\''(((a != b) || c) >= d) && e'\'' -a 0,1,0,0,0
0
$ test-expr '\''(((a != b) || c) >= d) && e'\'' -a 0,1,0,0,1
1
$ test-expr '\''(((a != b) || c) >= d) && e'\'' -a 0,1,1,1,0
0
$ test-expr '\''(((a != b) || c) >= d) && e'\'' -a 0,1,1,1,2
1
$ test-expr '\''(((a != b) || c) >= d) && e'\'' -a 0,1,1,2,2
0
$ test-expr '\''(((a != b) || c) >= d) && e'\'' -a 0,1,2,0,2
1
$ test-expr '\''(((a != b) || c) >= d) && e'\'' -a 0,1,2,1,1
1
$ test-expr '\''(((a != b) || c) >= d) && e'\'' -a 0,1,2,2,1
0
$ test-expr '\''(((a != b) || c) >= d) && e'\'' -a 1,0,1,1,1
1
$ test-expr '\''(((a != b) || c) >= d) && e'\'' -a 1,0,2,0,2
1
$ test-expr '\''(((a != b) || c) >= d) && e'\'' -a 1,0,2,1,1
1
$ test-expr '\''(((a != b) || c) >= d) && e'\'' -a 1,1,1,0,0
0
$ test-expr '\''(((a != b) || c) >= d) && e'\'' -a 1,1,1,1,2
1
$ test-expr '\''(((a != b) || c) >= d) && e'\'' -a 1,1,1,2,2
0
$ test-expr '\''(((a != b) || c) >= d) && e'\'' -a 1,1,2,1,2
1
$ test-expr '\''(((a != b) || c) >= d) && e'\'' -a 1,1,2,2,0
0
$ test-expr '\''(((a != b) || c) >= d) && e'\'' -a 1,2,2,0,2
1
$ test-expr '\''(((a != b) || c) >= d) && e'\'' -a 1,2,2,1,0
0
$ test-expr '\''(((a != b) || c) >= d) && e'\'' -a 1,2,2,2,1
0
$ test-expr '\''(((a != b) || c) >= d) && e'\'' -a 2,0,0,1,0
0
$ test-expr '\''(((a != b) || c) >= d) && e'\'' -a 2,0,1,0,2
1
$ test-expr '\''(((a != b) || c) >= d) && e'\'' -a 2,0,2,2,0
0
$ test-expr '\''(((a != b) || c) >= d) && e'\'' -a 2,1,0,1,2
1
$ test-expr '\''(((a != b) || c) >= d) && e'\'' -a 2,1,1,1,1
1
$ test-expr '\''(((a != b) || c) >= d) && e'\'' -a 2,1,2,1,2
1
$ test-expr '\''(((a != b) || c) >= d) && e'\'' -a 2,1,2,2,0
0
$ test-expr '\''(((a != b) || c) >= d) && e'\'' -a 2,2,1,1,0
0
$ test-expr '\''(((a != b) || c) >= d) && e'\'' -a 2,2,2,0,1
1
$ test-expr '\''(((a && b) != c) >= d) || e'\'' -a 0,0,0,1,2
1
$ test-expr '\''(((a && b) != c) >= d) || e'\'' -a 0,0,1,1,0
1
$ test-expr '\''(((a && b) != c) >= d) || e'\'' -a 0,0,2,0,1
1
$ test-expr '\''(((a && b) != c) >= d) || e'\'' -a 0,1,0,2,2
1
$ test-expr '\''(((a && b) != c) >= d) || e'\'' -a 0,1,1,0,1
1
$ test-expr '\''(((a && b) != c) >= d) || e'\'' -a 0,1,2,1,1
1
$ test-expr '\''(((a && b) != c) >= d) || e'\'' -a 0,1,2,1,2
1
$ test-expr '\''(((a && b) != c) >= d) || e'\'' -a 0,2,2,0,0
1
$ test-expr '\''(((a && b) != c) >= d) || e'\'' -a 1,0,1,2,1
1
$ test-expr '\''(((a && b) != c) >= d) || e'\'' -a 1,1,0,0,0
1
$ test-expr '\''(((a && b) != c) >= d) || e'\'' -a 1,1,1,1,0
0
$ test-expr '\''(((a && b) != c) >= d) || e'\'' -a 1,1,2,1,1
1
$ test-expr '\''(((a && b) != c) >= d) || e'\'' -a 1,2,1,0,2
1
$ test-expr '\''(((a && b) != c) >= d) || e'\'' -a 1,2,1,1,1
1
$ test-expr '\''(((a && b) != c) >= d) || e'\'' -a 1,2,1,2,0
0
$ test-expr '\''(((a && b) != c) >= d) || e'\'' -a 2,0,1,0,1
1
$ test-expr '\''(((a && b) != c) >= d) || e'\'' -a 2,0,2,1,0
1
$ test-expr '\''(((a && b) != c) >= d) || e'\'' -a 2,0,2,2,0
0
$ test-expr '\''(((a && b) != c) >= d) || e'\'' -a 2,1,0,0,1
1
$ test-expr '\''(((a && b) != c) >= d) || e'\'' -a 2,1,0,0,2
1
$ test-expr '\''(((a && b) != c) >= d) || e'\'' -a 2,1,1,0,0
1
$ test-expr '\''(((a && b) != c) >= d) || e'\'' -a 2,1,2,1,0
1
$ test-expr '\''(((a && b) != c) >= d) || e'\'' -a 2,2,0,0,2
1
$ test-expr '\''(((a && b) != c) >= d) || e'\'' -a 2,2,1,1,2
1
$ test-expr '\''(((a && b) != c) >= d) || e'\'' -a 2,2,1,2,1
1
$ test-expr '\''(((a && b) != c) || d) >= e'\'' -a 0,0,1,1,2
0
$ test-expr '\''(((a && b) != c) || d) >= e'\'' -a 0,0,2,2,0
1
$ test-expr '\''(((a && b) != c) || d) >= e'\'' -a 0,1,0,1,1
1
$ test-expr '\''(((a && b) != c) || d) >= e'\'' -a 0,1,0,2,1
1
$ test-expr '\''(((a && b) != c) || d) >= e'\'' -a 0,1,1,0,0
1
$ test-expr '\''(((a && b) != c) || d) >= e'\'' -a 0,1,1,1,0
1
$ test-expr '\''(((a && b) != c) || d) >= e'\'' -a 0,1,2,0,0
1
$ test-expr '\''(((a && b) != c) || d) >= e'\'' -a 0,2,0,2,0
1
$ test-expr '\''(((a && b) != c) || d) >= e'\'' -a 0,2,2,0,1
1
$ test-expr '\''(((a && b) != c) || d) >= e'\'' -a 0,2,2,1,0
1
$ test-expr '\''(((a && b) != c) || d) >= e'\'' -a 1,0,0,1,2
0
$ test-expr '\''(((a && b) != c) || d) >= e'\'' -a 1,0,1,2,0
1
$ test-expr '\''(((a && b) != c) || d) >= e'\'' -a 1,0,2,2,1
1
$ test-expr '\''(((a && b) != c) || d) >= e'\'' -a 1,0,2,2,2
0
$ test-expr '\''(((a && b) != c) || d) >= e'\'' -a 1,1,1,2,1
1
$ test-expr '\''(((a && b) != c) || d) >= e'\'' -a 1,1,2,2,1
1
$ test-expr '\''(((a && b) != c) || d) >= e'\'' -a 1,1,2,2,2
0
$ test-expr '\''(((a && b) != c) || d) >= e'\'' -a 1,2,0,0,1
1
$ test-expr '\''(((a && b) != c) || d) >= e'\'' -a 1,2,0,2,2
0
$ test-expr '\''(((a && b) != c) || d) >= e'\'' -a 1,2,2,0,1
1
$ test-expr '\''(((a && b) != c) || d) >= e'\'' -a 2,0,1,0,2
0
$ test-expr '\''(((a && b) != c) || d) >= e'\'' -a 2,1,0,2,2
0
$ test-expr '\''(((a && b) != c) || d) >= e'\'' -a 2,1,1,1,0
1
$ test-expr '\''(((a && b) != c) || d) >= e'\'' -a 2,1,2,0,2
0
$ test-expr '\''(((a && b) != c) || d) >= e'\'' -a 2,2,2,2,1
1
$ test-expr '\''(((a && b) >= c) != d) || e'\'' -a 0,0,0,1,0
0
$ test-expr '\''(((a && b) >= c) != d) || e'\'' -a 0,0,0,2,0
1
$ test-expr '\''(((a && b) >= c) != d) || e'\'' -a 0,0,1,1,0
1
$ test-expr '\''(((a && b) >= c) != d) || e'\'' -a 0,0,1,2,1
1
$ test-expr '\''(((a && b) >= c) != d) || e'\'' -a 0,1,0,1,0
0
$ test-expr '\''(((a && b) >= c) != d) || e'\'' -a 0,1,1,0,2
1
$ test-expr '\''(((a && b) >= c) != d) || e'\'' -a 0,1,1,2,0
1
$ test-expr '\''(((a && b) >= c) != d) || e'\'' -a 0,1,1,2,1
1
$ test-expr '\''(((a && b) >= c) != d) || e'\'' -a 0,1,1,2,2
1
$ test-expr '\''(((a && b) >= c) != d) || e'\'' -a 0,1,2,0,1
1
$ test-expr '\''(((a && b) >= c) != d) || e'\'' -a 0,1,2,1,1
1
$ test-expr '\''(((a && b) >= c) != d) || e'\'' -a 0,1,2,2,0
1
$ test-expr '\''(((a && b) >= c) != d) || e'\'' -a 0,2,0,0,2
1
$ test-expr '\''(((a && b) >= c) != d) || e'\'' -a 0,2,0,1,0
0
$ test-expr '\''(((a && b) >= c) != d) || e'\'' -a 0,2,1,2,2
1
$ test-expr '\''(((a && b) >= c) != d) || e'\'' -a 0,2,2,2,0
1
$ test-expr '\''(((a && b) >= c) != d) || e'\'' -a 1,0,0,0,0
1
$ test-expr '\''(((a && b) >= c) != d) || e'\'' -a 1,0,0,1,2
1
$ test-expr '\''(((a && b) >= c) != d) || e'\'' -a 1,0,2,0,1
1
$ test-expr '\''(((a && b) >= c) != d) || e'\'' -a 1,1,0,1,0
0
$ test-expr '\''(((a && b) >= c) != d) || e'\'' -a 1,1,1,0,1
1
$ test-expr '\''(((a && b) >= c) != d) || e'\'' -a 1,1,2,0,0
0
$ test-expr '\''(((a && b) >= c) != d) || e'\'' -a 1,2,0,0,0
1
$ test-expr '\''(((a && b) >= c) != d) || e'\'' -a 1,2,1,2,0
1
$ test-expr '\''(((a && b) >= c) != d) || e'\'' -a 1,2,2,0,1
1
$ test-expr '\''(((a && b) >= c) != d) || e'\'' -a 1,2,2,1,0
1
$ test-expr '\''(((a && b) >= c) != d) || e'\'' -a 1,2,2,2,1
1
$ test-expr '\''(((a && b) >= c) != d) || e'\'' -a 2,0,0,2,1
1
$ test-expr '\''(((a && b) >= c) != d) || e'\'' -a 2,0,1,1,0
1
$ test-expr '\''(((a && b) >= c) != d) || e'\'' -a 2,0,2,1,1
1
$ test-expr '\''(((a && b) >= c) != d) || e'\'' -a 2,1,0,0,1
1
$ test-expr '\''(((a && b) >= c) != d) || e'\'' -a 2,1,0,1,1
1
$ test-expr '\''(((a && b) >= c) != d) || e'\'' -a 2,1,1,1,0
0
$ test-expr '\''(((a && b) >= c) != d) || e'\'' -a 2,1,1,2,1
1
$ test-expr '\''(((a && b) >= c) != d) || e'\'' -a 2,1,1,2,2
1
$ test-expr '\''(((a && b) >= c) != d) || e'\'' -a 2,1,2,2,1
1
$ test-expr '\''(((a && b) >= c) != d) || e'\'' -a 2,2,0,2,1
1
$ test-expr '\''(((a && b) >= c) != d) || e'\'' -a 2,2,1,0,2
1
$ test-expr '\''(((a && b) >= c) != d) || e'\'' -a 2,2,2,1,1
1
$ test-expr '\''(((a && b) >= c) || d) != e'\'' -a 0,0,0,0,0
1
$ test-expr '\''(((a && b) >= c) || d) != e'\'' -a 0,0,1,2,2
1
$ test-expr '\''(((a && b) >= c) || d) != e'\'' -a 0,1,0,0,2
1
$ test-expr '\''(((a && b) >= c) || d) != e'\'' -a 0,1,0,1,2
1
$ test-expr '\''(((a && b) >= c) || d) != e'\'' -a 0,1,2,0,0
0
$ test-expr '\''(((a && b) >= c) || d) != e'\'' -a 0,1,2,0,2
1
$ test-expr '\''(((a && b) >= c) || d) != e'\'' -a 0,2,0,2,0
1
$ test-expr '\''(((a && b) >= c) || d) != e'\'' -a 0,2,1,1,1
0
$ test-expr '\''(((a && b) >= c) || d) != e'\'' -a 0,2,2,1,0
1
$ test-expr '\''(((a && b) >= c) || d) != e'\'' -a 1,0,0,0,1
0
$ test-expr '\''(((a && b) >= c) || d) != e'\'' -a 1,0,0,1,0
1
$ test-expr '\''(((a && b) >= c) || d) != e'\'' -a 1,0,0,1,2
1
$ test-expr '\''(((a && b) >= c) || d) != e'\'' -a 1,0,1,0,1
1
$ test-expr '\''(((a && b) >= c) || d) != e'\'' -a 1,0,2,0,2
1
$ test-expr '\''(((a && b) >= c) || d) != e'\'' -a 1,0,2,1,1
0
$ test-expr '\''(((a && b) >= c) || d) != e'\'' -a 1,0,2,1,2
1
$ test-expr '\''(((a && b) >= c) || d) != e'\'' -a 1,1,0,1,1
0
$ test-expr '\''(((a && b) >= c) || d) != e'\'' -a 1,1,1,0,0
1
$ test-expr '\''(((a && b) >= c) || d) != e'\'' -a 1,1,1,2,1
0
$ test-expr '\''(((a && b) >= c) || d) != e'\'' -a 1,1,2,0,2
1
$ test-expr '\''(((a && b) >= c) || d) != e'\'' -a 1,2,1,1,2
1
$ test-expr '\''(((a && b) >= c) || d) != e'\'' -a 1,2,2,2,2
1
$ test-expr '\''(((a && b) >= c) || d) != e'\'' -a 2,0,0,2,2
1
$ test-expr '\''(((a && b) >= c) || d) != e'\'' -a 2,0,1,0,1
1
$ test-expr '\''(((a && b) >= c) || d) != e'\'' -a 2,0,1,1,2
1
$ test-expr '\''(((a && b) >= c) || d) != e'\'' -a 2,0,1,2,0
1
$ test-expr '\''(((a && b) >= c) || d) != e'\'' -a 2,0,2,1,2
1
$ test-expr '\''(((a && b) >= c) || d) != e'\'' -a 2,1,0,0,0
1
$ test-expr '\''(((a && b) >= c) || d) != e'\'' -a 2,1,0,1,1
0
$ test-expr '\''(((a && b) >= c) || d) != e'\'' -a 2,1,2,2,1
0
$ test-expr '\''(((a && b) >= c) || d) != e'\'' -a 2,1,2,2,2
1
$ test-expr '\''(((a && b) >= c) || d) != e'\'' -a 2,2,0,1,0
1
$ test-expr '\''(((a && b) >= c) || d) != e'\'' -a 2,2,0,1,1
0
$ test-expr '\''(((a && b) || c) != d) >= e'\'' -a 0,0,0,2,0
1
$ test-expr '\''(((a && b) || c) != d) >= e'\'' -a 0,0,1,1,1
0
$ test-expr '\''(((a && b) || c) != d) >= e'\'' -a 0,0,2,1,2
0
$ test-expr '\''(((a && b) || c) != d) >= e'\'' -a 0,2,0,1,1
1
$ test-expr '\''(((a && b) || c) != d) >= e'\'' -a 0,2,0,2,0
1
$ test-expr '\''(((a && b) || c) != d) >= e'\'' -a 0,2,1,2,0
1
$ test-expr '\''(((a && b) || c) != d) >= e'\'' -a 1,1,2,1,0
1
$ test-expr '\''(((a && b) || c) != d) >= e'\'' -a 1,2,0,2,0
1
$ test-expr '\''(((a && b) || c) != d) >= e'\'' -a 1,2,1,0,0
1
$ test-expr '\''(((a && b) || c) != d) >= e'\'' -a 1,2,1,0,2
0
$ test-expr '\''(((a && b) || c) != d) >= e'\'' -a 1,2,1,1,2
0
$ test-expr '\''(((a && b) || c) != d) >= e'\'' -a 1,2,1,2,1
1
$ test-expr '\''(((a && b) || c) != d) >= e'\'' -a 1,2,2,1,2
0
$ test-expr '\''(((a && b) || c) != d) >= e'\'' -a 1,2,2,2,0
1
$ test-expr '\''(((a && b) || c) != d) >= e'\'' -a 2,0,1,1,2
0
$ test-expr '\''(((a && b) || c) != d) >= e'\'' -a 2,0,1,2,1
1
$ test-expr '\''(((a && b) || c) != d) >= e'\'' -a 2,0,2,2,2
0
$ test-expr '\''(((a && b) || c) != d) >= e'\'' -a 2,1,0,1,0
1
$ test-expr '\''(((a && b) || c) != d) >= e'\'' -a 2,1,1,1,1
0
$ test-expr '\''(((a && b) || c) != d) >= e'\'' -a 2,1,1,1,2
0
$ test-expr '\''(((a && b) || c) != d) >= e'\'' -a 2,1,1,2,2
0
$ test-expr '\''(((a && b) || c) != d) >= e'\'' -a 2,2,0,0,0
1
$ test-expr '\''(((a && b) || c) != d) >= e'\'' -a 2,2,0,0,2
0
$ test-expr '\''(((a && b) || c) != d) >= e'\'' -a 2,2,0,2,2
0
$ test-expr '\''(((a && b) || c) != d) >= e'\'' -a 2,2,1,0,1
1
$ test-expr '\''(((a && b) || c) != d) >= e'\'' -a 2,2,1,1,1
0
$ test-expr '\''(((a && b) || c) >= d) != e'\'' -a 0,0,1,1,0
1
$ test-expr '\''(((a && b) || c) >= d) != e'\'' -a 0,0,1,2,2
1
$ test-expr '\''(((a && b) || c) >= d) != e'\'' -a 0,1,0,1,0
0
$ test-expr '\''(((a && b) || c) >= d) != e'\'' -a 0,1,2,2,2
1
$ test-expr '\''(((a && b) || c) >= d) != e'\'' -a 0,2,2,2,2
1
$ test-expr '\''(((a && b) || c) >= d) != e'\'' -a 1,0,0,2,2
1
$ test-expr '\''(((a && b) || c) >= d) != e'\'' -a 1,0,2,1,0
1
$ test-expr '\''(((a && b) || c) >= d) != e'\'' -a 1,0,2,2,2
1
$ test-expr '\''(((a && b) || c) >= d) != e'\'' -a 1,1,0,0,1
0
$ test-expr '\''(((a && b) || c) >= d) != e'\'' -a 1,1,0,0,2
1
$ test-expr '\''(((a && b) || c) >= d) != e'\'' -a 1,1,1,1,1
0
$ test-expr '\''(((a && b) || c) >= d) != e'\'' -a 1,1,1,2,1
1
$ test-expr '\''(((a && b) || c) >= d) != e'\'' -a 1,1,1,2,2
1
$ test-expr '\''(((a && b) || c) >= d) != e'\'' -a 1,1,2,1,0
1
$ test-expr '\''(((a && b) || c) >= d) != e'\'' -a 1,2,1,1,1
0
$ test-expr '\''(((a && b) || c) >= d) != e'\'' -a 1,2,1,1,2
1
$ test-expr '\''(((a && b) || c) >= d) != e'\'' -a 1,2,2,1,1
0
$ test-expr '\''(((a && b) || c) >= d) != e'\'' -a 1,2,2,1,2
1
$ test-expr '\''(((a && b) || c) >= d) != e'\'' -a 1,2,2,2,0
0
$ test-expr '\''(((a && b) || c) >= d) != e'\'' -a 2,0,0,2,0
0
$ test-expr '\''(((a && b) || c) >= d) != e'\'' -a 2,0,0,2,2
1
$ test-expr '\''(((a && b) || c) >= d) != e'\'' -a 2,0,1,2,2
1
$ test-expr '\''(((a && b) || c) >= d) != e'\'' -a 2,1,1,1,2
1
$ test-expr '\''(((a && b) || c) >= d) != e'\'' -a 2,1,2,0,0
1
$ test-expr '\''(((a && b) || c) >= d) != e'\'' -a 2,2,0,0,2
1
$ test-expr '\''(((a >= b) != c) && d) || e'\'' -a 0,0,1,0,0
0
$ test-expr '\''(((a >= b) != c) && d) || e'\'' -a 0,0,2,0,2
1
$ test-expr '\''(((a >= b) != c) && d) || e'\'' -a 0,0,2,1,2
1
$ test-expr '\''(((a >= b) != c) && d) || e'\'' -a 0,1,0,2,2
1
$ test-expr '\''(((a >= b) != c) && d) || e'\'' -a 0,1,1,0,2
1
$ test-expr '\''(((a >= b) != c) && d) || e'\'' -a 0,1,1,1,0
1
$ test-expr '\''(((a >= b) != c) && d) || e'\'' -a 0,1,2,1,2
1
$ test-expr '\''(((a >= b) != c) && d) || e'\'' -a 0,2,0,0,2
1
$ test-expr '\''(((a >= b) != c) && d) || e'\'' -a 0,2,2,0,0
0
$ test-expr '\''(((a >= b) != c) && d) || e'\'' -a 0,2,2,0,2
1
$ test-expr '\''(((a >= b) != c) && d) || e'\'' -a 0,2,2,1,0
1
$ test-expr '\''(((a >= b) != c) && d) || e'\'' -a 1,0,0,1,1
1
$ test-expr '\''(((a >= b) != c) && d) || e'\'' -a 1,0,1,0,2
1
$ test-expr '\''(((a >= b) != c) && d) || e'\'' -a 1,0,1,1,0
0
$ test-expr '\''(((a >= b) != c) && d) || e'\'' -a 1,0,2,2,0
1
$ test-expr '\''(((a >= b) != c) && d) || e'\'' -a 1,1,0,1,2
1
$ test-expr '\''(((a >= b) != c) && d) || e'\'' -a 1,1,2,0,1
1
$ test-expr '\''(((a >= b) != c) && d) || e'\'' -a 1,2,1,0,2
1
$ test-expr '\''(((a >= b) != c) && d) || e'\'' -a 1,2,1,1,2
1
$ test-expr '\''(((a >= b) != c) && d) || e'\'' -a 1,2,2,1,1
1
$ test-expr '\''(((a >= b) != c) && d) || e'\'' -a 2,0,0,1,1
1
$ test-expr '\''(((a >= b) != c) && d) || e'\'' -a 2,0,0,1,2
1
$ test-expr '\''(((a >= b) != c) && d) || e'\'' -a 2,0,1,0,0
0
$ test-expr '\''(((a >= b) != c) && d) || e'\'' -a 2,0,2,0,0
0
$ test-expr '\''(((a >= b) != c) && d) || e'\'' -a 2,1,0,0,2
1
$ test-expr '\''(((a >= b) != c) && d) || e'\'' -a 2,1,1,1,1
1
$ test-expr '\''(((a >= b) != c) && d) || e'\'' -a 2,1,2,0,2
1
$ test-expr '\''(((a >= b) != c) && d) || e'\'' -a 2,2,0,1,2
1
$ test-expr '\''(((a >= b) != c) && d) || e'\'' -a 2,2,1,0,1
1
$ test-expr '\''(((a >= b) != c) && d) || e'\'' -a 2,2,1,0,2
1
$ test-expr '\''(((a >= b) != c) && d) || e'\'' -a 2,2,1,2,0
0
$ test-expr '\''(((a >= b) != c) && d) || e'\'' -a 2,2,2,1,1
1
$ test-expr '\''(((a >= b) != c) || d) && e'\'' -a 0,0,1,0,2
0
$ test-expr '\''(((a >= b) != c) || d) && e'\'' -a 0,0,1,1,0
0
$ test-expr '\''(((a >= b) != c) || d) && e'\'' -a 0,0,1,2,0
0
$ test-expr '\''(((a >= b) != c) || d) && e'\'' -a 0,1,0,2,2
1
$ test-expr '\''(((a >= b) != c) || d) && e'\'' -a 0,1,2,0,0
0
$ test-expr '\''(((a >= b) != c) || d) && e'\'' -a 0,1,2,1,0
0
$ test-expr '\''(((a >= b) != c) || d) && e'\'' -a 0,1,2,2,0
0
$ test-expr '\''(((a >= b) != c) || d) && e'\'' -a 0,2,0,2,2
1
$ test-expr '\''(((a >= b) != c) || d) && e'\'' -a 0,2,1,0,0
0
$ test-expr '\''(((a >= b) != c) || d) && e'\'' -a 0,2,2,0,1
1
$ test-expr '\''(((a >= b) != c) || d) && e'\'' -a 0,2,2,1,2
1
$ test-expr '\''(((a >= b) != c) || d) && e'\'' -a 1,0,0,0,0
0
$ test-expr '\''(((a >= b) != c) || d) && e'\'' -a 1,0,0,1,2
1
$ test-expr '\''(((a >= b) != c) || d) && e'\'' -a 1,0,1,0,1
0
$ test-expr '\''(((a >= b) != c) || d) && e'\'' -a 1,0,1,2,1
1
$ test-expr '\''(((a >= b) != c) || d) && e'\'' -a 1,0,2,0,0
0
$ test-expr '\''(((a >= b) != c) || d) && e'\'' -a 1,0,2,1,1
1
$ test-expr '\''(((a >= b) != c) || d) && e'\'' -a 1,0,2,2,2
1
$ test-expr '\''(((a >= b) != c) || d) && e'\'' -a 1,1,0,1,2
1
$ test-expr '\''(((a >= b) != c) || d) && e'\'' -a 1,1,1,0,1
0
$ test-expr '\''(((a >= b) != c) || d) && e'\'' -a 1,1,1,2,2
1
$ test-expr '\''(((a >= b) != c) || d) && e'\'' -a 1,2,1,2,0
0
$ test-expr '\''(((a >= b) != c) || d) && e'\'' -a 1,2,1,2,2
1
$ test-expr '\''(((a >= b) != c) || d) && e'\'' -a 1,2,2,1,2
1
$ test-expr '\''(((a >= b) != c) || d) && e'\'' -a 2,0,0,2,2
1
$ test-expr '\''(((a >= b) != c) || d) && e'\'' -a 2,0,2,0,1
1
$ test-expr '\''(((a >= b) != c) || d) && e'\'' -a 2,0,2,2,2
1
$ test-expr '\''(((a >= b) != c) || d) && e'\'' -a 2,1,1,1,0
0
$ test-expr '\''(((a >= b) != c) || d) && e'\'' -a 2,2,1,1,0
0
$ test-expr '\''(((a >= b) != c) || d) && e'\'' -a 2,2,1,2,2
1
$ test-expr '\''(((a >= b) && c) != d) || e'\'' -a 0,0,0,0,1
1
$ test-expr '\''(((a >= b) && c) != d) || e'\'' -a 0,0,0,1,0
1
$ test-expr '\''(((a >= b) && c) != d) || e'\'' -a 0,0,1,1,1
1
$ test-expr '\''(((a >= b) && c) != d) || e'\'' -a 0,0,2,2,1
1
$ test-expr '\''(((a >= b) && c) != d) || e'\'' -a 0,1,0,0,2
1
$ test-expr '\''(((a >= b) && c) != d) || e'\'' -a 0,1,0,2,0
1
$ test-expr '\''(((a >= b) && c) != d) || e'\'' -a 0,1,2,0,1
1
$ test-expr '\''(((a >= b) && c) != d) || e'\'' -a 0,2,1,2,0
1
$ test-expr '\''(((a >= b) && c) != d) || e'\'' -a 1,0,1,2,0
1
$ test-expr '\''(((a >= b) && c) != d) || e'\'' -a 1,0,2,1,0
0
$ test-expr '\''(((a >= b) && c) != d) || e'\'' -a 1,0,2,1,2
1
$ test-expr '\''(((a >= b) && c) != d) || e'\'' -a 1,1,1,1,0
0
$ test-expr '\''(((a >= b) && c) != d) || e'\'' -a 1,1,1,2,2
1
$ test-expr '\''(((a >= b) && c) != d) || e'\'' -a 1,1,2,1,2
1
$ test-expr '\''(((a >= b) && c) != d) || e'\'' -a 1,2,2,2,1
1
$ test-expr '\''(((a >= b) && c) != d) || e'\'' -a 2,0,1,1,2
1
$ test-expr '\''(((a >= b) && c) != d) || e'\'' -a 2,0,1,2,2
1
$ test-expr '\''(((a >= b) && c) != d) || e'\'' -a 2,0,2,1,2
1
$ test-expr '\''(((a >= b) && c) != d) || e'\'' -a 2,0,2,2,2
1
$ test-expr '\''(((a >= b) && c) != d) || e'\'' -a 2,1,0,0,2
1
$ test-expr '\''(((a >= b) && c) != d) || e'\'' -a 2,1,1,1,2
1
$ test-expr '\''(((a >= b) && c) != d) || e'\'' -a 2,1,2,0,1
1
$ test-expr '\''(((a >= b) && c) != d) || e'\'' -a 2,2,0,1,0
1
$ test-expr '\''(((a >= b) && c) != d) || e'\'' -a 2,2,0,1,2
1
$ test-expr '\''(((a >= b) && c) != d) || e'\'' -a 2,2,1,0,0
1
$ test-expr '\''(((a >= b) && c) != d) || e'\'' -a 2,2,1,2,1
1
$ test-expr '\''(((a >= b) && c) != d) || e'\'' -a 2,2,1,2,2
1
$ test-expr '\''(((a >= b) && c) || d) != e'\'' -a 0,0,0,0,1
1
$ test-expr '\''(((a >= b) && c) || d) != e'\'' -a 0,0,0,1,1
0
$ test-expr '\''(((a >= b) && c) || d) != e'\'' -a 0,0,1,0,0
1
$ test-expr '\''(((a >= b) && c) || d) != e'\'' -a 0,0,1,0,2
1
$ test-expr '\''(((a >= b) && c) || d) != e'\'' -a 0,0,1,1,0
1
$ test-expr '\''(((a >= b) && c) || d) != e'\'' -a 0,1,1,2,2
1
$ test-expr '\''(((a >= b) && c) || d) != e'\'' -a 0,1,2,1,0
1
$ test-expr '\''(((a >= b) && c) || d) != e'\'' -a 0,2,0,0,0
0
$ test-expr '\''(((a >= b) && c) || d) != e'\'' -a 0,2,1,1,2
1
$ test-expr '\''(((a >= b) && c) || d) != e'\'' -a 0,2,2,0,0
0
$ test-expr '\''(((a >= b) && c) || d) != e'\'' -a 0,2,2,2,1
0
$ test-expr '\''(((a >= b) && c) || d) != e'\'' -a 1,0,0,2,0
1
$ test-expr '\''(((a >= b) && c) || d) != e'\'' -a 1,0,1,2,0
1
$ test-expr '\''(((a >= b) && c) || d) != e'\'' -a 1,0,2,1,1
0
$ test-expr '\''(((a >= b) && c) || d) != e'\'' -a 1,0,2,2,1
0
$ test-expr '\''(((a >= b) && c) || d) != e'\'' -a 1,1,0,1,2
1
$ test-expr '\''(((a >= b) && c) || d) != e'\'' -a 1,1,1,0,2
1
$ test-expr '\''(((a >= b) && c) || d) != e'\'' -a 1,1,1,2,1
0
$ test-expr '\''(((a >= b) && c) || d) != e'\'' -a 1,1,2,1,1
0
$ test-expr '\''(((a >= b) && c) || d) != e'\'' -a 1,1,2,2,0
1
$ test-expr '\''(((a >= b) && c) || d) != e'\'' -a 1,2,0,0,1
1
$ test-expr '\''(((a >= b) && c) || d) != e'\'' -a 1,2,1,2,1
0
$ test-expr '\''(((a >= b) && c) || d) != e'\'' -a 1,2,2,1,2
1
$ test-expr '\''(((a >= b) && c) || d) != e'\'' -a 2,0,0,2,1
0
$ test-expr '\''(((a >= b) && c) || d) != e'\'' -a 2,0,1,2,2
1
$ test-expr '\''(((a >= b) && c) || d) != e'\'' -a 2,0,2,1,0
1
$ test-expr '\''(((a >= b) && c) || d) != e'\'' -a 2,1,0,1,1
0
$ test-expr '\''(((a >= b) && c) || d) != e'\'' -a 2,1,1,2,1
0
$ test-expr '\''(((a >= b) && c) || d) != e'\'' -a 2,1,2,1,0
1
$ test-expr '\''(((a >= b) && c) || d) != e'\'' -a 2,1,2,1,1
0
$ test-expr '\''(((a >= b) && c) || d) != e'\'' -a 2,2,1,0,2
1
$ test-expr '\''(((a >= b) && c) || d) != e'\'' -a 2,2,2,0,0
1
$ test-expr '\''(((a >= b) || c) != d) && e'\'' -a 0,0,0,2,1
1
$ test-expr '\''(((a >= b) || c) != d) && e'\'' -a 0,0,1,1,2
0
$ test-expr '\''(((a >= b) || c) != d) && e'\'' -a 0,0,2,0,1
1
$ test-expr '\''(((a >= b) || c) != d) && e'\'' -a 0,1,0,2,2
1
$ test-expr '\''(((a >= b) || c) != d) && e'\'' -a 0,1,2,1,0
0
$ test-expr '\''(((a >= b) || c) != d) && e'\'' -a 0,2,0,2,2
1
$ test-expr '\''(((a >= b) || c) != d) && e'\'' -a 1,0,0,2,1
1
$ test-expr '\''(((a >= b) || c) != d) && e'\'' -a 1,0,1,2,2
1
$ test-expr '\''(((a >= b) || c) != d) && e'\'' -a 1,0,2,1,2
0
$ test-expr '\''(((a >= b) || c) != d) && e'\'' -a 1,0,2,2,0
0
$ test-expr '\''(((a >= b) || c) != d) && e'\'' -a 1,0,2,2,2
1
$ test-expr '\''(((a >= b) || c) != d) && e'\'' -a 1,1,1,1,1
0
$ test-expr '\''(((a >= b) || c) != d) && e'\'' -a 1,1,1,2,2
1
$ test-expr '\''(((a >= b) || c) != d) && e'\'' -a 1,1,2,0,1
1
$ test-expr '\''(((a >= b) || c) != d) && e'\'' -a 1,1,2,1,2
0
$ test-expr '\''(((a >= b) || c) != d) && e'\'' -a 1,2,0,0,1
0
$ test-expr '\''(((a >= b) || c) != d) && e'\'' -a 1,2,0,0,2
0
$ test-expr '\''(((a >= b) || c) != d) && e'\'' -a 1,2,0,2,1
1
$ test-expr '\''(((a >= b) || c) != d) && e'\'' -a 1,2,1,1,0
0
$ test-expr '\''(((a >= b) || c) != d) && e'\'' -a 1,2,1,2,0
0
$ test-expr '\''(((a >= b) || c) != d) && e'\'' -a 1,2,1,2,1
1
$ test-expr '\''(((a >= b) || c) != d) && e'\'' -a 2,0,0,2,0
0
$ test-expr '\''(((a >= b) || c) != d) && e'\'' -a 2,0,2,2,0
0
$ test-expr '\''(((a >= b) || c) != d) && e'\'' -a 2,0,2,2,1
1
$ test-expr '\''(((a >= b) || c) != d) && e'\'' -a 2,1,0,1,0
0
$ test-expr '\''(((a >= b) || c) != d) && e'\'' -a 2,1,1,1,0
0
$ test-expr '\''(((a >= b) || c) != d) && e'\'' -a 2,1,1,1,2
0
$ test-expr '\''(((a >= b) || c) != d) && e'\'' -a 2,1,1,2,0
0
$ test-expr '\''(((a >= b) || c) != d) && e'\'' -a 2,1,2,2,2
1
$ test-expr '\''(((a >= b) || c) != d) && e'\'' -a 2,2,0,0,1
1
$ test-expr '\''(((a >= b) || c) != d) && e'\'' -a 2,2,1,0,2
1
$ test-expr '\''(((a >= b) || c) != d) && e'\'' -a 2,2,1,1,2
0
$ test-expr '\''(((a >= b) || c) != d) && e'\'' -a 2,2,2,1,1
0
$ test-expr '\''(((a >= b) || c) && d) != e'\'' -a 0,0,0,0,2
1
$ test-expr '\''(((a >= b) || c) && d) != e'\'' -a 0,0,0,1,2
1
$ test-expr '\''(((a >= b) || c) && d) != e'\'' -a 0,0,1,1,0
1
$ test-expr '\''(((a >= b) || c) && d) != e'\'' -a 0,0,2,0,1
1
$ test-expr '\''(((a >= b) || c) && d) != e'\'' -a 0,1,0,0,0
0
$ test-expr '\''(((a >= b) || c) && d) != e'\'' -a 0,1,0,0,1
1
$ test-expr '\''(((a >= b) || c) && d) != e'\'' -a 0,1,1,2,2
1
$ test-expr '\''(((a >= b) || c) && d) != e'\'' -a 0,1,2,2,0
1
$ test-expr '\''(((a >= b) || c) && d) != e'\'' -a 0,2,0,1,2
1
$ test-expr '\''(((a >= b) || c) && d) != e'\'' -a 0,2,1,1,2
1
$ test-expr '\''(((a >= b) || c) && d) != e'\'' -a 0,2,1,2,0
1
$ test-expr '\''(((a >= b) || c) && d) != e'\'' -a 0,2,1,2,1
0
$ test-expr '\''(((a >= b) || c) && d) != e'\'' -a 0,2,2,0,1
1
$ test-expr '\''(((a >= b) || c) && d) != e'\'' -a 1,0,2,0,0
0
$ test-expr '\''(((a >= b) || c) && d) != e'\'' -a 1,2,1,2,1
0
$ test-expr '\''(((a >= b) || c) && d) != e'\'' -a 1,2,2,0,1
1
$ test-expr '\''(((a >= b) || c) && d) != e'\'' -a 1,2,2,1,0
1
$ test-expr '\''(((a >= b) || c) && d) != e'\'' -a 1,2,2,2,1
0
$ test-expr '\''(((a >= b) || c) && d) != e'\'' -a 2,0,0,1,0
1
$ test-expr '\''(((a >= b) || c) && d) != e'\'' -a 2,0,1,1,0
1
$ test-expr '\''(((a >= b) || c) && d) != e'\'' -a 2,0,1,1,2
1
$ test-expr '\''(((a >= b) || c) && d) != e'\'' -a 2,1,0,0,2
1
$ test-expr '\''(((a >= b) || c) && d) != e'\'' -a 2,1,1,0,2
1
$ test-expr '\''(((a >= b) || c) && d) != e'\'' -a 2,1,2,1,2
1
$ test-expr '\''(((a >= b) || c) && d) != e'\'' -a 2,2,0,0,0
0
$ test-expr '\''(((a >= b) || c) && d) != e'\'' -a 2,2,0,2,2
1
$ test-expr '\''(((a >= b) || c) && d) != e'\'' -a 2,2,1,2,0
1
$ test-expr '\''(((a >= b) || c) && d) != e'\'' -a 2,2,1,2,1
0
$ test-expr '\''(((a >= b) || c) && d) != e'\'' -a 2,2,1,2,2
1
$ test-expr '\''(((a >= b) || c) && d) != e'\'' -a 2,2,2,1,2
1
$ test-expr '\''(((a || b) != c) && d) >= e'\'' -a 0,0,0,0,2
0
$ test-expr '\''(((a || b) != c) && d) >= e'\'' -a 0,0,1,0,2
0
$ test-expr '\''(((a || b) != c) && d) >= e'\'' -a 0,0,1,1,0
1
$ test-expr '\''(((a || b) != c) && d) >= e'\'' -a 0,0,1,2,1
1
$ test-expr '\''(((a || b) != c) && d) >= e'\'' -a 0,0,2,0,2
0
$ test-expr '\''(((a || b) != c) && d) >= e'\'' -a 0,0,2,1,1
1
$ test-expr '\''(((a || b) != c) && d) >= e'\'' -a 0,1,0,2,0
1
$ test-expr '\''(((a || b) != c) && d) >= e'\'' -a 0,1,2,2,1
1
$ test-expr '\''(((a || b) != c) && d) >= e'\'' -a 0,2,0,0,1
0
$ test-expr '\''(((a || b) != c) && d) >= e'\'' -a 0,2,1,2,1
0
$ test-expr '\''(((a || b) != c) && d) >= e'\'' -a 0,2,2,2,2
0
$ test-expr '\''(((a || b) != c) && d) >= e'\'' -a 1,0,0,0,2
0
$ test-expr '\''(((a || b) != c) && d) >= e'\'' -a 1,0,0,1,0
1
$ test-expr '\''(((a || b) != c) && d) >= e'\'' -a 1,0,0,1,1
1
$ test-expr '\''(((a || b) != c) && d) >= e'\'' -a 1,0,1,0,0
1
$ test-expr '\''(((a || b) != c) && d) >= e'\'' -a 1,0,2,0,1
0
$ test-expr '\''(((a || b) != c) && d) >= e'\'' -a 1,0,2,1,1
1
$ test-expr '\''(((a || b) != c) && d) >= e'\'' -a 1,1,0,0,0
1
$ test-expr '\''(((a || b) != c) && d) >= e'\'' -a 1,1,0,2,0
1
$ test-expr '\''(((a || b) != c) && d) >= e'\'' -a 2,0,0,0,0
1
$ test-expr '\''(((a || b) != c) && d) >= e'\'' -a 2,0,0,1,1
1
$ test-expr '\''(((a || b) != c) && d) >= e'\'' -a 2,0,2,0,0
1
$ test-expr '\''(((a || b) != c) && d) >= e'\'' -a 2,0,2,1,1
1
$ test-expr '\''(((a || b) != c) && d) >= e'\'' -a 2,0,2,2,1
1
$ test-expr '\''(((a || b) != c) && d) >= e'\'' -a 2,1,0,1,0
1
$ test-expr '\''(((a || b) != c) && d) >= e'\'' -a 2,1,1,1,1
0
$ test-expr '\''(((a || b) != c) && d) >= e'\'' -a 2,1,1,2,0
1
$ test-expr '\''(((a || b) != c) && d) >= e'\'' -a 2,2,0,2,0
1
$ test-expr '\''(((a || b) != c) && d) >= e'\'' -a 2,2,1,0,2
0
$ test-expr '\''(((a || b) != c) && d) >= e'\'' -a 2,2,2,1,2
0
$ test-expr '\''(((a || b) != c) >= d) && e'\'' -a 0,0,0,0,2
1
$ test-expr '\''(((a || b) != c) >= d) && e'\'' -a 0,0,0,2,1
0
$ test-expr '\''(((a || b) != c) >= d) && e'\'' -a 0,0,1,0,2
1
$ test-expr '\''(((a || b) != c) >= d) && e'\'' -a 0,1,0,0,1
1
$ test-expr '\''(((a || b) != c) >= d) && e'\'' -a 0,1,0,2,1
0
$ test-expr '\''(((a || b) != c) >= d) && e'\'' -a 0,1,2,0,2
1
$ test-expr '\''(((a || b) != c) >= d) && e'\'' -a 0,2,0,2,0
0
$ test-expr '\''(((a || b) != c) >= d) && e'\'' -a 1,0,0,0,1
1
$ test-expr '\''(((a || b) != c) >= d) && e'\'' -a 1,0,1,1,0
0
$ test-expr '\''(((a || b) != c) >= d) && e'\'' -a 1,0,1,1,1
0
$ test-expr '\''(((a || b) != c) >= d) && e'\'' -a 1,0,1,1,2
0
$ test-expr '\''(((a || b) != c) >= d) && e'\'' -a 1,0,1,2,0
0
$ test-expr '\''(((a || b) != c) >= d) && e'\'' -a 1,0,1,2,1
0
$ test-expr '\''(((a || b) != c) >= d) && e'\'' -a 1,0,2,0,2
1
$ test-expr '\''(((a || b) != c) >= d) && e'\'' -a 1,1,0,0,1
1
$ test-expr '\''(((a || b) != c) >= d) && e'\'' -a 1,1,0,0,2
1
$ test-expr '\''(((a || b) != c) >= d) && e'\'' -a 1,1,0,2,0
0
$ test-expr '\''(((a || b) != c) >= d) && e'\'' -a 1,1,0,2,1
0
$ test-expr '\''(((a || b) != c) >= d) && e'\'' -a 1,1,1,2,2
0
$ test-expr '\''(((a || b) != c) >= d) && e'\'' -a 1,1,2,0,2
1
$ test-expr '\''(((a || b) != c) >= d) && e'\'' -a 1,2,0,2,1
0
$ test-expr '\''(((a || b) != c) >= d) && e'\'' -a 1,2,1,2,1
0
$ test-expr '\''(((a || b) != c) >= d) && e'\'' -a 1,2,2,0,0
0
$ test-expr '\''(((a || b) != c) >= d) && e'\'' -a 2,0,0,1,1
1
$ test-expr '\''(((a || b) != c) >= d) && e'\'' -a 2,0,0,1,2
1
$ test-expr '\''(((a || b) != c) >= d) && e'\'' -a 2,0,1,1,2
0
$ test-expr '\''(((a || b) != c) >= d) && e'\'' -a 2,0,2,2,0
0
$ test-expr '\''(((a || b) != c) >= d) && e'\'' -a 2,1,1,2,2
0
$ test-expr '\''(((a || b) != c) >= d) && e'\'' -a 2,1,2,2,2
0
$ test-expr '\''(((a || b) != c) >= d) && e'\'' -a 2,2,1,1,1
0
$ test-expr '\''(((a || b) != c) >= d) && e'\'' -a 2,2,1,2,2
0
$ test-expr '\''(((a || b) && c) != d) >= e'\'' -a 0,0,2,0,0
1
$ test-expr '\''(((a || b) && c) != d) >= e'\'' -a 0,0,2,2,1
1
$ test-expr '\''(((a || b) && c) != d) >= e'\'' -a 0,1,0,0,0
1
$ test-expr '\''(((a || b) && c) != d) >= e'\'' -a 0,1,0,1,2
0
$ test-expr '\''(((a || b) && c) != d) >= e'\'' -a 0,1,0,2,1
1
$ test-expr '\''(((a || b) && c) != d) >= e'\'' -a 0,1,0,2,2
0
$ test-expr '\''(((a || b) && c) != d) >= e'\'' -a 0,1,2,1,0
1
$ test-expr '\''(((a || b) && c) != d) >= e'\'' -a 0,2,1,0,0
1
$ test-expr '\''(((a || b) && c) != d) >= e'\'' -a 0,2,1,0,1
1
$ test-expr '\''(((a || b) && c) != d) >= e'\'' -a 0,2,1,1,0
1
$ test-expr '\''(((a || b) && c) != d) >= e'\'' -a 0,2,2,0,1
1
$ test-expr '\''(((a || b) && c) != d) >= e'\'' -a 0,2,2,0,2
0
$ test-expr '\''(((a || b) && c) != d) >= e'\'' -a 1,0,1,2,1
1
$ test-expr '\''(((a || b) && c) != d) >= e'\'' -a 1,0,2,2,0
1
$ test-expr '\''(((a || b) && c) != d) >= e'\'' -a 1,1,0,2,1
1
$ test-expr '\''(((a || b) && c) != d) >= e'\'' -a 1,1,1,0,1
1
$ test-expr '\''(((a || b) && c) != d) >= e'\'' -a 1,1,1,1,0
1
$ test-expr '\''(((a || b) && c) != d) >= e'\'' -a 1,2,1,1,2
0
$ test-expr '\''(((a || b) && c) != d) >= e'\'' -a 1,2,2,0,1
1
$ test-expr '\''(((a || b) && c) != d) >= e'\'' -a 1,2,2,2,2
0
$ test-expr '\''(((a || b) && c) != d) >= e'\'' -a 2,0,0,2,1
1
$ test-expr '\''(((a || b) && c) != d) >= e'\'' -a 2,0,1,0,2
0
$ test-expr '\''(((a || b) && c) != d) >= e'\'' -a 2,0,2,2,0
1
$ test-expr '\''(((a || b) && c) != d) >= e'\'' -a 2,0,2,2,2
0
$ test-expr '\''(((a || b) && c) != d) >= e'\'' -a 2,1,0,0,2
0
$ test-expr '\''(((a || b) && c) != d) >= e'\'' -a 2,1,1,0,1
1
$ test-expr '\''(((a || b) && c) != d) >= e'\'' -a 2,1,1,1,2
0
$ test-expr '\''(((a || b) && c) != d) >= e'\'' -a 2,1,2,0,2
0
$ test-expr '\''(((a || b) && c) != d) >= e'\'' -a 2,2,2,2,2
0
$ test-expr '\''(((a || b) && c) >= d) != e'\'' -a 0,0,1,0,1
0
$ test-expr '\''(((a || b) && c) >= d) != e'\'' -a 0,0,1,0,2
1
$ test-expr '\''(((a || b) && c) >= d) != e'\'' -a 0,0,1,1,1
1
$ test-expr '\''(((a || b) && c) >= d) != e'\'' -a 0,1,1,0,0
1
$ test-expr '\''(((a || b) && c) >= d) != e'\'' -a 0,1,1,1,0
1
$ test-expr '\''(((a || b) && c) >= d) != e'\'' -a 0,1,1,1,2
1
$ test-expr '\''(((a || b) && c) >= d) != e'\'' -a 0,1,2,0,1
0
$ test-expr '\''(((a || b) && c) >= d) != e'\'' -a 0,1,2,1,1
0
$ test-expr '\''(((a || b) && c) >= d) != e'\'' -a 0,2,0,1,2
1
$ test-expr '\''(((a || b) && c) >= d) != e'\'' -a 0,2,1,1,1
0
$ test-expr '\''(((a || b) && c) >= d) != e'\'' -a 1,0,0,2,2
1
$ test-expr '\''(((a || b) && c) >= d) != e'\'' -a 1,0,1,1,1
0
$ test-expr '\''(((a || b) && c) >= d) != e'\'' -a 1,1,0,0,0
1
$ test-expr '\''(((a || b) && c) >= d) != e'\'' -a 1,1,1,0,0
1
$ test-expr '\''(((a || b) && c) >= d) != e'\'' -a 1,1,1,0,1
0
$ test-expr '\''(((a || b) && c) >= d) != e'\'' -a 1,1,2,2,0
0
$ test-expr '\''(((a || b) && c) >= d) != e'\'' -a 1,2,1,1,0
1
$ test-expr '\''(((a || b) && c) >= d) != e'\'' -a 1,2,1,2,1
1
$ test-expr '\''(((a || b) && c) >= d) != e'\'' -a 2,0,2,0,0
1
$ test-expr '\''(((a || b) && c) >= d) != e'\'' -a 2,1,0,2,2
1
$ test-expr '\''(((a || b) && c) >= d) != e'\'' -a 2,2,0,1,0
0
$ test-expr '\''(((a || b) && c) >= d) != e'\'' -a 2,2,2,0,2
1
$ test-expr '\''(((a || b) >= c) != d) && e'\'' -a 0,0,2,0,1
0
$ test-expr '\''(((a || b) >= c) != d) && e'\'' -a 0,0,2,2,0
0
$ test-expr '\''(((a || b) >= c) != d) && e'\'' -a 0,1,1,0,2
1
$ test-expr '\''(((a || b) >= c) != d) && e'\'' -a 0,1,1,1,2
0
$ test-expr '\''(((a || b) >= c) != d) && e'\'' -a 0,1,1,2,2
1
$ test-expr '\''(((a || b) >= c) != d) && e'\'' -a 0,1,2,1,0
0
$ test-expr '\''(((a || b) >= c) != d) && e'\'' -a 0,1,2,1,2
1
$ test-expr '\''(((a || b) >= c) != d) && e'\'' -a 0,2,0,2,1
1
$ test-expr '\''(((a || b) >= c) != d) && e'\'' -a 0,2,2,1,1
1
$ test-expr '\''(((a || b) >= c) != d) && e'\'' -a 1,0,1,0,0
0
$ test-expr '\''(((a || b) >= c) != d) && e'\'' -a 1,0,1,0,2
1
$ test-expr '\''(((a || b) >= c) != d) && e'\'' -a 1,0,1,1,1
0
$ test-expr '\''(((a || b) >= c) != d) && e'\'' -a 1,0,2,2,0
0
$ test-expr '\''(((a || b) >= c) != d) && e'\'' -a 1,1,0,0,0
0
$ test-expr '\''(((a || b) >= c) != d) && e'\'' -a 1,1,0,1,1
0
$ test-expr '\''(((a || b) >= c) != d) && e'\'' -a 1,1,1,1,2
0
$ test-expr '\''(((a || b) >= c) != d) && e'\'' -a 1,1,2,0,2
0
$ test-expr '\''(((a || b) >= c) != d) && e'\'' -a 1,1,2,1,0
0
$ test-expr '\''(((a || b) >= c) != d) && e'\'' -a 1,1,2,2,1
1
$ test-expr '\''(((a || b) >= c) != d) && e'\'' -a 1,2,0,0,1
1
$ test-expr '\''(((a || b) >= c) != d) && e'\'' -a 1,2,0,0,2
1
$ test-expr '\''(((a || b) >= c) != d) && e'\'' -a 1,2,1,0,1
1
$ test-expr '\''(((a || b) >= c) != d) && e'\'' -a 1,2,1,0,2
1
$ test-expr '\''(((a || b) >= c) != d) && e'\'' -a 1,2,1,1,1
0
$ test-expr '\''(((a || b) >= c) != d) && e'\'' -a 2,0,1,2,0
0
$ test-expr '\''(((a || b) >= c) != d) && e'\'' -a 2,0,1,2,2
1
$ test-expr '\''(((a || b) >= c) != d) && e'\'' -a 2,1,0,1,1
0
$ test-expr '\''(((a || b) >= c) != d) && e'\'' -a 2,1,2,1,0
0
$ test-expr '\''(((a || b) >= c) != d) && e'\'' -a 2,2,0,1,0
0
$ test-expr '\''(((a || b) >= c) != d) && e'\'' -a 2,2,2,1,1
1
$ test-expr '\''(((a || b) >= c) && d) != e'\'' -a 0,0,0,1,2
1
$ test-expr '\''(((a || b) >= c) && d) != e'\'' -a 0,0,1,0,1
1
$ test-expr '\''(((a || b) >= c) && d) != e'\'' -a 0,0,1,2,1
1
$ test-expr '\''(((a || b) >= c) && d) != e'\'' -a 0,0,2,1,0
0
$ test-expr '\''(((a || b) >= c) && d) != e'\'' -a 0,1,2,0,1
1
$ test-expr '\''(((a || b) >= c) && d) != e'\'' -a 0,1,2,1,2
1
$ test-expr '\''(((a || b) >= c) && d) != e'\'' -a 0,2,0,1,1
0
$ test-expr '\''(((a || b) >= c) && d) != e'\'' -a 0,2,1,0,0
0
$ test-expr '\''(((a || b) >= c) && d) != e'\'' -a 0,2,2,0,1
1
$ test-expr '\''(((a || b) >= c) && d) != e'\'' -a 0,2,2,1,1
1
$ test-expr '\''(((a || b) >= c) && d) != e'\'' -a 1,0,0,1,0
1
$ test-expr '\''(((a || b) >= c) && d) != e'\'' -a 1,0,0,1,1
0
$ test-expr '\''(((a || b) >= c) && d) != e'\'' -a 1,0,1,0,2
1
$ test-expr '\''(((a || b) >= c) && d) != e'\'' -a 1,0,2,2,1
1
$ test-expr '\''(((a || b) >= c) && d) != e'\'' -a 1,1,2,0,1
1
$ test-expr '\''(((a || b) >= c) && d) != e'\'' -a 1,1,2,1,0
0
$ test-expr '\''(((a || b) >= c) && d) != e'\'' -a 1,1,2,2,0
0
$ test-expr '\''(((a || b) >= c) && d) != e'\'' -a 1,2,0,0,1
1
$ test-expr '\''(((a || b) >= c) && d) != e'\'' -a 1,2,0,1,0
1
$ test-expr '\''(((a || b) >= c) && d) != e'\'' -a 1,2,1,0,2
1
$ test-expr '\''(((a || b) >= c) && d) != e'\'' -a 1,2,1,1,0
1
$ test-expr '\''(((a || b) >= c) && d) != e'\'' -a 1,2,2,0,0
0
$ test-expr '\''(((a || b) >= c) && d) != e'\'' -a 2,0,2,0,1
1
$ test-expr '\''(((a || b) >= c) && d) != e'\'' -a 2,1,1,2,0
1
$ test-expr '\''(((a || b) >= c) && d) != e'\'' -a 2,1,1,2,1
0
$ test-expr '\''(((a || b) >= c) && d) != e'\'' -a 2,1,2,2,1
1
$ test-expr '\''(((a || b) >= c) && d) != e'\'' -a 2,2,2,1,0
0
$ test-expr '\''(((a || b) >= c) && d) != e'\'' -a 2,2,2,1,1
1'
) -L op12.new <(
echo '$ shopt -s expand_aliases'
shopt -s expand_aliases 2>&1 ||
echo 'command failed: shopt -s expand_aliases'

echo '$ [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'
[ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib" 2>&1 ||
echo 'command failed: [ -n "$JSON_LITEX_TEST_PCRE2_LIB" ] || JSON_LITEX_TEST_PCRE2_LIB="/usr/local/lib"'

echo '$ test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vc ast; }'
test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vc ast; } 2>&1 ||
echo 'command failed: test-expr() { LD_LIBRARY_PATH="$JSON_LITEX_TEST_PCRE2_LIB" ../lib/test-expr "$@" -vc ast; }'

echo '$ alias test-expr='\''test-expr -b alpha -E'\'''
alias test-expr='test-expr -b alpha -E' 2>&1 ||
echo 'command failed: alias test-expr='\''test-expr -b alpha -E'\'''

echo '$ test-expr '\''a != (b && (c >= (d || e)))'\'' -a 0,0,1,1,2'
test-expr 'a != (b && (c >= (d || e)))' -a 0,0,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b && (c >= (d || e)))'\'' -a 0,0,1,1,2'

echo '$ test-expr '\''a != (b && (c >= (d || e)))'\'' -a 0,0,1,2,2'
test-expr 'a != (b && (c >= (d || e)))' -a 0,0,1,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b && (c >= (d || e)))'\'' -a 0,0,1,2,2'

echo '$ test-expr '\''a != (b && (c >= (d || e)))'\'' -a 0,1,0,1,0'
test-expr 'a != (b && (c >= (d || e)))' -a 0,1,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b && (c >= (d || e)))'\'' -a 0,1,0,1,0'

echo '$ test-expr '\''a != (b && (c >= (d || e)))'\'' -a 0,1,0,1,2'
test-expr 'a != (b && (c >= (d || e)))' -a 0,1,0,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b && (c >= (d || e)))'\'' -a 0,1,0,1,2'

echo '$ test-expr '\''a != (b && (c >= (d || e)))'\'' -a 0,1,1,1,0'
test-expr 'a != (b && (c >= (d || e)))' -a 0,1,1,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b && (c >= (d || e)))'\'' -a 0,1,1,1,0'

echo '$ test-expr '\''a != (b && (c >= (d || e)))'\'' -a 0,2,0,0,1'
test-expr 'a != (b && (c >= (d || e)))' -a 0,2,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b && (c >= (d || e)))'\'' -a 0,2,0,0,1'

echo '$ test-expr '\''a != (b && (c >= (d || e)))'\'' -a 0,2,2,2,1'
test-expr 'a != (b && (c >= (d || e)))' -a 0,2,2,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b && (c >= (d || e)))'\'' -a 0,2,2,2,1'

echo '$ test-expr '\''a != (b && (c >= (d || e)))'\'' -a 1,0,0,0,1'
test-expr 'a != (b && (c >= (d || e)))' -a 1,0,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b && (c >= (d || e)))'\'' -a 1,0,0,0,1'

echo '$ test-expr '\''a != (b && (c >= (d || e)))'\'' -a 1,0,0,2,0'
test-expr 'a != (b && (c >= (d || e)))' -a 1,0,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b && (c >= (d || e)))'\'' -a 1,0,0,2,0'

echo '$ test-expr '\''a != (b && (c >= (d || e)))'\'' -a 1,0,2,1,0'
test-expr 'a != (b && (c >= (d || e)))' -a 1,0,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b && (c >= (d || e)))'\'' -a 1,0,2,1,0'

echo '$ test-expr '\''a != (b && (c >= (d || e)))'\'' -a 1,0,2,2,1'
test-expr 'a != (b && (c >= (d || e)))' -a 1,0,2,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b && (c >= (d || e)))'\'' -a 1,0,2,2,1'

echo '$ test-expr '\''a != (b && (c >= (d || e)))'\'' -a 1,1,1,1,1'
test-expr 'a != (b && (c >= (d || e)))' -a 1,1,1,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b && (c >= (d || e)))'\'' -a 1,1,1,1,1'

echo '$ test-expr '\''a != (b && (c >= (d || e)))'\'' -a 1,1,2,0,0'
test-expr 'a != (b && (c >= (d || e)))' -a 1,1,2,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b && (c >= (d || e)))'\'' -a 1,1,2,0,0'

echo '$ test-expr '\''a != (b && (c >= (d || e)))'\'' -a 1,2,1,0,1'
test-expr 'a != (b && (c >= (d || e)))' -a 1,2,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b && (c >= (d || e)))'\'' -a 1,2,1,0,1'

echo '$ test-expr '\''a != (b && (c >= (d || e)))'\'' -a 1,2,1,1,1'
test-expr 'a != (b && (c >= (d || e)))' -a 1,2,1,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b && (c >= (d || e)))'\'' -a 1,2,1,1,1'

echo '$ test-expr '\''a != (b && (c >= (d || e)))'\'' -a 1,2,1,1,2'
test-expr 'a != (b && (c >= (d || e)))' -a 1,2,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b && (c >= (d || e)))'\'' -a 1,2,1,1,2'

echo '$ test-expr '\''a != (b && (c >= (d || e)))'\'' -a 1,2,2,2,1'
test-expr 'a != (b && (c >= (d || e)))' -a 1,2,2,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b && (c >= (d || e)))'\'' -a 1,2,2,2,1'

echo '$ test-expr '\''a != (b && (c >= (d || e)))'\'' -a 2,0,1,0,1'
test-expr 'a != (b && (c >= (d || e)))' -a 2,0,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b && (c >= (d || e)))'\'' -a 2,0,1,0,1'

echo '$ test-expr '\''a != (b && (c >= (d || e)))'\'' -a 2,0,1,1,0'
test-expr 'a != (b && (c >= (d || e)))' -a 2,0,1,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b && (c >= (d || e)))'\'' -a 2,0,1,1,0'

echo '$ test-expr '\''a != (b && (c >= (d || e)))'\'' -a 2,0,2,1,0'
test-expr 'a != (b && (c >= (d || e)))' -a 2,0,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b && (c >= (d || e)))'\'' -a 2,0,2,1,0'

echo '$ test-expr '\''a != (b && (c >= (d || e)))'\'' -a 2,1,0,0,0'
test-expr 'a != (b && (c >= (d || e)))' -a 2,1,0,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b && (c >= (d || e)))'\'' -a 2,1,0,0,0'

echo '$ test-expr '\''a != (b && (c >= (d || e)))'\'' -a 2,1,1,2,2'
test-expr 'a != (b && (c >= (d || e)))' -a 2,1,1,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b && (c >= (d || e)))'\'' -a 2,1,1,2,2'

echo '$ test-expr '\''a != (b && (c >= (d || e)))'\'' -a 2,1,2,1,2'
test-expr 'a != (b && (c >= (d || e)))' -a 2,1,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b && (c >= (d || e)))'\'' -a 2,1,2,1,2'

echo '$ test-expr '\''a != (b && (c >= (d || e)))'\'' -a 2,2,2,1,1'
test-expr 'a != (b && (c >= (d || e)))' -a 2,2,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b && (c >= (d || e)))'\'' -a 2,2,2,1,1'

echo '$ test-expr '\''a != (b && (c >= (d || e)))'\'' -a 2,2,2,2,2'
test-expr 'a != (b && (c >= (d || e)))' -a 2,2,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b && (c >= (d || e)))'\'' -a 2,2,2,2,2'

echo '$ test-expr '\''a != (b && (c || (d >= e)))'\'' -a 0,1,0,0,0'
test-expr 'a != (b && (c || (d >= e)))' -a 0,1,0,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b && (c || (d >= e)))'\'' -a 0,1,0,0,0'

echo '$ test-expr '\''a != (b && (c || (d >= e)))'\'' -a 0,1,1,2,2'
test-expr 'a != (b && (c || (d >= e)))' -a 0,1,1,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b && (c || (d >= e)))'\'' -a 0,1,1,2,2'

echo '$ test-expr '\''a != (b && (c || (d >= e)))'\'' -a 0,1,2,0,2'
test-expr 'a != (b && (c || (d >= e)))' -a 0,1,2,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b && (c || (d >= e)))'\'' -a 0,1,2,0,2'

echo '$ test-expr '\''a != (b && (c || (d >= e)))'\'' -a 0,2,1,0,2'
test-expr 'a != (b && (c || (d >= e)))' -a 0,2,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b && (c || (d >= e)))'\'' -a 0,2,1,0,2'

echo '$ test-expr '\''a != (b && (c || (d >= e)))'\'' -a 0,2,2,1,2'
test-expr 'a != (b && (c || (d >= e)))' -a 0,2,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b && (c || (d >= e)))'\'' -a 0,2,2,1,2'

echo '$ test-expr '\''a != (b && (c || (d >= e)))'\'' -a 1,0,1,2,2'
test-expr 'a != (b && (c || (d >= e)))' -a 1,0,1,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b && (c || (d >= e)))'\'' -a 1,0,1,2,2'

echo '$ test-expr '\''a != (b && (c || (d >= e)))'\'' -a 1,1,0,0,0'
test-expr 'a != (b && (c || (d >= e)))' -a 1,1,0,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b && (c || (d >= e)))'\'' -a 1,1,0,0,0'

echo '$ test-expr '\''a != (b && (c || (d >= e)))'\'' -a 1,1,0,0,2'
test-expr 'a != (b && (c || (d >= e)))' -a 1,1,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b && (c || (d >= e)))'\'' -a 1,1,0,0,2'

echo '$ test-expr '\''a != (b && (c || (d >= e)))'\'' -a 1,1,1,2,1'
test-expr 'a != (b && (c || (d >= e)))' -a 1,1,1,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b && (c || (d >= e)))'\'' -a 1,1,1,2,1'

echo '$ test-expr '\''a != (b && (c || (d >= e)))'\'' -a 1,1,1,2,2'
test-expr 'a != (b && (c || (d >= e)))' -a 1,1,1,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b && (c || (d >= e)))'\'' -a 1,1,1,2,2'

echo '$ test-expr '\''a != (b && (c || (d >= e)))'\'' -a 1,1,2,1,0'
test-expr 'a != (b && (c || (d >= e)))' -a 1,1,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b && (c || (d >= e)))'\'' -a 1,1,2,1,0'

echo '$ test-expr '\''a != (b && (c || (d >= e)))'\'' -a 1,2,0,1,2'
test-expr 'a != (b && (c || (d >= e)))' -a 1,2,0,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b && (c || (d >= e)))'\'' -a 1,2,0,1,2'

echo '$ test-expr '\''a != (b && (c || (d >= e)))'\'' -a 2,0,0,2,0'
test-expr 'a != (b && (c || (d >= e)))' -a 2,0,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b && (c || (d >= e)))'\'' -a 2,0,0,2,0'

echo '$ test-expr '\''a != (b && (c || (d >= e)))'\'' -a 2,0,0,2,1'
test-expr 'a != (b && (c || (d >= e)))' -a 2,0,0,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b && (c || (d >= e)))'\'' -a 2,0,0,2,1'

echo '$ test-expr '\''a != (b && (c || (d >= e)))'\'' -a 2,0,1,1,2'
test-expr 'a != (b && (c || (d >= e)))' -a 2,0,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b && (c || (d >= e)))'\'' -a 2,0,1,1,2'

echo '$ test-expr '\''a != (b && (c || (d >= e)))'\'' -a 2,0,1,2,1'
test-expr 'a != (b && (c || (d >= e)))' -a 2,0,1,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b && (c || (d >= e)))'\'' -a 2,0,1,2,1'

echo '$ test-expr '\''a != (b && (c || (d >= e)))'\'' -a 2,0,1,2,2'
test-expr 'a != (b && (c || (d >= e)))' -a 2,0,1,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b && (c || (d >= e)))'\'' -a 2,0,1,2,2'

echo '$ test-expr '\''a != (b && (c || (d >= e)))'\'' -a 2,0,2,1,0'
test-expr 'a != (b && (c || (d >= e)))' -a 2,0,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b && (c || (d >= e)))'\'' -a 2,0,2,1,0'

echo '$ test-expr '\''a != (b && (c || (d >= e)))'\'' -a 2,1,0,1,2'
test-expr 'a != (b && (c || (d >= e)))' -a 2,1,0,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b && (c || (d >= e)))'\'' -a 2,1,0,1,2'

echo '$ test-expr '\''a != (b && (c || (d >= e)))'\'' -a 2,1,0,2,1'
test-expr 'a != (b && (c || (d >= e)))' -a 2,1,0,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b && (c || (d >= e)))'\'' -a 2,1,0,2,1'

echo '$ test-expr '\''a != (b && (c || (d >= e)))'\'' -a 2,1,1,2,1'
test-expr 'a != (b && (c || (d >= e)))' -a 2,1,1,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b && (c || (d >= e)))'\'' -a 2,1,1,2,1'

echo '$ test-expr '\''a != (b && (c || (d >= e)))'\'' -a 2,2,1,0,0'
test-expr 'a != (b && (c || (d >= e)))' -a 2,2,1,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b && (c || (d >= e)))'\'' -a 2,2,1,0,0'

echo '$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 0,0,0,2,1'
test-expr 'a != (b && ((c >= d) || e))' -a 0,0,0,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b && ((c >= d) || e))'\'' -a 0,0,0,2,1'

echo '$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 0,0,1,2,0'
test-expr 'a != (b && ((c >= d) || e))' -a 0,0,1,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b && ((c >= d) || e))'\'' -a 0,0,1,2,0'

echo '$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 0,0,2,2,0'
test-expr 'a != (b && ((c >= d) || e))' -a 0,0,2,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b && ((c >= d) || e))'\'' -a 0,0,2,2,0'

echo '$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 0,0,2,2,1'
test-expr 'a != (b && ((c >= d) || e))' -a 0,0,2,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b && ((c >= d) || e))'\'' -a 0,0,2,2,1'

echo '$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 0,1,1,0,1'
test-expr 'a != (b && ((c >= d) || e))' -a 0,1,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b && ((c >= d) || e))'\'' -a 0,1,1,0,1'

echo '$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 0,2,1,0,1'
test-expr 'a != (b && ((c >= d) || e))' -a 0,2,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b && ((c >= d) || e))'\'' -a 0,2,1,0,1'

echo '$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 0,2,1,1,0'
test-expr 'a != (b && ((c >= d) || e))' -a 0,2,1,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b && ((c >= d) || e))'\'' -a 0,2,1,1,0'

echo '$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 0,2,1,2,0'
test-expr 'a != (b && ((c >= d) || e))' -a 0,2,1,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b && ((c >= d) || e))'\'' -a 0,2,1,2,0'

echo '$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 0,2,1,2,2'
test-expr 'a != (b && ((c >= d) || e))' -a 0,2,1,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b && ((c >= d) || e))'\'' -a 0,2,1,2,2'

echo '$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 0,2,2,0,1'
test-expr 'a != (b && ((c >= d) || e))' -a 0,2,2,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b && ((c >= d) || e))'\'' -a 0,2,2,0,1'

echo '$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 0,2,2,1,0'
test-expr 'a != (b && ((c >= d) || e))' -a 0,2,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b && ((c >= d) || e))'\'' -a 0,2,2,1,0'

echo '$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 0,2,2,1,2'
test-expr 'a != (b && ((c >= d) || e))' -a 0,2,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b && ((c >= d) || e))'\'' -a 0,2,2,1,2'

echo '$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 0,2,2,2,2'
test-expr 'a != (b && ((c >= d) || e))' -a 0,2,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b && ((c >= d) || e))'\'' -a 0,2,2,2,2'

echo '$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 1,0,0,0,1'
test-expr 'a != (b && ((c >= d) || e))' -a 1,0,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b && ((c >= d) || e))'\'' -a 1,0,0,0,1'

echo '$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 1,0,2,2,0'
test-expr 'a != (b && ((c >= d) || e))' -a 1,0,2,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b && ((c >= d) || e))'\'' -a 1,0,2,2,0'

echo '$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 1,1,0,1,0'
test-expr 'a != (b && ((c >= d) || e))' -a 1,1,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b && ((c >= d) || e))'\'' -a 1,1,0,1,0'

echo '$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 1,1,1,0,0'
test-expr 'a != (b && ((c >= d) || e))' -a 1,1,1,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b && ((c >= d) || e))'\'' -a 1,1,1,0,0'

echo '$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 1,1,1,2,0'
test-expr 'a != (b && ((c >= d) || e))' -a 1,1,1,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b && ((c >= d) || e))'\'' -a 1,1,1,2,0'

echo '$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 1,1,2,0,0'
test-expr 'a != (b && ((c >= d) || e))' -a 1,1,2,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b && ((c >= d) || e))'\'' -a 1,1,2,0,0'

echo '$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 1,1,2,0,1'
test-expr 'a != (b && ((c >= d) || e))' -a 1,1,2,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b && ((c >= d) || e))'\'' -a 1,1,2,0,1'

echo '$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 1,1,2,2,2'
test-expr 'a != (b && ((c >= d) || e))' -a 1,1,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b && ((c >= d) || e))'\'' -a 1,1,2,2,2'

echo '$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 1,2,0,2,2'
test-expr 'a != (b && ((c >= d) || e))' -a 1,2,0,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b && ((c >= d) || e))'\'' -a 1,2,0,2,2'

echo '$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 1,2,1,0,1'
test-expr 'a != (b && ((c >= d) || e))' -a 1,2,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b && ((c >= d) || e))'\'' -a 1,2,1,0,1'

echo '$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 2,0,2,0,0'
test-expr 'a != (b && ((c >= d) || e))' -a 2,0,2,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b && ((c >= d) || e))'\'' -a 2,0,2,0,0'

echo '$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 2,0,2,0,1'
test-expr 'a != (b && ((c >= d) || e))' -a 2,0,2,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b && ((c >= d) || e))'\'' -a 2,0,2,0,1'

echo '$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 2,1,1,0,1'
test-expr 'a != (b && ((c >= d) || e))' -a 2,1,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b && ((c >= d) || e))'\'' -a 2,1,1,0,1'

echo '$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 2,1,1,1,1'
test-expr 'a != (b && ((c >= d) || e))' -a 2,1,1,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b && ((c >= d) || e))'\'' -a 2,1,1,1,1'

echo '$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 2,1,1,1,2'
test-expr 'a != (b && ((c >= d) || e))' -a 2,1,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b && ((c >= d) || e))'\'' -a 2,1,1,1,2'

echo '$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 2,1,1,2,1'
test-expr 'a != (b && ((c >= d) || e))' -a 2,1,1,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b && ((c >= d) || e))'\'' -a 2,1,1,2,1'

echo '$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 2,1,1,2,2'
test-expr 'a != (b && ((c >= d) || e))' -a 2,1,1,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b && ((c >= d) || e))'\'' -a 2,1,1,2,2'

echo '$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 2,1,2,1,2'
test-expr 'a != (b && ((c >= d) || e))' -a 2,1,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b && ((c >= d) || e))'\'' -a 2,1,2,1,2'

echo '$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 2,2,0,0,1'
test-expr 'a != (b && ((c >= d) || e))' -a 2,2,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b && ((c >= d) || e))'\'' -a 2,2,0,0,1'

echo '$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 2,2,0,1,1'
test-expr 'a != (b && ((c >= d) || e))' -a 2,2,0,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b && ((c >= d) || e))'\'' -a 2,2,0,1,1'

echo '$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 2,2,0,2,0'
test-expr 'a != (b && ((c >= d) || e))' -a 2,2,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b && ((c >= d) || e))'\'' -a 2,2,0,2,0'

echo '$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 2,2,1,0,2'
test-expr 'a != (b && ((c >= d) || e))' -a 2,2,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b && ((c >= d) || e))'\'' -a 2,2,1,0,2'

echo '$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 2,2,1,1,1'
test-expr 'a != (b && ((c >= d) || e))' -a 2,2,1,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b && ((c >= d) || e))'\'' -a 2,2,1,1,1'

echo '$ test-expr '\''a != (b && ((c >= d) || e))'\'' -a 2,2,2,2,1'
test-expr 'a != (b && ((c >= d) || e))' -a 2,2,2,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b && ((c >= d) || e))'\'' -a 2,2,2,2,1'

echo '$ test-expr '\''a != (b && ((c || d) >= e))'\'' -a 0,0,0,1,0'
test-expr 'a != (b && ((c || d) >= e))' -a 0,0,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b && ((c || d) >= e))'\'' -a 0,0,0,1,0'

echo '$ test-expr '\''a != (b && ((c || d) >= e))'\'' -a 0,0,1,0,1'
test-expr 'a != (b && ((c || d) >= e))' -a 0,0,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b && ((c || d) >= e))'\'' -a 0,0,1,0,1'

echo '$ test-expr '\''a != (b && ((c || d) >= e))'\'' -a 0,0,1,2,2'
test-expr 'a != (b && ((c || d) >= e))' -a 0,0,1,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b && ((c || d) >= e))'\'' -a 0,0,1,2,2'

echo '$ test-expr '\''a != (b && ((c || d) >= e))'\'' -a 0,0,2,0,0'
test-expr 'a != (b && ((c || d) >= e))' -a 0,0,2,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b && ((c || d) >= e))'\'' -a 0,0,2,0,0'

echo '$ test-expr '\''a != (b && ((c || d) >= e))'\'' -a 0,0,2,0,2'
test-expr 'a != (b && ((c || d) >= e))' -a 0,0,2,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b && ((c || d) >= e))'\'' -a 0,0,2,0,2'

echo '$ test-expr '\''a != (b && ((c || d) >= e))'\'' -a 0,0,2,1,2'
test-expr 'a != (b && ((c || d) >= e))' -a 0,0,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b && ((c || d) >= e))'\'' -a 0,0,2,1,2'

echo '$ test-expr '\''a != (b && ((c || d) >= e))'\'' -a 0,1,1,1,1'
test-expr 'a != (b && ((c || d) >= e))' -a 0,1,1,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b && ((c || d) >= e))'\'' -a 0,1,1,1,1'

echo '$ test-expr '\''a != (b && ((c || d) >= e))'\'' -a 0,1,1,2,0'
test-expr 'a != (b && ((c || d) >= e))' -a 0,1,1,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b && ((c || d) >= e))'\'' -a 0,1,1,2,0'

echo '$ test-expr '\''a != (b && ((c || d) >= e))'\'' -a 0,1,1,2,2'
test-expr 'a != (b && ((c || d) >= e))' -a 0,1,1,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b && ((c || d) >= e))'\'' -a 0,1,1,2,2'

echo '$ test-expr '\''a != (b && ((c || d) >= e))'\'' -a 0,1,2,0,0'
test-expr 'a != (b && ((c || d) >= e))' -a 0,1,2,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b && ((c || d) >= e))'\'' -a 0,1,2,0,0'

echo '$ test-expr '\''a != (b && ((c || d) >= e))'\'' -a 0,2,0,2,2'
test-expr 'a != (b && ((c || d) >= e))' -a 0,2,0,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b && ((c || d) >= e))'\'' -a 0,2,0,2,2'

echo '$ test-expr '\''a != (b && ((c || d) >= e))'\'' -a 1,0,0,2,2'
test-expr 'a != (b && ((c || d) >= e))' -a 1,0,0,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b && ((c || d) >= e))'\'' -a 1,0,0,2,2'

echo '$ test-expr '\''a != (b && ((c || d) >= e))'\'' -a 1,0,1,1,1'
test-expr 'a != (b && ((c || d) >= e))' -a 1,0,1,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b && ((c || d) >= e))'\'' -a 1,0,1,1,1'

echo '$ test-expr '\''a != (b && ((c || d) >= e))'\'' -a 1,0,2,1,2'
test-expr 'a != (b && ((c || d) >= e))' -a 1,0,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b && ((c || d) >= e))'\'' -a 1,0,2,1,2'

echo '$ test-expr '\''a != (b && ((c || d) >= e))'\'' -a 1,1,0,0,1'
test-expr 'a != (b && ((c || d) >= e))' -a 1,1,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b && ((c || d) >= e))'\'' -a 1,1,0,0,1'

echo '$ test-expr '\''a != (b && ((c || d) >= e))'\'' -a 1,1,0,1,0'
test-expr 'a != (b && ((c || d) >= e))' -a 1,1,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b && ((c || d) >= e))'\'' -a 1,1,0,1,0'

echo '$ test-expr '\''a != (b && ((c || d) >= e))'\'' -a 1,1,0,1,2'
test-expr 'a != (b && ((c || d) >= e))' -a 1,1,0,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b && ((c || d) >= e))'\'' -a 1,1,0,1,2'

echo '$ test-expr '\''a != (b && ((c || d) >= e))'\'' -a 1,1,0,2,0'
test-expr 'a != (b && ((c || d) >= e))' -a 1,1,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b && ((c || d) >= e))'\'' -a 1,1,0,2,0'

echo '$ test-expr '\''a != (b && ((c || d) >= e))'\'' -a 1,1,1,0,0'
test-expr 'a != (b && ((c || d) >= e))' -a 1,1,1,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b && ((c || d) >= e))'\'' -a 1,1,1,0,0'

echo '$ test-expr '\''a != (b && ((c || d) >= e))'\'' -a 1,1,2,0,1'
test-expr 'a != (b && ((c || d) >= e))' -a 1,1,2,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b && ((c || d) >= e))'\'' -a 1,1,2,0,1'

echo '$ test-expr '\''a != (b && ((c || d) >= e))'\'' -a 1,2,0,1,1'
test-expr 'a != (b && ((c || d) >= e))' -a 1,2,0,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b && ((c || d) >= e))'\'' -a 1,2,0,1,1'

echo '$ test-expr '\''a != (b && ((c || d) >= e))'\'' -a 1,2,1,0,2'
test-expr 'a != (b && ((c || d) >= e))' -a 1,2,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b && ((c || d) >= e))'\'' -a 1,2,1,0,2'

echo '$ test-expr '\''a != (b && ((c || d) >= e))'\'' -a 1,2,2,0,1'
test-expr 'a != (b && ((c || d) >= e))' -a 1,2,2,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b && ((c || d) >= e))'\'' -a 1,2,2,0,1'

echo '$ test-expr '\''a != (b && ((c || d) >= e))'\'' -a 2,0,1,0,0'
test-expr 'a != (b && ((c || d) >= e))' -a 2,0,1,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b && ((c || d) >= e))'\'' -a 2,0,1,0,0'

echo '$ test-expr '\''a != (b && ((c || d) >= e))'\'' -a 2,0,1,1,1'
test-expr 'a != (b && ((c || d) >= e))' -a 2,0,1,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b && ((c || d) >= e))'\'' -a 2,0,1,1,1'

echo '$ test-expr '\''a != (b && ((c || d) >= e))'\'' -a 2,0,2,2,2'
test-expr 'a != (b && ((c || d) >= e))' -a 2,0,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b && ((c || d) >= e))'\'' -a 2,0,2,2,2'

echo '$ test-expr '\''a != (b && ((c || d) >= e))'\'' -a 2,1,1,0,0'
test-expr 'a != (b && ((c || d) >= e))' -a 2,1,1,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b && ((c || d) >= e))'\'' -a 2,1,1,0,0'

echo '$ test-expr '\''a != (b && ((c || d) >= e))'\'' -a 2,1,1,1,1'
test-expr 'a != (b && ((c || d) >= e))' -a 2,1,1,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b && ((c || d) >= e))'\'' -a 2,1,1,1,1'

echo '$ test-expr '\''a != (b && ((c || d) >= e))'\'' -a 2,2,2,0,2'
test-expr 'a != (b && ((c || d) >= e))' -a 2,2,2,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b && ((c || d) >= e))'\'' -a 2,2,2,0,2'

echo '$ test-expr '\''a != (b && ((c || d) >= e))'\'' -a 2,2,2,2,2'
test-expr 'a != (b && ((c || d) >= e))' -a 2,2,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b && ((c || d) >= e))'\'' -a 2,2,2,2,2'

echo '$ test-expr '\''a != (b >= (c && (d || e)))'\'' -a 0,0,0,2,2'
test-expr 'a != (b >= (c && (d || e)))' -a 0,0,0,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c && (d || e)))'\'' -a 0,0,0,2,2'

echo '$ test-expr '\''a != (b >= (c && (d || e)))'\'' -a 0,0,1,0,0'
test-expr 'a != (b >= (c && (d || e)))' -a 0,0,1,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c && (d || e)))'\'' -a 0,0,1,0,0'

echo '$ test-expr '\''a != (b >= (c && (d || e)))'\'' -a 0,1,0,0,1'
test-expr 'a != (b >= (c && (d || e)))' -a 0,1,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c && (d || e)))'\'' -a 0,1,0,0,1'

echo '$ test-expr '\''a != (b >= (c && (d || e)))'\'' -a 0,1,0,1,0'
test-expr 'a != (b >= (c && (d || e)))' -a 0,1,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c && (d || e)))'\'' -a 0,1,0,1,0'

echo '$ test-expr '\''a != (b >= (c && (d || e)))'\'' -a 0,1,1,2,1'
test-expr 'a != (b >= (c && (d || e)))' -a 0,1,1,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c && (d || e)))'\'' -a 0,1,1,2,1'

echo '$ test-expr '\''a != (b >= (c && (d || e)))'\'' -a 0,1,2,1,1'
test-expr 'a != (b >= (c && (d || e)))' -a 0,1,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c && (d || e)))'\'' -a 0,1,2,1,1'

echo '$ test-expr '\''a != (b >= (c && (d || e)))'\'' -a 0,1,2,2,1'
test-expr 'a != (b >= (c && (d || e)))' -a 0,1,2,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c && (d || e)))'\'' -a 0,1,2,2,1'

echo '$ test-expr '\''a != (b >= (c && (d || e)))'\'' -a 0,2,0,1,0'
test-expr 'a != (b >= (c && (d || e)))' -a 0,2,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c && (d || e)))'\'' -a 0,2,0,1,0'

echo '$ test-expr '\''a != (b >= (c && (d || e)))'\'' -a 0,2,0,2,1'
test-expr 'a != (b >= (c && (d || e)))' -a 0,2,0,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c && (d || e)))'\'' -a 0,2,0,2,1'

echo '$ test-expr '\''a != (b >= (c && (d || e)))'\'' -a 0,2,0,2,2'
test-expr 'a != (b >= (c && (d || e)))' -a 0,2,0,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c && (d || e)))'\'' -a 0,2,0,2,2'

echo '$ test-expr '\''a != (b >= (c && (d || e)))'\'' -a 1,0,0,2,2'
test-expr 'a != (b >= (c && (d || e)))' -a 1,0,0,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c && (d || e)))'\'' -a 1,0,0,2,2'

echo '$ test-expr '\''a != (b >= (c && (d || e)))'\'' -a 1,0,1,2,1'
test-expr 'a != (b >= (c && (d || e)))' -a 1,0,1,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c && (d || e)))'\'' -a 1,0,1,2,1'

echo '$ test-expr '\''a != (b >= (c && (d || e)))'\'' -a 1,0,2,2,1'
test-expr 'a != (b >= (c && (d || e)))' -a 1,0,2,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c && (d || e)))'\'' -a 1,0,2,2,1'

echo '$ test-expr '\''a != (b >= (c && (d || e)))'\'' -a 1,1,0,1,1'
test-expr 'a != (b >= (c && (d || e)))' -a 1,1,0,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c && (d || e)))'\'' -a 1,1,0,1,1'

echo '$ test-expr '\''a != (b >= (c && (d || e)))'\'' -a 1,1,0,2,0'
test-expr 'a != (b >= (c && (d || e)))' -a 1,1,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c && (d || e)))'\'' -a 1,1,0,2,0'

echo '$ test-expr '\''a != (b >= (c && (d || e)))'\'' -a 1,1,0,2,2'
test-expr 'a != (b >= (c && (d || e)))' -a 1,1,0,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c && (d || e)))'\'' -a 1,1,0,2,2'

echo '$ test-expr '\''a != (b >= (c && (d || e)))'\'' -a 1,1,1,2,0'
test-expr 'a != (b >= (c && (d || e)))' -a 1,1,1,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c && (d || e)))'\'' -a 1,1,1,2,0'

echo '$ test-expr '\''a != (b >= (c && (d || e)))'\'' -a 1,1,2,1,1'
test-expr 'a != (b >= (c && (d || e)))' -a 1,1,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c && (d || e)))'\'' -a 1,1,2,1,1'

echo '$ test-expr '\''a != (b >= (c && (d || e)))'\'' -a 1,2,0,2,2'
test-expr 'a != (b >= (c && (d || e)))' -a 1,2,0,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c && (d || e)))'\'' -a 1,2,0,2,2'

echo '$ test-expr '\''a != (b >= (c && (d || e)))'\'' -a 1,2,2,0,2'
test-expr 'a != (b >= (c && (d || e)))' -a 1,2,2,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c && (d || e)))'\'' -a 1,2,2,0,2'

echo '$ test-expr '\''a != (b >= (c && (d || e)))'\'' -a 1,2,2,2,1'
test-expr 'a != (b >= (c && (d || e)))' -a 1,2,2,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c && (d || e)))'\'' -a 1,2,2,2,1'

echo '$ test-expr '\''a != (b >= (c && (d || e)))'\'' -a 2,0,0,0,2'
test-expr 'a != (b >= (c && (d || e)))' -a 2,0,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c && (d || e)))'\'' -a 2,0,0,0,2'

echo '$ test-expr '\''a != (b >= (c && (d || e)))'\'' -a 2,0,0,1,1'
test-expr 'a != (b >= (c && (d || e)))' -a 2,0,0,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c && (d || e)))'\'' -a 2,0,0,1,1'

echo '$ test-expr '\''a != (b >= (c && (d || e)))'\'' -a 2,0,1,2,2'
test-expr 'a != (b >= (c && (d || e)))' -a 2,0,1,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c && (d || e)))'\'' -a 2,0,1,2,2'

echo '$ test-expr '\''a != (b >= (c && (d || e)))'\'' -a 2,0,2,1,1'
test-expr 'a != (b >= (c && (d || e)))' -a 2,0,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c && (d || e)))'\'' -a 2,0,2,1,1'

echo '$ test-expr '\''a != (b >= (c && (d || e)))'\'' -a 2,0,2,2,1'
test-expr 'a != (b >= (c && (d || e)))' -a 2,0,2,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c && (d || e)))'\'' -a 2,0,2,2,1'

echo '$ test-expr '\''a != (b >= (c && (d || e)))'\'' -a 2,1,0,1,0'
test-expr 'a != (b >= (c && (d || e)))' -a 2,1,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c && (d || e)))'\'' -a 2,1,0,1,0'

echo '$ test-expr '\''a != (b >= (c && (d || e)))'\'' -a 2,1,2,0,2'
test-expr 'a != (b >= (c && (d || e)))' -a 2,1,2,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c && (d || e)))'\'' -a 2,1,2,0,2'

echo '$ test-expr '\''a != (b >= (c && (d || e)))'\'' -a 2,1,2,2,0'
test-expr 'a != (b >= (c && (d || e)))' -a 2,1,2,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c && (d || e)))'\'' -a 2,1,2,2,0'

echo '$ test-expr '\''a != (b >= (c && (d || e)))'\'' -a 2,2,0,0,1'
test-expr 'a != (b >= (c && (d || e)))' -a 2,2,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c && (d || e)))'\'' -a 2,2,0,0,1'

echo '$ test-expr '\''a != (b >= (c && (d || e)))'\'' -a 2,2,0,1,0'
test-expr 'a != (b >= (c && (d || e)))' -a 2,2,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c && (d || e)))'\'' -a 2,2,0,1,0'

echo '$ test-expr '\''a != (b >= (c && (d || e)))'\'' -a 2,2,1,2,1'
test-expr 'a != (b >= (c && (d || e)))' -a 2,2,1,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c && (d || e)))'\'' -a 2,2,1,2,1'

echo '$ test-expr '\''a != (b >= (c && (d || e)))'\'' -a 2,2,1,2,2'
test-expr 'a != (b >= (c && (d || e)))' -a 2,2,1,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c && (d || e)))'\'' -a 2,2,1,2,2'

echo '$ test-expr '\''a != (b >= (c || (d && e)))'\'' -a 0,0,2,1,1'
test-expr 'a != (b >= (c || (d && e)))' -a 0,0,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c || (d && e)))'\'' -a 0,0,2,1,1'

echo '$ test-expr '\''a != (b >= (c || (d && e)))'\'' -a 0,0,2,2,2'
test-expr 'a != (b >= (c || (d && e)))' -a 0,0,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c || (d && e)))'\'' -a 0,0,2,2,2'

echo '$ test-expr '\''a != (b >= (c || (d && e)))'\'' -a 0,1,0,0,0'
test-expr 'a != (b >= (c || (d && e)))' -a 0,1,0,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c || (d && e)))'\'' -a 0,1,0,0,0'

echo '$ test-expr '\''a != (b >= (c || (d && e)))'\'' -a 0,1,0,0,2'
test-expr 'a != (b >= (c || (d && e)))' -a 0,1,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c || (d && e)))'\'' -a 0,1,0,0,2'

echo '$ test-expr '\''a != (b >= (c || (d && e)))'\'' -a 0,1,1,1,1'
test-expr 'a != (b >= (c || (d && e)))' -a 0,1,1,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c || (d && e)))'\'' -a 0,1,1,1,1'

echo '$ test-expr '\''a != (b >= (c || (d && e)))'\'' -a 0,1,1,2,0'
test-expr 'a != (b >= (c || (d && e)))' -a 0,1,1,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c || (d && e)))'\'' -a 0,1,1,2,0'

echo '$ test-expr '\''a != (b >= (c || (d && e)))'\'' -a 0,1,2,2,1'
test-expr 'a != (b >= (c || (d && e)))' -a 0,1,2,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c || (d && e)))'\'' -a 0,1,2,2,1'

echo '$ test-expr '\''a != (b >= (c || (d && e)))'\'' -a 0,2,0,0,2'
test-expr 'a != (b >= (c || (d && e)))' -a 0,2,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c || (d && e)))'\'' -a 0,2,0,0,2'

echo '$ test-expr '\''a != (b >= (c || (d && e)))'\'' -a 0,2,2,0,0'
test-expr 'a != (b >= (c || (d && e)))' -a 0,2,2,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c || (d && e)))'\'' -a 0,2,2,0,0'

echo '$ test-expr '\''a != (b >= (c || (d && e)))'\'' -a 1,0,0,2,0'
test-expr 'a != (b >= (c || (d && e)))' -a 1,0,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c || (d && e)))'\'' -a 1,0,0,2,0'

echo '$ test-expr '\''a != (b >= (c || (d && e)))'\'' -a 1,0,1,0,2'
test-expr 'a != (b >= (c || (d && e)))' -a 1,0,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c || (d && e)))'\'' -a 1,0,1,0,2'

echo '$ test-expr '\''a != (b >= (c || (d && e)))'\'' -a 1,1,0,0,2'
test-expr 'a != (b >= (c || (d && e)))' -a 1,1,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c || (d && e)))'\'' -a 1,1,0,0,2'

echo '$ test-expr '\''a != (b >= (c || (d && e)))'\'' -a 1,1,0,1,0'
test-expr 'a != (b >= (c || (d && e)))' -a 1,1,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c || (d && e)))'\'' -a 1,1,0,1,0'

echo '$ test-expr '\''a != (b >= (c || (d && e)))'\'' -a 1,1,0,1,2'
test-expr 'a != (b >= (c || (d && e)))' -a 1,1,0,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c || (d && e)))'\'' -a 1,1,0,1,2'

echo '$ test-expr '\''a != (b >= (c || (d && e)))'\'' -a 1,1,1,0,1'
test-expr 'a != (b >= (c || (d && e)))' -a 1,1,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c || (d && e)))'\'' -a 1,1,1,0,1'

echo '$ test-expr '\''a != (b >= (c || (d && e)))'\'' -a 1,1,2,0,0'
test-expr 'a != (b >= (c || (d && e)))' -a 1,1,2,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c || (d && e)))'\'' -a 1,1,2,0,0'

echo '$ test-expr '\''a != (b >= (c || (d && e)))'\'' -a 1,1,2,0,2'
test-expr 'a != (b >= (c || (d && e)))' -a 1,1,2,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c || (d && e)))'\'' -a 1,1,2,0,2'

echo '$ test-expr '\''a != (b >= (c || (d && e)))'\'' -a 1,1,2,1,1'
test-expr 'a != (b >= (c || (d && e)))' -a 1,1,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c || (d && e)))'\'' -a 1,1,2,1,1'

echo '$ test-expr '\''a != (b >= (c || (d && e)))'\'' -a 1,1,2,2,1'
test-expr 'a != (b >= (c || (d && e)))' -a 1,1,2,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c || (d && e)))'\'' -a 1,1,2,2,1'

echo '$ test-expr '\''a != (b >= (c || (d && e)))'\'' -a 1,2,1,0,0'
test-expr 'a != (b >= (c || (d && e)))' -a 1,2,1,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c || (d && e)))'\'' -a 1,2,1,0,0'

echo '$ test-expr '\''a != (b >= (c || (d && e)))'\'' -a 1,2,2,0,1'
test-expr 'a != (b >= (c || (d && e)))' -a 1,2,2,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c || (d && e)))'\'' -a 1,2,2,0,1'

echo '$ test-expr '\''a != (b >= (c || (d && e)))'\'' -a 2,0,0,0,0'
test-expr 'a != (b >= (c || (d && e)))' -a 2,0,0,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c || (d && e)))'\'' -a 2,0,0,0,0'

echo '$ test-expr '\''a != (b >= (c || (d && e)))'\'' -a 2,0,1,0,0'
test-expr 'a != (b >= (c || (d && e)))' -a 2,0,1,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c || (d && e)))'\'' -a 2,0,1,0,0'

echo '$ test-expr '\''a != (b >= (c || (d && e)))'\'' -a 2,0,1,0,1'
test-expr 'a != (b >= (c || (d && e)))' -a 2,0,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c || (d && e)))'\'' -a 2,0,1,0,1'

echo '$ test-expr '\''a != (b >= (c || (d && e)))'\'' -a 2,0,2,2,1'
test-expr 'a != (b >= (c || (d && e)))' -a 2,0,2,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c || (d && e)))'\'' -a 2,0,2,2,1'

echo '$ test-expr '\''a != (b >= (c || (d && e)))'\'' -a 2,1,0,0,0'
test-expr 'a != (b >= (c || (d && e)))' -a 2,1,0,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c || (d && e)))'\'' -a 2,1,0,0,0'

echo '$ test-expr '\''a != (b >= (c || (d && e)))'\'' -a 2,1,1,1,2'
test-expr 'a != (b >= (c || (d && e)))' -a 2,1,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c || (d && e)))'\'' -a 2,1,1,1,2'

echo '$ test-expr '\''a != (b >= (c || (d && e)))'\'' -a 2,1,2,2,2'
test-expr 'a != (b >= (c || (d && e)))' -a 2,1,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c || (d && e)))'\'' -a 2,1,2,2,2'

echo '$ test-expr '\''a != (b >= (c || (d && e)))'\'' -a 2,2,0,0,1'
test-expr 'a != (b >= (c || (d && e)))' -a 2,2,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c || (d && e)))'\'' -a 2,2,0,0,1'

echo '$ test-expr '\''a != (b >= (c || (d && e)))'\'' -a 2,2,0,0,2'
test-expr 'a != (b >= (c || (d && e)))' -a 2,2,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c || (d && e)))'\'' -a 2,2,0,0,2'

echo '$ test-expr '\''a != (b >= (c || (d && e)))'\'' -a 2,2,1,0,2'
test-expr 'a != (b >= (c || (d && e)))' -a 2,2,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c || (d && e)))'\'' -a 2,2,1,0,2'

echo '$ test-expr '\''a != (b >= (c || (d && e)))'\'' -a 2,2,1,2,1'
test-expr 'a != (b >= (c || (d && e)))' -a 2,2,1,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c || (d && e)))'\'' -a 2,2,1,2,1'

echo '$ test-expr '\''a != (b >= (c || (d && e)))'\'' -a 2,2,2,2,1'
test-expr 'a != (b >= (c || (d && e)))' -a 2,2,2,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= (c || (d && e)))'\'' -a 2,2,2,2,1'

echo '$ test-expr '\''a != (b >= ((c && d) || e))'\'' -a 0,0,1,1,0'
test-expr 'a != (b >= ((c && d) || e))' -a 0,0,1,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= ((c && d) || e))'\'' -a 0,0,1,1,0'

echo '$ test-expr '\''a != (b >= ((c && d) || e))'\'' -a 0,0,2,0,0'
test-expr 'a != (b >= ((c && d) || e))' -a 0,0,2,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= ((c && d) || e))'\'' -a 0,0,2,0,0'

echo '$ test-expr '\''a != (b >= ((c && d) || e))'\'' -a 0,0,2,1,2'
test-expr 'a != (b >= ((c && d) || e))' -a 0,0,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= ((c && d) || e))'\'' -a 0,0,2,1,2'

echo '$ test-expr '\''a != (b >= ((c && d) || e))'\'' -a 0,0,2,2,1'
test-expr 'a != (b >= ((c && d) || e))' -a 0,0,2,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= ((c && d) || e))'\'' -a 0,0,2,2,1'

echo '$ test-expr '\''a != (b >= ((c && d) || e))'\'' -a 0,1,0,0,1'
test-expr 'a != (b >= ((c && d) || e))' -a 0,1,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= ((c && d) || e))'\'' -a 0,1,0,0,1'

echo '$ test-expr '\''a != (b >= ((c && d) || e))'\'' -a 0,1,0,1,0'
test-expr 'a != (b >= ((c && d) || e))' -a 0,1,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= ((c && d) || e))'\'' -a 0,1,0,1,0'

echo '$ test-expr '\''a != (b >= ((c && d) || e))'\'' -a 0,1,0,2,0'
test-expr 'a != (b >= ((c && d) || e))' -a 0,1,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= ((c && d) || e))'\'' -a 0,1,0,2,0'

echo '$ test-expr '\''a != (b >= ((c && d) || e))'\'' -a 0,1,2,0,1'
test-expr 'a != (b >= ((c && d) || e))' -a 0,1,2,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= ((c && d) || e))'\'' -a 0,1,2,0,1'

echo '$ test-expr '\''a != (b >= ((c && d) || e))'\'' -a 0,2,1,0,1'
test-expr 'a != (b >= ((c && d) || e))' -a 0,2,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= ((c && d) || e))'\'' -a 0,2,1,0,1'

echo '$ test-expr '\''a != (b >= ((c && d) || e))'\'' -a 0,2,2,1,0'
test-expr 'a != (b >= ((c && d) || e))' -a 0,2,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= ((c && d) || e))'\'' -a 0,2,2,1,0'

echo '$ test-expr '\''a != (b >= ((c && d) || e))'\'' -a 1,0,0,0,0'
test-expr 'a != (b >= ((c && d) || e))' -a 1,0,0,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= ((c && d) || e))'\'' -a 1,0,0,0,0'

echo '$ test-expr '\''a != (b >= ((c && d) || e))'\'' -a 1,0,0,2,1'
test-expr 'a != (b >= ((c && d) || e))' -a 1,0,0,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= ((c && d) || e))'\'' -a 1,0,0,2,1'

echo '$ test-expr '\''a != (b >= ((c && d) || e))'\'' -a 1,0,1,1,0'
test-expr 'a != (b >= ((c && d) || e))' -a 1,0,1,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= ((c && d) || e))'\'' -a 1,0,1,1,0'

echo '$ test-expr '\''a != (b >= ((c && d) || e))'\'' -a 1,0,2,2,2'
test-expr 'a != (b >= ((c && d) || e))' -a 1,0,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= ((c && d) || e))'\'' -a 1,0,2,2,2'

echo '$ test-expr '\''a != (b >= ((c && d) || e))'\'' -a 1,1,0,1,2'
test-expr 'a != (b >= ((c && d) || e))' -a 1,1,0,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= ((c && d) || e))'\'' -a 1,1,0,1,2'

echo '$ test-expr '\''a != (b >= ((c && d) || e))'\'' -a 2,0,0,0,2'
test-expr 'a != (b >= ((c && d) || e))' -a 2,0,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= ((c && d) || e))'\'' -a 2,0,0,0,2'

echo '$ test-expr '\''a != (b >= ((c && d) || e))'\'' -a 2,0,0,1,1'
test-expr 'a != (b >= ((c && d) || e))' -a 2,0,0,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= ((c && d) || e))'\'' -a 2,0,0,1,1'

echo '$ test-expr '\''a != (b >= ((c && d) || e))'\'' -a 2,0,1,2,1'
test-expr 'a != (b >= ((c && d) || e))' -a 2,0,1,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= ((c && d) || e))'\'' -a 2,0,1,2,1'

echo '$ test-expr '\''a != (b >= ((c && d) || e))'\'' -a 2,0,2,1,2'
test-expr 'a != (b >= ((c && d) || e))' -a 2,0,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= ((c && d) || e))'\'' -a 2,0,2,1,2'

echo '$ test-expr '\''a != (b >= ((c && d) || e))'\'' -a 2,1,1,0,2'
test-expr 'a != (b >= ((c && d) || e))' -a 2,1,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= ((c && d) || e))'\'' -a 2,1,1,0,2'

echo '$ test-expr '\''a != (b >= ((c && d) || e))'\'' -a 2,1,1,1,2'
test-expr 'a != (b >= ((c && d) || e))' -a 2,1,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= ((c && d) || e))'\'' -a 2,1,1,1,2'

echo '$ test-expr '\''a != (b >= ((c && d) || e))'\'' -a 2,1,2,0,0'
test-expr 'a != (b >= ((c && d) || e))' -a 2,1,2,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= ((c && d) || e))'\'' -a 2,1,2,0,0'

echo '$ test-expr '\''a != (b >= ((c && d) || e))'\'' -a 2,2,0,0,1'
test-expr 'a != (b >= ((c && d) || e))' -a 2,2,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= ((c && d) || e))'\'' -a 2,2,0,0,1'

echo '$ test-expr '\''a != (b >= ((c && d) || e))'\'' -a 2,2,2,1,1'
test-expr 'a != (b >= ((c && d) || e))' -a 2,2,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= ((c && d) || e))'\'' -a 2,2,2,1,1'

echo '$ test-expr '\''a != (b >= ((c && d) || e))'\'' -a 2,2,2,2,0'
test-expr 'a != (b >= ((c && d) || e))' -a 2,2,2,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= ((c && d) || e))'\'' -a 2,2,2,2,0'

echo '$ test-expr '\''a != (b >= ((c || d) && e))'\'' -a 0,0,0,0,1'
test-expr 'a != (b >= ((c || d) && e))' -a 0,0,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= ((c || d) && e))'\'' -a 0,0,0,0,1'

echo '$ test-expr '\''a != (b >= ((c || d) && e))'\'' -a 0,0,1,1,1'
test-expr 'a != (b >= ((c || d) && e))' -a 0,0,1,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= ((c || d) && e))'\'' -a 0,0,1,1,1'

echo '$ test-expr '\''a != (b >= ((c || d) && e))'\'' -a 0,0,1,2,1'
test-expr 'a != (b >= ((c || d) && e))' -a 0,0,1,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= ((c || d) && e))'\'' -a 0,0,1,2,1'

echo '$ test-expr '\''a != (b >= ((c || d) && e))'\'' -a 0,1,1,2,2'
test-expr 'a != (b >= ((c || d) && e))' -a 0,1,1,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= ((c || d) && e))'\'' -a 0,1,1,2,2'

echo '$ test-expr '\''a != (b >= ((c || d) && e))'\'' -a 0,1,2,0,1'
test-expr 'a != (b >= ((c || d) && e))' -a 0,1,2,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= ((c || d) && e))'\'' -a 0,1,2,0,1'

echo '$ test-expr '\''a != (b >= ((c || d) && e))'\'' -a 0,1,2,1,2'
test-expr 'a != (b >= ((c || d) && e))' -a 0,1,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= ((c || d) && e))'\'' -a 0,1,2,1,2'

echo '$ test-expr '\''a != (b >= ((c || d) && e))'\'' -a 0,2,0,0,1'
test-expr 'a != (b >= ((c || d) && e))' -a 0,2,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= ((c || d) && e))'\'' -a 0,2,0,0,1'

echo '$ test-expr '\''a != (b >= ((c || d) && e))'\'' -a 0,2,1,0,0'
test-expr 'a != (b >= ((c || d) && e))' -a 0,2,1,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= ((c || d) && e))'\'' -a 0,2,1,0,0'

echo '$ test-expr '\''a != (b >= ((c || d) && e))'\'' -a 0,2,1,1,2'
test-expr 'a != (b >= ((c || d) && e))' -a 0,2,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= ((c || d) && e))'\'' -a 0,2,1,1,2'

echo '$ test-expr '\''a != (b >= ((c || d) && e))'\'' -a 0,2,2,0,2'
test-expr 'a != (b >= ((c || d) && e))' -a 0,2,2,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= ((c || d) && e))'\'' -a 0,2,2,0,2'

echo '$ test-expr '\''a != (b >= ((c || d) && e))'\'' -a 0,2,2,1,1'
test-expr 'a != (b >= ((c || d) && e))' -a 0,2,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= ((c || d) && e))'\'' -a 0,2,2,1,1'

echo '$ test-expr '\''a != (b >= ((c || d) && e))'\'' -a 1,0,0,0,1'
test-expr 'a != (b >= ((c || d) && e))' -a 1,0,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= ((c || d) && e))'\'' -a 1,0,0,0,1'

echo '$ test-expr '\''a != (b >= ((c || d) && e))'\'' -a 1,0,0,2,0'
test-expr 'a != (b >= ((c || d) && e))' -a 1,0,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= ((c || d) && e))'\'' -a 1,0,0,2,0'

echo '$ test-expr '\''a != (b >= ((c || d) && e))'\'' -a 1,0,1,1,1'
test-expr 'a != (b >= ((c || d) && e))' -a 1,0,1,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= ((c || d) && e))'\'' -a 1,0,1,1,1'

echo '$ test-expr '\''a != (b >= ((c || d) && e))'\'' -a 1,0,2,1,2'
test-expr 'a != (b >= ((c || d) && e))' -a 1,0,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= ((c || d) && e))'\'' -a 1,0,2,1,2'

echo '$ test-expr '\''a != (b >= ((c || d) && e))'\'' -a 1,1,0,1,0'
test-expr 'a != (b >= ((c || d) && e))' -a 1,1,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= ((c || d) && e))'\'' -a 1,1,0,1,0'

echo '$ test-expr '\''a != (b >= ((c || d) && e))'\'' -a 1,1,1,0,2'
test-expr 'a != (b >= ((c || d) && e))' -a 1,1,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= ((c || d) && e))'\'' -a 1,1,1,0,2'

echo '$ test-expr '\''a != (b >= ((c || d) && e))'\'' -a 1,1,1,1,2'
test-expr 'a != (b >= ((c || d) && e))' -a 1,1,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= ((c || d) && e))'\'' -a 1,1,1,1,2'

echo '$ test-expr '\''a != (b >= ((c || d) && e))'\'' -a 1,1,1,2,1'
test-expr 'a != (b >= ((c || d) && e))' -a 1,1,1,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= ((c || d) && e))'\'' -a 1,1,1,2,1'

echo '$ test-expr '\''a != (b >= ((c || d) && e))'\'' -a 1,1,2,2,1'
test-expr 'a != (b >= ((c || d) && e))' -a 1,1,2,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= ((c || d) && e))'\'' -a 1,1,2,2,1'

echo '$ test-expr '\''a != (b >= ((c || d) && e))'\'' -a 1,1,2,2,2'
test-expr 'a != (b >= ((c || d) && e))' -a 1,1,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= ((c || d) && e))'\'' -a 1,1,2,2,2'

echo '$ test-expr '\''a != (b >= ((c || d) && e))'\'' -a 1,2,0,0,1'
test-expr 'a != (b >= ((c || d) && e))' -a 1,2,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= ((c || d) && e))'\'' -a 1,2,0,0,1'

echo '$ test-expr '\''a != (b >= ((c || d) && e))'\'' -a 1,2,0,2,1'
test-expr 'a != (b >= ((c || d) && e))' -a 1,2,0,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= ((c || d) && e))'\'' -a 1,2,0,2,1'

echo '$ test-expr '\''a != (b >= ((c || d) && e))'\'' -a 1,2,2,1,2'
test-expr 'a != (b >= ((c || d) && e))' -a 1,2,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= ((c || d) && e))'\'' -a 1,2,2,1,2'

echo '$ test-expr '\''a != (b >= ((c || d) && e))'\'' -a 1,2,2,2,2'
test-expr 'a != (b >= ((c || d) && e))' -a 1,2,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= ((c || d) && e))'\'' -a 1,2,2,2,2'

echo '$ test-expr '\''a != (b >= ((c || d) && e))'\'' -a 2,0,0,2,2'
test-expr 'a != (b >= ((c || d) && e))' -a 2,0,0,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= ((c || d) && e))'\'' -a 2,0,0,2,2'

echo '$ test-expr '\''a != (b >= ((c || d) && e))'\'' -a 2,0,1,1,0'
test-expr 'a != (b >= ((c || d) && e))' -a 2,0,1,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= ((c || d) && e))'\'' -a 2,0,1,1,0'

echo '$ test-expr '\''a != (b >= ((c || d) && e))'\'' -a 2,0,2,1,1'
test-expr 'a != (b >= ((c || d) && e))' -a 2,0,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= ((c || d) && e))'\'' -a 2,0,2,1,1'

echo '$ test-expr '\''a != (b >= ((c || d) && e))'\'' -a 2,1,0,1,1'
test-expr 'a != (b >= ((c || d) && e))' -a 2,1,0,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b >= ((c || d) && e))'\'' -a 2,1,0,1,1'

echo '$ test-expr '\''a != (b || (c && (d >= e)))'\'' -a 0,0,1,0,2'
test-expr 'a != (b || (c && (d >= e)))' -a 0,0,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c && (d >= e)))'\'' -a 0,0,1,0,2'

echo '$ test-expr '\''a != (b || (c && (d >= e)))'\'' -a 0,0,2,1,0'
test-expr 'a != (b || (c && (d >= e)))' -a 0,0,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c && (d >= e)))'\'' -a 0,0,2,1,0'

echo '$ test-expr '\''a != (b || (c && (d >= e)))'\'' -a 0,1,0,1,1'
test-expr 'a != (b || (c && (d >= e)))' -a 0,1,0,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c && (d >= e)))'\'' -a 0,1,0,1,1'

echo '$ test-expr '\''a != (b || (c && (d >= e)))'\'' -a 0,1,2,0,0'
test-expr 'a != (b || (c && (d >= e)))' -a 0,1,2,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c && (d >= e)))'\'' -a 0,1,2,0,0'

echo '$ test-expr '\''a != (b || (c && (d >= e)))'\'' -a 0,1,2,0,2'
test-expr 'a != (b || (c && (d >= e)))' -a 0,1,2,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c && (d >= e)))'\'' -a 0,1,2,0,2'

echo '$ test-expr '\''a != (b || (c && (d >= e)))'\'' -a 0,1,2,2,1'
test-expr 'a != (b || (c && (d >= e)))' -a 0,1,2,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c && (d >= e)))'\'' -a 0,1,2,2,1'

echo '$ test-expr '\''a != (b || (c && (d >= e)))'\'' -a 0,2,0,0,2'
test-expr 'a != (b || (c && (d >= e)))' -a 0,2,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c && (d >= e)))'\'' -a 0,2,0,0,2'

echo '$ test-expr '\''a != (b || (c && (d >= e)))'\'' -a 0,2,0,2,2'
test-expr 'a != (b || (c && (d >= e)))' -a 0,2,0,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c && (d >= e)))'\'' -a 0,2,0,2,2'

echo '$ test-expr '\''a != (b || (c && (d >= e)))'\'' -a 0,2,1,0,1'
test-expr 'a != (b || (c && (d >= e)))' -a 0,2,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c && (d >= e)))'\'' -a 0,2,1,0,1'

echo '$ test-expr '\''a != (b || (c && (d >= e)))'\'' -a 0,2,1,0,2'
test-expr 'a != (b || (c && (d >= e)))' -a 0,2,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c && (d >= e)))'\'' -a 0,2,1,0,2'

echo '$ test-expr '\''a != (b || (c && (d >= e)))'\'' -a 0,2,1,1,1'
test-expr 'a != (b || (c && (d >= e)))' -a 0,2,1,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c && (d >= e)))'\'' -a 0,2,1,1,1'

echo '$ test-expr '\''a != (b || (c && (d >= e)))'\'' -a 1,0,0,1,2'
test-expr 'a != (b || (c && (d >= e)))' -a 1,0,0,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c && (d >= e)))'\'' -a 1,0,0,1,2'

echo '$ test-expr '\''a != (b || (c && (d >= e)))'\'' -a 1,0,1,0,0'
test-expr 'a != (b || (c && (d >= e)))' -a 1,0,1,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c && (d >= e)))'\'' -a 1,0,1,0,0'

echo '$ test-expr '\''a != (b || (c && (d >= e)))'\'' -a 1,0,1,2,2'
test-expr 'a != (b || (c && (d >= e)))' -a 1,0,1,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c && (d >= e)))'\'' -a 1,0,1,2,2'

echo '$ test-expr '\''a != (b || (c && (d >= e)))'\'' -a 1,1,0,1,1'
test-expr 'a != (b || (c && (d >= e)))' -a 1,1,0,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c && (d >= e)))'\'' -a 1,1,0,1,1'

echo '$ test-expr '\''a != (b || (c && (d >= e)))'\'' -a 1,1,0,1,2'
test-expr 'a != (b || (c && (d >= e)))' -a 1,1,0,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c && (d >= e)))'\'' -a 1,1,0,1,2'

echo '$ test-expr '\''a != (b || (c && (d >= e)))'\'' -a 1,1,0,2,2'
test-expr 'a != (b || (c && (d >= e)))' -a 1,1,0,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c && (d >= e)))'\'' -a 1,1,0,2,2'

echo '$ test-expr '\''a != (b || (c && (d >= e)))'\'' -a 1,1,1,1,1'
test-expr 'a != (b || (c && (d >= e)))' -a 1,1,1,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c && (d >= e)))'\'' -a 1,1,1,1,1'

echo '$ test-expr '\''a != (b || (c && (d >= e)))'\'' -a 1,1,2,0,1'
test-expr 'a != (b || (c && (d >= e)))' -a 1,1,2,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c && (d >= e)))'\'' -a 1,1,2,0,1'

echo '$ test-expr '\''a != (b || (c && (d >= e)))'\'' -a 1,1,2,2,2'
test-expr 'a != (b || (c && (d >= e)))' -a 1,1,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c && (d >= e)))'\'' -a 1,1,2,2,2'

echo '$ test-expr '\''a != (b || (c && (d >= e)))'\'' -a 1,2,0,0,0'
test-expr 'a != (b || (c && (d >= e)))' -a 1,2,0,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c && (d >= e)))'\'' -a 1,2,0,0,0'

echo '$ test-expr '\''a != (b || (c && (d >= e)))'\'' -a 1,2,0,1,1'
test-expr 'a != (b || (c && (d >= e)))' -a 1,2,0,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c && (d >= e)))'\'' -a 1,2,0,1,1'

echo '$ test-expr '\''a != (b || (c && (d >= e)))'\'' -a 1,2,0,2,1'
test-expr 'a != (b || (c && (d >= e)))' -a 1,2,0,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c && (d >= e)))'\'' -a 1,2,0,2,1'

echo '$ test-expr '\''a != (b || (c && (d >= e)))'\'' -a 1,2,1,0,1'
test-expr 'a != (b || (c && (d >= e)))' -a 1,2,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c && (d >= e)))'\'' -a 1,2,1,0,1'

echo '$ test-expr '\''a != (b || (c && (d >= e)))'\'' -a 1,2,2,2,2'
test-expr 'a != (b || (c && (d >= e)))' -a 1,2,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c && (d >= e)))'\'' -a 1,2,2,2,2'

echo '$ test-expr '\''a != (b || (c && (d >= e)))'\'' -a 2,1,0,1,0'
test-expr 'a != (b || (c && (d >= e)))' -a 2,1,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c && (d >= e)))'\'' -a 2,1,0,1,0'

echo '$ test-expr '\''a != (b || (c && (d >= e)))'\'' -a 2,1,0,2,2'
test-expr 'a != (b || (c && (d >= e)))' -a 2,1,0,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c && (d >= e)))'\'' -a 2,1,0,2,2'

echo '$ test-expr '\''a != (b || (c && (d >= e)))'\'' -a 2,1,1,2,2'
test-expr 'a != (b || (c && (d >= e)))' -a 2,1,1,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c && (d >= e)))'\'' -a 2,1,1,2,2'

echo '$ test-expr '\''a != (b || (c && (d >= e)))'\'' -a 2,2,0,0,1'
test-expr 'a != (b || (c && (d >= e)))' -a 2,2,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c && (d >= e)))'\'' -a 2,2,0,0,1'

echo '$ test-expr '\''a != (b || (c && (d >= e)))'\'' -a 2,2,0,1,1'
test-expr 'a != (b || (c && (d >= e)))' -a 2,2,0,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c && (d >= e)))'\'' -a 2,2,0,1,1'

echo '$ test-expr '\''a != (b || (c && (d >= e)))'\'' -a 2,2,2,1,1'
test-expr 'a != (b || (c && (d >= e)))' -a 2,2,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c && (d >= e)))'\'' -a 2,2,2,1,1'

echo '$ test-expr '\''a != (b || (c && (d >= e)))'\'' -a 2,2,2,1,2'
test-expr 'a != (b || (c && (d >= e)))' -a 2,2,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c && (d >= e)))'\'' -a 2,2,2,1,2'

echo '$ test-expr '\''a != (b || (c && (d >= e)))'\'' -a 2,2,2,2,2'
test-expr 'a != (b || (c && (d >= e)))' -a 2,2,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c && (d >= e)))'\'' -a 2,2,2,2,2'

echo '$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 0,0,1,0,0'
test-expr 'a != (b || (c >= (d && e)))' -a 0,0,1,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c >= (d && e)))'\'' -a 0,0,1,0,0'

echo '$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 0,0,1,0,1'
test-expr 'a != (b || (c >= (d && e)))' -a 0,0,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c >= (d && e)))'\'' -a 0,0,1,0,1'

echo '$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 0,0,1,2,0'
test-expr 'a != (b || (c >= (d && e)))' -a 0,0,1,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c >= (d && e)))'\'' -a 0,0,1,2,0'

echo '$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 0,0,1,2,1'
test-expr 'a != (b || (c >= (d && e)))' -a 0,0,1,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c >= (d && e)))'\'' -a 0,0,1,2,1'

echo '$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 0,0,1,2,2'
test-expr 'a != (b || (c >= (d && e)))' -a 0,0,1,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c >= (d && e)))'\'' -a 0,0,1,2,2'

echo '$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 0,0,2,0,2'
test-expr 'a != (b || (c >= (d && e)))' -a 0,0,2,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c >= (d && e)))'\'' -a 0,0,2,0,2'

echo '$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 0,0,2,1,2'
test-expr 'a != (b || (c >= (d && e)))' -a 0,0,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c >= (d && e)))'\'' -a 0,0,2,1,2'

echo '$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 0,0,2,2,2'
test-expr 'a != (b || (c >= (d && e)))' -a 0,0,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c >= (d && e)))'\'' -a 0,0,2,2,2'

echo '$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 0,1,0,0,2'
test-expr 'a != (b || (c >= (d && e)))' -a 0,1,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c >= (d && e)))'\'' -a 0,1,0,0,2'

echo '$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 0,1,0,2,1'
test-expr 'a != (b || (c >= (d && e)))' -a 0,1,0,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c >= (d && e)))'\'' -a 0,1,0,2,1'

echo '$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 0,1,1,0,1'
test-expr 'a != (b || (c >= (d && e)))' -a 0,1,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c >= (d && e)))'\'' -a 0,1,1,0,1'

echo '$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 0,1,1,2,2'
test-expr 'a != (b || (c >= (d && e)))' -a 0,1,1,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c >= (d && e)))'\'' -a 0,1,1,2,2'

echo '$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 0,1,2,2,1'
test-expr 'a != (b || (c >= (d && e)))' -a 0,1,2,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c >= (d && e)))'\'' -a 0,1,2,2,1'

echo '$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 0,2,0,0,0'
test-expr 'a != (b || (c >= (d && e)))' -a 0,2,0,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c >= (d && e)))'\'' -a 0,2,0,0,0'

echo '$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 0,2,0,2,0'
test-expr 'a != (b || (c >= (d && e)))' -a 0,2,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c >= (d && e)))'\'' -a 0,2,0,2,0'

echo '$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 0,2,0,2,1'
test-expr 'a != (b || (c >= (d && e)))' -a 0,2,0,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c >= (d && e)))'\'' -a 0,2,0,2,1'

echo '$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 0,2,1,1,0'
test-expr 'a != (b || (c >= (d && e)))' -a 0,2,1,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c >= (d && e)))'\'' -a 0,2,1,1,0'

echo '$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 0,2,1,2,0'
test-expr 'a != (b || (c >= (d && e)))' -a 0,2,1,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c >= (d && e)))'\'' -a 0,2,1,2,0'

echo '$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 1,0,1,1,1'
test-expr 'a != (b || (c >= (d && e)))' -a 1,0,1,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c >= (d && e)))'\'' -a 1,0,1,1,1'

echo '$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 1,0,2,1,0'
test-expr 'a != (b || (c >= (d && e)))' -a 1,0,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c >= (d && e)))'\'' -a 1,0,2,1,0'

echo '$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 1,1,0,2,2'
test-expr 'a != (b || (c >= (d && e)))' -a 1,1,0,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c >= (d && e)))'\'' -a 1,1,0,2,2'

echo '$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 1,1,1,0,0'
test-expr 'a != (b || (c >= (d && e)))' -a 1,1,1,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c >= (d && e)))'\'' -a 1,1,1,0,0'

echo '$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 1,1,1,1,0'
test-expr 'a != (b || (c >= (d && e)))' -a 1,1,1,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c >= (d && e)))'\'' -a 1,1,1,1,0'

echo '$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 1,1,2,0,2'
test-expr 'a != (b || (c >= (d && e)))' -a 1,1,2,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c >= (d && e)))'\'' -a 1,1,2,0,2'

echo '$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 1,2,2,1,0'
test-expr 'a != (b || (c >= (d && e)))' -a 1,2,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c >= (d && e)))'\'' -a 1,2,2,1,0'

echo '$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 2,0,0,0,0'
test-expr 'a != (b || (c >= (d && e)))' -a 2,0,0,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c >= (d && e)))'\'' -a 2,0,0,0,0'

echo '$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 2,0,0,1,1'
test-expr 'a != (b || (c >= (d && e)))' -a 2,0,0,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c >= (d && e)))'\'' -a 2,0,0,1,1'

echo '$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 2,0,0,1,2'
test-expr 'a != (b || (c >= (d && e)))' -a 2,0,0,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c >= (d && e)))'\'' -a 2,0,0,1,2'

echo '$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 2,1,1,0,0'
test-expr 'a != (b || (c >= (d && e)))' -a 2,1,1,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c >= (d && e)))'\'' -a 2,1,1,0,0'

echo '$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 2,1,1,2,1'
test-expr 'a != (b || (c >= (d && e)))' -a 2,1,1,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c >= (d && e)))'\'' -a 2,1,1,2,1'

echo '$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 2,2,0,0,1'
test-expr 'a != (b || (c >= (d && e)))' -a 2,2,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c >= (d && e)))'\'' -a 2,2,0,0,1'

echo '$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 2,2,0,2,0'
test-expr 'a != (b || (c >= (d && e)))' -a 2,2,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c >= (d && e)))'\'' -a 2,2,0,2,0'

echo '$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 2,2,0,2,1'
test-expr 'a != (b || (c >= (d && e)))' -a 2,2,0,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c >= (d && e)))'\'' -a 2,2,0,2,1'

echo '$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 2,2,1,0,1'
test-expr 'a != (b || (c >= (d && e)))' -a 2,2,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c >= (d && e)))'\'' -a 2,2,1,0,1'

echo '$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 2,2,1,1,0'
test-expr 'a != (b || (c >= (d && e)))' -a 2,2,1,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c >= (d && e)))'\'' -a 2,2,1,1,0'

echo '$ test-expr '\''a != (b || (c >= (d && e)))'\'' -a 2,2,1,2,0'
test-expr 'a != (b || (c >= (d && e)))' -a 2,2,1,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b || (c >= (d && e)))'\'' -a 2,2,1,2,0'

echo '$ test-expr '\''a != (b || ((c && d) >= e))'\'' -a 0,0,0,0,0'
test-expr 'a != (b || ((c && d) >= e))' -a 0,0,0,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b || ((c && d) >= e))'\'' -a 0,0,0,0,0'

echo '$ test-expr '\''a != (b || ((c && d) >= e))'\'' -a 0,0,0,1,0'
test-expr 'a != (b || ((c && d) >= e))' -a 0,0,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b || ((c && d) >= e))'\'' -a 0,0,0,1,0'

echo '$ test-expr '\''a != (b || ((c && d) >= e))'\'' -a 0,0,1,2,1'
test-expr 'a != (b || ((c && d) >= e))' -a 0,0,1,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b || ((c && d) >= e))'\'' -a 0,0,1,2,1'

echo '$ test-expr '\''a != (b || ((c && d) >= e))'\'' -a 0,1,0,0,2'
test-expr 'a != (b || ((c && d) >= e))' -a 0,1,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b || ((c && d) >= e))'\'' -a 0,1,0,0,2'

echo '$ test-expr '\''a != (b || ((c && d) >= e))'\'' -a 0,1,2,0,1'
test-expr 'a != (b || ((c && d) >= e))' -a 0,1,2,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b || ((c && d) >= e))'\'' -a 0,1,2,0,1'

echo '$ test-expr '\''a != (b || ((c && d) >= e))'\'' -a 0,2,0,0,1'
test-expr 'a != (b || ((c && d) >= e))' -a 0,2,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b || ((c && d) >= e))'\'' -a 0,2,0,0,1'

echo '$ test-expr '\''a != (b || ((c && d) >= e))'\'' -a 0,2,1,0,0'
test-expr 'a != (b || ((c && d) >= e))' -a 0,2,1,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b || ((c && d) >= e))'\'' -a 0,2,1,0,0'

echo '$ test-expr '\''a != (b || ((c && d) >= e))'\'' -a 0,2,2,0,1'
test-expr 'a != (b || ((c && d) >= e))' -a 0,2,2,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b || ((c && d) >= e))'\'' -a 0,2,2,0,1'

echo '$ test-expr '\''a != (b || ((c && d) >= e))'\'' -a 0,2,2,1,0'
test-expr 'a != (b || ((c && d) >= e))' -a 0,2,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b || ((c && d) >= e))'\'' -a 0,2,2,1,0'

echo '$ test-expr '\''a != (b || ((c && d) >= e))'\'' -a 0,2,2,2,0'
test-expr 'a != (b || ((c && d) >= e))' -a 0,2,2,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b || ((c && d) >= e))'\'' -a 0,2,2,2,0'

echo '$ test-expr '\''a != (b || ((c && d) >= e))'\'' -a 1,0,1,0,1'
test-expr 'a != (b || ((c && d) >= e))' -a 1,0,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b || ((c && d) >= e))'\'' -a 1,0,1,0,1'

echo '$ test-expr '\''a != (b || ((c && d) >= e))'\'' -a 1,0,1,2,1'
test-expr 'a != (b || ((c && d) >= e))' -a 1,0,1,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b || ((c && d) >= e))'\'' -a 1,0,1,2,1'

echo '$ test-expr '\''a != (b || ((c && d) >= e))'\'' -a 1,0,2,0,0'
test-expr 'a != (b || ((c && d) >= e))' -a 1,0,2,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b || ((c && d) >= e))'\'' -a 1,0,2,0,0'

echo '$ test-expr '\''a != (b || ((c && d) >= e))'\'' -a 1,1,2,0,2'
test-expr 'a != (b || ((c && d) >= e))' -a 1,1,2,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b || ((c && d) >= e))'\'' -a 1,1,2,0,2'

echo '$ test-expr '\''a != (b || ((c && d) >= e))'\'' -a 1,2,0,0,1'
test-expr 'a != (b || ((c && d) >= e))' -a 1,2,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b || ((c && d) >= e))'\'' -a 1,2,0,0,1'

echo '$ test-expr '\''a != (b || ((c && d) >= e))'\'' -a 1,2,0,2,1'
test-expr 'a != (b || ((c && d) >= e))' -a 1,2,0,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b || ((c && d) >= e))'\'' -a 1,2,0,2,1'

echo '$ test-expr '\''a != (b || ((c && d) >= e))'\'' -a 1,2,2,0,0'
test-expr 'a != (b || ((c && d) >= e))' -a 1,2,2,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b || ((c && d) >= e))'\'' -a 1,2,2,0,0'

echo '$ test-expr '\''a != (b || ((c && d) >= e))'\'' -a 1,2,2,1,1'
test-expr 'a != (b || ((c && d) >= e))' -a 1,2,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b || ((c && d) >= e))'\'' -a 1,2,2,1,1'

echo '$ test-expr '\''a != (b || ((c && d) >= e))'\'' -a 2,0,0,0,0'
test-expr 'a != (b || ((c && d) >= e))' -a 2,0,0,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b || ((c && d) >= e))'\'' -a 2,0,0,0,0'

echo '$ test-expr '\''a != (b || ((c && d) >= e))'\'' -a 2,0,1,2,2'
test-expr 'a != (b || ((c && d) >= e))' -a 2,0,1,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b || ((c && d) >= e))'\'' -a 2,0,1,2,2'

echo '$ test-expr '\''a != (b || ((c && d) >= e))'\'' -a 2,1,0,1,1'
test-expr 'a != (b || ((c && d) >= e))' -a 2,1,0,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b || ((c && d) >= e))'\'' -a 2,1,0,1,1'

echo '$ test-expr '\''a != (b || ((c && d) >= e))'\'' -a 2,1,1,1,0'
test-expr 'a != (b || ((c && d) >= e))' -a 2,1,1,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b || ((c && d) >= e))'\'' -a 2,1,1,1,0'

echo '$ test-expr '\''a != (b || ((c && d) >= e))'\'' -a 2,1,1,1,2'
test-expr 'a != (b || ((c && d) >= e))' -a 2,1,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b || ((c && d) >= e))'\'' -a 2,1,1,1,2'

echo '$ test-expr '\''a != (b || ((c && d) >= e))'\'' -a 2,2,0,0,0'
test-expr 'a != (b || ((c && d) >= e))' -a 2,2,0,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b || ((c && d) >= e))'\'' -a 2,2,0,0,0'

echo '$ test-expr '\''a != (b || ((c && d) >= e))'\'' -a 2,2,0,2,1'
test-expr 'a != (b || ((c && d) >= e))' -a 2,2,0,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b || ((c && d) >= e))'\'' -a 2,2,0,2,1'

echo '$ test-expr '\''a != (b || ((c && d) >= e))'\'' -a 2,2,1,1,2'
test-expr 'a != (b || ((c && d) >= e))' -a 2,2,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b || ((c && d) >= e))'\'' -a 2,2,1,1,2'

echo '$ test-expr '\''a != (b || ((c && d) >= e))'\'' -a 2,2,2,1,2'
test-expr 'a != (b || ((c && d) >= e))' -a 2,2,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b || ((c && d) >= e))'\'' -a 2,2,2,1,2'

echo '$ test-expr '\''a != (b || ((c && d) >= e))'\'' -a 2,2,2,2,0'
test-expr 'a != (b || ((c && d) >= e))' -a 2,2,2,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b || ((c && d) >= e))'\'' -a 2,2,2,2,0'

echo '$ test-expr '\''a != (b || ((c >= d) && e))'\'' -a 0,0,0,0,0'
test-expr 'a != (b || ((c >= d) && e))' -a 0,0,0,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b || ((c >= d) && e))'\'' -a 0,0,0,0,0'

echo '$ test-expr '\''a != (b || ((c >= d) && e))'\'' -a 0,0,1,2,2'
test-expr 'a != (b || ((c >= d) && e))' -a 0,0,1,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b || ((c >= d) && e))'\'' -a 0,0,1,2,2'

echo '$ test-expr '\''a != (b || ((c >= d) && e))'\'' -a 0,0,2,0,0'
test-expr 'a != (b || ((c >= d) && e))' -a 0,0,2,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b || ((c >= d) && e))'\'' -a 0,0,2,0,0'

echo '$ test-expr '\''a != (b || ((c >= d) && e))'\'' -a 0,0,2,0,2'
test-expr 'a != (b || ((c >= d) && e))' -a 0,0,2,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b || ((c >= d) && e))'\'' -a 0,0,2,0,2'

echo '$ test-expr '\''a != (b || ((c >= d) && e))'\'' -a 0,1,1,2,0'
test-expr 'a != (b || ((c >= d) && e))' -a 0,1,1,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b || ((c >= d) && e))'\'' -a 0,1,1,2,0'

echo '$ test-expr '\''a != (b || ((c >= d) && e))'\'' -a 0,1,2,1,1'
test-expr 'a != (b || ((c >= d) && e))' -a 0,1,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b || ((c >= d) && e))'\'' -a 0,1,2,1,1'

echo '$ test-expr '\''a != (b || ((c >= d) && e))'\'' -a 0,1,2,1,2'
test-expr 'a != (b || ((c >= d) && e))' -a 0,1,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b || ((c >= d) && e))'\'' -a 0,1,2,1,2'

echo '$ test-expr '\''a != (b || ((c >= d) && e))'\'' -a 0,2,0,0,0'
test-expr 'a != (b || ((c >= d) && e))' -a 0,2,0,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b || ((c >= d) && e))'\'' -a 0,2,0,0,0'

echo '$ test-expr '\''a != (b || ((c >= d) && e))'\'' -a 0,2,0,1,1'
test-expr 'a != (b || ((c >= d) && e))' -a 0,2,0,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b || ((c >= d) && e))'\'' -a 0,2,0,1,1'

echo '$ test-expr '\''a != (b || ((c >= d) && e))'\'' -a 0,2,0,2,0'
test-expr 'a != (b || ((c >= d) && e))' -a 0,2,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b || ((c >= d) && e))'\'' -a 0,2,0,2,0'

echo '$ test-expr '\''a != (b || ((c >= d) && e))'\'' -a 0,2,0,2,1'
test-expr 'a != (b || ((c >= d) && e))' -a 0,2,0,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b || ((c >= d) && e))'\'' -a 0,2,0,2,1'

echo '$ test-expr '\''a != (b || ((c >= d) && e))'\'' -a 1,0,0,1,2'
test-expr 'a != (b || ((c >= d) && e))' -a 1,0,0,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b || ((c >= d) && e))'\'' -a 1,0,0,1,2'

echo '$ test-expr '\''a != (b || ((c >= d) && e))'\'' -a 1,0,1,1,2'
test-expr 'a != (b || ((c >= d) && e))' -a 1,0,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b || ((c >= d) && e))'\'' -a 1,0,1,1,2'

echo '$ test-expr '\''a != (b || ((c >= d) && e))'\'' -a 1,0,2,0,2'
test-expr 'a != (b || ((c >= d) && e))' -a 1,0,2,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b || ((c >= d) && e))'\'' -a 1,0,2,0,2'

echo '$ test-expr '\''a != (b || ((c >= d) && e))'\'' -a 1,1,0,1,2'
test-expr 'a != (b || ((c >= d) && e))' -a 1,1,0,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b || ((c >= d) && e))'\'' -a 1,1,0,1,2'

echo '$ test-expr '\''a != (b || ((c >= d) && e))'\'' -a 1,1,1,0,1'
test-expr 'a != (b || ((c >= d) && e))' -a 1,1,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b || ((c >= d) && e))'\'' -a 1,1,1,0,1'

echo '$ test-expr '\''a != (b || ((c >= d) && e))'\'' -a 1,2,0,2,0'
test-expr 'a != (b || ((c >= d) && e))' -a 1,2,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b || ((c >= d) && e))'\'' -a 1,2,0,2,0'

echo '$ test-expr '\''a != (b || ((c >= d) && e))'\'' -a 1,2,1,0,0'
test-expr 'a != (b || ((c >= d) && e))' -a 1,2,1,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b || ((c >= d) && e))'\'' -a 1,2,1,0,0'

echo '$ test-expr '\''a != (b || ((c >= d) && e))'\'' -a 1,2,1,1,0'
test-expr 'a != (b || ((c >= d) && e))' -a 1,2,1,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b || ((c >= d) && e))'\'' -a 1,2,1,1,0'

echo '$ test-expr '\''a != (b || ((c >= d) && e))'\'' -a 1,2,1,2,2'
test-expr 'a != (b || ((c >= d) && e))' -a 1,2,1,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b || ((c >= d) && e))'\'' -a 1,2,1,2,2'

echo '$ test-expr '\''a != (b || ((c >= d) && e))'\'' -a 1,2,2,2,2'
test-expr 'a != (b || ((c >= d) && e))' -a 1,2,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b || ((c >= d) && e))'\'' -a 1,2,2,2,2'

echo '$ test-expr '\''a != (b || ((c >= d) && e))'\'' -a 2,0,0,0,2'
test-expr 'a != (b || ((c >= d) && e))' -a 2,0,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b || ((c >= d) && e))'\'' -a 2,0,0,0,2'

echo '$ test-expr '\''a != (b || ((c >= d) && e))'\'' -a 2,0,0,2,2'
test-expr 'a != (b || ((c >= d) && e))' -a 2,0,0,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b || ((c >= d) && e))'\'' -a 2,0,0,2,2'

echo '$ test-expr '\''a != (b || ((c >= d) && e))'\'' -a 2,0,1,2,1'
test-expr 'a != (b || ((c >= d) && e))' -a 2,0,1,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b || ((c >= d) && e))'\'' -a 2,0,1,2,1'

echo '$ test-expr '\''a != (b || ((c >= d) && e))'\'' -a 2,0,2,1,1'
test-expr 'a != (b || ((c >= d) && e))' -a 2,0,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b || ((c >= d) && e))'\'' -a 2,0,2,1,1'

echo '$ test-expr '\''a != (b || ((c >= d) && e))'\'' -a 2,1,1,1,2'
test-expr 'a != (b || ((c >= d) && e))' -a 2,1,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != (b || ((c >= d) && e))'\'' -a 2,1,1,1,2'

echo '$ test-expr '\''a != (b || ((c >= d) && e))'\'' -a 2,1,2,2,1'
test-expr 'a != (b || ((c >= d) && e))' -a 2,1,2,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (b || ((c >= d) && e))'\'' -a 2,1,2,2,1'

echo '$ test-expr '\''a != (b || ((c >= d) && e))'\'' -a 2,2,0,0,0'
test-expr 'a != (b || ((c >= d) && e))' -a 2,2,0,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b || ((c >= d) && e))'\'' -a 2,2,0,0,0'

echo '$ test-expr '\''a != (b || ((c >= d) && e))'\'' -a 2,2,0,2,0'
test-expr 'a != (b || ((c >= d) && e))' -a 2,2,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != (b || ((c >= d) && e))'\'' -a 2,2,0,2,0'

echo '$ test-expr '\''a != ((b && c) >= (d || e))'\'' -a 0,0,1,1,0'
test-expr 'a != ((b && c) >= (d || e))' -a 0,0,1,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && c) >= (d || e))'\'' -a 0,0,1,1,0'

echo '$ test-expr '\''a != ((b && c) >= (d || e))'\'' -a 0,0,2,0,1'
test-expr 'a != ((b && c) >= (d || e))' -a 0,0,2,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && c) >= (d || e))'\'' -a 0,0,2,0,1'

echo '$ test-expr '\''a != ((b && c) >= (d || e))'\'' -a 0,1,0,2,2'
test-expr 'a != ((b && c) >= (d || e))' -a 0,1,0,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && c) >= (d || e))'\'' -a 0,1,0,2,2'

echo '$ test-expr '\''a != ((b && c) >= (d || e))'\'' -a 0,1,1,0,2'
test-expr 'a != ((b && c) >= (d || e))' -a 0,1,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && c) >= (d || e))'\'' -a 0,1,1,0,2'

echo '$ test-expr '\''a != ((b && c) >= (d || e))'\'' -a 0,2,2,0,1'
test-expr 'a != ((b && c) >= (d || e))' -a 0,2,2,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && c) >= (d || e))'\'' -a 0,2,2,0,1'

echo '$ test-expr '\''a != ((b && c) >= (d || e))'\'' -a 1,0,0,0,0'
test-expr 'a != ((b && c) >= (d || e))' -a 1,0,0,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && c) >= (d || e))'\'' -a 1,0,0,0,0'

echo '$ test-expr '\''a != ((b && c) >= (d || e))'\'' -a 1,0,0,2,0'
test-expr 'a != ((b && c) >= (d || e))' -a 1,0,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && c) >= (d || e))'\'' -a 1,0,0,2,0'

echo '$ test-expr '\''a != ((b && c) >= (d || e))'\'' -a 1,0,1,0,1'
test-expr 'a != ((b && c) >= (d || e))' -a 1,0,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && c) >= (d || e))'\'' -a 1,0,1,0,1'

echo '$ test-expr '\''a != ((b && c) >= (d || e))'\'' -a 1,0,2,2,2'
test-expr 'a != ((b && c) >= (d || e))' -a 1,0,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && c) >= (d || e))'\'' -a 1,0,2,2,2'

echo '$ test-expr '\''a != ((b && c) >= (d || e))'\'' -a 1,1,0,0,1'
test-expr 'a != ((b && c) >= (d || e))' -a 1,1,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && c) >= (d || e))'\'' -a 1,1,0,0,1'

echo '$ test-expr '\''a != ((b && c) >= (d || e))'\'' -a 1,1,1,2,0'
test-expr 'a != ((b && c) >= (d || e))' -a 1,1,1,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && c) >= (d || e))'\'' -a 1,1,1,2,0'

echo '$ test-expr '\''a != ((b && c) >= (d || e))'\'' -a 1,1,2,1,1'
test-expr 'a != ((b && c) >= (d || e))' -a 1,1,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && c) >= (d || e))'\'' -a 1,1,2,1,1'

echo '$ test-expr '\''a != ((b && c) >= (d || e))'\'' -a 1,2,1,2,0'
test-expr 'a != ((b && c) >= (d || e))' -a 1,2,1,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && c) >= (d || e))'\'' -a 1,2,1,2,0'

echo '$ test-expr '\''a != ((b && c) >= (d || e))'\'' -a 1,2,1,2,1'
test-expr 'a != ((b && c) >= (d || e))' -a 1,2,1,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && c) >= (d || e))'\'' -a 1,2,1,2,1'

echo '$ test-expr '\''a != ((b && c) >= (d || e))'\'' -a 1,2,2,1,2'
test-expr 'a != ((b && c) >= (d || e))' -a 1,2,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && c) >= (d || e))'\'' -a 1,2,2,1,2'

echo '$ test-expr '\''a != ((b && c) >= (d || e))'\'' -a 2,0,0,0,1'
test-expr 'a != ((b && c) >= (d || e))' -a 2,0,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && c) >= (d || e))'\'' -a 2,0,0,0,1'

echo '$ test-expr '\''a != ((b && c) >= (d || e))'\'' -a 2,0,0,2,1'
test-expr 'a != ((b && c) >= (d || e))' -a 2,0,0,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && c) >= (d || e))'\'' -a 2,0,0,2,1'

echo '$ test-expr '\''a != ((b && c) >= (d || e))'\'' -a 2,0,2,0,1'
test-expr 'a != ((b && c) >= (d || e))' -a 2,0,2,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && c) >= (d || e))'\'' -a 2,0,2,0,1'

echo '$ test-expr '\''a != ((b && c) >= (d || e))'\'' -a 2,1,0,0,2'
test-expr 'a != ((b && c) >= (d || e))' -a 2,1,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && c) >= (d || e))'\'' -a 2,1,0,0,2'

echo '$ test-expr '\''a != ((b && c) >= (d || e))'\'' -a 2,1,0,2,0'
test-expr 'a != ((b && c) >= (d || e))' -a 2,1,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && c) >= (d || e))'\'' -a 2,1,0,2,0'

echo '$ test-expr '\''a != ((b && c) >= (d || e))'\'' -a 2,1,0,2,1'
test-expr 'a != ((b && c) >= (d || e))' -a 2,1,0,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && c) >= (d || e))'\'' -a 2,1,0,2,1'

echo '$ test-expr '\''a != ((b && c) >= (d || e))'\'' -a 2,1,1,0,2'
test-expr 'a != ((b && c) >= (d || e))' -a 2,1,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && c) >= (d || e))'\'' -a 2,1,1,0,2'

echo '$ test-expr '\''a != ((b && c) >= (d || e))'\'' -a 2,1,1,1,2'
test-expr 'a != ((b && c) >= (d || e))' -a 2,1,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && c) >= (d || e))'\'' -a 2,1,1,1,2'

echo '$ test-expr '\''a != ((b && c) >= (d || e))'\'' -a 2,2,0,0,1'
test-expr 'a != ((b && c) >= (d || e))' -a 2,2,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && c) >= (d || e))'\'' -a 2,2,0,0,1'

echo '$ test-expr '\''a != ((b && c) >= (d || e))'\'' -a 2,2,1,2,2'
test-expr 'a != ((b && c) >= (d || e))' -a 2,2,1,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && c) >= (d || e))'\'' -a 2,2,1,2,2'

echo '$ test-expr '\''a != ((b && c) >= (d || e))'\'' -a 2,2,2,2,1'
test-expr 'a != ((b && c) >= (d || e))' -a 2,2,2,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && c) >= (d || e))'\'' -a 2,2,2,2,1'

echo '$ test-expr '\''a != ((b && c) || (d >= e))'\'' -a 0,0,0,0,0'
test-expr 'a != ((b && c) || (d >= e))' -a 0,0,0,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && c) || (d >= e))'\'' -a 0,0,0,0,0'

echo '$ test-expr '\''a != ((b && c) || (d >= e))'\'' -a 0,0,0,1,0'
test-expr 'a != ((b && c) || (d >= e))' -a 0,0,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && c) || (d >= e))'\'' -a 0,0,0,1,0'

echo '$ test-expr '\''a != ((b && c) || (d >= e))'\'' -a 0,0,0,2,2'
test-expr 'a != ((b && c) || (d >= e))' -a 0,0,0,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && c) || (d >= e))'\'' -a 0,0,0,2,2'

echo '$ test-expr '\''a != ((b && c) || (d >= e))'\'' -a 0,1,0,2,1'
test-expr 'a != ((b && c) || (d >= e))' -a 0,1,0,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && c) || (d >= e))'\'' -a 0,1,0,2,1'

echo '$ test-expr '\''a != ((b && c) || (d >= e))'\'' -a 0,1,1,0,0'
test-expr 'a != ((b && c) || (d >= e))' -a 0,1,1,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && c) || (d >= e))'\'' -a 0,1,1,0,0'

echo '$ test-expr '\''a != ((b && c) || (d >= e))'\'' -a 0,1,2,0,0'
test-expr 'a != ((b && c) || (d >= e))' -a 0,1,2,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && c) || (d >= e))'\'' -a 0,1,2,0,0'

echo '$ test-expr '\''a != ((b && c) || (d >= e))'\'' -a 0,2,0,2,1'
test-expr 'a != ((b && c) || (d >= e))' -a 0,2,0,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && c) || (d >= e))'\'' -a 0,2,0,2,1'

echo '$ test-expr '\''a != ((b && c) || (d >= e))'\'' -a 0,2,1,0,2'
test-expr 'a != ((b && c) || (d >= e))' -a 0,2,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && c) || (d >= e))'\'' -a 0,2,1,0,2'

echo '$ test-expr '\''a != ((b && c) || (d >= e))'\'' -a 0,2,1,1,2'
test-expr 'a != ((b && c) || (d >= e))' -a 0,2,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && c) || (d >= e))'\'' -a 0,2,1,1,2'

echo '$ test-expr '\''a != ((b && c) || (d >= e))'\'' -a 0,2,1,2,1'
test-expr 'a != ((b && c) || (d >= e))' -a 0,2,1,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && c) || (d >= e))'\'' -a 0,2,1,2,1'

echo '$ test-expr '\''a != ((b && c) || (d >= e))'\'' -a 1,0,1,0,0'
test-expr 'a != ((b && c) || (d >= e))' -a 1,0,1,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && c) || (d >= e))'\'' -a 1,0,1,0,0'

echo '$ test-expr '\''a != ((b && c) || (d >= e))'\'' -a 1,0,1,1,2'
test-expr 'a != ((b && c) || (d >= e))' -a 1,0,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && c) || (d >= e))'\'' -a 1,0,1,1,2'

echo '$ test-expr '\''a != ((b && c) || (d >= e))'\'' -a 1,1,0,2,2'
test-expr 'a != ((b && c) || (d >= e))' -a 1,1,0,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && c) || (d >= e))'\'' -a 1,1,0,2,2'

echo '$ test-expr '\''a != ((b && c) || (d >= e))'\'' -a 2,0,0,2,2'
test-expr 'a != ((b && c) || (d >= e))' -a 2,0,0,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && c) || (d >= e))'\'' -a 2,0,0,2,2'

echo '$ test-expr '\''a != ((b && c) || (d >= e))'\'' -a 2,0,1,2,2'
test-expr 'a != ((b && c) || (d >= e))' -a 2,0,1,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && c) || (d >= e))'\'' -a 2,0,1,2,2'

echo '$ test-expr '\''a != ((b && c) || (d >= e))'\'' -a 2,0,2,0,0'
test-expr 'a != ((b && c) || (d >= e))' -a 2,0,2,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && c) || (d >= e))'\'' -a 2,0,2,0,0'

echo '$ test-expr '\''a != ((b && c) || (d >= e))'\'' -a 2,1,0,1,1'
test-expr 'a != ((b && c) || (d >= e))' -a 2,1,0,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && c) || (d >= e))'\'' -a 2,1,0,1,1'

echo '$ test-expr '\''a != ((b && c) || (d >= e))'\'' -a 2,1,0,2,2'
test-expr 'a != ((b && c) || (d >= e))' -a 2,1,0,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && c) || (d >= e))'\'' -a 2,1,0,2,2'

echo '$ test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 0,0,0,0,1'
test-expr 'a != ((b && (c >= d)) || e)' -a 0,0,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 0,0,0,0,1'

echo '$ test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 0,0,0,1,2'
test-expr 'a != ((b && (c >= d)) || e)' -a 0,0,0,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 0,0,0,1,2'

echo '$ test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 0,0,0,2,0'
test-expr 'a != ((b && (c >= d)) || e)' -a 0,0,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 0,0,0,2,0'

echo '$ test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 0,0,1,0,2'
test-expr 'a != ((b && (c >= d)) || e)' -a 0,0,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 0,0,1,0,2'

echo '$ test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 0,0,1,1,0'
test-expr 'a != ((b && (c >= d)) || e)' -a 0,0,1,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 0,0,1,1,0'

echo '$ test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 0,0,1,1,1'
test-expr 'a != ((b && (c >= d)) || e)' -a 0,0,1,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 0,0,1,1,1'

echo '$ test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 0,0,2,2,1'
test-expr 'a != ((b && (c >= d)) || e)' -a 0,0,2,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 0,0,2,2,1'

echo '$ test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 0,1,0,1,1'
test-expr 'a != ((b && (c >= d)) || e)' -a 0,1,0,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 0,1,0,1,1'

echo '$ test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 0,2,0,0,1'
test-expr 'a != ((b && (c >= d)) || e)' -a 0,2,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 0,2,0,0,1'

echo '$ test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 0,2,0,1,1'
test-expr 'a != ((b && (c >= d)) || e)' -a 0,2,0,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 0,2,0,1,1'

echo '$ test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 0,2,2,0,0'
test-expr 'a != ((b && (c >= d)) || e)' -a 0,2,2,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 0,2,2,0,0'

echo '$ test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 0,2,2,0,1'
test-expr 'a != ((b && (c >= d)) || e)' -a 0,2,2,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 0,2,2,0,1'

echo '$ test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 0,2,2,1,2'
test-expr 'a != ((b && (c >= d)) || e)' -a 0,2,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 0,2,2,1,2'

echo '$ test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 0,2,2,2,0'
test-expr 'a != ((b && (c >= d)) || e)' -a 0,2,2,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 0,2,2,2,0'

echo '$ test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 1,0,0,2,0'
test-expr 'a != ((b && (c >= d)) || e)' -a 1,0,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 1,0,0,2,0'

echo '$ test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 1,0,1,0,2'
test-expr 'a != ((b && (c >= d)) || e)' -a 1,0,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 1,0,1,0,2'

echo '$ test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 1,0,1,2,2'
test-expr 'a != ((b && (c >= d)) || e)' -a 1,0,1,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 1,0,1,2,2'

echo '$ test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 1,0,2,0,2'
test-expr 'a != ((b && (c >= d)) || e)' -a 1,0,2,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 1,0,2,0,2'

echo '$ test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 1,1,0,0,1'
test-expr 'a != ((b && (c >= d)) || e)' -a 1,1,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 1,1,0,0,1'

echo '$ test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 1,1,1,2,2'
test-expr 'a != ((b && (c >= d)) || e)' -a 1,1,1,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 1,1,1,2,2'

echo '$ test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 1,2,0,2,2'
test-expr 'a != ((b && (c >= d)) || e)' -a 1,2,0,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 1,2,0,2,2'

echo '$ test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 1,2,2,1,0'
test-expr 'a != ((b && (c >= d)) || e)' -a 1,2,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 1,2,2,1,0'

echo '$ test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 1,2,2,2,0'
test-expr 'a != ((b && (c >= d)) || e)' -a 1,2,2,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 1,2,2,2,0'

echo '$ test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 2,0,0,1,1'
test-expr 'a != ((b && (c >= d)) || e)' -a 2,0,0,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 2,0,0,1,1'

echo '$ test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 2,1,0,1,0'
test-expr 'a != ((b && (c >= d)) || e)' -a 2,1,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 2,1,0,1,0'

echo '$ test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 2,1,0,1,2'
test-expr 'a != ((b && (c >= d)) || e)' -a 2,1,0,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 2,1,0,1,2'

echo '$ test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 2,1,1,2,1'
test-expr 'a != ((b && (c >= d)) || e)' -a 2,1,1,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 2,1,1,2,1'

echo '$ test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 2,2,0,0,1'
test-expr 'a != ((b && (c >= d)) || e)' -a 2,2,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 2,2,0,0,1'

echo '$ test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 2,2,0,0,2'
test-expr 'a != ((b && (c >= d)) || e)' -a 2,2,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 2,2,0,0,2'

echo '$ test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 2,2,0,1,2'
test-expr 'a != ((b && (c >= d)) || e)' -a 2,2,0,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 2,2,0,1,2'

echo '$ test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 2,2,1,0,0'
test-expr 'a != ((b && (c >= d)) || e)' -a 2,2,1,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 2,2,1,0,0'

echo '$ test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 2,2,2,2,1'
test-expr 'a != ((b && (c >= d)) || e)' -a 2,2,2,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && (c >= d)) || e)'\'' -a 2,2,2,2,1'

echo '$ test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 0,0,0,1,2'
test-expr 'a != ((b && (c || d)) >= e)' -a 0,0,0,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 0,0,0,1,2'

echo '$ test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 0,0,0,2,0'
test-expr 'a != ((b && (c || d)) >= e)' -a 0,0,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 0,0,0,2,0'

echo '$ test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 0,1,2,0,2'
test-expr 'a != ((b && (c || d)) >= e)' -a 0,1,2,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 0,1,2,0,2'

echo '$ test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 0,1,2,1,1'
test-expr 'a != ((b && (c || d)) >= e)' -a 0,1,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 0,1,2,1,1'

echo '$ test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 0,1,2,1,2'
test-expr 'a != ((b && (c || d)) >= e)' -a 0,1,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 0,1,2,1,2'

echo '$ test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 0,2,0,1,0'
test-expr 'a != ((b && (c || d)) >= e)' -a 0,2,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 0,2,0,1,0'

echo '$ test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 0,2,0,2,2'
test-expr 'a != ((b && (c || d)) >= e)' -a 0,2,0,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 0,2,0,2,2'

echo '$ test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 1,0,0,1,2'
test-expr 'a != ((b && (c || d)) >= e)' -a 1,0,0,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 1,0,0,1,2'

echo '$ test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 1,0,1,0,0'
test-expr 'a != ((b && (c || d)) >= e)' -a 1,0,1,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 1,0,1,0,0'

echo '$ test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 1,0,1,2,2'
test-expr 'a != ((b && (c || d)) >= e)' -a 1,0,1,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 1,0,1,2,2'

echo '$ test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 1,1,2,0,1'
test-expr 'a != ((b && (c || d)) >= e)' -a 1,1,2,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 1,1,2,0,1'

echo '$ test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 1,2,1,1,0'
test-expr 'a != ((b && (c || d)) >= e)' -a 1,2,1,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 1,2,1,1,0'

echo '$ test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 1,2,1,2,0'
test-expr 'a != ((b && (c || d)) >= e)' -a 1,2,1,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 1,2,1,2,0'

echo '$ test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 2,0,0,1,1'
test-expr 'a != ((b && (c || d)) >= e)' -a 2,0,0,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 2,0,0,1,1'

echo '$ test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 2,0,1,0,0'
test-expr 'a != ((b && (c || d)) >= e)' -a 2,0,1,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 2,0,1,0,0'

echo '$ test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 2,0,1,2,1'
test-expr 'a != ((b && (c || d)) >= e)' -a 2,0,1,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 2,0,1,2,1'

echo '$ test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 2,0,2,0,2'
test-expr 'a != ((b && (c || d)) >= e)' -a 2,0,2,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 2,0,2,0,2'

echo '$ test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 2,1,0,0,2'
test-expr 'a != ((b && (c || d)) >= e)' -a 2,1,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 2,1,0,0,2'

echo '$ test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 2,1,0,2,0'
test-expr 'a != ((b && (c || d)) >= e)' -a 2,1,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 2,1,0,2,0'

echo '$ test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 2,1,0,2,2'
test-expr 'a != ((b && (c || d)) >= e)' -a 2,1,0,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 2,1,0,2,2'

echo '$ test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 2,1,1,0,2'
test-expr 'a != ((b && (c || d)) >= e)' -a 2,1,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 2,1,1,0,2'

echo '$ test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 2,1,2,1,2'
test-expr 'a != ((b && (c || d)) >= e)' -a 2,1,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 2,1,2,1,2'

echo '$ test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 2,2,0,0,2'
test-expr 'a != ((b && (c || d)) >= e)' -a 2,2,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 2,2,0,0,2'

echo '$ test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 2,2,1,2,2'
test-expr 'a != ((b && (c || d)) >= e)' -a 2,2,1,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 2,2,1,2,2'

echo '$ test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 2,2,2,1,2'
test-expr 'a != ((b && (c || d)) >= e)' -a 2,2,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b && (c || d)) >= e)'\'' -a 2,2,2,1,2'

echo '$ test-expr '\''a != ((b >= c) && (d || e))'\'' -a 0,0,1,0,1'
test-expr 'a != ((b >= c) && (d || e))' -a 0,0,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= c) && (d || e))'\'' -a 0,0,1,0,1'

echo '$ test-expr '\''a != ((b >= c) && (d || e))'\'' -a 0,1,0,2,1'
test-expr 'a != ((b >= c) && (d || e))' -a 0,1,0,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= c) && (d || e))'\'' -a 0,1,0,2,1'

echo '$ test-expr '\''a != ((b >= c) && (d || e))'\'' -a 0,1,2,0,1'
test-expr 'a != ((b >= c) && (d || e))' -a 0,1,2,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= c) && (d || e))'\'' -a 0,1,2,0,1'

echo '$ test-expr '\''a != ((b >= c) && (d || e))'\'' -a 0,1,2,2,2'
test-expr 'a != ((b >= c) && (d || e))' -a 0,1,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= c) && (d || e))'\'' -a 0,1,2,2,2'

echo '$ test-expr '\''a != ((b >= c) && (d || e))'\'' -a 0,2,0,2,0'
test-expr 'a != ((b >= c) && (d || e))' -a 0,2,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= c) && (d || e))'\'' -a 0,2,0,2,0'

echo '$ test-expr '\''a != ((b >= c) && (d || e))'\'' -a 0,2,1,0,2'
test-expr 'a != ((b >= c) && (d || e))' -a 0,2,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= c) && (d || e))'\'' -a 0,2,1,0,2'

echo '$ test-expr '\''a != ((b >= c) && (d || e))'\'' -a 0,2,2,0,2'
test-expr 'a != ((b >= c) && (d || e))' -a 0,2,2,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= c) && (d || e))'\'' -a 0,2,2,0,2'

echo '$ test-expr '\''a != ((b >= c) && (d || e))'\'' -a 1,0,1,1,2'
test-expr 'a != ((b >= c) && (d || e))' -a 1,0,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= c) && (d || e))'\'' -a 1,0,1,1,2'

echo '$ test-expr '\''a != ((b >= c) && (d || e))'\'' -a 1,0,1,2,1'
test-expr 'a != ((b >= c) && (d || e))' -a 1,0,1,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= c) && (d || e))'\'' -a 1,0,1,2,1'

echo '$ test-expr '\''a != ((b >= c) && (d || e))'\'' -a 1,1,0,0,0'
test-expr 'a != ((b >= c) && (d || e))' -a 1,1,0,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= c) && (d || e))'\'' -a 1,1,0,0,0'

echo '$ test-expr '\''a != ((b >= c) && (d || e))'\'' -a 1,1,0,1,2'
test-expr 'a != ((b >= c) && (d || e))' -a 1,1,0,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= c) && (d || e))'\'' -a 1,1,0,1,2'

echo '$ test-expr '\''a != ((b >= c) && (d || e))'\'' -a 1,1,1,1,0'
test-expr 'a != ((b >= c) && (d || e))' -a 1,1,1,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= c) && (d || e))'\'' -a 1,1,1,1,0'

echo '$ test-expr '\''a != ((b >= c) && (d || e))'\'' -a 1,1,2,2,0'
test-expr 'a != ((b >= c) && (d || e))' -a 1,1,2,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= c) && (d || e))'\'' -a 1,1,2,2,0'

echo '$ test-expr '\''a != ((b >= c) && (d || e))'\'' -a 1,2,0,0,2'
test-expr 'a != ((b >= c) && (d || e))' -a 1,2,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= c) && (d || e))'\'' -a 1,2,0,0,2'

echo '$ test-expr '\''a != ((b >= c) && (d || e))'\'' -a 1,2,1,0,0'
test-expr 'a != ((b >= c) && (d || e))' -a 1,2,1,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= c) && (d || e))'\'' -a 1,2,1,0,0'

echo '$ test-expr '\''a != ((b >= c) && (d || e))'\'' -a 1,2,2,0,2'
test-expr 'a != ((b >= c) && (d || e))' -a 1,2,2,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= c) && (d || e))'\'' -a 1,2,2,0,2'

echo '$ test-expr '\''a != ((b >= c) && (d || e))'\'' -a 2,0,1,1,1'
test-expr 'a != ((b >= c) && (d || e))' -a 2,0,1,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= c) && (d || e))'\'' -a 2,0,1,1,1'

echo '$ test-expr '\''a != ((b >= c) && (d || e))'\'' -a 2,1,0,2,1'
test-expr 'a != ((b >= c) && (d || e))' -a 2,1,0,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= c) && (d || e))'\'' -a 2,1,0,2,1'

echo '$ test-expr '\''a != ((b >= c) && (d || e))'\'' -a 2,1,2,1,1'
test-expr 'a != ((b >= c) && (d || e))' -a 2,1,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= c) && (d || e))'\'' -a 2,1,2,1,1'

echo '$ test-expr '\''a != ((b >= c) && (d || e))'\'' -a 2,2,0,0,0'
test-expr 'a != ((b >= c) && (d || e))' -a 2,2,0,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= c) && (d || e))'\'' -a 2,2,0,0,0'

echo '$ test-expr '\''a != ((b >= c) && (d || e))'\'' -a 2,2,1,0,1'
test-expr 'a != ((b >= c) && (d || e))' -a 2,2,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= c) && (d || e))'\'' -a 2,2,1,0,1'

echo '$ test-expr '\''a != ((b >= c) && (d || e))'\'' -a 2,2,2,1,2'
test-expr 'a != ((b >= c) && (d || e))' -a 2,2,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= c) && (d || e))'\'' -a 2,2,2,1,2'

echo '$ test-expr '\''a != ((b >= c) || (d && e))'\'' -a 0,0,0,0,0'
test-expr 'a != ((b >= c) || (d && e))' -a 0,0,0,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= c) || (d && e))'\'' -a 0,0,0,0,0'

echo '$ test-expr '\''a != ((b >= c) || (d && e))'\'' -a 0,0,0,0,1'
test-expr 'a != ((b >= c) || (d && e))' -a 0,0,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= c) || (d && e))'\'' -a 0,0,0,0,1'

echo '$ test-expr '\''a != ((b >= c) || (d && e))'\'' -a 0,0,1,2,1'
test-expr 'a != ((b >= c) || (d && e))' -a 0,0,1,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= c) || (d && e))'\'' -a 0,0,1,2,1'

echo '$ test-expr '\''a != ((b >= c) || (d && e))'\'' -a 0,0,2,2,0'
test-expr 'a != ((b >= c) || (d && e))' -a 0,0,2,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= c) || (d && e))'\'' -a 0,0,2,2,0'

echo '$ test-expr '\''a != ((b >= c) || (d && e))'\'' -a 0,1,0,1,1'
test-expr 'a != ((b >= c) || (d && e))' -a 0,1,0,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= c) || (d && e))'\'' -a 0,1,0,1,1'

echo '$ test-expr '\''a != ((b >= c) || (d && e))'\'' -a 0,1,1,0,2'
test-expr 'a != ((b >= c) || (d && e))' -a 0,1,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= c) || (d && e))'\'' -a 0,1,1,0,2'

echo '$ test-expr '\''a != ((b >= c) || (d && e))'\'' -a 0,1,1,2,1'
test-expr 'a != ((b >= c) || (d && e))' -a 0,1,1,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= c) || (d && e))'\'' -a 0,1,1,2,1'

echo '$ test-expr '\''a != ((b >= c) || (d && e))'\'' -a 0,1,2,2,0'
test-expr 'a != ((b >= c) || (d && e))' -a 0,1,2,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= c) || (d && e))'\'' -a 0,1,2,2,0'

echo '$ test-expr '\''a != ((b >= c) || (d && e))'\'' -a 0,2,0,0,2'
test-expr 'a != ((b >= c) || (d && e))' -a 0,2,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= c) || (d && e))'\'' -a 0,2,0,0,2'

echo '$ test-expr '\''a != ((b >= c) || (d && e))'\'' -a 0,2,2,0,2'
test-expr 'a != ((b >= c) || (d && e))' -a 0,2,2,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= c) || (d && e))'\'' -a 0,2,2,0,2'

echo '$ test-expr '\''a != ((b >= c) || (d && e))'\'' -a 0,2,2,1,0'
test-expr 'a != ((b >= c) || (d && e))' -a 0,2,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= c) || (d && e))'\'' -a 0,2,2,1,0'

echo '$ test-expr '\''a != ((b >= c) || (d && e))'\'' -a 1,0,0,0,0'
test-expr 'a != ((b >= c) || (d && e))' -a 1,0,0,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= c) || (d && e))'\'' -a 1,0,0,0,0'

echo '$ test-expr '\''a != ((b >= c) || (d && e))'\'' -a 1,0,0,0,1'
test-expr 'a != ((b >= c) || (d && e))' -a 1,0,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= c) || (d && e))'\'' -a 1,0,0,0,1'

echo '$ test-expr '\''a != ((b >= c) || (d && e))'\'' -a 1,0,1,0,0'
test-expr 'a != ((b >= c) || (d && e))' -a 1,0,1,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= c) || (d && e))'\'' -a 1,0,1,0,0'

echo '$ test-expr '\''a != ((b >= c) || (d && e))'\'' -a 1,1,0,2,2'
test-expr 'a != ((b >= c) || (d && e))' -a 1,1,0,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= c) || (d && e))'\'' -a 1,1,0,2,2'

echo '$ test-expr '\''a != ((b >= c) || (d && e))'\'' -a 1,2,0,0,1'
test-expr 'a != ((b >= c) || (d && e))' -a 1,2,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= c) || (d && e))'\'' -a 1,2,0,0,1'

echo '$ test-expr '\''a != ((b >= c) || (d && e))'\'' -a 1,2,0,1,0'
test-expr 'a != ((b >= c) || (d && e))' -a 1,2,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= c) || (d && e))'\'' -a 1,2,0,1,0'

echo '$ test-expr '\''a != ((b >= c) || (d && e))'\'' -a 1,2,1,2,0'
test-expr 'a != ((b >= c) || (d && e))' -a 1,2,1,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= c) || (d && e))'\'' -a 1,2,1,2,0'

echo '$ test-expr '\''a != ((b >= c) || (d && e))'\'' -a 1,2,2,0,1'
test-expr 'a != ((b >= c) || (d && e))' -a 1,2,2,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= c) || (d && e))'\'' -a 1,2,2,0,1'

echo '$ test-expr '\''a != ((b >= c) || (d && e))'\'' -a 1,2,2,1,0'
test-expr 'a != ((b >= c) || (d && e))' -a 1,2,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= c) || (d && e))'\'' -a 1,2,2,1,0'

echo '$ test-expr '\''a != ((b >= c) || (d && e))'\'' -a 2,0,1,0,0'
test-expr 'a != ((b >= c) || (d && e))' -a 2,0,1,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= c) || (d && e))'\'' -a 2,0,1,0,0'

echo '$ test-expr '\''a != ((b >= c) || (d && e))'\'' -a 2,0,1,2,1'
test-expr 'a != ((b >= c) || (d && e))' -a 2,0,1,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= c) || (d && e))'\'' -a 2,0,1,2,1'

echo '$ test-expr '\''a != ((b >= c) || (d && e))'\'' -a 2,0,2,1,2'
test-expr 'a != ((b >= c) || (d && e))' -a 2,0,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= c) || (d && e))'\'' -a 2,0,2,1,2'

echo '$ test-expr '\''a != ((b >= c) || (d && e))'\'' -a 2,1,0,0,1'
test-expr 'a != ((b >= c) || (d && e))' -a 2,1,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= c) || (d && e))'\'' -a 2,1,0,0,1'

echo '$ test-expr '\''a != ((b >= c) || (d && e))'\'' -a 2,1,0,1,2'
test-expr 'a != ((b >= c) || (d && e))' -a 2,1,0,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= c) || (d && e))'\'' -a 2,1,0,1,2'

echo '$ test-expr '\''a != ((b >= c) || (d && e))'\'' -a 2,1,2,0,1'
test-expr 'a != ((b >= c) || (d && e))' -a 2,1,2,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= c) || (d && e))'\'' -a 2,1,2,0,1'

echo '$ test-expr '\''a != ((b >= c) || (d && e))'\'' -a 2,1,2,2,1'
test-expr 'a != ((b >= c) || (d && e))' -a 2,1,2,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= c) || (d && e))'\'' -a 2,1,2,2,1'

echo '$ test-expr '\''a != ((b >= c) || (d && e))'\'' -a 2,2,0,1,0'
test-expr 'a != ((b >= c) || (d && e))' -a 2,2,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= c) || (d && e))'\'' -a 2,2,0,1,0'

echo '$ test-expr '\''a != ((b >= c) || (d && e))'\'' -a 2,2,2,2,1'
test-expr 'a != ((b >= c) || (d && e))' -a 2,2,2,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= c) || (d && e))'\'' -a 2,2,2,2,1'

echo '$ test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 0,0,1,2,1'
test-expr 'a != ((b >= (c && d)) || e)' -a 0,0,1,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 0,0,1,2,1'

echo '$ test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 0,0,2,1,0'
test-expr 'a != ((b >= (c && d)) || e)' -a 0,0,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 0,0,2,1,0'

echo '$ test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 0,0,2,2,1'
test-expr 'a != ((b >= (c && d)) || e)' -a 0,0,2,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 0,0,2,2,1'

echo '$ test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 0,1,0,1,0'
test-expr 'a != ((b >= (c && d)) || e)' -a 0,1,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 0,1,0,1,0'

echo '$ test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 0,1,2,0,0'
test-expr 'a != ((b >= (c && d)) || e)' -a 0,1,2,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 0,1,2,0,0'

echo '$ test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 0,1,2,2,2'
test-expr 'a != ((b >= (c && d)) || e)' -a 0,1,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 0,1,2,2,2'

echo '$ test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 0,2,1,0,1'
test-expr 'a != ((b >= (c && d)) || e)' -a 0,2,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 0,2,1,0,1'

echo '$ test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 0,2,2,0,0'
test-expr 'a != ((b >= (c && d)) || e)' -a 0,2,2,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 0,2,2,0,0'

echo '$ test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 1,0,0,2,0'
test-expr 'a != ((b >= (c && d)) || e)' -a 1,0,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 1,0,0,2,0'

echo '$ test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 1,0,1,0,1'
test-expr 'a != ((b >= (c && d)) || e)' -a 1,0,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 1,0,1,0,1'

echo '$ test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 1,0,2,0,1'
test-expr 'a != ((b >= (c && d)) || e)' -a 1,0,2,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 1,0,2,0,1'

echo '$ test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 1,0,2,1,2'
test-expr 'a != ((b >= (c && d)) || e)' -a 1,0,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 1,0,2,1,2'

echo '$ test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 1,0,2,2,2'
test-expr 'a != ((b >= (c && d)) || e)' -a 1,0,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 1,0,2,2,2'

echo '$ test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 1,1,1,0,0'
test-expr 'a != ((b >= (c && d)) || e)' -a 1,1,1,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 1,1,1,0,0'

echo '$ test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 1,2,0,2,0'
test-expr 'a != ((b >= (c && d)) || e)' -a 1,2,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 1,2,0,2,0'

echo '$ test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 1,2,1,0,1'
test-expr 'a != ((b >= (c && d)) || e)' -a 1,2,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 1,2,1,0,1'

echo '$ test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 1,2,2,2,2'
test-expr 'a != ((b >= (c && d)) || e)' -a 1,2,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 1,2,2,2,2'

echo '$ test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 2,0,0,0,0'
test-expr 'a != ((b >= (c && d)) || e)' -a 2,0,0,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 2,0,0,0,0'

echo '$ test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 2,0,2,1,1'
test-expr 'a != ((b >= (c && d)) || e)' -a 2,0,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 2,0,2,1,1'

echo '$ test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 2,0,2,2,0'
test-expr 'a != ((b >= (c && d)) || e)' -a 2,0,2,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 2,0,2,2,0'

echo '$ test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 2,0,2,2,1'
test-expr 'a != ((b >= (c && d)) || e)' -a 2,0,2,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 2,0,2,2,1'

echo '$ test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 2,1,1,2,0'
test-expr 'a != ((b >= (c && d)) || e)' -a 2,1,1,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 2,1,1,2,0'

echo '$ test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 2,1,2,0,0'
test-expr 'a != ((b >= (c && d)) || e)' -a 2,1,2,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 2,1,2,0,0'

echo '$ test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 2,2,0,1,0'
test-expr 'a != ((b >= (c && d)) || e)' -a 2,2,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 2,2,0,1,0'

echo '$ test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 2,2,2,1,0'
test-expr 'a != ((b >= (c && d)) || e)' -a 2,2,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 2,2,2,1,0'

echo '$ test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 2,2,2,2,2'
test-expr 'a != ((b >= (c && d)) || e)' -a 2,2,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= (c && d)) || e)'\'' -a 2,2,2,2,2'

echo '$ test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 0,0,0,0,0'
test-expr 'a != ((b >= (c || d)) && e)' -a 0,0,0,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 0,0,0,0,0'

echo '$ test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 0,0,1,0,2'
test-expr 'a != ((b >= (c || d)) && e)' -a 0,0,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 0,0,1,0,2'

echo '$ test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 0,1,0,0,2'
test-expr 'a != ((b >= (c || d)) && e)' -a 0,1,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 0,1,0,0,2'

echo '$ test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 0,1,1,2,0'
test-expr 'a != ((b >= (c || d)) && e)' -a 0,1,1,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 0,1,1,2,0'

echo '$ test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 0,2,0,1,0'
test-expr 'a != ((b >= (c || d)) && e)' -a 0,2,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 0,2,0,1,0'

echo '$ test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 0,2,0,2,0'
test-expr 'a != ((b >= (c || d)) && e)' -a 0,2,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 0,2,0,2,0'

echo '$ test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 0,2,0,2,1'
test-expr 'a != ((b >= (c || d)) && e)' -a 0,2,0,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 0,2,0,2,1'

echo '$ test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 0,2,2,1,1'
test-expr 'a != ((b >= (c || d)) && e)' -a 0,2,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 0,2,2,1,1'

echo '$ test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 1,0,1,0,0'
test-expr 'a != ((b >= (c || d)) && e)' -a 1,0,1,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 1,0,1,0,0'

echo '$ test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 1,0,1,0,1'
test-expr 'a != ((b >= (c || d)) && e)' -a 1,0,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 1,0,1,0,1'

echo '$ test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 1,0,1,2,2'
test-expr 'a != ((b >= (c || d)) && e)' -a 1,0,1,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 1,0,1,2,2'

echo '$ test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 1,0,2,1,1'
test-expr 'a != ((b >= (c || d)) && e)' -a 1,0,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 1,0,2,1,1'

echo '$ test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 1,0,2,2,1'
test-expr 'a != ((b >= (c || d)) && e)' -a 1,0,2,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 1,0,2,2,1'

echo '$ test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 1,1,1,0,0'
test-expr 'a != ((b >= (c || d)) && e)' -a 1,1,1,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 1,1,1,0,0'

echo '$ test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 1,1,1,0,1'
test-expr 'a != ((b >= (c || d)) && e)' -a 1,1,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 1,1,1,0,1'

echo '$ test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 1,1,2,1,2'
test-expr 'a != ((b >= (c || d)) && e)' -a 1,1,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 1,1,2,1,2'

echo '$ test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 1,2,1,2,0'
test-expr 'a != ((b >= (c || d)) && e)' -a 1,2,1,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 1,2,1,2,0'

echo '$ test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 2,0,0,2,0'
test-expr 'a != ((b >= (c || d)) && e)' -a 2,0,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 2,0,0,2,0'

echo '$ test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 2,0,0,2,2'
test-expr 'a != ((b >= (c || d)) && e)' -a 2,0,0,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 2,0,0,2,2'

echo '$ test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 2,0,1,0,1'
test-expr 'a != ((b >= (c || d)) && e)' -a 2,0,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 2,0,1,0,1'

echo '$ test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 2,1,1,0,0'
test-expr 'a != ((b >= (c || d)) && e)' -a 2,1,1,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 2,1,1,0,0'

echo '$ test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 2,1,2,2,0'
test-expr 'a != ((b >= (c || d)) && e)' -a 2,1,2,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 2,1,2,2,0'

echo '$ test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 2,2,0,1,0'
test-expr 'a != ((b >= (c || d)) && e)' -a 2,2,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 2,2,0,1,0'

echo '$ test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 2,2,0,2,1'
test-expr 'a != ((b >= (c || d)) && e)' -a 2,2,0,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 2,2,0,2,1'

echo '$ test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 2,2,2,2,2'
test-expr 'a != ((b >= (c || d)) && e)' -a 2,2,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b >= (c || d)) && e)'\'' -a 2,2,2,2,2'

echo '$ test-expr '\''a != ((b || c) && (d >= e))'\'' -a 0,0,0,0,0'
test-expr 'a != ((b || c) && (d >= e))' -a 0,0,0,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || c) && (d >= e))'\'' -a 0,0,0,0,0'

echo '$ test-expr '\''a != ((b || c) && (d >= e))'\'' -a 0,0,1,0,0'
test-expr 'a != ((b || c) && (d >= e))' -a 0,0,1,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || c) && (d >= e))'\'' -a 0,0,1,0,0'

echo '$ test-expr '\''a != ((b || c) && (d >= e))'\'' -a 0,0,1,1,2'
test-expr 'a != ((b || c) && (d >= e))' -a 0,0,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || c) && (d >= e))'\'' -a 0,0,1,1,2'

echo '$ test-expr '\''a != ((b || c) && (d >= e))'\'' -a 0,0,1,2,0'
test-expr 'a != ((b || c) && (d >= e))' -a 0,0,1,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || c) && (d >= e))'\'' -a 0,0,1,2,0'

echo '$ test-expr '\''a != ((b || c) && (d >= e))'\'' -a 0,0,2,0,0'
test-expr 'a != ((b || c) && (d >= e))' -a 0,0,2,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || c) && (d >= e))'\'' -a 0,0,2,0,0'

echo '$ test-expr '\''a != ((b || c) && (d >= e))'\'' -a 0,0,2,1,0'
test-expr 'a != ((b || c) && (d >= e))' -a 0,0,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || c) && (d >= e))'\'' -a 0,0,2,1,0'

echo '$ test-expr '\''a != ((b || c) && (d >= e))'\'' -a 0,0,2,1,1'
test-expr 'a != ((b || c) && (d >= e))' -a 0,0,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || c) && (d >= e))'\'' -a 0,0,2,1,1'

echo '$ test-expr '\''a != ((b || c) && (d >= e))'\'' -a 0,1,1,0,0'
test-expr 'a != ((b || c) && (d >= e))' -a 0,1,1,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || c) && (d >= e))'\'' -a 0,1,1,0,0'

echo '$ test-expr '\''a != ((b || c) && (d >= e))'\'' -a 0,1,1,1,1'
test-expr 'a != ((b || c) && (d >= e))' -a 0,1,1,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || c) && (d >= e))'\'' -a 0,1,1,1,1'

echo '$ test-expr '\''a != ((b || c) && (d >= e))'\'' -a 0,2,0,2,2'
test-expr 'a != ((b || c) && (d >= e))' -a 0,2,0,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || c) && (d >= e))'\'' -a 0,2,0,2,2'

echo '$ test-expr '\''a != ((b || c) && (d >= e))'\'' -a 0,2,1,2,1'
test-expr 'a != ((b || c) && (d >= e))' -a 0,2,1,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || c) && (d >= e))'\'' -a 0,2,1,2,1'

echo '$ test-expr '\''a != ((b || c) && (d >= e))'\'' -a 0,2,2,1,0'
test-expr 'a != ((b || c) && (d >= e))' -a 0,2,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || c) && (d >= e))'\'' -a 0,2,2,1,0'

echo '$ test-expr '\''a != ((b || c) && (d >= e))'\'' -a 1,0,0,0,0'
test-expr 'a != ((b || c) && (d >= e))' -a 1,0,0,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || c) && (d >= e))'\'' -a 1,0,0,0,0'

echo '$ test-expr '\''a != ((b || c) && (d >= e))'\'' -a 1,0,0,1,2'
test-expr 'a != ((b || c) && (d >= e))' -a 1,0,0,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || c) && (d >= e))'\'' -a 1,0,0,1,2'

echo '$ test-expr '\''a != ((b || c) && (d >= e))'\'' -a 1,0,2,1,2'
test-expr 'a != ((b || c) && (d >= e))' -a 1,0,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || c) && (d >= e))'\'' -a 1,0,2,1,2'

echo '$ test-expr '\''a != ((b || c) && (d >= e))'\'' -a 1,0,2,2,2'
test-expr 'a != ((b || c) && (d >= e))' -a 1,0,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || c) && (d >= e))'\'' -a 1,0,2,2,2'

echo '$ test-expr '\''a != ((b || c) && (d >= e))'\'' -a 1,1,0,0,2'
test-expr 'a != ((b || c) && (d >= e))' -a 1,1,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || c) && (d >= e))'\'' -a 1,1,0,0,2'

echo '$ test-expr '\''a != ((b || c) && (d >= e))'\'' -a 1,1,1,1,1'
test-expr 'a != ((b || c) && (d >= e))' -a 1,1,1,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || c) && (d >= e))'\'' -a 1,1,1,1,1'

echo '$ test-expr '\''a != ((b || c) && (d >= e))'\'' -a 1,1,2,0,0'
test-expr 'a != ((b || c) && (d >= e))' -a 1,1,2,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || c) && (d >= e))'\'' -a 1,1,2,0,0'

echo '$ test-expr '\''a != ((b || c) && (d >= e))'\'' -a 1,1,2,1,2'
test-expr 'a != ((b || c) && (d >= e))' -a 1,1,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || c) && (d >= e))'\'' -a 1,1,2,1,2'

echo '$ test-expr '\''a != ((b || c) && (d >= e))'\'' -a 1,1,2,2,2'
test-expr 'a != ((b || c) && (d >= e))' -a 1,1,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || c) && (d >= e))'\'' -a 1,1,2,2,2'

echo '$ test-expr '\''a != ((b || c) && (d >= e))'\'' -a 1,2,1,0,0'
test-expr 'a != ((b || c) && (d >= e))' -a 1,2,1,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || c) && (d >= e))'\'' -a 1,2,1,0,0'

echo '$ test-expr '\''a != ((b || c) && (d >= e))'\'' -a 1,2,1,0,2'
test-expr 'a != ((b || c) && (d >= e))' -a 1,2,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || c) && (d >= e))'\'' -a 1,2,1,0,2'

echo '$ test-expr '\''a != ((b || c) && (d >= e))'\'' -a 2,1,0,1,2'
test-expr 'a != ((b || c) && (d >= e))' -a 2,1,0,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || c) && (d >= e))'\'' -a 2,1,0,1,2'

echo '$ test-expr '\''a != ((b || c) && (d >= e))'\'' -a 2,1,0,2,2'
test-expr 'a != ((b || c) && (d >= e))' -a 2,1,0,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || c) && (d >= e))'\'' -a 2,1,0,2,2'

echo '$ test-expr '\''a != ((b || c) && (d >= e))'\'' -a 2,1,1,0,0'
test-expr 'a != ((b || c) && (d >= e))' -a 2,1,1,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || c) && (d >= e))'\'' -a 2,1,1,0,0'

echo '$ test-expr '\''a != ((b || c) && (d >= e))'\'' -a 2,1,1,1,0'
test-expr 'a != ((b || c) && (d >= e))' -a 2,1,1,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || c) && (d >= e))'\'' -a 2,1,1,1,0'

echo '$ test-expr '\''a != ((b || c) && (d >= e))'\'' -a 2,1,2,1,1'
test-expr 'a != ((b || c) && (d >= e))' -a 2,1,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || c) && (d >= e))'\'' -a 2,1,2,1,1'

echo '$ test-expr '\''a != ((b || c) && (d >= e))'\'' -a 2,2,0,0,1'
test-expr 'a != ((b || c) && (d >= e))' -a 2,2,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || c) && (d >= e))'\'' -a 2,2,0,0,1'

echo '$ test-expr '\''a != ((b || c) && (d >= e))'\'' -a 2,2,0,0,2'
test-expr 'a != ((b || c) && (d >= e))' -a 2,2,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || c) && (d >= e))'\'' -a 2,2,0,0,2'

echo '$ test-expr '\''a != ((b || c) && (d >= e))'\'' -a 2,2,1,1,2'
test-expr 'a != ((b || c) && (d >= e))' -a 2,2,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || c) && (d >= e))'\'' -a 2,2,1,1,2'

echo '$ test-expr '\''a != ((b || c) && (d >= e))'\'' -a 2,2,1,2,0'
test-expr 'a != ((b || c) && (d >= e))' -a 2,2,1,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || c) && (d >= e))'\'' -a 2,2,1,2,0'

echo '$ test-expr '\''a != ((b || c) && (d >= e))'\'' -a 2,2,2,0,0'
test-expr 'a != ((b || c) && (d >= e))' -a 2,2,2,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || c) && (d >= e))'\'' -a 2,2,2,0,0'

echo '$ test-expr '\''a != ((b || c) && (d >= e))'\'' -a 2,2,2,1,1'
test-expr 'a != ((b || c) && (d >= e))' -a 2,2,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || c) && (d >= e))'\'' -a 2,2,2,1,1'

echo '$ test-expr '\''a != ((b || c) >= (d && e))'\'' -a 0,0,0,0,0'
test-expr 'a != ((b || c) >= (d && e))' -a 0,0,0,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || c) >= (d && e))'\'' -a 0,0,0,0,0'

echo '$ test-expr '\''a != ((b || c) >= (d && e))'\'' -a 0,0,0,1,0'
test-expr 'a != ((b || c) >= (d && e))' -a 0,0,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || c) >= (d && e))'\'' -a 0,0,0,1,0'

echo '$ test-expr '\''a != ((b || c) >= (d && e))'\'' -a 0,0,1,2,2'
test-expr 'a != ((b || c) >= (d && e))' -a 0,0,1,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || c) >= (d && e))'\'' -a 0,0,1,2,2'

echo '$ test-expr '\''a != ((b || c) >= (d && e))'\'' -a 0,1,2,1,0'
test-expr 'a != ((b || c) >= (d && e))' -a 0,1,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || c) >= (d && e))'\'' -a 0,1,2,1,0'

echo '$ test-expr '\''a != ((b || c) >= (d && e))'\'' -a 0,2,0,2,1'
test-expr 'a != ((b || c) >= (d && e))' -a 0,2,0,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || c) >= (d && e))'\'' -a 0,2,0,2,1'

echo '$ test-expr '\''a != ((b || c) >= (d && e))'\'' -a 0,2,0,2,2'
test-expr 'a != ((b || c) >= (d && e))' -a 0,2,0,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || c) >= (d && e))'\'' -a 0,2,0,2,2'

echo '$ test-expr '\''a != ((b || c) >= (d && e))'\'' -a 0,2,2,0,1'
test-expr 'a != ((b || c) >= (d && e))' -a 0,2,2,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || c) >= (d && e))'\'' -a 0,2,2,0,1'

echo '$ test-expr '\''a != ((b || c) >= (d && e))'\'' -a 0,2,2,1,2'
test-expr 'a != ((b || c) >= (d && e))' -a 0,2,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || c) >= (d && e))'\'' -a 0,2,2,1,2'

echo '$ test-expr '\''a != ((b || c) >= (d && e))'\'' -a 1,0,0,1,2'
test-expr 'a != ((b || c) >= (d && e))' -a 1,0,0,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || c) >= (d && e))'\'' -a 1,0,0,1,2'

echo '$ test-expr '\''a != ((b || c) >= (d && e))'\'' -a 1,0,0,2,0'
test-expr 'a != ((b || c) >= (d && e))' -a 1,0,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || c) >= (d && e))'\'' -a 1,0,0,2,0'

echo '$ test-expr '\''a != ((b || c) >= (d && e))'\'' -a 1,0,1,1,1'
test-expr 'a != ((b || c) >= (d && e))' -a 1,0,1,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || c) >= (d && e))'\'' -a 1,0,1,1,1'

echo '$ test-expr '\''a != ((b || c) >= (d && e))'\'' -a 1,0,2,2,0'
test-expr 'a != ((b || c) >= (d && e))' -a 1,0,2,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || c) >= (d && e))'\'' -a 1,0,2,2,0'

echo '$ test-expr '\''a != ((b || c) >= (d && e))'\'' -a 1,1,0,1,2'
test-expr 'a != ((b || c) >= (d && e))' -a 1,1,0,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || c) >= (d && e))'\'' -a 1,1,0,1,2'

echo '$ test-expr '\''a != ((b || c) >= (d && e))'\'' -a 1,1,0,2,0'
test-expr 'a != ((b || c) >= (d && e))' -a 1,1,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || c) >= (d && e))'\'' -a 1,1,0,2,0'

echo '$ test-expr '\''a != ((b || c) >= (d && e))'\'' -a 1,1,1,1,0'
test-expr 'a != ((b || c) >= (d && e))' -a 1,1,1,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || c) >= (d && e))'\'' -a 1,1,1,1,0'

echo '$ test-expr '\''a != ((b || c) >= (d && e))'\'' -a 1,2,0,1,1'
test-expr 'a != ((b || c) >= (d && e))' -a 1,2,0,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || c) >= (d && e))'\'' -a 1,2,0,1,1'

echo '$ test-expr '\''a != ((b || c) >= (d && e))'\'' -a 1,2,1,0,2'
test-expr 'a != ((b || c) >= (d && e))' -a 1,2,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || c) >= (d && e))'\'' -a 1,2,1,0,2'

echo '$ test-expr '\''a != ((b || c) >= (d && e))'\'' -a 1,2,2,0,1'
test-expr 'a != ((b || c) >= (d && e))' -a 1,2,2,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || c) >= (d && e))'\'' -a 1,2,2,0,1'

echo '$ test-expr '\''a != ((b || c) >= (d && e))'\'' -a 1,2,2,0,2'
test-expr 'a != ((b || c) >= (d && e))' -a 1,2,2,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || c) >= (d && e))'\'' -a 1,2,2,0,2'

echo '$ test-expr '\''a != ((b || c) >= (d && e))'\'' -a 1,2,2,1,1'
test-expr 'a != ((b || c) >= (d && e))' -a 1,2,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || c) >= (d && e))'\'' -a 1,2,2,1,1'

echo '$ test-expr '\''a != ((b || c) >= (d && e))'\'' -a 1,2,2,2,1'
test-expr 'a != ((b || c) >= (d && e))' -a 1,2,2,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || c) >= (d && e))'\'' -a 1,2,2,2,1'

echo '$ test-expr '\''a != ((b || c) >= (d && e))'\'' -a 1,2,2,2,2'
test-expr 'a != ((b || c) >= (d && e))' -a 1,2,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || c) >= (d && e))'\'' -a 1,2,2,2,2'

echo '$ test-expr '\''a != ((b || c) >= (d && e))'\'' -a 2,0,1,0,0'
test-expr 'a != ((b || c) >= (d && e))' -a 2,0,1,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || c) >= (d && e))'\'' -a 2,0,1,0,0'

echo '$ test-expr '\''a != ((b || c) >= (d && e))'\'' -a 2,0,1,0,1'
test-expr 'a != ((b || c) >= (d && e))' -a 2,0,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || c) >= (d && e))'\'' -a 2,0,1,0,1'

echo '$ test-expr '\''a != ((b || c) >= (d && e))'\'' -a 2,1,2,0,0'
test-expr 'a != ((b || c) >= (d && e))' -a 2,1,2,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || c) >= (d && e))'\'' -a 2,1,2,0,0'

echo '$ test-expr '\''a != ((b || c) >= (d && e))'\'' -a 2,2,0,0,0'
test-expr 'a != ((b || c) >= (d && e))' -a 2,2,0,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || c) >= (d && e))'\'' -a 2,2,0,0,0'

echo '$ test-expr '\''a != ((b || c) >= (d && e))'\'' -a 2,2,1,0,1'
test-expr 'a != ((b || c) >= (d && e))' -a 2,2,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || c) >= (d && e))'\'' -a 2,2,1,0,1'

echo '$ test-expr '\''a != ((b || c) >= (d && e))'\'' -a 2,2,2,2,2'
test-expr 'a != ((b || c) >= (d && e))' -a 2,2,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || c) >= (d && e))'\'' -a 2,2,2,2,2'

echo '$ test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 0,0,0,2,2'
test-expr 'a != ((b || (c && d)) >= e)' -a 0,0,0,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 0,0,0,2,2'

echo '$ test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 0,0,1,0,2'
test-expr 'a != ((b || (c && d)) >= e)' -a 0,0,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 0,0,1,0,2'

echo '$ test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 0,0,1,1,0'
test-expr 'a != ((b || (c && d)) >= e)' -a 0,0,1,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 0,0,1,1,0'

echo '$ test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 0,0,1,1,1'
test-expr 'a != ((b || (c && d)) >= e)' -a 0,0,1,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 0,0,1,1,1'

echo '$ test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 0,0,1,2,2'
test-expr 'a != ((b || (c && d)) >= e)' -a 0,0,1,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 0,0,1,2,2'

echo '$ test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 0,1,0,1,2'
test-expr 'a != ((b || (c && d)) >= e)' -a 0,1,0,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 0,1,0,1,2'

echo '$ test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 0,1,1,0,0'
test-expr 'a != ((b || (c && d)) >= e)' -a 0,1,1,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 0,1,1,0,0'

echo '$ test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 0,1,1,1,2'
test-expr 'a != ((b || (c && d)) >= e)' -a 0,1,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 0,1,1,1,2'

echo '$ test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 0,1,2,0,0'
test-expr 'a != ((b || (c && d)) >= e)' -a 0,1,2,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 0,1,2,0,0'

echo '$ test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 0,1,2,0,1'
test-expr 'a != ((b || (c && d)) >= e)' -a 0,1,2,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 0,1,2,0,1'

echo '$ test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 0,1,2,1,0'
test-expr 'a != ((b || (c && d)) >= e)' -a 0,1,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 0,1,2,1,0'

echo '$ test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 0,2,0,0,0'
test-expr 'a != ((b || (c && d)) >= e)' -a 0,2,0,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 0,2,0,0,0'

echo '$ test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 0,2,0,2,1'
test-expr 'a != ((b || (c && d)) >= e)' -a 0,2,0,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 0,2,0,2,1'

echo '$ test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 0,2,2,2,0'
test-expr 'a != ((b || (c && d)) >= e)' -a 0,2,2,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 0,2,2,2,0'

echo '$ test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 1,0,0,0,2'
test-expr 'a != ((b || (c && d)) >= e)' -a 1,0,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 1,0,0,0,2'

echo '$ test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 1,0,0,1,1'
test-expr 'a != ((b || (c && d)) >= e)' -a 1,0,0,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 1,0,0,1,1'

echo '$ test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 1,0,1,0,0'
test-expr 'a != ((b || (c && d)) >= e)' -a 1,0,1,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 1,0,1,0,0'

echo '$ test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 1,0,1,2,0'
test-expr 'a != ((b || (c && d)) >= e)' -a 1,0,1,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 1,0,1,2,0'

echo '$ test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 1,1,0,0,1'
test-expr 'a != ((b || (c && d)) >= e)' -a 1,1,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 1,1,0,0,1'

echo '$ test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 2,0,0,1,2'
test-expr 'a != ((b || (c && d)) >= e)' -a 2,0,0,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 2,0,0,1,2'

echo '$ test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 2,0,1,2,0'
test-expr 'a != ((b || (c && d)) >= e)' -a 2,0,1,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 2,0,1,2,0'

echo '$ test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 2,0,2,0,0'
test-expr 'a != ((b || (c && d)) >= e)' -a 2,0,2,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 2,0,2,0,0'

echo '$ test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 2,0,2,2,2'
test-expr 'a != ((b || (c && d)) >= e)' -a 2,0,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 2,0,2,2,2'

echo '$ test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 2,2,0,2,0'
test-expr 'a != ((b || (c && d)) >= e)' -a 2,2,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 2,2,0,2,0'

echo '$ test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 2,2,2,1,0'
test-expr 'a != ((b || (c && d)) >= e)' -a 2,2,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 2,2,2,1,0'

echo '$ test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 2,2,2,1,2'
test-expr 'a != ((b || (c && d)) >= e)' -a 2,2,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || (c && d)) >= e)'\'' -a 2,2,2,1,2'

echo '$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 0,0,1,0,1'
test-expr 'a != ((b || (c >= d)) && e)' -a 0,0,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 0,0,1,0,1'

echo '$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 0,0,1,2,1'
test-expr 'a != ((b || (c >= d)) && e)' -a 0,0,1,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 0,0,1,2,1'

echo '$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 0,1,0,1,2'
test-expr 'a != ((b || (c >= d)) && e)' -a 0,1,0,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 0,1,0,1,2'

echo '$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 0,1,0,2,0'
test-expr 'a != ((b || (c >= d)) && e)' -a 0,1,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 0,1,0,2,0'

echo '$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 0,1,0,2,2'
test-expr 'a != ((b || (c >= d)) && e)' -a 0,1,0,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 0,1,0,2,2'

echo '$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 0,1,1,0,1'
test-expr 'a != ((b || (c >= d)) && e)' -a 0,1,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 0,1,1,0,1'

echo '$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 0,1,1,0,2'
test-expr 'a != ((b || (c >= d)) && e)' -a 0,1,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 0,1,1,0,2'

echo '$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 0,1,1,1,0'
test-expr 'a != ((b || (c >= d)) && e)' -a 0,1,1,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 0,1,1,1,0'

echo '$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 0,1,2,1,1'
test-expr 'a != ((b || (c >= d)) && e)' -a 0,1,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 0,1,2,1,1'

echo '$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 0,1,2,2,0'
test-expr 'a != ((b || (c >= d)) && e)' -a 0,1,2,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 0,1,2,2,0'

echo '$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 0,2,2,1,1'
test-expr 'a != ((b || (c >= d)) && e)' -a 0,2,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 0,2,2,1,1'

echo '$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 0,2,2,2,2'
test-expr 'a != ((b || (c >= d)) && e)' -a 0,2,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 0,2,2,2,2'

echo '$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 1,0,1,1,0'
test-expr 'a != ((b || (c >= d)) && e)' -a 1,0,1,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 1,0,1,1,0'

echo '$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 1,0,1,1,1'
test-expr 'a != ((b || (c >= d)) && e)' -a 1,0,1,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 1,0,1,1,1'

echo '$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 1,0,1,2,2'
test-expr 'a != ((b || (c >= d)) && e)' -a 1,0,1,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 1,0,1,2,2'

echo '$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 1,0,2,2,0'
test-expr 'a != ((b || (c >= d)) && e)' -a 1,0,2,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 1,0,2,2,0'

echo '$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 1,0,2,2,1'
test-expr 'a != ((b || (c >= d)) && e)' -a 1,0,2,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 1,0,2,2,1'

echo '$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 1,1,0,0,1'
test-expr 'a != ((b || (c >= d)) && e)' -a 1,1,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 1,1,0,0,1'

echo '$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 1,1,0,0,2'
test-expr 'a != ((b || (c >= d)) && e)' -a 1,1,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 1,1,0,0,2'

echo '$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 1,1,1,0,0'
test-expr 'a != ((b || (c >= d)) && e)' -a 1,1,1,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 1,1,1,0,0'

echo '$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 1,1,2,1,0'
test-expr 'a != ((b || (c >= d)) && e)' -a 1,1,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 1,1,2,1,0'

echo '$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 1,1,2,2,0'
test-expr 'a != ((b || (c >= d)) && e)' -a 1,1,2,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 1,1,2,2,0'

echo '$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 1,2,0,0,0'
test-expr 'a != ((b || (c >= d)) && e)' -a 1,2,0,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 1,2,0,0,0'

echo '$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 1,2,0,0,2'
test-expr 'a != ((b || (c >= d)) && e)' -a 1,2,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 1,2,0,0,2'

echo '$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 1,2,1,2,1'
test-expr 'a != ((b || (c >= d)) && e)' -a 1,2,1,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 1,2,1,2,1'

echo '$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 1,2,2,0,1'
test-expr 'a != ((b || (c >= d)) && e)' -a 1,2,2,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 1,2,2,0,1'

echo '$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 2,0,1,1,2'
test-expr 'a != ((b || (c >= d)) && e)' -a 2,0,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 2,0,1,1,2'

echo '$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 2,0,1,2,2'
test-expr 'a != ((b || (c >= d)) && e)' -a 2,0,1,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 2,0,1,2,2'

echo '$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 2,0,2,1,2'
test-expr 'a != ((b || (c >= d)) && e)' -a 2,0,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 2,0,2,1,2'

echo '$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 2,1,0,0,0'
test-expr 'a != ((b || (c >= d)) && e)' -a 2,1,0,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 2,1,0,0,0'

echo '$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 2,1,1,1,0'
test-expr 'a != ((b || (c >= d)) && e)' -a 2,1,1,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 2,1,1,1,0'

echo '$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 2,1,1,2,2'
test-expr 'a != ((b || (c >= d)) && e)' -a 2,1,1,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 2,1,1,2,2'

echo '$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 2,2,0,0,1'
test-expr 'a != ((b || (c >= d)) && e)' -a 2,2,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 2,2,0,0,1'

echo '$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 2,2,1,0,0'
test-expr 'a != ((b || (c >= d)) && e)' -a 2,2,1,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 2,2,1,0,0'

echo '$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 2,2,2,0,1'
test-expr 'a != ((b || (c >= d)) && e)' -a 2,2,2,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 2,2,2,0,1'

echo '$ test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 2,2,2,2,2'
test-expr 'a != ((b || (c >= d)) && e)' -a 2,2,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != ((b || (c >= d)) && e)'\'' -a 2,2,2,2,2'

echo '$ test-expr '\''a != (((b && c) >= d) || e)'\'' -a 0,0,0,0,2'
test-expr 'a != (((b && c) >= d) || e)' -a 0,0,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != (((b && c) >= d) || e)'\'' -a 0,0,0,0,2'

echo '$ test-expr '\''a != (((b && c) >= d) || e)'\'' -a 0,0,2,0,0'
test-expr 'a != (((b && c) >= d) || e)' -a 0,0,2,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != (((b && c) >= d) || e)'\'' -a 0,0,2,0,0'

echo '$ test-expr '\''a != (((b && c) >= d) || e)'\'' -a 0,0,2,0,1'
test-expr 'a != (((b && c) >= d) || e)' -a 0,0,2,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b && c) >= d) || e)'\'' -a 0,0,2,0,1'

echo '$ test-expr '\''a != (((b && c) >= d) || e)'\'' -a 0,0,2,2,2'
test-expr 'a != (((b && c) >= d) || e)' -a 0,0,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != (((b && c) >= d) || e)'\'' -a 0,0,2,2,2'

echo '$ test-expr '\''a != (((b && c) >= d) || e)'\'' -a 0,1,0,1,1'
test-expr 'a != (((b && c) >= d) || e)' -a 0,1,0,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b && c) >= d) || e)'\'' -a 0,1,0,1,1'

echo '$ test-expr '\''a != (((b && c) >= d) || e)'\'' -a 0,1,0,2,0'
test-expr 'a != (((b && c) >= d) || e)' -a 0,1,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != (((b && c) >= d) || e)'\'' -a 0,1,0,2,0'

echo '$ test-expr '\''a != (((b && c) >= d) || e)'\'' -a 0,1,0,2,2'
test-expr 'a != (((b && c) >= d) || e)' -a 0,1,0,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != (((b && c) >= d) || e)'\'' -a 0,1,0,2,2'

echo '$ test-expr '\''a != (((b && c) >= d) || e)'\'' -a 0,1,2,1,1'
test-expr 'a != (((b && c) >= d) || e)' -a 0,1,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b && c) >= d) || e)'\'' -a 0,1,2,1,1'

echo '$ test-expr '\''a != (((b && c) >= d) || e)'\'' -a 0,1,2,2,0'
test-expr 'a != (((b && c) >= d) || e)' -a 0,1,2,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != (((b && c) >= d) || e)'\'' -a 0,1,2,2,0'

echo '$ test-expr '\''a != (((b && c) >= d) || e)'\'' -a 0,1,2,2,1'
test-expr 'a != (((b && c) >= d) || e)' -a 0,1,2,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b && c) >= d) || e)'\'' -a 0,1,2,2,1'

echo '$ test-expr '\''a != (((b && c) >= d) || e)'\'' -a 0,1,2,2,2'
test-expr 'a != (((b && c) >= d) || e)' -a 0,1,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != (((b && c) >= d) || e)'\'' -a 0,1,2,2,2'

echo '$ test-expr '\''a != (((b && c) >= d) || e)'\'' -a 1,0,0,1,0'
test-expr 'a != (((b && c) >= d) || e)' -a 1,0,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != (((b && c) >= d) || e)'\'' -a 1,0,0,1,0'

echo '$ test-expr '\''a != (((b && c) >= d) || e)'\'' -a 1,0,1,0,1'
test-expr 'a != (((b && c) >= d) || e)' -a 1,0,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b && c) >= d) || e)'\'' -a 1,0,1,0,1'

echo '$ test-expr '\''a != (((b && c) >= d) || e)'\'' -a 1,0,2,0,1'
test-expr 'a != (((b && c) >= d) || e)' -a 1,0,2,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b && c) >= d) || e)'\'' -a 1,0,2,0,1'

echo '$ test-expr '\''a != (((b && c) >= d) || e)'\'' -a 1,0,2,1,2'
test-expr 'a != (((b && c) >= d) || e)' -a 1,0,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != (((b && c) >= d) || e)'\'' -a 1,0,2,1,2'

echo '$ test-expr '\''a != (((b && c) >= d) || e)'\'' -a 1,1,2,1,1'
test-expr 'a != (((b && c) >= d) || e)' -a 1,1,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b && c) >= d) || e)'\'' -a 1,1,2,1,1'

echo '$ test-expr '\''a != (((b && c) >= d) || e)'\'' -a 1,1,2,2,1'
test-expr 'a != (((b && c) >= d) || e)' -a 1,1,2,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b && c) >= d) || e)'\'' -a 1,1,2,2,1'

echo '$ test-expr '\''a != (((b && c) >= d) || e)'\'' -a 1,2,0,1,1'
test-expr 'a != (((b && c) >= d) || e)' -a 1,2,0,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b && c) >= d) || e)'\'' -a 1,2,0,1,1'

echo '$ test-expr '\''a != (((b && c) >= d) || e)'\'' -a 1,2,2,1,0'
test-expr 'a != (((b && c) >= d) || e)' -a 1,2,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != (((b && c) >= d) || e)'\'' -a 1,2,2,1,0'

echo '$ test-expr '\''a != (((b && c) >= d) || e)'\'' -a 2,0,0,1,1'
test-expr 'a != (((b && c) >= d) || e)' -a 2,0,0,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b && c) >= d) || e)'\'' -a 2,0,0,1,1'

echo '$ test-expr '\''a != (((b && c) >= d) || e)'\'' -a 2,0,1,1,1'
test-expr 'a != (((b && c) >= d) || e)' -a 2,0,1,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b && c) >= d) || e)'\'' -a 2,0,1,1,1'

echo '$ test-expr '\''a != (((b && c) >= d) || e)'\'' -a 2,0,1,2,1'
test-expr 'a != (((b && c) >= d) || e)' -a 2,0,1,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b && c) >= d) || e)'\'' -a 2,0,1,2,1'

echo '$ test-expr '\''a != (((b && c) >= d) || e)'\'' -a 2,0,2,0,1'
test-expr 'a != (((b && c) >= d) || e)' -a 2,0,2,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b && c) >= d) || e)'\'' -a 2,0,2,0,1'

echo '$ test-expr '\''a != (((b && c) >= d) || e)'\'' -a 2,0,2,2,1'
test-expr 'a != (((b && c) >= d) || e)' -a 2,0,2,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b && c) >= d) || e)'\'' -a 2,0,2,2,1'

echo '$ test-expr '\''a != (((b && c) >= d) || e)'\'' -a 2,1,0,0,2'
test-expr 'a != (((b && c) >= d) || e)' -a 2,1,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != (((b && c) >= d) || e)'\'' -a 2,1,0,0,2'

echo '$ test-expr '\''a != (((b && c) >= d) || e)'\'' -a 2,2,2,0,2'
test-expr 'a != (((b && c) >= d) || e)' -a 2,2,2,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != (((b && c) >= d) || e)'\'' -a 2,2,2,0,2'

echo '$ test-expr '\''a != (((b && c) >= d) || e)'\'' -a 2,2,2,2,1'
test-expr 'a != (((b && c) >= d) || e)' -a 2,2,2,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b && c) >= d) || e)'\'' -a 2,2,2,2,1'

echo '$ test-expr '\''a != (((b && c) || d) >= e)'\'' -a 0,0,0,1,1'
test-expr 'a != (((b && c) || d) >= e)' -a 0,0,0,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b && c) || d) >= e)'\'' -a 0,0,0,1,1'

echo '$ test-expr '\''a != (((b && c) || d) >= e)'\'' -a 0,0,0,1,2'
test-expr 'a != (((b && c) || d) >= e)' -a 0,0,0,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != (((b && c) || d) >= e)'\'' -a 0,0,0,1,2'

echo '$ test-expr '\''a != (((b && c) || d) >= e)'\'' -a 0,0,2,1,1'
test-expr 'a != (((b && c) || d) >= e)' -a 0,0,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b && c) || d) >= e)'\'' -a 0,0,2,1,1'

echo '$ test-expr '\''a != (((b && c) || d) >= e)'\'' -a 0,0,2,1,2'
test-expr 'a != (((b && c) || d) >= e)' -a 0,0,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != (((b && c) || d) >= e)'\'' -a 0,0,2,1,2'

echo '$ test-expr '\''a != (((b && c) || d) >= e)'\'' -a 0,1,1,1,0'
test-expr 'a != (((b && c) || d) >= e)' -a 0,1,1,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != (((b && c) || d) >= e)'\'' -a 0,1,1,1,0'

echo '$ test-expr '\''a != (((b && c) || d) >= e)'\'' -a 0,1,1,2,1'
test-expr 'a != (((b && c) || d) >= e)' -a 0,1,1,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b && c) || d) >= e)'\'' -a 0,1,1,2,1'

echo '$ test-expr '\''a != (((b && c) || d) >= e)'\'' -a 0,1,2,2,1'
test-expr 'a != (((b && c) || d) >= e)' -a 0,1,2,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b && c) || d) >= e)'\'' -a 0,1,2,2,1'

echo '$ test-expr '\''a != (((b && c) || d) >= e)'\'' -a 0,2,1,1,2'
test-expr 'a != (((b && c) || d) >= e)' -a 0,2,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != (((b && c) || d) >= e)'\'' -a 0,2,1,1,2'

echo '$ test-expr '\''a != (((b && c) || d) >= e)'\'' -a 0,2,2,2,0'
test-expr 'a != (((b && c) || d) >= e)' -a 0,2,2,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != (((b && c) || d) >= e)'\'' -a 0,2,2,2,0'

echo '$ test-expr '\''a != (((b && c) || d) >= e)'\'' -a 0,2,2,2,2'
test-expr 'a != (((b && c) || d) >= e)' -a 0,2,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != (((b && c) || d) >= e)'\'' -a 0,2,2,2,2'

echo '$ test-expr '\''a != (((b && c) || d) >= e)'\'' -a 1,0,0,0,0'
test-expr 'a != (((b && c) || d) >= e)' -a 1,0,0,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != (((b && c) || d) >= e)'\'' -a 1,0,0,0,0'

echo '$ test-expr '\''a != (((b && c) || d) >= e)'\'' -a 1,0,0,2,1'
test-expr 'a != (((b && c) || d) >= e)' -a 1,0,0,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b && c) || d) >= e)'\'' -a 1,0,0,2,1'

echo '$ test-expr '\''a != (((b && c) || d) >= e)'\'' -a 1,0,1,2,1'
test-expr 'a != (((b && c) || d) >= e)' -a 1,0,1,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b && c) || d) >= e)'\'' -a 1,0,1,2,1'

echo '$ test-expr '\''a != (((b && c) || d) >= e)'\'' -a 1,0,2,0,0'
test-expr 'a != (((b && c) || d) >= e)' -a 1,0,2,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != (((b && c) || d) >= e)'\'' -a 1,0,2,0,0'

echo '$ test-expr '\''a != (((b && c) || d) >= e)'\'' -a 1,0,2,0,1'
test-expr 'a != (((b && c) || d) >= e)' -a 1,0,2,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b && c) || d) >= e)'\'' -a 1,0,2,0,1'

echo '$ test-expr '\''a != (((b && c) || d) >= e)'\'' -a 1,1,0,0,0'
test-expr 'a != (((b && c) || d) >= e)' -a 1,1,0,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != (((b && c) || d) >= e)'\'' -a 1,1,0,0,0'

echo '$ test-expr '\''a != (((b && c) || d) >= e)'\'' -a 1,1,1,0,0'
test-expr 'a != (((b && c) || d) >= e)' -a 1,1,1,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != (((b && c) || d) >= e)'\'' -a 1,1,1,0,0'

echo '$ test-expr '\''a != (((b && c) || d) >= e)'\'' -a 1,2,0,1,0'
test-expr 'a != (((b && c) || d) >= e)' -a 1,2,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != (((b && c) || d) >= e)'\'' -a 1,2,0,1,0'

echo '$ test-expr '\''a != (((b && c) || d) >= e)'\'' -a 1,2,1,1,0'
test-expr 'a != (((b && c) || d) >= e)' -a 1,2,1,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != (((b && c) || d) >= e)'\'' -a 1,2,1,1,0'

echo '$ test-expr '\''a != (((b && c) || d) >= e)'\'' -a 2,0,0,1,0'
test-expr 'a != (((b && c) || d) >= e)' -a 2,0,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != (((b && c) || d) >= e)'\'' -a 2,0,0,1,0'

echo '$ test-expr '\''a != (((b && c) || d) >= e)'\'' -a 2,0,0,1,1'
test-expr 'a != (((b && c) || d) >= e)' -a 2,0,0,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b && c) || d) >= e)'\'' -a 2,0,0,1,1'

echo '$ test-expr '\''a != (((b && c) || d) >= e)'\'' -a 2,0,1,1,2'
test-expr 'a != (((b && c) || d) >= e)' -a 2,0,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != (((b && c) || d) >= e)'\'' -a 2,0,1,1,2'

echo '$ test-expr '\''a != (((b && c) || d) >= e)'\'' -a 2,0,1,2,1'
test-expr 'a != (((b && c) || d) >= e)' -a 2,0,1,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b && c) || d) >= e)'\'' -a 2,0,1,2,1'

echo '$ test-expr '\''a != (((b && c) || d) >= e)'\'' -a 2,0,2,1,1'
test-expr 'a != (((b && c) || d) >= e)' -a 2,0,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b && c) || d) >= e)'\'' -a 2,0,2,1,1'

echo '$ test-expr '\''a != (((b && c) || d) >= e)'\'' -a 2,0,2,2,1'
test-expr 'a != (((b && c) || d) >= e)' -a 2,0,2,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b && c) || d) >= e)'\'' -a 2,0,2,2,1'

echo '$ test-expr '\''a != (((b && c) || d) >= e)'\'' -a 2,1,0,1,2'
test-expr 'a != (((b && c) || d) >= e)' -a 2,1,0,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != (((b && c) || d) >= e)'\'' -a 2,1,0,1,2'

echo '$ test-expr '\''a != (((b && c) || d) >= e)'\'' -a 2,1,1,0,1'
test-expr 'a != (((b && c) || d) >= e)' -a 2,1,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b && c) || d) >= e)'\'' -a 2,1,1,0,1'

echo '$ test-expr '\''a != (((b && c) || d) >= e)'\'' -a 2,1,1,0,2'
test-expr 'a != (((b && c) || d) >= e)' -a 2,1,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != (((b && c) || d) >= e)'\'' -a 2,1,1,0,2'

echo '$ test-expr '\''a != (((b && c) || d) >= e)'\'' -a 2,1,1,2,2'
test-expr 'a != (((b && c) || d) >= e)' -a 2,1,1,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != (((b && c) || d) >= e)'\'' -a 2,1,1,2,2'

echo '$ test-expr '\''a != (((b && c) || d) >= e)'\'' -a 2,1,2,1,0'
test-expr 'a != (((b && c) || d) >= e)' -a 2,1,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != (((b && c) || d) >= e)'\'' -a 2,1,2,1,0'

echo '$ test-expr '\''a != (((b && c) || d) >= e)'\'' -a 2,2,0,2,0'
test-expr 'a != (((b && c) || d) >= e)' -a 2,2,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != (((b && c) || d) >= e)'\'' -a 2,2,0,2,0'

echo '$ test-expr '\''a != (((b && c) || d) >= e)'\'' -a 2,2,0,2,1'
test-expr 'a != (((b && c) || d) >= e)' -a 2,2,0,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b && c) || d) >= e)'\'' -a 2,2,0,2,1'

echo '$ test-expr '\''a != (((b >= c) && d) || e)'\'' -a 0,0,1,1,1'
test-expr 'a != (((b >= c) && d) || e)' -a 0,0,1,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b >= c) && d) || e)'\'' -a 0,0,1,1,1'

echo '$ test-expr '\''a != (((b >= c) && d) || e)'\'' -a 0,0,2,0,0'
test-expr 'a != (((b >= c) && d) || e)' -a 0,0,2,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != (((b >= c) && d) || e)'\'' -a 0,0,2,0,0'

echo '$ test-expr '\''a != (((b >= c) && d) || e)'\'' -a 0,0,2,2,2'
test-expr 'a != (((b >= c) && d) || e)' -a 0,0,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != (((b >= c) && d) || e)'\'' -a 0,0,2,2,2'

echo '$ test-expr '\''a != (((b >= c) && d) || e)'\'' -a 0,1,0,1,2'
test-expr 'a != (((b >= c) && d) || e)' -a 0,1,0,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != (((b >= c) && d) || e)'\'' -a 0,1,0,1,2'

echo '$ test-expr '\''a != (((b >= c) && d) || e)'\'' -a 0,1,1,2,0'
test-expr 'a != (((b >= c) && d) || e)' -a 0,1,1,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != (((b >= c) && d) || e)'\'' -a 0,1,1,2,0'

echo '$ test-expr '\''a != (((b >= c) && d) || e)'\'' -a 0,1,2,0,2'
test-expr 'a != (((b >= c) && d) || e)' -a 0,1,2,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != (((b >= c) && d) || e)'\'' -a 0,1,2,0,2'

echo '$ test-expr '\''a != (((b >= c) && d) || e)'\'' -a 0,1,2,1,0'
test-expr 'a != (((b >= c) && d) || e)' -a 0,1,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != (((b >= c) && d) || e)'\'' -a 0,1,2,1,0'

echo '$ test-expr '\''a != (((b >= c) && d) || e)'\'' -a 0,1,2,2,1'
test-expr 'a != (((b >= c) && d) || e)' -a 0,1,2,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b >= c) && d) || e)'\'' -a 0,1,2,2,1'

echo '$ test-expr '\''a != (((b >= c) && d) || e)'\'' -a 0,2,2,0,1'
test-expr 'a != (((b >= c) && d) || e)' -a 0,2,2,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b >= c) && d) || e)'\'' -a 0,2,2,0,1'

echo '$ test-expr '\''a != (((b >= c) && d) || e)'\'' -a 1,0,2,2,0'
test-expr 'a != (((b >= c) && d) || e)' -a 1,0,2,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != (((b >= c) && d) || e)'\'' -a 1,0,2,2,0'

echo '$ test-expr '\''a != (((b >= c) && d) || e)'\'' -a 1,0,2,2,1'
test-expr 'a != (((b >= c) && d) || e)' -a 1,0,2,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b >= c) && d) || e)'\'' -a 1,0,2,2,1'

echo '$ test-expr '\''a != (((b >= c) && d) || e)'\'' -a 1,1,0,2,1'
test-expr 'a != (((b >= c) && d) || e)' -a 1,1,0,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b >= c) && d) || e)'\'' -a 1,1,0,2,1'

echo '$ test-expr '\''a != (((b >= c) && d) || e)'\'' -a 1,1,0,2,2'
test-expr 'a != (((b >= c) && d) || e)' -a 1,1,0,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != (((b >= c) && d) || e)'\'' -a 1,1,0,2,2'

echo '$ test-expr '\''a != (((b >= c) && d) || e)'\'' -a 1,1,1,0,1'
test-expr 'a != (((b >= c) && d) || e)' -a 1,1,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b >= c) && d) || e)'\'' -a 1,1,1,0,1'

echo '$ test-expr '\''a != (((b >= c) && d) || e)'\'' -a 1,1,1,0,2'
test-expr 'a != (((b >= c) && d) || e)' -a 1,1,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != (((b >= c) && d) || e)'\'' -a 1,1,1,0,2'

echo '$ test-expr '\''a != (((b >= c) && d) || e)'\'' -a 1,1,2,2,1'
test-expr 'a != (((b >= c) && d) || e)' -a 1,1,2,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b >= c) && d) || e)'\'' -a 1,1,2,2,1'

echo '$ test-expr '\''a != (((b >= c) && d) || e)'\'' -a 1,2,0,0,2'
test-expr 'a != (((b >= c) && d) || e)' -a 1,2,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != (((b >= c) && d) || e)'\'' -a 1,2,0,0,2'

echo '$ test-expr '\''a != (((b >= c) && d) || e)'\'' -a 1,2,0,1,0'
test-expr 'a != (((b >= c) && d) || e)' -a 1,2,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != (((b >= c) && d) || e)'\'' -a 1,2,0,1,0'

echo '$ test-expr '\''a != (((b >= c) && d) || e)'\'' -a 1,2,1,0,1'
test-expr 'a != (((b >= c) && d) || e)' -a 1,2,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b >= c) && d) || e)'\'' -a 1,2,1,0,1'

echo '$ test-expr '\''a != (((b >= c) && d) || e)'\'' -a 1,2,1,0,2'
test-expr 'a != (((b >= c) && d) || e)' -a 1,2,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != (((b >= c) && d) || e)'\'' -a 1,2,1,0,2'

echo '$ test-expr '\''a != (((b >= c) && d) || e)'\'' -a 1,2,2,0,0'
test-expr 'a != (((b >= c) && d) || e)' -a 1,2,2,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != (((b >= c) && d) || e)'\'' -a 1,2,2,0,0'

echo '$ test-expr '\''a != (((b >= c) && d) || e)'\'' -a 2,0,0,0,2'
test-expr 'a != (((b >= c) && d) || e)' -a 2,0,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != (((b >= c) && d) || e)'\'' -a 2,0,0,0,2'

echo '$ test-expr '\''a != (((b >= c) && d) || e)'\'' -a 2,0,1,1,2'
test-expr 'a != (((b >= c) && d) || e)' -a 2,0,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != (((b >= c) && d) || e)'\'' -a 2,0,1,1,2'

echo '$ test-expr '\''a != (((b >= c) && d) || e)'\'' -a 2,0,1,2,2'
test-expr 'a != (((b >= c) && d) || e)' -a 2,0,1,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != (((b >= c) && d) || e)'\'' -a 2,0,1,2,2'

echo '$ test-expr '\''a != (((b >= c) && d) || e)'\'' -a 2,0,2,2,2'
test-expr 'a != (((b >= c) && d) || e)' -a 2,0,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != (((b >= c) && d) || e)'\'' -a 2,0,2,2,2'

echo '$ test-expr '\''a != (((b >= c) && d) || e)'\'' -a 2,1,0,0,2'
test-expr 'a != (((b >= c) && d) || e)' -a 2,1,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != (((b >= c) && d) || e)'\'' -a 2,1,0,0,2'

echo '$ test-expr '\''a != (((b >= c) && d) || e)'\'' -a 2,1,0,1,1'
test-expr 'a != (((b >= c) && d) || e)' -a 2,1,0,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b >= c) && d) || e)'\'' -a 2,1,0,1,1'

echo '$ test-expr '\''a != (((b >= c) && d) || e)'\'' -a 2,1,1,1,1'
test-expr 'a != (((b >= c) && d) || e)' -a 2,1,1,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b >= c) && d) || e)'\'' -a 2,1,1,1,1'

echo '$ test-expr '\''a != (((b >= c) && d) || e)'\'' -a 2,1,2,0,0'
test-expr 'a != (((b >= c) && d) || e)' -a 2,1,2,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != (((b >= c) && d) || e)'\'' -a 2,1,2,0,0'

echo '$ test-expr '\''a != (((b >= c) && d) || e)'\'' -a 2,2,0,1,1'
test-expr 'a != (((b >= c) && d) || e)' -a 2,2,0,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b >= c) && d) || e)'\'' -a 2,2,0,1,1'

echo '$ test-expr '\''a != (((b >= c) && d) || e)'\'' -a 2,2,1,1,1'
test-expr 'a != (((b >= c) && d) || e)' -a 2,2,1,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b >= c) && d) || e)'\'' -a 2,2,1,1,1'

echo '$ test-expr '\''a != (((b >= c) && d) || e)'\'' -a 2,2,1,2,0'
test-expr 'a != (((b >= c) && d) || e)' -a 2,2,1,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != (((b >= c) && d) || e)'\'' -a 2,2,1,2,0'

echo '$ test-expr '\''a != (((b >= c) || d) && e)'\'' -a 0,0,0,0,2'
test-expr 'a != (((b >= c) || d) && e)' -a 0,0,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != (((b >= c) || d) && e)'\'' -a 0,0,0,0,2'

echo '$ test-expr '\''a != (((b >= c) || d) && e)'\'' -a 0,0,1,1,2'
test-expr 'a != (((b >= c) || d) && e)' -a 0,0,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != (((b >= c) || d) && e)'\'' -a 0,0,1,1,2'

echo '$ test-expr '\''a != (((b >= c) || d) && e)'\'' -a 0,0,2,2,2'
test-expr 'a != (((b >= c) || d) && e)' -a 0,0,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != (((b >= c) || d) && e)'\'' -a 0,0,2,2,2'

echo '$ test-expr '\''a != (((b >= c) || d) && e)'\'' -a 0,1,0,0,1'
test-expr 'a != (((b >= c) || d) && e)' -a 0,1,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b >= c) || d) && e)'\'' -a 0,1,0,0,1'

echo '$ test-expr '\''a != (((b >= c) || d) && e)'\'' -a 0,1,0,1,1'
test-expr 'a != (((b >= c) || d) && e)' -a 0,1,0,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b >= c) || d) && e)'\'' -a 0,1,0,1,1'

echo '$ test-expr '\''a != (((b >= c) || d) && e)'\'' -a 0,1,2,2,0'
test-expr 'a != (((b >= c) || d) && e)' -a 0,1,2,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != (((b >= c) || d) && e)'\'' -a 0,1,2,2,0'

echo '$ test-expr '\''a != (((b >= c) || d) && e)'\'' -a 0,1,2,2,1'
test-expr 'a != (((b >= c) || d) && e)' -a 0,1,2,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b >= c) || d) && e)'\'' -a 0,1,2,2,1'

echo '$ test-expr '\''a != (((b >= c) || d) && e)'\'' -a 0,2,0,0,2'
test-expr 'a != (((b >= c) || d) && e)' -a 0,2,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != (((b >= c) || d) && e)'\'' -a 0,2,0,0,2'

echo '$ test-expr '\''a != (((b >= c) || d) && e)'\'' -a 0,2,0,1,0'
test-expr 'a != (((b >= c) || d) && e)' -a 0,2,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != (((b >= c) || d) && e)'\'' -a 0,2,0,1,0'

echo '$ test-expr '\''a != (((b >= c) || d) && e)'\'' -a 0,2,1,1,2'
test-expr 'a != (((b >= c) || d) && e)' -a 0,2,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != (((b >= c) || d) && e)'\'' -a 0,2,1,1,2'

echo '$ test-expr '\''a != (((b >= c) || d) && e)'\'' -a 0,2,1,2,1'
test-expr 'a != (((b >= c) || d) && e)' -a 0,2,1,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b >= c) || d) && e)'\'' -a 0,2,1,2,1'

echo '$ test-expr '\''a != (((b >= c) || d) && e)'\'' -a 0,2,2,2,0'
test-expr 'a != (((b >= c) || d) && e)' -a 0,2,2,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != (((b >= c) || d) && e)'\'' -a 0,2,2,2,0'

echo '$ test-expr '\''a != (((b >= c) || d) && e)'\'' -a 1,0,0,1,2'
test-expr 'a != (((b >= c) || d) && e)' -a 1,0,0,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != (((b >= c) || d) && e)'\'' -a 1,0,0,1,2'

echo '$ test-expr '\''a != (((b >= c) || d) && e)'\'' -a 1,0,1,0,2'
test-expr 'a != (((b >= c) || d) && e)' -a 1,0,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != (((b >= c) || d) && e)'\'' -a 1,0,1,0,2'

echo '$ test-expr '\''a != (((b >= c) || d) && e)'\'' -a 1,1,0,0,0'
test-expr 'a != (((b >= c) || d) && e)' -a 1,1,0,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != (((b >= c) || d) && e)'\'' -a 1,1,0,0,0'

echo '$ test-expr '\''a != (((b >= c) || d) && e)'\'' -a 1,1,0,1,0'
test-expr 'a != (((b >= c) || d) && e)' -a 1,1,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != (((b >= c) || d) && e)'\'' -a 1,1,0,1,0'

echo '$ test-expr '\''a != (((b >= c) || d) && e)'\'' -a 1,1,2,0,0'
test-expr 'a != (((b >= c) || d) && e)' -a 1,1,2,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != (((b >= c) || d) && e)'\'' -a 1,1,2,0,0'

echo '$ test-expr '\''a != (((b >= c) || d) && e)'\'' -a 1,1,2,2,0'
test-expr 'a != (((b >= c) || d) && e)' -a 1,1,2,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != (((b >= c) || d) && e)'\'' -a 1,1,2,2,0'

echo '$ test-expr '\''a != (((b >= c) || d) && e)'\'' -a 1,2,1,0,1'
test-expr 'a != (((b >= c) || d) && e)' -a 1,2,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b >= c) || d) && e)'\'' -a 1,2,1,0,1'

echo '$ test-expr '\''a != (((b >= c) || d) && e)'\'' -a 1,2,2,0,0'
test-expr 'a != (((b >= c) || d) && e)' -a 1,2,2,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != (((b >= c) || d) && e)'\'' -a 1,2,2,0,0'

echo '$ test-expr '\''a != (((b >= c) || d) && e)'\'' -a 1,2,2,0,1'
test-expr 'a != (((b >= c) || d) && e)' -a 1,2,2,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b >= c) || d) && e)'\'' -a 1,2,2,0,1'

echo '$ test-expr '\''a != (((b >= c) || d) && e)'\'' -a 1,2,2,1,1'
test-expr 'a != (((b >= c) || d) && e)' -a 1,2,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b >= c) || d) && e)'\'' -a 1,2,2,1,1'

echo '$ test-expr '\''a != (((b >= c) || d) && e)'\'' -a 1,2,2,1,2'
test-expr 'a != (((b >= c) || d) && e)' -a 1,2,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != (((b >= c) || d) && e)'\'' -a 1,2,2,1,2'

echo '$ test-expr '\''a != (((b >= c) || d) && e)'\'' -a 2,0,0,2,0'
test-expr 'a != (((b >= c) || d) && e)' -a 2,0,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != (((b >= c) || d) && e)'\'' -a 2,0,0,2,0'

echo '$ test-expr '\''a != (((b >= c) || d) && e)'\'' -a 2,0,0,2,2'
test-expr 'a != (((b >= c) || d) && e)' -a 2,0,0,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != (((b >= c) || d) && e)'\'' -a 2,0,0,2,2'

echo '$ test-expr '\''a != (((b >= c) || d) && e)'\'' -a 2,0,1,2,1'
test-expr 'a != (((b >= c) || d) && e)' -a 2,0,1,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b >= c) || d) && e)'\'' -a 2,0,1,2,1'

echo '$ test-expr '\''a != (((b >= c) || d) && e)'\'' -a 2,0,2,0,1'
test-expr 'a != (((b >= c) || d) && e)' -a 2,0,2,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b >= c) || d) && e)'\'' -a 2,0,2,0,1'

echo '$ test-expr '\''a != (((b >= c) || d) && e)'\'' -a 2,1,1,1,2'
test-expr 'a != (((b >= c) || d) && e)' -a 2,1,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != (((b >= c) || d) && e)'\'' -a 2,1,1,1,2'

echo '$ test-expr '\''a != (((b >= c) || d) && e)'\'' -a 2,2,1,0,0'
test-expr 'a != (((b >= c) || d) && e)' -a 2,2,1,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != (((b >= c) || d) && e)'\'' -a 2,2,1,0,0'

echo '$ test-expr '\''a != (((b || c) && d) >= e)'\'' -a 0,0,0,2,0'
test-expr 'a != (((b || c) && d) >= e)' -a 0,0,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != (((b || c) && d) >= e)'\'' -a 0,0,0,2,0'

echo '$ test-expr '\''a != (((b || c) && d) >= e)'\'' -a 0,0,2,1,1'
test-expr 'a != (((b || c) && d) >= e)' -a 0,0,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b || c) && d) >= e)'\'' -a 0,0,2,1,1'

echo '$ test-expr '\''a != (((b || c) && d) >= e)'\'' -a 0,0,2,2,0'
test-expr 'a != (((b || c) && d) >= e)' -a 0,0,2,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != (((b || c) && d) >= e)'\'' -a 0,0,2,2,0'

echo '$ test-expr '\''a != (((b || c) && d) >= e)'\'' -a 0,1,0,0,1'
test-expr 'a != (((b || c) && d) >= e)' -a 0,1,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b || c) && d) >= e)'\'' -a 0,1,0,0,1'

echo '$ test-expr '\''a != (((b || c) && d) >= e)'\'' -a 0,1,0,1,0'
test-expr 'a != (((b || c) && d) >= e)' -a 0,1,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != (((b || c) && d) >= e)'\'' -a 0,1,0,1,0'

echo '$ test-expr '\''a != (((b || c) && d) >= e)'\'' -a 0,1,1,0,0'
test-expr 'a != (((b || c) && d) >= e)' -a 0,1,1,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != (((b || c) && d) >= e)'\'' -a 0,1,1,0,0'

echo '$ test-expr '\''a != (((b || c) && d) >= e)'\'' -a 0,1,1,0,2'
test-expr 'a != (((b || c) && d) >= e)' -a 0,1,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != (((b || c) && d) >= e)'\'' -a 0,1,1,0,2'

echo '$ test-expr '\''a != (((b || c) && d) >= e)'\'' -a 0,1,1,1,2'
test-expr 'a != (((b || c) && d) >= e)' -a 0,1,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != (((b || c) && d) >= e)'\'' -a 0,1,1,1,2'

echo '$ test-expr '\''a != (((b || c) && d) >= e)'\'' -a 0,2,1,0,1'
test-expr 'a != (((b || c) && d) >= e)' -a 0,2,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b || c) && d) >= e)'\'' -a 0,2,1,0,1'

echo '$ test-expr '\''a != (((b || c) && d) >= e)'\'' -a 0,2,1,1,2'
test-expr 'a != (((b || c) && d) >= e)' -a 0,2,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != (((b || c) && d) >= e)'\'' -a 0,2,1,1,2'

echo '$ test-expr '\''a != (((b || c) && d) >= e)'\'' -a 1,0,0,2,1'
test-expr 'a != (((b || c) && d) >= e)' -a 1,0,0,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b || c) && d) >= e)'\'' -a 1,0,0,2,1'

echo '$ test-expr '\''a != (((b || c) && d) >= e)'\'' -a 1,0,2,1,1'
test-expr 'a != (((b || c) && d) >= e)' -a 1,0,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b || c) && d) >= e)'\'' -a 1,0,2,1,1'

echo '$ test-expr '\''a != (((b || c) && d) >= e)'\'' -a 1,1,0,1,1'
test-expr 'a != (((b || c) && d) >= e)' -a 1,1,0,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b || c) && d) >= e)'\'' -a 1,1,0,1,1'

echo '$ test-expr '\''a != (((b || c) && d) >= e)'\'' -a 1,1,0,1,2'
test-expr 'a != (((b || c) && d) >= e)' -a 1,1,0,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != (((b || c) && d) >= e)'\'' -a 1,1,0,1,2'

echo '$ test-expr '\''a != (((b || c) && d) >= e)'\'' -a 1,1,2,0,2'
test-expr 'a != (((b || c) && d) >= e)' -a 1,1,2,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != (((b || c) && d) >= e)'\'' -a 1,1,2,0,2'

echo '$ test-expr '\''a != (((b || c) && d) >= e)'\'' -a 1,1,2,1,1'
test-expr 'a != (((b || c) && d) >= e)' -a 1,1,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b || c) && d) >= e)'\'' -a 1,1,2,1,1'

echo '$ test-expr '\''a != (((b || c) && d) >= e)'\'' -a 1,2,2,2,1'
test-expr 'a != (((b || c) && d) >= e)' -a 1,2,2,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b || c) && d) >= e)'\'' -a 1,2,2,2,1'

echo '$ test-expr '\''a != (((b || c) && d) >= e)'\'' -a 1,2,2,2,2'
test-expr 'a != (((b || c) && d) >= e)' -a 1,2,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != (((b || c) && d) >= e)'\'' -a 1,2,2,2,2'

echo '$ test-expr '\''a != (((b || c) && d) >= e)'\'' -a 2,0,0,0,1'
test-expr 'a != (((b || c) && d) >= e)' -a 2,0,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b || c) && d) >= e)'\'' -a 2,0,0,0,1'

echo '$ test-expr '\''a != (((b || c) && d) >= e)'\'' -a 2,0,0,2,1'
test-expr 'a != (((b || c) && d) >= e)' -a 2,0,0,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b || c) && d) >= e)'\'' -a 2,0,0,2,1'

echo '$ test-expr '\''a != (((b || c) && d) >= e)'\'' -a 2,0,1,2,2'
test-expr 'a != (((b || c) && d) >= e)' -a 2,0,1,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != (((b || c) && d) >= e)'\'' -a 2,0,1,2,2'

echo '$ test-expr '\''a != (((b || c) && d) >= e)'\'' -a 2,0,2,0,0'
test-expr 'a != (((b || c) && d) >= e)' -a 2,0,2,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != (((b || c) && d) >= e)'\'' -a 2,0,2,0,0'

echo '$ test-expr '\''a != (((b || c) && d) >= e)'\'' -a 2,0,2,2,0'
test-expr 'a != (((b || c) && d) >= e)' -a 2,0,2,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != (((b || c) && d) >= e)'\'' -a 2,0,2,2,0'

echo '$ test-expr '\''a != (((b || c) && d) >= e)'\'' -a 2,0,2,2,2'
test-expr 'a != (((b || c) && d) >= e)' -a 2,0,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != (((b || c) && d) >= e)'\'' -a 2,0,2,2,2'

echo '$ test-expr '\''a != (((b || c) && d) >= e)'\'' -a 2,1,0,0,1'
test-expr 'a != (((b || c) && d) >= e)' -a 2,1,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b || c) && d) >= e)'\'' -a 2,1,0,0,1'

echo '$ test-expr '\''a != (((b || c) && d) >= e)'\'' -a 2,1,1,0,1'
test-expr 'a != (((b || c) && d) >= e)' -a 2,1,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b || c) && d) >= e)'\'' -a 2,1,1,0,1'

echo '$ test-expr '\''a != (((b || c) && d) >= e)'\'' -a 2,1,1,1,0'
test-expr 'a != (((b || c) && d) >= e)' -a 2,1,1,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != (((b || c) && d) >= e)'\'' -a 2,1,1,1,0'

echo '$ test-expr '\''a != (((b || c) && d) >= e)'\'' -a 2,1,2,0,0'
test-expr 'a != (((b || c) && d) >= e)' -a 2,1,2,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != (((b || c) && d) >= e)'\'' -a 2,1,2,0,0'

echo '$ test-expr '\''a != (((b || c) && d) >= e)'\'' -a 2,1,2,0,2'
test-expr 'a != (((b || c) && d) >= e)' -a 2,1,2,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != (((b || c) && d) >= e)'\'' -a 2,1,2,0,2'

echo '$ test-expr '\''a != (((b || c) && d) >= e)'\'' -a 2,1,2,1,1'
test-expr 'a != (((b || c) && d) >= e)' -a 2,1,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b || c) && d) >= e)'\'' -a 2,1,2,1,1'

echo '$ test-expr '\''a != (((b || c) && d) >= e)'\'' -a 2,1,2,2,2'
test-expr 'a != (((b || c) && d) >= e)' -a 2,1,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != (((b || c) && d) >= e)'\'' -a 2,1,2,2,2'

echo '$ test-expr '\''a != (((b || c) && d) >= e)'\'' -a 2,2,0,2,0'
test-expr 'a != (((b || c) && d) >= e)' -a 2,2,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != (((b || c) && d) >= e)'\'' -a 2,2,0,2,0'

echo '$ test-expr '\''a != (((b || c) && d) >= e)'\'' -a 2,2,1,2,1'
test-expr 'a != (((b || c) && d) >= e)' -a 2,2,1,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b || c) && d) >= e)'\'' -a 2,2,1,2,1'

echo '$ test-expr '\''a != (((b || c) && d) >= e)'\'' -a 2,2,2,1,2'
test-expr 'a != (((b || c) && d) >= e)' -a 2,2,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != (((b || c) && d) >= e)'\'' -a 2,2,2,1,2'

echo '$ test-expr '\''a != (((b || c) >= d) && e)'\'' -a 0,0,0,0,2'
test-expr 'a != (((b || c) >= d) && e)' -a 0,0,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != (((b || c) >= d) && e)'\'' -a 0,0,0,0,2'

echo '$ test-expr '\''a != (((b || c) >= d) && e)'\'' -a 0,0,0,1,1'
test-expr 'a != (((b || c) >= d) && e)' -a 0,0,0,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b || c) >= d) && e)'\'' -a 0,0,0,1,1'

echo '$ test-expr '\''a != (((b || c) >= d) && e)'\'' -a 0,0,0,1,2'
test-expr 'a != (((b || c) >= d) && e)' -a 0,0,0,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != (((b || c) >= d) && e)'\'' -a 0,0,0,1,2'

echo '$ test-expr '\''a != (((b || c) >= d) && e)'\'' -a 0,0,1,1,1'
test-expr 'a != (((b || c) >= d) && e)' -a 0,0,1,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b || c) >= d) && e)'\'' -a 0,0,1,1,1'

echo '$ test-expr '\''a != (((b || c) >= d) && e)'\'' -a 0,0,1,1,2'
test-expr 'a != (((b || c) >= d) && e)' -a 0,0,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != (((b || c) >= d) && e)'\'' -a 0,0,1,1,2'

echo '$ test-expr '\''a != (((b || c) >= d) && e)'\'' -a 0,0,1,2,1'
test-expr 'a != (((b || c) >= d) && e)' -a 0,0,1,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b || c) >= d) && e)'\'' -a 0,0,1,2,1'

echo '$ test-expr '\''a != (((b || c) >= d) && e)'\'' -a 0,1,0,1,1'
test-expr 'a != (((b || c) >= d) && e)' -a 0,1,0,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b || c) >= d) && e)'\'' -a 0,1,0,1,1'

echo '$ test-expr '\''a != (((b || c) >= d) && e)'\'' -a 0,1,2,0,1'
test-expr 'a != (((b || c) >= d) && e)' -a 0,1,2,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b || c) >= d) && e)'\'' -a 0,1,2,0,1'

echo '$ test-expr '\''a != (((b || c) >= d) && e)'\'' -a 0,1,2,2,1'
test-expr 'a != (((b || c) >= d) && e)' -a 0,1,2,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b || c) >= d) && e)'\'' -a 0,1,2,2,1'

echo '$ test-expr '\''a != (((b || c) >= d) && e)'\'' -a 0,2,0,0,1'
test-expr 'a != (((b || c) >= d) && e)' -a 0,2,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b || c) >= d) && e)'\'' -a 0,2,0,0,1'

echo '$ test-expr '\''a != (((b || c) >= d) && e)'\'' -a 0,2,0,2,1'
test-expr 'a != (((b || c) >= d) && e)' -a 0,2,0,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b || c) >= d) && e)'\'' -a 0,2,0,2,1'

echo '$ test-expr '\''a != (((b || c) >= d) && e)'\'' -a 0,2,1,2,2'
test-expr 'a != (((b || c) >= d) && e)' -a 0,2,1,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != (((b || c) >= d) && e)'\'' -a 0,2,1,2,2'

echo '$ test-expr '\''a != (((b || c) >= d) && e)'\'' -a 1,0,0,2,0'
test-expr 'a != (((b || c) >= d) && e)' -a 1,0,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a != (((b || c) >= d) && e)'\'' -a 1,0,0,2,0'

echo '$ test-expr '\''a != (((b || c) >= d) && e)'\'' -a 1,0,2,0,0'
test-expr 'a != (((b || c) >= d) && e)' -a 1,0,2,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != (((b || c) >= d) && e)'\'' -a 1,0,2,0,0'

echo '$ test-expr '\''a != (((b || c) >= d) && e)'\'' -a 1,0,2,0,1'
test-expr 'a != (((b || c) >= d) && e)' -a 1,0,2,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b || c) >= d) && e)'\'' -a 1,0,2,0,1'

echo '$ test-expr '\''a != (((b || c) >= d) && e)'\'' -a 1,0,2,1,0'
test-expr 'a != (((b || c) >= d) && e)' -a 1,0,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != (((b || c) >= d) && e)'\'' -a 1,0,2,1,0'

echo '$ test-expr '\''a != (((b || c) >= d) && e)'\'' -a 1,1,0,0,0'
test-expr 'a != (((b || c) >= d) && e)' -a 1,1,0,0,0 2>&1 ||
echo 'command failed: test-expr '\''a != (((b || c) >= d) && e)'\'' -a 1,1,0,0,0'

echo '$ test-expr '\''a != (((b || c) >= d) && e)'\'' -a 1,1,0,2,1'
test-expr 'a != (((b || c) >= d) && e)' -a 1,1,0,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b || c) >= d) && e)'\'' -a 1,1,0,2,1'

echo '$ test-expr '\''a != (((b || c) >= d) && e)'\'' -a 1,1,1,1,0'
test-expr 'a != (((b || c) >= d) && e)' -a 1,1,1,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != (((b || c) >= d) && e)'\'' -a 1,1,1,1,0'

echo '$ test-expr '\''a != (((b || c) >= d) && e)'\'' -a 1,1,1,2,2'
test-expr 'a != (((b || c) >= d) && e)' -a 1,1,1,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != (((b || c) >= d) && e)'\'' -a 1,1,1,2,2'

echo '$ test-expr '\''a != (((b || c) >= d) && e)'\'' -a 1,1,2,0,1'
test-expr 'a != (((b || c) >= d) && e)' -a 1,1,2,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b || c) >= d) && e)'\'' -a 1,1,2,0,1'

echo '$ test-expr '\''a != (((b || c) >= d) && e)'\'' -a 1,1,2,0,2'
test-expr 'a != (((b || c) >= d) && e)' -a 1,1,2,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != (((b || c) >= d) && e)'\'' -a 1,1,2,0,2'

echo '$ test-expr '\''a != (((b || c) >= d) && e)'\'' -a 1,1,2,1,1'
test-expr 'a != (((b || c) >= d) && e)' -a 1,1,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b || c) >= d) && e)'\'' -a 1,1,2,1,1'

echo '$ test-expr '\''a != (((b || c) >= d) && e)'\'' -a 1,2,0,0,1'
test-expr 'a != (((b || c) >= d) && e)' -a 1,2,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b || c) >= d) && e)'\'' -a 1,2,0,0,1'

echo '$ test-expr '\''a != (((b || c) >= d) && e)'\'' -a 1,2,0,1,0'
test-expr 'a != (((b || c) >= d) && e)' -a 1,2,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != (((b || c) >= d) && e)'\'' -a 1,2,0,1,0'

echo '$ test-expr '\''a != (((b || c) >= d) && e)'\'' -a 1,2,1,0,2'
test-expr 'a != (((b || c) >= d) && e)' -a 1,2,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != (((b || c) >= d) && e)'\'' -a 1,2,1,0,2'

echo '$ test-expr '\''a != (((b || c) >= d) && e)'\'' -a 1,2,2,1,0'
test-expr 'a != (((b || c) >= d) && e)' -a 1,2,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a != (((b || c) >= d) && e)'\'' -a 1,2,2,1,0'

echo '$ test-expr '\''a != (((b || c) >= d) && e)'\'' -a 2,0,1,0,2'
test-expr 'a != (((b || c) >= d) && e)' -a 2,0,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a != (((b || c) >= d) && e)'\'' -a 2,0,1,0,2'

echo '$ test-expr '\''a != (((b || c) >= d) && e)'\'' -a 2,0,2,2,2'
test-expr 'a != (((b || c) >= d) && e)' -a 2,0,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a != (((b || c) >= d) && e)'\'' -a 2,0,2,2,2'

echo '$ test-expr '\''a != (((b || c) >= d) && e)'\'' -a 2,1,2,1,2'
test-expr 'a != (((b || c) >= d) && e)' -a 2,1,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != (((b || c) >= d) && e)'\'' -a 2,1,2,1,2'

echo '$ test-expr '\''a != (((b || c) >= d) && e)'\'' -a 2,2,0,1,2'
test-expr 'a != (((b || c) >= d) && e)' -a 2,2,0,1,2 2>&1 ||
echo 'command failed: test-expr '\''a != (((b || c) >= d) && e)'\'' -a 2,2,0,1,2'

echo '$ test-expr '\''a != (((b || c) >= d) && e)'\'' -a 2,2,1,2,1'
test-expr 'a != (((b || c) >= d) && e)' -a 2,2,1,2,1 2>&1 ||
echo 'command failed: test-expr '\''a != (((b || c) >= d) && e)'\'' -a 2,2,1,2,1'

echo '$ test-expr '\''a && (b != (c >= (d || e)))'\'' -a 0,0,0,2,1'
test-expr 'a && (b != (c >= (d || e)))' -a 0,0,0,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b != (c >= (d || e)))'\'' -a 0,0,0,2,1'

echo '$ test-expr '\''a && (b != (c >= (d || e)))'\'' -a 0,0,1,1,1'
test-expr 'a && (b != (c >= (d || e)))' -a 0,0,1,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b != (c >= (d || e)))'\'' -a 0,0,1,1,1'

echo '$ test-expr '\''a && (b != (c >= (d || e)))'\'' -a 0,0,2,2,1'
test-expr 'a && (b != (c >= (d || e)))' -a 0,0,2,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b != (c >= (d || e)))'\'' -a 0,0,2,2,1'

echo '$ test-expr '\''a && (b != (c >= (d || e)))'\'' -a 0,1,0,0,2'
test-expr 'a && (b != (c >= (d || e)))' -a 0,1,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b != (c >= (d || e)))'\'' -a 0,1,0,0,2'

echo '$ test-expr '\''a && (b != (c >= (d || e)))'\'' -a 0,1,1,0,0'
test-expr 'a && (b != (c >= (d || e)))' -a 0,1,1,0,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b != (c >= (d || e)))'\'' -a 0,1,1,0,0'

echo '$ test-expr '\''a && (b != (c >= (d || e)))'\'' -a 0,1,1,0,1'
test-expr 'a && (b != (c >= (d || e)))' -a 0,1,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b != (c >= (d || e)))'\'' -a 0,1,1,0,1'

echo '$ test-expr '\''a && (b != (c >= (d || e)))'\'' -a 0,1,2,2,2'
test-expr 'a && (b != (c >= (d || e)))' -a 0,1,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b != (c >= (d || e)))'\'' -a 0,1,2,2,2'

echo '$ test-expr '\''a && (b != (c >= (d || e)))'\'' -a 1,0,0,1,0'
test-expr 'a && (b != (c >= (d || e)))' -a 1,0,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b != (c >= (d || e)))'\'' -a 1,0,0,1,0'

echo '$ test-expr '\''a && (b != (c >= (d || e)))'\'' -a 1,0,2,0,2'
test-expr 'a && (b != (c >= (d || e)))' -a 1,0,2,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b != (c >= (d || e)))'\'' -a 1,0,2,0,2'

echo '$ test-expr '\''a && (b != (c >= (d || e)))'\'' -a 1,1,0,1,0'
test-expr 'a && (b != (c >= (d || e)))' -a 1,1,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b != (c >= (d || e)))'\'' -a 1,1,0,1,0'

echo '$ test-expr '\''a && (b != (c >= (d || e)))'\'' -a 1,1,2,2,1'
test-expr 'a && (b != (c >= (d || e)))' -a 1,1,2,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b != (c >= (d || e)))'\'' -a 1,1,2,2,1'

echo '$ test-expr '\''a && (b != (c >= (d || e)))'\'' -a 1,1,2,2,2'
test-expr 'a && (b != (c >= (d || e)))' -a 1,1,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b != (c >= (d || e)))'\'' -a 1,1,2,2,2'

echo '$ test-expr '\''a && (b != (c >= (d || e)))'\'' -a 1,2,0,0,2'
test-expr 'a && (b != (c >= (d || e)))' -a 1,2,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b != (c >= (d || e)))'\'' -a 1,2,0,0,2'

echo '$ test-expr '\''a && (b != (c >= (d || e)))'\'' -a 1,2,0,2,0'
test-expr 'a && (b != (c >= (d || e)))' -a 1,2,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b != (c >= (d || e)))'\'' -a 1,2,0,2,0'

echo '$ test-expr '\''a && (b != (c >= (d || e)))'\'' -a 1,2,1,1,1'
test-expr 'a && (b != (c >= (d || e)))' -a 1,2,1,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b != (c >= (d || e)))'\'' -a 1,2,1,1,1'

echo '$ test-expr '\''a && (b != (c >= (d || e)))'\'' -a 1,2,1,1,2'
test-expr 'a && (b != (c >= (d || e)))' -a 1,2,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b != (c >= (d || e)))'\'' -a 1,2,1,1,2'

echo '$ test-expr '\''a && (b != (c >= (d || e)))'\'' -a 1,2,2,2,2'
test-expr 'a && (b != (c >= (d || e)))' -a 1,2,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b != (c >= (d || e)))'\'' -a 1,2,2,2,2'

echo '$ test-expr '\''a && (b != (c >= (d || e)))'\'' -a 2,0,0,0,1'
test-expr 'a && (b != (c >= (d || e)))' -a 2,0,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b != (c >= (d || e)))'\'' -a 2,0,0,0,1'

echo '$ test-expr '\''a && (b != (c >= (d || e)))'\'' -a 2,0,0,1,0'
test-expr 'a && (b != (c >= (d || e)))' -a 2,0,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b != (c >= (d || e)))'\'' -a 2,0,0,1,0'

echo '$ test-expr '\''a && (b != (c >= (d || e)))'\'' -a 2,0,0,2,2'
test-expr 'a && (b != (c >= (d || e)))' -a 2,0,0,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b != (c >= (d || e)))'\'' -a 2,0,0,2,2'

echo '$ test-expr '\''a && (b != (c >= (d || e)))'\'' -a 2,0,1,2,0'
test-expr 'a && (b != (c >= (d || e)))' -a 2,0,1,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b != (c >= (d || e)))'\'' -a 2,0,1,2,0'

echo '$ test-expr '\''a && (b != (c >= (d || e)))'\'' -a 2,0,1,2,1'
test-expr 'a && (b != (c >= (d || e)))' -a 2,0,1,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b != (c >= (d || e)))'\'' -a 2,0,1,2,1'

echo '$ test-expr '\''a && (b != (c >= (d || e)))'\'' -a 2,0,2,1,0'
test-expr 'a && (b != (c >= (d || e)))' -a 2,0,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b != (c >= (d || e)))'\'' -a 2,0,2,1,0'

echo '$ test-expr '\''a && (b != (c >= (d || e)))'\'' -a 2,0,2,2,2'
test-expr 'a && (b != (c >= (d || e)))' -a 2,0,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b != (c >= (d || e)))'\'' -a 2,0,2,2,2'

echo '$ test-expr '\''a && (b != (c >= (d || e)))'\'' -a 2,1,0,0,1'
test-expr 'a && (b != (c >= (d || e)))' -a 2,1,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b != (c >= (d || e)))'\'' -a 2,1,0,0,1'

echo '$ test-expr '\''a && (b != (c >= (d || e)))'\'' -a 2,1,0,0,2'
test-expr 'a && (b != (c >= (d || e)))' -a 2,1,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b != (c >= (d || e)))'\'' -a 2,1,0,0,2'

echo '$ test-expr '\''a && (b != (c >= (d || e)))'\'' -a 2,1,0,1,0'
test-expr 'a && (b != (c >= (d || e)))' -a 2,1,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b != (c >= (d || e)))'\'' -a 2,1,0,1,0'

echo '$ test-expr '\''a && (b != (c >= (d || e)))'\'' -a 2,1,0,1,2'
test-expr 'a && (b != (c >= (d || e)))' -a 2,1,0,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b != (c >= (d || e)))'\'' -a 2,1,0,1,2'

echo '$ test-expr '\''a && (b != (c >= (d || e)))'\'' -a 2,2,2,0,2'
test-expr 'a && (b != (c >= (d || e)))' -a 2,2,2,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b != (c >= (d || e)))'\'' -a 2,2,2,0,2'

echo '$ test-expr '\''a && (b != (c >= (d || e)))'\'' -a 2,2,2,2,2'
test-expr 'a && (b != (c >= (d || e)))' -a 2,2,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b != (c >= (d || e)))'\'' -a 2,2,2,2,2'

echo '$ test-expr '\''a && (b != (c || (d >= e)))'\'' -a 0,0,0,0,1'
test-expr 'a && (b != (c || (d >= e)))' -a 0,0,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b != (c || (d >= e)))'\'' -a 0,0,0,0,1'

echo '$ test-expr '\''a && (b != (c || (d >= e)))'\'' -a 0,0,0,1,1'
test-expr 'a && (b != (c || (d >= e)))' -a 0,0,0,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b != (c || (d >= e)))'\'' -a 0,0,0,1,1'

echo '$ test-expr '\''a && (b != (c || (d >= e)))'\'' -a 0,0,2,0,1'
test-expr 'a && (b != (c || (d >= e)))' -a 0,0,2,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b != (c || (d >= e)))'\'' -a 0,0,2,0,1'

echo '$ test-expr '\''a && (b != (c || (d >= e)))'\'' -a 0,1,0,2,2'
test-expr 'a && (b != (c || (d >= e)))' -a 0,1,0,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b != (c || (d >= e)))'\'' -a 0,1,0,2,2'

echo '$ test-expr '\''a && (b != (c || (d >= e)))'\'' -a 0,2,0,2,1'
test-expr 'a && (b != (c || (d >= e)))' -a 0,2,0,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b != (c || (d >= e)))'\'' -a 0,2,0,2,1'

echo '$ test-expr '\''a && (b != (c || (d >= e)))'\'' -a 0,2,1,0,1'
test-expr 'a && (b != (c || (d >= e)))' -a 0,2,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b != (c || (d >= e)))'\'' -a 0,2,1,0,1'

echo '$ test-expr '\''a && (b != (c || (d >= e)))'\'' -a 0,2,2,2,1'
test-expr 'a && (b != (c || (d >= e)))' -a 0,2,2,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b != (c || (d >= e)))'\'' -a 0,2,2,2,1'

echo '$ test-expr '\''a && (b != (c || (d >= e)))'\'' -a 1,0,0,0,2'
test-expr 'a && (b != (c || (d >= e)))' -a 1,0,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b != (c || (d >= e)))'\'' -a 1,0,0,0,2'

echo '$ test-expr '\''a && (b != (c || (d >= e)))'\'' -a 1,0,1,1,2'
test-expr 'a && (b != (c || (d >= e)))' -a 1,0,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b != (c || (d >= e)))'\'' -a 1,0,1,1,2'

echo '$ test-expr '\''a && (b != (c || (d >= e)))'\'' -a 1,1,0,2,2'
test-expr 'a && (b != (c || (d >= e)))' -a 1,1,0,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b != (c || (d >= e)))'\'' -a 1,1,0,2,2'

echo '$ test-expr '\''a && (b != (c || (d >= e)))'\'' -a 1,1,1,2,0'
test-expr 'a && (b != (c || (d >= e)))' -a 1,1,1,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b != (c || (d >= e)))'\'' -a 1,1,1,2,0'

echo '$ test-expr '\''a && (b != (c || (d >= e)))'\'' -a 1,2,0,1,0'
test-expr 'a && (b != (c || (d >= e)))' -a 1,2,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b != (c || (d >= e)))'\'' -a 1,2,0,1,0'

echo '$ test-expr '\''a && (b != (c || (d >= e)))'\'' -a 1,2,0,2,1'
test-expr 'a && (b != (c || (d >= e)))' -a 1,2,0,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b != (c || (d >= e)))'\'' -a 1,2,0,2,1'

echo '$ test-expr '\''a && (b != (c || (d >= e)))'\'' -a 1,2,1,1,1'
test-expr 'a && (b != (c || (d >= e)))' -a 1,2,1,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b != (c || (d >= e)))'\'' -a 1,2,1,1,1'

echo '$ test-expr '\''a && (b != (c || (d >= e)))'\'' -a 1,2,2,0,0'
test-expr 'a && (b != (c || (d >= e)))' -a 1,2,2,0,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b != (c || (d >= e)))'\'' -a 1,2,2,0,0'

echo '$ test-expr '\''a && (b != (c || (d >= e)))'\'' -a 1,2,2,1,0'
test-expr 'a && (b != (c || (d >= e)))' -a 1,2,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b != (c || (d >= e)))'\'' -a 1,2,2,1,0'

echo '$ test-expr '\''a && (b != (c || (d >= e)))'\'' -a 1,2,2,1,2'
test-expr 'a && (b != (c || (d >= e)))' -a 1,2,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b != (c || (d >= e)))'\'' -a 1,2,2,1,2'

echo '$ test-expr '\''a && (b != (c || (d >= e)))'\'' -a 2,0,2,0,0'
test-expr 'a && (b != (c || (d >= e)))' -a 2,0,2,0,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b != (c || (d >= e)))'\'' -a 2,0,2,0,0'

echo '$ test-expr '\''a && (b != (c || (d >= e)))'\'' -a 2,1,0,2,1'
test-expr 'a && (b != (c || (d >= e)))' -a 2,1,0,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b != (c || (d >= e)))'\'' -a 2,1,0,2,1'

echo '$ test-expr '\''a && (b != (c || (d >= e)))'\'' -a 2,1,0,2,2'
test-expr 'a && (b != (c || (d >= e)))' -a 2,1,0,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b != (c || (d >= e)))'\'' -a 2,1,0,2,2'

echo '$ test-expr '\''a && (b != (c || (d >= e)))'\'' -a 2,2,1,0,2'
test-expr 'a && (b != (c || (d >= e)))' -a 2,2,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b != (c || (d >= e)))'\'' -a 2,2,1,0,2'

echo '$ test-expr '\''a && (b != (c || (d >= e)))'\'' -a 2,2,1,1,0'
test-expr 'a && (b != (c || (d >= e)))' -a 2,2,1,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b != (c || (d >= e)))'\'' -a 2,2,1,1,0'

echo '$ test-expr '\''a && (b != (c || (d >= e)))'\'' -a 2,2,1,1,2'
test-expr 'a && (b != (c || (d >= e)))' -a 2,2,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b != (c || (d >= e)))'\'' -a 2,2,1,1,2'

echo '$ test-expr '\''a && (b != ((c >= d) || e))'\'' -a 0,0,0,2,0'
test-expr 'a && (b != ((c >= d) || e))' -a 0,0,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b != ((c >= d) || e))'\'' -a 0,0,0,2,0'

echo '$ test-expr '\''a && (b != ((c >= d) || e))'\'' -a 0,0,1,1,2'
test-expr 'a && (b != ((c >= d) || e))' -a 0,0,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b != ((c >= d) || e))'\'' -a 0,0,1,1,2'

echo '$ test-expr '\''a && (b != ((c >= d) || e))'\'' -a 0,0,2,1,0'
test-expr 'a && (b != ((c >= d) || e))' -a 0,0,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b != ((c >= d) || e))'\'' -a 0,0,2,1,0'

echo '$ test-expr '\''a && (b != ((c >= d) || e))'\'' -a 0,0,2,1,1'
test-expr 'a && (b != ((c >= d) || e))' -a 0,0,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b != ((c >= d) || e))'\'' -a 0,0,2,1,1'

echo '$ test-expr '\''a && (b != ((c >= d) || e))'\'' -a 0,1,1,2,0'
test-expr 'a && (b != ((c >= d) || e))' -a 0,1,1,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b != ((c >= d) || e))'\'' -a 0,1,1,2,0'

echo '$ test-expr '\''a && (b != ((c >= d) || e))'\'' -a 0,2,2,2,1'
test-expr 'a && (b != ((c >= d) || e))' -a 0,2,2,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b != ((c >= d) || e))'\'' -a 0,2,2,2,1'

echo '$ test-expr '\''a && (b != ((c >= d) || e))'\'' -a 1,0,0,0,2'
test-expr 'a && (b != ((c >= d) || e))' -a 1,0,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b != ((c >= d) || e))'\'' -a 1,0,0,0,2'

echo '$ test-expr '\''a && (b != ((c >= d) || e))'\'' -a 1,0,0,1,0'
test-expr 'a && (b != ((c >= d) || e))' -a 1,0,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b != ((c >= d) || e))'\'' -a 1,0,0,1,0'

echo '$ test-expr '\''a && (b != ((c >= d) || e))'\'' -a 1,0,1,0,0'
test-expr 'a && (b != ((c >= d) || e))' -a 1,0,1,0,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b != ((c >= d) || e))'\'' -a 1,0,1,0,0'

echo '$ test-expr '\''a && (b != ((c >= d) || e))'\'' -a 1,0,1,1,1'
test-expr 'a && (b != ((c >= d) || e))' -a 1,0,1,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b != ((c >= d) || e))'\'' -a 1,0,1,1,1'

echo '$ test-expr '\''a && (b != ((c >= d) || e))'\'' -a 1,0,2,0,0'
test-expr 'a && (b != ((c >= d) || e))' -a 1,0,2,0,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b != ((c >= d) || e))'\'' -a 1,0,2,0,0'

echo '$ test-expr '\''a && (b != ((c >= d) || e))'\'' -a 1,0,2,0,2'
test-expr 'a && (b != ((c >= d) || e))' -a 1,0,2,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b != ((c >= d) || e))'\'' -a 1,0,2,0,2'

echo '$ test-expr '\''a && (b != ((c >= d) || e))'\'' -a 1,1,2,1,2'
test-expr 'a && (b != ((c >= d) || e))' -a 1,1,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b != ((c >= d) || e))'\'' -a 1,1,2,1,2'

echo '$ test-expr '\''a && (b != ((c >= d) || e))'\'' -a 1,2,0,2,0'
test-expr 'a && (b != ((c >= d) || e))' -a 1,2,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b != ((c >= d) || e))'\'' -a 1,2,0,2,0'

echo '$ test-expr '\''a && (b != ((c >= d) || e))'\'' -a 1,2,0,2,2'
test-expr 'a && (b != ((c >= d) || e))' -a 1,2,0,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b != ((c >= d) || e))'\'' -a 1,2,0,2,2'

echo '$ test-expr '\''a && (b != ((c >= d) || e))'\'' -a 1,2,1,1,0'
test-expr 'a && (b != ((c >= d) || e))' -a 1,2,1,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b != ((c >= d) || e))'\'' -a 1,2,1,1,0'

echo '$ test-expr '\''a && (b != ((c >= d) || e))'\'' -a 1,2,2,1,0'
test-expr 'a && (b != ((c >= d) || e))' -a 1,2,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b != ((c >= d) || e))'\'' -a 1,2,2,1,0'

echo '$ test-expr '\''a && (b != ((c >= d) || e))'\'' -a 2,0,0,0,2'
test-expr 'a && (b != ((c >= d) || e))' -a 2,0,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b != ((c >= d) || e))'\'' -a 2,0,0,0,2'

echo '$ test-expr '\''a && (b != ((c >= d) || e))'\'' -a 2,0,0,1,0'
test-expr 'a && (b != ((c >= d) || e))' -a 2,0,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b != ((c >= d) || e))'\'' -a 2,0,0,1,0'

echo '$ test-expr '\''a && (b != ((c >= d) || e))'\'' -a 2,0,2,0,1'
test-expr 'a && (b != ((c >= d) || e))' -a 2,0,2,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b != ((c >= d) || e))'\'' -a 2,0,2,0,1'

echo '$ test-expr '\''a && (b != ((c >= d) || e))'\'' -a 2,0,2,0,2'
test-expr 'a && (b != ((c >= d) || e))' -a 2,0,2,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b != ((c >= d) || e))'\'' -a 2,0,2,0,2'

echo '$ test-expr '\''a && (b != ((c >= d) || e))'\'' -a 2,0,2,2,2'
test-expr 'a && (b != ((c >= d) || e))' -a 2,0,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b != ((c >= d) || e))'\'' -a 2,0,2,2,2'

echo '$ test-expr '\''a && (b != ((c >= d) || e))'\'' -a 2,1,1,0,0'
test-expr 'a && (b != ((c >= d) || e))' -a 2,1,1,0,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b != ((c >= d) || e))'\'' -a 2,1,1,0,0'

echo '$ test-expr '\''a && (b != ((c >= d) || e))'\'' -a 2,1,1,2,0'
test-expr 'a && (b != ((c >= d) || e))' -a 2,1,1,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b != ((c >= d) || e))'\'' -a 2,1,1,2,0'

echo '$ test-expr '\''a && (b != ((c >= d) || e))'\'' -a 2,2,0,1,2'
test-expr 'a && (b != ((c >= d) || e))' -a 2,2,0,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b != ((c >= d) || e))'\'' -a 2,2,0,1,2'

echo '$ test-expr '\''a && (b != ((c >= d) || e))'\'' -a 2,2,0,2,1'
test-expr 'a && (b != ((c >= d) || e))' -a 2,2,0,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b != ((c >= d) || e))'\'' -a 2,2,0,2,1'

echo '$ test-expr '\''a && (b != ((c >= d) || e))'\'' -a 2,2,1,1,0'
test-expr 'a && (b != ((c >= d) || e))' -a 2,2,1,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b != ((c >= d) || e))'\'' -a 2,2,1,1,0'

echo '$ test-expr '\''a && (b != ((c || d) >= e))'\'' -a 0,0,1,2,1'
test-expr 'a && (b != ((c || d) >= e))' -a 0,0,1,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b != ((c || d) >= e))'\'' -a 0,0,1,2,1'

echo '$ test-expr '\''a && (b != ((c || d) >= e))'\'' -a 0,0,1,2,2'
test-expr 'a && (b != ((c || d) >= e))' -a 0,0,1,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b != ((c || d) >= e))'\'' -a 0,0,1,2,2'

echo '$ test-expr '\''a && (b != ((c || d) >= e))'\'' -a 0,0,2,2,1'
test-expr 'a && (b != ((c || d) >= e))' -a 0,0,2,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b != ((c || d) >= e))'\'' -a 0,0,2,2,1'

echo '$ test-expr '\''a && (b != ((c || d) >= e))'\'' -a 0,1,0,0,0'
test-expr 'a && (b != ((c || d) >= e))' -a 0,1,0,0,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b != ((c || d) >= e))'\'' -a 0,1,0,0,0'

echo '$ test-expr '\''a && (b != ((c || d) >= e))'\'' -a 0,1,0,2,2'
test-expr 'a && (b != ((c || d) >= e))' -a 0,1,0,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b != ((c || d) >= e))'\'' -a 0,1,0,2,2'

echo '$ test-expr '\''a && (b != ((c || d) >= e))'\'' -a 0,1,1,0,1'
test-expr 'a && (b != ((c || d) >= e))' -a 0,1,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b != ((c || d) >= e))'\'' -a 0,1,1,0,1'

echo '$ test-expr '\''a && (b != ((c || d) >= e))'\'' -a 0,1,1,1,2'
test-expr 'a && (b != ((c || d) >= e))' -a 0,1,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b != ((c || d) >= e))'\'' -a 0,1,1,1,2'

echo '$ test-expr '\''a && (b != ((c || d) >= e))'\'' -a 0,2,0,0,2'
test-expr 'a && (b != ((c || d) >= e))' -a 0,2,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b != ((c || d) >= e))'\'' -a 0,2,0,0,2'

echo '$ test-expr '\''a && (b != ((c || d) >= e))'\'' -a 0,2,0,1,0'
test-expr 'a && (b != ((c || d) >= e))' -a 0,2,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b != ((c || d) >= e))'\'' -a 0,2,0,1,0'

echo '$ test-expr '\''a && (b != ((c || d) >= e))'\'' -a 0,2,0,1,2'
test-expr 'a && (b != ((c || d) >= e))' -a 0,2,0,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b != ((c || d) >= e))'\'' -a 0,2,0,1,2'

echo '$ test-expr '\''a && (b != ((c || d) >= e))'\'' -a 0,2,1,0,0'
test-expr 'a && (b != ((c || d) >= e))' -a 0,2,1,0,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b != ((c || d) >= e))'\'' -a 0,2,1,0,0'

echo '$ test-expr '\''a && (b != ((c || d) >= e))'\'' -a 0,2,2,0,2'
test-expr 'a && (b != ((c || d) >= e))' -a 0,2,2,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b != ((c || d) >= e))'\'' -a 0,2,2,0,2'

echo '$ test-expr '\''a && (b != ((c || d) >= e))'\'' -a 1,0,1,2,0'
test-expr 'a && (b != ((c || d) >= e))' -a 1,0,1,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b != ((c || d) >= e))'\'' -a 1,0,1,2,0'

echo '$ test-expr '\''a && (b != ((c || d) >= e))'\'' -a 1,0,2,1,2'
test-expr 'a && (b != ((c || d) >= e))' -a 1,0,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b != ((c || d) >= e))'\'' -a 1,0,2,1,2'

echo '$ test-expr '\''a && (b != ((c || d) >= e))'\'' -a 1,1,0,1,2'
test-expr 'a && (b != ((c || d) >= e))' -a 1,1,0,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b != ((c || d) >= e))'\'' -a 1,1,0,1,2'

echo '$ test-expr '\''a && (b != ((c || d) >= e))'\'' -a 1,1,1,0,0'
test-expr 'a && (b != ((c || d) >= e))' -a 1,1,1,0,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b != ((c || d) >= e))'\'' -a 1,1,1,0,0'

echo '$ test-expr '\''a && (b != ((c || d) >= e))'\'' -a 1,1,2,1,1'
test-expr 'a && (b != ((c || d) >= e))' -a 1,1,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b != ((c || d) >= e))'\'' -a 1,1,2,1,1'

echo '$ test-expr '\''a && (b != ((c || d) >= e))'\'' -a 1,2,0,1,2'
test-expr 'a && (b != ((c || d) >= e))' -a 1,2,0,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b != ((c || d) >= e))'\'' -a 1,2,0,1,2'

echo '$ test-expr '\''a && (b != ((c || d) >= e))'\'' -a 1,2,2,1,0'
test-expr 'a && (b != ((c || d) >= e))' -a 1,2,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b != ((c || d) >= e))'\'' -a 1,2,2,1,0'

echo '$ test-expr '\''a && (b != ((c || d) >= e))'\'' -a 1,2,2,1,1'
test-expr 'a && (b != ((c || d) >= e))' -a 1,2,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b != ((c || d) >= e))'\'' -a 1,2,2,1,1'

echo '$ test-expr '\''a && (b != ((c || d) >= e))'\'' -a 1,2,2,1,2'
test-expr 'a && (b != ((c || d) >= e))' -a 1,2,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b != ((c || d) >= e))'\'' -a 1,2,2,1,2'

echo '$ test-expr '\''a && (b != ((c || d) >= e))'\'' -a 1,2,2,2,0'
test-expr 'a && (b != ((c || d) >= e))' -a 1,2,2,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b != ((c || d) >= e))'\'' -a 1,2,2,2,0'

echo '$ test-expr '\''a && (b != ((c || d) >= e))'\'' -a 2,0,0,0,0'
test-expr 'a && (b != ((c || d) >= e))' -a 2,0,0,0,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b != ((c || d) >= e))'\'' -a 2,0,0,0,0'

echo '$ test-expr '\''a && (b != ((c || d) >= e))'\'' -a 2,0,1,0,2'
test-expr 'a && (b != ((c || d) >= e))' -a 2,0,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b != ((c || d) >= e))'\'' -a 2,0,1,0,2'

echo '$ test-expr '\''a && (b != ((c || d) >= e))'\'' -a 2,0,1,2,2'
test-expr 'a && (b != ((c || d) >= e))' -a 2,0,1,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b != ((c || d) >= e))'\'' -a 2,0,1,2,2'

echo '$ test-expr '\''a && (b != ((c || d) >= e))'\'' -a 2,0,2,0,1'
test-expr 'a && (b != ((c || d) >= e))' -a 2,0,2,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b != ((c || d) >= e))'\'' -a 2,0,2,0,1'

echo '$ test-expr '\''a && (b != ((c || d) >= e))'\'' -a 2,0,2,1,1'
test-expr 'a && (b != ((c || d) >= e))' -a 2,0,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b != ((c || d) >= e))'\'' -a 2,0,2,1,1'

echo '$ test-expr '\''a && (b != ((c || d) >= e))'\'' -a 2,1,1,0,2'
test-expr 'a && (b != ((c || d) >= e))' -a 2,1,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b != ((c || d) >= e))'\'' -a 2,1,1,0,2'

echo '$ test-expr '\''a && (b != ((c || d) >= e))'\'' -a 2,1,1,1,0'
test-expr 'a && (b != ((c || d) >= e))' -a 2,1,1,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b != ((c || d) >= e))'\'' -a 2,1,1,1,0'

echo '$ test-expr '\''a && (b != ((c || d) >= e))'\'' -a 2,2,0,0,0'
test-expr 'a && (b != ((c || d) >= e))' -a 2,2,0,0,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b != ((c || d) >= e))'\'' -a 2,2,0,0,0'

echo '$ test-expr '\''a && (b != ((c || d) >= e))'\'' -a 2,2,1,0,1'
test-expr 'a && (b != ((c || d) >= e))' -a 2,2,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b != ((c || d) >= e))'\'' -a 2,2,1,0,1'

echo '$ test-expr '\''a && (b != ((c || d) >= e))'\'' -a 2,2,1,1,0'
test-expr 'a && (b != ((c || d) >= e))' -a 2,2,1,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b != ((c || d) >= e))'\'' -a 2,2,1,1,0'

echo '$ test-expr '\''a && (b != ((c || d) >= e))'\'' -a 2,2,2,2,1'
test-expr 'a && (b != ((c || d) >= e))' -a 2,2,2,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b != ((c || d) >= e))'\'' -a 2,2,2,2,1'

echo '$ test-expr '\''a && (b >= (c != (d || e)))'\'' -a 0,0,1,2,1'
test-expr 'a && (b >= (c != (d || e)))' -a 0,0,1,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= (c != (d || e)))'\'' -a 0,0,1,2,1'

echo '$ test-expr '\''a && (b >= (c != (d || e)))'\'' -a 0,1,0,2,2'
test-expr 'a && (b >= (c != (d || e)))' -a 0,1,0,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= (c != (d || e)))'\'' -a 0,1,0,2,2'

echo '$ test-expr '\''a && (b >= (c != (d || e)))'\'' -a 0,1,1,0,1'
test-expr 'a && (b >= (c != (d || e)))' -a 0,1,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= (c != (d || e)))'\'' -a 0,1,1,0,1'

echo '$ test-expr '\''a && (b >= (c != (d || e)))'\'' -a 0,1,2,0,1'
test-expr 'a && (b >= (c != (d || e)))' -a 0,1,2,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= (c != (d || e)))'\'' -a 0,1,2,0,1'

echo '$ test-expr '\''a && (b >= (c != (d || e)))'\'' -a 0,2,1,2,1'
test-expr 'a && (b >= (c != (d || e)))' -a 0,2,1,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= (c != (d || e)))'\'' -a 0,2,1,2,1'

echo '$ test-expr '\''a && (b >= (c != (d || e)))'\'' -a 0,2,1,2,2'
test-expr 'a && (b >= (c != (d || e)))' -a 0,2,1,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= (c != (d || e)))'\'' -a 0,2,1,2,2'

echo '$ test-expr '\''a && (b >= (c != (d || e)))'\'' -a 0,2,2,1,2'
test-expr 'a && (b >= (c != (d || e)))' -a 0,2,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= (c != (d || e)))'\'' -a 0,2,2,1,2'

echo '$ test-expr '\''a && (b >= (c != (d || e)))'\'' -a 0,2,2,2,1'
test-expr 'a && (b >= (c != (d || e)))' -a 0,2,2,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= (c != (d || e)))'\'' -a 0,2,2,2,1'

echo '$ test-expr '\''a && (b >= (c != (d || e)))'\'' -a 1,0,1,0,0'
test-expr 'a && (b >= (c != (d || e)))' -a 1,0,1,0,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= (c != (d || e)))'\'' -a 1,0,1,0,0'

echo '$ test-expr '\''a && (b >= (c != (d || e)))'\'' -a 1,0,1,1,2'
test-expr 'a && (b >= (c != (d || e)))' -a 1,0,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= (c != (d || e)))'\'' -a 1,0,1,1,2'

echo '$ test-expr '\''a && (b >= (c != (d || e)))'\'' -a 1,0,2,2,2'
test-expr 'a && (b >= (c != (d || e)))' -a 1,0,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= (c != (d || e)))'\'' -a 1,0,2,2,2'

echo '$ test-expr '\''a && (b >= (c != (d || e)))'\'' -a 1,1,2,0,1'
test-expr 'a && (b >= (c != (d || e)))' -a 1,1,2,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= (c != (d || e)))'\'' -a 1,1,2,0,1'

echo '$ test-expr '\''a && (b >= (c != (d || e)))'\'' -a 1,1,2,0,2'
test-expr 'a && (b >= (c != (d || e)))' -a 1,1,2,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= (c != (d || e)))'\'' -a 1,1,2,0,2'

echo '$ test-expr '\''a && (b >= (c != (d || e)))'\'' -a 1,1,2,1,1'
test-expr 'a && (b >= (c != (d || e)))' -a 1,1,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= (c != (d || e)))'\'' -a 1,1,2,1,1'

echo '$ test-expr '\''a && (b >= (c != (d || e)))'\'' -a 1,1,2,2,0'
test-expr 'a && (b >= (c != (d || e)))' -a 1,1,2,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= (c != (d || e)))'\'' -a 1,1,2,2,0'

echo '$ test-expr '\''a && (b >= (c != (d || e)))'\'' -a 1,2,0,0,1'
test-expr 'a && (b >= (c != (d || e)))' -a 1,2,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= (c != (d || e)))'\'' -a 1,2,0,0,1'

echo '$ test-expr '\''a && (b >= (c != (d || e)))'\'' -a 1,2,2,0,1'
test-expr 'a && (b >= (c != (d || e)))' -a 1,2,2,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= (c != (d || e)))'\'' -a 1,2,2,0,1'

echo '$ test-expr '\''a && (b >= (c != (d || e)))'\'' -a 2,0,0,1,0'
test-expr 'a && (b >= (c != (d || e)))' -a 2,0,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= (c != (d || e)))'\'' -a 2,0,0,1,0'

echo '$ test-expr '\''a && (b >= (c != (d || e)))'\'' -a 2,0,1,0,0'
test-expr 'a && (b >= (c != (d || e)))' -a 2,0,1,0,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= (c != (d || e)))'\'' -a 2,0,1,0,0'

echo '$ test-expr '\''a && (b >= (c != (d || e)))'\'' -a 2,0,1,2,0'
test-expr 'a && (b >= (c != (d || e)))' -a 2,0,1,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= (c != (d || e)))'\'' -a 2,0,1,2,0'

echo '$ test-expr '\''a && (b >= (c != (d || e)))'\'' -a 2,0,2,0,1'
test-expr 'a && (b >= (c != (d || e)))' -a 2,0,2,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= (c != (d || e)))'\'' -a 2,0,2,0,1'

echo '$ test-expr '\''a && (b >= (c != (d || e)))'\'' -a 2,1,0,0,1'
test-expr 'a && (b >= (c != (d || e)))' -a 2,1,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= (c != (d || e)))'\'' -a 2,1,0,0,1'

echo '$ test-expr '\''a && (b >= (c != (d || e)))'\'' -a 2,1,0,1,0'
test-expr 'a && (b >= (c != (d || e)))' -a 2,1,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= (c != (d || e)))'\'' -a 2,1,0,1,0'

echo '$ test-expr '\''a && (b >= (c != (d || e)))'\'' -a 2,1,0,2,2'
test-expr 'a && (b >= (c != (d || e)))' -a 2,1,0,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= (c != (d || e)))'\'' -a 2,1,0,2,2'

echo '$ test-expr '\''a && (b >= (c != (d || e)))'\'' -a 2,1,1,1,0'
test-expr 'a && (b >= (c != (d || e)))' -a 2,1,1,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= (c != (d || e)))'\'' -a 2,1,1,1,0'

echo '$ test-expr '\''a && (b >= (c != (d || e)))'\'' -a 2,1,2,2,2'
test-expr 'a && (b >= (c != (d || e)))' -a 2,1,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= (c != (d || e)))'\'' -a 2,1,2,2,2'

echo '$ test-expr '\''a && (b >= (c != (d || e)))'\'' -a 2,2,0,0,1'
test-expr 'a && (b >= (c != (d || e)))' -a 2,2,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= (c != (d || e)))'\'' -a 2,2,0,0,1'

echo '$ test-expr '\''a && (b >= (c != (d || e)))'\'' -a 2,2,0,2,1'
test-expr 'a && (b >= (c != (d || e)))' -a 2,2,0,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= (c != (d || e)))'\'' -a 2,2,0,2,1'

echo '$ test-expr '\''a && (b >= (c != (d || e)))'\'' -a 2,2,1,2,1'
test-expr 'a && (b >= (c != (d || e)))' -a 2,2,1,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= (c != (d || e)))'\'' -a 2,2,1,2,1'

echo '$ test-expr '\''a && (b >= (c != (d || e)))'\'' -a 2,2,2,1,0'
test-expr 'a && (b >= (c != (d || e)))' -a 2,2,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= (c != (d || e)))'\'' -a 2,2,2,1,0'

echo '$ test-expr '\''a && (b >= (c != (d || e)))'\'' -a 2,2,2,2,0'
test-expr 'a && (b >= (c != (d || e)))' -a 2,2,2,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= (c != (d || e)))'\'' -a 2,2,2,2,0'

echo '$ test-expr '\''a && (b >= (c != (d || e)))'\'' -a 2,2,2,2,2'
test-expr 'a && (b >= (c != (d || e)))' -a 2,2,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= (c != (d || e)))'\'' -a 2,2,2,2,2'

echo '$ test-expr '\''a && (b >= (c || (d != e)))'\'' -a 0,0,1,1,1'
test-expr 'a && (b >= (c || (d != e)))' -a 0,0,1,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= (c || (d != e)))'\'' -a 0,0,1,1,1'

echo '$ test-expr '\''a && (b >= (c || (d != e)))'\'' -a 0,0,2,1,0'
test-expr 'a && (b >= (c || (d != e)))' -a 0,0,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= (c || (d != e)))'\'' -a 0,0,2,1,0'

echo '$ test-expr '\''a && (b >= (c || (d != e)))'\'' -a 0,1,2,0,1'
test-expr 'a && (b >= (c || (d != e)))' -a 0,1,2,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= (c || (d != e)))'\'' -a 0,1,2,0,1'

echo '$ test-expr '\''a && (b >= (c || (d != e)))'\'' -a 0,1,2,2,2'
test-expr 'a && (b >= (c || (d != e)))' -a 0,1,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= (c || (d != e)))'\'' -a 0,1,2,2,2'

echo '$ test-expr '\''a && (b >= (c || (d != e)))'\'' -a 0,2,0,1,1'
test-expr 'a && (b >= (c || (d != e)))' -a 0,2,0,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= (c || (d != e)))'\'' -a 0,2,0,1,1'

echo '$ test-expr '\''a && (b >= (c || (d != e)))'\'' -a 0,2,0,1,2'
test-expr 'a && (b >= (c || (d != e)))' -a 0,2,0,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= (c || (d != e)))'\'' -a 0,2,0,1,2'

echo '$ test-expr '\''a && (b >= (c || (d != e)))'\'' -a 0,2,0,2,2'
test-expr 'a && (b >= (c || (d != e)))' -a 0,2,0,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= (c || (d != e)))'\'' -a 0,2,0,2,2'

echo '$ test-expr '\''a && (b >= (c || (d != e)))'\'' -a 0,2,1,0,1'
test-expr 'a && (b >= (c || (d != e)))' -a 0,2,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= (c || (d != e)))'\'' -a 0,2,1,0,1'

echo '$ test-expr '\''a && (b >= (c || (d != e)))'\'' -a 0,2,1,1,2'
test-expr 'a && (b >= (c || (d != e)))' -a 0,2,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= (c || (d != e)))'\'' -a 0,2,1,1,2'

echo '$ test-expr '\''a && (b >= (c || (d != e)))'\'' -a 0,2,2,1,2'
test-expr 'a && (b >= (c || (d != e)))' -a 0,2,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= (c || (d != e)))'\'' -a 0,2,2,1,2'

echo '$ test-expr '\''a && (b >= (c || (d != e)))'\'' -a 1,0,0,1,1'
test-expr 'a && (b >= (c || (d != e)))' -a 1,0,0,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= (c || (d != e)))'\'' -a 1,0,0,1,1'

echo '$ test-expr '\''a && (b >= (c || (d != e)))'\'' -a 1,0,0,2,1'
test-expr 'a && (b >= (c || (d != e)))' -a 1,0,0,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= (c || (d != e)))'\'' -a 1,0,0,2,1'

echo '$ test-expr '\''a && (b >= (c || (d != e)))'\'' -a 1,1,1,0,1'
test-expr 'a && (b >= (c || (d != e)))' -a 1,1,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= (c || (d != e)))'\'' -a 1,1,1,0,1'

echo '$ test-expr '\''a && (b >= (c || (d != e)))'\'' -a 1,1,1,1,1'
test-expr 'a && (b >= (c || (d != e)))' -a 1,1,1,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= (c || (d != e)))'\'' -a 1,1,1,1,1'

echo '$ test-expr '\''a && (b >= (c || (d != e)))'\'' -a 1,2,2,2,2'
test-expr 'a && (b >= (c || (d != e)))' -a 1,2,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= (c || (d != e)))'\'' -a 1,2,2,2,2'

echo '$ test-expr '\''a && (b >= (c || (d != e)))'\'' -a 2,0,1,1,0'
test-expr 'a && (b >= (c || (d != e)))' -a 2,0,1,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= (c || (d != e)))'\'' -a 2,0,1,1,0'

echo '$ test-expr '\''a && (b >= (c || (d != e)))'\'' -a 2,0,2,1,1'
test-expr 'a && (b >= (c || (d != e)))' -a 2,0,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= (c || (d != e)))'\'' -a 2,0,2,1,1'

echo '$ test-expr '\''a && (b >= (c || (d != e)))'\'' -a 2,1,0,1,1'
test-expr 'a && (b >= (c || (d != e)))' -a 2,1,0,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= (c || (d != e)))'\'' -a 2,1,0,1,1'

echo '$ test-expr '\''a && (b >= (c || (d != e)))'\'' -a 2,1,0,2,1'
test-expr 'a && (b >= (c || (d != e)))' -a 2,1,0,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= (c || (d != e)))'\'' -a 2,1,0,2,1'

echo '$ test-expr '\''a && (b >= (c || (d != e)))'\'' -a 2,1,2,1,1'
test-expr 'a && (b >= (c || (d != e)))' -a 2,1,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= (c || (d != e)))'\'' -a 2,1,2,1,1'

echo '$ test-expr '\''a && (b >= (c || (d != e)))'\'' -a 2,2,0,2,1'
test-expr 'a && (b >= (c || (d != e)))' -a 2,2,0,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= (c || (d != e)))'\'' -a 2,2,0,2,1'

echo '$ test-expr '\''a && (b >= (c || (d != e)))'\'' -a 2,2,1,2,0'
test-expr 'a && (b >= (c || (d != e)))' -a 2,2,1,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= (c || (d != e)))'\'' -a 2,2,1,2,0'

echo '$ test-expr '\''a && (b >= ((c != d) || e))'\'' -a 0,0,0,1,2'
test-expr 'a && (b >= ((c != d) || e))' -a 0,0,0,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= ((c != d) || e))'\'' -a 0,0,0,1,2'

echo '$ test-expr '\''a && (b >= ((c != d) || e))'\'' -a 0,0,0,2,2'
test-expr 'a && (b >= ((c != d) || e))' -a 0,0,0,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= ((c != d) || e))'\'' -a 0,0,0,2,2'

echo '$ test-expr '\''a && (b >= ((c != d) || e))'\'' -a 0,0,1,0,0'
test-expr 'a && (b >= ((c != d) || e))' -a 0,0,1,0,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= ((c != d) || e))'\'' -a 0,0,1,0,0'

echo '$ test-expr '\''a && (b >= ((c != d) || e))'\'' -a 0,0,1,1,0'
test-expr 'a && (b >= ((c != d) || e))' -a 0,0,1,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= ((c != d) || e))'\'' -a 0,0,1,1,0'

echo '$ test-expr '\''a && (b >= ((c != d) || e))'\'' -a 0,0,2,1,1'
test-expr 'a && (b >= ((c != d) || e))' -a 0,0,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= ((c != d) || e))'\'' -a 0,0,2,1,1'

echo '$ test-expr '\''a && (b >= ((c != d) || e))'\'' -a 0,1,2,1,2'
test-expr 'a && (b >= ((c != d) || e))' -a 0,1,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= ((c != d) || e))'\'' -a 0,1,2,1,2'

echo '$ test-expr '\''a && (b >= ((c != d) || e))'\'' -a 0,2,0,1,0'
test-expr 'a && (b >= ((c != d) || e))' -a 0,2,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= ((c != d) || e))'\'' -a 0,2,0,1,0'

echo '$ test-expr '\''a && (b >= ((c != d) || e))'\'' -a 0,2,2,0,2'
test-expr 'a && (b >= ((c != d) || e))' -a 0,2,2,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= ((c != d) || e))'\'' -a 0,2,2,0,2'

echo '$ test-expr '\''a && (b >= ((c != d) || e))'\'' -a 1,0,0,0,0'
test-expr 'a && (b >= ((c != d) || e))' -a 1,0,0,0,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= ((c != d) || e))'\'' -a 1,0,0,0,0'

echo '$ test-expr '\''a && (b >= ((c != d) || e))'\'' -a 1,0,1,0,0'
test-expr 'a && (b >= ((c != d) || e))' -a 1,0,1,0,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= ((c != d) || e))'\'' -a 1,0,1,0,0'

echo '$ test-expr '\''a && (b >= ((c != d) || e))'\'' -a 1,0,1,0,2'
test-expr 'a && (b >= ((c != d) || e))' -a 1,0,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= ((c != d) || e))'\'' -a 1,0,1,0,2'

echo '$ test-expr '\''a && (b >= ((c != d) || e))'\'' -a 1,0,1,1,2'
test-expr 'a && (b >= ((c != d) || e))' -a 1,0,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= ((c != d) || e))'\'' -a 1,0,1,1,2'

echo '$ test-expr '\''a && (b >= ((c != d) || e))'\'' -a 1,0,1,2,1'
test-expr 'a && (b >= ((c != d) || e))' -a 1,0,1,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= ((c != d) || e))'\'' -a 1,0,1,2,1'

echo '$ test-expr '\''a && (b >= ((c != d) || e))'\'' -a 1,1,1,0,1'
test-expr 'a && (b >= ((c != d) || e))' -a 1,1,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= ((c != d) || e))'\'' -a 1,1,1,0,1'

echo '$ test-expr '\''a && (b >= ((c != d) || e))'\'' -a 1,1,1,1,1'
test-expr 'a && (b >= ((c != d) || e))' -a 1,1,1,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= ((c != d) || e))'\'' -a 1,1,1,1,1'

echo '$ test-expr '\''a && (b >= ((c != d) || e))'\'' -a 1,2,0,0,1'
test-expr 'a && (b >= ((c != d) || e))' -a 1,2,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= ((c != d) || e))'\'' -a 1,2,0,0,1'

echo '$ test-expr '\''a && (b >= ((c != d) || e))'\'' -a 1,2,1,1,0'
test-expr 'a && (b >= ((c != d) || e))' -a 1,2,1,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= ((c != d) || e))'\'' -a 1,2,1,1,0'

echo '$ test-expr '\''a && (b >= ((c != d) || e))'\'' -a 1,2,2,1,0'
test-expr 'a && (b >= ((c != d) || e))' -a 1,2,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= ((c != d) || e))'\'' -a 1,2,2,1,0'

echo '$ test-expr '\''a && (b >= ((c != d) || e))'\'' -a 1,2,2,2,0'
test-expr 'a && (b >= ((c != d) || e))' -a 1,2,2,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= ((c != d) || e))'\'' -a 1,2,2,2,0'

echo '$ test-expr '\''a && (b >= ((c != d) || e))'\'' -a 2,0,0,2,2'
test-expr 'a && (b >= ((c != d) || e))' -a 2,0,0,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= ((c != d) || e))'\'' -a 2,0,0,2,2'

echo '$ test-expr '\''a && (b >= ((c != d) || e))'\'' -a 2,0,2,1,1'
test-expr 'a && (b >= ((c != d) || e))' -a 2,0,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= ((c != d) || e))'\'' -a 2,0,2,1,1'

echo '$ test-expr '\''a && (b >= ((c != d) || e))'\'' -a 2,0,2,2,1'
test-expr 'a && (b >= ((c != d) || e))' -a 2,0,2,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= ((c != d) || e))'\'' -a 2,0,2,2,1'

echo '$ test-expr '\''a && (b >= ((c != d) || e))'\'' -a 2,0,2,2,2'
test-expr 'a && (b >= ((c != d) || e))' -a 2,0,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= ((c != d) || e))'\'' -a 2,0,2,2,2'

echo '$ test-expr '\''a && (b >= ((c != d) || e))'\'' -a 2,1,0,2,0'
test-expr 'a && (b >= ((c != d) || e))' -a 2,1,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= ((c != d) || e))'\'' -a 2,1,0,2,0'

echo '$ test-expr '\''a && (b >= ((c != d) || e))'\'' -a 2,1,2,2,0'
test-expr 'a && (b >= ((c != d) || e))' -a 2,1,2,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= ((c != d) || e))'\'' -a 2,1,2,2,0'

echo '$ test-expr '\''a && (b >= ((c != d) || e))'\'' -a 2,2,0,1,2'
test-expr 'a && (b >= ((c != d) || e))' -a 2,2,0,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= ((c != d) || e))'\'' -a 2,2,0,1,2'

echo '$ test-expr '\''a && (b >= ((c != d) || e))'\'' -a 2,2,0,2,2'
test-expr 'a && (b >= ((c != d) || e))' -a 2,2,0,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= ((c != d) || e))'\'' -a 2,2,0,2,2'

echo '$ test-expr '\''a && (b >= ((c != d) || e))'\'' -a 2,2,1,0,1'
test-expr 'a && (b >= ((c != d) || e))' -a 2,2,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= ((c != d) || e))'\'' -a 2,2,1,0,1'

echo '$ test-expr '\''a && (b >= ((c != d) || e))'\'' -a 2,2,1,0,2'
test-expr 'a && (b >= ((c != d) || e))' -a 2,2,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= ((c != d) || e))'\'' -a 2,2,1,0,2'

echo '$ test-expr '\''a && (b >= ((c || d) != e))'\'' -a 0,0,1,0,0'
test-expr 'a && (b >= ((c || d) != e))' -a 0,0,1,0,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= ((c || d) != e))'\'' -a 0,0,1,0,0'

echo '$ test-expr '\''a && (b >= ((c || d) != e))'\'' -a 0,0,2,1,0'
test-expr 'a && (b >= ((c || d) != e))' -a 0,0,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= ((c || d) != e))'\'' -a 0,0,2,1,0'

echo '$ test-expr '\''a && (b >= ((c || d) != e))'\'' -a 0,1,0,0,2'
test-expr 'a && (b >= ((c || d) != e))' -a 0,1,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= ((c || d) != e))'\'' -a 0,1,0,0,2'

echo '$ test-expr '\''a && (b >= ((c || d) != e))'\'' -a 0,1,2,0,1'
test-expr 'a && (b >= ((c || d) != e))' -a 0,1,2,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= ((c || d) != e))'\'' -a 0,1,2,0,1'

echo '$ test-expr '\''a && (b >= ((c || d) != e))'\'' -a 0,2,0,0,1'
test-expr 'a && (b >= ((c || d) != e))' -a 0,2,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= ((c || d) != e))'\'' -a 0,2,0,0,1'

echo '$ test-expr '\''a && (b >= ((c || d) != e))'\'' -a 0,2,1,0,1'
test-expr 'a && (b >= ((c || d) != e))' -a 0,2,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= ((c || d) != e))'\'' -a 0,2,1,0,1'

echo '$ test-expr '\''a && (b >= ((c || d) != e))'\'' -a 0,2,1,2,0'
test-expr 'a && (b >= ((c || d) != e))' -a 0,2,1,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= ((c || d) != e))'\'' -a 0,2,1,2,0'

echo '$ test-expr '\''a && (b >= ((c || d) != e))'\'' -a 0,2,2,2,2'
test-expr 'a && (b >= ((c || d) != e))' -a 0,2,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= ((c || d) != e))'\'' -a 0,2,2,2,2'

echo '$ test-expr '\''a && (b >= ((c || d) != e))'\'' -a 1,0,1,1,0'
test-expr 'a && (b >= ((c || d) != e))' -a 1,0,1,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= ((c || d) != e))'\'' -a 1,0,1,1,0'

echo '$ test-expr '\''a && (b >= ((c || d) != e))'\'' -a 1,1,2,2,2'
test-expr 'a && (b >= ((c || d) != e))' -a 1,1,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= ((c || d) != e))'\'' -a 1,1,2,2,2'

echo '$ test-expr '\''a && (b >= ((c || d) != e))'\'' -a 1,2,0,1,0'
test-expr 'a && (b >= ((c || d) != e))' -a 1,2,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= ((c || d) != e))'\'' -a 1,2,0,1,0'

echo '$ test-expr '\''a && (b >= ((c || d) != e))'\'' -a 1,2,1,0,0'
test-expr 'a && (b >= ((c || d) != e))' -a 1,2,1,0,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= ((c || d) != e))'\'' -a 1,2,1,0,0'

echo '$ test-expr '\''a && (b >= ((c || d) != e))'\'' -a 1,2,1,0,2'
test-expr 'a && (b >= ((c || d) != e))' -a 1,2,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= ((c || d) != e))'\'' -a 1,2,1,0,2'

echo '$ test-expr '\''a && (b >= ((c || d) != e))'\'' -a 2,0,0,1,0'
test-expr 'a && (b >= ((c || d) != e))' -a 2,0,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= ((c || d) != e))'\'' -a 2,0,0,1,0'

echo '$ test-expr '\''a && (b >= ((c || d) != e))'\'' -a 2,0,2,2,1'
test-expr 'a && (b >= ((c || d) != e))' -a 2,0,2,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= ((c || d) != e))'\'' -a 2,0,2,2,1'

echo '$ test-expr '\''a && (b >= ((c || d) != e))'\'' -a 2,1,0,0,2'
test-expr 'a && (b >= ((c || d) != e))' -a 2,1,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= ((c || d) != e))'\'' -a 2,1,0,0,2'

echo '$ test-expr '\''a && (b >= ((c || d) != e))'\'' -a 2,1,1,0,1'
test-expr 'a && (b >= ((c || d) != e))' -a 2,1,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= ((c || d) != e))'\'' -a 2,1,1,0,1'

echo '$ test-expr '\''a && (b >= ((c || d) != e))'\'' -a 2,1,2,1,2'
test-expr 'a && (b >= ((c || d) != e))' -a 2,1,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= ((c || d) != e))'\'' -a 2,1,2,1,2'

echo '$ test-expr '\''a && (b >= ((c || d) != e))'\'' -a 2,2,2,0,2'
test-expr 'a && (b >= ((c || d) != e))' -a 2,2,2,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b >= ((c || d) != e))'\'' -a 2,2,2,0,2'

echo '$ test-expr '\''a && (b || (c != (d >= e)))'\'' -a 0,0,0,1,1'
test-expr 'a && (b || (c != (d >= e)))' -a 0,0,0,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b || (c != (d >= e)))'\'' -a 0,0,0,1,1'

echo '$ test-expr '\''a && (b || (c != (d >= e)))'\'' -a 0,1,1,0,0'
test-expr 'a && (b || (c != (d >= e)))' -a 0,1,1,0,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b || (c != (d >= e)))'\'' -a 0,1,1,0,0'

echo '$ test-expr '\''a && (b || (c != (d >= e)))'\'' -a 0,1,2,2,2'
test-expr 'a && (b || (c != (d >= e)))' -a 0,1,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b || (c != (d >= e)))'\'' -a 0,1,2,2,2'

echo '$ test-expr '\''a && (b || (c != (d >= e)))'\'' -a 0,2,0,2,0'
test-expr 'a && (b || (c != (d >= e)))' -a 0,2,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b || (c != (d >= e)))'\'' -a 0,2,0,2,0'

echo '$ test-expr '\''a && (b || (c != (d >= e)))'\'' -a 0,2,0,2,1'
test-expr 'a && (b || (c != (d >= e)))' -a 0,2,0,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b || (c != (d >= e)))'\'' -a 0,2,0,2,1'

echo '$ test-expr '\''a && (b || (c != (d >= e)))'\'' -a 0,2,2,0,0'
test-expr 'a && (b || (c != (d >= e)))' -a 0,2,2,0,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b || (c != (d >= e)))'\'' -a 0,2,2,0,0'

echo '$ test-expr '\''a && (b || (c != (d >= e)))'\'' -a 0,2,2,1,2'
test-expr 'a && (b || (c != (d >= e)))' -a 0,2,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b || (c != (d >= e)))'\'' -a 0,2,2,1,2'

echo '$ test-expr '\''a && (b || (c != (d >= e)))'\'' -a 1,0,0,0,0'
test-expr 'a && (b || (c != (d >= e)))' -a 1,0,0,0,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b || (c != (d >= e)))'\'' -a 1,0,0,0,0'

echo '$ test-expr '\''a && (b || (c != (d >= e)))'\'' -a 1,0,0,1,1'
test-expr 'a && (b || (c != (d >= e)))' -a 1,0,0,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b || (c != (d >= e)))'\'' -a 1,0,0,1,1'

echo '$ test-expr '\''a && (b || (c != (d >= e)))'\'' -a 1,0,0,2,0'
test-expr 'a && (b || (c != (d >= e)))' -a 1,0,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b || (c != (d >= e)))'\'' -a 1,0,0,2,0'

echo '$ test-expr '\''a && (b || (c != (d >= e)))'\'' -a 1,0,1,1,1'
test-expr 'a && (b || (c != (d >= e)))' -a 1,0,1,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b || (c != (d >= e)))'\'' -a 1,0,1,1,1'

echo '$ test-expr '\''a && (b || (c != (d >= e)))'\'' -a 1,0,2,0,2'
test-expr 'a && (b || (c != (d >= e)))' -a 1,0,2,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b || (c != (d >= e)))'\'' -a 1,0,2,0,2'

echo '$ test-expr '\''a && (b || (c != (d >= e)))'\'' -a 1,1,0,0,2'
test-expr 'a && (b || (c != (d >= e)))' -a 1,1,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b || (c != (d >= e)))'\'' -a 1,1,0,0,2'

echo '$ test-expr '\''a && (b || (c != (d >= e)))'\'' -a 1,1,1,0,1'
test-expr 'a && (b || (c != (d >= e)))' -a 1,1,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b || (c != (d >= e)))'\'' -a 1,1,1,0,1'

echo '$ test-expr '\''a && (b || (c != (d >= e)))'\'' -a 1,1,1,1,2'
test-expr 'a && (b || (c != (d >= e)))' -a 1,1,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b || (c != (d >= e)))'\'' -a 1,1,1,1,2'

echo '$ test-expr '\''a && (b || (c != (d >= e)))'\'' -a 1,2,0,0,1'
test-expr 'a && (b || (c != (d >= e)))' -a 1,2,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b || (c != (d >= e)))'\'' -a 1,2,0,0,1'

echo '$ test-expr '\''a && (b || (c != (d >= e)))'\'' -a 1,2,1,1,0'
test-expr 'a && (b || (c != (d >= e)))' -a 1,2,1,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b || (c != (d >= e)))'\'' -a 1,2,1,1,0'

echo '$ test-expr '\''a && (b || (c != (d >= e)))'\'' -a 1,2,1,1,2'
test-expr 'a && (b || (c != (d >= e)))' -a 1,2,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b || (c != (d >= e)))'\'' -a 1,2,1,1,2'

echo '$ test-expr '\''a && (b || (c != (d >= e)))'\'' -a 2,0,0,0,1'
test-expr 'a && (b || (c != (d >= e)))' -a 2,0,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b || (c != (d >= e)))'\'' -a 2,0,0,0,1'

echo '$ test-expr '\''a && (b || (c != (d >= e)))'\'' -a 2,0,0,1,1'
test-expr 'a && (b || (c != (d >= e)))' -a 2,0,0,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b || (c != (d >= e)))'\'' -a 2,0,0,1,1'

echo '$ test-expr '\''a && (b || (c != (d >= e)))'\'' -a 2,0,1,1,1'
test-expr 'a && (b || (c != (d >= e)))' -a 2,0,1,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b || (c != (d >= e)))'\'' -a 2,0,1,1,1'

echo '$ test-expr '\''a && (b || (c != (d >= e)))'\'' -a 2,0,1,2,2'
test-expr 'a && (b || (c != (d >= e)))' -a 2,0,1,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b || (c != (d >= e)))'\'' -a 2,0,1,2,2'

echo '$ test-expr '\''a && (b || (c != (d >= e)))'\'' -a 2,0,2,0,0'
test-expr 'a && (b || (c != (d >= e)))' -a 2,0,2,0,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b || (c != (d >= e)))'\'' -a 2,0,2,0,0'

echo '$ test-expr '\''a && (b || (c != (d >= e)))'\'' -a 2,0,2,0,2'
test-expr 'a && (b || (c != (d >= e)))' -a 2,0,2,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b || (c != (d >= e)))'\'' -a 2,0,2,0,2'

echo '$ test-expr '\''a && (b || (c != (d >= e)))'\'' -a 2,1,1,0,2'
test-expr 'a && (b || (c != (d >= e)))' -a 2,1,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b || (c != (d >= e)))'\'' -a 2,1,1,0,2'

echo '$ test-expr '\''a && (b || (c != (d >= e)))'\'' -a 2,2,0,1,0'
test-expr 'a && (b || (c != (d >= e)))' -a 2,2,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b || (c != (d >= e)))'\'' -a 2,2,0,1,0'

echo '$ test-expr '\''a && (b || (c != (d >= e)))'\'' -a 2,2,0,2,2'
test-expr 'a && (b || (c != (d >= e)))' -a 2,2,0,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b || (c != (d >= e)))'\'' -a 2,2,0,2,2'

echo '$ test-expr '\''a && (b || (c != (d >= e)))'\'' -a 2,2,2,0,0'
test-expr 'a && (b || (c != (d >= e)))' -a 2,2,2,0,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b || (c != (d >= e)))'\'' -a 2,2,2,0,0'

echo '$ test-expr '\''a && (b || (c != (d >= e)))'\'' -a 2,2,2,0,1'
test-expr 'a && (b || (c != (d >= e)))' -a 2,2,2,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b || (c != (d >= e)))'\'' -a 2,2,2,0,1'

echo '$ test-expr '\''a && (b || (c >= (d != e)))'\'' -a 0,0,0,0,0'
test-expr 'a && (b || (c >= (d != e)))' -a 0,0,0,0,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b || (c >= (d != e)))'\'' -a 0,0,0,0,0'

echo '$ test-expr '\''a && (b || (c >= (d != e)))'\'' -a 0,0,2,1,2'
test-expr 'a && (b || (c >= (d != e)))' -a 0,0,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b || (c >= (d != e)))'\'' -a 0,0,2,1,2'

echo '$ test-expr '\''a && (b || (c >= (d != e)))'\'' -a 0,1,0,0,1'
test-expr 'a && (b || (c >= (d != e)))' -a 0,1,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b || (c >= (d != e)))'\'' -a 0,1,0,0,1'

echo '$ test-expr '\''a && (b || (c >= (d != e)))'\'' -a 0,1,0,2,2'
test-expr 'a && (b || (c >= (d != e)))' -a 0,1,0,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b || (c >= (d != e)))'\'' -a 0,1,0,2,2'

echo '$ test-expr '\''a && (b || (c >= (d != e)))'\'' -a 0,1,1,0,1'
test-expr 'a && (b || (c >= (d != e)))' -a 0,1,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b || (c >= (d != e)))'\'' -a 0,1,1,0,1'

echo '$ test-expr '\''a && (b || (c >= (d != e)))'\'' -a 0,1,1,0,2'
test-expr 'a && (b || (c >= (d != e)))' -a 0,1,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b || (c >= (d != e)))'\'' -a 0,1,1,0,2'

echo '$ test-expr '\''a && (b || (c >= (d != e)))'\'' -a 0,1,2,2,1'
test-expr 'a && (b || (c >= (d != e)))' -a 0,1,2,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b || (c >= (d != e)))'\'' -a 0,1,2,2,1'

echo '$ test-expr '\''a && (b || (c >= (d != e)))'\'' -a 0,2,0,0,0'
test-expr 'a && (b || (c >= (d != e)))' -a 0,2,0,0,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b || (c >= (d != e)))'\'' -a 0,2,0,0,0'

echo '$ test-expr '\''a && (b || (c >= (d != e)))'\'' -a 0,2,1,0,1'
test-expr 'a && (b || (c >= (d != e)))' -a 0,2,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b || (c >= (d != e)))'\'' -a 0,2,1,0,1'

echo '$ test-expr '\''a && (b || (c >= (d != e)))'\'' -a 0,2,1,1,0'
test-expr 'a && (b || (c >= (d != e)))' -a 0,2,1,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b || (c >= (d != e)))'\'' -a 0,2,1,1,0'

echo '$ test-expr '\''a && (b || (c >= (d != e)))'\'' -a 1,0,0,0,1'
test-expr 'a && (b || (c >= (d != e)))' -a 1,0,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b || (c >= (d != e)))'\'' -a 1,0,0,0,1'

echo '$ test-expr '\''a && (b || (c >= (d != e)))'\'' -a 1,0,0,2,1'
test-expr 'a && (b || (c >= (d != e)))' -a 1,0,0,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b || (c >= (d != e)))'\'' -a 1,0,0,2,1'

echo '$ test-expr '\''a && (b || (c >= (d != e)))'\'' -a 1,0,1,0,2'
test-expr 'a && (b || (c >= (d != e)))' -a 1,0,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b || (c >= (d != e)))'\'' -a 1,0,1,0,2'

echo '$ test-expr '\''a && (b || (c >= (d != e)))'\'' -a 1,0,1,1,2'
test-expr 'a && (b || (c >= (d != e)))' -a 1,0,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b || (c >= (d != e)))'\'' -a 1,0,1,1,2'

echo '$ test-expr '\''a && (b || (c >= (d != e)))'\'' -a 1,1,0,0,0'
test-expr 'a && (b || (c >= (d != e)))' -a 1,1,0,0,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b || (c >= (d != e)))'\'' -a 1,1,0,0,0'

echo '$ test-expr '\''a && (b || (c >= (d != e)))'\'' -a 1,1,0,1,2'
test-expr 'a && (b || (c >= (d != e)))' -a 1,1,0,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b || (c >= (d != e)))'\'' -a 1,1,0,1,2'

echo '$ test-expr '\''a && (b || (c >= (d != e)))'\'' -a 1,1,2,0,2'
test-expr 'a && (b || (c >= (d != e)))' -a 1,1,2,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b || (c >= (d != e)))'\'' -a 1,1,2,0,2'

echo '$ test-expr '\''a && (b || (c >= (d != e)))'\'' -a 1,1,2,1,0'
test-expr 'a && (b || (c >= (d != e)))' -a 1,1,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b || (c >= (d != e)))'\'' -a 1,1,2,1,0'

echo '$ test-expr '\''a && (b || (c >= (d != e)))'\'' -a 1,1,2,2,2'
test-expr 'a && (b || (c >= (d != e)))' -a 1,1,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b || (c >= (d != e)))'\'' -a 1,1,2,2,2'

echo '$ test-expr '\''a && (b || (c >= (d != e)))'\'' -a 1,2,2,1,1'
test-expr 'a && (b || (c >= (d != e)))' -a 1,2,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b || (c >= (d != e)))'\'' -a 1,2,2,1,1'

echo '$ test-expr '\''a && (b || (c >= (d != e)))'\'' -a 2,0,0,2,1'
test-expr 'a && (b || (c >= (d != e)))' -a 2,0,0,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b || (c >= (d != e)))'\'' -a 2,0,0,2,1'

echo '$ test-expr '\''a && (b || (c >= (d != e)))'\'' -a 2,0,2,1,2'
test-expr 'a && (b || (c >= (d != e)))' -a 2,0,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b || (c >= (d != e)))'\'' -a 2,0,2,1,2'

echo '$ test-expr '\''a && (b || (c >= (d != e)))'\'' -a 2,1,0,1,2'
test-expr 'a && (b || (c >= (d != e)))' -a 2,1,0,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b || (c >= (d != e)))'\'' -a 2,1,0,1,2'

echo '$ test-expr '\''a && (b || (c >= (d != e)))'\'' -a 2,1,2,0,1'
test-expr 'a && (b || (c >= (d != e)))' -a 2,1,2,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b || (c >= (d != e)))'\'' -a 2,1,2,0,1'

echo '$ test-expr '\''a && (b || (c >= (d != e)))'\'' -a 2,1,2,1,0'
test-expr 'a && (b || (c >= (d != e)))' -a 2,1,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b || (c >= (d != e)))'\'' -a 2,1,2,1,0'

echo '$ test-expr '\''a && (b || (c >= (d != e)))'\'' -a 2,2,0,0,1'
test-expr 'a && (b || (c >= (d != e)))' -a 2,2,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b || (c >= (d != e)))'\'' -a 2,2,0,0,1'

echo '$ test-expr '\''a && (b || (c >= (d != e)))'\'' -a 2,2,2,1,0'
test-expr 'a && (b || (c >= (d != e)))' -a 2,2,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b || (c >= (d != e)))'\'' -a 2,2,2,1,0'

echo '$ test-expr '\''a && (b || ((c != d) >= e))'\'' -a 0,0,0,0,1'
test-expr 'a && (b || ((c != d) >= e))' -a 0,0,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b || ((c != d) >= e))'\'' -a 0,0,0,0,1'

echo '$ test-expr '\''a && (b || ((c != d) >= e))'\'' -a 0,0,0,2,0'
test-expr 'a && (b || ((c != d) >= e))' -a 0,0,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b || ((c != d) >= e))'\'' -a 0,0,0,2,0'

echo '$ test-expr '\''a && (b || ((c != d) >= e))'\'' -a 0,0,1,1,2'
test-expr 'a && (b || ((c != d) >= e))' -a 0,0,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b || ((c != d) >= e))'\'' -a 0,0,1,1,2'

echo '$ test-expr '\''a && (b || ((c != d) >= e))'\'' -a 0,0,2,2,1'
test-expr 'a && (b || ((c != d) >= e))' -a 0,0,2,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b || ((c != d) >= e))'\'' -a 0,0,2,2,1'

echo '$ test-expr '\''a && (b || ((c != d) >= e))'\'' -a 0,1,1,0,0'
test-expr 'a && (b || ((c != d) >= e))' -a 0,1,1,0,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b || ((c != d) >= e))'\'' -a 0,1,1,0,0'

echo '$ test-expr '\''a && (b || ((c != d) >= e))'\'' -a 0,1,1,0,2'
test-expr 'a && (b || ((c != d) >= e))' -a 0,1,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b || ((c != d) >= e))'\'' -a 0,1,1,0,2'

echo '$ test-expr '\''a && (b || ((c != d) >= e))'\'' -a 0,1,2,0,2'
test-expr 'a && (b || ((c != d) >= e))' -a 0,1,2,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b || ((c != d) >= e))'\'' -a 0,1,2,0,2'

echo '$ test-expr '\''a && (b || ((c != d) >= e))'\'' -a 0,1,2,1,0'
test-expr 'a && (b || ((c != d) >= e))' -a 0,1,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b || ((c != d) >= e))'\'' -a 0,1,2,1,0'

echo '$ test-expr '\''a && (b || ((c != d) >= e))'\'' -a 0,2,0,2,0'
test-expr 'a && (b || ((c != d) >= e))' -a 0,2,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b || ((c != d) >= e))'\'' -a 0,2,0,2,0'

echo '$ test-expr '\''a && (b || ((c != d) >= e))'\'' -a 0,2,0,2,2'
test-expr 'a && (b || ((c != d) >= e))' -a 0,2,0,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b || ((c != d) >= e))'\'' -a 0,2,0,2,2'

echo '$ test-expr '\''a && (b || ((c != d) >= e))'\'' -a 0,2,1,0,2'
test-expr 'a && (b || ((c != d) >= e))' -a 0,2,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b || ((c != d) >= e))'\'' -a 0,2,1,0,2'

echo '$ test-expr '\''a && (b || ((c != d) >= e))'\'' -a 0,2,1,1,0'
test-expr 'a && (b || ((c != d) >= e))' -a 0,2,1,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b || ((c != d) >= e))'\'' -a 0,2,1,1,0'

echo '$ test-expr '\''a && (b || ((c != d) >= e))'\'' -a 1,0,2,0,1'
test-expr 'a && (b || ((c != d) >= e))' -a 1,0,2,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b || ((c != d) >= e))'\'' -a 1,0,2,0,1'

echo '$ test-expr '\''a && (b || ((c != d) >= e))'\'' -a 1,0,2,1,1'
test-expr 'a && (b || ((c != d) >= e))' -a 1,0,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b || ((c != d) >= e))'\'' -a 1,0,2,1,1'

echo '$ test-expr '\''a && (b || ((c != d) >= e))'\'' -a 1,1,0,1,1'
test-expr 'a && (b || ((c != d) >= e))' -a 1,1,0,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b || ((c != d) >= e))'\'' -a 1,1,0,1,1'

echo '$ test-expr '\''a && (b || ((c != d) >= e))'\'' -a 1,1,0,1,2'
test-expr 'a && (b || ((c != d) >= e))' -a 1,1,0,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b || ((c != d) >= e))'\'' -a 1,1,0,1,2'

echo '$ test-expr '\''a && (b || ((c != d) >= e))'\'' -a 1,1,0,2,1'
test-expr 'a && (b || ((c != d) >= e))' -a 1,1,0,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b || ((c != d) >= e))'\'' -a 1,1,0,2,1'

echo '$ test-expr '\''a && (b || ((c != d) >= e))'\'' -a 1,1,1,2,2'
test-expr 'a && (b || ((c != d) >= e))' -a 1,1,1,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b || ((c != d) >= e))'\'' -a 1,1,1,2,2'

echo '$ test-expr '\''a && (b || ((c != d) >= e))'\'' -a 1,2,1,2,0'
test-expr 'a && (b || ((c != d) >= e))' -a 1,2,1,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b || ((c != d) >= e))'\'' -a 1,2,1,2,0'

echo '$ test-expr '\''a && (b || ((c != d) >= e))'\'' -a 1,2,2,1,0'
test-expr 'a && (b || ((c != d) >= e))' -a 1,2,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b || ((c != d) >= e))'\'' -a 1,2,2,1,0'

echo '$ test-expr '\''a && (b || ((c != d) >= e))'\'' -a 1,2,2,1,1'
test-expr 'a && (b || ((c != d) >= e))' -a 1,2,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b || ((c != d) >= e))'\'' -a 1,2,2,1,1'

echo '$ test-expr '\''a && (b || ((c != d) >= e))'\'' -a 2,0,1,2,2'
test-expr 'a && (b || ((c != d) >= e))' -a 2,0,1,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b || ((c != d) >= e))'\'' -a 2,0,1,2,2'

echo '$ test-expr '\''a && (b || ((c != d) >= e))'\'' -a 2,1,2,0,2'
test-expr 'a && (b || ((c != d) >= e))' -a 2,1,2,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b || ((c != d) >= e))'\'' -a 2,1,2,0,2'

echo '$ test-expr '\''a && (b || ((c != d) >= e))'\'' -a 2,2,0,0,2'
test-expr 'a && (b || ((c != d) >= e))' -a 2,2,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b || ((c != d) >= e))'\'' -a 2,2,0,0,2'

echo '$ test-expr '\''a && (b || ((c != d) >= e))'\'' -a 2,2,0,2,0'
test-expr 'a && (b || ((c != d) >= e))' -a 2,2,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b || ((c != d) >= e))'\'' -a 2,2,0,2,0'

echo '$ test-expr '\''a && (b || ((c != d) >= e))'\'' -a 2,2,1,0,0'
test-expr 'a && (b || ((c != d) >= e))' -a 2,2,1,0,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b || ((c != d) >= e))'\'' -a 2,2,1,0,0'

echo '$ test-expr '\''a && (b || ((c != d) >= e))'\'' -a 2,2,1,2,0'
test-expr 'a && (b || ((c != d) >= e))' -a 2,2,1,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b || ((c != d) >= e))'\'' -a 2,2,1,2,0'

echo '$ test-expr '\''a && (b || ((c >= d) != e))'\'' -a 0,0,0,0,1'
test-expr 'a && (b || ((c >= d) != e))' -a 0,0,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b || ((c >= d) != e))'\'' -a 0,0,0,0,1'

echo '$ test-expr '\''a && (b || ((c >= d) != e))'\'' -a 0,0,1,1,0'
test-expr 'a && (b || ((c >= d) != e))' -a 0,0,1,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b || ((c >= d) != e))'\'' -a 0,0,1,1,0'

echo '$ test-expr '\''a && (b || ((c >= d) != e))'\'' -a 0,0,1,1,2'
test-expr 'a && (b || ((c >= d) != e))' -a 0,0,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b || ((c >= d) != e))'\'' -a 0,0,1,1,2'

echo '$ test-expr '\''a && (b || ((c >= d) != e))'\'' -a 0,1,0,0,2'
test-expr 'a && (b || ((c >= d) != e))' -a 0,1,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b || ((c >= d) != e))'\'' -a 0,1,0,0,2'

echo '$ test-expr '\''a && (b || ((c >= d) != e))'\'' -a 0,1,1,1,1'
test-expr 'a && (b || ((c >= d) != e))' -a 0,1,1,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b || ((c >= d) != e))'\'' -a 0,1,1,1,1'

echo '$ test-expr '\''a && (b || ((c >= d) != e))'\'' -a 0,1,1,2,1'
test-expr 'a && (b || ((c >= d) != e))' -a 0,1,1,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b || ((c >= d) != e))'\'' -a 0,1,1,2,1'

echo '$ test-expr '\''a && (b || ((c >= d) != e))'\'' -a 0,2,2,1,1'
test-expr 'a && (b || ((c >= d) != e))' -a 0,2,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b || ((c >= d) != e))'\'' -a 0,2,2,1,1'

echo '$ test-expr '\''a && (b || ((c >= d) != e))'\'' -a 1,0,0,0,2'
test-expr 'a && (b || ((c >= d) != e))' -a 1,0,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b || ((c >= d) != e))'\'' -a 1,0,0,0,2'

echo '$ test-expr '\''a && (b || ((c >= d) != e))'\'' -a 1,0,0,1,0'
test-expr 'a && (b || ((c >= d) != e))' -a 1,0,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b || ((c >= d) != e))'\'' -a 1,0,0,1,0'

echo '$ test-expr '\''a && (b || ((c >= d) != e))'\'' -a 1,0,0,1,1'
test-expr 'a && (b || ((c >= d) != e))' -a 1,0,0,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b || ((c >= d) != e))'\'' -a 1,0,0,1,1'

echo '$ test-expr '\''a && (b || ((c >= d) != e))'\'' -a 1,0,1,2,0'
test-expr 'a && (b || ((c >= d) != e))' -a 1,0,1,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b || ((c >= d) != e))'\'' -a 1,0,1,2,0'

echo '$ test-expr '\''a && (b || ((c >= d) != e))'\'' -a 1,0,1,2,2'
test-expr 'a && (b || ((c >= d) != e))' -a 1,0,1,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b || ((c >= d) != e))'\'' -a 1,0,1,2,2'

echo '$ test-expr '\''a && (b || ((c >= d) != e))'\'' -a 1,1,0,1,2'
test-expr 'a && (b || ((c >= d) != e))' -a 1,1,0,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b || ((c >= d) != e))'\'' -a 1,1,0,1,2'

echo '$ test-expr '\''a && (b || ((c >= d) != e))'\'' -a 1,1,1,2,2'
test-expr 'a && (b || ((c >= d) != e))' -a 1,1,1,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b || ((c >= d) != e))'\'' -a 1,1,1,2,2'

echo '$ test-expr '\''a && (b || ((c >= d) != e))'\'' -a 1,1,2,1,2'
test-expr 'a && (b || ((c >= d) != e))' -a 1,1,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b || ((c >= d) != e))'\'' -a 1,1,2,1,2'

echo '$ test-expr '\''a && (b || ((c >= d) != e))'\'' -a 1,1,2,2,2'
test-expr 'a && (b || ((c >= d) != e))' -a 1,1,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b || ((c >= d) != e))'\'' -a 1,1,2,2,2'

echo '$ test-expr '\''a && (b || ((c >= d) != e))'\'' -a 1,2,2,1,1'
test-expr 'a && (b || ((c >= d) != e))' -a 1,2,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && (b || ((c >= d) != e))'\'' -a 1,2,2,1,1'

echo '$ test-expr '\''a && (b || ((c >= d) != e))'\'' -a 2,0,0,2,2'
test-expr 'a && (b || ((c >= d) != e))' -a 2,0,0,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b || ((c >= d) != e))'\'' -a 2,0,0,2,2'

echo '$ test-expr '\''a && (b || ((c >= d) != e))'\'' -a 2,0,1,2,2'
test-expr 'a && (b || ((c >= d) != e))' -a 2,0,1,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b || ((c >= d) != e))'\'' -a 2,0,1,2,2'

echo '$ test-expr '\''a && (b || ((c >= d) != e))'\'' -a 2,0,2,2,2'
test-expr 'a && (b || ((c >= d) != e))' -a 2,0,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b || ((c >= d) != e))'\'' -a 2,0,2,2,2'

echo '$ test-expr '\''a && (b || ((c >= d) != e))'\'' -a 2,1,0,2,2'
test-expr 'a && (b || ((c >= d) != e))' -a 2,1,0,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b || ((c >= d) != e))'\'' -a 2,1,0,2,2'

echo '$ test-expr '\''a && (b || ((c >= d) != e))'\'' -a 2,1,1,0,0'
test-expr 'a && (b || ((c >= d) != e))' -a 2,1,1,0,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b || ((c >= d) != e))'\'' -a 2,1,1,0,0'

echo '$ test-expr '\''a && (b || ((c >= d) != e))'\'' -a 2,1,1,2,0'
test-expr 'a && (b || ((c >= d) != e))' -a 2,1,1,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b || ((c >= d) != e))'\'' -a 2,1,1,2,0'

echo '$ test-expr '\''a && (b || ((c >= d) != e))'\'' -a 2,2,0,1,2'
test-expr 'a && (b || ((c >= d) != e))' -a 2,2,0,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && (b || ((c >= d) != e))'\'' -a 2,2,0,1,2'

echo '$ test-expr '\''a && (b || ((c >= d) != e))'\'' -a 2,2,0,2,0'
test-expr 'a && (b || ((c >= d) != e))' -a 2,2,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && (b || ((c >= d) != e))'\'' -a 2,2,0,2,0'

echo '$ test-expr '\''a && ((b != c) >= (d || e))'\'' -a 0,0,0,0,0'
test-expr 'a && ((b != c) >= (d || e))' -a 0,0,0,0,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != c) >= (d || e))'\'' -a 0,0,0,0,0'

echo '$ test-expr '\''a && ((b != c) >= (d || e))'\'' -a 0,0,0,1,0'
test-expr 'a && ((b != c) >= (d || e))' -a 0,0,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != c) >= (d || e))'\'' -a 0,0,0,1,0'

echo '$ test-expr '\''a && ((b != c) >= (d || e))'\'' -a 0,0,1,1,1'
test-expr 'a && ((b != c) >= (d || e))' -a 0,0,1,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != c) >= (d || e))'\'' -a 0,0,1,1,1'

echo '$ test-expr '\''a && ((b != c) >= (d || e))'\'' -a 0,0,2,0,1'
test-expr 'a && ((b != c) >= (d || e))' -a 0,0,2,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != c) >= (d || e))'\'' -a 0,0,2,0,1'

echo '$ test-expr '\''a && ((b != c) >= (d || e))'\'' -a 0,1,1,0,0'
test-expr 'a && ((b != c) >= (d || e))' -a 0,1,1,0,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != c) >= (d || e))'\'' -a 0,1,1,0,0'

echo '$ test-expr '\''a && ((b != c) >= (d || e))'\'' -a 0,1,1,1,1'
test-expr 'a && ((b != c) >= (d || e))' -a 0,1,1,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != c) >= (d || e))'\'' -a 0,1,1,1,1'

echo '$ test-expr '\''a && ((b != c) >= (d || e))'\'' -a 0,1,1,2,0'
test-expr 'a && ((b != c) >= (d || e))' -a 0,1,1,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != c) >= (d || e))'\'' -a 0,1,1,2,0'

echo '$ test-expr '\''a && ((b != c) >= (d || e))'\'' -a 0,2,1,2,0'
test-expr 'a && ((b != c) >= (d || e))' -a 0,2,1,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != c) >= (d || e))'\'' -a 0,2,1,2,0'

echo '$ test-expr '\''a && ((b != c) >= (d || e))'\'' -a 0,2,2,0,0'
test-expr 'a && ((b != c) >= (d || e))' -a 0,2,2,0,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != c) >= (d || e))'\'' -a 0,2,2,0,0'

echo '$ test-expr '\''a && ((b != c) >= (d || e))'\'' -a 0,2,2,2,1'
test-expr 'a && ((b != c) >= (d || e))' -a 0,2,2,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != c) >= (d || e))'\'' -a 0,2,2,2,1'

echo '$ test-expr '\''a && ((b != c) >= (d || e))'\'' -a 0,2,2,2,2'
test-expr 'a && ((b != c) >= (d || e))' -a 0,2,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != c) >= (d || e))'\'' -a 0,2,2,2,2'

echo '$ test-expr '\''a && ((b != c) >= (d || e))'\'' -a 1,0,0,2,1'
test-expr 'a && ((b != c) >= (d || e))' -a 1,0,0,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != c) >= (d || e))'\'' -a 1,0,0,2,1'

echo '$ test-expr '\''a && ((b != c) >= (d || e))'\'' -a 1,0,1,1,1'
test-expr 'a && ((b != c) >= (d || e))' -a 1,0,1,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != c) >= (d || e))'\'' -a 1,0,1,1,1'

echo '$ test-expr '\''a && ((b != c) >= (d || e))'\'' -a 1,1,0,0,0'
test-expr 'a && ((b != c) >= (d || e))' -a 1,1,0,0,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != c) >= (d || e))'\'' -a 1,1,0,0,0'

echo '$ test-expr '\''a && ((b != c) >= (d || e))'\'' -a 1,1,0,1,2'
test-expr 'a && ((b != c) >= (d || e))' -a 1,1,0,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != c) >= (d || e))'\'' -a 1,1,0,1,2'

echo '$ test-expr '\''a && ((b != c) >= (d || e))'\'' -a 1,1,2,0,1'
test-expr 'a && ((b != c) >= (d || e))' -a 1,1,2,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != c) >= (d || e))'\'' -a 1,1,2,0,1'

echo '$ test-expr '\''a && ((b != c) >= (d || e))'\'' -a 1,1,2,1,1'
test-expr 'a && ((b != c) >= (d || e))' -a 1,1,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != c) >= (d || e))'\'' -a 1,1,2,1,1'

echo '$ test-expr '\''a && ((b != c) >= (d || e))'\'' -a 1,2,0,0,1'
test-expr 'a && ((b != c) >= (d || e))' -a 1,2,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != c) >= (d || e))'\'' -a 1,2,0,0,1'

echo '$ test-expr '\''a && ((b != c) >= (d || e))'\'' -a 1,2,0,1,2'
test-expr 'a && ((b != c) >= (d || e))' -a 1,2,0,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != c) >= (d || e))'\'' -a 1,2,0,1,2'

echo '$ test-expr '\''a && ((b != c) >= (d || e))'\'' -a 1,2,1,1,2'
test-expr 'a && ((b != c) >= (d || e))' -a 1,2,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != c) >= (d || e))'\'' -a 1,2,1,1,2'

echo '$ test-expr '\''a && ((b != c) >= (d || e))'\'' -a 1,2,2,1,1'
test-expr 'a && ((b != c) >= (d || e))' -a 1,2,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != c) >= (d || e))'\'' -a 1,2,2,1,1'

echo '$ test-expr '\''a && ((b != c) >= (d || e))'\'' -a 2,0,0,2,1'
test-expr 'a && ((b != c) >= (d || e))' -a 2,0,0,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != c) >= (d || e))'\'' -a 2,0,0,2,1'

echo '$ test-expr '\''a && ((b != c) >= (d || e))'\'' -a 2,0,2,0,2'
test-expr 'a && ((b != c) >= (d || e))' -a 2,0,2,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != c) >= (d || e))'\'' -a 2,0,2,0,2'

echo '$ test-expr '\''a && ((b != c) >= (d || e))'\'' -a 2,1,0,2,0'
test-expr 'a && ((b != c) >= (d || e))' -a 2,1,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != c) >= (d || e))'\'' -a 2,1,0,2,0'

echo '$ test-expr '\''a && ((b != c) >= (d || e))'\'' -a 2,1,2,2,2'
test-expr 'a && ((b != c) >= (d || e))' -a 2,1,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != c) >= (d || e))'\'' -a 2,1,2,2,2'

echo '$ test-expr '\''a && ((b != c) >= (d || e))'\'' -a 2,2,1,1,0'
test-expr 'a && ((b != c) >= (d || e))' -a 2,2,1,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != c) >= (d || e))'\'' -a 2,2,1,1,0'

echo '$ test-expr '\''a && ((b != c) >= (d || e))'\'' -a 2,2,2,1,1'
test-expr 'a && ((b != c) >= (d || e))' -a 2,2,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != c) >= (d || e))'\'' -a 2,2,2,1,1'

echo '$ test-expr '\''a && ((b != c) >= (d || e))'\'' -a 2,2,2,2,0'
test-expr 'a && ((b != c) >= (d || e))' -a 2,2,2,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != c) >= (d || e))'\'' -a 2,2,2,2,0'

echo '$ test-expr '\''a && ((b != c) || (d >= e))'\'' -a 0,0,0,0,1'
test-expr 'a && ((b != c) || (d >= e))' -a 0,0,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != c) || (d >= e))'\'' -a 0,0,0,0,1'

echo '$ test-expr '\''a && ((b != c) || (d >= e))'\'' -a 0,0,0,2,0'
test-expr 'a && ((b != c) || (d >= e))' -a 0,0,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != c) || (d >= e))'\'' -a 0,0,0,2,0'

echo '$ test-expr '\''a && ((b != c) || (d >= e))'\'' -a 0,2,0,0,0'
test-expr 'a && ((b != c) || (d >= e))' -a 0,2,0,0,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != c) || (d >= e))'\'' -a 0,2,0,0,0'

echo '$ test-expr '\''a && ((b != c) || (d >= e))'\'' -a 0,2,1,0,0'
test-expr 'a && ((b != c) || (d >= e))' -a 0,2,1,0,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != c) || (d >= e))'\'' -a 0,2,1,0,0'

echo '$ test-expr '\''a && ((b != c) || (d >= e))'\'' -a 0,2,1,2,0'
test-expr 'a && ((b != c) || (d >= e))' -a 0,2,1,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != c) || (d >= e))'\'' -a 0,2,1,2,0'

echo '$ test-expr '\''a && ((b != c) || (d >= e))'\'' -a 1,0,0,2,2'
test-expr 'a && ((b != c) || (d >= e))' -a 1,0,0,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != c) || (d >= e))'\'' -a 1,0,0,2,2'

echo '$ test-expr '\''a && ((b != c) || (d >= e))'\'' -a 1,0,1,0,0'
test-expr 'a && ((b != c) || (d >= e))' -a 1,0,1,0,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != c) || (d >= e))'\'' -a 1,0,1,0,0'

echo '$ test-expr '\''a && ((b != c) || (d >= e))'\'' -a 1,0,2,1,2'
test-expr 'a && ((b != c) || (d >= e))' -a 1,0,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != c) || (d >= e))'\'' -a 1,0,2,1,2'

echo '$ test-expr '\''a && ((b != c) || (d >= e))'\'' -a 1,0,2,2,0'
test-expr 'a && ((b != c) || (d >= e))' -a 1,0,2,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != c) || (d >= e))'\'' -a 1,0,2,2,0'

echo '$ test-expr '\''a && ((b != c) || (d >= e))'\'' -a 1,1,2,1,0'
test-expr 'a && ((b != c) || (d >= e))' -a 1,1,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != c) || (d >= e))'\'' -a 1,1,2,1,0'

echo '$ test-expr '\''a && ((b != c) || (d >= e))'\'' -a 1,1,2,2,2'
test-expr 'a && ((b != c) || (d >= e))' -a 1,1,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != c) || (d >= e))'\'' -a 1,1,2,2,2'

echo '$ test-expr '\''a && ((b != c) || (d >= e))'\'' -a 1,2,1,0,0'
test-expr 'a && ((b != c) || (d >= e))' -a 1,2,1,0,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != c) || (d >= e))'\'' -a 1,2,1,0,0'

echo '$ test-expr '\''a && ((b != c) || (d >= e))'\'' -a 2,0,0,1,0'
test-expr 'a && ((b != c) || (d >= e))' -a 2,0,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != c) || (d >= e))'\'' -a 2,0,0,1,0'

echo '$ test-expr '\''a && ((b != c) || (d >= e))'\'' -a 2,0,0,2,0'
test-expr 'a && ((b != c) || (d >= e))' -a 2,0,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != c) || (d >= e))'\'' -a 2,0,0,2,0'

echo '$ test-expr '\''a && ((b != c) || (d >= e))'\'' -a 2,0,2,0,0'
test-expr 'a && ((b != c) || (d >= e))' -a 2,0,2,0,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != c) || (d >= e))'\'' -a 2,0,2,0,0'

echo '$ test-expr '\''a && ((b != c) || (d >= e))'\'' -a 2,0,2,0,1'
test-expr 'a && ((b != c) || (d >= e))' -a 2,0,2,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != c) || (d >= e))'\'' -a 2,0,2,0,1'

echo '$ test-expr '\''a && ((b != c) || (d >= e))'\'' -a 2,1,0,0,1'
test-expr 'a && ((b != c) || (d >= e))' -a 2,1,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != c) || (d >= e))'\'' -a 2,1,0,0,1'

echo '$ test-expr '\''a && ((b != c) || (d >= e))'\'' -a 2,1,0,1,1'
test-expr 'a && ((b != c) || (d >= e))' -a 2,1,0,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != c) || (d >= e))'\'' -a 2,1,0,1,1'

echo '$ test-expr '\''a && ((b != c) || (d >= e))'\'' -a 2,1,0,2,0'
test-expr 'a && ((b != c) || (d >= e))' -a 2,1,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != c) || (d >= e))'\'' -a 2,1,0,2,0'

echo '$ test-expr '\''a && ((b != c) || (d >= e))'\'' -a 2,1,1,0,2'
test-expr 'a && ((b != c) || (d >= e))' -a 2,1,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != c) || (d >= e))'\'' -a 2,1,1,0,2'

echo '$ test-expr '\''a && ((b != c) || (d >= e))'\'' -a 2,1,2,0,1'
test-expr 'a && ((b != c) || (d >= e))' -a 2,1,2,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != c) || (d >= e))'\'' -a 2,1,2,0,1'

echo '$ test-expr '\''a && ((b != c) || (d >= e))'\'' -a 2,2,1,0,1'
test-expr 'a && ((b != c) || (d >= e))' -a 2,2,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != c) || (d >= e))'\'' -a 2,2,1,0,1'

echo '$ test-expr '\''a && ((b != c) || (d >= e))'\'' -a 2,2,2,1,2'
test-expr 'a && ((b != c) || (d >= e))' -a 2,2,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != c) || (d >= e))'\'' -a 2,2,2,1,2'

echo '$ test-expr '\''a && ((b != c) || (d >= e))'\'' -a 2,2,2,2,1'
test-expr 'a && ((b != c) || (d >= e))' -a 2,2,2,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != c) || (d >= e))'\'' -a 2,2,2,2,1'

echo '$ test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 0,0,0,2,0'
test-expr 'a && ((b != (c >= d)) || e)' -a 0,0,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 0,0,0,2,0'

echo '$ test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 0,0,1,2,0'
test-expr 'a && ((b != (c >= d)) || e)' -a 0,0,1,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 0,0,1,2,0'

echo '$ test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 0,1,0,0,0'
test-expr 'a && ((b != (c >= d)) || e)' -a 0,1,0,0,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 0,1,0,0,0'

echo '$ test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 0,1,0,1,0'
test-expr 'a && ((b != (c >= d)) || e)' -a 0,1,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 0,1,0,1,0'

echo '$ test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 0,1,0,1,2'
test-expr 'a && ((b != (c >= d)) || e)' -a 0,1,0,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 0,1,0,1,2'

echo '$ test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 0,1,1,1,2'
test-expr 'a && ((b != (c >= d)) || e)' -a 0,1,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 0,1,1,1,2'

echo '$ test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 0,1,1,2,0'
test-expr 'a && ((b != (c >= d)) || e)' -a 0,1,1,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 0,1,1,2,0'

echo '$ test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 0,1,2,1,0'
test-expr 'a && ((b != (c >= d)) || e)' -a 0,1,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 0,1,2,1,0'

echo '$ test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 0,1,2,2,1'
test-expr 'a && ((b != (c >= d)) || e)' -a 0,1,2,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 0,1,2,2,1'

echo '$ test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 1,0,0,2,1'
test-expr 'a && ((b != (c >= d)) || e)' -a 1,0,0,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 1,0,0,2,1'

echo '$ test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 1,0,1,2,0'
test-expr 'a && ((b != (c >= d)) || e)' -a 1,0,1,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 1,0,1,2,0'

echo '$ test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 1,0,2,2,0'
test-expr 'a && ((b != (c >= d)) || e)' -a 1,0,2,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 1,0,2,2,0'

echo '$ test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 1,1,0,2,2'
test-expr 'a && ((b != (c >= d)) || e)' -a 1,1,0,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 1,1,0,2,2'

echo '$ test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 1,1,1,2,1'
test-expr 'a && ((b != (c >= d)) || e)' -a 1,1,1,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 1,1,1,2,1'

echo '$ test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 1,1,2,0,2'
test-expr 'a && ((b != (c >= d)) || e)' -a 1,1,2,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 1,1,2,0,2'

echo '$ test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 1,1,2,2,0'
test-expr 'a && ((b != (c >= d)) || e)' -a 1,1,2,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 1,1,2,2,0'

echo '$ test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 1,2,0,0,1'
test-expr 'a && ((b != (c >= d)) || e)' -a 1,2,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 1,2,0,0,1'

echo '$ test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 1,2,1,0,2'
test-expr 'a && ((b != (c >= d)) || e)' -a 1,2,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 1,2,1,0,2'

echo '$ test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 1,2,1,1,2'
test-expr 'a && ((b != (c >= d)) || e)' -a 1,2,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 1,2,1,1,2'

echo '$ test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 1,2,2,1,1'
test-expr 'a && ((b != (c >= d)) || e)' -a 1,2,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 1,2,2,1,1'

echo '$ test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 2,0,0,0,1'
test-expr 'a && ((b != (c >= d)) || e)' -a 2,0,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 2,0,0,0,1'

echo '$ test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 2,0,0,2,0'
test-expr 'a && ((b != (c >= d)) || e)' -a 2,0,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 2,0,0,2,0'

echo '$ test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 2,0,1,0,0'
test-expr 'a && ((b != (c >= d)) || e)' -a 2,0,1,0,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 2,0,1,0,0'

echo '$ test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 2,0,2,1,0'
test-expr 'a && ((b != (c >= d)) || e)' -a 2,0,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 2,0,2,1,0'

echo '$ test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 2,1,0,1,2'
test-expr 'a && ((b != (c >= d)) || e)' -a 2,1,0,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 2,1,0,1,2'

echo '$ test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 2,1,1,0,1'
test-expr 'a && ((b != (c >= d)) || e)' -a 2,1,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 2,1,1,0,1'

echo '$ test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 2,1,1,0,2'
test-expr 'a && ((b != (c >= d)) || e)' -a 2,1,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 2,1,1,0,2'

echo '$ test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 2,1,1,2,0'
test-expr 'a && ((b != (c >= d)) || e)' -a 2,1,1,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 2,1,1,2,0'

echo '$ test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 2,1,1,2,1'
test-expr 'a && ((b != (c >= d)) || e)' -a 2,1,1,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 2,1,1,2,1'

echo '$ test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 2,2,2,1,1'
test-expr 'a && ((b != (c >= d)) || e)' -a 2,2,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 2,2,2,1,1'

echo '$ test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 2,2,2,2,1'
test-expr 'a && ((b != (c >= d)) || e)' -a 2,2,2,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != (c >= d)) || e)'\'' -a 2,2,2,2,1'

echo '$ test-expr '\''a && ((b != (c || d)) >= e)'\'' -a 0,1,0,2,0'
test-expr 'a && ((b != (c || d)) >= e)' -a 0,1,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != (c || d)) >= e)'\'' -a 0,1,0,2,0'

echo '$ test-expr '\''a && ((b != (c || d)) >= e)'\'' -a 0,2,1,1,1'
test-expr 'a && ((b != (c || d)) >= e)' -a 0,2,1,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != (c || d)) >= e)'\'' -a 0,2,1,1,1'

echo '$ test-expr '\''a && ((b != (c || d)) >= e)'\'' -a 0,2,2,1,2'
test-expr 'a && ((b != (c || d)) >= e)' -a 0,2,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != (c || d)) >= e)'\'' -a 0,2,2,1,2'

echo '$ test-expr '\''a && ((b != (c || d)) >= e)'\'' -a 1,0,0,0,0'
test-expr 'a && ((b != (c || d)) >= e)' -a 1,0,0,0,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != (c || d)) >= e)'\'' -a 1,0,0,0,0'

echo '$ test-expr '\''a && ((b != (c || d)) >= e)'\'' -a 1,0,1,0,0'
test-expr 'a && ((b != (c || d)) >= e)' -a 1,0,1,0,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != (c || d)) >= e)'\'' -a 1,0,1,0,0'

echo '$ test-expr '\''a && ((b != (c || d)) >= e)'\'' -a 1,1,2,1,0'
test-expr 'a && ((b != (c || d)) >= e)' -a 1,1,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != (c || d)) >= e)'\'' -a 1,1,2,1,0'

echo '$ test-expr '\''a && ((b != (c || d)) >= e)'\'' -a 1,1,2,1,2'
test-expr 'a && ((b != (c || d)) >= e)' -a 1,1,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != (c || d)) >= e)'\'' -a 1,1,2,1,2'

echo '$ test-expr '\''a && ((b != (c || d)) >= e)'\'' -a 1,2,0,0,2'
test-expr 'a && ((b != (c || d)) >= e)' -a 1,2,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != (c || d)) >= e)'\'' -a 1,2,0,0,2'

echo '$ test-expr '\''a && ((b != (c || d)) >= e)'\'' -a 1,2,1,0,2'
test-expr 'a && ((b != (c || d)) >= e)' -a 1,2,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != (c || d)) >= e)'\'' -a 1,2,1,0,2'

echo '$ test-expr '\''a && ((b != (c || d)) >= e)'\'' -a 1,2,1,1,1'
test-expr 'a && ((b != (c || d)) >= e)' -a 1,2,1,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != (c || d)) >= e)'\'' -a 1,2,1,1,1'

echo '$ test-expr '\''a && ((b != (c || d)) >= e)'\'' -a 1,2,2,0,0'
test-expr 'a && ((b != (c || d)) >= e)' -a 1,2,2,0,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != (c || d)) >= e)'\'' -a 1,2,2,0,0'

echo '$ test-expr '\''a && ((b != (c || d)) >= e)'\'' -a 2,0,0,0,2'
test-expr 'a && ((b != (c || d)) >= e)' -a 2,0,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != (c || d)) >= e)'\'' -a 2,0,0,0,2'

echo '$ test-expr '\''a && ((b != (c || d)) >= e)'\'' -a 2,0,2,0,2'
test-expr 'a && ((b != (c || d)) >= e)' -a 2,0,2,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != (c || d)) >= e)'\'' -a 2,0,2,0,2'

echo '$ test-expr '\''a && ((b != (c || d)) >= e)'\'' -a 2,1,1,0,2'
test-expr 'a && ((b != (c || d)) >= e)' -a 2,1,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != (c || d)) >= e)'\'' -a 2,1,1,0,2'

echo '$ test-expr '\''a && ((b != (c || d)) >= e)'\'' -a 2,1,1,1,1'
test-expr 'a && ((b != (c || d)) >= e)' -a 2,1,1,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != (c || d)) >= e)'\'' -a 2,1,1,1,1'

echo '$ test-expr '\''a && ((b != (c || d)) >= e)'\'' -a 2,1,2,1,2'
test-expr 'a && ((b != (c || d)) >= e)' -a 2,1,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != (c || d)) >= e)'\'' -a 2,1,2,1,2'

echo '$ test-expr '\''a && ((b != (c || d)) >= e)'\'' -a 2,2,0,1,2'
test-expr 'a && ((b != (c || d)) >= e)' -a 2,2,0,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != (c || d)) >= e)'\'' -a 2,2,0,1,2'

echo '$ test-expr '\''a && ((b != (c || d)) >= e)'\'' -a 2,2,0,2,0'
test-expr 'a && ((b != (c || d)) >= e)' -a 2,2,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != (c || d)) >= e)'\'' -a 2,2,0,2,0'

echo '$ test-expr '\''a && ((b != (c || d)) >= e)'\'' -a 2,2,2,2,0'
test-expr 'a && ((b != (c || d)) >= e)' -a 2,2,2,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != (c || d)) >= e)'\'' -a 2,2,2,2,0'

echo '$ test-expr '\''a && ((b != (c || d)) >= e)'\'' -a 2,2,2,2,2'
test-expr 'a && ((b != (c || d)) >= e)' -a 2,2,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b != (c || d)) >= e)'\'' -a 2,2,2,2,2'

echo '$ test-expr '\''a && ((b >= c) != (d || e))'\'' -a 0,0,0,0,2'
test-expr 'a && ((b >= c) != (d || e))' -a 0,0,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= c) != (d || e))'\'' -a 0,0,0,0,2'

echo '$ test-expr '\''a && ((b >= c) != (d || e))'\'' -a 0,1,1,2,0'
test-expr 'a && ((b >= c) != (d || e))' -a 0,1,1,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= c) != (d || e))'\'' -a 0,1,1,2,0'

echo '$ test-expr '\''a && ((b >= c) != (d || e))'\'' -a 0,1,2,1,0'
test-expr 'a && ((b >= c) != (d || e))' -a 0,1,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= c) != (d || e))'\'' -a 0,1,2,1,0'

echo '$ test-expr '\''a && ((b >= c) != (d || e))'\'' -a 0,1,2,1,1'
test-expr 'a && ((b >= c) != (d || e))' -a 0,1,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= c) != (d || e))'\'' -a 0,1,2,1,1'

echo '$ test-expr '\''a && ((b >= c) != (d || e))'\'' -a 0,1,2,2,0'
test-expr 'a && ((b >= c) != (d || e))' -a 0,1,2,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= c) != (d || e))'\'' -a 0,1,2,2,0'

echo '$ test-expr '\''a && ((b >= c) != (d || e))'\'' -a 0,2,0,0,0'
test-expr 'a && ((b >= c) != (d || e))' -a 0,2,0,0,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= c) != (d || e))'\'' -a 0,2,0,0,0'

echo '$ test-expr '\''a && ((b >= c) != (d || e))'\'' -a 0,2,1,0,1'
test-expr 'a && ((b >= c) != (d || e))' -a 0,2,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= c) != (d || e))'\'' -a 0,2,1,0,1'

echo '$ test-expr '\''a && ((b >= c) != (d || e))'\'' -a 0,2,1,2,1'
test-expr 'a && ((b >= c) != (d || e))' -a 0,2,1,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= c) != (d || e))'\'' -a 0,2,1,2,1'

echo '$ test-expr '\''a && ((b >= c) != (d || e))'\'' -a 0,2,2,0,0'
test-expr 'a && ((b >= c) != (d || e))' -a 0,2,2,0,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= c) != (d || e))'\'' -a 0,2,2,0,0'

echo '$ test-expr '\''a && ((b >= c) != (d || e))'\'' -a 1,0,0,1,1'
test-expr 'a && ((b >= c) != (d || e))' -a 1,0,0,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= c) != (d || e))'\'' -a 1,0,0,1,1'

echo '$ test-expr '\''a && ((b >= c) != (d || e))'\'' -a 1,0,0,2,1'
test-expr 'a && ((b >= c) != (d || e))' -a 1,0,0,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= c) != (d || e))'\'' -a 1,0,0,2,1'

echo '$ test-expr '\''a && ((b >= c) != (d || e))'\'' -a 1,0,1,1,2'
test-expr 'a && ((b >= c) != (d || e))' -a 1,0,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= c) != (d || e))'\'' -a 1,0,1,1,2'

echo '$ test-expr '\''a && ((b >= c) != (d || e))'\'' -a 1,1,0,0,0'
test-expr 'a && ((b >= c) != (d || e))' -a 1,1,0,0,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= c) != (d || e))'\'' -a 1,1,0,0,0'

echo '$ test-expr '\''a && ((b >= c) != (d || e))'\'' -a 1,1,1,1,2'
test-expr 'a && ((b >= c) != (d || e))' -a 1,1,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= c) != (d || e))'\'' -a 1,1,1,1,2'

echo '$ test-expr '\''a && ((b >= c) != (d || e))'\'' -a 1,2,0,1,1'
test-expr 'a && ((b >= c) != (d || e))' -a 1,2,0,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= c) != (d || e))'\'' -a 1,2,0,1,1'

echo '$ test-expr '\''a && ((b >= c) != (d || e))'\'' -a 1,2,1,1,2'
test-expr 'a && ((b >= c) != (d || e))' -a 1,2,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= c) != (d || e))'\'' -a 1,2,1,1,2'

echo '$ test-expr '\''a && ((b >= c) != (d || e))'\'' -a 1,2,1,2,0'
test-expr 'a && ((b >= c) != (d || e))' -a 1,2,1,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= c) != (d || e))'\'' -a 1,2,1,2,0'

echo '$ test-expr '\''a && ((b >= c) != (d || e))'\'' -a 1,2,2,1,0'
test-expr 'a && ((b >= c) != (d || e))' -a 1,2,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= c) != (d || e))'\'' -a 1,2,2,1,0'

echo '$ test-expr '\''a && ((b >= c) != (d || e))'\'' -a 1,2,2,2,2'
test-expr 'a && ((b >= c) != (d || e))' -a 1,2,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= c) != (d || e))'\'' -a 1,2,2,2,2'

echo '$ test-expr '\''a && ((b >= c) != (d || e))'\'' -a 2,0,0,0,2'
test-expr 'a && ((b >= c) != (d || e))' -a 2,0,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= c) != (d || e))'\'' -a 2,0,0,0,2'

echo '$ test-expr '\''a && ((b >= c) != (d || e))'\'' -a 2,0,0,1,0'
test-expr 'a && ((b >= c) != (d || e))' -a 2,0,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= c) != (d || e))'\'' -a 2,0,0,1,0'

echo '$ test-expr '\''a && ((b >= c) != (d || e))'\'' -a 2,0,2,2,2'
test-expr 'a && ((b >= c) != (d || e))' -a 2,0,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= c) != (d || e))'\'' -a 2,0,2,2,2'

echo '$ test-expr '\''a && ((b >= c) != (d || e))'\'' -a 2,1,1,0,1'
test-expr 'a && ((b >= c) != (d || e))' -a 2,1,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= c) != (d || e))'\'' -a 2,1,1,0,1'

echo '$ test-expr '\''a && ((b >= c) != (d || e))'\'' -a 2,1,2,1,2'
test-expr 'a && ((b >= c) != (d || e))' -a 2,1,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= c) != (d || e))'\'' -a 2,1,2,1,2'

echo '$ test-expr '\''a && ((b >= c) != (d || e))'\'' -a 2,2,0,2,0'
test-expr 'a && ((b >= c) != (d || e))' -a 2,2,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= c) != (d || e))'\'' -a 2,2,0,2,0'

echo '$ test-expr '\''a && ((b >= c) != (d || e))'\'' -a 2,2,1,2,2'
test-expr 'a && ((b >= c) != (d || e))' -a 2,2,1,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= c) != (d || e))'\'' -a 2,2,1,2,2'

echo '$ test-expr '\''a && ((b >= c) || (d != e))'\'' -a 0,0,0,0,2'
test-expr 'a && ((b >= c) || (d != e))' -a 0,0,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= c) || (d != e))'\'' -a 0,0,0,0,2'

echo '$ test-expr '\''a && ((b >= c) || (d != e))'\'' -a 0,0,0,1,2'
test-expr 'a && ((b >= c) || (d != e))' -a 0,0,0,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= c) || (d != e))'\'' -a 0,0,0,1,2'

echo '$ test-expr '\''a && ((b >= c) || (d != e))'\'' -a 0,0,2,1,1'
test-expr 'a && ((b >= c) || (d != e))' -a 0,0,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= c) || (d != e))'\'' -a 0,0,2,1,1'

echo '$ test-expr '\''a && ((b >= c) || (d != e))'\'' -a 0,0,2,1,2'
test-expr 'a && ((b >= c) || (d != e))' -a 0,0,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= c) || (d != e))'\'' -a 0,0,2,1,2'

echo '$ test-expr '\''a && ((b >= c) || (d != e))'\'' -a 0,0,2,2,0'
test-expr 'a && ((b >= c) || (d != e))' -a 0,0,2,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= c) || (d != e))'\'' -a 0,0,2,2,0'

echo '$ test-expr '\''a && ((b >= c) || (d != e))'\'' -a 0,1,0,1,0'
test-expr 'a && ((b >= c) || (d != e))' -a 0,1,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= c) || (d != e))'\'' -a 0,1,0,1,0'

echo '$ test-expr '\''a && ((b >= c) || (d != e))'\'' -a 0,1,1,0,2'
test-expr 'a && ((b >= c) || (d != e))' -a 0,1,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= c) || (d != e))'\'' -a 0,1,1,0,2'

echo '$ test-expr '\''a && ((b >= c) || (d != e))'\'' -a 0,1,1,2,1'
test-expr 'a && ((b >= c) || (d != e))' -a 0,1,1,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= c) || (d != e))'\'' -a 0,1,1,2,1'

echo '$ test-expr '\''a && ((b >= c) || (d != e))'\'' -a 0,1,1,2,2'
test-expr 'a && ((b >= c) || (d != e))' -a 0,1,1,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= c) || (d != e))'\'' -a 0,1,1,2,2'

echo '$ test-expr '\''a && ((b >= c) || (d != e))'\'' -a 0,1,2,1,2'
test-expr 'a && ((b >= c) || (d != e))' -a 0,1,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= c) || (d != e))'\'' -a 0,1,2,1,2'

echo '$ test-expr '\''a && ((b >= c) || (d != e))'\'' -a 0,2,0,0,2'
test-expr 'a && ((b >= c) || (d != e))' -a 0,2,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= c) || (d != e))'\'' -a 0,2,0,0,2'

echo '$ test-expr '\''a && ((b >= c) || (d != e))'\'' -a 0,2,1,2,0'
test-expr 'a && ((b >= c) || (d != e))' -a 0,2,1,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= c) || (d != e))'\'' -a 0,2,1,2,0'

echo '$ test-expr '\''a && ((b >= c) || (d != e))'\'' -a 0,2,2,1,1'
test-expr 'a && ((b >= c) || (d != e))' -a 0,2,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= c) || (d != e))'\'' -a 0,2,2,1,1'

echo '$ test-expr '\''a && ((b >= c) || (d != e))'\'' -a 1,0,1,0,2'
test-expr 'a && ((b >= c) || (d != e))' -a 1,0,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= c) || (d != e))'\'' -a 1,0,1,0,2'

echo '$ test-expr '\''a && ((b >= c) || (d != e))'\'' -a 1,0,1,1,2'
test-expr 'a && ((b >= c) || (d != e))' -a 1,0,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= c) || (d != e))'\'' -a 1,0,1,1,2'

echo '$ test-expr '\''a && ((b >= c) || (d != e))'\'' -a 1,0,2,0,2'
test-expr 'a && ((b >= c) || (d != e))' -a 1,0,2,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= c) || (d != e))'\'' -a 1,0,2,0,2'

echo '$ test-expr '\''a && ((b >= c) || (d != e))'\'' -a 1,0,2,2,1'
test-expr 'a && ((b >= c) || (d != e))' -a 1,0,2,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= c) || (d != e))'\'' -a 1,0,2,2,1'

echo '$ test-expr '\''a && ((b >= c) || (d != e))'\'' -a 1,1,1,2,2'
test-expr 'a && ((b >= c) || (d != e))' -a 1,1,1,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= c) || (d != e))'\'' -a 1,1,1,2,2'

echo '$ test-expr '\''a && ((b >= c) || (d != e))'\'' -a 1,2,0,0,0'
test-expr 'a && ((b >= c) || (d != e))' -a 1,2,0,0,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= c) || (d != e))'\'' -a 1,2,0,0,0'

echo '$ test-expr '\''a && ((b >= c) || (d != e))'\'' -a 1,2,0,1,1'
test-expr 'a && ((b >= c) || (d != e))' -a 1,2,0,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= c) || (d != e))'\'' -a 1,2,0,1,1'

echo '$ test-expr '\''a && ((b >= c) || (d != e))'\'' -a 2,0,0,1,1'
test-expr 'a && ((b >= c) || (d != e))' -a 2,0,0,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= c) || (d != e))'\'' -a 2,0,0,1,1'

echo '$ test-expr '\''a && ((b >= c) || (d != e))'\'' -a 2,0,1,1,1'
test-expr 'a && ((b >= c) || (d != e))' -a 2,0,1,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= c) || (d != e))'\'' -a 2,0,1,1,1'

echo '$ test-expr '\''a && ((b >= c) || (d != e))'\'' -a 2,1,0,0,2'
test-expr 'a && ((b >= c) || (d != e))' -a 2,1,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= c) || (d != e))'\'' -a 2,1,0,0,2'

echo '$ test-expr '\''a && ((b >= c) || (d != e))'\'' -a 2,1,0,1,1'
test-expr 'a && ((b >= c) || (d != e))' -a 2,1,0,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= c) || (d != e))'\'' -a 2,1,0,1,1'

echo '$ test-expr '\''a && ((b >= c) || (d != e))'\'' -a 2,1,0,2,0'
test-expr 'a && ((b >= c) || (d != e))' -a 2,1,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= c) || (d != e))'\'' -a 2,1,0,2,0'

echo '$ test-expr '\''a && ((b >= c) || (d != e))'\'' -a 2,1,1,2,2'
test-expr 'a && ((b >= c) || (d != e))' -a 2,1,1,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= c) || (d != e))'\'' -a 2,1,1,2,2'

echo '$ test-expr '\''a && ((b >= c) || (d != e))'\'' -a 2,2,1,2,2'
test-expr 'a && ((b >= c) || (d != e))' -a 2,2,1,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= c) || (d != e))'\'' -a 2,2,1,2,2'

echo '$ test-expr '\''a && ((b >= c) || (d != e))'\'' -a 2,2,2,0,1'
test-expr 'a && ((b >= c) || (d != e))' -a 2,2,2,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= c) || (d != e))'\'' -a 2,2,2,0,1'

echo '$ test-expr '\''a && ((b >= c) || (d != e))'\'' -a 2,2,2,2,0'
test-expr 'a && ((b >= c) || (d != e))' -a 2,2,2,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= c) || (d != e))'\'' -a 2,2,2,2,0'

echo '$ test-expr '\''a && ((b >= c) || (d != e))'\'' -a 2,2,2,2,2'
test-expr 'a && ((b >= c) || (d != e))' -a 2,2,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= c) || (d != e))'\'' -a 2,2,2,2,2'

echo '$ test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 0,0,0,0,2'
test-expr 'a && ((b >= (c != d)) || e)' -a 0,0,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 0,0,0,0,2'

echo '$ test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 0,0,0,1,2'
test-expr 'a && ((b >= (c != d)) || e)' -a 0,0,0,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 0,0,0,1,2'

echo '$ test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 0,0,1,0,1'
test-expr 'a && ((b >= (c != d)) || e)' -a 0,0,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 0,0,1,0,1'

echo '$ test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 0,0,1,2,0'
test-expr 'a && ((b >= (c != d)) || e)' -a 0,0,1,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 0,0,1,2,0'

echo '$ test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 0,0,1,2,1'
test-expr 'a && ((b >= (c != d)) || e)' -a 0,0,1,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 0,0,1,2,1'

echo '$ test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 0,0,2,1,0'
test-expr 'a && ((b >= (c != d)) || e)' -a 0,0,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 0,0,2,1,0'

echo '$ test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 0,1,1,0,2'
test-expr 'a && ((b >= (c != d)) || e)' -a 0,1,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 0,1,1,0,2'

echo '$ test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 0,1,2,2,2'
test-expr 'a && ((b >= (c != d)) || e)' -a 0,1,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 0,1,2,2,2'

echo '$ test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 0,2,0,1,0'
test-expr 'a && ((b >= (c != d)) || e)' -a 0,2,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 0,2,0,1,0'

echo '$ test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 0,2,0,1,2'
test-expr 'a && ((b >= (c != d)) || e)' -a 0,2,0,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 0,2,0,1,2'

echo '$ test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 0,2,2,1,2'
test-expr 'a && ((b >= (c != d)) || e)' -a 0,2,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 0,2,2,1,2'

echo '$ test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 1,0,1,0,2'
test-expr 'a && ((b >= (c != d)) || e)' -a 1,0,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 1,0,1,0,2'

echo '$ test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 1,0,1,1,0'
test-expr 'a && ((b >= (c != d)) || e)' -a 1,0,1,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 1,0,1,1,0'

echo '$ test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 1,0,2,0,2'
test-expr 'a && ((b >= (c != d)) || e)' -a 1,0,2,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 1,0,2,0,2'

echo '$ test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 1,0,2,2,0'
test-expr 'a && ((b >= (c != d)) || e)' -a 1,0,2,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 1,0,2,2,0'

echo '$ test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 1,1,0,1,1'
test-expr 'a && ((b >= (c != d)) || e)' -a 1,1,0,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 1,1,0,1,1'

echo '$ test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 1,1,0,2,1'
test-expr 'a && ((b >= (c != d)) || e)' -a 1,1,0,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 1,1,0,2,1'

echo '$ test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 1,1,1,1,0'
test-expr 'a && ((b >= (c != d)) || e)' -a 1,1,1,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 1,1,1,1,0'

echo '$ test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 1,1,2,0,2'
test-expr 'a && ((b >= (c != d)) || e)' -a 1,1,2,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 1,1,2,0,2'

echo '$ test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 1,1,2,1,0'
test-expr 'a && ((b >= (c != d)) || e)' -a 1,1,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 1,1,2,1,0'

echo '$ test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 1,2,1,1,0'
test-expr 'a && ((b >= (c != d)) || e)' -a 1,2,1,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 1,2,1,1,0'

echo '$ test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 1,2,2,0,1'
test-expr 'a && ((b >= (c != d)) || e)' -a 1,2,2,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 1,2,2,0,1'

echo '$ test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 1,2,2,2,0'
test-expr 'a && ((b >= (c != d)) || e)' -a 1,2,2,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 1,2,2,2,0'

echo '$ test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 2,0,0,0,1'
test-expr 'a && ((b >= (c != d)) || e)' -a 2,0,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 2,0,0,0,1'

echo '$ test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 2,2,1,1,2'
test-expr 'a && ((b >= (c != d)) || e)' -a 2,2,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= (c != d)) || e)'\'' -a 2,2,1,1,2'

echo '$ test-expr '\''a && ((b >= (c || d)) != e)'\'' -a 0,0,0,2,0'
test-expr 'a && ((b >= (c || d)) != e)' -a 0,0,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= (c || d)) != e)'\'' -a 0,0,0,2,0'

echo '$ test-expr '\''a && ((b >= (c || d)) != e)'\'' -a 0,0,1,2,1'
test-expr 'a && ((b >= (c || d)) != e)' -a 0,0,1,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= (c || d)) != e)'\'' -a 0,0,1,2,1'

echo '$ test-expr '\''a && ((b >= (c || d)) != e)'\'' -a 0,1,0,1,2'
test-expr 'a && ((b >= (c || d)) != e)' -a 0,1,0,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= (c || d)) != e)'\'' -a 0,1,0,1,2'

echo '$ test-expr '\''a && ((b >= (c || d)) != e)'\'' -a 0,1,2,0,1'
test-expr 'a && ((b >= (c || d)) != e)' -a 0,1,2,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= (c || d)) != e)'\'' -a 0,1,2,0,1'

echo '$ test-expr '\''a && ((b >= (c || d)) != e)'\'' -a 0,1,2,0,2'
test-expr 'a && ((b >= (c || d)) != e)' -a 0,1,2,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= (c || d)) != e)'\'' -a 0,1,2,0,2'

echo '$ test-expr '\''a && ((b >= (c || d)) != e)'\'' -a 1,0,0,1,1'
test-expr 'a && ((b >= (c || d)) != e)' -a 1,0,0,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= (c || d)) != e)'\'' -a 1,0,0,1,1'

echo '$ test-expr '\''a && ((b >= (c || d)) != e)'\'' -a 1,0,0,2,1'
test-expr 'a && ((b >= (c || d)) != e)' -a 1,0,0,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= (c || d)) != e)'\'' -a 1,0,0,2,1'

echo '$ test-expr '\''a && ((b >= (c || d)) != e)'\'' -a 1,0,1,0,2'
test-expr 'a && ((b >= (c || d)) != e)' -a 1,0,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= (c || d)) != e)'\'' -a 1,0,1,0,2'

echo '$ test-expr '\''a && ((b >= (c || d)) != e)'\'' -a 1,0,2,2,0'
test-expr 'a && ((b >= (c || d)) != e)' -a 1,0,2,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= (c || d)) != e)'\'' -a 1,0,2,2,0'

echo '$ test-expr '\''a && ((b >= (c || d)) != e)'\'' -a 1,1,0,1,0'
test-expr 'a && ((b >= (c || d)) != e)' -a 1,1,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= (c || d)) != e)'\'' -a 1,1,0,1,0'

echo '$ test-expr '\''a && ((b >= (c || d)) != e)'\'' -a 1,1,0,2,0'
test-expr 'a && ((b >= (c || d)) != e)' -a 1,1,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= (c || d)) != e)'\'' -a 1,1,0,2,0'

echo '$ test-expr '\''a && ((b >= (c || d)) != e)'\'' -a 1,1,1,1,2'
test-expr 'a && ((b >= (c || d)) != e)' -a 1,1,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= (c || d)) != e)'\'' -a 1,1,1,1,2'

echo '$ test-expr '\''a && ((b >= (c || d)) != e)'\'' -a 1,2,0,1,2'
test-expr 'a && ((b >= (c || d)) != e)' -a 1,2,0,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= (c || d)) != e)'\'' -a 1,2,0,1,2'

echo '$ test-expr '\''a && ((b >= (c || d)) != e)'\'' -a 2,0,1,0,0'
test-expr 'a && ((b >= (c || d)) != e)' -a 2,0,1,0,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= (c || d)) != e)'\'' -a 2,0,1,0,0'

echo '$ test-expr '\''a && ((b >= (c || d)) != e)'\'' -a 2,0,1,1,1'
test-expr 'a && ((b >= (c || d)) != e)' -a 2,0,1,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= (c || d)) != e)'\'' -a 2,0,1,1,1'

echo '$ test-expr '\''a && ((b >= (c || d)) != e)'\'' -a 2,0,1,1,2'
test-expr 'a && ((b >= (c || d)) != e)' -a 2,0,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= (c || d)) != e)'\'' -a 2,0,1,1,2'

echo '$ test-expr '\''a && ((b >= (c || d)) != e)'\'' -a 2,0,1,2,1'
test-expr 'a && ((b >= (c || d)) != e)' -a 2,0,1,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= (c || d)) != e)'\'' -a 2,0,1,2,1'

echo '$ test-expr '\''a && ((b >= (c || d)) != e)'\'' -a 2,0,2,1,1'
test-expr 'a && ((b >= (c || d)) != e)' -a 2,0,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= (c || d)) != e)'\'' -a 2,0,2,1,1'

echo '$ test-expr '\''a && ((b >= (c || d)) != e)'\'' -a 2,1,0,1,0'
test-expr 'a && ((b >= (c || d)) != e)' -a 2,1,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= (c || d)) != e)'\'' -a 2,1,0,1,0'

echo '$ test-expr '\''a && ((b >= (c || d)) != e)'\'' -a 2,1,0,2,2'
test-expr 'a && ((b >= (c || d)) != e)' -a 2,1,0,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= (c || d)) != e)'\'' -a 2,1,0,2,2'

echo '$ test-expr '\''a && ((b >= (c || d)) != e)'\'' -a 2,2,0,1,1'
test-expr 'a && ((b >= (c || d)) != e)' -a 2,2,0,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b >= (c || d)) != e)'\'' -a 2,2,0,1,1'

echo '$ test-expr '\''a && ((b || c) != (d >= e))'\'' -a 0,0,0,1,0'
test-expr 'a && ((b || c) != (d >= e))' -a 0,0,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) != (d >= e))'\'' -a 0,0,0,1,0'

echo '$ test-expr '\''a && ((b || c) != (d >= e))'\'' -a 0,0,2,0,0'
test-expr 'a && ((b || c) != (d >= e))' -a 0,0,2,0,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) != (d >= e))'\'' -a 0,0,2,0,0'

echo '$ test-expr '\''a && ((b || c) != (d >= e))'\'' -a 0,0,2,0,1'
test-expr 'a && ((b || c) != (d >= e))' -a 0,0,2,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) != (d >= e))'\'' -a 0,0,2,0,1'

echo '$ test-expr '\''a && ((b || c) != (d >= e))'\'' -a 0,0,2,2,1'
test-expr 'a && ((b || c) != (d >= e))' -a 0,0,2,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) != (d >= e))'\'' -a 0,0,2,2,1'

echo '$ test-expr '\''a && ((b || c) != (d >= e))'\'' -a 0,1,0,0,2'
test-expr 'a && ((b || c) != (d >= e))' -a 0,1,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) != (d >= e))'\'' -a 0,1,0,0,2'

echo '$ test-expr '\''a && ((b || c) != (d >= e))'\'' -a 0,1,2,0,1'
test-expr 'a && ((b || c) != (d >= e))' -a 0,1,2,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) != (d >= e))'\'' -a 0,1,2,0,1'

echo '$ test-expr '\''a && ((b || c) != (d >= e))'\'' -a 0,1,2,1,1'
test-expr 'a && ((b || c) != (d >= e))' -a 0,1,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) != (d >= e))'\'' -a 0,1,2,1,1'

echo '$ test-expr '\''a && ((b || c) != (d >= e))'\'' -a 0,1,2,1,2'
test-expr 'a && ((b || c) != (d >= e))' -a 0,1,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) != (d >= e))'\'' -a 0,1,2,1,2'

echo '$ test-expr '\''a && ((b || c) != (d >= e))'\'' -a 0,2,0,1,1'
test-expr 'a && ((b || c) != (d >= e))' -a 0,2,0,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) != (d >= e))'\'' -a 0,2,0,1,1'

echo '$ test-expr '\''a && ((b || c) != (d >= e))'\'' -a 0,2,1,1,1'
test-expr 'a && ((b || c) != (d >= e))' -a 0,2,1,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) != (d >= e))'\'' -a 0,2,1,1,1'

echo '$ test-expr '\''a && ((b || c) != (d >= e))'\'' -a 0,2,1,1,2'
test-expr 'a && ((b || c) != (d >= e))' -a 0,2,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) != (d >= e))'\'' -a 0,2,1,1,2'

echo '$ test-expr '\''a && ((b || c) != (d >= e))'\'' -a 1,0,0,1,0'
test-expr 'a && ((b || c) != (d >= e))' -a 1,0,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) != (d >= e))'\'' -a 1,0,0,1,0'

echo '$ test-expr '\''a && ((b || c) != (d >= e))'\'' -a 1,0,1,0,1'
test-expr 'a && ((b || c) != (d >= e))' -a 1,0,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) != (d >= e))'\'' -a 1,0,1,0,1'

echo '$ test-expr '\''a && ((b || c) != (d >= e))'\'' -a 1,0,1,0,2'
test-expr 'a && ((b || c) != (d >= e))' -a 1,0,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) != (d >= e))'\'' -a 1,0,1,0,2'

echo '$ test-expr '\''a && ((b || c) != (d >= e))'\'' -a 1,0,2,0,1'
test-expr 'a && ((b || c) != (d >= e))' -a 1,0,2,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) != (d >= e))'\'' -a 1,0,2,0,1'

echo '$ test-expr '\''a && ((b || c) != (d >= e))'\'' -a 1,0,2,1,1'
test-expr 'a && ((b || c) != (d >= e))' -a 1,0,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) != (d >= e))'\'' -a 1,0,2,1,1'

echo '$ test-expr '\''a && ((b || c) != (d >= e))'\'' -a 1,0,2,1,2'
test-expr 'a && ((b || c) != (d >= e))' -a 1,0,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) != (d >= e))'\'' -a 1,0,2,1,2'

echo '$ test-expr '\''a && ((b || c) != (d >= e))'\'' -a 1,0,2,2,2'
test-expr 'a && ((b || c) != (d >= e))' -a 1,0,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) != (d >= e))'\'' -a 1,0,2,2,2'

echo '$ test-expr '\''a && ((b || c) != (d >= e))'\'' -a 1,1,0,0,2'
test-expr 'a && ((b || c) != (d >= e))' -a 1,1,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) != (d >= e))'\'' -a 1,1,0,0,2'

echo '$ test-expr '\''a && ((b || c) != (d >= e))'\'' -a 1,1,0,2,0'
test-expr 'a && ((b || c) != (d >= e))' -a 1,1,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) != (d >= e))'\'' -a 1,1,0,2,0'

echo '$ test-expr '\''a && ((b || c) != (d >= e))'\'' -a 1,1,1,0,1'
test-expr 'a && ((b || c) != (d >= e))' -a 1,1,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) != (d >= e))'\'' -a 1,1,1,0,1'

echo '$ test-expr '\''a && ((b || c) != (d >= e))'\'' -a 1,1,1,0,2'
test-expr 'a && ((b || c) != (d >= e))' -a 1,1,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) != (d >= e))'\'' -a 1,1,1,0,2'

echo '$ test-expr '\''a && ((b || c) != (d >= e))'\'' -a 1,1,1,1,1'
test-expr 'a && ((b || c) != (d >= e))' -a 1,1,1,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) != (d >= e))'\'' -a 1,1,1,1,1'

echo '$ test-expr '\''a && ((b || c) != (d >= e))'\'' -a 1,1,2,2,0'
test-expr 'a && ((b || c) != (d >= e))' -a 1,1,2,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) != (d >= e))'\'' -a 1,1,2,2,0'

echo '$ test-expr '\''a && ((b || c) != (d >= e))'\'' -a 1,2,0,2,1'
test-expr 'a && ((b || c) != (d >= e))' -a 1,2,0,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) != (d >= e))'\'' -a 1,2,0,2,1'

echo '$ test-expr '\''a && ((b || c) != (d >= e))'\'' -a 1,2,1,1,2'
test-expr 'a && ((b || c) != (d >= e))' -a 1,2,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) != (d >= e))'\'' -a 1,2,1,1,2'

echo '$ test-expr '\''a && ((b || c) != (d >= e))'\'' -a 1,2,2,2,0'
test-expr 'a && ((b || c) != (d >= e))' -a 1,2,2,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) != (d >= e))'\'' -a 1,2,2,2,0'

echo '$ test-expr '\''a && ((b || c) != (d >= e))'\'' -a 2,0,0,2,1'
test-expr 'a && ((b || c) != (d >= e))' -a 2,0,0,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) != (d >= e))'\'' -a 2,0,0,2,1'

echo '$ test-expr '\''a && ((b || c) != (d >= e))'\'' -a 2,0,1,1,2'
test-expr 'a && ((b || c) != (d >= e))' -a 2,0,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) != (d >= e))'\'' -a 2,0,1,1,2'

echo '$ test-expr '\''a && ((b || c) != (d >= e))'\'' -a 2,1,1,0,0'
test-expr 'a && ((b || c) != (d >= e))' -a 2,1,1,0,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) != (d >= e))'\'' -a 2,1,1,0,0'

echo '$ test-expr '\''a && ((b || c) != (d >= e))'\'' -a 2,1,1,0,1'
test-expr 'a && ((b || c) != (d >= e))' -a 2,1,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) != (d >= e))'\'' -a 2,1,1,0,1'

echo '$ test-expr '\''a && ((b || c) != (d >= e))'\'' -a 2,1,1,1,2'
test-expr 'a && ((b || c) != (d >= e))' -a 2,1,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) != (d >= e))'\'' -a 2,1,1,1,2'

echo '$ test-expr '\''a && ((b || c) != (d >= e))'\'' -a 2,2,0,2,1'
test-expr 'a && ((b || c) != (d >= e))' -a 2,2,0,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) != (d >= e))'\'' -a 2,2,0,2,1'

echo '$ test-expr '\''a && ((b || c) >= (d != e))'\'' -a 0,0,0,0,1'
test-expr 'a && ((b || c) >= (d != e))' -a 0,0,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) >= (d != e))'\'' -a 0,0,0,0,1'

echo '$ test-expr '\''a && ((b || c) >= (d != e))'\'' -a 0,0,0,2,2'
test-expr 'a && ((b || c) >= (d != e))' -a 0,0,0,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) >= (d != e))'\'' -a 0,0,0,2,2'

echo '$ test-expr '\''a && ((b || c) >= (d != e))'\'' -a 0,0,1,2,0'
test-expr 'a && ((b || c) >= (d != e))' -a 0,0,1,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) >= (d != e))'\'' -a 0,0,1,2,0'

echo '$ test-expr '\''a && ((b || c) >= (d != e))'\'' -a 0,0,2,1,1'
test-expr 'a && ((b || c) >= (d != e))' -a 0,0,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) >= (d != e))'\'' -a 0,0,2,1,1'

echo '$ test-expr '\''a && ((b || c) >= (d != e))'\'' -a 0,1,0,2,0'
test-expr 'a && ((b || c) >= (d != e))' -a 0,1,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) >= (d != e))'\'' -a 0,1,0,2,0'

echo '$ test-expr '\''a && ((b || c) >= (d != e))'\'' -a 0,1,1,1,0'
test-expr 'a && ((b || c) >= (d != e))' -a 0,1,1,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) >= (d != e))'\'' -a 0,1,1,1,0'

echo '$ test-expr '\''a && ((b || c) >= (d != e))'\'' -a 0,2,2,2,2'
test-expr 'a && ((b || c) >= (d != e))' -a 0,2,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) >= (d != e))'\'' -a 0,2,2,2,2'

echo '$ test-expr '\''a && ((b || c) >= (d != e))'\'' -a 1,0,0,0,0'
test-expr 'a && ((b || c) >= (d != e))' -a 1,0,0,0,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) >= (d != e))'\'' -a 1,0,0,0,0'

echo '$ test-expr '\''a && ((b || c) >= (d != e))'\'' -a 1,0,1,0,0'
test-expr 'a && ((b || c) >= (d != e))' -a 1,0,1,0,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) >= (d != e))'\'' -a 1,0,1,0,0'

echo '$ test-expr '\''a && ((b || c) >= (d != e))'\'' -a 1,0,1,0,2'
test-expr 'a && ((b || c) >= (d != e))' -a 1,0,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) >= (d != e))'\'' -a 1,0,1,0,2'

echo '$ test-expr '\''a && ((b || c) >= (d != e))'\'' -a 1,0,1,1,1'
test-expr 'a && ((b || c) >= (d != e))' -a 1,0,1,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) >= (d != e))'\'' -a 1,0,1,1,1'

echo '$ test-expr '\''a && ((b || c) >= (d != e))'\'' -a 1,0,1,2,2'
test-expr 'a && ((b || c) >= (d != e))' -a 1,0,1,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) >= (d != e))'\'' -a 1,0,1,2,2'

echo '$ test-expr '\''a && ((b || c) >= (d != e))'\'' -a 1,0,2,2,0'
test-expr 'a && ((b || c) >= (d != e))' -a 1,0,2,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) >= (d != e))'\'' -a 1,0,2,2,0'

echo '$ test-expr '\''a && ((b || c) >= (d != e))'\'' -a 1,1,0,2,0'
test-expr 'a && ((b || c) >= (d != e))' -a 1,1,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) >= (d != e))'\'' -a 1,1,0,2,0'

echo '$ test-expr '\''a && ((b || c) >= (d != e))'\'' -a 1,1,1,0,2'
test-expr 'a && ((b || c) >= (d != e))' -a 1,1,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) >= (d != e))'\'' -a 1,1,1,0,2'

echo '$ test-expr '\''a && ((b || c) >= (d != e))'\'' -a 1,1,1,2,0'
test-expr 'a && ((b || c) >= (d != e))' -a 1,1,1,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) >= (d != e))'\'' -a 1,1,1,2,0'

echo '$ test-expr '\''a && ((b || c) >= (d != e))'\'' -a 1,1,2,1,2'
test-expr 'a && ((b || c) >= (d != e))' -a 1,1,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) >= (d != e))'\'' -a 1,1,2,1,2'

echo '$ test-expr '\''a && ((b || c) >= (d != e))'\'' -a 1,2,0,1,1'
test-expr 'a && ((b || c) >= (d != e))' -a 1,2,0,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) >= (d != e))'\'' -a 1,2,0,1,1'

echo '$ test-expr '\''a && ((b || c) >= (d != e))'\'' -a 1,2,2,0,2'
test-expr 'a && ((b || c) >= (d != e))' -a 1,2,2,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) >= (d != e))'\'' -a 1,2,2,0,2'

echo '$ test-expr '\''a && ((b || c) >= (d != e))'\'' -a 2,0,0,0,2'
test-expr 'a && ((b || c) >= (d != e))' -a 2,0,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) >= (d != e))'\'' -a 2,0,0,0,2'

echo '$ test-expr '\''a && ((b || c) >= (d != e))'\'' -a 2,0,0,1,2'
test-expr 'a && ((b || c) >= (d != e))' -a 2,0,0,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) >= (d != e))'\'' -a 2,0,0,1,2'

echo '$ test-expr '\''a && ((b || c) >= (d != e))'\'' -a 2,0,2,1,2'
test-expr 'a && ((b || c) >= (d != e))' -a 2,0,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) >= (d != e))'\'' -a 2,0,2,1,2'

echo '$ test-expr '\''a && ((b || c) >= (d != e))'\'' -a 2,0,2,2,2'
test-expr 'a && ((b || c) >= (d != e))' -a 2,0,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) >= (d != e))'\'' -a 2,0,2,2,2'

echo '$ test-expr '\''a && ((b || c) >= (d != e))'\'' -a 2,1,0,0,0'
test-expr 'a && ((b || c) >= (d != e))' -a 2,1,0,0,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) >= (d != e))'\'' -a 2,1,0,0,0'

echo '$ test-expr '\''a && ((b || c) >= (d != e))'\'' -a 2,1,0,1,0'
test-expr 'a && ((b || c) >= (d != e))' -a 2,1,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) >= (d != e))'\'' -a 2,1,0,1,0'

echo '$ test-expr '\''a && ((b || c) >= (d != e))'\'' -a 2,1,1,1,0'
test-expr 'a && ((b || c) >= (d != e))' -a 2,1,1,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) >= (d != e))'\'' -a 2,1,1,1,0'

echo '$ test-expr '\''a && ((b || c) >= (d != e))'\'' -a 2,1,2,0,0'
test-expr 'a && ((b || c) >= (d != e))' -a 2,1,2,0,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) >= (d != e))'\'' -a 2,1,2,0,0'

echo '$ test-expr '\''a && ((b || c) >= (d != e))'\'' -a 2,1,2,1,0'
test-expr 'a && ((b || c) >= (d != e))' -a 2,1,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) >= (d != e))'\'' -a 2,1,2,1,0'

echo '$ test-expr '\''a && ((b || c) >= (d != e))'\'' -a 2,2,0,0,1'
test-expr 'a && ((b || c) >= (d != e))' -a 2,2,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) >= (d != e))'\'' -a 2,2,0,0,1'

echo '$ test-expr '\''a && ((b || c) >= (d != e))'\'' -a 2,2,2,1,0'
test-expr 'a && ((b || c) >= (d != e))' -a 2,2,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) >= (d != e))'\'' -a 2,2,2,1,0'

echo '$ test-expr '\''a && ((b || c) >= (d != e))'\'' -a 2,2,2,2,1'
test-expr 'a && ((b || c) >= (d != e))' -a 2,2,2,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || c) >= (d != e))'\'' -a 2,2,2,2,1'

echo '$ test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 0,0,0,0,1'
test-expr 'a && ((b || (c != d)) >= e)' -a 0,0,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 0,0,0,0,1'

echo '$ test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 0,0,2,0,0'
test-expr 'a && ((b || (c != d)) >= e)' -a 0,0,2,0,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 0,0,2,0,0'

echo '$ test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 0,0,2,1,2'
test-expr 'a && ((b || (c != d)) >= e)' -a 0,0,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 0,0,2,1,2'

echo '$ test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 0,2,0,1,2'
test-expr 'a && ((b || (c != d)) >= e)' -a 0,2,0,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 0,2,0,1,2'

echo '$ test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 0,2,1,1,1'
test-expr 'a && ((b || (c != d)) >= e)' -a 0,2,1,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 0,2,1,1,1'

echo '$ test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 0,2,2,1,0'
test-expr 'a && ((b || (c != d)) >= e)' -a 0,2,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 0,2,2,1,0'

echo '$ test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 1,0,1,2,0'
test-expr 'a && ((b || (c != d)) >= e)' -a 1,0,1,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 1,0,1,2,0'

echo '$ test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 1,0,2,2,0'
test-expr 'a && ((b || (c != d)) >= e)' -a 1,0,2,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 1,0,2,2,0'

echo '$ test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 1,1,1,0,1'
test-expr 'a && ((b || (c != d)) >= e)' -a 1,1,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 1,1,1,0,1'

echo '$ test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 1,1,2,1,0'
test-expr 'a && ((b || (c != d)) >= e)' -a 1,1,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 1,1,2,1,0'

echo '$ test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 1,1,2,1,1'
test-expr 'a && ((b || (c != d)) >= e)' -a 1,1,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 1,1,2,1,1'

echo '$ test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 1,1,2,2,2'
test-expr 'a && ((b || (c != d)) >= e)' -a 1,1,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 1,1,2,2,2'

echo '$ test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 1,2,0,2,0'
test-expr 'a && ((b || (c != d)) >= e)' -a 1,2,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 1,2,0,2,0'

echo '$ test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 1,2,2,0,1'
test-expr 'a && ((b || (c != d)) >= e)' -a 1,2,2,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 1,2,2,0,1'

echo '$ test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 1,2,2,0,2'
test-expr 'a && ((b || (c != d)) >= e)' -a 1,2,2,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 1,2,2,0,2'

echo '$ test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 2,0,0,1,0'
test-expr 'a && ((b || (c != d)) >= e)' -a 2,0,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 2,0,0,1,0'

echo '$ test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 2,0,0,2,0'
test-expr 'a && ((b || (c != d)) >= e)' -a 2,0,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 2,0,0,2,0'

echo '$ test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 2,0,0,2,1'
test-expr 'a && ((b || (c != d)) >= e)' -a 2,0,0,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 2,0,0,2,1'

echo '$ test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 2,0,1,2,0'
test-expr 'a && ((b || (c != d)) >= e)' -a 2,0,1,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 2,0,1,2,0'

echo '$ test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 2,0,2,1,1'
test-expr 'a && ((b || (c != d)) >= e)' -a 2,0,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 2,0,2,1,1'

echo '$ test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 2,1,0,0,1'
test-expr 'a && ((b || (c != d)) >= e)' -a 2,1,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 2,1,0,0,1'

echo '$ test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 2,1,1,2,0'
test-expr 'a && ((b || (c != d)) >= e)' -a 2,1,1,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 2,1,1,2,0'

echo '$ test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 2,1,2,1,0'
test-expr 'a && ((b || (c != d)) >= e)' -a 2,1,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 2,1,2,1,0'

echo '$ test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 2,2,0,1,1'
test-expr 'a && ((b || (c != d)) >= e)' -a 2,2,0,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 2,2,0,1,1'

echo '$ test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 2,2,1,0,1'
test-expr 'a && ((b || (c != d)) >= e)' -a 2,2,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 2,2,1,0,1'

echo '$ test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 2,2,1,2,1'
test-expr 'a && ((b || (c != d)) >= e)' -a 2,2,1,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || (c != d)) >= e)'\'' -a 2,2,1,2,1'

echo '$ test-expr '\''a && ((b || (c >= d)) != e)'\'' -a 0,0,1,1,2'
test-expr 'a && ((b || (c >= d)) != e)' -a 0,0,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || (c >= d)) != e)'\'' -a 0,0,1,1,2'

echo '$ test-expr '\''a && ((b || (c >= d)) != e)'\'' -a 0,0,1,2,2'
test-expr 'a && ((b || (c >= d)) != e)' -a 0,0,1,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || (c >= d)) != e)'\'' -a 0,0,1,2,2'

echo '$ test-expr '\''a && ((b || (c >= d)) != e)'\'' -a 0,0,2,1,2'
test-expr 'a && ((b || (c >= d)) != e)' -a 0,0,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || (c >= d)) != e)'\'' -a 0,0,2,1,2'

echo '$ test-expr '\''a && ((b || (c >= d)) != e)'\'' -a 0,1,0,1,1'
test-expr 'a && ((b || (c >= d)) != e)' -a 0,1,0,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || (c >= d)) != e)'\'' -a 0,1,0,1,1'

echo '$ test-expr '\''a && ((b || (c >= d)) != e)'\'' -a 0,1,0,2,0'
test-expr 'a && ((b || (c >= d)) != e)' -a 0,1,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || (c >= d)) != e)'\'' -a 0,1,0,2,0'

echo '$ test-expr '\''a && ((b || (c >= d)) != e)'\'' -a 0,1,1,0,2'
test-expr 'a && ((b || (c >= d)) != e)' -a 0,1,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || (c >= d)) != e)'\'' -a 0,1,1,0,2'

echo '$ test-expr '\''a && ((b || (c >= d)) != e)'\'' -a 0,1,1,2,2'
test-expr 'a && ((b || (c >= d)) != e)' -a 0,1,1,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || (c >= d)) != e)'\'' -a 0,1,1,2,2'

echo '$ test-expr '\''a && ((b || (c >= d)) != e)'\'' -a 0,1,2,0,0'
test-expr 'a && ((b || (c >= d)) != e)' -a 0,1,2,0,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || (c >= d)) != e)'\'' -a 0,1,2,0,0'

echo '$ test-expr '\''a && ((b || (c >= d)) != e)'\'' -a 0,2,0,1,2'
test-expr 'a && ((b || (c >= d)) != e)' -a 0,2,0,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || (c >= d)) != e)'\'' -a 0,2,0,1,2'

echo '$ test-expr '\''a && ((b || (c >= d)) != e)'\'' -a 0,2,2,0,1'
test-expr 'a && ((b || (c >= d)) != e)' -a 0,2,2,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || (c >= d)) != e)'\'' -a 0,2,2,0,1'

echo '$ test-expr '\''a && ((b || (c >= d)) != e)'\'' -a 0,2,2,2,0'
test-expr 'a && ((b || (c >= d)) != e)' -a 0,2,2,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || (c >= d)) != e)'\'' -a 0,2,2,2,0'

echo '$ test-expr '\''a && ((b || (c >= d)) != e)'\'' -a 1,0,0,0,0'
test-expr 'a && ((b || (c >= d)) != e)' -a 1,0,0,0,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || (c >= d)) != e)'\'' -a 1,0,0,0,0'

echo '$ test-expr '\''a && ((b || (c >= d)) != e)'\'' -a 1,0,0,2,2'
test-expr 'a && ((b || (c >= d)) != e)' -a 1,0,0,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || (c >= d)) != e)'\'' -a 1,0,0,2,2'

echo '$ test-expr '\''a && ((b || (c >= d)) != e)'\'' -a 1,1,0,1,1'
test-expr 'a && ((b || (c >= d)) != e)' -a 1,1,0,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || (c >= d)) != e)'\'' -a 1,1,0,1,1'

echo '$ test-expr '\''a && ((b || (c >= d)) != e)'\'' -a 1,1,1,2,0'
test-expr 'a && ((b || (c >= d)) != e)' -a 1,1,1,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || (c >= d)) != e)'\'' -a 1,1,1,2,0'

echo '$ test-expr '\''a && ((b || (c >= d)) != e)'\'' -a 1,2,0,0,0'
test-expr 'a && ((b || (c >= d)) != e)' -a 1,2,0,0,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || (c >= d)) != e)'\'' -a 1,2,0,0,0'

echo '$ test-expr '\''a && ((b || (c >= d)) != e)'\'' -a 1,2,1,1,2'
test-expr 'a && ((b || (c >= d)) != e)' -a 1,2,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || (c >= d)) != e)'\'' -a 1,2,1,1,2'

echo '$ test-expr '\''a && ((b || (c >= d)) != e)'\'' -a 1,2,2,1,0'
test-expr 'a && ((b || (c >= d)) != e)' -a 1,2,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || (c >= d)) != e)'\'' -a 1,2,2,1,0'

echo '$ test-expr '\''a && ((b || (c >= d)) != e)'\'' -a 2,0,0,1,2'
test-expr 'a && ((b || (c >= d)) != e)' -a 2,0,0,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || (c >= d)) != e)'\'' -a 2,0,0,1,2'

echo '$ test-expr '\''a && ((b || (c >= d)) != e)'\'' -a 2,1,1,1,0'
test-expr 'a && ((b || (c >= d)) != e)' -a 2,1,1,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || (c >= d)) != e)'\'' -a 2,1,1,1,0'

echo '$ test-expr '\''a && ((b || (c >= d)) != e)'\'' -a 2,1,2,1,2'
test-expr 'a && ((b || (c >= d)) != e)' -a 2,1,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || (c >= d)) != e)'\'' -a 2,1,2,1,2'

echo '$ test-expr '\''a && ((b || (c >= d)) != e)'\'' -a 2,1,2,2,1'
test-expr 'a && ((b || (c >= d)) != e)' -a 2,1,2,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || (c >= d)) != e)'\'' -a 2,1,2,2,1'

echo '$ test-expr '\''a && ((b || (c >= d)) != e)'\'' -a 2,2,0,1,2'
test-expr 'a && ((b || (c >= d)) != e)' -a 2,2,0,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && ((b || (c >= d)) != e)'\'' -a 2,2,0,1,2'

echo '$ test-expr '\''a && (((b != c) >= d) || e)'\'' -a 0,0,0,2,2'
test-expr 'a && (((b != c) >= d) || e)' -a 0,0,0,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (((b != c) >= d) || e)'\'' -a 0,0,0,2,2'

echo '$ test-expr '\''a && (((b != c) >= d) || e)'\'' -a 0,0,1,1,1'
test-expr 'a && (((b != c) >= d) || e)' -a 0,0,1,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && (((b != c) >= d) || e)'\'' -a 0,0,1,1,1'

echo '$ test-expr '\''a && (((b != c) >= d) || e)'\'' -a 0,0,2,1,0'
test-expr 'a && (((b != c) >= d) || e)' -a 0,0,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && (((b != c) >= d) || e)'\'' -a 0,0,2,1,0'

echo '$ test-expr '\''a && (((b != c) >= d) || e)'\'' -a 0,1,0,0,2'
test-expr 'a && (((b != c) >= d) || e)' -a 0,1,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && (((b != c) >= d) || e)'\'' -a 0,1,0,0,2'

echo '$ test-expr '\''a && (((b != c) >= d) || e)'\'' -a 0,1,1,1,2'
test-expr 'a && (((b != c) >= d) || e)' -a 0,1,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && (((b != c) >= d) || e)'\'' -a 0,1,1,1,2'

echo '$ test-expr '\''a && (((b != c) >= d) || e)'\'' -a 0,1,1,2,0'
test-expr 'a && (((b != c) >= d) || e)' -a 0,1,1,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && (((b != c) >= d) || e)'\'' -a 0,1,1,2,0'

echo '$ test-expr '\''a && (((b != c) >= d) || e)'\'' -a 0,2,0,2,2'
test-expr 'a && (((b != c) >= d) || e)' -a 0,2,0,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (((b != c) >= d) || e)'\'' -a 0,2,0,2,2'

echo '$ test-expr '\''a && (((b != c) >= d) || e)'\'' -a 0,2,1,1,0'
test-expr 'a && (((b != c) >= d) || e)' -a 0,2,1,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && (((b != c) >= d) || e)'\'' -a 0,2,1,1,0'

echo '$ test-expr '\''a && (((b != c) >= d) || e)'\'' -a 0,2,1,2,2'
test-expr 'a && (((b != c) >= d) || e)' -a 0,2,1,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (((b != c) >= d) || e)'\'' -a 0,2,1,2,2'

echo '$ test-expr '\''a && (((b != c) >= d) || e)'\'' -a 1,0,2,2,0'
test-expr 'a && (((b != c) >= d) || e)' -a 1,0,2,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && (((b != c) >= d) || e)'\'' -a 1,0,2,2,0'

echo '$ test-expr '\''a && (((b != c) >= d) || e)'\'' -a 1,0,2,2,2'
test-expr 'a && (((b != c) >= d) || e)' -a 1,0,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (((b != c) >= d) || e)'\'' -a 1,0,2,2,2'

echo '$ test-expr '\''a && (((b != c) >= d) || e)'\'' -a 1,1,2,1,2'
test-expr 'a && (((b != c) >= d) || e)' -a 1,1,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && (((b != c) >= d) || e)'\'' -a 1,1,2,1,2'

echo '$ test-expr '\''a && (((b != c) >= d) || e)'\'' -a 1,2,0,2,2'
test-expr 'a && (((b != c) >= d) || e)' -a 1,2,0,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (((b != c) >= d) || e)'\'' -a 1,2,0,2,2'

echo '$ test-expr '\''a && (((b != c) >= d) || e)'\'' -a 1,2,1,1,0'
test-expr 'a && (((b != c) >= d) || e)' -a 1,2,1,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && (((b != c) >= d) || e)'\'' -a 1,2,1,1,0'

echo '$ test-expr '\''a && (((b != c) >= d) || e)'\'' -a 1,2,1,1,2'
test-expr 'a && (((b != c) >= d) || e)' -a 1,2,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && (((b != c) >= d) || e)'\'' -a 1,2,1,1,2'

echo '$ test-expr '\''a && (((b != c) >= d) || e)'\'' -a 1,2,1,2,2'
test-expr 'a && (((b != c) >= d) || e)' -a 1,2,1,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (((b != c) >= d) || e)'\'' -a 1,2,1,2,2'

echo '$ test-expr '\''a && (((b != c) >= d) || e)'\'' -a 1,2,2,0,0'
test-expr 'a && (((b != c) >= d) || e)' -a 1,2,2,0,0 2>&1 ||
echo 'command failed: test-expr '\''a && (((b != c) >= d) || e)'\'' -a 1,2,2,0,0'

echo '$ test-expr '\''a && (((b != c) >= d) || e)'\'' -a 2,0,0,0,1'
test-expr 'a && (((b != c) >= d) || e)' -a 2,0,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && (((b != c) >= d) || e)'\'' -a 2,0,0,0,1'

echo '$ test-expr '\''a && (((b != c) >= d) || e)'\'' -a 2,0,0,1,0'
test-expr 'a && (((b != c) >= d) || e)' -a 2,0,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && (((b != c) >= d) || e)'\'' -a 2,0,0,1,0'

echo '$ test-expr '\''a && (((b != c) >= d) || e)'\'' -a 2,0,0,1,2'
test-expr 'a && (((b != c) >= d) || e)' -a 2,0,0,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && (((b != c) >= d) || e)'\'' -a 2,0,0,1,2'

echo '$ test-expr '\''a && (((b != c) >= d) || e)'\'' -a 2,0,0,2,0'
test-expr 'a && (((b != c) >= d) || e)' -a 2,0,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && (((b != c) >= d) || e)'\'' -a 2,0,0,2,0'

echo '$ test-expr '\''a && (((b != c) >= d) || e)'\'' -a 2,0,0,2,2'
test-expr 'a && (((b != c) >= d) || e)' -a 2,0,0,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (((b != c) >= d) || e)'\'' -a 2,0,0,2,2'

echo '$ test-expr '\''a && (((b != c) >= d) || e)'\'' -a 2,0,1,0,2'
test-expr 'a && (((b != c) >= d) || e)' -a 2,0,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && (((b != c) >= d) || e)'\'' -a 2,0,1,0,2'

echo '$ test-expr '\''a && (((b != c) >= d) || e)'\'' -a 2,0,1,1,2'
test-expr 'a && (((b != c) >= d) || e)' -a 2,0,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && (((b != c) >= d) || e)'\'' -a 2,0,1,1,2'

echo '$ test-expr '\''a && (((b != c) >= d) || e)'\'' -a 2,0,2,2,2'
test-expr 'a && (((b != c) >= d) || e)' -a 2,0,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (((b != c) >= d) || e)'\'' -a 2,0,2,2,2'

echo '$ test-expr '\''a && (((b != c) >= d) || e)'\'' -a 2,1,0,1,0'
test-expr 'a && (((b != c) >= d) || e)' -a 2,1,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && (((b != c) >= d) || e)'\'' -a 2,1,0,1,0'

echo '$ test-expr '\''a && (((b != c) >= d) || e)'\'' -a 2,1,2,0,1'
test-expr 'a && (((b != c) >= d) || e)' -a 2,1,2,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && (((b != c) >= d) || e)'\'' -a 2,1,2,0,1'

echo '$ test-expr '\''a && (((b != c) >= d) || e)'\'' -a 2,2,0,0,1'
test-expr 'a && (((b != c) >= d) || e)' -a 2,2,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && (((b != c) >= d) || e)'\'' -a 2,2,0,0,1'

echo '$ test-expr '\''a && (((b != c) >= d) || e)'\'' -a 2,2,0,2,2'
test-expr 'a && (((b != c) >= d) || e)' -a 2,2,0,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (((b != c) >= d) || e)'\'' -a 2,2,0,2,2'

echo '$ test-expr '\''a && (((b != c) >= d) || e)'\'' -a 2,2,1,0,2'
test-expr 'a && (((b != c) >= d) || e)' -a 2,2,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && (((b != c) >= d) || e)'\'' -a 2,2,1,0,2'

echo '$ test-expr '\''a && (((b != c) >= d) || e)'\'' -a 2,2,1,2,0'
test-expr 'a && (((b != c) >= d) || e)' -a 2,2,1,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && (((b != c) >= d) || e)'\'' -a 2,2,1,2,0'

echo '$ test-expr '\''a && (((b != c) >= d) || e)'\'' -a 2,2,2,1,0'
test-expr 'a && (((b != c) >= d) || e)' -a 2,2,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && (((b != c) >= d) || e)'\'' -a 2,2,2,1,0'

echo '$ test-expr '\''a && (((b != c) || d) >= e)'\'' -a 0,0,0,2,0'
test-expr 'a && (((b != c) || d) >= e)' -a 0,0,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && (((b != c) || d) >= e)'\'' -a 0,0,0,2,0'

echo '$ test-expr '\''a && (((b != c) || d) >= e)'\'' -a 0,0,1,1,1'
test-expr 'a && (((b != c) || d) >= e)' -a 0,0,1,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && (((b != c) || d) >= e)'\'' -a 0,0,1,1,1'

echo '$ test-expr '\''a && (((b != c) || d) >= e)'\'' -a 0,0,1,1,2'
test-expr 'a && (((b != c) || d) >= e)' -a 0,0,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && (((b != c) || d) >= e)'\'' -a 0,0,1,1,2'

echo '$ test-expr '\''a && (((b != c) || d) >= e)'\'' -a 0,0,2,2,2'
test-expr 'a && (((b != c) || d) >= e)' -a 0,0,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (((b != c) || d) >= e)'\'' -a 0,0,2,2,2'

echo '$ test-expr '\''a && (((b != c) || d) >= e)'\'' -a 0,1,0,0,0'
test-expr 'a && (((b != c) || d) >= e)' -a 0,1,0,0,0 2>&1 ||
echo 'command failed: test-expr '\''a && (((b != c) || d) >= e)'\'' -a 0,1,0,0,0'

echo '$ test-expr '\''a && (((b != c) || d) >= e)'\'' -a 0,1,0,1,2'
test-expr 'a && (((b != c) || d) >= e)' -a 0,1,0,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && (((b != c) || d) >= e)'\'' -a 0,1,0,1,2'

echo '$ test-expr '\''a && (((b != c) || d) >= e)'\'' -a 0,1,1,2,0'
test-expr 'a && (((b != c) || d) >= e)' -a 0,1,1,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && (((b != c) || d) >= e)'\'' -a 0,1,1,2,0'

echo '$ test-expr '\''a && (((b != c) || d) >= e)'\'' -a 0,1,1,2,1'
test-expr 'a && (((b != c) || d) >= e)' -a 0,1,1,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && (((b != c) || d) >= e)'\'' -a 0,1,1,2,1'

echo '$ test-expr '\''a && (((b != c) || d) >= e)'\'' -a 0,2,0,1,1'
test-expr 'a && (((b != c) || d) >= e)' -a 0,2,0,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && (((b != c) || d) >= e)'\'' -a 0,2,0,1,1'

echo '$ test-expr '\''a && (((b != c) || d) >= e)'\'' -a 0,2,0,2,2'
test-expr 'a && (((b != c) || d) >= e)' -a 0,2,0,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (((b != c) || d) >= e)'\'' -a 0,2,0,2,2'

echo '$ test-expr '\''a && (((b != c) || d) >= e)'\'' -a 0,2,1,2,1'
test-expr 'a && (((b != c) || d) >= e)' -a 0,2,1,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && (((b != c) || d) >= e)'\'' -a 0,2,1,2,1'

echo '$ test-expr '\''a && (((b != c) || d) >= e)'\'' -a 1,0,2,0,1'
test-expr 'a && (((b != c) || d) >= e)' -a 1,0,2,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && (((b != c) || d) >= e)'\'' -a 1,0,2,0,1'

echo '$ test-expr '\''a && (((b != c) || d) >= e)'\'' -a 1,0,2,1,1'
test-expr 'a && (((b != c) || d) >= e)' -a 1,0,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && (((b != c) || d) >= e)'\'' -a 1,0,2,1,1'

echo '$ test-expr '\''a && (((b != c) || d) >= e)'\'' -a 1,0,2,1,2'
test-expr 'a && (((b != c) || d) >= e)' -a 1,0,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && (((b != c) || d) >= e)'\'' -a 1,0,2,1,2'

echo '$ test-expr '\''a && (((b != c) || d) >= e)'\'' -a 1,1,0,2,1'
test-expr 'a && (((b != c) || d) >= e)' -a 1,1,0,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && (((b != c) || d) >= e)'\'' -a 1,1,0,2,1'

echo '$ test-expr '\''a && (((b != c) || d) >= e)'\'' -a 1,1,1,0,1'
test-expr 'a && (((b != c) || d) >= e)' -a 1,1,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && (((b != c) || d) >= e)'\'' -a 1,1,1,0,1'

echo '$ test-expr '\''a && (((b != c) || d) >= e)'\'' -a 1,1,1,2,0'
test-expr 'a && (((b != c) || d) >= e)' -a 1,1,1,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && (((b != c) || d) >= e)'\'' -a 1,1,1,2,0'

echo '$ test-expr '\''a && (((b != c) || d) >= e)'\'' -a 1,1,2,0,0'
test-expr 'a && (((b != c) || d) >= e)' -a 1,1,2,0,0 2>&1 ||
echo 'command failed: test-expr '\''a && (((b != c) || d) >= e)'\'' -a 1,1,2,0,0'

echo '$ test-expr '\''a && (((b != c) || d) >= e)'\'' -a 1,1,2,1,1'
test-expr 'a && (((b != c) || d) >= e)' -a 1,1,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && (((b != c) || d) >= e)'\'' -a 1,1,2,1,1'

echo '$ test-expr '\''a && (((b != c) || d) >= e)'\'' -a 1,2,0,1,2'
test-expr 'a && (((b != c) || d) >= e)' -a 1,2,0,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && (((b != c) || d) >= e)'\'' -a 1,2,0,1,2'

echo '$ test-expr '\''a && (((b != c) || d) >= e)'\'' -a 1,2,0,2,1'
test-expr 'a && (((b != c) || d) >= e)' -a 1,2,0,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && (((b != c) || d) >= e)'\'' -a 1,2,0,2,1'

echo '$ test-expr '\''a && (((b != c) || d) >= e)'\'' -a 1,2,0,2,2'
test-expr 'a && (((b != c) || d) >= e)' -a 1,2,0,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (((b != c) || d) >= e)'\'' -a 1,2,0,2,2'

echo '$ test-expr '\''a && (((b != c) || d) >= e)'\'' -a 2,0,0,1,0'
test-expr 'a && (((b != c) || d) >= e)' -a 2,0,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && (((b != c) || d) >= e)'\'' -a 2,0,0,1,0'

echo '$ test-expr '\''a && (((b != c) || d) >= e)'\'' -a 2,1,0,0,2'
test-expr 'a && (((b != c) || d) >= e)' -a 2,1,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && (((b != c) || d) >= e)'\'' -a 2,1,0,0,2'

echo '$ test-expr '\''a && (((b != c) || d) >= e)'\'' -a 2,1,0,2,2'
test-expr 'a && (((b != c) || d) >= e)' -a 2,1,0,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (((b != c) || d) >= e)'\'' -a 2,1,0,2,2'

echo '$ test-expr '\''a && (((b != c) || d) >= e)'\'' -a 2,1,1,2,0'
test-expr 'a && (((b != c) || d) >= e)' -a 2,1,1,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && (((b != c) || d) >= e)'\'' -a 2,1,1,2,0'

echo '$ test-expr '\''a && (((b != c) || d) >= e)'\'' -a 2,2,0,2,2'
test-expr 'a && (((b != c) || d) >= e)' -a 2,2,0,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (((b != c) || d) >= e)'\'' -a 2,2,0,2,2'

echo '$ test-expr '\''a && (((b != c) || d) >= e)'\'' -a 2,2,1,1,1'
test-expr 'a && (((b != c) || d) >= e)' -a 2,2,1,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && (((b != c) || d) >= e)'\'' -a 2,2,1,1,1'

echo '$ test-expr '\''a && (((b != c) || d) >= e)'\'' -a 2,2,1,2,1'
test-expr 'a && (((b != c) || d) >= e)' -a 2,2,1,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && (((b != c) || d) >= e)'\'' -a 2,2,1,2,1'

echo '$ test-expr '\''a && (((b != c) || d) >= e)'\'' -a 2,2,2,0,2'
test-expr 'a && (((b != c) || d) >= e)' -a 2,2,2,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && (((b != c) || d) >= e)'\'' -a 2,2,2,0,2'

echo '$ test-expr '\''a && (((b >= c) != d) || e)'\'' -a 0,0,0,0,0'
test-expr 'a && (((b >= c) != d) || e)' -a 0,0,0,0,0 2>&1 ||
echo 'command failed: test-expr '\''a && (((b >= c) != d) || e)'\'' -a 0,0,0,0,0'

echo '$ test-expr '\''a && (((b >= c) != d) || e)'\'' -a 0,1,1,2,1'
test-expr 'a && (((b >= c) != d) || e)' -a 0,1,1,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && (((b >= c) != d) || e)'\'' -a 0,1,1,2,1'

echo '$ test-expr '\''a && (((b >= c) != d) || e)'\'' -a 0,1,2,2,0'
test-expr 'a && (((b >= c) != d) || e)' -a 0,1,2,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && (((b >= c) != d) || e)'\'' -a 0,1,2,2,0'

echo '$ test-expr '\''a && (((b >= c) != d) || e)'\'' -a 0,2,0,0,1'
test-expr 'a && (((b >= c) != d) || e)' -a 0,2,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && (((b >= c) != d) || e)'\'' -a 0,2,0,0,1'

echo '$ test-expr '\''a && (((b >= c) != d) || e)'\'' -a 0,2,2,0,0'
test-expr 'a && (((b >= c) != d) || e)' -a 0,2,2,0,0 2>&1 ||
echo 'command failed: test-expr '\''a && (((b >= c) != d) || e)'\'' -a 0,2,2,0,0'

echo '$ test-expr '\''a && (((b >= c) != d) || e)'\'' -a 0,2,2,0,1'
test-expr 'a && (((b >= c) != d) || e)' -a 0,2,2,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && (((b >= c) != d) || e)'\'' -a 0,2,2,0,1'

echo '$ test-expr '\''a && (((b >= c) != d) || e)'\'' -a 0,2,2,0,2'
test-expr 'a && (((b >= c) != d) || e)' -a 0,2,2,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && (((b >= c) != d) || e)'\'' -a 0,2,2,0,2'

echo '$ test-expr '\''a && (((b >= c) != d) || e)'\'' -a 1,0,1,0,1'
test-expr 'a && (((b >= c) != d) || e)' -a 1,0,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && (((b >= c) != d) || e)'\'' -a 1,0,1,0,1'

echo '$ test-expr '\''a && (((b >= c) != d) || e)'\'' -a 1,0,2,1,0'
test-expr 'a && (((b >= c) != d) || e)' -a 1,0,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && (((b >= c) != d) || e)'\'' -a 1,0,2,1,0'

echo '$ test-expr '\''a && (((b >= c) != d) || e)'\'' -a 1,0,2,2,1'
test-expr 'a && (((b >= c) != d) || e)' -a 1,0,2,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && (((b >= c) != d) || e)'\'' -a 1,0,2,2,1'

echo '$ test-expr '\''a && (((b >= c) != d) || e)'\'' -a 1,1,2,1,2'
test-expr 'a && (((b >= c) != d) || e)' -a 1,1,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && (((b >= c) != d) || e)'\'' -a 1,1,2,1,2'

echo '$ test-expr '\''a && (((b >= c) != d) || e)'\'' -a 1,2,0,2,2'
test-expr 'a && (((b >= c) != d) || e)' -a 1,2,0,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (((b >= c) != d) || e)'\'' -a 1,2,0,2,2'

echo '$ test-expr '\''a && (((b >= c) != d) || e)'\'' -a 1,2,2,1,2'
test-expr 'a && (((b >= c) != d) || e)' -a 1,2,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && (((b >= c) != d) || e)'\'' -a 1,2,2,1,2'

echo '$ test-expr '\''a && (((b >= c) != d) || e)'\'' -a 1,2,2,2,2'
test-expr 'a && (((b >= c) != d) || e)' -a 1,2,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (((b >= c) != d) || e)'\'' -a 1,2,2,2,2'

echo '$ test-expr '\''a && (((b >= c) != d) || e)'\'' -a 2,0,0,0,0'
test-expr 'a && (((b >= c) != d) || e)' -a 2,0,0,0,0 2>&1 ||
echo 'command failed: test-expr '\''a && (((b >= c) != d) || e)'\'' -a 2,0,0,0,0'

echo '$ test-expr '\''a && (((b >= c) != d) || e)'\'' -a 2,0,0,0,1'
test-expr 'a && (((b >= c) != d) || e)' -a 2,0,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && (((b >= c) != d) || e)'\'' -a 2,0,0,0,1'

echo '$ test-expr '\''a && (((b >= c) != d) || e)'\'' -a 2,0,0,0,2'
test-expr 'a && (((b >= c) != d) || e)' -a 2,0,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && (((b >= c) != d) || e)'\'' -a 2,0,0,0,2'

echo '$ test-expr '\''a && (((b >= c) != d) || e)'\'' -a 2,0,0,2,2'
test-expr 'a && (((b >= c) != d) || e)' -a 2,0,0,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (((b >= c) != d) || e)'\'' -a 2,0,0,2,2'

echo '$ test-expr '\''a && (((b >= c) != d) || e)'\'' -a 2,0,2,1,0'
test-expr 'a && (((b >= c) != d) || e)' -a 2,0,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && (((b >= c) != d) || e)'\'' -a 2,0,2,1,0'

echo '$ test-expr '\''a && (((b >= c) != d) || e)'\'' -a 2,0,2,2,2'
test-expr 'a && (((b >= c) != d) || e)' -a 2,0,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (((b >= c) != d) || e)'\'' -a 2,0,2,2,2'

echo '$ test-expr '\''a && (((b >= c) != d) || e)'\'' -a 2,1,1,1,1'
test-expr 'a && (((b >= c) != d) || e)' -a 2,1,1,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && (((b >= c) != d) || e)'\'' -a 2,1,1,1,1'

echo '$ test-expr '\''a && (((b >= c) != d) || e)'\'' -a 2,1,2,0,0'
test-expr 'a && (((b >= c) != d) || e)' -a 2,1,2,0,0 2>&1 ||
echo 'command failed: test-expr '\''a && (((b >= c) != d) || e)'\'' -a 2,1,2,0,0'

echo '$ test-expr '\''a && (((b >= c) != d) || e)'\'' -a 2,2,0,1,0'
test-expr 'a && (((b >= c) != d) || e)' -a 2,2,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && (((b >= c) != d) || e)'\'' -a 2,2,0,1,0'

echo '$ test-expr '\''a && (((b >= c) != d) || e)'\'' -a 2,2,0,2,1'
test-expr 'a && (((b >= c) != d) || e)' -a 2,2,0,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && (((b >= c) != d) || e)'\'' -a 2,2,0,2,1'

echo '$ test-expr '\''a && (((b >= c) != d) || e)'\'' -a 2,2,1,1,2'
test-expr 'a && (((b >= c) != d) || e)' -a 2,2,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && (((b >= c) != d) || e)'\'' -a 2,2,1,1,2'

echo '$ test-expr '\''a && (((b >= c) != d) || e)'\'' -a 2,2,2,2,1'
test-expr 'a && (((b >= c) != d) || e)' -a 2,2,2,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && (((b >= c) != d) || e)'\'' -a 2,2,2,2,1'

echo '$ test-expr '\''a && (((b >= c) || d) != e)'\'' -a 0,0,0,2,1'
test-expr 'a && (((b >= c) || d) != e)' -a 0,0,0,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && (((b >= c) || d) != e)'\'' -a 0,0,0,2,1'

echo '$ test-expr '\''a && (((b >= c) || d) != e)'\'' -a 0,0,2,1,1'
test-expr 'a && (((b >= c) || d) != e)' -a 0,0,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && (((b >= c) || d) != e)'\'' -a 0,0,2,1,1'

echo '$ test-expr '\''a && (((b >= c) || d) != e)'\'' -a 0,1,2,0,1'
test-expr 'a && (((b >= c) || d) != e)' -a 0,1,2,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && (((b >= c) || d) != e)'\'' -a 0,1,2,0,1'

echo '$ test-expr '\''a && (((b >= c) || d) != e)'\'' -a 0,2,2,1,0'
test-expr 'a && (((b >= c) || d) != e)' -a 0,2,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && (((b >= c) || d) != e)'\'' -a 0,2,2,1,0'

echo '$ test-expr '\''a && (((b >= c) || d) != e)'\'' -a 1,0,0,0,1'
test-expr 'a && (((b >= c) || d) != e)' -a 1,0,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && (((b >= c) || d) != e)'\'' -a 1,0,0,0,1'

echo '$ test-expr '\''a && (((b >= c) || d) != e)'\'' -a 1,0,1,0,2'
test-expr 'a && (((b >= c) || d) != e)' -a 1,0,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && (((b >= c) || d) != e)'\'' -a 1,0,1,0,2'

echo '$ test-expr '\''a && (((b >= c) || d) != e)'\'' -a 1,0,2,1,0'
test-expr 'a && (((b >= c) || d) != e)' -a 1,0,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && (((b >= c) || d) != e)'\'' -a 1,0,2,1,0'

echo '$ test-expr '\''a && (((b >= c) || d) != e)'\'' -a 1,0,2,1,1'
test-expr 'a && (((b >= c) || d) != e)' -a 1,0,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && (((b >= c) || d) != e)'\'' -a 1,0,2,1,1'

echo '$ test-expr '\''a && (((b >= c) || d) != e)'\'' -a 1,0,2,2,2'
test-expr 'a && (((b >= c) || d) != e)' -a 1,0,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (((b >= c) || d) != e)'\'' -a 1,0,2,2,2'

echo '$ test-expr '\''a && (((b >= c) || d) != e)'\'' -a 1,1,2,1,1'
test-expr 'a && (((b >= c) || d) != e)' -a 1,1,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && (((b >= c) || d) != e)'\'' -a 1,1,2,1,1'

echo '$ test-expr '\''a && (((b >= c) || d) != e)'\'' -a 1,2,0,2,1'
test-expr 'a && (((b >= c) || d) != e)' -a 1,2,0,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && (((b >= c) || d) != e)'\'' -a 1,2,0,2,1'

echo '$ test-expr '\''a && (((b >= c) || d) != e)'\'' -a 1,2,2,1,2'
test-expr 'a && (((b >= c) || d) != e)' -a 1,2,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && (((b >= c) || d) != e)'\'' -a 1,2,2,1,2'

echo '$ test-expr '\''a && (((b >= c) || d) != e)'\'' -a 2,0,0,0,1'
test-expr 'a && (((b >= c) || d) != e)' -a 2,0,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && (((b >= c) || d) != e)'\'' -a 2,0,0,0,1'

echo '$ test-expr '\''a && (((b >= c) || d) != e)'\'' -a 2,0,0,0,2'
test-expr 'a && (((b >= c) || d) != e)' -a 2,0,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && (((b >= c) || d) != e)'\'' -a 2,0,0,0,2'

echo '$ test-expr '\''a && (((b >= c) || d) != e)'\'' -a 2,0,0,2,1'
test-expr 'a && (((b >= c) || d) != e)' -a 2,0,0,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && (((b >= c) || d) != e)'\'' -a 2,0,0,2,1'

echo '$ test-expr '\''a && (((b >= c) || d) != e)'\'' -a 2,0,2,1,0'
test-expr 'a && (((b >= c) || d) != e)' -a 2,0,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && (((b >= c) || d) != e)'\'' -a 2,0,2,1,0'

echo '$ test-expr '\''a && (((b >= c) || d) != e)'\'' -a 2,0,2,2,2'
test-expr 'a && (((b >= c) || d) != e)' -a 2,0,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (((b >= c) || d) != e)'\'' -a 2,0,2,2,2'

echo '$ test-expr '\''a && (((b >= c) || d) != e)'\'' -a 2,1,0,1,0'
test-expr 'a && (((b >= c) || d) != e)' -a 2,1,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && (((b >= c) || d) != e)'\'' -a 2,1,0,1,0'

echo '$ test-expr '\''a && (((b >= c) || d) != e)'\'' -a 2,1,0,1,2'
test-expr 'a && (((b >= c) || d) != e)' -a 2,1,0,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && (((b >= c) || d) != e)'\'' -a 2,1,0,1,2'

echo '$ test-expr '\''a && (((b >= c) || d) != e)'\'' -a 2,1,0,2,0'
test-expr 'a && (((b >= c) || d) != e)' -a 2,1,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && (((b >= c) || d) != e)'\'' -a 2,1,0,2,0'

echo '$ test-expr '\''a && (((b >= c) || d) != e)'\'' -a 2,1,1,1,1'
test-expr 'a && (((b >= c) || d) != e)' -a 2,1,1,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && (((b >= c) || d) != e)'\'' -a 2,1,1,1,1'

echo '$ test-expr '\''a && (((b >= c) || d) != e)'\'' -a 2,1,2,2,0'
test-expr 'a && (((b >= c) || d) != e)' -a 2,1,2,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && (((b >= c) || d) != e)'\'' -a 2,1,2,2,0'

echo '$ test-expr '\''a && (((b >= c) || d) != e)'\'' -a 2,1,2,2,1'
test-expr 'a && (((b >= c) || d) != e)' -a 2,1,2,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && (((b >= c) || d) != e)'\'' -a 2,1,2,2,1'

echo '$ test-expr '\''a && (((b >= c) || d) != e)'\'' -a 2,1,2,2,2'
test-expr 'a && (((b >= c) || d) != e)' -a 2,1,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (((b >= c) || d) != e)'\'' -a 2,1,2,2,2'

echo '$ test-expr '\''a && (((b >= c) || d) != e)'\'' -a 2,2,0,1,2'
test-expr 'a && (((b >= c) || d) != e)' -a 2,2,0,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && (((b >= c) || d) != e)'\'' -a 2,2,0,1,2'

echo '$ test-expr '\''a && (((b >= c) || d) != e)'\'' -a 2,2,1,1,1'
test-expr 'a && (((b >= c) || d) != e)' -a 2,2,1,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && (((b >= c) || d) != e)'\'' -a 2,2,1,1,1'

echo '$ test-expr '\''a && (((b || c) != d) >= e)'\'' -a 0,0,1,1,1'
test-expr 'a && (((b || c) != d) >= e)' -a 0,0,1,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && (((b || c) != d) >= e)'\'' -a 0,0,1,1,1'

echo '$ test-expr '\''a && (((b || c) != d) >= e)'\'' -a 0,0,1,2,1'
test-expr 'a && (((b || c) != d) >= e)' -a 0,0,1,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && (((b || c) != d) >= e)'\'' -a 0,0,1,2,1'

echo '$ test-expr '\''a && (((b || c) != d) >= e)'\'' -a 0,0,1,2,2'
test-expr 'a && (((b || c) != d) >= e)' -a 0,0,1,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (((b || c) != d) >= e)'\'' -a 0,0,1,2,2'

echo '$ test-expr '\''a && (((b || c) != d) >= e)'\'' -a 0,0,2,2,0'
test-expr 'a && (((b || c) != d) >= e)' -a 0,0,2,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && (((b || c) != d) >= e)'\'' -a 0,0,2,2,0'

echo '$ test-expr '\''a && (((b || c) != d) >= e)'\'' -a 0,1,0,0,1'
test-expr 'a && (((b || c) != d) >= e)' -a 0,1,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && (((b || c) != d) >= e)'\'' -a 0,1,0,0,1'

echo '$ test-expr '\''a && (((b || c) != d) >= e)'\'' -a 0,1,1,0,1'
test-expr 'a && (((b || c) != d) >= e)' -a 0,1,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && (((b || c) != d) >= e)'\'' -a 0,1,1,0,1'

echo '$ test-expr '\''a && (((b || c) != d) >= e)'\'' -a 0,2,1,0,2'
test-expr 'a && (((b || c) != d) >= e)' -a 0,2,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && (((b || c) != d) >= e)'\'' -a 0,2,1,0,2'

echo '$ test-expr '\''a && (((b || c) != d) >= e)'\'' -a 0,2,1,1,0'
test-expr 'a && (((b || c) != d) >= e)' -a 0,2,1,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && (((b || c) != d) >= e)'\'' -a 0,2,1,1,0'

echo '$ test-expr '\''a && (((b || c) != d) >= e)'\'' -a 0,2,1,1,2'
test-expr 'a && (((b || c) != d) >= e)' -a 0,2,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && (((b || c) != d) >= e)'\'' -a 0,2,1,1,2'

echo '$ test-expr '\''a && (((b || c) != d) >= e)'\'' -a 0,2,1,2,0'
test-expr 'a && (((b || c) != d) >= e)' -a 0,2,1,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && (((b || c) != d) >= e)'\'' -a 0,2,1,2,0'

echo '$ test-expr '\''a && (((b || c) != d) >= e)'\'' -a 0,2,2,0,1'
test-expr 'a && (((b || c) != d) >= e)' -a 0,2,2,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && (((b || c) != d) >= e)'\'' -a 0,2,2,0,1'

echo '$ test-expr '\''a && (((b || c) != d) >= e)'\'' -a 1,0,1,0,2'
test-expr 'a && (((b || c) != d) >= e)' -a 1,0,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && (((b || c) != d) >= e)'\'' -a 1,0,1,0,2'

echo '$ test-expr '\''a && (((b || c) != d) >= e)'\'' -a 1,0,1,1,2'
test-expr 'a && (((b || c) != d) >= e)' -a 1,0,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && (((b || c) != d) >= e)'\'' -a 1,0,1,1,2'

echo '$ test-expr '\''a && (((b || c) != d) >= e)'\'' -a 1,0,2,0,2'
test-expr 'a && (((b || c) != d) >= e)' -a 1,0,2,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && (((b || c) != d) >= e)'\'' -a 1,0,2,0,2'

echo '$ test-expr '\''a && (((b || c) != d) >= e)'\'' -a 1,1,1,1,0'
test-expr 'a && (((b || c) != d) >= e)' -a 1,1,1,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && (((b || c) != d) >= e)'\'' -a 1,1,1,1,0'

echo '$ test-expr '\''a && (((b || c) != d) >= e)'\'' -a 1,1,1,1,2'
test-expr 'a && (((b || c) != d) >= e)' -a 1,1,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && (((b || c) != d) >= e)'\'' -a 1,1,1,1,2'

echo '$ test-expr '\''a && (((b || c) != d) >= e)'\'' -a 1,2,0,1,0'
test-expr 'a && (((b || c) != d) >= e)' -a 1,2,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && (((b || c) != d) >= e)'\'' -a 1,2,0,1,0'

echo '$ test-expr '\''a && (((b || c) != d) >= e)'\'' -a 1,2,0,2,0'
test-expr 'a && (((b || c) != d) >= e)' -a 1,2,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && (((b || c) != d) >= e)'\'' -a 1,2,0,2,0'

echo '$ test-expr '\''a && (((b || c) != d) >= e)'\'' -a 1,2,1,0,0'
test-expr 'a && (((b || c) != d) >= e)' -a 1,2,1,0,0 2>&1 ||
echo 'command failed: test-expr '\''a && (((b || c) != d) >= e)'\'' -a 1,2,1,0,0'

echo '$ test-expr '\''a && (((b || c) != d) >= e)'\'' -a 1,2,2,0,0'
test-expr 'a && (((b || c) != d) >= e)' -a 1,2,2,0,0 2>&1 ||
echo 'command failed: test-expr '\''a && (((b || c) != d) >= e)'\'' -a 1,2,2,0,0'

echo '$ test-expr '\''a && (((b || c) != d) >= e)'\'' -a 1,2,2,1,1'
test-expr 'a && (((b || c) != d) >= e)' -a 1,2,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && (((b || c) != d) >= e)'\'' -a 1,2,2,1,1'

echo '$ test-expr '\''a && (((b || c) != d) >= e)'\'' -a 2,0,0,0,1'
test-expr 'a && (((b || c) != d) >= e)' -a 2,0,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && (((b || c) != d) >= e)'\'' -a 2,0,0,0,1'

echo '$ test-expr '\''a && (((b || c) != d) >= e)'\'' -a 2,0,0,2,1'
test-expr 'a && (((b || c) != d) >= e)' -a 2,0,0,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && (((b || c) != d) >= e)'\'' -a 2,0,0,2,1'

echo '$ test-expr '\''a && (((b || c) != d) >= e)'\'' -a 2,0,1,0,2'
test-expr 'a && (((b || c) != d) >= e)' -a 2,0,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && (((b || c) != d) >= e)'\'' -a 2,0,1,0,2'

echo '$ test-expr '\''a && (((b || c) != d) >= e)'\'' -a 2,0,1,2,1'
test-expr 'a && (((b || c) != d) >= e)' -a 2,0,1,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && (((b || c) != d) >= e)'\'' -a 2,0,1,2,1'

echo '$ test-expr '\''a && (((b || c) != d) >= e)'\'' -a 2,1,0,1,2'
test-expr 'a && (((b || c) != d) >= e)' -a 2,1,0,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && (((b || c) != d) >= e)'\'' -a 2,1,0,1,2'

echo '$ test-expr '\''a && (((b || c) != d) >= e)'\'' -a 2,1,1,1,2'
test-expr 'a && (((b || c) != d) >= e)' -a 2,1,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && (((b || c) != d) >= e)'\'' -a 2,1,1,1,2'

echo '$ test-expr '\''a && (((b || c) != d) >= e)'\'' -a 2,1,1,2,2'
test-expr 'a && (((b || c) != d) >= e)' -a 2,1,1,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (((b || c) != d) >= e)'\'' -a 2,1,1,2,2'

echo '$ test-expr '\''a && (((b || c) != d) >= e)'\'' -a 2,1,2,2,0'
test-expr 'a && (((b || c) != d) >= e)' -a 2,1,2,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && (((b || c) != d) >= e)'\'' -a 2,1,2,2,0'

echo '$ test-expr '\''a && (((b || c) != d) >= e)'\'' -a 2,2,1,1,0'
test-expr 'a && (((b || c) != d) >= e)' -a 2,2,1,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && (((b || c) != d) >= e)'\'' -a 2,2,1,1,0'

echo '$ test-expr '\''a && (((b || c) != d) >= e)'\'' -a 2,2,1,2,2'
test-expr 'a && (((b || c) != d) >= e)' -a 2,2,1,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (((b || c) != d) >= e)'\'' -a 2,2,1,2,2'

echo '$ test-expr '\''a && (((b || c) >= d) != e)'\'' -a 0,0,0,2,2'
test-expr 'a && (((b || c) >= d) != e)' -a 0,0,0,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (((b || c) >= d) != e)'\'' -a 0,0,0,2,2'

echo '$ test-expr '\''a && (((b || c) >= d) != e)'\'' -a 0,0,2,0,2'
test-expr 'a && (((b || c) >= d) != e)' -a 0,0,2,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && (((b || c) >= d) != e)'\'' -a 0,0,2,0,2'

echo '$ test-expr '\''a && (((b || c) >= d) != e)'\'' -a 0,1,2,0,2'
test-expr 'a && (((b || c) >= d) != e)' -a 0,1,2,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && (((b || c) >= d) != e)'\'' -a 0,1,2,0,2'

echo '$ test-expr '\''a && (((b || c) >= d) != e)'\'' -a 0,2,1,1,2'
test-expr 'a && (((b || c) >= d) != e)' -a 0,2,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && (((b || c) >= d) != e)'\'' -a 0,2,1,1,2'

echo '$ test-expr '\''a && (((b || c) >= d) != e)'\'' -a 0,2,1,2,2'
test-expr 'a && (((b || c) >= d) != e)' -a 0,2,1,2,2 2>&1 ||
echo 'command failed: test-expr '\''a && (((b || c) >= d) != e)'\'' -a 0,2,1,2,2'

echo '$ test-expr '\''a && (((b || c) >= d) != e)'\'' -a 0,2,2,1,0'
test-expr 'a && (((b || c) >= d) != e)' -a 0,2,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && (((b || c) >= d) != e)'\'' -a 0,2,2,1,0'

echo '$ test-expr '\''a && (((b || c) >= d) != e)'\'' -a 1,0,0,1,2'
test-expr 'a && (((b || c) >= d) != e)' -a 1,0,0,1,2 2>&1 ||
echo 'command failed: test-expr '\''a && (((b || c) >= d) != e)'\'' -a 1,0,0,1,2'

echo '$ test-expr '\''a && (((b || c) >= d) != e)'\'' -a 1,0,1,0,1'
test-expr 'a && (((b || c) >= d) != e)' -a 1,0,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && (((b || c) >= d) != e)'\'' -a 1,0,1,0,1'

echo '$ test-expr '\''a && (((b || c) >= d) != e)'\'' -a 1,0,2,1,0'
test-expr 'a && (((b || c) >= d) != e)' -a 1,0,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && (((b || c) >= d) != e)'\'' -a 1,0,2,1,0'

echo '$ test-expr '\''a && (((b || c) >= d) != e)'\'' -a 1,0,2,1,1'
test-expr 'a && (((b || c) >= d) != e)' -a 1,0,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && (((b || c) >= d) != e)'\'' -a 1,0,2,1,1'

echo '$ test-expr '\''a && (((b || c) >= d) != e)'\'' -a 1,1,0,0,2'
test-expr 'a && (((b || c) >= d) != e)' -a 1,1,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && (((b || c) >= d) != e)'\'' -a 1,1,0,0,2'

echo '$ test-expr '\''a && (((b || c) >= d) != e)'\'' -a 1,1,0,1,0'
test-expr 'a && (((b || c) >= d) != e)' -a 1,1,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && (((b || c) >= d) != e)'\'' -a 1,1,0,1,0'

echo '$ test-expr '\''a && (((b || c) >= d) != e)'\'' -a 1,1,0,2,1'
test-expr 'a && (((b || c) >= d) != e)' -a 1,1,0,2,1 2>&1 ||
echo 'command failed: test-expr '\''a && (((b || c) >= d) != e)'\'' -a 1,1,0,2,1'

echo '$ test-expr '\''a && (((b || c) >= d) != e)'\'' -a 1,1,1,0,1'
test-expr 'a && (((b || c) >= d) != e)' -a 1,1,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && (((b || c) >= d) != e)'\'' -a 1,1,1,0,1'

echo '$ test-expr '\''a && (((b || c) >= d) != e)'\'' -a 1,1,2,0,1'
test-expr 'a && (((b || c) >= d) != e)' -a 1,1,2,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && (((b || c) >= d) != e)'\'' -a 1,1,2,0,1'

echo '$ test-expr '\''a && (((b || c) >= d) != e)'\'' -a 1,1,2,0,2'
test-expr 'a && (((b || c) >= d) != e)' -a 1,1,2,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && (((b || c) >= d) != e)'\'' -a 1,1,2,0,2'

echo '$ test-expr '\''a && (((b || c) >= d) != e)'\'' -a 1,1,2,1,1'
test-expr 'a && (((b || c) >= d) != e)' -a 1,1,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a && (((b || c) >= d) != e)'\'' -a 1,1,2,1,1'

echo '$ test-expr '\''a && (((b || c) >= d) != e)'\'' -a 1,1,2,2,0'
test-expr 'a && (((b || c) >= d) != e)' -a 1,1,2,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && (((b || c) >= d) != e)'\'' -a 1,1,2,2,0'

echo '$ test-expr '\''a && (((b || c) >= d) != e)'\'' -a 1,2,0,0,2'
test-expr 'a && (((b || c) >= d) != e)' -a 1,2,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && (((b || c) >= d) != e)'\'' -a 1,2,0,0,2'

echo '$ test-expr '\''a && (((b || c) >= d) != e)'\'' -a 1,2,1,2,0'
test-expr 'a && (((b || c) >= d) != e)' -a 1,2,1,2,0 2>&1 ||
echo 'command failed: test-expr '\''a && (((b || c) >= d) != e)'\'' -a 1,2,1,2,0'

echo '$ test-expr '\''a && (((b || c) >= d) != e)'\'' -a 2,0,1,0,1'
test-expr 'a && (((b || c) >= d) != e)' -a 2,0,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && (((b || c) >= d) != e)'\'' -a 2,0,1,0,1'

echo '$ test-expr '\''a && (((b || c) >= d) != e)'\'' -a 2,0,1,0,2'
test-expr 'a && (((b || c) >= d) != e)' -a 2,0,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && (((b || c) >= d) != e)'\'' -a 2,0,1,0,2'

echo '$ test-expr '\''a && (((b || c) >= d) != e)'\'' -a 2,0,2,0,0'
test-expr 'a && (((b || c) >= d) != e)' -a 2,0,2,0,0 2>&1 ||
echo 'command failed: test-expr '\''a && (((b || c) >= d) != e)'\'' -a 2,0,2,0,0'

echo '$ test-expr '\''a && (((b || c) >= d) != e)'\'' -a 2,1,2,0,2'
test-expr 'a && (((b || c) >= d) != e)' -a 2,1,2,0,2 2>&1 ||
echo 'command failed: test-expr '\''a && (((b || c) >= d) != e)'\'' -a 2,1,2,0,2'

echo '$ test-expr '\''a && (((b || c) >= d) != e)'\'' -a 2,2,1,0,1'
test-expr 'a && (((b || c) >= d) != e)' -a 2,2,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a && (((b || c) >= d) != e)'\'' -a 2,2,1,0,1'

echo '$ test-expr '\''a && (((b || c) >= d) != e)'\'' -a 2,2,2,1,0'
test-expr 'a && (((b || c) >= d) != e)' -a 2,2,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a && (((b || c) >= d) != e)'\'' -a 2,2,2,1,0'

echo '$ test-expr '\''a >= (b != (c && (d || e)))'\'' -a 0,0,0,0,0'
test-expr 'a >= (b != (c && (d || e)))' -a 0,0,0,0,0 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (c && (d || e)))'\'' -a 0,0,0,0,0'

echo '$ test-expr '\''a >= (b != (c && (d || e)))'\'' -a 0,0,0,2,1'
test-expr 'a >= (b != (c && (d || e)))' -a 0,0,0,2,1 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (c && (d || e)))'\'' -a 0,0,0,2,1'

echo '$ test-expr '\''a >= (b != (c && (d || e)))'\'' -a 0,0,2,1,0'
test-expr 'a >= (b != (c && (d || e)))' -a 0,0,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (c && (d || e)))'\'' -a 0,0,2,1,0'

echo '$ test-expr '\''a >= (b != (c && (d || e)))'\'' -a 0,0,2,1,1'
test-expr 'a >= (b != (c && (d || e)))' -a 0,0,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (c && (d || e)))'\'' -a 0,0,2,1,1'

echo '$ test-expr '\''a >= (b != (c && (d || e)))'\'' -a 0,1,2,0,1'
test-expr 'a >= (b != (c && (d || e)))' -a 0,1,2,0,1 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (c && (d || e)))'\'' -a 0,1,2,0,1'

echo '$ test-expr '\''a >= (b != (c && (d || e)))'\'' -a 0,2,0,0,2'
test-expr 'a >= (b != (c && (d || e)))' -a 0,2,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (c && (d || e)))'\'' -a 0,2,0,0,2'

echo '$ test-expr '\''a >= (b != (c && (d || e)))'\'' -a 0,2,0,2,1'
test-expr 'a >= (b != (c && (d || e)))' -a 0,2,0,2,1 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (c && (d || e)))'\'' -a 0,2,0,2,1'

echo '$ test-expr '\''a >= (b != (c && (d || e)))'\'' -a 0,2,1,0,2'
test-expr 'a >= (b != (c && (d || e)))' -a 0,2,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (c && (d || e)))'\'' -a 0,2,1,0,2'

echo '$ test-expr '\''a >= (b != (c && (d || e)))'\'' -a 0,2,1,2,1'
test-expr 'a >= (b != (c && (d || e)))' -a 0,2,1,2,1 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (c && (d || e)))'\'' -a 0,2,1,2,1'

echo '$ test-expr '\''a >= (b != (c && (d || e)))'\'' -a 0,2,2,1,0'
test-expr 'a >= (b != (c && (d || e)))' -a 0,2,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (c && (d || e)))'\'' -a 0,2,2,1,0'

echo '$ test-expr '\''a >= (b != (c && (d || e)))'\'' -a 1,0,0,0,0'
test-expr 'a >= (b != (c && (d || e)))' -a 1,0,0,0,0 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (c && (d || e)))'\'' -a 1,0,0,0,0'

echo '$ test-expr '\''a >= (b != (c && (d || e)))'\'' -a 1,0,1,0,2'
test-expr 'a >= (b != (c && (d || e)))' -a 1,0,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (c && (d || e)))'\'' -a 1,0,1,0,2'

echo '$ test-expr '\''a >= (b != (c && (d || e)))'\'' -a 1,0,1,1,1'
test-expr 'a >= (b != (c && (d || e)))' -a 1,0,1,1,1 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (c && (d || e)))'\'' -a 1,0,1,1,1'

echo '$ test-expr '\''a >= (b != (c && (d || e)))'\'' -a 1,0,1,2,2'
test-expr 'a >= (b != (c && (d || e)))' -a 1,0,1,2,2 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (c && (d || e)))'\'' -a 1,0,1,2,2'

echo '$ test-expr '\''a >= (b != (c && (d || e)))'\'' -a 1,0,2,0,0'
test-expr 'a >= (b != (c && (d || e)))' -a 1,0,2,0,0 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (c && (d || e)))'\'' -a 1,0,2,0,0'

echo '$ test-expr '\''a >= (b != (c && (d || e)))'\'' -a 1,0,2,1,0'
test-expr 'a >= (b != (c && (d || e)))' -a 1,0,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (c && (d || e)))'\'' -a 1,0,2,1,0'

echo '$ test-expr '\''a >= (b != (c && (d || e)))'\'' -a 1,0,2,1,1'
test-expr 'a >= (b != (c && (d || e)))' -a 1,0,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (c && (d || e)))'\'' -a 1,0,2,1,1'

echo '$ test-expr '\''a >= (b != (c && (d || e)))'\'' -a 1,1,1,0,1'
test-expr 'a >= (b != (c && (d || e)))' -a 1,1,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (c && (d || e)))'\'' -a 1,1,1,0,1'

echo '$ test-expr '\''a >= (b != (c && (d || e)))'\'' -a 1,1,1,1,0'
test-expr 'a >= (b != (c && (d || e)))' -a 1,1,1,1,0 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (c && (d || e)))'\'' -a 1,1,1,1,0'

echo '$ test-expr '\''a >= (b != (c && (d || e)))'\'' -a 1,1,1,2,0'
test-expr 'a >= (b != (c && (d || e)))' -a 1,1,1,2,0 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (c && (d || e)))'\'' -a 1,1,1,2,0'

echo '$ test-expr '\''a >= (b != (c && (d || e)))'\'' -a 1,2,0,0,2'
test-expr 'a >= (b != (c && (d || e)))' -a 1,2,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (c && (d || e)))'\'' -a 1,2,0,0,2'

echo '$ test-expr '\''a >= (b != (c && (d || e)))'\'' -a 1,2,0,1,1'
test-expr 'a >= (b != (c && (d || e)))' -a 1,2,0,1,1 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (c && (d || e)))'\'' -a 1,2,0,1,1'

echo '$ test-expr '\''a >= (b != (c && (d || e)))'\'' -a 1,2,1,0,2'
test-expr 'a >= (b != (c && (d || e)))' -a 1,2,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (c && (d || e)))'\'' -a 1,2,1,0,2'

echo '$ test-expr '\''a >= (b != (c && (d || e)))'\'' -a 1,2,1,2,2'
test-expr 'a >= (b != (c && (d || e)))' -a 1,2,1,2,2 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (c && (d || e)))'\'' -a 1,2,1,2,2'

echo '$ test-expr '\''a >= (b != (c && (d || e)))'\'' -a 1,2,2,2,1'
test-expr 'a >= (b != (c && (d || e)))' -a 1,2,2,2,1 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (c && (d || e)))'\'' -a 1,2,2,2,1'

echo '$ test-expr '\''a >= (b != (c && (d || e)))'\'' -a 2,0,2,1,0'
test-expr 'a >= (b != (c && (d || e)))' -a 2,0,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (c && (d || e)))'\'' -a 2,0,2,1,0'

echo '$ test-expr '\''a >= (b != (c && (d || e)))'\'' -a 2,1,0,2,1'
test-expr 'a >= (b != (c && (d || e)))' -a 2,1,0,2,1 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (c && (d || e)))'\'' -a 2,1,0,2,1'

echo '$ test-expr '\''a >= (b != (c && (d || e)))'\'' -a 2,1,1,2,0'
test-expr 'a >= (b != (c && (d || e)))' -a 2,1,1,2,0 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (c && (d || e)))'\'' -a 2,1,1,2,0'

echo '$ test-expr '\''a >= (b != (c && (d || e)))'\'' -a 2,1,1,2,2'
test-expr 'a >= (b != (c && (d || e)))' -a 2,1,1,2,2 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (c && (d || e)))'\'' -a 2,1,1,2,2'

echo '$ test-expr '\''a >= (b != (c && (d || e)))'\'' -a 2,2,0,0,0'
test-expr 'a >= (b != (c && (d || e)))' -a 2,2,0,0,0 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (c && (d || e)))'\'' -a 2,2,0,0,0'

echo '$ test-expr '\''a >= (b != (c || (d && e)))'\'' -a 0,0,0,2,0'
test-expr 'a >= (b != (c || (d && e)))' -a 0,0,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (c || (d && e)))'\'' -a 0,0,0,2,0'

echo '$ test-expr '\''a >= (b != (c || (d && e)))'\'' -a 0,0,1,0,2'
test-expr 'a >= (b != (c || (d && e)))' -a 0,0,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (c || (d && e)))'\'' -a 0,0,1,0,2'

echo '$ test-expr '\''a >= (b != (c || (d && e)))'\'' -a 0,0,1,1,2'
test-expr 'a >= (b != (c || (d && e)))' -a 0,0,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (c || (d && e)))'\'' -a 0,0,1,1,2'

echo '$ test-expr '\''a >= (b != (c || (d && e)))'\'' -a 0,0,1,2,0'
test-expr 'a >= (b != (c || (d && e)))' -a 0,0,1,2,0 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (c || (d && e)))'\'' -a 0,0,1,2,0'

echo '$ test-expr '\''a >= (b != (c || (d && e)))'\'' -a 0,0,2,1,1'
test-expr 'a >= (b != (c || (d && e)))' -a 0,0,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (c || (d && e)))'\'' -a 0,0,2,1,1'

echo '$ test-expr '\''a >= (b != (c || (d && e)))'\'' -a 0,1,0,0,2'
test-expr 'a >= (b != (c || (d && e)))' -a 0,1,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (c || (d && e)))'\'' -a 0,1,0,0,2'

echo '$ test-expr '\''a >= (b != (c || (d && e)))'\'' -a 0,1,0,2,1'
test-expr 'a >= (b != (c || (d && e)))' -a 0,1,0,2,1 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (c || (d && e)))'\'' -a 0,1,0,2,1'

echo '$ test-expr '\''a >= (b != (c || (d && e)))'\'' -a 0,1,1,1,1'
test-expr 'a >= (b != (c || (d && e)))' -a 0,1,1,1,1 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (c || (d && e)))'\'' -a 0,1,1,1,1'

echo '$ test-expr '\''a >= (b != (c || (d && e)))'\'' -a 0,1,1,2,0'
test-expr 'a >= (b != (c || (d && e)))' -a 0,1,1,2,0 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (c || (d && e)))'\'' -a 0,1,1,2,0'

echo '$ test-expr '\''a >= (b != (c || (d && e)))'\'' -a 0,1,2,0,2'
test-expr 'a >= (b != (c || (d && e)))' -a 0,1,2,0,2 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (c || (d && e)))'\'' -a 0,1,2,0,2'

echo '$ test-expr '\''a >= (b != (c || (d && e)))'\'' -a 0,1,2,1,0'
test-expr 'a >= (b != (c || (d && e)))' -a 0,1,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (c || (d && e)))'\'' -a 0,1,2,1,0'

echo '$ test-expr '\''a >= (b != (c || (d && e)))'\'' -a 0,1,2,2,0'
test-expr 'a >= (b != (c || (d && e)))' -a 0,1,2,2,0 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (c || (d && e)))'\'' -a 0,1,2,2,0'

echo '$ test-expr '\''a >= (b != (c || (d && e)))'\'' -a 0,2,0,2,0'
test-expr 'a >= (b != (c || (d && e)))' -a 0,2,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (c || (d && e)))'\'' -a 0,2,0,2,0'

echo '$ test-expr '\''a >= (b != (c || (d && e)))'\'' -a 0,2,1,0,1'
test-expr 'a >= (b != (c || (d && e)))' -a 0,2,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (c || (d && e)))'\'' -a 0,2,1,0,1'

echo '$ test-expr '\''a >= (b != (c || (d && e)))'\'' -a 0,2,1,2,0'
test-expr 'a >= (b != (c || (d && e)))' -a 0,2,1,2,0 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (c || (d && e)))'\'' -a 0,2,1,2,0'

echo '$ test-expr '\''a >= (b != (c || (d && e)))'\'' -a 0,2,2,1,1'
test-expr 'a >= (b != (c || (d && e)))' -a 0,2,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (c || (d && e)))'\'' -a 0,2,2,1,1'

echo '$ test-expr '\''a >= (b != (c || (d && e)))'\'' -a 1,0,1,1,0'
test-expr 'a >= (b != (c || (d && e)))' -a 1,0,1,1,0 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (c || (d && e)))'\'' -a 1,0,1,1,0'

echo '$ test-expr '\''a >= (b != (c || (d && e)))'\'' -a 1,0,1,2,2'
test-expr 'a >= (b != (c || (d && e)))' -a 1,0,1,2,2 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (c || (d && e)))'\'' -a 1,0,1,2,2'

echo '$ test-expr '\''a >= (b != (c || (d && e)))'\'' -a 1,0,2,2,1'
test-expr 'a >= (b != (c || (d && e)))' -a 1,0,2,2,1 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (c || (d && e)))'\'' -a 1,0,2,2,1'

echo '$ test-expr '\''a >= (b != (c || (d && e)))'\'' -a 1,2,0,0,1'
test-expr 'a >= (b != (c || (d && e)))' -a 1,2,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (c || (d && e)))'\'' -a 1,2,0,0,1'

echo '$ test-expr '\''a >= (b != (c || (d && e)))'\'' -a 1,2,0,1,0'
test-expr 'a >= (b != (c || (d && e)))' -a 1,2,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (c || (d && e)))'\'' -a 1,2,0,1,0'

echo '$ test-expr '\''a >= (b != (c || (d && e)))'\'' -a 1,2,0,2,0'
test-expr 'a >= (b != (c || (d && e)))' -a 1,2,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (c || (d && e)))'\'' -a 1,2,0,2,0'

echo '$ test-expr '\''a >= (b != (c || (d && e)))'\'' -a 1,2,1,1,2'
test-expr 'a >= (b != (c || (d && e)))' -a 1,2,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (c || (d && e)))'\'' -a 1,2,1,1,2'

echo '$ test-expr '\''a >= (b != (c || (d && e)))'\'' -a 1,2,2,0,2'
test-expr 'a >= (b != (c || (d && e)))' -a 1,2,2,0,2 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (c || (d && e)))'\'' -a 1,2,2,0,2'

echo '$ test-expr '\''a >= (b != (c || (d && e)))'\'' -a 1,2,2,1,0'
test-expr 'a >= (b != (c || (d && e)))' -a 1,2,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (c || (d && e)))'\'' -a 1,2,2,1,0'

echo '$ test-expr '\''a >= (b != (c || (d && e)))'\'' -a 1,2,2,1,2'
test-expr 'a >= (b != (c || (d && e)))' -a 1,2,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (c || (d && e)))'\'' -a 1,2,2,1,2'

echo '$ test-expr '\''a >= (b != (c || (d && e)))'\'' -a 1,2,2,2,1'
test-expr 'a >= (b != (c || (d && e)))' -a 1,2,2,2,1 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (c || (d && e)))'\'' -a 1,2,2,2,1'

echo '$ test-expr '\''a >= (b != (c || (d && e)))'\'' -a 2,0,1,2,0'
test-expr 'a >= (b != (c || (d && e)))' -a 2,0,1,2,0 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (c || (d && e)))'\'' -a 2,0,1,2,0'

echo '$ test-expr '\''a >= (b != (c || (d && e)))'\'' -a 2,1,1,0,1'
test-expr 'a >= (b != (c || (d && e)))' -a 2,1,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (c || (d && e)))'\'' -a 2,1,1,0,1'

echo '$ test-expr '\''a >= (b != (c || (d && e)))'\'' -a 2,2,0,0,1'
test-expr 'a >= (b != (c || (d && e)))' -a 2,2,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (c || (d && e)))'\'' -a 2,2,0,0,1'

echo '$ test-expr '\''a >= (b != (c || (d && e)))'\'' -a 2,2,0,0,2'
test-expr 'a >= (b != (c || (d && e)))' -a 2,2,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (c || (d && e)))'\'' -a 2,2,0,0,2'

echo '$ test-expr '\''a >= (b != (c || (d && e)))'\'' -a 2,2,1,1,2'
test-expr 'a >= (b != (c || (d && e)))' -a 2,2,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != (c || (d && e)))'\'' -a 2,2,1,1,2'

echo '$ test-expr '\''a >= (b != ((c && d) || e))'\'' -a 0,0,0,1,0'
test-expr 'a >= (b != ((c && d) || e))' -a 0,0,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != ((c && d) || e))'\'' -a 0,0,0,1,0'

echo '$ test-expr '\''a >= (b != ((c && d) || e))'\'' -a 0,0,1,0,2'
test-expr 'a >= (b != ((c && d) || e))' -a 0,0,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != ((c && d) || e))'\'' -a 0,0,1,0,2'

echo '$ test-expr '\''a >= (b != ((c && d) || e))'\'' -a 0,2,0,0,0'
test-expr 'a >= (b != ((c && d) || e))' -a 0,2,0,0,0 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != ((c && d) || e))'\'' -a 0,2,0,0,0'

echo '$ test-expr '\''a >= (b != ((c && d) || e))'\'' -a 0,2,1,0,0'
test-expr 'a >= (b != ((c && d) || e))' -a 0,2,1,0,0 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != ((c && d) || e))'\'' -a 0,2,1,0,0'

echo '$ test-expr '\''a >= (b != ((c && d) || e))'\'' -a 0,2,1,0,1'
test-expr 'a >= (b != ((c && d) || e))' -a 0,2,1,0,1 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != ((c && d) || e))'\'' -a 0,2,1,0,1'

echo '$ test-expr '\''a >= (b != ((c && d) || e))'\'' -a 0,2,1,2,0'
test-expr 'a >= (b != ((c && d) || e))' -a 0,2,1,2,0 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != ((c && d) || e))'\'' -a 0,2,1,2,0'

echo '$ test-expr '\''a >= (b != ((c && d) || e))'\'' -a 0,2,2,1,0'
test-expr 'a >= (b != ((c && d) || e))' -a 0,2,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != ((c && d) || e))'\'' -a 0,2,2,1,0'

echo '$ test-expr '\''a >= (b != ((c && d) || e))'\'' -a 1,0,2,0,0'
test-expr 'a >= (b != ((c && d) || e))' -a 1,0,2,0,0 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != ((c && d) || e))'\'' -a 1,0,2,0,0'

echo '$ test-expr '\''a >= (b != ((c && d) || e))'\'' -a 1,1,1,0,2'
test-expr 'a >= (b != ((c && d) || e))' -a 1,1,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != ((c && d) || e))'\'' -a 1,1,1,0,2'

echo '$ test-expr '\''a >= (b != ((c && d) || e))'\'' -a 1,1,2,0,0'
test-expr 'a >= (b != ((c && d) || e))' -a 1,1,2,0,0 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != ((c && d) || e))'\'' -a 1,1,2,0,0'

echo '$ test-expr '\''a >= (b != ((c && d) || e))'\'' -a 1,2,0,1,1'
test-expr 'a >= (b != ((c && d) || e))' -a 1,2,0,1,1 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != ((c && d) || e))'\'' -a 1,2,0,1,1'

echo '$ test-expr '\''a >= (b != ((c && d) || e))'\'' -a 1,2,1,1,2'
test-expr 'a >= (b != ((c && d) || e))' -a 1,2,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != ((c && d) || e))'\'' -a 1,2,1,1,2'

echo '$ test-expr '\''a >= (b != ((c && d) || e))'\'' -a 2,0,0,0,2'
test-expr 'a >= (b != ((c && d) || e))' -a 2,0,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != ((c && d) || e))'\'' -a 2,0,0,0,2'

echo '$ test-expr '\''a >= (b != ((c && d) || e))'\'' -a 2,0,0,2,2'
test-expr 'a >= (b != ((c && d) || e))' -a 2,0,0,2,2 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != ((c && d) || e))'\'' -a 2,0,0,2,2'

echo '$ test-expr '\''a >= (b != ((c && d) || e))'\'' -a 2,0,1,1,2'
test-expr 'a >= (b != ((c && d) || e))' -a 2,0,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != ((c && d) || e))'\'' -a 2,0,1,1,2'

echo '$ test-expr '\''a >= (b != ((c && d) || e))'\'' -a 2,0,1,2,0'
test-expr 'a >= (b != ((c && d) || e))' -a 2,0,1,2,0 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != ((c && d) || e))'\'' -a 2,0,1,2,0'

echo '$ test-expr '\''a >= (b != ((c && d) || e))'\'' -a 2,0,1,2,1'
test-expr 'a >= (b != ((c && d) || e))' -a 2,0,1,2,1 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != ((c && d) || e))'\'' -a 2,0,1,2,1'

echo '$ test-expr '\''a >= (b != ((c && d) || e))'\'' -a 2,0,2,1,0'
test-expr 'a >= (b != ((c && d) || e))' -a 2,0,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != ((c && d) || e))'\'' -a 2,0,2,1,0'

echo '$ test-expr '\''a >= (b != ((c && d) || e))'\'' -a 2,0,2,1,1'
test-expr 'a >= (b != ((c && d) || e))' -a 2,0,2,1,1 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != ((c && d) || e))'\'' -a 2,0,2,1,1'

echo '$ test-expr '\''a >= (b != ((c && d) || e))'\'' -a 2,1,0,2,0'
test-expr 'a >= (b != ((c && d) || e))' -a 2,1,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != ((c && d) || e))'\'' -a 2,1,0,2,0'

echo '$ test-expr '\''a >= (b != ((c && d) || e))'\'' -a 2,1,2,1,2'
test-expr 'a >= (b != ((c && d) || e))' -a 2,1,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != ((c && d) || e))'\'' -a 2,1,2,1,2'

echo '$ test-expr '\''a >= (b != ((c && d) || e))'\'' -a 2,1,2,2,0'
test-expr 'a >= (b != ((c && d) || e))' -a 2,1,2,2,0 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != ((c && d) || e))'\'' -a 2,1,2,2,0'

echo '$ test-expr '\''a >= (b != ((c && d) || e))'\'' -a 2,2,0,1,1'
test-expr 'a >= (b != ((c && d) || e))' -a 2,2,0,1,1 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != ((c && d) || e))'\'' -a 2,2,0,1,1'

echo '$ test-expr '\''a >= (b != ((c || d) && e))'\'' -a 0,0,0,0,1'
test-expr 'a >= (b != ((c || d) && e))' -a 0,0,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != ((c || d) && e))'\'' -a 0,0,0,0,1'

echo '$ test-expr '\''a >= (b != ((c || d) && e))'\'' -a 0,0,0,2,0'
test-expr 'a >= (b != ((c || d) && e))' -a 0,0,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != ((c || d) && e))'\'' -a 0,0,0,2,0'

echo '$ test-expr '\''a >= (b != ((c || d) && e))'\'' -a 0,0,0,2,1'
test-expr 'a >= (b != ((c || d) && e))' -a 0,0,0,2,1 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != ((c || d) && e))'\'' -a 0,0,0,2,1'

echo '$ test-expr '\''a >= (b != ((c || d) && e))'\'' -a 0,0,2,0,2'
test-expr 'a >= (b != ((c || d) && e))' -a 0,0,2,0,2 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != ((c || d) && e))'\'' -a 0,0,2,0,2'

echo '$ test-expr '\''a >= (b != ((c || d) && e))'\'' -a 0,0,2,2,0'
test-expr 'a >= (b != ((c || d) && e))' -a 0,0,2,2,0 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != ((c || d) && e))'\'' -a 0,0,2,2,0'

echo '$ test-expr '\''a >= (b != ((c || d) && e))'\'' -a 0,1,0,1,2'
test-expr 'a >= (b != ((c || d) && e))' -a 0,1,0,1,2 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != ((c || d) && e))'\'' -a 0,1,0,1,2'

echo '$ test-expr '\''a >= (b != ((c || d) && e))'\'' -a 0,1,2,0,2'
test-expr 'a >= (b != ((c || d) && e))' -a 0,1,2,0,2 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != ((c || d) && e))'\'' -a 0,1,2,0,2'

echo '$ test-expr '\''a >= (b != ((c || d) && e))'\'' -a 0,2,0,0,0'
test-expr 'a >= (b != ((c || d) && e))' -a 0,2,0,0,0 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != ((c || d) && e))'\'' -a 0,2,0,0,0'

echo '$ test-expr '\''a >= (b != ((c || d) && e))'\'' -a 0,2,0,1,0'
test-expr 'a >= (b != ((c || d) && e))' -a 0,2,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != ((c || d) && e))'\'' -a 0,2,0,1,0'

echo '$ test-expr '\''a >= (b != ((c || d) && e))'\'' -a 0,2,0,2,2'
test-expr 'a >= (b != ((c || d) && e))' -a 0,2,0,2,2 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != ((c || d) && e))'\'' -a 0,2,0,2,2'

echo '$ test-expr '\''a >= (b != ((c || d) && e))'\'' -a 1,0,1,2,0'
test-expr 'a >= (b != ((c || d) && e))' -a 1,0,1,2,0 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != ((c || d) && e))'\'' -a 1,0,1,2,0'

echo '$ test-expr '\''a >= (b != ((c || d) && e))'\'' -a 1,0,2,1,0'
test-expr 'a >= (b != ((c || d) && e))' -a 1,0,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != ((c || d) && e))'\'' -a 1,0,2,1,0'

echo '$ test-expr '\''a >= (b != ((c || d) && e))'\'' -a 1,0,2,1,2'
test-expr 'a >= (b != ((c || d) && e))' -a 1,0,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != ((c || d) && e))'\'' -a 1,0,2,1,2'

echo '$ test-expr '\''a >= (b != ((c || d) && e))'\'' -a 1,0,2,2,2'
test-expr 'a >= (b != ((c || d) && e))' -a 1,0,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != ((c || d) && e))'\'' -a 1,0,2,2,2'

echo '$ test-expr '\''a >= (b != ((c || d) && e))'\'' -a 1,1,2,2,2'
test-expr 'a >= (b != ((c || d) && e))' -a 1,1,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != ((c || d) && e))'\'' -a 1,1,2,2,2'

echo '$ test-expr '\''a >= (b != ((c || d) && e))'\'' -a 1,2,0,2,0'
test-expr 'a >= (b != ((c || d) && e))' -a 1,2,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != ((c || d) && e))'\'' -a 1,2,0,2,0'

echo '$ test-expr '\''a >= (b != ((c || d) && e))'\'' -a 1,2,1,0,2'
test-expr 'a >= (b != ((c || d) && e))' -a 1,2,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != ((c || d) && e))'\'' -a 1,2,1,0,2'

echo '$ test-expr '\''a >= (b != ((c || d) && e))'\'' -a 1,2,2,2,2'
test-expr 'a >= (b != ((c || d) && e))' -a 1,2,2,2,2 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != ((c || d) && e))'\'' -a 1,2,2,2,2'

echo '$ test-expr '\''a >= (b != ((c || d) && e))'\'' -a 2,0,0,0,0'
test-expr 'a >= (b != ((c || d) && e))' -a 2,0,0,0,0 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != ((c || d) && e))'\'' -a 2,0,0,0,0'

echo '$ test-expr '\''a >= (b != ((c || d) && e))'\'' -a 2,0,1,0,2'
test-expr 'a >= (b != ((c || d) && e))' -a 2,0,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != ((c || d) && e))'\'' -a 2,0,1,0,2'

echo '$ test-expr '\''a >= (b != ((c || d) && e))'\'' -a 2,0,1,2,2'
test-expr 'a >= (b != ((c || d) && e))' -a 2,0,1,2,2 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != ((c || d) && e))'\'' -a 2,0,1,2,2'

echo '$ test-expr '\''a >= (b != ((c || d) && e))'\'' -a 2,1,0,0,2'
test-expr 'a >= (b != ((c || d) && e))' -a 2,1,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != ((c || d) && e))'\'' -a 2,1,0,0,2'

echo '$ test-expr '\''a >= (b != ((c || d) && e))'\'' -a 2,1,0,2,0'
test-expr 'a >= (b != ((c || d) && e))' -a 2,1,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != ((c || d) && e))'\'' -a 2,1,0,2,0'

echo '$ test-expr '\''a >= (b != ((c || d) && e))'\'' -a 2,1,1,0,2'
test-expr 'a >= (b != ((c || d) && e))' -a 2,1,1,0,2 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != ((c || d) && e))'\'' -a 2,1,1,0,2'

echo '$ test-expr '\''a >= (b != ((c || d) && e))'\'' -a 2,1,1,1,0'
test-expr 'a >= (b != ((c || d) && e))' -a 2,1,1,1,0 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != ((c || d) && e))'\'' -a 2,1,1,1,0'

echo '$ test-expr '\''a >= (b != ((c || d) && e))'\'' -a 2,1,1,1,2'
test-expr 'a >= (b != ((c || d) && e))' -a 2,1,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != ((c || d) && e))'\'' -a 2,1,1,1,2'

echo '$ test-expr '\''a >= (b != ((c || d) && e))'\'' -a 2,1,1,2,0'
test-expr 'a >= (b != ((c || d) && e))' -a 2,1,1,2,0 2>&1 ||
echo 'command failed: test-expr '\''a >= (b != ((c || d) && e))'\'' -a 2,1,1,2,0'

echo '$ test-expr '\''a >= (b && (c != (d || e)))'\'' -a 0,0,0,2,1'
test-expr 'a >= (b && (c != (d || e)))' -a 0,0,0,2,1 2>&1 ||
echo 'command failed: test-expr '\''a >= (b && (c != (d || e)))'\'' -a 0,0,0,2,1'

echo '$ test-expr '\''a >= (b && (c != (d || e)))'\'' -a 0,0,1,1,1'
test-expr 'a >= (b && (c != (d || e)))' -a 0,0,1,1,1 2>&1 ||
echo 'command failed: test-expr '\''a >= (b && (c != (d || e)))'\'' -a 0,0,1,1,1'

echo '$ test-expr '\''a >= (b && (c != (d || e)))'\'' -a 0,2,0,0,2'
test-expr 'a >= (b && (c != (d || e)))' -a 0,2,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a >= (b && (c != (d || e)))'\'' -a 0,2,0,0,2'

echo '$ test-expr '\''a >= (b && (c != (d || e)))'\'' -a 0,2,0,1,0'
test-expr 'a >= (b && (c != (d || e)))' -a 0,2,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a >= (b && (c != (d || e)))'\'' -a 0,2,0,1,0'

echo '$ test-expr '\''a >= (b && (c != (d || e)))'\'' -a 0,2,0,2,0'
test-expr 'a >= (b && (c != (d || e)))' -a 0,2,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a >= (b && (c != (d || e)))'\'' -a 0,2,0,2,0'

echo '$ test-expr '\''a >= (b && (c != (d || e)))'\'' -a 0,2,1,1,2'
test-expr 'a >= (b && (c != (d || e)))' -a 0,2,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a >= (b && (c != (d || e)))'\'' -a 0,2,1,1,2'

echo '$ test-expr '\''a >= (b && (c != (d || e)))'\'' -a 0,2,1,2,2'
test-expr 'a >= (b && (c != (d || e)))' -a 0,2,1,2,2 2>&1 ||
echo 'command failed: test-expr '\''a >= (b && (c != (d || e)))'\'' -a 0,2,1,2,2'

echo '$ test-expr '\''a >= (b && (c != (d || e)))'\'' -a 0,2,2,0,0'
test-expr 'a >= (b && (c != (d || e)))' -a 0,2,2,0,0 2>&1 ||
echo 'command failed: test-expr '\''a >= (b && (c != (d || e)))'\'' -a 0,2,2,0,0'

echo '$ test-expr '\''a >= (b && (c != (d || e)))'\'' -a 0,2,2,1,0'
test-expr 'a >= (b && (c != (d || e)))' -a 0,2,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a >= (b && (c != (d || e)))'\'' -a 0,2,2,1,0'

echo '$ test-expr '\''a >= (b && (c != (d || e)))'\'' -a 1,1,0,0,1'
test-expr 'a >= (b && (c != (d || e)))' -a 1,1,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a >= (b && (c != (d || e)))'\'' -a 1,1,0,0,1'

echo '$ test-expr '\''a >= (b && (c != (d || e)))'\'' -a 1,1,0,2,0'
test-expr 'a >= (b && (c != (d || e)))' -a 1,1,0,2,0 2>&1 ||
echo 'command failed: test-expr '\''a >= (b && (c != (d || e)))'\'' -a 1,1,0,2,0'

echo '$ test-expr '\''a >= (b && (c != (d || e)))'\'' -a 1,1,1,1,2'
test-expr 'a >= (b && (c != (d || e)))' -a 1,1,1,1,2 2>&1 ||
echo 'command failed: test-expr '\''a >= (b && (c != (d || e)))'\'' -a 1,1,1,1,2'

echo '$ test-expr '\''a >= (b && (c != (d || e)))'\'' -a 1,1,2,1,0'
test-expr 'a >= (b && (c != (d || e)))' -a 1,1,2,1,0 2>&1 ||
echo 'command failed: test-expr '\''a >= (b && (c != (d || e)))'\'' -a 1,1,2,1,0'

echo '$ test-expr '\''a >= (b && (c != (d || e)))'\'' -a 1,2,0,0,1'
test-expr 'a >= (b && (c != (d || e)))' -a 1,2,0,0,1 2>&1 ||
echo 'command failed: test-expr '\''a >= (b && (c != (d || e)))'\'' -a 1,2,0,0,1'

echo '$ test-expr '\''a >= (b && (c != (d || e)))'\'' -a 1,2,0,0,2'
test-expr 'a >= (b && (c != (d || e)))' -a 1,2,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a >= (b && (c != (d || e)))'\'' -a 1,2,0,0,2'

echo '$ test-expr '\''a >= (b && (c != (d || e)))'\'' -a 1,2,1,1,0'
test-expr 'a >= (b && (c != (d || e)))' -a 1,2,1,1,0 2>&1 ||
echo 'command failed: test-expr '\''a >= (b && (c != (d || e)))'\'' -a 1,2,1,1,0'

echo '$ test-expr '\''a >= (b && (c != (d || e)))'\'' -a 1,2,2,1,2'
test-expr 'a >= (b && (c != (d || e)))' -a 1,2,2,1,2 2>&1 ||
echo 'command failed: test-expr '\''a >= (b && (c != (d || e)))'\'' -a 1,2,2,1,2'

echo '$ test-expr '\''a >= (b && (c != (d || e)))'\'' -a 2,0,0,2,2'
test-expr 'a >= (b && (c != (d || e)))' -a 2,0,0,2,2 2>&1 ||
echo 'command failed: test-expr '\''a >= (b && (c != (d || e)))'\'' -a 2,0,0,2,2'

echo '$ test-expr '\''a >= (b && (c != (d || e)))'\'' -a 2,0,2,0,0'
test-expr 'a >= (b && (c != (d || e)))' -a 2,0,2,0,0 2>&1 ||
echo 'command failed: test-expr '\''a >= (b && (c != (d || e)))'\'' -a 2,0,2,0,0'

echo '$ test-expr '\''a >= (b && (c != (d || e)))'\'' -a 2,1,0,0,2'
test-expr 'a >= (b && (c != (d || e)))' -a 2,1,0,0,2 2>&1 ||
echo 'command failed: test-expr '\''a >= (b && (c != (d || e)))'\'' -a 2,1,0,0,2'

echo '$ test-expr '\''a >= (b && (c != (d || e)))'\'' -a 2,1,0,1,0'
test-expr 'a >= (b && (c != (d || e)))' -a 2,1,0,1,0 2>&1 ||
echo 'command failed: test-expr '\''a >= (b && (c != (d || e)))'\'' -a 2,1,0,1,0'

echo '$ test-expr '\''a >= (b && (c != (d || e)))'\'' -a 2,1,0,2,1'
test-expr 'a >= (b && (c != (d || e)))' -a 2,1,0,2,1 2>&1 ||
echo 'command failed: t